import{s as Le,n as ze,o as He}from"../chunks/scheduler.182ea377.js";import{S as Ie,i as Re,g as a,s as o,r as u,A as Ve,h as i,f as s,c as n,j as ue,u as m,x as f,k as Pe,y as c,a as l,v as h,d as y,t as g,w as b}from"../chunks/index.abf12888.js";import{C as X}from"../chunks/CodeBlock.57fe6e13.js";import{D as Ne}from"../chunks/DocNotebookDropdown.d9060979.js";import{H as Me}from"../chunks/Heading.16916d63.js";function Se(Te){let w,Q,Y,q,M,E,T,D,v,ve='<a href="https://github.com/huggingface/safetensors" rel="nofollow">safetensors</a> is a safe and fast file format for storing and loading tensors. Typically, PyTorch model weights are saved or <em>pickled</em> into a <code>.bin</code> file with Python’s <a href="https://docs.python.org/3/library/pickle.html" rel="nofollow"><code>pickle</code></a> utility. However, <code>pickle</code> is not secure and pickled files may contain malicious code that can be executed. safetensors is a secure alternative to <code>pickle</code>, making it ideal for sharing model weights.',A,$,$e="This guide will show you how you load <code>.safetensor</code> files, and how to convert Stable Diffusion model weights stored in other formats to <code>.safetensor</code>. Before you start, make sure you have safetensors installed:",O,Z,K,U,Ze='If you look at the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5/tree/main" rel="nofollow"><code>runwayml/stable-diffusion-v1-5</code></a> repository, you’ll see weights inside the <code>text_encoder</code>, <code>unet</code> and <code>vae</code> subfolders are stored in the <code>.safetensors</code> format. By default, 🤗 Diffusers automatically loads these <code>.safetensors</code> files from their subfolders if they’re available in the model repository.',ee,k,Ue="For more explicit control, you can optionally set <code>use_safetensors=True</code> (if <code>safetensors</code> is not installed, you’ll get an error message asking you to install it):",te,_,se,G,ke='However, model weights are not necessarily stored in separate subfolders like in the example above. Sometimes, all the weights are stored in a single <code>.safetensors</code> file. In this case, if the weights are Stable Diffusion weights, you can load the file directly with the <a href="/docs/diffusers/v0.22.2/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline.from_single_file">from_single_file()</a> method:',le,J,oe,B,ne,j,_e='Not all weights on the Hub are available in the <code>.safetensors</code> format, and you may encounter weights stored as <code>.bin</code>. In this case, use the <a href="https://huggingface.co/spaces/diffusers/convert" rel="nofollow">Convert Space</a> to convert the weights to <code>.safetensors</code>. The Convert Space downloads the pickled weights, converts them, and opens a Pull Request to upload the newly converted <code>.safetensors</code> file on the Hub. This way, if there is any malicious code contained in the pickled files, they’re uploaded to the Hub - which has a <a href="https://huggingface.co/docs/hub/security-pickle#hubs-security-scanner" rel="nofollow">security scanner</a> to detect unsafe files and suspicious pickle imports - instead of your computer.',ae,W,Ge='You can use the model with the new <code>.safetensors</code> weights by specifying the reference to the Pull Request in the <code>revision</code> parameter (you can also test it in this <a href="https://huggingface.co/spaces/diffusers/check_pr" rel="nofollow">Check PR</a> Space on the Hub), for example <code>refs/pr/22</code>:',ie,x,re,C,fe,P,Je="There are several reasons for using safetensors:",ce,p,H,Be="<p>Safety is the number one reason for using safetensors. As open-source and model distribution grows, it is important to be able to trust the model weights you downloaded don’t contain any malicious code. The current size of the header in safetensors prevents parsing extremely large JSON files.</p>",me,r,I,je="Loading speed between switching models is another reason to use safetensors, which performs zero-copy of the tensors. It is especially fast compared to <code>pickle</code> if you’re loading the weights to CPU (the default case), and just as fast if not faster when directly loading the weights to GPU. You’ll only notice the performance difference if the model is already loaded, and not if you’re downloading the weights or loading the model for the first time.",he,R,We="The time it takes to load the entire pipeline:",ye,L,ge,V,xe="But the actual time it takes to load 500MB of the model weights is only:",be,z,we,N,Ce='<p>Lazy loading is also supported in safetensors, which is useful in distributed settings to only load some of the tensors. This format allowed the <a href="https://huggingface.co/bigscience/bloom" rel="nofollow">BLOOM</a> model to be loaded in 45 seconds on 8 GPUs instead of 10 minutes with regular PyTorch weights.</p>',pe,F,de;return M=new Me({props:{title:"Load safetensors",local:"load-safetensors",headingTag:"h1"}}),T=new Ne({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/using_safetensors.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/using_safetensors.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/using_safetensors.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/using_safetensors.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/using_safetensors.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/using_safetensors.ipynb"}]}}),Z=new X({props:{code:"JTIzJTIwdW5jb21tZW50JTIwdG8lMjBpbnN0YWxsJTIwdGhlJTIwbmVjZXNzYXJ5JTIwbGlicmFyaWVzJTIwaW4lMjBDb2xhYiUwQSUyMyFwaXAlMjBpbnN0YWxsJTIwc2FmZXRlbnNvcnM=",highlighted:`<span class="hljs-comment"># uncomment to install the necessary libraries in Colab</span>
<span class="hljs-comment">#!pip install safetensors</span>`,wrap:!1}}),_=new X({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),J=new X({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3NpbmdsZV9maWxlKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZXYXJyaW9yTWFtYTc3NyUyRk9yYW5nZU1peHMlMkZibG9iJTJGbWFpbiUyRk1vZGVscyUyRkFieXNzT3JhbmdlTWl4JTJGQWJ5c3NPcmFuZ2VNaXguc2FmZXRlbnNvcnMlMjIlMEEp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

pipeline = StableDiffusionPipeline.from_single_file(
    <span class="hljs-string">&quot;https://huggingface.co/WarriorMama777/OrangeMixs/blob/main/Models/AbyssOrangeMix/AbyssOrangeMix.safetensors&quot;</span>
)`,wrap:!1}}),B=new Me({props:{title:"Convert to safetensors",local:"convert-to-safetensors",headingTag:"h2"}}),x=new X({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUyMHJldmlzaW9uJTNEJTIycmVmcyUyRnByJTJGMjIlMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, revision=<span class="hljs-string">&quot;refs/pr/22&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)`,wrap:!1}}),C=new Me({props:{title:"Why use safetensors?",local:"why-use-safetensors",headingTag:"h2"}}),L=new X({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpJTBBJTIyTG9hZGVkJTIwaW4lMjBzYWZldGVuc29ycyUyMDAlM0EwMCUzQTAyLjAzMzY1OCUyMiUwQSUyMkxvYWRlZCUyMGluJTIwUHlUb3JjaCUyMDAlM0EwMCUzQTAyLjY2MzM3OSUyMg==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

pipeline = StableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)
<span class="hljs-string">&quot;Loaded in safetensors 0:00:02.033658&quot;</span>
<span class="hljs-string">&quot;Loaded in PyTorch 0:00:02.663379&quot;</span>`,wrap:!1}}),z=new X({props:{code:"c2FmZXRlbnNvcnMlM0ElMjAzLjQ4NzNtcyUwQVB5VG9yY2glM0ElMjAxNzIuNzUzN21z",highlighted:`safetensors: 3.4873ms
PyTorch: 172.7537ms`,wrap:!1}}),{c(){w=a("meta"),Q=o(),Y=a("p"),q=o(),u(M.$$.fragment),E=o(),u(T.$$.fragment),D=o(),v=a("p"),v.innerHTML=ve,A=o(),$=a("p"),$.innerHTML=$e,O=o(),u(Z.$$.fragment),K=o(),U=a("p"),U.innerHTML=Ze,ee=o(),k=a("p"),k.innerHTML=Ue,te=o(),u(_.$$.fragment),se=o(),G=a("p"),G.innerHTML=ke,le=o(),u(J.$$.fragment),oe=o(),u(B.$$.fragment),ne=o(),j=a("p"),j.innerHTML=_e,ae=o(),W=a("p"),W.innerHTML=Ge,ie=o(),u(x.$$.fragment),re=o(),u(C.$$.fragment),fe=o(),P=a("p"),P.textContent=Je,ce=o(),p=a("ul"),H=a("li"),H.innerHTML=Be,me=o(),r=a("li"),I=a("p"),I.innerHTML=je,he=o(),R=a("p"),R.textContent=We,ye=o(),u(L.$$.fragment),ge=o(),V=a("p"),V.textContent=xe,be=o(),u(z.$$.fragment),we=o(),N=a("li"),N.innerHTML=Ce,pe=o(),F=a("p"),this.h()},l(e){const t=Ve("svelte-u9bgzb",document.head);w=i(t,"META",{name:!0,content:!0}),t.forEach(s),Q=n(e),Y=i(e,"P",{}),ue(Y).forEach(s),q=n(e),m(M.$$.fragment,e),E=n(e),m(T.$$.fragment,e),D=n(e),v=i(e,"P",{"data-svelte-h":!0}),f(v)!=="svelte-ejaj9i"&&(v.innerHTML=ve),A=n(e),$=i(e,"P",{"data-svelte-h":!0}),f($)!=="svelte-19452ph"&&($.innerHTML=$e),O=n(e),m(Z.$$.fragment,e),K=n(e),U=i(e,"P",{"data-svelte-h":!0}),f(U)!=="svelte-1sm59ne"&&(U.innerHTML=Ze),ee=n(e),k=i(e,"P",{"data-svelte-h":!0}),f(k)!=="svelte-1qgf6oc"&&(k.innerHTML=Ue),te=n(e),m(_.$$.fragment,e),se=n(e),G=i(e,"P",{"data-svelte-h":!0}),f(G)!=="svelte-l75bzl"&&(G.innerHTML=ke),le=n(e),m(J.$$.fragment,e),oe=n(e),m(B.$$.fragment,e),ne=n(e),j=i(e,"P",{"data-svelte-h":!0}),f(j)!=="svelte-i3hl9t"&&(j.innerHTML=_e),ae=n(e),W=i(e,"P",{"data-svelte-h":!0}),f(W)!=="svelte-uqf6y9"&&(W.innerHTML=Ge),ie=n(e),m(x.$$.fragment,e),re=n(e),m(C.$$.fragment,e),fe=n(e),P=i(e,"P",{"data-svelte-h":!0}),f(P)!=="svelte-kqqg29"&&(P.textContent=Je),ce=n(e),p=i(e,"UL",{});var S=ue(p);H=i(S,"LI",{"data-svelte-h":!0}),f(H)!=="svelte-1ci1eo5"&&(H.innerHTML=Be),me=n(S),r=i(S,"LI",{});var d=ue(r);I=i(d,"P",{"data-svelte-h":!0}),f(I)!=="svelte-x9zzp2"&&(I.innerHTML=je),he=n(d),R=i(d,"P",{"data-svelte-h":!0}),f(R)!=="svelte-gqu57m"&&(R.textContent=We),ye=n(d),m(L.$$.fragment,d),ge=n(d),V=i(d,"P",{"data-svelte-h":!0}),f(V)!=="svelte-15nsa67"&&(V.textContent=xe),be=n(d),m(z.$$.fragment,d),d.forEach(s),we=n(S),N=i(S,"LI",{"data-svelte-h":!0}),f(N)!=="svelte-bvwr8d"&&(N.innerHTML=Ce),S.forEach(s),pe=n(e),F=i(e,"P",{}),ue(F).forEach(s),this.h()},h(){Pe(w,"name","hf:doc:metadata"),Pe(w,"content",Xe)},m(e,t){c(document.head,w),l(e,Q,t),l(e,Y,t),l(e,q,t),h(M,e,t),l(e,E,t),h(T,e,t),l(e,D,t),l(e,v,t),l(e,A,t),l(e,$,t),l(e,O,t),h(Z,e,t),l(e,K,t),l(e,U,t),l(e,ee,t),l(e,k,t),l(e,te,t),h(_,e,t),l(e,se,t),l(e,G,t),l(e,le,t),h(J,e,t),l(e,oe,t),h(B,e,t),l(e,ne,t),l(e,j,t),l(e,ae,t),l(e,W,t),l(e,ie,t),h(x,e,t),l(e,re,t),h(C,e,t),l(e,fe,t),l(e,P,t),l(e,ce,t),l(e,p,t),c(p,H),c(p,me),c(p,r),c(r,I),c(r,he),c(r,R),c(r,ye),h(L,r,null),c(r,ge),c(r,V),c(r,be),h(z,r,null),c(p,we),c(p,N),l(e,pe,t),l(e,F,t),de=!0},p:ze,i(e){de||(y(M.$$.fragment,e),y(T.$$.fragment,e),y(Z.$$.fragment,e),y(_.$$.fragment,e),y(J.$$.fragment,e),y(B.$$.fragment,e),y(x.$$.fragment,e),y(C.$$.fragment,e),y(L.$$.fragment,e),y(z.$$.fragment,e),de=!0)},o(e){g(M.$$.fragment,e),g(T.$$.fragment,e),g(Z.$$.fragment,e),g(_.$$.fragment,e),g(J.$$.fragment,e),g(B.$$.fragment,e),g(x.$$.fragment,e),g(C.$$.fragment,e),g(L.$$.fragment,e),g(z.$$.fragment,e),de=!1},d(e){e&&(s(Q),s(Y),s(q),s(E),s(D),s(v),s(A),s($),s(O),s(K),s(U),s(ee),s(k),s(te),s(se),s(G),s(le),s(oe),s(ne),s(j),s(ae),s(W),s(ie),s(re),s(fe),s(P),s(ce),s(p),s(pe),s(F)),s(w),b(M,e),b(T,e),b(Z,e),b(_,e),b(J,e),b(B,e),b(x,e),b(C,e),b(L),b(z)}}}const Xe='{"title":"Load safetensors","local":"load-safetensors","sections":[{"title":"Convert to safetensors","local":"convert-to-safetensors","sections":[],"depth":2},{"title":"Why use safetensors?","local":"why-use-safetensors","sections":[],"depth":2}],"depth":1}';function Ye(Te){return He(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ae extends Ie{constructor(w){super(),Re(this,w,Ye,Se,Le,{})}}export{Ae as component};
