import{s as Pt,o as Ut,n as $t}from"../chunks/scheduler.25b97de1.js";import{S as Jt,i as St,g as a,s as r,r as p,A as jt,h as i,f as o,c as s,j as k,u,x as d,k as W,y as c,a as n,v as f,d as h,t as g,w as y}from"../chunks/index.d9030fc9.js";import{T as It}from"../chunks/Tip.baa67368.js";import{D as ye}from"../chunks/Docstring.ffac8efa.js";import{C as Fe}from"../chunks/CodeBlock.e6cd0d95.js";import{E as zt}from"../chunks/ExampleCodeBlock.22dfe688.js";import{H as _e,E as xt}from"../chunks/EditOnGithub.91d95064.js";function kt(ie){let l,U="Example:",_,b,T;return b=new Fe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFN1cGVyUG9pbnRDb25maWclMkMlMjBTdXBlclBvaW50Rm9yS2V5cG9pbnREZXRlY3Rpb24lMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwU3VwZXJQb2ludCUyMHN1cGVycG9pbnQlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwU3VwZXJQb2ludENvbmZpZygpJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwZnJvbSUyMHRoZSUyMHN1cGVycG9pbnQlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMFN1cGVyUG9pbnRGb3JLZXlwb2ludERldGVjdGlvbihjb25maWd1cmF0aW9uKSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SuperPointConfig, SuperPointForKeypointDetection

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a SuperPoint superpoint style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = SuperPointConfig()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the superpoint style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SuperPointForKeypointDetection(configuration)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){l=a("p"),l.textContent=U,_=r(),p(b.$$.fragment)},l(m){l=i(m,"P",{"data-svelte-h":!0}),d(l)!=="svelte-11lpom8"&&(l.textContent=U),_=s(m),u(b.$$.fragment,m)},m(m,C){n(m,l,C),n(m,_,C),f(b,m,C),T=!0},p:$t,i(m){T||(h(b.$$.fragment,m),T=!0)},o(m){g(b.$$.fragment,m),T=!1},d(m){m&&(o(l),o(_)),y(b,m)}}}function Wt(ie){let l,U=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){l=a("p"),l.innerHTML=U},l(_){l=i(_,"P",{"data-svelte-h":!0}),d(l)!=="svelte-fincs2"&&(l.innerHTML=U)},m(_,b){n(_,l,b)},p:$t,d(_){_&&o(l)}}}function Zt(ie){let l,U,_,b,T,m,C,Me,Z,at=`The SuperPoint model was proposed
in <a href="https://arxiv.org/abs/1712.07629" rel="nofollow">SuperPoint: Self-Supervised Interest Point Detection and Description</a> by Daniel
DeTone, Tomasz Malisiewicz and Andrew Rabinovich.`,we,V,it=`This model is the result of a self-supervised training of a fully-convolutional network for interest point detection and
description. The model is able to detect interest points that are repeatable under homographic transformations and
provide a descriptor for each point. The use of the model in its own is limited, but it can be used as a feature
extractor for other tasks such as homography estimation, image matching, etc.`,ve,R,lt="The abstract from the paper is the following:",Te,G,ct=`<em>This paper presents a self-supervised framework for training interest point detectors and descriptors suitable for a
large number of multiple-view geometry problems in computer vision. As opposed to patch-based neural networks, our
fully-convolutional model operates on full-sized images and jointly computes pixel-level interest point locations and
associated descriptors in one forward pass. We introduce Homographic Adaptation, a multi-scale, multi-homography
approach for boosting interest point detection repeatability and performing cross-domain adaptation (e.g.,
synthetic-to-real). Our model, when trained on the MS-COCO generic image dataset using Homographic Adaptation, is able
to repeatedly detect a much richer set of interest points than the initial pre-adapted deep model and any other
traditional corner detector. The final system gives rise to state-of-the-art homography estimation results on HPatches
when compared to LIFT, SIFT and ORB.</em>`,Ce,N,$e,D,dt="Here is a quick example of using the model to detect interest points in an image:",Pe,B,Ue,H,mt="The outputs contain the list of keypoint coordinates with their respective score and description (a 256-long vector).",Je,q,pt=`You can also feed multiple images to the model. Due to the nature of SuperPoint, to output a dynamic number of keypoints,
you will need to use the mask attribute to retrieve the respective information :`,Se,E,je,F,ut="You can then print the keypoints on the image to visualize the result :",Ie,X,ze,Y,ft=`This model was contributed by <a href="https://huggingface.co/stevenbucaille" rel="nofollow">stevenbucaille</a>.
The original code can be found <a href="https://github.com/magicleap/SuperPointPretrainedNetwork" rel="nofollow">here</a>.`,xe,L,ke,M,A,Xe,le,ht=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/superpoint#transformers.SuperPointForKeypointDetection">SuperPointForKeypointDetection</a>. It is used to instantiate a
SuperPoint model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the SuperPoint
<a href="https://huggingface.co/magic-leap-community/superpoint" rel="nofollow">magic-leap-community/superpoint</a> architecture.`,Ye,ce,gt=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Le,S,We,Q,Ze,w,K,Ae,de,yt="Constructs a SuperPoint image processor.",Qe,j,O,Ke,me,_t="Preprocess an image or batch of images.",Oe,I,ee,et,pe,bt="Resize an image.",Ve,te,Mt="<li>preprocess</li>",Re,oe,Ge,v,ne,tt,ue,wt=`SuperPoint model outputting keypoints and descriptors.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,ot,fe,vt=`SuperPoint model. It consists of a SuperPointEncoder, a SuperPointInterestPointDecoder and a
SuperPointDescriptorDecoder. SuperPoint was proposed in <code>SuperPoint: Self-Supervised Interest Point Detection and Description &lt;https://arxiv.org/abs/1712.07629&gt;</code>__ by Daniel DeTone, Tomasz Malisiewicz, and Andrew Rabinovich. It
is a fully convolutional neural network that extracts keypoints and descriptors from an image. It is trained in a
self-supervised manner, using a combination of a photometric loss and a loss based on the homographic adaptation of
keypoints. It is made of a convolutional encoder and two decoders: one for keypoints and one for descriptors.`,nt,J,re,rt,he,Tt='The <a href="/docs/transformers/main/en/model_doc/superpoint#transformers.SuperPointForKeypointDetection">SuperPointForKeypointDetection</a> forward method, overrides the <code>__call__</code> special method.',st,z,Ne,se,Ct="<li>forward</li>",De,ae,Be,be,He;return T=new _e({props:{title:"SuperPoint",local:"superpoint",headingTag:"h1"}}),C=new _e({props:{title:"Overview",local:"overview",headingTag:"h2"}}),N=new _e({props:{title:"How to use",local:"how-to-use",headingTag:"h2"}}),B=new Fe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Nb2RlbCUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJtYWdpYy1sZWFwLWNvbW11bml0eSUyRnN1cGVycG9pbnQlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMm1hZ2ljLWxlYXAtY29tbXVuaXR5JTJGc3VwZXJwb2ludCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoModel
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;magic-leap-community/superpoint&quot;</span>)
model = AutoModel.from_pretrained(<span class="hljs-string">&quot;magic-leap-community/superpoint&quot;</span>)

inputs = processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
outputs = model(**inputs)`,wrap:!1}}),E=new Fe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Nb2RlbCUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmxfaW1hZ2VfMSUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZV8xJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsX2ltYWdlXzElMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBdXJsX2ltYWdlXzIlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnRlc3Qtc3R1ZmYyMDE3JTJGMDAwMDAwMDAwNTY4LmpwZyUyMiUwQWltYWdlXzIlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmxfaW1hZ2VfMiUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFpbWFnZXMlMjAlM0QlMjAlNUJpbWFnZV8xJTJDJTIwaW1hZ2VfMiU1RCUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIybWFnaWMtbGVhcC1jb21tdW5pdHklMkZzdXBlcnBvaW50JTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJtYWdpYy1sZWFwLWNvbW11bml0eSUyRnN1cGVycG9pbnQlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlcyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQWZvciUyMGklMjBpbiUyMHJhbmdlKGxlbihpbWFnZXMpKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlX21hc2slMjAlM0QlMjBvdXRwdXRzLm1hc2slNUJpJTVEJTBBJTIwJTIwJTIwJTIwaW1hZ2VfaW5kaWNlcyUyMCUzRCUyMHRvcmNoLm5vbnplcm8oaW1hZ2VfbWFzaykuc3F1ZWV6ZSgpJTBBJTIwJTIwJTIwJTIwaW1hZ2Vfa2V5cG9pbnRzJTIwJTNEJTIwb3V0cHV0cy5rZXlwb2ludHMlNUJpJTVEJTVCaW1hZ2VfaW5kaWNlcyU1RCUwQSUyMCUyMCUyMCUyMGltYWdlX3Njb3JlcyUyMCUzRCUyMG91dHB1dHMuc2NvcmVzJTVCaSU1RCU1QmltYWdlX2luZGljZXMlNUQlMEElMjAlMjAlMjAlMjBpbWFnZV9kZXNjcmlwdG9ycyUyMCUzRCUyMG91dHB1dHMuZGVzY3JpcHRvcnMlNUJpJTVEJTVCaW1hZ2VfaW5kaWNlcyU1RA==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoModel
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

url_image_1 = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
image_1 = Image.<span class="hljs-built_in">open</span>(requests.get(url_image_1, stream=<span class="hljs-literal">True</span>).raw)
url_image_2 = <span class="hljs-string">&quot;http://images.cocodataset.org/test-stuff2017/000000000568.jpg&quot;</span>
image_2 = Image.<span class="hljs-built_in">open</span>(requests.get(url_image_2, stream=<span class="hljs-literal">True</span>).raw)

images = [image_1, image_2]

processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;magic-leap-community/superpoint&quot;</span>)
model = AutoModel.from_pretrained(<span class="hljs-string">&quot;magic-leap-community/superpoint&quot;</span>)

inputs = processor(images, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
outputs = model(**inputs)

<span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(images)):
    image_mask = outputs.mask[i]
    image_indices = torch.nonzero(image_mask).squeeze()
    image_keypoints = outputs.keypoints[i][image_indices]
    image_scores = outputs.scores[i][image_indices]
    image_descriptors = outputs.descriptors[i][image_indices]`,wrap:!1}}),X=new Fe({props:{code:"aW1wb3J0JTIwY3YyJTBBZm9yJTIwa2V5cG9pbnQlMkMlMjBzY29yZSUyMGluJTIwemlwKGltYWdlX2tleXBvaW50cyUyQyUyMGltYWdlX3Njb3JlcyklM0ElMEElMjAlMjAlMjAlMjBrZXlwb2ludF94JTJDJTIwa2V5cG9pbnRfeSUyMCUzRCUyMGludChrZXlwb2ludCU1QjAlNUQuaXRlbSgpKSUyQyUyMGludChrZXlwb2ludCU1QjElNUQuaXRlbSgpKSUwQSUyMCUyMCUyMCUyMGNvbG9yJTIwJTNEJTIwdHVwbGUoJTVCc2NvcmUuaXRlbSgpJTIwKiUyMDI1NSU1RCUyMColMjAzKSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwY3YyLmNpcmNsZShpbWFnZSUyQyUyMChrZXlwb2ludF94JTJDJTIwa2V5cG9pbnRfeSklMkMlMjAyJTJDJTIwY29sb3IpJTBBY3YyLmltd3JpdGUoJTIyb3V0cHV0X2ltYWdlLnBuZyUyMiUyQyUyMGltYWdlKQ==",highlighted:`<span class="hljs-keyword">import</span> cv2
<span class="hljs-keyword">for</span> keypoint, score <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(image_keypoints, image_scores):
    keypoint_x, keypoint_y = <span class="hljs-built_in">int</span>(keypoint[<span class="hljs-number">0</span>].item()), <span class="hljs-built_in">int</span>(keypoint[<span class="hljs-number">1</span>].item())
    color = <span class="hljs-built_in">tuple</span>([score.item() * <span class="hljs-number">255</span>] * <span class="hljs-number">3</span>)
    image = cv2.circle(image, (keypoint_x, keypoint_y), <span class="hljs-number">2</span>, color)
cv2.imwrite(<span class="hljs-string">&quot;output_image.png&quot;</span>, image)`,wrap:!1}}),L=new _e({props:{title:"SuperPointConfig",local:"transformers.SuperPointConfig",headingTag:"h2"}}),A=new ye({props:{name:"class transformers.SuperPointConfig",anchor:"transformers.SuperPointConfig",parameters:[{name:"encoder_hidden_sizes",val:": List = [64, 64, 128, 128]"},{name:"decoder_hidden_size",val:": int = 256"},{name:"keypoint_decoder_dim",val:": int = 65"},{name:"descriptor_decoder_dim",val:": int = 256"},{name:"keypoint_threshold",val:": float = 0.005"},{name:"max_keypoints",val:": int = -1"},{name:"nms_radius",val:": int = 4"},{name:"border_removal_distance",val:": int = 4"},{name:"initializer_range",val:" = 0.02"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SuperPointConfig.encoder_hidden_sizes",description:`<strong>encoder_hidden_sizes</strong> (<code>List</code>, <em>optional</em>, defaults to <code>[64, 64, 128, 128]</code>) &#x2014;
The number of channels in each convolutional layer in the encoder.`,name:"encoder_hidden_sizes"},{anchor:"transformers.SuperPointConfig.decoder_hidden_size",description:"<strong>decoder_hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014; The hidden size of the decoder.",name:"decoder_hidden_size"},{anchor:"transformers.SuperPointConfig.keypoint_decoder_dim",description:"<strong>keypoint_decoder_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 65) &#x2014; The output dimension of the keypoint decoder.",name:"keypoint_decoder_dim"},{anchor:"transformers.SuperPointConfig.descriptor_decoder_dim",description:"<strong>descriptor_decoder_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014; The output dimension of the descriptor decoder.",name:"descriptor_decoder_dim"},{anchor:"transformers.SuperPointConfig.keypoint_threshold",description:`<strong>keypoint_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.005) &#x2014;
The threshold to use for extracting keypoints.`,name:"keypoint_threshold"},{anchor:"transformers.SuperPointConfig.max_keypoints",description:`<strong>max_keypoints</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
The maximum number of keypoints to extract. If <code>-1</code>, will extract all keypoints.`,name:"max_keypoints"},{anchor:"transformers.SuperPointConfig.nms_radius",description:`<strong>nms_radius</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The radius for non-maximum suppression.`,name:"nms_radius"},{anchor:"transformers.SuperPointConfig.border_removal_distance",description:`<strong>border_removal_distance</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The distance from the border to remove keypoints.`,name:"border_removal_distance"},{anchor:"transformers.SuperPointConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/superpoint/configuration_superpoint.py#L23"}}),S=new zt({props:{anchor:"transformers.SuperPointConfig.example",$$slots:{default:[kt]},$$scope:{ctx:ie}}}),Q=new _e({props:{title:"SuperPointImageProcessor",local:"transformers.SuperPointImageProcessor",headingTag:"h2"}}),K=new ye({props:{name:"class transformers.SuperPointImageProcessor",anchor:"transformers.SuperPointImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": Dict = None"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": float = 0.00392156862745098"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SuperPointImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overriden
by <code>do_resize</code> in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.SuperPointImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;height&quot; -- 480, &quot;width&quot;: 640}</code>):
Resolution of the output image after <code>resize</code> is applied. Only has an effect if <code>do_resize</code> is set to
<code>True</code>. Can be overriden by <code>size</code> in the <code>preprocess</code> method.`,name:"size"},{anchor:"transformers.SuperPointImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overriden by <code>do_rescale</code> in
the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.SuperPointImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overriden by <code>rescale_factor</code> in the <code>preprocess</code>
method.`,name:"rescale_factor"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/superpoint/image_processing_superpoint.py#L87"}}),O=new ye({props:{name:"preprocess",anchor:"transformers.SuperPointImageProcessor.preprocess",parameters:[{name:"images",val:""},{name:"do_resize",val:": bool = None"},{name:"size",val:": Dict = None"},{name:"do_rescale",val:": bool = None"},{name:"rescale_factor",val:": float = None"},{name:"return_tensors",val:": Union = None"},{name:"data_format",val:": ChannelDimension = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": Union = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SuperPointImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.SuperPointImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.SuperPointImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the output image after <code>resize</code> has been applied. If <code>size[&quot;shortest_edge&quot;]</code> &gt;= 384, the image
is resized to <code>(size[&quot;shortest_edge&quot;], size[&quot;shortest_edge&quot;])</code>. Otherwise, the smaller edge of the
image will be matched to <code>int(size[&quot;shortest_edge&quot;]/ crop_pct)</code>, after which the image is cropped to
<code>(size[&quot;shortest_edge&quot;], size[&quot;shortest_edge&quot;])</code>. Only has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"size"},{anchor:"transformers.SuperPointImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image values between [0 - 1].`,name:"do_rescale"},{anchor:"transformers.SuperPointImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.SuperPointImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.SuperPointImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.SuperPointImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/superpoint/image_processing_superpoint.py#L164"}}),ee=new ye({props:{name:"resize",anchor:"transformers.SuperPointImageProcessor.resize",parameters:[{name:"image",val:": ndarray"},{name:"size",val:": Dict"},{name:"data_format",val:": Union = None"},{name:"input_data_format",val:": Union = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SuperPointImageProcessor.resize.image",description:`<strong>image</strong> (<code>np.ndarray</code>) &#x2014;
Image to resize.`,name:"image"},{anchor:"transformers.SuperPointImageProcessor.resize.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>) &#x2014;
Dictionary of the form <code>{&quot;height&quot;: int, &quot;width&quot;: int}</code>, specifying the size of the output image.`,name:"size"},{anchor:"transformers.SuperPointImageProcessor.resize.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format of the output image. If not provided, it will be inferred from the input
image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"data_format"},{anchor:"transformers.SuperPointImageProcessor.resize.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/superpoint/image_processing_superpoint.py#L125"}}),oe=new _e({props:{title:"SuperPointForKeypointDetection",local:"transformers.SuperPointForKeypointDetection",headingTag:"h2"}}),ne=new ye({props:{name:"class transformers.SuperPointForKeypointDetection",anchor:"transformers.SuperPointForKeypointDetection",parameters:[{name:"config",val:": SuperPointConfig"}],parametersDescription:[{anchor:"transformers.SuperPointForKeypointDetection.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/superpoint#transformers.SuperPointConfig">SuperPointConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/superpoint/modeling_superpoint.py#L388"}}),re=new ye({props:{name:"forward",anchor:"transformers.SuperPointForKeypointDetection.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"labels",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.SuperPointForKeypointDetection.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/superpoint#transformers.SuperPointImageProcessor">SuperPointImageProcessor</a>. See
<a href="/docs/transformers/main/en/model_doc/imagegpt#transformers.ImageGPTFeatureExtractor.__call__">SuperPointImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.SuperPointForKeypointDetection.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for more
detail.`,name:"output_hidden_states"},{anchor:"transformers.SuperPointForKeypointDetection.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.</p>
<p>Examples:`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/superpoint/modeling_superpoint.py#L413"}}),z=new It({props:{$$slots:{default:[Wt]},$$scope:{ctx:ie}}}),ae=new xt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/superpoint.md"}}),{c(){l=a("meta"),U=r(),_=a("p"),b=r(),p(T.$$.fragment),m=r(),p(C.$$.fragment),Me=r(),Z=a("p"),Z.innerHTML=at,we=r(),V=a("p"),V.textContent=it,ve=r(),R=a("p"),R.textContent=lt,Te=r(),G=a("p"),G.innerHTML=ct,Ce=r(),p(N.$$.fragment),$e=r(),D=a("p"),D.textContent=dt,Pe=r(),p(B.$$.fragment),Ue=r(),H=a("p"),H.textContent=mt,Je=r(),q=a("p"),q.textContent=pt,Se=r(),p(E.$$.fragment),je=r(),F=a("p"),F.textContent=ut,Ie=r(),p(X.$$.fragment),ze=r(),Y=a("p"),Y.innerHTML=ft,xe=r(),p(L.$$.fragment),ke=r(),M=a("div"),p(A.$$.fragment),Xe=r(),le=a("p"),le.innerHTML=ht,Ye=r(),ce=a("p"),ce.innerHTML=gt,Le=r(),p(S.$$.fragment),We=r(),p(Q.$$.fragment),Ze=r(),w=a("div"),p(K.$$.fragment),Ae=r(),de=a("p"),de.textContent=yt,Qe=r(),j=a("div"),p(O.$$.fragment),Ke=r(),me=a("p"),me.textContent=_t,Oe=r(),I=a("div"),p(ee.$$.fragment),et=r(),pe=a("p"),pe.textContent=bt,Ve=r(),te=a("ul"),te.innerHTML=Mt,Re=r(),p(oe.$$.fragment),Ge=r(),v=a("div"),p(ne.$$.fragment),tt=r(),ue=a("p"),ue.innerHTML=wt,ot=r(),fe=a("p"),fe.innerHTML=vt,nt=r(),J=a("div"),p(re.$$.fragment),rt=r(),he=a("p"),he.innerHTML=Tt,st=r(),p(z.$$.fragment),Ne=r(),se=a("ul"),se.innerHTML=Ct,De=r(),p(ae.$$.fragment),Be=r(),be=a("p"),this.h()},l(e){const t=jt("svelte-u9bgzb",document.head);l=i(t,"META",{name:!0,content:!0}),t.forEach(o),U=s(e),_=i(e,"P",{}),k(_).forEach(o),b=s(e),u(T.$$.fragment,e),m=s(e),u(C.$$.fragment,e),Me=s(e),Z=i(e,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-3y1k2h"&&(Z.innerHTML=at),we=s(e),V=i(e,"P",{"data-svelte-h":!0}),d(V)!=="svelte-113tmz"&&(V.textContent=it),ve=s(e),R=i(e,"P",{"data-svelte-h":!0}),d(R)!=="svelte-vfdo9a"&&(R.textContent=lt),Te=s(e),G=i(e,"P",{"data-svelte-h":!0}),d(G)!=="svelte-110fra1"&&(G.innerHTML=ct),Ce=s(e),u(N.$$.fragment,e),$e=s(e),D=i(e,"P",{"data-svelte-h":!0}),d(D)!=="svelte-u2cob9"&&(D.textContent=dt),Pe=s(e),u(B.$$.fragment,e),Ue=s(e),H=i(e,"P",{"data-svelte-h":!0}),d(H)!=="svelte-qs9qlh"&&(H.textContent=mt),Je=s(e),q=i(e,"P",{"data-svelte-h":!0}),d(q)!=="svelte-g88i9e"&&(q.textContent=pt),Se=s(e),u(E.$$.fragment,e),je=s(e),F=i(e,"P",{"data-svelte-h":!0}),d(F)!=="svelte-1ma1uoo"&&(F.textContent=ut),Ie=s(e),u(X.$$.fragment,e),ze=s(e),Y=i(e,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-1s32sqj"&&(Y.innerHTML=ft),xe=s(e),u(L.$$.fragment,e),ke=s(e),M=i(e,"DIV",{class:!0});var $=k(M);u(A.$$.fragment,$),Xe=s($),le=i($,"P",{"data-svelte-h":!0}),d(le)!=="svelte-rmywrk"&&(le.innerHTML=ht),Ye=s($),ce=i($,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-o55m63"&&(ce.innerHTML=gt),Le=s($),u(S.$$.fragment,$),$.forEach(o),We=s(e),u(Q.$$.fragment,e),Ze=s(e),w=i(e,"DIV",{class:!0});var P=k(w);u(K.$$.fragment,P),Ae=s(P),de=i(P,"P",{"data-svelte-h":!0}),d(de)!=="svelte-bn94yj"&&(de.textContent=yt),Qe=s(P),j=i(P,"DIV",{class:!0});var qe=k(j);u(O.$$.fragment,qe),Ke=s(qe),me=i(qe,"P",{"data-svelte-h":!0}),d(me)!=="svelte-1x3yxsa"&&(me.textContent=_t),qe.forEach(o),Oe=s(P),I=i(P,"DIV",{class:!0});var Ee=k(I);u(ee.$$.fragment,Ee),et=s(Ee),pe=i(Ee,"P",{"data-svelte-h":!0}),d(pe)!=="svelte-1eb2h1k"&&(pe.textContent=bt),Ee.forEach(o),P.forEach(o),Ve=s(e),te=i(e,"UL",{"data-svelte-h":!0}),d(te)!=="svelte-j0c82d"&&(te.innerHTML=Mt),Re=s(e),u(oe.$$.fragment,e),Ge=s(e),v=i(e,"DIV",{class:!0});var x=k(v);u(ne.$$.fragment,x),tt=s(x),ue=i(x,"P",{"data-svelte-h":!0}),d(ue)!=="svelte-1jukl7g"&&(ue.innerHTML=wt),ot=s(x),fe=i(x,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-1177mku"&&(fe.innerHTML=vt),nt=s(x),J=i(x,"DIV",{class:!0});var ge=k(J);u(re.$$.fragment,ge),rt=s(ge),he=i(ge,"P",{"data-svelte-h":!0}),d(he)!=="svelte-1kya80i"&&(he.innerHTML=Tt),st=s(ge),u(z.$$.fragment,ge),ge.forEach(o),x.forEach(o),Ne=s(e),se=i(e,"UL",{"data-svelte-h":!0}),d(se)!=="svelte-n3ow4o"&&(se.innerHTML=Ct),De=s(e),u(ae.$$.fragment,e),Be=s(e),be=i(e,"P",{}),k(be).forEach(o),this.h()},h(){W(l,"name","hf:doc:metadata"),W(l,"content",Vt),W(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){c(document.head,l),n(e,U,t),n(e,_,t),n(e,b,t),f(T,e,t),n(e,m,t),f(C,e,t),n(e,Me,t),n(e,Z,t),n(e,we,t),n(e,V,t),n(e,ve,t),n(e,R,t),n(e,Te,t),n(e,G,t),n(e,Ce,t),f(N,e,t),n(e,$e,t),n(e,D,t),n(e,Pe,t),f(B,e,t),n(e,Ue,t),n(e,H,t),n(e,Je,t),n(e,q,t),n(e,Se,t),f(E,e,t),n(e,je,t),n(e,F,t),n(e,Ie,t),f(X,e,t),n(e,ze,t),n(e,Y,t),n(e,xe,t),f(L,e,t),n(e,ke,t),n(e,M,t),f(A,M,null),c(M,Xe),c(M,le),c(M,Ye),c(M,ce),c(M,Le),f(S,M,null),n(e,We,t),f(Q,e,t),n(e,Ze,t),n(e,w,t),f(K,w,null),c(w,Ae),c(w,de),c(w,Qe),c(w,j),f(O,j,null),c(j,Ke),c(j,me),c(w,Oe),c(w,I),f(ee,I,null),c(I,et),c(I,pe),n(e,Ve,t),n(e,te,t),n(e,Re,t),f(oe,e,t),n(e,Ge,t),n(e,v,t),f(ne,v,null),c(v,tt),c(v,ue),c(v,ot),c(v,fe),c(v,nt),c(v,J),f(re,J,null),c(J,rt),c(J,he),c(J,st),f(z,J,null),n(e,Ne,t),n(e,se,t),n(e,De,t),f(ae,e,t),n(e,Be,t),n(e,be,t),He=!0},p(e,[t]){const $={};t&2&&($.$$scope={dirty:t,ctx:e}),S.$set($);const P={};t&2&&(P.$$scope={dirty:t,ctx:e}),z.$set(P)},i(e){He||(h(T.$$.fragment,e),h(C.$$.fragment,e),h(N.$$.fragment,e),h(B.$$.fragment,e),h(E.$$.fragment,e),h(X.$$.fragment,e),h(L.$$.fragment,e),h(A.$$.fragment,e),h(S.$$.fragment,e),h(Q.$$.fragment,e),h(K.$$.fragment,e),h(O.$$.fragment,e),h(ee.$$.fragment,e),h(oe.$$.fragment,e),h(ne.$$.fragment,e),h(re.$$.fragment,e),h(z.$$.fragment,e),h(ae.$$.fragment,e),He=!0)},o(e){g(T.$$.fragment,e),g(C.$$.fragment,e),g(N.$$.fragment,e),g(B.$$.fragment,e),g(E.$$.fragment,e),g(X.$$.fragment,e),g(L.$$.fragment,e),g(A.$$.fragment,e),g(S.$$.fragment,e),g(Q.$$.fragment,e),g(K.$$.fragment,e),g(O.$$.fragment,e),g(ee.$$.fragment,e),g(oe.$$.fragment,e),g(ne.$$.fragment,e),g(re.$$.fragment,e),g(z.$$.fragment,e),g(ae.$$.fragment,e),He=!1},d(e){e&&(o(U),o(_),o(b),o(m),o(Me),o(Z),o(we),o(V),o(ve),o(R),o(Te),o(G),o(Ce),o($e),o(D),o(Pe),o(Ue),o(H),o(Je),o(q),o(Se),o(je),o(F),o(Ie),o(ze),o(Y),o(xe),o(ke),o(M),o(We),o(Ze),o(w),o(Ve),o(te),o(Re),o(Ge),o(v),o(Ne),o(se),o(De),o(Be),o(be)),o(l),y(T,e),y(C,e),y(N,e),y(B,e),y(E,e),y(X,e),y(L,e),y(A),y(S),y(Q,e),y(K),y(O),y(ee),y(oe,e),y(ne),y(re),y(z),y(ae,e)}}}const Vt='{"title":"SuperPoint","local":"superpoint","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"How to use","local":"how-to-use","sections":[],"depth":2},{"title":"SuperPointConfig","local":"transformers.SuperPointConfig","sections":[],"depth":2},{"title":"SuperPointImageProcessor","local":"transformers.SuperPointImageProcessor","sections":[],"depth":2},{"title":"SuperPointForKeypointDetection","local":"transformers.SuperPointForKeypointDetection","sections":[],"depth":2}],"depth":1}';function Rt(ie){return Ut(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ft extends Jt{constructor(l){super(),St(this,l,Rt,Zt,Pt,{})}}export{Ft as component};
