import{s as Ht,o as Bt,n as at}from"../chunks/scheduler.25b97de1.js";import{S as Et,i as St,g as i,s as a,r as h,A as Yt,h as l,f as o,c as s,j as U,u as f,x as m,k as P,y as d,a as n,v as g,d as _,t as y,w as b}from"../chunks/index.d9030fc9.js";import{T as qt}from"../chunks/Tip.baa67368.js";import{D as ge}from"../chunks/Docstring.ffac8efa.js";import{C as ze}from"../chunks/CodeBlock.e6cd0d95.js";import{E as Rt}from"../chunks/ExampleCodeBlock.22dfe688.js";import{H as Ce,E as Qt}from"../chunks/EditOnGithub.91d95064.js";function Dt(L){let r,T=`The <code>Fuyu</code> models were trained using <code>bfloat16</code>, but the original inference uses <code>float16</code> The checkpoints uploaded on the hub use <code>torch_dtype = &#39;float16&#39;</code> which will be
used by the <code>AutoModel</code> API to cast the checkpoints from <code>torch.float32</code> to <code>torch.float16</code>.`,c,u,M="The <code>dtype</code> of the online weights is mostly irrelevant, unless you are using <code>torch_dtype=&quot;auto&quot;</code> when initializing a model using <code>model = AutoModelForCausalLM.from_pretrained(&quot;path&quot;, torch_dtype = &quot;auto&quot;)</code>. The reason is that the model will first be downloaded ( using the <code>dtype</code> of the checkpoints online) then it will be cast to the default <code>dtype</code> of <code>torch</code> (becomes <code>torch.float32</code>). Users should specify the <code>torch_dtype</code> they want, and if they don’t it will be <code>torch.float32</code>.",p,w,H="Finetuning the model in <code>float16</code> is not recommended and known to produce <code>nan</code>, as such the model should be fine-tuned in <code>bfloat16</code>.";return{c(){r=i("p"),r.innerHTML=T,c=a(),u=i("p"),u.innerHTML=M,p=a(),w=i("p"),w.innerHTML=H},l(v){r=l(v,"P",{"data-svelte-h":!0}),m(r)!=="svelte-1005mfc"&&(r.innerHTML=T),c=s(v),u=l(v,"P",{"data-svelte-h":!0}),m(u)!=="svelte-1mgue3n"&&(u.innerHTML=M),p=s(v),w=l(v,"P",{"data-svelte-h":!0}),m(w)!=="svelte-1p3drsu"&&(w.innerHTML=H)},m(v,j){n(v,r,j),n(v,c,j),n(v,u,j),n(v,p,j),n(v,w,j)},p:at,d(v){v&&(o(r),o(c),o(u),o(p),o(w))}}}function At(L){let r,T;return r=new ze({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEZ1eXVDb25maWclMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwRnV5dSUyMGZ1eXUtN2IlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwRnV5dUNvbmZpZygp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> FuyuConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Fuyu fuyu-7b style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = FuyuConfig()`,wrap:!1}}),{c(){h(r.$$.fragment)},l(c){f(r.$$.fragment,c)},m(c,u){g(r,c,u),T=!0},p:at,i(c){T||(_(r.$$.fragment,c),T=!0)},o(c){y(r.$$.fragment,c),T=!1},d(c){b(r,c)}}}function Ot(L){let r,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=i("p"),r.innerHTML=T},l(c){r=l(c,"P",{"data-svelte-h":!0}),m(r)!=="svelte-fincs2"&&(r.innerHTML=T)},m(c,u){n(c,r,u)},p:at,d(c){c&&o(r)}}}function Kt(L){let r,T="Examples:",c,u,M;return u=new ze({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEZ1eXVQcm9jZXNzb3IlMkMlMjBGdXl1Rm9yQ2F1c2FsTE0lMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEZ1eXVQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmFkZXB0JTJGZnV5dS04YiUyMiklMEFtb2RlbCUyMCUzRCUyMEZ1eXVGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyYWRlcHQlMkZmdXl1LThiJTIyKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmhmLWludGVybmFsLXRlc3RpbmclMkZmaXh0dXJlcy1jYXB0aW9uaW5nJTJGcmVzb2x2ZSUyRm1haW4lMkZidXMucG5nJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBcHJvbXB0JTIwJTNEJTIwJTIyR2VuZXJhdGUlMjBhJTIwY29jby1zdHlsZSUyMGNhcHRpb24uJTVDbiUyMiUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvcih0ZXh0JTNEcHJvbXB0JTJDJTIwaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMEFnZW5lcmF0ZWRfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDcpJTBBZ2VuZXJhdGlvbl90ZXh0JTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTVCJTNBJTJDJTIwLTclM0ElNUQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklMEFwcmludChnZW5lcmF0aW9uX3RleHQlNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> FuyuProcessor, FuyuForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = FuyuProcessor.from_pretrained(<span class="hljs-string">&quot;adept/fuyu-8b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FuyuForCausalLM.from_pretrained(<span class="hljs-string">&quot;adept/fuyu-8b&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/fixtures-captioning/resolve/main/bus.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Generate a coco-style caption.\\n&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=prompt, images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">7</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_text = processor.batch_decode(generated_ids[:, -<span class="hljs-number">7</span>:], skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(generation_text[<span class="hljs-number">0</span>])
A blue bus parked on the side of a road.`,wrap:!1}}),{c(){r=i("p"),r.textContent=T,c=a(),h(u.$$.fragment)},l(p){r=l(p,"P",{"data-svelte-h":!0}),m(r)!=="svelte-kvfsh7"&&(r.textContent=T),c=s(p),f(u.$$.fragment,p)},m(p,w){n(p,r,w),n(p,c,w),g(u,p,w),M=!0},p:at,i(p){M||(_(u.$$.fragment,p),M=!0)},o(p){y(u.$$.fragment,p),M=!1},d(p){p&&(o(r),o(c)),b(u,p)}}}function eo(L){let r,T,c,u,M,p,w,H,v,j='The Fuyu model was created by <a href="https://www.adept.ai/blog/fuyu-8b" rel="nofollow">ADEPT</a>, and authored by Rohan Bavishi, Erich Elsen, Curtis Hawthorne, Maxwell Nye, Augustus Odena, Arushi Somani, Sağnak Taşırlar.',Je,B,Tt="The authors introduced Fuyu-8B, a decoder-only multimodal model based on the classic transformers architecture, with query and key normalization. A linear encoder is added to create multimodal embeddings from image inputs.",Ie,E,Mt="By treating image tokens like text tokens and using a special image-newline character, the model knows when an image line ends. Image positional embeddings are removed. This avoids the need for different training phases for various image resolutions. With 8 billion parameters and licensed under CC-BY-NC, Fuyu-8B is notable for its ability to handle both text and images, its impressive context size of 16K, and its overall performance.",Le,W,Ue,S,Ft="Tips:",Pe,Y,kt="<li>To convert the model, you need to clone the original repository using <code>git clone https://github.com/persimmon-ai-labs/adept-inference</code>, then get the checkpoints:</li>",je,Q,We,D,$t="For the chat model:",Xe,A,Ve,O,xt="Then, model can be loaded via:",Ge,K,Ne,ee,Ct=`Inputs need to be passed through a specific Processor to have the correct formats.
A processor requires an image_processor and a tokenizer. Hence, inputs can be loaded via:`,qe,te,Re,oe,zt=`This model was contributed by <a href="https://huggingface.co/Molbap" rel="nofollow">Molbap</a>.
The original code can be found <a href="https://github.com/persimmon-ai-labs/adept-inference" rel="nofollow">here</a>.`,He,ne,Zt=`<li><p>Fuyu uses a <code>sentencepiece</code> based tokenizer, with a <code>Unigram</code> model. It supports bytefallback, which is only available in <code>tokenizers==0.14.0</code> for the fast tokenizer.
The <code>LlamaTokenizer</code> is used as it is a standard wrapper around sentencepiece.</p></li> <li><p>The authors suggest to use the following prompt for image captioning: <code>f&quot;Generate a coco-style caption.\\\\n&quot;</code></p></li>`,Be,ae,Ee,F,se,st,_e,Jt=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/fuyu#transformers.FuyuForCausalLM">FuyuForCausalLM</a>. It is used to instantiate an
Fuyu model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the
<a href="https://huggingface.co/adept/fuyu-8b" rel="nofollow">adept/fuyu-8b</a>.`,rt,ye,It=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,it,X,Se,re,Ye,k,ie,lt,be,Lt=`Fuyu Model with a language modeling head on top for causal language model conditioned on image patches and text.
This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,dt,ve,Ut=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,ct,C,le,mt,we,Pt='The <a href="/docs/transformers/main/en/model_doc/fuyu#transformers.FuyuForCausalLM">FuyuForCausalLM</a> forward method, overrides the <code>__call__</code> special method.',ut,V,pt,G,Qe,de,De,$,ce,ht,Te,jt=`This class should handle the image processing part before the main FuyuForCausalLM. In particular, it should
handle:`,ft,Me,Wt=`<li><p>Processing Images:
Taking a batch of images as input. If the images are variable-sized, it resizes them based on the desired patch
dimensions. The image output is always img_h, img_w of (1080, 1920)</p> <p>Then, it patches up these images using the patchify_image function.</p></li> <li><p>Creating Image Input IDs:
For each patch, a placeholder ID is given to identify where these patches belong in a token sequence. For
variable-sized images, each line of patches is terminated with a newline ID.</p></li> <li><p>Image Patch Indices:
For each image patch, the code maintains an index where these patches should be inserted in a token stream.</p></li>`,gt,N,me,_t,Fe,Xt="Preprocess an image or a batch of images.",Ae,ue,Oe,x,pe,yt,ke,Vt="Constructs a Fuyu processor which wraps a Fuyu image processor and a Llama tokenizer into a single processor.",bt,$e,Gt=`<a href="/docs/transformers/main/en/model_doc/fuyu#transformers.FuyuProcessor">FuyuProcessor</a> offers all the functionalities of <a href="/docs/transformers/main/en/model_doc/fuyu#transformers.FuyuImageProcessor">FuyuImageProcessor</a> and <a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>. See the
<a href="/docs/transformers/main/en/model_doc/fuyu#transformers.FuyuProcessor.__call__"><strong>call</strong>()</a> and <code>decode()</code> for more information.`,vt,q,he,wt,xe,Nt=`Main method to prepare for the model one or several sequences(s) and image(s). This method forwards the <code>text</code>
and <code>kwargs</code> arguments to LlamaTokenizerFast’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__"><strong>call</strong>()</a> if <code>text</code> is not <code>None</code> to
encode the text. To prepare the image(s), this method forwards the <code>images</code> and <code>kwargs</code> arguments to
FuyuImageProcessor’s <a href="/docs/transformers/main/en/model_doc/fuyu#transformers.FuyuImageProcessor.__call__"><strong>call</strong>()</a> if <code>images</code> is not <code>None</code>. Please refer to the doctsring
of the above two methods for more information.`,Ke,fe,et,Ze,tt;return M=new Ce({props:{title:"Fuyu",local:"fuyu",headingTag:"h1"}}),w=new Ce({props:{title:"Overview",local:"overview",headingTag:"h2"}}),W=new qt({props:{warning:!0,$$slots:{default:[Dt]},$$scope:{ctx:L}}}),Q=new ze({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZwZXJzaW1tb24tYWktbGFicyUyRmFkZXB0LWluZmVyZW5jZSUwQXdnZXQlMjBwYXRoJTJGdG8lMkZmdXl1LThiLW1vZGVsLXdlaWdodHMudGFyJTBBdGFyJTIwLXh2ZiUyMGZ1eXUtOGItbW9kZWwtd2VpZ2h0cy50YXIlMEFweXRob24lMjBzcmMlMkZ0cmFuc2Zvcm1lcnMlMkZtb2RlbHMlMkZmdXl1JTJGY29udmVydF9mdXl1X3dlaWdodHNfdG9faGYucHklMjAlMjAtLWlucHV0X2RpciUyMCUyRnBhdGglMkZ0byUyRmRvd25sb2FkZWQlMkZmdXl1JTJGd2VpZ2h0cyUyRiUyMC0tb3V0cHV0X2RpciUyMCUyRm91dHB1dCUyRnBhdGglMjAlNUMlMEElMjAlMjAlMjAlMjAtLXB0X21vZGVsX3BhdGglMjAlMkZwYXRoJTJGdG8lMkZmdXl1XzhiX3JlbGVhc2UlMkZpdGVyXzAwMDEyNTElMkZtcF9yYW5rXzAwJTJGbW9kZWxfb3B0aW1fcm5nLnB0JTBBJTIwJTIwJTIwJTIwLS1hZGFfbGliX3BhdGglMjAlMkZwYXRoJTJGdG8lMkZhZGVwdC1pbmZlcmVuY2U=",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/persimmon-ai-labs/adept-inference
wget path/to/fuyu-8b-model-weights.tar
tar -xvf fuyu-8b-model-weights.tar
python src/transformers/models/fuyu/convert_fuyu_weights_to_hf.py  --input_dir /path/to/downloaded/fuyu/weights/ --output_dir /output/path \\
    --pt_model_path /path/to/fuyu_8b_release/iter_0001251/mp_rank_00/model_optim_rng.pt
    --ada_lib_path /path/to/adept-inference`,wrap:!1}}),A=new ze({props:{code:"d2dldCUyMGh0dHBzJTNBJTJGJTJGYXh0a240eGw1Y2lwLm9iamVjdHN0b3JhZ2UudXMtcGhvZW5peC0xLm9jaS5jdXN0b21lci1vY2kuY29tJTJGbiUyRmF4dGtuNHhsNWNpcCUyRmIlMkZhZGVwdC1wdWJsaWMtZGF0YSUyRm8lMkY4Yl9jaGF0X21vZGVsX3JlbGVhc2UudGFyJTBBdGFyJTIwLXh2ZiUyMDhiX2Jhc2VfbW9kZWxfcmVsZWFzZS50YXI=",highlighted:`wget https://axtkn4xl5cip.objectstorage.us-phoenix-1.oci.customer-oci.com/n/axtkn4xl5cip/b/adept-public-data/o/8b_chat_model_release.tar
tar -xvf 8b_base_model_release.tar`,wrap:!1}}),K=new ze({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEZ1eXVDb25maWclMkMlMjBGdXl1Rm9yQ2F1c2FsTE0lMEFtb2RlbF9jb25maWclMjAlM0QlMjBGdXl1Q29uZmlnKCklMEFtb2RlbCUyMCUzRCUyMEZ1eXVGb3JDYXVzYWxMTShtb2RlbF9jb25maWcpLmZyb21fcHJldHJhaW5lZCgnJTJGb3V0cHV0JTJGcGF0aCcp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> FuyuConfig, FuyuForCausalLM
model_config = FuyuConfig()
model = FuyuForCausalLM(model_config).from_pretrained(<span class="hljs-string">&#x27;/output/path&#x27;</span>)`,wrap:!1}}),te=new ze({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwdHJhbnNmb3JtZXJzLm1vZGVscy5mdXl1LnByb2Nlc3NpbmdfZnV5dSUyMGltcG9ydCUyMEZ1eXVQcm9jZXNzb3IlMEFmcm9tJTIwdHJhbnNmb3JtZXJzLm1vZGVscy5mdXl1LmltYWdlX3Byb2Nlc3NpbmdfZnV5dSUyMGltcG9ydCUyMEZ1eXVJbWFnZVByb2Nlc3NvciUwQSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCdhZGVwdC1oZi1jb2xsYWIlMkZmdXl1LThiJyklMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBGdXl1SW1hZ2VQcm9jZXNzb3IoKSUwQSUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEZ1eXVQcm9jZXNzb3IoaW1hZ2VfcHJvY2Vzc29yJTNEaW1hZ2VfcHJvY2Vzc29yJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQXRleHRfcHJvbXB0JTIwJTNEJTIwJTIyR2VuZXJhdGUlMjBhJTIwY29jby1zdHlsZSUyMGNhcHRpb24uJTVDJTVDbiUyMiUwQSUwQWJ1c19pbWFnZV91cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZml4dHVyZXMtY2FwdGlvbmluZyUyRnJlc29sdmUlMkZtYWluJTJGYnVzLnBuZyUyMiUwQWJ1c19pbWFnZV9waWwlMjAlM0QlMjBJbWFnZS5vcGVuKGlvLkJ5dGVzSU8ocmVxdWVzdHMuZ2V0KGJ1c19pbWFnZV91cmwpLmNvbnRlbnQpKSUwQWlucHV0c190b19tb2RlbCUyMCUzRCUyMHByb2Nlc3Nvcih0ZXh0JTNEdGV4dF9wcm9tcHQlMkMlMjBpbWFnZXMlM0RidXNfaW1hZ2VfcGlsKSUwQSUwQQ==",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-keyword">from</span> transformers.models.fuyu.processing_fuyu <span class="hljs-keyword">import</span> FuyuProcessor
<span class="hljs-keyword">from</span> transformers.models.fuyu.image_processing_fuyu <span class="hljs-keyword">import</span> FuyuImageProcessor


tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&#x27;adept-hf-collab/fuyu-8b&#x27;</span>)
image_processor = FuyuImageProcessor()


processor = FuyuProcessor(image_processor=image_processor, tokenizer=tokenizer)
text_prompt = <span class="hljs-string">&quot;Generate a coco-style caption.\\\\n&quot;</span>

bus_image_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/fixtures-captioning/resolve/main/bus.png&quot;</span>
bus_image_pil = Image.<span class="hljs-built_in">open</span>(io.BytesIO(requests.get(bus_image_url).content))
inputs_to_model = processor(text=text_prompt, images=bus_image_pil)

`,wrap:!1}}),ae=new Ce({props:{title:"FuyuConfig",local:"transformers.FuyuConfig",headingTag:"h2"}}),se=new ge({props:{name:"class transformers.FuyuConfig",anchor:"transformers.FuyuConfig",parameters:[{name:"vocab_size",val:" = 262144"},{name:"hidden_size",val:" = 4096"},{name:"intermediate_size",val:" = 16384"},{name:"num_hidden_layers",val:" = 36"},{name:"num_attention_heads",val:" = 64"},{name:"hidden_act",val:" = 'relu2'"},{name:"max_position_embeddings",val:" = 16384"},{name:"image_size",val:" = 300"},{name:"patch_size",val:" = 30"},{name:"num_channels",val:" = 3"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-05"},{name:"use_cache",val:" = True"},{name:"tie_word_embeddings",val:" = False"},{name:"rope_theta",val:" = 25000.0"},{name:"rope_scaling",val:" = None"},{name:"qk_layernorm",val:" = True"},{name:"hidden_dropout",val:" = 0.0"},{name:"attention_dropout",val:" = 0.0"},{name:"partial_rotary_factor",val:" = 0.5"},{name:"pad_token_id",val:" = None"},{name:"bos_token_id",val:" = 1"},{name:"eos_token_id",val:" = 2"},{name:"text_config",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FuyuConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 262144) &#x2014;
Vocabulary size of the Fuyu model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/fuyu#transformers.FuyuForCausalLM">FuyuForCausalLM</a>`,name:"vocab_size"},{anchor:"transformers.FuyuConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Dimension of the hidden representations.`,name:"hidden_size"},{anchor:"transformers.FuyuConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 16384) &#x2014;
Dimension of the MLP representations.`,name:"intermediate_size"},{anchor:"transformers.FuyuConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 36) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.FuyuConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.FuyuConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;relu2&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the decoder.`,name:"hidden_act"},{anchor:"transformers.FuyuConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 16384) &#x2014;
The maximum sequence length that this model might ever be used with.`,name:"max_position_embeddings"},{anchor:"transformers.FuyuConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 300) &#x2014;
The input image size.`,name:"image_size"},{anchor:"transformers.FuyuConfig.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 30) &#x2014;
The input vision transformer encoding patch size.`,name:"patch_size"},{anchor:"transformers.FuyuConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The input image number of channels.`,name:"num_channels"},{anchor:"transformers.FuyuConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.FuyuConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the rms normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.FuyuConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models). Only
relevant if <code>config.is_decoder=True</code>. Whether to tie weight embeddings`,name:"use_cache"},{anchor:"transformers.FuyuConfig.tie_word_embeddings",description:`<strong>tie_word_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to tie input and output embeddings.`,name:"tie_word_embeddings"},{anchor:"transformers.FuyuConfig.rope_theta",description:`<strong>rope_theta</strong> (<code>float</code>, <em>optional</em>, defaults to 25000.0) &#x2014;
The base period of the RoPE embeddings.`,name:"rope_theta"},{anchor:"transformers.FuyuConfig.rope_scaling",description:`<strong>rope_scaling</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Dictionary containing the scaling configuration for the RoPE embeddings. Currently supports two scaling
strategies: linear and dynamic. Their scaling factor must be a float greater than 1. The expected format is
<code>{&quot;type&quot;: strategy name, &quot;factor&quot;: scaling factor}</code>. When using this flag, don&#x2019;t update
<code>max_position_embeddings</code> to the expected new maximum. See the following thread for more information on how
these scaling strategies behave:
<a href="https://www.reddit.com/r/LocalFuyu/comments/14mrgpr/dynamically_scaled_rope_further_increases/" rel="nofollow">https://www.reddit.com/r/LocalFuyu/comments/14mrgpr/dynamically_scaled_rope_further_increases/</a>. This is an
experimental feature, subject to breaking API changes in future versions.`,name:"rope_scaling"},{anchor:"transformers.FuyuConfig.qk_layernorm",description:`<strong>qk_layernorm</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to normalize the Queries and Keys after projecting the hidden states`,name:"qk_layernorm"},{anchor:"transformers.FuyuConfig.hidden_dropout",description:`<strong>hidden_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio after applying the MLP to the hidden states.`,name:"hidden_dropout"},{anchor:"transformers.FuyuConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio after computing the attention scores.`,name:"attention_dropout"},{anchor:"transformers.FuyuConfig.partial_rotary_factor",description:`<strong>partial_rotary_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Percentage of the query and keys which will have rotary embedding.`,name:"partial_rotary_factor"},{anchor:"transformers.FuyuConfig.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.FuyuConfig.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The id of the <em>beginning-of-sequence</em> token.`,name:"bos_token_id"},{anchor:"transformers.FuyuConfig.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>, defaults to 2) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.FuyuConfig.text_config",description:"<strong>text_config</strong> (<code>dict</code>, <em>optional</em>) &#x2014;\nDictionary of configuration options used to initialize the <code>language```Aut</code>.",name:"text_config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/fuyu/configuration_fuyu.py#L25"}}),X=new Rt({props:{anchor:"transformers.FuyuConfig.example",$$slots:{default:[At]},$$scope:{ctx:L}}}),re=new Ce({props:{title:"FuyuForCausalLM",local:"transformers.FuyuForCausalLM",headingTag:"h2"}}),ie=new ge({props:{name:"class transformers.FuyuForCausalLM",anchor:"transformers.FuyuForCausalLM",parameters:[{name:"config",val:": FuyuConfig"}],parametersDescription:[{anchor:"transformers.FuyuForCausalLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/fuyu#transformers.FuyuConfig">FuyuConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/fuyu/modeling_fuyu.py#L143"}}),le=new ge({props:{name:"forward",anchor:"transformers.FuyuForCausalLM.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"image_patches",val:": Tensor = None"},{name:"image_patches_indices",val:": Tensor = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.FuyuForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FuyuForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.FuyuForCausalLM.forward.image_patches",description:`<strong>image_patches</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_total_patches, patch_size_ x patch_size x num_channels)</code>, <em>optional</em>) &#x2014;
Image patches to be used as continuous embeddings. The patches are flattened and then projected to the
hidden size of the model.`,name:"image_patches"},{anchor:"transformers.FuyuForCausalLM.forward.image_patches_indices",description:`<strong>image_patches_indices</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_total_patches + number_of_newline_tokens + number_of_text_tokens, patch_size_ x patch_size x num_channels )</code>, <em>optional</em>) &#x2014;
Indices indicating at which position the image_patches have to be inserted in input_embeds.`,name:"image_patches_indices"},{anchor:"transformers.FuyuForCausalLM.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.FuyuForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.FuyuForCausalLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.FuyuForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.FuyuForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.FuyuForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.FuyuForCausalLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.FuyuForCausalLM.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/fuyu/modeling_fuyu.py#L212",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/fuyu#transformers.FuyuConfig"
>FuyuConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),V=new qt({props:{$$slots:{default:[Ot]},$$scope:{ctx:L}}}),G=new Rt({props:{anchor:"transformers.FuyuForCausalLM.forward.example",$$slots:{default:[Kt]},$$scope:{ctx:L}}}),de=new Ce({props:{title:"FuyuImageProcessor",local:"transformers.FuyuImageProcessor",headingTag:"h2"}}),ce=new ge({props:{name:"class transformers.FuyuImageProcessor",anchor:"transformers.FuyuImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": Optional = None"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"do_pad",val:": bool = True"},{name:"padding_value",val:": float = 1.0"},{name:"padding_mode",val:": str = 'constant'"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": Union = 0.5"},{name:"image_std",val:": Union = 0.5"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": float = 0.00392156862745098"},{name:"patch_size",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FuyuImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image to <code>size</code>.`,name:"do_resize"},{anchor:"transformers.FuyuImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>{&quot;height&quot; -- 1080, &quot;width&quot;: 1920}</code>):
Dictionary in the format <code>{&quot;height&quot;: int, &quot;width&quot;: int}</code> specifying the size of the output image.`,name:"size"},{anchor:"transformers.FuyuImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>Resampling.BILINEAR</code>) &#x2014;
<code>PILImageResampling</code> filter to use when resizing the image e.g. <code>PILImageResampling.BILINEAR</code>.`,name:"resample"},{anchor:"transformers.FuyuImageProcessor.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to pad the image to <code>size</code>.`,name:"do_pad"},{anchor:"transformers.FuyuImageProcessor.padding_value",description:`<strong>padding_value</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The value to pad the image with.`,name:"padding_value"},{anchor:"transformers.FuyuImageProcessor.padding_mode",description:`<strong>padding_mode</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;constant&quot;</code>) &#x2014;
The padding mode to use when padding the image.`,name:"padding_mode"},{anchor:"transformers.FuyuImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.FuyuImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The mean to use when normalizing the image.`,name:"image_mean"},{anchor:"transformers.FuyuImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The standard deviation to use when normalizing the image.`,name:"image_std"},{anchor:"transformers.FuyuImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.FuyuImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>1 / 255</code>) &#x2014;
The factor to use when rescaling the image.`,name:"rescale_factor"},{anchor:"transformers.FuyuImageProcessor.patch_size",description:`<strong>patch_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>{&quot;height&quot; -- 30, &quot;width&quot;: 30}</code>):
Dictionary in the format <code>{&quot;height&quot;: int, &quot;width&quot;: int}</code> specifying the size of the patches.`,name:"patch_size"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/fuyu/image_processing_fuyu.py#L181"}}),me=new ge({props:{name:"__call__",anchor:"transformers.FuyuImageProcessor.__call__",parameters:[{name:"images",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/image_processing_utils.py#L549"}}),ue=new Ce({props:{title:"FuyuProcessor",local:"transformers.FuyuProcessor",headingTag:"h2"}}),pe=new ge({props:{name:"class transformers.FuyuProcessor",anchor:"transformers.FuyuProcessor",parameters:[{name:"image_processor",val:""},{name:"tokenizer",val:""}],parametersDescription:[{anchor:"transformers.FuyuProcessor.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/main/en/model_doc/fuyu#transformers.FuyuImageProcessor">FuyuImageProcessor</a>) &#x2014;
The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.FuyuProcessor.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>) &#x2014;
The tokenizer is a required input.`,name:"tokenizer"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/fuyu/processing_fuyu.py#L309"}}),he=new ge({props:{name:"__call__",anchor:"transformers.FuyuProcessor.__call__",parameters:[{name:"text",val:" = None"},{name:"images",val:" = None"},{name:"add_special_tokens",val:": bool = True"},{name:"return_attention_mask",val:": bool = True"},{name:"padding",val:": Union = False"},{name:"truncation",val:": Union = None"},{name:"max_length",val:": Optional = None"},{name:"stride",val:": int = 0"},{name:"pad_to_multiple_of",val:": Optional = None"},{name:"return_overflowing_tokens",val:": bool = False"},{name:"return_special_tokens_mask",val:": bool = False"},{name:"return_offsets_mapping",val:": bool = False"},{name:"return_token_type_ids",val:": bool = False"},{name:"return_length",val:": bool = False"},{name:"verbose",val:": bool = True"},{name:"return_tensors",val:": Union = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FuyuProcessor.__call__.text",description:`<strong>text</strong> (<code>str</code>, <code>List[str]</code>) &#x2014;
The sequence or batch of sequences to be encoded. Each sequence can be a string or a list of strings
(pretokenized string). If the sequences are provided as list of strings (pretokenized), you must set
<code>is_split_into_words=True</code> (to lift the ambiguity with a batch of sequences).`,name:"text"},{anchor:"transformers.FuyuProcessor.__call__.images",description:`<strong>images</strong> (<code>PIL.Image.Image</code>, <code>List[PIL.Image.Image]</code>) &#x2014;
The image or batch of images to be prepared. Each image can be a PIL image, NumPy array or PyTorch
tensor. Both channels-first and channels-last formats are supported.`,name:"images"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/fuyu/processing_fuyu.py#L451",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>FuyuBatchEncoding</code> with the following fields:</p>
<ul>
<li><strong>input_ids</strong> — Tensor of token ids to be fed to a model. Returned when <code>text</code> is not <code>None</code>.</li>
<li><strong>image_patches</strong> — List of Tensor of image patches. Returned when <code>images</code> is not <code>None</code>.</li>
<li><strong>image_patches_indices</strong> — Tensor of indices where patch embeddings have to be inserted by the model.</li>
<li><strong>attention_mask</strong> — List of indices specifying which tokens should be attended to by the model when
<code>return_attention_mask=True</code>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>FuyuBatchEncoding</code></p>
`}}),fe=new Qt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/fuyu.md"}}),{c(){r=i("meta"),T=a(),c=i("p"),u=a(),h(M.$$.fragment),p=a(),h(w.$$.fragment),H=a(),v=i("p"),v.innerHTML=j,Je=a(),B=i("p"),B.textContent=Tt,Ie=a(),E=i("p"),E.textContent=Mt,Le=a(),h(W.$$.fragment),Ue=a(),S=i("p"),S.textContent=Ft,Pe=a(),Y=i("ul"),Y.innerHTML=kt,je=a(),h(Q.$$.fragment),We=a(),D=i("p"),D.textContent=$t,Xe=a(),h(A.$$.fragment),Ve=a(),O=i("p"),O.textContent=xt,Ge=a(),h(K.$$.fragment),Ne=a(),ee=i("p"),ee.textContent=Ct,qe=a(),h(te.$$.fragment),Re=a(),oe=i("p"),oe.innerHTML=zt,He=a(),ne=i("ul"),ne.innerHTML=Zt,Be=a(),h(ae.$$.fragment),Ee=a(),F=i("div"),h(se.$$.fragment),st=a(),_e=i("p"),_e.innerHTML=Jt,rt=a(),ye=i("p"),ye.innerHTML=It,it=a(),h(X.$$.fragment),Se=a(),h(re.$$.fragment),Ye=a(),k=i("div"),h(ie.$$.fragment),lt=a(),be=i("p"),be.innerHTML=Lt,dt=a(),ve=i("p"),ve.innerHTML=Ut,ct=a(),C=i("div"),h(le.$$.fragment),mt=a(),we=i("p"),we.innerHTML=Pt,ut=a(),h(V.$$.fragment),pt=a(),h(G.$$.fragment),Qe=a(),h(de.$$.fragment),De=a(),$=i("div"),h(ce.$$.fragment),ht=a(),Te=i("p"),Te.textContent=jt,ft=a(),Me=i("ul"),Me.innerHTML=Wt,gt=a(),N=i("div"),h(me.$$.fragment),_t=a(),Fe=i("p"),Fe.textContent=Xt,Ae=a(),h(ue.$$.fragment),Oe=a(),x=i("div"),h(pe.$$.fragment),yt=a(),ke=i("p"),ke.textContent=Vt,bt=a(),$e=i("p"),$e.innerHTML=Gt,vt=a(),q=i("div"),h(he.$$.fragment),wt=a(),xe=i("p"),xe.innerHTML=Nt,Ke=a(),h(fe.$$.fragment),et=a(),Ze=i("p"),this.h()},l(e){const t=Yt("svelte-u9bgzb",document.head);r=l(t,"META",{name:!0,content:!0}),t.forEach(o),T=s(e),c=l(e,"P",{}),U(c).forEach(o),u=s(e),f(M.$$.fragment,e),p=s(e),f(w.$$.fragment,e),H=s(e),v=l(e,"P",{"data-svelte-h":!0}),m(v)!=="svelte-59lh8e"&&(v.innerHTML=j),Je=s(e),B=l(e,"P",{"data-svelte-h":!0}),m(B)!=="svelte-1g2inon"&&(B.textContent=Tt),Ie=s(e),E=l(e,"P",{"data-svelte-h":!0}),m(E)!=="svelte-1xp7ehr"&&(E.textContent=Mt),Le=s(e),f(W.$$.fragment,e),Ue=s(e),S=l(e,"P",{"data-svelte-h":!0}),m(S)!=="svelte-axv494"&&(S.textContent=Ft),Pe=s(e),Y=l(e,"UL",{"data-svelte-h":!0}),m(Y)!=="svelte-g9ue9k"&&(Y.innerHTML=kt),je=s(e),f(Q.$$.fragment,e),We=s(e),D=l(e,"P",{"data-svelte-h":!0}),m(D)!=="svelte-1cs7acv"&&(D.textContent=$t),Xe=s(e),f(A.$$.fragment,e),Ve=s(e),O=l(e,"P",{"data-svelte-h":!0}),m(O)!=="svelte-1c7gnsu"&&(O.textContent=xt),Ge=s(e),f(K.$$.fragment,e),Ne=s(e),ee=l(e,"P",{"data-svelte-h":!0}),m(ee)!=="svelte-60q0vi"&&(ee.textContent=Ct),qe=s(e),f(te.$$.fragment,e),Re=s(e),oe=l(e,"P",{"data-svelte-h":!0}),m(oe)!=="svelte-1ius34j"&&(oe.innerHTML=zt),He=s(e),ne=l(e,"UL",{"data-svelte-h":!0}),m(ne)!=="svelte-qodqh0"&&(ne.innerHTML=Zt),Be=s(e),f(ae.$$.fragment,e),Ee=s(e),F=l(e,"DIV",{class:!0});var z=U(F);f(se.$$.fragment,z),st=s(z),_e=l(z,"P",{"data-svelte-h":!0}),m(_e)!=="svelte-14kk906"&&(_e.innerHTML=Jt),rt=s(z),ye=l(z,"P",{"data-svelte-h":!0}),m(ye)!=="svelte-o55m63"&&(ye.innerHTML=It),it=s(z),f(X.$$.fragment,z),z.forEach(o),Se=s(e),f(re.$$.fragment,e),Ye=s(e),k=l(e,"DIV",{class:!0});var Z=U(k);f(ie.$$.fragment,Z),lt=s(Z),be=l(Z,"P",{"data-svelte-h":!0}),m(be)!=="svelte-19j7dmx"&&(be.innerHTML=Lt),dt=s(Z),ve=l(Z,"P",{"data-svelte-h":!0}),m(ve)!=="svelte-hswkmf"&&(ve.innerHTML=Ut),ct=s(Z),C=l(Z,"DIV",{class:!0});var J=U(C);f(le.$$.fragment,J),mt=s(J),we=l(J,"P",{"data-svelte-h":!0}),m(we)!=="svelte-15glyuy"&&(we.innerHTML=Pt),ut=s(J),f(V.$$.fragment,J),pt=s(J),f(G.$$.fragment,J),J.forEach(o),Z.forEach(o),Qe=s(e),f(de.$$.fragment,e),De=s(e),$=l(e,"DIV",{class:!0});var I=U($);f(ce.$$.fragment,I),ht=s(I),Te=l(I,"P",{"data-svelte-h":!0}),m(Te)!=="svelte-psqr0m"&&(Te.textContent=jt),ft=s(I),Me=l(I,"UL",{"data-svelte-h":!0}),m(Me)!=="svelte-16e0qf2"&&(Me.innerHTML=Wt),gt=s(I),N=l(I,"DIV",{class:!0});var ot=U(N);f(me.$$.fragment,ot),_t=s(ot),Fe=l(ot,"P",{"data-svelte-h":!0}),m(Fe)!=="svelte-khengj"&&(Fe.textContent=Xt),ot.forEach(o),I.forEach(o),Ae=s(e),f(ue.$$.fragment,e),Oe=s(e),x=l(e,"DIV",{class:!0});var R=U(x);f(pe.$$.fragment,R),yt=s(R),ke=l(R,"P",{"data-svelte-h":!0}),m(ke)!=="svelte-1wc4ris"&&(ke.textContent=Vt),bt=s(R),$e=l(R,"P",{"data-svelte-h":!0}),m($e)!=="svelte-m4qk42"&&($e.innerHTML=Gt),vt=s(R),q=l(R,"DIV",{class:!0});var nt=U(q);f(he.$$.fragment,nt),wt=s(nt),xe=l(nt,"P",{"data-svelte-h":!0}),m(xe)!=="svelte-1by0pxu"&&(xe.innerHTML=Nt),nt.forEach(o),R.forEach(o),Ke=s(e),f(fe.$$.fragment,e),et=s(e),Ze=l(e,"P",{}),U(Ze).forEach(o),this.h()},h(){P(r,"name","hf:doc:metadata"),P(r,"content",to),P(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){d(document.head,r),n(e,T,t),n(e,c,t),n(e,u,t),g(M,e,t),n(e,p,t),g(w,e,t),n(e,H,t),n(e,v,t),n(e,Je,t),n(e,B,t),n(e,Ie,t),n(e,E,t),n(e,Le,t),g(W,e,t),n(e,Ue,t),n(e,S,t),n(e,Pe,t),n(e,Y,t),n(e,je,t),g(Q,e,t),n(e,We,t),n(e,D,t),n(e,Xe,t),g(A,e,t),n(e,Ve,t),n(e,O,t),n(e,Ge,t),g(K,e,t),n(e,Ne,t),n(e,ee,t),n(e,qe,t),g(te,e,t),n(e,Re,t),n(e,oe,t),n(e,He,t),n(e,ne,t),n(e,Be,t),g(ae,e,t),n(e,Ee,t),n(e,F,t),g(se,F,null),d(F,st),d(F,_e),d(F,rt),d(F,ye),d(F,it),g(X,F,null),n(e,Se,t),g(re,e,t),n(e,Ye,t),n(e,k,t),g(ie,k,null),d(k,lt),d(k,be),d(k,dt),d(k,ve),d(k,ct),d(k,C),g(le,C,null),d(C,mt),d(C,we),d(C,ut),g(V,C,null),d(C,pt),g(G,C,null),n(e,Qe,t),g(de,e,t),n(e,De,t),n(e,$,t),g(ce,$,null),d($,ht),d($,Te),d($,ft),d($,Me),d($,gt),d($,N),g(me,N,null),d(N,_t),d(N,Fe),n(e,Ae,t),g(ue,e,t),n(e,Oe,t),n(e,x,t),g(pe,x,null),d(x,yt),d(x,ke),d(x,bt),d(x,$e),d(x,vt),d(x,q),g(he,q,null),d(q,wt),d(q,xe),n(e,Ke,t),g(fe,e,t),n(e,et,t),n(e,Ze,t),tt=!0},p(e,[t]){const z={};t&2&&(z.$$scope={dirty:t,ctx:e}),W.$set(z);const Z={};t&2&&(Z.$$scope={dirty:t,ctx:e}),X.$set(Z);const J={};t&2&&(J.$$scope={dirty:t,ctx:e}),V.$set(J);const I={};t&2&&(I.$$scope={dirty:t,ctx:e}),G.$set(I)},i(e){tt||(_(M.$$.fragment,e),_(w.$$.fragment,e),_(W.$$.fragment,e),_(Q.$$.fragment,e),_(A.$$.fragment,e),_(K.$$.fragment,e),_(te.$$.fragment,e),_(ae.$$.fragment,e),_(se.$$.fragment,e),_(X.$$.fragment,e),_(re.$$.fragment,e),_(ie.$$.fragment,e),_(le.$$.fragment,e),_(V.$$.fragment,e),_(G.$$.fragment,e),_(de.$$.fragment,e),_(ce.$$.fragment,e),_(me.$$.fragment,e),_(ue.$$.fragment,e),_(pe.$$.fragment,e),_(he.$$.fragment,e),_(fe.$$.fragment,e),tt=!0)},o(e){y(M.$$.fragment,e),y(w.$$.fragment,e),y(W.$$.fragment,e),y(Q.$$.fragment,e),y(A.$$.fragment,e),y(K.$$.fragment,e),y(te.$$.fragment,e),y(ae.$$.fragment,e),y(se.$$.fragment,e),y(X.$$.fragment,e),y(re.$$.fragment,e),y(ie.$$.fragment,e),y(le.$$.fragment,e),y(V.$$.fragment,e),y(G.$$.fragment,e),y(de.$$.fragment,e),y(ce.$$.fragment,e),y(me.$$.fragment,e),y(ue.$$.fragment,e),y(pe.$$.fragment,e),y(he.$$.fragment,e),y(fe.$$.fragment,e),tt=!1},d(e){e&&(o(T),o(c),o(u),o(p),o(H),o(v),o(Je),o(B),o(Ie),o(E),o(Le),o(Ue),o(S),o(Pe),o(Y),o(je),o(We),o(D),o(Xe),o(Ve),o(O),o(Ge),o(Ne),o(ee),o(qe),o(Re),o(oe),o(He),o(ne),o(Be),o(Ee),o(F),o(Se),o(Ye),o(k),o(Qe),o(De),o($),o(Ae),o(Oe),o(x),o(Ke),o(et),o(Ze)),o(r),b(M,e),b(w,e),b(W,e),b(Q,e),b(A,e),b(K,e),b(te,e),b(ae,e),b(se),b(X),b(re,e),b(ie),b(le),b(V),b(G),b(de,e),b(ce),b(me),b(ue,e),b(pe),b(he),b(fe,e)}}}const to='{"title":"Fuyu","local":"fuyu","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"FuyuConfig","local":"transformers.FuyuConfig","sections":[],"depth":2},{"title":"FuyuForCausalLM","local":"transformers.FuyuForCausalLM","sections":[],"depth":2},{"title":"FuyuImageProcessor","local":"transformers.FuyuImageProcessor","sections":[],"depth":2},{"title":"FuyuProcessor","local":"transformers.FuyuProcessor","sections":[],"depth":2}],"depth":1}';function oo(L){return Bt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class mo extends Et{constructor(r){super(),St(this,r,oo,eo,Ht,{})}}export{mo as component};
