import{s as qo,o as Ho,n as Jo}from"../chunks/scheduler.25b97de1.js";import{S as Do,i as Ko,g as i,s as n,r as p,A as Oo,h as l,f as a,c as t,j as L,u as h,x as m,k,y as r,a as s,v as g,d as f,t as u,w as _}from"../chunks/index.d9030fc9.js";import{T as ea}from"../chunks/Tip.baa67368.js";import{D as z}from"../chunks/Docstring.ffac8efa.js";import{C as ao}from"../chunks/CodeBlock.e6cd0d95.js";import{E as Qo}from"../chunks/ExampleCodeBlock.22dfe688.js";import{H as Ve,E as oa}from"../chunks/EditOnGithub.91d95064.js";function aa(G){let c,U="Example:",y,v,b;return v=new ao({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFZpZGVvTGxhdmFGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMkMlMjBWaWRlb0xsYXZhQ29uZmlnJTJDJTIwQ0xJUFZpc2lvbkNvbmZpZyUyQyUyMExsYW1hQ29uZmlnJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMENMSVAtdmlzaW9uJTIwY29uZmlnJTBBdmlzaW9uX2NvbmZpZyUyMCUzRCUyMENMSVBWaXNpb25Db25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBMbGFtYSUyMGNvbmZpZyUwQXRleHRfY29uZmlnJTIwJTNEJTIwTGxhbWFDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBWaWRlb0xsYXZhJTIwdmlkZW9fbGxhdmEtMS41LTdiJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMFZpZGVvTGxhdmFDb25maWcodmlzaW9uX2NvbmZpZyUyQyUyMHRleHRfY29uZmlnKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMGZyb20lMjB0aGUlMjB2aWRlb19sbGF2YS0xLjUtN2IlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMFZpZGVvTGxhdmFGb3JDb25kaXRpb25hbEdlbmVyYXRpb24oY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> VideoLlavaForConditionalGeneration, VideoLlavaConfig, CLIPVisionConfig, LlamaConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a CLIP-vision config</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>vision_config = CLIPVisionConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Llama config</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text_config = LlamaConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a VideoLlava video_llava-1.5-7b style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = VideoLlavaConfig(vision_config, text_config)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the video_llava-1.5-7b style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VideoLlavaForConditionalGeneration(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){c=i("p"),c.textContent=U,y=n(),p(v.$$.fragment)},l(d){c=l(d,"P",{"data-svelte-h":!0}),m(c)!=="svelte-11lpom8"&&(c.textContent=U),y=t(d),h(v.$$.fragment,d)},m(d,M){s(d,c,M),s(d,y,M),g(v,d,M),b=!0},p:Jo,i(d){b||(f(v.$$.fragment,d),b=!0)},o(d){u(v.$$.fragment,d),b=!1},d(d){d&&(a(c),a(y)),_(v,d)}}}function na(G){let c,U=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){c=i("p"),c.innerHTML=U},l(y){c=l(y,"P",{"data-svelte-h":!0}),m(c)!=="svelte-fincs2"&&(c.innerHTML=U)},m(y,v){s(y,c,v)},p:Jo,d(y){y&&a(c)}}}function ta(G){let c,U="Example:",y,v,b;return v=new ao({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> av
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> VideoLlavaProcessor, VideoLlavaForConditionalGeneration


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">read_video_pyav</span>(<span class="hljs-params">container, indices</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&#x27;&#x27;&#x27;
<span class="hljs-meta">... </span>    Decode the video with PyAV decoder.
<span class="hljs-meta">... </span>    Args:
<span class="hljs-meta">... </span>        container (\`av.container.input.InputContainer\`): PyAV container.
<span class="hljs-meta">... </span>        indices (\`List[int]\`): List of frame indices to decode.
<span class="hljs-meta">... </span>    Returns:
<span class="hljs-meta">... </span>        result (np.ndarray): np array of decoded frames of shape (num_frames, height, width, 3).
<span class="hljs-meta">... </span>    &#x27;&#x27;&#x27;</span>
<span class="hljs-meta">... </span>    frames = []
<span class="hljs-meta">... </span>    container.seek(<span class="hljs-number">0</span>)
<span class="hljs-meta">... </span>    start_index = indices[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>    end_index = indices[-<span class="hljs-number">1</span>]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> i, frame <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(container.decode(video=<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> i &gt; end_index:
<span class="hljs-meta">... </span>            <span class="hljs-keyword">break</span>
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> i &gt;= start_index <span class="hljs-keyword">and</span> i <span class="hljs-keyword">in</span> indices:
<span class="hljs-meta">... </span>            frames.append(frame)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> np.stack([x.to_ndarray(<span class="hljs-built_in">format</span>=<span class="hljs-string">&quot;rgb24&quot;</span>) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> frames])

<span class="hljs-meta">&gt;&gt;&gt; </span>model = VideoLlavaForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;LanguageBind/Video-LLaVA-7B-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = VideoLlavaProcessor.from_pretrained(<span class="hljs-string">&quot;LanguageBind/Video-LLaVA-7B-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;USER: &lt;video&gt;Why is this video funny? ASSISTANT:&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>video_path = hf_hub_download(repo_id=<span class="hljs-string">&quot;raushan-testing-hf/videos-test&quot;</span>, filename=<span class="hljs-string">&quot;sample_demo_1.mp4&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>container = av.<span class="hljs-built_in">open</span>(video_path)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># sample uniformly 8 frames from the video</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>total_frames = container.streams.video[<span class="hljs-number">0</span>].frames
<span class="hljs-meta">&gt;&gt;&gt; </span>indices = np.arange(<span class="hljs-number">0</span>, total_frames, total_frames / <span class="hljs-number">8</span>).astype(<span class="hljs-built_in">int</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>clip = read_video_pyav(container, indices)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=prompt, videos=clip, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(**inputs, max_length=<span class="hljs-number">80</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;USER:  Why is this video funny? ASSISTANT: The video is funny because the baby is sitting on the bed and reading a book, which is an unusual and amusing sight.Ъ&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># to generate from image and video mix</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = [
        <span class="hljs-string">&quot;USER: &lt;image&gt; How many cats are there in the image? ASSISTANT:&quot;</span>,
        <span class="hljs-string">&quot;USER: &lt;video&gt;Why is this video funny? ASSISTANT:&quot;</span>
    ]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=prompt, images=image, videos=clip, padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(**inputs, max_length=<span class="hljs-number">50</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;USER:   How many cats are there in the image? ASSISTANT: There are two cats in the image.\\nHow many cats are sleeping on the couch?\\nThere are&#x27;</span>, <span class="hljs-string">&#x27;USER:  Why is this video funny? ASSISTANT: The video is funny because the baby is sitting on the bed and reading a book, which is an unusual and amusing&#x27;</span>]`,wrap:!1}}),{c(){c=i("p"),c.textContent=U,y=n(),p(v.$$.fragment)},l(d){c=l(d,"P",{"data-svelte-h":!0}),m(c)!=="svelte-11lpom8"&&(c.textContent=U),y=t(d),h(v.$$.fragment,d)},m(d,M){s(d,c,M),s(d,y,M),g(v,d,M),b=!0},p:Jo,i(d){b||(f(v.$$.fragment,d),b=!0)},o(d){u(v.$$.fragment,d),b=!1},d(d){d&&(a(c),a(y)),_(v,d)}}}function sa(G){let c,U,y,v,b,d,M,ke,P,jo="Video-LLaVa is an open-source multimodal LLM trained by fine-tuning LlamA/Vicuna on multimodal instruction-following data generated by Llava1.5 and VideChat. It is an auto-regressive language model, based on the transformer architecture. Video-LLaVa unifies visual representations to the language feature space, and enables an LLM to perform visual reasoning capabilities on both images and videos simultaneously.",xe,E,Co='The Video-LLaVA model was proposed in <a href="https://arxiv.org/abs/2311.10122" rel="nofollow">Video-LLaVA: Learning United Visual Representation by Alignment Before Projection</a> by Bin Lin, Yang Ye, Bin Zhu, Jiaxi Cui, Munang Ning, Peng Jin, Li Yuan.',ze,Y,Io="The abstract from the paper is the following:",Ge,A,Vo=`<em>The Large Vision-Language Model (LVLM) has enhanced the performance of various downstream tasks in
visual-language understanding. Most existing approaches
encode images and videos into separate feature spaces,
which are then fed as inputs to large language models.
However, due to the lack of unified tokenization for images and videos, namely misalignment before projection, it
becomes challenging for a Large Language Model (LLM)
to learn multi-modal interactions from several poor projection layers. In this work, we unify visual representation into the language feature space to advance the foundational LLM towards a unified LVLM. As a result, we establish a simple but robust LVLM baseline, Video-LLaVA,
which learns from a mixed dataset of images and videos,
mutually enhancing each other. Video-LLaVA achieves superior performances on a broad range of 9 image benchmarks across 5 image question-answering datasets and 4
image benchmark toolkits. Additionally, our Video-LLaVA
also outperforms Video-ChatGPT by 5.8%, 9.9%, 18.6%,
and 10.1% on MSRVTT, MSVD, TGIF, and ActivityNet, respectively. Notably, extensive experiments demonstrate that
Video-LLaVA mutually benefits images and videos within
a unified visual representation, outperforming models designed specifically for images or videos. We aim for this
work to provide modest insights into the multi-modal inputs
for the LLM</em>`,We,Q,Lo="Tips:",Ze,q,ko="<li><p>We advise users to use padding_side=“left” when computing batched generation as it leads to more accurate results. Simply make sure to call processor.tokenizer.padding_side = “left” before generating.</p></li> <li><p>Note the model has not been explicitly trained to process multiple images/videos in the same prompt, although this is technically possible, you may experience inaccurate results.</p></li> <li><p>For better results, we recommend users prompt the model with the correct prompt format:</p></li>",Be,H,Re,D,xo="For multiple turns conversation change the prompt to:",$e,K,Fe,O,zo="<li>Note that the video inputs should have exactly 8 frames at the input, since the models were trained in that setting.</li>",Ne,ee,Go=`This model was contributed by <a href="https://huggingface.co/RaushanTurganbay" rel="nofollow">RaushanTurganbay</a>.
The original code can be found <a href="https://github.com/PKU-YuanGroup/Video-LLaVA" rel="nofollow">here</a>.`,Se,oe,Xe,T,ae,no,ue,Wo=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/video_llava#transformers.VideoLlavaForConditionalGeneration">VideoLlavaForConditionalGeneration</a>. It is used to instantiate an
VideoLlava model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the like LanguageBind/Video-LLaVA-7B-hf.`,to,_e,Zo='e.g. <a href="https://huggingface.co/LanguageBind/Video-LLaVA-7B-hf" rel="nofollow">LanguageBind/Video-LLaVA-7B-hf</a>',so,ve,Bo=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,ro,W,Pe,ne,Ee,J,te,io,ye,Ro="Constructs a CLIP image processor.",lo,Z,se,co,be,$o="Preprocess an image or batch of images.",mo,B,re,po,Me,Fo=`Resize an image. The shortest edge of the image is resized to size[“shortest_edge”], with the longest edge
resized to keep the input aspect ratio.`,Ye,ie,Ae,w,le,ho,Te,No="Constructs a VideoLlava processor which wraps a VideoLlava image processor and a Llava tokenizer into a single processor.",go,we,So=`<a href="/docs/transformers/main/en/model_doc/video_llava#transformers.VideoLlavaProcessor">VideoLlavaProcessor</a> offers all the functionalities of <a href="/docs/transformers/main/en/model_doc/video_llava#transformers.VideoLlavaImageProcessor">VideoLlavaImageProcessor</a> and <a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>. See the
<code>__call__()</code> and <a href="/docs/transformers/main/en/model_doc/video_llava#transformers.VideoLlavaProcessor.decode">decode()</a> for more information.`,fo,R,de,uo,Ue,Xo=`This method forwards all its arguments to LlamaTokenizerFast’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.batch_decode">batch_decode()</a>. Please
refer to the docstring of this method for more information.`,_o,$,ce,vo,Je,Po=`This method forwards all its arguments to LlamaTokenizerFast’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.decode">decode()</a>. Please refer to
the docstring of this method for more information.`,Qe,me,qe,j,pe,yo,je,Eo=`The VideoLlava model which consists of a vision backbone and a language model.
This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,bo,Ce,Yo=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Mo,I,he,To,Ie,Ao='The <a href="/docs/transformers/main/en/model_doc/video_llava#transformers.VideoLlavaForConditionalGeneration">VideoLlavaForConditionalGeneration</a> forward method, overrides the <code>__call__</code> special method.',wo,F,Uo,N,He,ge,De,Le,Ke;return b=new Ve({props:{title:"Video-LLaVA",local:"video-llava",headingTag:"h1"}}),M=new Ve({props:{title:"Overview",local:"overview",headingTag:"h2"}}),H=new ao({props:{code:"aW1wb3J0JTIwYXYlMEFpbXBvcnQlMjB0b3JjaCUwQWltcG9ydCUyMG51bXB5JTIwYXMlMjBucCUwQWltcG9ydCUyMHJlcXVlc3RzJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFZpZGVvTGxhdmFGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMkMlMjBWaWRlb0xsYXZhUHJvY2Vzc29yJTBBJTBBZGVmJTIwcmVhZF92aWRlb19weWF2KGNvbnRhaW5lciUyQyUyMGluZGljZXMpJTNBJTBBJTIwJTIwJTIwJTIwJycnJTBBJTIwJTIwJTIwJTIwRGVjb2RlJTIwdGhlJTIwdmlkZW8lMjB3aXRoJTIwUHlBViUyMGRlY29kZXIuJTBBJTIwJTIwJTIwJTIwQXJncyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbnRhaW5lciUyMCglNjBhdi5jb250YWluZXIuaW5wdXQuSW5wdXRDb250YWluZXIlNjApJTNBJTIwUHlBViUyMGNvbnRhaW5lci4lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbmRpY2VzJTIwKCU2MExpc3QlNUJpbnQlNUQlNjApJTNBJTIwTGlzdCUyMG9mJTIwZnJhbWUlMjBpbmRpY2VzJTIwdG8lMjBkZWNvZGUuJTBBJTIwJTIwJTIwJTIwUmV0dXJucyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlc3VsdCUyMChucC5uZGFycmF5KSUzQSUyMG5wJTIwYXJyYXklMjBvZiUyMGRlY29kZWQlMjBmcmFtZXMlMjBvZiUyMHNoYXBlJTIwKG51bV9mcmFtZXMlMkMlMjBoZWlnaHQlMkMlMjB3aWR0aCUyQyUyMDMpLiUwQSUyMCUyMCUyMCUyMCcnJyUwQSUyMCUyMCUyMCUyMGZyYW1lcyUyMCUzRCUyMCU1QiU1RCUwQSUyMCUyMCUyMCUyMGNvbnRhaW5lci5zZWVrKDApJTBBJTIwJTIwJTIwJTIwc3RhcnRfaW5kZXglMjAlM0QlMjBpbmRpY2VzJTVCMCU1RCUwQSUyMCUyMCUyMCUyMGVuZF9pbmRleCUyMCUzRCUyMGluZGljZXMlNUItMSU1RCUwQSUyMCUyMCUyMCUyMGZvciUyMGklMkMlMjBmcmFtZSUyMGluJTIwZW51bWVyYXRlKGNvbnRhaW5lci5kZWNvZGUodmlkZW8lM0QwKSklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMGklMjAlM0UlMjBlbmRfaW5kZXglM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBicmVhayUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwaSUyMCUzRSUzRCUyMHN0YXJ0X2luZGV4JTIwYW5kJTIwaSUyMGluJTIwaW5kaWNlcyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZyYW1lcy5hcHBlbmQoZnJhbWUpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwbnAuc3RhY2soJTVCeC50b19uZGFycmF5KGZvcm1hdCUzRCUyMnJnYjI0JTIyKSUyMGZvciUyMHglMjBpbiUyMGZyYW1lcyU1RCklMEElMEElMEFtb2RlbCUyMCUzRCUyMFZpZGVvTGxhdmFGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMlJhdXNoYW5UdXJnYW5iYXklMkZ2aWRlby1sbGF2YS03Yi1oZiUyMiUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyKSUwQXByb2Nlc3NvciUyMCUzRCUyMFZpZGVvTGxhdmFQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMlJhdXNoYW5UdXJnYW5iYXklMkZ2aWRlby1sbGF2YS03Yi1oZiUyMiklMEElMEF2aWRlb19wYXRoJTIwJTNEJTIwaGZfaHViX2Rvd25sb2FkKHJlcG9faWQlM0QlMjJyYXVzaGFuLXRlc3RpbmctaGYlMkZ2aWRlb3MtdGVzdCUyMiUyQyUyMGZpbGVuYW1lJTNEJTIyc2FtcGxlX2RlbW9fMS5tcDQlMjIlMkMlMjByZXBvX3R5cGUlM0QlMjJkYXRhc2V0JTIyKSUwQSUwQWNvbnRhaW5lciUyMCUzRCUyMGF2Lm9wZW4odmlkZW9fcGF0aCklMEF0b3RhbF9mcmFtZXMlMjAlM0QlMjBjb250YWluZXIuc3RyZWFtcy52aWRlbyU1QjAlNUQuZnJhbWVzJTBBaW5kaWNlcyUyMCUzRCUyMG5wLmFyYW5nZSgwJTJDJTIwdG90YWxfZnJhbWVzJTJDJTIwdG90YWxfZnJhbWVzJTIwJTJGJTIwOCkuYXN0eXBlKGludCklMEF2aWRlbyUyMCUzRCUyMHJlYWRfdmlkZW9fcHlhdihjb250YWluZXIlMkMlMjBpbmRpY2VzKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMlVTRVIlM0ElMjAlM0N2aWRlbyUzRVdoeSUyMGlzJTIwdGhpcyUyMGZ1bm55JTNGJTIwQVNTSVNUQU5UJTNBJTIyJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKHRleHQlM0Rwcm9tcHQlMkMlMjB2aWRlb3MlM0R2aWRlbyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDQwKSUwQXByaW50KHByb2Nlc3Nvci5iYXRjaF9kZWNvZGUob3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUlMkMlMjBjbGVhbl91cF90b2tlbml6YXRpb25fc3BhY2VzJTNEVHJ1ZSkp",highlighted:`<span class="hljs-keyword">import</span> av
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> VideoLlavaForConditionalGeneration, VideoLlavaProcessor

<span class="hljs-keyword">def</span> <span class="hljs-title function_">read_video_pyav</span>(<span class="hljs-params">container, indices</span>):
    <span class="hljs-string">&#x27;&#x27;&#x27;
    Decode the video with PyAV decoder.
    Args:
        container (\`av.container.input.InputContainer\`): PyAV container.
        indices (\`List[int]\`): List of frame indices to decode.
    Returns:
        result (np.ndarray): np array of decoded frames of shape (num_frames, height, width, 3).
    &#x27;&#x27;&#x27;</span>
    frames = []
    container.seek(<span class="hljs-number">0</span>)
    start_index = indices[<span class="hljs-number">0</span>]
    end_index = indices[-<span class="hljs-number">1</span>]
    <span class="hljs-keyword">for</span> i, frame <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(container.decode(video=<span class="hljs-number">0</span>)):
        <span class="hljs-keyword">if</span> i &gt; end_index:
            <span class="hljs-keyword">break</span>
        <span class="hljs-keyword">if</span> i &gt;= start_index <span class="hljs-keyword">and</span> i <span class="hljs-keyword">in</span> indices:
            frames.append(frame)
    <span class="hljs-keyword">return</span> np.stack([x.to_ndarray(<span class="hljs-built_in">format</span>=<span class="hljs-string">&quot;rgb24&quot;</span>) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> frames])


model = VideoLlavaForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;RaushanTurganbay/video-llava-7b-hf&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
processor = VideoLlavaProcessor.from_pretrained(<span class="hljs-string">&quot;RaushanTurganbay/video-llava-7b-hf&quot;</span>)

video_path = hf_hub_download(repo_id=<span class="hljs-string">&quot;raushan-testing-hf/videos-test&quot;</span>, filename=<span class="hljs-string">&quot;sample_demo_1.mp4&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)

container = av.<span class="hljs-built_in">open</span>(video_path)
total_frames = container.streams.video[<span class="hljs-number">0</span>].frames
indices = np.arange(<span class="hljs-number">0</span>, total_frames, total_frames / <span class="hljs-number">8</span>).astype(<span class="hljs-built_in">int</span>)
video = read_video_pyav(container, indices)

prompt = <span class="hljs-string">&quot;USER: &lt;video&gt;Why is this funny? ASSISTANT:&quot;</span>
inputs = processor(text=prompt, videos=video, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

out = model.generate(**inputs, max_new_tokens=<span class="hljs-number">40</span>)
<span class="hljs-built_in">print</span>(processor.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">True</span>))`,wrap:!1}}),K=new ao({props:{code:"JTIyVVNFUiUzQSUyMCUzQ3ZpZGVvJTNFV2hhdCUyMGRvJTIweW91JTIwc2VlJTIwaW4lMjB0aGlzJTIwdmlkZW8lM0YlMjBBU1NJU1RBTlQlM0ElMjBBJTIwYmFieSUyMHJlYWRpbmclMjBhJTIwYm9vay4lMjBVU0VSJTNBJTIwV2h5JTIwaXMlMjB0aGUlMjBpdCUyMGZ1bm55JTNGJTIwQVNTSVNUQU5UJTNBJTIy",highlighted:'<span class="hljs-string">&quot;USER: &lt;video&gt;What do you see in this video? ASSISTANT: A baby reading a book. USER: Why is the it funny? ASSISTANT:&quot;</span>',wrap:!1}}),oe=new Ve({props:{title:"VideoLlavaConfig",local:"transformers.VideoLlavaConfig",headingTag:"h2"}}),ae=new z({props:{name:"class transformers.VideoLlavaConfig",anchor:"transformers.VideoLlavaConfig",parameters:[{name:"vision_config",val:" = None"},{name:"text_config",val:" = None"},{name:"ignore_index",val:" = -100"},{name:"image_token_index",val:" = 32000"},{name:"video_token_index",val:" = 32001"},{name:"projector_hidden_act",val:" = 'gelu'"},{name:"vision_feature_select_strategy",val:" = 'default'"},{name:"vision_feature_layer",val:" = -2"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.VideoLlavaConfig.vision_config",description:`<strong>vision_config</strong> (<code>VideoLlavaVisionConfig</code>, <em>optional</em>) &#x2014;
Custom vision config or dict. Defaults to <code>CLIPVisionConfig</code> if not indicated.`,name:"vision_config"},{anchor:"transformers.VideoLlavaConfig.text_config",description:`<strong>text_config</strong> (<code>Union[AutoConfig, dict]</code>, <em>optional</em>) &#x2014;
The config object of the text backbone. Can be any of <code>LlamaConfig</code> or <code>MistralConfig</code>.
Defaults to <code>LlamaConfig</code> if not indicated.`,name:"text_config"},{anchor:"transformers.VideoLlavaConfig.ignore_index",description:`<strong>ignore_index</strong> (<code>int</code>, <em>optional</em>, defaults to -100) &#x2014;
The ignore index for the loss function.`,name:"ignore_index"},{anchor:"transformers.VideoLlavaConfig.image_token_index",description:`<strong>image_token_index</strong> (<code>int</code>, <em>optional</em>, defaults to 32000) &#x2014;
The image token index to encode the image prompt.`,name:"image_token_index"},{anchor:"transformers.VideoLlavaConfig.video_token_index",description:`<strong>video_token_index</strong> (<code>int</code>, <em>optional</em>, defaults to 32001) &#x2014;
The video token index to encode the image prompt.`,name:"video_token_index"},{anchor:"transformers.VideoLlavaConfig.projector_hidden_act",description:`<strong>projector_hidden_act</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The activation function used by the multimodal projector.`,name:"projector_hidden_act"},{anchor:"transformers.VideoLlavaConfig.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;default&quot;</code>) &#x2014;
The feature selection strategy used to select the vision feature from the CLIP backbone.
Can be either &#x201C;full&#x201D; to select all features or &#x201C;default&#x201D; to select features without <code>CLS</code>.`,name:"vision_feature_select_strategy"},{anchor:"transformers.VideoLlavaConfig.vision_feature_layer",description:`<strong>vision_feature_layer</strong> (<code>int</code>, <em>optional</em>, defaults to -2) &#x2014;
The index of the layer to select the vision feature.`,name:"vision_feature_layer"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/video_llava/configuration_video_llava.py#L24"}}),W=new Qo({props:{anchor:"transformers.VideoLlavaConfig.example",$$slots:{default:[aa]},$$scope:{ctx:G}}}),ne=new Ve({props:{title:"VideoLlavaImageProcessor",local:"transformers.VideoLlavaImageProcessor",headingTag:"h2"}}),te=new z({props:{name:"class transformers.VideoLlavaImageProcessor",anchor:"transformers.VideoLlavaImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": Dict = None"},{name:"resample",val:": Resampling = <Resampling.BICUBIC: 3>"},{name:"do_center_crop",val:": bool = True"},{name:"crop_size",val:": Dict = None"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": Union = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"do_convert_rgb",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.VideoLlavaImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overridden by
<code>do_resize</code> in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.VideoLlavaImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;shortest_edge&quot; -- 224}</code>):
Size of the image after resizing. The shortest edge of the image is resized to size[&#x201C;shortest_edge&#x201D;], with
the longest edge resized to keep the input aspect ratio. Can be overridden by <code>size</code> in the <code>preprocess</code>
method.`,name:"size"},{anchor:"transformers.VideoLlavaImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>Resampling.BICUBIC</code>) &#x2014;
Resampling filter to use if resizing the image. Can be overridden by <code>resample</code> in the <code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.VideoLlavaImageProcessor.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to center crop the image to the specified <code>crop_size</code>. Can be overridden by <code>do_center_crop</code> in the
<code>preprocess</code> method.`,name:"do_center_crop"},{anchor:"transformers.VideoLlavaImageProcessor.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to 224) &#x2014;
Size of the output image after applying <code>center_crop</code>. Can be overridden by <code>crop_size</code> in the <code>preprocess</code>
method.`,name:"crop_size"},{anchor:"transformers.VideoLlavaImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by <code>do_rescale</code> in
the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.VideoLlavaImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by <code>rescale_factor</code> in the <code>preprocess</code>
method.`,name:"rescale_factor"},{anchor:"transformers.VideoLlavaImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by <code>do_normalize</code> in the <code>preprocess</code> method.`,name:"do_normalize"},{anchor:"transformers.VideoLlavaImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>[0.48145466, 0.4578275, 0.40821073]</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.VideoLlavaImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>[0.26862954, 0.26130258, 0.27577711]</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.
Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.VideoLlavaImageProcessor.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/video_llava/image_processing_video_llava.py#L67"}}),se=new z({props:{name:"preprocess",anchor:"transformers.VideoLlavaImageProcessor.preprocess",parameters:[{name:"images",val:": List = None"},{name:"videos",val:": List = None"},{name:"do_resize",val:": bool = None"},{name:"size",val:": Dict = None"},{name:"resample",val:": Resampling = None"},{name:"do_center_crop",val:": bool = None"},{name:"crop_size",val:": int = None"},{name:"do_rescale",val:": bool = None"},{name:"rescale_factor",val:": float = None"},{name:"do_normalize",val:": bool = None"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"do_convert_rgb",val:": bool = None"},{name:"return_tensors",val:": Union = None"},{name:"data_format",val:": Optional = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": Union = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.VideoLlavaImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>, <em>optional</em>) &#x2014;
List of images to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.videos",description:`<strong>videos</strong> (<code>VideoInput</code>, <em>optional</em>) &#x2014;
List of videos to preprocess. Expects a single or batch of videos with pixel values ranging from 0 to 255. If
passing in videos with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"videos"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the image after resizing. Shortest edge of the image is resized to size[&#x201C;shortest_edge&#x201D;], with
the longest edge resized to keep the input aspect ratio.`,name:"size"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>. Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_center_crop</code>) &#x2014;
Whether to center crop the image.`,name:"do_center_crop"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.crop_size</code>) &#x2014;
Size of the center crop. Only has an effect if <code>do_center_crop</code> is set to <code>True</code>.`,name:"crop_size"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean to use for normalization. Only has an effect if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation to use for normalization. Only has an effect if <code>do_normalize</code> is set to
<code>True</code>.`,name:"image_std"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_convert_rgb</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/video_llava/image_processing_video_llava.py#L208"}}),re=new z({props:{name:"resize",anchor:"transformers.VideoLlavaImageProcessor.resize",parameters:[{name:"image",val:": ndarray"},{name:"size",val:": Dict"},{name:"resample",val:": Resampling = <Resampling.BICUBIC: 3>"},{name:"data_format",val:": Union = None"},{name:"input_data_format",val:": Union = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.VideoLlavaImageProcessor.resize.image",description:`<strong>image</strong> (<code>np.ndarray</code>) &#x2014;
Image to resize.`,name:"image"},{anchor:"transformers.VideoLlavaImageProcessor.resize.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>) &#x2014;
Size of the output image.`,name:"size"},{anchor:"transformers.VideoLlavaImageProcessor.resize.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>PILImageResampling.BICUBIC</code>) &#x2014;
Resampling filter to use when resiizing the image.`,name:"resample"},{anchor:"transformers.VideoLlavaImageProcessor.resize.data_format",description:`<strong>data_format</strong> (<code>str</code> or <code>ChannelDimension</code>, <em>optional</em>) &#x2014;
The channel dimension format of the image. If not provided, it will be the same as the input image.`,name:"data_format"},{anchor:"transformers.VideoLlavaImageProcessor.resize.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format of the input image. If not provided, it will be inferred.`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/video_llava/image_processing_video_llava.py#L159"}}),ie=new Ve({props:{title:"VideoLlavaProcessor",local:"transformers.VideoLlavaProcessor",headingTag:"h2"}}),le=new z({props:{name:"class transformers.VideoLlavaProcessor",anchor:"transformers.VideoLlavaProcessor",parameters:[{name:"image_processor",val:" = None"},{name:"tokenizer",val:" = None"}],parametersDescription:[{anchor:"transformers.VideoLlavaProcessor.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/main/en/model_doc/video_llava#transformers.VideoLlavaImageProcessor">VideoLlavaImageProcessor</a>, <em>optional</em>) &#x2014;
The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.VideoLlavaProcessor.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>, <em>optional</em>) &#x2014;
The tokenizer is a required input.`,name:"tokenizer"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/video_llava/processing_video_llava.py#L29"}}),de=new z({props:{name:"batch_decode",anchor:"transformers.VideoLlavaProcessor.batch_decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/video_llava/processing_video_llava.py#L123"}}),ce=new z({props:{name:"decode",anchor:"transformers.VideoLlavaProcessor.decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/video_llava/processing_video_llava.py#L131"}}),me=new Ve({props:{title:"VideoLlavaForConditionalGeneration",local:"transformers.VideoLlavaForConditionalGeneration",headingTag:"h2"}}),pe=new z({props:{name:"class transformers.VideoLlavaForConditionalGeneration",anchor:"transformers.VideoLlavaForConditionalGeneration",parameters:[{name:"config",val:": VideoLlavaConfig"}],parametersDescription:[{anchor:"transformers.VideoLlavaForConditionalGeneration.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/video_llava#transformers.VideoLlavaConfig">VideoLlavaConfig</a> or <code>VideoLlavaVisionConfig</code>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/video_llava/modeling_video_llava.py#L234"}}),he=new z({props:{name:"forward",anchor:"transformers.VideoLlavaForConditionalGeneration.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"pixel_values_images",val:": FloatTensor = None"},{name:"pixel_values_videos",val:": FloatTensor = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"vision_feature_layer",val:": Optional = None"},{name:"vision_feature_select_strategy",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.pixel_values_images",description:'<strong>pixel_values_images</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)) -- The tensors corresponding to the input images. Pixel values can be obtained using [AutoImageProcessor](/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor). See [VideoLlavaImageProcessor.__call__()](/docs/transformers/main/en/model_doc/fuyu#transformers.FuyuImageProcessor.__call__) for details ([]</code>LlavaProcessor`] uses\n<a href="/docs/transformers/main/en/model_doc/video_llava#transformers.VideoLlavaImageProcessor">VideoLlavaImageProcessor</a> for processing images).',name:"pixel_values_images"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.pixel_values_videos",description:'<strong>pixel_values_videos</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_frames, num_channels, image_size, image_size)) -- The tensors corresponding to the input video. Pixel values can be obtained using [AutoImageProcessor](/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor). See [VideoLlavaImageProcessor.__call__()](/docs/transformers/main/en/model_doc/fuyu#transformers.FuyuImageProcessor.__call__) for details ([]</code>LlavaProcessor`] uses\n<a href="/docs/transformers/main/en/model_doc/video_llava#transformers.VideoLlavaImageProcessor">VideoLlavaImageProcessor</a> for processing videos).',name:"pixel_values_videos"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>. <a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.vision_feature_layer",description:`<strong>vision_feature_layer</strong> (<code>int</code>, <em>optional</em>, defaults to -2) &#x2014;
The index of the layer to select the vision feature.`,name:"vision_feature_layer"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;default&quot;</code>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.
Can be one of <code>&quot;default&quot;</code> or <code>&quot;full&quot;</code>`,name:"vision_feature_select_strategy"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.</p>
<p>Args &#x2014;
labels (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>):
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/video_llava/modeling_video_llava.py#L399",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.video_llava.modeling_video_llava.VideoLlavaCausalLMOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/video_llava#transformers.VideoLlavaConfig"
>VideoLlavaConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>image_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the image embeddings, <code>(batch_size, num_images, sequence_length, hidden_size)</code>.</p>
<p>image_hidden_states of the model produced by the vision encoder, and optionally by the perceiver</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.video_llava.modeling_video_llava.VideoLlavaCausalLMOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),F=new ea({props:{$$slots:{default:[na]},$$scope:{ctx:G}}}),N=new Qo({props:{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.example",$$slots:{default:[ta]},$$scope:{ctx:G}}}),ge=new oa({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/video_llava.md"}}),{c(){c=i("meta"),U=n(),y=i("p"),v=n(),p(b.$$.fragment),d=n(),p(M.$$.fragment),ke=n(),P=i("p"),P.textContent=jo,xe=n(),E=i("p"),E.innerHTML=Co,ze=n(),Y=i("p"),Y.textContent=Io,Ge=n(),A=i("p"),A.innerHTML=Vo,We=n(),Q=i("p"),Q.textContent=Lo,Ze=n(),q=i("ul"),q.innerHTML=ko,Be=n(),p(H.$$.fragment),Re=n(),D=i("p"),D.textContent=xo,$e=n(),p(K.$$.fragment),Fe=n(),O=i("ul"),O.innerHTML=zo,Ne=n(),ee=i("p"),ee.innerHTML=Go,Se=n(),p(oe.$$.fragment),Xe=n(),T=i("div"),p(ae.$$.fragment),no=n(),ue=i("p"),ue.innerHTML=Wo,to=n(),_e=i("p"),_e.innerHTML=Zo,so=n(),ve=i("p"),ve.innerHTML=Bo,ro=n(),p(W.$$.fragment),Pe=n(),p(ne.$$.fragment),Ee=n(),J=i("div"),p(te.$$.fragment),io=n(),ye=i("p"),ye.textContent=Ro,lo=n(),Z=i("div"),p(se.$$.fragment),co=n(),be=i("p"),be.textContent=$o,mo=n(),B=i("div"),p(re.$$.fragment),po=n(),Me=i("p"),Me.textContent=Fo,Ye=n(),p(ie.$$.fragment),Ae=n(),w=i("div"),p(le.$$.fragment),ho=n(),Te=i("p"),Te.textContent=No,go=n(),we=i("p"),we.innerHTML=So,fo=n(),R=i("div"),p(de.$$.fragment),uo=n(),Ue=i("p"),Ue.innerHTML=Xo,_o=n(),$=i("div"),p(ce.$$.fragment),vo=n(),Je=i("p"),Je.innerHTML=Po,Qe=n(),p(me.$$.fragment),qe=n(),j=i("div"),p(pe.$$.fragment),yo=n(),je=i("p"),je.innerHTML=Eo,bo=n(),Ce=i("p"),Ce.innerHTML=Yo,Mo=n(),I=i("div"),p(he.$$.fragment),To=n(),Ie=i("p"),Ie.innerHTML=Ao,wo=n(),p(F.$$.fragment),Uo=n(),p(N.$$.fragment),He=n(),p(ge.$$.fragment),De=n(),Le=i("p"),this.h()},l(e){const o=Oo("svelte-u9bgzb",document.head);c=l(o,"META",{name:!0,content:!0}),o.forEach(a),U=t(e),y=l(e,"P",{}),L(y).forEach(a),v=t(e),h(b.$$.fragment,e),d=t(e),h(M.$$.fragment,e),ke=t(e),P=l(e,"P",{"data-svelte-h":!0}),m(P)!=="svelte-81xura"&&(P.textContent=jo),xe=t(e),E=l(e,"P",{"data-svelte-h":!0}),m(E)!=="svelte-v87k6c"&&(E.innerHTML=Co),ze=t(e),Y=l(e,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-vfdo9a"&&(Y.textContent=Io),Ge=t(e),A=l(e,"P",{"data-svelte-h":!0}),m(A)!=="svelte-sk56aa"&&(A.innerHTML=Vo),We=t(e),Q=l(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-axv494"&&(Q.textContent=Lo),Ze=t(e),q=l(e,"UL",{"data-svelte-h":!0}),m(q)!=="svelte-4x27ws"&&(q.innerHTML=ko),Be=t(e),h(H.$$.fragment,e),Re=t(e),D=l(e,"P",{"data-svelte-h":!0}),m(D)!=="svelte-6toftq"&&(D.textContent=xo),$e=t(e),h(K.$$.fragment,e),Fe=t(e),O=l(e,"UL",{"data-svelte-h":!0}),m(O)!=="svelte-1dv4oor"&&(O.innerHTML=zo),Ne=t(e),ee=l(e,"P",{"data-svelte-h":!0}),m(ee)!=="svelte-1lvcrum"&&(ee.innerHTML=Go),Se=t(e),h(oe.$$.fragment,e),Xe=t(e),T=l(e,"DIV",{class:!0});var C=L(T);h(ae.$$.fragment,C),no=t(C),ue=l(C,"P",{"data-svelte-h":!0}),m(ue)!=="svelte-h7bus0"&&(ue.innerHTML=Wo),to=t(C),_e=l(C,"P",{"data-svelte-h":!0}),m(_e)!=="svelte-q9hjjl"&&(_e.innerHTML=Zo),so=t(C),ve=l(C,"P",{"data-svelte-h":!0}),m(ve)!=="svelte-o55m63"&&(ve.innerHTML=Bo),ro=t(C),h(W.$$.fragment,C),C.forEach(a),Pe=t(e),h(ne.$$.fragment,e),Ee=t(e),J=l(e,"DIV",{class:!0});var V=L(J);h(te.$$.fragment,V),io=t(V),ye=l(V,"P",{"data-svelte-h":!0}),m(ye)!=="svelte-x48p92"&&(ye.textContent=Ro),lo=t(V),Z=l(V,"DIV",{class:!0});var fe=L(Z);h(se.$$.fragment,fe),co=t(fe),be=l(fe,"P",{"data-svelte-h":!0}),m(be)!=="svelte-1x3yxsa"&&(be.textContent=$o),fe.forEach(a),mo=t(V),B=l(V,"DIV",{class:!0});var Oe=L(B);h(re.$$.fragment,Oe),po=t(Oe),Me=l(Oe,"P",{"data-svelte-h":!0}),m(Me)!=="svelte-1qmgo6y"&&(Me.textContent=Fo),Oe.forEach(a),V.forEach(a),Ye=t(e),h(ie.$$.fragment,e),Ae=t(e),w=l(e,"DIV",{class:!0});var x=L(w);h(le.$$.fragment,x),ho=t(x),Te=l(x,"P",{"data-svelte-h":!0}),m(Te)!=="svelte-15aq8e1"&&(Te.textContent=No),go=t(x),we=l(x,"P",{"data-svelte-h":!0}),m(we)!=="svelte-sh4lfi"&&(we.innerHTML=So),fo=t(x),R=l(x,"DIV",{class:!0});var eo=L(R);h(de.$$.fragment,eo),uo=t(eo),Ue=l(eo,"P",{"data-svelte-h":!0}),m(Ue)!=="svelte-1o9eza"&&(Ue.innerHTML=Xo),eo.forEach(a),_o=t(x),$=l(x,"DIV",{class:!0});var oo=L($);h(ce.$$.fragment,oo),vo=t(oo),Je=l(oo,"P",{"data-svelte-h":!0}),m(Je)!=="svelte-kk16qw"&&(Je.innerHTML=Po),oo.forEach(a),x.forEach(a),Qe=t(e),h(me.$$.fragment,e),qe=t(e),j=l(e,"DIV",{class:!0});var S=L(j);h(pe.$$.fragment,S),yo=t(S),je=l(S,"P",{"data-svelte-h":!0}),m(je)!=="svelte-1qwtcy"&&(je.innerHTML=Eo),bo=t(S),Ce=l(S,"P",{"data-svelte-h":!0}),m(Ce)!=="svelte-hswkmf"&&(Ce.innerHTML=Yo),Mo=t(S),I=l(S,"DIV",{class:!0});var X=L(I);h(he.$$.fragment,X),To=t(X),Ie=l(X,"P",{"data-svelte-h":!0}),m(Ie)!=="svelte-fmp8gd"&&(Ie.innerHTML=Ao),wo=t(X),h(F.$$.fragment,X),Uo=t(X),h(N.$$.fragment,X),X.forEach(a),S.forEach(a),He=t(e),h(ge.$$.fragment,e),De=t(e),Le=l(e,"P",{}),L(Le).forEach(a),this.h()},h(){k(c,"name","hf:doc:metadata"),k(c,"content",ra),k(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,o){r(document.head,c),s(e,U,o),s(e,y,o),s(e,v,o),g(b,e,o),s(e,d,o),g(M,e,o),s(e,ke,o),s(e,P,o),s(e,xe,o),s(e,E,o),s(e,ze,o),s(e,Y,o),s(e,Ge,o),s(e,A,o),s(e,We,o),s(e,Q,o),s(e,Ze,o),s(e,q,o),s(e,Be,o),g(H,e,o),s(e,Re,o),s(e,D,o),s(e,$e,o),g(K,e,o),s(e,Fe,o),s(e,O,o),s(e,Ne,o),s(e,ee,o),s(e,Se,o),g(oe,e,o),s(e,Xe,o),s(e,T,o),g(ae,T,null),r(T,no),r(T,ue),r(T,to),r(T,_e),r(T,so),r(T,ve),r(T,ro),g(W,T,null),s(e,Pe,o),g(ne,e,o),s(e,Ee,o),s(e,J,o),g(te,J,null),r(J,io),r(J,ye),r(J,lo),r(J,Z),g(se,Z,null),r(Z,co),r(Z,be),r(J,mo),r(J,B),g(re,B,null),r(B,po),r(B,Me),s(e,Ye,o),g(ie,e,o),s(e,Ae,o),s(e,w,o),g(le,w,null),r(w,ho),r(w,Te),r(w,go),r(w,we),r(w,fo),r(w,R),g(de,R,null),r(R,uo),r(R,Ue),r(w,_o),r(w,$),g(ce,$,null),r($,vo),r($,Je),s(e,Qe,o),g(me,e,o),s(e,qe,o),s(e,j,o),g(pe,j,null),r(j,yo),r(j,je),r(j,bo),r(j,Ce),r(j,Mo),r(j,I),g(he,I,null),r(I,To),r(I,Ie),r(I,wo),g(F,I,null),r(I,Uo),g(N,I,null),s(e,He,o),g(ge,e,o),s(e,De,o),s(e,Le,o),Ke=!0},p(e,[o]){const C={};o&2&&(C.$$scope={dirty:o,ctx:e}),W.$set(C);const V={};o&2&&(V.$$scope={dirty:o,ctx:e}),F.$set(V);const fe={};o&2&&(fe.$$scope={dirty:o,ctx:e}),N.$set(fe)},i(e){Ke||(f(b.$$.fragment,e),f(M.$$.fragment,e),f(H.$$.fragment,e),f(K.$$.fragment,e),f(oe.$$.fragment,e),f(ae.$$.fragment,e),f(W.$$.fragment,e),f(ne.$$.fragment,e),f(te.$$.fragment,e),f(se.$$.fragment,e),f(re.$$.fragment,e),f(ie.$$.fragment,e),f(le.$$.fragment,e),f(de.$$.fragment,e),f(ce.$$.fragment,e),f(me.$$.fragment,e),f(pe.$$.fragment,e),f(he.$$.fragment,e),f(F.$$.fragment,e),f(N.$$.fragment,e),f(ge.$$.fragment,e),Ke=!0)},o(e){u(b.$$.fragment,e),u(M.$$.fragment,e),u(H.$$.fragment,e),u(K.$$.fragment,e),u(oe.$$.fragment,e),u(ae.$$.fragment,e),u(W.$$.fragment,e),u(ne.$$.fragment,e),u(te.$$.fragment,e),u(se.$$.fragment,e),u(re.$$.fragment,e),u(ie.$$.fragment,e),u(le.$$.fragment,e),u(de.$$.fragment,e),u(ce.$$.fragment,e),u(me.$$.fragment,e),u(pe.$$.fragment,e),u(he.$$.fragment,e),u(F.$$.fragment,e),u(N.$$.fragment,e),u(ge.$$.fragment,e),Ke=!1},d(e){e&&(a(U),a(y),a(v),a(d),a(ke),a(P),a(xe),a(E),a(ze),a(Y),a(Ge),a(A),a(We),a(Q),a(Ze),a(q),a(Be),a(Re),a(D),a($e),a(Fe),a(O),a(Ne),a(ee),a(Se),a(Xe),a(T),a(Pe),a(Ee),a(J),a(Ye),a(Ae),a(w),a(Qe),a(qe),a(j),a(He),a(De),a(Le)),a(c),_(b,e),_(M,e),_(H,e),_(K,e),_(oe,e),_(ae),_(W),_(ne,e),_(te),_(se),_(re),_(ie,e),_(le),_(de),_(ce),_(me,e),_(pe),_(he),_(F),_(N),_(ge,e)}}}const ra='{"title":"Video-LLaVA","local":"video-llava","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"VideoLlavaConfig","local":"transformers.VideoLlavaConfig","sections":[],"depth":2},{"title":"VideoLlavaImageProcessor","local":"transformers.VideoLlavaImageProcessor","sections":[],"depth":2},{"title":"VideoLlavaProcessor","local":"transformers.VideoLlavaProcessor","sections":[],"depth":2},{"title":"VideoLlavaForConditionalGeneration","local":"transformers.VideoLlavaForConditionalGeneration","sections":[],"depth":2}],"depth":1}';function ia(G){return Ho(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class fa extends Do{constructor(c){super(),Ko(this,c,ia,sa,qo,{})}}export{fa as component};
