import{s as io,o as mo,n as tr}from"../chunks/scheduler.9991993c.js";import{S as co,i as po,g as l,s,r as p,A as fo,h as i,f as t,c as a,j as $,u as f,x as m,k as b,y as o,a as n,v as u,d as h,t as g,w as _}from"../chunks/index.7fc9a5e7.js";import{T as la}from"../chunks/Tip.9de92fc6.js";import{D as M}from"../chunks/Docstring.ef7d0149.js";import{C as sr}from"../chunks/CodeBlock.e11cba92.js";import{E as ia}from"../chunks/ExampleCodeBlock.0db1a011.js";import{H as pe,E as uo}from"../chunks/EditOnGithub.84ab7f0e.js";function ho(J){let d,T=`This class method is simply calling the feature extractor
<a href="/docs/transformers/main/zh/main_classes/feature_extractor#transformers.FeatureExtractionMixin.from_pretrained">from_pretrained()</a>, image processor
<a href="/docs/transformers/main/zh/internal/image_processing_utils#transformers.ImageProcessingMixin">ImageProcessingMixin</a> and the tokenizer
<code>~tokenization_utils_base.PreTrainedTokenizer.from_pretrained</code> methods. Please refer to the docstrings of the
methods above for more information.`;return{c(){d=l("p"),d.innerHTML=T},l(v){d=i(v,"P",{"data-svelte-h":!0}),m(d)!=="svelte-1yuzgkp"&&(d.innerHTML=T)},m(v,x){n(v,d,x)},p:tr,d(v){v&&t(d)}}}function go(J){let d,T="Examples:",v,x,C;return x=new sr({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBQdXNoJTIwdGhlJTIwcHJvY2Vzc29yJTIwdG8lMjB5b3VyJTIwbmFtZXNwYWNlJTIwd2l0aCUyMHRoZSUyMG5hbWUlMjAlMjJteS1maW5ldHVuZWQtYmVydCUyMi4lMEFwcm9jZXNzb3IucHVzaF90b19odWIoJTIybXktZmluZXR1bmVkLWJlcnQlMjIpJTBBJTBBJTIzJTIwUHVzaCUyMHRoZSUyMHByb2Nlc3NvciUyMHRvJTIwYW4lMjBvcmdhbml6YXRpb24lMjB3aXRoJTIwdGhlJTIwbmFtZSUyMCUyMm15LWZpbmV0dW5lZC1iZXJ0JTIyLiUwQXByb2Nlc3Nvci5wdXNoX3RvX2h1YiglMjJodWdnaW5nZmFjZSUyRm15LWZpbmV0dW5lZC1iZXJ0JTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor

processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-comment"># Push the processor to your namespace with the name &quot;my-finetuned-bert&quot;.</span>
processor.push_to_hub(<span class="hljs-string">&quot;my-finetuned-bert&quot;</span>)

<span class="hljs-comment"># Push the processor to an organization with the name &quot;my-finetuned-bert&quot;.</span>
processor.push_to_hub(<span class="hljs-string">&quot;huggingface/my-finetuned-bert&quot;</span>)`,wrap:!1}}),{c(){d=l("p"),d.textContent=T,v=s(),p(x.$$.fragment)},l(c){d=i(c,"P",{"data-svelte-h":!0}),m(d)!=="svelte-kvfsh7"&&(d.textContent=T),v=a(c),f(x.$$.fragment,c)},m(c,I){n(c,d,I),n(c,v,I),u(x,c,I),C=!0},p:tr,i(c){C||(h(x.$$.fragment,c),C=!0)},o(c){g(x.$$.fragment,c),C=!1},d(c){c&&(t(d),t(v)),_(x,c)}}}function _o(J){let d,T="This API is experimental and may have some slight breaking changes in the next releases.";return{c(){d=l("p"),d.textContent=T},l(v){d=i(v,"P",{"data-svelte-h":!0}),m(d)!=="svelte-15rpg4"&&(d.textContent=T)},m(v,x){n(v,d,x)},p:tr,d(v){v&&t(d)}}}function vo(J){let d,T=`This class method is simply calling <a href="/docs/transformers/main/zh/main_classes/feature_extractor#transformers.FeatureExtractionMixin.save_pretrained">save_pretrained()</a> and
<a href="/docs/transformers/main/zh/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.save_pretrained">save_pretrained()</a>. Please refer to the docstrings of the
methods above for more information.`;return{c(){d=l("p"),d.innerHTML=T},l(v){d=i(v,"P",{"data-svelte-h":!0}),m(d)!=="svelte-6mch0o"&&(d.innerHTML=T)},m(v,x){n(v,d,x)},p:tr,d(v){v&&t(d)}}}function xo(J){let d,T="Examples:",v,x,C;return x=new sr({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvd19kYXRhc2V0cyUyMGFzJTIwdGZkcyUwQSUwQWRhdGFzZXQlMjAlM0QlMjB0ZmRzLmxvYWQoJTIyc3F1YWQlMjIpJTBBJTBBdHJhaW5pbmdfZXhhbXBsZXMlMjAlM0QlMjBnZXRfZXhhbXBsZXNfZnJvbV9kYXRhc2V0KGRhdGFzZXQlMkMlMjBldmFsdWF0ZSUzREZhbHNlKSUwQWV2YWx1YXRpb25fZXhhbXBsZXMlMjAlM0QlMjBnZXRfZXhhbXBsZXNfZnJvbV9kYXRhc2V0KGRhdGFzZXQlMkMlMjBldmFsdWF0ZSUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow_datasets <span class="hljs-keyword">as</span> tfds

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = tfds.load(<span class="hljs-string">&quot;squad&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>training_examples = get_examples_from_dataset(dataset, evaluate=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>evaluation_examples = get_examples_from_dataset(dataset, evaluate=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){d=l("p"),d.textContent=T,v=s(),p(x.$$.fragment)},l(c){d=i(c,"P",{"data-svelte-h":!0}),m(d)!=="svelte-kvfsh7"&&(d.textContent=T),v=a(c),f(x.$$.fragment,c)},m(c,I){n(c,d,I),n(c,v,I),u(x,c,I),C=!0},p:tr,i(c){C||(h(x.$$.fragment,c),C=!0)},o(c){g(x.$$.fragment,c),C=!1},d(c){c&&(t(d),t(v)),_(x,c)}}}function $o(J){let d,T="Example:",v,x,C;return x=new sr({props:{code:"cHJvY2Vzc29yJTIwJTNEJTIwU3F1YWRWMlByb2Nlc3NvcigpJTBBZXhhbXBsZXMlMjAlM0QlMjBwcm9jZXNzb3IuZ2V0X2Rldl9leGFtcGxlcyhkYXRhX2RpciklMEElMEFmZWF0dXJlcyUyMCUzRCUyMHNxdWFkX2NvbnZlcnRfZXhhbXBsZXNfdG9fZmVhdHVyZXMoJTBBJTIwJTIwJTIwJTIwZXhhbXBsZXMlM0RleGFtcGxlcyUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMG1heF9zZXFfbGVuZ3RoJTNEYXJncy5tYXhfc2VxX2xlbmd0aCUyQyUwQSUyMCUyMCUyMCUyMGRvY19zdHJpZGUlM0RhcmdzLmRvY19zdHJpZGUlMkMlMEElMjAlMjAlMjAlMjBtYXhfcXVlcnlfbGVuZ3RoJTNEYXJncy5tYXhfcXVlcnlfbGVuZ3RoJTJDJTBBJTIwJTIwJTIwJTIwaXNfdHJhaW5pbmclM0Rub3QlMjBldmFsdWF0ZSUyQyUwQSk=",highlighted:`processor = SquadV2Processor()
examples = processor.get_dev_examples(data_dir)

features = squad_convert_examples_to_features(
    examples=examples,
    tokenizer=tokenizer,
    max_seq_length=args.max_seq_length,
    doc_stride=args.doc_stride,
    max_query_length=args.max_query_length,
    is_training=<span class="hljs-keyword">not</span> evaluate,
)`,wrap:!1}}),{c(){d=l("p"),d.textContent=T,v=s(),p(x.$$.fragment)},l(c){d=i(c,"P",{"data-svelte-h":!0}),m(d)!=="svelte-11lpom8"&&(d.textContent=T),v=a(c),f(x.$$.fragment,c)},m(c,I){n(c,d,I),n(c,v,I),u(x,c,I),C=!0},p:tr,i(c){C||(h(x.$$.fragment,c),C=!0)},o(c){g(x.$$.fragment,c),C=!1},d(c){c&&(t(d),t(v)),_(x,c)}}}function bo(J){let d,T,v,x,C,c,I,ma="在 Transformers 库中，processors可以有两种不同的含义：",ar,fe,da='<li>为多模态模型，例如<a href="../model_doc/wav2vec2">Wav2Vec2</a>（语音和文本）或<a href="../model_doc/clip">CLIP</a>（文本和视觉）预处理输入的对象</li> <li>在库的旧版本中用于预处理GLUE或SQUAD数据的已弃用对象。</li>',or,ue,nr,he,ca="任何多模态模型都需要一个对象来编码或解码将多个模态（包括文本、视觉和音频）组合在一起的数据。这由称为processors的对象处理，这些processors将两个或多个处理对象组合在一起，例如tokenizers（用于文本模态），image processors（用于视觉）和feature extractors（用于音频）。",lr,ge,pa="这些processors继承自以下实现保存和加载功能的基类：",ir,y,_e,is,Mt,fa="This is a mixin used to provide saving/loading functionality for all processor classes.",ms,D,ve,ds,wt,ua="Instantiates a type of <code>~processing_utils.ProcessingMixin</code> from a Python dictionary of parameters.",cs,j,xe,ps,Tt,ha="Instantiate a processor associated with a pretrained model.",fs,G,us,R,$e,hs,Ct,ga=`From a <code>pretrained_model_name_or_path</code>, resolve to a dictionary of parameters, to be used for instantiating a
processor of type <code>~processing_utils.ProcessingMixin</code> using <code>from_args_and_dict</code>.`,gs,z,be,_s,Pt,_a="Upload the processor files to the 🤗 Model Hub.",vs,W,xs,V,ye,$s,It,va=`Register this class with a given auto class. This should only be used for custom feature extractors as the ones
in the library are already mapped with <code>AutoProcessor</code>.`,bs,Q,ys,q,Me,Ms,Xt,xa=`Saves the attributes of this processor (feature extractor, tokenizer…) in the specified directory so that it
can be reloaded using the <a href="/docs/transformers/main/zh/main_classes/processors#transformers.ProcessorMixin.from_pretrained">from_pretrained()</a> method.`,ws,Y,Ts,A,we,Cs,kt,$a="Serializes this instance to a Python dictionary.",Ps,O,Te,Is,Jt,ba="Save this instance to a JSON file.",Xs,K,Ce,ks,Ut,ya="Serializes this instance to a JSON string.",mr,Pe,dr,Ie,Ma='所有processor都遵循与 <a href="/docs/transformers/main/zh/main_classes/processors#transformers.DataProcessor">DataProcessor</a> 相同的架构。processor返回一个 <a href="/docs/transformers/main/zh/main_classes/processors#transformers.InputExample">InputExample</a> 列表。这些 <a href="/docs/transformers/main/zh/main_classes/processors#transformers.InputExample">InputExample</a> 可以转换为 <a href="/docs/transformers/main/zh/main_classes/processors#transformers.InputFeatures">InputFeatures</a> 以供输送到模型。',cr,P,Xe,Js,Zt,wa="Base class for data converters for sequence classification data sets.",Us,ee,ke,Zs,Lt,Ta='Gets a collection of <a href="/docs/transformers/main/zh/main_classes/processors#transformers.InputExample">InputExample</a> for the dev set.',Ls,te,Je,js,jt,Ca="Gets an example from a dict with tensorflow tensors.",zs,re,Ue,Vs,zt,Pa="Gets the list of labels for this data set.",qs,se,Ze,Es,Vt,Ia='Gets a collection of <a href="/docs/transformers/main/zh/main_classes/processors#transformers.InputExample">InputExample</a> for the test set.',Hs,ae,Le,Ns,qt,Xa='Gets a collection of <a href="/docs/transformers/main/zh/main_classes/processors#transformers.InputExample">InputExample</a> for the train set.',Bs,oe,je,Fs,Et,ka=`Some tensorflow_datasets datasets are not formatted the same way the GLUE datasets are. This method converts
examples to the correct format.`,pr,U,ze,Ss,Ht,Ja="A single training/test example for simple sequence classification.",Ds,ne,Ve,Gs,Nt,Ua="Serializes this instance to a JSON string.",fr,Z,qe,Rs,Bt,Za="A single set of features of data. Property names are the same names as the corresponding inputs to a model.",Ws,le,Ee,Qs,Ft,La="Serializes this instance to a JSON string.",ur,He,hr,Ne,ja='<a href="https://gluebenchmark.com/" rel="nofollow">General Language Understanding Evaluation (GLUE)</a> 是一个基准测试，评估模型在各种现有的自然语言理解任务上的性能。它与论文 <a href="https://openreview.net/pdf?id=rJ4km2R5t7" rel="nofollow">GLUE: A multi-task benchmark and analysis platform for natural language understanding</a> 一同发布。',gr,Be,za="该库为以下任务提供了总共10个processor：MRPC、MNLI、MNLI（mismatched）、CoLA、SST2、STSB、QQP、QNLI、RTE 和 WNLI。",_r,Fe,Va="这些processor是：",vr,Se,qa="<li><code>~data.processors.utils.MrpcProcessor</code></li> <li><code>~data.processors.utils.MnliProcessor</code></li> <li><code>~data.processors.utils.MnliMismatchedProcessor</code></li> <li><code>~data.processors.utils.Sst2Processor</code></li> <li><code>~data.processors.utils.StsbProcessor</code></li> <li><code>~data.processors.utils.QqpProcessor</code></li> <li><code>~data.processors.utils.QnliProcessor</code></li> <li><code>~data.processors.utils.RteProcessor</code></li> <li><code>~data.processors.utils.WnliProcessor</code></li>",xr,De,Ea='此外，还可以使用以下方法从数据文件加载值并将其转换为 <a href="/docs/transformers/main/zh/main_classes/processors#transformers.InputExample">InputExample</a> 列表。',$r,N,Ge,Ys,St,Ha="Loads a data file into a list of <code>InputFeatures</code>",br,Re,yr,We,Na='<a href="https://www.nyu.edu/projects/bowman/xnli/" rel="nofollow">跨语言NLI语料库（XNLI）</a> 是一个评估跨语言文本表示质量的基准测试。XNLI是一个基于<a href="http://www.nyu.edu/projects/bowman/multinli/" rel="nofollow"><em>MultiNLI</em></a>的众包数据集：”文本对“被标记为包含15种不同语言（包括英语等高资源语言和斯瓦希里语等低资源语言）的文本蕴涵注释。',Mr,Qe,Ba='它与论文 <a href="https://arxiv.org/abs/1809.05053" rel="nofollow">XNLI: Evaluating Cross-lingual Sentence Representations</a> 一同发布。',wr,Ye,Fa="该库提供了加载XNLI数据的processor：",Tr,Ae,Sa="<li><code>~data.processors.utils.XnliProcessor</code></li>",Cr,Oe,Da="请注意，由于测试集上有“gold”标签，因此评估是在测试集上进行的。",Pr,Ke,Ga='使用这些processor的示例在 <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/text-classification/run_xnli.py" rel="nofollow">run_xnli.py</a> 脚本中提供。',Ir,et,Xr,tt,Ra='<a href="https://rajpurkar.github.io/SQuAD-explorer//" rel="nofollow">斯坦福问答数据集（SQuAD）</a> 是一个评估模型在问答上性能的基准测试。有两个版本，v1.1 和 v2.0。第一个版本（v1.1）与论文 <a href="https://arxiv.org/abs/1606.05250" rel="nofollow">SQuAD: 100,000+ Questions for Machine Comprehension of Text</a> 一同发布。第二个版本（v2.0）与论文 <a href="https://arxiv.org/abs/1806.03822" rel="nofollow">Know What You Don’t Know: Unanswerable Questions for SQuAD</a> 一同发布。',kr,rt,Wa="该库为两个版本各自提供了一个processor：",Jr,st,Ur,at,Qa="这两个processor是：",Zr,ot,Ya="<li><code>~data.processors.utils.SquadV1Processor</code></li> <li><code>~data.processors.utils.SquadV2Processor</code></li>",Lr,nt,Aa="它们都继承自抽象类 <code>~data.processors.utils.SquadProcessor</code>。",jr,k,lt,As,Dt,Oa=`Processor for the SQuAD data set. overridden by SquadV1Processor and SquadV2Processor, used by the version 1.1 and
version 2.0 of SQuAD, respectively.`,Os,ie,it,Ks,Gt,Ka="Returns the evaluation example from the data directory.",ea,E,mt,ta,Rt,eo="Creates a list of <code>SquadExample</code> using a TFDS dataset.",ra,me,sa,de,dt,aa,Wt,to="Returns the training examples from the data directory.",zr,ct,ro="此外，可以使用以下方法将 SQuAD 示例转换为可用作模型输入的 <code>~data.processors.utils.SquadFeatures</code>。",Vr,L,pt,oa,Qt,so=`Converts a list of examples into a list of features that can be directly given as input to a model. It is
model-dependant and takes advantage of many of the tokenizer’s features to create the model’s inputs.`,na,ce,qr,ft,ao="这些processor以及前面提到的方法可以与包含数据的文件以及tensorflow_datasets包一起使用。下面给出了示例。",Er,ut,Hr,ht,oo="以下是使用processor以及使用数据文件的转换方法的示例：",Nr,gt,Br,_t,no="使用 <em>tensorflow_datasets</em> 就像使用数据文件一样简单：",Fr,vt,Sr,xt,lo='另一个使用这些processor的示例在 <a href="https://github.com/huggingface/transformers/tree/main/examples/legacy/question-answering/run_squad.py" rel="nofollow">run_squad.py</a> 脚本中提供。',Dr,$t,Gr,rr,Rr;return C=new pe({props:{title:"Processors",local:"processors",headingTag:"h1"}}),ue=new pe({props:{title:"多模态processors",local:"transformers.ProcessorMixin",headingTag:"h2"}}),_e=new M({props:{name:"class transformers.ProcessorMixin",anchor:"transformers.ProcessorMixin",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/processing_utils.py#L56"}}),ve=new M({props:{name:"from_args_and_dict",anchor:"transformers.ProcessorMixin.from_args_and_dict",parameters:[{name:"args",val:""},{name:"processor_dict",val:": Dict"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.from_args_and_dict.processor_dict",description:`<strong>processor_dict</strong> (<code>Dict[str, Any]</code>) &#x2014;
Dictionary that will be used to instantiate the processor object. Such a dictionary can be
retrieved from a pretrained checkpoint by leveraging the
<code>~processing_utils.ProcessingMixin.to_dict</code> method.`,name:"processor_dict"},{anchor:"transformers.ProcessorMixin.from_args_and_dict.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>) &#x2014;
Additional parameters from which to initialize the processor object.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/processing_utils.py#L365",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processor object instantiated from those
parameters.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~processing_utils.ProcessingMixin</code></p>
`}}),xe=new M({props:{name:"from_pretrained",anchor:"transformers.ProcessorMixin.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:": Union"},{name:"cache_dir",val:": Union = None"},{name:"force_download",val:": bool = False"},{name:"local_files_only",val:": bool = False"},{name:"token",val:": Union = None"},{name:"revision",val:": str = 'main'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
This can be either:</p>
<ul>
<li>a string, the <em>model id</em> of a pretrained feature_extractor hosted inside a model repo on
huggingface.co.</li>
<li>a path to a <em>directory</em> containing a feature extractor file saved using the
<a href="/docs/transformers/main/zh/main_classes/feature_extractor#transformers.FeatureExtractionMixin.save_pretrained">save_pretrained()</a> method, e.g., <code>./my_model_directory/</code>.</li>
<li>a path or url to a saved feature extractor JSON <em>file</em>, e.g.,
<code>./my_model_directory/preprocessor_config.json</code>.
**kwargs &#x2014;
Additional keyword arguments passed along to both
<a href="/docs/transformers/main/zh/main_classes/feature_extractor#transformers.FeatureExtractionMixin.from_pretrained">from_pretrained()</a> and
<code>~tokenization_utils_base.PreTrainedTokenizer.from_pretrained</code>.</li>
</ul>`,name:"pretrained_model_name_or_path"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/processing_utils.py#L406"}}),G=new la({props:{$$slots:{default:[ho]},$$scope:{ctx:J}}}),$e=new M({props:{name:"get_processor_dict",anchor:"transformers.ProcessorMixin.get_processor_dict",parameters:[{name:"pretrained_model_name_or_path",val:": Union"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.get_processor_dict.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
The identifier of the pre-trained checkpoint from which we want the dictionary of parameters.`,name:"pretrained_model_name_or_path"},{anchor:"transformers.ProcessorMixin.get_processor_dict.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
In case the relevant files are located inside a subfolder of the model repo on huggingface.co, you can
specify the folder name here.`,name:"subfolder"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/processing_utils.py#L256",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The dictionary(ies) that will be used to instantiate the processor object.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Tuple[Dict, Dict]</code></p>
`}}),be=new M({props:{name:"push_to_hub",anchor:"transformers.ProcessorMixin.push_to_hub",parameters:[{name:"repo_id",val:": str"},{name:"use_temp_dir",val:": Optional = None"},{name:"commit_message",val:": Optional = None"},{name:"private",val:": Optional = None"},{name:"token",val:": Union = None"},{name:"max_shard_size",val:": Union = '5GB'"},{name:"create_pr",val:": bool = False"},{name:"safe_serialization",val:": bool = True"},{name:"revision",val:": str = None"},{name:"commit_description",val:": str = None"},{name:"tags",val:": Optional = None"},{name:"**deprecated_kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.push_to_hub.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The name of the repository you want to push your processor to. It should contain your organization name
when pushing to a given organization.`,name:"repo_id"},{anchor:"transformers.ProcessorMixin.push_to_hub.use_temp_dir",description:`<strong>use_temp_dir</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to use a temporary directory to store the files saved before they are pushed to the Hub.
Will default to <code>True</code> if there is no directory named like <code>repo_id</code>, <code>False</code> otherwise.`,name:"use_temp_dir"},{anchor:"transformers.ProcessorMixin.push_to_hub.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Message to commit while pushing. Will default to <code>&quot;Upload processor&quot;</code>.`,name:"commit_message"},{anchor:"transformers.ProcessorMixin.push_to_hub.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not the repository created should be private.`,name:"private"},{anchor:"transformers.ProcessorMixin.push_to_hub.token",description:`<strong>token</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, will use the token generated
when running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>). Will default to <code>True</code> if <code>repo_url</code>
is not specified.`,name:"token"},{anchor:"transformers.ProcessorMixin.push_to_hub.max_shard_size",description:`<strong>max_shard_size</strong> (<code>int</code> or <code>str</code>, <em>optional</em>, defaults to <code>&quot;5GB&quot;</code>) &#x2014;
Only applicable for models. The maximum size for a checkpoint before being sharded. Checkpoints shard
will then be each of size lower than this size. If expressed as a string, needs to be digits followed
by a unit (like <code>&quot;5MB&quot;</code>). We default it to <code>&quot;5GB&quot;</code> so that users can easily load models on free-tier
Google Colab instances without any CPU OOM issues.`,name:"max_shard_size"},{anchor:"transformers.ProcessorMixin.push_to_hub.create_pr",description:`<strong>create_pr</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to create a PR with the uploaded files or directly commit.`,name:"create_pr"},{anchor:"transformers.ProcessorMixin.push_to_hub.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to convert the model weights in safetensors format for safer serialization.`,name:"safe_serialization"},{anchor:"transformers.ProcessorMixin.push_to_hub.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Branch to push the uploaded files to.`,name:"revision"},{anchor:"transformers.ProcessorMixin.push_to_hub.commit_description",description:`<strong>commit_description</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The description of the commit that will be created`,name:"commit_description"},{anchor:"transformers.ProcessorMixin.push_to_hub.tags",description:`<strong>tags</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
List of tags to push on the Hub.`,name:"tags"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/utils/hub.py#L770"}}),W=new ia({props:{anchor:"transformers.ProcessorMixin.push_to_hub.example",$$slots:{default:[go]},$$scope:{ctx:J}}}),ye=new M({props:{name:"register_for_auto_class",anchor:"transformers.ProcessorMixin.register_for_auto_class",parameters:[{name:"auto_class",val:" = 'AutoProcessor'"}],parametersDescription:[{anchor:"transformers.ProcessorMixin.register_for_auto_class.auto_class",description:`<strong>auto_class</strong> (<code>str</code> or <code>type</code>, <em>optional</em>, defaults to <code>&quot;AutoProcessor&quot;</code>) &#x2014;
The auto class to register this new feature extractor with.`,name:"auto_class"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/processing_utils.py#L470"}}),Q=new la({props:{warning:!0,$$slots:{default:[_o]},$$scope:{ctx:J}}}),Me=new M({props:{name:"save_pretrained",anchor:"transformers.ProcessorMixin.save_pretrained",parameters:[{name:"save_directory",val:""},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory where the feature extractor JSON file and the tokenizer files will be saved (directory will
be created if it does not exist).`,name:"save_directory"},{anchor:"transformers.ProcessorMixin.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"transformers.ProcessorMixin.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional key word arguments passed along to the <a href="/docs/transformers/main/zh/main_classes/model#transformers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/processing_utils.py#L167"}}),Y=new la({props:{$$slots:{default:[vo]},$$scope:{ctx:J}}}),we=new M({props:{name:"to_dict",anchor:"transformers.ProcessorMixin.to_dict",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/processing_utils.py#L102",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary of all the attributes that make up this processor instance.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, Any]</code></p>
`}}),Te=new M({props:{name:"to_json_file",anchor:"transformers.ProcessorMixin.to_json_file",parameters:[{name:"json_file_path",val:": Union"}],parametersDescription:[{anchor:"transformers.ProcessorMixin.to_json_file.json_file_path",description:`<strong>json_file_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Path to the JSON file in which this processor instance&#x2019;s parameters will be saved.`,name:"json_file_path"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/processing_utils.py#L151"}}),Ce=new M({props:{name:"to_json_string",anchor:"transformers.ProcessorMixin.to_json_string",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/processing_utils.py#L140",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>String containing all the attributes that make up this feature_extractor instance in JSON format.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`}}),Pe=new pe({props:{title:"已弃用的processors",local:"transformers.DataProcessor",headingTag:"h2"}}),Xe=new M({props:{name:"class transformers.DataProcessor",anchor:"transformers.DataProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/utils.py#L80"}}),ke=new M({props:{name:"get_dev_examples",anchor:"transformers.DataProcessor.get_dev_examples",parameters:[{name:"data_dir",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/utils.py#L97"}}),Je=new M({props:{name:"get_example_from_tensor_dict",anchor:"transformers.DataProcessor.get_example_from_tensor_dict",parameters:[{name:"tensor_dict",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/utils.py#L83"}}),Ue=new M({props:{name:"get_labels",anchor:"transformers.DataProcessor.get_labels",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/utils.py#L105"}}),Ze=new M({props:{name:"get_test_examples",anchor:"transformers.DataProcessor.get_test_examples",parameters:[{name:"data_dir",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/utils.py#L101"}}),Le=new M({props:{name:"get_train_examples",anchor:"transformers.DataProcessor.get_train_examples",parameters:[{name:"data_dir",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/utils.py#L93"}}),je=new M({props:{name:"tfds_map",anchor:"transformers.DataProcessor.tfds_map",parameters:[{name:"example",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/utils.py#L109"}}),ze=new M({props:{name:"class transformers.InputExample",anchor:"transformers.InputExample",parameters:[{name:"guid",val:": str"},{name:"text_a",val:": str"},{name:"text_b",val:": Optional = None"},{name:"label",val:": Optional = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/utils.py#L29"}}),Ve=new M({props:{name:"to_json_string",anchor:"transformers.InputExample.to_json_string",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/utils.py#L49"}}),qe=new M({props:{name:"class transformers.InputFeatures",anchor:"transformers.InputFeatures",parameters:[{name:"input_ids",val:": List"},{name:"attention_mask",val:": Optional = None"},{name:"token_type_ids",val:": Optional = None"},{name:"label",val:": Union = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/utils.py#L54"}}),Ee=new M({props:{name:"to_json_string",anchor:"transformers.InputFeatures.to_json_string",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/utils.py#L75"}}),He=new pe({props:{title:"GLUE",local:"transformers.glue_convert_examples_to_features",headingTag:"h2"}}),Ge=new M({props:{name:"transformers.glue_convert_examples_to_features",anchor:"transformers.glue_convert_examples_to_features",parameters:[{name:"examples",val:": Union"},{name:"tokenizer",val:": PreTrainedTokenizer"},{name:"max_length",val:": Optional = None"},{name:"task",val:" = None"},{name:"label_list",val:" = None"},{name:"output_mode",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/glue.py#L41",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If the <code>examples</code> input is a <code>tf.data.Dataset</code>, will return a <code>tf.data.Dataset</code> containing the task-specific
features. If the input is a list of <code>InputExamples</code>, will return a list of task-specific <code>InputFeatures</code> which
can be fed to the model.</p>
`}}),Re=new pe({props:{title:"XNLI",local:"xnli",headingTag:"h2"}}),et=new pe({props:{title:"SQuAD",local:"squad",headingTag:"h2"}}),st=new pe({props:{title:"Processors",local:"transformers.data.processors.squad.SquadProcessor",headingTag:"h3"}}),lt=new M({props:{name:"class transformers.data.processors.squad.SquadProcessor",anchor:"transformers.data.processors.squad.SquadProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/squad.py#L541"}}),it=new M({props:{name:"get_dev_examples",anchor:"transformers.data.processors.squad.SquadProcessor.get_dev_examples",parameters:[{name:"data_dir",val:""},{name:"filename",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/squad.py#L629"}}),mt=new M({props:{name:"get_examples_from_dataset",anchor:"transformers.data.processors.squad.SquadProcessor.get_examples_from_dataset",parameters:[{name:"dataset",val:""},{name:"evaluate",val:" = False"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/squad.py#L574",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of SquadExample</p>
`}}),me=new ia({props:{anchor:"transformers.data.processors.squad.SquadProcessor.get_examples_from_dataset.example",$$slots:{default:[xo]},$$scope:{ctx:J}}}),dt=new M({props:{name:"get_train_examples",anchor:"transformers.data.processors.squad.SquadProcessor.get_train_examples",parameters:[{name:"data_dir",val:""},{name:"filename",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/squad.py#L607"}}),pt=new M({props:{name:"transformers.squad_convert_examples_to_features",anchor:"transformers.squad_convert_examples_to_features",parameters:[{name:"examples",val:""},{name:"tokenizer",val:""},{name:"max_seq_length",val:""},{name:"doc_stride",val:""},{name:"max_query_length",val:""},{name:"is_training",val:""},{name:"padding_strategy",val:" = 'max_length'"},{name:"return_dataset",val:" = False"},{name:"threads",val:" = 1"},{name:"tqdm_enabled",val:" = True"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/squad.py#L316",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>list of <code>SquadFeatures</code></p>
`}}),ce=new ia({props:{anchor:"transformers.squad_convert_examples_to_features.example",$$slots:{default:[$o]},$$scope:{ctx:J}}}),ut=new pe({props:{title:"Example使用",local:"example使用",headingTag:"h3"}}),gt=new sr({props:{code:"JTIzJTIwTG9hZGluZyUyMGElMjBWMiUyMHByb2Nlc3NvciUwQXByb2Nlc3NvciUyMCUzRCUyMFNxdWFkVjJQcm9jZXNzb3IoKSUwQWV4YW1wbGVzJTIwJTNEJTIwcHJvY2Vzc29yLmdldF9kZXZfZXhhbXBsZXMoc3F1YWRfdjJfZGF0YV9kaXIpJTBBJTBBJTIzJTIwTG9hZGluZyUyMGElMjBWMSUyMHByb2Nlc3NvciUwQXByb2Nlc3NvciUyMCUzRCUyMFNxdWFkVjFQcm9jZXNzb3IoKSUwQWV4YW1wbGVzJTIwJTNEJTIwcHJvY2Vzc29yLmdldF9kZXZfZXhhbXBsZXMoc3F1YWRfdjFfZGF0YV9kaXIpJTBBJTBBZmVhdHVyZXMlMjAlM0QlMjBzcXVhZF9jb252ZXJ0X2V4YW1wbGVzX3RvX2ZlYXR1cmVzKCUwQSUyMCUyMCUyMCUyMGV4YW1wbGVzJTNEZXhhbXBsZXMlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEElMjAlMjAlMjAlMjBtYXhfc2VxX2xlbmd0aCUzRG1heF9zZXFfbGVuZ3RoJTJDJTBBJTIwJTIwJTIwJTIwZG9jX3N0cmlkZSUzRGFyZ3MuZG9jX3N0cmlkZSUyQyUwQSUyMCUyMCUyMCUyMG1heF9xdWVyeV9sZW5ndGglM0RtYXhfcXVlcnlfbGVuZ3RoJTJDJTBBJTIwJTIwJTIwJTIwaXNfdHJhaW5pbmclM0Rub3QlMjBldmFsdWF0ZSUyQyUwQSk=",highlighted:`<span class="hljs-comment"># Loading a V2 processor</span>
processor = SquadV2Processor()
examples = processor.get_dev_examples(squad_v2_data_dir)

<span class="hljs-comment"># Loading a V1 processor</span>
processor = SquadV1Processor()
examples = processor.get_dev_examples(squad_v1_data_dir)

features = squad_convert_examples_to_features(
    examples=examples,
    tokenizer=tokenizer,
    max_seq_length=max_seq_length,
    doc_stride=args.doc_stride,
    max_query_length=max_query_length,
    is_training=<span class="hljs-keyword">not</span> evaluate,
)`,wrap:!1}}),vt=new sr({props:{code:"JTIzJTIwdGVuc29yZmxvd19kYXRhc2V0cyUyMG9ubHklMjBoYW5kbGUlMjBTcXVhZCUyMFYxLiUwQXRmZHNfZXhhbXBsZXMlMjAlM0QlMjB0ZmRzLmxvYWQoJTIyc3F1YWQlMjIpJTBBZXhhbXBsZXMlMjAlM0QlMjBTcXVhZFYxUHJvY2Vzc29yKCkuZ2V0X2V4YW1wbGVzX2Zyb21fZGF0YXNldCh0ZmRzX2V4YW1wbGVzJTJDJTIwZXZhbHVhdGUlM0RldmFsdWF0ZSklMEElMEFmZWF0dXJlcyUyMCUzRCUyMHNxdWFkX2NvbnZlcnRfZXhhbXBsZXNfdG9fZmVhdHVyZXMoJTBBJTIwJTIwJTIwJTIwZXhhbXBsZXMlM0RleGFtcGxlcyUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMG1heF9zZXFfbGVuZ3RoJTNEbWF4X3NlcV9sZW5ndGglMkMlMEElMjAlMjAlMjAlMjBkb2Nfc3RyaWRlJTNEYXJncy5kb2Nfc3RyaWRlJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3F1ZXJ5X2xlbmd0aCUzRG1heF9xdWVyeV9sZW5ndGglMkMlMEElMjAlMjAlMjAlMjBpc190cmFpbmluZyUzRG5vdCUyMGV2YWx1YXRlJTJDJTBBKQ==",highlighted:`<span class="hljs-comment"># tensorflow_datasets only handle Squad V1.</span>
tfds_examples = tfds.load(<span class="hljs-string">&quot;squad&quot;</span>)
examples = SquadV1Processor().get_examples_from_dataset(tfds_examples, evaluate=evaluate)

features = squad_convert_examples_to_features(
    examples=examples,
    tokenizer=tokenizer,
    max_seq_length=max_seq_length,
    doc_stride=args.doc_stride,
    max_query_length=max_query_length,
    is_training=<span class="hljs-keyword">not</span> evaluate,
)`,wrap:!1}}),$t=new uo({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/zh/main_classes/processors.md"}}),{c(){d=l("meta"),T=s(),v=l("p"),x=s(),p(C.$$.fragment),c=s(),I=l("p"),I.textContent=ma,ar=s(),fe=l("ul"),fe.innerHTML=da,or=s(),p(ue.$$.fragment),nr=s(),he=l("p"),he.textContent=ca,lr=s(),ge=l("p"),ge.textContent=pa,ir=s(),y=l("div"),p(_e.$$.fragment),is=s(),Mt=l("p"),Mt.textContent=fa,ms=s(),D=l("div"),p(ve.$$.fragment),ds=s(),wt=l("p"),wt.innerHTML=ua,cs=s(),j=l("div"),p(xe.$$.fragment),ps=s(),Tt=l("p"),Tt.textContent=ha,fs=s(),p(G.$$.fragment),us=s(),R=l("div"),p($e.$$.fragment),hs=s(),Ct=l("p"),Ct.innerHTML=ga,gs=s(),z=l("div"),p(be.$$.fragment),_s=s(),Pt=l("p"),Pt.textContent=_a,vs=s(),p(W.$$.fragment),xs=s(),V=l("div"),p(ye.$$.fragment),$s=s(),It=l("p"),It.innerHTML=va,bs=s(),p(Q.$$.fragment),ys=s(),q=l("div"),p(Me.$$.fragment),Ms=s(),Xt=l("p"),Xt.innerHTML=xa,ws=s(),p(Y.$$.fragment),Ts=s(),A=l("div"),p(we.$$.fragment),Cs=s(),kt=l("p"),kt.textContent=$a,Ps=s(),O=l("div"),p(Te.$$.fragment),Is=s(),Jt=l("p"),Jt.textContent=ba,Xs=s(),K=l("div"),p(Ce.$$.fragment),ks=s(),Ut=l("p"),Ut.textContent=ya,mr=s(),p(Pe.$$.fragment),dr=s(),Ie=l("p"),Ie.innerHTML=Ma,cr=s(),P=l("div"),p(Xe.$$.fragment),Js=s(),Zt=l("p"),Zt.textContent=wa,Us=s(),ee=l("div"),p(ke.$$.fragment),Zs=s(),Lt=l("p"),Lt.innerHTML=Ta,Ls=s(),te=l("div"),p(Je.$$.fragment),js=s(),jt=l("p"),jt.textContent=Ca,zs=s(),re=l("div"),p(Ue.$$.fragment),Vs=s(),zt=l("p"),zt.textContent=Pa,qs=s(),se=l("div"),p(Ze.$$.fragment),Es=s(),Vt=l("p"),Vt.innerHTML=Ia,Hs=s(),ae=l("div"),p(Le.$$.fragment),Ns=s(),qt=l("p"),qt.innerHTML=Xa,Bs=s(),oe=l("div"),p(je.$$.fragment),Fs=s(),Et=l("p"),Et.textContent=ka,pr=s(),U=l("div"),p(ze.$$.fragment),Ss=s(),Ht=l("p"),Ht.textContent=Ja,Ds=s(),ne=l("div"),p(Ve.$$.fragment),Gs=s(),Nt=l("p"),Nt.textContent=Ua,fr=s(),Z=l("div"),p(qe.$$.fragment),Rs=s(),Bt=l("p"),Bt.textContent=Za,Ws=s(),le=l("div"),p(Ee.$$.fragment),Qs=s(),Ft=l("p"),Ft.textContent=La,ur=s(),p(He.$$.fragment),hr=s(),Ne=l("p"),Ne.innerHTML=ja,gr=s(),Be=l("p"),Be.textContent=za,_r=s(),Fe=l("p"),Fe.textContent=Va,vr=s(),Se=l("ul"),Se.innerHTML=qa,xr=s(),De=l("p"),De.innerHTML=Ea,$r=s(),N=l("div"),p(Ge.$$.fragment),Ys=s(),St=l("p"),St.innerHTML=Ha,br=s(),p(Re.$$.fragment),yr=s(),We=l("p"),We.innerHTML=Na,Mr=s(),Qe=l("p"),Qe.innerHTML=Ba,wr=s(),Ye=l("p"),Ye.textContent=Fa,Tr=s(),Ae=l("ul"),Ae.innerHTML=Sa,Cr=s(),Oe=l("p"),Oe.textContent=Da,Pr=s(),Ke=l("p"),Ke.innerHTML=Ga,Ir=s(),p(et.$$.fragment),Xr=s(),tt=l("p"),tt.innerHTML=Ra,kr=s(),rt=l("p"),rt.textContent=Wa,Jr=s(),p(st.$$.fragment),Ur=s(),at=l("p"),at.textContent=Qa,Zr=s(),ot=l("ul"),ot.innerHTML=Ya,Lr=s(),nt=l("p"),nt.innerHTML=Aa,jr=s(),k=l("div"),p(lt.$$.fragment),As=s(),Dt=l("p"),Dt.textContent=Oa,Os=s(),ie=l("div"),p(it.$$.fragment),Ks=s(),Gt=l("p"),Gt.textContent=Ka,ea=s(),E=l("div"),p(mt.$$.fragment),ta=s(),Rt=l("p"),Rt.innerHTML=eo,ra=s(),p(me.$$.fragment),sa=s(),de=l("div"),p(dt.$$.fragment),aa=s(),Wt=l("p"),Wt.textContent=to,zr=s(),ct=l("p"),ct.innerHTML=ro,Vr=s(),L=l("div"),p(pt.$$.fragment),oa=s(),Qt=l("p"),Qt.textContent=so,na=s(),p(ce.$$.fragment),qr=s(),ft=l("p"),ft.textContent=ao,Er=s(),p(ut.$$.fragment),Hr=s(),ht=l("p"),ht.textContent=oo,Nr=s(),p(gt.$$.fragment),Br=s(),_t=l("p"),_t.innerHTML=no,Fr=s(),p(vt.$$.fragment),Sr=s(),xt=l("p"),xt.innerHTML=lo,Dr=s(),p($t.$$.fragment),Gr=s(),rr=l("p"),this.h()},l(e){const r=fo("svelte-u9bgzb",document.head);d=i(r,"META",{name:!0,content:!0}),r.forEach(t),T=a(e),v=i(e,"P",{}),$(v).forEach(t),x=a(e),f(C.$$.fragment,e),c=a(e),I=i(e,"P",{"data-svelte-h":!0}),m(I)!=="svelte-1fd9lf0"&&(I.textContent=ma),ar=a(e),fe=i(e,"UL",{"data-svelte-h":!0}),m(fe)!=="svelte-rmvfpp"&&(fe.innerHTML=da),or=a(e),f(ue.$$.fragment,e),nr=a(e),he=i(e,"P",{"data-svelte-h":!0}),m(he)!=="svelte-ctzpmo"&&(he.textContent=ca),lr=a(e),ge=i(e,"P",{"data-svelte-h":!0}),m(ge)!=="svelte-9fh2y4"&&(ge.textContent=pa),ir=a(e),y=i(e,"DIV",{class:!0});var w=$(y);f(_e.$$.fragment,w),is=a(w),Mt=i(w,"P",{"data-svelte-h":!0}),m(Mt)!=="svelte-1s4wckx"&&(Mt.textContent=fa),ms=a(w),D=i(w,"DIV",{class:!0});var bt=$(D);f(ve.$$.fragment,bt),ds=a(bt),wt=i(bt,"P",{"data-svelte-h":!0}),m(wt)!=="svelte-1i2d3vx"&&(wt.innerHTML=ua),bt.forEach(t),cs=a(w),j=i(w,"DIV",{class:!0});var B=$(j);f(xe.$$.fragment,B),ps=a(B),Tt=i(B,"P",{"data-svelte-h":!0}),m(Tt)!=="svelte-1cj8dcb"&&(Tt.textContent=ha),fs=a(B),f(G.$$.fragment,B),B.forEach(t),us=a(w),R=i(w,"DIV",{class:!0});var yt=$(R);f($e.$$.fragment,yt),hs=a(yt),Ct=i(yt,"P",{"data-svelte-h":!0}),m(Ct)!=="svelte-hsvutq"&&(Ct.innerHTML=ga),yt.forEach(t),gs=a(w),z=i(w,"DIV",{class:!0});var F=$(z);f(be.$$.fragment,F),_s=a(F),Pt=i(F,"P",{"data-svelte-h":!0}),m(Pt)!=="svelte-1cwsjho"&&(Pt.textContent=_a),vs=a(F),f(W.$$.fragment,F),F.forEach(t),xs=a(w),V=i(w,"DIV",{class:!0});var S=$(V);f(ye.$$.fragment,S),$s=a(S),It=i(S,"P",{"data-svelte-h":!0}),m(It)!=="svelte-hhsvto"&&(It.innerHTML=va),bs=a(S),f(Q.$$.fragment,S),S.forEach(t),ys=a(w),q=i(w,"DIV",{class:!0});var Yt=$(q);f(Me.$$.fragment,Yt),Ms=a(Yt),Xt=i(Yt,"P",{"data-svelte-h":!0}),m(Xt)!=="svelte-wdcnpg"&&(Xt.innerHTML=xa),ws=a(Yt),f(Y.$$.fragment,Yt),Yt.forEach(t),Ts=a(w),A=i(w,"DIV",{class:!0});var Wr=$(A);f(we.$$.fragment,Wr),Cs=a(Wr),kt=i(Wr,"P",{"data-svelte-h":!0}),m(kt)!=="svelte-1ww3wqq"&&(kt.textContent=$a),Wr.forEach(t),Ps=a(w),O=i(w,"DIV",{class:!0});var Qr=$(O);f(Te.$$.fragment,Qr),Is=a(Qr),Jt=i(Qr,"P",{"data-svelte-h":!0}),m(Jt)!=="svelte-1g70y32"&&(Jt.textContent=ba),Qr.forEach(t),Xs=a(w),K=i(w,"DIV",{class:!0});var Yr=$(K);f(Ce.$$.fragment,Yr),ks=a(Yr),Ut=i(Yr,"P",{"data-svelte-h":!0}),m(Ut)!=="svelte-5ayq1f"&&(Ut.textContent=ya),Yr.forEach(t),w.forEach(t),mr=a(e),f(Pe.$$.fragment,e),dr=a(e),Ie=i(e,"P",{"data-svelte-h":!0}),m(Ie)!=="svelte-1gqc2ou"&&(Ie.innerHTML=Ma),cr=a(e),P=i(e,"DIV",{class:!0});var X=$(P);f(Xe.$$.fragment,X),Js=a(X),Zt=i(X,"P",{"data-svelte-h":!0}),m(Zt)!=="svelte-1bsw04k"&&(Zt.textContent=wa),Us=a(X),ee=i(X,"DIV",{class:!0});var Ar=$(ee);f(ke.$$.fragment,Ar),Zs=a(Ar),Lt=i(Ar,"P",{"data-svelte-h":!0}),m(Lt)!=="svelte-i9v8dv"&&(Lt.innerHTML=Ta),Ar.forEach(t),Ls=a(X),te=i(X,"DIV",{class:!0});var Or=$(te);f(Je.$$.fragment,Or),js=a(Or),jt=i(Or,"P",{"data-svelte-h":!0}),m(jt)!=="svelte-pplryq"&&(jt.textContent=Ca),Or.forEach(t),zs=a(X),re=i(X,"DIV",{class:!0});var Kr=$(re);f(Ue.$$.fragment,Kr),Vs=a(Kr),zt=i(Kr,"P",{"data-svelte-h":!0}),m(zt)!=="svelte-3oqyjr"&&(zt.textContent=Pa),Kr.forEach(t),qs=a(X),se=i(X,"DIV",{class:!0});var es=$(se);f(Ze.$$.fragment,es),Es=a(es),Vt=i(es,"P",{"data-svelte-h":!0}),m(Vt)!=="svelte-1f447o"&&(Vt.innerHTML=Ia),es.forEach(t),Hs=a(X),ae=i(X,"DIV",{class:!0});var ts=$(ae);f(Le.$$.fragment,ts),Ns=a(ts),qt=i(ts,"P",{"data-svelte-h":!0}),m(qt)!=="svelte-n3qvn6"&&(qt.innerHTML=Xa),ts.forEach(t),Bs=a(X),oe=i(X,"DIV",{class:!0});var rs=$(oe);f(je.$$.fragment,rs),Fs=a(rs),Et=i(rs,"P",{"data-svelte-h":!0}),m(Et)!=="svelte-1jevh15"&&(Et.textContent=ka),rs.forEach(t),X.forEach(t),pr=a(e),U=i(e,"DIV",{class:!0});var At=$(U);f(ze.$$.fragment,At),Ss=a(At),Ht=i(At,"P",{"data-svelte-h":!0}),m(Ht)!=="svelte-vkt0pi"&&(Ht.textContent=Ja),Ds=a(At),ne=i(At,"DIV",{class:!0});var ss=$(ne);f(Ve.$$.fragment,ss),Gs=a(ss),Nt=i(ss,"P",{"data-svelte-h":!0}),m(Nt)!=="svelte-5ayq1f"&&(Nt.textContent=Ua),ss.forEach(t),At.forEach(t),fr=a(e),Z=i(e,"DIV",{class:!0});var Ot=$(Z);f(qe.$$.fragment,Ot),Rs=a(Ot),Bt=i(Ot,"P",{"data-svelte-h":!0}),m(Bt)!=="svelte-168wf64"&&(Bt.textContent=Za),Ws=a(Ot),le=i(Ot,"DIV",{class:!0});var as=$(le);f(Ee.$$.fragment,as),Qs=a(as),Ft=i(as,"P",{"data-svelte-h":!0}),m(Ft)!=="svelte-5ayq1f"&&(Ft.textContent=La),as.forEach(t),Ot.forEach(t),ur=a(e),f(He.$$.fragment,e),hr=a(e),Ne=i(e,"P",{"data-svelte-h":!0}),m(Ne)!=="svelte-pf4p60"&&(Ne.innerHTML=ja),gr=a(e),Be=i(e,"P",{"data-svelte-h":!0}),m(Be)!=="svelte-17867sm"&&(Be.textContent=za),_r=a(e),Fe=i(e,"P",{"data-svelte-h":!0}),m(Fe)!=="svelte-190jb0p"&&(Fe.textContent=Va),vr=a(e),Se=i(e,"UL",{"data-svelte-h":!0}),m(Se)!=="svelte-my8qym"&&(Se.innerHTML=qa),xr=a(e),De=i(e,"P",{"data-svelte-h":!0}),m(De)!=="svelte-f7vo7d"&&(De.innerHTML=Ea),$r=a(e),N=i(e,"DIV",{class:!0});var os=$(N);f(Ge.$$.fragment,os),Ys=a(os),St=i(os,"P",{"data-svelte-h":!0}),m(St)!=="svelte-5lvrve"&&(St.innerHTML=Ha),os.forEach(t),br=a(e),f(Re.$$.fragment,e),yr=a(e),We=i(e,"P",{"data-svelte-h":!0}),m(We)!=="svelte-143feg"&&(We.innerHTML=Na),Mr=a(e),Qe=i(e,"P",{"data-svelte-h":!0}),m(Qe)!=="svelte-1y5f8bi"&&(Qe.innerHTML=Ba),wr=a(e),Ye=i(e,"P",{"data-svelte-h":!0}),m(Ye)!=="svelte-1n6xg4v"&&(Ye.textContent=Fa),Tr=a(e),Ae=i(e,"UL",{"data-svelte-h":!0}),m(Ae)!=="svelte-1e2xq99"&&(Ae.innerHTML=Sa),Cr=a(e),Oe=i(e,"P",{"data-svelte-h":!0}),m(Oe)!=="svelte-1514ut0"&&(Oe.textContent=Da),Pr=a(e),Ke=i(e,"P",{"data-svelte-h":!0}),m(Ke)!=="svelte-18t4sjl"&&(Ke.innerHTML=Ga),Ir=a(e),f(et.$$.fragment,e),Xr=a(e),tt=i(e,"P",{"data-svelte-h":!0}),m(tt)!=="svelte-1cqsmed"&&(tt.innerHTML=Ra),kr=a(e),rt=i(e,"P",{"data-svelte-h":!0}),m(rt)!=="svelte-1hd0jdd"&&(rt.textContent=Wa),Jr=a(e),f(st.$$.fragment,e),Ur=a(e),at=i(e,"P",{"data-svelte-h":!0}),m(at)!=="svelte-utkcp6"&&(at.textContent=Qa),Zr=a(e),ot=i(e,"UL",{"data-svelte-h":!0}),m(ot)!=="svelte-1qiv3qf"&&(ot.innerHTML=Ya),Lr=a(e),nt=i(e,"P",{"data-svelte-h":!0}),m(nt)!=="svelte-165sa1k"&&(nt.innerHTML=Aa),jr=a(e),k=i(e,"DIV",{class:!0});var H=$(k);f(lt.$$.fragment,H),As=a(H),Dt=i(H,"P",{"data-svelte-h":!0}),m(Dt)!=="svelte-173gxyd"&&(Dt.textContent=Oa),Os=a(H),ie=i(H,"DIV",{class:!0});var ns=$(ie);f(it.$$.fragment,ns),Ks=a(ns),Gt=i(ns,"P",{"data-svelte-h":!0}),m(Gt)!=="svelte-wmaktk"&&(Gt.textContent=Ka),ns.forEach(t),ea=a(H),E=i(H,"DIV",{class:!0});var Kt=$(E);f(mt.$$.fragment,Kt),ta=a(Kt),Rt=i(Kt,"P",{"data-svelte-h":!0}),m(Rt)!=="svelte-11nqnea"&&(Rt.innerHTML=eo),ra=a(Kt),f(me.$$.fragment,Kt),Kt.forEach(t),sa=a(H),de=i(H,"DIV",{class:!0});var ls=$(de);f(dt.$$.fragment,ls),aa=a(ls),Wt=i(ls,"P",{"data-svelte-h":!0}),m(Wt)!=="svelte-d5zv1x"&&(Wt.textContent=to),ls.forEach(t),H.forEach(t),zr=a(e),ct=i(e,"P",{"data-svelte-h":!0}),m(ct)!=="svelte-7uap0d"&&(ct.innerHTML=ro),Vr=a(e),L=i(e,"DIV",{class:!0});var er=$(L);f(pt.$$.fragment,er),oa=a(er),Qt=i(er,"P",{"data-svelte-h":!0}),m(Qt)!=="svelte-169nh0g"&&(Qt.textContent=so),na=a(er),f(ce.$$.fragment,er),er.forEach(t),qr=a(e),ft=i(e,"P",{"data-svelte-h":!0}),m(ft)!=="svelte-1dp3thd"&&(ft.textContent=ao),Er=a(e),f(ut.$$.fragment,e),Hr=a(e),ht=i(e,"P",{"data-svelte-h":!0}),m(ht)!=="svelte-1tuty7g"&&(ht.textContent=oo),Nr=a(e),f(gt.$$.fragment,e),Br=a(e),_t=i(e,"P",{"data-svelte-h":!0}),m(_t)!=="svelte-1klp1tb"&&(_t.innerHTML=no),Fr=a(e),f(vt.$$.fragment,e),Sr=a(e),xt=i(e,"P",{"data-svelte-h":!0}),m(xt)!=="svelte-1mzejoo"&&(xt.innerHTML=lo),Dr=a(e),f($t.$$.fragment,e),Gr=a(e),rr=i(e,"P",{}),$(rr).forEach(t),this.h()},h(){b(d,"name","hf:doc:metadata"),b(d,"content",yo),b(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,r){o(document.head,d),n(e,T,r),n(e,v,r),n(e,x,r),u(C,e,r),n(e,c,r),n(e,I,r),n(e,ar,r),n(e,fe,r),n(e,or,r),u(ue,e,r),n(e,nr,r),n(e,he,r),n(e,lr,r),n(e,ge,r),n(e,ir,r),n(e,y,r),u(_e,y,null),o(y,is),o(y,Mt),o(y,ms),o(y,D),u(ve,D,null),o(D,ds),o(D,wt),o(y,cs),o(y,j),u(xe,j,null),o(j,ps),o(j,Tt),o(j,fs),u(G,j,null),o(y,us),o(y,R),u($e,R,null),o(R,hs),o(R,Ct),o(y,gs),o(y,z),u(be,z,null),o(z,_s),o(z,Pt),o(z,vs),u(W,z,null),o(y,xs),o(y,V),u(ye,V,null),o(V,$s),o(V,It),o(V,bs),u(Q,V,null),o(y,ys),o(y,q),u(Me,q,null),o(q,Ms),o(q,Xt),o(q,ws),u(Y,q,null),o(y,Ts),o(y,A),u(we,A,null),o(A,Cs),o(A,kt),o(y,Ps),o(y,O),u(Te,O,null),o(O,Is),o(O,Jt),o(y,Xs),o(y,K),u(Ce,K,null),o(K,ks),o(K,Ut),n(e,mr,r),u(Pe,e,r),n(e,dr,r),n(e,Ie,r),n(e,cr,r),n(e,P,r),u(Xe,P,null),o(P,Js),o(P,Zt),o(P,Us),o(P,ee),u(ke,ee,null),o(ee,Zs),o(ee,Lt),o(P,Ls),o(P,te),u(Je,te,null),o(te,js),o(te,jt),o(P,zs),o(P,re),u(Ue,re,null),o(re,Vs),o(re,zt),o(P,qs),o(P,se),u(Ze,se,null),o(se,Es),o(se,Vt),o(P,Hs),o(P,ae),u(Le,ae,null),o(ae,Ns),o(ae,qt),o(P,Bs),o(P,oe),u(je,oe,null),o(oe,Fs),o(oe,Et),n(e,pr,r),n(e,U,r),u(ze,U,null),o(U,Ss),o(U,Ht),o(U,Ds),o(U,ne),u(Ve,ne,null),o(ne,Gs),o(ne,Nt),n(e,fr,r),n(e,Z,r),u(qe,Z,null),o(Z,Rs),o(Z,Bt),o(Z,Ws),o(Z,le),u(Ee,le,null),o(le,Qs),o(le,Ft),n(e,ur,r),u(He,e,r),n(e,hr,r),n(e,Ne,r),n(e,gr,r),n(e,Be,r),n(e,_r,r),n(e,Fe,r),n(e,vr,r),n(e,Se,r),n(e,xr,r),n(e,De,r),n(e,$r,r),n(e,N,r),u(Ge,N,null),o(N,Ys),o(N,St),n(e,br,r),u(Re,e,r),n(e,yr,r),n(e,We,r),n(e,Mr,r),n(e,Qe,r),n(e,wr,r),n(e,Ye,r),n(e,Tr,r),n(e,Ae,r),n(e,Cr,r),n(e,Oe,r),n(e,Pr,r),n(e,Ke,r),n(e,Ir,r),u(et,e,r),n(e,Xr,r),n(e,tt,r),n(e,kr,r),n(e,rt,r),n(e,Jr,r),u(st,e,r),n(e,Ur,r),n(e,at,r),n(e,Zr,r),n(e,ot,r),n(e,Lr,r),n(e,nt,r),n(e,jr,r),n(e,k,r),u(lt,k,null),o(k,As),o(k,Dt),o(k,Os),o(k,ie),u(it,ie,null),o(ie,Ks),o(ie,Gt),o(k,ea),o(k,E),u(mt,E,null),o(E,ta),o(E,Rt),o(E,ra),u(me,E,null),o(k,sa),o(k,de),u(dt,de,null),o(de,aa),o(de,Wt),n(e,zr,r),n(e,ct,r),n(e,Vr,r),n(e,L,r),u(pt,L,null),o(L,oa),o(L,Qt),o(L,na),u(ce,L,null),n(e,qr,r),n(e,ft,r),n(e,Er,r),u(ut,e,r),n(e,Hr,r),n(e,ht,r),n(e,Nr,r),u(gt,e,r),n(e,Br,r),n(e,_t,r),n(e,Fr,r),u(vt,e,r),n(e,Sr,r),n(e,xt,r),n(e,Dr,r),u($t,e,r),n(e,Gr,r),n(e,rr,r),Rr=!0},p(e,[r]){const w={};r&2&&(w.$$scope={dirty:r,ctx:e}),G.$set(w);const bt={};r&2&&(bt.$$scope={dirty:r,ctx:e}),W.$set(bt);const B={};r&2&&(B.$$scope={dirty:r,ctx:e}),Q.$set(B);const yt={};r&2&&(yt.$$scope={dirty:r,ctx:e}),Y.$set(yt);const F={};r&2&&(F.$$scope={dirty:r,ctx:e}),me.$set(F);const S={};r&2&&(S.$$scope={dirty:r,ctx:e}),ce.$set(S)},i(e){Rr||(h(C.$$.fragment,e),h(ue.$$.fragment,e),h(_e.$$.fragment,e),h(ve.$$.fragment,e),h(xe.$$.fragment,e),h(G.$$.fragment,e),h($e.$$.fragment,e),h(be.$$.fragment,e),h(W.$$.fragment,e),h(ye.$$.fragment,e),h(Q.$$.fragment,e),h(Me.$$.fragment,e),h(Y.$$.fragment,e),h(we.$$.fragment,e),h(Te.$$.fragment,e),h(Ce.$$.fragment,e),h(Pe.$$.fragment,e),h(Xe.$$.fragment,e),h(ke.$$.fragment,e),h(Je.$$.fragment,e),h(Ue.$$.fragment,e),h(Ze.$$.fragment,e),h(Le.$$.fragment,e),h(je.$$.fragment,e),h(ze.$$.fragment,e),h(Ve.$$.fragment,e),h(qe.$$.fragment,e),h(Ee.$$.fragment,e),h(He.$$.fragment,e),h(Ge.$$.fragment,e),h(Re.$$.fragment,e),h(et.$$.fragment,e),h(st.$$.fragment,e),h(lt.$$.fragment,e),h(it.$$.fragment,e),h(mt.$$.fragment,e),h(me.$$.fragment,e),h(dt.$$.fragment,e),h(pt.$$.fragment,e),h(ce.$$.fragment,e),h(ut.$$.fragment,e),h(gt.$$.fragment,e),h(vt.$$.fragment,e),h($t.$$.fragment,e),Rr=!0)},o(e){g(C.$$.fragment,e),g(ue.$$.fragment,e),g(_e.$$.fragment,e),g(ve.$$.fragment,e),g(xe.$$.fragment,e),g(G.$$.fragment,e),g($e.$$.fragment,e),g(be.$$.fragment,e),g(W.$$.fragment,e),g(ye.$$.fragment,e),g(Q.$$.fragment,e),g(Me.$$.fragment,e),g(Y.$$.fragment,e),g(we.$$.fragment,e),g(Te.$$.fragment,e),g(Ce.$$.fragment,e),g(Pe.$$.fragment,e),g(Xe.$$.fragment,e),g(ke.$$.fragment,e),g(Je.$$.fragment,e),g(Ue.$$.fragment,e),g(Ze.$$.fragment,e),g(Le.$$.fragment,e),g(je.$$.fragment,e),g(ze.$$.fragment,e),g(Ve.$$.fragment,e),g(qe.$$.fragment,e),g(Ee.$$.fragment,e),g(He.$$.fragment,e),g(Ge.$$.fragment,e),g(Re.$$.fragment,e),g(et.$$.fragment,e),g(st.$$.fragment,e),g(lt.$$.fragment,e),g(it.$$.fragment,e),g(mt.$$.fragment,e),g(me.$$.fragment,e),g(dt.$$.fragment,e),g(pt.$$.fragment,e),g(ce.$$.fragment,e),g(ut.$$.fragment,e),g(gt.$$.fragment,e),g(vt.$$.fragment,e),g($t.$$.fragment,e),Rr=!1},d(e){e&&(t(T),t(v),t(x),t(c),t(I),t(ar),t(fe),t(or),t(nr),t(he),t(lr),t(ge),t(ir),t(y),t(mr),t(dr),t(Ie),t(cr),t(P),t(pr),t(U),t(fr),t(Z),t(ur),t(hr),t(Ne),t(gr),t(Be),t(_r),t(Fe),t(vr),t(Se),t(xr),t(De),t($r),t(N),t(br),t(yr),t(We),t(Mr),t(Qe),t(wr),t(Ye),t(Tr),t(Ae),t(Cr),t(Oe),t(Pr),t(Ke),t(Ir),t(Xr),t(tt),t(kr),t(rt),t(Jr),t(Ur),t(at),t(Zr),t(ot),t(Lr),t(nt),t(jr),t(k),t(zr),t(ct),t(Vr),t(L),t(qr),t(ft),t(Er),t(Hr),t(ht),t(Nr),t(Br),t(_t),t(Fr),t(Sr),t(xt),t(Dr),t(Gr),t(rr)),t(d),_(C,e),_(ue,e),_(_e),_(ve),_(xe),_(G),_($e),_(be),_(W),_(ye),_(Q),_(Me),_(Y),_(we),_(Te),_(Ce),_(Pe,e),_(Xe),_(ke),_(Je),_(Ue),_(Ze),_(Le),_(je),_(ze),_(Ve),_(qe),_(Ee),_(He,e),_(Ge),_(Re,e),_(et,e),_(st,e),_(lt),_(it),_(mt),_(me),_(dt),_(pt),_(ce),_(ut,e),_(gt,e),_(vt,e),_($t,e)}}}const yo='{"title":"Processors","local":"processors","sections":[{"title":"多模态processors","local":"transformers.ProcessorMixin","sections":[],"depth":2},{"title":"已弃用的processors","local":"transformers.DataProcessor","sections":[],"depth":2},{"title":"GLUE","local":"transformers.glue_convert_examples_to_features","sections":[],"depth":2},{"title":"XNLI","local":"xnli","sections":[],"depth":2},{"title":"SQuAD","local":"squad","sections":[{"title":"Processors","local":"transformers.data.processors.squad.SquadProcessor","sections":[],"depth":3},{"title":"Example使用","local":"example使用","sections":[],"depth":3}],"depth":2}],"depth":1}';function Mo(J){return mo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Jo extends co{constructor(d){super(),po(this,d,Mo,bo,io,{})}}export{Jo as component};
