import{s as cn,o as mn,n as hn}from"../chunks/scheduler.f7e1785c.js";import{S as yn,i as un,g as p,s as a,r as M,A as dn,h as i,f as l,c as n,j as on,u as o,x as r,k as Ks,y as wn,a as s,v as c,d as m,t as h,w as y}from"../chunks/index.9f8f0838.js";import{T as Jn}from"../chunks/Tip.4575d9cf.js";import{C as u}from"../chunks/CodeBlock.b3510e34.js";import{H as J,E as Tn}from"../chunks/EditOnGithub.5a9bb8c5.js";function Un(_t){let d,j=`In our example we will be using approximately 40 hours of training data. If you’d like to follow along using the Google Colab free tier GPU,
you will need to reduce the amount of training data to approximately 10-15 hours, and reduce the number of training steps.`;return{c(){d=p("p"),d.textContent=j},l(w){d=i(w,"P",{"data-svelte-h":!0}),r(d)!=="svelte-jn3a6r"&&(d.textContent=j)},m(w,Bt){s(w,d,Bt)},p:hn,d(w){w&&l(d)}}}function fn(_t){let d,j,w,Bt,b,Xt,C,Os=`Now that you are familiar with the text-to-speech task and internal workings of the SpeechT5 model that was pre-trained
on English language data, let’s see how we can fine-tune it to another language.`,Rt,I,Yt,g,ea="Make sure that you have a GPU if you want to reproduce this example. In a notebook, you can check with the following command:",Qt,$,Nt,T,At,k,ta="You’ll also need some additional dependencies:",zt,x,Ft,Z,la="Finally, don’t forget to log in to your Hugging Face account so that you could upload and share your model with the community:",Et,v,Ht,G,qt,V,sa=`For this example we’ll take the Dutch (<code>nl</code>) language subset of the <a href="https://huggingface.co/datasets/facebook/voxpopuli" rel="nofollow">VoxPopuli</a> dataset.
<a href="https://huggingface.co/datasets/facebook/voxpopuli" rel="nofollow">VoxPopuli</a> is a large-scale multilingual speech corpus consisting of
data sourced from 2009-2020 European Parliament event recordings. It contains labelled audio-transcription data for 15
European languages. While we will be using the Dutch language subset, feel free to pick another subset.`,St,B,aa=`This is an automated speech recognition (ASR) dataset, so, as mentioned before, it is not the most suitable
option for training TTS models. However, it will be good enough for this exercise.`,Dt,W,na="Let’s load the data:",Lt,_,Pt,X,pa="<strong>Output:</strong>",Kt,R,Ot,Y,ia=`20968 examples should be sufficient for fine-tuning. SpeechT5 expects audio data to have a sampling rate of 16 kHz, so
make sure the examples in the dataset meet this requirement:`,el,Q,tl,N,ll,A,ra=`Let’s begin by defining the model checkpoint to use and loading the appropriate processor that contains both tokenizer,
and feature extractor that we will need to prepare the data for training:`,sl,z,al,F,nl,E,Ma="First, for preparing the text, we’ll need the tokenizer part of the processor, so let’s get it:",pl,H,il,q,oa="Let’s take a look at an example:",rl,S,Ml,D,ca="<strong>Output:</strong>",ol,L,cl,P,ma=`What you may notice is that the dataset examples contain <code>raw_text</code> and <code>normalized_text</code> features. When deciding which
feature to use as the text input, it will be important to know that the SpeechT5 tokenizer doesn’t have any tokens for
numbers. In <code>normalized_text</code> the numbers are written out as text. Thus, it is a better fit, and we should use <code>normalized_text</code>
as input text.`,ml,K,ha=`Because SpeechT5 was trained on the English language, it may not recognize certain characters in the Dutch dataset. If
left as is, these characters will be converted to <code>&lt;unk&gt;</code> tokens. However, in Dutch, certain characters like <code>à</code> are
used to stress syllables. In order to preserve the meaning of the text, we can replace this character with a regular <code>a</code>.`,hl,O,ya=`To identify unsupported tokens, extract all unique characters in the dataset using the <code>SpeechT5Tokenizer</code> which
works with characters as tokens. To do this, we’ll write the <code>extract_all_chars</code> mapping function that concatenates
the transcriptions from all examples into one string and converts it to a set of characters.
Make sure to set <code>batched=True</code> and <code>batch_size=-1</code> in <code>dataset.map()</code> so that all transcriptions are available at once for
the mapping function.`,yl,ee,ul,te,ua=`Now you have two sets of characters: one with the vocabulary from the dataset and one with the vocabulary from the tokenizer.
To identify any unsupported characters in the dataset, you can take the difference between these two sets. The resulting
set will contain the characters that are in the dataset but not in the tokenizer.`,dl,le,wl,se,da="<strong>Output:</strong>",Jl,ae,Tl,ne,wa=`To handle the unsupported characters identified in the previous step, we can define a function that maps these characters to
valid tokens. Note that spaces are already replaced by <code>▁</code> in the tokenizer and don’t need to be handled separately.`,Ul,pe,fl,ie,Ja="Now that we have dealt with special characters in the text, it’s time to shift the focus to the audio data.",jl,re,bl,Me,Ta=`The VoxPopuli dataset includes speech from multiple speakers, but how many speakers are represented in the dataset? To
determine this, we can count the number of unique speakers and the number of examples each speaker contributes to the dataset.
With a total of 20,968 examples in the dataset, this information will give us a better understanding of the distribution of
speakers and examples in the data.`,Cl,oe,Il,ce,Ua="By plotting a histogram you can get a sense of how much data there is for each speaker.",gl,me,$l,U,fa='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/tts_speakers_histogram.png" alt="Speakers histogram"/>',kl,he,ja=`The histogram reveals that approximately one-third of the speakers in the dataset have fewer than 100 examples, while
around ten speakers have more than 500 examples. To improve training efficiency and balance the dataset, we can limit
the data to speakers with between 100 and 400 examples.`,xl,ye,Zl,ue,ba="Let’s check how many speakers remain:",vl,de,Gl,we,Ca="<strong>Output:</strong>",Vl,Je,Bl,Te,Ia="Let’s see how many examples are left:",Wl,Ue,_l,fe,ga="<strong>Output:</strong>",Xl,je,Rl,be,$a="You are left with just under 10,000 examples from approximately 40 unique speakers, which should be sufficient.",Yl,Ce,ka=`Note that some speakers with few examples may actually have more audio available if the examples are long. However,
determining the total amount of audio for each speaker requires scanning through the entire dataset, which is a
time-consuming process that involves loading and decoding each audio file. As such, we have chosen to skip this step here.`,Ql,Ie,Nl,ge,xa=`To enable the TTS model to differentiate between multiple speakers, you’ll need to create a speaker embedding for each example.
The speaker embedding is an additional input into the model that captures a particular speaker’s voice characteristics.
To generate these speaker embeddings, use the pre-trained <a href="https://huggingface.co/speechbrain/spkrec-xvect-voxceleb" rel="nofollow">spkrec-xvect-voxceleb</a>
model from SpeechBrain.`,Al,$e,Za=`Create a function <code>create_speaker_embedding()</code> that takes an input audio waveform and outputs a 512-element vector
containing the corresponding speaker embedding.`,zl,ke,Fl,xe,va=`It’s important to note that the <code>speechbrain/spkrec-xvect-voxceleb</code> model was trained on English speech from the VoxCeleb
dataset, whereas the training examples in this guide are in Dutch. While we believe that this model will still generate
reasonable speaker embeddings for our Dutch dataset, this assumption may not hold true in all cases.`,El,Ze,Ga=`For optimal results, we would need to train an X-vector model on the target speech first. This will ensure that the model
is better able to capture the unique voice characteristics present in the Dutch language. If you’d like to train your own
X-vector model, you can use <a href="https://huggingface.co/mechanicalsea/speecht5-vc/blob/main/manifest/utils/prep_cmu_arctic_spkemb.py" rel="nofollow">this script</a>
as an example.`,Hl,ve,ql,Ge,Va=`Finally, let’s process the data into the format the model expects. Create a <code>prepare_dataset</code> function that takes in a
single example and uses the <code>SpeechT5Processor</code> object to tokenize the input text and load the target audio into a log-mel spectrogram.
It should also add the speaker embeddings as an additional input.`,Sl,Ve,Dl,Be,Ba="Verify the processing is correct by looking at a single example:",Ll,We,Pl,_e,Wa="<strong>Output:</strong>",Kl,Xe,Ol,Re,_a="Speaker embeddings should be a 512-element vector:",es,Ye,ts,Qe,Xa="<strong>Output:</strong>",ls,Ne,ss,Ae,Ra="The labels should be a log-mel spectrogram with 80 mel bins.",as,ze,ns,f,Ya='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/tts_logmelspectrogram_1.png" alt="Log-mel spectrogram with 80 mel bins"/>',ps,Fe,Qa=`Side note: If you find this spectrogram confusing, it may be due to your familiarity with the convention of placing low frequencies
at the bottom and high frequencies at the top of a plot. However, when plotting spectrograms as an image using the matplotlib library,
the y-axis is flipped and the spectrograms appear upside down.`,is,Ee,Na="Now we need to apply the processing function to the entire dataset. This will take between 5 and 10 minutes.",rs,He,Ms,qe,Aa=`You’ll see a warning saying that some examples in the dataset are longer than the maximum input length the model can handle (600 tokens).
Remove those examples from the dataset. Here we go even further and to allow for larger batch sizes we remove anything over 200 tokens.`,os,Se,cs,De,za="<strong>Output:</strong>",ms,Le,hs,Pe,Fa="Next, create a basic train/test split:",ys,Ke,us,Oe,ds,et,Ea=`In order to combine multiple examples into a batch, you need to define a custom data collator. This collator will pad shorter sequences with padding
tokens, ensuring that all examples have the same length. For the spectrogram labels, the padded portions are replaced with
the special value <code>-100</code>. This special value instructs the model to ignore that part of the spectrogram when calculating the spectrogram loss.`,ws,tt,Js,lt,Ha=`In SpeechT5, the input to the decoder part of the model is reduced by a factor 2. In other words, it throws away every
other timestep from the target sequence. The decoder then predicts a sequence that is twice as long. Since the original
target sequence length may be odd, the data collator makes sure to round the maximum length of the batch down to be a
multiple of 2.`,Ts,st,Us,at,fs,nt,qa="Load the pre-trained model from the same checkpoint as you used for loading the processor:",js,pt,bs,it,Sa=`The <code>use_cache=True</code> option is incompatible with gradient checkpointing. Disable it for training, and re-enable cache for
generation to speed-up inference time:`,Cs,rt,Is,Mt,Da=`Define the training arguments. Here we are not computing any evaluation metrics during the training process,
we’ll talk about evaluation later in this chapter. Instead, we’ll only look at the loss:`,gs,ot,$s,ct,La="Instantiate the <code>Trainer</code> object  and pass the model, dataset, and data collator to it.",ks,mt,xs,ht,Pa=`And with that, we’re ready to start training! Training will take several hours. Depending on your GPU,
it is possible that you will encounter a CUDA “out-of-memory” error when you start training. In this case, you can reduce
the <code>per_device_train_batch_size</code> incrementally by factors of 2 and increase <code>gradient_accumulation_steps</code> by 2x to compensate.`,Zs,yt,vs,ut,Ka="Push the final model to the 🤗 Hub:",Gs,dt,Vs,wt,Bs,Jt,Oa=`Once you have fine-tuned a model, you can use it for inference! Load the model from the 🤗 Hub (make sure to use your
account name in the following code snippet):`,Ws,Tt,_s,Ut,en="Pick an example, here we’ll take one from the test dataset. Obtain a speaker embedding.",Xs,ft,Rs,jt,tn="Define some input text and tokenize it.",Ys,bt,Qs,Ct,ln="Preprocess the input text:",Ns,It,As,gt,sn="Instantiate a vocoder and generate speech:",zs,$t,Fs,kt,an="Ready to listen to the result?",Es,xt,Hs,Zt,nn=`Obtaining satisfactory results from this model on a new language can be challenging. The quality of the speaker
embeddings can be a significant factor. Since SpeechT5 was pre-trained with English x-vectors, it performs best
when using English speaker embeddings. If the synthesized speech sounds poor, try using a different speaker embedding.`,qs,vt,pn=`Increasing the training duration is also likely to enhance the quality of the results. Even so, the speech clearly is Dutch instead of English, and it does
capture the voice characteristics of the speaker (compare to the original audio in the example).
Another thing to experiment with is the model’s configuration. For example, try using <code>config.reduction_factor = 1</code> to
see if this improves the results.`,Ss,Gt,rn="In the next section, we’ll talk about how we evaluate text-to-speech models.",Ds,Vt,Ls,Wt,Ps;return b=new J({props:{title:"Fine-tuning SpeechT5",local:"fine-tuning-speecht5",headingTag:"h1"}}),I=new J({props:{title:"House-keeping",local:"house-keeping",headingTag:"h2"}}),$=new u({props:{code:"bnZpZGlhLXNtaQ==",highlighted:"nvidia-smi",wrap:!1}}),T=new Jn({props:{warning:!0,$$slots:{default:[Un]},$$scope:{ctx:_t}}}),x=new u({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMGRhdGFzZXRzJTIwc291bmRmaWxlJTIwc3BlZWNoYnJhaW4lMjBhY2NlbGVyYXRl",highlighted:"pip install transformers datasets soundfile speechbrain accelerate",wrap:!1}}),v=new u({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),G=new J({props:{title:"The dataset",local:"the-dataset",headingTag:"h2"}}),_=new u({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTJDJTIwQXVkaW8lMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmZhY2Vib29rJTJGdm94cG9wdWxpJTIyJTJDJTIwJTIybmwlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQWxlbihkYXRhc2V0KQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, Audio

dataset = load_dataset(<span class="hljs-string">&quot;facebook/voxpopuli&quot;</span>, <span class="hljs-string">&quot;nl&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-built_in">len</span>(dataset)`,wrap:!1}}),R=new u({props:{code:"MjA5Njg=",highlighted:"20968",wrap:!1}}),Q=new u({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuY2FzdF9jb2x1bW4oJTIyYXVkaW8lMjIlMkMlMjBBdWRpbyhzYW1wbGluZ19yYXRlJTNEMTYwMDApKQ==",highlighted:'dataset = dataset.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=<span class="hljs-number">16000</span>))',wrap:!1}}),N=new J({props:{title:"Preprocessing the data",local:"preprocessing-the-data",headingTag:"h2"}}),z=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaFQ1UHJvY2Vzc29yJTBBJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMm1pY3Jvc29mdCUyRnNwZWVjaHQ1X3R0cyUyMiUwQXByb2Nlc3NvciUyMCUzRCUyMFNwZWVjaFQ1UHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SpeechT5Processor

checkpoint = <span class="hljs-string">&quot;microsoft/speecht5_tts&quot;</span>
processor = SpeechT5Processor.from_pretrained(checkpoint)`,wrap:!1}}),F=new J({props:{title:"Text cleanup for SpeechT5 tokenization",local:"text-cleanup-for-speecht5-tokenization",headingTag:"h3"}}),H=new u({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwcHJvY2Vzc29yLnRva2VuaXplcg==",highlighted:"tokenizer = processor.tokenizer",wrap:!1}}),S=new u({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:'dataset[<span class="hljs-number">0</span>]',wrap:!1}}),L=new u({props:{code:"JTdCJ2F1ZGlvX2lkJyUzQSUyMCcyMDEwMDIxMC0wOTAwLVBMRU5BUlktMy1ubF8yMDEwMDIxMC0wOSUzQTA2JTNBNDNfNCclMkMlMEElMjAnbGFuZ3VhZ2UnJTNBJTIwOSUyQyUwQSUyMCdhdWRpbyclM0ElMjAlN0IncGF0aCclM0ElMjAnJTJGcm9vdCUyRi5jYWNoZSUyRmh1Z2dpbmdmYWNlJTJGZGF0YXNldHMlMkZkb3dubG9hZHMlMkZleHRyYWN0ZWQlMkYwMmVjNmExOWQ1Yjk3YzAzZTEzNzkyNTAzNzg0NTRkYmYzZmEyOTcyOTQzNTA0YTkxYzdkYTUwNDVhYTI2YTg5JTJGdHJhaW5fcGFydF8wJTJGMjAxMDAyMTAtMDkwMC1QTEVOQVJZLTMtbmxfMjAxMDAyMTAtMDklM0EwNiUzQTQzXzQud2F2JyUyQyUwQSUyMCUyMCdhcnJheSclM0ElMjBhcnJheSglNUIlMjA0LjI3MjQ2MDk0ZS0wNCUyQyUyMCUyMDEuMzEyMjU1ODZlLTAzJTJDJTIwJTIwMS4wMzc1OTc2NmUtMDMlMkMlMjAuLi4lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAtOS4xNTUyNzM0NGUtMDUlMkMlMjAlMjA3LjYyOTM5NDUzZS0wNCUyQyUyMC0yLjQ0MTQwNjI1ZS0wNCU1RCklMkMlMEElMjAlMjAnc2FtcGxpbmdfcmF0ZSclM0ElMjAxNjAwMCU3RCUyQyUwQSUyMCdyYXdfdGV4dCclM0ElMjAnRGF0JTIwa2FuJTIwbmFhciUyMG1pam4lMjBnZXZvZWwlMjBhbGxlZW4lMjBtZXQlMjBlZW4lMjBicmVkZSUyMG1lZXJkZXJoZWlkJTIwZGllJTIwd2lqJTIwc2FtZW4lMjB6b2VrZW4uJyUyQyUwQSUyMCdub3JtYWxpemVkX3RleHQnJTNBJTIwJ2RhdCUyMGthbiUyMG5hYXIlMjBtaWpuJTIwZ2V2b2VsJTIwYWxsZWVuJTIwbWV0JTIwZWVuJTIwYnJlZGUlMjBtZWVyZGVyaGVpZCUyMGRpZSUyMHdpaiUyMHNhbWVuJTIwem9la2VuLiclMkMlMEElMjAnZ2VuZGVyJyUzQSUyMCdmZW1hbGUnJTJDJTBBJTIwJ3NwZWFrZXJfaWQnJTNBJTIwJzExMjInJTJDJTBBJTIwJ2lzX2dvbGRfdHJhbnNjcmlwdCclM0ElMjBUcnVlJTJDJTBBJTIwJ2FjY2VudCclM0ElMjAnTm9uZSclN0Q=",highlighted:`{&#x27;audio_id&#x27;: &#x27;<span class="hljs-number">20100210-0900</span>-PLENARY-3-nl_<span class="hljs-number">20100210-09:06:43</span>_4&#x27;,
 &#x27;language&#x27;: <span class="hljs-number">9</span>,
 &#x27;audio&#x27;: {&#x27;path&#x27;: &#x27;/root/.cache/huggingface/datasets/downloads/extracted/02ec6a19d5b97c03e<span class="hljs-number">137925037845</span>4dbf3fa<span class="hljs-number">2972943504</span>a91c7da<span class="hljs-number">5045</span>aa26a89/train_part_0/<span class="hljs-number">20100210-0900</span>-PLENARY-3-nl_<span class="hljs-number">20100210-09:06:43</span>_4.wav&#x27;,
  &#x27;array&#x27;: array([ <span class="hljs-number">4.27246094</span>e-<span class="hljs-number">04</span>,  <span class="hljs-number">1.31225586</span>e-<span class="hljs-number">03</span>,  <span class="hljs-number">1.03759766</span>e-<span class="hljs-number">03</span>, ...,
         -<span class="hljs-number">9.15527344</span>e-<span class="hljs-number">05</span>,  <span class="hljs-number">7.62939453</span>e-<span class="hljs-number">04</span>, -<span class="hljs-number">2.44140625</span>e-<span class="hljs-number">04</span>]),
  &#x27;sampling_rate&#x27;: <span class="hljs-number">16000</span>},
 &#x27;raw_text&#x27;: &#x27;Dat kan naar mijn gevoel alleen met een brede meerderheid die wij samen zoeken.&#x27;,
 &#x27;normalized_text&#x27;: &#x27;dat kan naar mijn gevoel alleen met een brede meerderheid die wij samen zoeken.&#x27;,
 &#x27;gender&#x27;: &#x27;female&#x27;,
 &#x27;speaker_id&#x27;: &#x27;<span class="hljs-number">1122</span>&#x27;,
 &#x27;is_gold_transcript&#x27;: True,
 &#x27;accent&#x27;: &#x27;None&#x27;}`,wrap:!1}}),ee=new u({props:{code:"ZGVmJTIwZXh0cmFjdF9hbGxfY2hhcnMoYmF0Y2gpJTNBJTBBJTIwJTIwJTIwJTIwYWxsX3RleHQlMjAlM0QlMjAlMjIlMjAlMjIuam9pbihiYXRjaCU1QiUyMm5vcm1hbGl6ZWRfdGV4dCUyMiU1RCklMEElMjAlMjAlMjAlMjB2b2NhYiUyMCUzRCUyMGxpc3Qoc2V0KGFsbF90ZXh0KSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJ2b2NhYiUyMiUzQSUyMCU1QnZvY2FiJTVEJTJDJTIwJTIyYWxsX3RleHQlMjIlM0ElMjAlNUJhbGxfdGV4dCU1RCU3RCUwQSUwQSUwQXZvY2FicyUyMCUzRCUyMGRhdGFzZXQubWFwKCUwQSUyMCUyMCUyMCUyMGV4dHJhY3RfYWxsX2NoYXJzJTJDJTBBJTIwJTIwJTIwJTIwYmF0Y2hlZCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNELTElMkMlMEElMjAlMjAlMjAlMjBrZWVwX2luX21lbW9yeSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjByZW1vdmVfY29sdW1ucyUzRGRhdGFzZXQuY29sdW1uX25hbWVzJTJDJTBBKSUwQSUwQWRhdGFzZXRfdm9jYWIlMjAlM0QlMjBzZXQodm9jYWJzJTVCJTIydm9jYWIlMjIlNUQlNUIwJTVEKSUwQXRva2VuaXplcl92b2NhYiUyMCUzRCUyMCU3QmslMjBmb3IlMjBrJTJDJTIwXyUyMGluJTIwdG9rZW5pemVyLmdldF92b2NhYigpLml0ZW1zKCklN0Q=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">extract_all_chars</span>(<span class="hljs-params">batch</span>):
    all_text = <span class="hljs-string">&quot; &quot;</span>.join(batch[<span class="hljs-string">&quot;normalized_text&quot;</span>])
    vocab = <span class="hljs-built_in">list</span>(<span class="hljs-built_in">set</span>(all_text))
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;vocab&quot;</span>: [vocab], <span class="hljs-string">&quot;all_text&quot;</span>: [all_text]}


vocabs = dataset.<span class="hljs-built_in">map</span>(
    extract_all_chars,
    batched=<span class="hljs-literal">True</span>,
    batch_size=-<span class="hljs-number">1</span>,
    keep_in_memory=<span class="hljs-literal">True</span>,
    remove_columns=dataset.column_names,
)

dataset_vocab = <span class="hljs-built_in">set</span>(vocabs[<span class="hljs-string">&quot;vocab&quot;</span>][<span class="hljs-number">0</span>])
tokenizer_vocab = {k <span class="hljs-keyword">for</span> k, _ <span class="hljs-keyword">in</span> tokenizer.get_vocab().items()}`,wrap:!1}}),le=new u({props:{code:"ZGF0YXNldF92b2NhYiUyMC0lMjB0b2tlbml6ZXJfdm9jYWI=",highlighted:"dataset_vocab - tokenizer_vocab",wrap:!1}}),ae=new u({props:{code:"JTdCJyUyMCclMkMlMjAnJUMzJUEwJyUyQyUyMCclQzMlQTcnJTJDJTIwJyVDMyVBOCclMkMlMjAnJUMzJUFCJyUyQyUyMCclQzMlQUQnJTJDJTIwJyVDMyVBRiclMkMlMjAnJUMzJUI2JyUyQyUyMCclQzMlQkMnJTdE",highlighted:"{&#x27; &#x27;, &#x27;à&#x27;, &#x27;ç&#x27;, &#x27;è&#x27;, &#x27;ë&#x27;, &#x27;í&#x27;, &#x27;ï&#x27;, &#x27;ö&#x27;, &#x27;ü&#x27;}",wrap:!1}}),pe=new u({props:{code:"cmVwbGFjZW1lbnRzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBMCUyMiUyQyUyMCUyMmElMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBNyUyMiUyQyUyMCUyMmMlMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBOCUyMiUyQyUyMCUyMmUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBQiUyMiUyQyUyMCUyMmUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBRCUyMiUyQyUyMCUyMmklMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBRiUyMiUyQyUyMCUyMmklMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVCNiUyMiUyQyUyMCUyMm8lMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVCQyUyMiUyQyUyMCUyMnUlMjIpJTJDJTBBJTVEJTBBJTBBJTBBZGVmJTIwY2xlYW51cF90ZXh0KGlucHV0cyklM0ElMEElMjAlMjAlMjAlMjBmb3IlMjBzcmMlMkMlMjBkc3QlMjBpbiUyMHJlcGxhY2VtZW50cyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlucHV0cyU1QiUyMm5vcm1hbGl6ZWRfdGV4dCUyMiU1RCUyMCUzRCUyMGlucHV0cyU1QiUyMm5vcm1hbGl6ZWRfdGV4dCUyMiU1RC5yZXBsYWNlKHNyYyUyQyUyMGRzdCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBpbnB1dHMlMEElMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAoY2xlYW51cF90ZXh0KQ==",highlighted:`replacements = [
    (<span class="hljs-string">&quot;à&quot;</span>, <span class="hljs-string">&quot;a&quot;</span>),
    (<span class="hljs-string">&quot;ç&quot;</span>, <span class="hljs-string">&quot;c&quot;</span>),
    (<span class="hljs-string">&quot;è&quot;</span>, <span class="hljs-string">&quot;e&quot;</span>),
    (<span class="hljs-string">&quot;ë&quot;</span>, <span class="hljs-string">&quot;e&quot;</span>),
    (<span class="hljs-string">&quot;í&quot;</span>, <span class="hljs-string">&quot;i&quot;</span>),
    (<span class="hljs-string">&quot;ï&quot;</span>, <span class="hljs-string">&quot;i&quot;</span>),
    (<span class="hljs-string">&quot;ö&quot;</span>, <span class="hljs-string">&quot;o&quot;</span>),
    (<span class="hljs-string">&quot;ü&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>),
]


<span class="hljs-keyword">def</span> <span class="hljs-title function_">cleanup_text</span>(<span class="hljs-params">inputs</span>):
    <span class="hljs-keyword">for</span> src, dst <span class="hljs-keyword">in</span> replacements:
        inputs[<span class="hljs-string">&quot;normalized_text&quot;</span>] = inputs[<span class="hljs-string">&quot;normalized_text&quot;</span>].replace(src, dst)
    <span class="hljs-keyword">return</span> inputs


dataset = dataset.<span class="hljs-built_in">map</span>(cleanup_text)`,wrap:!1}}),re=new J({props:{title:"Speakers",local:"speakers",headingTag:"h3"}}),oe=new u({props:{code:"ZnJvbSUyMGNvbGxlY3Rpb25zJTIwaW1wb3J0JTIwZGVmYXVsdGRpY3QlMEElMEFzcGVha2VyX2NvdW50cyUyMCUzRCUyMGRlZmF1bHRkaWN0KGludCklMEElMEFmb3IlMjBzcGVha2VyX2lkJTIwaW4lMjBkYXRhc2V0JTVCJTIyc3BlYWtlcl9pZCUyMiU1RCUzQSUwQSUyMCUyMCUyMCUyMHNwZWFrZXJfY291bnRzJTVCc3BlYWtlcl9pZCU1RCUyMCUyQiUzRCUyMDE=",highlighted:`<span class="hljs-keyword">from</span> collections <span class="hljs-keyword">import</span> defaultdict

speaker_counts = defaultdict(<span class="hljs-built_in">int</span>)

<span class="hljs-keyword">for</span> speaker_id <span class="hljs-keyword">in</span> dataset[<span class="hljs-string">&quot;speaker_id&quot;</span>]:
    speaker_counts[speaker_id] += <span class="hljs-number">1</span>`,wrap:!1}}),me=new u({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQXBsdC5maWd1cmUoKSUwQXBsdC5oaXN0KHNwZWFrZXJfY291bnRzLnZhbHVlcygpJTJDJTIwYmlucyUzRDIwKSUwQXBsdC55bGFiZWwoJTIyU3BlYWtlcnMlMjIpJTBBcGx0LnhsYWJlbCglMjJFeGFtcGxlcyUyMiklMEFwbHQuc2hvdygp",highlighted:`<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

plt.figure()
plt.hist(speaker_counts.values(), bins=<span class="hljs-number">20</span>)
plt.ylabel(<span class="hljs-string">&quot;Speakers&quot;</span>)
plt.xlabel(<span class="hljs-string">&quot;Examples&quot;</span>)
plt.show()`,wrap:!1}}),ye=new u({props:{code:"ZGVmJTIwc2VsZWN0X3NwZWFrZXIoc3BlYWtlcl9pZCklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjAxMDAlMjAlM0MlM0QlMjBzcGVha2VyX2NvdW50cyU1QnNwZWFrZXJfaWQlNUQlMjAlM0MlM0QlMjA0MDAlMEElMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5maWx0ZXIoc2VsZWN0X3NwZWFrZXIlMkMlMjBpbnB1dF9jb2x1bW5zJTNEJTVCJTIyc3BlYWtlcl9pZCUyMiU1RCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">select_speaker</span>(<span class="hljs-params">speaker_id</span>):
    <span class="hljs-keyword">return</span> <span class="hljs-number">100</span> &lt;= speaker_counts[speaker_id] &lt;= <span class="hljs-number">400</span>


dataset = dataset.<span class="hljs-built_in">filter</span>(select_speaker, input_columns=[<span class="hljs-string">&quot;speaker_id&quot;</span>])`,wrap:!1}}),de=new u({props:{code:"bGVuKHNldChkYXRhc2V0JTVCJTIyc3BlYWtlcl9pZCUyMiU1RCkp",highlighted:'<span class="hljs-built_in">len</span>(<span class="hljs-built_in">set</span>(dataset[<span class="hljs-string">&quot;speaker_id&quot;</span>]))',wrap:!1}}),Je=new u({props:{code:"NDI=",highlighted:"42",wrap:!1}}),Ue=new u({props:{code:"bGVuKGRhdGFzZXQp",highlighted:'<span class="hljs-built_in">len</span>(dataset)',wrap:!1}}),je=new u({props:{code:"OTk3Mw==",highlighted:'<span class="hljs-number">9973</span>',wrap:!1}}),Ie=new J({props:{title:"Speaker embeddings",local:"speaker-embeddings",headingTag:"h3"}}),ke=new u({props:{code:"aW1wb3J0JTIwb3MlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBzcGVlY2hicmFpbi5wcmV0cmFpbmVkJTIwaW1wb3J0JTIwRW5jb2RlckNsYXNzaWZpZXIlMEElMEFzcGtfbW9kZWxfbmFtZSUyMCUzRCUyMCUyMnNwZWVjaGJyYWluJTJGc3BrcmVjLXh2ZWN0LXZveGNlbGViJTIyJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEFzcGVha2VyX21vZGVsJTIwJTNEJTIwRW5jb2RlckNsYXNzaWZpZXIuZnJvbV9ocGFyYW1zKCUwQSUyMCUyMCUyMCUyMHNvdXJjZSUzRHNwa19tb2RlbF9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwcnVuX29wdHMlM0QlN0IlMjJkZXZpY2UlMjIlM0ElMjBkZXZpY2UlN0QlMkMlMEElMjAlMjAlMjAlMjBzYXZlZGlyJTNEb3MucGF0aC5qb2luKCUyMiUyRnRtcCUyMiUyQyUyMHNwa19tb2RlbF9uYW1lKSUyQyUwQSklMEElMEElMEFkZWYlMjBjcmVhdGVfc3BlYWtlcl9lbWJlZGRpbmcod2F2ZWZvcm0pJTNBJTBBJTIwJTIwJTIwJTIwd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNwZWFrZXJfZW1iZWRkaW5ncyUyMCUzRCUyMHNwZWFrZXJfbW9kZWwuZW5jb2RlX2JhdGNoKHRvcmNoLnRlbnNvcih3YXZlZm9ybSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3BlYWtlcl9lbWJlZGRpbmdzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5ub3JtYWxpemUoc3BlYWtlcl9lbWJlZGRpbmdzJTJDJTIwZGltJTNEMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzcGVha2VyX2VtYmVkZGluZ3MlMjAlM0QlMjBzcGVha2VyX2VtYmVkZGluZ3Muc3F1ZWV6ZSgpLmNwdSgpLm51bXB5KCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBzcGVha2VyX2VtYmVkZGluZ3M=",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> speechbrain.pretrained <span class="hljs-keyword">import</span> EncoderClassifier

spk_model_name = <span class="hljs-string">&quot;speechbrain/spkrec-xvect-voxceleb&quot;</span>

device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
speaker_model = EncoderClassifier.from_hparams(
    source=spk_model_name,
    run_opts={<span class="hljs-string">&quot;device&quot;</span>: device},
    savedir=os.path.join(<span class="hljs-string">&quot;/tmp&quot;</span>, spk_model_name),
)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">create_speaker_embedding</span>(<span class="hljs-params">waveform</span>):
    <span class="hljs-keyword">with</span> torch.no_grad():
        speaker_embeddings = speaker_model.encode_batch(torch.tensor(waveform))
        speaker_embeddings = torch.nn.functional.normalize(speaker_embeddings, dim=<span class="hljs-number">2</span>)
        speaker_embeddings = speaker_embeddings.squeeze().cpu().numpy()
    <span class="hljs-keyword">return</span> speaker_embeddings`,wrap:!1}}),ve=new J({props:{title:"Processing the dataset",local:"processing-the-dataset",headingTag:"h3"}}),Ve=new u({props:{code:"ZGVmJTIwcHJlcGFyZV9kYXRhc2V0KGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwYXVkaW8lMjAlM0QlMjBleGFtcGxlJTVCJTIyYXVkaW8lMjIlNUQlMEElMEElMjAlMjAlMjAlMjBleGFtcGxlJTIwJTNEJTIwcHJvY2Vzc29yKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRleHQlM0RleGFtcGxlJTVCJTIybm9ybWFsaXplZF90ZXh0JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXVkaW9fdGFyZ2V0JTNEYXVkaW8lNUIlMjJhcnJheSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNhbXBsaW5nX3JhdGUlM0RhdWRpbyU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm5fYXR0ZW50aW9uX21hc2slM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMCklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBzdHJpcCUyMG9mZiUyMHRoZSUyMGJhdGNoJTIwZGltZW5zaW9uJTBBJTIwJTIwJTIwJTIwZXhhbXBsZSU1QiUyMmxhYmVscyUyMiU1RCUyMCUzRCUyMGV4YW1wbGUlNUIlMjJsYWJlbHMlMjIlNUQlNUIwJTVEJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwdXNlJTIwU3BlZWNoQnJhaW4lMjB0byUyMG9idGFpbiUyMHgtdmVjdG9yJTBBJTIwJTIwJTIwJTIwZXhhbXBsZSU1QiUyMnNwZWFrZXJfZW1iZWRkaW5ncyUyMiU1RCUyMCUzRCUyMGNyZWF0ZV9zcGVha2VyX2VtYmVkZGluZyhhdWRpbyU1QiUyMmFycmF5JTIyJTVEKSUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGV4YW1wbGU=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">prepare_dataset</span>(<span class="hljs-params">example</span>):
    audio = example[<span class="hljs-string">&quot;audio&quot;</span>]

    example = processor(
        text=example[<span class="hljs-string">&quot;normalized_text&quot;</span>],
        audio_target=audio[<span class="hljs-string">&quot;array&quot;</span>],
        sampling_rate=audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>],
        return_attention_mask=<span class="hljs-literal">False</span>,
    )

    <span class="hljs-comment"># strip off the batch dimension</span>
    example[<span class="hljs-string">&quot;labels&quot;</span>] = example[<span class="hljs-string">&quot;labels&quot;</span>][<span class="hljs-number">0</span>]

    <span class="hljs-comment"># use SpeechBrain to obtain x-vector</span>
    example[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>] = create_speaker_embedding(audio[<span class="hljs-string">&quot;array&quot;</span>])

    <span class="hljs-keyword">return</span> example`,wrap:!1}}),We=new u({props:{code:"cHJvY2Vzc2VkX2V4YW1wbGUlMjAlM0QlMjBwcmVwYXJlX2RhdGFzZXQoZGF0YXNldCU1QjAlNUQpJTBBbGlzdChwcm9jZXNzZWRfZXhhbXBsZS5rZXlzKCkp",highlighted:`processed_example = prepare_dataset(dataset[<span class="hljs-number">0</span>])
<span class="hljs-built_in">list</span>(processed_example.keys())`,wrap:!1}}),Xe=new u({props:{code:"JTVCJ2lucHV0X2lkcyclMkMlMjAnbGFiZWxzJyUyQyUyMCdzdG9wX2xhYmVscyclMkMlMjAnc3BlYWtlcl9lbWJlZGRpbmdzJyU1RA==",highlighted:'[<span class="hljs-symbol">&#x27;input_ids</span>&#x27;, <span class="hljs-symbol">&#x27;labels</span>&#x27;, <span class="hljs-symbol">&#x27;stop_labels</span>&#x27;, <span class="hljs-symbol">&#x27;speaker_embeddings</span>&#x27;]',wrap:!1}}),Ye=new u({props:{code:"cHJvY2Vzc2VkX2V4YW1wbGUlNUIlMjJzcGVha2VyX2VtYmVkZGluZ3MlMjIlNUQuc2hhcGU=",highlighted:'processed_example[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>].shape',wrap:!1}}),Ne=new u({props:{code:"KDUxMiUyQyk=",highlighted:'(<span class="hljs-number">512</span><span class="hljs-punctuation">,</span>)',wrap:!1}}),ze=new u({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQXBsdC5maWd1cmUoKSUwQXBsdC5pbXNob3cocHJvY2Vzc2VkX2V4YW1wbGUlNUIlMjJsYWJlbHMlMjIlNUQuVCklMEFwbHQuc2hvdygp",highlighted:`<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

plt.figure()
plt.imshow(processed_example[<span class="hljs-string">&quot;labels&quot;</span>].T)
plt.show()`,wrap:!1}}),He=new u({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQubWFwKHByZXBhcmVfZGF0YXNldCUyQyUyMHJlbW92ZV9jb2x1bW5zJTNEZGF0YXNldC5jb2x1bW5fbmFtZXMp",highlighted:'dataset = dataset.<span class="hljs-built_in">map</span>(prepare_dataset, remove_columns=dataset.column_names)',wrap:!1}}),Se=new u({props:{code:"ZGVmJTIwaXNfbm90X3Rvb19sb25nKGlucHV0X2lkcyklM0ElMEElMjAlMjAlMjAlMjBpbnB1dF9sZW5ndGglMjAlM0QlMjBsZW4oaW5wdXRfaWRzKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGlucHV0X2xlbmd0aCUyMCUzQyUyMDIwMCUwQSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LmZpbHRlcihpc19ub3RfdG9vX2xvbmclMkMlMjBpbnB1dF9jb2x1bW5zJTNEJTVCJTIyaW5wdXRfaWRzJTIyJTVEKSUwQWxlbihkYXRhc2V0KQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">is_not_too_long</span>(<span class="hljs-params">input_ids</span>):
    input_length = <span class="hljs-built_in">len</span>(input_ids)
    <span class="hljs-keyword">return</span> input_length &lt; <span class="hljs-number">200</span>


dataset = dataset.<span class="hljs-built_in">filter</span>(is_not_too_long, input_columns=[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-built_in">len</span>(dataset)`,wrap:!1}}),Le=new u({props:{code:"ODI1OQ==",highlighted:'<span class="hljs-number">8259</span>',wrap:!1}}),Ke=new u({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQudHJhaW5fdGVzdF9zcGxpdCh0ZXN0X3NpemUlM0QwLjEp",highlighted:'dataset = dataset.train_test_split(test_size=<span class="hljs-number">0.1</span>)',wrap:!1}}),Oe=new J({props:{title:"Data collator",local:"data-collator",headingTag:"h3"}}),tt=new u({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Any</span>, <span class="hljs-type">Dict</span>, <span class="hljs-type">List</span>, <span class="hljs-type">Union</span>


<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">TTSDataCollatorWithPadding</span>:
    processor: <span class="hljs-type">Any</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">
        self, features: <span class="hljs-type">List</span>[<span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Union</span>[<span class="hljs-type">List</span>[<span class="hljs-built_in">int</span>], torch.Tensor]]]
    </span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, torch.Tensor]:
        input_ids = [{<span class="hljs-string">&quot;input_ids&quot;</span>: feature[<span class="hljs-string">&quot;input_ids&quot;</span>]} <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]
        label_features = [{<span class="hljs-string">&quot;input_values&quot;</span>: feature[<span class="hljs-string">&quot;labels&quot;</span>]} <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]
        speaker_features = [feature[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>] <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]

        <span class="hljs-comment"># collate the inputs and targets into a batch</span>
        batch = processor.pad(
            input_ids=input_ids, labels=label_features, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
        )

        <span class="hljs-comment"># replace padding with -100 to ignore loss correctly</span>
        batch[<span class="hljs-string">&quot;labels&quot;</span>] = batch[<span class="hljs-string">&quot;labels&quot;</span>].masked_fill(
            batch.decoder_attention_mask.unsqueeze(-<span class="hljs-number">1</span>).ne(<span class="hljs-number">1</span>), -<span class="hljs-number">100</span>
        )

        <span class="hljs-comment"># not used during fine-tuning</span>
        <span class="hljs-keyword">del</span> batch[<span class="hljs-string">&quot;decoder_attention_mask&quot;</span>]

        <span class="hljs-comment"># round down target lengths to multiple of reduction factor</span>
        <span class="hljs-keyword">if</span> model.config.reduction_factor &gt; <span class="hljs-number">1</span>:
            target_lengths = torch.tensor(
                [<span class="hljs-built_in">len</span>(feature[<span class="hljs-string">&quot;input_values&quot;</span>]) <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> label_features]
            )
            target_lengths = target_lengths.new(
                [
                    length - length % model.config.reduction_factor
                    <span class="hljs-keyword">for</span> length <span class="hljs-keyword">in</span> target_lengths
                ]
            )
            max_length = <span class="hljs-built_in">max</span>(target_lengths)
            batch[<span class="hljs-string">&quot;labels&quot;</span>] = batch[<span class="hljs-string">&quot;labels&quot;</span>][:, :max_length]

        <span class="hljs-comment"># also add in the speaker embeddings</span>
        batch[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>] = torch.tensor(speaker_features)

        <span class="hljs-keyword">return</span> batch`,wrap:!1}}),st=new u({props:{code:"ZGF0YV9jb2xsYXRvciUyMCUzRCUyMFRUU0RhdGFDb2xsYXRvcldpdGhQYWRkaW5nKHByb2Nlc3NvciUzRHByb2Nlc3Nvcik=",highlighted:"data_collator = TTSDataCollatorWithPadding(processor=processor)",wrap:!1}}),at=new J({props:{title:"Train the model",local:"train-the-model",headingTag:"h2"}}),pt=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaFQ1Rm9yVGV4dFRvU3BlZWNoJTBBJTBBbW9kZWwlMjAlM0QlMjBTcGVlY2hUNUZvclRleHRUb1NwZWVjaC5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SpeechT5ForTextToSpeech

model = SpeechT5ForTextToSpeech.from_pretrained(checkpoint)`,wrap:!1}}),rt=new u({props:{code:"ZnJvbSUyMGZ1bmN0b29scyUyMGltcG9ydCUyMHBhcnRpYWwlMEElMEElMjMlMjBkaXNhYmxlJTIwY2FjaGUlMjBkdXJpbmclMjB0cmFpbmluZyUyMHNpbmNlJTIwaXQncyUyMGluY29tcGF0aWJsZSUyMHdpdGglMjBncmFkaWVudCUyMGNoZWNrcG9pbnRpbmclMEFtb2RlbC5jb25maWcudXNlX2NhY2hlJTIwJTNEJTIwRmFsc2UlMEElMEElMjMlMjBzZXQlMjBsYW5ndWFnZSUyMGFuZCUyMHRhc2slMjBmb3IlMjBnZW5lcmF0aW9uJTIwYW5kJTIwcmUtZW5hYmxlJTIwY2FjaGUlMEFtb2RlbC5nZW5lcmF0ZSUyMCUzRCUyMHBhcnRpYWwobW9kZWwuZ2VuZXJhdGUlMkMlMjB1c2VfY2FjaGUlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> functools <span class="hljs-keyword">import</span> partial

<span class="hljs-comment"># disable cache during training since it&#x27;s incompatible with gradient checkpointing</span>
model.config.use_cache = <span class="hljs-literal">False</span>

<span class="hljs-comment"># set language and task for generation and re-enable cache</span>
model.generate = partial(model.generate, use_cache=<span class="hljs-literal">True</span>)`,wrap:!1}}),ot=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlcTJTZXFUcmFpbmluZ0FyZ3VtZW50cyUwQSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBTZXEyU2VxVHJhaW5pbmdBcmd1bWVudHMoJTBBJTIwJTIwJTIwJTIwb3V0cHV0X2RpciUzRCUyMnNwZWVjaHQ1X2ZpbmV0dW5lZF92b3hwb3B1bGlfbmwlMjIlMkMlMjAlMjAlMjMlMjBjaGFuZ2UlMjB0byUyMGElMjByZXBvJTIwbmFtZSUyMG9mJTIweW91ciUyMGNob2ljZSUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDQlMkMlMEElMjAlMjAlMjAlMjBncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlM0Q4JTJDJTBBJTIwJTIwJTIwJTIwbGVhcm5pbmdfcmF0ZSUzRDFlLTUlMkMlMEElMjAlMjAlMjAlMjB3YXJtdXBfc3RlcHMlM0Q1MDAlMkMlMEElMjAlMjAlMjAlMjBtYXhfc3RlcHMlM0Q0MDAwJTJDJTBBJTIwJTIwJTIwJTIwZ3JhZGllbnRfY2hlY2twb2ludGluZyUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBmcDE2JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGV2YWx1YXRpb25fc3RyYXRlZ3klM0QlMjJzdGVwcyUyMiUyQyUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfZXZhbF9iYXRjaF9zaXplJTNEMiUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfc3RlcHMlM0QxMDAwJTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9zdGVwcyUzRDEwMDAlMkMlMEElMjAlMjAlMjAlMjBsb2dnaW5nX3N0ZXBzJTNEMjUlMkMlMEElMjAlMjAlMjAlMjByZXBvcnRfdG8lM0QlNUIlMjJ0ZW5zb3Jib2FyZCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGxvYWRfYmVzdF9tb2RlbF9hdF9lbmQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwZ3JlYXRlcl9pc19iZXR0ZXIlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMGxhYmVsX25hbWVzJTNEJTVCJTIybGFiZWxzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwcHVzaF90b19odWIlM0RUcnVlJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Seq2SeqTrainingArguments

training_args = Seq2SeqTrainingArguments(
    output_dir=<span class="hljs-string">&quot;speecht5_finetuned_voxpopuli_nl&quot;</span>,  <span class="hljs-comment"># change to a repo name of your choice</span>
    per_device_train_batch_size=<span class="hljs-number">4</span>,
    gradient_accumulation_steps=<span class="hljs-number">8</span>,
    learning_rate=<span class="hljs-number">1e-5</span>,
    warmup_steps=<span class="hljs-number">500</span>,
    max_steps=<span class="hljs-number">4000</span>,
    gradient_checkpointing=<span class="hljs-literal">True</span>,
    fp16=<span class="hljs-literal">True</span>,
    evaluation_strategy=<span class="hljs-string">&quot;steps&quot;</span>,
    per_device_eval_batch_size=<span class="hljs-number">2</span>,
    save_steps=<span class="hljs-number">1000</span>,
    eval_steps=<span class="hljs-number">1000</span>,
    logging_steps=<span class="hljs-number">25</span>,
    report_to=[<span class="hljs-string">&quot;tensorboard&quot;</span>],
    load_best_model_at_end=<span class="hljs-literal">True</span>,
    greater_is_better=<span class="hljs-literal">False</span>,
    label_names=[<span class="hljs-string">&quot;labels&quot;</span>],
    push_to_hub=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),mt=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlcTJTZXFUcmFpbmVyJTBBJTBBdHJhaW5lciUyMCUzRCUyMFNlcTJTZXFUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0RkYXRhc2V0JTVCJTIydGVzdCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0RkYXRhX2NvbGxhdG9yJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEcHJvY2Vzc29yJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Seq2SeqTrainer

trainer = Seq2SeqTrainer(
    args=training_args,
    model=model,
    train_dataset=dataset[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=dataset[<span class="hljs-string">&quot;test&quot;</span>],
    data_collator=data_collator,
    tokenizer=processor,
)`,wrap:!1}}),yt=new u({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:"trainer.train()",wrap:!1}}),dt=new u({props:{code:"dHJhaW5lci5wdXNoX3RvX2h1Yigp",highlighted:"trainer.push_to_hub()",wrap:!1}}),wt=new J({props:{title:"Inference",local:"inference",headingTag:"h2"}}),Tt=new u({props:{code:"bW9kZWwlMjAlM0QlMjBTcGVlY2hUNUZvclRleHRUb1NwZWVjaC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyWU9VUl9BQ0NPVU5UJTJGc3BlZWNodDVfZmluZXR1bmVkX3ZveHBvcHVsaV9ubCUyMiUwQSk=",highlighted:`model = SpeechT5ForTextToSpeech.from_pretrained(
    <span class="hljs-string">&quot;YOUR_ACCOUNT/speecht5_finetuned_voxpopuli_nl&quot;</span>
)`,wrap:!1}}),ft=new u({props:{code:"ZXhhbXBsZSUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVEJTVCMzA0JTVEJTBBc3BlYWtlcl9lbWJlZGRpbmdzJTIwJTNEJTIwdG9yY2gudGVuc29yKGV4YW1wbGUlNUIlMjJzcGVha2VyX2VtYmVkZGluZ3MlMjIlNUQpLnVuc3F1ZWV6ZSgwKQ==",highlighted:`example = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-number">304</span>]
speaker_embeddings = torch.tensor(example[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>]).unsqueeze(<span class="hljs-number">0</span>)`,wrap:!1}}),bt=new u({props:{code:"dGV4dCUyMCUzRCUyMCUyMmhhbGxvJTIwYWxsZW1hYWwlMkMlMjBpayUyMHByYWF0JTIwbmVkZXJsYW5kcy4lMjBncm9ldGplcyUyMGFhbiUyMGllZGVyZWVuISUyMg==",highlighted:'text = <span class="hljs-string">&quot;hallo allemaal, ik praat nederlands. groetjes aan iedereen!&quot;</span>',wrap:!1}}),It=new u({props:{code:"aW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKHRleHQlM0R0ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:'inputs = processor(text=text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)',wrap:!1}}),$t=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaFQ1SGlmaUdhbiUwQSUwQXZvY29kZXIlMjAlM0QlMjBTcGVlY2hUNUhpZmlHYW4uZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnNwZWVjaHQ1X2hpZmlnYW4lMjIpJTBBc3BlZWNoJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGVfc3BlZWNoKGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCUyQyUyMHNwZWFrZXJfZW1iZWRkaW5ncyUyQyUyMHZvY29kZXIlM0R2b2NvZGVyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SpeechT5HifiGan

vocoder = SpeechT5HifiGan.from_pretrained(<span class="hljs-string">&quot;microsoft/speecht5_hifigan&quot;</span>)
speech = model.generate_speech(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], speaker_embeddings, vocoder=vocoder)`,wrap:!1}}),xt=new u({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBJTBBQXVkaW8oc3BlZWNoLm51bXB5KCklMkMlMjByYXRlJTNEMTYwMDAp",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Audio

Audio(speech.numpy(), rate=<span class="hljs-number">16000</span>)`,wrap:!1}}),Vt=new Tn({props:{source:"https://github.com/huggingface/audio-transformers-course/blob/main/chapters/en/chapter6/fine-tuning.mdx"}}),{c(){d=p("meta"),j=a(),w=p("p"),Bt=a(),M(b.$$.fragment),Xt=a(),C=p("p"),C.textContent=Os,Rt=a(),M(I.$$.fragment),Yt=a(),g=p("p"),g.textContent=ea,Qt=a(),M($.$$.fragment),Nt=a(),M(T.$$.fragment),At=a(),k=p("p"),k.textContent=ta,zt=a(),M(x.$$.fragment),Ft=a(),Z=p("p"),Z.textContent=la,Et=a(),M(v.$$.fragment),Ht=a(),M(G.$$.fragment),qt=a(),V=p("p"),V.innerHTML=sa,St=a(),B=p("p"),B.textContent=aa,Dt=a(),W=p("p"),W.textContent=na,Lt=a(),M(_.$$.fragment),Pt=a(),X=p("p"),X.innerHTML=pa,Kt=a(),M(R.$$.fragment),Ot=a(),Y=p("p"),Y.textContent=ia,el=a(),M(Q.$$.fragment),tl=a(),M(N.$$.fragment),ll=a(),A=p("p"),A.textContent=ra,sl=a(),M(z.$$.fragment),al=a(),M(F.$$.fragment),nl=a(),E=p("p"),E.textContent=Ma,pl=a(),M(H.$$.fragment),il=a(),q=p("p"),q.textContent=oa,rl=a(),M(S.$$.fragment),Ml=a(),D=p("p"),D.innerHTML=ca,ol=a(),M(L.$$.fragment),cl=a(),P=p("p"),P.innerHTML=ma,ml=a(),K=p("p"),K.innerHTML=ha,hl=a(),O=p("p"),O.innerHTML=ya,yl=a(),M(ee.$$.fragment),ul=a(),te=p("p"),te.textContent=ua,dl=a(),M(le.$$.fragment),wl=a(),se=p("p"),se.innerHTML=da,Jl=a(),M(ae.$$.fragment),Tl=a(),ne=p("p"),ne.innerHTML=wa,Ul=a(),M(pe.$$.fragment),fl=a(),ie=p("p"),ie.textContent=Ja,jl=a(),M(re.$$.fragment),bl=a(),Me=p("p"),Me.textContent=Ta,Cl=a(),M(oe.$$.fragment),Il=a(),ce=p("p"),ce.textContent=Ua,gl=a(),M(me.$$.fragment),$l=a(),U=p("div"),U.innerHTML=fa,kl=a(),he=p("p"),he.textContent=ja,xl=a(),M(ye.$$.fragment),Zl=a(),ue=p("p"),ue.textContent=ba,vl=a(),M(de.$$.fragment),Gl=a(),we=p("p"),we.innerHTML=Ca,Vl=a(),M(Je.$$.fragment),Bl=a(),Te=p("p"),Te.textContent=Ia,Wl=a(),M(Ue.$$.fragment),_l=a(),fe=p("p"),fe.innerHTML=ga,Xl=a(),M(je.$$.fragment),Rl=a(),be=p("p"),be.textContent=$a,Yl=a(),Ce=p("p"),Ce.textContent=ka,Ql=a(),M(Ie.$$.fragment),Nl=a(),ge=p("p"),ge.innerHTML=xa,Al=a(),$e=p("p"),$e.innerHTML=Za,zl=a(),M(ke.$$.fragment),Fl=a(),xe=p("p"),xe.innerHTML=va,El=a(),Ze=p("p"),Ze.innerHTML=Ga,Hl=a(),M(ve.$$.fragment),ql=a(),Ge=p("p"),Ge.innerHTML=Va,Sl=a(),M(Ve.$$.fragment),Dl=a(),Be=p("p"),Be.textContent=Ba,Ll=a(),M(We.$$.fragment),Pl=a(),_e=p("p"),_e.innerHTML=Wa,Kl=a(),M(Xe.$$.fragment),Ol=a(),Re=p("p"),Re.textContent=_a,es=a(),M(Ye.$$.fragment),ts=a(),Qe=p("p"),Qe.innerHTML=Xa,ls=a(),M(Ne.$$.fragment),ss=a(),Ae=p("p"),Ae.textContent=Ra,as=a(),M(ze.$$.fragment),ns=a(),f=p("div"),f.innerHTML=Ya,ps=a(),Fe=p("p"),Fe.textContent=Qa,is=a(),Ee=p("p"),Ee.textContent=Na,rs=a(),M(He.$$.fragment),Ms=a(),qe=p("p"),qe.textContent=Aa,os=a(),M(Se.$$.fragment),cs=a(),De=p("p"),De.innerHTML=za,ms=a(),M(Le.$$.fragment),hs=a(),Pe=p("p"),Pe.textContent=Fa,ys=a(),M(Ke.$$.fragment),us=a(),M(Oe.$$.fragment),ds=a(),et=p("p"),et.innerHTML=Ea,ws=a(),M(tt.$$.fragment),Js=a(),lt=p("p"),lt.textContent=Ha,Ts=a(),M(st.$$.fragment),Us=a(),M(at.$$.fragment),fs=a(),nt=p("p"),nt.textContent=qa,js=a(),M(pt.$$.fragment),bs=a(),it=p("p"),it.innerHTML=Sa,Cs=a(),M(rt.$$.fragment),Is=a(),Mt=p("p"),Mt.textContent=Da,gs=a(),M(ot.$$.fragment),$s=a(),ct=p("p"),ct.innerHTML=La,ks=a(),M(mt.$$.fragment),xs=a(),ht=p("p"),ht.innerHTML=Pa,Zs=a(),M(yt.$$.fragment),vs=a(),ut=p("p"),ut.textContent=Ka,Gs=a(),M(dt.$$.fragment),Vs=a(),M(wt.$$.fragment),Bs=a(),Jt=p("p"),Jt.textContent=Oa,Ws=a(),M(Tt.$$.fragment),_s=a(),Ut=p("p"),Ut.textContent=en,Xs=a(),M(ft.$$.fragment),Rs=a(),jt=p("p"),jt.textContent=tn,Ys=a(),M(bt.$$.fragment),Qs=a(),Ct=p("p"),Ct.textContent=ln,Ns=a(),M(It.$$.fragment),As=a(),gt=p("p"),gt.textContent=sn,zs=a(),M($t.$$.fragment),Fs=a(),kt=p("p"),kt.textContent=an,Es=a(),M(xt.$$.fragment),Hs=a(),Zt=p("p"),Zt.textContent=nn,qs=a(),vt=p("p"),vt.innerHTML=pn,Ss=a(),Gt=p("p"),Gt.textContent=rn,Ds=a(),M(Vt.$$.fragment),Ls=a(),Wt=p("p"),this.h()},l(e){const t=dn("svelte-u9bgzb",document.head);d=i(t,"META",{name:!0,content:!0}),t.forEach(l),j=n(e),w=i(e,"P",{}),on(w).forEach(l),Bt=n(e),o(b.$$.fragment,e),Xt=n(e),C=i(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-6isf2f"&&(C.textContent=Os),Rt=n(e),o(I.$$.fragment,e),Yt=n(e),g=i(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1pl1dgp"&&(g.textContent=ea),Qt=n(e),o($.$$.fragment,e),Nt=n(e),o(T.$$.fragment,e),At=n(e),k=i(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-9u3xmt"&&(k.textContent=ta),zt=n(e),o(x.$$.fragment,e),Ft=n(e),Z=i(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1lsy5mj"&&(Z.textContent=la),Et=n(e),o(v.$$.fragment,e),Ht=n(e),o(G.$$.fragment,e),qt=n(e),V=i(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1ixb96o"&&(V.innerHTML=sa),St=n(e),B=i(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1p30ok7"&&(B.textContent=aa),Dt=n(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1soaqfm"&&(W.textContent=na),Lt=n(e),o(_.$$.fragment,e),Pt=n(e),X=i(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1mvdyro"&&(X.innerHTML=pa),Kt=n(e),o(R.$$.fragment,e),Ot=n(e),Y=i(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1xdebij"&&(Y.textContent=ia),el=n(e),o(Q.$$.fragment,e),tl=n(e),o(N.$$.fragment,e),ll=n(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1k7tad6"&&(A.textContent=ra),sl=n(e),o(z.$$.fragment,e),al=n(e),o(F.$$.fragment,e),nl=n(e),E=i(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-a1pl49"&&(E.textContent=Ma),pl=n(e),o(H.$$.fragment,e),il=n(e),q=i(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-17epgem"&&(q.textContent=oa),rl=n(e),o(S.$$.fragment,e),Ml=n(e),D=i(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1mvdyro"&&(D.innerHTML=ca),ol=n(e),o(L.$$.fragment,e),cl=n(e),P=i(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-y5gqfm"&&(P.innerHTML=ma),ml=n(e),K=i(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1qiuc1m"&&(K.innerHTML=ha),hl=n(e),O=i(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-19dff1r"&&(O.innerHTML=ya),yl=n(e),o(ee.$$.fragment,e),ul=n(e),te=i(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-fefaym"&&(te.textContent=ua),dl=n(e),o(le.$$.fragment,e),wl=n(e),se=i(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1mvdyro"&&(se.innerHTML=da),Jl=n(e),o(ae.$$.fragment,e),Tl=n(e),ne=i(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-akzhx6"&&(ne.innerHTML=wa),Ul=n(e),o(pe.$$.fragment,e),fl=n(e),ie=i(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-hhu8o3"&&(ie.textContent=Ja),jl=n(e),o(re.$$.fragment,e),bl=n(e),Me=i(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-1edo483"&&(Me.textContent=Ta),Cl=n(e),o(oe.$$.fragment,e),Il=n(e),ce=i(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-1hah56a"&&(ce.textContent=Ua),gl=n(e),o(me.$$.fragment,e),$l=n(e),U=i(e,"DIV",{class:!0,"data-svelte-h":!0}),r(U)!=="svelte-1uufiik"&&(U.innerHTML=fa),kl=n(e),he=i(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-1ujf40"&&(he.textContent=ja),xl=n(e),o(ye.$$.fragment,e),Zl=n(e),ue=i(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-g2dd32"&&(ue.textContent=ba),vl=n(e),o(de.$$.fragment,e),Gl=n(e),we=i(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-1mvdyro"&&(we.innerHTML=Ca),Vl=n(e),o(Je.$$.fragment,e),Bl=n(e),Te=i(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-hbes5t"&&(Te.textContent=Ia),Wl=n(e),o(Ue.$$.fragment,e),_l=n(e),fe=i(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-1mvdyro"&&(fe.innerHTML=ga),Xl=n(e),o(je.$$.fragment,e),Rl=n(e),be=i(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-oizlk1"&&(be.textContent=$a),Yl=n(e),Ce=i(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-1n0u7fp"&&(Ce.textContent=ka),Ql=n(e),o(Ie.$$.fragment,e),Nl=n(e),ge=i(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-1xdfpy2"&&(ge.innerHTML=xa),Al=n(e),$e=i(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-7nncma"&&($e.innerHTML=Za),zl=n(e),o(ke.$$.fragment,e),Fl=n(e),xe=i(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-1mtxkxr"&&(xe.innerHTML=va),El=n(e),Ze=i(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-15ol8sg"&&(Ze.innerHTML=Ga),Hl=n(e),o(ve.$$.fragment,e),ql=n(e),Ge=i(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-1tlidee"&&(Ge.innerHTML=Va),Sl=n(e),o(Ve.$$.fragment,e),Dl=n(e),Be=i(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-17mzfft"&&(Be.textContent=Ba),Ll=n(e),o(We.$$.fragment,e),Pl=n(e),_e=i(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-1mvdyro"&&(_e.innerHTML=Wa),Kl=n(e),o(Xe.$$.fragment,e),Ol=n(e),Re=i(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-1mqg4ck"&&(Re.textContent=_a),es=n(e),o(Ye.$$.fragment,e),ts=n(e),Qe=i(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-1mvdyro"&&(Qe.innerHTML=Xa),ls=n(e),o(Ne.$$.fragment,e),ss=n(e),Ae=i(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-f7g58h"&&(Ae.textContent=Ra),as=n(e),o(ze.$$.fragment,e),ns=n(e),f=i(e,"DIV",{class:!0,"data-svelte-h":!0}),r(f)!=="svelte-j4o1b8"&&(f.innerHTML=Ya),ps=n(e),Fe=i(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-1t9vz0y"&&(Fe.textContent=Qa),is=n(e),Ee=i(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-7crb3r"&&(Ee.textContent=Na),rs=n(e),o(He.$$.fragment,e),Ms=n(e),qe=i(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-wvyh3r"&&(qe.textContent=Aa),os=n(e),o(Se.$$.fragment,e),cs=n(e),De=i(e,"P",{"data-svelte-h":!0}),r(De)!=="svelte-1mvdyro"&&(De.innerHTML=za),ms=n(e),o(Le.$$.fragment,e),hs=n(e),Pe=i(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-12gx63x"&&(Pe.textContent=Fa),ys=n(e),o(Ke.$$.fragment,e),us=n(e),o(Oe.$$.fragment,e),ds=n(e),et=i(e,"P",{"data-svelte-h":!0}),r(et)!=="svelte-rsy2my"&&(et.innerHTML=Ea),ws=n(e),o(tt.$$.fragment,e),Js=n(e),lt=i(e,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-u623yc"&&(lt.textContent=Ha),Ts=n(e),o(st.$$.fragment,e),Us=n(e),o(at.$$.fragment,e),fs=n(e),nt=i(e,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-1kkriue"&&(nt.textContent=qa),js=n(e),o(pt.$$.fragment,e),bs=n(e),it=i(e,"P",{"data-svelte-h":!0}),r(it)!=="svelte-1fpvhw6"&&(it.innerHTML=Sa),Cs=n(e),o(rt.$$.fragment,e),Is=n(e),Mt=i(e,"P",{"data-svelte-h":!0}),r(Mt)!=="svelte-1af5qye"&&(Mt.textContent=Da),gs=n(e),o(ot.$$.fragment,e),$s=n(e),ct=i(e,"P",{"data-svelte-h":!0}),r(ct)!=="svelte-1yq1u47"&&(ct.innerHTML=La),ks=n(e),o(mt.$$.fragment,e),xs=n(e),ht=i(e,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-98ddde"&&(ht.innerHTML=Pa),Zs=n(e),o(yt.$$.fragment,e),vs=n(e),ut=i(e,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-hefgo2"&&(ut.textContent=Ka),Gs=n(e),o(dt.$$.fragment,e),Vs=n(e),o(wt.$$.fragment,e),Bs=n(e),Jt=i(e,"P",{"data-svelte-h":!0}),r(Jt)!=="svelte-vqys4o"&&(Jt.textContent=Oa),Ws=n(e),o(Tt.$$.fragment,e),_s=n(e),Ut=i(e,"P",{"data-svelte-h":!0}),r(Ut)!=="svelte-kiuzrb"&&(Ut.textContent=en),Xs=n(e),o(ft.$$.fragment,e),Rs=n(e),jt=i(e,"P",{"data-svelte-h":!0}),r(jt)!=="svelte-1sn5mu7"&&(jt.textContent=tn),Ys=n(e),o(bt.$$.fragment,e),Qs=n(e),Ct=i(e,"P",{"data-svelte-h":!0}),r(Ct)!=="svelte-1sf6bxe"&&(Ct.textContent=ln),Ns=n(e),o(It.$$.fragment,e),As=n(e),gt=i(e,"P",{"data-svelte-h":!0}),r(gt)!=="svelte-1kfdmvn"&&(gt.textContent=sn),zs=n(e),o($t.$$.fragment,e),Fs=n(e),kt=i(e,"P",{"data-svelte-h":!0}),r(kt)!=="svelte-jp0xjb"&&(kt.textContent=an),Es=n(e),o(xt.$$.fragment,e),Hs=n(e),Zt=i(e,"P",{"data-svelte-h":!0}),r(Zt)!=="svelte-yji0sl"&&(Zt.textContent=nn),qs=n(e),vt=i(e,"P",{"data-svelte-h":!0}),r(vt)!=="svelte-6lmfh0"&&(vt.innerHTML=pn),Ss=n(e),Gt=i(e,"P",{"data-svelte-h":!0}),r(Gt)!=="svelte-bv2cz9"&&(Gt.textContent=rn),Ds=n(e),o(Vt.$$.fragment,e),Ls=n(e),Wt=i(e,"P",{}),on(Wt).forEach(l),this.h()},h(){Ks(d,"name","hf:doc:metadata"),Ks(d,"content",jn),Ks(U,"class","flex justify-center"),Ks(f,"class","flex justify-center")},m(e,t){wn(document.head,d),s(e,j,t),s(e,w,t),s(e,Bt,t),c(b,e,t),s(e,Xt,t),s(e,C,t),s(e,Rt,t),c(I,e,t),s(e,Yt,t),s(e,g,t),s(e,Qt,t),c($,e,t),s(e,Nt,t),c(T,e,t),s(e,At,t),s(e,k,t),s(e,zt,t),c(x,e,t),s(e,Ft,t),s(e,Z,t),s(e,Et,t),c(v,e,t),s(e,Ht,t),c(G,e,t),s(e,qt,t),s(e,V,t),s(e,St,t),s(e,B,t),s(e,Dt,t),s(e,W,t),s(e,Lt,t),c(_,e,t),s(e,Pt,t),s(e,X,t),s(e,Kt,t),c(R,e,t),s(e,Ot,t),s(e,Y,t),s(e,el,t),c(Q,e,t),s(e,tl,t),c(N,e,t),s(e,ll,t),s(e,A,t),s(e,sl,t),c(z,e,t),s(e,al,t),c(F,e,t),s(e,nl,t),s(e,E,t),s(e,pl,t),c(H,e,t),s(e,il,t),s(e,q,t),s(e,rl,t),c(S,e,t),s(e,Ml,t),s(e,D,t),s(e,ol,t),c(L,e,t),s(e,cl,t),s(e,P,t),s(e,ml,t),s(e,K,t),s(e,hl,t),s(e,O,t),s(e,yl,t),c(ee,e,t),s(e,ul,t),s(e,te,t),s(e,dl,t),c(le,e,t),s(e,wl,t),s(e,se,t),s(e,Jl,t),c(ae,e,t),s(e,Tl,t),s(e,ne,t),s(e,Ul,t),c(pe,e,t),s(e,fl,t),s(e,ie,t),s(e,jl,t),c(re,e,t),s(e,bl,t),s(e,Me,t),s(e,Cl,t),c(oe,e,t),s(e,Il,t),s(e,ce,t),s(e,gl,t),c(me,e,t),s(e,$l,t),s(e,U,t),s(e,kl,t),s(e,he,t),s(e,xl,t),c(ye,e,t),s(e,Zl,t),s(e,ue,t),s(e,vl,t),c(de,e,t),s(e,Gl,t),s(e,we,t),s(e,Vl,t),c(Je,e,t),s(e,Bl,t),s(e,Te,t),s(e,Wl,t),c(Ue,e,t),s(e,_l,t),s(e,fe,t),s(e,Xl,t),c(je,e,t),s(e,Rl,t),s(e,be,t),s(e,Yl,t),s(e,Ce,t),s(e,Ql,t),c(Ie,e,t),s(e,Nl,t),s(e,ge,t),s(e,Al,t),s(e,$e,t),s(e,zl,t),c(ke,e,t),s(e,Fl,t),s(e,xe,t),s(e,El,t),s(e,Ze,t),s(e,Hl,t),c(ve,e,t),s(e,ql,t),s(e,Ge,t),s(e,Sl,t),c(Ve,e,t),s(e,Dl,t),s(e,Be,t),s(e,Ll,t),c(We,e,t),s(e,Pl,t),s(e,_e,t),s(e,Kl,t),c(Xe,e,t),s(e,Ol,t),s(e,Re,t),s(e,es,t),c(Ye,e,t),s(e,ts,t),s(e,Qe,t),s(e,ls,t),c(Ne,e,t),s(e,ss,t),s(e,Ae,t),s(e,as,t),c(ze,e,t),s(e,ns,t),s(e,f,t),s(e,ps,t),s(e,Fe,t),s(e,is,t),s(e,Ee,t),s(e,rs,t),c(He,e,t),s(e,Ms,t),s(e,qe,t),s(e,os,t),c(Se,e,t),s(e,cs,t),s(e,De,t),s(e,ms,t),c(Le,e,t),s(e,hs,t),s(e,Pe,t),s(e,ys,t),c(Ke,e,t),s(e,us,t),c(Oe,e,t),s(e,ds,t),s(e,et,t),s(e,ws,t),c(tt,e,t),s(e,Js,t),s(e,lt,t),s(e,Ts,t),c(st,e,t),s(e,Us,t),c(at,e,t),s(e,fs,t),s(e,nt,t),s(e,js,t),c(pt,e,t),s(e,bs,t),s(e,it,t),s(e,Cs,t),c(rt,e,t),s(e,Is,t),s(e,Mt,t),s(e,gs,t),c(ot,e,t),s(e,$s,t),s(e,ct,t),s(e,ks,t),c(mt,e,t),s(e,xs,t),s(e,ht,t),s(e,Zs,t),c(yt,e,t),s(e,vs,t),s(e,ut,t),s(e,Gs,t),c(dt,e,t),s(e,Vs,t),c(wt,e,t),s(e,Bs,t),s(e,Jt,t),s(e,Ws,t),c(Tt,e,t),s(e,_s,t),s(e,Ut,t),s(e,Xs,t),c(ft,e,t),s(e,Rs,t),s(e,jt,t),s(e,Ys,t),c(bt,e,t),s(e,Qs,t),s(e,Ct,t),s(e,Ns,t),c(It,e,t),s(e,As,t),s(e,gt,t),s(e,zs,t),c($t,e,t),s(e,Fs,t),s(e,kt,t),s(e,Es,t),c(xt,e,t),s(e,Hs,t),s(e,Zt,t),s(e,qs,t),s(e,vt,t),s(e,Ss,t),s(e,Gt,t),s(e,Ds,t),c(Vt,e,t),s(e,Ls,t),s(e,Wt,t),Ps=!0},p(e,[t]){const Mn={};t&2&&(Mn.$$scope={dirty:t,ctx:e}),T.$set(Mn)},i(e){Ps||(m(b.$$.fragment,e),m(I.$$.fragment,e),m($.$$.fragment,e),m(T.$$.fragment,e),m(x.$$.fragment,e),m(v.$$.fragment,e),m(G.$$.fragment,e),m(_.$$.fragment,e),m(R.$$.fragment,e),m(Q.$$.fragment,e),m(N.$$.fragment,e),m(z.$$.fragment,e),m(F.$$.fragment,e),m(H.$$.fragment,e),m(S.$$.fragment,e),m(L.$$.fragment,e),m(ee.$$.fragment,e),m(le.$$.fragment,e),m(ae.$$.fragment,e),m(pe.$$.fragment,e),m(re.$$.fragment,e),m(oe.$$.fragment,e),m(me.$$.fragment,e),m(ye.$$.fragment,e),m(de.$$.fragment,e),m(Je.$$.fragment,e),m(Ue.$$.fragment,e),m(je.$$.fragment,e),m(Ie.$$.fragment,e),m(ke.$$.fragment,e),m(ve.$$.fragment,e),m(Ve.$$.fragment,e),m(We.$$.fragment,e),m(Xe.$$.fragment,e),m(Ye.$$.fragment,e),m(Ne.$$.fragment,e),m(ze.$$.fragment,e),m(He.$$.fragment,e),m(Se.$$.fragment,e),m(Le.$$.fragment,e),m(Ke.$$.fragment,e),m(Oe.$$.fragment,e),m(tt.$$.fragment,e),m(st.$$.fragment,e),m(at.$$.fragment,e),m(pt.$$.fragment,e),m(rt.$$.fragment,e),m(ot.$$.fragment,e),m(mt.$$.fragment,e),m(yt.$$.fragment,e),m(dt.$$.fragment,e),m(wt.$$.fragment,e),m(Tt.$$.fragment,e),m(ft.$$.fragment,e),m(bt.$$.fragment,e),m(It.$$.fragment,e),m($t.$$.fragment,e),m(xt.$$.fragment,e),m(Vt.$$.fragment,e),Ps=!0)},o(e){h(b.$$.fragment,e),h(I.$$.fragment,e),h($.$$.fragment,e),h(T.$$.fragment,e),h(x.$$.fragment,e),h(v.$$.fragment,e),h(G.$$.fragment,e),h(_.$$.fragment,e),h(R.$$.fragment,e),h(Q.$$.fragment,e),h(N.$$.fragment,e),h(z.$$.fragment,e),h(F.$$.fragment,e),h(H.$$.fragment,e),h(S.$$.fragment,e),h(L.$$.fragment,e),h(ee.$$.fragment,e),h(le.$$.fragment,e),h(ae.$$.fragment,e),h(pe.$$.fragment,e),h(re.$$.fragment,e),h(oe.$$.fragment,e),h(me.$$.fragment,e),h(ye.$$.fragment,e),h(de.$$.fragment,e),h(Je.$$.fragment,e),h(Ue.$$.fragment,e),h(je.$$.fragment,e),h(Ie.$$.fragment,e),h(ke.$$.fragment,e),h(ve.$$.fragment,e),h(Ve.$$.fragment,e),h(We.$$.fragment,e),h(Xe.$$.fragment,e),h(Ye.$$.fragment,e),h(Ne.$$.fragment,e),h(ze.$$.fragment,e),h(He.$$.fragment,e),h(Se.$$.fragment,e),h(Le.$$.fragment,e),h(Ke.$$.fragment,e),h(Oe.$$.fragment,e),h(tt.$$.fragment,e),h(st.$$.fragment,e),h(at.$$.fragment,e),h(pt.$$.fragment,e),h(rt.$$.fragment,e),h(ot.$$.fragment,e),h(mt.$$.fragment,e),h(yt.$$.fragment,e),h(dt.$$.fragment,e),h(wt.$$.fragment,e),h(Tt.$$.fragment,e),h(ft.$$.fragment,e),h(bt.$$.fragment,e),h(It.$$.fragment,e),h($t.$$.fragment,e),h(xt.$$.fragment,e),h(Vt.$$.fragment,e),Ps=!1},d(e){e&&(l(j),l(w),l(Bt),l(Xt),l(C),l(Rt),l(Yt),l(g),l(Qt),l(Nt),l(At),l(k),l(zt),l(Ft),l(Z),l(Et),l(Ht),l(qt),l(V),l(St),l(B),l(Dt),l(W),l(Lt),l(Pt),l(X),l(Kt),l(Ot),l(Y),l(el),l(tl),l(ll),l(A),l(sl),l(al),l(nl),l(E),l(pl),l(il),l(q),l(rl),l(Ml),l(D),l(ol),l(cl),l(P),l(ml),l(K),l(hl),l(O),l(yl),l(ul),l(te),l(dl),l(wl),l(se),l(Jl),l(Tl),l(ne),l(Ul),l(fl),l(ie),l(jl),l(bl),l(Me),l(Cl),l(Il),l(ce),l(gl),l($l),l(U),l(kl),l(he),l(xl),l(Zl),l(ue),l(vl),l(Gl),l(we),l(Vl),l(Bl),l(Te),l(Wl),l(_l),l(fe),l(Xl),l(Rl),l(be),l(Yl),l(Ce),l(Ql),l(Nl),l(ge),l(Al),l($e),l(zl),l(Fl),l(xe),l(El),l(Ze),l(Hl),l(ql),l(Ge),l(Sl),l(Dl),l(Be),l(Ll),l(Pl),l(_e),l(Kl),l(Ol),l(Re),l(es),l(ts),l(Qe),l(ls),l(ss),l(Ae),l(as),l(ns),l(f),l(ps),l(Fe),l(is),l(Ee),l(rs),l(Ms),l(qe),l(os),l(cs),l(De),l(ms),l(hs),l(Pe),l(ys),l(us),l(ds),l(et),l(ws),l(Js),l(lt),l(Ts),l(Us),l(fs),l(nt),l(js),l(bs),l(it),l(Cs),l(Is),l(Mt),l(gs),l($s),l(ct),l(ks),l(xs),l(ht),l(Zs),l(vs),l(ut),l(Gs),l(Vs),l(Bs),l(Jt),l(Ws),l(_s),l(Ut),l(Xs),l(Rs),l(jt),l(Ys),l(Qs),l(Ct),l(Ns),l(As),l(gt),l(zs),l(Fs),l(kt),l(Es),l(Hs),l(Zt),l(qs),l(vt),l(Ss),l(Gt),l(Ds),l(Ls),l(Wt)),l(d),y(b,e),y(I,e),y($,e),y(T,e),y(x,e),y(v,e),y(G,e),y(_,e),y(R,e),y(Q,e),y(N,e),y(z,e),y(F,e),y(H,e),y(S,e),y(L,e),y(ee,e),y(le,e),y(ae,e),y(pe,e),y(re,e),y(oe,e),y(me,e),y(ye,e),y(de,e),y(Je,e),y(Ue,e),y(je,e),y(Ie,e),y(ke,e),y(ve,e),y(Ve,e),y(We,e),y(Xe,e),y(Ye,e),y(Ne,e),y(ze,e),y(He,e),y(Se,e),y(Le,e),y(Ke,e),y(Oe,e),y(tt,e),y(st,e),y(at,e),y(pt,e),y(rt,e),y(ot,e),y(mt,e),y(yt,e),y(dt,e),y(wt,e),y(Tt,e),y(ft,e),y(bt,e),y(It,e),y($t,e),y(xt,e),y(Vt,e)}}}const jn='{"title":"Fine-tuning SpeechT5","local":"fine-tuning-speecht5","sections":[{"title":"House-keeping","local":"house-keeping","sections":[],"depth":2},{"title":"The dataset","local":"the-dataset","sections":[],"depth":2},{"title":"Preprocessing the data","local":"preprocessing-the-data","sections":[{"title":"Text cleanup for SpeechT5 tokenization","local":"text-cleanup-for-speecht5-tokenization","sections":[],"depth":3},{"title":"Speakers","local":"speakers","sections":[],"depth":3},{"title":"Speaker embeddings","local":"speaker-embeddings","sections":[],"depth":3},{"title":"Processing the dataset","local":"processing-the-dataset","sections":[],"depth":3},{"title":"Data collator","local":"data-collator","sections":[],"depth":3}],"depth":2},{"title":"Train the model","local":"train-the-model","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[],"depth":2}],"depth":1}';function bn(_t){return mn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class xn extends yn{constructor(d){super(),un(this,d,bn,fn,cn,{})}}export{xn as component};
