import{s as en,o as ln,n as nn}from"../chunks/scheduler.9bc65507.js";import{S as sn,i as an,g as i,s,u as w,A as on,h as o,f as e,c as a,j as y,v as T,y as r,k as M,o as p,a as n,w as h,d as u,t as J,x as d}from"../chunks/index.78c82d43.js";import{T as rn}from"../chunks/Tip.87d55b76.js";import{I as Zt}from"../chunks/IconCopyLink.bedaa44d.js";import{C as U}from"../chunks/CodeBlock.48618ec2.js";function Mn(Ht){let m,Q=`If you plan to run multiple experiments, in order to properly clear the memory between experiments, restart the Python
kernel between experiments.`;return{c(){m=i("p"),m.textContent=Q},l(c){m=o(c,"P",{"data-svelte-h":!0}),r(m)!=="svelte-1v4397i"&&(m.textContent=Q)},m(c,Rt){n(c,m,Rt)},p:nn,d(c){c&&e(m)}}}function pn(Ht){let m,Q,c,Rt,f,A,Et,R,Oe,xt,nl="Model training anatomy",Ft,x,sl=`To understand performance optimization techniques that one can apply to improve efficiency of model training
speed and memory utilization, it’s helpful to get familiar with how GPU is utilized during training, and how compute
intensity varies depending on an operation performed.`,Xt,$,al=`Let’s start by exploring a motivating example of GPU utilization and the training run of a model. For the demonstration,
we’ll need to install a few libraries:`,Dt,k,qt,_,il=`The <code>nvidia-ml-py3</code> library allows us to monitor the memory usage of the models from within Python. You might be familiar
with the <code>nvidia-smi</code> command in the terminal - this library allows to access the same information in Python directly.`,Yt,G,ol=`Then, we create some dummy data: random token IDs between 100 and 30000 and binary labels for a classifier.
In total, we get 512 sequences each with length 512 and store them in a <a href="https://huggingface.co/docs/datasets/v2.14.5/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">Dataset</a> with PyTorch format.`,Ot,E,Kt,B,rl='To print summary statistics for the GPU utilization and the training run with the <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer">Trainer</a> we define two helper functions:',te,P,ee,W,Ml="Let’s verify that we start with a free GPU memory:",le,N,ne,V,pl=`That looks good: the GPU memory is not occupied as we would expect before we load any models. If that’s not the case on
your machine make sure to stop all processes that are using GPU memory. However, not all free GPU memory can be used by
the user. When a model is loaded to the GPU the kernels are also loaded, which can take up 1-2GB of memory. To see how
much it is we load a tiny tensor into the GPU which triggers the kernels to be loaded as well.`,se,Z,ae,H,ml="We see that the kernels alone take up 1.3GB of GPU memory. Now let’s see how much space the model uses.",ie,C,v,Bt,F,Ke,$t,wl="Load Model",oe,X,yl=`First, we load the <code>bert-large-uncased</code> model. We load the model weights directly to the GPU so that we can check
how much space just the weights use.`,re,D,Me,q,Tl=`We can see that the model weights alone take up 1.3 GB of GPU memory. The exact number depends on the specific
GPU you are using. Note that on newer GPUs a model can sometimes take up more space since the weights are loaded in an
optimized fashion that speeds up the usage of the model. Now we can also quickly check if we get the same result
as with <code>nvidia-smi</code> CLI:`,pe,Y,me,O,we,K,hl=`We get the same number as before and you can also see that we are using a V100 GPU with 16GB of memory. So now we can
start training the model and see how the GPU memory consumption changes. First, we set up a few standard training
arguments:`,ye,tt,Te,S,he,j,b,Pt,et,tl,kt,ul="Memory utilization at vanilla training",ue,lt,Jl='Let’s use the <a href="/docs/transformers/v4.33.3/en/main_classes/trainer#transformers.Trainer">Trainer</a> and train the model without using any GPU performance optimization techniques and a batch size of 4:',Je,nt,de,st,ce,at,dl=`We see that already a relatively small batch size almost fills up our GPU’s entire memory. However, a larger batch size
can often result in faster model convergence or better end performance. So ideally we want to tune the batch size to our
model’s needs and not to the GPU limitations. What’s interesting is that we use much more memory than the size of the model.
To understand a bit better why this is the case let’s have a look at a model’s operations and memory needs.`,Ue,I,L,Wt,it,el,_t,cl="Anatomy of Model's Operations",fe,ot,Ul="Transformers architecture includes 3 main groups of operations grouped below by compute-intensity.",Ce,rt,fl="<li><p><strong>Tensor Contractions</strong></p> <p>Linear layers and components of Multi-Head Attention all do batched <strong>matrix-matrix multiplications</strong>. These operations are the most compute-intensive part of training a transformer.</p></li> <li><p><strong>Statistical Normalizations</strong></p> <p>Softmax and layer normalization are less compute-intensive than tensor contractions, and involve one or more <strong>reduction operations</strong>, the result of which is then applied via a map.</p></li> <li><p><strong>Element-wise Operators</strong></p> <p>These are the remaining operators: <strong>biases, dropout, activations, and residual connections</strong>. These are the least compute-intensive operations.</p></li>",je,Mt,Cl="This knowledge can be helpful to know when analyzing performance bottlenecks.",Ie,pt,jl='This summary is derived from <a href="https://arxiv.org/abs/2007.00072" rel="nofollow">Data Movement Is All You Need: A Case Study on Optimizing Transformers 2020</a>',ge,g,z,Nt,mt,ll,Gt,Il="Anatomy of Model's Memory",Ae,wt,gl=`We’ve seen that training the model uses much more memory than just putting the model on the GPU. This is because there
are many components during training that use GPU memory. The components on GPU memory are the following:`,ve,yt,Al="<li>model weights</li> <li>optimizer states</li> <li>gradients</li> <li>forward activations saved for gradient computation</li> <li>temporary buffers</li> <li>functionality-specific memory</li>",Se,Tt,vl=`A typical model trained in mixed precision with AdamW requires 18 bytes per model parameter plus activation memory. For
inference there are no optimizer states and gradients, so we can subtract those. And thus we end up with 6 bytes per
model parameter for mixed precision inference, plus activation memory.`,be,ht,Sl="Let’s look at the details.",Le,ut,bl="<strong>Model Weights:</strong>",ze,Jt,Ll="<li>4 bytes * number of parameters for fp32 training</li> <li>6 bytes * number of parameters for mixed precision training (maintains a model in fp32 and one in fp16 in memory)</li>",Qe,dt,zl="<strong>Optimizer States:</strong>",Re,ct,Ql='<li>8 bytes * number of parameters for normal AdamW (maintains 2 states)</li> <li>2 bytes * number of parameters for 8-bit AdamW optimizers like <a href="https://github.com/TimDettmers/bitsandbytes" rel="nofollow">bitsandbytes</a></li> <li>4 bytes * number of parameters for optimizers like SGD with momentum (maintains only 1 state)</li>',xe,Ut,Rl="<strong>Gradients</strong>",$e,ft,xl="<li>4 bytes * number of parameters for either fp32 or mixed precision training (gradients are always kept in fp32)</li>",ke,Ct,$l="<strong>Forward Activations</strong>",_e,jt,kl="<li>size depends on many factors, the key ones being sequence length, hidden size and batch size.</li>",Ge,It,_l=`There are the input and output that are being passed and returned by the forward and the backward functions and the
forward activations saved for gradient computation.`,Ee,gt,Gl="<strong>Temporary Memory</strong>",Be,At,El=`Additionally, there are all kinds of temporary variables which get released once the calculation is done, but in the
moment these could require additional memory and could push to OOM. Therefore, when coding it’s crucial to think
strategically about such temporary variables and sometimes to explicitly free those as soon as they are no longer needed.`,Pe,vt,Bl="<strong>Functionality-specific memory</strong>",We,St,Pl=`Then, your software could have special memory needs. For example, when generating text using beam search, the software
needs to maintain multiple copies of inputs and outputs.`,Ne,bt,Wl="<strong><code>forward</code> vs <code>backward</code> Execution Speed</strong>",Ve,Lt,Nl=`For convolutions and linear layers there are 2x flops in the backward compared to the forward, which generally translates
into ~2x slower (sometimes more, because sizes in the backward tend to be more awkward). Activations are usually
bandwidth-limited, and it’s typical for an activation to have to read more data in the backward than in the forward
(e.g. activation forward reads once, writes once, activation backward reads twice, gradOutput and output of the forward,
and writes once, gradInput).`,Ze,zt,Vl=`As you can see, there are potentially a few places where we could save GPU memory or speed up operations.
Now that you understand what affects GPU utilization and computation speed, refer to
the <a href="perf_train_gpu_one">Methods and tools for efficient training on a single GPU</a> documentation page to learn about
performance optimization techniques.`,He,Vt,Fe;return R=new Zt({}),k=new U({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMGRhdGFzZXRzJTIwYWNjZWxlcmF0ZSUyMG52aWRpYS1tbC1weTM=",highlighted:"pip install transformers datasets accelerate nvidia-ml-py3"}}),E=new U({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQSUwQSUwQXNlcV9sZW4lMkMlMjBkYXRhc2V0X3NpemUlMjAlM0QlMjA1MTIlMkMlMjA1MTIlMEFkdW1teV9kYXRhJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyaW5wdXRfaWRzJTIyJTNBJTIwbnAucmFuZG9tLnJhbmRpbnQoMTAwJTJDJTIwMzAwMDAlMkMlMjAoZGF0YXNldF9zaXplJTJDJTIwc2VxX2xlbikpJTJDJTBBJTIwJTIwJTIwJTIwJTIybGFiZWxzJTIyJTNBJTIwbnAucmFuZG9tLnJhbmRpbnQoMCUyQyUyMDElMkMlMjAoZGF0YXNldF9zaXplKSklMkMlMEElN0QlMEFkcyUyMCUzRCUyMERhdGFzZXQuZnJvbV9kaWN0KGR1bW15X2RhdGEpJTBBZHMuc2V0X2Zvcm1hdCglMjJwdCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset


<span class="hljs-meta">&gt;&gt;&gt; </span>seq_len, dataset_size = <span class="hljs-number">512</span>, <span class="hljs-number">512</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dummy_data = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;input_ids&quot;</span>: np.random.randint(<span class="hljs-number">100</span>, <span class="hljs-number">30000</span>, (dataset_size, seq_len)),
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;labels&quot;</span>: np.random.randint(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, (dataset_size)),
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict(dummy_data)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds.set_format(<span class="hljs-string">&quot;pt&quot;</span>)`}}),P=new U({props:{code:"ZnJvbSUyMHB5bnZtbCUyMGltcG9ydCUyMColMEElMEElMEFkZWYlMjBwcmludF9ncHVfdXRpbGl6YXRpb24oKSUzQSUwQSUyMCUyMCUyMCUyMG52bWxJbml0KCklMEElMjAlMjAlMjAlMjBoYW5kbGUlMjAlM0QlMjBudm1sRGV2aWNlR2V0SGFuZGxlQnlJbmRleCgwKSUwQSUyMCUyMCUyMCUyMGluZm8lMjAlM0QlMjBudm1sRGV2aWNlR2V0TWVtb3J5SW5mbyhoYW5kbGUpJTBBJTIwJTIwJTIwJTIwcHJpbnQoZiUyMkdQVSUyMG1lbW9yeSUyMG9jY3VwaWVkJTNBJTIwJTdCaW5mby51c2VkJTJGJTJGMTAyNCoqMiU3RCUyME1CLiUyMiklMEElMEElMEFkZWYlMjBwcmludF9zdW1tYXJ5KHJlc3VsdCklM0ElMEElMjAlMjAlMjAlMjBwcmludChmJTIyVGltZSUzQSUyMCU3QnJlc3VsdC5tZXRyaWNzJTVCJ3RyYWluX3J1bnRpbWUnJTVEJTNBLjJmJTdEJTIyKSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjJTYW1wbGVzJTJGc2Vjb25kJTNBJTIwJTdCcmVzdWx0Lm1ldHJpY3MlNUIndHJhaW5fc2FtcGxlc19wZXJfc2Vjb25kJyU1RCUzQS4yZiU3RCUyMiklMEElMjAlMjAlMjAlMjBwcmludF9ncHVfdXRpbGl6YXRpb24oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pynvml <span class="hljs-keyword">import</span> *


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">print_gpu_utilization</span>():
<span class="hljs-meta">... </span>    nvmlInit()
<span class="hljs-meta">... </span>    handle = nvmlDeviceGetHandleByIndex(<span class="hljs-number">0</span>)
<span class="hljs-meta">... </span>    info = nvmlDeviceGetMemoryInfo(handle)
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;GPU memory occupied: <span class="hljs-subst">{info.used//<span class="hljs-number">1024</span>**<span class="hljs-number">2</span>}</span> MB.&quot;</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">print_summary</span>(<span class="hljs-params">result</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Time: <span class="hljs-subst">{result.metrics[<span class="hljs-string">&#x27;train_runtime&#x27;</span>]:<span class="hljs-number">.2</span>f}</span>&quot;</span>)
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Samples/second: <span class="hljs-subst">{result.metrics[<span class="hljs-string">&#x27;train_samples_per_second&#x27;</span>]:<span class="hljs-number">.2</span>f}</span>&quot;</span>)
<span class="hljs-meta">... </span>    print_gpu_utilization()`}}),N=new U({props:{code:"cHJpbnRfZ3B1X3V0aWxpemF0aW9uKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>print_gpu_utilization()
GPU memory occupied: <span class="hljs-number">0</span> MB.`}}),Z=new U({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEElMEF0b3JjaC5vbmVzKCgxJTJDJTIwMSkpLnRvKCUyMmN1ZGElMjIpJTBBcHJpbnRfZ3B1X3V0aWxpemF0aW9uKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch


<span class="hljs-meta">&gt;&gt;&gt; </span>torch.ones((<span class="hljs-number">1</span>, <span class="hljs-number">1</span>)).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>print_gpu_utilization()
GPU memory occupied: <span class="hljs-number">1343</span> MB.`}}),F=new Zt({}),D=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtbGFyZ2UtdW5jYXNlZCUyMikudG8oJTIyY3VkYSUyMiklMEFwcmludF9ncHVfdXRpbGl6YXRpb24oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification


<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;bert-large-uncased&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>print_gpu_utilization()
GPU memory occupied: <span class="hljs-number">2631</span> MB.`}}),Y=new U({props:{code:"bnZpZGlhLXNtaQ==",highlighted:"nvidia-smi"}}),O=new U({props:{code:"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",highlighted:`Tue Jan 11 08:58:05 2022
+-----------------------------------------------------------------------------+
| NVIDIA-SMI 460.91.03    Driver Version: 460.91.03    CUDA Version: 11.2     |
|-------------------------------+----------------------+----------------------+
| GPU  Name        Persistence-M| Bus-Id        Disp.A | Volatile Uncorr. ECC |
| Fan  Temp  Perf  Pwr:Usage/Cap|         Memory-Usage | GPU-Util  Compute M. |
|                               |                      |               MIG M. |
|===============================+======================+======================|
|   0  Tesla V100-SXM2...  On   | 00000000:00:04.0 Off |                    0 |
| N/A   37C    P0    39W / 300W |   2631MiB / 16160MiB |      0%      Default |
|                               |                      |                  N/A |
+-------------------------------+----------------------+----------------------+

+-----------------------------------------------------------------------------+
| Processes:                                                                  |
|  GPU   GI   CI        PID   Type   Process name                  GPU Memory |
|        ID   ID                                                   Usage      |
|=============================================================================|
|    0   N/A  N/A      3721      C   ...nvs/codeparrot/bin/python     2629MiB |
+-----------------------------------------------------------------------------+`}}),tt=new U({props:{code:"ZGVmYXVsdF9hcmdzJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyb3V0cHV0X2RpciUyMiUzQSUyMCUyMnRtcCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmV2YWx1YXRpb25fc3RyYXRlZ3klMjIlM0ElMjAlMjJzdGVwcyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMm51bV90cmFpbl9lcG9jaHMlMjIlM0ElMjAxJTJDJTBBJTIwJTIwJTIwJTIwJTIybG9nX2xldmVsJTIyJTNBJTIwJTIyZXJyb3IlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJyZXBvcnRfdG8lMjIlM0ElMjAlMjJub25lJTIyJTJDJTBBJTdE",highlighted:`default_args = {
    <span class="hljs-string">&quot;output_dir&quot;</span>: <span class="hljs-string">&quot;tmp&quot;</span>,
    <span class="hljs-string">&quot;evaluation_strategy&quot;</span>: <span class="hljs-string">&quot;steps&quot;</span>,
    <span class="hljs-string">&quot;num_train_epochs&quot;</span>: <span class="hljs-number">1</span>,
    <span class="hljs-string">&quot;log_level&quot;</span>: <span class="hljs-string">&quot;error&quot;</span>,
    <span class="hljs-string">&quot;report_to&quot;</span>: <span class="hljs-string">&quot;none&quot;</span>,
}`}}),S=new rn({props:{$$slots:{default:[Mn]},$$scope:{ctx:Ht}}}),et=new Zt({}),nt=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTJDJTIwVHJhaW5lciUyQyUyMGxvZ2dpbmclMEElMEFsb2dnaW5nLnNldF92ZXJib3NpdHlfZXJyb3IoKSUwQSUwQSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBUcmFpbmluZ0FyZ3VtZW50cyhwZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlM0Q0JTJDJTIwKipkZWZhdWx0X2FyZ3MpJTBBdHJhaW5lciUyMCUzRCUyMFRyYWluZXIobW9kZWwlM0Rtb2RlbCUyQyUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTIwdHJhaW5fZGF0YXNldCUzRGRzKSUwQXJlc3VsdCUyMCUzRCUyMHRyYWluZXIudHJhaW4oKSUwQXByaW50X3N1bW1hcnkocmVzdWx0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments, Trainer, logging

<span class="hljs-meta">&gt;&gt;&gt; </span>logging.set_verbosity_error()


<span class="hljs-meta">&gt;&gt;&gt; </span>training_args = TrainingArguments(per_device_train_batch_size=<span class="hljs-number">4</span>, **default_args)
<span class="hljs-meta">&gt;&gt;&gt; </span>trainer = Trainer(model=model, args=training_args, train_dataset=ds)
<span class="hljs-meta">&gt;&gt;&gt; </span>result = trainer.train()
<span class="hljs-meta">&gt;&gt;&gt; </span>print_summary(result)`}}),st=new U({props:{code:"VGltZSUzQSUyMDU3LjgyJTBBU2FtcGxlcyUyRnNlY29uZCUzQSUyMDguODYlMEFHUFUlMjBtZW1vcnklMjBvY2N1cGllZCUzQSUyMDE0OTQ5JTIwTUIu",highlighted:`<span class="hljs-keyword">Time:</span> 57.82
Samples/second: 8.86
GPU memory occupied: 14949 MB.`}}),it=new Zt({}),mt=new Zt({}),{c(){m=i("meta"),Q=s(),c=i("p"),Rt=s(),f=i("h1"),A=i("a"),Et=i("span"),w(R.$$.fragment),Oe=s(),xt=i("span"),xt.textContent=nl,Ft=s(),x=i("p"),x.textContent=sl,Xt=s(),$=i("p"),$.textContent=al,Dt=s(),w(k.$$.fragment),qt=s(),_=i("p"),_.innerHTML=il,Yt=s(),G=i("p"),G.innerHTML=ol,Ot=s(),w(E.$$.fragment),Kt=s(),B=i("p"),B.innerHTML=rl,te=s(),w(P.$$.fragment),ee=s(),W=i("p"),W.textContent=Ml,le=s(),w(N.$$.fragment),ne=s(),V=i("p"),V.textContent=pl,se=s(),w(Z.$$.fragment),ae=s(),H=i("p"),H.textContent=ml,ie=s(),C=i("h2"),v=i("a"),Bt=i("span"),w(F.$$.fragment),Ke=s(),$t=i("span"),$t.textContent=wl,oe=s(),X=i("p"),X.innerHTML=yl,re=s(),w(D.$$.fragment),Me=s(),q=i("p"),q.innerHTML=Tl,pe=s(),w(Y.$$.fragment),me=s(),w(O.$$.fragment),we=s(),K=i("p"),K.textContent=hl,ye=s(),w(tt.$$.fragment),Te=s(),w(S.$$.fragment),he=s(),j=i("h2"),b=i("a"),Pt=i("span"),w(et.$$.fragment),tl=s(),kt=i("span"),kt.textContent=ul,ue=s(),lt=i("p"),lt.innerHTML=Jl,Je=s(),w(nt.$$.fragment),de=s(),w(st.$$.fragment),ce=s(),at=i("p"),at.textContent=dl,Ue=s(),I=i("h2"),L=i("a"),Wt=i("span"),w(it.$$.fragment),el=s(),_t=i("span"),_t.textContent=cl,fe=s(),ot=i("p"),ot.textContent=Ul,Ce=s(),rt=i("ol"),rt.innerHTML=fl,je=s(),Mt=i("p"),Mt.textContent=Cl,Ie=s(),pt=i("p"),pt.innerHTML=jl,ge=s(),g=i("h2"),z=i("a"),Nt=i("span"),w(mt.$$.fragment),ll=s(),Gt=i("span"),Gt.textContent=Il,Ae=s(),wt=i("p"),wt.textContent=gl,ve=s(),yt=i("ol"),yt.innerHTML=Al,Se=s(),Tt=i("p"),Tt.textContent=vl,be=s(),ht=i("p"),ht.textContent=Sl,Le=s(),ut=i("p"),ut.innerHTML=bl,ze=s(),Jt=i("ul"),Jt.innerHTML=Ll,Qe=s(),dt=i("p"),dt.innerHTML=zl,Re=s(),ct=i("ul"),ct.innerHTML=Ql,xe=s(),Ut=i("p"),Ut.innerHTML=Rl,$e=s(),ft=i("ul"),ft.innerHTML=xl,ke=s(),Ct=i("p"),Ct.innerHTML=$l,_e=s(),jt=i("ul"),jt.innerHTML=kl,Ge=s(),It=i("p"),It.textContent=_l,Ee=s(),gt=i("p"),gt.innerHTML=Gl,Be=s(),At=i("p"),At.textContent=El,Pe=s(),vt=i("p"),vt.innerHTML=Bl,We=s(),St=i("p"),St.textContent=Pl,Ne=s(),bt=i("p"),bt.innerHTML=Wl,Ve=s(),Lt=i("p"),Lt.textContent=Nl,Ze=s(),zt=i("p"),zt.innerHTML=Vl,He=s(),Vt=i("p"),this.h()},l(t){const l=on("svelte-1phssyn",document.head);m=o(l,"META",{name:!0,content:!0}),l.forEach(e),Q=a(t),c=o(t,"P",{}),y(c).forEach(e),Rt=a(t),f=o(t,"H1",{class:!0});var Qt=y(f);A=o(Qt,"A",{id:!0,class:!0,href:!0});var Zl=y(A);Et=o(Zl,"SPAN",{});var Hl=y(Et);T(R.$$.fragment,Hl),Hl.forEach(e),Zl.forEach(e),Oe=a(Qt),xt=o(Qt,"SPAN",{"data-svelte-h":!0}),r(xt)!=="svelte-16hs1zt"&&(xt.textContent=nl),Qt.forEach(e),Ft=a(t),x=o(t,"P",{"data-svelte-h":!0}),r(x)!=="svelte-hnkrmx"&&(x.textContent=sl),Xt=a(t),$=o(t,"P",{"data-svelte-h":!0}),r($)!=="svelte-1senzsq"&&($.textContent=al),Dt=a(t),T(k.$$.fragment,t),qt=a(t),_=o(t,"P",{"data-svelte-h":!0}),r(_)!=="svelte-12yc6mf"&&(_.innerHTML=il),Yt=a(t),G=o(t,"P",{"data-svelte-h":!0}),r(G)!=="svelte-3smhwl"&&(G.innerHTML=ol),Ot=a(t),T(E.$$.fragment,t),Kt=a(t),B=o(t,"P",{"data-svelte-h":!0}),r(B)!=="svelte-kl46ul"&&(B.innerHTML=rl),te=a(t),T(P.$$.fragment,t),ee=a(t),W=o(t,"P",{"data-svelte-h":!0}),r(W)!=="svelte-ync61x"&&(W.textContent=Ml),le=a(t),T(N.$$.fragment,t),ne=a(t),V=o(t,"P",{"data-svelte-h":!0}),r(V)!=="svelte-5czace"&&(V.textContent=pl),se=a(t),T(Z.$$.fragment,t),ae=a(t),H=o(t,"P",{"data-svelte-h":!0}),r(H)!=="svelte-i7swzw"&&(H.textContent=ml),ie=a(t),C=o(t,"H2",{class:!0});var Xe=y(C);v=o(Xe,"A",{id:!0,class:!0,href:!0});var Fl=y(v);Bt=o(Fl,"SPAN",{});var Xl=y(Bt);T(F.$$.fragment,Xl),Xl.forEach(e),Fl.forEach(e),Ke=a(Xe),$t=o(Xe,"SPAN",{"data-svelte-h":!0}),r($t)!=="svelte-1526h8e"&&($t.textContent=wl),Xe.forEach(e),oe=a(t),X=o(t,"P",{"data-svelte-h":!0}),r(X)!=="svelte-7th3fs"&&(X.innerHTML=yl),re=a(t),T(D.$$.fragment,t),Me=a(t),q=o(t,"P",{"data-svelte-h":!0}),r(q)!=="svelte-11jwi8m"&&(q.innerHTML=Tl),pe=a(t),T(Y.$$.fragment,t),me=a(t),T(O.$$.fragment,t),we=a(t),K=o(t,"P",{"data-svelte-h":!0}),r(K)!=="svelte-3jv7wr"&&(K.textContent=hl),ye=a(t),T(tt.$$.fragment,t),Te=a(t),T(S.$$.fragment,t),he=a(t),j=o(t,"H2",{class:!0});var De=y(j);b=o(De,"A",{id:!0,class:!0,href:!0});var Dl=y(b);Pt=o(Dl,"SPAN",{});var ql=y(Pt);T(et.$$.fragment,ql),ql.forEach(e),Dl.forEach(e),tl=a(De),kt=o(De,"SPAN",{"data-svelte-h":!0}),r(kt)!=="svelte-1q4sz58"&&(kt.textContent=ul),De.forEach(e),ue=a(t),lt=o(t,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-uik4hc"&&(lt.innerHTML=Jl),Je=a(t),T(nt.$$.fragment,t),de=a(t),T(st.$$.fragment,t),ce=a(t),at=o(t,"P",{"data-svelte-h":!0}),r(at)!=="svelte-17rqaak"&&(at.textContent=dl),Ue=a(t),I=o(t,"H2",{class:!0});var qe=y(I);L=o(qe,"A",{id:!0,class:!0,href:!0});var Yl=y(L);Wt=o(Yl,"SPAN",{});var Ol=y(Wt);T(it.$$.fragment,Ol),Ol.forEach(e),Yl.forEach(e),el=a(qe),_t=o(qe,"SPAN",{"data-svelte-h":!0}),r(_t)!=="svelte-d0p6ne"&&(_t.textContent=cl),qe.forEach(e),fe=a(t),ot=o(t,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-1yxwgxq"&&(ot.textContent=Ul),Ce=a(t),rt=o(t,"OL",{"data-svelte-h":!0}),r(rt)!=="svelte-6rh9nr"&&(rt.innerHTML=fl),je=a(t),Mt=o(t,"P",{"data-svelte-h":!0}),r(Mt)!=="svelte-133lz8w"&&(Mt.textContent=Cl),Ie=a(t),pt=o(t,"P",{"data-svelte-h":!0}),r(pt)!=="svelte-kuotmr"&&(pt.innerHTML=jl),ge=a(t),g=o(t,"H2",{class:!0});var Ye=y(g);z=o(Ye,"A",{id:!0,class:!0,href:!0});var Kl=y(z);Nt=o(Kl,"SPAN",{});var tn=y(Nt);T(mt.$$.fragment,tn),tn.forEach(e),Kl.forEach(e),ll=a(Ye),Gt=o(Ye,"SPAN",{"data-svelte-h":!0}),r(Gt)!=="svelte-i5abpr"&&(Gt.textContent=Il),Ye.forEach(e),Ae=a(t),wt=o(t,"P",{"data-svelte-h":!0}),r(wt)!=="svelte-1754txj"&&(wt.textContent=gl),ve=a(t),yt=o(t,"OL",{"data-svelte-h":!0}),r(yt)!=="svelte-sugems"&&(yt.innerHTML=Al),Se=a(t),Tt=o(t,"P",{"data-svelte-h":!0}),r(Tt)!=="svelte-fr1nan"&&(Tt.textContent=vl),be=a(t),ht=o(t,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-gkt5oe"&&(ht.textContent=Sl),Le=a(t),ut=o(t,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-xrqy2v"&&(ut.innerHTML=bl),ze=a(t),Jt=o(t,"UL",{"data-svelte-h":!0}),r(Jt)!=="svelte-onmuxe"&&(Jt.innerHTML=Ll),Qe=a(t),dt=o(t,"P",{"data-svelte-h":!0}),r(dt)!=="svelte-1lt6jd6"&&(dt.innerHTML=zl),Re=a(t),ct=o(t,"UL",{"data-svelte-h":!0}),r(ct)!=="svelte-1da4la2"&&(ct.innerHTML=Ql),xe=a(t),Ut=o(t,"P",{"data-svelte-h":!0}),r(Ut)!=="svelte-1ecbalg"&&(Ut.innerHTML=Rl),$e=a(t),ft=o(t,"UL",{"data-svelte-h":!0}),r(ft)!=="svelte-4g0r46"&&(ft.innerHTML=xl),ke=a(t),Ct=o(t,"P",{"data-svelte-h":!0}),r(Ct)!=="svelte-2pm1hh"&&(Ct.innerHTML=$l),_e=a(t),jt=o(t,"UL",{"data-svelte-h":!0}),r(jt)!=="svelte-if0ig5"&&(jt.innerHTML=kl),Ge=a(t),It=o(t,"P",{"data-svelte-h":!0}),r(It)!=="svelte-1nzmdyx"&&(It.textContent=_l),Ee=a(t),gt=o(t,"P",{"data-svelte-h":!0}),r(gt)!=="svelte-1wp748v"&&(gt.innerHTML=Gl),Be=a(t),At=o(t,"P",{"data-svelte-h":!0}),r(At)!=="svelte-1wjdkzj"&&(At.textContent=El),Pe=a(t),vt=o(t,"P",{"data-svelte-h":!0}),r(vt)!=="svelte-1fhakxc"&&(vt.innerHTML=Bl),We=a(t),St=o(t,"P",{"data-svelte-h":!0}),r(St)!=="svelte-l8a4kr"&&(St.textContent=Pl),Ne=a(t),bt=o(t,"P",{"data-svelte-h":!0}),r(bt)!=="svelte-1mll0j9"&&(bt.innerHTML=Wl),Ve=a(t),Lt=o(t,"P",{"data-svelte-h":!0}),r(Lt)!=="svelte-10o41gl"&&(Lt.textContent=Nl),Ze=a(t),zt=o(t,"P",{"data-svelte-h":!0}),r(zt)!=="svelte-a36np0"&&(zt.innerHTML=Vl),He=a(t),Vt=o(t,"P",{}),y(Vt).forEach(e),this.h()},h(){M(m,"name","hf:doc:metadata"),M(m,"content",JSON.stringify(mn)),M(A,"id","model-training-anatomy"),M(A,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(A,"href","#model-training-anatomy"),M(f,"class","relative group"),M(v,"id","load-model"),M(v,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(v,"href","#load-model"),M(C,"class","relative group"),M(b,"id","memory-utilization-at-vanilla-training"),M(b,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(b,"href","#memory-utilization-at-vanilla-training"),M(j,"class","relative group"),M(L,"id","anatomy-of-models-operations"),M(L,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(L,"href","#anatomy-of-models-operations"),M(I,"class","relative group"),M(z,"id","anatomy-of-models-memory"),M(z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(z,"href","#anatomy-of-models-memory"),M(g,"class","relative group")},m(t,l){p(document.head,m),n(t,Q,l),n(t,c,l),n(t,Rt,l),n(t,f,l),p(f,A),p(A,Et),h(R,Et,null),p(f,Oe),p(f,xt),n(t,Ft,l),n(t,x,l),n(t,Xt,l),n(t,$,l),n(t,Dt,l),h(k,t,l),n(t,qt,l),n(t,_,l),n(t,Yt,l),n(t,G,l),n(t,Ot,l),h(E,t,l),n(t,Kt,l),n(t,B,l),n(t,te,l),h(P,t,l),n(t,ee,l),n(t,W,l),n(t,le,l),h(N,t,l),n(t,ne,l),n(t,V,l),n(t,se,l),h(Z,t,l),n(t,ae,l),n(t,H,l),n(t,ie,l),n(t,C,l),p(C,v),p(v,Bt),h(F,Bt,null),p(C,Ke),p(C,$t),n(t,oe,l),n(t,X,l),n(t,re,l),h(D,t,l),n(t,Me,l),n(t,q,l),n(t,pe,l),h(Y,t,l),n(t,me,l),h(O,t,l),n(t,we,l),n(t,K,l),n(t,ye,l),h(tt,t,l),n(t,Te,l),h(S,t,l),n(t,he,l),n(t,j,l),p(j,b),p(b,Pt),h(et,Pt,null),p(j,tl),p(j,kt),n(t,ue,l),n(t,lt,l),n(t,Je,l),h(nt,t,l),n(t,de,l),h(st,t,l),n(t,ce,l),n(t,at,l),n(t,Ue,l),n(t,I,l),p(I,L),p(L,Wt),h(it,Wt,null),p(I,el),p(I,_t),n(t,fe,l),n(t,ot,l),n(t,Ce,l),n(t,rt,l),n(t,je,l),n(t,Mt,l),n(t,Ie,l),n(t,pt,l),n(t,ge,l),n(t,g,l),p(g,z),p(z,Nt),h(mt,Nt,null),p(g,ll),p(g,Gt),n(t,Ae,l),n(t,wt,l),n(t,ve,l),n(t,yt,l),n(t,Se,l),n(t,Tt,l),n(t,be,l),n(t,ht,l),n(t,Le,l),n(t,ut,l),n(t,ze,l),n(t,Jt,l),n(t,Qe,l),n(t,dt,l),n(t,Re,l),n(t,ct,l),n(t,xe,l),n(t,Ut,l),n(t,$e,l),n(t,ft,l),n(t,ke,l),n(t,Ct,l),n(t,_e,l),n(t,jt,l),n(t,Ge,l),n(t,It,l),n(t,Ee,l),n(t,gt,l),n(t,Be,l),n(t,At,l),n(t,Pe,l),n(t,vt,l),n(t,We,l),n(t,St,l),n(t,Ne,l),n(t,bt,l),n(t,Ve,l),n(t,Lt,l),n(t,Ze,l),n(t,zt,l),n(t,He,l),n(t,Vt,l),Fe=!0},p(t,[l]){const Qt={};l&2&&(Qt.$$scope={dirty:l,ctx:t}),S.$set(Qt)},i(t){Fe||(u(R.$$.fragment,t),u(k.$$.fragment,t),u(E.$$.fragment,t),u(P.$$.fragment,t),u(N.$$.fragment,t),u(Z.$$.fragment,t),u(F.$$.fragment,t),u(D.$$.fragment,t),u(Y.$$.fragment,t),u(O.$$.fragment,t),u(tt.$$.fragment,t),u(S.$$.fragment,t),u(et.$$.fragment,t),u(nt.$$.fragment,t),u(st.$$.fragment,t),u(it.$$.fragment,t),u(mt.$$.fragment,t),Fe=!0)},o(t){J(R.$$.fragment,t),J(k.$$.fragment,t),J(E.$$.fragment,t),J(P.$$.fragment,t),J(N.$$.fragment,t),J(Z.$$.fragment,t),J(F.$$.fragment,t),J(D.$$.fragment,t),J(Y.$$.fragment,t),J(O.$$.fragment,t),J(tt.$$.fragment,t),J(S.$$.fragment,t),J(et.$$.fragment,t),J(nt.$$.fragment,t),J(st.$$.fragment,t),J(it.$$.fragment,t),J(mt.$$.fragment,t),Fe=!1},d(t){t&&(e(Q),e(c),e(Rt),e(f),e(Ft),e(x),e(Xt),e($),e(Dt),e(qt),e(_),e(Yt),e(G),e(Ot),e(Kt),e(B),e(te),e(ee),e(W),e(le),e(ne),e(V),e(se),e(ae),e(H),e(ie),e(C),e(oe),e(X),e(re),e(Me),e(q),e(pe),e(me),e(we),e(K),e(ye),e(Te),e(he),e(j),e(ue),e(lt),e(Je),e(de),e(ce),e(at),e(Ue),e(I),e(fe),e(ot),e(Ce),e(rt),e(je),e(Mt),e(Ie),e(pt),e(ge),e(g),e(Ae),e(wt),e(ve),e(yt),e(Se),e(Tt),e(be),e(ht),e(Le),e(ut),e(ze),e(Jt),e(Qe),e(dt),e(Re),e(ct),e(xe),e(Ut),e($e),e(ft),e(ke),e(Ct),e(_e),e(jt),e(Ge),e(It),e(Ee),e(gt),e(Be),e(At),e(Pe),e(vt),e(We),e(St),e(Ne),e(bt),e(Ve),e(Lt),e(Ze),e(zt),e(He),e(Vt)),e(m),d(R),d(k,t),d(E,t),d(P,t),d(N,t),d(Z,t),d(F),d(D,t),d(Y,t),d(O,t),d(tt,t),d(S,t),d(et),d(nt,t),d(st,t),d(it),d(mt)}}}const mn={local:"model-training-anatomy",sections:[{local:"load-model",title:"Load Model"},{local:"memory-utilization-at-vanilla-training",title:"Memory utilization at vanilla training"},{local:"anatomy-of-models-operations",title:"Anatomy of Model's Operations"},{local:"anatomy-of-models-memory",title:"Anatomy of Model's Memory"}],title:"Model training anatomy"};function wn(Ht){return ln(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class dn extends sn{constructor(m){super(),an(this,m,wn,pn,en,{})}}export{dn as component};
