import{s as on,n as rn,o as sn}from"../chunks/scheduler.85c25b89.js";import{S as ln,i as cn,g as r,s as o,r as d,A as dn,h as s,f as n,c as i,j as C,u as p,x as l,k as $,y as c,a,v as m,d as g,t as h,w as f}from"../chunks/index.c142fe32.js";import{D as De}from"../chunks/Docstring.e6639b56.js";import{C as ft}from"../chunks/CodeBlock.a5e95a57.js";import{H as y,E as pn}from"../chunks/EditOnGithub.a592e7aa.js";function mn(jt){let v,$e,xe,ke,k,je,j,Je,J,Jt='<thead><tr><th>Before</th> <th>After DDPO finetuning</th></tr></thead> <tbody><tr><td><div style="text-align: center"><img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/pre_squirrel.png"/></div></td> <td><div style="text-align: center"><img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/post_squirrel.png"/></div></td></tr> <tr><td><div style="text-align: center"><img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/pre_crab.png"/></div></td> <td><div style="text-align: center"><img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/post_crab.png"/></div></td></tr> <tr><td><div style="text-align: center"><img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/pre_starfish.png"/></div></td> <td><div style="text-align: center"><img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/post_starfish.png"/></div></td></tr></tbody>',Pe,P,Ue,U,Pt=`The machinery for finetuning of Stable Diffusion models with reinforcement learning makes heavy use of HuggingFace’s <code>diffusers</code>
library. A reason for  stating this is that getting started requires a bit of familiarity with the <code>diffusers</code> library concepts, mainly two of them - pipelines and schedulers.
Right out of the box (<code>diffusers</code> library), there isn’t a <code>Pipeline</code> nor a <code>Scheduler</code> instance that is suitable for finetuning with reinforcement learning. Some adjustments need to made.`,Oe,O,Ut=`There is a pipeline interface that is provided by this library that is required to be implemented to be used with the <code>DDPOTrainer</code>, which is the main machinery for fine-tuning Stable Diffusion with reinforcement learning. <strong>Note: Only the StableDiffusion architecture is supported at this point.</strong>
There is a default implementation of this interface that you can use out of the box. Assuming the default implementation is sufficient and/or to get things moving, refer to the training example alongside this guide.`,Ie,I,Ot="The point of the interface is to fuse the pipeline and the scheduler into one object which allows for minimalness in terms of having the constraints all in one place. The interface was designed in hopes of catering to pipelines and schedulers beyond the examples in this repository and elsewhere at this time of writing. Also the scheduler step is a method of this pipeline interface and this may seem redundant given that the raw scheduler is accessible via the interface but this is the only way to constrain the scheduler step output to an output type befitting of the algorithm at hand (DDPO).",Ae,A,It='For a more detailed look into the interface and the associated default implementation, go <a href="https://github.com/lvwerra/trl/tree/main/trl/models/modeling_sd_base.py" rel="nofollow">here</a>',Ze,Z,At="Note that the default implementation has a LoRA implementation path and a non-LoRA based implementation path. The LoRA flag enabled by default and this can be turned off by passing in the flag to do so. LORA based training is faster and the LORA associated model hyperparameters responsible for model convergence aren’t as finicky as non-LORA based training.",Le,L,Zt="Also in addition, there is the expectation of providing a reward function and a prompt function. The reward function is used to evaluate the generated images  and the prompt function is used to generate the prompts that are used to generate the images.",Be,B,He,H,Lt="The <code>ddpo.py</code> script is a working example of using the <code>DDPO</code> trainer to finetune a Stable Diffusion model. This example explicitly configures a small subset of the overall parameters associated with the config object (<code>DDPOConfig</code>).",ze,z,Bt="<strong>Note:</strong> one A100 GPU is recommended to get this running. Anything below a A100 will not be able to run this example script and even if it does via relatively smaller sized parameters, the results will most likely be poor.",Ge,G,Ht='Almost every configuration parameter has a default. There is only one commandline flag argument that is required of the user to get things up and running. The user is expected to have a <a href="https://huggingface.co/docs/hub/security-tokens" rel="nofollow">huggingface user access token</a> that will be used to upload the model post finetuning to HuggingFace hub. The following bash command is to be entered to get things running',Ne,N,qe,q,zt="To obtain the documentation of <code>stable_diffusion_tuning.py</code>, please run <code>python stable_diffusion_tuning.py --help</code>",Se,S,Gt="The following are things to keep in mind (The code checks this for you as well) in general while configuring the trainer (beyond the use case of using the example script)",Ee,E,Nt="<li>The configurable sample batch size (<code>--ddpo_config.sample_batch_size=6</code>) should be greater than or equal to the configurable training batch size (<code>--ddpo_config.train_batch_size=3</code>)</li> <li>The configurable sample batch size (<code>--ddpo_config.sample_batch_size=6</code>) must be divisible by the configurable train batch size (<code>--ddpo_config.train_batch_size=3</code>)</li> <li>The configurable sample batch size (<code>--ddpo_config.sample_batch_size=6</code>) must be divisible by both the configurable gradient accumulation steps (<code>--ddpo_config.train_gradient_accumulation_steps=1</code>) and the configurable accelerator processes count</li>",Re,R,Xe,X,qt="Expect the function to be given a list of lists of the form",We,W,Ye,Y,St=`and <code>image</code>, <code>prompt</code>, <code>prompt_metadata</code>, <code>rewards</code>, <code>reward_metadata</code> are batched.
The last list in the lists of lists represents the last sample batch. You are likely to want to log this one
While you are free to log however you want the use of <code>wandb</code> or <code>tensorboard</code> is recommended.`,Qe,Q,Ve,V,Et='<li><code>rewards</code> : The rewards/score is a numerical associated with the generated image and is key to steering the RL process</li> <li><code>reward_metadata</code> : The reward metadata is the metadata associated with the reward. Think of this as extra information payload delivered alongside the reward</li> <li><code>prompt</code> : The prompt is the text that is used to generate the image</li> <li><code>prompt_metadata</code> : The prompt metadata is the metadata associated with the prompt. A situation where this will not be empty is when the reward model comprises of a <a href="https://huggingface.co/docs/transformers/model_doc/flava" rel="nofollow"><code>FLAVA</code></a> setup where questions and ground answers (linked to the generated image) are expected with the generated image (See here: <a href="https://github.com/kvablack/ddpo-pytorch/blob/main/ddpo_pytorch/rewards.py#L45" rel="nofollow">https://github.com/kvablack/ddpo-pytorch/blob/main/ddpo_pytorch/rewards.py#L45</a>)</li> <li><code>image</code> : The image generated by the Stable Diffusion model</li>',Fe,F,Rt="Example code for logging sampled images with <code>wandb</code> is given below.",Ke,K,et,ee,tt,te,Xt="Assuming you’ve done with all the epochs and have pushed up your model to the hub, you can use the finetuned model as follows",nt,ne,at,ae,ot,oe,Wt=`This work is heavily influenced by the repo <a href="https://github.com/kvablack/ddpo-pytorch" rel="nofollow">here</a> and the associated paper <a href="https://huggingface.co/papers/2305.13301" rel="nofollow">Training Diffusion Models
with Reinforcement Learning by Kevin Black, Michael Janner, Yilan Du, Ilya Kostrikov, Sergey Levine</a>.`,it,ie,rt,u,re,ut,he,Yt=`The DDPOTrainer uses Deep Diffusion Policy Optimization to optimise diffusion models.
Note, this trainer is heavily inspired by the work here: <a href="https://github.com/kvablack/ddpo-pytorch" rel="nofollow">https://github.com/kvablack/ddpo-pytorch</a>
As of now only Stable Diffusion based pipelines are supported`,_t,T,se,bt,fe,Qt="Calculate the loss for a batch of an unpacked sample",wt,M,le,yt,ue,Vt="Creates and saves a model card for a TRL model.",vt,_,ce,Tt,_e,Ft="Perform a single step of training.",Mt,be,Kt="Side Effects:",Dt,we,en="<li>Model weights are updated</li> <li>Logs the statistics to the accelerator trackers.</li> <li>If <code>self.image_samples_callback</code> is not None, it will be called with the prompt_image_pairs, global_step, and the accelerator tracker.</li>",xt,D,de,Ct,ye,tn="Train the model for a given number of epochs",st,pe,lt,w,me,$t,ve,nn='Configuration class for the <a href="/docs/trl/v0.11.2/en/ddpo_trainer#trl.DDPOTrainer">DDPOTrainer</a>.',kt,Te,an=`Using <a href="https://huggingface.co/docs/transformers/v4.45.2/en/internal/trainer_utils#transformers.HfArgumentParser" rel="nofollow">HfArgumentParser</a> we can turn this class into
<a href="https://docs.python.org/3/library/argparse#module-argparse" rel="nofollow">argparse</a> arguments that can be specified on the
command line.`,ct,ge,dt,Ce,pt;return k=new y({props:{title:"Denoising Diffusion Policy Optimization",local:"denoising-diffusion-policy-optimization",headingTag:"h1"}}),j=new y({props:{title:"The why",local:"the-why",headingTag:"h2"}}),P=new y({props:{title:"Getting started with Stable Diffusion finetuning with reinforcement learning",local:"getting-started-with-stable-diffusion-finetuning-with-reinforcement-learning",headingTag:"h2"}}),B=new y({props:{title:"Getting started with examples/scripts/ddpo.py",local:"getting-started-with-examplesscriptsddpopy",headingTag:"h2"}}),N=new ft({props:{code:"cHl0aG9uJTIwZGRwby5weSUyMC0taGZfdXNlcl9hY2Nlc3NfdG9rZW4lMjAlM0N0b2tlbiUzRQ==",highlighted:'<span class="hljs-keyword">python</span> ddpo.<span class="hljs-keyword">py</span> --hf_user_access_token <span class="hljs-symbol">&lt;token&gt;</span>',wrap:!1}}),R=new y({props:{title:"Setting up the image logging hook function",local:"setting-up-the-image-logging-hook-function",headingTag:"h2"}}),W=new ft({props:{code:"JTVCJTVCaW1hZ2UlMkMlMjBwcm9tcHQlMkMlMjBwcm9tcHRfbWV0YWRhdGElMkMlMjByZXdhcmRzJTJDJTIwcmV3YXJkX21ldGFkYXRhJTVEJTJDJTIwLi4uJTVEJTBB",highlighted:`[[image, prompt, prompt_metadata, rewards, reward_metadata], ...]
`,wrap:!1}}),Q=new y({props:{title:"Key terms",local:"key-terms",headingTag:"h3"}}),K=new ft({props:{code:"JTIzJTIwZm9yJTIwbG9nZ2luZyUyMHRoZXNlJTIwaW1hZ2VzJTIwdG8lMjB3YW5kYiUwQSUwQWRlZiUyMGltYWdlX291dHB1dHNfaG9vayhpbWFnZV9kYXRhJTJDJTIwZ2xvYmFsX3N0ZXAlMkMlMjBhY2NlbGVyYXRlX2xvZ2dlciklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBGb3IlMjB0aGUlMjBzYWtlJTIwb2YlMjB0aGlzJTIwZXhhbXBsZSUyQyUyMHdlJTIwb25seSUyMGNhcmUlMjBhYm91dCUyMHRoZSUyMGxhc3QlMjBiYXRjaCUwQSUyMCUyMCUyMCUyMCUyMyUyMGhlbmNlJTIwd2UlMjBleHRyYWN0JTIwdGhlJTIwbGFzdCUyMGVsZW1lbnQlMjBvZiUyMHRoZSUyMGxpc3QlMEElMjAlMjAlMjAlMjByZXN1bHQlMjAlM0QlMjAlN0IlN0QlMEElMjAlMjAlMjAlMjBpbWFnZXMlMkMlMjBwcm9tcHRzJTJDJTIwXyUyQyUyMHJld2FyZHMlMkMlMjBfJTIwJTNEJTIwaW1hZ2VfZGF0YSU1Qi0xJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwaSUyQyUyMGltYWdlJTIwaW4lMjBlbnVtZXJhdGUoaW1hZ2VzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBpbCUyMCUzRCUyMEltYWdlLmZyb21hcnJheSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAoaW1hZ2UuY3B1KCkubnVtcHkoKS50cmFuc3Bvc2UoMSUyQyUyMDIlMkMlMjAwKSUyMColMjAyNTUpLmFzdHlwZShucC51aW50OCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGlsJTIwJTNEJTIwcGlsLnJlc2l6ZSgoMjU2JTJDJTIwMjU2KSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXN1bHQlNUJmJTIyJTdCcHJvbXB0cyU1QmklNUQlM0EuMjUlN0QlMjAlN0MlMjAlN0JyZXdhcmRzJTVCaSU1RCUzQS4yZiU3RCUyMiU1RCUyMCUzRCUyMCU1QnBpbCU1RCUwQSUyMCUyMCUyMCUyMGFjY2VsZXJhdGVfbG9nZ2VyLmxvZ19pbWFnZXMoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVzdWx0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlcCUzRGdsb2JhbF9zdGVwJTJDJTBBJTIwJTIwJTIwJTIwKSUwQQ==",highlighted:`<span class="hljs-comment"># for logging these images to wandb</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">image_outputs_hook</span>(<span class="hljs-params">image_data, global_step, accelerate_logger</span>):
    <span class="hljs-comment"># For the sake of this example, we only care about the last batch</span>
    <span class="hljs-comment"># hence we extract the last element of the list</span>
    result = {}
    images, prompts, _, rewards, _ = image_data[-<span class="hljs-number">1</span>]
    <span class="hljs-keyword">for</span> i, image <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(images):
        pil = Image.fromarray(
            (image.cpu().numpy().transpose(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">0</span>) * <span class="hljs-number">255</span>).astype(np.uint8)
        )
        pil = pil.resize((<span class="hljs-number">256</span>, <span class="hljs-number">256</span>))
        result[<span class="hljs-string">f&quot;<span class="hljs-subst">{prompts[i]:<span class="hljs-number">.25</span>}</span> | <span class="hljs-subst">{rewards[i]:<span class="hljs-number">.2</span>f}</span>&quot;</span>] = [pil]
    accelerate_logger.log_images(
        result,
        step=global_step,
    )
`,wrap:!1}}),ee=new y({props:{title:"Using the finetuned model",local:"using-the-finetuned-model",headingTag:"h3"}}),ne=new ft({props:{code:"JTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJsJTIwaW1wb3J0JTIwRGVmYXVsdEREUE9TdGFibGVEaWZmdXNpb25QaXBlbGluZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwRGVmYXVsdEREUE9TdGFibGVEaWZmdXNpb25QaXBlbGluZSglMjJtZXRyaWMtc3BhY2UlMkZkZHBvLWZpbmV0dW5lZC1zZC1tb2RlbCUyMiklMEElMEFkZXZpY2UlMjAlM0QlMjB0b3JjaC5kZXZpY2UoJTIyY3VkYSUyMiklMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwdG9yY2guZGV2aWNlKCUyMmNwdSUyMiklMEElMEElMjMlMjBtZW1vcnklMjBvcHRpbWl6YXRpb24lMEFwaXBlbGluZS52YWUudG8oZGV2aWNlJTJDJTIwdG9yY2guZmxvYXQxNiklMEFwaXBlbGluZS50ZXh0X2VuY29kZXIudG8oZGV2aWNlJTJDJTIwdG9yY2guZmxvYXQxNiklMEFwaXBlbGluZS51bmV0LnRvKGRldmljZSUyQyUyMHRvcmNoLmZsb2F0MTYpJTBBJTBBcHJvbXB0cyUyMCUzRCUyMCU1QiUyMnNxdWlycmVsJTIyJTJDJTIwJTIyY3JhYiUyMiUyQyUyMCUyMnN0YXJmaXNoJTIyJTJDJTIwJTIyd2hhbGUlMjIlMkMlMjJzcG9uZ2UlMjIlMkMlMjAlMjJwbGFua3RvbiUyMiU1RCUwQXJlc3VsdHMlMjAlM0QlMjBwaXBlbGluZShwcm9tcHRzKSUwQSUwQWZvciUyMHByb21wdCUyQyUyMGltYWdlJTIwaW4lMjB6aXAocHJvbXB0cyUyQ3Jlc3VsdHMuaW1hZ2VzKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlLnNhdmUoZiUyMiU3QnByb21wdCU3RC5wbmclMjIpJTBB",highlighted:`
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> DefaultDDPOStableDiffusionPipeline

pipeline = DefaultDDPOStableDiffusionPipeline(<span class="hljs-string">&quot;metric-space/ddpo-finetuned-sd-model&quot;</span>)

device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> torch.device(<span class="hljs-string">&quot;cpu&quot;</span>)

<span class="hljs-comment"># memory optimization</span>
pipeline.vae.to(device, torch.float16)
pipeline.text_encoder.to(device, torch.float16)
pipeline.unet.to(device, torch.float16)

prompts = [<span class="hljs-string">&quot;squirrel&quot;</span>, <span class="hljs-string">&quot;crab&quot;</span>, <span class="hljs-string">&quot;starfish&quot;</span>, <span class="hljs-string">&quot;whale&quot;</span>,<span class="hljs-string">&quot;sponge&quot;</span>, <span class="hljs-string">&quot;plankton&quot;</span>]
results = pipeline(prompts)

<span class="hljs-keyword">for</span> prompt, image <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(prompts,results.images):
    image.save(<span class="hljs-string">f&quot;<span class="hljs-subst">{prompt}</span>.png&quot;</span>)
`,wrap:!1}}),ae=new y({props:{title:"Credits",local:"credits",headingTag:"h2"}}),ie=new y({props:{title:"DDPOTrainer",local:"trl.DDPOTrainer",headingTag:"h2"}}),re=new De({props:{name:"class trl.DDPOTrainer",anchor:"trl.DDPOTrainer",parameters:[{name:"config",val:": DDPOConfig"},{name:"reward_function",val:": Callable"},{name:"prompt_function",val:": Callable"},{name:"sd_pipeline",val:": DDPOStableDiffusionPipeline"},{name:"image_samples_hook",val:": Optional = None"}],parametersDescription:[{anchor:"trl.DDPOTrainer.*config**",description:`*<strong>*config**</strong> (<code>DDPOConfig</code>) &#x2014; Configuration object for DDPOTrainer. Check the documentation of <code>PPOConfig</code> for more &#x2014;
details.`,name:"*config**"},{anchor:"trl.DDPOTrainer.*reward_function**",description:"*<strong>*reward_function**</strong> (Callable[[torch.Tensor, Tuple[str], Tuple[Any]], torch.Tensor]) &#x2014; Reward function to be used &#x2014;",name:"*reward_function**"},{anchor:"trl.DDPOTrainer.*prompt_function**",description:"*<strong>*prompt_function**</strong> (Callable[[], Tuple[str, Any]]) &#x2014; Function to generate prompts to guide model &#x2014;",name:"*prompt_function**"},{anchor:"trl.DDPOTrainer.*sd_pipeline**",description:"*<strong>*sd_pipeline**</strong> (<code>DDPOStableDiffusionPipeline</code>) &#x2014; Stable Diffusion pipeline to be used for training. &#x2014;",name:"*sd_pipeline**"},{anchor:"trl.DDPOTrainer.*image_samples_hook**",description:"*<strong>*image_samples_hook**</strong> (Optional[Callable[[Any, Any, Any], Any]]) &#x2014; Hook to be called to log images &#x2014;",name:"*image_samples_hook**"}],source:"https://github.com/huggingface/trl/blob/v0.11.2/trl/trainer/ddpo_trainer.py#L55"}}),se=new De({props:{name:"calculate_loss",anchor:"trl.DDPOTrainer.calculate_loss",parameters:[{name:"latents",val:""},{name:"timesteps",val:""},{name:"next_latents",val:""},{name:"log_probs",val:""},{name:"advantages",val:""},{name:"embeds",val:""}],parametersDescription:[{anchor:"trl.DDPOTrainer.calculate_loss.latents",description:`<strong>latents</strong> (torch.Tensor) &#x2014;
The latents sampled from the diffusion model, shape: [batch_size, num_channels_latents, height, width]`,name:"latents"},{anchor:"trl.DDPOTrainer.calculate_loss.timesteps",description:`<strong>timesteps</strong> (torch.Tensor) &#x2014;
The timesteps sampled from the diffusion model, shape: [batch_size]`,name:"timesteps"},{anchor:"trl.DDPOTrainer.calculate_loss.next_latents",description:`<strong>next_latents</strong> (torch.Tensor) &#x2014;
The next latents sampled from the diffusion model, shape: [batch_size, num_channels_latents, height, width]`,name:"next_latents"},{anchor:"trl.DDPOTrainer.calculate_loss.log_probs",description:`<strong>log_probs</strong> (torch.Tensor) &#x2014;
The log probabilities of the latents, shape: [batch_size]`,name:"log_probs"},{anchor:"trl.DDPOTrainer.calculate_loss.advantages",description:`<strong>advantages</strong> (torch.Tensor) &#x2014;
The advantages of the latents, shape: [batch_size]`,name:"advantages"},{anchor:"trl.DDPOTrainer.calculate_loss.embeds",description:`<strong>embeds</strong> (torch.Tensor) &#x2014;
The embeddings of the prompts, shape: [2*batch_size or batch_size, &#x2026;]
Note: the &#x201C;or&#x201D; is because if train_cfg is True, the expectation is that negative prompts are concatenated to the embeds`,name:"embeds"}],source:"https://github.com/huggingface/trl/blob/v0.11.2/trl/trainer/ddpo_trainer.py#L340",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>loss (torch.Tensor), approx_kl (torch.Tensor), clipfrac (torch.Tensor)
(all of these are of shape (1,))</p>
`}}),le=new De({props:{name:"create_model_card",anchor:"trl.DDPOTrainer.create_model_card",parameters:[{name:"path",val:": str"},{name:"model_name",val:": Optional = 'TRL DDPO Model'"}],parametersDescription:[{anchor:"trl.DDPOTrainer.create_model_card.path",description:"<strong>path</strong> (<code>str</code>) &#x2014; The path to save the model card to.",name:"path"},{anchor:"trl.DDPOTrainer.create_model_card.model_name",description:"<strong>model_name</strong> (<code>str</code>, <em>optional</em>) &#x2014; The name of the model, defaults to <code>TRL DDPO Model</code>.",name:"model_name"}],source:"https://github.com/huggingface/trl/blob/v0.11.2/trl/trainer/ddpo_trainer.py#L606"}}),ce=new De({props:{name:"step",anchor:"trl.DDPOTrainer.step",parameters:[{name:"epoch",val:": int"},{name:"global_step",val:": int"}],parametersDescription:[{anchor:"trl.DDPOTrainer.step.epoch",description:"<strong>epoch</strong> (int) &#x2014; The current epoch.",name:"epoch"},{anchor:"trl.DDPOTrainer.step.global_step",description:"<strong>global_step</strong> (int) &#x2014; The current global step.",name:"global_step"}],source:"https://github.com/huggingface/trl/blob/v0.11.2/trl/trainer/ddpo_trainer.py#L234",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The updated global step.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>global_step (int)</p>
`}}),de=new De({props:{name:"train",anchor:"trl.DDPOTrainer.train",parameters:[{name:"epochs",val:": Optional = None"}],source:"https://github.com/huggingface/trl/blob/v0.11.2/trl/trainer/ddpo_trainer.py#L596"}}),pe=new y({props:{title:"DDPOConfig",local:"trl.DDPOConfig",headingTag:"h2"}}),me=new De({props:{name:"class trl.DDPOConfig",anchor:"trl.DDPOConfig",parameters:[{name:"exp_name",val:": str = 'doc-buil'"},{name:"run_name",val:": str = ''"},{name:"seed",val:": int = 0"},{name:"log_with",val:": Optional = None"},{name:"tracker_kwargs",val:": dict = <factory>"},{name:"accelerator_kwargs",val:": dict = <factory>"},{name:"project_kwargs",val:": dict = <factory>"},{name:"tracker_project_name",val:": str = 'trl'"},{name:"logdir",val:": str = 'logs'"},{name:"num_epochs",val:": int = 100"},{name:"save_freq",val:": int = 1"},{name:"num_checkpoint_limit",val:": int = 5"},{name:"mixed_precision",val:": str = 'fp16'"},{name:"allow_tf32",val:": bool = True"},{name:"resume_from",val:": str = ''"},{name:"sample_num_steps",val:": int = 50"},{name:"sample_eta",val:": float = 1.0"},{name:"sample_guidance_scale",val:": float = 5.0"},{name:"sample_batch_size",val:": int = 1"},{name:"sample_num_batches_per_epoch",val:": int = 2"},{name:"train_batch_size",val:": int = 1"},{name:"train_use_8bit_adam",val:": bool = False"},{name:"train_learning_rate",val:": float = 0.0003"},{name:"train_adam_beta1",val:": float = 0.9"},{name:"train_adam_beta2",val:": float = 0.999"},{name:"train_adam_weight_decay",val:": float = 0.0001"},{name:"train_adam_epsilon",val:": float = 1e-08"},{name:"train_gradient_accumulation_steps",val:": int = 1"},{name:"train_max_grad_norm",val:": float = 1.0"},{name:"train_num_inner_epochs",val:": int = 1"},{name:"train_cfg",val:": bool = True"},{name:"train_adv_clip_max",val:": float = 5.0"},{name:"train_clip_range",val:": float = 0.0001"},{name:"train_timestep_fraction",val:": float = 1.0"},{name:"per_prompt_stat_tracking",val:": bool = False"},{name:"per_prompt_stat_tracking_buffer_size",val:": int = 16"},{name:"per_prompt_stat_tracking_min_count",val:": int = 16"},{name:"async_reward_computation",val:": bool = False"},{name:"max_workers",val:": int = 2"},{name:"negative_prompts",val:": str = ''"}],parametersDescription:[{anchor:"trl.DDPOConfig.exp_name",description:`<strong>exp_name</strong> (<code>str</code>, <em>optional</em>, defaults to <code>os.path.basename(sys.argv[0])[ -- -len(&quot;.py&quot;)]</code>):
Name of this experiment (by default is the file name without the extension name).`,name:"exp_name"},{anchor:"trl.DDPOConfig.run_name",description:`<strong>run_name</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
Name of this run.`,name:"run_name"},{anchor:"trl.DDPOConfig.seed",description:`<strong>seed</strong> (<code>int</code>, <em>optional</em>, defaults to <code>0</code>) &#x2014;
Random seed.`,name:"seed"},{anchor:"trl.DDPOConfig.log_with",description:`<strong>log_with</strong> (<code>Optional[Literal[&quot;wandb&quot;, &quot;tensorboard&quot;]]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Log with either &#x2018;wandb&#x2019; or &#x2018;tensorboard&#x2019;, check
<a href="https://huggingface.co/docs/accelerate/usage_guides/tracking" rel="nofollow">https://huggingface.co/docs/accelerate/usage_guides/tracking</a> for more details.`,name:"log_with"},{anchor:"trl.DDPOConfig.tracker_kwargs",description:`<strong>tracker_kwargs</strong> (<code>Dict</code>, <em>optional</em>, defaults to <code>{}</code>) &#x2014;
Keyword arguments for the tracker (e.g. wandb_project).`,name:"tracker_kwargs"},{anchor:"trl.DDPOConfig.accelerator_kwargs",description:`<strong>accelerator_kwargs</strong> (<code>Dict</code>, <em>optional</em>, defaults to <code>{}</code>) &#x2014;
Keyword arguments for the accelerator.`,name:"accelerator_kwargs"},{anchor:"trl.DDPOConfig.project_kwargs",description:`<strong>project_kwargs</strong> (<code>Dict</code>, <em>optional</em>, defaults to <code>{}</code>) &#x2014;
Keyword arguments for the accelerator project config (e.g. <code>logging_dir</code>).`,name:"project_kwargs"},{anchor:"trl.DDPOConfig.tracker_project_name",description:`<strong>tracker_project_name</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;trl&quot;</code>) &#x2014;
Name of project to use for tracking.`,name:"tracker_project_name"},{anchor:"trl.DDPOConfig.logdir",description:`<strong>logdir</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;logs&quot;</code>) &#x2014;
Top-level logging directory for checkpoint saving.`,name:"logdir"},{anchor:"trl.DDPOConfig.num_epochs",description:`<strong>num_epochs</strong> (<code>int</code>, <em>optional</em>, defaults to <code>100</code>) &#x2014;
Number of epochs to train.`,name:"num_epochs"},{anchor:"trl.DDPOConfig.save_freq",description:`<strong>save_freq</strong> (<code>int</code>, <em>optional</em>, defaults to <code>1</code>) &#x2014;
Number of epochs between saving model checkpoints.`,name:"save_freq"},{anchor:"trl.DDPOConfig.num_checkpoint_limit",description:`<strong>num_checkpoint_limit</strong> (<code>int</code>, <em>optional</em>, defaults to <code>5</code>) &#x2014;
Number of checkpoints to keep before overwriting old ones.`,name:"num_checkpoint_limit"},{anchor:"trl.DDPOConfig.mixed_precision",description:`<strong>mixed_precision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;fp16&quot;</code>) &#x2014;
Mixed precision training.`,name:"mixed_precision"},{anchor:"trl.DDPOConfig.allow_tf32",description:`<strong>allow_tf32</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Allow <code>tf32</code> on Ampere GPUs.`,name:"allow_tf32"},{anchor:"trl.DDPOConfig.resume_from",description:`<strong>resume_from</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
Resume training from a checkpoint.`,name:"resume_from"},{anchor:"trl.DDPOConfig.sample_num_steps",description:`<strong>sample_num_steps</strong> (<code>int</code>, <em>optional</em>, defaults to <code>50</code>) &#x2014;
Number of sampler inference steps.`,name:"sample_num_steps"},{anchor:"trl.DDPOConfig.sample_eta",description:`<strong>sample_eta</strong> (<code>float</code>, <em>optional</em>, defaults to <code>1.0</code>) &#x2014;
Eta parameter for the DDIM sampler.`,name:"sample_eta"},{anchor:"trl.DDPOConfig.sample_guidance_scale",description:`<strong>sample_guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to <code>5.0</code>) &#x2014;
Classifier-free guidance weight.`,name:"sample_guidance_scale"},{anchor:"trl.DDPOConfig.sample_batch_size",description:`<strong>sample_batch_size</strong> (<code>int</code>, <em>optional</em>, defaults to <code>1</code>) &#x2014;
Batch size (per GPU) to use for sampling.`,name:"sample_batch_size"},{anchor:"trl.DDPOConfig.sample_num_batches_per_epoch",description:`<strong>sample_num_batches_per_epoch</strong> (<code>int</code>, <em>optional</em>, defaults to <code>2</code>) &#x2014;
Number of batches to sample per epoch.`,name:"sample_num_batches_per_epoch"},{anchor:"trl.DDPOConfig.train_batch_size",description:`<strong>train_batch_size</strong> (<code>int</code>, <em>optional</em>, defaults to <code>1</code>) &#x2014;
Batch size (per GPU) to use for training.`,name:"train_batch_size"},{anchor:"trl.DDPOConfig.train_use_8bit_adam",description:`<strong>train_use_8bit_adam</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Use 8bit Adam optimizer from bitsandbytes.`,name:"train_use_8bit_adam"},{anchor:"trl.DDPOConfig.train_learning_rate",description:`<strong>train_learning_rate</strong> (<code>float</code>, <em>optional</em>, defaults to <code>3e-4</code>) &#x2014;
Learning rate.`,name:"train_learning_rate"},{anchor:"trl.DDPOConfig.train_adam_beta1",description:`<strong>train_adam_beta1</strong> (<code>float</code>, <em>optional</em>, defaults to <code>0.9</code>) &#x2014;
Adam beta1.`,name:"train_adam_beta1"},{anchor:"trl.DDPOConfig.train_adam_beta2",description:`<strong>train_adam_beta2</strong> (<code>float</code>, <em>optional</em>, defaults to <code>0.999</code>) &#x2014;
Adam beta2.`,name:"train_adam_beta2"},{anchor:"trl.DDPOConfig.train_adam_weight_decay",description:`<strong>train_adam_weight_decay</strong> (<code>float</code>, <em>optional</em>, defaults to <code>1e-4</code>) &#x2014;
Adam weight decay.`,name:"train_adam_weight_decay"},{anchor:"trl.DDPOConfig.train_adam_epsilon",description:`<strong>train_adam_epsilon</strong> (<code>float</code>, <em>optional</em>, defaults to <code>1e-8</code>) &#x2014;
Adam epsilon.`,name:"train_adam_epsilon"},{anchor:"trl.DDPOConfig.train_gradient_accumulation_steps",description:`<strong>train_gradient_accumulation_steps</strong> (<code>int</code>, <em>optional</em>, defaults to <code>1</code>) &#x2014;
Number of gradient accumulation steps.`,name:"train_gradient_accumulation_steps"},{anchor:"trl.DDPOConfig.train_max_grad_norm",description:`<strong>train_max_grad_norm</strong> (<code>float</code>, <em>optional</em>, defaults to <code>1.0</code>) &#x2014;
Maximum gradient norm for gradient clipping.`,name:"train_max_grad_norm"},{anchor:"trl.DDPOConfig.train_num_inner_epochs",description:`<strong>train_num_inner_epochs</strong> (<code>int</code>, <em>optional</em>, defaults to <code>1</code>) &#x2014;
Number of inner epochs per outer epoch.`,name:"train_num_inner_epochs"},{anchor:"trl.DDPOConfig.train_cfg",description:`<strong>train_cfg</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to use classifier-free guidance during training.`,name:"train_cfg"},{anchor:"trl.DDPOConfig.train_adv_clip_max",description:`<strong>train_adv_clip_max</strong> (<code>float</code>, <em>optional</em>, defaults to <code>5.0</code>) &#x2014;
Clip advantages to the range.`,name:"train_adv_clip_max"},{anchor:"trl.DDPOConfig.train_clip_range",description:`<strong>train_clip_range</strong> (<code>float</code>, <em>optional</em>, defaults to <code>1e-4</code>) &#x2014;
PPO clip range.`,name:"train_clip_range"},{anchor:"trl.DDPOConfig.train_timestep_fraction",description:`<strong>train_timestep_fraction</strong> (<code>float</code>, <em>optional</em>, defaults to <code>1.0</code>) &#x2014;
Fraction of timesteps to train on.`,name:"train_timestep_fraction"},{anchor:"trl.DDPOConfig.per_prompt_stat_tracking",description:`<strong>per_prompt_stat_tracking</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to track statistics for each prompt separately.`,name:"per_prompt_stat_tracking"},{anchor:"trl.DDPOConfig.per_prompt_stat_tracking_buffer_size",description:`<strong>per_prompt_stat_tracking_buffer_size</strong> (<code>int</code>, <em>optional</em>, defaults to <code>16</code>) &#x2014;
Number of reward values to store in the buffer for each prompt.`,name:"per_prompt_stat_tracking_buffer_size"},{anchor:"trl.DDPOConfig.per_prompt_stat_tracking_min_count",description:`<strong>per_prompt_stat_tracking_min_count</strong> (<code>int</code>, <em>optional</em>, defaults to <code>16</code>) &#x2014;
Minimum number of reward values to store in the buffer.`,name:"per_prompt_stat_tracking_min_count"},{anchor:"trl.DDPOConfig.async_reward_computation",description:`<strong>async_reward_computation</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to compute rewards asynchronously.`,name:"async_reward_computation"},{anchor:"trl.DDPOConfig.max_workers",description:`<strong>max_workers</strong> (<code>int</code>, <em>optional</em>, defaults to <code>2</code>) &#x2014;
Maximum number of workers to use for async reward computation.`,name:"max_workers"},{anchor:"trl.DDPOConfig.negative_prompts",description:`<strong>negative_prompts</strong> (<code>Optional[str]</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
Comma-separated list of prompts to use as negative examples.`,name:"negative_prompts"}],source:"https://github.com/huggingface/trl/blob/v0.11.2/trl/trainer/ddpo_config.py#L26"}}),ge=new pn({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/ddpo_trainer.mdx"}}),{c(){v=r("meta"),$e=o(),xe=r("p"),ke=o(),d(k.$$.fragment),je=o(),d(j.$$.fragment),Je=o(),J=r("table"),J.innerHTML=Jt,Pe=o(),d(P.$$.fragment),Ue=o(),U=r("p"),U.innerHTML=Pt,Oe=o(),O=r("p"),O.innerHTML=Ut,Ie=o(),I=r("p"),I.textContent=Ot,Ae=o(),A=r("p"),A.innerHTML=It,Ze=o(),Z=r("p"),Z.textContent=At,Le=o(),L=r("p"),L.textContent=Zt,Be=o(),d(B.$$.fragment),He=o(),H=r("p"),H.innerHTML=Lt,ze=o(),z=r("p"),z.innerHTML=Bt,Ge=o(),G=r("p"),G.innerHTML=Ht,Ne=o(),d(N.$$.fragment),qe=o(),q=r("p"),q.innerHTML=zt,Se=o(),S=r("p"),S.textContent=Gt,Ee=o(),E=r("ul"),E.innerHTML=Nt,Re=o(),d(R.$$.fragment),Xe=o(),X=r("p"),X.textContent=qt,We=o(),d(W.$$.fragment),Ye=o(),Y=r("p"),Y.innerHTML=St,Qe=o(),d(Q.$$.fragment),Ve=o(),V=r("ul"),V.innerHTML=Et,Fe=o(),F=r("p"),F.innerHTML=Rt,Ke=o(),d(K.$$.fragment),et=o(),d(ee.$$.fragment),tt=o(),te=r("p"),te.textContent=Xt,nt=o(),d(ne.$$.fragment),at=o(),d(ae.$$.fragment),ot=o(),oe=r("p"),oe.innerHTML=Wt,it=o(),d(ie.$$.fragment),rt=o(),u=r("div"),d(re.$$.fragment),ut=o(),he=r("p"),he.innerHTML=Yt,_t=o(),T=r("div"),d(se.$$.fragment),bt=o(),fe=r("p"),fe.textContent=Qt,wt=o(),M=r("div"),d(le.$$.fragment),yt=o(),ue=r("p"),ue.textContent=Vt,vt=o(),_=r("div"),d(ce.$$.fragment),Tt=o(),_e=r("p"),_e.textContent=Ft,Mt=o(),be=r("p"),be.textContent=Kt,Dt=o(),we=r("ul"),we.innerHTML=en,xt=o(),D=r("div"),d(de.$$.fragment),Ct=o(),ye=r("p"),ye.textContent=tn,st=o(),d(pe.$$.fragment),lt=o(),w=r("div"),d(me.$$.fragment),$t=o(),ve=r("p"),ve.innerHTML=nn,kt=o(),Te=r("p"),Te.innerHTML=an,ct=o(),d(ge.$$.fragment),dt=o(),Ce=r("p"),this.h()},l(e){const t=dn("svelte-u9bgzb",document.head);v=s(t,"META",{name:!0,content:!0}),t.forEach(n),$e=i(e),xe=s(e,"P",{}),C(xe).forEach(n),ke=i(e),p(k.$$.fragment,e),je=i(e),p(j.$$.fragment,e),Je=i(e),J=s(e,"TABLE",{"data-svelte-h":!0}),l(J)!=="svelte-k42nnq"&&(J.innerHTML=Jt),Pe=i(e),p(P.$$.fragment,e),Ue=i(e),U=s(e,"P",{"data-svelte-h":!0}),l(U)!=="svelte-1ut0u9"&&(U.innerHTML=Pt),Oe=i(e),O=s(e,"P",{"data-svelte-h":!0}),l(O)!=="svelte-xp6gwm"&&(O.innerHTML=Ut),Ie=i(e),I=s(e,"P",{"data-svelte-h":!0}),l(I)!=="svelte-a4w6o0"&&(I.textContent=Ot),Ae=i(e),A=s(e,"P",{"data-svelte-h":!0}),l(A)!=="svelte-t0ve8a"&&(A.innerHTML=It),Ze=i(e),Z=s(e,"P",{"data-svelte-h":!0}),l(Z)!=="svelte-1s71aap"&&(Z.textContent=At),Le=i(e),L=s(e,"P",{"data-svelte-h":!0}),l(L)!=="svelte-1e16bv7"&&(L.textContent=Zt),Be=i(e),p(B.$$.fragment,e),He=i(e),H=s(e,"P",{"data-svelte-h":!0}),l(H)!=="svelte-1cfw9tr"&&(H.innerHTML=Lt),ze=i(e),z=s(e,"P",{"data-svelte-h":!0}),l(z)!=="svelte-xqnbvi"&&(z.innerHTML=Bt),Ge=i(e),G=s(e,"P",{"data-svelte-h":!0}),l(G)!=="svelte-1iay88v"&&(G.innerHTML=Ht),Ne=i(e),p(N.$$.fragment,e),qe=i(e),q=s(e,"P",{"data-svelte-h":!0}),l(q)!=="svelte-mmabua"&&(q.innerHTML=zt),Se=i(e),S=s(e,"P",{"data-svelte-h":!0}),l(S)!=="svelte-gn7d4"&&(S.textContent=Gt),Ee=i(e),E=s(e,"UL",{"data-svelte-h":!0}),l(E)!=="svelte-1wxt0fz"&&(E.innerHTML=Nt),Re=i(e),p(R.$$.fragment,e),Xe=i(e),X=s(e,"P",{"data-svelte-h":!0}),l(X)!=="svelte-171n2tq"&&(X.textContent=qt),We=i(e),p(W.$$.fragment,e),Ye=i(e),Y=s(e,"P",{"data-svelte-h":!0}),l(Y)!=="svelte-qc0duo"&&(Y.innerHTML=St),Qe=i(e),p(Q.$$.fragment,e),Ve=i(e),V=s(e,"UL",{"data-svelte-h":!0}),l(V)!=="svelte-hf6txl"&&(V.innerHTML=Et),Fe=i(e),F=s(e,"P",{"data-svelte-h":!0}),l(F)!=="svelte-1r6a60u"&&(F.innerHTML=Rt),Ke=i(e),p(K.$$.fragment,e),et=i(e),p(ee.$$.fragment,e),tt=i(e),te=s(e,"P",{"data-svelte-h":!0}),l(te)!=="svelte-eqxomu"&&(te.textContent=Xt),nt=i(e),p(ne.$$.fragment,e),at=i(e),p(ae.$$.fragment,e),ot=i(e),oe=s(e,"P",{"data-svelte-h":!0}),l(oe)!=="svelte-16vahxi"&&(oe.innerHTML=Wt),it=i(e),p(ie.$$.fragment,e),rt=i(e),u=s(e,"DIV",{class:!0});var b=C(u);p(re.$$.fragment,b),ut=i(b),he=s(b,"P",{"data-svelte-h":!0}),l(he)!=="svelte-8q861t"&&(he.innerHTML=Yt),_t=i(b),T=s(b,"DIV",{class:!0});var mt=C(T);p(se.$$.fragment,mt),bt=i(mt),fe=s(mt,"P",{"data-svelte-h":!0}),l(fe)!=="svelte-1ag17u3"&&(fe.textContent=Qt),mt.forEach(n),wt=i(b),M=s(b,"DIV",{class:!0});var gt=C(M);p(le.$$.fragment,gt),yt=i(gt),ue=s(gt,"P",{"data-svelte-h":!0}),l(ue)!=="svelte-3jfrz9"&&(ue.textContent=Vt),gt.forEach(n),vt=i(b),_=s(b,"DIV",{class:!0});var x=C(_);p(ce.$$.fragment,x),Tt=i(x),_e=s(x,"P",{"data-svelte-h":!0}),l(_e)!=="svelte-r6y15n"&&(_e.textContent=Ft),Mt=i(x),be=s(x,"P",{"data-svelte-h":!0}),l(be)!=="svelte-imqqfp"&&(be.textContent=Kt),Dt=i(x),we=s(x,"UL",{"data-svelte-h":!0}),l(we)!=="svelte-105j238"&&(we.innerHTML=en),x.forEach(n),xt=i(b),D=s(b,"DIV",{class:!0});var ht=C(D);p(de.$$.fragment,ht),Ct=i(ht),ye=s(ht,"P",{"data-svelte-h":!0}),l(ye)!=="svelte-1an944l"&&(ye.textContent=tn),ht.forEach(n),b.forEach(n),st=i(e),p(pe.$$.fragment,e),lt=i(e),w=s(e,"DIV",{class:!0});var Me=C(w);p(me.$$.fragment,Me),$t=i(Me),ve=s(Me,"P",{"data-svelte-h":!0}),l(ve)!=="svelte-iepuz6"&&(ve.innerHTML=nn),kt=i(Me),Te=s(Me,"P",{"data-svelte-h":!0}),l(Te)!=="svelte-1iitlg5"&&(Te.innerHTML=an),Me.forEach(n),ct=i(e),p(ge.$$.fragment,e),dt=i(e),Ce=s(e,"P",{}),C(Ce).forEach(n),this.h()},h(){$(v,"name","hf:doc:metadata"),$(v,"content",gn),$(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(_,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(u,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){c(document.head,v),a(e,$e,t),a(e,xe,t),a(e,ke,t),m(k,e,t),a(e,je,t),m(j,e,t),a(e,Je,t),a(e,J,t),a(e,Pe,t),m(P,e,t),a(e,Ue,t),a(e,U,t),a(e,Oe,t),a(e,O,t),a(e,Ie,t),a(e,I,t),a(e,Ae,t),a(e,A,t),a(e,Ze,t),a(e,Z,t),a(e,Le,t),a(e,L,t),a(e,Be,t),m(B,e,t),a(e,He,t),a(e,H,t),a(e,ze,t),a(e,z,t),a(e,Ge,t),a(e,G,t),a(e,Ne,t),m(N,e,t),a(e,qe,t),a(e,q,t),a(e,Se,t),a(e,S,t),a(e,Ee,t),a(e,E,t),a(e,Re,t),m(R,e,t),a(e,Xe,t),a(e,X,t),a(e,We,t),m(W,e,t),a(e,Ye,t),a(e,Y,t),a(e,Qe,t),m(Q,e,t),a(e,Ve,t),a(e,V,t),a(e,Fe,t),a(e,F,t),a(e,Ke,t),m(K,e,t),a(e,et,t),m(ee,e,t),a(e,tt,t),a(e,te,t),a(e,nt,t),m(ne,e,t),a(e,at,t),m(ae,e,t),a(e,ot,t),a(e,oe,t),a(e,it,t),m(ie,e,t),a(e,rt,t),a(e,u,t),m(re,u,null),c(u,ut),c(u,he),c(u,_t),c(u,T),m(se,T,null),c(T,bt),c(T,fe),c(u,wt),c(u,M),m(le,M,null),c(M,yt),c(M,ue),c(u,vt),c(u,_),m(ce,_,null),c(_,Tt),c(_,_e),c(_,Mt),c(_,be),c(_,Dt),c(_,we),c(u,xt),c(u,D),m(de,D,null),c(D,Ct),c(D,ye),a(e,st,t),m(pe,e,t),a(e,lt,t),a(e,w,t),m(me,w,null),c(w,$t),c(w,ve),c(w,kt),c(w,Te),a(e,ct,t),m(ge,e,t),a(e,dt,t),a(e,Ce,t),pt=!0},p:rn,i(e){pt||(g(k.$$.fragment,e),g(j.$$.fragment,e),g(P.$$.fragment,e),g(B.$$.fragment,e),g(N.$$.fragment,e),g(R.$$.fragment,e),g(W.$$.fragment,e),g(Q.$$.fragment,e),g(K.$$.fragment,e),g(ee.$$.fragment,e),g(ne.$$.fragment,e),g(ae.$$.fragment,e),g(ie.$$.fragment,e),g(re.$$.fragment,e),g(se.$$.fragment,e),g(le.$$.fragment,e),g(ce.$$.fragment,e),g(de.$$.fragment,e),g(pe.$$.fragment,e),g(me.$$.fragment,e),g(ge.$$.fragment,e),pt=!0)},o(e){h(k.$$.fragment,e),h(j.$$.fragment,e),h(P.$$.fragment,e),h(B.$$.fragment,e),h(N.$$.fragment,e),h(R.$$.fragment,e),h(W.$$.fragment,e),h(Q.$$.fragment,e),h(K.$$.fragment,e),h(ee.$$.fragment,e),h(ne.$$.fragment,e),h(ae.$$.fragment,e),h(ie.$$.fragment,e),h(re.$$.fragment,e),h(se.$$.fragment,e),h(le.$$.fragment,e),h(ce.$$.fragment,e),h(de.$$.fragment,e),h(pe.$$.fragment,e),h(me.$$.fragment,e),h(ge.$$.fragment,e),pt=!1},d(e){e&&(n($e),n(xe),n(ke),n(je),n(Je),n(J),n(Pe),n(Ue),n(U),n(Oe),n(O),n(Ie),n(I),n(Ae),n(A),n(Ze),n(Z),n(Le),n(L),n(Be),n(He),n(H),n(ze),n(z),n(Ge),n(G),n(Ne),n(qe),n(q),n(Se),n(S),n(Ee),n(E),n(Re),n(Xe),n(X),n(We),n(Ye),n(Y),n(Qe),n(Ve),n(V),n(Fe),n(F),n(Ke),n(et),n(tt),n(te),n(nt),n(at),n(ot),n(oe),n(it),n(rt),n(u),n(st),n(lt),n(w),n(ct),n(dt),n(Ce)),n(v),f(k,e),f(j,e),f(P,e),f(B,e),f(N,e),f(R,e),f(W,e),f(Q,e),f(K,e),f(ee,e),f(ne,e),f(ae,e),f(ie,e),f(re),f(se),f(le),f(ce),f(de),f(pe,e),f(me),f(ge,e)}}}const gn='{"title":"Denoising Diffusion Policy Optimization","local":"denoising-diffusion-policy-optimization","sections":[{"title":"The why","local":"the-why","sections":[],"depth":2},{"title":"Getting started with Stable Diffusion finetuning with reinforcement learning","local":"getting-started-with-stable-diffusion-finetuning-with-reinforcement-learning","sections":[],"depth":2},{"title":"Getting started with examples/scripts/ddpo.py","local":"getting-started-with-examplesscriptsddpopy","sections":[],"depth":2},{"title":"Setting up the image logging hook function","local":"setting-up-the-image-logging-hook-function","sections":[{"title":"Key terms","local":"key-terms","sections":[],"depth":3},{"title":"Using the finetuned model","local":"using-the-finetuned-model","sections":[],"depth":3}],"depth":2},{"title":"Credits","local":"credits","sections":[],"depth":2},{"title":"DDPOTrainer","local":"trl.DDPOTrainer","sections":[],"depth":2},{"title":"DDPOConfig","local":"trl.DDPOConfig","sections":[],"depth":2}],"depth":1}';function hn(jt){return sn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class yn extends ln{constructor(v){super(),cn(this,v,hn,mn,on,{})}}export{yn as component};
