import{s as ke,n as Ge,o as We}from"../chunks/scheduler.c59d9fbb.js";import{S as Be,i as Se,g as i,s as l,r as p,A as Re,h as r,f as s,c as n,j as Xe,u as o,x as g,k as _e,y as He,a,v as m,d as c,t as d,w as h}from"../chunks/index.a47918e3.js";import{C as u}from"../chunks/CodeBlock.936db8cd.js";import{D as Ne}from"../chunks/DocNotebookDropdown.c0ce911f.js";import{H as M}from"../chunks/Heading.604bc707.js";function Qe(oe){let f,ht,ct,gt,y,ut,b,ft,w,me='This quickstart is intended for developers who are ready to dive into the code and see an example of how to train and use 🤗 SetFit models. We recommend starting with this quickstart, and then proceeding to the <a href="./tutorials/overview">tutorials</a> or <a href="./how_to/overview">how-to guides</a> for additional material. Additionally, the <a href="./conceptual_guides/setfit">conceptual guides</a> help explain exactly how SetFit works.',Mt,j,ce="Start by installing 🤗 SetFit:",yt,J,bt,T,de='If you have a CUDA-capable graphics card, then it is recommended to <a href="https://pytorch.org/get-started/locally/" rel="nofollow">install <code>torch</code> with CUDA support</a> to train and performing inference much more quickly:',wt,U,jt,$,Jt,v,he="SetFit is an efficient framework to train low-latency text classification models using little training data. In this Quickstart, you’ll learn how to train a SetFit model, how to perform inference with it, and how to save it to the Hugging Face Hub.",Tt,x,Ut,Z,ge='In this section, you’ll load a <a href="https://huggingface.co/models?library=sentence-transformers" rel="nofollow">Sentence Transformer model</a> and further finetune it for classifying movie reviews as positive or negative. To train a model, we will need to prepare the following three: 1) a <strong>model</strong>, 2) a <strong>dataset</strong>, and 3) <strong>training arguments</strong>.',$t,I,ue='<strong>1</strong>. Initialize a SetFit model using a Sentence Transformer model of our choice. Consider using the <a href="https://huggingface.co/spaces/mteb/leaderboard" rel="nofollow">MTEB Leaderboard</a> to guide your decision on which Sentence Transformer model to choose. We will use <a href="https://huggingface.co/BAAI/bge-small-en-v1.5" rel="nofollow">BAAI/bge-small-en-v1.5</a>, a small but performant model.',vt,C,xt,F,fe='<strong>2a</strong>. Next, load both the “train” and “test” splits of the <a href="https://huggingface.co/datasets/sst2" rel="nofollow">SetFit/sst2</a> dataset. Note that the dataset has <code>&quot;text&quot;</code> and <code>&quot;label&quot;</code> columns: this is exactly the format that 🤗 SetFit expects. If your dataset has different columns, then you can use the column_mapping argument of the <a href="/docs/setfit/main/en/reference/trainer#setfit.Trainer">Trainer</a> in step 4 to map the column names to <code>&quot;text&quot;</code> and <code>&quot;label&quot;</code>.',Zt,X,It,_,Me="<strong>2b</strong>. In real world scenarios it is very uncommon to have ~7.000 high quality labeled training samples, so we will heavily shrink the training dataset to give a better idea of how 🤗 SetFit would work in real settings. To be specific, the <code>sample_dataset</code> function will sample only 8 samples for each class. The testing set is left unaffected for better evaluation.",Ct,k,Ft,G,Xt,W,ye="<strong>2c</strong>. We can apply the labels from the dataset on the model, so the predictions output readable classes. You can also provide the labels directly to <code>SetFitModel.from_pretrained()</code>.",_t,B,kt,S,be='<strong>3</strong>. Prepare the <a href="/docs/setfit/main/en/reference/trainer#setfit.TrainingArguments">TrainingArguments</a> for training. Note that training with 🤗 SetFit consists of two phases behind the scenes: <strong>finetuning embeddings</strong> and <strong>training a classification head</strong>. As a result, some of the training arguments can be tuples, where the two values are used for each of the two phases, respectively.',Gt,R,we="The <code>num_epochs</code> and <code>max_steps</code> arguments are frequently used to increase and decrease the number of total training steps. Consider that with SetFit, better performance is reached with <strong>more data, not more training</strong>! Don’t be afraid to train for less than 1 epoch if you have a lot of data.",Wt,H,Bt,N,je='<strong>4</strong>. Initialize the <a href="/docs/setfit/main/en/reference/trainer#setfit.Trainer">Trainer</a> and perform training.',St,Q,Rt,q,Ht,z,Je="<strong>5</strong>. Perform evaluation using the provided testing dataset.",Nt,Y,Qt,L,Te="Feel free to experiment with increasing the number of samples per class to observe the improvements in accuracy. As a challenge, you can play with the samples per class, learning rate, number of epochs, maximum number of steps, and the base Sentence Transformer model to try and improve the accuracy over 90% using very little data.",qt,V,zt,E,Ue="After training, you can save a 🤗 SetFit model to your local filesystem or to the Hugging Face Hub. Save a model to a local directory using <code>SetFitModel.save_pretrained()</code> by providing a <code>save_directory</code>:",Yt,A,Lt,P,$e="Alternatively, push a model to the Hugging Face Hub using <code>SetFitModel.push_to_hub()</code> by providing a <code>repo_id</code>:",Vt,D,Et,K,At,O,ve="A 🤗 SetFit model can be loaded using <code>SetFitModel.from_pretrained()</code> by providing 1) a <code>repo_id</code> from the Hugging Face Hub or 2) a path to a local directory:",Pt,tt,Dt,et,Kt,st,xe='Once a 🤗 SetFit model has been trained, then it can be used for inference to classify reviews using <a href="/docs/setfit/main/en/reference/main#setfit.PolarityModel.predict">SetFitModel.predict()</a> or <a href="/docs/setfit/main/en/reference/main#setfit.SetFitModel.__call__">SetFitModel.<strong>call</strong>()</a>:',Ot,at,te,lt,Ze="These predictions rely on the <code>model.labels</code>. If not set, it will return predictions in the format that was used during training, e.g. <code>tensor([1, 0, 0])</code>.",ee,nt,se,it,Ie="You’ve completed the 🤗 SetFit quickstart! You can train, save, load and perform inference with 🤗 SetFit models!",ae,pt,Ce='For your next steps, take a look at our <a href="./how_to/overview">How-to guides</a> and learn how to do more specific things like hyperparameter search, knowledge distillation, or zero-shot text classification. If you’re interested in learning more about how 🤗 SetFit works, grab a cup of coffee and read our <a href="./conceptual_guides/setfit">Conceptual Guides</a>!',le,rt,ne,ot,Fe="This snippet shows the entire quickstart in an end-to-end example:",ie,mt,pe,dt,re;return y=new M({props:{title:"Quickstart",local:"quickstart",headingTag:"h1"}}),b=new Ne({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/setfit_doc/en/quickstart.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/setfit_doc/en/pytorch/quickstart.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/setfit_doc/en/tensorflow/quickstart.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/setfit_doc/en/quickstart.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/setfit_doc/en/pytorch/quickstart.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/setfit_doc/en/tensorflow/quickstart.ipynb"}]}}),J=new u({props:{code:"cGlwJTIwaW5zdGFsbCUyMHNldGZpdA==",highlighted:"pip install setfit",wrap:!1}}),U=new u({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRvcmNoJTIwLS1pbmRleC11cmwlMjBodHRwcyUzQSUyRiUyRmRvd25sb2FkLnB5dG9yY2gub3JnJTJGd2hsJTJGY3UxMTg=",highlighted:"pip install torch --index-url https://download.pytorch.org/whl/cu118",wrap:!1}}),$=new M({props:{title:"SetFit",local:"setfit",headingTag:"h2"}}),x=new M({props:{title:"Training",local:"training",headingTag:"h3"}}),C=new u({props:{code:"ZnJvbSUyMHNldGZpdCUyMGltcG9ydCUyMFNldEZpdE1vZGVsJTBBJTBBbW9kZWwlMjAlM0QlMjBTZXRGaXRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyQkFBSSUyRmJnZS1zbWFsbC1lbi12MS41JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> SetFitModel

<span class="hljs-meta">&gt;&gt;&gt; </span>model = SetFitModel.from_pretrained(<span class="hljs-string">&quot;BAAI/bge-small-en-v1.5&quot;</span>)`,wrap:!1}}),X=new u({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJTZXRGaXQlMkZzc3QyJTIyKSUwQWRhdGFzZXQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;SetFit/sst2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset
DatasetDict({
    train: Dataset({
        features: [<span class="hljs-string">&#x27;text&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>, <span class="hljs-string">&#x27;label_text&#x27;</span>],
        num_rows: <span class="hljs-number">6920</span>
    })
    test: Dataset({
        features: [<span class="hljs-string">&#x27;text&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>, <span class="hljs-string">&#x27;label_text&#x27;</span>],
        num_rows: <span class="hljs-number">1821</span>
    })
    validation: Dataset({
        features: [<span class="hljs-string">&#x27;text&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>, <span class="hljs-string">&#x27;label_text&#x27;</span>],
        num_rows: <span class="hljs-number">872</span>
    })
})`,wrap:!1}}),k=new u({props:{code:"ZnJvbSUyMHNldGZpdCUyMGltcG9ydCUyMHNhbXBsZV9kYXRhc2V0JTBBJTBBdHJhaW5fZGF0YXNldCUyMCUzRCUyMHNhbXBsZV9kYXRhc2V0KGRhdGFzZXQlNUIlMjJ0cmFpbiUyMiU1RCUyQyUyMGxhYmVsX2NvbHVtbiUzRCUyMmxhYmVsJTIyJTJDJTIwbnVtX3NhbXBsZXMlM0Q4KSUwQXRyYWluX2RhdGFzZXQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> sample_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>train_dataset = sample_dataset(dataset[<span class="hljs-string">&quot;train&quot;</span>], label_column=<span class="hljs-string">&quot;label&quot;</span>, num_samples=<span class="hljs-number">8</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>train_dataset
Dataset({
    features: [<span class="hljs-string">&#x27;text&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>, <span class="hljs-string">&#x27;label_text&#x27;</span>],
    num_rows: <span class="hljs-number">16</span>
})`,wrap:!1}}),G=new u({props:{code:"dGVzdF9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldCU1QiUyMnRlc3QlMjIlNUQlMEF0ZXN0X2RhdGFzZXQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>test_dataset = dataset[<span class="hljs-string">&quot;test&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>test_dataset
Dataset({
    features: [<span class="hljs-string">&#x27;text&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>, <span class="hljs-string">&#x27;label_text&#x27;</span>],
    num_rows: <span class="hljs-number">1821</span>
})`,wrap:!1}}),B=new u({props:{code:"bW9kZWwubGFiZWxzJTIwJTNEJTIwJTVCJTIybmVnYXRpdmUlMjIlMkMlMjAlMjJwb3NpdGl2ZSUyMiU1RA==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model.labels = [<span class="hljs-string">&quot;negative&quot;</span>, <span class="hljs-string">&quot;positive&quot;</span>]',wrap:!1}}),H=new u({props:{code:"ZnJvbSUyMHNldGZpdCUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTBBJTBBYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMGJhdGNoX3NpemUlM0QzMiUyQyUwQSUyMCUyMCUyMCUyMG51bV9lcG9jaHMlM0QxMCUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> TrainingArguments

<span class="hljs-meta">&gt;&gt;&gt; </span>args = TrainingArguments(
<span class="hljs-meta">... </span>    batch_size=<span class="hljs-number">32</span>,
<span class="hljs-meta">... </span>    num_epochs=<span class="hljs-number">10</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),Q=new u({props:{code:"ZnJvbSUyMHNldGZpdCUyMGltcG9ydCUyMFRyYWluZXIlMEElMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRGFyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdHJhaW5fZGF0YXNldCUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> Trainer

<span class="hljs-meta">&gt;&gt;&gt; </span>trainer = Trainer(
<span class="hljs-meta">... </span>    model=model,
<span class="hljs-meta">... </span>    args=args,
<span class="hljs-meta">... </span>    train_dataset=train_dataset,
<span class="hljs-meta">... </span>)`,wrap:!1}}),q=new u({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.train()
***** Running training *****
  Num examples = <span class="hljs-number">5</span>
  Num epochs = <span class="hljs-number">10</span>
  Total optimization steps = <span class="hljs-number">50</span>
  Total train batch size = <span class="hljs-number">32</span>
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.2077</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">4.000000000000001e-06</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.2</span>}                                                                                                                
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.0097</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">0.0</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">10.0</span>}                                                                                                                                 
{<span class="hljs-string">&#x27;train_runtime&#x27;</span>: <span class="hljs-number">14.705</span>, <span class="hljs-string">&#x27;train_samples_per_second&#x27;</span>: <span class="hljs-number">108.807</span>, <span class="hljs-string">&#x27;train_steps_per_second&#x27;</span>: <span class="hljs-number">3.4</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">10.0</span>}
<span class="hljs-number">100</span>%|██████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████| <span class="hljs-number">50</span>/<span class="hljs-number">50</span> [<span class="hljs-number">00</span>:08&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>,  <span class="hljs-number">5.70</span>it/s]`,wrap:!1}}),Y=new u({props:{code:"dHJhaW5lci5ldmFsdWF0ZSh0ZXN0X2RhdGFzZXQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.evaluate(test_dataset)
***** Running evaluation *****
{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.8511806699615596</span>}`,wrap:!1}}),V=new M({props:{title:"Saving a 🤗 SetFit model",local:"saving-a--setfit-model",headingTag:"h3"}}),A=new u({props:{code:"bW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUyMnNldGZpdC1iZ2Utc21hbGwtdjEuNS1zc3QyLTgtc2hvdCUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(<span class="hljs-string">&quot;setfit-bge-small-v1.5-sst2-8-shot&quot;</span>)',wrap:!1}}),D=new u({props:{code:"bW9kZWwucHVzaF90b19odWIoJTIydG9tYWFyc2VuJTJGc2V0Zml0LWJnZS1zbWFsbC12MS41LXNzdDItOC1zaG90JTIyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model.push_to_hub(<span class="hljs-string">&quot;tomaarsen/setfit-bge-small-v1.5-sst2-8-shot&quot;</span>)',wrap:!1}}),K=new M({props:{title:"Loading a 🤗 SetFit model",local:"loading-a--setfit-model",headingTag:"h3"}}),tt=new u({props:{code:"bW9kZWwlMjAlM0QlMjBTZXRGaXRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIydG9tYWFyc2VuJTJGc2V0Zml0LWJnZS1zbWFsbC12MS41LXNzdDItOC1zaG90JTIyKSUyMCUyMyUyMExvYWQlMjBmcm9tJTIwdGhlJTIwSHVnZ2luZyUyMEZhY2UlMjBIdWIlMEElMEFtb2RlbCUyMCUzRCUyMFNldEZpdE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJzZXRmaXQtYmdlLXNtYWxsLXYxLjUtc3N0Mi04LXNob3QlMjIpJTIwJTIzJTIwTG9hZCUyMGZyb20lMjBhJTIwbG9jYWwlMjBkaXJlY3Rvcnk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>model = SetFitModel.from_pretrained(<span class="hljs-string">&quot;tomaarsen/setfit-bge-small-v1.5-sst2-8-shot&quot;</span>) <span class="hljs-comment"># Load from the Hugging Face Hub</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>model = SetFitModel.from_pretrained(<span class="hljs-string">&quot;setfit-bge-small-v1.5-sst2-8-shot&quot;</span>) <span class="hljs-comment"># Load from a local directory</span>`,wrap:!1}}),et=new M({props:{title:"Inference",local:"inference",headingTag:"h3"}}),at=new u({props:{code:"cHJlZHMlMjAlM0QlMjBtb2RlbC5wcmVkaWN0KCU1QiUwQSUyMCUyMCUyMCUyMCUyMkl0J3MlMjBhJTIwY2hhcm1pbmclMjBhbmQlMjBvZnRlbiUyMGFmZmVjdGluZyUyMGpvdXJuZXkuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIySXQncyUyMHNsb3clMjAtLSUyMHZlcnklMkMlMjB2ZXJ5JTIwc2xvdy4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJBJTIwc29tZXRpbWVzJTIwdGVkaW91cyUyMGZpbG0uJTIyJTJDJTBBJTVEKSUwQXByZWRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>preds = model.predict([
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;It&#x27;s a charming and often affecting journey.&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;It&#x27;s slow -- very, very slow.&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A sometimes tedious film.&quot;</span>,
<span class="hljs-meta">... </span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>preds
[<span class="hljs-string">&#x27;positive&#x27;</span> <span class="hljs-string">&#x27;negative&#x27;</span> <span class="hljs-string">&#x27;negative&#x27;</span>]`,wrap:!1}}),nt=new M({props:{title:"What’s next?",local:"whats-next",headingTag:"h2"}}),rt=new M({props:{title:"End-to-end",local:"end-to-end",headingTag:"h2"}}),mt=new u({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> SetFitModel, Trainer, TrainingArguments, sample_dataset
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># Initializing a new SetFit model</span>
model = SetFitModel.from_pretrained(<span class="hljs-string">&quot;BAAI/bge-small-en-v1.5&quot;</span>, labels=[<span class="hljs-string">&quot;negative&quot;</span>, <span class="hljs-string">&quot;positive&quot;</span>])

<span class="hljs-comment"># Preparing the dataset</span>
dataset = load_dataset(<span class="hljs-string">&quot;SetFit/sst2&quot;</span>)
train_dataset = sample_dataset(dataset[<span class="hljs-string">&quot;train&quot;</span>], label_column=<span class="hljs-string">&quot;label&quot;</span>, num_samples=<span class="hljs-number">8</span>)
test_dataset = dataset[<span class="hljs-string">&quot;test&quot;</span>]

<span class="hljs-comment"># Preparing the training arguments</span>
args = TrainingArguments(
    batch_size=<span class="hljs-number">32</span>,
    num_epochs=<span class="hljs-number">10</span>,
)

<span class="hljs-comment"># Preparing the trainer</span>
trainer = Trainer(
    model=model,
    args=args,
    train_dataset=train_dataset,
)
trainer.train()

<span class="hljs-comment"># Evaluating</span>
metrics = trainer.evaluate(test_dataset)
<span class="hljs-built_in">print</span>(metrics)
<span class="hljs-comment"># =&gt; {&#x27;accuracy&#x27;: 0.8511806699615596}</span>

<span class="hljs-comment"># Saving the trained model</span>
model.save_pretrained(<span class="hljs-string">&quot;setfit-bge-small-v1.5-sst2-8-shot&quot;</span>)
<span class="hljs-comment"># or</span>
model.push_to_hub(<span class="hljs-string">&quot;tomaarsen/setfit-bge-small-v1.5-sst2-8-shot&quot;</span>)

<span class="hljs-comment"># Loading a trained model</span>
model = SetFitModel.from_pretrained(<span class="hljs-string">&quot;tomaarsen/setfit-bge-small-v1.5-sst2-8-shot&quot;</span>) <span class="hljs-comment"># Load from the Hugging Face Hub</span>
<span class="hljs-comment"># or</span>
model = SetFitModel.from_pretrained(<span class="hljs-string">&quot;setfit-bge-small-v1.5-sst2-8-shot&quot;</span>) <span class="hljs-comment"># Load from a local directory</span>

<span class="hljs-comment"># Performing inference</span>
preds = model.predict([
    <span class="hljs-string">&quot;It&#x27;s a charming and often affecting journey.&quot;</span>,
    <span class="hljs-string">&quot;It&#x27;s slow -- very, very slow.&quot;</span>,
    <span class="hljs-string">&quot;A sometimes tedious film.&quot;</span>,
])
<span class="hljs-built_in">print</span>(preds)
<span class="hljs-comment"># =&gt; [&quot;positive&quot;, &quot;negative&quot;, &quot;negative&quot;]</span>`,wrap:!1}}),{c(){f=i("meta"),ht=l(),ct=i("p"),gt=l(),p(y.$$.fragment),ut=l(),p(b.$$.fragment),ft=l(),w=i("p"),w.innerHTML=me,Mt=l(),j=i("p"),j.textContent=ce,yt=l(),p(J.$$.fragment),bt=l(),T=i("p"),T.innerHTML=de,wt=l(),p(U.$$.fragment),jt=l(),p($.$$.fragment),Jt=l(),v=i("p"),v.textContent=he,Tt=l(),p(x.$$.fragment),Ut=l(),Z=i("p"),Z.innerHTML=ge,$t=l(),I=i("p"),I.innerHTML=ue,vt=l(),p(C.$$.fragment),xt=l(),F=i("p"),F.innerHTML=fe,Zt=l(),p(X.$$.fragment),It=l(),_=i("p"),_.innerHTML=Me,Ct=l(),p(k.$$.fragment),Ft=l(),p(G.$$.fragment),Xt=l(),W=i("p"),W.innerHTML=ye,_t=l(),p(B.$$.fragment),kt=l(),S=i("p"),S.innerHTML=be,Gt=l(),R=i("p"),R.innerHTML=we,Wt=l(),p(H.$$.fragment),Bt=l(),N=i("p"),N.innerHTML=je,St=l(),p(Q.$$.fragment),Rt=l(),p(q.$$.fragment),Ht=l(),z=i("p"),z.innerHTML=Je,Nt=l(),p(Y.$$.fragment),Qt=l(),L=i("p"),L.textContent=Te,qt=l(),p(V.$$.fragment),zt=l(),E=i("p"),E.innerHTML=Ue,Yt=l(),p(A.$$.fragment),Lt=l(),P=i("p"),P.innerHTML=$e,Vt=l(),p(D.$$.fragment),Et=l(),p(K.$$.fragment),At=l(),O=i("p"),O.innerHTML=ve,Pt=l(),p(tt.$$.fragment),Dt=l(),p(et.$$.fragment),Kt=l(),st=i("p"),st.innerHTML=xe,Ot=l(),p(at.$$.fragment),te=l(),lt=i("p"),lt.innerHTML=Ze,ee=l(),p(nt.$$.fragment),se=l(),it=i("p"),it.textContent=Ie,ae=l(),pt=i("p"),pt.innerHTML=Ce,le=l(),p(rt.$$.fragment),ne=l(),ot=i("p"),ot.textContent=Fe,ie=l(),p(mt.$$.fragment),pe=l(),dt=i("p"),this.h()},l(t){const e=Re("svelte-u9bgzb",document.head);f=r(e,"META",{name:!0,content:!0}),e.forEach(s),ht=n(t),ct=r(t,"P",{}),Xe(ct).forEach(s),gt=n(t),o(y.$$.fragment,t),ut=n(t),o(b.$$.fragment,t),ft=n(t),w=r(t,"P",{"data-svelte-h":!0}),g(w)!=="svelte-yf6m1a"&&(w.innerHTML=me),Mt=n(t),j=r(t,"P",{"data-svelte-h":!0}),g(j)!=="svelte-14v6c2i"&&(j.textContent=ce),yt=n(t),o(J.$$.fragment,t),bt=n(t),T=r(t,"P",{"data-svelte-h":!0}),g(T)!=="svelte-zdbrrm"&&(T.innerHTML=de),wt=n(t),o(U.$$.fragment,t),jt=n(t),o($.$$.fragment,t),Jt=n(t),v=r(t,"P",{"data-svelte-h":!0}),g(v)!=="svelte-yv05pn"&&(v.textContent=he),Tt=n(t),o(x.$$.fragment,t),Ut=n(t),Z=r(t,"P",{"data-svelte-h":!0}),g(Z)!=="svelte-55wyuo"&&(Z.innerHTML=ge),$t=n(t),I=r(t,"P",{"data-svelte-h":!0}),g(I)!=="svelte-b5pnqy"&&(I.innerHTML=ue),vt=n(t),o(C.$$.fragment,t),xt=n(t),F=r(t,"P",{"data-svelte-h":!0}),g(F)!=="svelte-1kj537f"&&(F.innerHTML=fe),Zt=n(t),o(X.$$.fragment,t),It=n(t),_=r(t,"P",{"data-svelte-h":!0}),g(_)!=="svelte-10w3ory"&&(_.innerHTML=Me),Ct=n(t),o(k.$$.fragment,t),Ft=n(t),o(G.$$.fragment,t),Xt=n(t),W=r(t,"P",{"data-svelte-h":!0}),g(W)!=="svelte-1x016ab"&&(W.innerHTML=ye),_t=n(t),o(B.$$.fragment,t),kt=n(t),S=r(t,"P",{"data-svelte-h":!0}),g(S)!=="svelte-16bcam5"&&(S.innerHTML=be),Gt=n(t),R=r(t,"P",{"data-svelte-h":!0}),g(R)!=="svelte-1z01zd6"&&(R.innerHTML=we),Wt=n(t),o(H.$$.fragment,t),Bt=n(t),N=r(t,"P",{"data-svelte-h":!0}),g(N)!=="svelte-vm5fvx"&&(N.innerHTML=je),St=n(t),o(Q.$$.fragment,t),Rt=n(t),o(q.$$.fragment,t),Ht=n(t),z=r(t,"P",{"data-svelte-h":!0}),g(z)!=="svelte-4ybstn"&&(z.innerHTML=Je),Nt=n(t),o(Y.$$.fragment,t),Qt=n(t),L=r(t,"P",{"data-svelte-h":!0}),g(L)!=="svelte-1svsu67"&&(L.textContent=Te),qt=n(t),o(V.$$.fragment,t),zt=n(t),E=r(t,"P",{"data-svelte-h":!0}),g(E)!=="svelte-1jhyq77"&&(E.innerHTML=Ue),Yt=n(t),o(A.$$.fragment,t),Lt=n(t),P=r(t,"P",{"data-svelte-h":!0}),g(P)!=="svelte-1hpf3g"&&(P.innerHTML=$e),Vt=n(t),o(D.$$.fragment,t),Et=n(t),o(K.$$.fragment,t),At=n(t),O=r(t,"P",{"data-svelte-h":!0}),g(O)!=="svelte-1di90ms"&&(O.innerHTML=ve),Pt=n(t),o(tt.$$.fragment,t),Dt=n(t),o(et.$$.fragment,t),Kt=n(t),st=r(t,"P",{"data-svelte-h":!0}),g(st)!=="svelte-1ahk5rr"&&(st.innerHTML=xe),Ot=n(t),o(at.$$.fragment,t),te=n(t),lt=r(t,"P",{"data-svelte-h":!0}),g(lt)!=="svelte-yxp1nk"&&(lt.innerHTML=Ze),ee=n(t),o(nt.$$.fragment,t),se=n(t),it=r(t,"P",{"data-svelte-h":!0}),g(it)!=="svelte-153smf1"&&(it.textContent=Ie),ae=n(t),pt=r(t,"P",{"data-svelte-h":!0}),g(pt)!=="svelte-1h8ndzm"&&(pt.innerHTML=Ce),le=n(t),o(rt.$$.fragment,t),ne=n(t),ot=r(t,"P",{"data-svelte-h":!0}),g(ot)!=="svelte-1lco45x"&&(ot.textContent=Fe),ie=n(t),o(mt.$$.fragment,t),pe=n(t),dt=r(t,"P",{}),Xe(dt).forEach(s),this.h()},h(){_e(f,"name","hf:doc:metadata"),_e(f,"content",qe)},m(t,e){He(document.head,f),a(t,ht,e),a(t,ct,e),a(t,gt,e),m(y,t,e),a(t,ut,e),m(b,t,e),a(t,ft,e),a(t,w,e),a(t,Mt,e),a(t,j,e),a(t,yt,e),m(J,t,e),a(t,bt,e),a(t,T,e),a(t,wt,e),m(U,t,e),a(t,jt,e),m($,t,e),a(t,Jt,e),a(t,v,e),a(t,Tt,e),m(x,t,e),a(t,Ut,e),a(t,Z,e),a(t,$t,e),a(t,I,e),a(t,vt,e),m(C,t,e),a(t,xt,e),a(t,F,e),a(t,Zt,e),m(X,t,e),a(t,It,e),a(t,_,e),a(t,Ct,e),m(k,t,e),a(t,Ft,e),m(G,t,e),a(t,Xt,e),a(t,W,e),a(t,_t,e),m(B,t,e),a(t,kt,e),a(t,S,e),a(t,Gt,e),a(t,R,e),a(t,Wt,e),m(H,t,e),a(t,Bt,e),a(t,N,e),a(t,St,e),m(Q,t,e),a(t,Rt,e),m(q,t,e),a(t,Ht,e),a(t,z,e),a(t,Nt,e),m(Y,t,e),a(t,Qt,e),a(t,L,e),a(t,qt,e),m(V,t,e),a(t,zt,e),a(t,E,e),a(t,Yt,e),m(A,t,e),a(t,Lt,e),a(t,P,e),a(t,Vt,e),m(D,t,e),a(t,Et,e),m(K,t,e),a(t,At,e),a(t,O,e),a(t,Pt,e),m(tt,t,e),a(t,Dt,e),m(et,t,e),a(t,Kt,e),a(t,st,e),a(t,Ot,e),m(at,t,e),a(t,te,e),a(t,lt,e),a(t,ee,e),m(nt,t,e),a(t,se,e),a(t,it,e),a(t,ae,e),a(t,pt,e),a(t,le,e),m(rt,t,e),a(t,ne,e),a(t,ot,e),a(t,ie,e),m(mt,t,e),a(t,pe,e),a(t,dt,e),re=!0},p:Ge,i(t){re||(c(y.$$.fragment,t),c(b.$$.fragment,t),c(J.$$.fragment,t),c(U.$$.fragment,t),c($.$$.fragment,t),c(x.$$.fragment,t),c(C.$$.fragment,t),c(X.$$.fragment,t),c(k.$$.fragment,t),c(G.$$.fragment,t),c(B.$$.fragment,t),c(H.$$.fragment,t),c(Q.$$.fragment,t),c(q.$$.fragment,t),c(Y.$$.fragment,t),c(V.$$.fragment,t),c(A.$$.fragment,t),c(D.$$.fragment,t),c(K.$$.fragment,t),c(tt.$$.fragment,t),c(et.$$.fragment,t),c(at.$$.fragment,t),c(nt.$$.fragment,t),c(rt.$$.fragment,t),c(mt.$$.fragment,t),re=!0)},o(t){d(y.$$.fragment,t),d(b.$$.fragment,t),d(J.$$.fragment,t),d(U.$$.fragment,t),d($.$$.fragment,t),d(x.$$.fragment,t),d(C.$$.fragment,t),d(X.$$.fragment,t),d(k.$$.fragment,t),d(G.$$.fragment,t),d(B.$$.fragment,t),d(H.$$.fragment,t),d(Q.$$.fragment,t),d(q.$$.fragment,t),d(Y.$$.fragment,t),d(V.$$.fragment,t),d(A.$$.fragment,t),d(D.$$.fragment,t),d(K.$$.fragment,t),d(tt.$$.fragment,t),d(et.$$.fragment,t),d(at.$$.fragment,t),d(nt.$$.fragment,t),d(rt.$$.fragment,t),d(mt.$$.fragment,t),re=!1},d(t){t&&(s(ht),s(ct),s(gt),s(ut),s(ft),s(w),s(Mt),s(j),s(yt),s(bt),s(T),s(wt),s(jt),s(Jt),s(v),s(Tt),s(Ut),s(Z),s($t),s(I),s(vt),s(xt),s(F),s(Zt),s(It),s(_),s(Ct),s(Ft),s(Xt),s(W),s(_t),s(kt),s(S),s(Gt),s(R),s(Wt),s(Bt),s(N),s(St),s(Rt),s(Ht),s(z),s(Nt),s(Qt),s(L),s(qt),s(zt),s(E),s(Yt),s(Lt),s(P),s(Vt),s(Et),s(At),s(O),s(Pt),s(Dt),s(Kt),s(st),s(Ot),s(te),s(lt),s(ee),s(se),s(it),s(ae),s(pt),s(le),s(ne),s(ot),s(ie),s(pe),s(dt)),s(f),h(y,t),h(b,t),h(J,t),h(U,t),h($,t),h(x,t),h(C,t),h(X,t),h(k,t),h(G,t),h(B,t),h(H,t),h(Q,t),h(q,t),h(Y,t),h(V,t),h(A,t),h(D,t),h(K,t),h(tt,t),h(et,t),h(at,t),h(nt,t),h(rt,t),h(mt,t)}}}const qe='{"title":"Quickstart","local":"quickstart","sections":[{"title":"SetFit","local":"setfit","sections":[{"title":"Training","local":"training","sections":[],"depth":3},{"title":"Saving a 🤗 SetFit model","local":"saving-a--setfit-model","sections":[],"depth":3},{"title":"Loading a 🤗 SetFit model","local":"loading-a--setfit-model","sections":[],"depth":3},{"title":"Inference","local":"inference","sections":[],"depth":3}],"depth":2},{"title":"What’s next?","local":"whats-next","sections":[],"depth":2},{"title":"End-to-end","local":"end-to-end","sections":[],"depth":2}],"depth":1}';function ze(oe){return We(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Pe extends Be{constructor(f){super(),Se(this,f,ze,Qe,ke,{})}}export{Pe as component};
