import{s as pa,o as oa,n as ia}from"../chunks/scheduler.9bc65507.js";import{S as ca,i as ra,g as i,s as l,r,A as ma,h as p,f as e,c as n,j as na,u as m,x as o,k as x,y as da,a,v as d,d as M,t as h,w as g,m as Ma,n as ha}from"../chunks/index.707bf1b6.js";import{T as ce}from"../chunks/Tip.c2ecdbf4.js";import{C as f}from"../chunks/CodeBlock.54a9f38d.js";import{D as ga}from"../chunks/DocNotebookDropdown.3e6b3817.js";import{H as j}from"../chunks/Heading.342b1fa6.js";function ua(J){let c;return{c(){c=Ma("To run the following examples with a non-quantized version of the model checkpoint you will need at least 20GB of GPU memory.")},l(y){c=ha(y,"To run the following examples with a non-quantized version of the model checkpoint you will need at least 20GB of GPU memory.")},m(y,u){a(y,c,u)},d(y){y&&e(c)}}}function ya(J){let c,y=`It is a good idea to include the <code>bad_words_ids</code> in the call to <code>generate</code> to avoid errors arising when increasing
the <code>max_new_tokens</code>: the model will want to generate a new <code>&lt;image&gt;</code> or <code>&lt;fake_token_around_image&gt;</code> token when there
is no image being generated by the model.
You can set it on-the-fly as in this guide, or store in the <code>GenerationConfig</code> as described in the <a href="../generation_strategies">Text generation strategies</a> guide.`;return{c(){c=i("p"),c.innerHTML=y},l(u){c=p(u,"P",{"data-svelte-h":!0}),o(c)!=="svelte-uwc51d"&&(c.innerHTML=y)},m(u,w){a(u,c,w)},p:ia,d(u){u&&e(c)}}}function fa(J){let c,y=`For longer outputs like this, you will greatly benefit from tweaking the text generation strategy. This can help
you significantly improve the quality of the generated output. Check out <a href="../generation_strategies">Text generation strategies</a>
to learn more.`;return{c(){c=i("p"),c.innerHTML=y},l(u){c=p(u,"P",{"data-svelte-h":!0}),o(c)!=="svelte-79vr3a"&&(c.innerHTML=y)},m(u,w){a(u,c,w)},p:ia,d(u){u&&e(c)}}}function ja(J){let c,y,u,w,W,Et,N,$t,_,re=`While individual tasks can be tackled by fine-tuning specialized models, an alternative approach
that has recently emerged and gained popularity is to use large models for a diverse set of tasks without fine-tuning.
For instance, large language models can handle such NLP tasks as summarization, translation, classification, and more.
This approach is no longer limited to a single modality, such as text, and in this guide, we will illustrate how you can
solve image-text tasks with a large multimodal model called IDEFICS.`,Yt,G,me=`<a href="../model_doc/idefics">IDEFICS</a> is an open-access vision and language model based on <a href="https://huggingface.co/papers/2204.14198" rel="nofollow">Flamingo</a>,
a state-of-the-art visual language model initially developed by DeepMind. The model accepts arbitrary sequences of image
and text inputs and generates coherent text as output. It can answer questions about images, describe visual content,
create stories grounded in multiple images, and so on. IDEFICS comes in two variants - <a href="https://huggingface.co/HuggingFaceM4/idefics-80b" rel="nofollow">80 billion parameters</a>
and <a href="https://huggingface.co/HuggingFaceM4/idefics-9b" rel="nofollow">9 billion parameters</a>, both of which are available on the 🤗 Hub. For each variant, you can also find fine-tuned instructed
versions of the model adapted for conversational use cases.`,At,z,de=`This model is exceptionally versatile and can be used for a wide range of image and multimodal tasks. However,
being a large model means it requires significant computational resources and infrastructure. It is up to you to decide whether
this approach suits your use case better than fine-tuning specialized models for each individual task.`,qt,Q,Me="In this guide, you’ll learn how to:",St,B,he='<li><a href="#loading-the-model">Load IDEFICS</a> and <a href="#loading-the-quantized-version-of-the-model">load the quantized version of the model</a></li> <li>Use IDEFICS for: <ul><li><a href="#image-captioning">Image captioning</a></li> <li><a href="#prompted-image-captioning">Prompted image captioning</a></li> <li><a href="#few-shot-prompting">Few-shot prompting</a></li> <li><a href="#visual-question-answering">Visual question answering</a></li> <li><a href="#image-classification">Image classificaiton</a></li> <li><a href="#image-guided-text-generation">Image-guided text generation</a></li></ul></li> <li><a href="#running-inference-in-batch-mode">Run inference in batch mode</a></li> <li><a href="#idefics-instruct-for-conversational-use">Run IDEFICS instruct for conversational use</a></li>',Dt,V,ge="Before you begin, make sure you have all the necessary libraries installed.",Lt,H,Pt,T,Ot,X,Kt,F,ue="Let’s start by loading the model’s 9 billion parameters checkpoint:",ts,E,ss,$,ye=`Just like for other Transformers models, you need to load a processor and the model itself from the checkpoint.
The IDEFICS processor wraps a <a href="/docs/transformers/v4.35.2/en/model_doc/llama#transformers.LlamaTokenizer">LlamaTokenizer</a> and IDEFICS image processor into a single processor to take care of
preparing text and image inputs for the model.`,es,Y,as,A,fe=`Setting <code>device_map</code> to <code>&quot;auto&quot;</code> will automatically determine how to load and store the model weights in the most optimized
manner given existing devices.`,ls,q,ns,S,je=`If high-memory GPU availability is an issue, you can load the quantized version of the model. To load the model and the
processor in 4bit precision, pass a <code>BitsAndBytesConfig</code> to the <code>from_pretrained</code> method and the model will be compressed
on the fly while loading.`,is,D,ps,L,Je="Now that you have the model loaded in one of the suggested ways, let’s move on to exploring tasks that you can use IDEFICS for.",os,P,cs,O,we=`Image captioning is the task of predicting a caption for a given image. A common application is to aid visually impaired
people navigate through different situations, for instance, explore image content online.`,rs,K,Te="To illustrate the task, get an image to be captioned, e.g.:",ms,U,Ue='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/idefics-im-captioning.jpg" alt="Image of a puppy in a flower bed"/>',ds,tt,be='Photo by <a href="https://unsplash.com/@hendoo" rel="nofollow">Hendo Wang</a>.',Ms,st,Ze=`IDEFICS accepts text and image prompts. However, to caption an image, you do not have to provide a text prompt to the
model, only the preprocessed input image. Without a text prompt, the model will start generating text from the
BOS (beginning-of-sequence) token thus creating a caption.`,hs,et,Ie="As image input to the model, you can use either an image object (<code>PIL.Image</code>) or a url from which the image can be retrieved.",gs,at,us,b,ys,lt,fs,nt,ke=`You can extend image captioning by providing a text prompt, which the model will continue given the image. Let’s take
another image to illustrate:`,js,Z,Ce='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/idefics-prompted-im-captioning.jpg" alt="Image of the Eiffel Tower at night"/>',Js,it,Re='Photo by <a href="https://unsplash.com/@dnevozhai" rel="nofollow">Denys Nevozhai</a>.',ws,pt,ve="Textual and image prompts can be passed to the model’s processor as a single list to create appropriate inputs.",Ts,ot,Us,ct,bs,rt,xe=`While IDEFICS demonstrates great zero-shot results, your task may require a certain format of the caption, or come with
other restrictions or requirements that increase task’s complexity. Few-shot prompting can be used to enable in-context learning.
By providing examples in the prompt, you can steer the model to generate results that mimic the format of given examples.`,Zs,mt,We=`Let’s use the previous image of the Eiffel Tower as an example for the model and build a prompt that demonstrates to the model
that in addition to learning what the object in an image is, we would also like to get some interesting information about it.
Then, let’s see, if we can get the same response format for an image of the Statue of Liberty:`,Is,I,Ne='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/idefics-few-shot.jpg" alt="Image of the Statue of Liberty"/>',ks,dt,_e='Photo by <a href="https://unsplash.com/@jmayobres" rel="nofollow">Juan Mayobre</a>.',Cs,Mt,Rs,ht,Ge=`Notice that just from a single example (i.e., 1-shot) the model has learned how to perform the task. For more complex tasks,
feel free to experiment with a larger number of examples (e.g., 3-shot, 5-shot, etc.).`,vs,gt,xs,ut,ze=`Visual Question Answering (VQA) is the task of answering open-ended questions based on an image. Similar to image
captioning it can be used in accessibility applications, but also in education (reasoning about visual materials), customer
service (questions about products based on images), and image retrieval.`,Ws,yt,Qe="Let’s get a new image for this task:",Ns,k,Be='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/idefics-vqa.jpg" alt="Image of a couple having a picnic"/>',_s,ft,Ve='Photo by <a href="https://unsplash.com/@jarritos" rel="nofollow">Jarritos Mexican Soda</a>.',Gs,jt,He="You can steer the model from image captioning to visual question answering by prompting it with appropriate instructions:",zs,Jt,Qs,wt,Bs,Tt,Xe=`IDEFICS is capable of classifying images into different categories without being explicitly trained on data containing
labeled examples from those specific categories. Given a list of categories and using its image and text understanding
capabilities, the model can infer which category the image likely belongs to.`,Vs,Ut,Fe="Say, we have this image of a vegetable stand:",Hs,C,Ee='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/idefics-classification.jpg" alt="Image of a vegetable stand"/>',Xs,bt,$e='Photo by <a href="https://unsplash.com/@peterwendt" rel="nofollow">Peter Wendt</a>.',Fs,Zt,Ye="We can instruct the model to classify the image into one of the categories that we have:",Es,It,$s,kt,Ae="In the example above we instruct the model to classify the image into a single category, however, you can also prompt the model to do rank classification.",Ys,Ct,As,Rt,qe=`For more creative applications, you can use image-guided text generation to generate text based on an image. This can be
useful to create descriptions of products, ads, descriptions of a scene, etc.`,qs,vt,Se="Let’s prompt IDEFICS to write a story based on a simple image of a red door:",Ss,R,De='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/idefics-story-generation.jpg" alt="Image of a red door with a pumpkin on the steps"/>',Ds,xt,Le='Photo by <a href="https://unsplash.com/@devonshiremedia" rel="nofollow">Craig Tidball</a>.',Ls,Wt,Ps,Nt,Pe="Looks like IDEFICS noticed the pumpkin on the doorstep and went with a spooky Halloween story about a ghost.",Os,v,Ks,_t,te,Gt,Oe=`All of the earlier sections illustrated IDEFICS for a single example. In a very similar fashion, you can run inference
for a batch of examples by passing a list of prompts:`,se,zt,ee,Qt,ae,Bt,Ke=`For conversational use cases, you can find fine-tuned instructed versions of the model on the 🤗 Hub:
<code>HuggingFaceM4/idefics-80b-instruct</code> and <code>HuggingFaceM4/idefics-9b-instruct</code>.`,le,Vt,ta=`These checkpoints are the result of fine-tuning the respective base models on a mixture of supervised and instruction
fine-tuning datasets, which boosts the downstream performance while making the models more usable in conversational settings.`,ne,Ht,sa="The use and prompting for the conversational use is very similar to using the base models:",ie,Xt,pe,Ft,oe;return W=new j({props:{title:"Image tasks with IDEFICS",local:"image-tasks-with-idefics",headingTag:"h1"}}),N=new ga({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/idefics.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/idefics.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/idefics.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/idefics.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/idefics.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/idefics.ipynb"}]}}),H=new f({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwYml0c2FuZGJ5dGVzJTIwc2VudGVuY2VwaWVjZSUyMGFjY2VsZXJhdGUlMjB0cmFuc2Zvcm1lcnM=",highlighted:"pip install -q bitsandbytes sentencepiece accelerate transformers",wrap:!1}}),T=new ce({props:{$$slots:{default:[ua]},$$scope:{ctx:J}}}),X=new j({props:{title:"Loading the model",local:"loading-the-model",headingTag:"h2"}}),E=new f({props:{code:"Y2hlY2twb2ludCUyMCUzRCUyMCUyMkh1Z2dpbmdGYWNlTTQlMkZpZGVmaWNzLTliJTIy",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;HuggingFaceM4/idefics-9b&quot;</span>',wrap:!1}}),Y=new f({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwSWRlZmljc0ZvclZpc2lvblRleHQyVGV4dCUyQyUyMEF1dG9Qcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQSUwQW1vZGVsJTIwJTNEJTIwSWRlZmljc0ZvclZpc2lvblRleHQyVGV4dC5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> IdeficsForVisionText2Text, AutoProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(checkpoint)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = IdeficsForVisionText2Text.from_pretrained(checkpoint, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;auto&quot;</span>)`,wrap:!1}}),q=new j({props:{title:"Quantized model",local:"quantized-model",headingTag:"h3"}}),D=new f({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwSWRlZmljc0ZvclZpc2lvblRleHQyVGV4dCUyQyUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBCaXRzQW5kQnl0ZXNDb25maWclMEElMEFxdWFudGl6YXRpb25fY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF9jb21wdXRlX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSklMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQSUwQW1vZGVsJTIwJTNEJTIwSWRlZmljc0ZvclZpc2lvblRleHQyVGV4dC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwY2hlY2twb2ludCUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudGl6YXRpb25fY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> IdeficsForVisionText2Text, AutoProcessor, BitsAndBytesConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>quantization_config = BitsAndBytesConfig(
<span class="hljs-meta">... </span>    load_in_4bit=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    bnb_4bit_compute_dtype=torch.float16,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(checkpoint)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = IdeficsForVisionText2Text.from_pretrained(
<span class="hljs-meta">... </span>    checkpoint,
<span class="hljs-meta">... </span>    quantization_config=quantization_config,
<span class="hljs-meta">... </span>    device_map=<span class="hljs-string">&quot;auto&quot;</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),P=new j({props:{title:"Image captioning",local:"image-captioning",headingTag:"h2"}}),at=new f({props:{code:"cHJvbXB0JTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZpbWFnZXMudW5zcGxhc2guY29tJTJGcGhvdG8tMTU4MzE2MDI0NzcxMS0yMTkxNzc2YjRiOTElM0ZpeGxpYiUzRHJiLTQuMC4zJTI2aXhpZCUzRE0zd3hNakEzZkRCOE1IeHdhRzkwYnkxd1lXZGxmSHg4ZkdWdWZEQjhmSHg4ZkElMjUzRCUyNTNEJTI2YXV0byUzRGZvcm1hdCUyNmZpdCUzRGNyb3AlMjZ3JTNEMzU0MiUyNnElM0Q4MCUyMiUyQyUwQSU1RCUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byglMjJjdWRhJTIyKSUwQWJhZF93b3Jkc19pZHMlMjAlM0QlMjBwcm9jZXNzb3IudG9rZW5pemVyKCU1QiUyMiUzQ2ltYWdlJTNFJTIyJTJDJTIwJTIyJTNDZmFrZV90b2tlbl9hcm91bmRfaW1hZ2UlM0UlMjIlNUQlMkMlMjBhZGRfc3BlY2lhbF90b2tlbnMlM0RGYWxzZSkuaW5wdXRfaWRzJTBBJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMCUyQyUyMGJhZF93b3Jkc19pZHMlM0RiYWRfd29yZHNfaWRzKSUwQWdlbmVyYXRlZF90ZXh0JTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTBBcHJpbnQoZ2VuZXJhdGVkX3RleHQlNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://images.unsplash.com/photo-1583160247711-2191776b4b91?ixlib=rb-4.0.3&amp;ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&amp;auto=format&amp;fit=crop&amp;w=3542&amp;q=80&quot;</span>,
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>bad_words_ids = processor.tokenizer([<span class="hljs-string">&quot;&lt;image&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;fake_token_around_image&gt;&quot;</span>], add_special_tokens=<span class="hljs-literal">False</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>, bad_words_ids=bad_words_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(generated_text[<span class="hljs-number">0</span>])
A puppy <span class="hljs-keyword">in</span> a flower bed`,wrap:!1}}),b=new ce({props:{$$slots:{default:[ya]},$$scope:{ctx:J}}}),lt=new j({props:{title:"Prompted image captioning",local:"prompted-image-captioning",headingTag:"h2"}}),ot=new f({props:{code:"cHJvbXB0JTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZpbWFnZXMudW5zcGxhc2guY29tJTJGcGhvdG8tMTU0MzM0OTY4OS05YTRkNDI2YmVlOGUlM0ZpeGxpYiUzRHJiLTQuMC4zJTI2aXhpZCUzRE0zd3hNakEzZkRCOE1IeHdhRzkwYnkxd1lXZGxmSHg4ZkdWdWZEQjhmSHg4ZkElMjUzRCUyNTNEJTI2YXV0byUzRGZvcm1hdCUyNmZpdCUzRGNyb3AlMjZ3JTNEMzUwMSUyNnElM0Q4MCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMlRoaXMlMjBpcyUyMGFuJTIwaW1hZ2UlMjBvZiUyMCUyMiUyQyUwQSU1RCUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byglMjJjdWRhJTIyKSUwQWJhZF93b3Jkc19pZHMlMjAlM0QlMjBwcm9jZXNzb3IudG9rZW5pemVyKCU1QiUyMiUzQ2ltYWdlJTNFJTIyJTJDJTIwJTIyJTNDZmFrZV90b2tlbl9hcm91bmRfaW1hZ2UlM0UlMjIlNUQlMkMlMjBhZGRfc3BlY2lhbF90b2tlbnMlM0RGYWxzZSkuaW5wdXRfaWRzJTBBJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMCUyQyUyMGJhZF93b3Jkc19pZHMlM0RiYWRfd29yZHNfaWRzKSUwQWdlbmVyYXRlZF90ZXh0JTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTBBcHJpbnQoZ2VuZXJhdGVkX3RleHQlNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://images.unsplash.com/photo-1543349689-9a4d426bee8e?ixlib=rb-4.0.3&amp;ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&amp;auto=format&amp;fit=crop&amp;w=3501&amp;q=80&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;This is an image of &quot;</span>,
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>bad_words_ids = processor.tokenizer([<span class="hljs-string">&quot;&lt;image&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;fake_token_around_image&gt;&quot;</span>], add_special_tokens=<span class="hljs-literal">False</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>, bad_words_ids=bad_words_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(generated_text[<span class="hljs-number">0</span>])
This <span class="hljs-keyword">is</span> an image of the Eiffel Tower <span class="hljs-keyword">in</span> Paris, France.`,wrap:!1}}),ct=new j({props:{title:"Few-shot prompting",local:"few-shot-prompting",headingTag:"h2"}}),Mt=new f({props:{code:"cHJvbXB0JTIwJTNEJTIwJTVCJTIyVXNlciUzQSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaW1hZ2VzLnVuc3BsYXNoLmNvbSUyRnBob3RvLTE1NDMzNDk2ODktOWE0ZDQyNmJlZThlJTNGaXhsaWIlM0RyYi00LjAuMyUyNml4aWQlM0RNM3d4TWpBM2ZEQjhNSHh3YUc5MGJ5MXdZV2RsZkh4OGZHVnVmREI4Zkh4OGZBJTI1M0QlMjUzRCUyNmF1dG8lM0Rmb3JtYXQlMjZmaXQlM0Rjcm9wJTI2dyUzRDM1MDElMjZxJTNEODAlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJEZXNjcmliZSUyMHRoaXMlMjBpbWFnZS4lNUNuQXNzaXN0YW50JTNBJTIwQW4lMjBpbWFnZSUyMG9mJTIwdGhlJTIwRWlmZmVsJTIwVG93ZXIlMjBhdCUyMG5pZ2h0LiUyMEZ1biUyMGZhY3QlM0ElMjB0aGUlMjBFaWZmZWwlMjBUb3dlciUyMGlzJTIwdGhlJTIwc2FtZSUyMGhlaWdodCUyMGFzJTIwYW4lMjA4MS1zdG9yZXklMjBidWlsZGluZy4lNUNuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyVXNlciUzQSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaW1hZ2VzLnVuc3BsYXNoLmNvbSUyRnBob3RvLTE1MjQwOTkxNjMyNTMtMzJiN2YwMjU2ODY4JTNGaXhsaWIlM0RyYi00LjAuMyUyNml4aWQlM0RNM3d4TWpBM2ZEQjhNSHh3YUc5MGJ5MXdZV2RsZkh4OGZHVnVmREI4Zkh4OGZBJTI1M0QlMjUzRCUyNmF1dG8lM0Rmb3JtYXQlMjZmaXQlM0Rjcm9wJTI2dyUzRDMzODclMjZxJTNEODAlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJEZXNjcmliZSUyMHRoaXMlMjBpbWFnZS4lNUNuQXNzaXN0YW50JTNBJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKCUyMmN1ZGElMjIpJTBBYmFkX3dvcmRzX2lkcyUyMCUzRCUyMHByb2Nlc3Nvci50b2tlbml6ZXIoJTVCJTIyJTNDaW1hZ2UlM0UlMjIlMkMlMjAlMjIlM0NmYWtlX3Rva2VuX2Fyb3VuZF9pbWFnZSUzRSUyMiU1RCUyQyUyMGFkZF9zcGVjaWFsX3Rva2VucyUzREZhbHNlKS5pbnB1dF9pZHMlMEElMEFnZW5lcmF0ZWRfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDMwJTJDJTIwYmFkX3dvcmRzX2lkcyUzRGJhZF93b3Jkc19pZHMpJTBBZ2VuZXJhdGVkX3RleHQlMjAlM0QlMjBwcm9jZXNzb3IuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlZF9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklMEFwcmludChnZW5lcmF0ZWRfdGV4dCU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = [<span class="hljs-string">&quot;User:&quot;</span>,
<span class="hljs-meta">... </span>           <span class="hljs-string">&quot;https://images.unsplash.com/photo-1543349689-9a4d426bee8e?ixlib=rb-4.0.3&amp;ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&amp;auto=format&amp;fit=crop&amp;w=3501&amp;q=80&quot;</span>,
<span class="hljs-meta">... </span>           <span class="hljs-string">&quot;Describe this image.\\nAssistant: An image of the Eiffel Tower at night. Fun fact: the Eiffel Tower is the same height as an 81-storey building.\\n&quot;</span>,
<span class="hljs-meta">... </span>           <span class="hljs-string">&quot;User:&quot;</span>,
<span class="hljs-meta">... </span>           <span class="hljs-string">&quot;https://images.unsplash.com/photo-1524099163253-32b7f0256868?ixlib=rb-4.0.3&amp;ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&amp;auto=format&amp;fit=crop&amp;w=3387&amp;q=80&quot;</span>,
<span class="hljs-meta">... </span>           <span class="hljs-string">&quot;Describe this image.\\nAssistant:&quot;</span>
<span class="hljs-meta">... </span>           ]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>bad_words_ids = processor.tokenizer([<span class="hljs-string">&quot;&lt;image&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;fake_token_around_image&gt;&quot;</span>], add_special_tokens=<span class="hljs-literal">False</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">30</span>, bad_words_ids=bad_words_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(generated_text[<span class="hljs-number">0</span>])
User: Describe this image.
Assistant: An image of the Eiffel Tower at night. Fun fact: the Eiffel Tower <span class="hljs-keyword">is</span> the same height <span class="hljs-keyword">as</span> an <span class="hljs-number">81</span>-storey building. 
User: Describe this image.
Assistant: An image of the Statue of Liberty. Fun fact: the Statue of Liberty <span class="hljs-keyword">is</span> <span class="hljs-number">151</span> feet tall.`,wrap:!1}}),gt=new j({props:{title:"Visual question answering",local:"visual-question-answering",headingTag:"h2"}}),Jt=new f({props:{code:"cHJvbXB0JTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIySW5zdHJ1Y3Rpb24lM0ElMjBQcm92aWRlJTIwYW4lMjBhbnN3ZXIlMjB0byUyMHRoZSUyMHF1ZXN0aW9uLiUyMFVzZSUyMHRoZSUyMGltYWdlJTIwdG8lMjBhbnN3ZXIuJTVDbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaW1hZ2VzLnVuc3BsYXNoLmNvbSUyRnBob3RvLTE2MjM5NDQ4ODkyODgtY2QxNDdkYmI1MTdjJTNGaXhsaWIlM0RyYi00LjAuMyUyNml4aWQlM0RNM3d4TWpBM2ZEQjhNSHh3YUc5MGJ5MXdZV2RsZkh4OGZHVnVmREI4Zkh4OGZBJTI1M0QlMjUzRCUyNmF1dG8lM0Rmb3JtYXQlMjZmaXQlM0Rjcm9wJTI2dyUzRDM1NDAlMjZxJTNEODAlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJRdWVzdGlvbiUzQSUyMFdoZXJlJTIwYXJlJTIwdGhlc2UlMjBwZW9wbGUlMjBhbmQlMjB3aGF0J3MlMjB0aGUlMjB3ZWF0aGVyJTIwbGlrZSUzRiUyMEFuc3dlciUzQSUyMiUwQSU1RCUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byglMjJjdWRhJTIyKSUwQWJhZF93b3Jkc19pZHMlMjAlM0QlMjBwcm9jZXNzb3IudG9rZW5pemVyKCU1QiUyMiUzQ2ltYWdlJTNFJTIyJTJDJTIwJTIyJTNDZmFrZV90b2tlbl9hcm91bmRfaW1hZ2UlM0UlMjIlNUQlMkMlMjBhZGRfc3BlY2lhbF90b2tlbnMlM0RGYWxzZSkuaW5wdXRfaWRzJTBBJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QyMCUyQyUyMGJhZF93b3Jkc19pZHMlM0RiYWRfd29yZHNfaWRzKSUwQWdlbmVyYXRlZF90ZXh0JTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTBBcHJpbnQoZ2VuZXJhdGVkX3RleHQlNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Instruction: Provide an answer to the question. Use the image to answer.\\n&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://images.unsplash.com/photo-1623944889288-cd147dbb517c?ixlib=rb-4.0.3&amp;ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&amp;auto=format&amp;fit=crop&amp;w=3540&amp;q=80&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Question: Where are these people and what&#x27;s the weather like? Answer:&quot;</span>
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>bad_words_ids = processor.tokenizer([<span class="hljs-string">&quot;&lt;image&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;fake_token_around_image&gt;&quot;</span>], add_special_tokens=<span class="hljs-literal">False</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">20</span>, bad_words_ids=bad_words_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(generated_text[<span class="hljs-number">0</span>])
Instruction: Provide an answer to the question. Use the image to answer.
 Question: Where are these people <span class="hljs-keyword">and</span> what<span class="hljs-string">&#x27;s the weather like? Answer: They&#x27;</span>re <span class="hljs-keyword">in</span> a park <span class="hljs-keyword">in</span> New York City, <span class="hljs-keyword">and</span> it<span class="hljs-string">&#x27;s a beautiful day.</span>`,wrap:!1}}),wt=new j({props:{title:"Image classification",local:"image-classification",headingTag:"h2"}}),It=new f({props:{code:"Y2F0ZWdvcmllcyUyMCUzRCUyMCU1QidhbmltYWxzJyUyQyd2ZWdldGFibGVzJyUyQyUyMCdjaXR5JTIwbGFuZHNjYXBlJyUyQyUyMCdjYXJzJyUyQyUyMCdvZmZpY2UnJTVEJTBBcHJvbXB0JTIwJTNEJTIwJTVCZiUyMkluc3RydWN0aW9uJTNBJTIwQ2xhc3NpZnklMjB0aGUlMjBmb2xsb3dpbmclMjBpbWFnZSUyMGludG8lMjBhJTIwc2luZ2xlJTIwY2F0ZWdvcnklMjBmcm9tJTIwdGhlJTIwZm9sbG93aW5nJTIwbGlzdCUzQSUyMCU3QmNhdGVnb3JpZXMlN0QuJTVDbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaW1hZ2VzLnVuc3BsYXNoLmNvbSUyRnBob3RvLTE0NzExOTM5NDU1MDktOWFkMDYxN2FmYWJmJTNGaXhsaWIlM0RyYi00LjAuMyUyNml4aWQlM0RNM3d4TWpBM2ZEQjhNSHh3YUc5MGJ5MXdZV2RsZkh4OGZHVnVmREI4Zkh4OGZBJTI1M0QlMjUzRCUyNmF1dG8lM0Rmb3JtYXQlMjZmaXQlM0Rjcm9wJTI2dyUzRDM1NDAlMjZxJTNEODAlMjIlMkMlMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjJDYXRlZ29yeSUzQSUyMCUyMiUwQSU1RCUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byglMjJjdWRhJTIyKSUwQWJhZF93b3Jkc19pZHMlMjAlM0QlMjBwcm9jZXNzb3IudG9rZW5pemVyKCU1QiUyMiUzQ2ltYWdlJTNFJTIyJTJDJTIwJTIyJTNDZmFrZV90b2tlbl9hcm91bmRfaW1hZ2UlM0UlMjIlNUQlMkMlMjBhZGRfc3BlY2lhbF90b2tlbnMlM0RGYWxzZSkuaW5wdXRfaWRzJTBBJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0Q2JTJDJTIwYmFkX3dvcmRzX2lkcyUzRGJhZF93b3Jkc19pZHMpJTBBZ2VuZXJhdGVkX3RleHQlMjAlM0QlMjBwcm9jZXNzb3IuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlZF9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklMEFwcmludChnZW5lcmF0ZWRfdGV4dCU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>categories = [<span class="hljs-string">&#x27;animals&#x27;</span>,<span class="hljs-string">&#x27;vegetables&#x27;</span>, <span class="hljs-string">&#x27;city landscape&#x27;</span>, <span class="hljs-string">&#x27;cars&#x27;</span>, <span class="hljs-string">&#x27;office&#x27;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = [<span class="hljs-string">f&quot;Instruction: Classify the following image into a single category from the following list: <span class="hljs-subst">{categories}</span>.\\n&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://images.unsplash.com/photo-1471193945509-9ad0617afabf?ixlib=rb-4.0.3&amp;ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&amp;auto=format&amp;fit=crop&amp;w=3540&amp;q=80&quot;</span>,    
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Category: &quot;</span>
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>bad_words_ids = processor.tokenizer([<span class="hljs-string">&quot;&lt;image&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;fake_token_around_image&gt;&quot;</span>], add_special_tokens=<span class="hljs-literal">False</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">6</span>, bad_words_ids=bad_words_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(generated_text[<span class="hljs-number">0</span>])
Instruction: Classify the following image into a single category <span class="hljs-keyword">from</span> the following <span class="hljs-built_in">list</span>: [<span class="hljs-string">&#x27;animals&#x27;</span>, <span class="hljs-string">&#x27;vegetables&#x27;</span>, <span class="hljs-string">&#x27;city landscape&#x27;</span>, <span class="hljs-string">&#x27;cars&#x27;</span>, <span class="hljs-string">&#x27;office&#x27;</span>].
Category: Vegetables`,wrap:!1}}),Ct=new j({props:{title:"Image-guided text generation",local:"image-guided-text-generation",headingTag:"h2"}}),Wt=new f({props:{code:"cHJvbXB0JTIwJTNEJTIwJTVCJTIySW5zdHJ1Y3Rpb24lM0ElMjBVc2UlMjB0aGUlMjBpbWFnZSUyMHRvJTIwd3JpdGUlMjBhJTIwc3RvcnkuJTIwJTVDbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaW1hZ2VzLnVuc3BsYXNoLmNvbSUyRnBob3RvLTE1MTcwODY4MjIxNTctMmIwMzU4ZTc2ODRhJTNGaXhsaWIlM0RyYi00LjAuMyUyNml4aWQlM0RNM3d4TWpBM2ZEQjhNSHh3YUc5MGJ5MXdZV2RsZkh4OGZHVnVmREI4Zkh4OGZBJTI1M0QlMjUzRCUyNmF1dG8lM0Rmb3JtYXQlMjZmaXQlM0Rjcm9wJTI2dyUzRDIyMDMlMjZxJTNEODAlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJTdG9yeSUzQSUyMCU1Q24lMjIlNUQlMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IocHJvbXB0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oJTIyY3VkYSUyMiklMEFiYWRfd29yZHNfaWRzJTIwJTNEJTIwcHJvY2Vzc29yLnRva2VuaXplciglNUIlMjIlM0NpbWFnZSUzRSUyMiUyQyUyMCUyMiUzQ2Zha2VfdG9rZW5fYXJvdW5kX2ltYWdlJTNFJTIyJTVEJTJDJTIwYWRkX3NwZWNpYWxfdG9rZW5zJTNERmFsc2UpLmlucHV0X2lkcyUwQSUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG51bV9iZWFtcyUzRDIlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDIwMCUyQyUyMGJhZF93b3Jkc19pZHMlM0RiYWRfd29yZHNfaWRzKSUwQWdlbmVyYXRlZF90ZXh0JTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTBBcHJpbnQoZ2VuZXJhdGVkX3RleHQlNUIwJTVEKSUyMCUwQSUwQSUwQSUwQSUwQSUwQSUwQSUwQQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = [<span class="hljs-string">&quot;Instruction: Use the image to write a story. \\n&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://images.unsplash.com/photo-1517086822157-2b0358e7684a?ixlib=rb-4.0.3&amp;ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&amp;auto=format&amp;fit=crop&amp;w=2203&amp;q=80&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Story: \\n&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>bad_words_ids = processor.tokenizer([<span class="hljs-string">&quot;&lt;image&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;fake_token_around_image&gt;&quot;</span>], add_special_tokens=<span class="hljs-literal">False</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**inputs, num_beams=<span class="hljs-number">2</span>, max_new_tokens=<span class="hljs-number">200</span>, bad_words_ids=bad_words_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(generated_text[<span class="hljs-number">0</span>]) 
Instruction: Use the image to write a story. 
 Story: 
Once upon a time, there was a little girl who lived <span class="hljs-keyword">in</span> a house <span class="hljs-keyword">with</span> a red door.  She loved her red door.  It was the prettiest door <span class="hljs-keyword">in</span> the whole world.

One day, the little girl was playing <span class="hljs-keyword">in</span> her yard when she noticed a man standing on her doorstep.  He was wearing a long black coat <span class="hljs-keyword">and</span> a top hat.

The little girl ran inside <span class="hljs-keyword">and</span> told her mother about the man.

Her mother said, “Don’t worry, honey.  He’s just a friendly ghost.”

The little girl wasn’t sure <span class="hljs-keyword">if</span> she believed her mother, but she went outside anyway.

When she got to the door, the man was gone.

The <span class="hljs-built_in">next</span> day, the little girl was playing <span class="hljs-keyword">in</span> her yard again when she noticed the man standing on her doorstep.

He was wearing a long black coat <span class="hljs-keyword">and</span> a top hat.

The little girl ran`,wrap:!1}}),v=new ce({props:{$$slots:{default:[fa]},$$scope:{ctx:J}}}),_t=new j({props:{title:"Running inference in batch mode",local:"running-inference-in-batch-mode",headingTag:"h2"}}),zt=new f({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>prompts = [
<span class="hljs-meta">... </span>    [   <span class="hljs-string">&quot;https://images.unsplash.com/photo-1543349689-9a4d426bee8e?ixlib=rb-4.0.3&amp;ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&amp;auto=format&amp;fit=crop&amp;w=3501&amp;q=80&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;This is an image of &quot;</span>,
<span class="hljs-meta">... </span>    ],
<span class="hljs-meta">... </span>    [   <span class="hljs-string">&quot;https://images.unsplash.com/photo-1623944889288-cd147dbb517c?ixlib=rb-4.0.3&amp;ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&amp;auto=format&amp;fit=crop&amp;w=3540&amp;q=80&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;This is an image of &quot;</span>,
<span class="hljs-meta">... </span>    ],
<span class="hljs-meta">... </span>    [   <span class="hljs-string">&quot;https://images.unsplash.com/photo-1471193945509-9ad0617afabf?ixlib=rb-4.0.3&amp;ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&amp;auto=format&amp;fit=crop&amp;w=3540&amp;q=80&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;This is an image of &quot;</span>,
<span class="hljs-meta">... </span>    ],
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(prompts, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>bad_words_ids = processor.tokenizer([<span class="hljs-string">&quot;&lt;image&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;fake_token_around_image&gt;&quot;</span>], add_special_tokens=<span class="hljs-literal">False</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>, bad_words_ids=bad_words_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i,t <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(generated_text):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{i}</span>:\\n<span class="hljs-subst">{t}</span>\\n&quot;</span>) 
<span class="hljs-number">0</span>:
This <span class="hljs-keyword">is</span> an image of the Eiffel Tower <span class="hljs-keyword">in</span> Paris, France.

<span class="hljs-number">1</span>:
This <span class="hljs-keyword">is</span> an image of a couple on a picnic blanket.

<span class="hljs-number">2</span>:
This <span class="hljs-keyword">is</span> an image of a vegetable stand.`,wrap:!1}}),Qt=new j({props:{title:"IDEFICS instruct for conversational use",local:"idefics-instruct-for-conversational-use",headingTag:"h2"}}),Xt=new f({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> IdeficsForVisionText2Text, AutoProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;HuggingFaceM4/idefics-9b-instruct&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = IdeficsForVisionText2Text.from_pretrained(checkpoint, torch_dtype=torch.bfloat16).to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(checkpoint)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompts = [
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;User: What is in this image?&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/8/86/Id%C3%A9fix.JPG&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;&lt;end_of_utterance&gt;&quot;</span>,

<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;\\nAssistant: This picture depicts Idefix, the dog of Obelix in Asterix and Obelix. Idefix is running on the ground.&lt;end_of_utterance&gt;&quot;</span>,

<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;\\nUser:&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;https://static.wikia.nocookie.net/asterix/images/2/25/R22b.gif/revision/latest?cb=20110815073052&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;And who is that?&lt;end_of_utterance&gt;&quot;</span>,

<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;\\nAssistant:&quot;</span>,
<span class="hljs-meta">... </span>    ],
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># --batched mode</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(prompts, add_end_of_utterance_token=<span class="hljs-literal">False</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># --single sample mode</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># inputs = processor(prompts[0], return_tensors=&quot;pt&quot;).to(device)</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generation args</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>exit_condition = processor.tokenizer(<span class="hljs-string">&quot;&lt;end_of_utterance&gt;&quot;</span>, add_special_tokens=<span class="hljs-literal">False</span>).input_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>bad_words_ids = processor.tokenizer([<span class="hljs-string">&quot;&lt;image&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;fake_token_around_image&gt;&quot;</span>], add_special_tokens=<span class="hljs-literal">False</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**inputs, eos_token_id=exit_condition, bad_words_ids=bad_words_ids, max_length=<span class="hljs-number">100</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i, t <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(generated_text):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{i}</span>:\\n<span class="hljs-subst">{t}</span>\\n&quot;</span>)`,wrap:!1}}),{c(){c=i("meta"),y=l(),u=i("p"),w=l(),r(W.$$.fragment),Et=l(),r(N.$$.fragment),$t=l(),_=i("p"),_.textContent=re,Yt=l(),G=i("p"),G.innerHTML=me,At=l(),z=i("p"),z.textContent=de,qt=l(),Q=i("p"),Q.textContent=Me,St=l(),B=i("ul"),B.innerHTML=he,Dt=l(),V=i("p"),V.textContent=ge,Lt=l(),r(H.$$.fragment),Pt=l(),r(T.$$.fragment),Ot=l(),r(X.$$.fragment),Kt=l(),F=i("p"),F.textContent=ue,ts=l(),r(E.$$.fragment),ss=l(),$=i("p"),$.innerHTML=ye,es=l(),r(Y.$$.fragment),as=l(),A=i("p"),A.innerHTML=fe,ls=l(),r(q.$$.fragment),ns=l(),S=i("p"),S.innerHTML=je,is=l(),r(D.$$.fragment),ps=l(),L=i("p"),L.textContent=Je,os=l(),r(P.$$.fragment),cs=l(),O=i("p"),O.textContent=we,rs=l(),K=i("p"),K.textContent=Te,ms=l(),U=i("div"),U.innerHTML=Ue,ds=l(),tt=i("p"),tt.innerHTML=be,Ms=l(),st=i("p"),st.textContent=Ze,hs=l(),et=i("p"),et.innerHTML=Ie,gs=l(),r(at.$$.fragment),us=l(),r(b.$$.fragment),ys=l(),r(lt.$$.fragment),fs=l(),nt=i("p"),nt.textContent=ke,js=l(),Z=i("div"),Z.innerHTML=Ce,Js=l(),it=i("p"),it.innerHTML=Re,ws=l(),pt=i("p"),pt.textContent=ve,Ts=l(),r(ot.$$.fragment),Us=l(),r(ct.$$.fragment),bs=l(),rt=i("p"),rt.textContent=xe,Zs=l(),mt=i("p"),mt.textContent=We,Is=l(),I=i("div"),I.innerHTML=Ne,ks=l(),dt=i("p"),dt.innerHTML=_e,Cs=l(),r(Mt.$$.fragment),Rs=l(),ht=i("p"),ht.textContent=Ge,vs=l(),r(gt.$$.fragment),xs=l(),ut=i("p"),ut.textContent=ze,Ws=l(),yt=i("p"),yt.textContent=Qe,Ns=l(),k=i("div"),k.innerHTML=Be,_s=l(),ft=i("p"),ft.innerHTML=Ve,Gs=l(),jt=i("p"),jt.textContent=He,zs=l(),r(Jt.$$.fragment),Qs=l(),r(wt.$$.fragment),Bs=l(),Tt=i("p"),Tt.textContent=Xe,Vs=l(),Ut=i("p"),Ut.textContent=Fe,Hs=l(),C=i("div"),C.innerHTML=Ee,Xs=l(),bt=i("p"),bt.innerHTML=$e,Fs=l(),Zt=i("p"),Zt.textContent=Ye,Es=l(),r(It.$$.fragment),$s=l(),kt=i("p"),kt.textContent=Ae,Ys=l(),r(Ct.$$.fragment),As=l(),Rt=i("p"),Rt.textContent=qe,qs=l(),vt=i("p"),vt.textContent=Se,Ss=l(),R=i("div"),R.innerHTML=De,Ds=l(),xt=i("p"),xt.innerHTML=Le,Ls=l(),r(Wt.$$.fragment),Ps=l(),Nt=i("p"),Nt.textContent=Pe,Os=l(),r(v.$$.fragment),Ks=l(),r(_t.$$.fragment),te=l(),Gt=i("p"),Gt.textContent=Oe,se=l(),r(zt.$$.fragment),ee=l(),r(Qt.$$.fragment),ae=l(),Bt=i("p"),Bt.innerHTML=Ke,le=l(),Vt=i("p"),Vt.textContent=ta,ne=l(),Ht=i("p"),Ht.textContent=sa,ie=l(),r(Xt.$$.fragment),pe=l(),Ft=i("p"),this.h()},l(t){const s=ma("svelte-u9bgzb",document.head);c=p(s,"META",{name:!0,content:!0}),s.forEach(e),y=n(t),u=p(t,"P",{}),na(u).forEach(e),w=n(t),m(W.$$.fragment,t),Et=n(t),m(N.$$.fragment,t),$t=n(t),_=p(t,"P",{"data-svelte-h":!0}),o(_)!=="svelte-11wnsr"&&(_.textContent=re),Yt=n(t),G=p(t,"P",{"data-svelte-h":!0}),o(G)!=="svelte-1nt7nk6"&&(G.innerHTML=me),At=n(t),z=p(t,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1k5g1sg"&&(z.textContent=de),qt=n(t),Q=p(t,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-fp1hdi"&&(Q.textContent=Me),St=n(t),B=p(t,"UL",{"data-svelte-h":!0}),o(B)!=="svelte-187zpo0"&&(B.innerHTML=he),Dt=n(t),V=p(t,"P",{"data-svelte-h":!0}),o(V)!=="svelte-qn4ey1"&&(V.textContent=ge),Lt=n(t),m(H.$$.fragment,t),Pt=n(t),m(T.$$.fragment,t),Ot=n(t),m(X.$$.fragment,t),Kt=n(t),F=p(t,"P",{"data-svelte-h":!0}),o(F)!=="svelte-pbsmkm"&&(F.textContent=ue),ts=n(t),m(E.$$.fragment,t),ss=n(t),$=p(t,"P",{"data-svelte-h":!0}),o($)!=="svelte-1lri5lq"&&($.innerHTML=ye),es=n(t),m(Y.$$.fragment,t),as=n(t),A=p(t,"P",{"data-svelte-h":!0}),o(A)!=="svelte-10jwul3"&&(A.innerHTML=fe),ls=n(t),m(q.$$.fragment,t),ns=n(t),S=p(t,"P",{"data-svelte-h":!0}),o(S)!=="svelte-gb566o"&&(S.innerHTML=je),is=n(t),m(D.$$.fragment,t),ps=n(t),L=p(t,"P",{"data-svelte-h":!0}),o(L)!=="svelte-vovwl0"&&(L.textContent=Je),os=n(t),m(P.$$.fragment,t),cs=n(t),O=p(t,"P",{"data-svelte-h":!0}),o(O)!=="svelte-195xyco"&&(O.textContent=we),rs=n(t),K=p(t,"P",{"data-svelte-h":!0}),o(K)!=="svelte-syqfn9"&&(K.textContent=Te),ms=n(t),U=p(t,"DIV",{class:!0,"data-svelte-h":!0}),o(U)!=="svelte-t8y7db"&&(U.innerHTML=Ue),ds=n(t),tt=p(t,"P",{"data-svelte-h":!0}),o(tt)!=="svelte-knozkn"&&(tt.innerHTML=be),Ms=n(t),st=p(t,"P",{"data-svelte-h":!0}),o(st)!=="svelte-10bztc1"&&(st.textContent=Ze),hs=n(t),et=p(t,"P",{"data-svelte-h":!0}),o(et)!=="svelte-sk4o55"&&(et.innerHTML=Ie),gs=n(t),m(at.$$.fragment,t),us=n(t),m(b.$$.fragment,t),ys=n(t),m(lt.$$.fragment,t),fs=n(t),nt=p(t,"P",{"data-svelte-h":!0}),o(nt)!=="svelte-15l3yis"&&(nt.textContent=ke),js=n(t),Z=p(t,"DIV",{class:!0,"data-svelte-h":!0}),o(Z)!=="svelte-1ritb1k"&&(Z.innerHTML=Ce),Js=n(t),it=p(t,"P",{"data-svelte-h":!0}),o(it)!=="svelte-1uz68x8"&&(it.innerHTML=Re),ws=n(t),pt=p(t,"P",{"data-svelte-h":!0}),o(pt)!=="svelte-cncrxa"&&(pt.textContent=ve),Ts=n(t),m(ot.$$.fragment,t),Us=n(t),m(ct.$$.fragment,t),bs=n(t),rt=p(t,"P",{"data-svelte-h":!0}),o(rt)!=="svelte-fytdtn"&&(rt.textContent=xe),Zs=n(t),mt=p(t,"P",{"data-svelte-h":!0}),o(mt)!=="svelte-148v07a"&&(mt.textContent=We),Is=n(t),I=p(t,"DIV",{class:!0,"data-svelte-h":!0}),o(I)!=="svelte-gin1vp"&&(I.innerHTML=Ne),ks=n(t),dt=p(t,"P",{"data-svelte-h":!0}),o(dt)!=="svelte-s7b8dy"&&(dt.innerHTML=_e),Cs=n(t),m(Mt.$$.fragment,t),Rs=n(t),ht=p(t,"P",{"data-svelte-h":!0}),o(ht)!=="svelte-mpygyg"&&(ht.textContent=Ge),vs=n(t),m(gt.$$.fragment,t),xs=n(t),ut=p(t,"P",{"data-svelte-h":!0}),o(ut)!=="svelte-cnfg69"&&(ut.textContent=ze),Ws=n(t),yt=p(t,"P",{"data-svelte-h":!0}),o(yt)!=="svelte-nptt59"&&(yt.textContent=Qe),Ns=n(t),k=p(t,"DIV",{class:!0,"data-svelte-h":!0}),o(k)!=="svelte-1j2xr8e"&&(k.innerHTML=Be),_s=n(t),ft=p(t,"P",{"data-svelte-h":!0}),o(ft)!=="svelte-1a68h7f"&&(ft.innerHTML=Ve),Gs=n(t),jt=p(t,"P",{"data-svelte-h":!0}),o(jt)!=="svelte-tdtrto"&&(jt.textContent=He),zs=n(t),m(Jt.$$.fragment,t),Qs=n(t),m(wt.$$.fragment,t),Bs=n(t),Tt=p(t,"P",{"data-svelte-h":!0}),o(Tt)!=="svelte-a4cfdv"&&(Tt.textContent=Xe),Vs=n(t),Ut=p(t,"P",{"data-svelte-h":!0}),o(Ut)!=="svelte-1xbkffx"&&(Ut.textContent=Fe),Hs=n(t),C=p(t,"DIV",{class:!0,"data-svelte-h":!0}),o(C)!=="svelte-g02ga3"&&(C.innerHTML=Ee),Xs=n(t),bt=p(t,"P",{"data-svelte-h":!0}),o(bt)!=="svelte-17q4ltv"&&(bt.innerHTML=$e),Fs=n(t),Zt=p(t,"P",{"data-svelte-h":!0}),o(Zt)!=="svelte-13lz1gw"&&(Zt.textContent=Ye),Es=n(t),m(It.$$.fragment,t),$s=n(t),kt=p(t,"P",{"data-svelte-h":!0}),o(kt)!=="svelte-571z8p"&&(kt.textContent=Ae),Ys=n(t),m(Ct.$$.fragment,t),As=n(t),Rt=p(t,"P",{"data-svelte-h":!0}),o(Rt)!=="svelte-1cpi6ml"&&(Rt.textContent=qe),qs=n(t),vt=p(t,"P",{"data-svelte-h":!0}),o(vt)!=="svelte-bxfm2h"&&(vt.textContent=Se),Ss=n(t),R=p(t,"DIV",{class:!0,"data-svelte-h":!0}),o(R)!=="svelte-1mf93u3"&&(R.innerHTML=De),Ds=n(t),xt=p(t,"P",{"data-svelte-h":!0}),o(xt)!=="svelte-75pbgi"&&(xt.innerHTML=Le),Ls=n(t),m(Wt.$$.fragment,t),Ps=n(t),Nt=p(t,"P",{"data-svelte-h":!0}),o(Nt)!=="svelte-eumo01"&&(Nt.textContent=Pe),Os=n(t),m(v.$$.fragment,t),Ks=n(t),m(_t.$$.fragment,t),te=n(t),Gt=p(t,"P",{"data-svelte-h":!0}),o(Gt)!=="svelte-2k4kpw"&&(Gt.textContent=Oe),se=n(t),m(zt.$$.fragment,t),ee=n(t),m(Qt.$$.fragment,t),ae=n(t),Bt=p(t,"P",{"data-svelte-h":!0}),o(Bt)!=="svelte-ay5071"&&(Bt.innerHTML=Ke),le=n(t),Vt=p(t,"P",{"data-svelte-h":!0}),o(Vt)!=="svelte-8tbmhu"&&(Vt.textContent=ta),ne=n(t),Ht=p(t,"P",{"data-svelte-h":!0}),o(Ht)!=="svelte-ccrnle"&&(Ht.textContent=sa),ie=n(t),m(Xt.$$.fragment,t),pe=n(t),Ft=p(t,"P",{}),na(Ft).forEach(e),this.h()},h(){x(c,"name","hf:doc:metadata"),x(c,"content",Ja),x(U,"class","flex justify-center"),x(Z,"class","flex justify-center"),x(I,"class","flex justify-center"),x(k,"class","flex justify-center"),x(C,"class","flex justify-center"),x(R,"class","flex justify-center")},m(t,s){da(document.head,c),a(t,y,s),a(t,u,s),a(t,w,s),d(W,t,s),a(t,Et,s),d(N,t,s),a(t,$t,s),a(t,_,s),a(t,Yt,s),a(t,G,s),a(t,At,s),a(t,z,s),a(t,qt,s),a(t,Q,s),a(t,St,s),a(t,B,s),a(t,Dt,s),a(t,V,s),a(t,Lt,s),d(H,t,s),a(t,Pt,s),d(T,t,s),a(t,Ot,s),d(X,t,s),a(t,Kt,s),a(t,F,s),a(t,ts,s),d(E,t,s),a(t,ss,s),a(t,$,s),a(t,es,s),d(Y,t,s),a(t,as,s),a(t,A,s),a(t,ls,s),d(q,t,s),a(t,ns,s),a(t,S,s),a(t,is,s),d(D,t,s),a(t,ps,s),a(t,L,s),a(t,os,s),d(P,t,s),a(t,cs,s),a(t,O,s),a(t,rs,s),a(t,K,s),a(t,ms,s),a(t,U,s),a(t,ds,s),a(t,tt,s),a(t,Ms,s),a(t,st,s),a(t,hs,s),a(t,et,s),a(t,gs,s),d(at,t,s),a(t,us,s),d(b,t,s),a(t,ys,s),d(lt,t,s),a(t,fs,s),a(t,nt,s),a(t,js,s),a(t,Z,s),a(t,Js,s),a(t,it,s),a(t,ws,s),a(t,pt,s),a(t,Ts,s),d(ot,t,s),a(t,Us,s),d(ct,t,s),a(t,bs,s),a(t,rt,s),a(t,Zs,s),a(t,mt,s),a(t,Is,s),a(t,I,s),a(t,ks,s),a(t,dt,s),a(t,Cs,s),d(Mt,t,s),a(t,Rs,s),a(t,ht,s),a(t,vs,s),d(gt,t,s),a(t,xs,s),a(t,ut,s),a(t,Ws,s),a(t,yt,s),a(t,Ns,s),a(t,k,s),a(t,_s,s),a(t,ft,s),a(t,Gs,s),a(t,jt,s),a(t,zs,s),d(Jt,t,s),a(t,Qs,s),d(wt,t,s),a(t,Bs,s),a(t,Tt,s),a(t,Vs,s),a(t,Ut,s),a(t,Hs,s),a(t,C,s),a(t,Xs,s),a(t,bt,s),a(t,Fs,s),a(t,Zt,s),a(t,Es,s),d(It,t,s),a(t,$s,s),a(t,kt,s),a(t,Ys,s),d(Ct,t,s),a(t,As,s),a(t,Rt,s),a(t,qs,s),a(t,vt,s),a(t,Ss,s),a(t,R,s),a(t,Ds,s),a(t,xt,s),a(t,Ls,s),d(Wt,t,s),a(t,Ps,s),a(t,Nt,s),a(t,Os,s),d(v,t,s),a(t,Ks,s),d(_t,t,s),a(t,te,s),a(t,Gt,s),a(t,se,s),d(zt,t,s),a(t,ee,s),d(Qt,t,s),a(t,ae,s),a(t,Bt,s),a(t,le,s),a(t,Vt,s),a(t,ne,s),a(t,Ht,s),a(t,ie,s),d(Xt,t,s),a(t,pe,s),a(t,Ft,s),oe=!0},p(t,[s]){const ea={};s&2&&(ea.$$scope={dirty:s,ctx:t}),T.$set(ea);const aa={};s&2&&(aa.$$scope={dirty:s,ctx:t}),b.$set(aa);const la={};s&2&&(la.$$scope={dirty:s,ctx:t}),v.$set(la)},i(t){oe||(M(W.$$.fragment,t),M(N.$$.fragment,t),M(H.$$.fragment,t),M(T.$$.fragment,t),M(X.$$.fragment,t),M(E.$$.fragment,t),M(Y.$$.fragment,t),M(q.$$.fragment,t),M(D.$$.fragment,t),M(P.$$.fragment,t),M(at.$$.fragment,t),M(b.$$.fragment,t),M(lt.$$.fragment,t),M(ot.$$.fragment,t),M(ct.$$.fragment,t),M(Mt.$$.fragment,t),M(gt.$$.fragment,t),M(Jt.$$.fragment,t),M(wt.$$.fragment,t),M(It.$$.fragment,t),M(Ct.$$.fragment,t),M(Wt.$$.fragment,t),M(v.$$.fragment,t),M(_t.$$.fragment,t),M(zt.$$.fragment,t),M(Qt.$$.fragment,t),M(Xt.$$.fragment,t),oe=!0)},o(t){h(W.$$.fragment,t),h(N.$$.fragment,t),h(H.$$.fragment,t),h(T.$$.fragment,t),h(X.$$.fragment,t),h(E.$$.fragment,t),h(Y.$$.fragment,t),h(q.$$.fragment,t),h(D.$$.fragment,t),h(P.$$.fragment,t),h(at.$$.fragment,t),h(b.$$.fragment,t),h(lt.$$.fragment,t),h(ot.$$.fragment,t),h(ct.$$.fragment,t),h(Mt.$$.fragment,t),h(gt.$$.fragment,t),h(Jt.$$.fragment,t),h(wt.$$.fragment,t),h(It.$$.fragment,t),h(Ct.$$.fragment,t),h(Wt.$$.fragment,t),h(v.$$.fragment,t),h(_t.$$.fragment,t),h(zt.$$.fragment,t),h(Qt.$$.fragment,t),h(Xt.$$.fragment,t),oe=!1},d(t){t&&(e(y),e(u),e(w),e(Et),e($t),e(_),e(Yt),e(G),e(At),e(z),e(qt),e(Q),e(St),e(B),e(Dt),e(V),e(Lt),e(Pt),e(Ot),e(Kt),e(F),e(ts),e(ss),e($),e(es),e(as),e(A),e(ls),e(ns),e(S),e(is),e(ps),e(L),e(os),e(cs),e(O),e(rs),e(K),e(ms),e(U),e(ds),e(tt),e(Ms),e(st),e(hs),e(et),e(gs),e(us),e(ys),e(fs),e(nt),e(js),e(Z),e(Js),e(it),e(ws),e(pt),e(Ts),e(Us),e(bs),e(rt),e(Zs),e(mt),e(Is),e(I),e(ks),e(dt),e(Cs),e(Rs),e(ht),e(vs),e(xs),e(ut),e(Ws),e(yt),e(Ns),e(k),e(_s),e(ft),e(Gs),e(jt),e(zs),e(Qs),e(Bs),e(Tt),e(Vs),e(Ut),e(Hs),e(C),e(Xs),e(bt),e(Fs),e(Zt),e(Es),e($s),e(kt),e(Ys),e(As),e(Rt),e(qs),e(vt),e(Ss),e(R),e(Ds),e(xt),e(Ls),e(Ps),e(Nt),e(Os),e(Ks),e(te),e(Gt),e(se),e(ee),e(ae),e(Bt),e(le),e(Vt),e(ne),e(Ht),e(ie),e(pe),e(Ft)),e(c),g(W,t),g(N,t),g(H,t),g(T,t),g(X,t),g(E,t),g(Y,t),g(q,t),g(D,t),g(P,t),g(at,t),g(b,t),g(lt,t),g(ot,t),g(ct,t),g(Mt,t),g(gt,t),g(Jt,t),g(wt,t),g(It,t),g(Ct,t),g(Wt,t),g(v,t),g(_t,t),g(zt,t),g(Qt,t),g(Xt,t)}}}const Ja='{"title":"Image tasks with IDEFICS","local":"image-tasks-with-idefics","sections":[{"title":"Loading the model","local":"loading-the-model","sections":[{"title":"Quantized model","local":"quantized-model","sections":[],"depth":3}],"depth":2},{"title":"Image captioning","local":"image-captioning","sections":[],"depth":2},{"title":"Prompted image captioning","local":"prompted-image-captioning","sections":[],"depth":2},{"title":"Few-shot prompting","local":"few-shot-prompting","sections":[],"depth":2},{"title":"Visual question answering","local":"visual-question-answering","sections":[],"depth":2},{"title":"Image classification","local":"image-classification","sections":[],"depth":2},{"title":"Image-guided text generation","local":"image-guided-text-generation","sections":[],"depth":2},{"title":"Running inference in batch mode","local":"running-inference-in-batch-mode","sections":[],"depth":2},{"title":"IDEFICS instruct for conversational use","local":"idefics-instruct-for-conversational-use","sections":[],"depth":2}],"depth":1}';function wa(J){return oa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ca extends ca{constructor(c){super(),ra(this,c,wa,ja,pa,{})}}export{Ca as component};
