import{s as Ka,o as es,n as Kn}from"../chunks/scheduler.182ea377.js";import{S as ts,i as ns,g as o,s as a,r as p,A as is,h as l,f as i,c as s,j as T,u as c,x as d,k as v,y as n,a as r,v as m,d as f,t as u,w as h}from"../chunks/index.abf12888.js";import{T as Oi}from"../chunks/Tip.230e2334.js";import{D as J}from"../chunks/Docstring.93f6f462.js";import{C as ct}from"../chunks/CodeBlock.57fe6e13.js";import{E as as}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as I}from"../chunks/Heading.16916d63.js";function ss(G){let g,Z="AnimateDiff tends to work better with finetuned Stable Diffusion models. If you plan on using a scheduler that can clip samples, make sure to disable it by setting <code>clip_sample=False</code> in the scheduler as this can also have an adverse effect on generated samples. Additionally, the AnimateDiff checkpoints can be sensitive to the beta schedule of the scheduler. We recommend setting this to <code>linear</code>.";return{c(){g=o("p"),g.innerHTML=Z},l(y){g=l(y,"P",{"data-svelte-h":!0}),d(g)!=="svelte-vnv4xn"&&(g.innerHTML=Z)},m(y,j){r(y,g,j)},p:Kn,d(y){y&&i(g)}}}function os(G){let g,Z="FreeInit is not really free - the improved quality comes at the cost of extra computation. It requires sampling a few extra times depending on the <code>num_iters</code> parameter that is set when enabling it. Setting the <code>use_fast_sampling</code> parameter to <code>True</code> can improve the overall performance (at the cost of lower quality compared to when <code>use_fast_sampling=False</code> but still better results than vanilla video generation models).";return{c(){g=o("p"),g.innerHTML=Z},l(y){g=l(y,"P",{"data-svelte-h":!0}),d(g)!=="svelte-xxwpr5"&&(g.innerHTML=Z)},m(y,j){r(y,g,j)},p:Kn,d(y){y&&i(g)}}}function ls(G){let g,Z='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-components-across-pipelines">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){g=o("p"),g.innerHTML=Z},l(y){g=l(y,"P",{"data-svelte-h":!0}),d(g)!=="svelte-1wmc0l4"&&(g.innerHTML=Z)},m(y,j){r(y,g,j)},p:Kn,d(y){y&&i(g)}}}function rs(G){let g,Z="Examples:",y,j,x;return j=new ct({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwTW90aW9uQWRhcHRlciUyQyUyMEFuaW1hdGVEaWZmUGlwZWxpbmUlMkMlMjBERElNU2NoZWR1bGVyJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGV4cG9ydF90b19naWYlMEElMEFhZGFwdGVyJTIwJTNEJTIwTW90aW9uQWRhcHRlci5mcm9tX3ByZXRyYWluZWQoJTIyZ3VveXd3JTJGYW5pbWF0ZWRpZmYtbW90aW9uLWFkYXB0ZXItdjEtNS0yJTIyKSUwQXBpcGUlMjAlM0QlMjBBbmltYXRlRGlmZlBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJmcmFua2pvc2h1YSUyRnRvb255b3VfYmV0YTYlMjIlMkMlMjBtb3Rpb25fYWRhcHRlciUzRGFkYXB0ZXIpJTBBcGlwZS5zY2hlZHVsZXIlMjAlM0QlMjBERElNU2NoZWR1bGVyKGJldGFfc2NoZWR1bGUlM0QlMjJsaW5lYXIlMjIlMkMlMjBzdGVwc19vZmZzZXQlM0QxJTJDJTIwY2xpcF9zYW1wbGUlM0RGYWxzZSklMEFvdXRwdXQlMjAlM0QlMjBwaXBlKHByb21wdCUzRCUyMkElMjBjb3JnaSUyMHdhbGtpbmclMjBpbiUyMHRoZSUyMHBhcmslMjIpJTBBZnJhbWVzJTIwJTNEJTIwb3V0cHV0LmZyYW1lcyU1QjAlNUQlMEFleHBvcnRfdG9fZ2lmKGZyYW1lcyUyQyUyMCUyMmFuaW1hdGlvbi5naWYlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> MotionAdapter, AnimateDiffPipeline, DDIMScheduler
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif

<span class="hljs-meta">&gt;&gt;&gt; </span>adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;guoyww/animatediff-motion-adapter-v1-5-2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = AnimateDiffPipeline.from_pretrained(<span class="hljs-string">&quot;frankjoshua/toonyou_beta6&quot;</span>, motion_adapter=adapter)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.scheduler = DDIMScheduler(beta_schedule=<span class="hljs-string">&quot;linear&quot;</span>, steps_offset=<span class="hljs-number">1</span>, clip_sample=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output = pipe(prompt=<span class="hljs-string">&quot;A corgi walking in the park&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>frames = output.frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_gif(frames, <span class="hljs-string">&quot;animation.gif&quot;</span>)`,wrap:!1}}),{c(){g=o("p"),g.textContent=Z,y=a(),p(j.$$.fragment)},l(U){g=l(U,"P",{"data-svelte-h":!0}),d(g)!=="svelte-kvfsh7"&&(g.textContent=Z),y=s(U),c(j.$$.fragment,U)},m(U,C){r(U,g,C),r(U,y,C),m(j,U,C),x=!0},p:Kn,i(U){x||(f(j.$$.fragment,U),x=!0)},o(U){u(j.$$.fragment,U),x=!1},d(U){U&&(i(g),i(y)),h(j,U)}}}function ds(G){let g,Z,y,j,x,U,C,Lt,ae,Ki='<a href="https://arxiv.org/abs/2307.04725" rel="nofollow">AnimateDiff: Animate Your Personalized Text-to-Image Diffusion Models without Specific Tuning</a> by Yuwei Guo, Ceyuan Yang, Anyi Rao, Yaohui Wang, Yu Qiao, Dahua Lin, Bo Dai.',zt,se,ea="The abstract of the paper is the following:",Ht,oe,ta='<em>With the advance of text-to-image models (e.g., Stable Diffusion) and corresponding personalization techniques such as DreamBooth and LoRA, everyone can manifest their imagination into high-quality images at an affordable cost. Subsequently, there is a great demand for image animation techniques to further combine generated static images with motion dynamics. In this report, we propose a practical framework to animate most of the existing personalized text-to-image models once and for all, saving efforts in model-specific tuning. At the core of the proposed framework is to insert a newly initialized motion modeling module into the frozen text-to-image model and train it on video clips to distill reasonable motion priors. Once trained, by simply injecting this motion modeling module, all personalized versions derived from the same base T2I readily become text-driven models that produce diverse and personalized animated images. We conduct our evaluation on several public representative personalized text-to-image models across anime pictures and realistic photographs, and demonstrate that our proposed framework helps these models generate temporally smooth animation clips while preserving the domain and diversity of their outputs. Code and pre-trained weights will be publicly available at <a href="https://animatediff.github.io/" rel="nofollow">this https URL</a>.</em>',qt,le,Ot,re,na='<thead><tr><th>Pipeline</th> <th>Tasks</th> <th align="center">Demo</th></tr></thead> <tbody><tr><td><a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff.py" rel="nofollow">AnimateDiffPipeline</a></td> <td><em>Text-to-Video Generation with AnimateDiff</em></td> <td align="center"></td></tr> <tr><td><a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff_video2video.py" rel="nofollow">AnimateDiffVideoToVideoPipeline</a></td> <td><em>Video-to-Video Generation with AnimateDiff</em></td> <td align="center"></td></tr></tbody>',Kt,de,en,pe,ia='Motion Adapter checkpoints can be found under <a href="https://huggingface.co/guoyww/" rel="nofollow">guoyww</a>. These checkpoints are meant to work with any model based on Stable Diffusion 1.4/1.5.',tn,ce,nn,me,an,fe,aa="AnimateDiff works with a MotionAdapter checkpoint and a Stable Diffusion model checkpoint. The MotionAdapter is a collection of Motion Modules that are responsible for adding coherent motion across image frames. These modules are applied after the Resnet and Attention blocks in Stable Diffusion UNet.",sn,ue,sa="The following example demonstrates how to use a <em>MotionAdapter</em> checkpoint with Diffusers for inference based on StableDiffusion-1.4/1.5.",on,he,ln,ge,oa="Here are some sample outputs:",rn,Me,la=`<tbody><tr><td><center>masterpiece, bestquality, sunset.
        <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff-realistic-doc.gif" alt="masterpiece, bestquality, sunset" style="width: 300px;"/></center></td></tr></tbody>`,dn,E,pn,be,cn,_e,ra="AnimateDiff can also be used to generate visually similar videos or enable style/character/background or other edits starting from an initial video, allowing you to seamlessly explore creative possibilities.",mn,ye,fn,we,da="Here are some sample outputs:",un,Te,pa=`<tbody><tr><th align="center">Source Video</th> <th align="center">Output Video</th></tr> <tr><td align="center">raccoon playing a guitar
          <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff-vid2vid-input-1.gif" alt="racoon playing a guitar" style="width: 300px;"/></td> <td align="center">panda playing a guitar
          <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff-vid2vid-output-1.gif" alt="panda playing a guitar" style="width: 300px;"/></td></tr> <tr><td align="center">closeup of margot robbie, fireworks in the background, high quality
          <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff-vid2vid-input-2.gif" alt="closeup of margot robbie, fireworks in the background, high quality" style="width: 300px;"/></td> <td align="center">closeup of tony stark, robert downey jr, fireworks
          <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff-vid2vid-output-2.gif" alt="closeup of tony stark, robert downey jr, fireworks" style="width: 300px;"/></td></tr></tbody>`,hn,ve,gn,Je,ca="Motion LoRAs are a collection of LoRAs that work with the <code>guoyww/animatediff-motion-adapter-v1-5-2</code> checkpoint. These LoRAs are responsible for adding specific types of motion to the animations.",Mn,Ue,bn,je,ma=`<tbody><tr><td><center>masterpiece, bestquality, sunset.
        <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff-zoom-out-lora.gif" alt="masterpiece, bestquality, sunset" style="width: 300px;"/></center></td></tr></tbody>`,_n,Ze,yn,Ie,fa='You can also leverage the <a href="https://github.com/huggingface/peft" rel="nofollow">PEFT</a> backend to combine Motion LoRA’s and create more complex animations.',wn,xe,ua="First install PEFT with",Tn,We,vn,Ve,ha="Then you can use the following code to combine Motion LoRAs.",Jn,Ce,Un,Ge,ga=`<tbody><tr><td><center>masterpiece, bestquality, sunset.
        <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff-zoom-out-pan-left-lora.gif" alt="masterpiece, bestquality, sunset" style="width: 300px;"/></center></td></tr></tbody>`,jn,Ae,Zn,ke,Ma='<a href="https://arxiv.org/abs/2312.07537" rel="nofollow">FreeInit: Bridging Initialization Gap in Video Diffusion Models</a> by Tianxing Wu, Chenyang Si, Yuming Jiang, Ziqi Huang, Ziwei Liu.',In,Be,ba="FreeInit is an effective method that improves temporal consistency and overall quality of videos generated using video-diffusion-models without any addition training. It can be applied to AnimateDiff, ModelScope, VideoCrafter and various other video generation models seamlessly at inference time, and works by iteratively refining the latent-initialization noise. More details can be found it the paper.",xn,$e,_a="The following example demonstrates the usage of FreeInit.",Wn,De,Vn,R,Cn,F,Gn,Ee,An,M,Re,ei,mt,ya="Pipeline for text-to-video generation.",ti,ft,wa=`This model inherits from <a href="/docs/diffusers/v0.26.1/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,ni,ut,Ta="The pipeline also inherits the following loading methods:",ii,ht,va='<li><a href="/docs/diffusers/v0.26.1/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/v0.26.1/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/v0.26.1/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li> <li><a href="/docs/diffusers/v0.26.1/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> for loading IP Adapters</li>',ai,A,Fe,si,gt,Ja="The call function to the pipeline for generation.",oi,X,li,P,Xe,ri,Mt,Ua="Disables the FreeInit mechanism if enabled.",di,S,Pe,pi,bt,ja="Disables the FreeU mechanism if enabled.",ci,N,Se,mi,_t,Za=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,fi,Y,Ne,ui,yt,Ia=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,hi,k,Ye,gi,wt,xa='Enables the FreeInit mechanism as in <a href="https://arxiv.org/abs/2312.07537" rel="nofollow">https://arxiv.org/abs/2312.07537</a>.',Mi,Tt,Wa='This implementation has been adapted from the <a href="https://github.com/TianxingWu/FreeInit" rel="nofollow">official repository</a>.',bi,W,Qe,_i,vt,Va='Enables the FreeU mechanism as in <a href="https://arxiv.org/abs/2309.11497" rel="nofollow">https://arxiv.org/abs/2309.11497</a>.',yi,Jt,Ca="The suffixes after the scaling factors represent the stages where they are being applied.",wi,Ut,Ga=`Please refer to the <a href="https://github.com/ChenyangSi/FreeU" rel="nofollow">official repository</a> for combinations of the values
that are known to work well for different pipelines such as Stable Diffusion v1, v2, and Stable Diffusion XL.`,Ti,Q,Le,vi,jt,Aa=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,Ji,L,ze,Ui,Zt,ka=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,ji,z,He,Zi,It,Ba="Encodes the prompt into text encoder hidden states.",kn,qe,Bn,_,Oe,Ii,xt,$a="Pipeline for video-to-video generation.",xi,Wt,Da=`This model inherits from <a href="/docs/diffusers/v0.26.1/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Wi,Vt,Ea="The pipeline also inherits the following loading methods:",Vi,Ct,Ra='<li><a href="/docs/diffusers/v0.26.1/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/v0.26.1/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/v0.26.1/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li> <li><a href="/docs/diffusers/v0.26.1/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> for loading IP Adapters</li>',Ci,B,Ke,Gi,Gt,Fa="The call function to the pipeline for generation.",Ai,At,Xa="Examples:",ki,H,et,Bi,kt,Pa="Disables the FreeU mechanism if enabled.",$i,q,tt,Di,Bt,Sa=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,Ei,O,nt,Ri,$t,Na=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,Fi,V,it,Xi,Dt,Ya='Enables the FreeU mechanism as in <a href="https://arxiv.org/abs/2309.11497" rel="nofollow">https://arxiv.org/abs/2309.11497</a>.',Pi,Et,Qa="The suffixes after the scaling factors represent the stages where they are being applied.",Si,Rt,La=`Please refer to the <a href="https://github.com/ChenyangSi/FreeU" rel="nofollow">official repository</a> for combinations of the values
that are known to work well for different pipelines such as Stable Diffusion v1, v2, and Stable Diffusion XL.`,Ni,K,at,Yi,Ft,za=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,Qi,ee,st,Li,Xt,Ha=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,zi,te,ot,Hi,Pt,qa="Encodes the prompt into text encoder hidden states.",$n,lt,Dn,$,rt,qi,St,Oa="Output class for AnimateDiff pipelines.",En,Qt,Rn;return x=new I({props:{title:"Text-to-Video Generation with AnimateDiff",local:"text-to-video-generation-with-animatediff",headingTag:"h1"}}),C=new I({props:{title:"Overview",local:"overview",headingTag:"h2"}}),le=new I({props:{title:"Available Pipelines",local:"available-pipelines",headingTag:"h2"}}),de=new I({props:{title:"Available checkpoints",local:"available-checkpoints",headingTag:"h2"}}),ce=new I({props:{title:"Usage example",local:"usage-example",headingTag:"h2"}}),me=new I({props:{title:"AnimateDiffPipeline",local:"animatediffpipeline",headingTag:"h3"}}),he=new ct({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AnimateDiffPipeline, DDIMScheduler, MotionAdapter
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif

<span class="hljs-comment"># Load the motion adapter</span>
adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;guoyww/animatediff-motion-adapter-v1-5-2&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-comment"># load SD 1.5 based finetuned model</span>
model_id = <span class="hljs-string">&quot;SG161222/Realistic_Vision_V5.1_noVAE&quot;</span>
pipe = AnimateDiffPipeline.from_pretrained(model_id, motion_adapter=adapter, torch_dtype=torch.float16)
scheduler = DDIMScheduler.from_pretrained(
    model_id,
    subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>,
    clip_sample=<span class="hljs-literal">False</span>,
    timestep_spacing=<span class="hljs-string">&quot;linspace&quot;</span>,
    beta_schedule=<span class="hljs-string">&quot;linear&quot;</span>,
    steps_offset=<span class="hljs-number">1</span>,
)
pipe.scheduler = scheduler

<span class="hljs-comment"># enable memory savings</span>
pipe.enable_vae_slicing()
pipe.enable_model_cpu_offload()

output = pipe(
    prompt=(
        <span class="hljs-string">&quot;masterpiece, bestquality, highlydetailed, ultradetailed, sunset, &quot;</span>
        <span class="hljs-string">&quot;orange sky, warm lighting, fishing boats, ocean waves seagulls, &quot;</span>
        <span class="hljs-string">&quot;rippling water, wharf, silhouette, serene atmosphere, dusk, evening glow, &quot;</span>
        <span class="hljs-string">&quot;golden hour, coastal landscape, seaside scenery&quot;</span>
    ),
    negative_prompt=<span class="hljs-string">&quot;bad quality, worse quality&quot;</span>,
    num_frames=<span class="hljs-number">16</span>,
    guidance_scale=<span class="hljs-number">7.5</span>,
    num_inference_steps=<span class="hljs-number">25</span>,
    generator=torch.Generator(<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">42</span>),
)
frames = output.frames[<span class="hljs-number">0</span>]
export_to_gif(frames, <span class="hljs-string">&quot;animation.gif&quot;</span>)
`,wrap:!1}}),E=new Oi({props:{$$slots:{default:[ss]},$$scope:{ctx:G}}}),be=new I({props:{title:"AnimateDiffVideoToVideoPipeline",local:"animatediffvideotovideopipeline",headingTag:"h3"}}),ye=new ct({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> imageio
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AnimateDiffVideoToVideoPipeline, DDIMScheduler, MotionAdapter
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-comment"># Load the motion adapter</span>
adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;guoyww/animatediff-motion-adapter-v1-5-2&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-comment"># load SD 1.5 based finetuned model</span>
model_id = <span class="hljs-string">&quot;SG161222/Realistic_Vision_V5.1_noVAE&quot;</span>
pipe = AnimateDiffVideoToVideoPipeline.from_pretrained(model_id, motion_adapter=adapter, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
scheduler = DDIMScheduler.from_pretrained(
    model_id,
    subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>,
    clip_sample=<span class="hljs-literal">False</span>,
    timestep_spacing=<span class="hljs-string">&quot;linspace&quot;</span>,
    beta_schedule=<span class="hljs-string">&quot;linear&quot;</span>,
    steps_offset=<span class="hljs-number">1</span>,
)
pipe.scheduler = scheduler

<span class="hljs-comment"># enable memory savings</span>
pipe.enable_vae_slicing()
pipe.enable_model_cpu_offload()

<span class="hljs-comment"># helper function to load videos</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">load_video</span>(<span class="hljs-params">file_path: <span class="hljs-built_in">str</span></span>):
    images = []

    <span class="hljs-keyword">if</span> file_path.startswith((<span class="hljs-string">&#x27;http://&#x27;</span>, <span class="hljs-string">&#x27;https://&#x27;</span>)):
        <span class="hljs-comment"># If the file_path is a URL</span>
        response = requests.get(file_path)
        response.raise_for_status()
        content = BytesIO(response.content)
        vid = imageio.get_reader(content)
    <span class="hljs-keyword">else</span>:
        <span class="hljs-comment"># Assuming it&#x27;s a local file path</span>
        vid = imageio.get_reader(file_path)

    <span class="hljs-keyword">for</span> frame <span class="hljs-keyword">in</span> vid:
        pil_image = Image.fromarray(frame)
        images.append(pil_image)

    <span class="hljs-keyword">return</span> images

video = load_video(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff-vid2vid-input-1.gif&quot;</span>)

output = pipe(
    video = video,
    prompt=<span class="hljs-string">&quot;panda playing a guitar, on a boat, in the ocean, high quality&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;bad quality, worse quality&quot;</span>,
    guidance_scale=<span class="hljs-number">7.5</span>,
    num_inference_steps=<span class="hljs-number">25</span>,
    strength=<span class="hljs-number">0.5</span>,
    generator=torch.Generator(<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">42</span>),
)
frames = output.frames[<span class="hljs-number">0</span>]
export_to_gif(frames, <span class="hljs-string">&quot;animation.gif&quot;</span>)`,wrap:!1}}),ve=new I({props:{title:"Using Motion LoRAs",local:"using-motion-loras",headingTag:"h2"}}),Ue=new ct({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AnimateDiffPipeline, DDIMScheduler, MotionAdapter
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif

<span class="hljs-comment"># Load the motion adapter</span>
adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;guoyww/animatediff-motion-adapter-v1-5-2&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-comment"># load SD 1.5 based finetuned model</span>
model_id = <span class="hljs-string">&quot;SG161222/Realistic_Vision_V5.1_noVAE&quot;</span>
pipe = AnimateDiffPipeline.from_pretrained(model_id, motion_adapter=adapter, torch_dtype=torch.float16)
pipe.load_lora_weights(
    <span class="hljs-string">&quot;guoyww/animatediff-motion-lora-zoom-out&quot;</span>, adapter_name=<span class="hljs-string">&quot;zoom-out&quot;</span>
)

scheduler = DDIMScheduler.from_pretrained(
    model_id,
    subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>,
    clip_sample=<span class="hljs-literal">False</span>,
    beta_schedule=<span class="hljs-string">&quot;linear&quot;</span>,
    timestep_spacing=<span class="hljs-string">&quot;linspace&quot;</span>,
    steps_offset=<span class="hljs-number">1</span>,
)
pipe.scheduler = scheduler

<span class="hljs-comment"># enable memory savings</span>
pipe.enable_vae_slicing()
pipe.enable_model_cpu_offload()

output = pipe(
    prompt=(
        <span class="hljs-string">&quot;masterpiece, bestquality, highlydetailed, ultradetailed, sunset, &quot;</span>
        <span class="hljs-string">&quot;orange sky, warm lighting, fishing boats, ocean waves seagulls, &quot;</span>
        <span class="hljs-string">&quot;rippling water, wharf, silhouette, serene atmosphere, dusk, evening glow, &quot;</span>
        <span class="hljs-string">&quot;golden hour, coastal landscape, seaside scenery&quot;</span>
    ),
    negative_prompt=<span class="hljs-string">&quot;bad quality, worse quality&quot;</span>,
    num_frames=<span class="hljs-number">16</span>,
    guidance_scale=<span class="hljs-number">7.5</span>,
    num_inference_steps=<span class="hljs-number">25</span>,
    generator=torch.Generator(<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">42</span>),
)
frames = output.frames[<span class="hljs-number">0</span>]
export_to_gif(frames, <span class="hljs-string">&quot;animation.gif&quot;</span>)
`,wrap:!1}}),Ze=new I({props:{title:"Using Motion LoRAs with PEFT",local:"using-motion-loras-with-peft",headingTag:"h2"}}),We=new ct({props:{code:"cGlwJTIwaW5zdGFsbCUyMHBlZnQ=",highlighted:"pip install peft",wrap:!1}}),Ce=new ct({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AnimateDiffPipeline, DDIMScheduler, MotionAdapter
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif

<span class="hljs-comment"># Load the motion adapter</span>
adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;guoyww/animatediff-motion-adapter-v1-5-2&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-comment"># load SD 1.5 based finetuned model</span>
model_id = <span class="hljs-string">&quot;SG161222/Realistic_Vision_V5.1_noVAE&quot;</span>
pipe = AnimateDiffPipeline.from_pretrained(model_id, motion_adapter=adapter, torch_dtype=torch.float16)

pipe.load_lora_weights(
    <span class="hljs-string">&quot;diffusers/animatediff-motion-lora-zoom-out&quot;</span>, adapter_name=<span class="hljs-string">&quot;zoom-out&quot;</span>,
)
pipe.load_lora_weights(
    <span class="hljs-string">&quot;diffusers/animatediff-motion-lora-pan-left&quot;</span>, adapter_name=<span class="hljs-string">&quot;pan-left&quot;</span>,
)
pipe.set_adapters([<span class="hljs-string">&quot;zoom-out&quot;</span>, <span class="hljs-string">&quot;pan-left&quot;</span>], adapter_weights=[<span class="hljs-number">1.0</span>, <span class="hljs-number">1.0</span>])

scheduler = DDIMScheduler.from_pretrained(
    model_id,
    subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>,
    clip_sample=<span class="hljs-literal">False</span>,
    timestep_spacing=<span class="hljs-string">&quot;linspace&quot;</span>,
    beta_schedule=<span class="hljs-string">&quot;linear&quot;</span>,
    steps_offset=<span class="hljs-number">1</span>,
)
pipe.scheduler = scheduler

<span class="hljs-comment"># enable memory savings</span>
pipe.enable_vae_slicing()
pipe.enable_model_cpu_offload()

output = pipe(
    prompt=(
        <span class="hljs-string">&quot;masterpiece, bestquality, highlydetailed, ultradetailed, sunset, &quot;</span>
        <span class="hljs-string">&quot;orange sky, warm lighting, fishing boats, ocean waves seagulls, &quot;</span>
        <span class="hljs-string">&quot;rippling water, wharf, silhouette, serene atmosphere, dusk, evening glow, &quot;</span>
        <span class="hljs-string">&quot;golden hour, coastal landscape, seaside scenery&quot;</span>
    ),
    negative_prompt=<span class="hljs-string">&quot;bad quality, worse quality&quot;</span>,
    num_frames=<span class="hljs-number">16</span>,
    guidance_scale=<span class="hljs-number">7.5</span>,
    num_inference_steps=<span class="hljs-number">25</span>,
    generator=torch.Generator(<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">42</span>),
)
frames = output.frames[<span class="hljs-number">0</span>]
export_to_gif(frames, <span class="hljs-string">&quot;animation.gif&quot;</span>)
`,wrap:!1}}),Ae=new I({props:{title:"Using FreeInit",local:"using-freeinit",headingTag:"h2"}}),De=new ct({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> MotionAdapter, AnimateDiffPipeline, DDIMScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif

adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;guoyww/animatediff-motion-adapter-v1-5-2&quot;</span>)
model_id = <span class="hljs-string">&quot;SG161222/Realistic_Vision_V5.1_noVAE&quot;</span>
pipe = AnimateDiffPipeline.from_pretrained(model_id, motion_adapter=adapter, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.scheduler = DDIMScheduler.from_pretrained(
    model_id,
    subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>,
    beta_schedule=<span class="hljs-string">&quot;linear&quot;</span>,
    clip_sample=<span class="hljs-literal">False</span>,
    timestep_spacing=<span class="hljs-string">&quot;linspace&quot;</span>,
    steps_offset=<span class="hljs-number">1</span>
)

<span class="hljs-comment"># enable memory savings</span>
pipe.enable_vae_slicing()
pipe.enable_vae_tiling()

<span class="hljs-comment"># enable FreeInit</span>
<span class="hljs-comment"># Refer to the enable_free_init documentation for a full list of configurable parameters</span>
pipe.enable_free_init(method=<span class="hljs-string">&quot;butterworth&quot;</span>, use_fast_sampling=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># run inference</span>
output = pipe(
    prompt=<span class="hljs-string">&quot;a panda playing a guitar, on a boat, in the ocean, high quality&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;bad quality, worse quality&quot;</span>,
    num_frames=<span class="hljs-number">16</span>,
    guidance_scale=<span class="hljs-number">7.5</span>,
    num_inference_steps=<span class="hljs-number">20</span>,
    generator=torch.Generator(<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">666</span>),
)

<span class="hljs-comment"># disable FreeInit</span>
pipe.disable_free_init()

frames = output.frames[<span class="hljs-number">0</span>]
export_to_gif(frames, <span class="hljs-string">&quot;animation.gif&quot;</span>)`,wrap:!1}}),R=new Oi({props:{warning:!0,$$slots:{default:[os]},$$scope:{ctx:G}}}),F=new Oi({props:{$$slots:{default:[ls]},$$scope:{ctx:G}}}),Ee=new I({props:{title:"AnimateDiffPipeline",local:"diffusers.AnimateDiffPipeline",headingTag:"h2"}}),Re=new J({props:{name:"class diffusers.AnimateDiffPipeline",anchor:"diffusers.AnimateDiffPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"motion_adapter",val:": MotionAdapter"},{name:"scheduler",val:": Union"},{name:"feature_extractor",val:": CLIPImageProcessor = None"},{name:"image_encoder",val:": CLIPVisionModelWithProjection = None"}],parametersDescription:[{anchor:"diffusers.AnimateDiffPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/v0.26.1/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.AnimateDiffPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.AnimateDiffPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
A <a href="https://huggingface.co/docs/transformers/v4.37.2/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.AnimateDiffPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/v0.26.1/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <a href="/docs/diffusers/v0.26.1/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a> used to create a UNetMotionModel to denoise the encoded video latents.`,name:"unet"},{anchor:"diffusers.AnimateDiffPipeline.motion_adapter",description:`<strong>motion_adapter</strong> (<code>MotionAdapter</code>) &#x2014;
A <code>MotionAdapter</code> to be used in combination with <code>unet</code> to denoise the encoded video latents.`,name:"motion_adapter"},{anchor:"diffusers.AnimateDiffPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/v0.26.1/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/v0.26.1/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/v0.26.1/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/v0.26.1/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/v0.26.1/src/diffusers/pipelines/animatediff/pipeline_animatediff.py#L155"}}),Fe=new J({props:{name:"__call__",anchor:"diffusers.AnimateDiffPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"num_frames",val:": Optional = 16"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": Union = None"},{name:"num_videos_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"ip_adapter_image",val:": Union = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.AnimateDiffPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.AnimateDiffPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated video.`,name:"height"},{anchor:"diffusers.AnimateDiffPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated video.`,name:"width"},{anchor:"diffusers.AnimateDiffPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The number of video frames that are generated. Defaults to 16 frames which at 8 frames per seconds
amounts to 2 seconds of video.`,name:"num_frames"},{anchor:"diffusers.AnimateDiffPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality videos at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.AnimateDiffPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.AnimateDiffPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.AnimateDiffPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/v0.26.1/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.AnimateDiffPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.AnimateDiffPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for video
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>. Latents should be of shape
<code>(batch_size, num_channel, num_frames, height, width)</code>.`,name:"latents"},{anchor:"diffusers.AnimateDiffPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.AnimateDiffPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.
ip_adapter_image &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>):
Optional image input to work with IP Adapters.`,name:"negative_prompt_embeds"},{anchor:"diffusers.AnimateDiffPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated video. Choose between <code>torch.FloatTensor</code>, <code>PIL.Image</code> or
<code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.AnimateDiffPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.26.1/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput">TextToVideoSDPipelineOutput</a> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.AnimateDiffPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.AnimateDiffPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.AnimateDiffPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.AnimateDiffPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeine class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/v0.26.1/src/diffusers/pipelines/animatediff/pipeline_animatediff.py#L867",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/v0.26.1/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput"
>TextToVideoSDPipelineOutput</a> is
returned, otherwise a <code>tuple</code> is returned where the first element is a list with the generated frames.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/v0.26.1/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput"
>TextToVideoSDPipelineOutput</a> or <code>tuple</code></p>
`}}),X=new as({props:{anchor:"diffusers.AnimateDiffPipeline.__call__.example",$$slots:{default:[rs]},$$scope:{ctx:G}}}),Xe=new J({props:{name:"disable_free_init",anchor:"diffusers.AnimateDiffPipeline.disable_free_init",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.26.1/src/diffusers/pipelines/animatediff/pipeline_animatediff.py#L591"}}),Pe=new J({props:{name:"disable_freeu",anchor:"diffusers.AnimateDiffPipeline.disable_freeu",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.26.1/src/diffusers/pipelines/animatediff/pipeline_animatediff.py#L539"}}),Se=new J({props:{name:"disable_vae_slicing",anchor:"diffusers.AnimateDiffPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.26.1/src/diffusers/pipelines/animatediff/pipeline_animatediff.py#L491"}}),Ne=new J({props:{name:"disable_vae_tiling",anchor:"diffusers.AnimateDiffPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.26.1/src/diffusers/pipelines/animatediff/pipeline_animatediff.py#L508"}}),Ye=new J({props:{name:"enable_free_init",anchor:"diffusers.AnimateDiffPipeline.enable_free_init",parameters:[{name:"num_iters",val:": int = 3"},{name:"use_fast_sampling",val:": bool = False"},{name:"method",val:": str = 'butterworth'"},{name:"order",val:": int = 4"},{name:"spatial_stop_frequency",val:": float = 0.25"},{name:"temporal_stop_frequency",val:": float = 0.25"},{name:"generator",val:": Generator = None"}],parametersDescription:[{anchor:"diffusers.AnimateDiffPipeline.enable_free_init.num_iters",description:`<strong>num_iters</strong> (<code>int</code>, <em>optional</em>, defaults to <code>3</code>) &#x2014;
Number of FreeInit noise re-initialization iterations.`,name:"num_iters"},{anchor:"diffusers.AnimateDiffPipeline.enable_free_init.use_fast_sampling",description:`<strong>use_fast_sampling</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to speedup sampling procedure at the cost of probably lower quality results. Enables
the &#x201C;Coarse-to-Fine Sampling&#x201D; strategy, as mentioned in the paper, if set to <code>True</code>.`,name:"use_fast_sampling"},{anchor:"diffusers.AnimateDiffPipeline.enable_free_init.method",description:`<strong>method</strong> (<code>str</code>, <em>optional</em>, defaults to <code>butterworth</code>) &#x2014;
Must be one of <code>butterworth</code>, <code>ideal</code> or <code>gaussian</code> to use as the filtering method for the
FreeInit low pass filter.`,name:"method"},{anchor:"diffusers.AnimateDiffPipeline.enable_free_init.order",description:`<strong>order</strong> (<code>int</code>, <em>optional</em>, defaults to <code>4</code>) &#x2014;
Order of the filter used in <code>butterworth</code> method. Larger values lead to <code>ideal</code> method behaviour
whereas lower values lead to <code>gaussian</code> method behaviour.`,name:"order"},{anchor:"diffusers.AnimateDiffPipeline.enable_free_init.spatial_stop_frequency",description:`<strong>spatial_stop_frequency</strong> (<code>float</code>, <em>optional</em>, defaults to <code>0.25</code>) &#x2014;
Normalized stop frequency for spatial dimensions. Must be between 0 to 1. Referred to as <code>d_s</code> in
the original implementation.`,name:"spatial_stop_frequency"},{anchor:"diffusers.AnimateDiffPipeline.enable_free_init.temporal_stop_frequency",description:`<strong>temporal_stop_frequency</strong> (<code>float</code>, <em>optional</em>, defaults to <code>0.25</code>) &#x2014;
Normalized stop frequency for temporal dimensions. Must be between 0 to 1. Referred to as <code>d_t</code> in
the original implementation.`,name:"temporal_stop_frequency"},{anchor:"diffusers.AnimateDiffPipeline.enable_free_init.generator",description:`<strong>generator</strong> (<code>torch.Generator</code>, <em>optional</em>, defaults to <code>0.25</code>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
FreeInit generation deterministic.`,name:"generator"}],source:"https://github.com/huggingface/diffusers/blob/v0.26.1/src/diffusers/pipelines/animatediff/pipeline_animatediff.py#L547"}}),Qe=new J({props:{name:"enable_freeu",anchor:"diffusers.AnimateDiffPipeline.enable_freeu",parameters:[{name:"s1",val:": float"},{name:"s2",val:": float"},{name:"b1",val:": float"},{name:"b2",val:": float"}],parametersDescription:[{anchor:"diffusers.AnimateDiffPipeline.enable_freeu.s1",description:`<strong>s1</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 1 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s1"},{anchor:"diffusers.AnimateDiffPipeline.enable_freeu.s2",description:`<strong>s2</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 2 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s2"},{anchor:"diffusers.AnimateDiffPipeline.enable_freeu.b1",description:"<strong>b1</strong> (<code>float</code>) &#x2014; Scaling factor for stage 1 to amplify the contributions of backbone features.",name:"b1"},{anchor:"diffusers.AnimateDiffPipeline.enable_freeu.b2",description:"<strong>b2</strong> (<code>float</code>) &#x2014; Scaling factor for stage 2 to amplify the contributions of backbone features.",name:"b2"}],source:"https://github.com/huggingface/diffusers/blob/v0.26.1/src/diffusers/pipelines/animatediff/pipeline_animatediff.py#L516"}}),Le=new J({props:{name:"enable_vae_slicing",anchor:"diffusers.AnimateDiffPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.26.1/src/diffusers/pipelines/animatediff/pipeline_animatediff.py#L483"}}),ze=new J({props:{name:"enable_vae_tiling",anchor:"diffusers.AnimateDiffPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.26.1/src/diffusers/pipelines/animatediff/pipeline_animatediff.py#L499"}}),He=new J({props:{name:"encode_prompt",anchor:"diffusers.AnimateDiffPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.AnimateDiffPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.AnimateDiffPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.AnimateDiffPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.AnimateDiffPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.AnimateDiffPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.AnimateDiffPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.AnimateDiffPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.AnimateDiffPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/v0.26.1/src/diffusers/pipelines/animatediff/pipeline_animatediff.py#L223"}}),qe=new I({props:{title:"AnimateDiffVideoToVideoPipeline",local:"diffusers.AnimateDiffVideoToVideoPipeline",headingTag:"h2"}}),Oe=new J({props:{name:"class diffusers.AnimateDiffVideoToVideoPipeline",anchor:"diffusers.AnimateDiffVideoToVideoPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"motion_adapter",val:": MotionAdapter"},{name:"scheduler",val:": Union"},{name:"feature_extractor",val:": CLIPImageProcessor = None"},{name:"image_encoder",val:": CLIPVisionModelWithProjection = None"}],parametersDescription:[{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/v0.26.1/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
A <a href="https://huggingface.co/docs/transformers/v4.37.2/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/v0.26.1/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <a href="/docs/diffusers/v0.26.1/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a> used to create a UNetMotionModel to denoise the encoded video latents.`,name:"unet"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.motion_adapter",description:`<strong>motion_adapter</strong> (<code>MotionAdapter</code>) &#x2014;
A <code>MotionAdapter</code> to be used in combination with <code>unet</code> to denoise the encoded video latents.`,name:"motion_adapter"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/v0.26.1/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/v0.26.1/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/v0.26.1/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/v0.26.1/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/v0.26.1/src/diffusers/pipelines/animatediff/pipeline_animatediff_video2video.py#L166"}}),Ke=new J({props:{name:"__call__",anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__",parameters:[{name:"video",val:": List = None"},{name:"prompt",val:": Union = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": Optional = None"},{name:"guidance_scale",val:": float = 7.5"},{name:"strength",val:": float = 0.8"},{name:"negative_prompt",val:": Union = None"},{name:"num_videos_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"ip_adapter_image",val:": Union = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"}],parametersDescription:[{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.video",description:`<strong>video</strong> (<code>List[PipelineImageInput]</code>) &#x2014;
The input video to condition the generation on. Must be a list of images/frames of the video.`,name:"video"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated video.`,name:"height"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated video.`,name:"width"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality videos at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
Higher strength leads to more differences between original video and generated video.`,name:"strength"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/v0.26.1/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for video
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>. Latents should be of shape
<code>(batch_size, num_channel, num_frames, height, width)</code>.`,name:"latents"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.
ip_adapter_image &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>):
Optional image input to work with IP Adapters.`,name:"negative_prompt_embeds"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated video. Choose between <code>torch.FloatTensor</code>, <code>PIL.Image</code> or
<code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>AnimateDiffPipelineOutput</code> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeine class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/v0.26.1/src/diffusers/pipelines/animatediff/pipeline_animatediff_video2video.py#L726",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>AnimateDiffPipelineOutput</code> is
returned, otherwise a <code>tuple</code> is returned where the first element is a list with the generated frames.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>AnimateDiffPipelineOutput</code> or <code>tuple</code></p>
`}}),et=new J({props:{name:"disable_freeu",anchor:"diffusers.AnimateDiffVideoToVideoPipeline.disable_freeu",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.26.1/src/diffusers/pipelines/animatediff/pipeline_animatediff_video2video.py#L521"}}),tt=new J({props:{name:"disable_vae_slicing",anchor:"diffusers.AnimateDiffVideoToVideoPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.26.1/src/diffusers/pipelines/animatediff/pipeline_animatediff_video2video.py#L473"}}),nt=new J({props:{name:"disable_vae_tiling",anchor:"diffusers.AnimateDiffVideoToVideoPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.26.1/src/diffusers/pipelines/animatediff/pipeline_animatediff_video2video.py#L490"}}),it=new J({props:{name:"enable_freeu",anchor:"diffusers.AnimateDiffVideoToVideoPipeline.enable_freeu",parameters:[{name:"s1",val:": float"},{name:"s2",val:": float"},{name:"b1",val:": float"},{name:"b2",val:": float"}],parametersDescription:[{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.enable_freeu.s1",description:`<strong>s1</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 1 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s1"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.enable_freeu.s2",description:`<strong>s2</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 2 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s2"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.enable_freeu.b1",description:"<strong>b1</strong> (<code>float</code>) &#x2014; Scaling factor for stage 1 to amplify the contributions of backbone features.",name:"b1"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.enable_freeu.b2",description:"<strong>b2</strong> (<code>float</code>) &#x2014; Scaling factor for stage 2 to amplify the contributions of backbone features.",name:"b2"}],source:"https://github.com/huggingface/diffusers/blob/v0.26.1/src/diffusers/pipelines/animatediff/pipeline_animatediff_video2video.py#L498"}}),at=new J({props:{name:"enable_vae_slicing",anchor:"diffusers.AnimateDiffVideoToVideoPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.26.1/src/diffusers/pipelines/animatediff/pipeline_animatediff_video2video.py#L465"}}),st=new J({props:{name:"enable_vae_tiling",anchor:"diffusers.AnimateDiffVideoToVideoPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.26.1/src/diffusers/pipelines/animatediff/pipeline_animatediff_video2video.py#L481"}}),ot=new J({props:{name:"encode_prompt",anchor:"diffusers.AnimateDiffVideoToVideoPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.AnimateDiffVideoToVideoPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/v0.26.1/src/diffusers/pipelines/animatediff/pipeline_animatediff_video2video.py#L234"}}),lt=new I({props:{title:"AnimateDiffPipelineOutput",local:"diffusers.pipelines.animatediff.AnimateDiffPipelineOutput",headingTag:"h2"}}),rt=new J({props:{name:"class diffusers.pipelines.animatediff.AnimateDiffPipelineOutput",anchor:"diffusers.pipelines.animatediff.AnimateDiffPipelineOutput",parameters:[{name:"frames",val:": Union"}],parametersDescription:[{anchor:"diffusers.pipelines.animatediff.AnimateDiffPipelineOutput.frames",description:`<strong>frames</strong> (<code>List[List[PIL.Image.Image]]</code> or <code>torch.Tensor</code> or <code>np.ndarray</code>) &#x2014;
List of PIL Images of length <code>batch_size</code> or torch.Tensor or np.ndarray of shape
<code>(batch_size, num_frames, height, width, num_channels)</code>.`,name:"frames"}],source:"https://github.com/huggingface/diffusers/blob/v0.26.1/src/diffusers/pipelines/animatediff/pipeline_output.py#L11"}}),{c(){g=o("meta"),Z=a(),y=o("p"),j=a(),p(x.$$.fragment),U=a(),p(C.$$.fragment),Lt=a(),ae=o("p"),ae.innerHTML=Ki,zt=a(),se=o("p"),se.textContent=ea,Ht=a(),oe=o("p"),oe.innerHTML=ta,qt=a(),p(le.$$.fragment),Ot=a(),re=o("table"),re.innerHTML=na,Kt=a(),p(de.$$.fragment),en=a(),pe=o("p"),pe.innerHTML=ia,tn=a(),p(ce.$$.fragment),nn=a(),p(me.$$.fragment),an=a(),fe=o("p"),fe.textContent=aa,sn=a(),ue=o("p"),ue.innerHTML=sa,on=a(),p(he.$$.fragment),ln=a(),ge=o("p"),ge.textContent=oa,rn=a(),Me=o("table"),Me.innerHTML=la,dn=a(),p(E.$$.fragment),pn=a(),p(be.$$.fragment),cn=a(),_e=o("p"),_e.textContent=ra,mn=a(),p(ye.$$.fragment),fn=a(),we=o("p"),we.textContent=da,un=a(),Te=o("table"),Te.innerHTML=pa,hn=a(),p(ve.$$.fragment),gn=a(),Je=o("p"),Je.innerHTML=ca,Mn=a(),p(Ue.$$.fragment),bn=a(),je=o("table"),je.innerHTML=ma,_n=a(),p(Ze.$$.fragment),yn=a(),Ie=o("p"),Ie.innerHTML=fa,wn=a(),xe=o("p"),xe.textContent=ua,Tn=a(),p(We.$$.fragment),vn=a(),Ve=o("p"),Ve.textContent=ha,Jn=a(),p(Ce.$$.fragment),Un=a(),Ge=o("table"),Ge.innerHTML=ga,jn=a(),p(Ae.$$.fragment),Zn=a(),ke=o("p"),ke.innerHTML=Ma,In=a(),Be=o("p"),Be.textContent=ba,xn=a(),$e=o("p"),$e.textContent=_a,Wn=a(),p(De.$$.fragment),Vn=a(),p(R.$$.fragment),Cn=a(),p(F.$$.fragment),Gn=a(),p(Ee.$$.fragment),An=a(),M=o("div"),p(Re.$$.fragment),ei=a(),mt=o("p"),mt.textContent=ya,ti=a(),ft=o("p"),ft.innerHTML=wa,ni=a(),ut=o("p"),ut.textContent=Ta,ii=a(),ht=o("ul"),ht.innerHTML=va,ai=a(),A=o("div"),p(Fe.$$.fragment),si=a(),gt=o("p"),gt.textContent=Ja,oi=a(),p(X.$$.fragment),li=a(),P=o("div"),p(Xe.$$.fragment),ri=a(),Mt=o("p"),Mt.textContent=Ua,di=a(),S=o("div"),p(Pe.$$.fragment),pi=a(),bt=o("p"),bt.textContent=ja,ci=a(),N=o("div"),p(Se.$$.fragment),mi=a(),_t=o("p"),_t.innerHTML=Za,fi=a(),Y=o("div"),p(Ne.$$.fragment),ui=a(),yt=o("p"),yt.innerHTML=Ia,hi=a(),k=o("div"),p(Ye.$$.fragment),gi=a(),wt=o("p"),wt.innerHTML=xa,Mi=a(),Tt=o("p"),Tt.innerHTML=Wa,bi=a(),W=o("div"),p(Qe.$$.fragment),_i=a(),vt=o("p"),vt.innerHTML=Va,yi=a(),Jt=o("p"),Jt.textContent=Ca,wi=a(),Ut=o("p"),Ut.innerHTML=Ga,Ti=a(),Q=o("div"),p(Le.$$.fragment),vi=a(),jt=o("p"),jt.textContent=Aa,Ji=a(),L=o("div"),p(ze.$$.fragment),Ui=a(),Zt=o("p"),Zt.textContent=ka,ji=a(),z=o("div"),p(He.$$.fragment),Zi=a(),It=o("p"),It.textContent=Ba,kn=a(),p(qe.$$.fragment),Bn=a(),_=o("div"),p(Oe.$$.fragment),Ii=a(),xt=o("p"),xt.textContent=$a,xi=a(),Wt=o("p"),Wt.innerHTML=Da,Wi=a(),Vt=o("p"),Vt.textContent=Ea,Vi=a(),Ct=o("ul"),Ct.innerHTML=Ra,Ci=a(),B=o("div"),p(Ke.$$.fragment),Gi=a(),Gt=o("p"),Gt.textContent=Fa,Ai=a(),At=o("p"),At.textContent=Xa,ki=a(),H=o("div"),p(et.$$.fragment),Bi=a(),kt=o("p"),kt.textContent=Pa,$i=a(),q=o("div"),p(tt.$$.fragment),Di=a(),Bt=o("p"),Bt.innerHTML=Sa,Ei=a(),O=o("div"),p(nt.$$.fragment),Ri=a(),$t=o("p"),$t.innerHTML=Na,Fi=a(),V=o("div"),p(it.$$.fragment),Xi=a(),Dt=o("p"),Dt.innerHTML=Ya,Pi=a(),Et=o("p"),Et.textContent=Qa,Si=a(),Rt=o("p"),Rt.innerHTML=La,Ni=a(),K=o("div"),p(at.$$.fragment),Yi=a(),Ft=o("p"),Ft.textContent=za,Qi=a(),ee=o("div"),p(st.$$.fragment),Li=a(),Xt=o("p"),Xt.textContent=Ha,zi=a(),te=o("div"),p(ot.$$.fragment),Hi=a(),Pt=o("p"),Pt.textContent=qa,$n=a(),p(lt.$$.fragment),Dn=a(),$=o("div"),p(rt.$$.fragment),qi=a(),St=o("p"),St.textContent=Oa,En=a(),Qt=o("p"),this.h()},l(e){const t=is("svelte-u9bgzb",document.head);g=l(t,"META",{name:!0,content:!0}),t.forEach(i),Z=s(e),y=l(e,"P",{}),T(y).forEach(i),j=s(e),c(x.$$.fragment,e),U=s(e),c(C.$$.fragment,e),Lt=s(e),ae=l(e,"P",{"data-svelte-h":!0}),d(ae)!=="svelte-1heixsu"&&(ae.innerHTML=Ki),zt=s(e),se=l(e,"P",{"data-svelte-h":!0}),d(se)!=="svelte-wu27l3"&&(se.textContent=ea),Ht=s(e),oe=l(e,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-17654bv"&&(oe.innerHTML=ta),qt=s(e),c(le.$$.fragment,e),Ot=s(e),re=l(e,"TABLE",{"data-svelte-h":!0}),d(re)!=="svelte-2pawus"&&(re.innerHTML=na),Kt=s(e),c(de.$$.fragment,e),en=s(e),pe=l(e,"P",{"data-svelte-h":!0}),d(pe)!=="svelte-1eu5pwh"&&(pe.innerHTML=ia),tn=s(e),c(ce.$$.fragment,e),nn=s(e),c(me.$$.fragment,e),an=s(e),fe=l(e,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-q9bvzo"&&(fe.textContent=aa),sn=s(e),ue=l(e,"P",{"data-svelte-h":!0}),d(ue)!=="svelte-o3l8n4"&&(ue.innerHTML=sa),on=s(e),c(he.$$.fragment,e),ln=s(e),ge=l(e,"P",{"data-svelte-h":!0}),d(ge)!=="svelte-1pxzje"&&(ge.textContent=oa),rn=s(e),Me=l(e,"TABLE",{"data-svelte-h":!0}),d(Me)!=="svelte-5250wa"&&(Me.innerHTML=la),dn=s(e),c(E.$$.fragment,e),pn=s(e),c(be.$$.fragment,e),cn=s(e),_e=l(e,"P",{"data-svelte-h":!0}),d(_e)!=="svelte-v5wx3"&&(_e.textContent=ra),mn=s(e),c(ye.$$.fragment,e),fn=s(e),we=l(e,"P",{"data-svelte-h":!0}),d(we)!=="svelte-1pxzje"&&(we.textContent=da),un=s(e),Te=l(e,"TABLE",{"data-svelte-h":!0}),d(Te)!=="svelte-1hj8351"&&(Te.innerHTML=pa),hn=s(e),c(ve.$$.fragment,e),gn=s(e),Je=l(e,"P",{"data-svelte-h":!0}),d(Je)!=="svelte-u1dwwg"&&(Je.innerHTML=ca),Mn=s(e),c(Ue.$$.fragment,e),bn=s(e),je=l(e,"TABLE",{"data-svelte-h":!0}),d(je)!=="svelte-16prig"&&(je.innerHTML=ma),_n=s(e),c(Ze.$$.fragment,e),yn=s(e),Ie=l(e,"P",{"data-svelte-h":!0}),d(Ie)!=="svelte-1gecok3"&&(Ie.innerHTML=fa),wn=s(e),xe=l(e,"P",{"data-svelte-h":!0}),d(xe)!=="svelte-26fcye"&&(xe.textContent=ua),Tn=s(e),c(We.$$.fragment,e),vn=s(e),Ve=l(e,"P",{"data-svelte-h":!0}),d(Ve)!=="svelte-1e37vkb"&&(Ve.textContent=ha),Jn=s(e),c(Ce.$$.fragment,e),Un=s(e),Ge=l(e,"TABLE",{"data-svelte-h":!0}),d(Ge)!=="svelte-3p6096"&&(Ge.innerHTML=ga),jn=s(e),c(Ae.$$.fragment,e),Zn=s(e),ke=l(e,"P",{"data-svelte-h":!0}),d(ke)!=="svelte-a52po1"&&(ke.innerHTML=Ma),In=s(e),Be=l(e,"P",{"data-svelte-h":!0}),d(Be)!=="svelte-i9hpov"&&(Be.textContent=ba),xn=s(e),$e=l(e,"P",{"data-svelte-h":!0}),d($e)!=="svelte-1qq4ux4"&&($e.textContent=_a),Wn=s(e),c(De.$$.fragment,e),Vn=s(e),c(R.$$.fragment,e),Cn=s(e),c(F.$$.fragment,e),Gn=s(e),c(Ee.$$.fragment,e),An=s(e),M=l(e,"DIV",{class:!0});var b=T(M);c(Re.$$.fragment,b),ei=s(b),mt=l(b,"P",{"data-svelte-h":!0}),d(mt)!=="svelte-19ipoo4"&&(mt.textContent=ya),ti=s(b),ft=l(b,"P",{"data-svelte-h":!0}),d(ft)!=="svelte-1wq4yle"&&(ft.innerHTML=wa),ni=s(b),ut=l(b,"P",{"data-svelte-h":!0}),d(ut)!=="svelte-14s6m4u"&&(ut.textContent=Ta),ii=s(b),ht=l(b,"UL",{"data-svelte-h":!0}),d(ht)!=="svelte-lta7tg"&&(ht.innerHTML=va),ai=s(b),A=l(b,"DIV",{class:!0});var D=T(A);c(Fe.$$.fragment,D),si=s(D),gt=l(D,"P",{"data-svelte-h":!0}),d(gt)!=="svelte-50j04k"&&(gt.textContent=Ja),oi=s(D),c(X.$$.fragment,D),D.forEach(i),li=s(b),P=l(b,"DIV",{class:!0});var dt=T(P);c(Xe.$$.fragment,dt),ri=s(dt),Mt=l(dt,"P",{"data-svelte-h":!0}),d(Mt)!=="svelte-14r83"&&(Mt.textContent=Ua),dt.forEach(i),di=s(b),S=l(b,"DIV",{class:!0});var pt=T(S);c(Pe.$$.fragment,pt),pi=s(pt),bt=l(pt,"P",{"data-svelte-h":!0}),d(bt)!=="svelte-psupw6"&&(bt.textContent=ja),pt.forEach(i),ci=s(b),N=l(b,"DIV",{class:!0});var Fn=T(N);c(Se.$$.fragment,Fn),mi=s(Fn),_t=l(Fn,"P",{"data-svelte-h":!0}),d(_t)!=="svelte-1s3c06i"&&(_t.innerHTML=Za),Fn.forEach(i),fi=s(b),Y=l(b,"DIV",{class:!0});var Xn=T(Y);c(Ne.$$.fragment,Xn),ui=s(Xn),yt=l(Xn,"P",{"data-svelte-h":!0}),d(yt)!=="svelte-pkn4ui"&&(yt.innerHTML=Ia),Xn.forEach(i),hi=s(b),k=l(b,"DIV",{class:!0});var Nt=T(k);c(Ye.$$.fragment,Nt),gi=s(Nt),wt=l(Nt,"P",{"data-svelte-h":!0}),d(wt)!=="svelte-1llfxku"&&(wt.innerHTML=xa),Mi=s(Nt),Tt=l(Nt,"P",{"data-svelte-h":!0}),d(Tt)!=="svelte-1adhw15"&&(Tt.innerHTML=Wa),Nt.forEach(i),bi=s(b),W=l(b,"DIV",{class:!0});var ne=T(W);c(Qe.$$.fragment,ne),_i=s(ne),vt=l(ne,"P",{"data-svelte-h":!0}),d(vt)!=="svelte-1f3tmq1"&&(vt.innerHTML=Va),yi=s(ne),Jt=l(ne,"P",{"data-svelte-h":!0}),d(Jt)!=="svelte-xjijlp"&&(Jt.textContent=Ca),wi=s(ne),Ut=l(ne,"P",{"data-svelte-h":!0}),d(Ut)!=="svelte-hy0nzs"&&(Ut.innerHTML=Ga),ne.forEach(i),Ti=s(b),Q=l(b,"DIV",{class:!0});var Pn=T(Q);c(Le.$$.fragment,Pn),vi=s(Pn),jt=l(Pn,"P",{"data-svelte-h":!0}),d(jt)!=="svelte-14bnrb6"&&(jt.textContent=Aa),Pn.forEach(i),Ji=s(b),L=l(b,"DIV",{class:!0});var Sn=T(L);c(ze.$$.fragment,Sn),Ui=s(Sn),Zt=l(Sn,"P",{"data-svelte-h":!0}),d(Zt)!=="svelte-1xwrf7t"&&(Zt.textContent=ka),Sn.forEach(i),ji=s(b),z=l(b,"DIV",{class:!0});var Nn=T(z);c(He.$$.fragment,Nn),Zi=s(Nn),It=l(Nn,"P",{"data-svelte-h":!0}),d(It)!=="svelte-16q0ax1"&&(It.textContent=Ba),Nn.forEach(i),b.forEach(i),kn=s(e),c(qe.$$.fragment,e),Bn=s(e),_=l(e,"DIV",{class:!0});var w=T(_);c(Oe.$$.fragment,w),Ii=s(w),xt=l(w,"P",{"data-svelte-h":!0}),d(xt)!=="svelte-19djzsa"&&(xt.textContent=$a),xi=s(w),Wt=l(w,"P",{"data-svelte-h":!0}),d(Wt)!=="svelte-1wq4yle"&&(Wt.innerHTML=Da),Wi=s(w),Vt=l(w,"P",{"data-svelte-h":!0}),d(Vt)!=="svelte-14s6m4u"&&(Vt.textContent=Ea),Vi=s(w),Ct=l(w,"UL",{"data-svelte-h":!0}),d(Ct)!=="svelte-lta7tg"&&(Ct.innerHTML=Ra),Ci=s(w),B=l(w,"DIV",{class:!0});var Yt=T(B);c(Ke.$$.fragment,Yt),Gi=s(Yt),Gt=l(Yt,"P",{"data-svelte-h":!0}),d(Gt)!=="svelte-50j04k"&&(Gt.textContent=Fa),Ai=s(Yt),At=l(Yt,"P",{"data-svelte-h":!0}),d(At)!=="svelte-kvfsh7"&&(At.textContent=Xa),Yt.forEach(i),ki=s(w),H=l(w,"DIV",{class:!0});var Yn=T(H);c(et.$$.fragment,Yn),Bi=s(Yn),kt=l(Yn,"P",{"data-svelte-h":!0}),d(kt)!=="svelte-psupw6"&&(kt.textContent=Pa),Yn.forEach(i),$i=s(w),q=l(w,"DIV",{class:!0});var Qn=T(q);c(tt.$$.fragment,Qn),Di=s(Qn),Bt=l(Qn,"P",{"data-svelte-h":!0}),d(Bt)!=="svelte-1s3c06i"&&(Bt.innerHTML=Sa),Qn.forEach(i),Ei=s(w),O=l(w,"DIV",{class:!0});var Ln=T(O);c(nt.$$.fragment,Ln),Ri=s(Ln),$t=l(Ln,"P",{"data-svelte-h":!0}),d($t)!=="svelte-pkn4ui"&&($t.innerHTML=Na),Ln.forEach(i),Fi=s(w),V=l(w,"DIV",{class:!0});var ie=T(V);c(it.$$.fragment,ie),Xi=s(ie),Dt=l(ie,"P",{"data-svelte-h":!0}),d(Dt)!=="svelte-1f3tmq1"&&(Dt.innerHTML=Ya),Pi=s(ie),Et=l(ie,"P",{"data-svelte-h":!0}),d(Et)!=="svelte-xjijlp"&&(Et.textContent=Qa),Si=s(ie),Rt=l(ie,"P",{"data-svelte-h":!0}),d(Rt)!=="svelte-hy0nzs"&&(Rt.innerHTML=La),ie.forEach(i),Ni=s(w),K=l(w,"DIV",{class:!0});var zn=T(K);c(at.$$.fragment,zn),Yi=s(zn),Ft=l(zn,"P",{"data-svelte-h":!0}),d(Ft)!=="svelte-14bnrb6"&&(Ft.textContent=za),zn.forEach(i),Qi=s(w),ee=l(w,"DIV",{class:!0});var Hn=T(ee);c(st.$$.fragment,Hn),Li=s(Hn),Xt=l(Hn,"P",{"data-svelte-h":!0}),d(Xt)!=="svelte-1xwrf7t"&&(Xt.textContent=Ha),Hn.forEach(i),zi=s(w),te=l(w,"DIV",{class:!0});var qn=T(te);c(ot.$$.fragment,qn),Hi=s(qn),Pt=l(qn,"P",{"data-svelte-h":!0}),d(Pt)!=="svelte-16q0ax1"&&(Pt.textContent=qa),qn.forEach(i),w.forEach(i),$n=s(e),c(lt.$$.fragment,e),Dn=s(e),$=l(e,"DIV",{class:!0});var On=T($);c(rt.$$.fragment,On),qi=s(On),St=l(On,"P",{"data-svelte-h":!0}),d(St)!=="svelte-8gpkil"&&(St.textContent=Oa),On.forEach(i),En=s(e),Qt=l(e,"P",{}),T(Qt).forEach(i),this.h()},h(){v(g,"name","hf:doc:metadata"),v(g,"content",ps),v(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(_,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){n(document.head,g),r(e,Z,t),r(e,y,t),r(e,j,t),m(x,e,t),r(e,U,t),m(C,e,t),r(e,Lt,t),r(e,ae,t),r(e,zt,t),r(e,se,t),r(e,Ht,t),r(e,oe,t),r(e,qt,t),m(le,e,t),r(e,Ot,t),r(e,re,t),r(e,Kt,t),m(de,e,t),r(e,en,t),r(e,pe,t),r(e,tn,t),m(ce,e,t),r(e,nn,t),m(me,e,t),r(e,an,t),r(e,fe,t),r(e,sn,t),r(e,ue,t),r(e,on,t),m(he,e,t),r(e,ln,t),r(e,ge,t),r(e,rn,t),r(e,Me,t),r(e,dn,t),m(E,e,t),r(e,pn,t),m(be,e,t),r(e,cn,t),r(e,_e,t),r(e,mn,t),m(ye,e,t),r(e,fn,t),r(e,we,t),r(e,un,t),r(e,Te,t),r(e,hn,t),m(ve,e,t),r(e,gn,t),r(e,Je,t),r(e,Mn,t),m(Ue,e,t),r(e,bn,t),r(e,je,t),r(e,_n,t),m(Ze,e,t),r(e,yn,t),r(e,Ie,t),r(e,wn,t),r(e,xe,t),r(e,Tn,t),m(We,e,t),r(e,vn,t),r(e,Ve,t),r(e,Jn,t),m(Ce,e,t),r(e,Un,t),r(e,Ge,t),r(e,jn,t),m(Ae,e,t),r(e,Zn,t),r(e,ke,t),r(e,In,t),r(e,Be,t),r(e,xn,t),r(e,$e,t),r(e,Wn,t),m(De,e,t),r(e,Vn,t),m(R,e,t),r(e,Cn,t),m(F,e,t),r(e,Gn,t),m(Ee,e,t),r(e,An,t),r(e,M,t),m(Re,M,null),n(M,ei),n(M,mt),n(M,ti),n(M,ft),n(M,ni),n(M,ut),n(M,ii),n(M,ht),n(M,ai),n(M,A),m(Fe,A,null),n(A,si),n(A,gt),n(A,oi),m(X,A,null),n(M,li),n(M,P),m(Xe,P,null),n(P,ri),n(P,Mt),n(M,di),n(M,S),m(Pe,S,null),n(S,pi),n(S,bt),n(M,ci),n(M,N),m(Se,N,null),n(N,mi),n(N,_t),n(M,fi),n(M,Y),m(Ne,Y,null),n(Y,ui),n(Y,yt),n(M,hi),n(M,k),m(Ye,k,null),n(k,gi),n(k,wt),n(k,Mi),n(k,Tt),n(M,bi),n(M,W),m(Qe,W,null),n(W,_i),n(W,vt),n(W,yi),n(W,Jt),n(W,wi),n(W,Ut),n(M,Ti),n(M,Q),m(Le,Q,null),n(Q,vi),n(Q,jt),n(M,Ji),n(M,L),m(ze,L,null),n(L,Ui),n(L,Zt),n(M,ji),n(M,z),m(He,z,null),n(z,Zi),n(z,It),r(e,kn,t),m(qe,e,t),r(e,Bn,t),r(e,_,t),m(Oe,_,null),n(_,Ii),n(_,xt),n(_,xi),n(_,Wt),n(_,Wi),n(_,Vt),n(_,Vi),n(_,Ct),n(_,Ci),n(_,B),m(Ke,B,null),n(B,Gi),n(B,Gt),n(B,Ai),n(B,At),n(_,ki),n(_,H),m(et,H,null),n(H,Bi),n(H,kt),n(_,$i),n(_,q),m(tt,q,null),n(q,Di),n(q,Bt),n(_,Ei),n(_,O),m(nt,O,null),n(O,Ri),n(O,$t),n(_,Fi),n(_,V),m(it,V,null),n(V,Xi),n(V,Dt),n(V,Pi),n(V,Et),n(V,Si),n(V,Rt),n(_,Ni),n(_,K),m(at,K,null),n(K,Yi),n(K,Ft),n(_,Qi),n(_,ee),m(st,ee,null),n(ee,Li),n(ee,Xt),n(_,zi),n(_,te),m(ot,te,null),n(te,Hi),n(te,Pt),r(e,$n,t),m(lt,e,t),r(e,Dn,t),r(e,$,t),m(rt,$,null),n($,qi),n($,St),r(e,En,t),r(e,Qt,t),Rn=!0},p(e,[t]){const b={};t&2&&(b.$$scope={dirty:t,ctx:e}),E.$set(b);const D={};t&2&&(D.$$scope={dirty:t,ctx:e}),R.$set(D);const dt={};t&2&&(dt.$$scope={dirty:t,ctx:e}),F.$set(dt);const pt={};t&2&&(pt.$$scope={dirty:t,ctx:e}),X.$set(pt)},i(e){Rn||(f(x.$$.fragment,e),f(C.$$.fragment,e),f(le.$$.fragment,e),f(de.$$.fragment,e),f(ce.$$.fragment,e),f(me.$$.fragment,e),f(he.$$.fragment,e),f(E.$$.fragment,e),f(be.$$.fragment,e),f(ye.$$.fragment,e),f(ve.$$.fragment,e),f(Ue.$$.fragment,e),f(Ze.$$.fragment,e),f(We.$$.fragment,e),f(Ce.$$.fragment,e),f(Ae.$$.fragment,e),f(De.$$.fragment,e),f(R.$$.fragment,e),f(F.$$.fragment,e),f(Ee.$$.fragment,e),f(Re.$$.fragment,e),f(Fe.$$.fragment,e),f(X.$$.fragment,e),f(Xe.$$.fragment,e),f(Pe.$$.fragment,e),f(Se.$$.fragment,e),f(Ne.$$.fragment,e),f(Ye.$$.fragment,e),f(Qe.$$.fragment,e),f(Le.$$.fragment,e),f(ze.$$.fragment,e),f(He.$$.fragment,e),f(qe.$$.fragment,e),f(Oe.$$.fragment,e),f(Ke.$$.fragment,e),f(et.$$.fragment,e),f(tt.$$.fragment,e),f(nt.$$.fragment,e),f(it.$$.fragment,e),f(at.$$.fragment,e),f(st.$$.fragment,e),f(ot.$$.fragment,e),f(lt.$$.fragment,e),f(rt.$$.fragment,e),Rn=!0)},o(e){u(x.$$.fragment,e),u(C.$$.fragment,e),u(le.$$.fragment,e),u(de.$$.fragment,e),u(ce.$$.fragment,e),u(me.$$.fragment,e),u(he.$$.fragment,e),u(E.$$.fragment,e),u(be.$$.fragment,e),u(ye.$$.fragment,e),u(ve.$$.fragment,e),u(Ue.$$.fragment,e),u(Ze.$$.fragment,e),u(We.$$.fragment,e),u(Ce.$$.fragment,e),u(Ae.$$.fragment,e),u(De.$$.fragment,e),u(R.$$.fragment,e),u(F.$$.fragment,e),u(Ee.$$.fragment,e),u(Re.$$.fragment,e),u(Fe.$$.fragment,e),u(X.$$.fragment,e),u(Xe.$$.fragment,e),u(Pe.$$.fragment,e),u(Se.$$.fragment,e),u(Ne.$$.fragment,e),u(Ye.$$.fragment,e),u(Qe.$$.fragment,e),u(Le.$$.fragment,e),u(ze.$$.fragment,e),u(He.$$.fragment,e),u(qe.$$.fragment,e),u(Oe.$$.fragment,e),u(Ke.$$.fragment,e),u(et.$$.fragment,e),u(tt.$$.fragment,e),u(nt.$$.fragment,e),u(it.$$.fragment,e),u(at.$$.fragment,e),u(st.$$.fragment,e),u(ot.$$.fragment,e),u(lt.$$.fragment,e),u(rt.$$.fragment,e),Rn=!1},d(e){e&&(i(Z),i(y),i(j),i(U),i(Lt),i(ae),i(zt),i(se),i(Ht),i(oe),i(qt),i(Ot),i(re),i(Kt),i(en),i(pe),i(tn),i(nn),i(an),i(fe),i(sn),i(ue),i(on),i(ln),i(ge),i(rn),i(Me),i(dn),i(pn),i(cn),i(_e),i(mn),i(fn),i(we),i(un),i(Te),i(hn),i(gn),i(Je),i(Mn),i(bn),i(je),i(_n),i(yn),i(Ie),i(wn),i(xe),i(Tn),i(vn),i(Ve),i(Jn),i(Un),i(Ge),i(jn),i(Zn),i(ke),i(In),i(Be),i(xn),i($e),i(Wn),i(Vn),i(Cn),i(Gn),i(An),i(M),i(kn),i(Bn),i(_),i($n),i(Dn),i($),i(En),i(Qt)),i(g),h(x,e),h(C,e),h(le,e),h(de,e),h(ce,e),h(me,e),h(he,e),h(E,e),h(be,e),h(ye,e),h(ve,e),h(Ue,e),h(Ze,e),h(We,e),h(Ce,e),h(Ae,e),h(De,e),h(R,e),h(F,e),h(Ee,e),h(Re),h(Fe),h(X),h(Xe),h(Pe),h(Se),h(Ne),h(Ye),h(Qe),h(Le),h(ze),h(He),h(qe,e),h(Oe),h(Ke),h(et),h(tt),h(nt),h(it),h(at),h(st),h(ot),h(lt,e),h(rt)}}}const ps='{"title":"Text-to-Video Generation with AnimateDiff","local":"text-to-video-generation-with-animatediff","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Available Pipelines","local":"available-pipelines","sections":[],"depth":2},{"title":"Available checkpoints","local":"available-checkpoints","sections":[],"depth":2},{"title":"Usage example","local":"usage-example","sections":[{"title":"AnimateDiffPipeline","local":"animatediffpipeline","sections":[],"depth":3},{"title":"AnimateDiffVideoToVideoPipeline","local":"animatediffvideotovideopipeline","sections":[],"depth":3}],"depth":2},{"title":"Using Motion LoRAs","local":"using-motion-loras","sections":[],"depth":2},{"title":"Using Motion LoRAs with PEFT","local":"using-motion-loras-with-peft","sections":[],"depth":2},{"title":"Using FreeInit","local":"using-freeinit","sections":[],"depth":2},{"title":"AnimateDiffPipeline","local":"diffusers.AnimateDiffPipeline","sections":[],"depth":2},{"title":"AnimateDiffVideoToVideoPipeline","local":"diffusers.AnimateDiffVideoToVideoPipeline","sections":[],"depth":2},{"title":"AnimateDiffPipelineOutput","local":"diffusers.pipelines.animatediff.AnimateDiffPipelineOutput","sections":[],"depth":2}],"depth":1}';function cs(G){return es(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _s extends ts{constructor(g){super(),ns(this,g,cs,ds,Ka,{})}}export{_s as component};
