import{S as ru,i as iu,s as lu,e as o,k as m,w,t as n,M as cu,c as a,d as t,m as g,a as r,x as T,h as s,b as u,G as e,g as b,y as j,q as J,o as U,B as x,v as du,L as Xe}from"../../chunks/vendor-hf-doc-builder.js";import{T as tt}from"../../chunks/Tip-hf-doc-builder.js";import{D as S}from"../../chunks/Docstring-hf-doc-builder.js";import{C as Re}from"../../chunks/CodeBlock-hf-doc-builder.js";import{I as $a}from"../../chunks/IconCopyLink-hf-doc-builder.js";import{E as Ne}from"../../chunks/ExampleCodeBlock-hf-doc-builder.js";function pu(k){let c,_,p,d,f;return d=new Re({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdlbmVyYXRpb25Db25maWclMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFnZW5lcmF0aW9uX2NvbmZpZyUyMCUzRCUyMEdlbmVyYXRpb25Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmdwdDIlMjIpJTBBJTBBJTIzJTIwRS5nLiUyMGNvbmZpZyUyMHdhcyUyMHNhdmVkJTIwdXNpbmclMjAqc2F2ZV9wcmV0cmFpbmVkKCcuJTJGdGVzdCUyRnNhdmVkX21vZGVsJTJGJykqJTBBZ2VuZXJhdGlvbl9jb25maWcuc2F2ZV9wcmV0cmFpbmVkKCUyMi4lMkZ0ZXN0JTJGc2F2ZWRfbW9kZWwlMkYlMjIpJTBBZ2VuZXJhdGlvbl9jb25maWclMjAlM0QlMjBHZW5lcmF0aW9uQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGdGVzdCUyRnNhdmVkX21vZGVsJTJGJTIyKSUwQSUwQSUyMyUyMFlvdSUyMGNhbiUyMGFsc28lMjBzcGVjaWZ5JTIwY29uZmlndXJhdGlvbiUyMG5hbWVzJTIwdG8lMjB5b3VyJTIwZ2VuZXJhdGlvbiUyMGNvbmZpZ3VyYXRpb24lMjBmaWxlJTBBZ2VuZXJhdGlvbl9jb25maWcuc2F2ZV9wcmV0cmFpbmVkKCUyMi4lMkZ0ZXN0JTJGc2F2ZWRfbW9kZWwlMkYlMjIlMkMlMjBjb25maWdfZmlsZV9uYW1lJTNEJTIybXlfY29uZmlndXJhdGlvbi5qc29uJTIyKSUwQWdlbmVyYXRpb25fY29uZmlnJTIwJTNEJTIwR2VuZXJhdGlvbkNvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRlc3QlMkZzYXZlZF9tb2RlbCUyRiUyMiUyQyUyMCUyMm15X2NvbmZpZ3VyYXRpb24uanNvbiUyMiklMEElMEElMjMlMjBJZiUyMHlvdSdkJTIwbGlrZSUyMHRvJTIwdHJ5JTIwYSUyMG1pbm9yJTIwdmFyaWF0aW9uJTIwdG8lMjBhbiUyMGV4aXN0aW5nJTIwY29uZmlndXJhdGlvbiUyQyUyMHlvdSUyMGNhbiUyMGFsc28lMjBwYXNzJTIwZ2VuZXJhdGlvbiUwQSUyMyUyMGFyZ3VtZW50cyUyMHRvJTIwJTYwLmZyb21fcHJldHJhaW5lZCgpJTYwLiUyMEJlJTIwbWluZGZ1bCUyMHRoYXQlMjB0eXBvcyUyMGFuZCUyMHVudXNlZCUyMGFyZ3VtZW50cyUyMHdpbGwlMjBiZSUyMGlnbm9yZWQlMEFnZW5lcmF0aW9uX2NvbmZpZyUyQyUyMHVudXNlZF9rd2FyZ3MlMjAlM0QlMjBHZW5lcmF0aW9uQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJncHQyJTIyJTJDJTIwdG9wX2slM0QxJTJDJTIwZm9vJTNERmFsc2UlMkMlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTIwcmV0dXJuX3VudXNlZF9rd2FyZ3MlM0RUcnVlJTBBKSUwQWdlbmVyYXRpb25fY29uZmlnLnRvcF9rJTBBJTBBdW51c2VkX2t3YXJncw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GenerationConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config = GenerationConfig.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># E.g. config was saved using *save_pretrained(&#x27;./test/saved_model/&#x27;)*</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config.save_pretrained(<span class="hljs-string">&quot;./test/saved_model/&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config = GenerationConfig.from_pretrained(<span class="hljs-string">&quot;./test/saved_model/&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># You can also specify configuration names to your generation configuration file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config.save_pretrained(<span class="hljs-string">&quot;./test/saved_model/&quot;</span>, config_file_name=<span class="hljs-string">&quot;my_configuration.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config = GenerationConfig.from_pretrained(<span class="hljs-string">&quot;./test/saved_model/&quot;</span>, <span class="hljs-string">&quot;my_configuration.json&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If you&#x27;d like to try a minor variation to an existing configuration, you can also pass generation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># arguments to \`.from_pretrained()\`. Be mindful that typos and unused arguments will be ignored</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config, unused_kwargs = GenerationConfig.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;gpt2&quot;</span>, top_k=<span class="hljs-number">1</span>, foo=<span class="hljs-literal">False</span>, do_sample=<span class="hljs-literal">True</span>, return_unused_kwargs=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config.top_k
<span class="hljs-number">1</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>unused_kwargs
{<span class="hljs-string">&#x27;foo&#x27;</span>: <span class="hljs-literal">False</span>}`}}),{c(){c=o("p"),_=n("Examples:"),p=m(),w(d.$$.fragment)},l(i){c=a(i,"P",{});var h=r(c);_=s(h,"Examples:"),h.forEach(t),p=g(i),T(d.$$.fragment,i)},m(i,h){b(i,c,h),e(c,_),b(i,p,h),j(d,i,h),f=!0},p:Xe,i(i){f||(J(d.$$.fragment,i),f=!0)},o(i){U(d.$$.fragment,i),f=!1},d(i){i&&t(c),i&&t(p),x(d,i)}}}function mu(k){let c,_,p,d,f,i,h,G,v,y,E,B,N,ie,F,q,$;return{c(){c=o("p"),_=n("Most generation-controlling parameters are set in "),p=o("code"),d=n("generation_config"),f=n(` which, if not passed, will be set to the
model\u2019s default generation configuration. You can override any `),i=o("code"),h=n("generation_config"),G=n(` by passing the corresponding
parameters to generate(), e.g. `),v=o("code"),y=n(".generate(inputs, num_beams=4, do_sample=True)"),E=n("."),B=m(),N=o("p"),ie=n("For an overview of generation strategies and code examples, check out the "),F=o("a"),q=n(`following
guide`),$=n("."),this.h()},l(Z){c=a(Z,"P",{});var I=r(c);_=s(I,"Most generation-controlling parameters are set in "),p=a(I,"CODE",{});var P=r(p);d=s(P,"generation_config"),P.forEach(t),f=s(I,` which, if not passed, will be set to the
model\u2019s default generation configuration. You can override any `),i=a(I,"CODE",{});var Ve=r(i);h=s(Ve,"generation_config"),Ve.forEach(t),G=s(I,` by passing the corresponding
parameters to generate(), e.g. `),v=a(I,"CODE",{});var Se=r(v);y=s(Se,".generate(inputs, num_beams=4, do_sample=True)"),Se.forEach(t),E=s(I,"."),I.forEach(t),B=g(Z),N=a(Z,"P",{});var A=r(N);ie=s(A,"For an overview of generation strategies and code examples, check out the "),F=a(A,"A",{href:!0});var $e=r(F);q=s($e,`following
guide`),$e.forEach(t),$=s(A,"."),A.forEach(t),this.h()},h(){u(F,"href","../generation_strategies")},m(Z,I){b(Z,c,I),e(c,_),e(c,p),e(p,d),e(c,f),e(c,i),e(i,h),e(c,G),e(c,v),e(v,y),e(c,E),b(Z,B,I),b(Z,N,I),e(N,ie),e(N,F),e(F,q),e(N,$)},d(Z){Z&&t(c),Z&&t(B),Z&&t(N)}}}function gu(k){let c,_,p,d,f;return d=new Re({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2Tokenizer, AutoModelForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = GPT2Tokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.pad_token_id = tokenizer.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Today is&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Example 1: Print the scores for each token generated with Greedy Search</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">5</span>, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transition_scores = model.compute_transition_scores(
<span class="hljs-meta">... </span>    outputs.sequences, outputs.scores, normalize_logits=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># input_length is the length of the input prompt for decoder-only models, like the GPT family, and 1 for</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># encoder-decoder models, like BART or T5.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_length = <span class="hljs-number">1</span> <span class="hljs-keyword">if</span> model.config.is_encoder_decoder <span class="hljs-keyword">else</span> inputs.input_ids.shape[<span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_tokens = outputs.sequences[:, input_length:]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> tok, score <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(generated_tokens[<span class="hljs-number">0</span>], transition_scores[<span class="hljs-number">0</span>]):
<span class="hljs-meta">... </span>    <span class="hljs-comment"># | token | token string | logits | probability</span>
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;| <span class="hljs-subst">{tok:5d}</span> | <span class="hljs-subst">{tokenizer.decode(tok):8s}</span> | <span class="hljs-subst">{score.numpy():<span class="hljs-number">.3</span>f}</span> | <span class="hljs-subst">{np.exp(score.numpy()):<span class="hljs-number">.2</span>%}</span>&quot;</span>)
|   <span class="hljs-number">262</span> |  the     | -<span class="hljs-number">1.414</span> | <span class="hljs-number">24.33</span>%
|  <span class="hljs-number">1110</span> |  day     | -<span class="hljs-number">2.609</span> | <span class="hljs-number">7.36</span>%
|   <span class="hljs-number">618</span> |  when    | -<span class="hljs-number">2.010</span> | <span class="hljs-number">13.40</span>%
|   <span class="hljs-number">356</span> |  we      | -<span class="hljs-number">1.859</span> | <span class="hljs-number">15.58</span>%
|   <span class="hljs-number">460</span> |  can     | -<span class="hljs-number">2.508</span> | <span class="hljs-number">8.14</span>%

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Example 2: Reconstruct the sequence scores from Beam Search</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">5</span>,
<span class="hljs-meta">... </span>    num_beams=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    return_dict_in_generate=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    output_scores=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transition_scores = model.compute_transition_scores(
<span class="hljs-meta">... </span>    outputs.sequences, outputs.scores, outputs.beam_indices, normalize_logits=<span class="hljs-literal">False</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If you sum the generated tokens&#x27; scores and apply the length penalty, you&#x27;ll get the sequence scores.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Tip: recomputing the scores is only guaranteed to match with \`normalize_logits=False\`. Depending on the</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># use case, you might want to recompute it with \`normalize_logits=True\`.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output_length = input_length + np.<span class="hljs-built_in">sum</span>(transition_scores.numpy() &lt; <span class="hljs-number">0</span>, axis=<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>length_penalty = model.generation_config.length_penalty
<span class="hljs-meta">&gt;&gt;&gt; </span>reconstructed_scores = transition_scores.<span class="hljs-built_in">sum</span>(axis=<span class="hljs-number">1</span>) / (output_length**length_penalty)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(np.allclose(outputs.sequences_scores, reconstructed_scores))
<span class="hljs-literal">True</span>`}}),{c(){c=o("p"),_=n("Examples:"),p=m(),w(d.$$.fragment)},l(i){c=a(i,"P",{});var h=r(c);_=s(h,"Examples:"),h.forEach(t),p=g(i),T(d.$$.fragment,i)},m(i,h){b(i,c,h),e(c,_),b(i,p,h),j(d,i,h),f=!0},p:Xe,i(i){f||(J(d.$$.fragment,i),f=!0)},o(i){U(d.$$.fragment,i),f=!1},d(i){i&&t(c),i&&t(p),x(d,i)}}}function hu(k){let c,_,p,d,f,i,h,G;return{c(){c=o("p"),_=n("In most cases, you do not need to call "),p=o("a"),d=n("greedy_search()"),f=n(` directly. Use generate()
instead. For an overview of generation strategies and code examples, check the `),i=o("a"),h=n(`following
guide`),G=n("."),this.h()},l(v){c=a(v,"P",{});var y=r(c);_=s(y,"In most cases, you do not need to call "),p=a(y,"A",{href:!0});var E=r(p);d=s(E,"greedy_search()"),E.forEach(t),f=s(y,` directly. Use generate()
instead. For an overview of generation strategies and code examples, check the `),i=a(y,"A",{href:!0});var B=r(i);h=s(B,`following
guide`),B.forEach(t),G=s(y,"."),y.forEach(t),this.h()},h(){u(p,"href","/docs/transformers/v4.32.1/en/main_classes/text_generation#transformers.GenerationMixin.greedy_search"),u(i,"href","../generation_strategies")},m(v,y){b(v,c,y),e(c,_),e(c,p),e(p,d),e(c,f),e(c,i),e(i,h),e(c,G)},d(v){v&&t(c)}}}function uu(k){let c,_,p,d,f;return d=new Re({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBBdXRvVG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMEElMjAlMjAlMjAlMjBMb2dpdHNQcm9jZXNzb3JMaXN0JTJDJTBBJTIwJTIwJTIwJTIwTWluTGVuZ3RoTG9naXRzUHJvY2Vzc29yJTJDJTBBJTIwJTIwJTIwJTIwU3RvcHBpbmdDcml0ZXJpYUxpc3QlMkMlMEElMjAlMjAlMjAlMjBNYXhMZW5ndGhDcml0ZXJpYSUyQyUwQSklMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdwdDIlMjIpJTBBJTBBJTIzJTIwc2V0JTIwcGFkX3Rva2VuX2lkJTIwdG8lMjBlb3NfdG9rZW5faWQlMjBiZWNhdXNlJTIwR1BUMiUyMGRvZXMlMjBub3QlMjBoYXZlJTIwYSUyMFBBRCUyMHRva2VuJTBBbW9kZWwuZ2VuZXJhdGlvbl9jb25maWcucGFkX3Rva2VuX2lkJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGlvbl9jb25maWcuZW9zX3Rva2VuX2lkJTBBJTBBaW5wdXRfcHJvbXB0JTIwJTNEJTIwJTIySXQlMjBtaWdodCUyMGJlJTIwcG9zc2libGUlMjB0byUyMiUwQWlucHV0X2lkcyUyMCUzRCUyMHRva2VuaXplcihpbnB1dF9wcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS5pbnB1dF9pZHMlMEElMEElMjMlMjBpbnN0YW50aWF0ZSUyMGxvZ2l0cyUyMHByb2Nlc3NvcnMlMEFsb2dpdHNfcHJvY2Vzc29yJTIwJTNEJTIwTG9naXRzUHJvY2Vzc29yTGlzdCglMEElMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBNaW5MZW5ndGhMb2dpdHNQcm9jZXNzb3IoMTAlMkMlMjBlb3NfdG9rZW5faWQlM0Rtb2RlbC5nZW5lcmF0aW9uX2NvbmZpZy5lb3NfdG9rZW5faWQpJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTBBKSUwQXN0b3BwaW5nX2NyaXRlcmlhJTIwJTNEJTIwU3RvcHBpbmdDcml0ZXJpYUxpc3QoJTVCTWF4TGVuZ3RoQ3JpdGVyaWEobWF4X2xlbmd0aCUzRDIwKSU1RCklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ3JlZWR5X3NlYXJjaCglMEElMjAlMjAlMjAlMjBpbnB1dF9pZHMlMkMlMjBsb2dpdHNfcHJvY2Vzc29yJTNEbG9naXRzX3Byb2Nlc3NvciUyQyUyMHN0b3BwaW5nX2NyaXRlcmlhJTNEc3RvcHBpbmdfY3JpdGVyaWElMEEpJTBBJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    AutoTokenizer,
<span class="hljs-meta">... </span>    AutoModelForCausalLM,
<span class="hljs-meta">... </span>    LogitsProcessorList,
<span class="hljs-meta">... </span>    MinLengthLogitsProcessor,
<span class="hljs-meta">... </span>    StoppingCriteriaList,
<span class="hljs-meta">... </span>    MaxLengthCriteria,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># set pad_token_id to eos_token_id because GPT2 does not have a PAD token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.generation_config.pad_token_id = model.generation_config.eos_token_id

<span class="hljs-meta">&gt;&gt;&gt; </span>input_prompt = <span class="hljs-string">&quot;It might be possible to&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(input_prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate logits processors</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_processor = LogitsProcessorList(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        MinLengthLogitsProcessor(<span class="hljs-number">10</span>, eos_token_id=model.generation_config.eos_token_id),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>stopping_criteria = StoppingCriteriaList([MaxLengthCriteria(max_length=<span class="hljs-number">20</span>)])

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.greedy_search(
<span class="hljs-meta">... </span>    input_ids, logits_processor=logits_processor, stopping_criteria=stopping_criteria
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&quot;It might be possible to get a better understanding of the nature of the problem, but it&#x27;s not&quot;</span>]`}}),{c(){c=o("p"),_=n("Examples:"),p=m(),w(d.$$.fragment)},l(i){c=a(i,"P",{});var h=r(c);_=s(h,"Examples:"),h.forEach(t),p=g(i),T(d.$$.fragment,i)},m(i,h){b(i,c,h),e(c,_),b(i,p,h),j(d,i,h),f=!0},p:Xe,i(i){f||(J(d.$$.fragment,i),f=!0)},o(i){U(d.$$.fragment,i),f=!1},d(i){i&&t(c),i&&t(p),x(d,i)}}}function fu(k){let c,_,p,d,f,i,h,G;return{c(){c=o("p"),_=n("In most cases, you do not need to call "),p=o("a"),d=n("sample()"),f=n(` directly. Use generate() instead.
For an overview of generation strategies and code examples, check the `),i=o("a"),h=n(`following
guide`),G=n("."),this.h()},l(v){c=a(v,"P",{});var y=r(c);_=s(y,"In most cases, you do not need to call "),p=a(y,"A",{href:!0});var E=r(p);d=s(E,"sample()"),E.forEach(t),f=s(y,` directly. Use generate() instead.
For an overview of generation strategies and code examples, check the `),i=a(y,"A",{href:!0});var B=r(i);h=s(B,`following
guide`),B.forEach(t),G=s(y,"."),y.forEach(t),this.h()},h(){u(p,"href","/docs/transformers/v4.32.1/en/main_classes/text_generation#transformers.GenerationMixin.sample"),u(i,"href","../generation_strategies")},m(v,y){b(v,c,y),e(c,_),e(c,p),e(p,d),e(c,f),e(c,i),e(i,h),e(c,G)},d(v){v&&t(c)}}}function _u(k){let c,_,p,d,f;return d=new Re({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    AutoTokenizer,
<span class="hljs-meta">... </span>    AutoModelForCausalLM,
<span class="hljs-meta">... </span>    LogitsProcessorList,
<span class="hljs-meta">... </span>    MinLengthLogitsProcessor,
<span class="hljs-meta">... </span>    TopKLogitsWarper,
<span class="hljs-meta">... </span>    TemperatureLogitsWarper,
<span class="hljs-meta">... </span>    StoppingCriteriaList,
<span class="hljs-meta">... </span>    MaxLengthCriteria,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># set pad_token_id to eos_token_id because GPT2 does not have a EOS token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.pad_token_id = model.config.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>model.generation_config.pad_token_id = model.config.eos_token_id

<span class="hljs-meta">&gt;&gt;&gt; </span>input_prompt = <span class="hljs-string">&quot;Today is a beautiful day, and&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(input_prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate logits processors</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_processor = LogitsProcessorList(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        MinLengthLogitsProcessor(<span class="hljs-number">15</span>, eos_token_id=model.generation_config.eos_token_id),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate logits processors</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_warper = LogitsProcessorList(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        TopKLogitsWarper(<span class="hljs-number">50</span>),
<span class="hljs-meta">... </span>        TemperatureLogitsWarper(<span class="hljs-number">0.7</span>),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>stopping_criteria = StoppingCriteriaList([MaxLengthCriteria(max_length=<span class="hljs-number">20</span>)])

<span class="hljs-meta">&gt;&gt;&gt; </span>torch.manual_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.sample(
<span class="hljs-meta">... </span>    input_ids,
<span class="hljs-meta">... </span>    logits_processor=logits_processor,
<span class="hljs-meta">... </span>    logits_warper=logits_warper,
<span class="hljs-meta">... </span>    stopping_criteria=stopping_criteria,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;Today is a beautiful day, and we must do everything possible to make it a day of celebration.&#x27;</span>]`}}),{c(){c=o("p"),_=n("Examples:"),p=m(),w(d.$$.fragment)},l(i){c=a(i,"P",{});var h=r(c);_=s(h,"Examples:"),h.forEach(t),p=g(i),T(d.$$.fragment,i)},m(i,h){b(i,c,h),e(c,_),b(i,p,h),j(d,i,h),f=!0},p:Xe,i(i){f||(J(d.$$.fragment,i),f=!0)},o(i){U(d.$$.fragment,i),f=!1},d(i){i&&t(c),i&&t(p),x(d,i)}}}function yu(k){let c,_,p,d,f,i,h,G;return{c(){c=o("p"),_=n("In most cases, you do not need to call "),p=o("a"),d=n("beam_search()"),f=n(` directly. Use generate()
instead. For an overview of generation strategies and code examples, check the `),i=o("a"),h=n(`following
guide`),G=n("."),this.h()},l(v){c=a(v,"P",{});var y=r(c);_=s(y,"In most cases, you do not need to call "),p=a(y,"A",{href:!0});var E=r(p);d=s(E,"beam_search()"),E.forEach(t),f=s(y,` directly. Use generate()
instead. For an overview of generation strategies and code examples, check the `),i=a(y,"A",{href:!0});var B=r(i);h=s(B,`following
guide`),B.forEach(t),G=s(y,"."),y.forEach(t),this.h()},h(){u(p,"href","/docs/transformers/v4.32.1/en/main_classes/text_generation#transformers.GenerationMixin.beam_search"),u(i,"href","../generation_strategies")},m(v,y){b(v,c,y),e(c,_),e(c,p),e(p,d),e(c,f),e(c,i),e(i,h),e(c,G)},d(v){v&&t(c)}}}function Mu(k){let c,_,p,d,f;return d=new Re({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    AutoTokenizer,
<span class="hljs-meta">... </span>    AutoModelForSeq2SeqLM,
<span class="hljs-meta">... </span>    LogitsProcessorList,
<span class="hljs-meta">... </span>    MinLengthLogitsProcessor,
<span class="hljs-meta">... </span>    BeamSearchScorer,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>encoder_input_str = <span class="hljs-string">&quot;translate English to German: How old are you?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoder_input_ids = tokenizer(encoder_input_str, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># lets run beam search using 3 beams</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_beams = <span class="hljs-number">3</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># define decoder start token ids</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = torch.ones((num_beams, <span class="hljs-number">1</span>), device=model.device, dtype=torch.long)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = input_ids * model.config.decoder_start_token_id

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># add encoder_outputs to model keyword arguments</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_kwargs = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;encoder_outputs&quot;</span>: model.get_encoder()(
<span class="hljs-meta">... </span>        encoder_input_ids.repeat_interleave(num_beams, dim=<span class="hljs-number">0</span>), return_dict=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>}

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate beam scorer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>beam_scorer = BeamSearchScorer(
<span class="hljs-meta">... </span>    batch_size=<span class="hljs-number">1</span>,
<span class="hljs-meta">... </span>    num_beams=num_beams,
<span class="hljs-meta">... </span>    device=model.device,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate logits processors</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_processor = LogitsProcessorList(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        MinLengthLogitsProcessor(<span class="hljs-number">5</span>, eos_token_id=model.config.eos_token_id),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.beam_search(input_ids, beam_scorer, logits_processor=logits_processor, **model_kwargs)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;Wie alt bist du?&#x27;</span>]`}}),{c(){c=o("p"),_=n("Examples:"),p=m(),w(d.$$.fragment)},l(i){c=a(i,"P",{});var h=r(c);_=s(h,"Examples:"),h.forEach(t),p=g(i),T(d.$$.fragment,i)},m(i,h){b(i,c,h),e(c,_),b(i,p,h),j(d,i,h),f=!0},p:Xe,i(i){f||(J(d.$$.fragment,i),f=!0)},o(i){U(d.$$.fragment,i),f=!1},d(i){i&&t(c),i&&t(p),x(d,i)}}}function bu(k){let c,_,p,d,f,i,h,G;return{c(){c=o("p"),_=n("In most cases, you do not need to call "),p=o("a"),d=n("beam_sample()"),f=n(` directly. Use generate()
instead. For an overview of generation strategies and code examples, check the `),i=o("a"),h=n(`following
guide`),G=n("."),this.h()},l(v){c=a(v,"P",{});var y=r(c);_=s(y,"In most cases, you do not need to call "),p=a(y,"A",{href:!0});var E=r(p);d=s(E,"beam_sample()"),E.forEach(t),f=s(y,` directly. Use generate()
instead. For an overview of generation strategies and code examples, check the `),i=a(y,"A",{href:!0});var B=r(i);h=s(B,`following
guide`),B.forEach(t),G=s(y,"."),y.forEach(t),this.h()},h(){u(p,"href","/docs/transformers/v4.32.1/en/main_classes/text_generation#transformers.GenerationMixin.beam_sample"),u(i,"href","../generation_strategies")},m(v,y){b(v,c,y),e(c,_),e(c,p),e(p,d),e(c,f),e(c,i),e(i,h),e(c,G)},d(v){v&&t(c)}}}function vu(k){let c,_,p,d,f;return d=new Re({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    AutoTokenizer,
<span class="hljs-meta">... </span>    AutoModelForSeq2SeqLM,
<span class="hljs-meta">... </span>    LogitsProcessorList,
<span class="hljs-meta">... </span>    MinLengthLogitsProcessor,
<span class="hljs-meta">... </span>    TopKLogitsWarper,
<span class="hljs-meta">... </span>    TemperatureLogitsWarper,
<span class="hljs-meta">... </span>    BeamSearchScorer,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>encoder_input_str = <span class="hljs-string">&quot;translate English to German: How old are you?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoder_input_ids = tokenizer(encoder_input_str, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># lets run beam search using 3 beams</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_beams = <span class="hljs-number">3</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># define decoder start token ids</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = torch.ones((num_beams, <span class="hljs-number">1</span>), device=model.device, dtype=torch.long)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = input_ids * model.config.decoder_start_token_id

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># add encoder_outputs to model keyword arguments</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_kwargs = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;encoder_outputs&quot;</span>: model.get_encoder()(
<span class="hljs-meta">... </span>        encoder_input_ids.repeat_interleave(num_beams, dim=<span class="hljs-number">0</span>), return_dict=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>}

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate beam scorer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>beam_scorer = BeamSearchScorer(
<span class="hljs-meta">... </span>    batch_size=<span class="hljs-number">1</span>,
<span class="hljs-meta">... </span>    max_length=model.config.max_length,
<span class="hljs-meta">... </span>    num_beams=num_beams,
<span class="hljs-meta">... </span>    device=model.device,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate logits processors</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_processor = LogitsProcessorList(
<span class="hljs-meta">... </span>    [MinLengthLogitsProcessor(<span class="hljs-number">5</span>, eos_token_id=model.config.eos_token_id)]
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate logits processors</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_warper = LogitsProcessorList(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        TopKLogitsWarper(<span class="hljs-number">50</span>),
<span class="hljs-meta">... </span>        TemperatureLogitsWarper(<span class="hljs-number">0.7</span>),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.beam_sample(
<span class="hljs-meta">... </span>    input_ids, beam_scorer, logits_processor=logits_processor, logits_warper=logits_warper, **model_kwargs
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;Wie alt bist du?&#x27;</span>]`}}),{c(){c=o("p"),_=n("Examples:"),p=m(),w(d.$$.fragment)},l(i){c=a(i,"P",{});var h=r(c);_=s(h,"Examples:"),h.forEach(t),p=g(i),T(d.$$.fragment,i)},m(i,h){b(i,c,h),e(c,_),b(i,p,h),j(d,i,h),f=!0},p:Xe,i(i){f||(J(d.$$.fragment,i),f=!0)},o(i){U(d.$$.fragment,i),f=!1},d(i){i&&t(c),i&&t(p),x(d,i)}}}function wu(k){let c,_,p,d,f,i,h,G;return{c(){c=o("p"),_=n("In most cases, you do not need to call "),p=o("a"),d=n("contrastive_search()"),f=n(` directly. Use
generate() instead. For an overview of generation strategies and code examples, check the `),i=o("a"),h=n(`following
guide`),G=n("."),this.h()},l(v){c=a(v,"P",{});var y=r(c);_=s(y,"In most cases, you do not need to call "),p=a(y,"A",{href:!0});var E=r(p);d=s(E,"contrastive_search()"),E.forEach(t),f=s(y,` directly. Use
generate() instead. For an overview of generation strategies and code examples, check the `),i=a(y,"A",{href:!0});var B=r(i);h=s(B,`following
guide`),B.forEach(t),G=s(y,"."),y.forEach(t),this.h()},h(){u(p,"href","/docs/transformers/v4.32.1/en/main_classes/text_generation#transformers.GenerationMixin.contrastive_search"),u(i,"href","../generation_strategies")},m(v,y){b(v,c,y),e(c,_),e(c,p),e(p,d),e(c,f),e(c,i),e(i,h),e(c,G)},d(v){v&&t(c)}}}function Tu(k){let c,_,p,d,f;return d=new Re({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBBdXRvVG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMEElMjAlMjAlMjAlMjBTdG9wcGluZ0NyaXRlcmlhTGlzdCUyQyUwQSUyMCUyMCUyMCUyME1heExlbmd0aENyaXRlcmlhJTJDJTBBKSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTEyNW0lMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMTI1bSUyMiklMEElMjMlMjBzZXQlMjBwYWRfdG9rZW5faWQlMjB0byUyMGVvc190b2tlbl9pZCUyMGJlY2F1c2UlMjBPUFQlMjBkb2VzJTIwbm90JTIwaGF2ZSUyMGElMjBQQUQlMjB0b2tlbiUwQW1vZGVsLmNvbmZpZy5wYWRfdG9rZW5faWQlMjAlM0QlMjBtb2RlbC5jb25maWcuZW9zX3Rva2VuX2lkJTBBaW5wdXRfcHJvbXB0JTIwJTNEJTIwJTIyRGVlcE1pbmQlMjBDb21wYW55JTIwaXMlMjIlMEFpbnB1dF9pZHMlMjAlM0QlMjB0b2tlbml6ZXIoaW5wdXRfcHJvbXB0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFzdG9wcGluZ19jcml0ZXJpYSUyMCUzRCUyMFN0b3BwaW5nQ3JpdGVyaWFMaXN0KCU1Qk1heExlbmd0aENyaXRlcmlhKG1heF9sZW5ndGglM0Q2NCklNUQpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmNvbnRyYXN0aXZlX3NlYXJjaCglMEElMjAlMjAlMjAlMjAqKmlucHV0X2lkcyUyQyUyMHBlbmFsdHlfYWxwaGElM0QwLjYlMkMlMjB0b3BfayUzRDQlMkMlMjBzdG9wcGluZ19jcml0ZXJpYSUzRHN0b3BwaW5nX2NyaXRlcmlhJTBBKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    AutoTokenizer,
<span class="hljs-meta">... </span>    AutoModelForCausalLM,
<span class="hljs-meta">... </span>    StoppingCriteriaList,
<span class="hljs-meta">... </span>    MaxLengthCriteria,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-125m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-125m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># set pad_token_id to eos_token_id because OPT does not have a PAD token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.pad_token_id = model.config.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>input_prompt = <span class="hljs-string">&quot;DeepMind Company is&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(input_prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>stopping_criteria = StoppingCriteriaList([MaxLengthCriteria(max_length=<span class="hljs-number">64</span>)])
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.contrastive_search(
<span class="hljs-meta">... </span>    **input_ids, penalty_alpha=<span class="hljs-number">0.6</span>, top_k=<span class="hljs-number">4</span>, stopping_criteria=stopping_criteria
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;DeepMind Company is a company that focuses on the development and commercialization of artificial intelligence (AI). DeepMind\u2019s mission is to help people understand and solve problems that are difficult to solve in the world today.\\n\\nIn this post, we talk about the benefits of deep learning in business and how it&#x27;</span>]`}}),{c(){c=o("p"),_=n("Examples:"),p=m(),w(d.$$.fragment)},l(i){c=a(i,"P",{});var h=r(c);_=s(h,"Examples:"),h.forEach(t),p=g(i),T(d.$$.fragment,i)},m(i,h){b(i,c,h),e(c,_),b(i,p,h),j(d,i,h),f=!0},p:Xe,i(i){f||(J(d.$$.fragment,i),f=!0)},o(i){U(d.$$.fragment,i),f=!1},d(i){i&&t(c),i&&t(p),x(d,i)}}}function ju(k){let c,_,p,d,f,i,h,G;return{c(){c=o("p"),_=n("In most cases, you do not need to call "),p=o("a"),d=n("group_beam_search()"),f=n(` directly. Use
generate() instead. For an overview of generation strategies and code examples, check the `),i=o("a"),h=n(`following
guide`),G=n("."),this.h()},l(v){c=a(v,"P",{});var y=r(c);_=s(y,"In most cases, you do not need to call "),p=a(y,"A",{href:!0});var E=r(p);d=s(E,"group_beam_search()"),E.forEach(t),f=s(y,` directly. Use
generate() instead. For an overview of generation strategies and code examples, check the `),i=a(y,"A",{href:!0});var B=r(i);h=s(B,`following
guide`),B.forEach(t),G=s(y,"."),y.forEach(t),this.h()},h(){u(p,"href","/docs/transformers/v4.32.1/en/main_classes/text_generation#transformers.GenerationMixin.group_beam_search"),u(i,"href","../generation_strategies")},m(v,y){b(v,c,y),e(c,_),e(c,p),e(p,d),e(c,f),e(c,i),e(i,h),e(c,G)},d(v){v&&t(c)}}}function Ju(k){let c,_,p,d,f;return d=new Re({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    AutoTokenizer,
<span class="hljs-meta">... </span>    AutoModelForSeq2SeqLM,
<span class="hljs-meta">... </span>    LogitsProcessorList,
<span class="hljs-meta">... </span>    MinLengthLogitsProcessor,
<span class="hljs-meta">... </span>    HammingDiversityLogitsProcessor,
<span class="hljs-meta">... </span>    BeamSearchScorer,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>encoder_input_str = <span class="hljs-string">&quot;translate English to German: How old are you?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoder_input_ids = tokenizer(encoder_input_str, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># lets run diverse beam search using 6 beams</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_beams = <span class="hljs-number">6</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># define decoder start token ids</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = torch.ones((num_beams, <span class="hljs-number">1</span>), device=model.device, dtype=torch.long)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = input_ids * model.config.decoder_start_token_id

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># add encoder_outputs to model keyword arguments</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_kwargs = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;encoder_outputs&quot;</span>: model.get_encoder()(
<span class="hljs-meta">... </span>        encoder_input_ids.repeat_interleave(num_beams, dim=<span class="hljs-number">0</span>), return_dict=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>}

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate beam scorer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>beam_scorer = BeamSearchScorer(
<span class="hljs-meta">... </span>    batch_size=<span class="hljs-number">1</span>,
<span class="hljs-meta">... </span>    max_length=model.config.max_length,
<span class="hljs-meta">... </span>    num_beams=num_beams,
<span class="hljs-meta">... </span>    device=model.device,
<span class="hljs-meta">... </span>    num_beam_groups=<span class="hljs-number">3</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate logits processors</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_processor = LogitsProcessorList(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        HammingDiversityLogitsProcessor(<span class="hljs-number">5.5</span>, num_beams=<span class="hljs-number">6</span>, num_beam_groups=<span class="hljs-number">3</span>),
<span class="hljs-meta">... </span>        MinLengthLogitsProcessor(<span class="hljs-number">5</span>, eos_token_id=model.config.eos_token_id),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.group_beam_search(
<span class="hljs-meta">... </span>    input_ids, beam_scorer, logits_processor=logits_processor, **model_kwargs
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;Wie alt bist du?&#x27;</span>]`}}),{c(){c=o("p"),_=n("Examples:"),p=m(),w(d.$$.fragment)},l(i){c=a(i,"P",{});var h=r(c);_=s(h,"Examples:"),h.forEach(t),p=g(i),T(d.$$.fragment,i)},m(i,h){b(i,c,h),e(c,_),b(i,p,h),j(d,i,h),f=!0},p:Xe,i(i){f||(J(d.$$.fragment,i),f=!0)},o(i){U(d.$$.fragment,i),f=!1},d(i){i&&t(c),i&&t(p),x(d,i)}}}function Uu(k){let c,_,p,d,f,i,h,G;return{c(){c=o("p"),_=n("In most cases, you do not need to call "),p=o("a"),d=n("constrained_beam_search()"),f=n(` directly. Use
generate() instead. For an overview of generation strategies and code examples, check the `),i=o("a"),h=n(`following
guide`),G=n("."),this.h()},l(v){c=a(v,"P",{});var y=r(c);_=s(y,"In most cases, you do not need to call "),p=a(y,"A",{href:!0});var E=r(p);d=s(E,"constrained_beam_search()"),E.forEach(t),f=s(y,` directly. Use
generate() instead. For an overview of generation strategies and code examples, check the `),i=a(y,"A",{href:!0});var B=r(i);h=s(B,`following
guide`),B.forEach(t),G=s(y,"."),y.forEach(t),this.h()},h(){u(p,"href","/docs/transformers/v4.32.1/en/main_classes/text_generation#transformers.GenerationMixin.constrained_beam_search"),u(i,"href","../generation_strategies")},m(v,y){b(v,c,y),e(c,_),e(c,p),e(p,d),e(c,f),e(c,i),e(i,h),e(c,G)},d(v){v&&t(c)}}}function xu(k){let c,_,p,d,f;return d=new Re({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    AutoTokenizer,
<span class="hljs-meta">... </span>    AutoModelForSeq2SeqLM,
<span class="hljs-meta">... </span>    LogitsProcessorList,
<span class="hljs-meta">... </span>    MinLengthLogitsProcessor,
<span class="hljs-meta">... </span>    ConstrainedBeamSearchScorer,
<span class="hljs-meta">... </span>    PhrasalConstraint,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>encoder_input_str = <span class="hljs-string">&quot;translate English to German: How old are you?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoder_input_ids = tokenizer(encoder_input_str, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># lets run beam search using 3 beams</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_beams = <span class="hljs-number">3</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># define decoder start token ids</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = torch.ones((num_beams, <span class="hljs-number">1</span>), device=model.device, dtype=torch.long)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = input_ids * model.config.decoder_start_token_id

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># add encoder_outputs to model keyword arguments</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_kwargs = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;encoder_outputs&quot;</span>: model.get_encoder()(
<span class="hljs-meta">... </span>        encoder_input_ids.repeat_interleave(num_beams, dim=<span class="hljs-number">0</span>), return_dict=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>}

<span class="hljs-meta">&gt;&gt;&gt; </span>constraint_str = <span class="hljs-string">&quot;Sie&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>constraint_token_ids = tokenizer.encode(constraint_str)[:-<span class="hljs-number">1</span>]  <span class="hljs-comment"># slice to remove eos token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>constraints = [PhrasalConstraint(token_ids=constraint_token_ids)]


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate beam scorer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>beam_scorer = ConstrainedBeamSearchScorer(
<span class="hljs-meta">... </span>    batch_size=<span class="hljs-number">1</span>, num_beams=num_beams, device=model.device, constraints=constraints
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate logits processors</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_processor = LogitsProcessorList(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        MinLengthLogitsProcessor(<span class="hljs-number">5</span>, eos_token_id=model.config.eos_token_id),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.constrained_beam_search(
<span class="hljs-meta">... </span>    input_ids, beam_scorer, constraints=constraints, logits_processor=logits_processor, **model_kwargs
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;Wie alt sind Sie?&#x27;</span>]`}}),{c(){c=o("p"),_=n("Examples:"),p=m(),w(d.$$.fragment)},l(i){c=a(i,"P",{});var h=r(c);_=s(h,"Examples:"),h.forEach(t),p=g(i),T(d.$$.fragment,i)},m(i,h){b(i,c,h),e(c,_),b(i,p,h),j(d,i,h),f=!0},p:Xe,i(i){f||(J(d.$$.fragment,i),f=!0)},o(i){U(d.$$.fragment,i),f=!1},d(i){i&&t(c),i&&t(p),x(d,i)}}}function Gu(k){let c,_,p,d,f,i,h,G,v,y,E,B,N,ie,F,q,$;return{c(){c=o("p"),_=n("Most generation-controlling parameters are set in "),p=o("code"),d=n("generation_config"),f=n(` which, if not passed, will be set to the
model\u2019s default generation configuration. You can override any `),i=o("code"),h=n("generation_config"),G=n(` by passing the corresponding
parameters to generate, e.g. `),v=o("code"),y=n(".generate(inputs, num_beams=4, do_sample=True)"),E=n("."),B=m(),N=o("p"),ie=n("For an overview of generation strategies and code examples, check out the "),F=o("a"),q=n(`following
guide`),$=n("."),this.h()},l(Z){c=a(Z,"P",{});var I=r(c);_=s(I,"Most generation-controlling parameters are set in "),p=a(I,"CODE",{});var P=r(p);d=s(P,"generation_config"),P.forEach(t),f=s(I,` which, if not passed, will be set to the
model\u2019s default generation configuration. You can override any `),i=a(I,"CODE",{});var Ve=r(i);h=s(Ve,"generation_config"),Ve.forEach(t),G=s(I,` by passing the corresponding
parameters to generate, e.g. `),v=a(I,"CODE",{});var Se=r(v);y=s(Se,".generate(inputs, num_beams=4, do_sample=True)"),Se.forEach(t),E=s(I,"."),I.forEach(t),B=g(Z),N=a(Z,"P",{});var A=r(N);ie=s(A,"For an overview of generation strategies and code examples, check out the "),F=a(A,"A",{href:!0});var $e=r(F);q=s($e,`following
guide`),$e.forEach(t),$=s(A,"."),A.forEach(t),this.h()},h(){u(F,"href","../generation_strategies")},m(Z,I){b(Z,c,I),e(c,_),e(c,p),e(p,d),e(c,f),e(c,i),e(i,h),e(c,G),e(c,v),e(v,y),e(c,E),b(Z,B,I),b(Z,N,I),e(N,ie),e(N,F),e(F,q),e(N,$)},d(Z){Z&&t(c),Z&&t(B),Z&&t(N)}}}function ku(k){let c,_,p,d,f;return d=new Re({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2Tokenizer, TFAutoModelForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = GPT2Tokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.pad_token_id = tokenizer.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Today is&quot;</span>], return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Example 1: Print the scores for each token generated with Greedy Search</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">5</span>, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transition_scores = model.compute_transition_scores(
<span class="hljs-meta">... </span>    outputs.sequences, outputs.scores, normalize_logits=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># input_length is the length of the input prompt for decoder-only models, like the GPT family, and 1 for</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># encoder-decoder models, like BART or T5.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_length = <span class="hljs-number">1</span> <span class="hljs-keyword">if</span> model.config.is_encoder_decoder <span class="hljs-keyword">else</span> inputs.input_ids.shape[<span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_tokens = outputs.sequences[:, input_length:]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> tok, score <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(generated_tokens[<span class="hljs-number">0</span>], transition_scores[<span class="hljs-number">0</span>]):
<span class="hljs-meta">... </span>    <span class="hljs-comment"># | token | token string | logits | probability</span>
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;| <span class="hljs-subst">{tok:5d}</span> | <span class="hljs-subst">{tokenizer.decode(tok):8s}</span> | <span class="hljs-subst">{score.numpy():<span class="hljs-number">.3</span>f}</span> | <span class="hljs-subst">{np.exp(score.numpy()):<span class="hljs-number">.2</span>%}</span>&quot;</span>)
|   <span class="hljs-number">262</span> |  the     | -<span class="hljs-number">1.413</span> | <span class="hljs-number">24.33</span>%
|  <span class="hljs-number">1110</span> |  day     | -<span class="hljs-number">2.609</span> | <span class="hljs-number">7.36</span>%
|   <span class="hljs-number">618</span> |  when    | -<span class="hljs-number">2.009</span> | <span class="hljs-number">13.41</span>%
|   <span class="hljs-number">356</span> |  we      | -<span class="hljs-number">1.859</span> | <span class="hljs-number">15.58</span>%
|   <span class="hljs-number">460</span> |  can     | -<span class="hljs-number">2.508</span> | <span class="hljs-number">8.14</span>%

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Example 2: Reconstruct the sequence scores from Beam Search</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">5</span>,
<span class="hljs-meta">... </span>    num_beams=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    return_dict_in_generate=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    output_scores=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transition_scores = model.compute_transition_scores(
<span class="hljs-meta">... </span>    outputs.sequences, outputs.scores, outputs.beam_indices, normalize_logits=<span class="hljs-literal">False</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If you sum the generated tokens&#x27; scores and apply the length penalty, you&#x27;ll get the sequence scores.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Tip: recomputing the scores is only guaranteed to match with \`normalize_logits=False\`. Depending on the</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># use case, you might want to recompute it with \`normalize_logits=True\`.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output_length = input_length + np.<span class="hljs-built_in">sum</span>(transition_scores.numpy() &lt; <span class="hljs-number">0</span>, axis=<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>length_penalty = model.generation_config.length_penalty
<span class="hljs-meta">&gt;&gt;&gt; </span>reconstructed_scores = np.<span class="hljs-built_in">sum</span>(transition_scores, axis=<span class="hljs-number">1</span>) / (output_length**length_penalty)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(np.allclose(outputs.sequences_scores, reconstructed_scores))
<span class="hljs-literal">True</span>`}}),{c(){c=o("p"),_=n("Examples:"),p=m(),w(d.$$.fragment)},l(i){c=a(i,"P",{});var h=r(c);_=s(h,"Examples:"),h.forEach(t),p=g(i),T(d.$$.fragment,i)},m(i,h){b(i,c,h),e(c,_),b(i,p,h),j(d,i,h),f=!0},p:Xe,i(i){f||(J(d.$$.fragment,i),f=!0)},o(i){U(d.$$.fragment,i),f=!1},d(i){i&&t(c),i&&t(p),x(d,i)}}}function Eu(k){let c,_,p,d,f,i,h,G,v,y,E,B,N,ie,F,q,$,Z,I,P,Ve,Se,A,$e,Jr,Ur,Fe,xr,Pn,Gr,kr,Kn,Er,Br,Zr,ze,Cr,es,Ir,Wr,ts,Nr,Xr,Fa,nt,Rr,ns,Vr,Sr,za,st,$r,ss,Fr,zr,La,Le,ot,Fs,an,Lr,zs,Ar,Aa,X,rn,Qr,ln,Dr,Ls,Yr,Or,Hr,R,le,As,qr,Pr,os,Kr,ei,Qs,ti,ni,Ds,si,oi,ce,Ys,ai,ri,as,ii,li,Os,ci,di,Hs,pi,mi,de,qs,gi,hi,rs,ui,fi,Ps,_i,yi,Ks,Mi,bi,pe,eo,vi,wi,is,Ti,ji,to,Ji,Ui,no,xi,Gi,me,so,ki,Ei,ls,Bi,Zi,oo,Ci,Ii,ao,Wi,Ni,ge,ro,Xi,Ri,cs,Vi,Si,io,$i,Fi,lo,zi,Li,he,co,Ai,Qi,ds,Di,Yi,po,Oi,Hi,mo,qi,Pi,ue,go,Ki,el,ho,tl,nl,uo,sl,ol,fo,al,rl,cn,il,ps,ll,cl,dl,Ee,dn,pl,pn,ml,ms,gl,hl,ul,at,fl,rt,mn,_l,H,yl,gs,Ml,bl,hs,vl,wl,us,Tl,jl,fs,Jl,Ul,xl,it,gn,Gl,Ae,kl,_o,El,Bl,_s,Zl,Cl,Qa,Qe,lt,yo,hn,Il,Mo,Wl,Da,C,un,Nl,fn,Xl,ys,Rl,Vl,Sl,_n,$l,Ms,Fl,zl,Ll,z,fe,bo,Al,Ql,bs,Dl,Yl,vo,Ol,Hl,wo,ql,Pl,_e,To,Kl,ec,vs,tc,nc,jo,sc,oc,Jo,ac,rc,ye,Uo,ic,lc,ws,cc,dc,xo,pc,mc,Go,gc,hc,Me,ko,uc,fc,Ts,_c,yc,Eo,Mc,bc,Bo,vc,wc,be,Zo,Tc,jc,js,Jc,Uc,Co,xc,Gc,Io,kc,Ec,ve,Wo,Bc,Zc,Js,Cc,Ic,No,Wc,Nc,Xo,Xc,Rc,we,Ro,Vc,Sc,Us,$c,Fc,Vo,zc,Lc,So,Ac,Qc,yn,Dc,xs,Yc,Oc,Hc,Be,Mn,qc,$o,Pc,Kc,ct,ed,Ze,bn,td,Fo,nd,sd,dt,od,K,vn,ad,wn,rd,zo,id,ld,cd,pt,dd,mt,pd,ee,Tn,md,jn,gd,Lo,hd,ud,fd,gt,_d,ht,yd,te,Jn,Md,Un,bd,Ao,vd,wd,Td,ut,jd,ft,Jd,ne,xn,Ud,Gn,xd,Qo,Gd,kd,Ed,_t,Bd,yt,Zd,se,kn,Cd,En,Id,Do,Wd,Nd,Xd,Mt,Rd,bt,Vd,oe,Bn,Sd,Zn,$d,Yo,Fd,zd,Ld,vt,Ad,wt,Qd,ae,Cn,Dd,In,Yd,Oo,Od,Hd,qd,Tt,Pd,jt,Ya,De,Jt,Ho,Wn,Kd,qo,ep,Oa,V,Nn,tp,Xn,np,Gs,sp,op,ap,Rn,rp,ks,ip,lp,cp,Te,je,Po,dp,pp,Ko,mp,gp,ea,hp,up,ta,fp,_p,Je,na,yp,Mp,sa,bp,vp,oa,wp,Tp,aa,jp,Jp,Ue,ra,Up,xp,ia,Gp,kp,la,Ep,Bp,ca,Zp,Cp,Ye,da,Ip,Wp,pa,Np,Xp,ma,Rp,Vp,Vn,Sp,Es,$p,Fp,zp,Ce,Sn,Lp,ga,Ap,Qp,Ut,Dp,Ie,$n,Yp,ha,Op,Hp,xt,Ha,Oe,Gt,ua,Fn,qp,fa,Pp,qa,L,zn,Kp,Ln,em,Bs,tm,nm,sm,An,om,Zs,am,rm,im,He,xe,_a,lm,cm,ya,dm,pm,Ma,mm,gm,ba,hm,um,Ge,va,fm,_m,wa,ym,Mm,Ta,bm,vm,ja,wm,Tm,ke,Ja,jm,Jm,Ua,Um,xm,xa,Gm,km,Ga,Em,Bm,Qn,Zm,Cs,Cm,Im,Wm,kt,Dn,Nm,ka,Xm,Pa;return i=new $a({}),an=new $a({}),rn=new S({props:{name:"class transformers.GenerationConfig",anchor:"transformers.GenerationConfig",parameters:[{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/configuration_utils.py#L39",parameterGroups:[{title:"Parameters that control the length of the output",parametersDescription:[{anchor:"transformers.GenerationConfig.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
The maximum length the generated tokens can have. Corresponds to the length of the input prompt +
<code>max_new_tokens</code>. Its effect is overridden by <code>max_new_tokens</code>, if also set.`,name:"max_length"},{anchor:"transformers.GenerationConfig.max_new_tokens",description:`<strong>max_new_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum numbers of tokens to generate, ignoring the number of tokens in the prompt.`,name:"max_new_tokens"},{anchor:"transformers.GenerationConfig.min_length",description:`<strong>min_length</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
The minimum length of the sequence to be generated. Corresponds to the length of the input prompt +
<code>min_new_tokens</code>. Its effect is overridden by <code>min_new_tokens</code>, if also set.`,name:"min_length"},{anchor:"transformers.GenerationConfig.min_new_tokens",description:`<strong>min_new_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The minimum numbers of tokens to generate, ignoring the number of tokens in the prompt.`,name:"min_new_tokens"},{anchor:"transformers.GenerationConfig.early_stopping",description:`<strong>early_stopping</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Controls the stopping condition for beam-based methods, like beam-search. It accepts the following values:
<code>True</code>, where the generation stops as soon as there are <code>num_beams</code> complete candidates; <code>False</code>, where an
heuristic is applied and the generation stops when is it very unlikely to find better candidates;
<code>&quot;never&quot;</code>, where the beam search procedure only stops when there cannot be better candidates (canonical
beam search algorithm).`,name:"early_stopping"},{anchor:"transformers.GenerationConfig.max_time(float,",description:`<strong>max_time(<code>float</code>,</strong> <em>optional</em>) &#x2014;
The maximum amount of time you allow the computation to run for in seconds. generation will still finish
the current pass after allocated time has been passed.`,name:"max_time(float,"}]},{title:"Parameters that control the generation strategy used",parametersDescription:[{anchor:"transformers.GenerationConfig.do_sample",description:`<strong>do_sample</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to use sampling ; use greedy decoding otherwise.`,name:"do_sample"},{anchor:"transformers.GenerationConfig.num_beams",description:`<strong>num_beams</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of beams for beam search. 1 means no beam search.`,name:"num_beams"},{anchor:"transformers.GenerationConfig.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams.
<a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"},{anchor:"transformers.GenerationConfig.penalty_alpha",description:`<strong>penalty_alpha</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The values balance the model confidence and the degeneration penalty in contrastive search decoding.`,name:"penalty_alpha"},{anchor:"transformers.GenerationConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should use the past last key/values attentions (if applicable to the model) to
speed up decoding.`,name:"use_cache"}]},{title:"Parameters for manipulation of the model output logits",parametersDescription:[{anchor:"transformers.GenerationConfig.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The value used to modulate the next token probabilities.`,name:"temperature"},{anchor:"transformers.GenerationConfig.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.GenerationConfig.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
If set to float &lt; 1, only the smallest set of most probable tokens with probabilities that add up to
<code>top_p</code> or higher are kept for generation.`,name:"top_p"},{anchor:"transformers.GenerationConfig.typical_p",description:`<strong>typical_p</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Local typicality measures how similar the conditional probability of predicting a target token next is to
the expected conditional probability of predicting a random token next, given the partial text already
generated. If set to float &lt; 1, the smallest set of the most locally typical tokens with probabilities that
add up to <code>typical_p</code> or higher are kept for generation. See <a href="https://arxiv.org/pdf/2202.00666.pdf" rel="nofollow">this
paper</a> for more details.`,name:"typical_p"},{anchor:"transformers.GenerationConfig.epsilon_cutoff",description:`<strong>epsilon_cutoff</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
If set to float strictly between 0 and 1, only tokens with a conditional probability greater than
<code>epsilon_cutoff</code> will be sampled. In the paper, suggested values range from 3e-4 to 9e-4, depending on the
size of the model. See <a href="https://arxiv.org/abs/2210.15191" rel="nofollow">Truncation Sampling as Language Model
Desmoothing</a> for more details.`,name:"epsilon_cutoff"},{anchor:"transformers.GenerationConfig.eta_cutoff",description:`<strong>eta_cutoff</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Eta sampling is a hybrid of locally typical sampling and epsilon sampling. If set to float strictly between
0 and 1, a token is only considered if it is greater than either <code>eta_cutoff</code> or <code>sqrt(eta_cutoff) * exp(-entropy(softmax(next_token_logits)))</code>. The latter term is intuitively the expected next token
probability, scaled by <code>sqrt(eta_cutoff)</code>. In the paper, suggested values range from 3e-4 to 2e-3,
depending on the size of the model. See <a href="https://arxiv.org/abs/2210.15191" rel="nofollow">Truncation Sampling as Language Model
Desmoothing</a> for more details.`,name:"eta_cutoff"},{anchor:"transformers.GenerationConfig.diversity_penalty",description:`<strong>diversity_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
This value is subtracted from a beam&#x2019;s score if it generates a token same as any beam from other group at a
particular time. Note that <code>diversity_penalty</code> is only effective if <code>group beam search</code> is enabled.`,name:"diversity_penalty"},{anchor:"transformers.GenerationConfig.repetition_penalty",description:`<strong>repetition_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. See <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">this
paper</a> for more details.`,name:"repetition_penalty"},{anchor:"transformers.GenerationConfig.encoder_repetition_penalty",description:`<strong>encoder_repetition_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The paramater for encoder_repetition_penalty. An exponential penalty on sequences that are not in the
original input. 1.0 means no penalty.`,name:"encoder_repetition_penalty"},{anchor:"transformers.GenerationConfig.length_penalty",description:`<strong>length_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Exponential penalty to the length that is used with beam-based generation. It is applied as an exponent to
the sequence length, which in turn is used to divide the score of the sequence. Since the score is the log
likelihood of the sequence (i.e. negative), <code>length_penalty</code> &gt; 0.0 promotes longer sequences, while
<code>length_penalty</code> &lt; 0.0 encourages shorter sequences.`,name:"length_penalty"},{anchor:"transformers.GenerationConfig.no_repeat_ngram_size",description:`<strong>no_repeat_ngram_size</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
If set to int &gt; 0, all ngrams of that size can only occur once.`,name:"no_repeat_ngram_size"},{anchor:"transformers.GenerationConfig.bad_words_ids(List[List[int]],",description:`<strong>bad_words_ids(<code>List[List[int]]</code>,</strong> <em>optional</em>) &#x2014;
List of list of token ids that are not allowed to be generated. Check
<a href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.NoBadWordsLogitsProcessor">NoBadWordsLogitsProcessor</a> for further documentation and examples.`,name:"bad_words_ids(List[List[int]],"},{anchor:"transformers.GenerationConfig.force_words_ids(List[List[int]]",description:`<strong>force_words_ids(<code>List[List[int]]</code></strong> or <code>List[List[List[int]]]</code>, <em>optional</em>) &#x2014;
List of token ids that must be generated. If given a <code>List[List[int]]</code>, this is treated as a simple list of
words that must be included, the opposite to <code>bad_words_ids</code>. If given <code>List[List[List[int]]]</code>, this
triggers a <a href="https://github.com/huggingface/transformers/issues/14081" rel="nofollow">disjunctive constraint</a>, where one
can allow different forms of each word.`,name:"force_words_ids(List[List[int]]"},{anchor:"transformers.GenerationConfig.renormalize_logits",description:`<strong>renormalize_logits</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to renormalize the logits after applying all the logits processors or warpers (including the custom
ones). It&#x2019;s highly recommended to set this flag to <code>True</code> as the search algorithms suppose the score logits
are normalized but some logit processors or warpers break the normalization.`,name:"renormalize_logits"},{anchor:"transformers.GenerationConfig.constraints",description:`<strong>constraints</strong> (<code>List[Constraint]</code>, <em>optional</em>) &#x2014;
Custom constraints that can be added to the generation to ensure that the output will contain the use of
certain tokens as defined by <code>Constraint</code> objects, in the most sensible way possible.`,name:"constraints"},{anchor:"transformers.GenerationConfig.forced_bos_token_id",description:`<strong>forced_bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to <code>model.config.forced_bos_token_id</code>) &#x2014;
The id of the token to force as the first generated token after the <code>decoder_start_token_id</code>. Useful for
multilingual models like <a href="../model_doc/mbart">mBART</a> where the first generated token needs to be the target
language token.`,name:"forced_bos_token_id"},{anchor:"transformers.GenerationConfig.forced_eos_token_id",description:`<strong>forced_eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>, defaults to <code>model.config.forced_eos_token_id</code>) &#x2014;
The id of the token to force as the last generated token when <code>max_length</code> is reached. Optionally, use a
list to set multiple <em>end-of-sequence</em> tokens.`,name:"forced_eos_token_id"},{anchor:"transformers.GenerationConfig.remove_invalid_values",description:`<strong>remove_invalid_values</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>model.config.remove_invalid_values</code>) &#x2014;
Whether to remove possible <em>nan</em> and <em>inf</em> outputs of the model to prevent the generation method to crash.
Note that using <code>remove_invalid_values</code> can slow down generation.`,name:"remove_invalid_values"},{anchor:"transformers.GenerationConfig.exponential_decay_length_penalty",description:`<strong>exponential_decay_length_penalty</strong> (<code>tuple(int, float)</code>, <em>optional</em>) &#x2014;
This Tuple adds an exponentially increasing length penalty, after a certain amount of tokens have been
generated. The tuple shall consist of: <code>(start_index, decay_factor)</code> where <code>start_index</code> indicates where
penalty starts and <code>decay_factor</code> represents the factor of exponential decay`,name:"exponential_decay_length_penalty"},{anchor:"transformers.GenerationConfig.suppress_tokens",description:`<strong>suppress_tokens</strong>  (<code>List[int]</code>, <em>optional</em>) &#x2014;
A list of tokens that will be suppressed at generation. The <code>SupressTokens</code> logit processor will set their
log probs to <code>-inf</code> so that they are not sampled.`,name:"suppress_tokens"},{anchor:"transformers.GenerationConfig.begin_suppress_tokens",description:`<strong>begin_suppress_tokens</strong>  (<code>List[int]</code>, <em>optional</em>) &#x2014;
A list of tokens that will be suppressed at the beginning of the generation. The <code>SupressBeginTokens</code> logit
processor will set their log probs to <code>-inf</code> so that they are not sampled.`,name:"begin_suppress_tokens"},{anchor:"transformers.GenerationConfig.forced_decoder_ids",description:`<strong>forced_decoder_ids</strong> (<code>List[List[int]]</code>, <em>optional</em>) &#x2014;
A list of pairs of integers which indicates a mapping from generation indices to token indices that will be
forced before sampling. For example, <code>[[1, 123]]</code> means the second generated token will always be a token
of index 123.`,name:"forced_decoder_ids"},{anchor:"transformers.GenerationConfig.sequence_bias",description:`<strong>sequence_bias</strong> (<code>Dict[Tuple[int], float]</code>, <em>optional</em>)) &#x2014;
Dictionary that maps a sequence of tokens to its bias term. Positive biases increase the odds of the
sequence being selected, while negative biases do the opposite. Check
<a href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.SequenceBiasLogitsProcessor">SequenceBiasLogitsProcessor</a> for further documentation and examples.`,name:"sequence_bias"},{anchor:"transformers.GenerationConfig.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The guidance scale for classifier free guidance (CFG). CFG is enabled by setting <code>guidance_scale &gt; 1</code>.
Higher guidance scale encourages the model to generate samples that are more closely linked to the input
prompt, usually at the expense of poorer quality.`,name:"guidance_scale"},{anchor:"transformers.GenerationConfig.low_memory",description:`<strong>low_memory</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Switch to sequential topk for contrastive search to reduce peak memory. Used with contrastive search.`,name:"low_memory"}]},{title:"Parameters that define the output variables of `generate`",parametersDescription:[{anchor:"transformers.GenerationConfig.num_return_sequences(int,",description:`<strong>num_return_sequences(<code>int</code>,</strong> <em>optional</em>, defaults to 1) &#x2014;
The number of independently computed returned sequences for each element in the batch.`,name:"num_return_sequences(int,"},{anchor:"transformers.GenerationConfig.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more details.`,name:"output_attentions"},{anchor:"transformers.GenerationConfig.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more details.`,name:"output_hidden_states"},{anchor:"transformers.GenerationConfig.output_scores",description:`<strong>output_scores</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the prediction scores. See <code>scores</code> under returned tensors for more details.`,name:"output_scores"},{anchor:"transformers.GenerationConfig.return_dict_in_generate",description:`<strong>return_dict_in_generate</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.32.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict_in_generate"}]},{title:"Special tokens that can be used at generation time",parametersDescription:[{anchor:"transformers.GenerationConfig.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.GenerationConfig.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>beginning-of-sequence</em> token.`,name:"bos_token_id"},{anchor:"transformers.GenerationConfig.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}]},{title:"Generation parameters exclusive to encoder-decoder models",parametersDescription:[{anchor:"transformers.GenerationConfig.encoder_no_repeat_ngram_size",description:`<strong>encoder_no_repeat_ngram_size</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
If set to int &gt; 0, all ngrams of that size that occur in the <code>encoder_input_ids</code> cannot occur in the
<code>decoder_input_ids</code>.`,name:"encoder_no_repeat_ngram_size"},{anchor:"transformers.GenerationConfig.decoder_start_token_id",description:`<strong>decoder_start_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If an encoder-decoder model starts decoding with a different token than <em>bos</em>, the id of that token.`,name:"decoder_start_token_id"}]},{title:"Wild card",parametersDescription:[]}]}}),dn=new S({props:{name:"from_pretrained",anchor:"transformers.GenerationConfig.from_pretrained",parameters:[{name:"pretrained_model_name",val:": typing.Union[str, os.PathLike]"},{name:"config_file_name",val:": typing.Union[str, os.PathLike, NoneType] = None"},{name:"cache_dir",val:": typing.Union[str, os.PathLike, NoneType] = None"},{name:"force_download",val:": bool = False"},{name:"local_files_only",val:": bool = False"},{name:"token",val:": typing.Union[str, bool, NoneType] = None"},{name:"revision",val:": str = 'main'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationConfig.from_pretrained.pretrained_model_name",description:`<strong>pretrained_model_name</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
This can be either:</p>
<ul>
<li>a string, the <em>model id</em> of a pretrained model configuration hosted inside a model repo on
huggingface.co. Valid model ids can be located at the root-level, like <code>bert-base-uncased</code>, or
namespaced under a user or organization name, like <code>dbmdz/bert-base-german-cased</code>.</li>
<li>a path to a <em>directory</em> containing a configuration file saved using the
<a href="/docs/transformers/v4.32.1/en/main_classes/text_generation#transformers.GenerationConfig.save_pretrained">save_pretrained()</a> method, e.g., <code>./my_model_directory/</code>.</li>
</ul>`,name:"pretrained_model_name"},{anchor:"transformers.GenerationConfig.from_pretrained.config_file_name",description:`<strong>config_file_name</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>, defaults to <code>&quot;generation_config.json&quot;</code>) &#x2014;
Name of the generation configuration JSON file to be loaded from <code>pretrained_model_name</code>.`,name:"config_file_name"},{anchor:"transformers.GenerationConfig.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.GenerationConfig.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force to (re-)download the configuration files and override the cached versions if
they exist.`,name:"force_download"},{anchor:"transformers.GenerationConfig.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received file. Attempts to resume the download if such a file
exists.`,name:"resume_download"},{anchor:"transformers.GenerationConfig.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}.</code> The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.GenerationConfig.from_pretrained.token",description:`<strong>token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, or not specified, will use
the token generated when running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"transformers.GenerationConfig.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>To test a pull request you made on the Hub, you can pass \`revision=&#x201C;refs/pr/<pr_number>&#x201C;.</pr_number></p>

					</div>`,name:"revision"},{anchor:"transformers.GenerationConfig.from_pretrained.return_unused_kwargs",description:`<strong>return_unused_kwargs</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>False</code>, then this function returns just the final configuration object.</p>
<p>If <code>True</code>, then this functions returns a <code>Tuple(config, unused_kwargs)</code> where <em>unused_kwargs</em> is a
dictionary consisting of the key/value pairs whose keys are not configuration attributes: i.e., the
part of <code>kwargs</code> which has not been used to update <code>config</code> and is otherwise ignored.`,name:"return_unused_kwargs"},{anchor:"transformers.GenerationConfig.from_pretrained.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
In case the relevant files are located inside a subfolder of the model repo on huggingface.co, you can
specify the folder name here.`,name:"subfolder"},{anchor:"transformers.GenerationConfig.from_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
The values in kwargs of any keys which are configuration attributes will be used to override the loaded
values. Behavior concerning key/value pairs whose keys are <em>not</em> configuration attributes is controlled
by the <code>return_unused_kwargs</code> keyword parameter.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/configuration_utils.py#L555",returnDescription:`
<p>The configuration object instantiated from this pretrained model.</p>
`,returnType:`
<p><a
  href="/docs/transformers/v4.32.1/en/main_classes/text_generation#transformers.GenerationConfig"
>GenerationConfig</a></p>
`}}),at=new Ne({props:{anchor:"transformers.GenerationConfig.from_pretrained.example",$$slots:{default:[pu]},$$scope:{ctx:k}}}),mn=new S({props:{name:"from_model_config",anchor:"transformers.GenerationConfig.from_model_config",parameters:[{name:"model_config",val:": PretrainedConfig"}],parametersDescription:[{anchor:"transformers.GenerationConfig.from_model_config.model_config",description:`<strong>model_config</strong> (<code>PretrainedConfig</code>) &#x2014;
The model config that will be used to instantiate the generation config.`,name:"model_config"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/configuration_utils.py#L858",returnDescription:`
<p>The configuration object instantiated from those parameters.</p>
`,returnType:`
<p><a
  href="/docs/transformers/v4.32.1/en/main_classes/text_generation#transformers.GenerationConfig"
>GenerationConfig</a></p>
`}}),gn=new S({props:{name:"save_pretrained",anchor:"transformers.GenerationConfig.save_pretrained",parameters:[{name:"save_directory",val:": typing.Union[str, os.PathLike]"},{name:"config_file_name",val:": typing.Union[str, os.PathLike, NoneType] = None"},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationConfig.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory where the configuration JSON file will be saved (will be created if it does not exist).`,name:"save_directory"},{anchor:"transformers.GenerationConfig.save_pretrained.config_file_name",description:`<strong>config_file_name</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>, defaults to <code>&quot;generation_config.json&quot;</code>) &#x2014;
Name of the generation configuration JSON file to be saved in <code>save_directory</code>.`,name:"config_file_name"},{anchor:"transformers.GenerationConfig.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"transformers.GenerationConfig.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional key word arguments passed along to the <a href="/docs/transformers/v4.32.1/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/configuration_utils.py#L477"}}),hn=new $a({}),un=new S({props:{name:"class transformers.GenerationMixin",anchor:"transformers.GenerationMixin",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/utils.py#L488"}}),Mn=new S({props:{name:"generate",anchor:"transformers.GenerationMixin.generate",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"generation_config",val:": typing.Optional[transformers.generation.configuration_utils.GenerationConfig] = None"},{name:"logits_processor",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"stopping_criteria",val:": typing.Optional[transformers.generation.stopping_criteria.StoppingCriteriaList] = None"},{name:"prefix_allowed_tokens_fn",val:": typing.Union[typing.Callable[[int, torch.Tensor], typing.List[int]], NoneType] = None"},{name:"synced_gpus",val:": typing.Optional[bool] = None"},{name:"assistant_model",val:": typing.Optional[ForwardRef('PreTrainedModel')] = None"},{name:"streamer",val:": typing.Optional[ForwardRef('BaseStreamer')] = None"},{name:"negative_prompt_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationMixin.generate.inputs",description:`<strong>inputs</strong> (<code>torch.Tensor</code> of varying shape depending on the modality, <em>optional</em>) &#x2014;
The sequence used as a prompt for the generation or as model inputs to the encoder. If <code>None</code> the
method initializes it with <code>bos_token_id</code> and a batch size of 1. For decoder-only models <code>inputs</code>
should of in the format of <code>input_ids</code>. For encoder-decoder models <em>inputs</em> can represent any of
<code>input_ids</code>, <code>input_values</code>, <code>input_features</code>, or <code>pixel_values</code>.`,name:"inputs"},{anchor:"transformers.GenerationMixin.generate.generation_config",description:`<strong>generation_config</strong> (<code>~generation.GenerationConfig</code>, <em>optional</em>) &#x2014;
The generation configuration to be used as base parametrization for the generation call. <code>**kwargs</code>
passed to generate matching the attributes of <code>generation_config</code> will override them. If
<code>generation_config</code> is not provided, the default will be used, which had the following loading
priority: 1) from the <code>generation_config.json</code> model file, if it exists; 2) from the model
configuration. Please note that unspecified parameters will inherit <a href="/docs/transformers/v4.32.1/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>&#x2019;s
default values, whose documentation should be checked to parameterize generation.`,name:"generation_config"},{anchor:"transformers.GenerationMixin.generate.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
Custom logits processors that complement the default logits processors built from arguments and
generation config. If a logit processor is passed that is already created with the arguments or a
generation config an error is thrown. This feature is intended for advanced users.`,name:"logits_processor"},{anchor:"transformers.GenerationMixin.generate.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
Custom stopping criteria that complement the default stopping criteria built from arguments and a
generation config. If a stopping criteria is passed that is already created with the arguments or a
generation config an error is thrown. This feature is intended for advanced users.`,name:"stopping_criteria"},{anchor:"transformers.GenerationMixin.generate.prefix_allowed_tokens_fn",description:`<strong>prefix_allowed_tokens_fn</strong> (<code>Callable[[int, torch.Tensor], List[int]]</code>, <em>optional</em>) &#x2014;
If provided, this function constraints the beam search to allowed tokens only at each step. If not
provided no constraint is applied. This function takes 2 arguments: the batch ID <code>batch_id</code> and
<code>input_ids</code>. It has to return a list with the allowed tokens for the next generation step conditioned
on the batch ID <code>batch_id</code> and the previously generated tokens <code>inputs_ids</code>. This argument is useful
for constrained generation conditioned on the prefix, as described in <a href="https://arxiv.org/abs/2010.00904" rel="nofollow">Autoregressive Entity
Retrieval</a>.`,name:"prefix_allowed_tokens_fn"},{anchor:"transformers.GenerationMixin.generate.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to continue running the while loop until max_length. Unless overridden this flag will be set to
<code>True</code> under DeepSpeed ZeRO Stage 3 multiple GPUs environment to avoid hanging if one GPU finished
generating before other GPUs. Otherwise it&#x2019;ll be set to <code>False</code>.`,name:"synced_gpus"},{anchor:"transformers.GenerationMixin.generate.assistant_model",description:`<strong>assistant_model</strong> (<code>PreTrainedModel</code>, <em>optional</em>) &#x2014;
An assistant model that can be used to accelerate generation. The assistant model must have the exact
same tokenizer. The acceleration is achieved when forecasting candidate tokens with the assistent model
is much faster than running generation with the model you&#x2019;re calling generate from. As such, the
assistant model should be much smaller.`,name:"assistant_model"},{anchor:"transformers.GenerationMixin.generate.streamer",description:`<strong>streamer</strong> (<code>BaseStreamer</code>, <em>optional</em>) &#x2014;
Streamer object that will be used to stream the generated sequences. Generated tokens are passed
through <code>streamer.put(token_ids)</code> and the streamer is responsible for any further processing.`,name:"streamer"},{anchor:"transformers.GenerationMixin.generate.negative_prompt_ids",description:`<strong>negative_prompt_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
The negative prompt needed for some processors such as CFG. The batch size must match the input batch
size. This is an experimental feature, subject to breaking API changes in future versions.`,name:"negative_prompt_ids"},{anchor:"transformers.GenerationMixin.generate.negative_prompt_attention_mask",description:`<strong>negative_prompt_attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Attention_mask for <code>negative_prompt_ids</code>.`,name:"negative_prompt_attention_mask"},{anchor:"transformers.GenerationMixin.generate.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Ad hoc parametrization of <code>generate_config</code> and/or additional model-specific kwargs that will be
forwarded to the <code>forward</code> function of the model. If the model is an encoder-decoder model, encoder
specific kwargs should not be prefixed and decoder specific kwargs should be prefixed with <em>decoder_</em>.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/utils.py#L1294",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.32.1/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> (if <code>return_dict_in_generate=True</code>
or when <code>config.return_dict_in_generate=True</code>) or a <code>torch.FloatTensor</code>.</p>
<p>If the model is <em>not</em> an encoder-decoder model (<code>model.config.is_encoder_decoder=False</code>), the possible
<a
  href="/docs/transformers/v4.32.1/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><a
  href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.generation.GreedySearchDecoderOnlyOutput"
>GreedySearchDecoderOnlyOutput</a>,</li>
<li><a
  href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.generation.SampleDecoderOnlyOutput"
>SampleDecoderOnlyOutput</a>,</li>
<li><a
  href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.generation.BeamSearchDecoderOnlyOutput"
>BeamSearchDecoderOnlyOutput</a>,</li>
<li><a
  href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.generation.BeamSampleDecoderOnlyOutput"
>BeamSampleDecoderOnlyOutput</a></li>
</ul>
<p>If the model is an encoder-decoder model (<code>model.config.is_encoder_decoder=True</code>), the possible
<a
  href="/docs/transformers/v4.32.1/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><a
  href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.generation.GreedySearchEncoderDecoderOutput"
>GreedySearchEncoderDecoderOutput</a>,</li>
<li><a
  href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.generation.SampleEncoderDecoderOutput"
>SampleEncoderDecoderOutput</a>,</li>
<li><a
  href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.generation.BeamSearchEncoderDecoderOutput"
>BeamSearchEncoderDecoderOutput</a>,</li>
<li><a
  href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.generation.BeamSampleEncoderDecoderOutput"
>BeamSampleEncoderDecoderOutput</a></li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.32.1/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> or <code>torch.LongTensor</code></p>
`}}),ct=new tt({props:{warning:!0,$$slots:{default:[mu]},$$scope:{ctx:k}}}),bn=new S({props:{name:"compute_transition_scores",anchor:"transformers.GenerationMixin.compute_transition_scores",parameters:[{name:"sequences",val:": Tensor"},{name:"scores",val:": typing.Tuple[torch.Tensor]"},{name:"beam_indices",val:": typing.Optional[torch.Tensor] = None"},{name:"normalize_logits",val:": bool = False"}],parametersDescription:[{anchor:"transformers.GenerationMixin.compute_transition_scores.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or
shorter if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.GenerationMixin.compute_transition_scores.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code>) &#x2014;
Transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens Tuple of
<code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token), with
each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.GenerationMixin.compute_transition_scores.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Beam indices of generated token id at each generation step. <code>torch.LongTensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>. Only required if a <code>num_beams&gt;1</code> at
generate-time.`,name:"beam_indices"},{anchor:"transformers.GenerationMixin.compute_transition_scores.normalize_logits",description:`<strong>normalize_logits</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to normalize the logits (which, for legacy reasons, may be unnormalized).`,name:"normalize_logits"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/utils.py#L1052",returnDescription:`
<p>A <code>torch.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code> containing
the transition scores (logits)</p>
`,returnType:`
<p><code>torch.Tensor</code></p>
`}}),dt=new Ne({props:{anchor:"transformers.GenerationMixin.compute_transition_scores.example",$$slots:{default:[gu]},$$scope:{ctx:k}}}),vn=new S({props:{name:"greedy_search",anchor:"transformers.GenerationMixin.greedy_search",parameters:[{name:"input_ids",val:": LongTensor"},{name:"logits_processor",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"stopping_criteria",val:": typing.Optional[transformers.generation.stopping_criteria.StoppingCriteriaList] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_scores",val:": typing.Optional[bool] = None"},{name:"return_dict_in_generate",val:": typing.Optional[bool] = None"},{name:"synced_gpus",val:": bool = False"},{name:"streamer",val:": typing.Optional[ForwardRef('BaseStreamer')] = None"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationMixin.greedy_search.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The sequence used as a prompt for the generation.`,name:"input_ids"},{anchor:"transformers.GenerationMixin.greedy_search.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a>
used to modify the prediction scores of the language modeling head applied at each generation step.`,name:"logits_processor"},{anchor:"transformers.GenerationMixin.greedy_search.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.StoppingCriteriaList">StoppingCriteriaList</a>. List of instances of class derived from <a href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a>
used to tell if the generation loop should stop.`,name:"stopping_criteria"},{anchor:"transformers.GenerationMixin.greedy_search.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
<strong>DEPRECATED</strong>. Use <code>logits_processor</code> or <code>stopping_criteria</code> directly to cap the number of generated
tokens. The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.GenerationMixin.greedy_search.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.GenerationMixin.greedy_search.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.GenerationMixin.greedy_search.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under
returned tensors for more details.`,name:"output_attentions"},{anchor:"transformers.GenerationMixin.greedy_search.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors
for more details.`,name:"output_hidden_states"},{anchor:"transformers.GenerationMixin.greedy_search.output_scores",description:`<strong>output_scores</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the prediction scores. See <code>scores</code> under returned tensors for more details.`,name:"output_scores"},{anchor:"transformers.GenerationMixin.greedy_search.return_dict_in_generate",description:`<strong>return_dict_in_generate</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.32.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict_in_generate"},{anchor:"transformers.GenerationMixin.greedy_search.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to continue running the while loop until max_length (needed for ZeRO stage 3)`,name:"synced_gpus"},{anchor:"transformers.GenerationMixin.greedy_search.streamer",description:`<strong>streamer</strong> (<code>BaseStreamer</code>, <em>optional</em>) &#x2014;
Streamer object that will be used to stream the generated sequences. Generated tokens are passed
through <code>streamer.put(token_ids)</code> and the streamer is responsible for any further processing.
model_kwargs &#x2014;
Additional model specific keyword arguments will be forwarded to the <code>forward</code> function of the model.
If model is an encoder-decoder model the kwargs should include <code>encoder_outputs</code>.`,name:"streamer"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/utils.py#L2276",returnDescription:`
<p><a
  href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.generation.GreedySearchDecoderOnlyOutput"
>GreedySearchDecoderOnlyOutput</a>, <a
  href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.generation.GreedySearchEncoderDecoderOutput"
>GreedySearchEncoderDecoderOutput</a> or
<code>torch.LongTensor</code>: A <code>torch.LongTensor</code> containing the generated tokens (default behaviour) or a
<a
  href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.generation.GreedySearchDecoderOnlyOutput"
>GreedySearchDecoderOnlyOutput</a> if <code>model.config.is_encoder_decoder=False</code> and
<code>return_dict_in_generate=True</code> or a <a
  href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.generation.GreedySearchEncoderDecoderOutput"
>GreedySearchEncoderDecoderOutput</a> if
<code>model.config.is_encoder_decoder=True</code>.</p>
`}}),pt=new tt({props:{warning:!0,$$slots:{default:[hu]},$$scope:{ctx:k}}}),mt=new Ne({props:{anchor:"transformers.GenerationMixin.greedy_search.example",$$slots:{default:[uu]},$$scope:{ctx:k}}}),Tn=new S({props:{name:"sample",anchor:"transformers.GenerationMixin.sample",parameters:[{name:"input_ids",val:": LongTensor"},{name:"logits_processor",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"stopping_criteria",val:": typing.Optional[transformers.generation.stopping_criteria.StoppingCriteriaList] = None"},{name:"logits_warper",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_scores",val:": typing.Optional[bool] = None"},{name:"return_dict_in_generate",val:": typing.Optional[bool] = None"},{name:"synced_gpus",val:": bool = False"},{name:"streamer",val:": typing.Optional[ForwardRef('BaseStreamer')] = None"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationMixin.sample.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The sequence used as a prompt for the generation.`,name:"input_ids"},{anchor:"transformers.GenerationMixin.sample.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a>
used to modify the prediction scores of the language modeling head applied at each generation step.`,name:"logits_processor"},{anchor:"transformers.GenerationMixin.sample.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.StoppingCriteriaList">StoppingCriteriaList</a>. List of instances of class derived from <a href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a>
used to tell if the generation loop should stop.`,name:"stopping_criteria"},{anchor:"transformers.GenerationMixin.sample.logits_warper",description:`<strong>logits_warper</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> used
to warp the prediction score distribution of the language modeling head applied before multinomial
sampling at each generation step.`,name:"logits_warper"},{anchor:"transformers.GenerationMixin.sample.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
<strong>DEPRECATED</strong>. Use <code>logits_processor</code> or <code>stopping_criteria</code> directly to cap the number of generated
tokens. The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.GenerationMixin.sample.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.GenerationMixin.sample.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.GenerationMixin.sample.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under
returned tensors for more details.`,name:"output_attentions"},{anchor:"transformers.GenerationMixin.sample.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors
for more details.`,name:"output_hidden_states"},{anchor:"transformers.GenerationMixin.sample.output_scores",description:`<strong>output_scores</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the prediction scores. See <code>scores</code> under returned tensors for more details.`,name:"output_scores"},{anchor:"transformers.GenerationMixin.sample.return_dict_in_generate",description:`<strong>return_dict_in_generate</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.32.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict_in_generate"},{anchor:"transformers.GenerationMixin.sample.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to continue running the while loop until max_length (needed for ZeRO stage 3)`,name:"synced_gpus"},{anchor:"transformers.GenerationMixin.sample.streamer",description:`<strong>streamer</strong> (<code>BaseStreamer</code>, <em>optional</em>) &#x2014;
Streamer object that will be used to stream the generated sequences. Generated tokens are passed
through <code>streamer.put(token_ids)</code> and the streamer is responsible for any further processing.
model_kwargs &#x2014;
Additional model specific kwargs will be forwarded to the <code>forward</code> function of the model. If model is
an encoder-decoder model the kwargs should include <code>encoder_outputs</code>.`,name:"streamer"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/utils.py#L2535",returnDescription:`
<p>A <code>torch.LongTensor</code> containing the generated tokens (default behaviour) or a
<a
  href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.generation.SampleDecoderOnlyOutput"
>SampleDecoderOnlyOutput</a> if <code>model.config.is_encoder_decoder=False</code> and
<code>return_dict_in_generate=True</code> or a <a
  href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.generation.SampleEncoderDecoderOutput"
>SampleEncoderDecoderOutput</a> if
<code>model.config.is_encoder_decoder=True</code>.</p>
`,returnType:`
<p><a
  href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.generation.SampleDecoderOnlyOutput"
>SampleDecoderOnlyOutput</a>, <a
  href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.generation.SampleEncoderDecoderOutput"
>SampleEncoderDecoderOutput</a> or <code>torch.LongTensor</code></p>
`}}),gt=new tt({props:{warning:!0,$$slots:{default:[fu]},$$scope:{ctx:k}}}),ht=new Ne({props:{anchor:"transformers.GenerationMixin.sample.example",$$slots:{default:[_u]},$$scope:{ctx:k}}}),Jn=new S({props:{name:"beam_search",anchor:"transformers.GenerationMixin.beam_search",parameters:[{name:"input_ids",val:": LongTensor"},{name:"beam_scorer",val:": BeamScorer"},{name:"logits_processor",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"stopping_criteria",val:": typing.Optional[transformers.generation.stopping_criteria.StoppingCriteriaList] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_scores",val:": typing.Optional[bool] = None"},{name:"return_dict_in_generate",val:": typing.Optional[bool] = None"},{name:"synced_gpus",val:": bool = False"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationMixin.beam_search.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The sequence used as a prompt for the generation.`,name:"input_ids"},{anchor:"transformers.GenerationMixin.beam_search.beam_scorer",description:`<strong>beam_scorer</strong> (<code>BeamScorer</code>) &#x2014;
An derived instance of <a href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> that defines how beam hypotheses are constructed, stored and
sorted during generation. For more information, the documentation of <a href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> should be read.`,name:"beam_scorer"},{anchor:"transformers.GenerationMixin.beam_search.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a>
used to modify the prediction scores of the language modeling head applied at each generation step.`,name:"logits_processor"},{anchor:"transformers.GenerationMixin.beam_search.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.StoppingCriteriaList">StoppingCriteriaList</a>. List of instances of class derived from <a href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a>
used to tell if the generation loop should stop.`,name:"stopping_criteria"},{anchor:"transformers.GenerationMixin.beam_search.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
<strong>DEPRECATED</strong>. Use <code>logits_processor</code> or <code>stopping_criteria</code> directly to cap the number of generated
tokens. The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.GenerationMixin.beam_search.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.GenerationMixin.beam_search.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.GenerationMixin.beam_search.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under
returned tensors for more details.`,name:"output_attentions"},{anchor:"transformers.GenerationMixin.beam_search.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors
for more details.`,name:"output_hidden_states"},{anchor:"transformers.GenerationMixin.beam_search.output_scores",description:`<strong>output_scores</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the prediction scores. See <code>scores</code> under returned tensors for more details.`,name:"output_scores"},{anchor:"transformers.GenerationMixin.beam_search.return_dict_in_generate",description:`<strong>return_dict_in_generate</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.32.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict_in_generate"},{anchor:"transformers.GenerationMixin.beam_search.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to continue running the while loop until max_length (needed for ZeRO stage 3)
model_kwargs &#x2014;
Additional model specific kwargs will be forwarded to the <code>forward</code> function of the model. If model is
an encoder-decoder model the kwargs should include <code>encoder_outputs</code>.`,name:"synced_gpus"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/utils.py#L2817",returnDescription:`
<p><a
  href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.generation.BeamSearchDecoderOnlyOutput"
>generation.BeamSearchDecoderOnlyOutput</a>, <a
  href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.generation.BeamSearchEncoderDecoderOutput"
>BeamSearchEncoderDecoderOutput</a> or
<code>torch.LongTensor</code>: A <code>torch.LongTensor</code> containing the generated tokens (default behaviour) or a
<a
  href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.generation.BeamSearchDecoderOnlyOutput"
>BeamSearchDecoderOnlyOutput</a> if <code>model.config.is_encoder_decoder=False</code> and
<code>return_dict_in_generate=True</code> or a <a
  href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.generation.BeamSearchEncoderDecoderOutput"
>BeamSearchEncoderDecoderOutput</a> if
<code>model.config.is_encoder_decoder=True</code>.</p>
`}}),ut=new tt({props:{warning:!0,$$slots:{default:[yu]},$$scope:{ctx:k}}}),ft=new Ne({props:{anchor:"transformers.GenerationMixin.beam_search.example",$$slots:{default:[Mu]},$$scope:{ctx:k}}}),xn=new S({props:{name:"beam_sample",anchor:"transformers.GenerationMixin.beam_sample",parameters:[{name:"input_ids",val:": LongTensor"},{name:"beam_scorer",val:": BeamScorer"},{name:"logits_processor",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"stopping_criteria",val:": typing.Optional[transformers.generation.stopping_criteria.StoppingCriteriaList] = None"},{name:"logits_warper",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_scores",val:": typing.Optional[bool] = None"},{name:"return_dict_in_generate",val:": typing.Optional[bool] = None"},{name:"synced_gpus",val:": bool = False"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationMixin.beam_sample.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The sequence used as a prompt for the generation.`,name:"input_ids"},{anchor:"transformers.GenerationMixin.beam_sample.beam_scorer",description:`<strong>beam_scorer</strong> (<code>BeamScorer</code>) &#x2014;
A derived instance of <a href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> that defines how beam hypotheses are constructed, stored and
sorted during generation. For more information, the documentation of <a href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> should be read.`,name:"beam_scorer"},{anchor:"transformers.GenerationMixin.beam_sample.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a>
used to modify the prediction scores of the language modeling head applied at each generation step.`,name:"logits_processor"},{anchor:"transformers.GenerationMixin.beam_sample.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.StoppingCriteriaList">StoppingCriteriaList</a>. List of instances of class derived from <a href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a>
used to tell if the generation loop should stop.`,name:"stopping_criteria"},{anchor:"transformers.GenerationMixin.beam_sample.logits_warper",description:`<strong>logits_warper</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> used
to warp the prediction score distribution of the language modeling head applied before multinomial
sampling at each generation step.`,name:"logits_warper"},{anchor:"transformers.GenerationMixin.beam_sample.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
<strong>DEPRECATED</strong>. Use <code>logits_processor</code> or <code>stopping_criteria</code> directly to cap the number of generated
tokens. The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.GenerationMixin.beam_sample.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.GenerationMixin.beam_sample.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.GenerationMixin.beam_sample.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under
returned tensors for more details.`,name:"output_attentions"},{anchor:"transformers.GenerationMixin.beam_sample.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors
for more details.`,name:"output_hidden_states"},{anchor:"transformers.GenerationMixin.beam_sample.output_scores",description:`<strong>output_scores</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the prediction scores. See <code>scores</code> under returned tensors for more details.`,name:"output_scores"},{anchor:"transformers.GenerationMixin.beam_sample.return_dict_in_generate",description:`<strong>return_dict_in_generate</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.32.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict_in_generate"},{anchor:"transformers.GenerationMixin.beam_sample.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to continue running the while loop until max_length (needed for ZeRO stage 3)
model_kwargs &#x2014;
Additional model specific kwargs will be forwarded to the <code>forward</code> function of the model. If model is
an encoder-decoder model the kwargs should include <code>encoder_outputs</code>.`,name:"synced_gpus"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/utils.py#L3138",returnDescription:`
<p><a
  href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.generation.BeamSampleDecoderOnlyOutput"
>BeamSampleDecoderOnlyOutput</a>, <a
  href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.generation.BeamSampleEncoderDecoderOutput"
>BeamSampleEncoderDecoderOutput</a> or
<code>torch.LongTensor</code>: A <code>torch.LongTensor</code> containing the generated tokens (default behaviour) or a
<a
  href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.generation.BeamSampleDecoderOnlyOutput"
>BeamSampleDecoderOnlyOutput</a> if <code>model.config.is_encoder_decoder=False</code> and
<code>return_dict_in_generate=True</code> or a <a
  href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.generation.BeamSampleEncoderDecoderOutput"
>BeamSampleEncoderDecoderOutput</a> if
<code>model.config.is_encoder_decoder=True</code>.</p>
`}}),_t=new tt({props:{warning:!0,$$slots:{default:[bu]},$$scope:{ctx:k}}}),yt=new Ne({props:{anchor:"transformers.GenerationMixin.beam_sample.example",$$slots:{default:[vu]},$$scope:{ctx:k}}}),kn=new S({props:{name:"contrastive_search",anchor:"transformers.GenerationMixin.contrastive_search",parameters:[{name:"input_ids",val:": LongTensor"},{name:"top_k",val:": typing.Optional[int] = 1"},{name:"penalty_alpha",val:": typing.Optional[float] = 0"},{name:"logits_processor",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"logits_warper",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"stopping_criteria",val:": typing.Optional[transformers.generation.stopping_criteria.StoppingCriteriaList] = None"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_scores",val:": typing.Optional[bool] = None"},{name:"return_dict_in_generate",val:": typing.Optional[bool] = None"},{name:"synced_gpus",val:": bool = False"},{name:"streamer",val:": typing.Optional[ForwardRef('BaseStreamer')] = None"},{name:"sequential",val:": typing.Optional[bool] = None"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationMixin.contrastive_search.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The sequence used as a prompt for the generation.`,name:"input_ids"},{anchor:"transformers.GenerationMixin.contrastive_search.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The size of the candidate set that is used to re-rank for contrastive search`,name:"top_k"},{anchor:"transformers.GenerationMixin.contrastive_search.penalty_alpha",description:`<strong>penalty_alpha</strong> (<code>float</code>, <em>optional</em>, defaults to 0) &#x2014;
The degeneration penalty for contrastive search; activate when it is larger than 0`,name:"penalty_alpha"},{anchor:"transformers.GenerationMixin.contrastive_search.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a>
used to modify the prediction scores of the language modeling head applied at each generation step.`,name:"logits_processor"},{anchor:"transformers.GenerationMixin.contrastive_search.logits_warper",description:`<strong>logits_warper</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> used
to warp the prediction score distribution of the language modeling head applied before multinomial
sampling at each generation step.`,name:"logits_warper"},{anchor:"transformers.GenerationMixin.contrastive_search.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.StoppingCriteriaList">StoppingCriteriaList</a>. List of instances of class derived from <a href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a>
used to tell if the generation loop should stop.`,name:"stopping_criteria"},{anchor:"transformers.GenerationMixin.contrastive_search.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.GenerationMixin.contrastive_search.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.GenerationMixin.contrastive_search.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under
returned tensors for more details.`,name:"output_attentions"},{anchor:"transformers.GenerationMixin.contrastive_search.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors
for more details.`,name:"output_hidden_states"},{anchor:"transformers.GenerationMixin.contrastive_search.output_scores",description:`<strong>output_scores</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the prediction scores. See <code>scores</code> under returned tensors for more details.`,name:"output_scores"},{anchor:"transformers.GenerationMixin.contrastive_search.return_dict_in_generate",description:`<strong>return_dict_in_generate</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.32.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict_in_generate"},{anchor:"transformers.GenerationMixin.contrastive_search.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to continue running the while loop until max_length (needed for ZeRO stage 3)`,name:"synced_gpus"},{anchor:"transformers.GenerationMixin.contrastive_search.streamer",description:`<strong>streamer</strong> (<code>BaseStreamer</code>, <em>optional</em>) &#x2014;
Streamer object that will be used to stream the generated sequences. Generated tokens are passed
through <code>streamer.put(token_ids)</code> and the streamer is responsible for any further processing.`,name:"streamer"},{anchor:"transformers.GenerationMixin.contrastive_search.sequential",description:`<strong>sequential</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Switches topk hidden state computation from parallel to sequential to reduce memory if True.
model_kwargs &#x2014;
Additional model specific keyword arguments will be forwarded to the <code>forward</code> function of the model.
If model is an encoder-decoder model the kwargs should include <code>encoder_outputs</code>.`,name:"sequential"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/utils.py#L1832",returnDescription:`
<p><a
  href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.generation.ContrastiveSearchDecoderOnlyOutput"
>ContrastiveSearchDecoderOnlyOutput</a>, <a
  href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.generation.ContrastiveSearchEncoderDecoderOutput"
>ContrastiveSearchEncoderDecoderOutput</a>
or <code>torch.LongTensor</code>: A <code>torch.LongTensor</code> containing the generated tokens (default behaviour) or a
<a
  href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.generation.ContrastiveSearchDecoderOnlyOutput"
>ContrastiveSearchDecoderOnlyOutput</a> if <code>model.config.is_encoder_decoder=False</code> and
<code>return_dict_in_generate=True</code> or a <a
  href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.generation.ContrastiveSearchEncoderDecoderOutput"
>ContrastiveSearchEncoderDecoderOutput</a> if
<code>model.config.is_encoder_decoder=True</code>.</p>
`}}),Mt=new tt({props:{warning:!0,$$slots:{default:[wu]},$$scope:{ctx:k}}}),bt=new Ne({props:{anchor:"transformers.GenerationMixin.contrastive_search.example",$$slots:{default:[Tu]},$$scope:{ctx:k}}}),Bn=new S({props:{name:"group_beam_search",anchor:"transformers.GenerationMixin.group_beam_search",parameters:[{name:"input_ids",val:": LongTensor"},{name:"beam_scorer",val:": BeamScorer"},{name:"logits_processor",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"stopping_criteria",val:": typing.Optional[transformers.generation.stopping_criteria.StoppingCriteriaList] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_scores",val:": typing.Optional[bool] = None"},{name:"return_dict_in_generate",val:": typing.Optional[bool] = None"},{name:"synced_gpus",val:": bool = False"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationMixin.group_beam_search.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The sequence used as a prompt for the generation.`,name:"input_ids"},{anchor:"transformers.GenerationMixin.group_beam_search.beam_scorer",description:`<strong>beam_scorer</strong> (<code>BeamScorer</code>) &#x2014;
An derived instance of <a href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> that defines how beam hypotheses are constructed, stored and
sorted during generation. For more information, the documentation of <a href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> should be read.`,name:"beam_scorer"},{anchor:"transformers.GenerationMixin.group_beam_search.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a>
used to modify the prediction scores of the language modeling head applied at each generation step.`,name:"logits_processor"},{anchor:"transformers.GenerationMixin.group_beam_search.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.StoppingCriteriaList">StoppingCriteriaList</a>. List of instances of class derived from <a href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a>
used to tell if the generation loop should stop.`,name:"stopping_criteria"},{anchor:"transformers.GenerationMixin.group_beam_search.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
<strong>DEPRECATED</strong>. Use <code>logits_processor</code> or <code>stopping_criteria</code> directly to cap the number of generated
tokens. The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.GenerationMixin.group_beam_search.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.GenerationMixin.group_beam_search.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.GenerationMixin.group_beam_search.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under
returned tensors for more details.`,name:"output_attentions"},{anchor:"transformers.GenerationMixin.group_beam_search.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors
for more details.`,name:"output_hidden_states"},{anchor:"transformers.GenerationMixin.group_beam_search.output_scores",description:`<strong>output_scores</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the prediction scores. See <code>scores</code> under returned tensors for more details.`,name:"output_scores"},{anchor:"transformers.GenerationMixin.group_beam_search.return_dict_in_generate",description:`<strong>return_dict_in_generate</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.32.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict_in_generate"},{anchor:"transformers.GenerationMixin.group_beam_search.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to continue running the while loop until max_length (needed for ZeRO stage 3)</p>
<p>model_kwargs &#x2014;
Additional model specific kwargs that will be forwarded to the <code>forward</code> function of the model. If
model is an encoder-decoder model the kwargs should include <code>encoder_outputs</code>.`,name:"synced_gpus"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/utils.py#L3468",returnDescription:`
<p><a
  href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.generation.BeamSearchDecoderOnlyOutput"
>BeamSearchDecoderOnlyOutput</a>, <a
  href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.generation.BeamSearchEncoderDecoderOutput"
>BeamSearchEncoderDecoderOutput</a> or
<code>torch.LongTensor</code>: A <code>torch.LongTensor</code> containing the generated tokens (default behaviour) or a
<a
  href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.generation.BeamSearchDecoderOnlyOutput"
>BeamSearchDecoderOnlyOutput</a> if <a
  href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.generation.BeamSearchDecoderOnlyOutput"
>BeamSearchDecoderOnlyOutput</a> if
<code>model.config.is_encoder_decoder=False</code> and <code>return_dict_in_generate=True</code> or a
<a
  href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.generation.BeamSearchEncoderDecoderOutput"
>BeamSearchEncoderDecoderOutput</a> if <code>model.config.is_encoder_decoder=True</code>.</p>
`}}),vt=new tt({props:{warning:!0,$$slots:{default:[ju]},$$scope:{ctx:k}}}),wt=new Ne({props:{anchor:"transformers.GenerationMixin.group_beam_search.example",$$slots:{default:[Ju]},$$scope:{ctx:k}}}),Cn=new S({props:{name:"constrained_beam_search",anchor:"transformers.GenerationMixin.constrained_beam_search",parameters:[{name:"input_ids",val:": LongTensor"},{name:"constrained_beam_scorer",val:": ConstrainedBeamSearchScorer"},{name:"logits_processor",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"stopping_criteria",val:": typing.Optional[transformers.generation.stopping_criteria.StoppingCriteriaList] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_scores",val:": typing.Optional[bool] = None"},{name:"return_dict_in_generate",val:": typing.Optional[bool] = None"},{name:"synced_gpus",val:": typing.Optional[bool] = None"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationMixin.constrained_beam_search.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The sequence used as a prompt for the generation.`,name:"input_ids"},{anchor:"transformers.GenerationMixin.constrained_beam_search.constrained_beam_scorer",description:`<strong>constrained_beam_scorer</strong> (<code>ConstrainedBeamSearchScorer</code>) &#x2014;
A derived instance of <a href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> that defines how beam hypotheses are constructed, stored and
sorted during generation, while satisfying a list of positive constraints. For more information, the
documentation of <a href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.ConstrainedBeamSearchScorer">ConstrainedBeamSearchScorer</a> should be read.`,name:"constrained_beam_scorer"},{anchor:"transformers.GenerationMixin.constrained_beam_search.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a>
used to modify the prediction scores of the language modeling head applied at each generation step.`,name:"logits_processor"},{anchor:"transformers.GenerationMixin.constrained_beam_search.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.StoppingCriteriaList">StoppingCriteriaList</a>. List of instances of class derived from <a href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a>
used to tell if the generation loop should stop.`,name:"stopping_criteria"},{anchor:"transformers.GenerationMixin.constrained_beam_search.logits_warper",description:`<strong>logits_warper</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> used
to warp the prediction score distribution of the language modeling head applied before multinomial
sampling at each generation step.`,name:"logits_warper"},{anchor:"transformers.GenerationMixin.constrained_beam_search.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
<strong>DEPRECATED</strong>. Use <code>logits_processor</code> or <code>stopping_criteria</code> directly to cap the number of generated
tokens. The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.GenerationMixin.constrained_beam_search.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.GenerationMixin.constrained_beam_search.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.GenerationMixin.constrained_beam_search.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under
returned tensors for more details.`,name:"output_attentions"},{anchor:"transformers.GenerationMixin.constrained_beam_search.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors
for more details.`,name:"output_hidden_states"},{anchor:"transformers.GenerationMixin.constrained_beam_search.output_scores",description:`<strong>output_scores</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the prediction scores. See <code>scores</code> under returned tensors for more details.`,name:"output_scores"},{anchor:"transformers.GenerationMixin.constrained_beam_search.return_dict_in_generate",description:`<strong>return_dict_in_generate</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.32.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict_in_generate"},{anchor:"transformers.GenerationMixin.constrained_beam_search.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to continue running the while loop until max_length (needed for ZeRO stage 3)
model_kwargs &#x2014;
Additional model specific kwargs will be forwarded to the <code>forward</code> function of the model. If model is
an encoder-decoder model the kwargs should include <code>encoder_outputs</code>.`,name:"synced_gpus"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/utils.py#L3847",returnDescription:`
<p><a
  href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.generation.BeamSearchDecoderOnlyOutput"
>generation.BeamSearchDecoderOnlyOutput</a>, <a
  href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.generation.BeamSearchEncoderDecoderOutput"
>BeamSearchEncoderDecoderOutput</a> or
<code>torch.LongTensor</code>: A <code>torch.LongTensor</code> containing the generated tokens (default behaviour) or a
<a
  href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.generation.BeamSearchDecoderOnlyOutput"
>BeamSearchDecoderOnlyOutput</a> if <code>model.config.is_encoder_decoder=False</code> and
<code>return_dict_in_generate=True</code> or a <a
  href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.generation.BeamSearchEncoderDecoderOutput"
>BeamSearchEncoderDecoderOutput</a> if
<code>model.config.is_encoder_decoder=True</code>.</p>
`}}),Tt=new tt({props:{warning:!0,$$slots:{default:[Uu]},$$scope:{ctx:k}}}),jt=new Ne({props:{anchor:"transformers.GenerationMixin.constrained_beam_search.example",$$slots:{default:[xu]},$$scope:{ctx:k}}}),Wn=new $a({}),Nn=new S({props:{name:"class transformers.TFGenerationMixin",anchor:"transformers.TFGenerationMixin",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/tf_utils.py#L444"}}),Sn=new S({props:{name:"generate",anchor:"transformers.TFGenerationMixin.generate",parameters:[{name:"inputs",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"generation_config",val:": typing.Optional[transformers.generation.configuration_utils.GenerationConfig] = None"},{name:"logits_processor",val:": typing.Optional[transformers.generation.tf_logits_process.TFLogitsProcessorList] = None"},{name:"seed",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFGenerationMixin.generate.inputs",description:`<strong>inputs</strong> (<code>tf.Tensor</code> of varying shape depending on the modality, <em>optional</em>) &#x2014;
The sequence used as a prompt for the generation or as model inputs to the encoder. If <code>None</code> the
method initializes it with <code>bos_token_id</code> and a batch size of 1. For decoder-only models <code>inputs</code>
should of in the format of <code>input_ids</code>. For encoder-decoder models <em>inputs</em> can represent any of
<code>input_ids</code>, <code>input_values</code>, <code>input_features</code>, or <code>pixel_values</code>.`,name:"inputs"},{anchor:"transformers.TFGenerationMixin.generate.generation_config",description:`<strong>generation_config</strong> (<code>~generation.GenerationConfig</code>, <em>optional</em>) &#x2014;
The generation configuration to be used as base parametrization for the generation call. <code>**kwargs</code>
passed to generate matching the attributes of <code>generation_config</code> will override them. If
<code>generation_config</code> is not provided, the default will be used, which had the following loading
priority: 1) from the <code>generation_config.json</code> model file, if it exists; 2) from the model
configuration. Please note that unspecified parameters will inherit <a href="/docs/transformers/v4.32.1/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>&#x2019;s
default values, whose documentation should be checked to parameterize generation.`,name:"generation_config"},{anchor:"transformers.TFGenerationMixin.generate.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
Custom logits processors that complement the default logits processors built from arguments and
generation config. If a logit processor is passed that is already created with the arguments or a
generation config an error is thrown. This feature is intended for advanced users.`,name:"logits_processor"},{anchor:"transformers.TFGenerationMixin.generate.seed",description:`<strong>seed</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Random seed to control sampling, containing two integers, used when <code>do_sample</code> is <code>True</code>. See the
<code>seed</code> argument from stateless functions in <code>tf.random</code>.`,name:"seed"},{anchor:"transformers.TFGenerationMixin.generate.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Ad hoc parametrization of <code>generate_config</code> and/or additional model-specific kwargs that will be
forwarded to the <code>forward</code> function of the model. If the model is an encoder-decoder model, encoder
specific kwargs should not be prefixed and decoder specific kwargs should be prefixed with <em>decoder_</em>.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/tf_utils.py#L645",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.32.1/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> (if <code>return_dict_in_generate=True</code> or when
<code>config.return_dict_in_generate=True</code>) or a <code>tf.Tensor</code>.</p>
<p>If the model is <em>not</em> an encoder-decoder model (<code>model.config.is_encoder_decoder=False</code>), the possible
<a
  href="/docs/transformers/v4.32.1/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><a
  href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.generation.TFGreedySearchDecoderOnlyOutput"
>TFGreedySearchDecoderOnlyOutput</a>,</li>
<li><a
  href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.generation.TFSampleDecoderOnlyOutput"
>TFSampleDecoderOnlyOutput</a>,</li>
<li><a
  href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.generation.TFBeamSearchDecoderOnlyOutput"
>TFBeamSearchDecoderOnlyOutput</a>,</li>
<li><a
  href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.generation.TFBeamSampleDecoderOnlyOutput"
>TFBeamSampleDecoderOnlyOutput</a></li>
</ul>
<p>If the model is an encoder-decoder model (<code>model.config.is_encoder_decoder=True</code>), the possible
<a
  href="/docs/transformers/v4.32.1/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><a
  href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.generation.TFGreedySearchEncoderDecoderOutput"
>TFGreedySearchEncoderDecoderOutput</a>,</li>
<li><a
  href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.generation.TFSampleEncoderDecoderOutput"
>TFSampleEncoderDecoderOutput</a>,</li>
<li><a
  href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.generation.TFBeamSearchEncoderDecoderOutput"
>TFBeamSearchEncoderDecoderOutput</a>,</li>
<li><a
  href="/docs/transformers/v4.32.1/en/internal/generation_utils#transformers.generation.TFBeamSampleEncoderDecoderOutput"
>TFBeamSampleEncoderDecoderOutput</a></li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.32.1/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> or <code>tf.Tensor</code></p>
`}}),Ut=new tt({props:{warning:!0,$$slots:{default:[Gu]},$$scope:{ctx:k}}}),$n=new S({props:{name:"compute_transition_scores",anchor:"transformers.TFGenerationMixin.compute_transition_scores",parameters:[{name:"sequences",val:": Tensor"},{name:"scores",val:": typing.Tuple[tensorflow.python.framework.ops.Tensor]"},{name:"beam_indices",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"normalize_logits",val:": bool = False"}],parametersDescription:[{anchor:"transformers.TFGenerationMixin.compute_transition_scores.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or
shorter if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.TFGenerationMixin.compute_transition_scores.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code>) &#x2014;
Transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens Tuple of
<code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token), with each
tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.TFGenerationMixin.compute_transition_scores.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>. Only required if a <code>num_beams&gt;1</code> at
generate-time.`,name:"beam_indices"},{anchor:"transformers.TFGenerationMixin.compute_transition_scores.normalize_logits",description:`<strong>normalize_logits</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to normalize the logits (which, for legacy reasons, may be unnormalized).`,name:"normalize_logits"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/tf_utils.py#L477",returnDescription:`
<p>A <code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code> containing
the transition scores (logits)</p>
`,returnType:`
<p><code>tf.Tensor</code></p>
`}}),xt=new Ne({props:{anchor:"transformers.TFGenerationMixin.compute_transition_scores.example",$$slots:{default:[ku]},$$scope:{ctx:k}}}),Fn=new $a({}),zn=new S({props:{name:"class transformers.FlaxGenerationMixin",anchor:"transformers.FlaxGenerationMixin",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/flax_utils.py#L129"}}),Dn=new S({props:{name:"generate",anchor:"transformers.FlaxGenerationMixin.generate",parameters:[{name:"input_ids",val:": Array"},{name:"generation_config",val:": typing.Optional[transformers.generation.configuration_utils.GenerationConfig] = None"},{name:"prng_key",val:": typing.Optional[jax.Array] = None"},{name:"trace",val:": bool = True"},{name:"params",val:": typing.Union[typing.Dict[str, jax.Array], NoneType] = None"},{name:"logits_processor",val:": typing.Optional[transformers.generation.flax_logits_process.FlaxLogitsProcessorList] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxGenerationMixin.generate.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The sequence used as a prompt for the generation.`,name:"input_ids"},{anchor:"transformers.FlaxGenerationMixin.generate.generation_config",description:`<strong>generation_config</strong> (<code>~generation.GenerationConfig</code>, <em>optional</em>) &#x2014;
The generation configuration to be used as base parametrization for the generation call. <code>**kwargs</code>
passed to generate matching the attributes of <code>generation_config</code> will override them. If
<code>generation_config</code> is not provided, the default will be used, which had the following loading
priority: 1) from the <code>generation_config.json</code> model file, if it exists; 2) from the model
configuration. Please note that unspecified parameters will inherit <a href="/docs/transformers/v4.32.1/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>&#x2019;s
default values, whose documentation should be checked to parameterize generation.`,name:"generation_config"},{anchor:"transformers.FlaxGenerationMixin.generate.trace",description:`<strong>trace</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to trace generation. Setting <code>trace=False</code> should only be used for debugging and will lead to a
considerably slower runtime.`,name:"trace"},{anchor:"transformers.FlaxGenerationMixin.generate.params",description:`<strong>params</strong> (<code>Dict[str, jnp.ndarray]</code>, <em>optional</em>) &#x2014;
Optionally the model parameters can be passed. Can be useful for parallelized generation.`,name:"params"},{anchor:"transformers.FlaxGenerationMixin.generate.logits_processor",description:`<strong>logits_processor</strong> (<code>FlaxLogitsProcessorList </code>, <em>optional</em>) &#x2014;
Custom logits processors that complement the default logits processors built from arguments and
generation config. If a logit processor is passed that is already created with the arguments or a
generation config an error is thrown. This feature is intended for advanced users.`,name:"logits_processor"},{anchor:"transformers.FlaxGenerationMixin.generate.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Ad hoc parametrization of <code>generate_config</code> and/or additional model-specific kwargs that will be
forwarded to the <code>forward</code> function of the model. If the model is an encoder-decoder model, encoder
specific kwargs should not be prefixed and decoder specific kwargs should be prefixed with <em>decoder_</em>.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.32.1/src/transformers/generation/flax_utils.py#L267",returnDescription:`
<p><a
  href="/docs/transformers/v4.32.1/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a>.</p>
`}}),{c(){c=o("meta"),_=m(),p=o("h1"),d=o("a"),f=o("span"),w(i.$$.fragment),h=m(),G=o("span"),v=n("Generation"),y=m(),E=o("p"),B=n("Each framework has a generate method for text generation implemented in their respective "),N=o("code"),ie=n("GenerationMixin"),F=n(" class:"),q=m(),$=o("ul"),Z=o("li"),I=n("PyTorch "),P=o("a"),Ve=n("generate()"),Se=n(" is implemented in "),A=o("a"),$e=n("GenerationMixin"),Jr=n("."),Ur=m(),Fe=o("li"),xr=n("TensorFlow "),Pn=o("a"),Gr=n("generate()"),kr=n(" is implemented in "),Kn=o("a"),Er=n("TFGenerationMixin"),Br=n("."),Zr=m(),ze=o("li"),Cr=n("Flax/JAX "),es=o("a"),Ir=n("generate()"),Wr=n(" is implemented in "),ts=o("a"),Nr=n("FlaxGenerationMixin"),Xr=n("."),Fa=m(),nt=o("p"),Rr=n("Regardless of your framework of choice, you can parameterize the generate method with a "),ns=o("a"),Vr=n("GenerationConfig"),Sr=n(`
class instance. Please refer to this class for the complete list of generation parameters, which control the behavior
of the generation method.`),za=m(),st=o("p"),$r=n(`To learn how to inspect a model\u2019s generation configuration, what are the defaults, how to change the parameters ad hoc,
and how to create and save a customized generation configuration, refer to the
`),ss=o("a"),Fr=n("text generation strategies guide"),zr=n(`. The guide also explains how to use related features,
like token streaming.`),La=m(),Le=o("h2"),ot=o("a"),Fs=o("span"),w(an.$$.fragment),Lr=m(),zs=o("span"),Ar=n("GenerationConfig"),Aa=m(),X=o("div"),w(rn.$$.fragment),Qr=m(),ln=o("p"),Dr=n("Class that holds a configuration for a generation task. A "),Ls=o("code"),Yr=n("generate"),Or=n(` call supports the following generation methods
for text-decoder, text-to-text, speech-to-text, and vision-to-text models:`),Hr=m(),R=o("ul"),le=o("li"),As=o("em"),qr=n("greedy decoding"),Pr=n(" by calling "),os=o("a"),Kr=n("greedy_search()"),ei=n(" if "),Qs=o("code"),ti=n("num_beams=1"),ni=n(` and
`),Ds=o("code"),si=n("do_sample=False"),oi=m(),ce=o("li"),Ys=o("em"),ai=n("contrastive search"),ri=n(" by calling "),as=o("a"),ii=n("contrastive_search()"),li=n(" if "),Os=o("code"),ci=n("penalty_alpha>0."),di=n(`
and `),Hs=o("code"),pi=n("top_k>1"),mi=m(),de=o("li"),qs=o("em"),gi=n("multinomial sampling"),hi=n(" by calling "),rs=o("a"),ui=n("sample()"),fi=n(" if "),Ps=o("code"),_i=n("num_beams=1"),yi=n(` and
`),Ks=o("code"),Mi=n("do_sample=True"),bi=m(),pe=o("li"),eo=o("em"),vi=n("beam-search decoding"),wi=n(" by calling "),is=o("a"),Ti=n("beam_search()"),ji=n(" if "),to=o("code"),Ji=n("num_beams>1"),Ui=n(` and
`),no=o("code"),xi=n("do_sample=False"),Gi=m(),me=o("li"),so=o("em"),ki=n("beam-search multinomial sampling"),Ei=n(" by calling "),ls=o("a"),Bi=n("beam_sample()"),Zi=n(` if
`),oo=o("code"),Ci=n("num_beams>1"),Ii=n(" and "),ao=o("code"),Wi=n("do_sample=True"),Ni=m(),ge=o("li"),ro=o("em"),Xi=n("diverse beam-search decoding"),Ri=n(" by calling "),cs=o("a"),Vi=n("group_beam_search()"),Si=n(`, if
`),io=o("code"),$i=n("num_beams>1"),Fi=n(" and "),lo=o("code"),zi=n("num_beam_groups>1"),Li=m(),he=o("li"),co=o("em"),Ai=n("constrained beam-search decoding"),Qi=n(" by calling "),ds=o("a"),Di=n("constrained_beam_search()"),Yi=n(`, if
`),po=o("code"),Oi=n("constraints!=None"),Hi=n(" or "),mo=o("code"),qi=n("force_words_ids!=None"),Pi=m(),ue=o("li"),go=o("em"),Ki=n("assisted decoding"),el=n(" by calling "),ho=o("code"),tl=n("assisted_decoding()"),nl=n(`, if
`),uo=o("code"),sl=n("assistant_model"),ol=n(" is passed to "),fo=o("code"),al=n(".generate()"),rl=m(),cn=o("p"),il=n(`You do not need to call any of the above methods directly. Pass custom parameter values to \u2018.generate()\u2018. To learn
more about decoding strategies refer to the `),ps=o("a"),ll=n("text generation strategies guide"),cl=n("."),dl=m(),Ee=o("div"),w(dn.$$.fragment),pl=m(),pn=o("p"),ml=n("Instantiate a "),ms=o("a"),gl=n("GenerationConfig"),hl=n(" from a generation configuration file."),ul=m(),w(at.$$.fragment),fl=m(),rt=o("div"),w(mn.$$.fragment),_l=m(),H=o("p"),yl=n("Instantiates a "),gs=o("a"),Ml=n("GenerationConfig"),bl=n(" from a "),hs=o("a"),vl=n("PretrainedConfig"),wl=n(`. This function is useful to convert legacy
`),us=o("a"),Tl=n("PretrainedConfig"),jl=n(" objects, which may contain generation parameters, into a stand-alone "),fs=o("a"),Jl=n("GenerationConfig"),Ul=n("."),xl=m(),it=o("div"),w(gn.$$.fragment),Gl=m(),Ae=o("p"),kl=n("Save a generation configuration object to the directory "),_o=o("code"),El=n("save_directory"),Bl=n(`, so that it can be re-loaded using the
`),_s=o("a"),Zl=n("from_pretrained()"),Cl=n(" class method."),Qa=m(),Qe=o("h2"),lt=o("a"),yo=o("span"),w(hn.$$.fragment),Il=m(),Mo=o("span"),Wl=n("GenerationMixin"),Da=m(),C=o("div"),w(un.$$.fragment),Nl=m(),fn=o("p"),Xl=n("A class containing all functions for auto-regressive text generation, to be used as a mixin in "),ys=o("a"),Rl=n("PreTrainedModel"),Vl=n("."),Sl=m(),_n=o("p"),$l=n("The class exposes "),Ms=o("a"),Fl=n("generate()"),zl=n(", which can be used for:"),Ll=m(),z=o("ul"),fe=o("li"),bo=o("em"),Al=n("greedy decoding"),Ql=n(" by calling "),bs=o("a"),Dl=n("greedy_search()"),Yl=n(" if "),vo=o("code"),Ol=n("num_beams=1"),Hl=n(` and
`),wo=o("code"),ql=n("do_sample=False"),Pl=m(),_e=o("li"),To=o("em"),Kl=n("contrastive search"),ec=n(" by calling "),vs=o("a"),tc=n("contrastive_search()"),nc=n(" if "),jo=o("code"),sc=n("penalty_alpha>0"),oc=n(` and
`),Jo=o("code"),ac=n("top_k>1"),rc=m(),ye=o("li"),Uo=o("em"),ic=n("multinomial sampling"),lc=n(" by calling "),ws=o("a"),cc=n("sample()"),dc=n(" if "),xo=o("code"),pc=n("num_beams=1"),mc=n(` and
`),Go=o("code"),gc=n("do_sample=True"),hc=m(),Me=o("li"),ko=o("em"),uc=n("beam-search decoding"),fc=n(" by calling "),Ts=o("a"),_c=n("beam_search()"),yc=n(" if "),Eo=o("code"),Mc=n("num_beams>1"),bc=n(` and
`),Bo=o("code"),vc=n("do_sample=False"),wc=m(),be=o("li"),Zo=o("em"),Tc=n("beam-search multinomial sampling"),jc=n(" by calling "),js=o("a"),Jc=n("beam_sample()"),Uc=n(" if "),Co=o("code"),xc=n("num_beams>1"),Gc=n(`
and `),Io=o("code"),kc=n("do_sample=True"),Ec=m(),ve=o("li"),Wo=o("em"),Bc=n("diverse beam-search decoding"),Zc=n(" by calling "),Js=o("a"),Cc=n("group_beam_search()"),Ic=n(", if "),No=o("code"),Wc=n("num_beams>1"),Nc=n(`
and `),Xo=o("code"),Xc=n("num_beam_groups>1"),Rc=m(),we=o("li"),Ro=o("em"),Vc=n("constrained beam-search decoding"),Sc=n(" by calling "),Us=o("a"),$c=n("constrained_beam_search()"),Fc=n(`, if
`),Vo=o("code"),zc=n("constraints!=None"),Lc=n(" or "),So=o("code"),Ac=n("force_words_ids!=None"),Qc=m(),yn=o("p"),Dc=n(`You do not need to call any of the above methods directly. Pass custom parameter values to \u2018generate\u2019 instead. To
learn more about decoding strategies refer to the `),xs=o("a"),Yc=n("text generation strategies guide"),Oc=n("."),Hc=m(),Be=o("div"),w(Mn.$$.fragment),qc=m(),$o=o("p"),Pc=n("Generates sequences of token ids for models with a language modeling head."),Kc=m(),w(ct.$$.fragment),ed=m(),Ze=o("div"),w(bn.$$.fragment),td=m(),Fo=o("p"),nd=n(`Computes the transition scores of sequences given the generation scores (and beam indices, if beam search was
used). This is a convenient method to quicky obtain the scores of the selected tokens at generation time.`),sd=m(),w(dt.$$.fragment),od=m(),K=o("div"),w(vn.$$.fragment),ad=m(),wn=o("p"),rd=n("Generates sequences of token ids for models with a language modeling head using "),zo=o("strong"),id=n("greedy decoding"),ld=n(` and can be
used for text-decoder, text-to-text, speech-to-text, and vision-to-text models.`),cd=m(),w(pt.$$.fragment),dd=m(),w(mt.$$.fragment),pd=m(),ee=o("div"),w(Tn.$$.fragment),md=m(),jn=o("p"),gd=n("Generates sequences of token ids for models with a language modeling head using "),Lo=o("strong"),hd=n("multinomial sampling"),ud=n(` and
can be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models.`),fd=m(),w(gt.$$.fragment),_d=m(),w(ht.$$.fragment),yd=m(),te=o("div"),w(Jn.$$.fragment),Md=m(),Un=o("p"),bd=n("Generates sequences of token ids for models with a language modeling head using "),Ao=o("strong"),vd=n("beam search decoding"),wd=n(` and
can be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models.`),Td=m(),w(ut.$$.fragment),jd=m(),w(ft.$$.fragment),Jd=m(),ne=o("div"),w(xn.$$.fragment),Ud=m(),Gn=o("p"),xd=n("Generates sequences of token ids for models with a language modeling head using "),Qo=o("strong"),Gd=n(`beam search multinomial
sampling`),kd=n(" and can be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models."),Ed=m(),w(_t.$$.fragment),Bd=m(),w(yt.$$.fragment),Zd=m(),se=o("div"),w(kn.$$.fragment),Cd=m(),En=o("p"),Id=n("Generates sequences of token ids for models with a language modeling head using "),Do=o("strong"),Wd=n("contrastive search"),Nd=n(` and can
be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models.`),Xd=m(),w(Mt.$$.fragment),Rd=m(),w(bt.$$.fragment),Vd=m(),oe=o("div"),w(Bn.$$.fragment),Sd=m(),Zn=o("p"),$d=n("Generates sequences of token ids for models with a language modeling head using "),Yo=o("strong"),Fd=n(`diverse beam search
decoding`),zd=n(" and can be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models."),Ld=m(),w(vt.$$.fragment),Ad=m(),w(wt.$$.fragment),Qd=m(),ae=o("div"),w(Cn.$$.fragment),Dd=m(),In=o("p"),Yd=n("Generates sequences of token ids for models with a language modeling head using "),Oo=o("strong"),Od=n(`constrained beam search
decoding`),Hd=n(" and can be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models."),qd=m(),w(Tt.$$.fragment),Pd=m(),w(jt.$$.fragment),Ya=m(),De=o("h2"),Jt=o("a"),Ho=o("span"),w(Wn.$$.fragment),Kd=m(),qo=o("span"),ep=n("TFGenerationMixin"),Oa=m(),V=o("div"),w(Nn.$$.fragment),tp=m(),Xn=o("p"),np=n("A class containing all of the functions supporting generation, to be used as a mixin in "),Gs=o("a"),sp=n("TFPreTrainedModel"),op=n("."),ap=m(),Rn=o("p"),rp=n("The class exposes "),ks=o("a"),ip=n("generate()"),lp=n(", which can be used for:"),cp=m(),Te=o("ul"),je=o("li"),Po=o("em"),dp=n("greedy decoding"),pp=n(" by calling "),Ko=o("code"),mp=n("greedy_search()"),gp=n(" if "),ea=o("code"),hp=n("num_beams=1"),up=n(` and
`),ta=o("code"),fp=n("do_sample=False"),_p=m(),Je=o("li"),na=o("em"),yp=n("contrastive search"),Mp=n(" by calling "),sa=o("code"),bp=n("contrastive_search()"),vp=n(" if "),oa=o("code"),wp=n("penalty_alpha>0"),Tp=n(` and
`),aa=o("code"),jp=n("top_k>1"),Jp=m(),Ue=o("li"),ra=o("em"),Up=n("multinomial sampling"),xp=n(" by calling "),ia=o("code"),Gp=n("sample()"),kp=n(" if "),la=o("code"),Ep=n("num_beams=1"),Bp=n(` and
`),ca=o("code"),Zp=n("do_sample=True"),Cp=m(),Ye=o("li"),da=o("em"),Ip=n("beam-search decoding"),Wp=n(" by calling "),pa=o("code"),Np=n("beam_search()"),Xp=n(" if "),ma=o("code"),Rp=n("num_beams>1"),Vp=m(),Vn=o("p"),Sp=n(`You do not need to call any of the above methods directly. Pass custom parameter values to \u2018generate\u2019 instead. To
learn more about decoding strategies refer to the `),Es=o("a"),$p=n("text generation strategies guide"),Fp=n("."),zp=m(),Ce=o("div"),w(Sn.$$.fragment),Lp=m(),ga=o("p"),Ap=n("Generates sequences of token ids for models with a language modeling head."),Qp=m(),w(Ut.$$.fragment),Dp=m(),Ie=o("div"),w($n.$$.fragment),Yp=m(),ha=o("p"),Op=n(`Computes the transition scores of sequences given the generation scores (and beam indices, if beam search was
used). This is a convenient method to quicky obtain the scores of the selected tokens at generation time.`),Hp=m(),w(xt.$$.fragment),Ha=m(),Oe=o("h2"),Gt=o("a"),ua=o("span"),w(Fn.$$.fragment),qp=m(),fa=o("span"),Pp=n("FlaxGenerationMixin"),qa=m(),L=o("div"),w(zn.$$.fragment),Kp=m(),Ln=o("p"),em=n(`A class containing all functions for auto-regressive text generation, to be used as a mixin in
`),Bs=o("a"),tm=n("FlaxPreTrainedModel"),nm=n("."),sm=m(),An=o("p"),om=n("The class exposes "),Zs=o("a"),am=n("generate()"),rm=n(", which can be used for:"),im=m(),He=o("ul"),xe=o("li"),_a=o("em"),lm=n("greedy decoding"),cm=n(" by calling "),ya=o("code"),dm=n("_greedy_search()"),pm=n(" if "),Ma=o("code"),mm=n("num_beams=1"),gm=n(` and
`),ba=o("code"),hm=n("do_sample=False"),um=m(),Ge=o("li"),va=o("em"),fm=n("multinomial sampling"),_m=n(" by calling "),wa=o("code"),ym=n("_sample()"),Mm=n(" if "),Ta=o("code"),bm=n("num_beams=1"),vm=n(` and
`),ja=o("code"),wm=n("do_sample=True"),Tm=m(),ke=o("li"),Ja=o("em"),jm=n("beam-search decoding"),Jm=n(" by calling "),Ua=o("code"),Um=n("_beam_search()"),xm=n(" if "),xa=o("code"),Gm=n("num_beams>1"),km=n(` and
`),Ga=o("code"),Em=n("do_sample=False"),Bm=m(),Qn=o("p"),Zm=n(`You do not need to call any of the above methods directly. Pass custom parameter values to \u2018generate\u2019 instead. To
learn more about decoding strategies refer to the `),Cs=o("a"),Cm=n("text generation strategies guide"),Im=n("."),Wm=m(),kt=o("div"),w(Dn.$$.fragment),Nm=m(),ka=o("p"),Xm=n("Generates sequences of token ids for models with a language modeling head."),this.h()},l(l){const M=cu('[data-svelte="svelte-1phssyn"]',document.head);c=a(M,"META",{name:!0,content:!0}),M.forEach(t),_=g(l),p=a(l,"H1",{class:!0});var Yn=r(p);d=a(Yn,"A",{id:!0,class:!0,href:!0});var Ea=r(d);f=a(Ea,"SPAN",{});var Ba=r(f);T(i.$$.fragment,Ba),Ba.forEach(t),Ea.forEach(t),h=g(Yn),G=a(Yn,"SPAN",{});var Za=r(G);v=s(Za,"Generation"),Za.forEach(t),Yn.forEach(t),y=g(l),E=a(l,"P",{});var On=r(E);B=s(On,"Each framework has a generate method for text generation implemented in their respective "),N=a(On,"CODE",{});var Ca=r(N);ie=s(Ca,"GenerationMixin"),Ca.forEach(t),F=s(On," class:"),On.forEach(t),q=g(l),$=a(l,"UL",{});var qe=r($);Z=a(qe,"LI",{});var Pe=r(Z);I=s(Pe,"PyTorch "),P=a(Pe,"A",{href:!0});var Ia=r(P);Ve=s(Ia,"generate()"),Ia.forEach(t),Se=s(Pe," is implemented in "),A=a(Pe,"A",{href:!0});var Wa=r(A);$e=s(Wa,"GenerationMixin"),Wa.forEach(t),Jr=s(Pe,"."),Pe.forEach(t),Ur=g(qe),Fe=a(qe,"LI",{});var Ke=r(Fe);xr=s(Ke,"TensorFlow "),Pn=a(Ke,"A",{href:!0});var Na=r(Pn);Gr=s(Na,"generate()"),Na.forEach(t),kr=s(Ke," is implemented in "),Kn=a(Ke,"A",{href:!0});var Xa=r(Kn);Er=s(Xa,"TFGenerationMixin"),Xa.forEach(t),Br=s(Ke,"."),Ke.forEach(t),Zr=g(qe),ze=a(qe,"LI",{});var et=r(ze);Cr=s(et,"Flax/JAX "),es=a(et,"A",{href:!0});var Ra=r(es);Ir=s(Ra,"generate()"),Ra.forEach(t),Wr=s(et," is implemented in "),ts=a(et,"A",{href:!0});var Va=r(ts);Nr=s(Va,"FlaxGenerationMixin"),Va.forEach(t),Xr=s(et,"."),et.forEach(t),qe.forEach(t),Fa=g(l),nt=a(l,"P",{});var Hn=r(nt);Rr=s(Hn,"Regardless of your framework of choice, you can parameterize the generate method with a "),ns=a(Hn,"A",{href:!0});var Sa=r(ns);Vr=s(Sa,"GenerationConfig"),Sa.forEach(t),Sr=s(Hn,`
class instance. Please refer to this class for the complete list of generation parameters, which control the behavior
of the generation method.`),Hn.forEach(t),za=g(l),st=a(l,"P",{});var qn=r(st);$r=s(qn,`To learn how to inspect a model\u2019s generation configuration, what are the defaults, how to change the parameters ad hoc,
and how to create and save a customized generation configuration, refer to the
`),ss=a(qn,"A",{href:!0});var Rm=r(ss);Fr=s(Rm,"text generation strategies guide"),Rm.forEach(t),zr=s(qn,`. The guide also explains how to use related features,
like token streaming.`),qn.forEach(t),La=g(l),Le=a(l,"H2",{class:!0});var Ka=r(Le);ot=a(Ka,"A",{id:!0,class:!0,href:!0});var Vm=r(ot);Fs=a(Vm,"SPAN",{});var Sm=r(Fs);T(an.$$.fragment,Sm),Sm.forEach(t),Vm.forEach(t),Lr=g(Ka),zs=a(Ka,"SPAN",{});var $m=r(zs);Ar=s($m,"GenerationConfig"),$m.forEach(t),Ka.forEach(t),Aa=g(l),X=a(l,"DIV",{class:!0});var D=r(X);T(rn.$$.fragment,D),Qr=g(D),ln=a(D,"P",{});var er=r(ln);Dr=s(er,"Class that holds a configuration for a generation task. A "),Ls=a(er,"CODE",{});var Fm=r(Ls);Yr=s(Fm,"generate"),Fm.forEach(t),Or=s(er,` call supports the following generation methods
for text-decoder, text-to-text, speech-to-text, and vision-to-text models:`),er.forEach(t),Hr=g(D),R=a(D,"UL",{});var Q=r(R);le=a(Q,"LI",{});var Et=r(le);As=a(Et,"EM",{});var zm=r(As);qr=s(zm,"greedy decoding"),zm.forEach(t),Pr=s(Et," by calling "),os=a(Et,"A",{href:!0});var Lm=r(os);Kr=s(Lm,"greedy_search()"),Lm.forEach(t),ei=s(Et," if "),Qs=a(Et,"CODE",{});var Am=r(Qs);ti=s(Am,"num_beams=1"),Am.forEach(t),ni=s(Et,` and
`),Ds=a(Et,"CODE",{});var Qm=r(Ds);si=s(Qm,"do_sample=False"),Qm.forEach(t),Et.forEach(t),oi=g(Q),ce=a(Q,"LI",{});var Bt=r(ce);Ys=a(Bt,"EM",{});var Dm=r(Ys);ai=s(Dm,"contrastive search"),Dm.forEach(t),ri=s(Bt," by calling "),as=a(Bt,"A",{href:!0});var Ym=r(as);ii=s(Ym,"contrastive_search()"),Ym.forEach(t),li=s(Bt," if "),Os=a(Bt,"CODE",{});var Om=r(Os);ci=s(Om,"penalty_alpha>0."),Om.forEach(t),di=s(Bt,`
and `),Hs=a(Bt,"CODE",{});var Hm=r(Hs);pi=s(Hm,"top_k>1"),Hm.forEach(t),Bt.forEach(t),mi=g(Q),de=a(Q,"LI",{});var Zt=r(de);qs=a(Zt,"EM",{});var qm=r(qs);gi=s(qm,"multinomial sampling"),qm.forEach(t),hi=s(Zt," by calling "),rs=a(Zt,"A",{href:!0});var Pm=r(rs);ui=s(Pm,"sample()"),Pm.forEach(t),fi=s(Zt," if "),Ps=a(Zt,"CODE",{});var Km=r(Ps);_i=s(Km,"num_beams=1"),Km.forEach(t),yi=s(Zt,` and
`),Ks=a(Zt,"CODE",{});var eg=r(Ks);Mi=s(eg,"do_sample=True"),eg.forEach(t),Zt.forEach(t),bi=g(Q),pe=a(Q,"LI",{});var Ct=r(pe);eo=a(Ct,"EM",{});var tg=r(eo);vi=s(tg,"beam-search decoding"),tg.forEach(t),wi=s(Ct," by calling "),is=a(Ct,"A",{href:!0});var ng=r(is);Ti=s(ng,"beam_search()"),ng.forEach(t),ji=s(Ct," if "),to=a(Ct,"CODE",{});var sg=r(to);Ji=s(sg,"num_beams>1"),sg.forEach(t),Ui=s(Ct,` and
`),no=a(Ct,"CODE",{});var og=r(no);xi=s(og,"do_sample=False"),og.forEach(t),Ct.forEach(t),Gi=g(Q),me=a(Q,"LI",{});var It=r(me);so=a(It,"EM",{});var ag=r(so);ki=s(ag,"beam-search multinomial sampling"),ag.forEach(t),Ei=s(It," by calling "),ls=a(It,"A",{href:!0});var rg=r(ls);Bi=s(rg,"beam_sample()"),rg.forEach(t),Zi=s(It,` if
`),oo=a(It,"CODE",{});var ig=r(oo);Ci=s(ig,"num_beams>1"),ig.forEach(t),Ii=s(It," and "),ao=a(It,"CODE",{});var lg=r(ao);Wi=s(lg,"do_sample=True"),lg.forEach(t),It.forEach(t),Ni=g(Q),ge=a(Q,"LI",{});var Wt=r(ge);ro=a(Wt,"EM",{});var cg=r(ro);Xi=s(cg,"diverse beam-search decoding"),cg.forEach(t),Ri=s(Wt," by calling "),cs=a(Wt,"A",{href:!0});var dg=r(cs);Vi=s(dg,"group_beam_search()"),dg.forEach(t),Si=s(Wt,`, if
`),io=a(Wt,"CODE",{});var pg=r(io);$i=s(pg,"num_beams>1"),pg.forEach(t),Fi=s(Wt," and "),lo=a(Wt,"CODE",{});var mg=r(lo);zi=s(mg,"num_beam_groups>1"),mg.forEach(t),Wt.forEach(t),Li=g(Q),he=a(Q,"LI",{});var Nt=r(he);co=a(Nt,"EM",{});var gg=r(co);Ai=s(gg,"constrained beam-search decoding"),gg.forEach(t),Qi=s(Nt," by calling "),ds=a(Nt,"A",{href:!0});var hg=r(ds);Di=s(hg,"constrained_beam_search()"),hg.forEach(t),Yi=s(Nt,`, if
`),po=a(Nt,"CODE",{});var ug=r(po);Oi=s(ug,"constraints!=None"),ug.forEach(t),Hi=s(Nt," or "),mo=a(Nt,"CODE",{});var fg=r(mo);qi=s(fg,"force_words_ids!=None"),fg.forEach(t),Nt.forEach(t),Pi=g(Q),ue=a(Q,"LI",{});var Xt=r(ue);go=a(Xt,"EM",{});var _g=r(go);Ki=s(_g,"assisted decoding"),_g.forEach(t),el=s(Xt," by calling "),ho=a(Xt,"CODE",{});var yg=r(ho);tl=s(yg,"assisted_decoding()"),yg.forEach(t),nl=s(Xt,`, if
`),uo=a(Xt,"CODE",{});var Mg=r(uo);sl=s(Mg,"assistant_model"),Mg.forEach(t),ol=s(Xt," is passed to "),fo=a(Xt,"CODE",{});var bg=r(fo);al=s(bg,".generate()"),bg.forEach(t),Xt.forEach(t),Q.forEach(t),rl=g(D),cn=a(D,"P",{});var tr=r(cn);il=s(tr,`You do not need to call any of the above methods directly. Pass custom parameter values to \u2018.generate()\u2018. To learn
more about decoding strategies refer to the `),ps=a(tr,"A",{href:!0});var vg=r(ps);ll=s(vg,"text generation strategies guide"),vg.forEach(t),cl=s(tr,"."),tr.forEach(t),dl=g(D),Ee=a(D,"DIV",{class:!0});var Is=r(Ee);T(dn.$$.fragment,Is),pl=g(Is),pn=a(Is,"P",{});var nr=r(pn);ml=s(nr,"Instantiate a "),ms=a(nr,"A",{href:!0});var wg=r(ms);gl=s(wg,"GenerationConfig"),wg.forEach(t),hl=s(nr," from a generation configuration file."),nr.forEach(t),ul=g(Is),T(at.$$.fragment,Is),Is.forEach(t),fl=g(D),rt=a(D,"DIV",{class:!0});var sr=r(rt);T(mn.$$.fragment,sr),_l=g(sr),H=a(sr,"P",{});var We=r(H);yl=s(We,"Instantiates a "),gs=a(We,"A",{href:!0});var Tg=r(gs);Ml=s(Tg,"GenerationConfig"),Tg.forEach(t),bl=s(We," from a "),hs=a(We,"A",{href:!0});var jg=r(hs);vl=s(jg,"PretrainedConfig"),jg.forEach(t),wl=s(We,`. This function is useful to convert legacy
`),us=a(We,"A",{href:!0});var Jg=r(us);Tl=s(Jg,"PretrainedConfig"),Jg.forEach(t),jl=s(We," objects, which may contain generation parameters, into a stand-alone "),fs=a(We,"A",{href:!0});var Ug=r(fs);Jl=s(Ug,"GenerationConfig"),Ug.forEach(t),Ul=s(We,"."),We.forEach(t),sr.forEach(t),xl=g(D),it=a(D,"DIV",{class:!0});var or=r(it);T(gn.$$.fragment,or),Gl=g(or),Ae=a(or,"P",{});var Ws=r(Ae);kl=s(Ws,"Save a generation configuration object to the directory "),_o=a(Ws,"CODE",{});var xg=r(_o);El=s(xg,"save_directory"),xg.forEach(t),Bl=s(Ws,`, so that it can be re-loaded using the
`),_s=a(Ws,"A",{href:!0});var Gg=r(_s);Zl=s(Gg,"from_pretrained()"),Gg.forEach(t),Cl=s(Ws," class method."),Ws.forEach(t),or.forEach(t),D.forEach(t),Qa=g(l),Qe=a(l,"H2",{class:!0});var ar=r(Qe);lt=a(ar,"A",{id:!0,class:!0,href:!0});var kg=r(lt);yo=a(kg,"SPAN",{});var Eg=r(yo);T(hn.$$.fragment,Eg),Eg.forEach(t),kg.forEach(t),Il=g(ar),Mo=a(ar,"SPAN",{});var Bg=r(Mo);Wl=s(Bg,"GenerationMixin"),Bg.forEach(t),ar.forEach(t),Da=g(l),C=a(l,"DIV",{class:!0});var W=r(C);T(un.$$.fragment,W),Nl=g(W),fn=a(W,"P",{});var rr=r(fn);Xl=s(rr,"A class containing all functions for auto-regressive text generation, to be used as a mixin in "),ys=a(rr,"A",{href:!0});var Zg=r(ys);Rl=s(Zg,"PreTrainedModel"),Zg.forEach(t),Vl=s(rr,"."),rr.forEach(t),Sl=g(W),_n=a(W,"P",{});var ir=r(_n);$l=s(ir,"The class exposes "),Ms=a(ir,"A",{href:!0});var Cg=r(Ms);Fl=s(Cg,"generate()"),Cg.forEach(t),zl=s(ir,", which can be used for:"),ir.forEach(t),Ll=g(W),z=a(W,"UL",{});var Y=r(z);fe=a(Y,"LI",{});var Rt=r(fe);bo=a(Rt,"EM",{});var Ig=r(bo);Al=s(Ig,"greedy decoding"),Ig.forEach(t),Ql=s(Rt," by calling "),bs=a(Rt,"A",{href:!0});var Wg=r(bs);Dl=s(Wg,"greedy_search()"),Wg.forEach(t),Yl=s(Rt," if "),vo=a(Rt,"CODE",{});var Ng=r(vo);Ol=s(Ng,"num_beams=1"),Ng.forEach(t),Hl=s(Rt,` and
`),wo=a(Rt,"CODE",{});var Xg=r(wo);ql=s(Xg,"do_sample=False"),Xg.forEach(t),Rt.forEach(t),Pl=g(Y),_e=a(Y,"LI",{});var Vt=r(_e);To=a(Vt,"EM",{});var Rg=r(To);Kl=s(Rg,"contrastive search"),Rg.forEach(t),ec=s(Vt," by calling "),vs=a(Vt,"A",{href:!0});var Vg=r(vs);tc=s(Vg,"contrastive_search()"),Vg.forEach(t),nc=s(Vt," if "),jo=a(Vt,"CODE",{});var Sg=r(jo);sc=s(Sg,"penalty_alpha>0"),Sg.forEach(t),oc=s(Vt,` and
`),Jo=a(Vt,"CODE",{});var $g=r(Jo);ac=s($g,"top_k>1"),$g.forEach(t),Vt.forEach(t),rc=g(Y),ye=a(Y,"LI",{});var St=r(ye);Uo=a(St,"EM",{});var Fg=r(Uo);ic=s(Fg,"multinomial sampling"),Fg.forEach(t),lc=s(St," by calling "),ws=a(St,"A",{href:!0});var zg=r(ws);cc=s(zg,"sample()"),zg.forEach(t),dc=s(St," if "),xo=a(St,"CODE",{});var Lg=r(xo);pc=s(Lg,"num_beams=1"),Lg.forEach(t),mc=s(St,` and
`),Go=a(St,"CODE",{});var Ag=r(Go);gc=s(Ag,"do_sample=True"),Ag.forEach(t),St.forEach(t),hc=g(Y),Me=a(Y,"LI",{});var $t=r(Me);ko=a($t,"EM",{});var Qg=r(ko);uc=s(Qg,"beam-search decoding"),Qg.forEach(t),fc=s($t," by calling "),Ts=a($t,"A",{href:!0});var Dg=r(Ts);_c=s(Dg,"beam_search()"),Dg.forEach(t),yc=s($t," if "),Eo=a($t,"CODE",{});var Yg=r(Eo);Mc=s(Yg,"num_beams>1"),Yg.forEach(t),bc=s($t,` and
`),Bo=a($t,"CODE",{});var Og=r(Bo);vc=s(Og,"do_sample=False"),Og.forEach(t),$t.forEach(t),wc=g(Y),be=a(Y,"LI",{});var Ft=r(be);Zo=a(Ft,"EM",{});var Hg=r(Zo);Tc=s(Hg,"beam-search multinomial sampling"),Hg.forEach(t),jc=s(Ft," by calling "),js=a(Ft,"A",{href:!0});var qg=r(js);Jc=s(qg,"beam_sample()"),qg.forEach(t),Uc=s(Ft," if "),Co=a(Ft,"CODE",{});var Pg=r(Co);xc=s(Pg,"num_beams>1"),Pg.forEach(t),Gc=s(Ft,`
and `),Io=a(Ft,"CODE",{});var Kg=r(Io);kc=s(Kg,"do_sample=True"),Kg.forEach(t),Ft.forEach(t),Ec=g(Y),ve=a(Y,"LI",{});var zt=r(ve);Wo=a(zt,"EM",{});var eh=r(Wo);Bc=s(eh,"diverse beam-search decoding"),eh.forEach(t),Zc=s(zt," by calling "),Js=a(zt,"A",{href:!0});var th=r(Js);Cc=s(th,"group_beam_search()"),th.forEach(t),Ic=s(zt,", if "),No=a(zt,"CODE",{});var nh=r(No);Wc=s(nh,"num_beams>1"),nh.forEach(t),Nc=s(zt,`
and `),Xo=a(zt,"CODE",{});var sh=r(Xo);Xc=s(sh,"num_beam_groups>1"),sh.forEach(t),zt.forEach(t),Rc=g(Y),we=a(Y,"LI",{});var Lt=r(we);Ro=a(Lt,"EM",{});var oh=r(Ro);Vc=s(oh,"constrained beam-search decoding"),oh.forEach(t),Sc=s(Lt," by calling "),Us=a(Lt,"A",{href:!0});var ah=r(Us);$c=s(ah,"constrained_beam_search()"),ah.forEach(t),Fc=s(Lt,`, if
`),Vo=a(Lt,"CODE",{});var rh=r(Vo);zc=s(rh,"constraints!=None"),rh.forEach(t),Lc=s(Lt," or "),So=a(Lt,"CODE",{});var ih=r(So);Ac=s(ih,"force_words_ids!=None"),ih.forEach(t),Lt.forEach(t),Y.forEach(t),Qc=g(W),yn=a(W,"P",{});var lr=r(yn);Dc=s(lr,`You do not need to call any of the above methods directly. Pass custom parameter values to \u2018generate\u2019 instead. To
learn more about decoding strategies refer to the `),xs=a(lr,"A",{href:!0});var lh=r(xs);Yc=s(lh,"text generation strategies guide"),lh.forEach(t),Oc=s(lr,"."),lr.forEach(t),Hc=g(W),Be=a(W,"DIV",{class:!0});var Ns=r(Be);T(Mn.$$.fragment,Ns),qc=g(Ns),$o=a(Ns,"P",{});var ch=r($o);Pc=s(ch,"Generates sequences of token ids for models with a language modeling head."),ch.forEach(t),Kc=g(Ns),T(ct.$$.fragment,Ns),Ns.forEach(t),ed=g(W),Ze=a(W,"DIV",{class:!0});var Xs=r(Ze);T(bn.$$.fragment,Xs),td=g(Xs),Fo=a(Xs,"P",{});var dh=r(Fo);nd=s(dh,`Computes the transition scores of sequences given the generation scores (and beam indices, if beam search was
used). This is a convenient method to quicky obtain the scores of the selected tokens at generation time.`),dh.forEach(t),sd=g(Xs),T(dt.$$.fragment,Xs),Xs.forEach(t),od=g(W),K=a(W,"DIV",{class:!0});var At=r(K);T(vn.$$.fragment,At),ad=g(At),wn=a(At,"P",{});var cr=r(wn);rd=s(cr,"Generates sequences of token ids for models with a language modeling head using "),zo=a(cr,"STRONG",{});var ph=r(zo);id=s(ph,"greedy decoding"),ph.forEach(t),ld=s(cr,` and can be
used for text-decoder, text-to-text, speech-to-text, and vision-to-text models.`),cr.forEach(t),cd=g(At),T(pt.$$.fragment,At),dd=g(At),T(mt.$$.fragment,At),At.forEach(t),pd=g(W),ee=a(W,"DIV",{class:!0});var Qt=r(ee);T(Tn.$$.fragment,Qt),md=g(Qt),jn=a(Qt,"P",{});var dr=r(jn);gd=s(dr,"Generates sequences of token ids for models with a language modeling head using "),Lo=a(dr,"STRONG",{});var mh=r(Lo);hd=s(mh,"multinomial sampling"),mh.forEach(t),ud=s(dr,` and
can be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models.`),dr.forEach(t),fd=g(Qt),T(gt.$$.fragment,Qt),_d=g(Qt),T(ht.$$.fragment,Qt),Qt.forEach(t),yd=g(W),te=a(W,"DIV",{class:!0});var Dt=r(te);T(Jn.$$.fragment,Dt),Md=g(Dt),Un=a(Dt,"P",{});var pr=r(Un);bd=s(pr,"Generates sequences of token ids for models with a language modeling head using "),Ao=a(pr,"STRONG",{});var gh=r(Ao);vd=s(gh,"beam search decoding"),gh.forEach(t),wd=s(pr,` and
can be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models.`),pr.forEach(t),Td=g(Dt),T(ut.$$.fragment,Dt),jd=g(Dt),T(ft.$$.fragment,Dt),Dt.forEach(t),Jd=g(W),ne=a(W,"DIV",{class:!0});var Yt=r(ne);T(xn.$$.fragment,Yt),Ud=g(Yt),Gn=a(Yt,"P",{});var mr=r(Gn);xd=s(mr,"Generates sequences of token ids for models with a language modeling head using "),Qo=a(mr,"STRONG",{});var hh=r(Qo);Gd=s(hh,`beam search multinomial
sampling`),hh.forEach(t),kd=s(mr," and can be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models."),mr.forEach(t),Ed=g(Yt),T(_t.$$.fragment,Yt),Bd=g(Yt),T(yt.$$.fragment,Yt),Yt.forEach(t),Zd=g(W),se=a(W,"DIV",{class:!0});var Ot=r(se);T(kn.$$.fragment,Ot),Cd=g(Ot),En=a(Ot,"P",{});var gr=r(En);Id=s(gr,"Generates sequences of token ids for models with a language modeling head using "),Do=a(gr,"STRONG",{});var uh=r(Do);Wd=s(uh,"contrastive search"),uh.forEach(t),Nd=s(gr,` and can
be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models.`),gr.forEach(t),Xd=g(Ot),T(Mt.$$.fragment,Ot),Rd=g(Ot),T(bt.$$.fragment,Ot),Ot.forEach(t),Vd=g(W),oe=a(W,"DIV",{class:!0});var Ht=r(oe);T(Bn.$$.fragment,Ht),Sd=g(Ht),Zn=a(Ht,"P",{});var hr=r(Zn);$d=s(hr,"Generates sequences of token ids for models with a language modeling head using "),Yo=a(hr,"STRONG",{});var fh=r(Yo);Fd=s(fh,`diverse beam search
decoding`),fh.forEach(t),zd=s(hr," and can be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models."),hr.forEach(t),Ld=g(Ht),T(vt.$$.fragment,Ht),Ad=g(Ht),T(wt.$$.fragment,Ht),Ht.forEach(t),Qd=g(W),ae=a(W,"DIV",{class:!0});var qt=r(ae);T(Cn.$$.fragment,qt),Dd=g(qt),In=a(qt,"P",{});var ur=r(In);Yd=s(ur,"Generates sequences of token ids for models with a language modeling head using "),Oo=a(ur,"STRONG",{});var _h=r(Oo);Od=s(_h,`constrained beam search
decoding`),_h.forEach(t),Hd=s(ur," and can be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models."),ur.forEach(t),qd=g(qt),T(Tt.$$.fragment,qt),Pd=g(qt),T(jt.$$.fragment,qt),qt.forEach(t),W.forEach(t),Ya=g(l),De=a(l,"H2",{class:!0});var fr=r(De);Jt=a(fr,"A",{id:!0,class:!0,href:!0});var yh=r(Jt);Ho=a(yh,"SPAN",{});var Mh=r(Ho);T(Wn.$$.fragment,Mh),Mh.forEach(t),yh.forEach(t),Kd=g(fr),qo=a(fr,"SPAN",{});var bh=r(qo);ep=s(bh,"TFGenerationMixin"),bh.forEach(t),fr.forEach(t),Oa=g(l),V=a(l,"DIV",{class:!0});var O=r(V);T(Nn.$$.fragment,O),tp=g(O),Xn=a(O,"P",{});var _r=r(Xn);np=s(_r,"A class containing all of the functions supporting generation, to be used as a mixin in "),Gs=a(_r,"A",{href:!0});var vh=r(Gs);sp=s(vh,"TFPreTrainedModel"),vh.forEach(t),op=s(_r,"."),_r.forEach(t),ap=g(O),Rn=a(O,"P",{});var yr=r(Rn);rp=s(yr,"The class exposes "),ks=a(yr,"A",{href:!0});var wh=r(ks);ip=s(wh,"generate()"),wh.forEach(t),lp=s(yr,", which can be used for:"),yr.forEach(t),cp=g(O),Te=a(O,"UL",{});var Pt=r(Te);je=a(Pt,"LI",{});var Kt=r(je);Po=a(Kt,"EM",{});var Th=r(Po);dp=s(Th,"greedy decoding"),Th.forEach(t),pp=s(Kt," by calling "),Ko=a(Kt,"CODE",{});var jh=r(Ko);mp=s(jh,"greedy_search()"),jh.forEach(t),gp=s(Kt," if "),ea=a(Kt,"CODE",{});var Jh=r(ea);hp=s(Jh,"num_beams=1"),Jh.forEach(t),up=s(Kt,` and
`),ta=a(Kt,"CODE",{});var Uh=r(ta);fp=s(Uh,"do_sample=False"),Uh.forEach(t),Kt.forEach(t),_p=g(Pt),Je=a(Pt,"LI",{});var en=r(Je);na=a(en,"EM",{});var xh=r(na);yp=s(xh,"contrastive search"),xh.forEach(t),Mp=s(en," by calling "),sa=a(en,"CODE",{});var Gh=r(sa);bp=s(Gh,"contrastive_search()"),Gh.forEach(t),vp=s(en," if "),oa=a(en,"CODE",{});var kh=r(oa);wp=s(kh,"penalty_alpha>0"),kh.forEach(t),Tp=s(en,` and
`),aa=a(en,"CODE",{});var Eh=r(aa);jp=s(Eh,"top_k>1"),Eh.forEach(t),en.forEach(t),Jp=g(Pt),Ue=a(Pt,"LI",{});var tn=r(Ue);ra=a(tn,"EM",{});var Bh=r(ra);Up=s(Bh,"multinomial sampling"),Bh.forEach(t),xp=s(tn," by calling "),ia=a(tn,"CODE",{});var Zh=r(ia);Gp=s(Zh,"sample()"),Zh.forEach(t),kp=s(tn," if "),la=a(tn,"CODE",{});var Ch=r(la);Ep=s(Ch,"num_beams=1"),Ch.forEach(t),Bp=s(tn,` and
`),ca=a(tn,"CODE",{});var Ih=r(ca);Zp=s(Ih,"do_sample=True"),Ih.forEach(t),tn.forEach(t),Cp=g(Pt),Ye=a(Pt,"LI",{});var Rs=r(Ye);da=a(Rs,"EM",{});var Wh=r(da);Ip=s(Wh,"beam-search decoding"),Wh.forEach(t),Wp=s(Rs," by calling "),pa=a(Rs,"CODE",{});var Nh=r(pa);Np=s(Nh,"beam_search()"),Nh.forEach(t),Xp=s(Rs," if "),ma=a(Rs,"CODE",{});var Xh=r(ma);Rp=s(Xh,"num_beams>1"),Xh.forEach(t),Rs.forEach(t),Pt.forEach(t),Vp=g(O),Vn=a(O,"P",{});var Mr=r(Vn);Sp=s(Mr,`You do not need to call any of the above methods directly. Pass custom parameter values to \u2018generate\u2019 instead. To
learn more about decoding strategies refer to the `),Es=a(Mr,"A",{href:!0});var Rh=r(Es);$p=s(Rh,"text generation strategies guide"),Rh.forEach(t),Fp=s(Mr,"."),Mr.forEach(t),zp=g(O),Ce=a(O,"DIV",{class:!0});var Vs=r(Ce);T(Sn.$$.fragment,Vs),Lp=g(Vs),ga=a(Vs,"P",{});var Vh=r(ga);Ap=s(Vh,"Generates sequences of token ids for models with a language modeling head."),Vh.forEach(t),Qp=g(Vs),T(Ut.$$.fragment,Vs),Vs.forEach(t),Dp=g(O),Ie=a(O,"DIV",{class:!0});var Ss=r(Ie);T($n.$$.fragment,Ss),Yp=g(Ss),ha=a(Ss,"P",{});var Sh=r(ha);Op=s(Sh,`Computes the transition scores of sequences given the generation scores (and beam indices, if beam search was
used). This is a convenient method to quicky obtain the scores of the selected tokens at generation time.`),Sh.forEach(t),Hp=g(Ss),T(xt.$$.fragment,Ss),Ss.forEach(t),O.forEach(t),Ha=g(l),Oe=a(l,"H2",{class:!0});var br=r(Oe);Gt=a(br,"A",{id:!0,class:!0,href:!0});var $h=r(Gt);ua=a($h,"SPAN",{});var Fh=r(ua);T(Fn.$$.fragment,Fh),Fh.forEach(t),$h.forEach(t),qp=g(br),fa=a(br,"SPAN",{});var zh=r(fa);Pp=s(zh,"FlaxGenerationMixin"),zh.forEach(t),br.forEach(t),qa=g(l),L=a(l,"DIV",{class:!0});var re=r(L);T(zn.$$.fragment,re),Kp=g(re),Ln=a(re,"P",{});var vr=r(Ln);em=s(vr,`A class containing all functions for auto-regressive text generation, to be used as a mixin in
`),Bs=a(vr,"A",{href:!0});var Lh=r(Bs);tm=s(Lh,"FlaxPreTrainedModel"),Lh.forEach(t),nm=s(vr,"."),vr.forEach(t),sm=g(re),An=a(re,"P",{});var wr=r(An);om=s(wr,"The class exposes "),Zs=a(wr,"A",{href:!0});var Ah=r(Zs);am=s(Ah,"generate()"),Ah.forEach(t),rm=s(wr,", which can be used for:"),wr.forEach(t),im=g(re),He=a(re,"UL",{});var $s=r(He);xe=a($s,"LI",{});var nn=r(xe);_a=a(nn,"EM",{});var Qh=r(_a);lm=s(Qh,"greedy decoding"),Qh.forEach(t),cm=s(nn," by calling "),ya=a(nn,"CODE",{});var Dh=r(ya);dm=s(Dh,"_greedy_search()"),Dh.forEach(t),pm=s(nn," if "),Ma=a(nn,"CODE",{});var Yh=r(Ma);mm=s(Yh,"num_beams=1"),Yh.forEach(t),gm=s(nn,` and
`),ba=a(nn,"CODE",{});var Oh=r(ba);hm=s(Oh,"do_sample=False"),Oh.forEach(t),nn.forEach(t),um=g($s),Ge=a($s,"LI",{});var sn=r(Ge);va=a(sn,"EM",{});var Hh=r(va);fm=s(Hh,"multinomial sampling"),Hh.forEach(t),_m=s(sn," by calling "),wa=a(sn,"CODE",{});var qh=r(wa);ym=s(qh,"_sample()"),qh.forEach(t),Mm=s(sn," if "),Ta=a(sn,"CODE",{});var Ph=r(Ta);bm=s(Ph,"num_beams=1"),Ph.forEach(t),vm=s(sn,` and
`),ja=a(sn,"CODE",{});var Kh=r(ja);wm=s(Kh,"do_sample=True"),Kh.forEach(t),sn.forEach(t),Tm=g($s),ke=a($s,"LI",{});var on=r(ke);Ja=a(on,"EM",{});var eu=r(Ja);jm=s(eu,"beam-search decoding"),eu.forEach(t),Jm=s(on," by calling "),Ua=a(on,"CODE",{});var tu=r(Ua);Um=s(tu,"_beam_search()"),tu.forEach(t),xm=s(on," if "),xa=a(on,"CODE",{});var nu=r(xa);Gm=s(nu,"num_beams>1"),nu.forEach(t),km=s(on,` and
`),Ga=a(on,"CODE",{});var su=r(Ga);Em=s(su,"do_sample=False"),su.forEach(t),on.forEach(t),$s.forEach(t),Bm=g(re),Qn=a(re,"P",{});var Tr=r(Qn);Zm=s(Tr,`You do not need to call any of the above methods directly. Pass custom parameter values to \u2018generate\u2019 instead. To
learn more about decoding strategies refer to the `),Cs=a(Tr,"A",{href:!0});var ou=r(Cs);Cm=s(ou,"text generation strategies guide"),ou.forEach(t),Im=s(Tr,"."),Tr.forEach(t),Wm=g(re),kt=a(re,"DIV",{class:!0});var jr=r(kt);T(Dn.$$.fragment,jr),Nm=g(jr),ka=a(jr,"P",{});var au=r(ka);Xm=s(au,"Generates sequences of token ids for models with a language modeling head."),au.forEach(t),jr.forEach(t),re.forEach(t),this.h()},h(){u(c,"name","hf:doc:metadata"),u(c,"content",JSON.stringify(Bu)),u(d,"id","generation"),u(d,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(d,"href","#generation"),u(p,"class","relative group"),u(P,"href","/docs/transformers/v4.32.1/en/main_classes/text_generation#transformers.GenerationMixin.generate"),u(A,"href","/docs/transformers/v4.32.1/en/main_classes/text_generation#transformers.GenerationMixin"),u(Pn,"href","/docs/transformers/v4.32.1/en/main_classes/text_generation#transformers.TFGenerationMixin.generate"),u(Kn,"href","/docs/transformers/v4.32.1/en/main_classes/text_generation#transformers.TFGenerationMixin"),u(es,"href","/docs/transformers/v4.32.1/en/main_classes/text_generation#transformers.FlaxGenerationMixin.generate"),u(ts,"href","/docs/transformers/v4.32.1/en/main_classes/text_generation#transformers.FlaxGenerationMixin"),u(ns,"href","/docs/transformers/v4.32.1/en/main_classes/text_generation#transformers.GenerationConfig"),u(ss,"href","../generation_strategies"),u(ot,"id","transformers.GenerationConfig"),u(ot,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(ot,"href","#transformers.GenerationConfig"),u(Le,"class","relative group"),u(os,"href","/docs/transformers/v4.32.1/en/main_classes/text_generation#transformers.GenerationMixin.greedy_search"),u(as,"href","/docs/transformers/v4.32.1/en/main_classes/text_generation#transformers.GenerationMixin.contrastive_search"),u(rs,"href","/docs/transformers/v4.32.1/en/main_classes/text_generation#transformers.GenerationMixin.sample"),u(is,"href","/docs/transformers/v4.32.1/en/main_classes/text_generation#transformers.GenerationMixin.beam_search"),u(ls,"href","/docs/transformers/v4.32.1/en/main_classes/text_generation#transformers.GenerationMixin.beam_sample"),u(cs,"href","/docs/transformers/v4.32.1/en/main_classes/text_generation#transformers.GenerationMixin.group_beam_search"),u(ds,"href","/docs/transformers/v4.32.1/en/main_classes/text_generation#transformers.GenerationMixin.constrained_beam_search"),u(ps,"href","../generation_strategies"),u(ms,"href","/docs/transformers/v4.32.1/en/main_classes/text_generation#transformers.GenerationConfig"),u(Ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(gs,"href","/docs/transformers/v4.32.1/en/main_classes/text_generation#transformers.GenerationConfig"),u(hs,"href","/docs/transformers/v4.32.1/en/main_classes/configuration#transformers.PretrainedConfig"),u(us,"href","/docs/transformers/v4.32.1/en/main_classes/configuration#transformers.PretrainedConfig"),u(fs,"href","/docs/transformers/v4.32.1/en/main_classes/text_generation#transformers.GenerationConfig"),u(rt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(_s,"href","/docs/transformers/v4.32.1/en/main_classes/text_generation#transformers.GenerationConfig.from_pretrained"),u(it,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(lt,"id","transformers.GenerationMixin"),u(lt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(lt,"href","#transformers.GenerationMixin"),u(Qe,"class","relative group"),u(ys,"href","/docs/transformers/v4.32.1/en/main_classes/model#transformers.PreTrainedModel"),u(Ms,"href","/docs/transformers/v4.32.1/en/main_classes/text_generation#transformers.GenerationMixin.generate"),u(bs,"href","/docs/transformers/v4.32.1/en/main_classes/text_generation#transformers.GenerationMixin.greedy_search"),u(vs,"href","/docs/transformers/v4.32.1/en/main_classes/text_generation#transformers.GenerationMixin.contrastive_search"),u(ws,"href","/docs/transformers/v4.32.1/en/main_classes/text_generation#transformers.GenerationMixin.sample"),u(Ts,"href","/docs/transformers/v4.32.1/en/main_classes/text_generation#transformers.GenerationMixin.beam_search"),u(js,"href","/docs/transformers/v4.32.1/en/main_classes/text_generation#transformers.GenerationMixin.beam_sample"),u(Js,"href","/docs/transformers/v4.32.1/en/main_classes/text_generation#transformers.GenerationMixin.group_beam_search"),u(Us,"href","/docs/transformers/v4.32.1/en/main_classes/text_generation#transformers.GenerationMixin.constrained_beam_search"),u(xs,"href","../generation_strategies"),u(Be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(Ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(Jt,"id","transformers.TFGenerationMixin"),u(Jt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(Jt,"href","#transformers.TFGenerationMixin"),u(De,"class","relative group"),u(Gs,"href","/docs/transformers/v4.32.1/en/main_classes/model#transformers.TFPreTrainedModel"),u(ks,"href","/docs/transformers/v4.32.1/en/main_classes/text_generation#transformers.TFGenerationMixin.generate"),u(Es,"href","../generation_strategies"),u(Ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(Ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(Gt,"id","transformers.FlaxGenerationMixin"),u(Gt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(Gt,"href","#transformers.FlaxGenerationMixin"),u(Oe,"class","relative group"),u(Bs,"href","/docs/transformers/v4.32.1/en/main_classes/model#transformers.FlaxPreTrainedModel"),u(Zs,"href","/docs/transformers/v4.32.1/en/main_classes/text_generation#transformers.FlaxGenerationMixin.generate"),u(Cs,"href","../generation_strategies"),u(kt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(l,M){e(document.head,c),b(l,_,M),b(l,p,M),e(p,d),e(d,f),j(i,f,null),e(p,h),e(p,G),e(G,v),b(l,y,M),b(l,E,M),e(E,B),e(E,N),e(N,ie),e(E,F),b(l,q,M),b(l,$,M),e($,Z),e(Z,I),e(Z,P),e(P,Ve),e(Z,Se),e(Z,A),e(A,$e),e(Z,Jr),e($,Ur),e($,Fe),e(Fe,xr),e(Fe,Pn),e(Pn,Gr),e(Fe,kr),e(Fe,Kn),e(Kn,Er),e(Fe,Br),e($,Zr),e($,ze),e(ze,Cr),e(ze,es),e(es,Ir),e(ze,Wr),e(ze,ts),e(ts,Nr),e(ze,Xr),b(l,Fa,M),b(l,nt,M),e(nt,Rr),e(nt,ns),e(ns,Vr),e(nt,Sr),b(l,za,M),b(l,st,M),e(st,$r),e(st,ss),e(ss,Fr),e(st,zr),b(l,La,M),b(l,Le,M),e(Le,ot),e(ot,Fs),j(an,Fs,null),e(Le,Lr),e(Le,zs),e(zs,Ar),b(l,Aa,M),b(l,X,M),j(rn,X,null),e(X,Qr),e(X,ln),e(ln,Dr),e(ln,Ls),e(Ls,Yr),e(ln,Or),e(X,Hr),e(X,R),e(R,le),e(le,As),e(As,qr),e(le,Pr),e(le,os),e(os,Kr),e(le,ei),e(le,Qs),e(Qs,ti),e(le,ni),e(le,Ds),e(Ds,si),e(R,oi),e(R,ce),e(ce,Ys),e(Ys,ai),e(ce,ri),e(ce,as),e(as,ii),e(ce,li),e(ce,Os),e(Os,ci),e(ce,di),e(ce,Hs),e(Hs,pi),e(R,mi),e(R,de),e(de,qs),e(qs,gi),e(de,hi),e(de,rs),e(rs,ui),e(de,fi),e(de,Ps),e(Ps,_i),e(de,yi),e(de,Ks),e(Ks,Mi),e(R,bi),e(R,pe),e(pe,eo),e(eo,vi),e(pe,wi),e(pe,is),e(is,Ti),e(pe,ji),e(pe,to),e(to,Ji),e(pe,Ui),e(pe,no),e(no,xi),e(R,Gi),e(R,me),e(me,so),e(so,ki),e(me,Ei),e(me,ls),e(ls,Bi),e(me,Zi),e(me,oo),e(oo,Ci),e(me,Ii),e(me,ao),e(ao,Wi),e(R,Ni),e(R,ge),e(ge,ro),e(ro,Xi),e(ge,Ri),e(ge,cs),e(cs,Vi),e(ge,Si),e(ge,io),e(io,$i),e(ge,Fi),e(ge,lo),e(lo,zi),e(R,Li),e(R,he),e(he,co),e(co,Ai),e(he,Qi),e(he,ds),e(ds,Di),e(he,Yi),e(he,po),e(po,Oi),e(he,Hi),e(he,mo),e(mo,qi),e(R,Pi),e(R,ue),e(ue,go),e(go,Ki),e(ue,el),e(ue,ho),e(ho,tl),e(ue,nl),e(ue,uo),e(uo,sl),e(ue,ol),e(ue,fo),e(fo,al),e(X,rl),e(X,cn),e(cn,il),e(cn,ps),e(ps,ll),e(cn,cl),e(X,dl),e(X,Ee),j(dn,Ee,null),e(Ee,pl),e(Ee,pn),e(pn,ml),e(pn,ms),e(ms,gl),e(pn,hl),e(Ee,ul),j(at,Ee,null),e(X,fl),e(X,rt),j(mn,rt,null),e(rt,_l),e(rt,H),e(H,yl),e(H,gs),e(gs,Ml),e(H,bl),e(H,hs),e(hs,vl),e(H,wl),e(H,us),e(us,Tl),e(H,jl),e(H,fs),e(fs,Jl),e(H,Ul),e(X,xl),e(X,it),j(gn,it,null),e(it,Gl),e(it,Ae),e(Ae,kl),e(Ae,_o),e(_o,El),e(Ae,Bl),e(Ae,_s),e(_s,Zl),e(Ae,Cl),b(l,Qa,M),b(l,Qe,M),e(Qe,lt),e(lt,yo),j(hn,yo,null),e(Qe,Il),e(Qe,Mo),e(Mo,Wl),b(l,Da,M),b(l,C,M),j(un,C,null),e(C,Nl),e(C,fn),e(fn,Xl),e(fn,ys),e(ys,Rl),e(fn,Vl),e(C,Sl),e(C,_n),e(_n,$l),e(_n,Ms),e(Ms,Fl),e(_n,zl),e(C,Ll),e(C,z),e(z,fe),e(fe,bo),e(bo,Al),e(fe,Ql),e(fe,bs),e(bs,Dl),e(fe,Yl),e(fe,vo),e(vo,Ol),e(fe,Hl),e(fe,wo),e(wo,ql),e(z,Pl),e(z,_e),e(_e,To),e(To,Kl),e(_e,ec),e(_e,vs),e(vs,tc),e(_e,nc),e(_e,jo),e(jo,sc),e(_e,oc),e(_e,Jo),e(Jo,ac),e(z,rc),e(z,ye),e(ye,Uo),e(Uo,ic),e(ye,lc),e(ye,ws),e(ws,cc),e(ye,dc),e(ye,xo),e(xo,pc),e(ye,mc),e(ye,Go),e(Go,gc),e(z,hc),e(z,Me),e(Me,ko),e(ko,uc),e(Me,fc),e(Me,Ts),e(Ts,_c),e(Me,yc),e(Me,Eo),e(Eo,Mc),e(Me,bc),e(Me,Bo),e(Bo,vc),e(z,wc),e(z,be),e(be,Zo),e(Zo,Tc),e(be,jc),e(be,js),e(js,Jc),e(be,Uc),e(be,Co),e(Co,xc),e(be,Gc),e(be,Io),e(Io,kc),e(z,Ec),e(z,ve),e(ve,Wo),e(Wo,Bc),e(ve,Zc),e(ve,Js),e(Js,Cc),e(ve,Ic),e(ve,No),e(No,Wc),e(ve,Nc),e(ve,Xo),e(Xo,Xc),e(z,Rc),e(z,we),e(we,Ro),e(Ro,Vc),e(we,Sc),e(we,Us),e(Us,$c),e(we,Fc),e(we,Vo),e(Vo,zc),e(we,Lc),e(we,So),e(So,Ac),e(C,Qc),e(C,yn),e(yn,Dc),e(yn,xs),e(xs,Yc),e(yn,Oc),e(C,Hc),e(C,Be),j(Mn,Be,null),e(Be,qc),e(Be,$o),e($o,Pc),e(Be,Kc),j(ct,Be,null),e(C,ed),e(C,Ze),j(bn,Ze,null),e(Ze,td),e(Ze,Fo),e(Fo,nd),e(Ze,sd),j(dt,Ze,null),e(C,od),e(C,K),j(vn,K,null),e(K,ad),e(K,wn),e(wn,rd),e(wn,zo),e(zo,id),e(wn,ld),e(K,cd),j(pt,K,null),e(K,dd),j(mt,K,null),e(C,pd),e(C,ee),j(Tn,ee,null),e(ee,md),e(ee,jn),e(jn,gd),e(jn,Lo),e(Lo,hd),e(jn,ud),e(ee,fd),j(gt,ee,null),e(ee,_d),j(ht,ee,null),e(C,yd),e(C,te),j(Jn,te,null),e(te,Md),e(te,Un),e(Un,bd),e(Un,Ao),e(Ao,vd),e(Un,wd),e(te,Td),j(ut,te,null),e(te,jd),j(ft,te,null),e(C,Jd),e(C,ne),j(xn,ne,null),e(ne,Ud),e(ne,Gn),e(Gn,xd),e(Gn,Qo),e(Qo,Gd),e(Gn,kd),e(ne,Ed),j(_t,ne,null),e(ne,Bd),j(yt,ne,null),e(C,Zd),e(C,se),j(kn,se,null),e(se,Cd),e(se,En),e(En,Id),e(En,Do),e(Do,Wd),e(En,Nd),e(se,Xd),j(Mt,se,null),e(se,Rd),j(bt,se,null),e(C,Vd),e(C,oe),j(Bn,oe,null),e(oe,Sd),e(oe,Zn),e(Zn,$d),e(Zn,Yo),e(Yo,Fd),e(Zn,zd),e(oe,Ld),j(vt,oe,null),e(oe,Ad),j(wt,oe,null),e(C,Qd),e(C,ae),j(Cn,ae,null),e(ae,Dd),e(ae,In),e(In,Yd),e(In,Oo),e(Oo,Od),e(In,Hd),e(ae,qd),j(Tt,ae,null),e(ae,Pd),j(jt,ae,null),b(l,Ya,M),b(l,De,M),e(De,Jt),e(Jt,Ho),j(Wn,Ho,null),e(De,Kd),e(De,qo),e(qo,ep),b(l,Oa,M),b(l,V,M),j(Nn,V,null),e(V,tp),e(V,Xn),e(Xn,np),e(Xn,Gs),e(Gs,sp),e(Xn,op),e(V,ap),e(V,Rn),e(Rn,rp),e(Rn,ks),e(ks,ip),e(Rn,lp),e(V,cp),e(V,Te),e(Te,je),e(je,Po),e(Po,dp),e(je,pp),e(je,Ko),e(Ko,mp),e(je,gp),e(je,ea),e(ea,hp),e(je,up),e(je,ta),e(ta,fp),e(Te,_p),e(Te,Je),e(Je,na),e(na,yp),e(Je,Mp),e(Je,sa),e(sa,bp),e(Je,vp),e(Je,oa),e(oa,wp),e(Je,Tp),e(Je,aa),e(aa,jp),e(Te,Jp),e(Te,Ue),e(Ue,ra),e(ra,Up),e(Ue,xp),e(Ue,ia),e(ia,Gp),e(Ue,kp),e(Ue,la),e(la,Ep),e(Ue,Bp),e(Ue,ca),e(ca,Zp),e(Te,Cp),e(Te,Ye),e(Ye,da),e(da,Ip),e(Ye,Wp),e(Ye,pa),e(pa,Np),e(Ye,Xp),e(Ye,ma),e(ma,Rp),e(V,Vp),e(V,Vn),e(Vn,Sp),e(Vn,Es),e(Es,$p),e(Vn,Fp),e(V,zp),e(V,Ce),j(Sn,Ce,null),e(Ce,Lp),e(Ce,ga),e(ga,Ap),e(Ce,Qp),j(Ut,Ce,null),e(V,Dp),e(V,Ie),j($n,Ie,null),e(Ie,Yp),e(Ie,ha),e(ha,Op),e(Ie,Hp),j(xt,Ie,null),b(l,Ha,M),b(l,Oe,M),e(Oe,Gt),e(Gt,ua),j(Fn,ua,null),e(Oe,qp),e(Oe,fa),e(fa,Pp),b(l,qa,M),b(l,L,M),j(zn,L,null),e(L,Kp),e(L,Ln),e(Ln,em),e(Ln,Bs),e(Bs,tm),e(Ln,nm),e(L,sm),e(L,An),e(An,om),e(An,Zs),e(Zs,am),e(An,rm),e(L,im),e(L,He),e(He,xe),e(xe,_a),e(_a,lm),e(xe,cm),e(xe,ya),e(ya,dm),e(xe,pm),e(xe,Ma),e(Ma,mm),e(xe,gm),e(xe,ba),e(ba,hm),e(He,um),e(He,Ge),e(Ge,va),e(va,fm),e(Ge,_m),e(Ge,wa),e(wa,ym),e(Ge,Mm),e(Ge,Ta),e(Ta,bm),e(Ge,vm),e(Ge,ja),e(ja,wm),e(He,Tm),e(He,ke),e(ke,Ja),e(Ja,jm),e(ke,Jm),e(ke,Ua),e(Ua,Um),e(ke,xm),e(ke,xa),e(xa,Gm),e(ke,km),e(ke,Ga),e(Ga,Em),e(L,Bm),e(L,Qn),e(Qn,Zm),e(Qn,Cs),e(Cs,Cm),e(Qn,Im),e(L,Wm),e(L,kt),j(Dn,kt,null),e(kt,Nm),e(kt,ka),e(ka,Xm),Pa=!0},p(l,[M]){const Yn={};M&2&&(Yn.$$scope={dirty:M,ctx:l}),at.$set(Yn);const Ea={};M&2&&(Ea.$$scope={dirty:M,ctx:l}),ct.$set(Ea);const Ba={};M&2&&(Ba.$$scope={dirty:M,ctx:l}),dt.$set(Ba);const Za={};M&2&&(Za.$$scope={dirty:M,ctx:l}),pt.$set(Za);const On={};M&2&&(On.$$scope={dirty:M,ctx:l}),mt.$set(On);const Ca={};M&2&&(Ca.$$scope={dirty:M,ctx:l}),gt.$set(Ca);const qe={};M&2&&(qe.$$scope={dirty:M,ctx:l}),ht.$set(qe);const Pe={};M&2&&(Pe.$$scope={dirty:M,ctx:l}),ut.$set(Pe);const Ia={};M&2&&(Ia.$$scope={dirty:M,ctx:l}),ft.$set(Ia);const Wa={};M&2&&(Wa.$$scope={dirty:M,ctx:l}),_t.$set(Wa);const Ke={};M&2&&(Ke.$$scope={dirty:M,ctx:l}),yt.$set(Ke);const Na={};M&2&&(Na.$$scope={dirty:M,ctx:l}),Mt.$set(Na);const Xa={};M&2&&(Xa.$$scope={dirty:M,ctx:l}),bt.$set(Xa);const et={};M&2&&(et.$$scope={dirty:M,ctx:l}),vt.$set(et);const Ra={};M&2&&(Ra.$$scope={dirty:M,ctx:l}),wt.$set(Ra);const Va={};M&2&&(Va.$$scope={dirty:M,ctx:l}),Tt.$set(Va);const Hn={};M&2&&(Hn.$$scope={dirty:M,ctx:l}),jt.$set(Hn);const Sa={};M&2&&(Sa.$$scope={dirty:M,ctx:l}),Ut.$set(Sa);const qn={};M&2&&(qn.$$scope={dirty:M,ctx:l}),xt.$set(qn)},i(l){Pa||(J(i.$$.fragment,l),J(an.$$.fragment,l),J(rn.$$.fragment,l),J(dn.$$.fragment,l),J(at.$$.fragment,l),J(mn.$$.fragment,l),J(gn.$$.fragment,l),J(hn.$$.fragment,l),J(un.$$.fragment,l),J(Mn.$$.fragment,l),J(ct.$$.fragment,l),J(bn.$$.fragment,l),J(dt.$$.fragment,l),J(vn.$$.fragment,l),J(pt.$$.fragment,l),J(mt.$$.fragment,l),J(Tn.$$.fragment,l),J(gt.$$.fragment,l),J(ht.$$.fragment,l),J(Jn.$$.fragment,l),J(ut.$$.fragment,l),J(ft.$$.fragment,l),J(xn.$$.fragment,l),J(_t.$$.fragment,l),J(yt.$$.fragment,l),J(kn.$$.fragment,l),J(Mt.$$.fragment,l),J(bt.$$.fragment,l),J(Bn.$$.fragment,l),J(vt.$$.fragment,l),J(wt.$$.fragment,l),J(Cn.$$.fragment,l),J(Tt.$$.fragment,l),J(jt.$$.fragment,l),J(Wn.$$.fragment,l),J(Nn.$$.fragment,l),J(Sn.$$.fragment,l),J(Ut.$$.fragment,l),J($n.$$.fragment,l),J(xt.$$.fragment,l),J(Fn.$$.fragment,l),J(zn.$$.fragment,l),J(Dn.$$.fragment,l),Pa=!0)},o(l){U(i.$$.fragment,l),U(an.$$.fragment,l),U(rn.$$.fragment,l),U(dn.$$.fragment,l),U(at.$$.fragment,l),U(mn.$$.fragment,l),U(gn.$$.fragment,l),U(hn.$$.fragment,l),U(un.$$.fragment,l),U(Mn.$$.fragment,l),U(ct.$$.fragment,l),U(bn.$$.fragment,l),U(dt.$$.fragment,l),U(vn.$$.fragment,l),U(pt.$$.fragment,l),U(mt.$$.fragment,l),U(Tn.$$.fragment,l),U(gt.$$.fragment,l),U(ht.$$.fragment,l),U(Jn.$$.fragment,l),U(ut.$$.fragment,l),U(ft.$$.fragment,l),U(xn.$$.fragment,l),U(_t.$$.fragment,l),U(yt.$$.fragment,l),U(kn.$$.fragment,l),U(Mt.$$.fragment,l),U(bt.$$.fragment,l),U(Bn.$$.fragment,l),U(vt.$$.fragment,l),U(wt.$$.fragment,l),U(Cn.$$.fragment,l),U(Tt.$$.fragment,l),U(jt.$$.fragment,l),U(Wn.$$.fragment,l),U(Nn.$$.fragment,l),U(Sn.$$.fragment,l),U(Ut.$$.fragment,l),U($n.$$.fragment,l),U(xt.$$.fragment,l),U(Fn.$$.fragment,l),U(zn.$$.fragment,l),U(Dn.$$.fragment,l),Pa=!1},d(l){t(c),l&&t(_),l&&t(p),x(i),l&&t(y),l&&t(E),l&&t(q),l&&t($),l&&t(Fa),l&&t(nt),l&&t(za),l&&t(st),l&&t(La),l&&t(Le),x(an),l&&t(Aa),l&&t(X),x(rn),x(dn),x(at),x(mn),x(gn),l&&t(Qa),l&&t(Qe),x(hn),l&&t(Da),l&&t(C),x(un),x(Mn),x(ct),x(bn),x(dt),x(vn),x(pt),x(mt),x(Tn),x(gt),x(ht),x(Jn),x(ut),x(ft),x(xn),x(_t),x(yt),x(kn),x(Mt),x(bt),x(Bn),x(vt),x(wt),x(Cn),x(Tt),x(jt),l&&t(Ya),l&&t(De),x(Wn),l&&t(Oa),l&&t(V),x(Nn),x(Sn),x(Ut),x($n),x(xt),l&&t(Ha),l&&t(Oe),x(Fn),l&&t(qa),l&&t(L),x(zn),x(Dn)}}}const Bu={local:"generation",sections:[{local:"transformers.GenerationConfig",title:"GenerationConfig"},{local:"transformers.GenerationMixin",title:"GenerationMixin"},{local:"transformers.TFGenerationMixin",title:"TFGenerationMixin"},{local:"transformers.FlaxGenerationMixin",title:"FlaxGenerationMixin"}],title:"Generation"};function Zu(k){return du(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Vu extends ru{constructor(c){super();iu(this,c,Zu,Eu,lu,{})}}export{Vu as default,Bu as metadata};
