import{s as co,o as mo,n as Q}from"../chunks/scheduler.9bc65507.js";import{S as po,i as fo,g as m,s as a,r as u,A as ho,h as p,f as s,c as r,j as N,u as _,x as h,k as F,y as d,a as c,v as b,d as v,t as y,w as T}from"../chunks/index.707bf1b6.js";import{T as Bt}from"../chunks/Tip.c2ecdbf4.js";import{D as V}from"../chunks/Docstring.570ddb64.js";import{C as Ee}from"../chunks/CodeBlock.54a9f38d.js";import{E as Ve}from"../chunks/ExampleCodeBlock.bc2be6bc.js";import{H as ve,E as go}from"../chunks/EditOnGithub.922df6ba.js";function uo(x){let o,M="IDEFICS modeling code in Transformers is for finetuning and inferencing the pre-trained IDEFICS models.",l,i,f="To train a new IDEFICS model from scratch use the m4 codebase (a link will be provided once it’s made public)";return{c(){o=m("p"),o.textContent=M,l=a(),i=m("p"),i.textContent=f},l(t){o=p(t,"P",{"data-svelte-h":!0}),h(o)!=="svelte-1avuyik"&&(o.textContent=M),l=r(t),i=p(t,"P",{"data-svelte-h":!0}),h(i)!=="svelte-22xyvf"&&(i.textContent=f)},m(t,g){c(t,o,g),c(t,l,g),c(t,i,g)},p:Q,d(t){t&&(s(o),s(l),s(i))}}}function _o(x){let o,M="Example:",l,i,f;return i=new Ee({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMElkZWZpY3NNb2RlbCUyQyUyMElkZWZpY3NDb25maWclMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwSWRlZmljcyUyMGlkZWZpY3MtOWIlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwSWRlZmljc0NvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwZnJvbSUyMHRoZSUyMGlkZWZpY3MtOWIlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMElkZWZpY3NNb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> IdeficsModel, IdeficsConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Idefics idefics-9b style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = IdeficsConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the idefics-9b style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = IdeficsModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){o=m("p"),o.textContent=M,l=a(),u(i.$$.fragment)},l(t){o=p(t,"P",{"data-svelte-h":!0}),h(o)!=="svelte-11lpom8"&&(o.textContent=M),l=r(t),_(i.$$.fragment,t)},m(t,g){c(t,o,g),c(t,l,g),b(i,t,g),f=!0},p:Q,i(t){f||(v(i.$$.fragment,t),f=!0)},o(t){y(i.$$.fragment,t),f=!1},d(t){t&&(s(o),s(l)),T(i,t)}}}function bo(x){let o,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=m("p"),o.innerHTML=M},l(l){o=p(l,"P",{"data-svelte-h":!0}),h(o)!=="svelte-fincs2"&&(o.innerHTML=M)},m(l,i){c(l,o,i)},p:Q,d(l){l&&s(o)}}}function vo(x){let o,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=m("p"),o.innerHTML=M},l(l){o=p(l,"P",{"data-svelte-h":!0}),h(o)!=="svelte-fincs2"&&(o.innerHTML=M)},m(l,i){c(l,o,i)},p:Q,d(l){l&&s(o)}}}function yo(x){let o,M="Example:",l,i,f;return i=new Ee({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBJZGVmaWNzRm9yVmlzaW9uVGV4dDJUZXh0JTBBJTBBbW9kZWwlMjAlM0QlMjBJZGVmaWNzRm9yVmlzaW9uVGV4dDJUZXh0LmZyb21fcHJldHJhaW5lZCglMjJIdWdnaW5nRmFjZU00JTJGaWRlZmljcy05YiUyMiklMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJIdWdnaW5nRmFjZU00JTJGaWRlZmljcy05YiUyMiklMEElMEFkb2dzX2ltYWdlX3VybF8xJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaGYtaW50ZXJuYWwtdGVzdGluZyUyRmZpeHR1cmVzX25sdnIyJTJGcmF3JTJGbWFpbiUyRmltYWdlMS5qcGVnJTIyJTBBZG9nc19pbWFnZV91cmxfMiUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmhmLWludGVybmFsLXRlc3RpbmclMkZmaXh0dXJlc19ubHZyMiUyRnJhdyUyRm1haW4lMkZpbWFnZTIuanBlZyUyMiUwQSUwQXByb21wdHMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJVc2VyJTNBJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZG9nc19pbWFnZV91cmxfMSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkRlc2NyaWJlJTIwdGhpcyUyMGltYWdlLiU1Q25Bc3Npc3RhbnQlM0ElMjBBbiUyMGltYWdlJTIwb2YlMjB0d28lMjBkb2dzLiU1Q24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJVc2VyJTNBJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZG9nc19pbWFnZV91cmxfMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkRlc2NyaWJlJTIwdGhpcyUyMGltYWdlLiU1Q25Bc3Npc3RhbnQlM0ElMjIlMkMlMEElMjAlMjAlMjAlMjAlNUQlMEElNUQlMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IocHJvbXB0cyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBZ2VuZXJhdGVfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDYpJTBBcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZV9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, IdeficsForVisionText2Text

<span class="hljs-meta">&gt;&gt;&gt; </span>model = IdeficsForVisionText2Text.from_pretrained(<span class="hljs-string">&quot;HuggingFaceM4/idefics-9b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;HuggingFaceM4/idefics-9b&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>dogs_image_url_1 = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/fixtures_nlvr2/raw/main/image1.jpeg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dogs_image_url_2 = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/fixtures_nlvr2/raw/main/image2.jpeg&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>prompts = [
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;User:&quot;</span>,
<span class="hljs-meta">... </span>        dogs_image_url_1,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;Describe this image.\\nAssistant: An image of two dogs.\\n&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;User:&quot;</span>,
<span class="hljs-meta">... </span>        dogs_image_url_2,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;Describe this image.\\nAssistant:&quot;</span>,
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(prompts, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">6</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){o=m("p"),o.textContent=M,l=a(),u(i.$$.fragment)},l(t){o=p(t,"P",{"data-svelte-h":!0}),h(o)!=="svelte-11lpom8"&&(o.textContent=M),l=r(t),_(i.$$.fragment,t)},m(t,g){c(t,o,g),c(t,l,g),b(i,t,g),f=!0},p:Q,i(t){f||(v(i.$$.fragment,t),f=!0)},o(t){y(i.$$.fragment,t),f=!1},d(t){t&&(s(o),s(l)),T(i,t)}}}function To(x){let o,M="Example:",l,i,f;return i=new Ee({props:{code:"Y2hlY2twb2ludCUyMCUzRCUyMCUyMkh1Z2dpbmdGYWNlTTQlMkZpZGVmaWNzLTliJTIyJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCklMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmhpcHMuaGVhcnN0YXBwcy5jb20lMkZobWctcHJvZCUyRmltYWdlcyUyRmN1dGUtcGhvdG9zLW9mLWNhdHMtaW4tZ3Jhc3MtMTU5MzE4NDc3Ny5qcGclMjIlMEFpbWclMjAlM0QlMjBwcm9jZXNzb3IuaW1hZ2VfcHJvY2Vzc29yLmZldGNoX2ltYWdlcyglNUJ1cmwlNUQpJTVCMCU1RCUwQSUwQXByb21wdHMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJVc2VyJTNBJTIyJTJDJTBBJTIwJTIwJTIwJTIwaW1nJTJDJTBBJTIwJTIwJTIwJTIwJTIyRGVzY3JpYmUlMjB0aGlzJTIwaW1hZ2UuJTBBdCUzQSUyMEFuJTIwaW1hZ2UlMjBvZiUyMHR3byUyMGtpdHRlbnMlMjBpbiUyMGdyYXNzLiUwQSUwQSUyMCUyMCUyMCUyMCUyMlVzZXIlM0ElMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmhpcHMuaGVhcnN0YXBwcy5jb20lMkZobWctcHJvZCUyRmltYWdlcyUyRmRvZy1wdW5zLTE1ODE3MDgyMDguanBnJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyRGVzY3JpYmUlMjB0aGlzJTIwaW1hZ2UuJTBBdCUzQSUyMiUyQyUwQSU1RCUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvcihwcm9tcHRzJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFnZW5lcmF0ZWRfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbGVuZ3RoJTNEMTAwKSUwQWdlbmVyYXRlZF90ZXh0JTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RA==",highlighted:`checkpoint = <span class="hljs-string">&quot;HuggingFaceM4/idefics-9b&quot;</span>
processor = AutoProcessor.from_pretrained(checkpoint)
url = <span class="hljs-string">&quot;https://hips.hearstapps.com/hmg-prod/images/cute-photos-of-cats-in-grass-1593184777.jpg&quot;</span>
img = processor.image_processor.fetch_images([url])[<span class="hljs-number">0</span>]

prompts = [
    <span class="hljs-string">&quot;User:&quot;</span>,
    img,
    <span class="hljs-string">&quot;Describe this image.
t: An image of two kittens in grass.

    &quot;</span>User:<span class="hljs-string">&quot;,
    &quot;</span>https://hips.hearstapps.com/hmg-prod/images/dog-puns-<span class="hljs-number">1581708208.j</span>pg<span class="hljs-string">&quot;,
    &quot;</span>Describe this image.
t:<span class="hljs-string">&quot;,
]

inputs = processor(prompts, return_tensors=&quot;</span>pt<span class="hljs-string">&quot;)
generated_ids = model.generate(**inputs, max_length=100)
generated_text = processor.batch_decode(generated_ids, skip_special_tokens=True)[0]</span>`,wrap:!1}}),{c(){o=m("p"),o.textContent=M,l=a(),u(i.$$.fragment)},l(t){o=p(t,"P",{"data-svelte-h":!0}),h(o)!=="svelte-11lpom8"&&(o.textContent=M),l=r(t),_(i.$$.fragment,t)},m(t,g){c(t,o,g),c(t,l,g),b(i,t,g),f=!0},p:Q,i(t){f||(v(i.$$.fragment,t),f=!0)},o(t){y(i.$$.fragment,t),f=!1},d(t){t&&(s(o),s(l)),T(i,t)}}}function Mo(x){let o,M="In this example the <code>prompts</code> will be converted into:",l,i,f;return i=new Ee({props:{code:"JTNDcyUzRVVzZXIlM0ElM0NmYWtlX3Rva2VuX2Fyb3VuZF9pbWFnZSUzRSUzQ2ltYWdlJTNFJTNDZmFrZV90b2tlbl9hcm91bmRfaW1hZ2UlM0VEZXNjcmliZSUyMHRoaXMlMjBpbWFnZS4lMEFBc3Npc3RhbnQlM0ElMjBBbiUyMGltYWdlJTIwb2YlMjB0d28lMjBraXR0ZW5zJTIwaW4lMjBncmFzcy4lMEFVc2VyJTNBJTNDZmFrZV90b2tlbl9hcm91bmRfaW1hZ2UlM0UlM0NpbWFnZSUzRSUzQ2Zha2VfdG9rZW5fYXJvdW5kX2ltYWdlJTNFRGVzY3JpYmUlMjB0aGlzJTIwaW1hZ2UuJTBBQXNzaXN0YW50JTNBJw==",highlighted:`&lt;s&gt;<span class="hljs-title class_">User</span><span class="hljs-symbol">:&lt;fake_token_around_image&gt;&lt;image&gt;&lt;fake_token_around_image&gt;Describe</span> this image.
<span class="hljs-title class_">Assistant</span>: <span class="hljs-title class_">An</span> image of two kittens <span class="hljs-keyword">in</span> grass.
<span class="hljs-title class_">User</span><span class="hljs-symbol">:&lt;fake_token_around_image&gt;&lt;image&gt;&lt;fake_token_around_image&gt;Describe</span> this image.
<span class="hljs-title class_">Assistant</span><span class="hljs-symbol">:<span class="hljs-string">&#x27;</span></span>`,wrap:!1}}),{c(){o=m("p"),o.innerHTML=M,l=a(),u(i.$$.fragment)},l(t){o=p(t,"P",{"data-svelte-h":!0}),h(o)!=="svelte-c8byn"&&(o.innerHTML=M),l=r(t),_(i.$$.fragment,t)},m(t,g){c(t,o,g),c(t,l,g),b(i,t,g),f=!0},p:Q,i(t){f||(v(i.$$.fragment,t),f=!0)},o(t){y(i.$$.fragment,t),f=!1},d(t){t&&(s(o),s(l)),T(i,t)}}}function Io(x){let o,M="To do training do:",l,i,f;return i=new Ee({props:{code:"aW1hZ2VfdHJhbnNmb3JtJTIwJTNEJTIwdHJhbnNmb3Jtcy5Db21wb3NlKCUwQSUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRyYW5zZm9ybXMuUmFuZG9tUmVzaXplZENyb3AoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKHclMkMlMjBoKSUyQyUyMHNjYWxlJTNEKDAuOSUyQyUyMDEuMCklMkMlMjBpbnRlcnBvbGF0aW9uJTNEdHJhbnNmb3Jtcy5JbnRlcnBvbGF0aW9uTW9kZS5CSUNVQklDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRyYW5zZm9ybXMuVG9UZW5zb3IoKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRyYW5zZm9ybXMuTm9ybWFsaXplKG1lYW4lM0RzZWxmLmltYWdlX21lYW4lMkMlMjBzdGQlM0RzZWxmLmltYWdlX3N0ZCklMkMlMEElMjAlMjAlMjAlMjAlNUQlMEEpJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKHByb21wdHMlMkMlMjB0cmFuc2Zvcm0lM0RpbWFnZV90cmFuc2Zvcm0lMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKQ==",highlighted:`image_transform = transforms.Compose(
    [
        transforms.RandomResizedCrop(
            (w, h), scale=(<span class="hljs-number">0.9</span>, <span class="hljs-number">1.0</span>), interpolation=transforms.InterpolationMode.BICUBIC
        ),
        transforms.ToTensor(),
        transforms.Normalize(mean=self.image_mean, std=self.image_std),
    ]
)
inputs = processor(prompts, transform=image_transform, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)`,wrap:!1}}),{c(){o=m("p"),o.textContent=M,l=a(),u(i.$$.fragment)},l(t){o=p(t,"P",{"data-svelte-h":!0}),h(o)!=="svelte-1jbe3nb"&&(o.textContent=M),l=r(t),_(i.$$.fragment,t)},m(t,g){c(t,o,g),c(t,l,g),b(i,t,g),f=!0},p:Q,i(t){f||(v(i.$$.fragment,t),f=!0)},o(t){y(i.$$.fragment,t),f=!1},d(t){t&&(s(o),s(l)),T(i,t)}}}function wo(x){let o,M,l,i,f,t,g,Le,O,Rt='The IDEFICS model was proposed in <a href="https://huggingface.co/papers/2306.16527" rel="nofollow">OBELICS: An Open Web-Scale Filtered Dataset of Interleaved Image-Text Documents</a> by Hugo Laurençon, Lucile Saulnier, Léo Tronchon, Stas Bekman, Amanpreet Singh, Anton Lozhkov, Thomas Wang, Siddharth Karamcheti, Alexander M. Rush, Douwe Kiela, Matthieu Cord, Victor Sanh',Ae,K,Ht="The abstract from the paper is the following:",Se,ee,Vt="<em>Large multimodal models trained on natural documents, which interleave images and text, outperform models trained on image-text pairs on various multimodal benchmarks that require reasoning over one or multiple images to generate a text. However, the datasets used to train these models have not been released, and the collection process has not been fully specified. We introduce the OBELICS dataset, an open web-scale filtered dataset of interleaved image-text documents comprising 141 million web pages extracted from Common Crawl, 353 million associated images, and 115 billion text tokens. We describe the dataset creation process, present comprehensive filtering rules, and provide an analysis of the dataset’s content. To show the viability of OBELISC, we train an 80 billion parameters vision and language model on the dataset and obtain competitive performance on various multimodal benchmarks. We release the code to reproduce the dataset along with the dataset itself.</em>",qe,te,Et='This model was contributed by <a href="https://huggingface.co/HuggingFaceM4" rel="nofollow">HuggingFaceM4</a>. The original code can be found <a href="INSERT%20LINK%20TO%20GITHUB%20REPO%20HERE">here</a>. (TODO: don’t have a public link yet).',De,E,Ge,oe,Ye,$,ne,it,ye,Lt=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.40.2/en/model_doc/idefics#transformers.IdeficsModel">IdeficsModel</a>. It is used to instantiate an
Idefics model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the Idefics-9B.`,dt,Te,At='e.g. <a href="https://huggingface.co/HuggingFaceM4/idefics-9b" rel="nofollow">HuggingFaceM4/idefics-9b</a>',lt,Me,St=`Configuration objects inherit from <a href="/docs/transformers/v4.40.2/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.40.2/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,ct,L,Xe,se,Qe,k,ae,mt,Ie,qt=`The bare LLaMA Model outputting raw hidden-states without any specific head on top.
This model inherits from <a href="/docs/transformers/v4.40.2/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,pt,we,Dt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,ft,xe,Gt="Transformer decoder consisting of <code>config.num_hidden_layers</code> layers. Each layer is a <code>IdeficsDecoderLayer</code>",ht,P,re,gt,$e,Yt='The <a href="/docs/transformers/v4.40.2/en/model_doc/idefics#transformers.IdeficsModel">IdeficsModel</a> forward method, overrides the <code>__call__</code> special method.',ut,A,Oe,ie,Ke,B,de,_t,U,le,bt,ke,Xt='The <a href="/docs/transformers/v4.40.2/en/model_doc/idefics#transformers.IdeficsForVisionText2Text">IdeficsForVisionText2Text</a> forward method, overrides the <code>__call__</code> special method.',vt,S,yt,q,et,ce,tt,j,me,Tt,ze,Qt="Constructs a Idefics image processor.",Mt,D,pe,It,Ce,Ot="Preprocess a batch of images.",ot,fe,nt,z,he,wt,Je,Kt="Constructs a IDEFICS processor which wraps a LLama tokenizer and IDEFICS image processor into a single processor.",xt,Ue,eo=`<a href="/docs/transformers/v4.40.2/en/model_doc/idefics#transformers.IdeficsProcessor">IdeficsProcessor</a> offers all the functionalities of <a href="/docs/transformers/v4.40.2/en/model_doc/idefics#transformers.IdeficsImageProcessor">IdeficsImageProcessor</a> and <a href="/docs/transformers/v4.40.2/en/model_doc/llama#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>. See
the docstring of <a href="/docs/transformers/v4.40.2/en/model_doc/idefics#transformers.IdeficsProcessor.__call__"><strong>call</strong>()</a> and <code>decode()</code> for more information.`,$t,I,ge,kt,je,to=`This method takes batched or non-batched prompts made of text and images and converts them into prompts that
the model was trained on and prepares the image pixel values for the model to process.`,zt,We,oo="Detailed explanation:",Ct,Ze,no="Each entry in <code>prompts</code> is either a text to be passed as is or an image that will be processed.",Jt,Ne,so="An image can be either an image object (<code>PIL.Image</code>) or a url from which the image can be retrieved.",Ut,Fe,ao=`When the processor encounters an image it’ll inject <code>&lt;fake_token_around_image&gt;&lt;image&gt;&lt;fake_token_around_image&gt;</code>
entry into the prompt.`,jt,G,Wt,Y,Zt,Pe,ro=`and the two images will be massaged using <a href="/docs/transformers/v4.40.2/en/model_doc/fuyu#transformers.FuyuImageProcessor.__call__">IdeficsImageProcessor.<strong>call</strong>()</a> method and placed inside the
<code>pixel_values</code> dict entry of the return value.`,Nt,Be,io=`This example also examplifies that images can be passed as objects or as text urls. It can be seen that the
first image is passed as object and the second one as a url.`,Ft,X,Pt,Re,lo="In order to help debug prompt generation enable <code>debug=True</code> which will show you what’s happening.",st,ue,at,He,rt;return f=new ve({props:{title:"IDEFICS",local:"idefics",headingTag:"h1"}}),g=new ve({props:{title:"Overview",local:"overview",headingTag:"h2"}}),E=new Bt({props:{warning:!0,$$slots:{default:[uo]},$$scope:{ctx:x}}}),oe=new ve({props:{title:"IdeficsConfig",local:"transformers.IdeficsConfig",headingTag:"h2"}}),ne=new V({props:{name:"class transformers.IdeficsConfig",anchor:"transformers.IdeficsConfig",parameters:[{name:"vocab_size",val:" = 32000"},{name:"additional_vocab_size",val:" = 0"},{name:"hidden_size",val:" = 4096"},{name:"intermediate_size",val:" = 11008"},{name:"num_hidden_layers",val:" = 32"},{name:"num_attention_heads",val:" = 32"},{name:"dropout",val:" = 0.0"},{name:"hidden_act",val:" = 'silu'"},{name:"initializer_range",val:" = 0.02"},{name:"alpha_initializer",val:" = 'zeros'"},{name:"alphas_initializer_range",val:" = 0.0"},{name:"alpha_type",val:" = 'float'"},{name:"rms_norm_eps",val:" = 1e-06"},{name:"use_cache",val:" = True"},{name:"pad_token_id",val:" = 0"},{name:"bos_token_id",val:" = 1"},{name:"eos_token_id",val:" = 2"},{name:"tie_word_embeddings",val:" = False"},{name:"cross_layer_interval",val:" = 1"},{name:"qk_layer_norms",val:" = False"},{name:"freeze_text_layers",val:" = True"},{name:"freeze_text_module_exceptions",val:" = []"},{name:"freeze_lm_head",val:" = False"},{name:"freeze_vision_layers",val:" = True"},{name:"freeze_vision_module_exceptions",val:" = []"},{name:"use_resampler",val:" = False"},{name:"vision_config",val:" = None"},{name:"perceiver_config",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.IdeficsConfig.additional_vocab_size",description:`<strong>additional_vocab_size</strong> (<code>int</code>, *optional\`, defaults to 0) &#x2014;
Additional vocabulary size of the model, typically for the special &#x201D;<img>&#x201D; token. Additional vocab tokens
are always trainable whereas regular vocab tokens can be frozen or not.`,name:"additional_vocab_size"},{anchor:"transformers.IdeficsConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 32000) &#x2014;
Vocabulary size of the Idefics model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/v4.40.2/en/model_doc/idefics#transformers.IdeficsModel">~IdeficsModel</a>`,name:"vocab_size"},{anchor:"transformers.IdeficsConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Dimension of the hidden representations.`,name:"hidden_size"},{anchor:"transformers.IdeficsConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 11008) &#x2014;
Dimension of the MLP representations.`,name:"intermediate_size"},{anchor:"transformers.IdeficsConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.IdeficsConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.IdeficsConfig.dropout",description:`<strong>dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"dropout"},{anchor:"transformers.IdeficsConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;silu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the decoder.`,name:"hidden_act"},{anchor:"transformers.IdeficsConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.IdeficsConfig.alpha_initializer",description:`<strong>alpha_initializer</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;zeros&quot;</code>) &#x2014;
Initialization type for the alphas.`,name:"alpha_initializer"},{anchor:"transformers.IdeficsConfig.alphas_initializer_range",description:`<strong>alphas_initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing the alphas in the Gated Cross
Attention.`,name:"alphas_initializer_range"},{anchor:"transformers.IdeficsConfig.alpha_type",description:`<strong>alpha_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;float&quot;</code>) &#x2014;
Whether the gating alphas should be vectors or single floats.`,name:"alpha_type"},{anchor:"transformers.IdeficsConfig.rms_norm_eps",description:`<strong>rms_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-6) &#x2014;
The epsilon used by the rms normalization layers.`,name:"rms_norm_eps"},{anchor:"transformers.IdeficsConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models). Only
relevant if <code>config.is_decoder=True</code>.`,name:"use_cache"},{anchor:"transformers.IdeficsConfig.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Padding token id.`,name:"pad_token_id"},{anchor:"transformers.IdeficsConfig.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Beginning of stream token id.`,name:"bos_token_id"},{anchor:"transformers.IdeficsConfig.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
End of stream token id.`,name:"eos_token_id"},{anchor:"transformers.IdeficsConfig.tie_word_embeddings(bool,",description:`<strong>tie_word_embeddings(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to tie weight embeddings`,name:"tie_word_embeddings(bool,"},{anchor:"transformers.IdeficsConfig.cross_layer_interval",description:`<strong>cross_layer_interval</strong> (<code>int</code>, <em>optional</em>, default to 1) &#x2014;
Interval for cross attention (from text to image) layers.`,name:"cross_layer_interval"},{anchor:"transformers.IdeficsConfig.qk_layer_norms",description:"<strong>qk_layer_norms</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014; Whether to add layer norm after q and k",name:"qk_layer_norms"},{anchor:"transformers.IdeficsConfig.freeze_text_layers",description:"<strong>freeze_text_layers</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014; Whether to freeze text layers",name:"freeze_text_layers"},{anchor:"transformers.IdeficsConfig.freeze_text_module_exceptions",description:`<strong>freeze_text_module_exceptions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>[]</code>) &#x2014;
Exceptions to freezing text layers when <code>freeze_text_layers</code> is <code>True</code>`,name:"freeze_text_module_exceptions"},{anchor:"transformers.IdeficsConfig.freeze_lm_head",description:"<strong>freeze_lm_head</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014; Whether to freeze lm head",name:"freeze_lm_head"},{anchor:"transformers.IdeficsConfig.freeze_vision_layers",description:"<strong>freeze_vision_layers</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;  Whether to freeze vision layers",name:"freeze_vision_layers"},{anchor:"transformers.IdeficsConfig.freeze_vision_module_exceptions",description:`<strong>freeze_vision_module_exceptions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>[]</code>) &#x2014;
Exceptions to freezing vision layers when <code>freeze_vision_layers</code> is <code>True</code>`,name:"freeze_vision_module_exceptions"},{anchor:"transformers.IdeficsConfig.use_resampler",description:"<strong>use_resampler</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014; Whether to use the Resampler",name:"use_resampler"},{anchor:"transformers.IdeficsConfig.vision_config",description:"<strong>vision_config</strong> (<code>IdeficsVisionConfig</code>,  <em>optional</em>) &#x2014; Custom vision config or dict",name:"vision_config"},{anchor:"transformers.IdeficsConfig.perceiver_config",description:"<strong>perceiver_config</strong> (<code>IdeficsPerceiverConfig</code>,  <em>optional</em>) &#x2014; Custom perceiver config or dict",name:"perceiver_config"}],source:"https://github.com/huggingface/transformers/blob/v4.40.2/src/transformers/models/idefics/configuration_idefics.py#L159"}}),L=new Ve({props:{anchor:"transformers.IdeficsConfig.example",$$slots:{default:[_o]},$$scope:{ctx:x}}}),se=new ve({props:{title:"IdeficsModel",local:"transformers.IdeficsModel",headingTag:"h2"}}),ae=new V({props:{name:"class transformers.IdeficsModel",anchor:"transformers.IdeficsModel",parameters:[{name:"config",val:": IdeficsConfig"}],parametersDescription:[{anchor:"transformers.IdeficsModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.40.2/en/model_doc/idefics#transformers.IdeficsConfig">IdeficsConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/v4.40.2/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.
config &#x2014; IdeficsConfig`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.40.2/src/transformers/models/idefics/modeling_idefics.py#L1032"}}),re=new V({props:{name:"forward",anchor:"transformers.IdeficsModel.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"pixel_values",val:": Optional = None"},{name:"image_encoder_embeddings",val:": Optional = None"},{name:"perceiver_embeddings",val:": Optional = None"},{name:"image_attention_mask",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"interpolate_pos_encoding",val:": Optional = False"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.IdeficsModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.40.2/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.40.2/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.40.2/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.IdeficsModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.40.2/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.40.2/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.40.2/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.IdeficsModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>. <a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.IdeficsModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.IdeficsModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.IdeficsModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.IdeficsModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.IdeficsModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.IdeficsModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.40.2/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.40.2/src/transformers/models/idefics/modeling_idefics.py#L1113"}}),A=new Bt({props:{$$slots:{default:[bo]},$$scope:{ctx:x}}}),ie=new ve({props:{title:"IdeficsForVisionText2Text",local:"transformers.IdeficsForVisionText2Text",headingTag:"h2"}}),de=new V({props:{name:"class transformers.IdeficsForVisionText2Text",anchor:"transformers.IdeficsForVisionText2Text",parameters:[{name:"config",val:""},{name:"vision_model",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/v4.40.2/src/transformers/models/idefics/modeling_idefics.py#L1371"}}),le=new V({props:{name:"forward",anchor:"transformers.IdeficsForVisionText2Text.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": Optional = None"},{name:"position_ids",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"},{name:"inputs_embeds",val:": Optional = None"},{name:"pixel_values",val:": Optional = None"},{name:"image_encoder_embeddings",val:": Optional = None"},{name:"perceiver_embeddings",val:": Optional = None"},{name:"image_attention_mask",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"use_cache",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"interpolate_pos_encoding",val:": Optional = False"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.IdeficsForVisionText2Text.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.40.2/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.40.2/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.40.2/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.IdeficsForVisionText2Text.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.40.2/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.40.2/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.40.2/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.IdeficsForVisionText2Text.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>. <a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.IdeficsForVisionText2Text.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.IdeficsForVisionText2Text.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.IdeficsForVisionText2Text.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.IdeficsForVisionText2Text.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.IdeficsForVisionText2Text.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.IdeficsForVisionText2Text.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.40.2/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.</p>
<p>Args &#x2014;
labels (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>):
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.40.2/src/transformers/models/idefics/modeling_idefics.py#L1429",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.idefics.modeling_idefics.IdeficsCausalLMOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.40.2/en/model_doc/idefics#transformers.IdeficsConfig"
>IdeficsConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>image_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the image embeddings, <code>(batch_size, num_images, sequence_length, hidden_size)</code>.</p>
<p>image_hidden_states of the model produced by the vision encoder, and optionally by the perceiver</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.idefics.modeling_idefics.IdeficsCausalLMOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),S=new Bt({props:{$$slots:{default:[vo]},$$scope:{ctx:x}}}),q=new Ve({props:{anchor:"transformers.IdeficsForVisionText2Text.forward.example",$$slots:{default:[yo]},$$scope:{ctx:x}}}),ce=new ve({props:{title:"IdeficsImageProcessor",local:"transformers.IdeficsImageProcessor",headingTag:"h2"}}),me=new V({props:{name:"class transformers.IdeficsImageProcessor",anchor:"transformers.IdeficsImageProcessor",parameters:[{name:"image_size",val:": int = 224"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"image_num_channels",val:": Optional = 3"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.IdeficsImageProcessor.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 224) &#x2014;
Resize to image size`,name:"image_size"},{anchor:"transformers.IdeficsImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IDEFICS_STANDARD_MEAN</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method. Can be
overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.IdeficsImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IDEFICS_STANDARD_STD</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.
Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.IdeficsImageProcessor.image_num_channels",description:`<strong>image_num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
Number of image channels.`,name:"image_num_channels"}],source:"https://github.com/huggingface/transformers/blob/v4.40.2/src/transformers/models/idefics/image_processing_idefics.py#L51"}}),pe=new V({props:{name:"preprocess",anchor:"transformers.IdeficsImageProcessor.preprocess",parameters:[{name:"images",val:": Union"},{name:"image_num_channels",val:": Optional = 3"},{name:"image_size",val:": Optional = None"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"transform",val:": Callable = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.IdeficsImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
A list of images to preprocess.`,name:"images"},{anchor:"transformers.IdeficsImageProcessor.preprocess.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.image_size</code>) &#x2014;
Resize to image size`,name:"image_size"},{anchor:"transformers.IdeficsImageProcessor.preprocess.image_num_channels",description:`<strong>image_num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.image_num_channels</code>) &#x2014;
Number of image channels.`,name:"image_num_channels"},{anchor:"transformers.IdeficsImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IDEFICS_STANDARD_MEAN</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method. Can
be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.IdeficsImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IDEFICS_STANDARD_STD</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code>
method. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.IdeficsImageProcessor.preprocess.transform",description:`<strong>transform</strong> (<code>Callable</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
A custom transform function that accepts a single image can be passed for training. For example,
<code>torchvision.Compose</code> can be used to compose multiple transforms. If <code>None</code> - an inference mode is
assumed - and then a preset of inference-specific transforms will be applied to the images`,name:"transform"}],source:"https://github.com/huggingface/transformers/blob/v4.40.2/src/transformers/models/idefics/image_processing_idefics.py#L87",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a PyTorch tensor of the processed images</p>
`}}),fe=new ve({props:{title:"IdeficsProcessor",local:"transformers.IdeficsProcessor",headingTag:"h2"}}),he=new V({props:{name:"class transformers.IdeficsProcessor",anchor:"transformers.IdeficsProcessor",parameters:[{name:"image_processor",val:""},{name:"tokenizer",val:" = None"},{name:"image_size",val:" = 224"},{name:"add_end_of_utterance_token",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.IdeficsProcessor.image_processor",description:`<strong>image_processor</strong> (<code>IdeficsImageProcessor</code>) &#x2014;
An instance of <a href="/docs/transformers/v4.40.2/en/model_doc/idefics#transformers.IdeficsImageProcessor">IdeficsImageProcessor</a>. The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.IdeficsProcessor.tokenizer",description:`<strong>tokenizer</strong> (<code>LlamaTokenizerFast</code>) &#x2014;
An instance of <a href="/docs/transformers/v4.40.2/en/model_doc/llama#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>. The tokenizer is a required input.`,name:"tokenizer"},{anchor:"transformers.IdeficsProcessor.image_size",description:"<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 224) &#x2014; Image size (assuming a square image)",name:"image_size"}],source:"https://github.com/huggingface/transformers/blob/v4.40.2/src/transformers/models/idefics/processing_idefics.py#L108"}}),ge=new V({props:{name:"__call__",anchor:"transformers.IdeficsProcessor.__call__",parameters:[{name:"prompts",val:": Union"},{name:"padding",val:": Union = 'longest'"},{name:"truncation",val:": Union = None"},{name:"max_length",val:": Optional = None"},{name:"transform",val:": Callable = None"},{name:"add_eos_token",val:" = False"},{name:"add_end_of_utterance_token",val:" = None"},{name:"debug",val:" = False"},{name:"return_tensors",val:": Union = <TensorType.PYTORCH: 'pt'>"}],parametersDescription:[{anchor:"transformers.IdeficsProcessor.__call__.prompts",description:`<strong>prompts</strong> (<code>Union[List[TextInput], [List[List[TextInput]]]]</code>) &#x2014;
either a single prompt or a batched list of prompts - see the detailed description immediately after
the end of the arguments doc section.`,name:"prompts"},{anchor:"transformers.IdeficsProcessor.__call__.padding",description:`<strong>padding</strong> (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/v4.40.2/en/internal/file_utils#transformers.utils.PaddingStrategy">PaddingStrategy</a>, <em>optional</em>, defaults to <code>&quot;longest&quot;</code>) &#x2014;
Select a strategy to pad the returned sequences (according to the model&#x2019;s padding side and padding
index) among:<ul>
<li><code>True</code> or <code>&apos;longest&apos;</code> (default): Pad to the longest sequence in the batch (or no padding if only a single
sequence if provided).</li>
<li><code>&apos;max_length&apos;</code>: Pad to a maximum length specified with the argument <code>max_length</code> or to the maximum
acceptable input length for the model if that argument is not provided.</li>
<li><code>False</code> or <code>&apos;do_not_pad&apos;</code>: No padding. This will raise an error if the input sequences are of different
lengths.
Note: Unlike most processors, which set padding=<code>False</code> by default, <code>IdeficsProcessor</code> sets <code>padding=&quot;longest&quot;</code>
by default. See <a href="https://github.com/huggingface/transformers/pull/29449#pullrequestreview-1925576061" rel="nofollow">https://github.com/huggingface/transformers/pull/29449#pullrequestreview-1925576061</a> for why.</li>
</ul>`,name:"padding"},{anchor:"transformers.IdeficsProcessor.__call__.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Maximum length of the returned list and optionally padding length (see above).`,name:"max_length"},{anchor:"transformers.IdeficsProcessor.__call__.truncation",description:`<strong>truncation</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Activates truncation to cut input sequences longer than <code>max_length</code> to <code>max_length</code>.`,name:"truncation"},{anchor:"transformers.IdeficsProcessor.__call__.transform",description:`<strong>transform</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A custom transform function that accepts a single image can be passed for training. For example,
<code>torchvision.Compose</code> can be used to compose multiple functions. If <code>None</code> a preset inference-specific
set of transforms will be applied to the images`,name:"transform"},{anchor:"transformers.IdeficsProcessor.__call__.add_eos_token",description:"<strong>add_eos_token</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;\nAdds <code>eos_token</code> at the end of the final prompt if True`",name:"add_eos_token"},{anchor:"transformers.IdeficsProcessor.__call__.add_end_of_utterance_token",description:`<strong>add_end_of_utterance_token</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to automatically add <code>&lt;end_of_utterance&gt;</code> after each prompt&#x2019;s text input (unless followed by an
image). If <code>None</code> the tokenizer will be checked instead and if this token is found in
<code>additional_special_tokens</code> then the value will be <code>True</code>.`,name:"add_end_of_utterance_token"},{anchor:"transformers.IdeficsProcessor.__call__.debug",description:`<strong>debug</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
<code>True</code> value will help debug prompt generation by dumping useful information`,name:"debug"},{anchor:"transformers.IdeficsProcessor.__call__.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>, defaults to <code>TensorType.PYTORCH</code>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
</ul>`,name:"return_tensors"}],source:"https://github.com/huggingface/transformers/blob/v4.40.2/src/transformers/models/idefics/processing_idefics.py#L149",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>input_ids</code>, <code>attention_mask</code>, <code>pixel_values</code>, <code>image_attention_mask</code> which can be
directly passed to <code>model.generate</code></p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a dict with entries</p>
`}}),G=new Ve({props:{anchor:"transformers.IdeficsProcessor.__call__.example",$$slots:{default:[To]},$$scope:{ctx:x}}}),Y=new Ve({props:{anchor:"transformers.IdeficsProcessor.__call__.example-2",$$slots:{default:[Mo]},$$scope:{ctx:x}}}),X=new Ve({props:{anchor:"transformers.IdeficsProcessor.__call__.example-3",$$slots:{default:[Io]},$$scope:{ctx:x}}}),ue=new go({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/idefics.md"}}),{c(){o=m("meta"),M=a(),l=m("p"),i=a(),u(f.$$.fragment),t=a(),u(g.$$.fragment),Le=a(),O=m("p"),O.innerHTML=Rt,Ae=a(),K=m("p"),K.textContent=Ht,Se=a(),ee=m("p"),ee.innerHTML=Vt,qe=a(),te=m("p"),te.innerHTML=Et,De=a(),u(E.$$.fragment),Ge=a(),u(oe.$$.fragment),Ye=a(),$=m("div"),u(ne.$$.fragment),it=a(),ye=m("p"),ye.innerHTML=Lt,dt=a(),Te=m("p"),Te.innerHTML=At,lt=a(),Me=m("p"),Me.innerHTML=St,ct=a(),u(L.$$.fragment),Xe=a(),u(se.$$.fragment),Qe=a(),k=m("div"),u(ae.$$.fragment),mt=a(),Ie=m("p"),Ie.innerHTML=qt,pt=a(),we=m("p"),we.innerHTML=Dt,ft=a(),xe=m("p"),xe.innerHTML=Gt,ht=a(),P=m("div"),u(re.$$.fragment),gt=a(),$e=m("p"),$e.innerHTML=Yt,ut=a(),u(A.$$.fragment),Oe=a(),u(ie.$$.fragment),Ke=a(),B=m("div"),u(de.$$.fragment),_t=a(),U=m("div"),u(le.$$.fragment),bt=a(),ke=m("p"),ke.innerHTML=Xt,vt=a(),u(S.$$.fragment),yt=a(),u(q.$$.fragment),et=a(),u(ce.$$.fragment),tt=a(),j=m("div"),u(me.$$.fragment),Tt=a(),ze=m("p"),ze.textContent=Qt,Mt=a(),D=m("div"),u(pe.$$.fragment),It=a(),Ce=m("p"),Ce.textContent=Ot,ot=a(),u(fe.$$.fragment),nt=a(),z=m("div"),u(he.$$.fragment),wt=a(),Je=m("p"),Je.textContent=Kt,xt=a(),Ue=m("p"),Ue.innerHTML=eo,$t=a(),I=m("div"),u(ge.$$.fragment),kt=a(),je=m("p"),je.textContent=to,zt=a(),We=m("p"),We.textContent=oo,Ct=a(),Ze=m("p"),Ze.innerHTML=no,Jt=a(),Ne=m("p"),Ne.innerHTML=so,Ut=a(),Fe=m("p"),Fe.innerHTML=ao,jt=a(),u(G.$$.fragment),Wt=a(),u(Y.$$.fragment),Zt=a(),Pe=m("p"),Pe.innerHTML=ro,Nt=a(),Be=m("p"),Be.textContent=io,Ft=a(),u(X.$$.fragment),Pt=a(),Re=m("p"),Re.innerHTML=lo,st=a(),u(ue.$$.fragment),at=a(),He=m("p"),this.h()},l(e){const n=ho("svelte-u9bgzb",document.head);o=p(n,"META",{name:!0,content:!0}),n.forEach(s),M=r(e),l=p(e,"P",{}),N(l).forEach(s),i=r(e),_(f.$$.fragment,e),t=r(e),_(g.$$.fragment,e),Le=r(e),O=p(e,"P",{"data-svelte-h":!0}),h(O)!=="svelte-jddp08"&&(O.innerHTML=Rt),Ae=r(e),K=p(e,"P",{"data-svelte-h":!0}),h(K)!=="svelte-vfdo9a"&&(K.textContent=Ht),Se=r(e),ee=p(e,"P",{"data-svelte-h":!0}),h(ee)!=="svelte-18xi2yr"&&(ee.innerHTML=Vt),qe=r(e),te=p(e,"P",{"data-svelte-h":!0}),h(te)!=="svelte-1nhi3a3"&&(te.innerHTML=Et),De=r(e),_(E.$$.fragment,e),Ge=r(e),_(oe.$$.fragment,e),Ye=r(e),$=p(e,"DIV",{class:!0});var C=N($);_(ne.$$.fragment,C),it=r(C),ye=p(C,"P",{"data-svelte-h":!0}),h(ye)!=="svelte-1y9v76f"&&(ye.innerHTML=Lt),dt=r(C),Te=p(C,"P",{"data-svelte-h":!0}),h(Te)!=="svelte-n7bqeh"&&(Te.innerHTML=At),lt=r(C),Me=p(C,"P",{"data-svelte-h":!0}),h(Me)!=="svelte-xu8n6r"&&(Me.innerHTML=St),ct=r(C),_(L.$$.fragment,C),C.forEach(s),Xe=r(e),_(se.$$.fragment,e),Qe=r(e),k=p(e,"DIV",{class:!0});var J=N(k);_(ae.$$.fragment,J),mt=r(J),Ie=p(J,"P",{"data-svelte-h":!0}),h(Ie)!=="svelte-1f85lyw"&&(Ie.innerHTML=qt),pt=r(J),we=p(J,"P",{"data-svelte-h":!0}),h(we)!=="svelte-hswkmf"&&(we.innerHTML=Dt),ft=r(J),xe=p(J,"P",{"data-svelte-h":!0}),h(xe)!=="svelte-1rhjct8"&&(xe.innerHTML=Gt),ht=r(J),P=p(J,"DIV",{class:!0});var R=N(P);_(re.$$.fragment,R),gt=r(R),$e=p(R,"P",{"data-svelte-h":!0}),h($e)!=="svelte-13i5js9"&&($e.innerHTML=Yt),ut=r(R),_(A.$$.fragment,R),R.forEach(s),J.forEach(s),Oe=r(e),_(ie.$$.fragment,e),Ke=r(e),B=p(e,"DIV",{class:!0});var _e=N(B);_(de.$$.fragment,_e),_t=r(_e),U=p(_e,"DIV",{class:!0});var W=N(U);_(le.$$.fragment,W),bt=r(W),ke=p(W,"P",{"data-svelte-h":!0}),h(ke)!=="svelte-hzz3bl"&&(ke.innerHTML=Xt),vt=r(W),_(S.$$.fragment,W),yt=r(W),_(q.$$.fragment,W),W.forEach(s),_e.forEach(s),et=r(e),_(ce.$$.fragment,e),tt=r(e),j=p(e,"DIV",{class:!0});var H=N(j);_(me.$$.fragment,H),Tt=r(H),ze=p(H,"P",{"data-svelte-h":!0}),h(ze)!=="svelte-1m1ucrf"&&(ze.textContent=Qt),Mt=r(H),D=p(H,"DIV",{class:!0});var be=N(D);_(pe.$$.fragment,be),It=r(be),Ce=p(be,"P",{"data-svelte-h":!0}),h(Ce)!=="svelte-1xds4wy"&&(Ce.textContent=Ot),be.forEach(s),H.forEach(s),ot=r(e),_(fe.$$.fragment,e),nt=r(e),z=p(e,"DIV",{class:!0});var Z=N(z);_(he.$$.fragment,Z),wt=r(Z),Je=p(Z,"P",{"data-svelte-h":!0}),h(Je)!=="svelte-ntsjs9"&&(Je.textContent=Kt),xt=r(Z),Ue=p(Z,"P",{"data-svelte-h":!0}),h(Ue)!=="svelte-1vyxwb8"&&(Ue.innerHTML=eo),$t=r(Z),I=p(Z,"DIV",{class:!0});var w=N(I);_(ge.$$.fragment,w),kt=r(w),je=p(w,"P",{"data-svelte-h":!0}),h(je)!=="svelte-1dgzv8j"&&(je.textContent=to),zt=r(w),We=p(w,"P",{"data-svelte-h":!0}),h(We)!=="svelte-qv5ndj"&&(We.textContent=oo),Ct=r(w),Ze=p(w,"P",{"data-svelte-h":!0}),h(Ze)!=="svelte-xvvltg"&&(Ze.innerHTML=no),Jt=r(w),Ne=p(w,"P",{"data-svelte-h":!0}),h(Ne)!=="svelte-15i05k0"&&(Ne.innerHTML=so),Ut=r(w),Fe=p(w,"P",{"data-svelte-h":!0}),h(Fe)!=="svelte-gstss4"&&(Fe.innerHTML=ao),jt=r(w),_(G.$$.fragment,w),Wt=r(w),_(Y.$$.fragment,w),Zt=r(w),Pe=p(w,"P",{"data-svelte-h":!0}),h(Pe)!=="svelte-bcp6vk"&&(Pe.innerHTML=ro),Nt=r(w),Be=p(w,"P",{"data-svelte-h":!0}),h(Be)!=="svelte-9aj4iv"&&(Be.textContent=io),Ft=r(w),_(X.$$.fragment,w),Pt=r(w),Re=p(w,"P",{"data-svelte-h":!0}),h(Re)!=="svelte-1drva0b"&&(Re.innerHTML=lo),w.forEach(s),Z.forEach(s),st=r(e),_(ue.$$.fragment,e),at=r(e),He=p(e,"P",{}),N(He).forEach(s),this.h()},h(){F(o,"name","hf:doc:metadata"),F(o,"content",xo),F($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,n){d(document.head,o),c(e,M,n),c(e,l,n),c(e,i,n),b(f,e,n),c(e,t,n),b(g,e,n),c(e,Le,n),c(e,O,n),c(e,Ae,n),c(e,K,n),c(e,Se,n),c(e,ee,n),c(e,qe,n),c(e,te,n),c(e,De,n),b(E,e,n),c(e,Ge,n),b(oe,e,n),c(e,Ye,n),c(e,$,n),b(ne,$,null),d($,it),d($,ye),d($,dt),d($,Te),d($,lt),d($,Me),d($,ct),b(L,$,null),c(e,Xe,n),b(se,e,n),c(e,Qe,n),c(e,k,n),b(ae,k,null),d(k,mt),d(k,Ie),d(k,pt),d(k,we),d(k,ft),d(k,xe),d(k,ht),d(k,P),b(re,P,null),d(P,gt),d(P,$e),d(P,ut),b(A,P,null),c(e,Oe,n),b(ie,e,n),c(e,Ke,n),c(e,B,n),b(de,B,null),d(B,_t),d(B,U),b(le,U,null),d(U,bt),d(U,ke),d(U,vt),b(S,U,null),d(U,yt),b(q,U,null),c(e,et,n),b(ce,e,n),c(e,tt,n),c(e,j,n),b(me,j,null),d(j,Tt),d(j,ze),d(j,Mt),d(j,D),b(pe,D,null),d(D,It),d(D,Ce),c(e,ot,n),b(fe,e,n),c(e,nt,n),c(e,z,n),b(he,z,null),d(z,wt),d(z,Je),d(z,xt),d(z,Ue),d(z,$t),d(z,I),b(ge,I,null),d(I,kt),d(I,je),d(I,zt),d(I,We),d(I,Ct),d(I,Ze),d(I,Jt),d(I,Ne),d(I,Ut),d(I,Fe),d(I,jt),b(G,I,null),d(I,Wt),b(Y,I,null),d(I,Zt),d(I,Pe),d(I,Nt),d(I,Be),d(I,Ft),b(X,I,null),d(I,Pt),d(I,Re),c(e,st,n),b(ue,e,n),c(e,at,n),c(e,He,n),rt=!0},p(e,[n]){const C={};n&2&&(C.$$scope={dirty:n,ctx:e}),E.$set(C);const J={};n&2&&(J.$$scope={dirty:n,ctx:e}),L.$set(J);const R={};n&2&&(R.$$scope={dirty:n,ctx:e}),A.$set(R);const _e={};n&2&&(_e.$$scope={dirty:n,ctx:e}),S.$set(_e);const W={};n&2&&(W.$$scope={dirty:n,ctx:e}),q.$set(W);const H={};n&2&&(H.$$scope={dirty:n,ctx:e}),G.$set(H);const be={};n&2&&(be.$$scope={dirty:n,ctx:e}),Y.$set(be);const Z={};n&2&&(Z.$$scope={dirty:n,ctx:e}),X.$set(Z)},i(e){rt||(v(f.$$.fragment,e),v(g.$$.fragment,e),v(E.$$.fragment,e),v(oe.$$.fragment,e),v(ne.$$.fragment,e),v(L.$$.fragment,e),v(se.$$.fragment,e),v(ae.$$.fragment,e),v(re.$$.fragment,e),v(A.$$.fragment,e),v(ie.$$.fragment,e),v(de.$$.fragment,e),v(le.$$.fragment,e),v(S.$$.fragment,e),v(q.$$.fragment,e),v(ce.$$.fragment,e),v(me.$$.fragment,e),v(pe.$$.fragment,e),v(fe.$$.fragment,e),v(he.$$.fragment,e),v(ge.$$.fragment,e),v(G.$$.fragment,e),v(Y.$$.fragment,e),v(X.$$.fragment,e),v(ue.$$.fragment,e),rt=!0)},o(e){y(f.$$.fragment,e),y(g.$$.fragment,e),y(E.$$.fragment,e),y(oe.$$.fragment,e),y(ne.$$.fragment,e),y(L.$$.fragment,e),y(se.$$.fragment,e),y(ae.$$.fragment,e),y(re.$$.fragment,e),y(A.$$.fragment,e),y(ie.$$.fragment,e),y(de.$$.fragment,e),y(le.$$.fragment,e),y(S.$$.fragment,e),y(q.$$.fragment,e),y(ce.$$.fragment,e),y(me.$$.fragment,e),y(pe.$$.fragment,e),y(fe.$$.fragment,e),y(he.$$.fragment,e),y(ge.$$.fragment,e),y(G.$$.fragment,e),y(Y.$$.fragment,e),y(X.$$.fragment,e),y(ue.$$.fragment,e),rt=!1},d(e){e&&(s(M),s(l),s(i),s(t),s(Le),s(O),s(Ae),s(K),s(Se),s(ee),s(qe),s(te),s(De),s(Ge),s(Ye),s($),s(Xe),s(Qe),s(k),s(Oe),s(Ke),s(B),s(et),s(tt),s(j),s(ot),s(nt),s(z),s(st),s(at),s(He)),s(o),T(f,e),T(g,e),T(E,e),T(oe,e),T(ne),T(L),T(se,e),T(ae),T(re),T(A),T(ie,e),T(de),T(le),T(S),T(q),T(ce,e),T(me),T(pe),T(fe,e),T(he),T(ge),T(G),T(Y),T(X),T(ue,e)}}}const xo='{"title":"IDEFICS","local":"idefics","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"IdeficsConfig","local":"transformers.IdeficsConfig","sections":[],"depth":2},{"title":"IdeficsModel","local":"transformers.IdeficsModel","sections":[],"depth":2},{"title":"IdeficsForVisionText2Text","local":"transformers.IdeficsForVisionText2Text","sections":[],"depth":2},{"title":"IdeficsImageProcessor","local":"transformers.IdeficsImageProcessor","sections":[],"depth":2},{"title":"IdeficsProcessor","local":"transformers.IdeficsProcessor","sections":[],"depth":2}],"depth":1}';function $o(x){return mo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Zo extends po{constructor(o){super(),fo(this,o,$o,wo,co,{})}}export{Zo as component};
