import{s as fl,n as Tl,o as gl}from"../chunks/scheduler.9039eef2.js";import{S as Ul,i as wl,g as o,s as n,r as p,A as jl,h as i,f as a,c as l,j as Be,u as c,x as r,k as qe,l as yl,y as xe,a as s,v as d,d as u,t as m,w as h}from"../chunks/index.ded8f90d.js";import{D as an}from"../chunks/Docstring.a2ba2b54.js";import{C as M}from"../chunks/CodeBlock.8580f3e8.js";import{H as y}from"../chunks/Heading.f027f30d.js";function bl(sn){let f,Xe,Ze,Qe,b,ze,J,nn="Supervised fine-tuning (or SFT for short) is a crucial step in RLHF. In TRL we provide an easy-to-use API to create your SFT models and train them with few lines of code on your dataset.",Ve,_,ln='Check out a complete flexible example at <a href="https://github.com/huggingface/trl/tree/main/examples/scripts/sft.py" rel="nofollow"><code>examples/scripts/sft.py</code></a>.',We,k,Ee,C,on=`If you have a dataset hosted on the 🤗 Hub, you can easily fine-tune your SFT model using <a href="/docs/trl/v0.7.11/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> from TRL. Let us assume your dataset is <code>imdb</code>, the text you want to predict is inside the <code>text</code> field of the dataset, and you want to fine-tune the <code>facebook/opt-350m</code> model.
The following code-snippet takes care of all the data pre-processing and training for you:`,Ne,v,Se,I,rn="Make sure to pass a correct value for <code>max_seq_length</code> as the default value will be set to <code>min(tokenizer.model_max_length, 1024)</code>.",Ae,x,pn="You can also construct a model outside of the trainer and pass it as follows:",He,F,Ye,$,cn='The above snippets will use the default training arguments from the <a href="https://huggingface.co/docs/transformers/main_classes/trainer#transformers.TrainingArguments" rel="nofollow"><code>transformers.TrainingArguments</code></a> class. If you want to modify that, make sure to create your own <code>TrainingArguments</code> object and pass it to the <a href="/docs/trl/v0.7.11/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> constructor as it is done on the <a href="https://github.com/huggingface/trl/blob/main/examples/stack_llama/scripts/supervised_finetuning.py" rel="nofollow"><code>supervised_finetuning.py</code> script</a> on the stack-llama example.',Le,G,De,Z,Pe,R,dn=`You can use the <code>DataCollatorForCompletionOnlyLM</code> to train your model on the generated prompts only. Note that this works only in the case when <code>packing=False</code>.
To instantiate that collator for instruction data, pass a response template and the tokenizer. Here is an example of how it would work to fine-tune <code>opt-350m</code> on completions only on the CodeAlpaca dataset:`,Oe,B,Ke,q,un="To instantiate that collator for assistant style conversation data, pass a response template, an instruction template and the tokenizer. Here is an example of how it would work to fine-tune <code>opt-350m</code> on assistant completions only on the Open Assistant Guanaco dataset:",ta,X,ea,Q,mn="Make sure to have a <code>pad_token_id</code> which is different from <code>eos_token_id</code> which can result in the model not properly predicting EOS (End of Sentence) tokens during generation.",aa,z,sa,V,hn="Some tokenizers like Llama 2 (<code>meta-llama/Llama-2-XXb-hf</code>) tokenize sequences differently depending whether they have context or not. For example:",na,W,la,E,Mn="In this case, and due to lack of context in <code>response_template</code>, the same string (”### Assistant:”) is tokenized differently:",oa,N,yn="<li>Text (with context): <code>[2277, 29937, 4007, 22137, 29901]</code></li> <li><code>response_template</code> (without context): <code>[835, 4007, 22137, 29901]</code></li>",ia,S,fn="This will lead to an error when the <code>DataCollatorForCompletionOnlyLM</code> does not find the <code>response_template</code> in the dataset example text:",ra,A,pa,H,Tn="To solve this, you can tokenize the <code>response_template</code> with the same context than in the dataset, truncate it as needed and pass the <code>token_ids</code> directly to the <code>response_template</code> argument of the <code>DataCollatorForCompletionOnlyLM</code> class. For example:",ca,Y,da,L,ua,D,gn=`Adding special tokens to a language model is crucial for training chat models. These tokens are added between the different roles in a conversation, such as the user, assistant, and system and help the model recognize the structure and flow of a conversation. This setup is essential for enabling the model to generate coherent and contextually appropriate responses in a chat environment.
The <code>setup_chat_format()</code> function in <code>trl</code> easily sets up a model and tokenizer for conversational AI tasks. This function:`,ma,P,Un='<li>Adds special tokens to the tokenizer, e.g. <code>&lt;|im_start|&gt;</code> and <code>&lt;|im_end|&gt;</code>, to indicate the start and end of a conversation.</li> <li>Resizes the model’s embedding layer to accommodate the new tokens.</li> <li>Sets the <code>chat_template</code> of the tokenizer, which is used to format the input data into a chat-like format. The default is <code>chatml</code> from OpenAI.</li> <li><em>optionally</em> you can pass <code>resize_to_multiple_of</code> to resize the embedding layer to a multiple of the <code>resize_to_multiple_of</code> argument, e.g. 64. If you want to see more formats being supported in the future, please open a GitHub issue on <a href="https://github.com/huggingface/trl" rel="nofollow">trl</a></li>',ha,O,Ma,K,wn="With our model and tokenizer set up, we can now fine-tune our model on a conversational dataset. Below is an example of how a dataset can be formatted for fine-tuning.",ya,tt,fa,et,jn='The <a href="/docs/trl/v0.7.11/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> supports popular dataset formats. This allows you to pass the dataset to the trainer without any pre-processing directly. The following formats are supported:',Ta,at,bn="<li>conversational format</li>",ga,st,Ua,nt,Jn="<li>instruction format</li>",wa,lt,ja,ot,_n='If your dataset uses one of the above formats, you can directly pass it to the trainer without pre-processing. The <a href="/docs/trl/v0.7.11/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> will then format the dataset for you using the defined format from the model’s tokenizer with the <a href="https://huggingface.co/docs/transformers/main/en/chat_templating#templates-for-chat-models" rel="nofollow">apply_chat_template</a> method.',ba,it,Ja,rt,kn="If the dataset is not in one those format you can either preprocess the dataset to match the formatting or pass a formatting function to the SFTTrainer to do it for you. Let’s have a look.",_a,pt,ka,ct,Cn=`For instruction fine-tuning, it is quite common to have two columns inside the dataset: one for the prompt &amp; the other for the response.
This allows people to format examples like <a href="https://github.com/tatsu-lab/stanford_alpaca" rel="nofollow">Stanford-Alpaca</a> did as follows:`,Ca,dt,va,ut,vn="Let us assume your dataset has two fields, <code>question</code> and <code>answer</code>. Therefore you can just run:",Ia,mt,xa,ht,In='To properly format your input make sure to process all the examples by looping over them and returning a list of processed text. Check out a full example on how to use SFTTrainer on alpaca dataset <a href="https://github.com/huggingface/trl/pull/444#issue-1760952763" rel="nofollow">here</a>',Fa,Mt,$a,yt,xn='<a href="/docs/trl/v0.7.11/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> supports <em>example packing</em>, where multiple short examples are packed in the same input sequence to increase training efficiency. This is done with the <code>ConstantLengthDataset</code> utility class that returns constant length chunks of tokens from a stream of examples. To enable the usage of this dataset class, simply pass <code>packing=True</code> to the <a href="/docs/trl/v0.7.11/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> constructor.',Ga,ft,Za,Tt,Fn="Note that if you use a packed dataset and if you pass <code>max_steps</code> in the training arguments you will probably train your models for more than few epochs, depending on the way you have configured the packed dataset and the training protocol. Double check that you know and understand what you are doing.",Ra,gt,Ba,Ut,$n="If your dataset has several fields that you want to combine, for example if the dataset has <code>question</code> and <code>answer</code> fields and you want to combine them, you can pass a formatting function to the trainer that will take care of that. For example:",qa,wt,Xa,jt,Gn='You can also customize the <code>ConstantLengthDataset</code> much more by directly passing the arguments to the <a href="/docs/trl/v0.7.11/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> constructor. Please refer to that class’ signature for more information.',Qa,bt,za,Jt,Zn='You can directly pass the kwargs of the <code>from_pretrained()</code> method to the <a href="/docs/trl/v0.7.11/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a>. For example, if you want to load a model in a different precision, analogous to',Va,_t,Wa,kt,Ea,Ct,Rn="Note that all keyword arguments of <code>from_pretrained()</code> are supported.",Na,vt,Sa,It,Bn="We also support a tight integration with 🤗 PEFT library so that any user can conveniently train adapters and share them on the Hub instead of training the entire model",Aa,xt,Ha,Ft,qn="You can also continue training your <code>PeftModel</code>. For that, first load a <code>PeftModel</code> outside <code>SFTTrainer</code> and pass it directly to the trainer without the <code>peft_config</code> argument being passed.",Ya,$t,La,Gt,Xn="For that you need to first load your 8bit model outside the Trainer and pass a <code>PeftConfig</code> to the trainer. For example:",Da,Zt,Pa,Rt,Oa,Bt,Qn=`You can benefit from Flash Attention 1 & 2 using SFTTrainer out of the box with minimal changes of code.
First, to make sure you have all the latest features from transformers, install transformers from source`,Ka,qt,ts,Xt,zn=`Note that Flash Attention only works on GPU now and under half-precision regime (when using adapters, base model loaded in half-precision)
Note also both features are perfectly compatible with other tools such as quantization.`,es,Qt,as,zt,Vn="For Flash Attention 1 you can use the <code>BetterTransformer</code> API and force-dispatch the API to use Flash Attention kernel. First, install the latest optimum package:",ss,Vt,ns,Wt,Wn="Once you have loaded your model, wrap the <code>trainer.train()</code> call under the <code>with torch.backends.cuda.sdp_kernel(enable_flash=True, enable_math=False, enable_mem_efficient=False):</code> context manager:",ls,Et,os,Nt,En="Note that you cannot train your model using Flash Attention 1 on an arbitrary dataset as <code>torch.scaled_dot_product_attention</code> does not support training with padding tokens if you use Flash Attention kernels. Therefore you can only use that feature with <code>packing=True</code>. If your dataset contains padding tokens, consider switching to Flash Attention 2 integration.",is,St,Nn="Below are some numbers you can get in terms of speedup and memory efficiency, using Flash Attention 1, on a single NVIDIA-T4 16GB.",rs,At,Sn="<thead><tr><th>use_flash_attn_1</th> <th>model_name</th> <th>max_seq_len</th> <th>batch_size</th> <th>time per training step</th></tr></thead> <tbody><tr><td>x</td> <td>facebook/opt-350m</td> <td>2048</td> <td>8</td> <td>~59.1s</td></tr> <tr><td></td> <td>facebook/opt-350m</td> <td>2048</td> <td>8</td> <td><strong>OOM</strong></td></tr> <tr><td>x</td> <td>facebook/opt-350m</td> <td>2048</td> <td>4</td> <td>~30.3s</td></tr> <tr><td></td> <td>facebook/opt-350m</td> <td>2048</td> <td>4</td> <td>~148.9s</td></tr></tbody>",ps,Ht,cs,Yt,An="To use Flash Attention 2, first install the latest <code>flash-attn</code> package:",ds,Lt,us,Dt,Hn="And add <code>attn_implementation=&quot;flash_attention_2&quot;</code> when calling <code>from_pretrained</code>:",ms,Pt,hs,Ot,Yn=`If you don’t use quantization, make sure your model is loaded in half-precision and dispatch your model on a supported GPU device.
After loading your model, you can either train it as it is, or attach adapters and train adapters on it in case your model is quantized.`,Ms,Kt,Ln="In contrary to Flash Attention 1, the integration makes it possible to train your model on an arbitrary dataset that also includes padding tokens.",ys,te,fs,ee,Dn="We included a utility function to create your model.",Ts,T,ae,Ks,Fe,Pn="Arguments which define the model and tokenizer to load.",gs,se,Us,ne,ws,le,On='NEFTune is a technique to boost the performance of chat models and was introduced by the paper <a href="https://arxiv.org/abs/2310.05914" rel="nofollow">“NEFTune: Noisy Embeddings Improve Instruction Finetuning”</a> from Jain et al. it consists of adding noise to the embedding vectors during training. According to the abstract of the paper:',js,oe,Kn="<p>Standard finetuning of LLaMA-2-7B using Alpaca achieves 29.79% on AlpacaEval, which rises to 64.69% using noisy embeddings. NEFTune also improves over strong baselines on modern instruction datasets. Models trained with Evol-Instruct see a 10% improvement, with ShareGPT an 8% improvement, and with OpenPlatypus an 8% improvement. Even powerful models further refined with RLHF such as LLaMA-2-Chat benefit from additional training with NEFTune.</p>",bs,w,tl='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/neft-screenshot.png"/>',Js,ie,el="To use it in <code>SFTTrainer</code> simply pass <code>neftune_noise_alpha</code> when creating your <code>SFTTrainer</code> instance. Note that to avoid any surprising behaviour, NEFTune is disabled after training to retrieve back the original behaviour of the embedding layer.",_s,re,ks,pe,al='We have tested NEFTune by training <code>mistralai/Mistral-7B-v0.1</code> on the <a href="https://huggingface.co/datasets/timdettmers/openassistant-guanaco" rel="nofollow">OpenAssistant dataset</a> and validated that using NEFTune led to a performance boost of ~25% on MT Bench.',Cs,j,sl='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/trl-neftune-mistral-7b.png"/>',vs,ce,nl='Note however, that the amount of performance gain is <em>dataset dependent</em> and in particular, applying NEFTune on synthetic datasets like <a href="https://huggingface.co/datasets/stingning/ultrachat" rel="nofollow">UltraChat</a> typically produces smaller gains.',Is,de,xs,ue,ll='You can further accelerate QLoRA / LoRA (2x faster, 60% less memory) using the <a href="https://github.com/unslothai/unsloth" rel="nofollow"><code>unsloth</code></a> library that is fully compatible with <code>SFTTrainer</code>. Currently <code>unsloth</code> supports only Llama (Yi, TinyLlama, Qwen, Deepseek etc) and Mistral architectures. Some benchmarks on 1x A100 listed below:',Fs,me,ol="<thead><tr><th>1 A100 40GB</th> <th>Dataset</th> <th>🤗</th> <th>🤗 + Flash Attention 2</th> <th>🦥 Unsloth</th> <th>🦥 VRAM saved</th></tr></thead> <tbody><tr><td>Code Llama 34b</td> <td>Slim Orca</td> <td>1x</td> <td>1.01x</td> <td><strong>1.94x</strong></td> <td>-22.7%</td></tr> <tr><td>Llama-2 7b</td> <td>Slim Orca</td> <td>1x</td> <td>0.96x</td> <td><strong>1.87x</strong></td> <td>-39.3%</td></tr> <tr><td>Mistral 7b</td> <td>Slim Orca</td> <td>1x</td> <td>1.17x</td> <td><strong>1.88x</strong></td> <td>-65.9%</td></tr> <tr><td>Tiny Llama 1.1b</td> <td>Alpaca</td> <td>1x</td> <td>1.55x</td> <td><strong>2.74x</strong></td> <td>-57.8%</td></tr></tbody>",$s,he,il='First install <code>unsloth</code> according to the <a href="https://github.com/unslothai/unsloth" rel="nofollow">official documentation</a>. Once installed, you can incorporate unsloth into your workflow in a very simple manner; instead of loading <code>AutoModelForCausalLM</code>, you just need to load a <code>FastLanguageModel</code> as follows:',Gs,Me,Zs,ye,rl='The saved model is fully compatible with Hugging Face’s transformers library. Learn more about unsloth in their <a href="https://github.com/unslothai/unsloth" rel="nofollow">official repository</a>.',Rs,fe,Bs,Te,pl="Pay attention to the following best practices when training a model with that trainer:",qs,ge,cl='<li><a href="/docs/trl/v0.7.11/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> always pads by default the sequences to the <code>max_seq_length</code> argument of the <a href="/docs/trl/v0.7.11/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a>. If none is passed, the trainer will retrieve that value from the tokenizer. Some tokenizers do not provide default value, so there is a check to retrieve the minimum between 2048 and that value. Make sure to check it before training.</li> <li>For training adapters in 8bit, you might need to tweak the arguments of the <code>prepare_model_for_kbit_training</code> method from PEFT, hence we advise users to use <code>prepare_in_int8_kwargs</code> field, or create the <code>PeftModel</code> outside the <a href="/docs/trl/v0.7.11/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> and pass it.</li> <li>For a more memory-efficient training using adapters, you can load the base model in 8bit, for that simply add <code>load_in_8bit</code> argument when creating the <a href="/docs/trl/v0.7.11/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a>, or create a base model in 8bit outside the trainer and pass it.</li> <li>If you create a model outside the trainer, make sure to not pass to the trainer any additional keyword arguments that are relative to <code>from_pretrained()</code> method.</li>',Xs,Ue,Qs,we,dl='Trainer (and thus SFTTrainer) supports multi-GPU training. If you run your script with <code>python script.py</code> it will default to using DP as the strategy, which may be <a href="https://github.com/huggingface/trl/issues/1303" rel="nofollow">slower than expected</a>. To use DDP (which is generally recommended, see <a href="https://huggingface.co/docs/transformers/en/perf_train_gpu_many?select-gpu=Accelerate#data-parallelism" rel="nofollow">here</a> for more info) you must launch the script with <code>python -m torch.distributed.launch script.py</code> or <code>accelerate launch script.py</code>. For DDP to work you must also check the following:',zs,je,ul='<li>If you’re using gradient_checkpointing, add the following to the TrainingArguments: <code>gradient_checkpointing_kwargs={&#39;use_reentrant&#39;:False}</code> (more info <a href="https://github.com/huggingface/transformers/issues/26969" rel="nofollow">here</a></li> <li>Ensure that the model is placed on the correct device:</li>',Vs,be,Ws,Je,Es,_e,ml="You may experience some issues with GPTQ Quantization after completing training. Lowering <code>gradient_accumulation_steps</code> to <code>4</code> will resolve most issues during the quantization process to GPTQ format.",Ns,ke,Ss,g,Ce,tn,$e,hl=`Class definition of the Supervised Finetuning Trainer (SFT Trainer).
This class is a wrapper around the <code>transformers.Trainer</code> class and inherits all of its attributes and methods.
The trainer takes care of properly initializing the PeftModel in case a user passes a <code>PeftConfig</code> object.`,As,ve,Hs,U,Ie,en,Ge,Ml=`Iterable dataset that returns constant length chunks of tokens from stream of text files.
The dataset also formats the text before tokenization with a specific format that is provided
by the user.`,Ys,Re,Ls;return b=new y({props:{title:"Supervised Fine-tuning Trainer",local:"supervised-fine-tuning-trainer",headingTag:"h1"}}),k=new y({props:{title:"Quickstart",local:"quickstart",headingTag:"h2"}}),v=new M({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVFRyYWluZXIlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmltZGIlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQXRyYWluZXIlMjAlM0QlMjBTRlRUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGRhdGFzZXRfdGV4dF9maWVsZCUzRCUyMnRleHQlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXhfc2VxX2xlbmd0aCUzRDUxMiUyQyUwQSklMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer

dataset = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    max_seq_length=<span class="hljs-number">512</span>,
)
trainer.train()`,wrap:!1}}),F=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVFRyYWluZXIlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmltZGIlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIpJTBBJTBBdHJhaW5lciUyMCUzRCUyMFNGVFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGRhdGFzZXRfdGV4dF9maWVsZCUzRCUyMnRleHQlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXhfc2VxX2xlbmd0aCUzRDUxMiUyQyUwQSklMEElMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer

dataset = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    max_seq_length=<span class="hljs-number">512</span>,
)

trainer.train()`,wrap:!1}}),G=new y({props:{title:"Advanced usage",local:"advanced-usage",headingTag:"h2"}}),Z=new y({props:{title:"Train on completions only",local:"train-on-completions-only",headingTag:"h3"}}),B=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBTRlRUcmFpbmVyJTJDJTIwRGF0YUNvbGxhdG9yRm9yQ29tcGxldGlvbk9ubHlMTSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIybHVjYXNtY2NhYmUtbG1pJTJGQ29kZUFscGFjYS0yMGslMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEElMEFkZWYlMjBmb3JtYXR0aW5nX3Byb21wdHNfZnVuYyhleGFtcGxlKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dF90ZXh0cyUyMCUzRCUyMCU1QiU1RCUwQSUyMCUyMCUyMCUyMGZvciUyMGklMjBpbiUyMHJhbmdlKGxlbihleGFtcGxlJTVCJ2luc3RydWN0aW9uJyU1RCkpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGV4dCUyMCUzRCUyMGYlMjIlMjMlMjMlMjMlMjBRdWVzdGlvbiUzQSUyMCU3QmV4YW1wbGUlNUInaW5zdHJ1Y3Rpb24nJTVEJTVCaSU1RCU3RCU1Q24lMjAlMjMlMjMlMjMlMjBBbnN3ZXIlM0ElMjAlN0JleGFtcGxlJTVCJ291dHB1dCclNUQlNUJpJTVEJTdEJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0X3RleHRzLmFwcGVuZCh0ZXh0KSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG91dHB1dF90ZXh0cyUwQSUwQXJlc3BvbnNlX3RlbXBsYXRlJTIwJTNEJTIwJTIyJTIwJTIzJTIzJTIzJTIwQW5zd2VyJTNBJTIyJTBBY29sbGF0b3IlMjAlM0QlMjBEYXRhQ29sbGF0b3JGb3JDb21wbGV0aW9uT25seUxNKHJlc3BvbnNlX3RlbXBsYXRlJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRyYWluZXIlMjAlM0QlMjBTRlRUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRGRhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBmb3JtYXR0aW5nX2Z1bmMlM0Rmb3JtYXR0aW5nX3Byb21wdHNfZnVuYyUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0Rjb2xsYXRvciUyQyUwQSklMEElMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer, DataCollatorForCompletionOnlyLM

dataset = load_dataset(<span class="hljs-string">&quot;lucasmccabe-lmi/CodeAlpaca-20k&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">formatting_prompts_func</span>(<span class="hljs-params">example</span>):
    output_texts = []
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(example[<span class="hljs-string">&#x27;instruction&#x27;</span>])):
        text = <span class="hljs-string">f&quot;### Question: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;instruction&#x27;</span>][i]}</span>\\n ### Answer: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;output&#x27;</span>][i]}</span>&quot;</span>
        output_texts.append(text)
    <span class="hljs-keyword">return</span> output_texts

response_template = <span class="hljs-string">&quot; ### Answer:&quot;</span>
collator = DataCollatorForCompletionOnlyLM(response_template, tokenizer=tokenizer)

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    formatting_func=formatting_prompts_func,
    data_collator=collator,
)

trainer.train()`,wrap:!1}}),X=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBTRlRUcmFpbmVyJTJDJTIwRGF0YUNvbGxhdG9yRm9yQ29tcGxldGlvbk9ubHlMTSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIydGltZGV0dG1lcnMlMkZvcGVuYXNzaXN0YW50LWd1YW5hY28lMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEElMEFpbnN0cnVjdGlvbl90ZW1wbGF0ZSUyMCUzRCUyMCUyMiUyMyUyMyUyMyUyMEh1bWFuJTNBJTIyJTBBcmVzcG9uc2VfdGVtcGxhdGUlMjAlM0QlMjAlMjIlMjMlMjMlMjMlMjBBc3Npc3RhbnQlM0ElMjIlMEFjb2xsYXRvciUyMCUzRCUyMERhdGFDb2xsYXRvckZvckNvbXBsZXRpb25Pbmx5TE0oaW5zdHJ1Y3Rpb25fdGVtcGxhdGUlM0RpbnN0cnVjdGlvbl90ZW1wbGF0ZSUyQyUyMHJlc3BvbnNlX3RlbXBsYXRlJTNEcmVzcG9uc2VfdGVtcGxhdGUlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMjBtbG0lM0RGYWxzZSklMEElMEF0cmFpbmVyJTIwJTNEJTIwU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwZGF0YXNldF90ZXh0X2ZpZWxkJTNEJTIydGV4dCUyMiUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0Rjb2xsYXRvciUyQyUwQSklMEElMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer, DataCollatorForCompletionOnlyLM

dataset = load_dataset(<span class="hljs-string">&quot;timdettmers/openassistant-guanaco&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

instruction_template = <span class="hljs-string">&quot;### Human:&quot;</span>
response_template = <span class="hljs-string">&quot;### Assistant:&quot;</span>
collator = DataCollatorForCompletionOnlyLM(instruction_template=instruction_template, response_template=response_template, tokenizer=tokenizer, mlm=<span class="hljs-literal">False</span>)

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    data_collator=collator,
)

trainer.train()`,wrap:!1}}),z=new y({props:{title:"Using token_ids directly for response_template",local:"using-tokenids-directly-for-responsetemplate",headingTag:"h4"}}),W=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03Yi1oZiUyMiklMEElMEFkZWYlMjBwcmludF90b2tlbnNfd2l0aF9pZHModHh0KSUzQSUwQSUyMCUyMCUyMCUyMHRva2VucyUyMCUzRCUyMHRva2VuaXplci50b2tlbml6ZSh0eHQlMkMlMjBhZGRfc3BlY2lhbF90b2tlbnMlM0RGYWxzZSklMEElMjAlMjAlMjAlMjB0b2tlbl9pZHMlMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKHR4dCUyQyUyMGFkZF9zcGVjaWFsX3Rva2VucyUzREZhbHNlKSUwQSUyMCUyMCUyMCUyMHByaW50KGxpc3QoemlwKHRva2VucyUyQyUyMHRva2VuX2lkcykpKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMiUyMiUyMiUyMyUyMyUyMyUyMFVzZXIlM0ElMjBIZWxsbyU1Q24lNUNuJTIzJTIzJTIzJTIwQXNzaXN0YW50JTNBJTIwSGklMkMlMjBob3clMjBjYW4lMjBJJTIwaGVscCUyMHlvdSUzRiUyMiUyMiUyMiUwQXByaW50X3Rva2Vuc193aXRoX2lkcyhwcm9tcHQpJTIwJTIwJTIzJTIwJTVCLi4uJTJDJTIwKCclRTIlOTYlODFIZWxsbyclMkMlMjAxNTA0MyklMkMlMjAoJyUzQzB4MEElM0UnJTJDJTIwMTMpJTJDJTIwKCclM0MweDBBJTNFJyUyQyUyMDEzKSUyQyUyMCgnJTIzJTIzJyUyQyUyMDIyNzcpJTJDJTIwKCclMjMnJTJDJTIwMjk5MzcpJTJDJTIwKCclRTIlOTYlODFBc3MnJTJDJTIwNDAwNyklMkMlMjAoJ2lzdGFudCclMkMlMjAyMjEzNyklMkMlMjAoJyUzQSclMkMlMjAyOTkwMSklMkMlMjAuLi4lNUQlMEElMEFyZXNwb25zZV90ZW1wbGF0ZSUyMCUzRCUyMCUyMiUyMyUyMyUyMyUyMEFzc2lzdGFudCUzQSUyMiUwQXByaW50X3Rva2Vuc193aXRoX2lkcyhyZXNwb25zZV90ZW1wbGF0ZSklMjAlMjAlMjMlMjAlNUIoJyVFMiU5NiU4MSUyMyUyMyUyMyclMkMlMjA4MzUpJTJDJTIwKCclRTIlOTYlODFBc3MnJTJDJTIwNDAwNyklMkMlMjAoJ2lzdGFudCclMkMlMjAyMjEzNyklMkMlMjAoJyUzQSclMkMlMjAyOTkwMSklNUQ=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-hf&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">print_tokens_with_ids</span>(<span class="hljs-params">txt</span>):
    tokens = tokenizer.tokenize(txt, add_special_tokens=<span class="hljs-literal">False</span>)
    token_ids = tokenizer.encode(txt, add_special_tokens=<span class="hljs-literal">False</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-built_in">list</span>(<span class="hljs-built_in">zip</span>(tokens, token_ids)))

prompt = <span class="hljs-string">&quot;&quot;&quot;### User: Hello\\n\\n### Assistant: Hi, how can I help you?&quot;&quot;&quot;</span>
print_tokens_with_ids(prompt)  <span class="hljs-comment"># [..., (&#x27;▁Hello&#x27;, 15043), (&#x27;&lt;0x0A&gt;&#x27;, 13), (&#x27;&lt;0x0A&gt;&#x27;, 13), (&#x27;##&#x27;, 2277), (&#x27;#&#x27;, 29937), (&#x27;▁Ass&#x27;, 4007), (&#x27;istant&#x27;, 22137), (&#x27;:&#x27;, 29901), ...]</span>

response_template = <span class="hljs-string">&quot;### Assistant:&quot;</span>
print_tokens_with_ids(response_template)  <span class="hljs-comment"># [(&#x27;▁###&#x27;, 835), (&#x27;▁Ass&#x27;, 4007), (&#x27;istant&#x27;, 22137), (&#x27;:&#x27;, 29901)]</span>`,wrap:!1}}),A=new M({props:{code:"UnVudGltZUVycm9yJTNBJTIwQ291bGQlMjBub3QlMjBmaW5kJTIwcmVzcG9uc2UlMjBrZXklMjAlNUI4MzUlMkMlMjA0MDA3JTJDJTIwMjIxMzclMkMlMjAyOTkwMSU1RCUyMGluJTIwdG9rZW4lMjBJRHMlMjB0ZW5zb3IoJTVCJTIwJTIwJTIwJTIwMSUyQyUyMCUyMCUyMDgzNSUyQyUyMCUyMC4uLiU1RCk=",highlighted:'RuntimeError: Could not find response key <span class="hljs-selector-attr">[835, 4007, 22137, 29901]</span> <span class="hljs-keyword">in</span> token IDs <span class="hljs-built_in">tensor</span>(<span class="hljs-selector-attr">[    1,   835,  ...]</span>)',wrap:!1}}),Y=new M({props:{code:"cmVzcG9uc2VfdGVtcGxhdGVfd2l0aF9jb250ZXh0JTIwJTNEJTIwJTIyJTVDbiUyMyUyMyUyMyUyMEFzc2lzdGFudCUzQSUyMiUyMCUyMCUyMyUyMFdlJTIwYWRkZWQlMjBjb250ZXh0JTIwaGVyZSUzQSUyMCUyMiU1Q24lMjIuJTIwVGhpcyUyMGlzJTIwZW5vdWdoJTIwZm9yJTIwdGhpcyUyMHRva2VuaXplciUwQXJlc3BvbnNlX3RlbXBsYXRlX2lkcyUyMCUzRCUyMHRva2VuaXplci5lbmNvZGUocmVzcG9uc2VfdGVtcGxhdGVfd2l0aF9jb250ZXh0JTJDJTIwYWRkX3NwZWNpYWxfdG9rZW5zJTNERmFsc2UpJTVCMiUzQSU1RCUyMCUyMCUyMyUyME5vdyUyMHdlJTIwaGF2ZSUyMGl0JTIwbGlrZSUyMGluJTIwdGhlJTIwZGF0YXNldCUyMHRleHRzJTNBJTIwJTYwJTVCMjI3NyUyQyUyMDI5OTM3JTJDJTIwNDAwNyUyQyUyMDIyMTM3JTJDJTIwMjk5MDElNUQlNjAlMEElMEFkYXRhX2NvbGxhdG9yJTIwJTNEJTIwRGF0YUNvbGxhdG9yRm9yQ29tcGxldGlvbk9ubHlMTShyZXNwb25zZV90ZW1wbGF0ZV9pZHMlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`response_template_with_context = <span class="hljs-string">&quot;\\n### Assistant:&quot;</span>  <span class="hljs-comment"># We added context here: &quot;\\n&quot;. This is enough for this tokenizer</span>
response_template_ids = tokenizer.encode(response_template_with_context, add_special_tokens=<span class="hljs-literal">False</span>)[<span class="hljs-number">2</span>:]  <span class="hljs-comment"># Now we have it like in the dataset texts: \`[2277, 29937, 4007, 22137, 29901]\`</span>

data_collator = DataCollatorForCompletionOnlyLM(response_template_ids, tokenizer=tokenizer)`,wrap:!1}}),L=new y({props:{title:"Add Special Tokens for Chat Format",local:"add-special-tokens-for-chat-format",headingTag:"h3"}}),O=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQSUyMyUyMExvYWQlMjBtb2RlbCUyMGFuZCUyMHRva2VuaXplciUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEElMEElMjMlMjBTZXQlMjB1cCUyMHRoZSUyMGNoYXQlMjBmb3JtYXQlMjB3aXRoJTIwZGVmYXVsdCUyMCdjaGF0bWwnJTIwZm9ybWF0JTBBbW9kZWwlMkMlMjB0b2tlbml6ZXIlMjAlM0QlMjBzZXR1cF9jaGF0X2Zvcm1hdChtb2RlbCUyQyUyMHRva2VuaXplciklMEE=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-comment"># Load model and tokenizer</span>
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

<span class="hljs-comment"># Set up the chat format with default &#x27;chatml&#x27; format</span>
model, tokenizer = setup_chat_format(model, tokenizer)
`,wrap:!1}}),tt=new y({props:{title:"Dataset format support",local:"dataset-format-support",headingTag:"h3"}}),st=new M({props:{code:"JTdCJTIybWVzc2FnZXMlMjIlM0ElMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGhlbHBmdWwlMjIlN0QlMkMlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0J3MlMjB0aGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlM0YlMjIlN0QlMkMlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMi4uLiUyMiU3RCU1RCU3RCUwQSU3QiUyMm1lc3NhZ2VzJTIyJTNBJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJZb3UlMjBhcmUlMjBoZWxwZnVsJTIyJTdEJTJDJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hvJTIwd3JvdGUlMjAnUm9tZW8lMjBhbmQlMjBKdWxpZXQnJTNGJTIyJTdEJTJDJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjIuLi4lMjIlN0QlNUQlN0QlMEElN0IlMjJtZXNzYWdlcyUyMiUzQSUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwaGVscGZ1bCUyMiU3RCUyQyUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhvdyUyMGZhciUyMGlzJTIwdGhlJTIwTW9vbiUyMGZyb20lMjBFYXJ0aCUzRiUyMiU3RCUyQyUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyLi4uJTIyJTdEJTVEJTdE",highlighted:`<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;messages&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;system&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;You are helpful&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;user&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;What&#x27;s the capital of France?&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;assistant&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;...&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;messages&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;system&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;You are helpful&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;user&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Who wrote &#x27;Romeo and Juliet&#x27;?&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;assistant&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;...&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;messages&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;system&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;You are helpful&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;user&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;How far is the Moon from Earth?&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;assistant&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;...&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">}</span>`,wrap:!1}}),lt=new M({props:{code:"JTdCJTIycHJvbXB0JTIyJTNBJTIwJTIyJTNDcHJvbXB0JTIwdGV4dCUzRSUyMiUyQyUyMCUyMmNvbXBsZXRpb24lMjIlM0ElMjAlMjIlM0NpZGVhbCUyMGdlbmVyYXRlZCUyMHRleHQlM0UlMjIlN0QlMEElN0IlMjJwcm9tcHQlMjIlM0ElMjAlMjIlM0Nwcm9tcHQlMjB0ZXh0JTNFJTIyJTJDJTIwJTIyY29tcGxldGlvbiUyMiUzQSUyMCUyMiUzQ2lkZWFsJTIwZ2VuZXJhdGVkJTIwdGV4dCUzRSUyMiU3RCUwQSU3QiUyMnByb21wdCUyMiUzQSUyMCUyMiUzQ3Byb21wdCUyMHRleHQlM0UlMjIlMkMlMjAlMjJjb21wbGV0aW9uJTIyJTNBJTIwJTIyJTNDaWRlYWwlMjBnZW5lcmF0ZWQlMjB0ZXh0JTNFJTIyJTdE",highlighted:`<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;prompt&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;prompt text&gt;&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;completion&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;ideal generated text&gt;&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;prompt&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;prompt text&gt;&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;completion&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;ideal generated text&gt;&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;prompt&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;prompt text&gt;&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;completion&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;ideal generated text&gt;&quot;</span><span class="hljs-punctuation">}</span>`,wrap:!1}}),it=new M({props:{code:"JTBBJTBBJTBB",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer

...

<span class="hljs-comment"># load jsonl dataset</span>
dataset = load_dataset(<span class="hljs-string">&quot;json&quot;</span>, data_files=<span class="hljs-string">&quot;path/to/dataset.jsonl&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-comment"># load dataset from the HuggingFace Hub</span>
dataset = load_dataset(<span class="hljs-string">&quot;philschmid/dolly-15k-oai-style&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

...

trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    args=training_args,
    train_dataset=dataset,
    packing=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),pt=new y({props:{title:"Format your input prompts",local:"format-your-input-prompts",headingTag:"h3"}}),dt=new M({props:{code:"QmVsb3clMjBpcyUyMGFuJTIwaW5zdHJ1Y3Rpb24lMjAuLi4lMEElMEElMjMlMjMlMjMlMjBJbnN0cnVjdGlvbiUwQSU3QnByb21wdCU3RCUwQSUwQSUyMyUyMyUyMyUyMFJlc3BvbnNlJTNBJTBBJTdCY29tcGxldGlvbiU3RA==",highlighted:`Below is an instruction ...

<span class="hljs-comment">### Instruction</span>
{prompt}

<span class="hljs-comment">### Response:</span>
{completion}`,wrap:!1}}),mt=new M({props:{code:"JTBB",highlighted:`...
<span class="hljs-keyword">def</span> <span class="hljs-title function_">formatting_prompts_func</span>(<span class="hljs-params">example</span>):
    output_texts = []
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(example[<span class="hljs-string">&#x27;question&#x27;</span>])):
        text = <span class="hljs-string">f&quot;### Question: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;question&#x27;</span>][i]}</span>\\n ### Answer: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;answer&#x27;</span>][i]}</span>&quot;</span>
        output_texts.append(text)
    <span class="hljs-keyword">return</span> output_texts

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    formatting_func=formatting_prompts_func,
)

trainer.train()`,wrap:!1}}),Mt=new y({props:{title:"Packing dataset ( ConstantLengthDataset )",local:"packing-dataset--constantlengthdataset-",headingTag:"h3"}}),ft=new M({props:{code:"JTBB",highlighted:`...

trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    packing=<span class="hljs-literal">True</span>
)

trainer.train()`,wrap:!1}}),gt=new y({props:{title:"Customize your prompts using packed dataset",local:"customize-your-prompts-using-packed-dataset",headingTag:"h4"}}),wt=new M({props:{code:"ZGVmJTIwZm9ybWF0dGluZ19mdW5jKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwdGV4dCUyMCUzRCUyMGYlMjIlMjMlMjMlMjMlMjBRdWVzdGlvbiUzQSUyMCU3QmV4YW1wbGUlNUIncXVlc3Rpb24nJTVEJTdEJTVDbiUyMCUyMyUyMyUyMyUyMEFuc3dlciUzQSUyMCU3QmV4YW1wbGUlNUInYW5zd2VyJyU1RCU3RCUyMiUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHRleHQlMEElMEF0cmFpbmVyJTIwJTNEJTIwU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjAlMjJmYWNlYm9vayUyRm9wdC0zNTBtJTIyJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRGRhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBwYWNraW5nJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGZvcm1hdHRpbmdfZnVuYyUzRGZvcm1hdHRpbmdfZnVuYyUwQSklMEElMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">formatting_func</span>(<span class="hljs-params">example</span>):
    text = <span class="hljs-string">f&quot;### Question: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;question&#x27;</span>]}</span>\\n ### Answer: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;answer&#x27;</span>]}</span>&quot;</span>
    <span class="hljs-keyword">return</span> text

trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    packing=<span class="hljs-literal">True</span>,
    formatting_func=formatting_func
)

trainer.train()`,wrap:!1}}),bt=new y({props:{title:"Control over the pretrained model",local:"control-over-the-pretrained-model",headingTag:"h3"}}),_t=new M({props:{code:"bW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYp",highlighted:'model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>, torch_dtype=torch.bfloat16)',wrap:!1}}),kt=new M({props:{code:"JTBB",highlighted:`...

trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    model_init_kwargs={
        <span class="hljs-string">&quot;torch_dtype&quot;</span>: torch.bfloat16,
    },
)

trainer.train()`,wrap:!1}}),vt=new y({props:{title:"Training adapters",local:"training-adapters",headingTag:"h3"}}),xt=new M({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVFRyYWluZXIlMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMExvcmFDb25maWclMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmltZGIlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQXBlZnRfY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjByJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2FscGhhJTNEMzIlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2Ryb3BvdXQlM0QwLjA1JTJDJTBBJTIwJTIwJTIwJTIwYmlhcyUzRCUyMm5vbmUlMjIlMkMlMEElMjAlMjAlMjAlMjB0YXNrX3R5cGUlM0QlMjJDQVVTQUxfTE0lMjIlMkMlMEEpJTBBJTBBdHJhaW5lciUyMCUzRCUyMFNGVFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwJTIyRWxldXRoZXJBSSUyRmdwdC1uZW8tMTI1bSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwZGF0YXNldF90ZXh0X2ZpZWxkJTNEJTIydGV4dCUyMiUyQyUwQSUyMCUyMCUyMCUyMHBlZnRfY29uZmlnJTNEcGVmdF9jb25maWclMEEpJTBBJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

dataset = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

peft_config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)

trainer = SFTTrainer(
    <span class="hljs-string">&quot;EleutherAI/gpt-neo-125m&quot;</span>,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    peft_config=peft_config
)

trainer.train()`,wrap:!1}}),$t=new y({props:{title:"Training adapters with base 8 bit models",local:"training-adapters-with-base-8-bit-models",headingTag:"h3"}}),Zt=new M({props:{code:"JTBBJTBBJTBB",highlighted:`...

peft_config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)

model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;EleutherAI/gpt-neo-125m&quot;</span>,
    load_in_8bit=<span class="hljs-literal">True</span>,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
)

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    peft_config=peft_config,
)

trainer.train()`,wrap:!1}}),Rt=new y({props:{title:"Using Flash Attention and Flash Attention 2",local:"using-flash-attention-and-flash-attention-2",headingTag:"h2"}}),qt=new M({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwZ2l0JTJCaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZ0cmFuc2Zvcm1lcnMuZ2l0",highlighted:"pip install -U git+https://github.com/huggingface/transformers.git",wrap:!1}}),Qt=new y({props:{title:"Using Flash-Attention 1",local:"using-flash-attention-1",headingTag:"h3"}}),Vt=new M({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwb3B0aW11bQ==",highlighted:"pip install -U optimum",wrap:!1}}),Et=new M({props:{code:"",highlighted:`...

<span class="hljs-addition">+ with torch.backends.cuda.sdp_kernel(enable_flash=True, enable_math=False, enable_mem_efficient=False):</span>
    trainer.train()`,wrap:!1}}),Ht=new y({props:{title:"Using Flash Attention-2",local:"using-flash-attention-2",headingTag:"h3"}}),Lt=new M({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwZmxhc2gtYXR0bg==",highlighted:"pip install -U flash-attn",wrap:!1}}),Pt=new M({props:{code:"bW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwYXR0bl9pbXBsZW1lbnRhdGlvbiUzRCUyMmZsYXNoX2F0dGVudGlvbl8yJTIyJTBBKQ==",highlighted:`model = AutoModelForCausalLM.from_pretrained(
    model_id,
    load_in_4bit=<span class="hljs-literal">True</span>,
    attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>
)`,wrap:!1}}),te=new y({props:{title:"Using model creation utility",local:"trl.ModelConfig",headingTag:"h3"}}),ae=new an({props:{name:"class trl.ModelConfig",anchor:"trl.ModelConfig",parameters:[{name:"model_name_or_path",val:": Optional = None"},{name:"model_revision",val:": str = 'main'"},{name:"torch_dtype",val:": Optional = None"},{name:"trust_remote_code",val:": bool = False"},{name:"attn_implementation",val:": Optional = None"},{name:"use_peft",val:": bool = False"},{name:"lora_r",val:": Optional = 16"},{name:"lora_alpha",val:": Optional = 32"},{name:"lora_dropout",val:": Optional = 0.05"},{name:"lora_target_modules",val:": Optional = None"},{name:"lora_modules_to_save",val:": Optional = None"},{name:"load_in_8bit",val:": bool = False"},{name:"load_in_4bit",val:": bool = False"},{name:"bnb_4bit_quant_type",val:": Optional = 'nf4'"},{name:"use_bnb_nested_quant",val:": bool = False"}],source:"https://github.com/huggingface/trl/blob/v0.7.11/trl/trainer/model_config.py#L7"}}),se=new M({props:{code:"ZnJvbSUyMHRybCUyMGltcG9ydCUyME1vZGVsQ29uZmlnJTJDJTIwU0ZUVHJhaW5lciUyQyUyMGdldF9rYml0X2RldmljZV9tYXAlMkMlMjBnZXRfcGVmdF9jb25maWclMkMlMjBnZXRfcXVhbnRpemF0aW9uX2NvbmZpZyUwQW1vZGVsX2NvbmZpZyUyMCUzRCUyME1vZGVsQ29uZmlnKCUwQSUyMCUyMCUyMCUyMG1vZGVsX25hbWVfb3JfcGF0aCUzRCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIlMEElMjAlMjAlMjAlMjBhdHRuX2ltcGxlbWVudGF0aW9uJTNETm9uZSUyQyUyMCUyMyUyMG9yJTIwJTIyZmxhc2hfYXR0ZW50aW9uXzIlMjIlMEEpJTBBdG9yY2hfZHR5cGUlMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwbW9kZWxfY29uZmlnLnRvcmNoX2R0eXBlJTBBJTIwJTIwJTIwJTIwaWYlMjBtb2RlbF9jb25maWcudG9yY2hfZHR5cGUlMjBpbiUyMCU1QiUyMmF1dG8lMjIlMkMlMjBOb25lJTVEJTBBJTIwJTIwJTIwJTIwZWxzZSUyMGdldGF0dHIodG9yY2glMkMlMjBtb2RlbF9jb25maWcudG9yY2hfZHR5cGUpJTBBKSUwQXF1YW50aXphdGlvbl9jb25maWclMjAlM0QlMjBnZXRfcXVhbnRpemF0aW9uX2NvbmZpZyhtb2RlbF9jb25maWcpJTBBbW9kZWxfa3dhcmdzJTIwJTNEJTIwZGljdCglMEElMjAlMjAlMjAlMjByZXZpc2lvbiUzRG1vZGVsX2NvbmZpZy5tb2RlbF9yZXZpc2lvbiUyQyUwQSUyMCUyMCUyMCUyMHRydXN0X3JlbW90ZV9jb2RlJTNEbW9kZWxfY29uZmlnLnRydXN0X3JlbW90ZV9jb2RlJTJDJTBBJTIwJTIwJTIwJTIwYXR0bl9pbXBsZW1lbnRhdGlvbiUzRG1vZGVsX2NvbmZpZy5hdHRuX2ltcGxlbWVudGF0aW9uJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaF9kdHlwZSUyQyUwQSUyMCUyMCUyMCUyMHVzZV9jYWNoZSUzREZhbHNlJTIwaWYlMjB0cmFpbmluZ19hcmdzLmdyYWRpZW50X2NoZWNrcG9pbnRpbmclMjBlbHNlJTIwVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0RnZXRfa2JpdF9kZXZpY2VfbWFwKCklMjBpZiUyMHF1YW50aXphdGlvbl9jb25maWclMjBpcyUyMG5vdCUyME5vbmUlMjBlbHNlJTIwTm9uZSUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudGl6YXRpb25fY29uZmlnJTJDJTBBKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2NvbmZpZy5tb2RlbF9uYW1lX29yX3BhdGglMkMlMjAqKm1vZGVsX2t3YXJncyklMEF0cmFpbmVyJTIwJTNEJTIwU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjAuLi4lMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsX2NvbmZpZy5tb2RlbF9uYW1lX29yX3BhdGglMkMlMEElMjAlMjAlMjAlMjBwZWZ0X2NvbmZpZyUzRGdldF9wZWZ0X2NvbmZpZyhtb2RlbF9jb25maWcpJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> ModelConfig, SFTTrainer, get_kbit_device_map, get_peft_config, get_quantization_config
model_config = ModelConfig(
    model_name_or_path=<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>
    attn_implementation=<span class="hljs-literal">None</span>, <span class="hljs-comment"># or &quot;flash_attention_2&quot;</span>
)
torch_dtype = (
    model_config.torch_dtype
    <span class="hljs-keyword">if</span> model_config.torch_dtype <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;auto&quot;</span>, <span class="hljs-literal">None</span>]
    <span class="hljs-keyword">else</span> <span class="hljs-built_in">getattr</span>(torch, model_config.torch_dtype)
)
quantization_config = get_quantization_config(model_config)
model_kwargs = <span class="hljs-built_in">dict</span>(
    revision=model_config.model_revision,
    trust_remote_code=model_config.trust_remote_code,
    attn_implementation=model_config.attn_implementation,
    torch_dtype=torch_dtype,
    use_cache=<span class="hljs-literal">False</span> <span class="hljs-keyword">if</span> training_args.gradient_checkpointing <span class="hljs-keyword">else</span> <span class="hljs-literal">True</span>,
    device_map=get_kbit_device_map() <span class="hljs-keyword">if</span> quantization_config <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>,
    quantization_config=quantization_config,
)
model = AutoModelForCausalLM.from_pretrained(model_config.model_name_or_path, **model_kwargs)
trainer = SFTTrainer(
    ...,
    model=model_config.model_name_or_path,
    peft_config=get_peft_config(model_config),
)`,wrap:!1}}),ne=new y({props:{title:"Enhance model’s performances using NEFTune",local:"enhance-models-performances-using-neftune",headingTag:"h3"}}),re=new M({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVFRyYWluZXIlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmltZGIlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQXRyYWluZXIlMjAlM0QlMjBTRlRUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGRhdGFzZXRfdGV4dF9maWVsZCUzRCUyMnRleHQlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXhfc2VxX2xlbmd0aCUzRDUxMiUyQyUwQSUyMCUyMCUyMCUyMG5lZnR1bmVfbm9pc2VfYWxwaGElM0Q1JTJDJTBBKSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer

dataset = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    max_seq_length=<span class="hljs-number">512</span>,
    neftune_noise_alpha=<span class="hljs-number">5</span>,
)
trainer.train()`,wrap:!1}}),de=new y({props:{title:"Accelerate fine-tuning 2x using unsloth",local:"accelerate-fine-tuning-2x-using-unsloth",headingTag:"h3"}}),Me=new M({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer
<span class="hljs-keyword">from</span> unsloth <span class="hljs-keyword">import</span> FastLanguageModel

max_seq_length = <span class="hljs-number">2048</span> <span class="hljs-comment"># Supports automatic RoPE Scaling, so choose any number</span>

<span class="hljs-comment"># Load model</span>
model, tokenizer = FastLanguageModel.from_pretrained(
    model_name = <span class="hljs-string">&quot;unsloth/mistral-7b&quot;</span>,
    max_seq_length = max_seq_length,
    dtype = <span class="hljs-literal">None</span>, <span class="hljs-comment"># None for auto detection. Float16 for Tesla T4, V100, Bfloat16 for Ampere+</span>
    load_in_4bit = <span class="hljs-literal">True</span>, <span class="hljs-comment"># Use 4bit quantization to reduce memory usage. Can be False</span>
    <span class="hljs-comment"># token = &quot;hf_...&quot;, # use one if using gated models like meta-llama/Llama-2-7b-hf</span>
)

<span class="hljs-comment"># Do model patching and add fast LoRA weights</span>
model = FastLanguageModel.get_peft_model(
    model,
    r = <span class="hljs-number">16</span>,
    target_modules = [<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;k_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>, <span class="hljs-string">&quot;o_proj&quot;</span>,
                      <span class="hljs-string">&quot;gate_proj&quot;</span>, <span class="hljs-string">&quot;up_proj&quot;</span>, <span class="hljs-string">&quot;down_proj&quot;</span>,],
    lora_alpha = <span class="hljs-number">16</span>,
    lora_dropout = <span class="hljs-number">0</span>, <span class="hljs-comment"># Dropout = 0 is currently optimized</span>
    bias = <span class="hljs-string">&quot;none&quot;</span>,    <span class="hljs-comment"># Bias = &quot;none&quot; is currently optimized</span>
    use_gradient_checkpointing = <span class="hljs-literal">True</span>,
    random_state = <span class="hljs-number">3407</span>,
)

args = TrainingArguments(output_dir = <span class="hljs-string">&quot;./output&quot;</span>)

trainer = SFTTrainer(
    model = model,
    args = args,
    train_dataset = dataset,
    dataset_text_field = <span class="hljs-string">&quot;text&quot;</span>,
    max_seq_length = max_seq_length,
)
trainer.train()`,wrap:!1}}),fe=new y({props:{title:"Best practices",local:"best-practices",headingTag:"h2"}}),Ue=new y({props:{title:"Multi-GPU Training",local:"multi-gpu-training",headingTag:"h2"}}),be=new M({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBQYXJ0aWFsU3RhdGUlMEFkZXZpY2Vfc3RyaW5nJTIwJTNEJTIwUGFydGlhbFN0YXRlKCkucHJvY2Vzc19pbmRleCUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMC4uLiUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlN0InJyUzQWRldmljZV9zdHJpbmclN0QlMEEp",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> PartialState
device_string = PartialState().process_index
model = AutoModelForCausalLM.from_pretrained(
     ...
    device_map={<span class="hljs-string">&#x27;&#x27;</span>:device_string}
)`,wrap:!1}}),Je=new y({props:{title:"GPTQ Conversion",local:"gptq-conversion",headingTag:"h2"}}),ke=new y({props:{title:"SFTTrainer",local:"trl.SFTTrainer",headingTag:"h2"}}),Ce=new an({props:{name:"class trl.SFTTrainer",anchor:"trl.SFTTrainer",parameters:[{name:"model",val:": Union = None"},{name:"args",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"model_init",val:": Optional = None"},{name:"compute_metrics",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"peft_config",val:": Optional = None"},{name:"dataset_text_field",val:": Optional = None"},{name:"packing",val:": Optional = False"},{name:"formatting_func",val:": Optional = None"},{name:"max_seq_length",val:": Optional = None"},{name:"infinite",val:": Optional = None"},{name:"num_of_sequences",val:": Optional = 1024"},{name:"chars_per_token",val:": Optional = 3.6"},{name:"dataset_num_proc",val:": Optional = None"},{name:"dataset_batch_size",val:": int = 1000"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"model_init_kwargs",val:": Optional = None"},{name:"dataset_kwargs",val:": Optional = None"}],parametersDescription:[{anchor:"trl.SFTTrainer.model",description:`<strong>model</strong> (Union[<code>transformers.PreTrainedModel</code>, <code>nn.Module</code>, <code>str</code>]) &#x2014;
The model to train, can be a <code>PreTrainedModel</code>, a <code>torch.nn.Module</code> or a string with the model name to
load from cache or download. The model can be also converted to a <code>PeftModel</code> if a <code>PeftConfig</code> object is
passed to the <code>peft_config</code> argument.`,name:"model"},{anchor:"trl.SFTTrainer.args",description:`<strong>args</strong> (Optional<a href="https://huggingface.co/docs/transformers/v4.37.2/en/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">transformers.TrainingArguments</a>) &#x2014;
The arguments to tweak for training. Please refer to the official documentation of <code>transformers.TrainingArguments</code>
for more information.`,name:"args"},{anchor:"trl.SFTTrainer.data_collator",description:`<strong>data_collator</strong> (Optional<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training.`,name:"data_collator"},{anchor:"trl.SFTTrainer.train_dataset",description:`<strong>train_dataset</strong> (Optional<a href="https://huggingface.co/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">datasets.Dataset</a>) &#x2014;
The dataset to use for training. We recommend users to use <code>trl.trainer.ConstantLengthDataset</code> to create their dataset.`,name:"train_dataset"},{anchor:"trl.SFTTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (Optional[Union[<code>datasets.Dataset</code>, Dict[<code>str</code>, <code>datasets.Dataset</code>]]]) &#x2014;
The dataset to use for evaluation. We recommend users to use <code>trl.trainer.ConstantLengthDataset</code> to create their dataset.`,name:"eval_dataset"},{anchor:"trl.SFTTrainer.tokenizer",description:`<strong>tokenizer</strong> (Optional<a href="https://huggingface.co/docs/transformers/v4.37.2/en/main_classes/tokenizer#transformers.PreTrainedTokenizer" rel="nofollow">transformers.PreTrainedTokenizer</a>) &#x2014;
The tokenizer to use for training. If not specified, the tokenizer associated to the model will be used.`,name:"tokenizer"},{anchor:"trl.SFTTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.SFTTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[transformers.EvalPrediction], Dict]</code>, <em>optional</em> defaults to None) &#x2014;
The function used to compute metrics during evaluation. It should return a dictionary mapping metric names to metric values.
If not specified, only the loss will be computed during evaluation.`,name:"compute_metrics"},{anchor:"trl.SFTTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.SFTTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.SFTTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.SFTTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Optional[PeftConfig]</code>) &#x2014;
The PeftConfig object to use to initialize the PeftModel.`,name:"peft_config"},{anchor:"trl.SFTTrainer.dataset_text_field",description:`<strong>dataset_text_field</strong> (<code>Optional[str]</code>) &#x2014;
The name of the text field of the dataset, in case this is passed by a user, the trainer will automatically create a
<code>ConstantLengthDataset</code> based on the <code>dataset_text_field</code> argument.`,name:"dataset_text_field"},{anchor:"trl.SFTTrainer.formatting_func",description:`<strong>formatting_func</strong> (<code>Optional[Callable]</code>) &#x2014;
The formatting function to be used for creating the <code>ConstantLengthDataset</code>.`,name:"formatting_func"},{anchor:"trl.SFTTrainer.max_seq_length",description:`<strong>max_seq_length</strong> (<code>Optional[int]</code>) &#x2014;
The maximum sequence length to use for the <code>ConstantLengthDataset</code> and for automatically creating the Dataset. Defaults to <code>512</code>.`,name:"max_seq_length"},{anchor:"trl.SFTTrainer.infinite",description:`<strong>infinite</strong> (<code>Optional[bool]</code>) &#x2014;
Whether to use an infinite dataset or not. Defaults to <code>False</code>.`,name:"infinite"},{anchor:"trl.SFTTrainer.num_of_sequences",description:`<strong>num_of_sequences</strong> (<code>Optional[int]</code>) &#x2014;
The number of sequences to use for the <code>ConstantLengthDataset</code>. Defaults to <code>1024</code>.`,name:"num_of_sequences"},{anchor:"trl.SFTTrainer.chars_per_token",description:`<strong>chars_per_token</strong> (<code>Optional[float]</code>) &#x2014;
The number of characters per token to use for the <code>ConstantLengthDataset</code>. Defaults to <code>3.6</code>. You can check how this is computed in the
stack-llama example: <a href="https://github.com/huggingface/trl/blob/08f550674c553c36c51d1027613c29f14f3676a5/examples/stack_llama/scripts/supervised_finetuning.py#L53" rel="nofollow">https://github.com/huggingface/trl/blob/08f550674c553c36c51d1027613c29f14f3676a5/examples/stack_llama/scripts/supervised_finetuning.py#L53</a>.`,name:"chars_per_token"},{anchor:"trl.SFTTrainer.packing",description:`<strong>packing</strong> (<code>Optional[bool]</code>) &#x2014;
Used only in case <code>dataset_text_field</code> is passed. This argument is used by the <code>ConstantLengthDataset</code> to pack the sequences
of the dataset.`,name:"packing"},{anchor:"trl.SFTTrainer.dataset_num_proc",description:`<strong>dataset_num_proc</strong> (<code>Optional[int]</code>) &#x2014;
The number of workers to use to tokenize the data. Only used when <code>packing=False</code>. Defaults to None.`,name:"dataset_num_proc"},{anchor:"trl.SFTTrainer.dataset_batch_size",description:`<strong>dataset_batch_size</strong> (<code>int</code>) &#x2014;
The number of examples to tokenize per batch. If batch_size &lt;= 0 or batch_size == None,
tokenize the full dataset as a single batch. Defaults to 1000.`,name:"dataset_batch_size"},{anchor:"trl.SFTTrainer.neftune_noise_alpha",description:`<strong>neftune_noise_alpha</strong> (<code>Optional[float]</code>) &#x2014;
If not <code>None</code>, this will activate NEFTune noise embeddings. This has been proven to drastically improve model performances for instruction
fine-tuning. Check out the original paper here: <a href="https://arxiv.org/abs/2310.05914" rel="nofollow">https://arxiv.org/abs/2310.05914</a> and the original code here: <a href="https://github.com/neelsjain/NEFTune" rel="nofollow">https://github.com/neelsjain/NEFTune</a>
model_init_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when instantiating the model from a string
dataset_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when creating packed or non-packed datasets`,name:"neftune_noise_alpha"}],source:"https://github.com/huggingface/trl/blob/v0.7.11/trl/trainer/sft_trainer.py#L55"}}),ve=new y({props:{title:"ConstantLengthDataset",local:"trl.trainer.ConstantLengthDataset",headingTag:"h2"}}),Ie=new an({props:{name:"class trl.trainer.ConstantLengthDataset",anchor:"trl.trainer.ConstantLengthDataset",parameters:[{name:"tokenizer",val:""},{name:"dataset",val:""},{name:"dataset_text_field",val:" = None"},{name:"formatting_func",val:" = None"},{name:"infinite",val:" = False"},{name:"seq_length",val:" = 1024"},{name:"num_of_sequences",val:" = 1024"},{name:"chars_per_token",val:" = 3.6"},{name:"eos_token_id",val:" = 0"},{name:"shuffle",val:" = True"},{name:"append_concat_token",val:" = True"},{name:"add_special_tokens",val:" = True"}],parametersDescription:[{anchor:"trl.trainer.ConstantLengthDataset.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizer</code>) &#x2014;
The processor used for processing the data.`,name:"tokenizer"},{anchor:"trl.trainer.ConstantLengthDataset.dataset",description:`<strong>dataset</strong> (<code>dataset.Dataset</code>) &#x2014;
Dataset with text files.`,name:"dataset"},{anchor:"trl.trainer.ConstantLengthDataset.dataset_text_field",description:`<strong>dataset_text_field</strong> (<code>str</code>, <strong>optional</strong>) &#x2014;
Name of the field in the dataset that contains the text. Used only if <code>formatting_func</code> is <code>None</code>.`,name:"dataset_text_field"},{anchor:"trl.trainer.ConstantLengthDataset.formatting_func",description:`<strong>formatting_func</strong> (<code>Callable</code>, <strong>optional</strong>) &#x2014;
Function that formats the text before tokenization. Usually it is recommended to have follows a certain
pattern such as <code>&quot;### Question: {question} ### Answer: {answer}&quot;</code>`,name:"formatting_func"},{anchor:"trl.trainer.ConstantLengthDataset.infinite",description:`<strong>infinite</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If True the iterator is reset after dataset reaches end else stops.`,name:"infinite"},{anchor:"trl.trainer.ConstantLengthDataset.seq_length",description:`<strong>seq_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>1024</code>) &#x2014;
Length of token sequences to return.`,name:"seq_length"},{anchor:"trl.trainer.ConstantLengthDataset.num_of_sequences",description:`<strong>num_of_sequences</strong> (<code>int</code>, <em>optional</em>, defaults to <code>1024</code>) &#x2014;
Number of token sequences to keep in buffer.`,name:"num_of_sequences"},{anchor:"trl.trainer.ConstantLengthDataset.chars_per_token",description:`<strong>chars_per_token</strong> (<code>int</code>, <em>optional</em>, defaults to <code>3.6</code>) &#x2014;
Number of characters per token used to estimate number of tokens in text buffer.`,name:"chars_per_token"},{anchor:"trl.trainer.ConstantLengthDataset.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to <code>0</code>) &#x2014;
Id of the end of sequence token if the passed tokenizer does not have an EOS token.`,name:"eos_token_id"},{anchor:"trl.trainer.ConstantLengthDataset.shuffle",description:`<strong>shuffle</strong> (&#x2018;bool&#x2019;, <em>optional</em>, defaults to True) &#x2014;
Shuffle the examples before they are returned`,name:"shuffle"},{anchor:"trl.trainer.ConstantLengthDataset.append_concat_token",description:`<strong>append_concat_token</strong> (&#x2018;bool&#x2019;, <em>optional</em>, defaults to True) &#x2014;
If true, appends <code>eos_token_id</code> at the end of each sample being packed.`,name:"append_concat_token"},{anchor:"trl.trainer.ConstantLengthDataset.add_special_tokens",description:`<strong>add_special_tokens</strong> (&#x2018;bool&#x2019;, <em>optional</em>, defaults to True) &#x2014;
If true, tokenizers adds special tokens to each sample being packed.`,name:"add_special_tokens"}],source:"https://github.com/huggingface/trl/blob/v0.7.11/trl/trainer/utils.py#L361"}}),{c(){f=o("meta"),Xe=n(),Ze=o("p"),Qe=n(),p(b.$$.fragment),ze=n(),J=o("p"),J.textContent=nn,Ve=n(),_=o("p"),_.innerHTML=ln,We=n(),p(k.$$.fragment),Ee=n(),C=o("p"),C.innerHTML=on,Ne=n(),p(v.$$.fragment),Se=n(),I=o("p"),I.innerHTML=rn,Ae=n(),x=o("p"),x.textContent=pn,He=n(),p(F.$$.fragment),Ye=n(),$=o("p"),$.innerHTML=cn,Le=n(),p(G.$$.fragment),De=n(),p(Z.$$.fragment),Pe=n(),R=o("p"),R.innerHTML=dn,Oe=n(),p(B.$$.fragment),Ke=n(),q=o("p"),q.innerHTML=un,ta=n(),p(X.$$.fragment),ea=n(),Q=o("p"),Q.innerHTML=mn,aa=n(),p(z.$$.fragment),sa=n(),V=o("p"),V.innerHTML=hn,na=n(),p(W.$$.fragment),la=n(),E=o("p"),E.innerHTML=Mn,oa=n(),N=o("ul"),N.innerHTML=yn,ia=n(),S=o("p"),S.innerHTML=fn,ra=n(),p(A.$$.fragment),pa=n(),H=o("p"),H.innerHTML=Tn,ca=n(),p(Y.$$.fragment),da=n(),p(L.$$.fragment),ua=n(),D=o("p"),D.innerHTML=gn,ma=n(),P=o("ul"),P.innerHTML=Un,ha=n(),p(O.$$.fragment),Ma=n(),K=o("p"),K.textContent=wn,ya=n(),p(tt.$$.fragment),fa=n(),et=o("p"),et.innerHTML=jn,Ta=n(),at=o("ul"),at.innerHTML=bn,ga=n(),p(st.$$.fragment),Ua=n(),nt=o("ul"),nt.innerHTML=Jn,wa=n(),p(lt.$$.fragment),ja=n(),ot=o("p"),ot.innerHTML=_n,ba=n(),p(it.$$.fragment),Ja=n(),rt=o("p"),rt.textContent=kn,_a=n(),p(pt.$$.fragment),ka=n(),ct=o("p"),ct.innerHTML=Cn,Ca=n(),p(dt.$$.fragment),va=n(),ut=o("p"),ut.innerHTML=vn,Ia=n(),p(mt.$$.fragment),xa=n(),ht=o("p"),ht.innerHTML=In,Fa=n(),p(Mt.$$.fragment),$a=n(),yt=o("p"),yt.innerHTML=xn,Ga=n(),p(ft.$$.fragment),Za=n(),Tt=o("p"),Tt.innerHTML=Fn,Ra=n(),p(gt.$$.fragment),Ba=n(),Ut=o("p"),Ut.innerHTML=$n,qa=n(),p(wt.$$.fragment),Xa=n(),jt=o("p"),jt.innerHTML=Gn,Qa=n(),p(bt.$$.fragment),za=n(),Jt=o("p"),Jt.innerHTML=Zn,Va=n(),p(_t.$$.fragment),Wa=n(),p(kt.$$.fragment),Ea=n(),Ct=o("p"),Ct.innerHTML=Rn,Na=n(),p(vt.$$.fragment),Sa=n(),It=o("p"),It.textContent=Bn,Aa=n(),p(xt.$$.fragment),Ha=n(),Ft=o("p"),Ft.innerHTML=qn,Ya=n(),p($t.$$.fragment),La=n(),Gt=o("p"),Gt.innerHTML=Xn,Da=n(),p(Zt.$$.fragment),Pa=n(),p(Rt.$$.fragment),Oa=n(),Bt=o("p"),Bt.textContent=Qn,Ka=n(),p(qt.$$.fragment),ts=n(),Xt=o("p"),Xt.textContent=zn,es=n(),p(Qt.$$.fragment),as=n(),zt=o("p"),zt.innerHTML=Vn,ss=n(),p(Vt.$$.fragment),ns=n(),Wt=o("p"),Wt.innerHTML=Wn,ls=n(),p(Et.$$.fragment),os=n(),Nt=o("p"),Nt.innerHTML=En,is=n(),St=o("p"),St.textContent=Nn,rs=n(),At=o("table"),At.innerHTML=Sn,ps=n(),p(Ht.$$.fragment),cs=n(),Yt=o("p"),Yt.innerHTML=An,ds=n(),p(Lt.$$.fragment),us=n(),Dt=o("p"),Dt.innerHTML=Hn,ms=n(),p(Pt.$$.fragment),hs=n(),Ot=o("p"),Ot.textContent=Yn,Ms=n(),Kt=o("p"),Kt.textContent=Ln,ys=n(),p(te.$$.fragment),fs=n(),ee=o("p"),ee.textContent=Dn,Ts=n(),T=o("div"),p(ae.$$.fragment),Ks=n(),Fe=o("p"),Fe.textContent=Pn,gs=n(),p(se.$$.fragment),Us=n(),p(ne.$$.fragment),ws=n(),le=o("p"),le.innerHTML=On,js=n(),oe=o("blockquote"),oe.innerHTML=Kn,bs=n(),w=o("div"),w.innerHTML=tl,Js=n(),ie=o("p"),ie.innerHTML=el,_s=n(),p(re.$$.fragment),ks=n(),pe=o("p"),pe.innerHTML=al,Cs=n(),j=o("div"),j.innerHTML=sl,vs=n(),ce=o("p"),ce.innerHTML=nl,Is=n(),p(de.$$.fragment),xs=n(),ue=o("p"),ue.innerHTML=ll,Fs=n(),me=o("table"),me.innerHTML=ol,$s=n(),he=o("p"),he.innerHTML=il,Gs=n(),p(Me.$$.fragment),Zs=n(),ye=o("p"),ye.innerHTML=rl,Rs=n(),p(fe.$$.fragment),Bs=n(),Te=o("p"),Te.textContent=pl,qs=n(),ge=o("ul"),ge.innerHTML=cl,Xs=n(),p(Ue.$$.fragment),Qs=n(),we=o("p"),we.innerHTML=dl,zs=n(),je=o("ul"),je.innerHTML=ul,Vs=n(),p(be.$$.fragment),Ws=n(),p(Je.$$.fragment),Es=n(),_e=o("p"),_e.innerHTML=ml,Ns=n(),p(ke.$$.fragment),Ss=n(),g=o("div"),p(Ce.$$.fragment),tn=n(),$e=o("p"),$e.innerHTML=hl,As=n(),p(ve.$$.fragment),Hs=n(),U=o("div"),p(Ie.$$.fragment),en=n(),Ge=o("p"),Ge.textContent=Ml,Ys=n(),Re=o("p"),this.h()},l(t){const e=jl("svelte-u9bgzb",document.head);f=i(e,"META",{name:!0,content:!0}),e.forEach(a),Xe=l(t),Ze=i(t,"P",{}),Be(Ze).forEach(a),Qe=l(t),c(b.$$.fragment,t),ze=l(t),J=i(t,"P",{"data-svelte-h":!0}),r(J)!=="svelte-o839x3"&&(J.textContent=nn),Ve=l(t),_=i(t,"P",{"data-svelte-h":!0}),r(_)!=="svelte-exgkch"&&(_.innerHTML=ln),We=l(t),c(k.$$.fragment,t),Ee=l(t),C=i(t,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1quuet8"&&(C.innerHTML=on),Ne=l(t),c(v.$$.fragment,t),Se=l(t),I=i(t,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1gbidw"&&(I.innerHTML=rn),Ae=l(t),x=i(t,"P",{"data-svelte-h":!0}),r(x)!=="svelte-ulikv8"&&(x.textContent=pn),He=l(t),c(F.$$.fragment,t),Ye=l(t),$=i(t,"P",{"data-svelte-h":!0}),r($)!=="svelte-1rem0of"&&($.innerHTML=cn),Le=l(t),c(G.$$.fragment,t),De=l(t),c(Z.$$.fragment,t),Pe=l(t),R=i(t,"P",{"data-svelte-h":!0}),r(R)!=="svelte-13sbeoj"&&(R.innerHTML=dn),Oe=l(t),c(B.$$.fragment,t),Ke=l(t),q=i(t,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1a743rp"&&(q.innerHTML=un),ta=l(t),c(X.$$.fragment,t),ea=l(t),Q=i(t,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-rjhq4r"&&(Q.innerHTML=mn),aa=l(t),c(z.$$.fragment,t),sa=l(t),V=i(t,"P",{"data-svelte-h":!0}),r(V)!=="svelte-dfggk8"&&(V.innerHTML=hn),na=l(t),c(W.$$.fragment,t),la=l(t),E=i(t,"P",{"data-svelte-h":!0}),r(E)!=="svelte-xlwe87"&&(E.innerHTML=Mn),oa=l(t),N=i(t,"UL",{"data-svelte-h":!0}),r(N)!=="svelte-1enki0k"&&(N.innerHTML=yn),ia=l(t),S=i(t,"P",{"data-svelte-h":!0}),r(S)!=="svelte-14yxh0m"&&(S.innerHTML=fn),ra=l(t),c(A.$$.fragment,t),pa=l(t),H=i(t,"P",{"data-svelte-h":!0}),r(H)!=="svelte-13h81gp"&&(H.innerHTML=Tn),ca=l(t),c(Y.$$.fragment,t),da=l(t),c(L.$$.fragment,t),ua=l(t),D=i(t,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1ccg0zx"&&(D.innerHTML=gn),ma=l(t),P=i(t,"UL",{"data-svelte-h":!0}),r(P)!=="svelte-ebt5re"&&(P.innerHTML=Un),ha=l(t),c(O.$$.fragment,t),Ma=l(t),K=i(t,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1hmfl2q"&&(K.textContent=wn),ya=l(t),c(tt.$$.fragment,t),fa=l(t),et=i(t,"P",{"data-svelte-h":!0}),r(et)!=="svelte-1j1m8u9"&&(et.innerHTML=jn),Ta=l(t),at=i(t,"UL",{"data-svelte-h":!0}),r(at)!=="svelte-5iwuvk"&&(at.innerHTML=bn),ga=l(t),c(st.$$.fragment,t),Ua=l(t),nt=i(t,"UL",{"data-svelte-h":!0}),r(nt)!=="svelte-23l1e6"&&(nt.innerHTML=Jn),wa=l(t),c(lt.$$.fragment,t),ja=l(t),ot=i(t,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-1vr7pqv"&&(ot.innerHTML=_n),ba=l(t),c(it.$$.fragment,t),Ja=l(t),rt=i(t,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-1da8xo3"&&(rt.textContent=kn),_a=l(t),c(pt.$$.fragment,t),ka=l(t),ct=i(t,"P",{"data-svelte-h":!0}),r(ct)!=="svelte-cqsf2h"&&(ct.innerHTML=Cn),Ca=l(t),c(dt.$$.fragment,t),va=l(t),ut=i(t,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-l25vq0"&&(ut.innerHTML=vn),Ia=l(t),c(mt.$$.fragment,t),xa=l(t),ht=i(t,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-1tv1he7"&&(ht.innerHTML=In),Fa=l(t),c(Mt.$$.fragment,t),$a=l(t),yt=i(t,"P",{"data-svelte-h":!0}),r(yt)!=="svelte-e9x59a"&&(yt.innerHTML=xn),Ga=l(t),c(ft.$$.fragment,t),Za=l(t),Tt=i(t,"P",{"data-svelte-h":!0}),r(Tt)!=="svelte-5wxaqa"&&(Tt.innerHTML=Fn),Ra=l(t),c(gt.$$.fragment,t),Ba=l(t),Ut=i(t,"P",{"data-svelte-h":!0}),r(Ut)!=="svelte-iejqw3"&&(Ut.innerHTML=$n),qa=l(t),c(wt.$$.fragment,t),Xa=l(t),jt=i(t,"P",{"data-svelte-h":!0}),r(jt)!=="svelte-1rnhgii"&&(jt.innerHTML=Gn),Qa=l(t),c(bt.$$.fragment,t),za=l(t),Jt=i(t,"P",{"data-svelte-h":!0}),r(Jt)!=="svelte-1c44ysq"&&(Jt.innerHTML=Zn),Va=l(t),c(_t.$$.fragment,t),Wa=l(t),c(kt.$$.fragment,t),Ea=l(t),Ct=i(t,"P",{"data-svelte-h":!0}),r(Ct)!=="svelte-1su7aih"&&(Ct.innerHTML=Rn),Na=l(t),c(vt.$$.fragment,t),Sa=l(t),It=i(t,"P",{"data-svelte-h":!0}),r(It)!=="svelte-11jfbzz"&&(It.textContent=Bn),Aa=l(t),c(xt.$$.fragment,t),Ha=l(t),Ft=i(t,"P",{"data-svelte-h":!0}),r(Ft)!=="svelte-pwdaav"&&(Ft.innerHTML=qn),Ya=l(t),c($t.$$.fragment,t),La=l(t),Gt=i(t,"P",{"data-svelte-h":!0}),r(Gt)!=="svelte-zbh7v5"&&(Gt.innerHTML=Xn),Da=l(t),c(Zt.$$.fragment,t),Pa=l(t),c(Rt.$$.fragment,t),Oa=l(t),Bt=i(t,"P",{"data-svelte-h":!0}),r(Bt)!=="svelte-fyvvsj"&&(Bt.textContent=Qn),Ka=l(t),c(qt.$$.fragment,t),ts=l(t),Xt=i(t,"P",{"data-svelte-h":!0}),r(Xt)!=="svelte-yypgof"&&(Xt.textContent=zn),es=l(t),c(Qt.$$.fragment,t),as=l(t),zt=i(t,"P",{"data-svelte-h":!0}),r(zt)!=="svelte-yugu96"&&(zt.innerHTML=Vn),ss=l(t),c(Vt.$$.fragment,t),ns=l(t),Wt=i(t,"P",{"data-svelte-h":!0}),r(Wt)!=="svelte-1qms4cl"&&(Wt.innerHTML=Wn),ls=l(t),c(Et.$$.fragment,t),os=l(t),Nt=i(t,"P",{"data-svelte-h":!0}),r(Nt)!=="svelte-qe5zfz"&&(Nt.innerHTML=En),is=l(t),St=i(t,"P",{"data-svelte-h":!0}),r(St)!=="svelte-69u1rz"&&(St.textContent=Nn),rs=l(t),At=i(t,"TABLE",{"data-svelte-h":!0}),r(At)!=="svelte-8fq96j"&&(At.innerHTML=Sn),ps=l(t),c(Ht.$$.fragment,t),cs=l(t),Yt=i(t,"P",{"data-svelte-h":!0}),r(Yt)!=="svelte-1rqlm78"&&(Yt.innerHTML=An),ds=l(t),c(Lt.$$.fragment,t),us=l(t),Dt=i(t,"P",{"data-svelte-h":!0}),r(Dt)!=="svelte-14s96xo"&&(Dt.innerHTML=Hn),ms=l(t),c(Pt.$$.fragment,t),hs=l(t),Ot=i(t,"P",{"data-svelte-h":!0}),r(Ot)!=="svelte-vfpk19"&&(Ot.textContent=Yn),Ms=l(t),Kt=i(t,"P",{"data-svelte-h":!0}),r(Kt)!=="svelte-zatc00"&&(Kt.textContent=Ln),ys=l(t),c(te.$$.fragment,t),fs=l(t),ee=i(t,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-u9yx96"&&(ee.textContent=Dn),Ts=l(t),T=i(t,"DIV",{class:!0});var Ds=Be(T);c(ae.$$.fragment,Ds),Ks=l(Ds),Fe=i(Ds,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-fghgxx"&&(Fe.textContent=Pn),Ds.forEach(a),gs=l(t),c(se.$$.fragment,t),Us=l(t),c(ne.$$.fragment,t),ws=l(t),le=i(t,"P",{"data-svelte-h":!0}),r(le)!=="svelte-6trhkk"&&(le.innerHTML=On),js=l(t),oe=i(t,"BLOCKQUOTE",{"data-svelte-h":!0}),r(oe)!=="svelte-1ejl1pl"&&(oe.innerHTML=Kn),bs=l(t),w=i(t,"DIV",{style:!0,"data-svelte-h":!0}),r(w)!=="svelte-1wkjgyb"&&(w.innerHTML=tl),Js=l(t),ie=i(t,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-7jwpzy"&&(ie.innerHTML=el),_s=l(t),c(re.$$.fragment,t),ks=l(t),pe=i(t,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-sqj12"&&(pe.innerHTML=al),Cs=l(t),j=i(t,"DIV",{style:!0,"data-svelte-h":!0}),r(j)!=="svelte-a1m5gi"&&(j.innerHTML=sl),vs=l(t),ce=i(t,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-rwofnh"&&(ce.innerHTML=nl),Is=l(t),c(de.$$.fragment,t),xs=l(t),ue=i(t,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1q1m1nw"&&(ue.innerHTML=ll),Fs=l(t),me=i(t,"TABLE",{"data-svelte-h":!0}),r(me)!=="svelte-lj2wpp"&&(me.innerHTML=ol),$s=l(t),he=i(t,"P",{"data-svelte-h":!0}),r(he)!=="svelte-1p74c9x"&&(he.innerHTML=il),Gs=l(t),c(Me.$$.fragment,t),Zs=l(t),ye=i(t,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1o18rwj"&&(ye.innerHTML=rl),Rs=l(t),c(fe.$$.fragment,t),Bs=l(t),Te=i(t,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-g801h1"&&(Te.textContent=pl),qs=l(t),ge=i(t,"UL",{"data-svelte-h":!0}),r(ge)!=="svelte-chftc0"&&(ge.innerHTML=cl),Xs=l(t),c(Ue.$$.fragment,t),Qs=l(t),we=i(t,"P",{"data-svelte-h":!0}),r(we)!=="svelte-s3xf41"&&(we.innerHTML=dl),zs=l(t),je=i(t,"UL",{"data-svelte-h":!0}),r(je)!=="svelte-19jsxq"&&(je.innerHTML=ul),Vs=l(t),c(be.$$.fragment,t),Ws=l(t),c(Je.$$.fragment,t),Es=l(t),_e=i(t,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-xofzi2"&&(_e.innerHTML=ml),Ns=l(t),c(ke.$$.fragment,t),Ss=l(t),g=i(t,"DIV",{class:!0});var Ps=Be(g);c(Ce.$$.fragment,Ps),tn=l(Ps),$e=i(Ps,"P",{"data-svelte-h":!0}),r($e)!=="svelte-14oyph8"&&($e.innerHTML=hl),Ps.forEach(a),As=l(t),c(ve.$$.fragment,t),Hs=l(t),U=i(t,"DIV",{class:!0});var Os=Be(U);c(Ie.$$.fragment,Os),en=l(Os),Ge=i(Os,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-1dlriq1"&&(Ge.textContent=Ml),Os.forEach(a),Ys=l(t),Re=i(t,"P",{}),Be(Re).forEach(a),this.h()},h(){qe(f,"name","hf:doc:metadata"),qe(f,"content",Jl),qe(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),yl(w,"text-align","center"),yl(j,"text-align","center"),qe(g,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),qe(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(t,e){xe(document.head,f),s(t,Xe,e),s(t,Ze,e),s(t,Qe,e),d(b,t,e),s(t,ze,e),s(t,J,e),s(t,Ve,e),s(t,_,e),s(t,We,e),d(k,t,e),s(t,Ee,e),s(t,C,e),s(t,Ne,e),d(v,t,e),s(t,Se,e),s(t,I,e),s(t,Ae,e),s(t,x,e),s(t,He,e),d(F,t,e),s(t,Ye,e),s(t,$,e),s(t,Le,e),d(G,t,e),s(t,De,e),d(Z,t,e),s(t,Pe,e),s(t,R,e),s(t,Oe,e),d(B,t,e),s(t,Ke,e),s(t,q,e),s(t,ta,e),d(X,t,e),s(t,ea,e),s(t,Q,e),s(t,aa,e),d(z,t,e),s(t,sa,e),s(t,V,e),s(t,na,e),d(W,t,e),s(t,la,e),s(t,E,e),s(t,oa,e),s(t,N,e),s(t,ia,e),s(t,S,e),s(t,ra,e),d(A,t,e),s(t,pa,e),s(t,H,e),s(t,ca,e),d(Y,t,e),s(t,da,e),d(L,t,e),s(t,ua,e),s(t,D,e),s(t,ma,e),s(t,P,e),s(t,ha,e),d(O,t,e),s(t,Ma,e),s(t,K,e),s(t,ya,e),d(tt,t,e),s(t,fa,e),s(t,et,e),s(t,Ta,e),s(t,at,e),s(t,ga,e),d(st,t,e),s(t,Ua,e),s(t,nt,e),s(t,wa,e),d(lt,t,e),s(t,ja,e),s(t,ot,e),s(t,ba,e),d(it,t,e),s(t,Ja,e),s(t,rt,e),s(t,_a,e),d(pt,t,e),s(t,ka,e),s(t,ct,e),s(t,Ca,e),d(dt,t,e),s(t,va,e),s(t,ut,e),s(t,Ia,e),d(mt,t,e),s(t,xa,e),s(t,ht,e),s(t,Fa,e),d(Mt,t,e),s(t,$a,e),s(t,yt,e),s(t,Ga,e),d(ft,t,e),s(t,Za,e),s(t,Tt,e),s(t,Ra,e),d(gt,t,e),s(t,Ba,e),s(t,Ut,e),s(t,qa,e),d(wt,t,e),s(t,Xa,e),s(t,jt,e),s(t,Qa,e),d(bt,t,e),s(t,za,e),s(t,Jt,e),s(t,Va,e),d(_t,t,e),s(t,Wa,e),d(kt,t,e),s(t,Ea,e),s(t,Ct,e),s(t,Na,e),d(vt,t,e),s(t,Sa,e),s(t,It,e),s(t,Aa,e),d(xt,t,e),s(t,Ha,e),s(t,Ft,e),s(t,Ya,e),d($t,t,e),s(t,La,e),s(t,Gt,e),s(t,Da,e),d(Zt,t,e),s(t,Pa,e),d(Rt,t,e),s(t,Oa,e),s(t,Bt,e),s(t,Ka,e),d(qt,t,e),s(t,ts,e),s(t,Xt,e),s(t,es,e),d(Qt,t,e),s(t,as,e),s(t,zt,e),s(t,ss,e),d(Vt,t,e),s(t,ns,e),s(t,Wt,e),s(t,ls,e),d(Et,t,e),s(t,os,e),s(t,Nt,e),s(t,is,e),s(t,St,e),s(t,rs,e),s(t,At,e),s(t,ps,e),d(Ht,t,e),s(t,cs,e),s(t,Yt,e),s(t,ds,e),d(Lt,t,e),s(t,us,e),s(t,Dt,e),s(t,ms,e),d(Pt,t,e),s(t,hs,e),s(t,Ot,e),s(t,Ms,e),s(t,Kt,e),s(t,ys,e),d(te,t,e),s(t,fs,e),s(t,ee,e),s(t,Ts,e),s(t,T,e),d(ae,T,null),xe(T,Ks),xe(T,Fe),s(t,gs,e),d(se,t,e),s(t,Us,e),d(ne,t,e),s(t,ws,e),s(t,le,e),s(t,js,e),s(t,oe,e),s(t,bs,e),s(t,w,e),s(t,Js,e),s(t,ie,e),s(t,_s,e),d(re,t,e),s(t,ks,e),s(t,pe,e),s(t,Cs,e),s(t,j,e),s(t,vs,e),s(t,ce,e),s(t,Is,e),d(de,t,e),s(t,xs,e),s(t,ue,e),s(t,Fs,e),s(t,me,e),s(t,$s,e),s(t,he,e),s(t,Gs,e),d(Me,t,e),s(t,Zs,e),s(t,ye,e),s(t,Rs,e),d(fe,t,e),s(t,Bs,e),s(t,Te,e),s(t,qs,e),s(t,ge,e),s(t,Xs,e),d(Ue,t,e),s(t,Qs,e),s(t,we,e),s(t,zs,e),s(t,je,e),s(t,Vs,e),d(be,t,e),s(t,Ws,e),d(Je,t,e),s(t,Es,e),s(t,_e,e),s(t,Ns,e),d(ke,t,e),s(t,Ss,e),s(t,g,e),d(Ce,g,null),xe(g,tn),xe(g,$e),s(t,As,e),d(ve,t,e),s(t,Hs,e),s(t,U,e),d(Ie,U,null),xe(U,en),xe(U,Ge),s(t,Ys,e),s(t,Re,e),Ls=!0},p:Tl,i(t){Ls||(u(b.$$.fragment,t),u(k.$$.fragment,t),u(v.$$.fragment,t),u(F.$$.fragment,t),u(G.$$.fragment,t),u(Z.$$.fragment,t),u(B.$$.fragment,t),u(X.$$.fragment,t),u(z.$$.fragment,t),u(W.$$.fragment,t),u(A.$$.fragment,t),u(Y.$$.fragment,t),u(L.$$.fragment,t),u(O.$$.fragment,t),u(tt.$$.fragment,t),u(st.$$.fragment,t),u(lt.$$.fragment,t),u(it.$$.fragment,t),u(pt.$$.fragment,t),u(dt.$$.fragment,t),u(mt.$$.fragment,t),u(Mt.$$.fragment,t),u(ft.$$.fragment,t),u(gt.$$.fragment,t),u(wt.$$.fragment,t),u(bt.$$.fragment,t),u(_t.$$.fragment,t),u(kt.$$.fragment,t),u(vt.$$.fragment,t),u(xt.$$.fragment,t),u($t.$$.fragment,t),u(Zt.$$.fragment,t),u(Rt.$$.fragment,t),u(qt.$$.fragment,t),u(Qt.$$.fragment,t),u(Vt.$$.fragment,t),u(Et.$$.fragment,t),u(Ht.$$.fragment,t),u(Lt.$$.fragment,t),u(Pt.$$.fragment,t),u(te.$$.fragment,t),u(ae.$$.fragment,t),u(se.$$.fragment,t),u(ne.$$.fragment,t),u(re.$$.fragment,t),u(de.$$.fragment,t),u(Me.$$.fragment,t),u(fe.$$.fragment,t),u(Ue.$$.fragment,t),u(be.$$.fragment,t),u(Je.$$.fragment,t),u(ke.$$.fragment,t),u(Ce.$$.fragment,t),u(ve.$$.fragment,t),u(Ie.$$.fragment,t),Ls=!0)},o(t){m(b.$$.fragment,t),m(k.$$.fragment,t),m(v.$$.fragment,t),m(F.$$.fragment,t),m(G.$$.fragment,t),m(Z.$$.fragment,t),m(B.$$.fragment,t),m(X.$$.fragment,t),m(z.$$.fragment,t),m(W.$$.fragment,t),m(A.$$.fragment,t),m(Y.$$.fragment,t),m(L.$$.fragment,t),m(O.$$.fragment,t),m(tt.$$.fragment,t),m(st.$$.fragment,t),m(lt.$$.fragment,t),m(it.$$.fragment,t),m(pt.$$.fragment,t),m(dt.$$.fragment,t),m(mt.$$.fragment,t),m(Mt.$$.fragment,t),m(ft.$$.fragment,t),m(gt.$$.fragment,t),m(wt.$$.fragment,t),m(bt.$$.fragment,t),m(_t.$$.fragment,t),m(kt.$$.fragment,t),m(vt.$$.fragment,t),m(xt.$$.fragment,t),m($t.$$.fragment,t),m(Zt.$$.fragment,t),m(Rt.$$.fragment,t),m(qt.$$.fragment,t),m(Qt.$$.fragment,t),m(Vt.$$.fragment,t),m(Et.$$.fragment,t),m(Ht.$$.fragment,t),m(Lt.$$.fragment,t),m(Pt.$$.fragment,t),m(te.$$.fragment,t),m(ae.$$.fragment,t),m(se.$$.fragment,t),m(ne.$$.fragment,t),m(re.$$.fragment,t),m(de.$$.fragment,t),m(Me.$$.fragment,t),m(fe.$$.fragment,t),m(Ue.$$.fragment,t),m(be.$$.fragment,t),m(Je.$$.fragment,t),m(ke.$$.fragment,t),m(Ce.$$.fragment,t),m(ve.$$.fragment,t),m(Ie.$$.fragment,t),Ls=!1},d(t){t&&(a(Xe),a(Ze),a(Qe),a(ze),a(J),a(Ve),a(_),a(We),a(Ee),a(C),a(Ne),a(Se),a(I),a(Ae),a(x),a(He),a(Ye),a($),a(Le),a(De),a(Pe),a(R),a(Oe),a(Ke),a(q),a(ta),a(ea),a(Q),a(aa),a(sa),a(V),a(na),a(la),a(E),a(oa),a(N),a(ia),a(S),a(ra),a(pa),a(H),a(ca),a(da),a(ua),a(D),a(ma),a(P),a(ha),a(Ma),a(K),a(ya),a(fa),a(et),a(Ta),a(at),a(ga),a(Ua),a(nt),a(wa),a(ja),a(ot),a(ba),a(Ja),a(rt),a(_a),a(ka),a(ct),a(Ca),a(va),a(ut),a(Ia),a(xa),a(ht),a(Fa),a($a),a(yt),a(Ga),a(Za),a(Tt),a(Ra),a(Ba),a(Ut),a(qa),a(Xa),a(jt),a(Qa),a(za),a(Jt),a(Va),a(Wa),a(Ea),a(Ct),a(Na),a(Sa),a(It),a(Aa),a(Ha),a(Ft),a(Ya),a(La),a(Gt),a(Da),a(Pa),a(Oa),a(Bt),a(Ka),a(ts),a(Xt),a(es),a(as),a(zt),a(ss),a(ns),a(Wt),a(ls),a(os),a(Nt),a(is),a(St),a(rs),a(At),a(ps),a(cs),a(Yt),a(ds),a(us),a(Dt),a(ms),a(hs),a(Ot),a(Ms),a(Kt),a(ys),a(fs),a(ee),a(Ts),a(T),a(gs),a(Us),a(ws),a(le),a(js),a(oe),a(bs),a(w),a(Js),a(ie),a(_s),a(ks),a(pe),a(Cs),a(j),a(vs),a(ce),a(Is),a(xs),a(ue),a(Fs),a(me),a($s),a(he),a(Gs),a(Zs),a(ye),a(Rs),a(Bs),a(Te),a(qs),a(ge),a(Xs),a(Qs),a(we),a(zs),a(je),a(Vs),a(Ws),a(Es),a(_e),a(Ns),a(Ss),a(g),a(As),a(Hs),a(U),a(Ys),a(Re)),a(f),h(b,t),h(k,t),h(v,t),h(F,t),h(G,t),h(Z,t),h(B,t),h(X,t),h(z,t),h(W,t),h(A,t),h(Y,t),h(L,t),h(O,t),h(tt,t),h(st,t),h(lt,t),h(it,t),h(pt,t),h(dt,t),h(mt,t),h(Mt,t),h(ft,t),h(gt,t),h(wt,t),h(bt,t),h(_t,t),h(kt,t),h(vt,t),h(xt,t),h($t,t),h(Zt,t),h(Rt,t),h(qt,t),h(Qt,t),h(Vt,t),h(Et,t),h(Ht,t),h(Lt,t),h(Pt,t),h(te,t),h(ae),h(se,t),h(ne,t),h(re,t),h(de,t),h(Me,t),h(fe,t),h(Ue,t),h(be,t),h(Je,t),h(ke,t),h(Ce),h(ve,t),h(Ie)}}}const Jl='{"title":"Supervised Fine-tuning Trainer","local":"supervised-fine-tuning-trainer","sections":[{"title":"Quickstart","local":"quickstart","sections":[],"depth":2},{"title":"Advanced usage","local":"advanced-usage","sections":[{"title":"Train on completions only","local":"train-on-completions-only","sections":[{"title":"Using token_ids directly for response_template","local":"using-tokenids-directly-for-responsetemplate","sections":[],"depth":4}],"depth":3},{"title":"Add Special Tokens for Chat Format","local":"add-special-tokens-for-chat-format","sections":[],"depth":3},{"title":"Dataset format support","local":"dataset-format-support","sections":[],"depth":3},{"title":"Format your input prompts","local":"format-your-input-prompts","sections":[],"depth":3},{"title":"Packing dataset ( ConstantLengthDataset )","local":"packing-dataset--constantlengthdataset-","sections":[{"title":"Customize your prompts using packed dataset","local":"customize-your-prompts-using-packed-dataset","sections":[],"depth":4}],"depth":3},{"title":"Control over the pretrained model","local":"control-over-the-pretrained-model","sections":[],"depth":3},{"title":"Training adapters","local":"training-adapters","sections":[],"depth":3},{"title":"Training adapters with base 8 bit models","local":"training-adapters-with-base-8-bit-models","sections":[],"depth":3}],"depth":2},{"title":"Using Flash Attention and Flash Attention 2","local":"using-flash-attention-and-flash-attention-2","sections":[{"title":"Using Flash-Attention 1","local":"using-flash-attention-1","sections":[],"depth":3},{"title":"Using Flash Attention-2","local":"using-flash-attention-2","sections":[],"depth":3},{"title":"Using model creation utility","local":"trl.ModelConfig","sections":[],"depth":3},{"title":"Enhance model’s performances using NEFTune","local":"enhance-models-performances-using-neftune","sections":[],"depth":3},{"title":"Accelerate fine-tuning 2x using unsloth","local":"accelerate-fine-tuning-2x-using-unsloth","sections":[],"depth":3}],"depth":2},{"title":"Best practices","local":"best-practices","sections":[],"depth":2},{"title":"Multi-GPU Training","local":"multi-gpu-training","sections":[],"depth":2},{"title":"GPTQ Conversion","local":"gptq-conversion","sections":[],"depth":2},{"title":"SFTTrainer","local":"trl.SFTTrainer","sections":[],"depth":2},{"title":"ConstantLengthDataset","local":"trl.trainer.ConstantLengthDataset","sections":[],"depth":2}],"depth":1}';function _l(sn){return gl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Fl extends Ul{constructor(f){super(),wl(this,f,_l,bl,fl,{})}}export{Fl as component};
