import{s as ft,n as Tt,o as gt}from"../chunks/scheduler.9039eef2.js";import{S as Jt,i as Ut,g as i,s as a,r as p,A as bt,h as o,f as l,c as s,j as Mt,u as d,x as r,k as yt,y as jt,a as n,v as c,d as m,t as h,w as u}from"../chunks/index.ded8f90d.js";import{C as O}from"../chunks/CodeBlock.8580f3e8.js";import{H as le}from"../chunks/Heading.f027f30d.js";function Ct(Qe){let w,ne,ee,ae,M,se,y,Fe='We’ve begun rolling out examples to use Meta’s LLaMA models in <code>trl</code> (see <a href="https://ai.facebook.com/blog/large-language-model-llama-meta-ai/" rel="nofollow">Meta’s LLaMA release</a> for the original LLaMA model).',ie,f,oe,T,Ne='Even training the smallest LLaMA model requires an enormous amount of memory. Some quick math: in bf16, every parameter uses 2 bytes (in fp32 4 bytes) in addition to 8 bytes used, e.g., in the Adam optimizer (see the <a href="https://huggingface.co/docs/transformers/perf_train_gpu_one#optimizer" rel="nofollow">performance docs</a> in Transformers for more info). So a 7B parameter model would use <code>(2+8)*7B=70GB</code> just to fit in memory and would likely need more when you compute intermediate values such as attention scores. So you couldn’t train the model even on a single 80GB A100 like that. You can use some tricks, like more efficient optimizers of half-precision training, to squeeze a bit more into memory, but you’ll run out sooner or later.',re,g,Se=`Another option is to use Parameter-Efficient Fine-Tuning (PEFT) techniques, such as the <a href="https://github.com/huggingface/peft" rel="nofollow"><code>peft</code></a> library, which can perform low-rank adaptation (LoRA) on a model loaded in 8-bit.
For more on <code>peft</code> + <code>trl</code>, see the <a href="https://huggingface.co/docs/trl/sentiment_tuning_peft" rel="nofollow">docs</a>.`,pe,J,Ee=`Loading the model in 8bit reduces the memory footprint drastically since you only need one byte per parameter for the weights (e.g. 7B LlaMa is 7GB in memory).
Instead of training the original weights directly, LoRA adds small adapter layers on top of some specific layers (usually the attention layers); thus, the number of trainable parameters is drastically reduced.`,de,U,Ye=`In this scenario, a rule of thumb is to allocate ~1.2-1.4GB per billion parameters (depending on the batch size and sequence length) to fit the entire fine-tuning setup.
This enables fine-tuning larger models (up to 50-60B scale models on a NVIDIA A100 80GB) at low cost.`,ce,b,qe=`Now we can fit very large models into a single GPU, but the training might still be very slow.
The simplest strategy in this scenario is data parallelism: we replicate the same training setup into separate GPUs and pass different batches to each GPU.
With this, you can parallelize the forward/backward passes of the model and scale with the number of GPUs.`,me,j,Pe='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/blog/stackllama/chapter10_ddp.png" alt="chapter10_ddp.png"/>',he,C,Ke="We use either the <code>transformers.Trainer</code> or <code>accelerate</code>, which both support data parallelism without any code changes, by simply passing arguments when calling the scripts with <code>torchrun</code> or <code>accelerate launch</code>. The following runs a training script with 8 GPUs on a single machine with <code>accelerate</code> and <code>torchrun</code>, respectively.",ue,I,we,_,Me,v,De=`Before we start training reward models and tuning our model with RL, it helps if the model is already good in the domain we are interested in.
In our case, we want it to answer questions, while for other use cases, we might want it to follow instructions, in which case instruction tuning is a great idea.
The easiest way to achieve this is by continuing to train the language model with the language modeling objective on texts from the domain or task.
The <a href="https://huggingface.co/datasets/HuggingFaceH4/stack-exchange-preferences" rel="nofollow">StackExchange dataset</a> is enormous (over 10 million instructions), so we can easily train the language model on a subset of it.`,ye,k,Oe=`There is nothing special about fine-tuning the model before doing RLHF - it’s just the causal language modeling objective from pretraining that we apply here.
To use the data efficiently, we use a technique called packing: instead of having one text per sample in the batch and then padding to either the longest text or the maximal context of the model, we concatenate a lot of texts with a EOS token in between and cut chunks of the context size to fill the batch without any padding.`,fe,R,et='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/blog/stackllama/chapter10_preprocessing-clm.png" alt="chapter10_preprocessing-clm.png"/>',Te,B,tt=`With this approach the training is much more efficient as each token that is passed through the model is also trained in contrast to padding tokens which are usually masked from the loss.
If you don’t have much data and are more concerned about occasionally cutting off some tokens that are overflowing the context you can also use a classical data loader.`,ge,x,lt="The packing is handled by the <code>ConstantLengthDataset</code> and we can then use the <code>Trainer</code> after loading the model with <code>peft</code>. First, we load the model in int8, prepare it for training, and then add the LoRA adapters.",Je,H,Ue,A,nt=`We train the model for a few thousand steps with the causal language modeling objective and save the model.
Since we will tune the model again with different objectives, we merge the adapter weights with the original model weights.`,be,G,at=`<strong>Disclaimer:</strong> due to LLaMA’s license, we release only the adapter weights for this and the model checkpoints in the following sections.
You can apply for access to the base model’s weights by filling out Meta AI’s <a href="https://docs.google.com/forms/d/e/1FAIpQLSfqNECQnMkycAp2jP4Z9TFX0cGR4uf7b_fBxjY_OjhJILlKGA/viewform" rel="nofollow">form</a> and then converting them to the 🤗 Transformers format by running this <a href="https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama/convert_llama_weights_to_hf.py" rel="nofollow">script</a>.
Note that you’ll also need to install 🤗 Transformers from source until the <code>v4.28</code> is released.`,je,L,st="Now that we have fine-tuned the model for the task, we are ready to train a reward model.",Ce,Z,Ie,$,it=`In principle, we could fine-tune the model using RLHF directly with the human annotations.
However, this would require us to send some samples to humans for rating after each optimization iteration.
This is expensive and slow due to the number of training samples needed for convergence and the inherent latency of human reading and annotator speed.`,_e,V,ot=`A trick that works well instead of direct feedback is training a reward model on human annotations collected before the RL loop.
The goal of the reward model is to imitate how a human would rate a text. There are several possible strategies to build a reward model: the most straightforward way would be to predict the annotation (e.g. a rating score or a binary value for “good”/”bad”).
In practice, what works better is to predict the ranking of two examples, where the reward model is presented with two candidates <code>(y_k, y_j)</code> for a given prompt <code>x</code> and has to predict which one would be rated higher by a human annotator.`,ve,X,rt=`With the StackExchange dataset, we can infer which of the two answers was preferred by the users based on the score.
With that information and the loss defined above, we can then modify the <code>transformers.Trainer</code> by adding a custom loss function.`,ke,z,Re,W,pt="We utilize a subset of a 100,000 pair of candidates and evaluate on a held-out set of 50,000. With a modest training batch size of 4, we train the Llama model using the LoRA <code>peft</code> adapter for a single epoch using the Adam optimizer with BF16 precision. Our LoRA configuration is:",Be,Q,xe,F,dt="As detailed in the next section, the resulting adapter can be merged into the frozen model and saved for further downstream use.",He,N,Ae,S,ct="With the fine-tuned language model and the reward model at hand, we are now ready to run the RL loop. It follows roughly three steps:",Ge,E,mt="<li>Generate responses from prompts,</li> <li>Rate the responses with the reward model,</li> <li>Run a reinforcement learning policy-optimization step with the ratings.</li>",Le,Y,ht="The Query and Response prompts are templated as follows before being tokenized and passed to the model:",Ze,q,$e,P,ut=`The same template was used for SFT, RM and RLHF stages.
Once more, we utilize <code>peft</code> for memory-efficient training, which offers an extra advantage in the RLHF context.
Here, the reference model and policy share the same base, the SFT model, which we load in 8-bit and freeze during training.
We exclusively optimize the policy’s LoRA weights using PPO while sharing the base model’s weights.`,Ve,K,Xe,D,wt='For the rest of the details and evaluation, please refer to our <a href="https://huggingface.co/blog/stackllama" rel="nofollow">blog post on StackLLaMA</a>.',ze,te,We;return M=new le({props:{title:"Using LLaMA models with TRL",local:"using-llama-models-with-trl",headingTag:"h1"}}),f=new le({props:{title:"Efficient training strategies",local:"efficient-training-strategies",headingTag:"h2"}}),I=new O({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMC0tbXVsdGlfZ3B1JTIwLS1udW1fbWFjaGluZXMlMjAxJTIwJTIwLS1udW1fcHJvY2Vzc2VzJTIwOCUyMG15X2FjY2VsZXJhdGVfc2NyaXB0LnB5JTBBdG9yY2hydW4lMjAtLW5ub2RlcyUyMDElMjAlMjAtLW5wcm9jX3Blcl9ub2RlJTIwOCUyMG15X3RvcmNoX3NjcmlwdC5weQ==",highlighted:`accelerate launch --multi_gpu --num_machines 1  --num_processes 8 my_accelerate_script.py
torchrun --nnodes 1  --nproc_per_node 8 my_torch_script.py`,wrap:!1}}),_=new le({props:{title:"Supervised fine-tuning",local:"supervised-fine-tuning",headingTag:"h2"}}),H=new O({props:{code:"JTIzJTIwbG9hZCUyMG1vZGVsJTIwaW4lMjA4Yml0JTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXJncy5tb2RlbF9wYXRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9hZF9pbl84Yml0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlN0IlMjIlMjIlM0ElMjBBY2NlbGVyYXRvcigpLmxvY2FsX3Byb2Nlc3NfaW5kZXglN0QlMEElMjAlMjAlMjAlMjApJTBBbW9kZWwlMjAlM0QlMjBwcmVwYXJlX21vZGVsX2Zvcl9rYml0X3RyYWluaW5nKG1vZGVsKSUwQSUwQSUyMyUyMGFkZCUyMExvUkElMjB0byUyMG1vZGVsJTBBbG9yYV9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHIlM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfYWxwaGElM0QzMiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfZHJvcG91dCUzRDAuMDUlMkMlMEElMjAlMjAlMjAlMjBiaWFzJTNEJTIybm9uZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRhc2tfdHlwZSUzRCUyMkNBVVNBTF9MTSUyMiUyQyUwQSklMEElMEFtb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKG1vZGVsJTJDJTIwY29uZmlnKQ==",highlighted:`<span class="hljs-comment"># load model in 8bit</span>
model = AutoModelForCausalLM.from_pretrained(
        args.model_path,
        load_in_8bit=<span class="hljs-literal">True</span>,
        device_map={<span class="hljs-string">&quot;&quot;</span>: Accelerator().local_process_index}
    )
model = prepare_model_for_kbit_training(model)

<span class="hljs-comment"># add LoRA to model</span>
lora_config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)

model = get_peft_model(model, config)`,wrap:!1}}),Z=new le({props:{title:"Reward modeling and human preferences",local:"reward-modeling-and-human-preferences",headingTag:"h2"}}),z=new O({props:{code:"Y2xhc3MlMjBSZXdhcmRUcmFpbmVyKFRyYWluZXIpJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwY29tcHV0ZV9sb3NzKHNlbGYlMkMlMjBtb2RlbCUyQyUyMGlucHV0cyUyQyUyMHJldHVybl9vdXRwdXRzJTNERmFsc2UpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV3YXJkc19qJTIwJTNEJTIwbW9kZWwoaW5wdXRfaWRzJTNEaW5wdXRzJTVCJTIyaW5wdXRfaWRzX2olMjIlNUQlMkMlMjAlMjBhdHRlbnRpb25fbWFzayUzRGlucHV0cyU1QiUyMmF0dGVudGlvbl9tYXNrX2olMjIlNUQpJTVCMCU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJld2FyZHNfayUyMCUzRCUyMG1vZGVsKGlucHV0X2lkcyUzRGlucHV0cyU1QiUyMmlucHV0X2lkc19rJTIyJTVEJTJDJTIwYXR0ZW50aW9uX21hc2slM0RpbnB1dHMlNUIlMjJhdHRlbnRpb25fbWFza19rJTIyJTVEKSU1QjAlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwLW5uLmZ1bmN0aW9uYWwubG9nc2lnbW9pZChyZXdhcmRzX2olMjAtJTIwcmV3YXJkc19rKS5tZWFuKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMHJldHVybl9vdXRwdXRzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwbG9zcyUyQyUyMCU3QiUyMnJld2FyZHNfaiUyMiUzQSUyMHJld2FyZHNfaiUyQyUyMCUyMnJld2FyZHNfayUyMiUzQSUyMHJld2FyZHNfayU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGxvc3M=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">RewardTrainer</span>(<span class="hljs-title class_ inherited__">Trainer</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_loss</span>(<span class="hljs-params">self, model, inputs, return_outputs=<span class="hljs-literal">False</span></span>):
        rewards_j = model(input_ids=inputs[<span class="hljs-string">&quot;input_ids_j&quot;</span>],  attention_mask=inputs[<span class="hljs-string">&quot;attention_mask_j&quot;</span>])[<span class="hljs-number">0</span>]
        rewards_k = model(input_ids=inputs[<span class="hljs-string">&quot;input_ids_k&quot;</span>], attention_mask=inputs[<span class="hljs-string">&quot;attention_mask_k&quot;</span>])[<span class="hljs-number">0</span>]
        loss = -nn.functional.logsigmoid(rewards_j - rewards_k).mean()
        <span class="hljs-keyword">if</span> return_outputs:
            <span class="hljs-keyword">return</span> loss, {<span class="hljs-string">&quot;rewards_j&quot;</span>: rewards_j, <span class="hljs-string">&quot;rewards_k&quot;</span>: rewards_k}
        <span class="hljs-keyword">return</span> loss`,wrap:!1}}),Q=new O({props:{code:"cGVmdF9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHRhc2tfdHlwZSUzRFRhc2tUeXBlLlNFUV9DTFMlMkMlMEElMjAlMjAlMjAlMjBpbmZlcmVuY2VfbW9kZSUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwciUzRDglMkMlMEElMjAlMjAlMjAlMjBsb3JhX2FscGhhJTNEMzIlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2Ryb3BvdXQlM0QwLjElMkMlMEEp",highlighted:`peft_config = LoraConfig(
    task_type=TaskType.SEQ_CLS,
    inference_mode=<span class="hljs-literal">False</span>,
    r=<span class="hljs-number">8</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lora_dropout=<span class="hljs-number">0.1</span>,
)`,wrap:!1}}),N=new le({props:{title:"Reinforcement Learning from Human Feedback",local:"reinforcement-learning-from-human-feedback",headingTag:"h2"}}),q=new O({props:{code:"UXVlc3Rpb24lM0ElMjAlM0NRdWVyeSUzRSUwQSUwQUFuc3dlciUzQSUyMCUzQ1Jlc3BvbnNlJTNF",highlighted:`Question: &lt;Query&gt;

Answer: &lt;Response&gt;`,wrap:!1}}),K=new O({props:{code:"Zm9yJTIwZXBvY2glMkMlMjBiYXRjaCUyMGluJTIwdHFkbShlbnVtZXJhdGUocHBvX3RyYWluZXIuZGF0YWxvYWRlcikpJTNBJTBBJTIwJTIwJTIwJTIwcXVlc3Rpb25fdGVuc29ycyUyMCUzRCUyMGJhdGNoJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTBBJTBBJTA5JTIzJTIwc2FtcGxlJTIwZnJvbSUyMHRoZSUyMHBvbGljeSUyMGFuZCUyMHRvJTIwZ2VuZXJhdGUlMjByZXNwb25zZXMlMEElMjAlMjAlMjAlMjByZXNwb25zZV90ZW5zb3JzJTIwJTNEJTIwcHBvX3RyYWluZXIuZ2VuZXJhdGUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcXVlc3Rpb25fdGVuc29ycyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybl9wcm9tcHQlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxlbmd0aF9zYW1wbGVyJTNEb3V0cHV0X2xlbmd0aF9zYW1wbGVyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKipnZW5lcmF0aW9uX2t3YXJncyUyQyUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjBiYXRjaCU1QiUyMnJlc3BvbnNlJTIyJTVEJTIwJTNEJTIwdG9rZW5pemVyLmJhdGNoX2RlY29kZShyZXNwb25zZV90ZW5zb3JzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwQ29tcHV0ZSUyMHNlbnRpbWVudCUyMHNjb3JlJTBBJTIwJTIwJTIwJTIwdGV4dHMlMjAlM0QlMjAlNUJxJTIwJTJCJTIwciUyMGZvciUyMHElMkMlMjByJTIwaW4lMjB6aXAoYmF0Y2glNUIlMjJxdWVyeSUyMiU1RCUyQyUyMGJhdGNoJTVCJTIycmVzcG9uc2UlMjIlNUQpJTVEJTBBJTIwJTIwJTIwJTIwcGlwZV9vdXRwdXRzJTIwJTNEJTIwc2VudGltZW50X3BpcGUodGV4dHMlMkMlMjAqKnNlbnRfa3dhcmdzKSUwQSUyMCUyMCUyMCUyMHJld2FyZHMlMjAlM0QlMjAlNUJ0b3JjaC50ZW5zb3Iob3V0cHV0JTVCMCU1RCU1QiUyMnNjb3JlJTIyJTVEJTIwLSUyMHNjcmlwdF9hcmdzLnJld2FyZF9iYXNlbGluZSklMjBmb3IlMjBvdXRwdXQlMjBpbiUyMHBpcGVfb3V0cHV0cyU1RCUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFJ1biUyMFBQTyUyMHN0ZXAlMEElMjAlMjAlMjAlMjBzdGF0cyUyMCUzRCUyMHBwb190cmFpbmVyLnN0ZXAocXVlc3Rpb25fdGVuc29ycyUyQyUyMHJlc3BvbnNlX3RlbnNvcnMlMkMlMjByZXdhcmRzKSUwQSUwOSUyMyUyMExvZyUyMHN0YXRzJTIwdG8lMjBXYW5kYiUwQSUyMCUyMCUyMCUyMHBwb190cmFpbmVyLmxvZ19zdGF0cyhzdGF0cyUyQyUyMGJhdGNoJTJDJTIwcmV3YXJkcyk=",highlighted:`<span class="hljs-keyword">for</span> epoch, batch <span class="hljs-keyword">in</span> tqdm(<span class="hljs-built_in">enumerate</span>(ppo_trainer.dataloader)):
    question_tensors = batch[<span class="hljs-string">&quot;input_ids&quot;</span>]

	<span class="hljs-comment"># sample from the policy and to generate responses</span>
    response_tensors = ppo_trainer.generate(
        question_tensors,
        return_prompt=<span class="hljs-literal">False</span>,
        length_sampler=output_length_sampler,
        **generation_kwargs,
    )
    batch[<span class="hljs-string">&quot;response&quot;</span>] = tokenizer.batch_decode(response_tensors, skip_special_tokens=<span class="hljs-literal">True</span>)

    <span class="hljs-comment"># Compute sentiment score</span>
    texts = [q + r <span class="hljs-keyword">for</span> q, r <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(batch[<span class="hljs-string">&quot;query&quot;</span>], batch[<span class="hljs-string">&quot;response&quot;</span>])]
    pipe_outputs = sentiment_pipe(texts, **sent_kwargs)
    rewards = [torch.tensor(output[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;score&quot;</span>] - script_args.reward_baseline) <span class="hljs-keyword">for</span> output <span class="hljs-keyword">in</span> pipe_outputs]

    <span class="hljs-comment"># Run PPO step</span>
    stats = ppo_trainer.step(question_tensors, response_tensors, rewards)
	<span class="hljs-comment"># Log stats to Wandb</span>
    ppo_trainer.log_stats(stats, batch, rewards)`,wrap:!1}}),{c(){w=i("meta"),ne=a(),ee=i("p"),ae=a(),p(M.$$.fragment),se=a(),y=i("p"),y.innerHTML=Fe,ie=a(),p(f.$$.fragment),oe=a(),T=i("p"),T.innerHTML=Ne,re=a(),g=i("p"),g.innerHTML=Se,pe=a(),J=i("p"),J.textContent=Ee,de=a(),U=i("p"),U.textContent=Ye,ce=a(),b=i("p"),b.textContent=qe,me=a(),j=i("p"),j.innerHTML=Pe,he=a(),C=i("p"),C.innerHTML=Ke,ue=a(),p(I.$$.fragment),we=a(),p(_.$$.fragment),Me=a(),v=i("p"),v.innerHTML=De,ye=a(),k=i("p"),k.textContent=Oe,fe=a(),R=i("p"),R.innerHTML=et,Te=a(),B=i("p"),B.textContent=tt,ge=a(),x=i("p"),x.innerHTML=lt,Je=a(),p(H.$$.fragment),Ue=a(),A=i("p"),A.textContent=nt,be=a(),G=i("p"),G.innerHTML=at,je=a(),L=i("p"),L.textContent=st,Ce=a(),p(Z.$$.fragment),Ie=a(),$=i("p"),$.textContent=it,_e=a(),V=i("p"),V.innerHTML=ot,ve=a(),X=i("p"),X.innerHTML=rt,ke=a(),p(z.$$.fragment),Re=a(),W=i("p"),W.innerHTML=pt,Be=a(),p(Q.$$.fragment),xe=a(),F=i("p"),F.textContent=dt,He=a(),p(N.$$.fragment),Ae=a(),S=i("p"),S.textContent=ct,Ge=a(),E=i("ol"),E.innerHTML=mt,Le=a(),Y=i("p"),Y.textContent=ht,Ze=a(),p(q.$$.fragment),$e=a(),P=i("p"),P.innerHTML=ut,Ve=a(),p(K.$$.fragment),Xe=a(),D=i("p"),D.innerHTML=wt,ze=a(),te=i("p"),this.h()},l(e){const t=bt("svelte-u9bgzb",document.head);w=o(t,"META",{name:!0,content:!0}),t.forEach(l),ne=s(e),ee=o(e,"P",{}),Mt(ee).forEach(l),ae=s(e),d(M.$$.fragment,e),se=s(e),y=o(e,"P",{"data-svelte-h":!0}),r(y)!=="svelte-e13aq4"&&(y.innerHTML=Fe),ie=s(e),d(f.$$.fragment,e),oe=s(e),T=o(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-16n3a3d"&&(T.innerHTML=Ne),re=s(e),g=o(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-15jce6t"&&(g.innerHTML=Se),pe=s(e),J=o(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-13fiyhv"&&(J.textContent=Ee),de=s(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-14acoww"&&(U.textContent=Ye),ce=s(e),b=o(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-4ezqnt"&&(b.textContent=qe),me=s(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-n90oj8"&&(j.innerHTML=Pe),he=s(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-iudduc"&&(C.innerHTML=Ke),ue=s(e),d(I.$$.fragment,e),we=s(e),d(_.$$.fragment,e),Me=s(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-lj6rat"&&(v.innerHTML=De),ye=s(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-qefjfd"&&(k.textContent=Oe),fe=s(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-gam3e8"&&(R.innerHTML=et),Te=s(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1gv8jsw"&&(B.textContent=tt),ge=s(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1dk2p5m"&&(x.innerHTML=lt),Je=s(e),d(H.$$.fragment,e),Ue=s(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-n2utf9"&&(A.textContent=nt),be=s(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1rx67l9"&&(G.innerHTML=at),je=s(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-exsorg"&&(L.textContent=st),Ce=s(e),d(Z.$$.fragment,e),Ie=s(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-yra23x"&&($.textContent=it),_e=s(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-14koobd"&&(V.innerHTML=ot),ve=s(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-15d99ek"&&(X.innerHTML=rt),ke=s(e),d(z.$$.fragment,e),Re=s(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-14vojqw"&&(W.innerHTML=pt),Be=s(e),d(Q.$$.fragment,e),xe=s(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-103ifl4"&&(F.textContent=dt),He=s(e),d(N.$$.fragment,e),Ae=s(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1hyr34n"&&(S.textContent=ct),Ge=s(e),E=o(e,"OL",{"data-svelte-h":!0}),r(E)!=="svelte-oi045r"&&(E.innerHTML=mt),Le=s(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-ffg2nl"&&(Y.textContent=ht),Ze=s(e),d(q.$$.fragment,e),$e=s(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-unvala"&&(P.innerHTML=ut),Ve=s(e),d(K.$$.fragment,e),Xe=s(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-hi9qdh"&&(D.innerHTML=wt),ze=s(e),te=o(e,"P",{}),Mt(te).forEach(l),this.h()},h(){yt(w,"name","hf:doc:metadata"),yt(w,"content",It)},m(e,t){jt(document.head,w),n(e,ne,t),n(e,ee,t),n(e,ae,t),c(M,e,t),n(e,se,t),n(e,y,t),n(e,ie,t),c(f,e,t),n(e,oe,t),n(e,T,t),n(e,re,t),n(e,g,t),n(e,pe,t),n(e,J,t),n(e,de,t),n(e,U,t),n(e,ce,t),n(e,b,t),n(e,me,t),n(e,j,t),n(e,he,t),n(e,C,t),n(e,ue,t),c(I,e,t),n(e,we,t),c(_,e,t),n(e,Me,t),n(e,v,t),n(e,ye,t),n(e,k,t),n(e,fe,t),n(e,R,t),n(e,Te,t),n(e,B,t),n(e,ge,t),n(e,x,t),n(e,Je,t),c(H,e,t),n(e,Ue,t),n(e,A,t),n(e,be,t),n(e,G,t),n(e,je,t),n(e,L,t),n(e,Ce,t),c(Z,e,t),n(e,Ie,t),n(e,$,t),n(e,_e,t),n(e,V,t),n(e,ve,t),n(e,X,t),n(e,ke,t),c(z,e,t),n(e,Re,t),n(e,W,t),n(e,Be,t),c(Q,e,t),n(e,xe,t),n(e,F,t),n(e,He,t),c(N,e,t),n(e,Ae,t),n(e,S,t),n(e,Ge,t),n(e,E,t),n(e,Le,t),n(e,Y,t),n(e,Ze,t),c(q,e,t),n(e,$e,t),n(e,P,t),n(e,Ve,t),c(K,e,t),n(e,Xe,t),n(e,D,t),n(e,ze,t),n(e,te,t),We=!0},p:Tt,i(e){We||(m(M.$$.fragment,e),m(f.$$.fragment,e),m(I.$$.fragment,e),m(_.$$.fragment,e),m(H.$$.fragment,e),m(Z.$$.fragment,e),m(z.$$.fragment,e),m(Q.$$.fragment,e),m(N.$$.fragment,e),m(q.$$.fragment,e),m(K.$$.fragment,e),We=!0)},o(e){h(M.$$.fragment,e),h(f.$$.fragment,e),h(I.$$.fragment,e),h(_.$$.fragment,e),h(H.$$.fragment,e),h(Z.$$.fragment,e),h(z.$$.fragment,e),h(Q.$$.fragment,e),h(N.$$.fragment,e),h(q.$$.fragment,e),h(K.$$.fragment,e),We=!1},d(e){e&&(l(ne),l(ee),l(ae),l(se),l(y),l(ie),l(oe),l(T),l(re),l(g),l(pe),l(J),l(de),l(U),l(ce),l(b),l(me),l(j),l(he),l(C),l(ue),l(we),l(Me),l(v),l(ye),l(k),l(fe),l(R),l(Te),l(B),l(ge),l(x),l(Je),l(Ue),l(A),l(be),l(G),l(je),l(L),l(Ce),l(Ie),l($),l(_e),l(V),l(ve),l(X),l(ke),l(Re),l(W),l(Be),l(xe),l(F),l(He),l(Ae),l(S),l(Ge),l(E),l(Le),l(Y),l(Ze),l($e),l(P),l(Ve),l(Xe),l(D),l(ze),l(te)),l(w),u(M,e),u(f,e),u(I,e),u(_,e),u(H,e),u(Z,e),u(z,e),u(Q,e),u(N,e),u(q,e),u(K,e)}}}const It='{"title":"Using LLaMA models with TRL","local":"using-llama-models-with-trl","sections":[{"title":"Efficient training strategies","local":"efficient-training-strategies","sections":[],"depth":2},{"title":"Supervised fine-tuning","local":"supervised-fine-tuning","sections":[],"depth":2},{"title":"Reward modeling and human preferences","local":"reward-modeling-and-human-preferences","sections":[],"depth":2},{"title":"Reinforcement Learning from Human Feedback","local":"reinforcement-learning-from-human-feedback","sections":[],"depth":2}],"depth":1}';function _t(Qe){return gt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class xt extends Jt{constructor(w){super(),Ut(this,w,_t,Ct,ft,{})}}export{xt as component};
