import{s as $a,o as Ia,n as za}from"../chunks/scheduler.37c15a92.js";import{S as Va,i as _a,g as o,s as t,r as p,A as Aa,h as r,f as a,c as l,j as Qa,u as m,x as i,k as ka,y as Ba,a as n,v as c,d as u,t as d,w as M}from"../chunks/index.2bf4358c.js";import{T as qa}from"../chunks/Tip.363c041f.js";import{Y as Za}from"../chunks/Youtube.1e50a667.js";import{C as J}from"../chunks/CodeBlock.4f5fc1ad.js";import{C as Xa}from"../chunks/CourseFloatingBanner.15ba07e6.js";import{H as Ye}from"../chunks/Heading.8ada512a.js";function Na(Vs){let y,x="⚠️ Treinar um tokenizador não é o mesmo que treinar um modelo! O treinamento de um modelo usa o gradiente descendente estocástico para fazer a perda um pouquinho menor a cada batch. Portanto, é aleatório por natureza (o que significa que você deve definir seeds para obter o mesmo resultado quando estiver fazendo o mesmo treino novamente). Treinar um tokenizador é um processo estatístico que tenta identificar que subpalavras são as melhores para escolher dependendo do algoritmo de tokenização. Portanto, este processo é determinístico, o que significa que você terá sempre o mesmo resultado quando for treinar com o mesmo algoritmo no mesmo corpus.";return{c(){y=o("p"),y.textContent=x},l(j){y=r(j,"P",{"data-svelte-h":!0}),i(y)!=="svelte-1psy6ua"&&(y.textContent=x)},m(j,Is){n(j,y,Is)},p:za,d(j){j&&a(y)}}}function Ga(Vs){let y,x,j,Is,h,_s,U,As,g,Se='Se um modelo de linguagem não estiver disponível no idioma que você estiver interessado, ou se o seu corpus for muito diferente do que o seu modelo de linguagem foi treinado, você muito provavelmente desejará retreinar o modelo do zero usando um tokenizador adaptado para seus dados. Isto exigirá um treinamento de um novo tokenizador para seu conjunto de dados. Mas o que isso exatamente significa? Quando observamos os tokenizadores pela primeira vez no <a href="/course/chapter2">Capítulo 2</a>, nós vimos que a maioria dos modelos Transformer usa um algoritmo de tokenização de subpalavras. Para identificar quais subpalavras são de interesse e que ocorrem mais frequentemente no corpus em questão, o tokenizador precisa dar uma boa olhada em todos os textos no corpus — processo que chamamos de <em>treinamento</em>. As regras exatas que governam o treinamento dependem do tipo de tokenizador usado, e veremos os três algoritmos principais mais adiante neste capítulo.',Bs,f,qs,T,Zs,w,Xs,b,Pe="Existe uma API muito simples em 🤗 Transformers que você pode usar para treinar um novo tokenizador com as mesmas características de um já existente: <code>AutoTokenizer.train_new_from_iterator()</code>. Para ver isso em ação, vamos supor que queremos treinar o GPT-2 do zero, mas em um idioma diferente do inglês. Nossa primeira tarefa será obter muitos dados de um idioma em um corpus de treinamento. Para prover exemplos que todo mundo será capaz de entender, não usaremos um idioma como russo ou chinês aqui, mas sim in idiome inglês especializado: código Python.",Ns,C,Fe='A biblioteca <a href="https://github.com/huggingface/datasets" rel="nofollow">🤗 Datasets</a> pode nos ajudar a montar um corpus de códigos em Python. Nós usaremos a função usual <code>load_dataset()</code> para baixar e armazenar em cache o dataset <a href="https://huggingface.co/datasets/code_search_net" rel="nofollow">CodeSearchNet</a>. Este dataset foi criado para o <a href="https://wandb.ai/github/CodeSearchNet/benchmark" rel="nofollow">CodeSearchNet challenge</a> e contém milhões de funções de bibliotecas de código aberto no GitHub em diferentes linguagens de programação. Aqui, nós iremos carregar a parte Python deste dataset:',Gs,v,Es,Q,Le="Podemos dar uma olhada na divisão de treinamento para ver a quais colunas temos acesso:",Ws,k,Ds,$,Hs,I,Ke="Podemos ver que o conjunto de dados separa as docstrings do código e sugere uma tokenização de ambos. Aqui, usaremos apenas a coluna <code>whole_func_string</code> para treinar o nosso tokenizador. Podemos observar um exemplo de uma dessas funções indexando na divisão <code>train</code>:",Rs,z,Ys,V,Oe="Que deve resultar na seguinte saída:",Ss,_,Ps,A,sa="A primeira coisa que precisamos fazer é transformar o dataset em um iterador) de listas de textos — por exemplo, uma lista de lista de textos. Usando lista de textos irá habilitar o nosso tokenizador para funcionar mais rapidamente (treinando em lotes de textos ao invés de processar individualmente os textos, um por vez), e deve ser um iterador se quisermos evitar ter tudo na memória de uma vez. Se o teu corpus for grande, você vai querer aproveitar o fato de que 🤗 Datasets não carrega tudo na memória RAM, mas armazena os elementos do dataset no disco.",Fs,B,ea="Executar o trecho abaixo criaria uma lista de listas de 1000 textos cada, mas carregaria tudo na memória:",Ls,q,Ks,Z,aa="Usando um Python generator, nós podemos evitar que o Python carregue tudo na memória até que realmente seja necessário. Para criar tal generator, você precisa apenas substituir os colchetes por parênteses:",Os,X,se,N,na="Esta linha de código não busca nenhum elemento no dataset; ele apenas cria um objeto que você pode usar em um o loop <code>for</code> do Python. Os textos só serão carregados quando você precisar deles (ou seja, quando você estiver na etapa do loop <code>for</code> que os requer), e apenas 1000 textos por vez serão carregados. Desse modo, você não esgotará toda a sua memória, mesmo se você estiver processando um grande dataset.",ee,G,ta="O problema com um objeto gerador é que ele só pode ser usado uma vez. Então, em vez de nos dar a lista dos primeiros 10 dígitos duas vezes:",ae,E,ne,W,la="nós obtemos uma vez e, em seguida, uma lista vazia:",te,D,le,H,oa="É por isso que definomos uma função que retorna um gerador:",oe,R,re,Y,ra="Você também pode definir o seu gerador dentro de um loop <code>for</code> ao usar o comando <code>yield</code>:",ie,S,pe,P,ia="que irá produzir exatamente o mesmo gerador de antes, mas permite que você use uma lógica mais complexa do que você pode em um list comprehension.",me,F,ce,L,pa="Agora que nós temos o nosso corpus na forma de um iterador de lotes de texto, estamos prontos para treinar um novo tokenizador. Para fazer isso, primeiramente nós precisamos carregar o tokenizador que queremos emparelhar com o nosso modelo (neste caso, GPT-2):",ue,K,de,O,ma="Por mais que iremos treinar um novo tokenizador, é uma boa ideia fazer isso para evitar começar do zero. Dessa forma, não precisaremos especificar nada sobre o algoritmo de tokenização ou tokens especiais que queremos usar; nosso novo tokenizador será exatamente igual ao GPT-2, e a única coisa que irá mudar é o vocabulário, que será determinado pelo treinamento em nosso corpus.",Me,ss,ca="Primeiramente, vamos dar uma olhada em como o tokenizador trataria um exemplo de função:",Je,es,ye,as,je,ns,ua="O tokenizador possui alguns símbolos especiais, como <code>Ġ</code> e <code>Ċ</code>, que denotam espaços e novas linhas, respectivamente. Como podemos observar, isso não é tão eficiente: o tokenizador retorna tokens individuais para cada espaço, quando poderia agrupar níveis de indentação (já que ter conjuntos de quatro ou oito espaços será muito comum no código). O tokenizador também dividiu o nome da função de uma forma um pouco estranha, não sendo usado para ver palavras com o caractere <code>_</code>.",Te,ts,da="Vamos treinar um novo tokenizador e ver se isso resolve esses problemas. Para isso, iremos utilizar o método <code>train_new_from_iterator()</code>:",xe,ls,he,os,Ma="Este comando pode demorar um pouco se o seu corpus for muito grande, mas para este dataset contendo 1.6 GB de textos é extremamente rápido (1 minuto e 16 segundos em uma CPU AMD Ryzen 9 3900X com 12 núcleos).",Ue,rs,Ja='Observe que <code>AutoTokenizer.train_new_from_iterator()</code> funciona apenas se o tokenizador que você estiver usando é um tokenizador “rápido”. Como você verá na próxima seção, a biblioteca 🤗 Transformers contém dois tipos de tokenizers: alguns são escritos puramente em Python e outros (os mais rápidos) são apoiados pela biblioteca 🤗 Tokenizers, que é escrita na linguagem de programação <a href="https://www.rust-lang.org" rel="nofollow">Rust</a>. Python é a linguagem de programação mais utilizada para Ciência de Dados e aplicações em Deep Learning, mas quando algo precisa ser paralelizado para ser rápido, é preciso ser escrito em uma outra linguagem. Por exemplo, as multiplicações de matrizes que estão na base de modelos de computação são escritos em CUDA, uma biblioteca em C otimizada para GPUs.',ge,is,ya='Treinar um tokenizador totalmente novo usando apenas Python seria terrivelmente lento, e é por isso que nós desenvolvemos a biblioteca 🤗 Tokenizers. Observe que, assim como você não precisou aprender a linguagem CUDA para ser capaz de executar seu modelo em um lote de entradas em uma GPU, você não precisará aprender Rust para usar o tokenizador rápido. A biblioteca 🤗 Tokenizers fornece ligaçções para muitos métodos que internamente chamam algum trecho de código em Rust; por exemplo, para paralelizar o treinamento do seu novo tokenizador ou, como vimos no <a href="/course/chapter3">Chapter 3</a>, a tokenização de um lote de entradas.',fe,ps,ja='A maioria dos modelos Transformer possui um tokenizador rápido disponível (existem algumas exceções que você pode checar <a href="https://huggingface.co/transformers/#supported-frameworks" rel="nofollow">aqui</a>), e a API <code>AutoTokenizer</code> sempre seleciona o tokenizador rápido para você se estiver disponível. Na próxima seção, veremos alguns dos outros recursos especiais que os tokenizers rápidos possuem, que serão realmente úteis para tarefas como classificação de tokens e resposta a perguntas. Antes de aprofundarmos nisso, no entanto, vamos experimentar o nosso novo tokenizador no exemplo anterior:',we,ms,be,cs,Ce,us,Ta="Aqui vemos novamente os símbolos especiais <code>Ġ</code> and <code>Ċ</code> que denotam espaços e novas linhas, mas também podemos observar que o nosso tokenizador aprendeu alguns tokens que são altamente específicos em um corpus de funções em Python: por exemplo, existe um token <code>ĊĠĠĠ</code> que representa uma indentação, e um token <code>Ġ&quot;&quot;&quot;</code> que representa as três aspas que começam uma docstring. O tokenizador também divide corretamente o nome da função em <code>_</code>. Esta é uma representação bastante compacta; comparativamente, usando o tokenizador em inglês no mesmo exemplo nos dará uma frase mais longa:",ve,ds,Qe,Ms,ke,Js,xa="Vejamos outro exemplo:",$e,ys,Ie,js,ze,Ts,ha="Além do token correpondente a uma indentação, aqui podemos ver um token para uma indentação dupla: <code>ĊĠĠĠĠĠĠĠ</code>. Palavras especiais em Python, como <code>class</code>, <code>init</code>, <code>call</code>, <code>self</code>, e <code>return</code> são tokenizadas como um token, e podemos ver que além de dividir em <code>_</code> e <code>.</code>, o tokenizador divide corretamente até mesmo nomes em CamelCase: <code>LinearLayer</code> é tokenizado como <code>[&quot;ĠLinear&quot;, &quot;Layer&quot;]</code>",Ve,xs,_e,hs,Ua="Para garantir que podemos usá-lo mais tarde, precisamos salvar nosso novo tokenizador. Assim como é utilizado para modelos, isso é feito com o método <code>save_pretrained()</code>:",Ae,Us,Be,gs,ga="Isso irá criar uma nova pasta chamada <em>code-search-net-tokenizer</em>, que irá conter todos os arquivos que o tokenizador precisa para ser recarregado. Se você quiser compartilhar este tokenizador com outros colegas e amigos, você pode carregá-lo no Hub fazendo login em sua conta. Se você estiver trabalhando em um notebook, há uma função conveniente para ajudá-lo com isso:",qe,fs,Ze,ws,fa="Isso exibirá um widget onde você pode inserir suas credenciais de login do Hugging Face. Se você não estiver trabalhando em um notebook, basta digitar a seguinte linha em seu terminal:",Xe,bs,Ne,Cs,wa="Depois de você logar, você pode enviar seu tokenizador executando o seguinte comando:",Ge,vs,Ee,Qs,ba="Isso criará um novo repositório em seu namespace com o nome <code>code-search-net-tokenizer</code>, contendo o arquivo do tokenizador. Você pode então carregar o tokenizador de qualquer lugar com o método <code>from_pretrained()</code>:",We,ks,De,$s,Ca='Agora você está pronto para treinar um modelo de linguagem do zero e ajustá-lo para sua tarefa! Chegaremos a isso no <a href="/course/chapter7">Chapter 7</a>, mas primeiro, no resto do capítulo daremos uma olhada sobre tokenizers rápidos e explorar em detalhes o que realmente acontece quando chamamos o método <code>train_new_from_iterator()</code>.',He,zs,Re;return h=new Ye({props:{title:"Treinando um novo tokenizador",local:"treinando-um-novo-tokenizador",headingTag:"h1"}}),U=new Xa({props:{chapter:6,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/pt/chapter6/section2.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/pt/chapter6/section2.ipynb"}]}}),f=new Za({props:{id:"DJimQynXZsQ"}}),T=new qa({props:{warning:!0,$$slots:{default:[Na]},$$scope:{ctx:Vs}}}),w=new Ye({props:{title:"Montando um corpus",local:"montando-um-corpus",headingTag:"h2"}}),v=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBJTIzJTIwSXN0byUyMHBvZGUlMjBsZXZhciUyMGFsZ3VucyUyMG1pbnV0b3MlMjBwYXJhJTIwY2FycmVnYXIlMkMlMjBlbnQlQzMlQTNvJTIwcGVndWUlMjB1bSUyMGNvcG8lMjBkZSUyMGNhZiVDMyVBOSUyMGVucXVhbnRvJTIwZXNwZXJhISUwQXJhd19kYXRhc2V0cyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJjb2RlX3NlYXJjaF9uZXQlMjIlMkMlMjAlMjJweXRob24lMjIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># Isto pode levar alguns minutos para carregar, então pegue um copo de café enquanto espera!</span>
raw_datasets = load_dataset(<span class="hljs-string">&quot;code_search_net&quot;</span>, <span class="hljs-string">&quot;python&quot;</span>)`,wrap:!1}}),k=new J({props:{code:"cmF3X2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQ=",highlighted:'raw_datasets[<span class="hljs-string">&quot;train&quot;</span>]',wrap:!1}}),$=new J({props:{code:"RGF0YXNldCglN0IlMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QidyZXBvc2l0b3J5X25hbWUnJTJDJTIwJ2Z1bmNfcGF0aF9pbl9yZXBvc2l0b3J5JyUyQyUyMCdmdW5jX25hbWUnJTJDJTIwJ3dob2xlX2Z1bmNfc3RyaW5nJyUyQyUyMCdsYW5ndWFnZSclMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAnZnVuY19jb2RlX3N0cmluZyclMkMlMjAnZnVuY19jb2RlX3Rva2VucyclMkMlMjAnZnVuY19kb2N1bWVudGF0aW9uX3N0cmluZyclMkMlMjAnZnVuY19kb2N1bWVudGF0aW9uX3Rva2VucyclMkMlMjAnc3BsaXRfbmFtZSclMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAnZnVuY19jb2RlX3VybCclMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjBudW1fcm93cyUzQSUyMDQxMjE3OCUwQSU3RCk=",highlighted:`Dataset({
    features: [<span class="hljs-string">&#x27;repository_name&#x27;</span>, <span class="hljs-string">&#x27;func_path_in_repository&#x27;</span>, <span class="hljs-string">&#x27;func_name&#x27;</span>, <span class="hljs-string">&#x27;whole_func_string&#x27;</span>, <span class="hljs-string">&#x27;language&#x27;</span>, 
      <span class="hljs-string">&#x27;func_code_string&#x27;</span>, <span class="hljs-string">&#x27;func_code_tokens&#x27;</span>, <span class="hljs-string">&#x27;func_documentation_string&#x27;</span>, <span class="hljs-string">&#x27;func_documentation_tokens&#x27;</span>, <span class="hljs-string">&#x27;split_name&#x27;</span>, 
      <span class="hljs-string">&#x27;func_code_url&#x27;</span>
    ],
    num_rows: <span class="hljs-number">412178</span>
})`,wrap:!1}}),z=new J({props:{code:"cHJpbnQocmF3X2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlNUIxMjM0NTYlNUQlNUIlMjJ3aG9sZV9mdW5jX3N0cmluZyUyMiU1RCk=",highlighted:'<span class="hljs-built_in">print</span>(raw_datasets[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">123456</span>][<span class="hljs-string">&quot;whole_func_string&quot;</span>])',wrap:!1}}),_=new J({props:{code:"ZGVmJTIwaGFuZGxlX3NpbXBsZV9yZXNwb25zZXMoJTBBJTIwJTIwJTIwJTIwJTIwJTIwc2VsZiUyQyUyMHRpbWVvdXRfbXMlM0ROb25lJTJDJTIwaW5mb19jYiUzRERFRkFVTFRfTUVTU0FHRV9DQUxMQkFDSyklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJBY2NlcHRzJTIwbm9ybWFsJTIwcmVzcG9uc2VzJTIwZnJvbSUyMHRoZSUyMGRldmljZS4lMEElMEElMjAlMjAlMjAlMjBBcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwdGltZW91dF9tcyUzQSUyMFRpbWVvdXQlMjBpbiUyMG1pbGxpc2Vjb25kcyUyMHRvJTIwd2FpdCUyMGZvciUyMGVhY2glMjByZXNwb25zZS4lMEElMjAlMjAlMjAlMjAlMjAlMjBpbmZvX2NiJTNBJTIwT3B0aW9uYWwlMjBjYWxsYmFjayUyMGZvciUyMHRleHQlMjBzZW50JTIwZnJvbSUyMHRoZSUyMGJvb3Rsb2FkZXIuJTBBJTBBJTIwJTIwJTIwJTIwUmV0dXJucyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyME9LQVklMjBwYWNrZXQncyUyMG1lc3NhZ2UuJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc2VsZi5fYWNjZXB0X3Jlc3BvbnNlcygnT0tBWSclMkMlMjBpbmZvX2NiJTJDJTIwdGltZW91dF9tcyUzRHRpbWVvdXRfbXMp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">handle_simple_responses</span>(<span class="hljs-params">
      self, timeout_ms=<span class="hljs-literal">None</span>, info_cb=DEFAULT_MESSAGE_CALLBACK</span>):
    <span class="hljs-string">&quot;&quot;&quot;Accepts normal responses from the device.

    Args:
      timeout_ms: Timeout in milliseconds to wait for each response.
      info_cb: Optional callback for text sent from the bootloader.

    Returns:
      OKAY packet&#x27;s message.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> self._accept_responses(<span class="hljs-string">&#x27;OKAY&#x27;</span>, info_cb, timeout_ms=timeout_ms)`,wrap:!1}}),q=new J({props:{code:"JTIzJTIwTiVDMyVBM28lMjByZW1vdmElMjBvJTIwY29tZW50JUMzJUExcmlvJTIwZGElMjBsaW5oYSUyMGFiYWl4byUyQyUyMGElMjBtZW5vcyUyMHF1ZSUyMG8lMjB0ZXUlMjBkYXRhc2V0JTIwc2VqYSUyMHBlcXVlbm8hJTBBJTIzJTIwdHJhaW5pbmdfY29ycHVzJTIwJTNEJTIwJTVCcmF3X2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlNUJpJTNBJTIwaSUyMCUyQiUyMDEwMDAlNUQlNUIlMjJ3aG9sZV9mdW5jX3N0cmluZyUyMiU1RCUyMGZvciUyMGklMjBpbiUyMHJhbmdlKDAlMkMlMjBsZW4ocmF3X2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQpJTJDJTIwMTAwMCklNUQ=",highlighted:`<span class="hljs-comment"># Não remova o comentário da linha abaixo, a menos que o teu dataset seja pequeno!</span>
<span class="hljs-comment"># training_corpus = [raw_datasets[&quot;train&quot;][i: i + 1000][&quot;whole_func_string&quot;] for i in range(0, len(raw_datasets[&quot;train&quot;]), 1000)]</span>`,wrap:!1}}),X=new J({props:{code:"dHJhaW5pbmdfY29ycHVzJTIwJTNEJTIwKCUwQSUyMCUyMCUyMCUyMHJhd19kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVEJTVCaSUyMCUzQSUyMGklMjAlMkIlMjAxMDAwJTVEJTVCJTIyd2hvbGVfZnVuY19zdHJpbmclMjIlNUQlMEElMjAlMjAlMjAlMjBmb3IlMjBpJTIwaW4lMjByYW5nZSgwJTJDJTIwbGVuKHJhd19kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVEKSUyQyUyMDEwMDApJTBBKQ==",highlighted:`training_corpus = (
    raw_datasets[<span class="hljs-string">&quot;train&quot;</span>][i : i + <span class="hljs-number">1000</span>][<span class="hljs-string">&quot;whole_func_string&quot;</span>]
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(raw_datasets[<span class="hljs-string">&quot;train&quot;</span>]), <span class="hljs-number">1000</span>)
)`,wrap:!1}}),E=new J({props:{code:"Z2VuJTIwJTNEJTIwKGklMjBmb3IlMjBpJTIwaW4lMjByYW5nZSgxMCkpJTBBcHJpbnQobGlzdChnZW4pKSUwQXByaW50KGxpc3QoZ2VuKSk=",highlighted:`gen = (i <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">10</span>))
<span class="hljs-built_in">print</span>(<span class="hljs-built_in">list</span>(gen))
<span class="hljs-built_in">print</span>(<span class="hljs-built_in">list</span>(gen))`,wrap:!1}}),D=new J({props:{code:"JTVCMCUyQyUyMDElMkMlMjAyJTJDJTIwMyUyQyUyMDQlMkMlMjA1JTJDJTIwNiUyQyUyMDclMkMlMjA4JTJDJTIwOSU1RCUwQSU1QiU1RA==",highlighted:`[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>]
[]`,wrap:!1}}),R=new J({props:{code:"ZGVmJTIwZ2V0X3RyYWluaW5nX2NvcnB1cygpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJhd19kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVEJTVCaSUyMCUzQSUyMGklMjAlMkIlMjAxMDAwJTVEJTVCJTIyd2hvbGVfZnVuY19zdHJpbmclMjIlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBpJTIwaW4lMjByYW5nZSgwJTJDJTIwbGVuKHJhd19kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVEKSUyQyUyMDEwMDApJTBBJTIwJTIwJTIwJTIwKSUwQSUwQSUwQXRyYWluaW5nX2NvcnB1cyUyMCUzRCUyMGdldF90cmFpbmluZ19jb3JwdXMoKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_training_corpus</span>():
    <span class="hljs-keyword">return</span> (
        raw_datasets[<span class="hljs-string">&quot;train&quot;</span>][i : i + <span class="hljs-number">1000</span>][<span class="hljs-string">&quot;whole_func_string&quot;</span>]
        <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(raw_datasets[<span class="hljs-string">&quot;train&quot;</span>]), <span class="hljs-number">1000</span>)
    )


training_corpus = get_training_corpus()`,wrap:!1}}),S=new J({props:{code:"ZGVmJTIwZ2V0X3RyYWluaW5nX2NvcnB1cygpJTNBJTBBJTIwJTIwJTIwJTIwZGF0YXNldCUyMCUzRCUyMHJhd19kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwc3RhcnRfaWR4JTIwaW4lMjByYW5nZSgwJTJDJTIwbGVuKGRhdGFzZXQpJTJDJTIwMTAwMCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzYW1wbGVzJTIwJTNEJTIwZGF0YXNldCU1QnN0YXJ0X2lkeCUyMCUzQSUyMHN0YXJ0X2lkeCUyMCUyQiUyMDEwMDAlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB5aWVsZCUyMHNhbXBsZXMlNUIlMjJ3aG9sZV9mdW5jX3N0cmluZyUyMiU1RA==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_training_corpus</span>():
    dataset = raw_datasets[<span class="hljs-string">&quot;train&quot;</span>]
    <span class="hljs-keyword">for</span> start_idx <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(dataset), <span class="hljs-number">1000</span>):
        samples = dataset[start_idx : start_idx + <span class="hljs-number">1000</span>]
        <span class="hljs-keyword">yield</span> samples[<span class="hljs-string">&quot;whole_func_string&quot;</span>]`,wrap:!1}}),F=new Ye({props:{title:"Treinando um novo tokenizador",local:"treinando-um-novo-tokenizador",headingTag:"h2"}}),K=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEFvbGRfdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

old_tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)`,wrap:!1}}),es=new J({props:{code:"ZXhhbXBsZSUyMCUzRCUyMCcnJ2RlZiUyMGFkZF9udW1iZXJzKGElMkMlMjBiKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkFkZCUyMHRoZSUyMHR3byUyMG51bWJlcnMlMjAlNjBhJTYwJTIwYW5kJTIwJTYwYiU2MC4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBhJTIwJTJCJTIwYicnJyUwQSUwQXRva2VucyUyMCUzRCUyMG9sZF90b2tlbml6ZXIudG9rZW5pemUoZXhhbXBsZSklMEF0b2tlbnM=",highlighted:`example = <span class="hljs-string">&#x27;&#x27;&#x27;def add_numbers(a, b):
    &quot;&quot;&quot;Add the two numbers \`a\` and \`b\`.&quot;&quot;&quot;
    return a + b&#x27;&#x27;&#x27;</span>

tokens = old_tokenizer.tokenize(example)
tokens`,wrap:!1}}),as=new J({props:{code:"JTVCJ2RlZiclMkMlMjAnJUM0JUEwYWRkJyUyQyUyMCdfJyUyQyUyMCduJyUyQyUyMCd1bWJlcnMnJTJDJTIwJygnJTJDJTIwJ2EnJTJDJTIwJyUyQyclMkMlMjAnJUM0JUEwYiclMkMlMjAnKSUzQSclMkMlMjAnJUM0JThBJyUyQyUyMCclQzQlQTAnJTJDJTIwJyVDNCVBMCclMkMlMjAnJUM0JUEwJyUyQyUyMCclQzQlQTAlMjIlMjIlMjInJTJDJTIwJ0FkZCclMkMlMjAnJUM0JUEwdGhlJyUyQyUyMCclQzQlQTB0d28nJTJDJTBBJTIwJyVDNCVBMG51bWJlcnMnJTJDJTIwJyVDNCVBMCU2MCclMkMlMjAnYSclMkMlMjAnJTYwJyUyQyUyMCclQzQlQTBhbmQnJTJDJTIwJyVDNCVBMCU2MCclMkMlMjAnYiclMkMlMjAnJTYwJyUyQyUyMCcuJTIyJyUyQyUyMCclMjIlMjInJTJDJTIwJyVDNCU4QSclMkMlMjAnJUM0JUEwJyUyQyUyMCclQzQlQTAnJTJDJTIwJyVDNCVBMCclMkMlMjAnJUM0JUEwcmV0dXJuJyUyQyUyMCclQzQlQTBhJyUyQyUyMCclQzQlQTAlMkInJTJDJTIwJyVDNCVBMGInJTVE",highlighted:'[<span class="hljs-string">&#x27;def&#x27;</span>, <span class="hljs-string">&#x27;Ġadd&#x27;</span>, <span class="hljs-string">&#x27;_&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;umbers&#x27;</span>, <span class="hljs-string">&#x27;(&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;Ġb&#x27;</span>, <span class="hljs-string">&#x27;):&#x27;</span>, <span class="hljs-string">&#x27;Ċ&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;Ġ&quot;&quot;&quot;&#x27;</span>, <span class="hljs-string">&#x27;Add&#x27;</span>, <span class="hljs-string">&#x27;Ġthe&#x27;</span>, <span class="hljs-string">&#x27;Ġtwo&#x27;</span>,\n <span class="hljs-string">&#x27;Ġnumbers&#x27;</span>, <span class="hljs-string">&#x27;Ġ`&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;`&#x27;</span>, <span class="hljs-string">&#x27;Ġand&#x27;</span>, <span class="hljs-string">&#x27;Ġ`&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>, <span class="hljs-string">&#x27;`&#x27;</span>, <span class="hljs-string">&#x27;.&quot;&#x27;</span>, <span class="hljs-string">&#x27;&quot;&quot;&#x27;</span>, <span class="hljs-string">&#x27;Ċ&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;Ġreturn&#x27;</span>, <span class="hljs-string">&#x27;Ġa&#x27;</span>, <span class="hljs-string">&#x27;Ġ+&#x27;</span>, <span class="hljs-string">&#x27;Ġb&#x27;</span>]',wrap:!1}}),ls=new J({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwb2xkX3Rva2VuaXplci50cmFpbl9uZXdfZnJvbV9pdGVyYXRvcih0cmFpbmluZ19jb3JwdXMlMkMlMjA1MjAwMCk=",highlighted:'tokenizer = old_tokenizer.train_new_from_iterator(training_corpus, <span class="hljs-number">52000</span>)',wrap:!1}}),ms=new J({props:{code:"dG9rZW5zJTIwJTNEJTIwdG9rZW5pemVyLnRva2VuaXplKGV4YW1wbGUpJTBBdG9rZW5z",highlighted:`tokens = tokenizer.tokenize(example)
tokens`,wrap:!1}}),cs=new J({props:{code:"JTVCJ2RlZiclMkMlMjAnJUM0JUEwYWRkJyUyQyUyMCdfJyUyQyUyMCdudW1iZXJzJyUyQyUyMCcoJyUyQyUyMCdhJyUyQyUyMCclMkMnJTJDJTIwJyVDNCVBMGInJTJDJTIwJyklM0EnJTJDJTIwJyVDNCU4QSVDNCVBMCVDNCVBMCVDNCVBMCclMkMlMjAnJUM0JUEwJTIyJTIyJTIyJyUyQyUyMCdBZGQnJTJDJTIwJyVDNCVBMHRoZSclMkMlMjAnJUM0JUEwdHdvJyUyQyUyMCclQzQlQTBudW1iZXJzJyUyQyUyMCclQzQlQTAlNjAnJTJDJTBBJTIwJ2EnJTJDJTIwJyU2MCclMkMlMjAnJUM0JUEwYW5kJyUyQyUyMCclQzQlQTAlNjAnJTJDJTIwJ2InJTJDJTIwJyU2MC4lMjIlMjIlMjInJTJDJTIwJyVDNCU4QSVDNCVBMCVDNCVBMCVDNCVBMCclMkMlMjAnJUM0JUEwcmV0dXJuJyUyQyUyMCclQzQlQTBhJyUyQyUyMCclQzQlQTAlMkInJTJDJTIwJyVDNCVBMGInJTVE",highlighted:'[<span class="hljs-string">&#x27;def&#x27;</span>, <span class="hljs-string">&#x27;Ġadd&#x27;</span>, <span class="hljs-string">&#x27;_&#x27;</span>, <span class="hljs-string">&#x27;numbers&#x27;</span>, <span class="hljs-string">&#x27;(&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;Ġb&#x27;</span>, <span class="hljs-string">&#x27;):&#x27;</span>, <span class="hljs-string">&#x27;ĊĠĠĠ&#x27;</span>, <span class="hljs-string">&#x27;Ġ&quot;&quot;&quot;&#x27;</span>, <span class="hljs-string">&#x27;Add&#x27;</span>, <span class="hljs-string">&#x27;Ġthe&#x27;</span>, <span class="hljs-string">&#x27;Ġtwo&#x27;</span>, <span class="hljs-string">&#x27;Ġnumbers&#x27;</span>, <span class="hljs-string">&#x27;Ġ`&#x27;</span>,\n <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;`&#x27;</span>, <span class="hljs-string">&#x27;Ġand&#x27;</span>, <span class="hljs-string">&#x27;Ġ`&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>, <span class="hljs-string">&#x27;`.&quot;&quot;&quot;&#x27;</span>, <span class="hljs-string">&#x27;ĊĠĠĠ&#x27;</span>, <span class="hljs-string">&#x27;Ġreturn&#x27;</span>, <span class="hljs-string">&#x27;Ġa&#x27;</span>, <span class="hljs-string">&#x27;Ġ+&#x27;</span>, <span class="hljs-string">&#x27;Ġb&#x27;</span>]',wrap:!1}}),ds=new J({props:{code:"cHJpbnQobGVuKHRva2VucykpJTBBcHJpbnQobGVuKG9sZF90b2tlbml6ZXIudG9rZW5pemUoZXhhbXBsZSkpKQ==",highlighted:`<span class="hljs-built_in">print</span>(<span class="hljs-built_in">len</span>(tokens))
<span class="hljs-built_in">print</span>(<span class="hljs-built_in">len</span>(old_tokenizer.tokenize(example)))`,wrap:!1}}),Ms=new J({props:{code:"MjclMEEzNg==",highlighted:`<span class="hljs-number">27</span>
<span class="hljs-number">36</span>`,wrap:!1}}),ys=new J({props:{code:"ZXhhbXBsZSUyMCUzRCUyMCUyMiUyMiUyMmNsYXNzJTIwTGluZWFyTGF5ZXIoKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBpbnB1dF9zaXplJTJDJTIwb3V0cHV0X3NpemUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi53ZWlnaHQlMjAlM0QlMjB0b3JjaC5yYW5kbihpbnB1dF9zaXplJTJDJTIwb3V0cHV0X3NpemUpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5iaWFzJTIwJTNEJTIwdG9yY2guemVyb3Mob3V0cHV0X3NpemUpJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19jYWxsX18oc2VsZiUyQyUyMHgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIweCUyMCU0MCUyMHNlbGYud2VpZ2h0cyUyMCUyQiUyMHNlbGYuYmlhcyUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQXRva2VuaXplci50b2tlbml6ZShleGFtcGxlKQ==",highlighted:`example = <span class="hljs-string">&quot;&quot;&quot;class LinearLayer():
    def __init__(self, input_size, output_size):
        self.weight = torch.randn(input_size, output_size)
        self.bias = torch.zeros(output_size)

    def __call__(self, x):
        return x @ self.weights + self.bias
    &quot;&quot;&quot;</span>
tokenizer.tokenize(example)`,wrap:!1}}),js=new J({props:{code:"JTVCJ2NsYXNzJyUyQyUyMCclQzQlQTBMaW5lYXInJTJDJTIwJ0xheWVyJyUyQyUyMCcoKSUzQSclMkMlMjAnJUM0JThBJUM0JUEwJUM0JUEwJUM0JUEwJyUyQyUyMCclQzQlQTBkZWYnJTJDJTIwJyVDNCVBMF9fJyUyQyUyMCdpbml0JyUyQyUyMCdfXygnJTJDJTIwJ3NlbGYnJTJDJTIwJyUyQyclMkMlMjAnJUM0JUEwaW5wdXQnJTJDJTIwJ18nJTJDJTIwJ3NpemUnJTJDJTIwJyUyQyclMkMlMEElMjAnJUM0JUEwb3V0cHV0JyUyQyUyMCdfJyUyQyUyMCdzaXplJyUyQyUyMCcpJTNBJyUyQyUyMCclQzQlOEElQzQlQTAlQzQlQTAlQzQlQTAlQzQlQTAlQzQlQTAlQzQlQTAlQzQlQTAnJTJDJTIwJyVDNCVBMHNlbGYnJTJDJTIwJy4nJTJDJTIwJ3dlaWdodCclMkMlMjAnJUM0JUEwJTNEJyUyQyUyMCclQzQlQTB0b3JjaCclMkMlMjAnLiclMkMlMjAncmFuZG4nJTJDJTIwJygnJTJDJTIwJ2lucHV0JyUyQyUyMCdfJyUyQyUwQSUyMCdzaXplJyUyQyUyMCclMkMnJTJDJTIwJyVDNCVBMG91dHB1dCclMkMlMjAnXyclMkMlMjAnc2l6ZSclMkMlMjAnKSclMkMlMjAnJUM0JThBJUM0JUEwJUM0JUEwJUM0JUEwJUM0JUEwJUM0JUEwJUM0JUEwJUM0JUEwJyUyQyUyMCclQzQlQTBzZWxmJyUyQyUyMCcuJyUyQyUyMCdiaWFzJyUyQyUyMCclQzQlQTAlM0QnJTJDJTIwJyVDNCVBMHRvcmNoJyUyQyUyMCcuJyUyQyUyMCd6ZXJvcyclMkMlMjAnKCclMkMlMEElMjAnb3V0cHV0JyUyQyUyMCdfJyUyQyUyMCdzaXplJyUyQyUyMCcpJyUyQyUyMCclQzQlOEElQzQlOEElQzQlQTAlQzQlQTAlQzQlQTAnJTJDJTIwJyVDNCVBMGRlZiclMkMlMjAnJUM0JUEwX18nJTJDJTIwJ2NhbGwnJTJDJTIwJ19fKCclMkMlMjAnc2VsZiclMkMlMjAnJTJDJyUyQyUyMCclQzQlQTB4JyUyQyUyMCcpJTNBJyUyQyUyMCclQzQlOEElQzQlQTAlQzQlQTAlQzQlQTAlQzQlQTAlQzQlQTAlQzQlQTAlQzQlQTAnJTJDJTBBJTIwJyVDNCVBMHJldHVybiclMkMlMjAnJUM0JUEweCclMkMlMjAnJUM0JUEwJTQwJyUyQyUyMCclQzQlQTBzZWxmJyUyQyUyMCcuJyUyQyUyMCd3ZWlnaHRzJyUyQyUyMCclQzQlQTAlMkInJTJDJTIwJyVDNCVBMHNlbGYnJTJDJTIwJy4nJTJDJTIwJ2JpYXMnJTJDJTIwJyVDNCU4QSVDNCVBMCVDNCVBMCVDNCVBMCVDNCVBMCclNUQ=",highlighted:`[<span class="hljs-string">&#x27;class&#x27;</span>, <span class="hljs-string">&#x27;ĠLinear&#x27;</span>, <span class="hljs-string">&#x27;Layer&#x27;</span>, <span class="hljs-string">&#x27;():&#x27;</span>, <span class="hljs-string">&#x27;ĊĠĠĠ&#x27;</span>, <span class="hljs-string">&#x27;Ġdef&#x27;</span>, <span class="hljs-string">&#x27;Ġ__&#x27;</span>, <span class="hljs-string">&#x27;init&#x27;</span>, <span class="hljs-string">&#x27;__(&#x27;</span>, <span class="hljs-string">&#x27;self&#x27;</span>, <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;Ġinput&#x27;</span>, <span class="hljs-string">&#x27;_&#x27;</span>, <span class="hljs-string">&#x27;size&#x27;</span>, <span class="hljs-string">&#x27;,&#x27;</span>,
 <span class="hljs-string">&#x27;Ġoutput&#x27;</span>, <span class="hljs-string">&#x27;_&#x27;</span>, <span class="hljs-string">&#x27;size&#x27;</span>, <span class="hljs-string">&#x27;):&#x27;</span>, <span class="hljs-string">&#x27;ĊĠĠĠĠĠĠĠ&#x27;</span>, <span class="hljs-string">&#x27;Ġself&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;weight&#x27;</span>, <span class="hljs-string">&#x27;Ġ=&#x27;</span>, <span class="hljs-string">&#x27;Ġtorch&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;randn&#x27;</span>, <span class="hljs-string">&#x27;(&#x27;</span>, <span class="hljs-string">&#x27;input&#x27;</span>, <span class="hljs-string">&#x27;_&#x27;</span>,
 <span class="hljs-string">&#x27;size&#x27;</span>, <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;Ġoutput&#x27;</span>, <span class="hljs-string">&#x27;_&#x27;</span>, <span class="hljs-string">&#x27;size&#x27;</span>, <span class="hljs-string">&#x27;)&#x27;</span>, <span class="hljs-string">&#x27;ĊĠĠĠĠĠĠĠ&#x27;</span>, <span class="hljs-string">&#x27;Ġself&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;bias&#x27;</span>, <span class="hljs-string">&#x27;Ġ=&#x27;</span>, <span class="hljs-string">&#x27;Ġtorch&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;zeros&#x27;</span>, <span class="hljs-string">&#x27;(&#x27;</span>,
 <span class="hljs-string">&#x27;output&#x27;</span>, <span class="hljs-string">&#x27;_&#x27;</span>, <span class="hljs-string">&#x27;size&#x27;</span>, <span class="hljs-string">&#x27;)&#x27;</span>, <span class="hljs-string">&#x27;ĊĊĠĠĠ&#x27;</span>, <span class="hljs-string">&#x27;Ġdef&#x27;</span>, <span class="hljs-string">&#x27;Ġ__&#x27;</span>, <span class="hljs-string">&#x27;call&#x27;</span>, <span class="hljs-string">&#x27;__(&#x27;</span>, <span class="hljs-string">&#x27;self&#x27;</span>, <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;Ġx&#x27;</span>, <span class="hljs-string">&#x27;):&#x27;</span>, <span class="hljs-string">&#x27;ĊĠĠĠĠĠĠĠ&#x27;</span>,
 <span class="hljs-string">&#x27;Ġreturn&#x27;</span>, <span class="hljs-string">&#x27;Ġx&#x27;</span>, <span class="hljs-string">&#x27;Ġ@&#x27;</span>, <span class="hljs-string">&#x27;Ġself&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;weights&#x27;</span>, <span class="hljs-string">&#x27;Ġ+&#x27;</span>, <span class="hljs-string">&#x27;Ġself&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;bias&#x27;</span>, <span class="hljs-string">&#x27;ĊĠĠĠĠ&#x27;</span>]`,wrap:!1}}),xs=new Ye({props:{title:"Salvando o tokenizador",local:"salvando-o-tokenizador",headingTag:"h2"}}),Us=new J({props:{code:"dG9rZW5pemVyLnNhdmVfcHJldHJhaW5lZCglMjJjb2RlLXNlYXJjaC1uZXQtdG9rZW5pemVyJTIyKQ==",highlighted:'tokenizer.save_pretrained(<span class="hljs-string">&quot;code-search-net-tokenizer&quot;</span>)',wrap:!1}}),fs=new J({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),bs=new J({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login",wrap:!1}}),vs=new J({props:{code:"dG9rZW5pemVyLnB1c2hfdG9faHViKCUyMmNvZGUtc2VhcmNoLW5ldC10b2tlbml6ZXIlMjIp",highlighted:'tokenizer.push_to_hub(<span class="hljs-string">&quot;code-search-net-tokenizer&quot;</span>)',wrap:!1}}),ks=new J({props:{code:"JTIzJTIwU3Vic3RpdHVhJTIwJTIyaHVnZ2luZ2ZhY2UtY291cnNlJTIyJTIwYWJhaXhvJTIwcGVsbyUyMHNldSUyMG5hbWVzcGFjZSUyMHJlYWwlMjBwYXJhJTIwdXNhciUyMHNldSUyMHByJUMzJUIzcHJpbyUyMHRva2VuaXphZG9yJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyaHVnZ2luZ2ZhY2UtY291cnNlJTJGY29kZS1zZWFyY2gtbmV0LXRva2VuaXplciUyMik=",highlighted:`<span class="hljs-comment"># Substitua &quot;huggingface-course&quot; abaixo pelo seu namespace real para usar seu próprio tokenizador</span>
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;huggingface-course/code-search-net-tokenizer&quot;</span>)`,wrap:!1}}),{c(){y=o("meta"),x=t(),j=o("p"),Is=t(),p(h.$$.fragment),_s=t(),p(U.$$.fragment),As=t(),g=o("p"),g.innerHTML=Se,Bs=t(),p(f.$$.fragment),qs=t(),p(T.$$.fragment),Zs=t(),p(w.$$.fragment),Xs=t(),b=o("p"),b.innerHTML=Pe,Ns=t(),C=o("p"),C.innerHTML=Fe,Gs=t(),p(v.$$.fragment),Es=t(),Q=o("p"),Q.textContent=Le,Ws=t(),p(k.$$.fragment),Ds=t(),p($.$$.fragment),Hs=t(),I=o("p"),I.innerHTML=Ke,Rs=t(),p(z.$$.fragment),Ys=t(),V=o("p"),V.textContent=Oe,Ss=t(),p(_.$$.fragment),Ps=t(),A=o("p"),A.textContent=sa,Fs=t(),B=o("p"),B.textContent=ea,Ls=t(),p(q.$$.fragment),Ks=t(),Z=o("p"),Z.textContent=aa,Os=t(),p(X.$$.fragment),se=t(),N=o("p"),N.innerHTML=na,ee=t(),G=o("p"),G.textContent=ta,ae=t(),p(E.$$.fragment),ne=t(),W=o("p"),W.textContent=la,te=t(),p(D.$$.fragment),le=t(),H=o("p"),H.textContent=oa,oe=t(),p(R.$$.fragment),re=t(),Y=o("p"),Y.innerHTML=ra,ie=t(),p(S.$$.fragment),pe=t(),P=o("p"),P.textContent=ia,me=t(),p(F.$$.fragment),ce=t(),L=o("p"),L.textContent=pa,ue=t(),p(K.$$.fragment),de=t(),O=o("p"),O.textContent=ma,Me=t(),ss=o("p"),ss.textContent=ca,Je=t(),p(es.$$.fragment),ye=t(),p(as.$$.fragment),je=t(),ns=o("p"),ns.innerHTML=ua,Te=t(),ts=o("p"),ts.innerHTML=da,xe=t(),p(ls.$$.fragment),he=t(),os=o("p"),os.textContent=Ma,Ue=t(),rs=o("p"),rs.innerHTML=Ja,ge=t(),is=o("p"),is.innerHTML=ya,fe=t(),ps=o("p"),ps.innerHTML=ja,we=t(),p(ms.$$.fragment),be=t(),p(cs.$$.fragment),Ce=t(),us=o("p"),us.innerHTML=Ta,ve=t(),p(ds.$$.fragment),Qe=t(),p(Ms.$$.fragment),ke=t(),Js=o("p"),Js.textContent=xa,$e=t(),p(ys.$$.fragment),Ie=t(),p(js.$$.fragment),ze=t(),Ts=o("p"),Ts.innerHTML=ha,Ve=t(),p(xs.$$.fragment),_e=t(),hs=o("p"),hs.innerHTML=Ua,Ae=t(),p(Us.$$.fragment),Be=t(),gs=o("p"),gs.innerHTML=ga,qe=t(),p(fs.$$.fragment),Ze=t(),ws=o("p"),ws.textContent=fa,Xe=t(),p(bs.$$.fragment),Ne=t(),Cs=o("p"),Cs.textContent=wa,Ge=t(),p(vs.$$.fragment),Ee=t(),Qs=o("p"),Qs.innerHTML=ba,We=t(),p(ks.$$.fragment),De=t(),$s=o("p"),$s.innerHTML=Ca,He=t(),zs=o("p"),this.h()},l(s){const e=Aa("svelte-u9bgzb",document.head);y=r(e,"META",{name:!0,content:!0}),e.forEach(a),x=l(s),j=r(s,"P",{}),Qa(j).forEach(a),Is=l(s),m(h.$$.fragment,s),_s=l(s),m(U.$$.fragment,s),As=l(s),g=r(s,"P",{"data-svelte-h":!0}),i(g)!=="svelte-x44f7i"&&(g.innerHTML=Se),Bs=l(s),m(f.$$.fragment,s),qs=l(s),m(T.$$.fragment,s),Zs=l(s),m(w.$$.fragment,s),Xs=l(s),b=r(s,"P",{"data-svelte-h":!0}),i(b)!=="svelte-1hv00c6"&&(b.innerHTML=Pe),Ns=l(s),C=r(s,"P",{"data-svelte-h":!0}),i(C)!=="svelte-rcbbns"&&(C.innerHTML=Fe),Gs=l(s),m(v.$$.fragment,s),Es=l(s),Q=r(s,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-1m43037"&&(Q.textContent=Le),Ws=l(s),m(k.$$.fragment,s),Ds=l(s),m($.$$.fragment,s),Hs=l(s),I=r(s,"P",{"data-svelte-h":!0}),i(I)!=="svelte-10ass7x"&&(I.innerHTML=Ke),Rs=l(s),m(z.$$.fragment,s),Ys=l(s),V=r(s,"P",{"data-svelte-h":!0}),i(V)!=="svelte-1a385u8"&&(V.textContent=Oe),Ss=l(s),m(_.$$.fragment,s),Ps=l(s),A=r(s,"P",{"data-svelte-h":!0}),i(A)!=="svelte-14r92l0"&&(A.textContent=sa),Fs=l(s),B=r(s,"P",{"data-svelte-h":!0}),i(B)!=="svelte-14uouvq"&&(B.textContent=ea),Ls=l(s),m(q.$$.fragment,s),Ks=l(s),Z=r(s,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-98gx1x"&&(Z.textContent=aa),Os=l(s),m(X.$$.fragment,s),se=l(s),N=r(s,"P",{"data-svelte-h":!0}),i(N)!=="svelte-7csvqv"&&(N.innerHTML=na),ee=l(s),G=r(s,"P",{"data-svelte-h":!0}),i(G)!=="svelte-1s9m9sp"&&(G.textContent=ta),ae=l(s),m(E.$$.fragment,s),ne=l(s),W=r(s,"P",{"data-svelte-h":!0}),i(W)!=="svelte-wjal7j"&&(W.textContent=la),te=l(s),m(D.$$.fragment,s),le=l(s),H=r(s,"P",{"data-svelte-h":!0}),i(H)!=="svelte-1tqwfcm"&&(H.textContent=oa),oe=l(s),m(R.$$.fragment,s),re=l(s),Y=r(s,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-1w4dew1"&&(Y.innerHTML=ra),ie=l(s),m(S.$$.fragment,s),pe=l(s),P=r(s,"P",{"data-svelte-h":!0}),i(P)!=="svelte-yyjtdy"&&(P.textContent=ia),me=l(s),m(F.$$.fragment,s),ce=l(s),L=r(s,"P",{"data-svelte-h":!0}),i(L)!=="svelte-iq4v51"&&(L.textContent=pa),ue=l(s),m(K.$$.fragment,s),de=l(s),O=r(s,"P",{"data-svelte-h":!0}),i(O)!=="svelte-vygci3"&&(O.textContent=ma),Me=l(s),ss=r(s,"P",{"data-svelte-h":!0}),i(ss)!=="svelte-id8gx"&&(ss.textContent=ca),Je=l(s),m(es.$$.fragment,s),ye=l(s),m(as.$$.fragment,s),je=l(s),ns=r(s,"P",{"data-svelte-h":!0}),i(ns)!=="svelte-1ni5tyk"&&(ns.innerHTML=ua),Te=l(s),ts=r(s,"P",{"data-svelte-h":!0}),i(ts)!=="svelte-1w0qhno"&&(ts.innerHTML=da),xe=l(s),m(ls.$$.fragment,s),he=l(s),os=r(s,"P",{"data-svelte-h":!0}),i(os)!=="svelte-1ou3vq3"&&(os.textContent=Ma),Ue=l(s),rs=r(s,"P",{"data-svelte-h":!0}),i(rs)!=="svelte-1rf6ca0"&&(rs.innerHTML=Ja),ge=l(s),is=r(s,"P",{"data-svelte-h":!0}),i(is)!=="svelte-a11k97"&&(is.innerHTML=ya),fe=l(s),ps=r(s,"P",{"data-svelte-h":!0}),i(ps)!=="svelte-hvvcog"&&(ps.innerHTML=ja),we=l(s),m(ms.$$.fragment,s),be=l(s),m(cs.$$.fragment,s),Ce=l(s),us=r(s,"P",{"data-svelte-h":!0}),i(us)!=="svelte-1m97xcr"&&(us.innerHTML=Ta),ve=l(s),m(ds.$$.fragment,s),Qe=l(s),m(Ms.$$.fragment,s),ke=l(s),Js=r(s,"P",{"data-svelte-h":!0}),i(Js)!=="svelte-1j9rbec"&&(Js.textContent=xa),$e=l(s),m(ys.$$.fragment,s),Ie=l(s),m(js.$$.fragment,s),ze=l(s),Ts=r(s,"P",{"data-svelte-h":!0}),i(Ts)!=="svelte-1ktqser"&&(Ts.innerHTML=ha),Ve=l(s),m(xs.$$.fragment,s),_e=l(s),hs=r(s,"P",{"data-svelte-h":!0}),i(hs)!=="svelte-13spa8"&&(hs.innerHTML=Ua),Ae=l(s),m(Us.$$.fragment,s),Be=l(s),gs=r(s,"P",{"data-svelte-h":!0}),i(gs)!=="svelte-1r9s58a"&&(gs.innerHTML=ga),qe=l(s),m(fs.$$.fragment,s),Ze=l(s),ws=r(s,"P",{"data-svelte-h":!0}),i(ws)!=="svelte-t334av"&&(ws.textContent=fa),Xe=l(s),m(bs.$$.fragment,s),Ne=l(s),Cs=r(s,"P",{"data-svelte-h":!0}),i(Cs)!=="svelte-gcaawg"&&(Cs.textContent=wa),Ge=l(s),m(vs.$$.fragment,s),Ee=l(s),Qs=r(s,"P",{"data-svelte-h":!0}),i(Qs)!=="svelte-7uwkn2"&&(Qs.innerHTML=ba),We=l(s),m(ks.$$.fragment,s),De=l(s),$s=r(s,"P",{"data-svelte-h":!0}),i($s)!=="svelte-5q5pj5"&&($s.innerHTML=Ca),He=l(s),zs=r(s,"P",{}),Qa(zs).forEach(a),this.h()},h(){ka(y,"name","hf:doc:metadata"),ka(y,"content",Ea)},m(s,e){Ba(document.head,y),n(s,x,e),n(s,j,e),n(s,Is,e),c(h,s,e),n(s,_s,e),c(U,s,e),n(s,As,e),n(s,g,e),n(s,Bs,e),c(f,s,e),n(s,qs,e),c(T,s,e),n(s,Zs,e),c(w,s,e),n(s,Xs,e),n(s,b,e),n(s,Ns,e),n(s,C,e),n(s,Gs,e),c(v,s,e),n(s,Es,e),n(s,Q,e),n(s,Ws,e),c(k,s,e),n(s,Ds,e),c($,s,e),n(s,Hs,e),n(s,I,e),n(s,Rs,e),c(z,s,e),n(s,Ys,e),n(s,V,e),n(s,Ss,e),c(_,s,e),n(s,Ps,e),n(s,A,e),n(s,Fs,e),n(s,B,e),n(s,Ls,e),c(q,s,e),n(s,Ks,e),n(s,Z,e),n(s,Os,e),c(X,s,e),n(s,se,e),n(s,N,e),n(s,ee,e),n(s,G,e),n(s,ae,e),c(E,s,e),n(s,ne,e),n(s,W,e),n(s,te,e),c(D,s,e),n(s,le,e),n(s,H,e),n(s,oe,e),c(R,s,e),n(s,re,e),n(s,Y,e),n(s,ie,e),c(S,s,e),n(s,pe,e),n(s,P,e),n(s,me,e),c(F,s,e),n(s,ce,e),n(s,L,e),n(s,ue,e),c(K,s,e),n(s,de,e),n(s,O,e),n(s,Me,e),n(s,ss,e),n(s,Je,e),c(es,s,e),n(s,ye,e),c(as,s,e),n(s,je,e),n(s,ns,e),n(s,Te,e),n(s,ts,e),n(s,xe,e),c(ls,s,e),n(s,he,e),n(s,os,e),n(s,Ue,e),n(s,rs,e),n(s,ge,e),n(s,is,e),n(s,fe,e),n(s,ps,e),n(s,we,e),c(ms,s,e),n(s,be,e),c(cs,s,e),n(s,Ce,e),n(s,us,e),n(s,ve,e),c(ds,s,e),n(s,Qe,e),c(Ms,s,e),n(s,ke,e),n(s,Js,e),n(s,$e,e),c(ys,s,e),n(s,Ie,e),c(js,s,e),n(s,ze,e),n(s,Ts,e),n(s,Ve,e),c(xs,s,e),n(s,_e,e),n(s,hs,e),n(s,Ae,e),c(Us,s,e),n(s,Be,e),n(s,gs,e),n(s,qe,e),c(fs,s,e),n(s,Ze,e),n(s,ws,e),n(s,Xe,e),c(bs,s,e),n(s,Ne,e),n(s,Cs,e),n(s,Ge,e),c(vs,s,e),n(s,Ee,e),n(s,Qs,e),n(s,We,e),c(ks,s,e),n(s,De,e),n(s,$s,e),n(s,He,e),n(s,zs,e),Re=!0},p(s,[e]){const va={};e&2&&(va.$$scope={dirty:e,ctx:s}),T.$set(va)},i(s){Re||(u(h.$$.fragment,s),u(U.$$.fragment,s),u(f.$$.fragment,s),u(T.$$.fragment,s),u(w.$$.fragment,s),u(v.$$.fragment,s),u(k.$$.fragment,s),u($.$$.fragment,s),u(z.$$.fragment,s),u(_.$$.fragment,s),u(q.$$.fragment,s),u(X.$$.fragment,s),u(E.$$.fragment,s),u(D.$$.fragment,s),u(R.$$.fragment,s),u(S.$$.fragment,s),u(F.$$.fragment,s),u(K.$$.fragment,s),u(es.$$.fragment,s),u(as.$$.fragment,s),u(ls.$$.fragment,s),u(ms.$$.fragment,s),u(cs.$$.fragment,s),u(ds.$$.fragment,s),u(Ms.$$.fragment,s),u(ys.$$.fragment,s),u(js.$$.fragment,s),u(xs.$$.fragment,s),u(Us.$$.fragment,s),u(fs.$$.fragment,s),u(bs.$$.fragment,s),u(vs.$$.fragment,s),u(ks.$$.fragment,s),Re=!0)},o(s){d(h.$$.fragment,s),d(U.$$.fragment,s),d(f.$$.fragment,s),d(T.$$.fragment,s),d(w.$$.fragment,s),d(v.$$.fragment,s),d(k.$$.fragment,s),d($.$$.fragment,s),d(z.$$.fragment,s),d(_.$$.fragment,s),d(q.$$.fragment,s),d(X.$$.fragment,s),d(E.$$.fragment,s),d(D.$$.fragment,s),d(R.$$.fragment,s),d(S.$$.fragment,s),d(F.$$.fragment,s),d(K.$$.fragment,s),d(es.$$.fragment,s),d(as.$$.fragment,s),d(ls.$$.fragment,s),d(ms.$$.fragment,s),d(cs.$$.fragment,s),d(ds.$$.fragment,s),d(Ms.$$.fragment,s),d(ys.$$.fragment,s),d(js.$$.fragment,s),d(xs.$$.fragment,s),d(Us.$$.fragment,s),d(fs.$$.fragment,s),d(bs.$$.fragment,s),d(vs.$$.fragment,s),d(ks.$$.fragment,s),Re=!1},d(s){s&&(a(x),a(j),a(Is),a(_s),a(As),a(g),a(Bs),a(qs),a(Zs),a(Xs),a(b),a(Ns),a(C),a(Gs),a(Es),a(Q),a(Ws),a(Ds),a(Hs),a(I),a(Rs),a(Ys),a(V),a(Ss),a(Ps),a(A),a(Fs),a(B),a(Ls),a(Ks),a(Z),a(Os),a(se),a(N),a(ee),a(G),a(ae),a(ne),a(W),a(te),a(le),a(H),a(oe),a(re),a(Y),a(ie),a(pe),a(P),a(me),a(ce),a(L),a(ue),a(de),a(O),a(Me),a(ss),a(Je),a(ye),a(je),a(ns),a(Te),a(ts),a(xe),a(he),a(os),a(Ue),a(rs),a(ge),a(is),a(fe),a(ps),a(we),a(be),a(Ce),a(us),a(ve),a(Qe),a(ke),a(Js),a($e),a(Ie),a(ze),a(Ts),a(Ve),a(_e),a(hs),a(Ae),a(Be),a(gs),a(qe),a(Ze),a(ws),a(Xe),a(Ne),a(Cs),a(Ge),a(Ee),a(Qs),a(We),a(De),a($s),a(He),a(zs)),a(y),M(h,s),M(U,s),M(f,s),M(T,s),M(w,s),M(v,s),M(k,s),M($,s),M(z,s),M(_,s),M(q,s),M(X,s),M(E,s),M(D,s),M(R,s),M(S,s),M(F,s),M(K,s),M(es,s),M(as,s),M(ls,s),M(ms,s),M(cs,s),M(ds,s),M(Ms,s),M(ys,s),M(js,s),M(xs,s),M(Us,s),M(fs,s),M(bs,s),M(vs,s),M(ks,s)}}}const Ea='{"title":"Treinando um novo tokenizador","local":"treinando-um-novo-tokenizador","sections":[{"title":"Montando um corpus","local":"montando-um-corpus","sections":[],"depth":2},{"title":"Treinando um novo tokenizador","local":"treinando-um-novo-tokenizador","sections":[],"depth":2},{"title":"Salvando o tokenizador","local":"salvando-o-tokenizador","sections":[],"depth":2}],"depth":1}';function Wa(Vs){return Ia(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class La extends Va{constructor(y){super(),_a(this,y,Wa,Ga,$a,{})}}export{La as component};
