import{s as vl,f as be,n as Tl,o as Ul}from"../chunks/scheduler.37c15a92.js";import{S as jl,i as Jl,g as a,s,r as c,A as Gl,h as i,f as l,c as o,j as bl,u as h,x as r,k as p,y as xl,a as n,v as d,d as m,t as u,w as M}from"../chunks/index.7cb9c9b8.js";import{C as _t}from"../chunks/CodeBlock.a6d3f852.js";import{H as f}from"../chunks/Heading.d3928e2a.js";function _l(Ct){let g,Ue,ve,je,w,Je,y,Zt='<a href="https://github.com/edbeeching/godot_rl_agents" rel="nofollow">Godot RL Agents</a> is an Open Source package that allows video game creators, AI researchers, and hobbyists the opportunity <strong>to learn complex behaviors for their Non Player Characters or agents</strong>.',Ge,b,It="The library provides:",xe,v,St='<li>An interface between games created in the <a href="https://godotengine.org/" rel="nofollow">Godot Engine</a> and Machine Learning algorithms running in Python</li> <li>Wrappers for four well known rl frameworks: <a href="https://stable-baselines3.readthedocs.io/en/master/" rel="nofollow">StableBaselines3</a>, <a href="https://docs.cleanrl.dev/" rel="nofollow">CleanRL</a>, <a href="https://www.samplefactory.dev/" rel="nofollow">Sample Factory</a> and <a href="https://docs.ray.io/en/latest/rllib-algorithms.html" rel="nofollow">Ray RLLib</a></li> <li>Support for memory-based agents with LSTM or attention based interfaces</li> <li>Support for <em>2D and 3D games</em></li> <li>A suite of <em>AI sensors</em> to augment your agent’s capacity to observe the game world</li> <li>Godot and Godot RL Agents are <strong>completely free and open source under a very permissive MIT license</strong>. No strings attached, no royalties, nothing.</li>',_e,T,kt='You can find out more about Godot RL agents on their <a href="https://github.com/edbeeching/godot_rl_agents" rel="nofollow">GitHub page</a> or their AAAI-2022 Workshop <a href="https://arxiv.org/abs/2112.03636" rel="nofollow">paper</a>. The library’s creator, <a href="https://edbeeching.github.io/" rel="nofollow">Ed Beeching</a>, is a Research Scientist here at Hugging Face.',Ce,U,Bt="Installation of the library is simple: <code>pip install godot-rl</code>",Ze,j,Ie,J,Rt="In this section, you will <strong>learn how to create a custom environment in the Godot Game Engine</strong> and then implement an AI controller that learns to play with Deep Reinforcement Learning.",Se,G,Lt="The example game we create today is simple, <strong>but shows off many of the features of the Godot Engine and the Godot RL Agents library</strong>. You can then dive into the examples for more complex environments and behaviors.",ke,x,Wt="The environment we will be building today is called Ring Pong, the game of pong but the pitch is a ring and the paddle moves around the ring. The <strong>objective is to keep the ball bouncing inside the ring</strong>.",Be,_,Et,Re,C,Le,Z,Xt='The <a href="https://godotengine.org/" rel="nofollow">Godot game engine</a> is an open source tool for the <strong>creation of video games, tools and user interfaces</strong>.',We,I,At="Godot Engine is a feature-packed, cross-platform game engine designed to create 2D and 3D games from a unified interface. It provides a comprehensive set of common tools, so users <strong>can focus on making games without having to reinvent the wheel</strong>. Games can be exported in one click to a number of platforms, including the major desktop platforms (Linux, macOS, Windows) as well as mobile (Android, iOS) and web-based (HTML5) platforms.",Ee,S,$t='While we will guide you through the steps to implement your agent, you may wish to learn more about the Godot Game Engine. Their <a href="https://docs.godotengine.org/en/latest/index.html" rel="nofollow">documentation</a> is thorough, and there are many tutorials on YouTube we would also recommend <a href="https://www.gdquest.com/" rel="nofollow">GDQuest</a>, <a href="https://kidscancode.org/godot_recipes/4.x/" rel="nofollow">KidsCanCode</a> and <a href="https://www.youtube.com/channel/UCczi7Aq_dTKrQPF5ZV5J3gg" rel="nofollow">Bramwell</a> as sources of information.',Xe,k,Ht="In order to create games in Godot, <strong>you must first download the editor</strong>. Godot RL Agents supports the latest version of Godot, Godot 4.0.",Ae,B,Qt="Which can be downloaded at the following links:",$e,R,zt='<li><a href="https://downloads.tuxfamily.org/godotengine/4.0.1/Godot_v4.0.1-stable_win64.exe.zip" rel="nofollow">Windows</a></li> <li><a href="https://downloads.tuxfamily.org/godotengine/4.0.1/Godot_v4.0.1-stable_macos.universal.zip" rel="nofollow">Mac</a></li> <li><a href="https://downloads.tuxfamily.org/godotengine/4.0.1/Godot_v4.0.1-stable_linux.x86_64.zip" rel="nofollow">Linux</a></li>',He,L,Qe,W,Nt="We provide two versions of the codebase:",ze,E,Ft='<li><a href="https://drive.google.com/file/d/1C7xd3TibJHlxFEJPBgBLpksgxrFZ3D8e/view?usp=share_link" rel="nofollow">A starter project, to download and follow along for this tutorial</a></li> <li><a href="https://drive.google.com/file/d/1k-b2Bu7uIA6poApbouX4c3sq98xqogpZ/view?usp=share_link" rel="nofollow">A final version of the project, for comparison and debugging.</a></li>',Ne,X,Yt="To load the project, in the Godot Project Manager click <strong>Import</strong>, navigate to where the files are located and load the <strong>project.godot</strong> file.",Fe,A,qt="If you press F5 or play in the editor, you should be able to play the game in human mode. There are several instances of the game running, this is because we want to speed up training our AI agent with many parallel environments.",Ye,$,qe,H,Vt="The Godot RL Agents plugin can be installed from the Github repo or with the Godot Asset Lib in the editor.",Ve,Q,Dt="First click on the AssetLib and search for “rl”",De,z,Pt,Pe,N,Ot="Then click on Godot RL Agents, click Download and unselect the LICENSE and README .md files. Then click install.",Oe,F,Kt,Ke,Y,el="The Godot RL Agents plugin is now downloaded to your machine. Now click on Project → Project settings and enable the addon:",et,q,tl,tt,V,lt,D,ll="We now want to add an AI controller to our game. Open the player.tscn scene, on the left you should see a hierarchy of nodes that looks like this:",nt,P,nl,st,O,sl="Right click the <strong>Player</strong> node and click <strong>Add Child Node.</strong> There are many nodes listed here, search for AIController3D and create it.",ot,K,ol,at,ee,al="The AI Controller Node should have been added to the scene tree, next to it is a scroll. Click on it to open the script that is attached to the AIController. The Godot game engine uses a scripting language called GDScript, which is syntactically similar to python. The script contains methods that need to be implemented in order to get our AI controller working.",it,te,rt,le,il="In order to implement these methods, we will need to create a class that inherits from AIController3D. This is easy to do in Godot, and is called “extending” a class.",pt,ne,rl="Right click the AIController3D Node and click “Extend Script” and call the new script <code>controller.gd</code>. You should now have an almost empty script file that looks like this:",ct,se,ht,oe,pl="We will now implement the 4 missing methods, delete this code, and replace it with the following:",dt,ae,mt,ie,cl="We have now defined the agent’s observation, which is the position and velocity of the ball in its local coordinate space. We have also defined the action space of the agent, which is a single continuous value ranging from -1 to +1.",ut,re,hl="The next step is to update the Player’s script to use the actions from the AIController, edit the Player’s script by clicking on the scroll next to the player node, update the code in <code>Player.gd</code> to the following:",Mt,pe,gt,ce,dl="We now need to synchronize between the game running in Godot and the neural network being trained in Python. Godot RL agents provides a node that does just that. Open the train.tscn scene, right click on the root node, and click “Add child node”. Then, search for “sync” and add a Godot RL Agents Sync node. This node handles the communication between Python and Godot over TCP.",ft,he,ml="You can run training live in the editor, by first launching the python training with <code>gdrl</code>.",wt,de,ul="In this simple example, a reasonable policy is learned in several minutes. You may wish to speed up training, click on the Sync node in the train scene, and you will see there is a “Speed Up” property exposed in the editor:",yt,me,Ml,bt,ue,gl="Try setting this property up to 8 to speed up training. This can be a great benefit on more complex environments, like the multi-player FPS we will learn about in the next chapter.",vt,Me,Tt,ge,fl='We have only scratched the surface of what can be achieved with Godot RL Agents, the library includes custom sensors and cameras to enrich the information available to the agent. Take a look at the <a href="https://github.com/edbeeching/godot_rl_agents_examples" rel="nofollow">examples</a> to find out more!',Ut,fe,wl='For the ability to export the trained model to .onnx so that you can run inference directly from Godot without the Python server, and other useful training options, take a look at the <a href="https://github.com/edbeeching/godot_rl_agents/blob/main/docs/ADV_STABLE_BASELINES_3.md" rel="nofollow">advanced SB3 tutorial</a>.',jt,we,Jt,ye,yl='This section was written by <a href="https://twitter.com/edwardbeeching">Edward Beeching</a>',Gt,Te,xt;return w=new f({props:{title:"Godot RL Agents",local:"godot-rl-agents",headingTag:"h1"}}),j=new f({props:{title:"Create a custom RL environment with Godot RL Agents",local:"create-a-custom-rl-environment-with-godot-rl-agents",headingTag:"h2"}}),C=new f({props:{title:"Installing the Godot Game Engine",local:"installing-the-godot-game-engine",headingTag:"h3"}}),L=new f({props:{title:"Loading the starter project",local:"loading-the-starter-project",headingTag:"h3"}}),$=new f({props:{title:"Installing the Godot RL Agents plugin",local:"installing-the-godot-rl-agents-plugin",headingTag:"h3"}}),V=new f({props:{title:"Adding the AI controller",local:"adding-the-ai-controller",headingTag:"h3"}}),te=new _t({props:{code:"JTIzLS0lMjBNZXRob2RzJTIwdGhhdCUyMG5lZWQlMjBpbXBsZW1lbnRpbmclMjB1c2luZyUyMHRoZSUyMCUyMmV4dGVuZCUyMHNjcmlwdCUyMiUyMG9wdGlvbiUyMGluJTIwR29kb3QlMjAtLSUyMyUwQWZ1bmMlMjBnZXRfb2JzKCklMjAtJTNFJTIwRGljdGlvbmFyeSUzQSUwQSUwOWFzc2VydChmYWxzZSUyQyUyMCUyMnRoZSUyMGdldF9vYnMlMjBtZXRob2QlMjBpcyUyMG5vdCUyMGltcGxlbWVudGVkJTIwd2hlbiUyMGV4dGVuZGluZyUyMGZyb20lMjBhaV9jb250cm9sbGVyJTIyKSUwQSUwOXJldHVybiUyMCU3QiUyMm9icyUyMiUzQSU1QiU1RCU3RCUwQSUwQWZ1bmMlMjBnZXRfcmV3YXJkKCklMjAtJTNFJTIwZmxvYXQlM0ElMEElMDlhc3NlcnQoZmFsc2UlMkMlMjAlMjJ0aGUlMjBnZXRfcmV3YXJkJTIwbWV0aG9kJTIwaXMlMjBub3QlMjBpbXBsZW1lbnRlZCUyMHdoZW4lMjBleHRlbmRpbmclMjBmcm9tJTIwYWlfY29udHJvbGxlciUyMiklMEElMDlyZXR1cm4lMjAwLjAlMEElMEFmdW5jJTIwZ2V0X2FjdGlvbl9zcGFjZSgpJTIwLSUzRSUyMERpY3Rpb25hcnklM0ElMEElMDlhc3NlcnQoZmFsc2UlMkMlMjAlMjJ0aGUlMjBnZXQlMjBnZXRfYWN0aW9uX3NwYWNlJTIwbWV0aG9kJTIwaXMlMjBub3QlMjBpbXBsZW1lbnRlZCUyMHdoZW4lMjBleHRlbmRpbmclMjBmcm9tJTIwYWlfY29udHJvbGxlciUyMiklMEElMDlyZXR1cm4lMjAlN0IlMEElMDklMDklMjJleGFtcGxlX2FjdGlvbnNfY29udGlub3VzJTIyJTIwJTNBJTIwJTdCJTBBJTA5JTA5JTA5JTIyc2l6ZSUyMiUzQSUyMDIlMkMlMEElMDklMDklMDklMjJhY3Rpb25fdHlwZSUyMiUzQSUyMCUyMmNvbnRpbnVvdXMlMjIlMEElMDklMDklN0QlMkMlMEElMDklMDklMjJleGFtcGxlX2FjdGlvbnNfZGlzY3JldGUlMjIlMjAlM0ElMjAlN0IlMEElMDklMDklMDklMjJzaXplJTIyJTNBJTIwMiUyQyUwQSUwOSUwOSUwOSUyMmFjdGlvbl90eXBlJTIyJTNBJTIwJTIyZGlzY3JldGUlMjIlMEElMDklMDklN0QlMkMlMEElMDklMDklN0QlMEElMEFmdW5jJTIwc2V0X2FjdGlvbihhY3Rpb24pJTIwLSUzRSUyMHZvaWQlM0ElMEElMDlhc3NlcnQoZmFsc2UlMkMlMjAlMjJ0aGUlMjBnZXQlMjBzZXRfYWN0aW9uJTIwbWV0aG9kJTIwaXMlMjBub3QlMjBpbXBsZW1lbnRlZCUyMHdoZW4lMjBleHRlbmRpbmclMjBmcm9tJTIwYWlfY29udHJvbGxlciUyMiklMEElMjMlMjAtLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLSUyMw==",highlighted:`<span class="hljs-comment">#-- Methods that need implementing using the &quot;extend script&quot; option in Godot --#</span>
func get_obs() -&gt; Dictionary:
	<span class="hljs-keyword">assert</span>(false, <span class="hljs-string">&quot;the get_obs method is not implemented when extending from ai_controller&quot;</span>)
	<span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;obs&quot;</span>:[]}

func get_reward() -&gt; <span class="hljs-built_in">float</span>:
	<span class="hljs-keyword">assert</span>(false, <span class="hljs-string">&quot;the get_reward method is not implemented when extending from ai_controller&quot;</span>)
	<span class="hljs-keyword">return</span> <span class="hljs-number">0.0</span>

func get_action_space() -&gt; Dictionary:
	<span class="hljs-keyword">assert</span>(false, <span class="hljs-string">&quot;the get get_action_space method is not implemented when extending from ai_controller&quot;</span>)
	<span class="hljs-keyword">return</span> {
		<span class="hljs-string">&quot;example_actions_continous&quot;</span> : {
			<span class="hljs-string">&quot;size&quot;</span>: <span class="hljs-number">2</span>,
			<span class="hljs-string">&quot;action_type&quot;</span>: <span class="hljs-string">&quot;continuous&quot;</span>
		},
		<span class="hljs-string">&quot;example_actions_discrete&quot;</span> : {
			<span class="hljs-string">&quot;size&quot;</span>: <span class="hljs-number">2</span>,
			<span class="hljs-string">&quot;action_type&quot;</span>: <span class="hljs-string">&quot;discrete&quot;</span>
		},
		}

func set_action(action) -&gt; void:
	<span class="hljs-keyword">assert</span>(false, <span class="hljs-string">&quot;the get set_action method is not implemented when extending from ai_controller&quot;</span>)
<span class="hljs-comment"># -----------------------------------------------------------------------------#</span>`,wrap:!1}}),se=new _t({props:{code:"ZXh0ZW5kcyUyMEFJQ29udHJvbGxlcjNEJTBBJTBBJTIzJTIwQ2FsbGVkJTIwd2hlbiUyMHRoZSUyMG5vZGUlMjBlbnRlcnMlMjB0aGUlMjBzY2VuZSUyMHRyZWUlMjBmb3IlMjB0aGUlMjBmaXJzdCUyMHRpbWUuJTBBZnVuYyUyMF9yZWFkeSgpJTNBJTBBJTA5cGFzcyUyMCUyMyUyMFJlcGxhY2UlMjB3aXRoJTIwZnVuY3Rpb24lMjBib2R5LiUwQSUwQSUyMyUyMENhbGxlZCUyMGV2ZXJ5JTIwZnJhbWUuJTIwJ2RlbHRhJyUyMGlzJTIwdGhlJTIwZWxhcHNlZCUyMHRpbWUlMjBzaW5jZSUyMHRoZSUyMHByZXZpb3VzJTIwZnJhbWUuJTBBZnVuYyUyMF9wcm9jZXNzKGRlbHRhKSUzQSUwQSUwOXBhc3M=",highlighted:`extends AIController3D

<span class="hljs-comment"># Called when the node enters the scene tree for the first time.</span>
func _ready():
	<span class="hljs-keyword">pass</span> <span class="hljs-comment"># Replace with function body.</span>

<span class="hljs-comment"># Called every frame. &#x27;delta&#x27; is the elapsed time since the previous frame.</span>
func _process(delta):
	<span class="hljs-keyword">pass</span>`,wrap:!1}}),ae=new _t({props:{code:"ZXh0ZW5kcyUyMEFJQ29udHJvbGxlcjNEJTBBJTBBJTIzJTIwU3RvcmVzJTIwdGhlJTIwYWN0aW9uJTIwc2FtcGxlZCUyMGZvciUyMHRoZSUyMGFnZW50J3MlMjBwb2xpY3klMkMlMjBydW5uaW5nJTIwaW4lMjBweXRob24lMEF2YXIlMjBtb3ZlX2FjdGlvbiUyMCUzQSUyMGZsb2F0JTIwJTNEJTIwMC4wJTBBJTBBZnVuYyUyMGdldF9vYnMoKSUyMC0lM0UlMjBEaWN0aW9uYXJ5JTNBJTBBJTA5JTIzJTIwZ2V0JTIwdGhlJTIwYmFsbHMlMjBwb3NpdGlvbiUyMGFuZCUyMHZlbG9jaXR5JTIwaW4lMjB0aGUlMjBwYWRkbGUncyUyMGZyYW1lJTIwb2YlMjByZWZlcmVuY2UlMEElMDl2YXIlMjBiYWxsX3BvcyUyMCUzRCUyMHRvX2xvY2FsKF9wbGF5ZXIuYmFsbC5nbG9iYWxfcG9zaXRpb24pJTBBJTA5dmFyJTIwYmFsbF92ZWwlMjAlM0QlMjB0b19sb2NhbChfcGxheWVyLmJhbGwubGluZWFyX3ZlbG9jaXR5KSUwQSUwOXZhciUyMG9icyUyMCUzRCUyMCU1QmJhbGxfcG9zLnglMkMlMjBiYWxsX3Bvcy56JTJDJTIwYmFsbF92ZWwueCUyRjEwLjAlMkMlMjBiYWxsX3ZlbC56JTJGMTAuMCU1RCUwQSUwQSUwOXJldHVybiUyMCU3QiUyMm9icyUyMiUzQW9icyU3RCUwQSUwQWZ1bmMlMjBnZXRfcmV3YXJkKCklMjAtJTNFJTIwZmxvYXQlM0ElMEElMDlyZXR1cm4lMjByZXdhcmQlMEElMEFmdW5jJTIwZ2V0X2FjdGlvbl9zcGFjZSgpJTIwLSUzRSUyMERpY3Rpb25hcnklM0ElMEElMDlyZXR1cm4lMjAlN0IlMEElMDklMDklMjJtb3ZlX2FjdGlvbiUyMiUyMCUzQSUyMCU3QiUwQSUwOSUwOSUwOSUyMnNpemUlMjIlM0ElMjAxJTJDJTBBJTA5JTA5JTA5JTIyYWN0aW9uX3R5cGUlMjIlM0ElMjAlMjJjb250aW51b3VzJTIyJTBBJTA5JTA5JTdEJTJDJTBBJTA5JTA5JTdEJTBBJTBBZnVuYyUyMHNldF9hY3Rpb24oYWN0aW9uKSUyMC0lM0UlMjB2b2lkJTNBJTBBJTA5bW92ZV9hY3Rpb24lMjAlM0QlMjBjbGFtcChhY3Rpb24lNUIlMjJtb3ZlX2FjdGlvbiUyMiU1RCU1QjAlNUQlMkMlMjAtMS4wJTJDJTIwMS4wKQ==",highlighted:`extends AIController3D

<span class="hljs-comment"># Stores the action sampled for the agent&#x27;s policy, running in python</span>
var move_action : <span class="hljs-built_in">float</span> = <span class="hljs-number">0.0</span>

func get_obs() -&gt; Dictionary:
	<span class="hljs-comment"># get the balls position and velocity in the paddle&#x27;s frame of reference</span>
	var ball_pos = to_local(_player.ball.global_position)
	var ball_vel = to_local(_player.ball.linear_velocity)
	var obs = [ball_pos.x, ball_pos.z, ball_vel.x/<span class="hljs-number">10.0</span>, ball_vel.z/<span class="hljs-number">10.0</span>]

	<span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;obs&quot;</span>:obs}

func get_reward() -&gt; <span class="hljs-built_in">float</span>:
	<span class="hljs-keyword">return</span> reward

func get_action_space() -&gt; Dictionary:
	<span class="hljs-keyword">return</span> {
		<span class="hljs-string">&quot;move_action&quot;</span> : {
			<span class="hljs-string">&quot;size&quot;</span>: <span class="hljs-number">1</span>,
			<span class="hljs-string">&quot;action_type&quot;</span>: <span class="hljs-string">&quot;continuous&quot;</span>
		},
		}

func set_action(action) -&gt; void:
	move_action = clamp(action[<span class="hljs-string">&quot;move_action&quot;</span>][<span class="hljs-number">0</span>], -<span class="hljs-number">1.0</span>, <span class="hljs-number">1.0</span>)`,wrap:!1}}),pe=new _t({props:{code:"ZXh0ZW5kcyUyME5vZGUzRCUwQSUwQSU0MGV4cG9ydCUyMHZhciUyMHJvdGF0aW9uX3NwZWVkJTIwJTNEJTIwMy4wJTBBJTQwb25yZWFkeSUyMHZhciUyMGJhbGwlMjAlM0QlMjBnZXRfbm9kZSglMjIuLiUyRkJhbGwlMjIpJTBBJTQwb25yZWFkeSUyMHZhciUyMGFpX2NvbnRyb2xsZXIlMjAlM0QlMjAlMjRBSUNvbnRyb2xsZXIzRCUwQSUwQWZ1bmMlMjBfcmVhZHkoKSUzQSUwQSUwOWFpX2NvbnRyb2xsZXIuaW5pdChzZWxmKSUwQSUwQWZ1bmMlMjBnYW1lX292ZXIoKSUzQSUwQSUwOWFpX2NvbnRyb2xsZXIuZG9uZSUyMCUzRCUyMHRydWUlMEElMDlhaV9jb250cm9sbGVyLm5lZWRzX3Jlc2V0JTIwJTNEJTIwdHJ1ZSUwQSUwQWZ1bmMlMjBfcGh5c2ljc19wcm9jZXNzKGRlbHRhKSUzQSUwQSUwOWlmJTIwYWlfY29udHJvbGxlci5uZWVkc19yZXNldCUzQSUwQSUwOSUwOWFpX2NvbnRyb2xsZXIucmVzZXQoKSUwQSUwOSUwOWJhbGwucmVzZXQoKSUwQSUwOSUwOXJldHVybiUwQSUwQSUwOXZhciUyMG1vdmVtZW50JTIwJTNBJTIwZmxvYXQlMEElMDlpZiUyMGFpX2NvbnRyb2xsZXIuaGV1cmlzdGljJTIwJTNEJTNEJTIwJTIyaHVtYW4lMjIlM0ElMEElMDklMDltb3ZlbWVudCUyMCUzRCUyMElucHV0LmdldF9heGlzKCUyMnJvdGF0ZV9hbnRpY2xvY2t3aXNlJTIyJTJDJTIwJTIycm90YXRlX2Nsb2Nrd2lzZSUyMiklMEElMDllbHNlJTNBJTBBJTA5JTA5bW92ZW1lbnQlMjAlM0QlMjBhaV9jb250cm9sbGVyLm1vdmVfYWN0aW9uJTBBJTA5cm90YXRlX3kobW92ZW1lbnQqZGVsdGEqcm90YXRpb25fc3BlZWQpJTBBJTBBZnVuYyUyMF9vbl9hcmVhXzNkX2JvZHlfZW50ZXJlZChib2R5KSUzQSUwQSUwOWFpX2NvbnRyb2xsZXIucmV3YXJkJTIwJTJCJTNEJTIwMS4w",highlighted:`extends Node3D

<span class="hljs-meta">@export var rotation_speed = <span class="hljs-number">3.0</span></span>
<span class="hljs-meta">@onready var ball = get_node(<span class="hljs-params"><span class="hljs-string">&quot;../Ball&quot;</span></span>)</span>
<span class="hljs-meta">@onready var ai_controller = $AIController3D</span>

func _ready():
	ai_controller.init(self)

func game_over():
	ai_controller.done = true
	ai_controller.needs_reset = true

func _physics_process(delta):
	<span class="hljs-keyword">if</span> ai_controller.needs_reset:
		ai_controller.reset()
		ball.reset()
		<span class="hljs-keyword">return</span>

	var movement : <span class="hljs-built_in">float</span>
	<span class="hljs-keyword">if</span> ai_controller.heuristic == <span class="hljs-string">&quot;human&quot;</span>:
		movement = Input.get_axis(<span class="hljs-string">&quot;rotate_anticlockwise&quot;</span>, <span class="hljs-string">&quot;rotate_clockwise&quot;</span>)
	<span class="hljs-keyword">else</span>:
		movement = ai_controller.move_action
	rotate_y(movement*delta*rotation_speed)

func _on_area_3d_body_entered(body):
	ai_controller.reward += <span class="hljs-number">1.0</span>`,wrap:!1}}),Me=new f({props:{title:"There’s more!",local:"theres-more",headingTag:"h3"}}),we=new f({props:{title:"Author",local:"author",headingTag:"h2"}}),{c(){g=a("meta"),Ue=s(),ve=a("p"),je=s(),c(w.$$.fragment),Je=s(),y=a("p"),y.innerHTML=Zt,Ge=s(),b=a("p"),b.textContent=It,xe=s(),v=a("ul"),v.innerHTML=St,_e=s(),T=a("p"),T.innerHTML=kt,Ce=s(),U=a("p"),U.innerHTML=Bt,Ze=s(),c(j.$$.fragment),Ie=s(),J=a("p"),J.innerHTML=Rt,Se=s(),G=a("p"),G.innerHTML=Lt,ke=s(),x=a("p"),x.innerHTML=Wt,Be=s(),_=a("img"),Re=s(),c(C.$$.fragment),Le=s(),Z=a("p"),Z.innerHTML=Xt,We=s(),I=a("p"),I.innerHTML=At,Ee=s(),S=a("p"),S.innerHTML=$t,Xe=s(),k=a("p"),k.innerHTML=Ht,Ae=s(),B=a("p"),B.textContent=Qt,$e=s(),R=a("ul"),R.innerHTML=zt,He=s(),c(L.$$.fragment),Qe=s(),W=a("p"),W.textContent=Nt,ze=s(),E=a("ul"),E.innerHTML=Ft,Ne=s(),X=a("p"),X.innerHTML=Yt,Fe=s(),A=a("p"),A.textContent=qt,Ye=s(),c($.$$.fragment),qe=s(),H=a("p"),H.textContent=Vt,Ve=s(),Q=a("p"),Q.textContent=Dt,De=s(),z=a("img"),Pe=s(),N=a("p"),N.textContent=Ot,Oe=s(),F=a("img"),Ke=s(),Y=a("p"),Y.textContent=el,et=s(),q=a("img"),tt=s(),c(V.$$.fragment),lt=s(),D=a("p"),D.textContent=ll,nt=s(),P=a("img"),st=s(),O=a("p"),O.innerHTML=sl,ot=s(),K=a("img"),at=s(),ee=a("p"),ee.textContent=al,it=s(),c(te.$$.fragment),rt=s(),le=a("p"),le.textContent=il,pt=s(),ne=a("p"),ne.innerHTML=rl,ct=s(),c(se.$$.fragment),ht=s(),oe=a("p"),oe.textContent=pl,dt=s(),c(ae.$$.fragment),mt=s(),ie=a("p"),ie.textContent=cl,ut=s(),re=a("p"),re.innerHTML=hl,Mt=s(),c(pe.$$.fragment),gt=s(),ce=a("p"),ce.textContent=dl,ft=s(),he=a("p"),he.innerHTML=ml,wt=s(),de=a("p"),de.textContent=ul,yt=s(),me=a("img"),bt=s(),ue=a("p"),ue.textContent=gl,vt=s(),c(Me.$$.fragment),Tt=s(),ge=a("p"),ge.innerHTML=fl,Ut=s(),fe=a("p"),fe.innerHTML=wl,jt=s(),c(we.$$.fragment),Jt=s(),ye=a("p"),ye.innerHTML=yl,Gt=s(),Te=a("p"),this.h()},l(e){const t=Gl("svelte-u9bgzb",document.head);g=i(t,"META",{name:!0,content:!0}),t.forEach(l),Ue=o(e),ve=i(e,"P",{}),bl(ve).forEach(l),je=o(e),h(w.$$.fragment,e),Je=o(e),y=i(e,"P",{"data-svelte-h":!0}),r(y)!=="svelte-2p47v5"&&(y.innerHTML=Zt),Ge=o(e),b=i(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-1py9j1o"&&(b.textContent=It),xe=o(e),v=i(e,"UL",{"data-svelte-h":!0}),r(v)!=="svelte-fbxqzk"&&(v.innerHTML=St),_e=o(e),T=i(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-f5k4w1"&&(T.innerHTML=kt),Ce=o(e),U=i(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1tilrrq"&&(U.innerHTML=Bt),Ze=o(e),h(j.$$.fragment,e),Ie=o(e),J=i(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-j43km5"&&(J.innerHTML=Rt),Se=o(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1bia7ve"&&(G.innerHTML=Lt),ke=o(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-18kdqtx"&&(x.innerHTML=Wt),Be=o(e),_=i(e,"IMG",{src:!0,alt:!0}),Re=o(e),h(C.$$.fragment,e),Le=o(e),Z=i(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-12z31zk"&&(Z.innerHTML=Xt),We=o(e),I=i(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-15j420f"&&(I.innerHTML=At),Ee=o(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-11gpv3q"&&(S.innerHTML=$t),Xe=o(e),k=i(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-sbxy1m"&&(k.innerHTML=Ht),Ae=o(e),B=i(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1qow1fz"&&(B.textContent=Qt),$e=o(e),R=i(e,"UL",{"data-svelte-h":!0}),r(R)!=="svelte-113hcwa"&&(R.innerHTML=zt),He=o(e),h(L.$$.fragment,e),Qe=o(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-4xjw3c"&&(W.textContent=Nt),ze=o(e),E=i(e,"UL",{"data-svelte-h":!0}),r(E)!=="svelte-14f47bb"&&(E.innerHTML=Ft),Ne=o(e),X=i(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-n5pdey"&&(X.innerHTML=Yt),Fe=o(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-82774z"&&(A.textContent=qt),Ye=o(e),h($.$$.fragment,e),qe=o(e),H=i(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1czivbr"&&(H.textContent=Vt),Ve=o(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1mue8hu"&&(Q.textContent=Dt),De=o(e),z=i(e,"IMG",{src:!0,alt:!0}),Pe=o(e),N=i(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-x1a58g"&&(N.textContent=Ot),Oe=o(e),F=i(e,"IMG",{src:!0,alt:!0}),Ke=o(e),Y=i(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-kax2n0"&&(Y.textContent=el),et=o(e),q=i(e,"IMG",{src:!0,alt:!0}),tt=o(e),h(V.$$.fragment,e),lt=o(e),D=i(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1k1rgr4"&&(D.textContent=ll),nt=o(e),P=i(e,"IMG",{src:!0,alt:!0}),st=o(e),O=i(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-wi5wbl"&&(O.innerHTML=sl),ot=o(e),K=i(e,"IMG",{src:!0,alt:!0}),at=o(e),ee=i(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-g41mxc"&&(ee.textContent=al),it=o(e),h(te.$$.fragment,e),rt=o(e),le=i(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1nxuc10"&&(le.textContent=il),pt=o(e),ne=i(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-10r5ldp"&&(ne.innerHTML=rl),ct=o(e),h(se.$$.fragment,e),ht=o(e),oe=i(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1bzu5xq"&&(oe.textContent=pl),dt=o(e),h(ae.$$.fragment,e),mt=o(e),ie=i(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-48pe1i"&&(ie.textContent=cl),ut=o(e),re=i(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-13nui2f"&&(re.innerHTML=hl),Mt=o(e),h(pe.$$.fragment,e),gt=o(e),ce=i(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-vvgyl6"&&(ce.textContent=dl),ft=o(e),he=i(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-188118c"&&(he.innerHTML=ml),wt=o(e),de=i(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1lptaex"&&(de.textContent=ul),yt=o(e),me=i(e,"IMG",{src:!0,alt:!0}),bt=o(e),ue=i(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1da9kc0"&&(ue.textContent=gl),vt=o(e),h(Me.$$.fragment,e),Tt=o(e),ge=i(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-w6yf05"&&(ge.innerHTML=fl),Ut=o(e),fe=i(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-6qyuz4"&&(fe.innerHTML=wl),jt=o(e),h(we.$$.fragment,e),Jt=o(e),ye=i(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-11016ov"&&(ye.innerHTML=yl),Gt=o(e),Te=i(e,"P",{}),bl(Te).forEach(l),this.h()},h(){p(g,"name","hf:doc:metadata"),p(g,"content",Cl),be(_.src,Et="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit9/ringpong.gif")||p(_,"src",Et),p(_,"alt","Ring Pong"),be(z.src,Pt="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit9/godot1.png")||p(z,"src",Pt),p(z,"alt","Godot"),be(F.src,Kt="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit9/godot2.png")||p(F,"src",Kt),p(F,"alt","Godot"),be(q.src,tl="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit9/godot3.png")||p(q,"src",tl),p(q,"alt","Godot"),be(P.src,nl="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit9/godot4.png")||p(P,"src",nl),p(P,"alt","Godot"),be(K.src,ol="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit9/godot5.png")||p(K,"src",ol),p(K,"alt","Godot"),be(me.src,Ml="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit9/godot6.png")||p(me,"src",Ml),p(me,"alt","Godot")},m(e,t){xl(document.head,g),n(e,Ue,t),n(e,ve,t),n(e,je,t),d(w,e,t),n(e,Je,t),n(e,y,t),n(e,Ge,t),n(e,b,t),n(e,xe,t),n(e,v,t),n(e,_e,t),n(e,T,t),n(e,Ce,t),n(e,U,t),n(e,Ze,t),d(j,e,t),n(e,Ie,t),n(e,J,t),n(e,Se,t),n(e,G,t),n(e,ke,t),n(e,x,t),n(e,Be,t),n(e,_,t),n(e,Re,t),d(C,e,t),n(e,Le,t),n(e,Z,t),n(e,We,t),n(e,I,t),n(e,Ee,t),n(e,S,t),n(e,Xe,t),n(e,k,t),n(e,Ae,t),n(e,B,t),n(e,$e,t),n(e,R,t),n(e,He,t),d(L,e,t),n(e,Qe,t),n(e,W,t),n(e,ze,t),n(e,E,t),n(e,Ne,t),n(e,X,t),n(e,Fe,t),n(e,A,t),n(e,Ye,t),d($,e,t),n(e,qe,t),n(e,H,t),n(e,Ve,t),n(e,Q,t),n(e,De,t),n(e,z,t),n(e,Pe,t),n(e,N,t),n(e,Oe,t),n(e,F,t),n(e,Ke,t),n(e,Y,t),n(e,et,t),n(e,q,t),n(e,tt,t),d(V,e,t),n(e,lt,t),n(e,D,t),n(e,nt,t),n(e,P,t),n(e,st,t),n(e,O,t),n(e,ot,t),n(e,K,t),n(e,at,t),n(e,ee,t),n(e,it,t),d(te,e,t),n(e,rt,t),n(e,le,t),n(e,pt,t),n(e,ne,t),n(e,ct,t),d(se,e,t),n(e,ht,t),n(e,oe,t),n(e,dt,t),d(ae,e,t),n(e,mt,t),n(e,ie,t),n(e,ut,t),n(e,re,t),n(e,Mt,t),d(pe,e,t),n(e,gt,t),n(e,ce,t),n(e,ft,t),n(e,he,t),n(e,wt,t),n(e,de,t),n(e,yt,t),n(e,me,t),n(e,bt,t),n(e,ue,t),n(e,vt,t),d(Me,e,t),n(e,Tt,t),n(e,ge,t),n(e,Ut,t),n(e,fe,t),n(e,jt,t),d(we,e,t),n(e,Jt,t),n(e,ye,t),n(e,Gt,t),n(e,Te,t),xt=!0},p:Tl,i(e){xt||(m(w.$$.fragment,e),m(j.$$.fragment,e),m(C.$$.fragment,e),m(L.$$.fragment,e),m($.$$.fragment,e),m(V.$$.fragment,e),m(te.$$.fragment,e),m(se.$$.fragment,e),m(ae.$$.fragment,e),m(pe.$$.fragment,e),m(Me.$$.fragment,e),m(we.$$.fragment,e),xt=!0)},o(e){u(w.$$.fragment,e),u(j.$$.fragment,e),u(C.$$.fragment,e),u(L.$$.fragment,e),u($.$$.fragment,e),u(V.$$.fragment,e),u(te.$$.fragment,e),u(se.$$.fragment,e),u(ae.$$.fragment,e),u(pe.$$.fragment,e),u(Me.$$.fragment,e),u(we.$$.fragment,e),xt=!1},d(e){e&&(l(Ue),l(ve),l(je),l(Je),l(y),l(Ge),l(b),l(xe),l(v),l(_e),l(T),l(Ce),l(U),l(Ze),l(Ie),l(J),l(Se),l(G),l(ke),l(x),l(Be),l(_),l(Re),l(Le),l(Z),l(We),l(I),l(Ee),l(S),l(Xe),l(k),l(Ae),l(B),l($e),l(R),l(He),l(Qe),l(W),l(ze),l(E),l(Ne),l(X),l(Fe),l(A),l(Ye),l(qe),l(H),l(Ve),l(Q),l(De),l(z),l(Pe),l(N),l(Oe),l(F),l(Ke),l(Y),l(et),l(q),l(tt),l(lt),l(D),l(nt),l(P),l(st),l(O),l(ot),l(K),l(at),l(ee),l(it),l(rt),l(le),l(pt),l(ne),l(ct),l(ht),l(oe),l(dt),l(mt),l(ie),l(ut),l(re),l(Mt),l(gt),l(ce),l(ft),l(he),l(wt),l(de),l(yt),l(me),l(bt),l(ue),l(vt),l(Tt),l(ge),l(Ut),l(fe),l(jt),l(Jt),l(ye),l(Gt),l(Te)),l(g),M(w,e),M(j,e),M(C,e),M(L,e),M($,e),M(V,e),M(te,e),M(se,e),M(ae,e),M(pe,e),M(Me,e),M(we,e)}}}const Cl='{"title":"Godot RL Agents","local":"godot-rl-agents","sections":[{"title":"Create a custom RL environment with Godot RL Agents","local":"create-a-custom-rl-environment-with-godot-rl-agents","sections":[{"title":"Installing the Godot Game Engine","local":"installing-the-godot-game-engine","sections":[],"depth":3},{"title":"Loading the starter project","local":"loading-the-starter-project","sections":[],"depth":3},{"title":"Installing the Godot RL Agents plugin","local":"installing-the-godot-rl-agents-plugin","sections":[],"depth":3},{"title":"Adding the AI controller","local":"adding-the-ai-controller","sections":[],"depth":3},{"title":"There’s more!","local":"theres-more","sections":[],"depth":3}],"depth":2},{"title":"Author","local":"author","sections":[],"depth":2}],"depth":1}';function Zl(Ct){return Ul(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Rl extends jl{constructor(g){super(),Jl(this,g,Zl,_l,vl,{})}}export{Rl as component};
