import{s as hy,f as G,n as jy,o as Iy}from"../chunks/scheduler.37c15a92.js";import{S as uy,i as dy,g as M,s as a,r as y,m as u,H as st,A as Cy,h as p,f as s,c as n,j as d,u as J,x as i,n as C,B as tt,k as h,y as U,a as t,v as w,d as o,t as m,w as T}from"../chunks/index.7cb9c9b8.js";import{C as c}from"../chunks/CodeBlock.a6d3f852.js";import{C as by}from"../chunks/CourseFloatingBanner.2c4a7381.js";import{H as r}from"../chunks/Heading.d3928e2a.js";function fy(pp){let b,it,at,yt,Z,Jt,v,wt,A,ip="Now that we’ve studied the theory behind Reinforce, <strong>you’re ready to code your Reinforce agent with PyTorch</strong>. And you’ll test its robustness using CartPole-v1 and PixelCopter,.",ot,_,yp="You’ll then be able to iterate and improve this implementation for more advanced environments.",mt,f,Jp='<img src="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit6/envs.gif" alt="Environments"/>',Tt,X,wp="To validate this hands-on for the certification process, you need to push your trained models to the Hub and:",rt,W,op="<li>Get a result of &gt;= 350 for <code>Cartpole-v1</code></li> <li>Get a result of &gt;= 5 for <code>PixelCopter</code>.</li>",ct,k,mp="To find your result, go to the leaderboard and find your model, <strong>the result = mean_reward - std of reward</strong>. <strong>If you don’t see your model on the leaderboard, go at the bottom of the leaderboard page and click on the refresh button</strong>.",Ut,S,Tp="<strong>If you don’t find your model, go to the bottom of the page and click on the refresh button.</strong>",ht,H,rp='For more information about the certification process, check this section 👉 <a href="https://huggingface.co/deep-rl-course/en/unit0/introduction#certification-process" rel="nofollow">https://huggingface.co/deep-rl-course/en/unit0/introduction#certification-process</a>',jt,V,cp='And you can check your progress here 👉 <a href="https://huggingface.co/spaces/ThomasSimonini/Check-my-progress-Deep-RL-Course" rel="nofollow">https://huggingface.co/spaces/ThomasSimonini/Check-my-progress-Deep-RL-Course</a>',It,Q,Up="<strong>To start the hands-on click on Open In Colab button</strong> 👇 :",ut,R,hp='<a href="https://colab.research.google.com/github/huggingface/deep-rl-class/blob/master/notebooks/unit4/unit4.ipynb" rel="nofollow"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab"/></a>',dt,$,jp="We strongly <strong>recommend students use Google Colab for the hands-on exercises</strong> instead of running them on their personal computers.",Ct,E,Ip="By using Google Colab, <strong>you can focus on learning and experimenting without worrying about the technical aspects</strong> of setting up your environments.",bt,Y,ft,x,up,Bt,z,dp="In this notebook, you’ll code your first Deep Reinforcement Learning algorithm from scratch: Reinforce (also called Monte Carlo Policy Gradient).",gt,N,Cp="Reinforce is a <em>Policy-based method</em>: a Deep Reinforcement Learning algorithm that tries <strong>to optimize the policy directly without using an action-value function</strong>.",Gt,F,bp="More precisely, Reinforce is a <em>Policy-gradient method</em>, a subclass of <em>Policy-based methods</em> that aims <strong>to optimize the policy directly by estimating the weights of the optimal policy using gradient ascent</strong>.",Zt,L,fp="To test its robustness, we’re going to train it in 2 different simple environments:",vt,q,Bp="<li>Cartpole-v1</li> <li>PixelcopterEnv</li>",At,K,gp="⬇️ Here is an example of what <strong>you will achieve at the end of this notebook.</strong> ⬇️",_t,P,Gp,Xt,D,Wt,O,Zp='<li><a href="https://www.gymlibrary.dev/environments/classic_control/cart_pole/" rel="nofollow">CartPole-v1</a></li> <li><a href="https://pygame-learning-environment.readthedocs.io/en/latest/user/games/pixelcopter.html" rel="nofollow">PixelCopter</a></li>',kt,ll,St,el,vp="<li>Python</li> <li>PyTorch</li>",Ht,sl,Ap='We’re constantly trying to improve our tutorials, so <strong>if you find some issues in this notebook</strong>, please <a href="https://github.com/huggingface/deep-rl-class/issues" rel="nofollow">open an issue on the GitHub Repo</a>.',Vt,tl,Qt,al,_p="At the end of the notebook, you will:",Rt,nl,Xp="<li>Be able to <strong>code a Reinforce algorithm from scratch using PyTorch.</strong></li> <li>Be able to <strong>test the robustness of your agent using simple environments.</strong></li> <li>Be able to <strong>push your trained agent to the Hub</strong> with a nice video replay and an evaluation score 🔥.</li>",$t,Ml,Et,pl,Wp="Before diving into the notebook, you need to:",Yt,il,kp='🔲 📚 <a href="https://huggingface.co/deep-rl-course/unit4/introduction" rel="nofollow">Study Policy Gradients by reading Unit 4</a>',xt,yl,zt,Jl,Nt,wl,Sp="It’s better to run this colab in a copy on your Google Drive, so that <strong>if it times out</strong> you still have the saved notebook on your Google Drive and do not need to fill everything in from scratch.",Ft,ol,Hp="To do that you can either do <code>Ctrl + S</code> or <code>File &gt; Save a copy in Google Drive.</code>",Lt,ml,qt,Tl,Vp="<li>To <strong>accelerate the agent’s training, we’ll use a GPU</strong>. To do that, go to <code>Runtime &gt; Change Runtime type</code></li>",Kt,rl,Qp,Pt,cl,Rp="<li><code>Hardware Accelerator &gt; GPU</code></li>",Dt,Ul,$p,Ot,hl,la,jl,Ep="During the notebook, we’ll need to generate a replay video. To do so, with colab, <strong>we need to have a virtual screen to be able to render the environment</strong> (and thus record the frames).",ea,Il,Yp="The following cell will install the librairies and create and run a virtual screen 🖥",sa,ul,ta,dl,aa,Cl,na,bl,xp="The first step is to install the dependencies. We’ll install multiple ones:",Ma,fl,zp="<li><code>gym</code></li> <li><code>gym-games</code>: Extra gym environments made with PyGame.</li> <li><code>huggingface_hub</code>: The Hub works as a central place where anyone can share and explore models and datasets. It has versioning, metrics, visualizations, and other features that will allow you to easily collaborate with others.</li>",pa,Bl,Np="You may be wondering why we install gym and not gymnasium, a more recent version of gym? <strong>Because the gym-games we are using are not updated yet with gymnasium</strong>.",ia,gl,Fp="The differences you’ll encounter here:",ya,Gl,Lp="<li>In <code>gym</code> we don’t have <code>terminated</code> and <code>truncated</code> but only <code>done</code>.</li> <li>In <code>gym</code> using <code>env.step()</code> returns <code>state, reward, done, info</code></li>",Ja,Zl,qp='You can learn more about the differences between Gym and Gymnasium here 👉 <a href="https://gymnasium.farama.org/content/migration-guide/" rel="nofollow">https://gymnasium.farama.org/content/migration-guide/</a>',wa,vl,Kp='You can see here all the Reinforce models available 👉 <a href="https://huggingface.co/models?other=reinforce" rel="nofollow">https://huggingface.co/models?other=reinforce</a>',oa,Al,Pp='And you can find all the Deep Reinforcement Learning models here 👉 <a href="https://huggingface.co/models?pipeline_tag=reinforcement-learning" rel="nofollow">https://huggingface.co/models?pipeline_tag=reinforcement-learning</a>',ma,_l,Ta,Xl,ra,Wl,Dp="In addition to importing the installed libraries, we also import:",ca,kl,Op="<li><code>imageio</code>: A library that will help us to generate a replay video</li>",Ua,Sl,ha,Hl,ja,Vl,li="<li>Let’s check if we have a GPU</li> <li>If it’s the case you should see <code>device:cuda0</code></li>",Ia,Ql,ua,Rl,da,$l,ei="We’re now ready to implement our Reinforce algorithm 🔥",Ca,El,ba,Yl,fa,xl,Ba,zl,ga,Nl,si='As explained in <a href="https://stable-baselines3.readthedocs.io/en/master/guide/rl_tips.html" rel="nofollow">Reinforcement Learning Tips and Tricks</a>, when you implement your agent from scratch, you need <strong>to be sure that it works correctly and find bugs with easy environments before going deeper</strong> as finding bugs will be much easier in simple environments.',Ga,Fl,ti="<p>Try to have some “sign of life” on toy problems</p>",Za,Ll,ai="<p>Validate the implementation by making it run on harder and harder envs (you can compare results against the RL zoo). You usually need to run hyperparameter optimization for that step.</p>",va,ql,Aa,Kl,ni="<p>A pole is attached by an un-actuated joint to a cart, which moves along a frictionless track. The pendulum is placed upright on the cart and the goal is to balance the pole by applying forces in the left and right direction on the cart.</p>",_a,Pl,Mi="So, we start with CartPole-v1. The goal is to push the cart left or right <strong>so that the pole stays in the equilibrium.</strong>",Xa,Dl,pi="The episode ends if:",Wa,Ol,ii="<li>The pole Angle is greater than ±12°</li> <li>The Cart Position is greater than ±2.4</li> <li>The episode length is greater than 500</li>",ka,le,yi="We get a reward 💰 of +1 every timestep that the Pole stays in the equilibrium.",Sa,ee,Ha,se,Va,te,Qa,ae,Ra,ne,Ji="This implementation is based on three implementations:",$a,Me,wi='<li><a href="https://github.com/pytorch/examples/blob/main/reinforcement_learning/reinforce.py" rel="nofollow">PyTorch official Reinforcement Learning example</a></li> <li><a href="https://github.com/udacity/deep-reinforcement-learning/blob/master/reinforce/REINFORCE.ipynb" rel="nofollow">Udacity Reinforce</a></li> <li><a href="https://github.com/huggingface/deep-rl-class/pull/95" rel="nofollow">Improvement of the integration by Chris1nexus</a></li>',Ea,pe,oi,Ya,ie,mi="So we want:",xa,ye,Ti="<li>Two fully connected layers (fc1 and fc2).</li> <li>To use ReLU as activation function of fc1</li> <li>To use Softmax to output a probability distribution over actions</li>",za,Je,Na,we,Fa,oe,La,me,ri="I made a mistake, can you guess where?",qa,Te,ci="<li>To find out let’s make a forward pass:</li>",Ka,re,Pa,ce,Ui="<li><p>Here we see that the error says <code>ValueError: The value argument to log_prob must be a Tensor</code></p></li> <li><p>It means that <code>action</code> in <code>m.log_prob(action)</code> must be a Tensor <strong>but it’s not.</strong></p></li> <li><p>Do you know why? Check the act function and try to see why it does not work.</p></li>",Da,Ue,hi="Advice 💡: Something is wrong in this implementation. Remember that for the act function <strong>we want to sample an action from the probability distribution over actions</strong>.",Oa,he,ln,je,en,Ie,ji="By using CartPole, it was easier to debug since <strong>we know that the bug comes from our integration and not from our simple environment</strong>.",sn,ue,Ii="<li><p>Since <strong>we want to sample an action from the probability distribution over actions</strong>, we can’t use <code>action = np.argmax(m)</code> since it will always output the action that has the highest probability.</p></li> <li><p>We need to replace this with <code>action = m.sample()</code> which will sample an action from the probability distribution P(.|s)</p></li>",tn,de,an,Ce,ui="This is the Reinforce algorithm pseudocode:",nn,be,di,Mn,fe,Ci='<li><p>When we calculate the return Gt (line 6), we see that we calculate the sum of discounted rewards <strong>starting at timestep t</strong>.</p></li> <li><p>Why? Because our policy should only <strong>reinforce actions on the basis of the consequences</strong>: so rewards obtained before taking an action are useless (since they were not because of the action), <strong>only the ones that come after the action matters</strong>.</p></li> <li><p>Before coding this you should read this section <a href="https://spinningup.openai.com/en/latest/spinningup/rl_intro3.html#don-t-let-the-past-distract-you" rel="nofollow">don’t let the past distract you</a> that explains why we use reward-to-go policy gradient.</p></li>',pn,Be,bi=`We use an interesting technique coded by <a href="https://github.com/Chris1nexus" rel="nofollow">Chris1nexus</a> to <strong>compute the return at each timestep efficiently</strong>. The comments explained the procedure. Don’t hesitate also <a href="https://github.com/huggingface/deep-rl-class/pull/95" rel="nofollow">to check the PR explanation</a>
But overall the idea is to <strong>compute the return at each timestep efficiently</strong>.`,yn,ge,fi="The second question you may ask is <strong>why do we minimize the loss</strong>? Didn’t we talk about Gradient Ascent, not Gradient Descent earlier?",Jn,qs,Ge,FM,Ks,Bi="minimize an objective function.",j,Ps,gi="So let’s say we want to reinforce action 3 at a certain timestep. Before training this action P is 0.25.",LM,B,qM,wn,oy='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>t</mi><mi>h</mi><mi>e</mi><mi>t</mi><mi>a</mi></mrow><annotation encoding="application/x-tex">theta </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6944em;"></span><span class="mord mathnormal">t</span><span class="mord mathnormal">h</span><span class="mord mathnormal">e</span><span class="mord mathnormal">t</span><span class="mord mathnormal">a</span></span></span></span>',on,mn,my='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>π</mi><mi>θ</mi></msub><mo stretchy="false">(</mo><msub><mi>a</mi><mn>3</mn></msub><mi mathvariant="normal">∣</mi><mi>s</mi><mo separator="true">;</mo><mi>θ</mi><mo stretchy="false">)</mo><mo>&gt;</mo><mn>0.25</mn></mrow><annotation encoding="application/x-tex">\\pi_\\theta(a_3|s; \\theta) &gt; 0.25 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.03588em;">π</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:-0.0359em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.02778em;">θ</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal">a</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">3</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mord">∣</span><span class="mord mathnormal">s</span><span class="mpunct">;</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">θ</span><span class="mclose">)</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">&gt;</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">0.25</span></span></span></span>',KM,g,PM,Tn,Ty='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>p</mi><msub><mi>i</mi><mi>θ</mi></msub><mo stretchy="false">(</mo><msub><mi>a</mi><mn>3</mn></msub><mi mathvariant="normal">∣</mi><mi>s</mi><mo separator="true">;</mo><mi>θ</mi><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">pi_\\theta(a_3|s; \\theta)</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord mathnormal">p</span><span class="mord"><span class="mord mathnormal">i</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.02778em;">θ</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal">a</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">3</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mord">∣</span><span class="mord mathnormal">s</span><span class="mpunct">;</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">θ</span><span class="mclose">)</span></span></span></span>',rn,Ds,Gi="minimize other action probability.",DM,Os,OM,Ze,lp,cn,ry='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mn>1</mn><mo>−</mo><msub><mi>π</mi><mi>θ</mi></msub><mo stretchy="false">(</mo><msub><mi>a</mi><mn>3</mn></msub><mi mathvariant="normal">∣</mi><mi>s</mi><mo separator="true">;</mo><mi>θ</mi><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">1 - \\pi_\\theta(a_3|s; \\theta)</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7278em;vertical-align:-0.0833em;"></span><span class="mord">1</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.03588em;">π</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:-0.0359em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.02778em;">θ</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal">a</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">3</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mord">∣</span><span class="mord mathnormal">s</span><span class="mpunct">;</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">θ</span><span class="mclose">)</span></span></span></span>',Un,ep,ve,sp,hn,cy='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>π</mi><mi>θ</mi></msub><mo stretchy="false">(</mo><msub><mi>a</mi><mn>3</mn></msub><mi mathvariant="normal">∣</mi><mi>s</mi><mo separator="true">;</mo><mi>θ</mi><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">\\pi_\\theta(a_3|s; \\theta)</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.03588em;">π</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:-0.0359em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.02778em;">θ</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal">a</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">3</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mord">∣</span><span class="mord mathnormal">s</span><span class="mpunct">;</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">θ</span><span class="mclose">)</span></span></span></span>',jn,tp,lt,ap,In,Uy='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>π</mi><mi>θ</mi></msub><mo stretchy="false">(</mo><msub><mi>a</mi><mn>3</mn></msub><mi mathvariant="normal">∣</mi><mi>s</mi><mo separator="true">;</mo><mi>θ</mi><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">\\pi_\\theta(a_3|s; \\theta)</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.03588em;">π</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:-0.0359em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.02778em;">θ</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal">a</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">3</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mord">∣</span><span class="mord mathnormal">s</span><span class="mpunct">;</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">θ</span><span class="mclose">)</span></span></span></span>',un,Ae,dn,_e,Cn,Xe,bn,We,fn,ke,Zi="<li>We’re now ready to train our agent.</li> <li>But first, we define a variable containing all the training hyperparameters.</li> <li>You can change the training parameters (and should 😉)</li>",Bn,Se,gn,He,Gn,Ve,Zn,Qe,vn,Re,vi="<li>Here we define the evaluation method that we’re going to use to test our Reinforce agent.</li>",An,$e,_n,Ee,Xn,Ye,Wn,xe,kn,ze,Ai="Now that we saw we got good results after the training, we can publish our trained model on the hub 🤗 with one line of code.",Sn,Ne,_i="Here’s an example of a Model Card:",Hn,et,Xi,Vn,Fe,Qn,Le,Rn,qe,$n,Ke,En,Pe,Yn,De,Wi="By using <code>push_to_hub</code>, <strong>you evaluate, record a replay, generate a model card of your agent, and push it to the Hub</strong>.",xn,Oe,ki="This way:",zn,ls,Si='<li>You can <strong>showcase our work</strong> 🔥</li> <li>You can <strong>visualize your agent playing</strong> 👀</li> <li>You can <strong>share an agent with the community that others can use</strong> 💾</li> <li>You can <strong>access a leaderboard 🏆 to see how well your agent is performing compared to your classmates</strong> 👉 <a href="https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard" rel="nofollow">https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard</a></li>',Nn,es,Hi="To be able to share your model with the community there are three more steps to follow:",Fn,ss,Vi='1️⃣ (If it’s not already done) create an account to HF ➡ <a href="https://huggingface.co/join" rel="nofollow">https://huggingface.co/join</a>',Ln,ts,Qi="2️⃣ Sign in and then, you need to store your authentication token from the Hugging Face website.",qn,as,Ri='<li>Create a new token (<a href="https://huggingface.co/settings/tokens" rel="nofollow">https://huggingface.co/settings/tokens</a>) <strong>with write role</strong></li>',Kn,ns,$i,Pn,Ms,Dn,ps,Ei="If you don’t want to use Google Colab or a Jupyter Notebook, you need to use this command instead: <code>huggingface-cli login</code> (or <code>login</code>)",On,is,Yi="3️⃣ We’re now ready to push our trained agent to the 🤗 Hub 🔥 using <code>package_to_hub()</code> function",lM,ys,eM,Js,xi="Now that we tested the robustness of our implementation, let’s try a more complex environment: PixelCopter 🚁",sM,ws,tM,os,aM,ms,zi='<li><a href="https://pygame-learning-environment.readthedocs.io/en/latest/user/games/pixelcopter.html" rel="nofollow">The Environment documentation</a></li>',nM,Ts,MM,rs,pM,cs,iM,Us,Ni="The observation space (7) 👀:",yM,hs,Fi="<li>player y position</li> <li>player velocity</li> <li>player distance to floor</li> <li>player distance to ceiling</li> <li>next block x distance to player</li> <li>next blocks top y location</li> <li>next blocks bottom y location</li>",JM,js,Li="The action space(2) 🎮:",wM,Is,qi="<li>Up (press accelerator)</li> <li>Do nothing (don’t press accelerator)</li>",oM,us,Ki="The reward function 💰:",mM,ds,Pi="<li>For each vertical block it passes, it gains a positive reward of +1. Each time a terminal state is reached it receives a negative reward of -1.</li>",TM,Cs,rM,bs,Di="<li>We need to have a deeper neural network since the environment is more complex</li>",cM,fs,UM,Bs,hM,gs,jM,Gs,IM,Zs,Oi="<li>Because this environment is more complex.</li> <li>Especially for the hidden size, we need more neurons.</li>",uM,vs,dM,As,CM,_s,ly="<li>We’re now ready to train our agent 🔥.</li>",bM,Xs,fM,Ws,BM,ks,gM,Ss,GM,Hs,ZM,Vs,ey="The best way to learn <strong>is to try things on your own</strong>! As you saw, the current agent is not doing great. As a first suggestion, you can train for more steps. But also try to find better parameters.",vM,Qs,sy='In the <a href="https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard" rel="nofollow">Leaderboard</a> you will find your agents. Can you get to the top?',AM,Rs,ty="Here are some ideas to climb up the leaderboard:",_M,$s,ay=`<li>Train more steps</li> <li>Try different hyperparameters by looking at what your classmates have done 👉 <a href="https://huggingface.co/models?other=reinforce" rel="nofollow">https://huggingface.co/models?other=reinforce</a></li> <li><strong>Push your new trained model</strong> on the Hub 🔥</li> <li><strong>Improving the implementation for more complex environments</strong> (for instance, what about changing the network to a Convolutional Neural Network to handle
frames as observation)?</li>`,XM,WM,kM,Es,ny=`<strong>Congrats on finishing this unit</strong>! There was a lot of information.
And congrats on finishing the tutorial. You’ve just coded your first Deep Reinforcement Learning agent from scratch using PyTorch and shared it on the Hub 🥳.`,SM,Ys,My=`Don’t hesitate to iterate on this unit <strong>by improving the implementation for more complex environments</strong> (for instance, what about changing the network to a Convolutional Neural Network to handle
frames as observation)?`,HM,xs,py=`In the next unit, <strong>we’re going to learn more about Unity MLAgents</strong>, by training agents in Unity environments. This way, you will be ready to participate in the <strong>AI vs AI challenges where you’ll train your agents
to compete against other agents in a snowball fight and a soccer game.</strong>`,VM,zs,iy="Sound fun? See you next time!",QM,Ns,yy='Finally, we would love <strong>to hear what you think of the course and how we can improve it</strong>. If you have some feedback then please 👉  <a href="https://forms.gle/BzKXWzLAGZESGNaE9" rel="nofollow">fill this form</a>',RM,Fs,Jy="See you in Unit 5! 🔥",$M,Ls,EM,nt,YM;return Z=new r({props:{title:"Hands on",local:"hands-on",headingTag:"h1"}}),v=new by({props:{classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/deep-rl-class/blob/main/notebooks/unit4/unit4.ipynb"}],askForHelpUrl:"http://hf.co/join/discord"}}),Y=new r({props:{title:"Unit 4: Code your first Deep Reinforcement Learning Algorithm with PyTorch: Reinforce. And test its robustness 💪",local:"unit-4-code-your-first-deep-reinforcement-learning-algorithm-with-pytorch-reinforce-and-test-its-robustness-",headingTag:"h1"}}),D=new r({props:{title:"🎮 Environments:",local:"-environments",headingTag:"h3"}}),ll=new r({props:{title:"📚 RL-Library:",local:"-rl-library",headingTag:"h3"}}),tl=new r({props:{title:"Objectives of this notebook 🏆",local:"objectives-of-this-notebook-",headingTag:"h2"}}),Ml=new r({props:{title:"Prerequisites 🏗️",local:"prerequisites-",headingTag:"h2"}}),yl=new r({props:{title:"Let’s code Reinforce algorithm from scratch 🔥",local:"lets-code-reinforce-algorithm-from-scratch-",headingTag:"h1"}}),Jl=new r({props:{title:"Some advice 💡",local:"some-advice-",headingTag:"h2"}}),ml=new r({props:{title:"Set the GPU 💪",local:"set-the-gpu-",headingTag:"h2"}}),hl=new r({props:{title:"Create a virtual display 🖥",local:"create-a-virtual-display-",headingTag:"h2"}}),ul=new c({props:{code:"JTI1JTI1Y2FwdHVyZSUwQSFhcHQlMjBpbnN0YWxsJTIwcHl0aG9uLW9wZW5nbCUwQSFhcHQlMjBpbnN0YWxsJTIwZmZtcGVnJTBBIWFwdCUyMGluc3RhbGwlMjB4dmZiJTBBIXBpcCUyMGluc3RhbGwlMjBweXZpcnR1YWxkaXNwbGF5JTBBIXBpcCUyMGluc3RhbGwlMjBweWdsZXQlM0QlM0QxLjUuMQ==",highlighted:`%%capture
!apt install python-opengl
!apt install ffmpeg
!apt install xvfb
!pip install pyvirtualdisplay
!pip install pyglet==<span class="hljs-number">1.5</span><span class="hljs-number">.1</span>`,wrap:!1}}),dl=new c({props:{code:"JTIzJTIwVmlydHVhbCUyMGRpc3BsYXklMEFmcm9tJTIwcHl2aXJ0dWFsZGlzcGxheSUyMGltcG9ydCUyMERpc3BsYXklMEElMEF2aXJ0dWFsX2Rpc3BsYXklMjAlM0QlMjBEaXNwbGF5KHZpc2libGUlM0QwJTJDJTIwc2l6ZSUzRCgxNDAwJTJDJTIwOTAwKSklMEF2aXJ0dWFsX2Rpc3BsYXkuc3RhcnQoKQ==",highlighted:`<span class="hljs-comment"># Virtual display</span>
<span class="hljs-keyword">from</span> pyvirtualdisplay <span class="hljs-keyword">import</span> Display

virtual_display = Display(visible=<span class="hljs-number">0</span>, size=(<span class="hljs-number">1400</span>, <span class="hljs-number">900</span>))
virtual_display.start()`,wrap:!1}}),Cl=new r({props:{title:"Install the dependencies 🔽",local:"install-the-dependencies-",headingTag:"h2"}}),_l=new c({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtciUyMGh0dHBzJTNBJTJGJTJGcmF3LmdpdGh1YnVzZXJjb250ZW50LmNvbSUyRmh1Z2dpbmdmYWNlJTJGZGVlcC1ybC1jbGFzcyUyRm1haW4lMkZub3RlYm9va3MlMkZ1bml0NCUyRnJlcXVpcmVtZW50cy11bml0NC50eHQ=",highlighted:"!pip install -r https://raw.githubusercontent.com/huggingface/deep-rl-class/main/notebooks/unit4/requirements-unit4.txt",wrap:!1}}),Xl=new r({props:{title:"Import the packages 📦",local:"import-the-packages-",headingTag:"h2"}}),Sl=new c({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBZnJvbSUyMGNvbGxlY3Rpb25zJTIwaW1wb3J0JTIwZGVxdWUlMEElMEFpbXBvcnQlMjBtYXRwbG90bGliLnB5cGxvdCUyMGFzJTIwcGx0JTBBJTI1bWF0cGxvdGxpYiUyMGlubGluZSUwQSUwQSUyMyUyMFB5VG9yY2glMEFpbXBvcnQlMjB0b3JjaCUwQWltcG9ydCUyMHRvcmNoLm5uJTIwYXMlMjBubiUwQWltcG9ydCUyMHRvcmNoLm5uLmZ1bmN0aW9uYWwlMjBhcyUyMEYlMEFpbXBvcnQlMjB0b3JjaC5vcHRpbSUyMGFzJTIwb3B0aW0lMEFmcm9tJTIwdG9yY2guZGlzdHJpYnV0aW9ucyUyMGltcG9ydCUyMENhdGVnb3JpY2FsJTBBJTBBJTIzJTIwR3ltJTBBaW1wb3J0JTIwZ3ltJTBBaW1wb3J0JTIwZ3ltX3B5Z2FtZSUwQSUwQSUyMyUyMEh1Z2dpbmclMjBGYWNlJTIwSHViJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTIwJTIzJTIwVG8lMjBsb2clMjB0byUyMG91ciUyMEh1Z2dpbmclMjBGYWNlJTIwYWNjb3VudCUyMHRvJTIwYmUlMjBhYmxlJTIwdG8lMjB1cGxvYWQlMjBtb2RlbHMlMjB0byUyMHRoZSUyMEh1Yi4lMEFpbXBvcnQlMjBpbWFnZWlv",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-keyword">from</span> collections <span class="hljs-keyword">import</span> deque

<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt
%matplotlib inline

<span class="hljs-comment"># PyTorch</span>
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn
<span class="hljs-keyword">import</span> torch.nn.functional <span class="hljs-keyword">as</span> F
<span class="hljs-keyword">import</span> torch.optim <span class="hljs-keyword">as</span> optim
<span class="hljs-keyword">from</span> torch.distributions <span class="hljs-keyword">import</span> Categorical

<span class="hljs-comment"># Gym</span>
<span class="hljs-keyword">import</span> gym
<span class="hljs-keyword">import</span> gym_pygame

<span class="hljs-comment"># Hugging Face Hub</span>
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login <span class="hljs-comment"># To log to our Hugging Face account to be able to upload models to the Hub.</span>
<span class="hljs-keyword">import</span> imageio`,wrap:!1}}),Hl=new r({props:{title:"Check if we have a GPU",local:"check-if-we-have-a-gpu",headingTag:"h2"}}),Ql=new c({props:{code:"ZGV2aWNlJTIwJTNEJTIwdG9yY2guZGV2aWNlKCUyMmN1ZGElM0EwJTIyJTIwaWYlMjB0b3JjaC5jdWRhLmlzX2F2YWlsYWJsZSgpJTIwZWxzZSUyMCUyMmNwdSUyMik=",highlighted:'device = torch.device(<span class="hljs-string">&quot;cuda:0&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>)',wrap:!1}}),Rl=new c({props:{code:"cHJpbnQoZGV2aWNlKQ==",highlighted:'<span class="hljs-built_in">print</span>(device)',wrap:!1}}),El=new r({props:{title:"First agent: Playing CartPole-v1 🤖",local:"first-agent-playing-cartpole-v1-",headingTag:"h1"}}),Yl=new r({props:{title:"Create the CartPole environment and understand how it works",local:"create-the-cartpole-environment-and-understand-how-it-works",headingTag:"h2"}}),xl=new r({props:{title:"The environment 🎮",local:"the-environment-",headingTag:"h3"}}),zl=new r({props:{title:"Why do we use a simple environment like CartPole-v1?",local:"why-do-we-use-a-simple-environment-like-cartpole-v1",headingTag:"h3"}}),ql=new r({props:{title:"The CartPole-v1 environment",local:"the-cartpole-v1-environment",headingTag:"h3"}}),ee=new c({props:{code:"ZW52X2lkJTIwJTNEJTIwJTIyQ2FydFBvbGUtdjElMjIlMEElMjMlMjBDcmVhdGUlMjB0aGUlMjBlbnYlMEFlbnYlMjAlM0QlMjBneW0ubWFrZShlbnZfaWQpJTBBJTBBJTIzJTIwQ3JlYXRlJTIwdGhlJTIwZXZhbHVhdGlvbiUyMGVudiUwQWV2YWxfZW52JTIwJTNEJTIwZ3ltLm1ha2UoZW52X2lkKSUwQSUwQSUyMyUyMEdldCUyMHRoZSUyMHN0YXRlJTIwc3BhY2UlMjBhbmQlMjBhY3Rpb24lMjBzcGFjZSUwQXNfc2l6ZSUyMCUzRCUyMGVudi5vYnNlcnZhdGlvbl9zcGFjZS5zaGFwZSU1QjAlNUQlMEFhX3NpemUlMjAlM0QlMjBlbnYuYWN0aW9uX3NwYWNlLm4=",highlighted:`env_id = <span class="hljs-string">&quot;CartPole-v1&quot;</span>
<span class="hljs-comment"># Create the env</span>
env = gym.make(env_id)

<span class="hljs-comment"># Create the evaluation env</span>
eval_env = gym.make(env_id)

<span class="hljs-comment"># Get the state space and action space</span>
s_size = env.observation_space.shape[<span class="hljs-number">0</span>]
a_size = env.action_space.n`,wrap:!1}}),se=new c({props:{code:"cHJpbnQoJTIyX19fX19PQlNFUlZBVElPTiUyMFNQQUNFX19fX18lMjAlNUNuJTIyKSUwQXByaW50KCUyMlRoZSUyMFN0YXRlJTIwU3BhY2UlMjBpcyUzQSUyMCUyMiUyQyUyMHNfc2l6ZSklMEFwcmludCglMjJTYW1wbGUlMjBvYnNlcnZhdGlvbiUyMiUyQyUyMGVudi5vYnNlcnZhdGlvbl9zcGFjZS5zYW1wbGUoKSklMjAlMjAlMjMlMjBHZXQlMjBhJTIwcmFuZG9tJTIwb2JzZXJ2YXRpb24=",highlighted:`<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;_____OBSERVATION SPACE_____ \\n&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;The State Space is: &quot;</span>, s_size)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Sample observation&quot;</span>, env.observation_space.sample())  <span class="hljs-comment"># Get a random observation</span>`,wrap:!1}}),te=new c({props:{code:"cHJpbnQoJTIyJTVDbiUyMF9fX19fQUNUSU9OJTIwU1BBQ0VfX19fXyUyMCU1Q24lMjIpJTBBcHJpbnQoJTIyVGhlJTIwQWN0aW9uJTIwU3BhY2UlMjBpcyUzQSUyMCUyMiUyQyUyMGFfc2l6ZSklMEFwcmludCglMjJBY3Rpb24lMjBTcGFjZSUyMFNhbXBsZSUyMiUyQyUyMGVudi5hY3Rpb25fc3BhY2Uuc2FtcGxlKCkpJTIwJTIwJTIzJTIwVGFrZSUyMGElMjByYW5kb20lMjBhY3Rpb24=",highlighted:`<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\n _____ACTION SPACE_____ \\n&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;The Action Space is: &quot;</span>, a_size)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Action Space Sample&quot;</span>, env.action_space.sample())  <span class="hljs-comment"># Take a random action</span>`,wrap:!1}}),ae=new r({props:{title:"Let’s build the Reinforce Architecture",local:"lets-build-the-reinforce-architecture",headingTag:"h2"}}),Je=new c({props:{code:"Y2xhc3MlMjBQb2xpY3kobm4uTW9kdWxlKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBzX3NpemUlMkMlMjBhX3NpemUlMkMlMjBoX3NpemUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3VwZXIoUG9saWN5JTJDJTIwc2VsZikuX19pbml0X18oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMENyZWF0ZSUyMHR3byUyMGZ1bGx5JTIwY29ubmVjdGVkJTIwbGF5ZXJzJTBBJTBBJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIweCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBEZWZpbmUlMjB0aGUlMjBmb3J3YXJkJTIwcGFzcyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMHN0YXRlJTIwZ29lcyUyMHRvJTIwZmMxJTIwdGhlbiUyMHdlJTIwYXBwbHklMjBSZUxVJTIwYWN0aXZhdGlvbiUyMGZ1bmN0aW9uJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwZmMxJTIwb3V0cHV0cyUyMGdvZXMlMjB0byUyMGZjMiUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFdlJTIwb3V0cHV0JTIwdGhlJTIwc29mdG1heCUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGFjdChzZWxmJTJDJTIwc3RhdGUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwR2l2ZW4lMjBhJTIwc3RhdGUlMkMlMjB0YWtlJTIwYWN0aW9uJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RhdGUlMjAlM0QlMjB0b3JjaC5mcm9tX251bXB5KHN0YXRlKS5mbG9hdCgpLnVuc3F1ZWV6ZSgwKS50byhkZXZpY2UpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJvYnMlMjAlM0QlMjBzZWxmLmZvcndhcmQoc3RhdGUpLmNwdSgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbSUyMCUzRCUyMENhdGVnb3JpY2FsKHByb2JzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFjdGlvbiUyMCUzRCUyMG5wLmFyZ21heChtKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGFjdGlvbi5pdGVtKCklMkMlMjBtLmxvZ19wcm9iKGFjdGlvbik=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">Policy</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, s_size, a_size, h_size</span>):
        <span class="hljs-built_in">super</span>(Policy, self).__init__()
        <span class="hljs-comment"># Create two fully connected layers</span>



    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
        <span class="hljs-comment"># Define the forward pass</span>
        <span class="hljs-comment"># state goes to fc1 then we apply ReLU activation function</span>

        <span class="hljs-comment"># fc1 outputs goes to fc2</span>

        <span class="hljs-comment"># We output the softmax</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">act</span>(<span class="hljs-params">self, state</span>):
        <span class="hljs-string">&quot;&quot;&quot;
        Given a state, take action
        &quot;&quot;&quot;</span>
        state = torch.from_numpy(state).<span class="hljs-built_in">float</span>().unsqueeze(<span class="hljs-number">0</span>).to(device)
        probs = self.forward(state).cpu()
        m = Categorical(probs)
        action = np.argmax(m)
        <span class="hljs-keyword">return</span> action.item(), m.log_prob(action)`,wrap:!1}}),we=new r({props:{title:"Solution",local:"solution",headingTag:"h3"}}),oe=new c({props:{code:"Y2xhc3MlMjBQb2xpY3kobm4uTW9kdWxlKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBzX3NpemUlMkMlMjBhX3NpemUlMkMlMjBoX3NpemUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3VwZXIoUG9saWN5JTJDJTIwc2VsZikuX19pbml0X18oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuZmMxJTIwJTNEJTIwbm4uTGluZWFyKHNfc2l6ZSUyQyUyMGhfc2l6ZSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmZjMiUyMCUzRCUyMG5uLkxpbmVhcihoX3NpemUlMkMlMjBhX3NpemUpJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIweCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB4JTIwJTNEJTIwRi5yZWx1KHNlbGYuZmMxKHgpKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHglMjAlM0QlMjBzZWxmLmZjMih4KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMEYuc29mdG1heCh4JTJDJTIwZGltJTNEMSklMEElMEElMjAlMjAlMjAlMjBkZWYlMjBhY3Qoc2VsZiUyQyUyMHN0YXRlKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN0YXRlJTIwJTNEJTIwdG9yY2guZnJvbV9udW1weShzdGF0ZSkuZmxvYXQoKS51bnNxdWVlemUoMCkudG8oZGV2aWNlKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByb2JzJTIwJTNEJTIwc2VsZi5mb3J3YXJkKHN0YXRlKS5jcHUoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG0lMjAlM0QlMjBDYXRlZ29yaWNhbChwcm9icyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhY3Rpb24lMjAlM0QlMjBucC5hcmdtYXgobSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBhY3Rpb24uaXRlbSgpJTJDJTIwbS5sb2dfcHJvYihhY3Rpb24p",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">Policy</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, s_size, a_size, h_size</span>):
        <span class="hljs-built_in">super</span>(Policy, self).__init__()
        self.fc1 = nn.Linear(s_size, h_size)
        self.fc2 = nn.Linear(h_size, a_size)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
        x = F.relu(self.fc1(x))
        x = self.fc2(x)
        <span class="hljs-keyword">return</span> F.softmax(x, dim=<span class="hljs-number">1</span>)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">act</span>(<span class="hljs-params">self, state</span>):
        state = torch.from_numpy(state).<span class="hljs-built_in">float</span>().unsqueeze(<span class="hljs-number">0</span>).to(device)
        probs = self.forward(state).cpu()
        m = Categorical(probs)
        action = np.argmax(m)
        <span class="hljs-keyword">return</span> action.item(), m.log_prob(action)`,wrap:!1}}),re=new c({props:{code:"ZGVidWdfcG9saWN5JTIwJTNEJTIwUG9saWN5KHNfc2l6ZSUyQyUyMGFfc2l6ZSUyQyUyMDY0KS50byhkZXZpY2UpJTBBZGVidWdfcG9saWN5LmFjdChlbnYucmVzZXQoKSk=",highlighted:`debug_policy = Policy(s_size, a_size, <span class="hljs-number">64</span>).to(device)
debug_policy.act(env.reset())`,wrap:!1}}),he=new r({props:{title:"(Real) Solution",local:"real-solution",headingTag:"h3"}}),je=new c({props:{code:"Y2xhc3MlMjBQb2xpY3kobm4uTW9kdWxlKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBzX3NpemUlMkMlMjBhX3NpemUlMkMlMjBoX3NpemUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3VwZXIoUG9saWN5JTJDJTIwc2VsZikuX19pbml0X18oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuZmMxJTIwJTNEJTIwbm4uTGluZWFyKHNfc2l6ZSUyQyUyMGhfc2l6ZSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmZjMiUyMCUzRCUyMG5uLkxpbmVhcihoX3NpemUlMkMlMjBhX3NpemUpJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIweCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB4JTIwJTNEJTIwRi5yZWx1KHNlbGYuZmMxKHgpKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHglMjAlM0QlMjBzZWxmLmZjMih4KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMEYuc29mdG1heCh4JTJDJTIwZGltJTNEMSklMEElMEElMjAlMjAlMjAlMjBkZWYlMjBhY3Qoc2VsZiUyQyUyMHN0YXRlKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN0YXRlJTIwJTNEJTIwdG9yY2guZnJvbV9udW1weShzdGF0ZSkuZmxvYXQoKS51bnNxdWVlemUoMCkudG8oZGV2aWNlKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByb2JzJTIwJTNEJTIwc2VsZi5mb3J3YXJkKHN0YXRlKS5jcHUoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG0lMjAlM0QlMjBDYXRlZ29yaWNhbChwcm9icyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhY3Rpb24lMjAlM0QlMjBtLnNhbXBsZSgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwYWN0aW9uLml0ZW0oKSUyQyUyMG0ubG9nX3Byb2IoYWN0aW9uKQ==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">Policy</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, s_size, a_size, h_size</span>):
        <span class="hljs-built_in">super</span>(Policy, self).__init__()
        self.fc1 = nn.Linear(s_size, h_size)
        self.fc2 = nn.Linear(h_size, a_size)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
        x = F.relu(self.fc1(x))
        x = self.fc2(x)
        <span class="hljs-keyword">return</span> F.softmax(x, dim=<span class="hljs-number">1</span>)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">act</span>(<span class="hljs-params">self, state</span>):
        state = torch.from_numpy(state).<span class="hljs-built_in">float</span>().unsqueeze(<span class="hljs-number">0</span>).to(device)
        probs = self.forward(state).cpu()
        m = Categorical(probs)
        action = m.sample()
        <span class="hljs-keyword">return</span> action.item(), m.log_prob(action)`,wrap:!1}}),de=new r({props:{title:"Let’s build the Reinforce Training Algorithm",local:"lets-build-the-reinforce-training-algorithm",headingTag:"h3"}}),Ae=new c({props:{code:"ZGVmJTIwcmVpbmZvcmNlKHBvbGljeSUyQyUyMG9wdGltaXplciUyQyUyMG5fdHJhaW5pbmdfZXBpc29kZXMlMkMlMjBtYXhfdCUyQyUyMGdhbW1hJTJDJTIwcHJpbnRfZXZlcnkpJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwSGVscCUyMHVzJTIwdG8lMjBjYWxjdWxhdGUlMjB0aGUlMjBzY29yZSUyMGR1cmluZyUyMHRoZSUyMHRyYWluaW5nJTBBJTIwJTIwJTIwJTIwc2NvcmVzX2RlcXVlJTIwJTNEJTIwZGVxdWUobWF4bGVuJTNEMTAwKSUwQSUyMCUyMCUyMCUyMHNjb3JlcyUyMCUzRCUyMCU1QiU1RCUwQSUyMCUyMCUyMCUyMCUyMyUyMExpbmUlMjAzJTIwb2YlMjBwc2V1ZG9jb2RlJTBBJTIwJTIwJTIwJTIwZm9yJTIwaV9lcGlzb2RlJTIwaW4lMjByYW5nZSgxJTJDJTIwbl90cmFpbmluZ19lcGlzb2RlcyUyQjEpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2F2ZWRfbG9nX3Byb2JzJTIwJTNEJTIwJTVCJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV3YXJkcyUyMCUzRCUyMCU1QiU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN0YXRlJTIwJTNEJTIwJTIzJTIwVE9ETyUzQSUyMHJlc2V0JTIwdGhlJTIwZW52aXJvbm1lbnQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBMaW5lJTIwNCUyMG9mJTIwcHNldWRvY29kZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMHQlMjBpbiUyMHJhbmdlKG1heF90KSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFjdGlvbiUyQyUyMGxvZ19wcm9iJTIwJTNEJTIwJTIzJTIwVE9ETyUyMGdldCUyMHRoZSUyMGFjdGlvbiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNhdmVkX2xvZ19wcm9icy5hcHBlbmQobG9nX3Byb2IpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RhdGUlMkMlMjByZXdhcmQlMkMlMjBkb25lJTJDJTIwXyUyMCUzRCUyMCUyMyUyMFRPRE8lM0ElMjB0YWtlJTIwYW4lMjBlbnYlMjBzdGVwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV3YXJkcy5hcHBlbmQocmV3YXJkKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwZG9uZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJyZWFrJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2NvcmVzX2RlcXVlLmFwcGVuZChzdW0ocmV3YXJkcykpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2NvcmVzLmFwcGVuZChzdW0ocmV3YXJkcykpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwTGluZSUyMDYlMjBvZiUyMHBzZXVkb2NvZGUlM0ElMjBjYWxjdWxhdGUlMjB0aGUlMjByZXR1cm4lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm5zJTIwJTNEJTIwZGVxdWUobWF4bGVuJTNEbWF4X3QpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbl9zdGVwcyUyMCUzRCUyMGxlbihyZXdhcmRzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMENvbXB1dGUlMjB0aGUlMjBkaXNjb3VudGVkJTIwcmV0dXJucyUyMGF0JTIwZWFjaCUyMHRpbWVzdGVwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwYXMlMjB0aGUlMjBzdW0lMjBvZiUyMHRoZSUyMGdhbW1hLWRpc2NvdW50ZWQlMjByZXR1cm4lMjBhdCUyMHRpbWUlMjB0JTIwKEdfdCklMjAlMkIlMjB0aGUlMjByZXdhcmQlMjBhdCUyMHRpbWUlMjB0JTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwSW4lMjBPKE4pJTIwdGltZSUyQyUyMHdoZXJlJTIwTiUyMGlzJTIwdGhlJTIwbnVtYmVyJTIwb2YlMjB0aW1lJTIwc3RlcHMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjAodGhpcyUyMGRlZmluaXRpb24lMjBvZiUyMHRoZSUyMGRpc2NvdW50ZWQlMjByZXR1cm4lMjBHX3QlMjBmb2xsb3dzJTIwdGhlJTIwZGVmaW5pdGlvbiUyMG9mJTIwdGhpcyUyMHF1YW50aXR5JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwc2hvd24lMjBhdCUyMHBhZ2UlMjA0NCUyMG9mJTIwU3V0dG9uJTI2QmFydG8lMjAyMDE3JTIwMm5kJTIwZHJhZnQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwR190JTIwJTNEJTIwcl8odCUyQjEpJTIwJTJCJTIwcl8odCUyQjIpJTIwJTJCJTIwLi4uJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwR2l2ZW4lMjB0aGlzJTIwZm9ybXVsYXRpb24lMkMlMjB0aGUlMjByZXR1cm5zJTIwYXQlMjBlYWNoJTIwdGltZXN0ZXAlMjB0JTIwY2FuJTIwYmUlMjBjb21wdXRlZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMGJ5JTIwcmUtdXNpbmclMjB0aGUlMjBjb21wdXRlZCUyMGZ1dHVyZSUyMHJldHVybnMlMjBHXyh0JTJCMSklMjB0byUyMGNvbXB1dGUlMjB0aGUlMjBjdXJyZW50JTIwcmV0dXJuJTIwR190JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwR190JTIwJTNEJTIwcl8odCUyQjEpJTIwJTJCJTIwZ2FtbWEqR18odCUyQjEpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwR18odC0xKSUyMCUzRCUyMHJfdCUyMCUyQiUyMGdhbW1hKiUyMEdfdCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMCh0aGlzJTIwZm9sbG93cyUyMGElMjBkeW5hbWljJTIwcHJvZ3JhbW1pbmclMjBhcHByb2FjaCUyQyUyMHdpdGglMjB3aGljaCUyMHdlJTIwbWVtb3JpemUlMjBzb2x1dGlvbnMlMjBpbiUyMG9yZGVyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwdG8lMjBhdm9pZCUyMGNvbXB1dGluZyUyMHRoZW0lMjBtdWx0aXBsZSUyMHRpbWVzKSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFRoaXMlMjBpcyUyMGNvcnJlY3QlMjBzaW5jZSUyMHRoZSUyMGFib3ZlJTIwaXMlMjBlcXVpdmFsZW50JTIwdG8lMjAoc2VlJTIwYWxzbyUyMHBhZ2UlMjA0NiUyMG9mJTIwU3V0dG9uJTI2QmFydG8lMjAyMDE3JTIwMm5kJTIwZHJhZnQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwR18odC0xKSUyMCUzRCUyMHJfdCUyMCUyQiUyMGdhbW1hKnJfKHQlMkIxKSUyMCUyQiUyMGdhbW1hKmdhbW1hKnJfKHQlMkIyKSUyMCUyQiUyMC4uLiUwQSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMyUyMEdpdmVuJTIwdGhlJTIwYWJvdmUlMkMlMjB3ZSUyMGNhbGN1bGF0ZSUyMHRoZSUyMHJldHVybnMlMjBhdCUyMHRpbWVzdGVwJTIwdCUyMGFzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZ2FtbWElNUJ0JTVEJTIwKiUyMHJldHVybiU1QnQlNUQlMjAlMkIlMjByZXdhcmQlNUJ0JTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIzJTIwV2UlMjBjb21wdXRlJTIwdGhpcyUyMHN0YXJ0aW5nJTIwZnJvbSUyMHRoZSUyMGxhc3QlMjB0aW1lc3RlcCUyMHRvJTIwdGhlJTIwZmlyc3QlMkMlMjBpbiUyMG9yZGVyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIzJTIwdG8lMjBlbXBsb3klMjB0aGUlMjBmb3JtdWxhJTIwcHJlc2VudGVkJTIwYWJvdmUlMjBhbmQlMjBhdm9pZCUyMHJlZHVuZGFudCUyMGNvbXB1dGF0aW9ucyUyMHRoYXQlMjB3b3VsZCUyMGJlJTIwbmVlZGVkJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIzJTIwaWYlMjB3ZSUyMHdlcmUlMjB0byUyMGRvJTIwaXQlMjBmcm9tJTIwZmlyc3QlMjB0byUyMGxhc3QuJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIzJTIwSGVuY2UlMkMlMjB0aGUlMjBxdWV1ZSUyMCUyMnJldHVybnMlMjIlMjB3aWxsJTIwaG9sZCUyMHRoZSUyMHJldHVybnMlMjBpbiUyMGNocm9ub2xvZ2ljYWwlMjBvcmRlciUyQyUyMGZyb20lMjB0JTNEMCUyMHRvJTIwdCUzRG5fc3RlcHMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjMlMjB0aGFua3MlMjB0byUyMHRoZSUyMGFwcGVuZGxlZnQoKSUyMGZ1bmN0aW9uJTIwd2hpY2glMjBhbGxvd3MlMjB0byUyMGFwcGVuZCUyMHRvJTIwdGhlJTIwcG9zaXRpb24lMjAwJTIwaW4lMjBjb25zdGFudCUyMHRpbWUlMjBPKDEpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIzJTIwYSUyMG5vcm1hbCUyMHB5dGhvbiUyMGxpc3QlMjB3b3VsZCUyMGluc3RlYWQlMjByZXF1aXJlJTIwTyhOKSUyMHRvJTIwZG8lMjB0aGlzLiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMHQlMjBpbiUyMHJhbmdlKG5fc3RlcHMpJTVCJTNBJTNBLTElNUQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkaXNjX3JldHVybl90JTIwJTNEJTIwKHJldHVybnMlNUIwJTVEJTIwaWYlMjBsZW4ocmV0dXJucyklM0UwJTIwZWxzZSUyMDApJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJucy5hcHBlbmRsZWZ0KCUyMCUyMCUyMCUyMCklMjAlMjMlMjBUT0RPJTNBJTIwY29tcGxldGUlMjBoZXJlJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIzJTIwc3RhbmRhcmRpemF0aW9uJTIwb2YlMjB0aGUlMjByZXR1cm5zJTIwaXMlMjBlbXBsb3llZCUyMHRvJTIwbWFrZSUyMHRyYWluaW5nJTIwbW9yZSUyMHN0YWJsZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVwcyUyMCUzRCUyMG5wLmZpbmZvKG5wLmZsb2F0MzIpLmVwcy5pdGVtKCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjMlMjBlcHMlMjBpcyUyMHRoZSUyMHNtYWxsZXN0JTIwcmVwcmVzZW50YWJsZSUyMGZsb2F0JTJDJTIwd2hpY2glMjBpcyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMGFkZGVkJTIwdG8lMjB0aGUlMjBzdGFuZGFyZCUyMGRldmlhdGlvbiUyMG9mJTIwdGhlJTIwcmV0dXJucyUyMHRvJTIwYXZvaWQlMjBudW1lcmljYWwlMjBpbnN0YWJpbGl0aWVzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJucyUyMCUzRCUyMHRvcmNoLnRlbnNvcihyZXR1cm5zKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybnMlMjAlM0QlMjAocmV0dXJucyUyMC0lMjByZXR1cm5zLm1lYW4oKSklMjAlMkYlMjAocmV0dXJucy5zdGQoKSUyMCUyQiUyMGVwcyklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBMaW5lJTIwNyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBvbGljeV9sb3NzJTIwJTNEJTIwJTVCJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm9yJTIwbG9nX3Byb2IlMkMlMjBkaXNjX3JldHVybiUyMGluJTIwemlwKHNhdmVkX2xvZ19wcm9icyUyQyUyMHJldHVybnMpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcG9saWN5X2xvc3MuYXBwZW5kKC1sb2dfcHJvYiUyMColMjBkaXNjX3JldHVybiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwb2xpY3lfbG9zcyUyMCUzRCUyMHRvcmNoLmNhdChwb2xpY3lfbG9zcykuc3VtKCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBMaW5lJTIwOCUzQSUyMFB5VG9yY2glMjBwcmVmZXJzJTIwZ3JhZGllbnQlMjBkZXNjZW50JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnplcm9fZ3JhZCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcG9saWN5X2xvc3MuYmFja3dhcmQoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplci5zdGVwKCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMGlfZXBpc29kZSUyMCUyNSUyMHByaW50X2V2ZXJ5JTIwJTNEJTNEJTIwMCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KCdFcGlzb2RlJTIwJTdCJTdEJTVDdEF2ZXJhZ2UlMjBTY29yZSUzQSUyMCU3QiUzQS4yZiU3RCcuZm9ybWF0KGlfZXBpc29kZSUyQyUyMG5wLm1lYW4oc2NvcmVzX2RlcXVlKSkpJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc2NvcmVz",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">reinforce</span>(<span class="hljs-params">policy, optimizer, n_training_episodes, max_t, gamma, print_every</span>):
    <span class="hljs-comment"># Help us to calculate the score during the training</span>
    scores_deque = deque(maxlen=<span class="hljs-number">100</span>)
    scores = []
    <span class="hljs-comment"># Line 3 of pseudocode</span>
    <span class="hljs-keyword">for</span> i_episode <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">1</span>, n_training_episodes+<span class="hljs-number">1</span>):
        saved_log_probs = []
        rewards = []
        state = <span class="hljs-comment"># <span class="hljs-doctag">TODO:</span> reset the environment</span>
        <span class="hljs-comment"># Line 4 of pseudocode</span>
        <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(max_t):
            action, log_prob = <span class="hljs-comment"># TODO get the action</span>
            saved_log_probs.append(log_prob)
            state, reward, done, _ = <span class="hljs-comment"># <span class="hljs-doctag">TODO:</span> take an env step</span>
            rewards.append(reward)
            <span class="hljs-keyword">if</span> done:
                <span class="hljs-keyword">break</span>
        scores_deque.append(<span class="hljs-built_in">sum</span>(rewards))
        scores.append(<span class="hljs-built_in">sum</span>(rewards))

        <span class="hljs-comment"># Line 6 of pseudocode: calculate the return</span>
        returns = deque(maxlen=max_t)
        n_steps = <span class="hljs-built_in">len</span>(rewards)
        <span class="hljs-comment"># Compute the discounted returns at each timestep,</span>
        <span class="hljs-comment"># as the sum of the gamma-discounted return at time t (G_t) + the reward at time t</span>

        <span class="hljs-comment"># In O(N) time, where N is the number of time steps</span>
        <span class="hljs-comment"># (this definition of the discounted return G_t follows the definition of this quantity</span>
        <span class="hljs-comment"># shown at page 44 of Sutton&amp;Barto 2017 2nd draft)</span>
        <span class="hljs-comment"># G_t = r_(t+1) + r_(t+2) + ...</span>

        <span class="hljs-comment"># Given this formulation, the returns at each timestep t can be computed</span>
        <span class="hljs-comment"># by re-using the computed future returns G_(t+1) to compute the current return G_t</span>
        <span class="hljs-comment"># G_t = r_(t+1) + gamma*G_(t+1)</span>
        <span class="hljs-comment"># G_(t-1) = r_t + gamma* G_t</span>
        <span class="hljs-comment"># (this follows a dynamic programming approach, with which we memorize solutions in order</span>
        <span class="hljs-comment"># to avoid computing them multiple times)</span>

        <span class="hljs-comment"># This is correct since the above is equivalent to (see also page 46 of Sutton&amp;Barto 2017 2nd draft)</span>
        <span class="hljs-comment"># G_(t-1) = r_t + gamma*r_(t+1) + gamma*gamma*r_(t+2) + ...</span>


        <span class="hljs-comment">## Given the above, we calculate the returns at timestep t as:</span>
        <span class="hljs-comment">#               gamma[t] * return[t] + reward[t]</span>
        <span class="hljs-comment">#</span>
        <span class="hljs-comment">## We compute this starting from the last timestep to the first, in order</span>
        <span class="hljs-comment">## to employ the formula presented above and avoid redundant computations that would be needed</span>
        <span class="hljs-comment">## if we were to do it from first to last.</span>

        <span class="hljs-comment">## Hence, the queue &quot;returns&quot; will hold the returns in chronological order, from t=0 to t=n_steps</span>
        <span class="hljs-comment">## thanks to the appendleft() function which allows to append to the position 0 in constant time O(1)</span>
        <span class="hljs-comment">## a normal python list would instead require O(N) to do this.</span>
        <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(n_steps)[::-<span class="hljs-number">1</span>]:
            disc_return_t = (returns[<span class="hljs-number">0</span>] <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(returns)&gt;<span class="hljs-number">0</span> <span class="hljs-keyword">else</span> <span class="hljs-number">0</span>)
            returns.appendleft(    ) <span class="hljs-comment"># <span class="hljs-doctag">TODO:</span> complete here</span>

        <span class="hljs-comment">## standardization of the returns is employed to make training more stable</span>
        eps = np.finfo(np.float32).eps.item()

        <span class="hljs-comment">## eps is the smallest representable float, which is</span>
        <span class="hljs-comment"># added to the standard deviation of the returns to avoid numerical instabilities</span>
        returns = torch.tensor(returns)
        returns = (returns - returns.mean()) / (returns.std() + eps)

        <span class="hljs-comment"># Line 7:</span>
        policy_loss = []
        <span class="hljs-keyword">for</span> log_prob, disc_return <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(saved_log_probs, returns):
            policy_loss.append(-log_prob * disc_return)
        policy_loss = torch.cat(policy_loss).<span class="hljs-built_in">sum</span>()

        <span class="hljs-comment"># Line 8: PyTorch prefers gradient descent</span>
        optimizer.zero_grad()
        policy_loss.backward()
        optimizer.step()

        <span class="hljs-keyword">if</span> i_episode % print_every == <span class="hljs-number">0</span>:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27;Episode {}\\tAverage Score: {:.2f}&#x27;</span>.<span class="hljs-built_in">format</span>(i_episode, np.mean(scores_deque)))

    <span class="hljs-keyword">return</span> scores`,wrap:!1}}),_e=new r({props:{title:"Solution",local:"solution",headingTag:"h4"}}),Xe=new c({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">reinforce</span>(<span class="hljs-params">policy, optimizer, n_training_episodes, max_t, gamma, print_every</span>):
    <span class="hljs-comment"># Help us to calculate the score during the training</span>
    scores_deque = deque(maxlen=<span class="hljs-number">100</span>)
    scores = []
    <span class="hljs-comment"># Line 3 of pseudocode</span>
    <span class="hljs-keyword">for</span> i_episode <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">1</span>, n_training_episodes + <span class="hljs-number">1</span>):
        saved_log_probs = []
        rewards = []
        state = env.reset()
        <span class="hljs-comment"># Line 4 of pseudocode</span>
        <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(max_t):
            action, log_prob = policy.act(state)
            saved_log_probs.append(log_prob)
            state, reward, done, _ = env.step(action)
            rewards.append(reward)
            <span class="hljs-keyword">if</span> done:
                <span class="hljs-keyword">break</span>
        scores_deque.append(<span class="hljs-built_in">sum</span>(rewards))
        scores.append(<span class="hljs-built_in">sum</span>(rewards))

        <span class="hljs-comment"># Line 6 of pseudocode: calculate the return</span>
        returns = deque(maxlen=max_t)
        n_steps = <span class="hljs-built_in">len</span>(rewards)
        <span class="hljs-comment"># Compute the discounted returns at each timestep,</span>
        <span class="hljs-comment"># as</span>
        <span class="hljs-comment">#      the sum of the gamma-discounted return at time t (G_t) + the reward at time t</span>
        <span class="hljs-comment">#</span>
        <span class="hljs-comment"># In O(N) time, where N is the number of time steps</span>
        <span class="hljs-comment"># (this definition of the discounted return G_t follows the definition of this quantity</span>
        <span class="hljs-comment"># shown at page 44 of Sutton&amp;Barto 2017 2nd draft)</span>
        <span class="hljs-comment"># G_t = r_(t+1) + r_(t+2) + ...</span>

        <span class="hljs-comment"># Given this formulation, the returns at each timestep t can be computed</span>
        <span class="hljs-comment"># by re-using the computed future returns G_(t+1) to compute the current return G_t</span>
        <span class="hljs-comment"># G_t = r_(t+1) + gamma*G_(t+1)</span>
        <span class="hljs-comment"># G_(t-1) = r_t + gamma* G_t</span>
        <span class="hljs-comment"># (this follows a dynamic programming approach, with which we memorize solutions in order</span>
        <span class="hljs-comment"># to avoid computing them multiple times)</span>

        <span class="hljs-comment"># This is correct since the above is equivalent to (see also page 46 of Sutton&amp;Barto 2017 2nd draft)</span>
        <span class="hljs-comment"># G_(t-1) = r_t + gamma*r_(t+1) + gamma*gamma*r_(t+2) + ...</span>

        <span class="hljs-comment">## Given the above, we calculate the returns at timestep t as:</span>
        <span class="hljs-comment">#               gamma[t] * return[t] + reward[t]</span>
        <span class="hljs-comment">#</span>
        <span class="hljs-comment">## We compute this starting from the last timestep to the first, in order</span>
        <span class="hljs-comment">## to employ the formula presented above and avoid redundant computations that would be needed</span>
        <span class="hljs-comment">## if we were to do it from first to last.</span>

        <span class="hljs-comment">## Hence, the queue &quot;returns&quot; will hold the returns in chronological order, from t=0 to t=n_steps</span>
        <span class="hljs-comment">## thanks to the appendleft() function which allows to append to the position 0 in constant time O(1)</span>
        <span class="hljs-comment">## a normal python list would instead require O(N) to do this.</span>
        <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(n_steps)[::-<span class="hljs-number">1</span>]:
            disc_return_t = returns[<span class="hljs-number">0</span>] <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(returns) &gt; <span class="hljs-number">0</span> <span class="hljs-keyword">else</span> <span class="hljs-number">0</span>
            returns.appendleft(gamma * disc_return_t + rewards[t])

        <span class="hljs-comment">## standardization of the returns is employed to make training more stable</span>
        eps = np.finfo(np.float32).eps.item()
        <span class="hljs-comment">## eps is the smallest representable float, which is</span>
        <span class="hljs-comment"># added to the standard deviation of the returns to avoid numerical instabilities</span>
        returns = torch.tensor(returns)
        returns = (returns - returns.mean()) / (returns.std() + eps)

        <span class="hljs-comment"># Line 7:</span>
        policy_loss = []
        <span class="hljs-keyword">for</span> log_prob, disc_return <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(saved_log_probs, returns):
            policy_loss.append(-log_prob * disc_return)
        policy_loss = torch.cat(policy_loss).<span class="hljs-built_in">sum</span>()

        <span class="hljs-comment"># Line 8: PyTorch prefers gradient descent</span>
        optimizer.zero_grad()
        policy_loss.backward()
        optimizer.step()

        <span class="hljs-keyword">if</span> i_episode % print_every == <span class="hljs-number">0</span>:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Episode {}\\tAverage Score: {:.2f}&quot;</span>.<span class="hljs-built_in">format</span>(i_episode, np.mean(scores_deque)))

    <span class="hljs-keyword">return</span> scores`,wrap:!1}}),We=new r({props:{title:"Train it",local:"train-it",headingTag:"h2"}}),Se=new c({props:{code:"Y2FydHBvbGVfaHlwZXJwYXJhbWV0ZXJzJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyaF9zaXplJTIyJTNBJTIwMTYlMkMlMEElMjAlMjAlMjAlMjAlMjJuX3RyYWluaW5nX2VwaXNvZGVzJTIyJTNBJTIwMTAwMCUyQyUwQSUyMCUyMCUyMCUyMCUyMm5fZXZhbHVhdGlvbl9lcGlzb2RlcyUyMiUzQSUyMDEwJTJDJTBBJTIwJTIwJTIwJTIwJTIybWF4X3QlMjIlM0ElMjAxMDAwJTJDJTBBJTIwJTIwJTIwJTIwJTIyZ2FtbWElMjIlM0ElMjAxLjAlMkMlMEElMjAlMjAlMjAlMjAlMjJsciUyMiUzQSUyMDFlLTIlMkMlMEElMjAlMjAlMjAlMjAlMjJlbnZfaWQlMjIlM0ElMjBlbnZfaWQlMkMlMEElMjAlMjAlMjAlMjAlMjJzdGF0ZV9zcGFjZSUyMiUzQSUyMHNfc2l6ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMmFjdGlvbl9zcGFjZSUyMiUzQSUyMGFfc2l6ZSUyQyUwQSU3RA==",highlighted:`cartpole_hyperparameters = {
    <span class="hljs-string">&quot;h_size&quot;</span>: <span class="hljs-number">16</span>,
    <span class="hljs-string">&quot;n_training_episodes&quot;</span>: <span class="hljs-number">1000</span>,
    <span class="hljs-string">&quot;n_evaluation_episodes&quot;</span>: <span class="hljs-number">10</span>,
    <span class="hljs-string">&quot;max_t&quot;</span>: <span class="hljs-number">1000</span>,
    <span class="hljs-string">&quot;gamma&quot;</span>: <span class="hljs-number">1.0</span>,
    <span class="hljs-string">&quot;lr&quot;</span>: <span class="hljs-number">1e-2</span>,
    <span class="hljs-string">&quot;env_id&quot;</span>: env_id,
    <span class="hljs-string">&quot;state_space&quot;</span>: s_size,
    <span class="hljs-string">&quot;action_space&quot;</span>: a_size,
}`,wrap:!1}}),He=new c({props:{code:"JTIzJTIwQ3JlYXRlJTIwcG9saWN5JTIwYW5kJTIwcGxhY2UlMjBpdCUyMHRvJTIwdGhlJTIwZGV2aWNlJTBBY2FydHBvbGVfcG9saWN5JTIwJTNEJTIwUG9saWN5KCUwQSUyMCUyMCUyMCUyMGNhcnRwb2xlX2h5cGVycGFyYW1ldGVycyU1QiUyMnN0YXRlX3NwYWNlJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwY2FydHBvbGVfaHlwZXJwYXJhbWV0ZXJzJTVCJTIyYWN0aW9uX3NwYWNlJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwY2FydHBvbGVfaHlwZXJwYXJhbWV0ZXJzJTVCJTIyaF9zaXplJTIyJTVEJTJDJTBBKS50byhkZXZpY2UpJTBBY2FydHBvbGVfb3B0aW1pemVyJTIwJTNEJTIwb3B0aW0uQWRhbShjYXJ0cG9sZV9wb2xpY3kucGFyYW1ldGVycygpJTJDJTIwbHIlM0RjYXJ0cG9sZV9oeXBlcnBhcmFtZXRlcnMlNUIlMjJsciUyMiU1RCk=",highlighted:`<span class="hljs-comment"># Create policy and place it to the device</span>
cartpole_policy = Policy(
    cartpole_hyperparameters[<span class="hljs-string">&quot;state_space&quot;</span>],
    cartpole_hyperparameters[<span class="hljs-string">&quot;action_space&quot;</span>],
    cartpole_hyperparameters[<span class="hljs-string">&quot;h_size&quot;</span>],
).to(device)
cartpole_optimizer = optim.Adam(cartpole_policy.parameters(), lr=cartpole_hyperparameters[<span class="hljs-string">&quot;lr&quot;</span>])`,wrap:!1}}),Ve=new c({props:{code:"c2NvcmVzJTIwJTNEJTIwcmVpbmZvcmNlKCUwQSUyMCUyMCUyMCUyMGNhcnRwb2xlX3BvbGljeSUyQyUwQSUyMCUyMCUyMCUyMGNhcnRwb2xlX29wdGltaXplciUyQyUwQSUyMCUyMCUyMCUyMGNhcnRwb2xlX2h5cGVycGFyYW1ldGVycyU1QiUyMm5fdHJhaW5pbmdfZXBpc29kZXMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBjYXJ0cG9sZV9oeXBlcnBhcmFtZXRlcnMlNUIlMjJtYXhfdCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGNhcnRwb2xlX2h5cGVycGFyYW1ldGVycyU1QiUyMmdhbW1hJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwMTAwJTJDJTBBKQ==",highlighted:`scores = reinforce(
    cartpole_policy,
    cartpole_optimizer,
    cartpole_hyperparameters[<span class="hljs-string">&quot;n_training_episodes&quot;</span>],
    cartpole_hyperparameters[<span class="hljs-string">&quot;max_t&quot;</span>],
    cartpole_hyperparameters[<span class="hljs-string">&quot;gamma&quot;</span>],
    <span class="hljs-number">100</span>,
)`,wrap:!1}}),Qe=new r({props:{title:"Define evaluation method 📝",local:"define-evaluation-method-",headingTag:"h2"}}),$e=new c({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">evaluate_agent</span>(<span class="hljs-params">env, max_steps, n_eval_episodes, policy</span>):
    <span class="hljs-string">&quot;&quot;&quot;
    Evaluate the agent for \`\`n_eval_episodes\`\` episodes and returns average reward and std of reward.
    :param env: The evaluation environment
    :param n_eval_episodes: Number of episode to evaluate the agent
    :param policy: The Reinforce agent
    &quot;&quot;&quot;</span>
    episode_rewards = []
    <span class="hljs-keyword">for</span> episode <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(n_eval_episodes):
        state = env.reset()
        step = <span class="hljs-number">0</span>
        done = <span class="hljs-literal">False</span>
        total_rewards_ep = <span class="hljs-number">0</span>

        <span class="hljs-keyword">for</span> step <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(max_steps):
            action, _ = policy.act(state)
            new_state, reward, done, info = env.step(action)
            total_rewards_ep += reward

            <span class="hljs-keyword">if</span> done:
                <span class="hljs-keyword">break</span>
            state = new_state
        episode_rewards.append(total_rewards_ep)
    mean_reward = np.mean(episode_rewards)
    std_reward = np.std(episode_rewards)

    <span class="hljs-keyword">return</span> mean_reward, std_reward`,wrap:!1}}),Ee=new r({props:{title:"Evaluate our agent 📈",local:"evaluate-our-agent-",headingTag:"h2"}}),Ye=new c({props:{code:"ZXZhbHVhdGVfYWdlbnQoJTBBJTIwJTIwJTIwJTIwZXZhbF9lbnYlMkMlMjBjYXJ0cG9sZV9oeXBlcnBhcmFtZXRlcnMlNUIlMjJtYXhfdCUyMiU1RCUyQyUyMGNhcnRwb2xlX2h5cGVycGFyYW1ldGVycyU1QiUyMm5fZXZhbHVhdGlvbl9lcGlzb2RlcyUyMiU1RCUyQyUyMGNhcnRwb2xlX3BvbGljeSUwQSk=",highlighted:`evaluate_agent(
    eval_env, cartpole_hyperparameters[<span class="hljs-string">&quot;max_t&quot;</span>], cartpole_hyperparameters[<span class="hljs-string">&quot;n_evaluation_episodes&quot;</span>], cartpole_policy
)`,wrap:!1}}),xe=new r({props:{title:"Publish our trained model on the Hub 🔥",local:"publish-our-trained-model-on-the-hub-",headingTag:"h3"}}),Fe=new r({props:{title:"Push to the Hub",local:"push-to-the-hub",headingTag:"h3"}}),Le=new r({props:{title:"Do not modify this code",local:"do-not-modify-this-code",headingTag:"h4"}}),qe=new c({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTJDJTIwc25hcHNob3RfZG93bmxvYWQlMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViLnJlcG9jYXJkJTIwaW1wb3J0JTIwbWV0YWRhdGFfZXZhbF9yZXN1bHQlMkMlMjBtZXRhZGF0YV9zYXZlJTBBJTBBZnJvbSUyMHBhdGhsaWIlMjBpbXBvcnQlMjBQYXRoJTBBaW1wb3J0JTIwZGF0ZXRpbWUlMEFpbXBvcnQlMjBqc29uJTBBaW1wb3J0JTIwaW1hZ2VpbyUwQSUwQWltcG9ydCUyMHRlbXBmaWxlJTBBJTBBaW1wb3J0JTIwb3M=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi, snapshot_download
<span class="hljs-keyword">from</span> huggingface_hub.repocard <span class="hljs-keyword">import</span> metadata_eval_result, metadata_save

<span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-keyword">import</span> datetime
<span class="hljs-keyword">import</span> json
<span class="hljs-keyword">import</span> imageio

<span class="hljs-keyword">import</span> tempfile

<span class="hljs-keyword">import</span> os`,wrap:!1}}),Ke=new c({props:{code:"ZGVmJTIwcmVjb3JkX3ZpZGVvKGVudiUyQyUyMHBvbGljeSUyQyUyMG91dF9kaXJlY3RvcnklMkMlMjBmcHMlM0QzMCklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBHZW5lcmF0ZSUyMGElMjByZXBsYXklMjB2aWRlbyUyMG9mJTIwdGhlJTIwYWdlbnQlMEElMjAlMjAlMjAlMjAlM0FwYXJhbSUyMGVudiUwQSUyMCUyMCUyMCUyMCUzQXBhcmFtJTIwUXRhYmxlJTNBJTIwUXRhYmxlJTIwb2YlMjBvdXIlMjBhZ2VudCUwQSUyMCUyMCUyMCUyMCUzQXBhcmFtJTIwb3V0X2RpcmVjdG9yeSUwQSUyMCUyMCUyMCUyMCUzQXBhcmFtJTIwZnBzJTNBJTIwaG93JTIwbWFueSUyMGZyYW1lJTIwcGVyJTIwc2Vjb25kcyUyMCh3aXRoJTIwdGF4aS12MyUyMGFuZCUyMGZyb3plbmxha2UtdjElMjB3ZSUyMHVzZSUyMDEpJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwaW1hZ2VzJTIwJTNEJTIwJTVCJTVEJTBBJTIwJTIwJTIwJTIwZG9uZSUyMCUzRCUyMEZhbHNlJTBBJTIwJTIwJTIwJTIwc3RhdGUlMjAlM0QlMjBlbnYucmVzZXQoKSUwQSUyMCUyMCUyMCUyMGltZyUyMCUzRCUyMGVudi5yZW5kZXIobW9kZSUzRCUyMnJnYl9hcnJheSUyMiklMEElMjAlMjAlMjAlMjBpbWFnZXMuYXBwZW5kKGltZyklMEElMjAlMjAlMjAlMjB3aGlsZSUyMG5vdCUyMGRvbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBUYWtlJTIwdGhlJTIwYWN0aW9uJTIwKGluZGV4KSUyMHRoYXQlMjBoYXZlJTIwdGhlJTIwbWF4aW11bSUyMGV4cGVjdGVkJTIwZnV0dXJlJTIwcmV3YXJkJTIwZ2l2ZW4lMjB0aGF0JTIwc3RhdGUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhY3Rpb24lMkMlMjBfJTIwJTNEJTIwcG9saWN5LmFjdChzdGF0ZSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGF0ZSUyQyUyMHJld2FyZCUyQyUyMGRvbmUlMkMlMjBpbmZvJTIwJTNEJTIwZW52LnN0ZXAoYWN0aW9uKSUyMCUyMCUyMyUyMFdlJTIwZGlyZWN0bHklMjBwdXQlMjBuZXh0X3N0YXRlJTIwJTNEJTIwc3RhdGUlMjBmb3IlMjByZWNvcmRpbmclMjBsb2dpYyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGltZyUyMCUzRCUyMGVudi5yZW5kZXIobW9kZSUzRCUyMnJnYl9hcnJheSUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbWFnZXMuYXBwZW5kKGltZyklMEElMjAlMjAlMjAlMjBpbWFnZWlvLm1pbXNhdmUob3V0X2RpcmVjdG9yeSUyQyUyMCU1Qm5wLmFycmF5KGltZyklMjBmb3IlMjBpJTJDJTIwaW1nJTIwaW4lMjBlbnVtZXJhdGUoaW1hZ2VzKSU1RCUyQyUyMGZwcyUzRGZwcyk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">record_video</span>(<span class="hljs-params">env, policy, out_directory, fps=<span class="hljs-number">30</span></span>):
    <span class="hljs-string">&quot;&quot;&quot;
    Generate a replay video of the agent
    :param env
    :param Qtable: Qtable of our agent
    :param out_directory
    :param fps: how many frame per seconds (with taxi-v3 and frozenlake-v1 we use 1)
    &quot;&quot;&quot;</span>
    images = []
    done = <span class="hljs-literal">False</span>
    state = env.reset()
    img = env.render(mode=<span class="hljs-string">&quot;rgb_array&quot;</span>)
    images.append(img)
    <span class="hljs-keyword">while</span> <span class="hljs-keyword">not</span> done:
        <span class="hljs-comment"># Take the action (index) that have the maximum expected future reward given that state</span>
        action, _ = policy.act(state)
        state, reward, done, info = env.step(action)  <span class="hljs-comment"># We directly put next_state = state for recording logic</span>
        img = env.render(mode=<span class="hljs-string">&quot;rgb_array&quot;</span>)
        images.append(img)
    imageio.mimsave(out_directory, [np.array(img) <span class="hljs-keyword">for</span> i, img <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(images)], fps=fps)`,wrap:!1}}),Pe=new c({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">push_to_hub</span>(<span class="hljs-params">repo_id,
                model,
                hyperparameters,
                eval_env,
                video_fps=<span class="hljs-number">30</span>
                </span>):
  <span class="hljs-string">&quot;&quot;&quot;
  Evaluate, Generate a video and Upload a model to Hugging Face Hub.
  This method does the complete pipeline:
  - It evaluates the model
  - It generates the model card
  - It generates a replay video of the agent
  - It pushes everything to the Hub

  :param repo_id: repo_id: id of the model repository from the Hugging Face Hub
  :param model: the pytorch model we want to save
  :param hyperparameters: training hyperparameters
  :param eval_env: evaluation environment
  :param video_fps: how many frame per seconds to record our video replay
  &quot;&quot;&quot;</span>

  _, repo_name = repo_id.split(<span class="hljs-string">&quot;/&quot;</span>)
  api = HfApi()

  <span class="hljs-comment"># Step 1: Create the repo</span>
  repo_url = api.create_repo(
        repo_id=repo_id,
        exist_ok=<span class="hljs-literal">True</span>,
  )

  <span class="hljs-keyword">with</span> tempfile.TemporaryDirectory() <span class="hljs-keyword">as</span> tmpdirname:
    local_directory = Path(tmpdirname)

    <span class="hljs-comment"># Step 2: Save the model</span>
    torch.save(model, local_directory / <span class="hljs-string">&quot;model.pt&quot;</span>)

    <span class="hljs-comment"># Step 3: Save the hyperparameters to JSON</span>
    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(local_directory / <span class="hljs-string">&quot;hyperparameters.json&quot;</span>, <span class="hljs-string">&quot;w&quot;</span>) <span class="hljs-keyword">as</span> outfile:
      json.dump(hyperparameters, outfile)

    <span class="hljs-comment"># Step 4: Evaluate the model and build JSON</span>
    mean_reward, std_reward = evaluate_agent(eval_env,
                                            hyperparameters[<span class="hljs-string">&quot;max_t&quot;</span>],
                                            hyperparameters[<span class="hljs-string">&quot;n_evaluation_episodes&quot;</span>],
                                            model)
    <span class="hljs-comment"># Get datetime</span>
    eval_datetime = datetime.datetime.now()
    eval_form_datetime = eval_datetime.isoformat()

    evaluate_data = {
          <span class="hljs-string">&quot;env_id&quot;</span>: hyperparameters[<span class="hljs-string">&quot;env_id&quot;</span>],
          <span class="hljs-string">&quot;mean_reward&quot;</span>: mean_reward,
          <span class="hljs-string">&quot;n_evaluation_episodes&quot;</span>: hyperparameters[<span class="hljs-string">&quot;n_evaluation_episodes&quot;</span>],
          <span class="hljs-string">&quot;eval_datetime&quot;</span>: eval_form_datetime,
    }

    <span class="hljs-comment"># Write a JSON file</span>
    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(local_directory / <span class="hljs-string">&quot;results.json&quot;</span>, <span class="hljs-string">&quot;w&quot;</span>) <span class="hljs-keyword">as</span> outfile:
        json.dump(evaluate_data, outfile)

    <span class="hljs-comment"># Step 5: Create the model card</span>
    env_name = hyperparameters[<span class="hljs-string">&quot;env_id&quot;</span>]

    metadata = {}
    metadata[<span class="hljs-string">&quot;tags&quot;</span>] = [
          env_name,
          <span class="hljs-string">&quot;reinforce&quot;</span>,
          <span class="hljs-string">&quot;reinforcement-learning&quot;</span>,
          <span class="hljs-string">&quot;custom-implementation&quot;</span>,
          <span class="hljs-string">&quot;deep-rl-class&quot;</span>
      ]

    <span class="hljs-comment"># Add metrics</span>
    <span class="hljs-built_in">eval</span> = metadata_eval_result(
        model_pretty_name=repo_name,
        task_pretty_name=<span class="hljs-string">&quot;reinforcement-learning&quot;</span>,
        task_id=<span class="hljs-string">&quot;reinforcement-learning&quot;</span>,
        metrics_pretty_name=<span class="hljs-string">&quot;mean_reward&quot;</span>,
        metrics_id=<span class="hljs-string">&quot;mean_reward&quot;</span>,
        metrics_value=<span class="hljs-string">f&quot;<span class="hljs-subst">{mean_reward:<span class="hljs-number">.2</span>f}</span> +/- <span class="hljs-subst">{std_reward:<span class="hljs-number">.2</span>f}</span>&quot;</span>,
        dataset_pretty_name=env_name,
        dataset_id=env_name,
      )

    <span class="hljs-comment"># Merges both dictionaries</span>
    metadata = {**metadata, **<span class="hljs-built_in">eval</span>}

    model_card = <span class="hljs-string">f&quot;&quot;&quot;
  # **Reinforce** Agent playing **<span class="hljs-subst">{env_id}</span>**
  This is a trained model of a **Reinforce** agent playing **<span class="hljs-subst">{env_id}</span>** .
  To learn to use this model and train yours check Unit 4 of the Deep Reinforcement Learning Course: https://huggingface.co/deep-rl-course/unit4/introduction
  &quot;&quot;&quot;</span>

    readme_path = local_directory / <span class="hljs-string">&quot;README.md&quot;</span>
    readme = <span class="hljs-string">&quot;&quot;</span>
    <span class="hljs-keyword">if</span> readme_path.exists():
        <span class="hljs-keyword">with</span> readme_path.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;r&quot;</span>, encoding=<span class="hljs-string">&quot;utf8&quot;</span>) <span class="hljs-keyword">as</span> f:
          readme = f.read()
    <span class="hljs-keyword">else</span>:
      readme = model_card

    <span class="hljs-keyword">with</span> readme_path.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;w&quot;</span>, encoding=<span class="hljs-string">&quot;utf-8&quot;</span>) <span class="hljs-keyword">as</span> f:
      f.write(readme)

    <span class="hljs-comment"># Save our metrics to Readme metadata</span>
    metadata_save(readme_path, metadata)

    <span class="hljs-comment"># Step 6: Record a video</span>
    video_path =  local_directory / <span class="hljs-string">&quot;replay.mp4&quot;</span>
    record_video(env, model, video_path, video_fps)

    <span class="hljs-comment"># Step 7. Push everything to the Hub</span>
    api.upload_folder(
          repo_id=repo_id,
          folder_path=local_directory,
          path_in_repo=<span class="hljs-string">&quot;.&quot;</span>,
    )

    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Your model is pushed to the Hub. You can view your model here: <span class="hljs-subst">{repo_url}</span>&quot;</span>)`,wrap:!1}}),Ms=new c({props:{code:"bm90ZWJvb2tfbG9naW4oKQ==",highlighted:"notebook_login()",wrap:!1}}),ys=new c({props:{code:"cmVwb19pZCUyMCUzRCUyMCUyMiUyMiUyMCUyMCUyMyUyMFRPRE8lMjBEZWZpbmUlMjB5b3VyJTIwcmVwbyUyMGlkJTIwJTdCdXNlcm5hbWUlMkZSZWluZm9yY2UtJTdCbW9kZWwtaWQlN0QlN0QlMEFwdXNoX3RvX2h1YiglMEElMjAlMjAlMjAlMjByZXBvX2lkJTJDJTBBJTIwJTIwJTIwJTIwY2FydHBvbGVfcG9saWN5JTJDJTIwJTIwJTIzJTIwVGhlJTIwbW9kZWwlMjB3ZSUyMHdhbnQlMjB0byUyMHNhdmUlMEElMjAlMjAlMjAlMjBjYXJ0cG9sZV9oeXBlcnBhcmFtZXRlcnMlMkMlMjAlMjAlMjMlMjBIeXBlcnBhcmFtZXRlcnMlMEElMjAlMjAlMjAlMjBldmFsX2VudiUyQyUyMCUyMCUyMyUyMEV2YWx1YXRpb24lMjBlbnZpcm9ubWVudCUwQSUyMCUyMCUyMCUyMHZpZGVvX2ZwcyUzRDMwJTBBKQ==",highlighted:`repo_id = <span class="hljs-string">&quot;&quot;</span>  <span class="hljs-comment"># TODO Define your repo id {username/Reinforce-{model-id}}</span>
push_to_hub(
    repo_id,
    cartpole_policy,  <span class="hljs-comment"># The model we want to save</span>
    cartpole_hyperparameters,  <span class="hljs-comment"># Hyperparameters</span>
    eval_env,  <span class="hljs-comment"># Evaluation environment</span>
    video_fps=<span class="hljs-number">30</span>
)`,wrap:!1}}),ws=new r({props:{title:"Second agent: PixelCopter 🚁",local:"second-agent-pixelcopter-",headingTag:"h2"}}),os=new r({props:{title:"Study the PixelCopter environment 👀",local:"study-the-pixelcopter-environment-",headingTag:"h3"}}),Ts=new c({props:{code:"ZW52X2lkJTIwJTNEJTIwJTIyUGl4ZWxjb3B0ZXItUExFLXYwJTIyJTBBZW52JTIwJTNEJTIwZ3ltLm1ha2UoZW52X2lkKSUwQWV2YWxfZW52JTIwJTNEJTIwZ3ltLm1ha2UoZW52X2lkKSUwQXNfc2l6ZSUyMCUzRCUyMGVudi5vYnNlcnZhdGlvbl9zcGFjZS5zaGFwZSU1QjAlNUQlMEFhX3NpemUlMjAlM0QlMjBlbnYuYWN0aW9uX3NwYWNlLm4=",highlighted:`env_id = <span class="hljs-string">&quot;Pixelcopter-PLE-v0&quot;</span>
env = gym.make(env_id)
eval_env = gym.make(env_id)
s_size = env.observation_space.shape[<span class="hljs-number">0</span>]
a_size = env.action_space.n`,wrap:!1}}),rs=new c({props:{code:"cHJpbnQoJTIyX19fX19PQlNFUlZBVElPTiUyMFNQQUNFX19fX18lMjAlNUNuJTIyKSUwQXByaW50KCUyMlRoZSUyMFN0YXRlJTIwU3BhY2UlMjBpcyUzQSUyMCUyMiUyQyUyMHNfc2l6ZSklMEFwcmludCglMjJTYW1wbGUlMjBvYnNlcnZhdGlvbiUyMiUyQyUyMGVudi5vYnNlcnZhdGlvbl9zcGFjZS5zYW1wbGUoKSklMjAlMjAlMjMlMjBHZXQlMjBhJTIwcmFuZG9tJTIwb2JzZXJ2YXRpb24=",highlighted:`<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;_____OBSERVATION SPACE_____ \\n&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;The State Space is: &quot;</span>, s_size)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Sample observation&quot;</span>, env.observation_space.sample())  <span class="hljs-comment"># Get a random observation</span>`,wrap:!1}}),cs=new c({props:{code:"cHJpbnQoJTIyJTVDbiUyMF9fX19fQUNUSU9OJTIwU1BBQ0VfX19fXyUyMCU1Q24lMjIpJTBBcHJpbnQoJTIyVGhlJTIwQWN0aW9uJTIwU3BhY2UlMjBpcyUzQSUyMCUyMiUyQyUyMGFfc2l6ZSklMEFwcmludCglMjJBY3Rpb24lMjBTcGFjZSUyMFNhbXBsZSUyMiUyQyUyMGVudi5hY3Rpb25fc3BhY2Uuc2FtcGxlKCkpJTIwJTIwJTIzJTIwVGFrZSUyMGElMjByYW5kb20lMjBhY3Rpb24=",highlighted:`<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\n _____ACTION SPACE_____ \\n&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;The Action Space is: &quot;</span>, a_size)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Action Space Sample&quot;</span>, env.action_space.sample())  <span class="hljs-comment"># Take a random action</span>`,wrap:!1}}),Cs=new r({props:{title:"Define the new Policy 🧠",local:"define-the-new-policy-",headingTag:"h3"}}),fs=new c({props:{code:"Y2xhc3MlMjBQb2xpY3kobm4uTW9kdWxlKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBzX3NpemUlMkMlMjBhX3NpemUlMkMlMjBoX3NpemUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3VwZXIoUG9saWN5JTJDJTIwc2VsZikuX19pbml0X18oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMERlZmluZSUyMHRoZSUyMHRocmVlJTIwbGF5ZXJzJTIwaGVyZSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMHgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwRGVmaW5lJTIwdGhlJTIwZm9yd2FyZCUyMHByb2Nlc3MlMjBoZXJlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwRi5zb2Z0bWF4KHglMkMlMjBkaW0lM0QxKSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGFjdChzZWxmJTJDJTIwc3RhdGUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RhdGUlMjAlM0QlMjB0b3JjaC5mcm9tX251bXB5KHN0YXRlKS5mbG9hdCgpLnVuc3F1ZWV6ZSgwKS50byhkZXZpY2UpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJvYnMlMjAlM0QlMjBzZWxmLmZvcndhcmQoc3RhdGUpLmNwdSgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbSUyMCUzRCUyMENhdGVnb3JpY2FsKHByb2JzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFjdGlvbiUyMCUzRCUyMG0uc2FtcGxlKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBhY3Rpb24uaXRlbSgpJTJDJTIwbS5sb2dfcHJvYihhY3Rpb24p",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">Policy</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, s_size, a_size, h_size</span>):
        <span class="hljs-built_in">super</span>(Policy, self).__init__()
        <span class="hljs-comment"># Define the three layers here</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
        <span class="hljs-comment"># Define the forward process here</span>
        <span class="hljs-keyword">return</span> F.softmax(x, dim=<span class="hljs-number">1</span>)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">act</span>(<span class="hljs-params">self, state</span>):
        state = torch.from_numpy(state).<span class="hljs-built_in">float</span>().unsqueeze(<span class="hljs-number">0</span>).to(device)
        probs = self.forward(state).cpu()
        m = Categorical(probs)
        action = m.sample()
        <span class="hljs-keyword">return</span> action.item(), m.log_prob(action)`,wrap:!1}}),Bs=new r({props:{title:"Solution",local:"solution",headingTag:"h4"}}),gs=new c({props:{code:"Y2xhc3MlMjBQb2xpY3kobm4uTW9kdWxlKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBzX3NpemUlMkMlMjBhX3NpemUlMkMlMjBoX3NpemUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3VwZXIoUG9saWN5JTJDJTIwc2VsZikuX19pbml0X18oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuZmMxJTIwJTNEJTIwbm4uTGluZWFyKHNfc2l6ZSUyQyUyMGhfc2l6ZSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmZjMiUyMCUzRCUyMG5uLkxpbmVhcihoX3NpemUlMkMlMjBoX3NpemUlMjAqJTIwMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmZjMyUyMCUzRCUyMG5uLkxpbmVhcihoX3NpemUlMjAqJTIwMiUyQyUyMGFfc2l6ZSklMEElMEElMjAlMjAlMjAlMjBkZWYlMjBmb3J3YXJkKHNlbGYlMkMlMjB4KSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHglMjAlM0QlMjBGLnJlbHUoc2VsZi5mYzEoeCkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweCUyMCUzRCUyMEYucmVsdShzZWxmLmZjMih4KSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB4JTIwJTNEJTIwc2VsZi5mYzMoeCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBGLnNvZnRtYXgoeCUyQyUyMGRpbSUzRDEpJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwYWN0KHNlbGYlMkMlMjBzdGF0ZSklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGF0ZSUyMCUzRCUyMHRvcmNoLmZyb21fbnVtcHkoc3RhdGUpLmZsb2F0KCkudW5zcXVlZXplKDApLnRvKGRldmljZSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9icyUyMCUzRCUyMHNlbGYuZm9yd2FyZChzdGF0ZSkuY3B1KCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtJTIwJTNEJTIwQ2F0ZWdvcmljYWwocHJvYnMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWN0aW9uJTIwJTNEJTIwbS5zYW1wbGUoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGFjdGlvbi5pdGVtKCklMkMlMjBtLmxvZ19wcm9iKGFjdGlvbik=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">Policy</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, s_size, a_size, h_size</span>):
        <span class="hljs-built_in">super</span>(Policy, self).__init__()
        self.fc1 = nn.Linear(s_size, h_size)
        self.fc2 = nn.Linear(h_size, h_size * <span class="hljs-number">2</span>)
        self.fc3 = nn.Linear(h_size * <span class="hljs-number">2</span>, a_size)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
        x = F.relu(self.fc1(x))
        x = F.relu(self.fc2(x))
        x = self.fc3(x)
        <span class="hljs-keyword">return</span> F.softmax(x, dim=<span class="hljs-number">1</span>)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">act</span>(<span class="hljs-params">self, state</span>):
        state = torch.from_numpy(state).<span class="hljs-built_in">float</span>().unsqueeze(<span class="hljs-number">0</span>).to(device)
        probs = self.forward(state).cpu()
        m = Categorical(probs)
        action = m.sample()
        <span class="hljs-keyword">return</span> action.item(), m.log_prob(action)`,wrap:!1}}),Gs=new r({props:{title:"Define the hyperparameters ⚙️",local:"define-the-hyperparameters-",headingTag:"h3"}}),vs=new c({props:{code:"cGl4ZWxjb3B0ZXJfaHlwZXJwYXJhbWV0ZXJzJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyaF9zaXplJTIyJTNBJTIwNjQlMkMlMEElMjAlMjAlMjAlMjAlMjJuX3RyYWluaW5nX2VwaXNvZGVzJTIyJTNBJTIwNTAwMDAlMkMlMEElMjAlMjAlMjAlMjAlMjJuX2V2YWx1YXRpb25fZXBpc29kZXMlMjIlM0ElMjAxMCUyQyUwQSUyMCUyMCUyMCUyMCUyMm1heF90JTIyJTNBJTIwMTAwMDAlMkMlMEElMjAlMjAlMjAlMjAlMjJnYW1tYSUyMiUzQSUyMDAuOTklMkMlMEElMjAlMjAlMjAlMjAlMjJsciUyMiUzQSUyMDFlLTQlMkMlMEElMjAlMjAlMjAlMjAlMjJlbnZfaWQlMjIlM0ElMjBlbnZfaWQlMkMlMEElMjAlMjAlMjAlMjAlMjJzdGF0ZV9zcGFjZSUyMiUzQSUyMHNfc2l6ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMmFjdGlvbl9zcGFjZSUyMiUzQSUyMGFfc2l6ZSUyQyUwQSU3RA==",highlighted:`pixelcopter_hyperparameters = {
    <span class="hljs-string">&quot;h_size&quot;</span>: <span class="hljs-number">64</span>,
    <span class="hljs-string">&quot;n_training_episodes&quot;</span>: <span class="hljs-number">50000</span>,
    <span class="hljs-string">&quot;n_evaluation_episodes&quot;</span>: <span class="hljs-number">10</span>,
    <span class="hljs-string">&quot;max_t&quot;</span>: <span class="hljs-number">10000</span>,
    <span class="hljs-string">&quot;gamma&quot;</span>: <span class="hljs-number">0.99</span>,
    <span class="hljs-string">&quot;lr&quot;</span>: <span class="hljs-number">1e-4</span>,
    <span class="hljs-string">&quot;env_id&quot;</span>: env_id,
    <span class="hljs-string">&quot;state_space&quot;</span>: s_size,
    <span class="hljs-string">&quot;action_space&quot;</span>: a_size,
}`,wrap:!1}}),As=new r({props:{title:"Train it",local:"train-it",headingTag:"h3"}}),Xs=new c({props:{code:"JTIzJTIwQ3JlYXRlJTIwcG9saWN5JTIwYW5kJTIwcGxhY2UlMjBpdCUyMHRvJTIwdGhlJTIwZGV2aWNlJTBBJTIzJTIwdG9yY2gubWFudWFsX3NlZWQoNTApJTBBcGl4ZWxjb3B0ZXJfcG9saWN5JTIwJTNEJTIwUG9saWN5KCUwQSUyMCUyMCUyMCUyMHBpeGVsY29wdGVyX2h5cGVycGFyYW1ldGVycyU1QiUyMnN0YXRlX3NwYWNlJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwcGl4ZWxjb3B0ZXJfaHlwZXJwYXJhbWV0ZXJzJTVCJTIyYWN0aW9uX3NwYWNlJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwcGl4ZWxjb3B0ZXJfaHlwZXJwYXJhbWV0ZXJzJTVCJTIyaF9zaXplJTIyJTVEJTJDJTBBKS50byhkZXZpY2UpJTBBcGl4ZWxjb3B0ZXJfb3B0aW1pemVyJTIwJTNEJTIwb3B0aW0uQWRhbShwaXhlbGNvcHRlcl9wb2xpY3kucGFyYW1ldGVycygpJTJDJTIwbHIlM0RwaXhlbGNvcHRlcl9oeXBlcnBhcmFtZXRlcnMlNUIlMjJsciUyMiU1RCk=",highlighted:`<span class="hljs-comment"># Create policy and place it to the device</span>
<span class="hljs-comment"># torch.manual_seed(50)</span>
pixelcopter_policy = Policy(
    pixelcopter_hyperparameters[<span class="hljs-string">&quot;state_space&quot;</span>],
    pixelcopter_hyperparameters[<span class="hljs-string">&quot;action_space&quot;</span>],
    pixelcopter_hyperparameters[<span class="hljs-string">&quot;h_size&quot;</span>],
).to(device)
pixelcopter_optimizer = optim.Adam(pixelcopter_policy.parameters(), lr=pixelcopter_hyperparameters[<span class="hljs-string">&quot;lr&quot;</span>])`,wrap:!1}}),Ws=new c({props:{code:"c2NvcmVzJTIwJTNEJTIwcmVpbmZvcmNlKCUwQSUyMCUyMCUyMCUyMHBpeGVsY29wdGVyX3BvbGljeSUyQyUwQSUyMCUyMCUyMCUyMHBpeGVsY29wdGVyX29wdGltaXplciUyQyUwQSUyMCUyMCUyMCUyMHBpeGVsY29wdGVyX2h5cGVycGFyYW1ldGVycyU1QiUyMm5fdHJhaW5pbmdfZXBpc29kZXMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBwaXhlbGNvcHRlcl9oeXBlcnBhcmFtZXRlcnMlNUIlMjJtYXhfdCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHBpeGVsY29wdGVyX2h5cGVycGFyYW1ldGVycyU1QiUyMmdhbW1hJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwMTAwMCUyQyUwQSk=",highlighted:`scores = reinforce(
    pixelcopter_policy,
    pixelcopter_optimizer,
    pixelcopter_hyperparameters[<span class="hljs-string">&quot;n_training_episodes&quot;</span>],
    pixelcopter_hyperparameters[<span class="hljs-string">&quot;max_t&quot;</span>],
    pixelcopter_hyperparameters[<span class="hljs-string">&quot;gamma&quot;</span>],
    <span class="hljs-number">1000</span>,
)`,wrap:!1}}),ks=new r({props:{title:"Publish our trained model on the Hub 🔥",local:"publish-our-trained-model-on-the-hub-",headingTag:"h3"}}),Ss=new c({props:{code:"cmVwb19pZCUyMCUzRCUyMCUyMiUyMiUyMCUyMCUyMyUyMFRPRE8lMjBEZWZpbmUlMjB5b3VyJTIwcmVwbyUyMGlkJTIwJTdCdXNlcm5hbWUlMkZSZWluZm9yY2UtJTdCbW9kZWwtaWQlN0QlN0QlMEFwdXNoX3RvX2h1YiglMEElMjAlMjAlMjAlMjByZXBvX2lkJTJDJTBBJTIwJTIwJTIwJTIwcGl4ZWxjb3B0ZXJfcG9saWN5JTJDJTIwJTIwJTIzJTIwVGhlJTIwbW9kZWwlMjB3ZSUyMHdhbnQlMjB0byUyMHNhdmUlMEElMjAlMjAlMjAlMjBwaXhlbGNvcHRlcl9oeXBlcnBhcmFtZXRlcnMlMkMlMjAlMjAlMjMlMjBIeXBlcnBhcmFtZXRlcnMlMEElMjAlMjAlMjAlMjBldmFsX2VudiUyQyUyMCUyMCUyMyUyMEV2YWx1YXRpb24lMjBlbnZpcm9ubWVudCUwQSUyMCUyMCUyMCUyMHZpZGVvX2ZwcyUzRDMwJTBBKQ==",highlighted:`repo_id = <span class="hljs-string">&quot;&quot;</span>  <span class="hljs-comment"># TODO Define your repo id {username/Reinforce-{model-id}}</span>
push_to_hub(
    repo_id,
    pixelcopter_policy,  <span class="hljs-comment"># The model we want to save</span>
    pixelcopter_hyperparameters,  <span class="hljs-comment"># Hyperparameters</span>
    eval_env,  <span class="hljs-comment"># Evaluation environment</span>
    video_fps=<span class="hljs-number">30</span>
)`,wrap:!1}}),Hs=new r({props:{title:"Some additional challenges 🏆",local:"some-additional-challenges-",headingTag:"h2"}}),Ls=new r({props:{title:"Keep Learning, stay awesome 🤗",local:"keep-learning-stay-awesome-",headingTag:"h3"}}),{c(){b=M("meta"),it=a(),at=M("p"),yt=a(),y(Z.$$.fragment),Jt=a(),y(v.$$.fragment),wt=a(),A=M("p"),A.innerHTML=ip,ot=a(),_=M("p"),_.textContent=yp,mt=a(),f=M("figure"),f.innerHTML=Jp,Tt=a(),X=M("p"),X.textContent=wp,rt=a(),W=M("ul"),W.innerHTML=op,ct=a(),k=M("p"),k.innerHTML=mp,Ut=a(),S=M("p"),S.innerHTML=Tp,ht=a(),H=M("p"),H.innerHTML=rp,jt=a(),V=M("p"),V.innerHTML=cp,It=a(),Q=M("p"),Q.innerHTML=Up,ut=a(),R=M("p"),R.innerHTML=hp,dt=a(),$=M("p"),$.innerHTML=jp,Ct=a(),E=M("p"),E.innerHTML=Ip,bt=a(),y(Y.$$.fragment),ft=a(),x=M("img"),Bt=a(),z=M("p"),z.textContent=dp,gt=a(),N=M("p"),N.innerHTML=Cp,Gt=a(),F=M("p"),F.innerHTML=bp,Zt=a(),L=M("p"),L.textContent=fp,vt=a(),q=M("ul"),q.innerHTML=Bp,At=a(),K=M("p"),K.innerHTML=gp,_t=a(),P=M("img"),Xt=a(),y(D.$$.fragment),Wt=a(),O=M("ul"),O.innerHTML=Zp,kt=a(),y(ll.$$.fragment),St=a(),el=M("ul"),el.innerHTML=vp,Ht=a(),sl=M("p"),sl.innerHTML=Ap,Vt=a(),y(tl.$$.fragment),Qt=a(),al=M("p"),al.textContent=_p,Rt=a(),nl=M("ul"),nl.innerHTML=Xp,$t=a(),y(Ml.$$.fragment),Et=a(),pl=M("p"),pl.textContent=Wp,Yt=a(),il=M("p"),il.innerHTML=kp,xt=a(),y(yl.$$.fragment),zt=a(),y(Jl.$$.fragment),Nt=a(),wl=M("p"),wl.innerHTML=Sp,Ft=a(),ol=M("p"),ol.innerHTML=Hp,Lt=a(),y(ml.$$.fragment),qt=a(),Tl=M("ul"),Tl.innerHTML=Vp,Kt=a(),rl=M("img"),Pt=a(),cl=M("ul"),cl.innerHTML=Rp,Dt=a(),Ul=M("img"),Ot=a(),y(hl.$$.fragment),la=a(),jl=M("p"),jl.innerHTML=Ep,ea=a(),Il=M("p"),Il.textContent=Yp,sa=a(),y(ul.$$.fragment),ta=a(),y(dl.$$.fragment),aa=a(),y(Cl.$$.fragment),na=a(),bl=M("p"),bl.textContent=xp,Ma=a(),fl=M("ul"),fl.innerHTML=zp,pa=a(),Bl=M("p"),Bl.innerHTML=Np,ia=a(),gl=M("p"),gl.textContent=Fp,ya=a(),Gl=M("ul"),Gl.innerHTML=Lp,Ja=a(),Zl=M("p"),Zl.innerHTML=qp,wa=a(),vl=M("p"),vl.innerHTML=Kp,oa=a(),Al=M("p"),Al.innerHTML=Pp,ma=a(),y(_l.$$.fragment),Ta=a(),y(Xl.$$.fragment),ra=a(),Wl=M("p"),Wl.textContent=Dp,ca=a(),kl=M("ul"),kl.innerHTML=Op,Ua=a(),y(Sl.$$.fragment),ha=a(),y(Hl.$$.fragment),ja=a(),Vl=M("ul"),Vl.innerHTML=li,Ia=a(),y(Ql.$$.fragment),ua=a(),y(Rl.$$.fragment),da=a(),$l=M("p"),$l.textContent=ei,Ca=a(),y(El.$$.fragment),ba=a(),y(Yl.$$.fragment),fa=a(),y(xl.$$.fragment),Ba=a(),y(zl.$$.fragment),ga=a(),Nl=M("p"),Nl.innerHTML=si,Ga=a(),Fl=M("blockquote"),Fl.innerHTML=ti,Za=a(),Ll=M("blockquote"),Ll.innerHTML=ai,va=a(),y(ql.$$.fragment),Aa=a(),Kl=M("blockquote"),Kl.innerHTML=ni,_a=a(),Pl=M("p"),Pl.innerHTML=Mi,Xa=a(),Dl=M("p"),Dl.textContent=pi,Wa=a(),Ol=M("ul"),Ol.innerHTML=ii,ka=a(),le=M("p"),le.textContent=yi,Sa=a(),y(ee.$$.fragment),Ha=a(),y(se.$$.fragment),Va=a(),y(te.$$.fragment),Qa=a(),y(ae.$$.fragment),Ra=a(),ne=M("p"),ne.textContent=Ji,$a=a(),Me=M("ul"),Me.innerHTML=wi,Ea=a(),pe=M("img"),Ya=a(),ie=M("p"),ie.textContent=mi,xa=a(),ye=M("ul"),ye.innerHTML=Ti,za=a(),y(Je.$$.fragment),Na=a(),y(we.$$.fragment),Fa=a(),y(oe.$$.fragment),La=a(),me=M("p"),me.textContent=ri,qa=a(),Te=M("ul"),Te.innerHTML=ci,Ka=a(),y(re.$$.fragment),Pa=a(),ce=M("ul"),ce.innerHTML=Ui,Da=a(),Ue=M("p"),Ue.innerHTML=hi,Oa=a(),y(he.$$.fragment),ln=a(),y(je.$$.fragment),en=a(),Ie=M("p"),Ie.innerHTML=ji,sn=a(),ue=M("ul"),ue.innerHTML=Ii,tn=a(),y(de.$$.fragment),an=a(),Ce=M("p"),Ce.textContent=ui,nn=a(),be=M("img"),Mn=a(),fe=M("ul"),fe.innerHTML=Ci,pn=a(),Be=M("p"),Be.innerHTML=bi,yn=a(),ge=M("p"),ge.innerHTML=fi,Jn=a(),qs=M("ul"),Ge=M("li"),FM=u("We want to maximize our utility function $J(\\theta)$, but in PyTorch and TensorFlow, it’s better to "),Ks=M("strong"),Ks.textContent=Bi,j=M("ul"),Ps=M("li"),Ps.textContent=gi,LM=a(),B=M("li"),qM=u("So we want to modify"),wn=new st(!1),on=u(" such that"),mn=new st(!1),KM=a(),g=M("li"),PM=u("Because all P must sum to 1, max"),Tn=new st(!1),rn=u(" will "),Ds=M("strong"),Ds.textContent=Gi,DM=a(),Os=M("li"),OM=u("So we should tell PyTorch "),Ze=M("strong"),lp=u("to min"),cn=new st(!1),Un=u("."),ep=a(),ve=M("li"),sp=u("This loss function approaches 0 as"),hn=new st(!1),jn=u(" nears 1."),tp=a(),lt=M("li"),ap=u("So we are encouraging the gradient to max"),In=new st(!1),un=a(),y(Ae.$$.fragment),dn=a(),y(_e.$$.fragment),Cn=a(),y(Xe.$$.fragment),bn=a(),y(We.$$.fragment),fn=a(),ke=M("ul"),ke.innerHTML=Zi,Bn=a(),y(Se.$$.fragment),gn=a(),y(He.$$.fragment),Gn=a(),y(Ve.$$.fragment),Zn=a(),y(Qe.$$.fragment),vn=a(),Re=M("ul"),Re.innerHTML=vi,An=a(),y($e.$$.fragment),_n=a(),y(Ee.$$.fragment),Xn=a(),y(Ye.$$.fragment),Wn=a(),y(xe.$$.fragment),kn=a(),ze=M("p"),ze.textContent=Ai,Sn=a(),Ne=M("p"),Ne.textContent=_i,Hn=a(),et=M("img"),Vn=a(),y(Fe.$$.fragment),Qn=a(),y(Le.$$.fragment),Rn=a(),y(qe.$$.fragment),$n=a(),y(Ke.$$.fragment),En=a(),y(Pe.$$.fragment),Yn=a(),De=M("p"),De.innerHTML=Wi,xn=a(),Oe=M("p"),Oe.textContent=ki,zn=a(),ls=M("ul"),ls.innerHTML=Si,Nn=a(),es=M("p"),es.textContent=Hi,Fn=a(),ss=M("p"),ss.innerHTML=Vi,Ln=a(),ts=M("p"),ts.textContent=Qi,qn=a(),as=M("ul"),as.innerHTML=Ri,Kn=a(),ns=M("img"),Pn=a(),y(Ms.$$.fragment),Dn=a(),ps=M("p"),ps.innerHTML=Ei,On=a(),is=M("p"),is.innerHTML=Yi,lM=a(),y(ys.$$.fragment),eM=a(),Js=M("p"),Js.textContent=xi,sM=a(),y(ws.$$.fragment),tM=a(),y(os.$$.fragment),aM=a(),ms=M("ul"),ms.innerHTML=zi,nM=a(),y(Ts.$$.fragment),MM=a(),y(rs.$$.fragment),pM=a(),y(cs.$$.fragment),iM=a(),Us=M("p"),Us.textContent=Ni,yM=a(),hs=M("ul"),hs.innerHTML=Fi,JM=a(),js=M("p"),js.textContent=Li,wM=a(),Is=M("ul"),Is.innerHTML=qi,oM=a(),us=M("p"),us.textContent=Ki,mM=a(),ds=M("ul"),ds.innerHTML=Pi,TM=a(),y(Cs.$$.fragment),rM=a(),bs=M("ul"),bs.innerHTML=Di,cM=a(),y(fs.$$.fragment),UM=a(),y(Bs.$$.fragment),hM=a(),y(gs.$$.fragment),jM=a(),y(Gs.$$.fragment),IM=a(),Zs=M("ul"),Zs.innerHTML=Oi,uM=a(),y(vs.$$.fragment),dM=a(),y(As.$$.fragment),CM=a(),_s=M("ul"),_s.innerHTML=ly,bM=a(),y(Xs.$$.fragment),fM=a(),y(Ws.$$.fragment),BM=a(),y(ks.$$.fragment),gM=a(),y(Ss.$$.fragment),GM=a(),y(Hs.$$.fragment),ZM=a(),Vs=M("p"),Vs.innerHTML=ey,vM=a(),Qs=M("p"),Qs.innerHTML=sy,AM=a(),Rs=M("p"),Rs.textContent=ty,_M=a(),$s=M("ul"),$s.innerHTML=ay,XM=a(),WM=M("hr"),kM=a(),Es=M("p"),Es.innerHTML=ny,SM=a(),Ys=M("p"),Ys.innerHTML=My,HM=a(),xs=M("p"),xs.innerHTML=py,VM=a(),zs=M("p"),zs.textContent=iy,QM=a(),Ns=M("p"),Ns.innerHTML=yy,RM=a(),Fs=M("p"),Fs.textContent=Jy,$M=a(),y(Ls.$$.fragment),EM=a(),nt=M("p"),this.h()},l(l){const e=Cy("svelte-u9bgzb",document.head);b=p(e,"META",{name:!0,content:!0}),e.forEach(s),it=n(l),at=p(l,"P",{}),d(at).forEach(s),yt=n(l),J(Z.$$.fragment,l),Jt=n(l),J(v.$$.fragment,l),wt=n(l),A=p(l,"P",{"data-svelte-h":!0}),i(A)!=="svelte-fi9d8o"&&(A.innerHTML=ip),ot=n(l),_=p(l,"P",{"data-svelte-h":!0}),i(_)!=="svelte-liqaak"&&(_.textContent=yp),mt=n(l),f=p(l,"FIGURE",{class:!0,"data-svelte-h":!0}),i(f)!=="svelte-1dadvfq"&&(f.innerHTML=Jp),Tt=n(l),X=p(l,"P",{"data-svelte-h":!0}),i(X)!=="svelte-1u0hqjo"&&(X.textContent=wp),rt=n(l),W=p(l,"UL",{"data-svelte-h":!0}),i(W)!=="svelte-qqschq"&&(W.innerHTML=op),ct=n(l),k=p(l,"P",{"data-svelte-h":!0}),i(k)!=="svelte-h6mhk8"&&(k.innerHTML=mp),Ut=n(l),S=p(l,"P",{"data-svelte-h":!0}),i(S)!=="svelte-1c0nyzi"&&(S.innerHTML=Tp),ht=n(l),H=p(l,"P",{"data-svelte-h":!0}),i(H)!=="svelte-1qkxyrx"&&(H.innerHTML=rp),jt=n(l),V=p(l,"P",{"data-svelte-h":!0}),i(V)!=="svelte-znarat"&&(V.innerHTML=cp),It=n(l),Q=p(l,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-10pdw2g"&&(Q.innerHTML=Up),ut=n(l),R=p(l,"P",{"data-svelte-h":!0}),i(R)!=="svelte-8tt267"&&(R.innerHTML=hp),dt=n(l),$=p(l,"P",{"data-svelte-h":!0}),i($)!=="svelte-uilrpw"&&($.innerHTML=jp),Ct=n(l),E=p(l,"P",{"data-svelte-h":!0}),i(E)!=="svelte-p9mrd0"&&(E.innerHTML=Ip),bt=n(l),J(Y.$$.fragment,l),ft=n(l),x=p(l,"IMG",{src:!0,alt:!0}),Bt=n(l),z=p(l,"P",{"data-svelte-h":!0}),i(z)!=="svelte-11hwml8"&&(z.textContent=dp),gt=n(l),N=p(l,"P",{"data-svelte-h":!0}),i(N)!=="svelte-nwil7u"&&(N.innerHTML=Cp),Gt=n(l),F=p(l,"P",{"data-svelte-h":!0}),i(F)!=="svelte-jsssl2"&&(F.innerHTML=bp),Zt=n(l),L=p(l,"P",{"data-svelte-h":!0}),i(L)!=="svelte-1wpzntl"&&(L.textContent=fp),vt=n(l),q=p(l,"UL",{"data-svelte-h":!0}),i(q)!=="svelte-1c5irle"&&(q.innerHTML=Bp),At=n(l),K=p(l,"P",{"data-svelte-h":!0}),i(K)!=="svelte-4ucrls"&&(K.innerHTML=gp),_t=n(l),P=p(l,"IMG",{src:!0,alt:!0}),Xt=n(l),J(D.$$.fragment,l),Wt=n(l),O=p(l,"UL",{"data-svelte-h":!0}),i(O)!=="svelte-1tbp2wd"&&(O.innerHTML=Zp),kt=n(l),J(ll.$$.fragment,l),St=n(l),el=p(l,"UL",{"data-svelte-h":!0}),i(el)!=="svelte-ud7zzn"&&(el.innerHTML=vp),Ht=n(l),sl=p(l,"P",{"data-svelte-h":!0}),i(sl)!=="svelte-qqj2y4"&&(sl.innerHTML=Ap),Vt=n(l),J(tl.$$.fragment,l),Qt=n(l),al=p(l,"P",{"data-svelte-h":!0}),i(al)!=="svelte-nsjs09"&&(al.textContent=_p),Rt=n(l),nl=p(l,"UL",{"data-svelte-h":!0}),i(nl)!=="svelte-14xf3th"&&(nl.innerHTML=Xp),$t=n(l),J(Ml.$$.fragment,l),Et=n(l),pl=p(l,"P",{"data-svelte-h":!0}),i(pl)!=="svelte-1v25wk6"&&(pl.textContent=Wp),Yt=n(l),il=p(l,"P",{"data-svelte-h":!0}),i(il)!=="svelte-1rlbolh"&&(il.innerHTML=kp),xt=n(l),J(yl.$$.fragment,l),zt=n(l),J(Jl.$$.fragment,l),Nt=n(l),wl=p(l,"P",{"data-svelte-h":!0}),i(wl)!=="svelte-ob9gmy"&&(wl.innerHTML=Sp),Ft=n(l),ol=p(l,"P",{"data-svelte-h":!0}),i(ol)!=="svelte-kifkkx"&&(ol.innerHTML=Hp),Lt=n(l),J(ml.$$.fragment,l),qt=n(l),Tl=p(l,"UL",{"data-svelte-h":!0}),i(Tl)!=="svelte-1funvfi"&&(Tl.innerHTML=Vp),Kt=n(l),rl=p(l,"IMG",{src:!0,alt:!0}),Pt=n(l),cl=p(l,"UL",{"data-svelte-h":!0}),i(cl)!=="svelte-1cge6gn"&&(cl.innerHTML=Rp),Dt=n(l),Ul=p(l,"IMG",{src:!0,alt:!0}),Ot=n(l),J(hl.$$.fragment,l),la=n(l),jl=p(l,"P",{"data-svelte-h":!0}),i(jl)!=="svelte-pdx5k3"&&(jl.innerHTML=Ep),ea=n(l),Il=p(l,"P",{"data-svelte-h":!0}),i(Il)!=="svelte-tsd2zd"&&(Il.textContent=Yp),sa=n(l),J(ul.$$.fragment,l),ta=n(l),J(dl.$$.fragment,l),aa=n(l),J(Cl.$$.fragment,l),na=n(l),bl=p(l,"P",{"data-svelte-h":!0}),i(bl)!=="svelte-1pw2whq"&&(bl.textContent=xp),Ma=n(l),fl=p(l,"UL",{"data-svelte-h":!0}),i(fl)!=="svelte-k2qrfp"&&(fl.innerHTML=zp),pa=n(l),Bl=p(l,"P",{"data-svelte-h":!0}),i(Bl)!=="svelte-1vmixr"&&(Bl.innerHTML=Np),ia=n(l),gl=p(l,"P",{"data-svelte-h":!0}),i(gl)!=="svelte-1wv28c2"&&(gl.textContent=Fp),ya=n(l),Gl=p(l,"UL",{"data-svelte-h":!0}),i(Gl)!=="svelte-myoczt"&&(Gl.innerHTML=Lp),Ja=n(l),Zl=p(l,"P",{"data-svelte-h":!0}),i(Zl)!=="svelte-1qs6q29"&&(Zl.innerHTML=qp),wa=n(l),vl=p(l,"P",{"data-svelte-h":!0}),i(vl)!=="svelte-xcqr7v"&&(vl.innerHTML=Kp),oa=n(l),Al=p(l,"P",{"data-svelte-h":!0}),i(Al)!=="svelte-hj7hlz"&&(Al.innerHTML=Pp),ma=n(l),J(_l.$$.fragment,l),Ta=n(l),J(Xl.$$.fragment,l),ra=n(l),Wl=p(l,"P",{"data-svelte-h":!0}),i(Wl)!=="svelte-dqxg7f"&&(Wl.textContent=Dp),ca=n(l),kl=p(l,"UL",{"data-svelte-h":!0}),i(kl)!=="svelte-1gjders"&&(kl.innerHTML=Op),Ua=n(l),J(Sl.$$.fragment,l),ha=n(l),J(Hl.$$.fragment,l),ja=n(l),Vl=p(l,"UL",{"data-svelte-h":!0}),i(Vl)!=="svelte-1gy9cwb"&&(Vl.innerHTML=li),Ia=n(l),J(Ql.$$.fragment,l),ua=n(l),J(Rl.$$.fragment,l),da=n(l),$l=p(l,"P",{"data-svelte-h":!0}),i($l)!=="svelte-vuxvq9"&&($l.textContent=ei),Ca=n(l),J(El.$$.fragment,l),ba=n(l),J(Yl.$$.fragment,l),fa=n(l),J(xl.$$.fragment,l),Ba=n(l),J(zl.$$.fragment,l),ga=n(l),Nl=p(l,"P",{"data-svelte-h":!0}),i(Nl)!=="svelte-gt4x2w"&&(Nl.innerHTML=si),Ga=n(l),Fl=p(l,"BLOCKQUOTE",{"data-svelte-h":!0}),i(Fl)!=="svelte-1tbaqzz"&&(Fl.innerHTML=ti),Za=n(l),Ll=p(l,"BLOCKQUOTE",{"data-svelte-h":!0}),i(Ll)!=="svelte-183qkv9"&&(Ll.innerHTML=ai),va=n(l),J(ql.$$.fragment,l),Aa=n(l),Kl=p(l,"BLOCKQUOTE",{"data-svelte-h":!0}),i(Kl)!=="svelte-9v2bo0"&&(Kl.innerHTML=ni),_a=n(l),Pl=p(l,"P",{"data-svelte-h":!0}),i(Pl)!=="svelte-13r4rlx"&&(Pl.innerHTML=Mi),Xa=n(l),Dl=p(l,"P",{"data-svelte-h":!0}),i(Dl)!=="svelte-oceozx"&&(Dl.textContent=pi),Wa=n(l),Ol=p(l,"UL",{"data-svelte-h":!0}),i(Ol)!=="svelte-1c26av6"&&(Ol.innerHTML=ii),ka=n(l),le=p(l,"P",{"data-svelte-h":!0}),i(le)!=="svelte-poz2v2"&&(le.textContent=yi),Sa=n(l),J(ee.$$.fragment,l),Ha=n(l),J(se.$$.fragment,l),Va=n(l),J(te.$$.fragment,l),Qa=n(l),J(ae.$$.fragment,l),Ra=n(l),ne=p(l,"P",{"data-svelte-h":!0}),i(ne)!=="svelte-2qybsb"&&(ne.textContent=Ji),$a=n(l),Me=p(l,"UL",{"data-svelte-h":!0}),i(Me)!=="svelte-1sj03by"&&(Me.innerHTML=wi),Ea=n(l),pe=p(l,"IMG",{src:!0,alt:!0}),Ya=n(l),ie=p(l,"P",{"data-svelte-h":!0}),i(ie)!=="svelte-56izqm"&&(ie.textContent=mi),xa=n(l),ye=p(l,"UL",{"data-svelte-h":!0}),i(ye)!=="svelte-5b172v"&&(ye.innerHTML=Ti),za=n(l),J(Je.$$.fragment,l),Na=n(l),J(we.$$.fragment,l),Fa=n(l),J(oe.$$.fragment,l),La=n(l),me=p(l,"P",{"data-svelte-h":!0}),i(me)!=="svelte-131hsl5"&&(me.textContent=ri),qa=n(l),Te=p(l,"UL",{"data-svelte-h":!0}),i(Te)!=="svelte-f2pb1"&&(Te.innerHTML=ci),Ka=n(l),J(re.$$.fragment,l),Pa=n(l),ce=p(l,"UL",{"data-svelte-h":!0}),i(ce)!=="svelte-kheb3v"&&(ce.innerHTML=Ui),Da=n(l),Ue=p(l,"P",{"data-svelte-h":!0}),i(Ue)!=="svelte-r1i79m"&&(Ue.innerHTML=hi),Oa=n(l),J(he.$$.fragment,l),ln=n(l),J(je.$$.fragment,l),en=n(l),Ie=p(l,"P",{"data-svelte-h":!0}),i(Ie)!=="svelte-tmktf2"&&(Ie.innerHTML=ji),sn=n(l),ue=p(l,"UL",{"data-svelte-h":!0}),i(ue)!=="svelte-mzudog"&&(ue.innerHTML=Ii),tn=n(l),J(de.$$.fragment,l),an=n(l),Ce=p(l,"P",{"data-svelte-h":!0}),i(Ce)!=="svelte-adbt0w"&&(Ce.textContent=ui),nn=n(l),be=p(l,"IMG",{src:!0,alt:!0}),Mn=n(l),fe=p(l,"UL",{"data-svelte-h":!0}),i(fe)!=="svelte-1wxltag"&&(fe.innerHTML=Ci),pn=n(l),Be=p(l,"P",{"data-svelte-h":!0}),i(Be)!=="svelte-1ucwq0c"&&(Be.innerHTML=bi),yn=n(l),ge=p(l,"P",{"data-svelte-h":!0}),i(ge)!=="svelte-1tam5jq"&&(ge.innerHTML=fi),Jn=n(l),qs=p(l,"UL",{});var wy=d(qs);Ge=p(wy,"LI",{});var xM=d(Ge);FM=C(xM,"We want to maximize our utility function $J(\\theta)$, but in PyTorch and TensorFlow, it’s better to "),Ks=p(xM,"STRONG",{"data-svelte-h":!0}),i(Ks)!=="svelte-147747o"&&(Ks.textContent=Bi),j=p(xM,"UL",{});var I=d(j);Ps=p(I,"LI",{"data-svelte-h":!0}),i(Ps)!=="svelte-1pp5ztk"&&(Ps.textContent=gi),LM=n(I),B=p(I,"LI",{});var Mt=d(B);qM=C(Mt,"So we want to modify"),wn=tt(Mt,!1),on=C(Mt," such that"),mn=tt(Mt,!1),Mt.forEach(s),KM=n(I),g=p(I,"LI",{});var pt=d(g);PM=C(pt,"Because all P must sum to 1, max"),Tn=tt(pt,!1),rn=C(pt," will "),Ds=p(pt,"STRONG",{"data-svelte-h":!0}),i(Ds)!=="svelte-5xkb6z"&&(Ds.textContent=Gi),pt.forEach(s),DM=n(I),Os=p(I,"LI",{});var np=d(Os);OM=C(np,"So we should tell PyTorch "),Ze=p(np,"STRONG",{});var zM=d(Ze);lp=C(zM,"to min"),cn=tt(zM,!1),Un=C(zM,"."),zM.forEach(s),np.forEach(s),ep=n(I),ve=p(I,"LI",{});var NM=d(ve);sp=C(NM,"This loss function approaches 0 as"),hn=tt(NM,!1),jn=C(NM," nears 1."),NM.forEach(s),tp=n(I),lt=p(I,"LI",{});var Mp=d(lt);ap=C(Mp,"So we are encouraging the gradient to max"),In=tt(Mp,!1),Mp.forEach(s),I.forEach(s),xM.forEach(s),wy.forEach(s),un=n(l),J(Ae.$$.fragment,l),dn=n(l),J(_e.$$.fragment,l),Cn=n(l),J(Xe.$$.fragment,l),bn=n(l),J(We.$$.fragment,l),fn=n(l),ke=p(l,"UL",{"data-svelte-h":!0}),i(ke)!=="svelte-aryts0"&&(ke.innerHTML=Zi),Bn=n(l),J(Se.$$.fragment,l),gn=n(l),J(He.$$.fragment,l),Gn=n(l),J(Ve.$$.fragment,l),Zn=n(l),J(Qe.$$.fragment,l),vn=n(l),Re=p(l,"UL",{"data-svelte-h":!0}),i(Re)!=="svelte-1f2fdos"&&(Re.innerHTML=vi),An=n(l),J($e.$$.fragment,l),_n=n(l),J(Ee.$$.fragment,l),Xn=n(l),J(Ye.$$.fragment,l),Wn=n(l),J(xe.$$.fragment,l),kn=n(l),ze=p(l,"P",{"data-svelte-h":!0}),i(ze)!=="svelte-13d1cnp"&&(ze.textContent=Ai),Sn=n(l),Ne=p(l,"P",{"data-svelte-h":!0}),i(Ne)!=="svelte-1ifum22"&&(Ne.textContent=_i),Hn=n(l),et=p(l,"IMG",{src:!0}),Vn=n(l),J(Fe.$$.fragment,l),Qn=n(l),J(Le.$$.fragment,l),Rn=n(l),J(qe.$$.fragment,l),$n=n(l),J(Ke.$$.fragment,l),En=n(l),J(Pe.$$.fragment,l),Yn=n(l),De=p(l,"P",{"data-svelte-h":!0}),i(De)!=="svelte-1ss5nh"&&(De.innerHTML=Wi),xn=n(l),Oe=p(l,"P",{"data-svelte-h":!0}),i(Oe)!=="svelte-vgzxi7"&&(Oe.textContent=ki),zn=n(l),ls=p(l,"UL",{"data-svelte-h":!0}),i(ls)!=="svelte-bcjr5d"&&(ls.innerHTML=Si),Nn=n(l),es=p(l,"P",{"data-svelte-h":!0}),i(es)!=="svelte-6k9qpu"&&(es.textContent=Hi),Fn=n(l),ss=p(l,"P",{"data-svelte-h":!0}),i(ss)!=="svelte-932u9c"&&(ss.innerHTML=Vi),Ln=n(l),ts=p(l,"P",{"data-svelte-h":!0}),i(ts)!=="svelte-1cn3tld"&&(ts.textContent=Qi),qn=n(l),as=p(l,"UL",{"data-svelte-h":!0}),i(as)!=="svelte-19b5tev"&&(as.innerHTML=Ri),Kn=n(l),ns=p(l,"IMG",{src:!0,alt:!0}),Pn=n(l),J(Ms.$$.fragment,l),Dn=n(l),ps=p(l,"P",{"data-svelte-h":!0}),i(ps)!=="svelte-14yhksh"&&(ps.innerHTML=Ei),On=n(l),is=p(l,"P",{"data-svelte-h":!0}),i(is)!=="svelte-1enm9m5"&&(is.innerHTML=Yi),lM=n(l),J(ys.$$.fragment,l),eM=n(l),Js=p(l,"P",{"data-svelte-h":!0}),i(Js)!=="svelte-s4clfq"&&(Js.textContent=xi),sM=n(l),J(ws.$$.fragment,l),tM=n(l),J(os.$$.fragment,l),aM=n(l),ms=p(l,"UL",{"data-svelte-h":!0}),i(ms)!=="svelte-19tqm2y"&&(ms.innerHTML=zi),nM=n(l),J(Ts.$$.fragment,l),MM=n(l),J(rs.$$.fragment,l),pM=n(l),J(cs.$$.fragment,l),iM=n(l),Us=p(l,"P",{"data-svelte-h":!0}),i(Us)!=="svelte-xr9zu2"&&(Us.textContent=Ni),yM=n(l),hs=p(l,"UL",{"data-svelte-h":!0}),i(hs)!=="svelte-hfzbwg"&&(hs.innerHTML=Fi),JM=n(l),js=p(l,"P",{"data-svelte-h":!0}),i(js)!=="svelte-1j0vapy"&&(js.textContent=Li),wM=n(l),Is=p(l,"UL",{"data-svelte-h":!0}),i(Is)!=="svelte-109j46n"&&(Is.innerHTML=qi),oM=n(l),us=p(l,"P",{"data-svelte-h":!0}),i(us)!=="svelte-1kwknxb"&&(us.textContent=Ki),mM=n(l),ds=p(l,"UL",{"data-svelte-h":!0}),i(ds)!=="svelte-14go64c"&&(ds.innerHTML=Pi),TM=n(l),J(Cs.$$.fragment,l),rM=n(l),bs=p(l,"UL",{"data-svelte-h":!0}),i(bs)!=="svelte-kjz32c"&&(bs.innerHTML=Di),cM=n(l),J(fs.$$.fragment,l),UM=n(l),J(Bs.$$.fragment,l),hM=n(l),J(gs.$$.fragment,l),jM=n(l),J(Gs.$$.fragment,l),IM=n(l),Zs=p(l,"UL",{"data-svelte-h":!0}),i(Zs)!=="svelte-4ebgyj"&&(Zs.innerHTML=Oi),uM=n(l),J(vs.$$.fragment,l),dM=n(l),J(As.$$.fragment,l),CM=n(l),_s=p(l,"UL",{"data-svelte-h":!0}),i(_s)!=="svelte-c51ubm"&&(_s.innerHTML=ly),bM=n(l),J(Xs.$$.fragment,l),fM=n(l),J(Ws.$$.fragment,l),BM=n(l),J(ks.$$.fragment,l),gM=n(l),J(Ss.$$.fragment,l),GM=n(l),J(Hs.$$.fragment,l),ZM=n(l),Vs=p(l,"P",{"data-svelte-h":!0}),i(Vs)!=="svelte-h9supy"&&(Vs.innerHTML=ey),vM=n(l),Qs=p(l,"P",{"data-svelte-h":!0}),i(Qs)!=="svelte-131ixzr"&&(Qs.innerHTML=sy),AM=n(l),Rs=p(l,"P",{"data-svelte-h":!0}),i(Rs)!=="svelte-1uth36j"&&(Rs.textContent=ty),_M=n(l),$s=p(l,"UL",{"data-svelte-h":!0}),i($s)!=="svelte-su8kur"&&($s.innerHTML=ay),XM=n(l),WM=p(l,"HR",{}),kM=n(l),Es=p(l,"P",{"data-svelte-h":!0}),i(Es)!=="svelte-jb70tl"&&(Es.innerHTML=ny),SM=n(l),Ys=p(l,"P",{"data-svelte-h":!0}),i(Ys)!=="svelte-h09rnt"&&(Ys.innerHTML=My),HM=n(l),xs=p(l,"P",{"data-svelte-h":!0}),i(xs)!=="svelte-st4ijf"&&(xs.innerHTML=py),VM=n(l),zs=p(l,"P",{"data-svelte-h":!0}),i(zs)!=="svelte-2auufk"&&(zs.textContent=iy),QM=n(l),Ns=p(l,"P",{"data-svelte-h":!0}),i(Ns)!=="svelte-ol1ouv"&&(Ns.innerHTML=yy),RM=n(l),Fs=p(l,"P",{"data-svelte-h":!0}),i(Fs)!=="svelte-kyrcnn"&&(Fs.textContent=Jy),$M=n(l),J(Ls.$$.fragment,l),EM=n(l),nt=p(l,"P",{}),d(nt).forEach(s),this.h()},h(){h(b,"name","hf:doc:metadata"),h(b,"content",By),h(f,"class","image table text-center m-0 w-full"),G(x.src,up="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit6/thumbnail.png")||h(x,"src",up),h(x,"alt","thumbnail"),G(P.src,Gp="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit6/envs.gif")||h(P,"src",Gp),h(P,"alt","Environments"),G(rl.src,Qp="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/gpu-step1.jpg")||h(rl,"src",Qp),h(rl,"alt","GPU Step 1"),G(Ul.src,$p="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/gpu-step2.jpg")||h(Ul,"src",$p),h(Ul,"alt","GPU Step 2"),G(pe.src,oi="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit6/reinforce.png")||h(pe,"src",oi),h(pe,"alt","Reinforce"),G(be.src,di="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit6/pg_pseudocode.png")||h(be,"src",di),h(be,"alt","Policy gradient pseudocode"),wn.a=on,mn.a=null,Tn.a=rn,cn.a=Un,hn.a=jn,In.a=null,G(et.src,Xi="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit6/modelcard.png")||h(et,"src",Xi),G(ns.src,$i="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/create-token.jpg")||h(ns,"src",$i),h(ns,"alt","Create HF Token")},m(l,e){U(document.head,b),t(l,it,e),t(l,at,e),t(l,yt,e),w(Z,l,e),t(l,Jt,e),w(v,l,e),t(l,wt,e),t(l,A,e),t(l,ot,e),t(l,_,e),t(l,mt,e),t(l,f,e),t(l,Tt,e),t(l,X,e),t(l,rt,e),t(l,W,e),t(l,ct,e),t(l,k,e),t(l,Ut,e),t(l,S,e),t(l,ht,e),t(l,H,e),t(l,jt,e),t(l,V,e),t(l,It,e),t(l,Q,e),t(l,ut,e),t(l,R,e),t(l,dt,e),t(l,$,e),t(l,Ct,e),t(l,E,e),t(l,bt,e),w(Y,l,e),t(l,ft,e),t(l,x,e),t(l,Bt,e),t(l,z,e),t(l,gt,e),t(l,N,e),t(l,Gt,e),t(l,F,e),t(l,Zt,e),t(l,L,e),t(l,vt,e),t(l,q,e),t(l,At,e),t(l,K,e),t(l,_t,e),t(l,P,e),t(l,Xt,e),w(D,l,e),t(l,Wt,e),t(l,O,e),t(l,kt,e),w(ll,l,e),t(l,St,e),t(l,el,e),t(l,Ht,e),t(l,sl,e),t(l,Vt,e),w(tl,l,e),t(l,Qt,e),t(l,al,e),t(l,Rt,e),t(l,nl,e),t(l,$t,e),w(Ml,l,e),t(l,Et,e),t(l,pl,e),t(l,Yt,e),t(l,il,e),t(l,xt,e),w(yl,l,e),t(l,zt,e),w(Jl,l,e),t(l,Nt,e),t(l,wl,e),t(l,Ft,e),t(l,ol,e),t(l,Lt,e),w(ml,l,e),t(l,qt,e),t(l,Tl,e),t(l,Kt,e),t(l,rl,e),t(l,Pt,e),t(l,cl,e),t(l,Dt,e),t(l,Ul,e),t(l,Ot,e),w(hl,l,e),t(l,la,e),t(l,jl,e),t(l,ea,e),t(l,Il,e),t(l,sa,e),w(ul,l,e),t(l,ta,e),w(dl,l,e),t(l,aa,e),w(Cl,l,e),t(l,na,e),t(l,bl,e),t(l,Ma,e),t(l,fl,e),t(l,pa,e),t(l,Bl,e),t(l,ia,e),t(l,gl,e),t(l,ya,e),t(l,Gl,e),t(l,Ja,e),t(l,Zl,e),t(l,wa,e),t(l,vl,e),t(l,oa,e),t(l,Al,e),t(l,ma,e),w(_l,l,e),t(l,Ta,e),w(Xl,l,e),t(l,ra,e),t(l,Wl,e),t(l,ca,e),t(l,kl,e),t(l,Ua,e),w(Sl,l,e),t(l,ha,e),w(Hl,l,e),t(l,ja,e),t(l,Vl,e),t(l,Ia,e),w(Ql,l,e),t(l,ua,e),w(Rl,l,e),t(l,da,e),t(l,$l,e),t(l,Ca,e),w(El,l,e),t(l,ba,e),w(Yl,l,e),t(l,fa,e),w(xl,l,e),t(l,Ba,e),w(zl,l,e),t(l,ga,e),t(l,Nl,e),t(l,Ga,e),t(l,Fl,e),t(l,Za,e),t(l,Ll,e),t(l,va,e),w(ql,l,e),t(l,Aa,e),t(l,Kl,e),t(l,_a,e),t(l,Pl,e),t(l,Xa,e),t(l,Dl,e),t(l,Wa,e),t(l,Ol,e),t(l,ka,e),t(l,le,e),t(l,Sa,e),w(ee,l,e),t(l,Ha,e),w(se,l,e),t(l,Va,e),w(te,l,e),t(l,Qa,e),w(ae,l,e),t(l,Ra,e),t(l,ne,e),t(l,$a,e),t(l,Me,e),t(l,Ea,e),t(l,pe,e),t(l,Ya,e),t(l,ie,e),t(l,xa,e),t(l,ye,e),t(l,za,e),w(Je,l,e),t(l,Na,e),w(we,l,e),t(l,Fa,e),w(oe,l,e),t(l,La,e),t(l,me,e),t(l,qa,e),t(l,Te,e),t(l,Ka,e),w(re,l,e),t(l,Pa,e),t(l,ce,e),t(l,Da,e),t(l,Ue,e),t(l,Oa,e),w(he,l,e),t(l,ln,e),w(je,l,e),t(l,en,e),t(l,Ie,e),t(l,sn,e),t(l,ue,e),t(l,tn,e),w(de,l,e),t(l,an,e),t(l,Ce,e),t(l,nn,e),t(l,be,e),t(l,Mn,e),t(l,fe,e),t(l,pn,e),t(l,Be,e),t(l,yn,e),t(l,ge,e),t(l,Jn,e),t(l,qs,e),U(qs,Ge),U(Ge,FM),U(Ge,Ks),U(Ge,j),U(j,Ps),U(j,LM),U(j,B),U(B,qM),wn.m(oy,B),U(B,on),mn.m(my,B),U(j,KM),U(j,g),U(g,PM),Tn.m(Ty,g),U(g,rn),U(g,Ds),U(j,DM),U(j,Os),U(Os,OM),U(Os,Ze),U(Ze,lp),cn.m(ry,Ze),U(Ze,Un),U(j,ep),U(j,ve),U(ve,sp),hn.m(cy,ve),U(ve,jn),U(j,tp),U(j,lt),U(lt,ap),In.m(Uy,lt),t(l,un,e),w(Ae,l,e),t(l,dn,e),w(_e,l,e),t(l,Cn,e),w(Xe,l,e),t(l,bn,e),w(We,l,e),t(l,fn,e),t(l,ke,e),t(l,Bn,e),w(Se,l,e),t(l,gn,e),w(He,l,e),t(l,Gn,e),w(Ve,l,e),t(l,Zn,e),w(Qe,l,e),t(l,vn,e),t(l,Re,e),t(l,An,e),w($e,l,e),t(l,_n,e),w(Ee,l,e),t(l,Xn,e),w(Ye,l,e),t(l,Wn,e),w(xe,l,e),t(l,kn,e),t(l,ze,e),t(l,Sn,e),t(l,Ne,e),t(l,Hn,e),t(l,et,e),t(l,Vn,e),w(Fe,l,e),t(l,Qn,e),w(Le,l,e),t(l,Rn,e),w(qe,l,e),t(l,$n,e),w(Ke,l,e),t(l,En,e),w(Pe,l,e),t(l,Yn,e),t(l,De,e),t(l,xn,e),t(l,Oe,e),t(l,zn,e),t(l,ls,e),t(l,Nn,e),t(l,es,e),t(l,Fn,e),t(l,ss,e),t(l,Ln,e),t(l,ts,e),t(l,qn,e),t(l,as,e),t(l,Kn,e),t(l,ns,e),t(l,Pn,e),w(Ms,l,e),t(l,Dn,e),t(l,ps,e),t(l,On,e),t(l,is,e),t(l,lM,e),w(ys,l,e),t(l,eM,e),t(l,Js,e),t(l,sM,e),w(ws,l,e),t(l,tM,e),w(os,l,e),t(l,aM,e),t(l,ms,e),t(l,nM,e),w(Ts,l,e),t(l,MM,e),w(rs,l,e),t(l,pM,e),w(cs,l,e),t(l,iM,e),t(l,Us,e),t(l,yM,e),t(l,hs,e),t(l,JM,e),t(l,js,e),t(l,wM,e),t(l,Is,e),t(l,oM,e),t(l,us,e),t(l,mM,e),t(l,ds,e),t(l,TM,e),w(Cs,l,e),t(l,rM,e),t(l,bs,e),t(l,cM,e),w(fs,l,e),t(l,UM,e),w(Bs,l,e),t(l,hM,e),w(gs,l,e),t(l,jM,e),w(Gs,l,e),t(l,IM,e),t(l,Zs,e),t(l,uM,e),w(vs,l,e),t(l,dM,e),w(As,l,e),t(l,CM,e),t(l,_s,e),t(l,bM,e),w(Xs,l,e),t(l,fM,e),w(Ws,l,e),t(l,BM,e),w(ks,l,e),t(l,gM,e),w(Ss,l,e),t(l,GM,e),w(Hs,l,e),t(l,ZM,e),t(l,Vs,e),t(l,vM,e),t(l,Qs,e),t(l,AM,e),t(l,Rs,e),t(l,_M,e),t(l,$s,e),t(l,XM,e),t(l,WM,e),t(l,kM,e),t(l,Es,e),t(l,SM,e),t(l,Ys,e),t(l,HM,e),t(l,xs,e),t(l,VM,e),t(l,zs,e),t(l,QM,e),t(l,Ns,e),t(l,RM,e),t(l,Fs,e),t(l,$M,e),w(Ls,l,e),t(l,EM,e),t(l,nt,e),YM=!0},p:jy,i(l){YM||(o(Z.$$.fragment,l),o(v.$$.fragment,l),o(Y.$$.fragment,l),o(D.$$.fragment,l),o(ll.$$.fragment,l),o(tl.$$.fragment,l),o(Ml.$$.fragment,l),o(yl.$$.fragment,l),o(Jl.$$.fragment,l),o(ml.$$.fragment,l),o(hl.$$.fragment,l),o(ul.$$.fragment,l),o(dl.$$.fragment,l),o(Cl.$$.fragment,l),o(_l.$$.fragment,l),o(Xl.$$.fragment,l),o(Sl.$$.fragment,l),o(Hl.$$.fragment,l),o(Ql.$$.fragment,l),o(Rl.$$.fragment,l),o(El.$$.fragment,l),o(Yl.$$.fragment,l),o(xl.$$.fragment,l),o(zl.$$.fragment,l),o(ql.$$.fragment,l),o(ee.$$.fragment,l),o(se.$$.fragment,l),o(te.$$.fragment,l),o(ae.$$.fragment,l),o(Je.$$.fragment,l),o(we.$$.fragment,l),o(oe.$$.fragment,l),o(re.$$.fragment,l),o(he.$$.fragment,l),o(je.$$.fragment,l),o(de.$$.fragment,l),o(Ae.$$.fragment,l),o(_e.$$.fragment,l),o(Xe.$$.fragment,l),o(We.$$.fragment,l),o(Se.$$.fragment,l),o(He.$$.fragment,l),o(Ve.$$.fragment,l),o(Qe.$$.fragment,l),o($e.$$.fragment,l),o(Ee.$$.fragment,l),o(Ye.$$.fragment,l),o(xe.$$.fragment,l),o(Fe.$$.fragment,l),o(Le.$$.fragment,l),o(qe.$$.fragment,l),o(Ke.$$.fragment,l),o(Pe.$$.fragment,l),o(Ms.$$.fragment,l),o(ys.$$.fragment,l),o(ws.$$.fragment,l),o(os.$$.fragment,l),o(Ts.$$.fragment,l),o(rs.$$.fragment,l),o(cs.$$.fragment,l),o(Cs.$$.fragment,l),o(fs.$$.fragment,l),o(Bs.$$.fragment,l),o(gs.$$.fragment,l),o(Gs.$$.fragment,l),o(vs.$$.fragment,l),o(As.$$.fragment,l),o(Xs.$$.fragment,l),o(Ws.$$.fragment,l),o(ks.$$.fragment,l),o(Ss.$$.fragment,l),o(Hs.$$.fragment,l),o(Ls.$$.fragment,l),YM=!0)},o(l){m(Z.$$.fragment,l),m(v.$$.fragment,l),m(Y.$$.fragment,l),m(D.$$.fragment,l),m(ll.$$.fragment,l),m(tl.$$.fragment,l),m(Ml.$$.fragment,l),m(yl.$$.fragment,l),m(Jl.$$.fragment,l),m(ml.$$.fragment,l),m(hl.$$.fragment,l),m(ul.$$.fragment,l),m(dl.$$.fragment,l),m(Cl.$$.fragment,l),m(_l.$$.fragment,l),m(Xl.$$.fragment,l),m(Sl.$$.fragment,l),m(Hl.$$.fragment,l),m(Ql.$$.fragment,l),m(Rl.$$.fragment,l),m(El.$$.fragment,l),m(Yl.$$.fragment,l),m(xl.$$.fragment,l),m(zl.$$.fragment,l),m(ql.$$.fragment,l),m(ee.$$.fragment,l),m(se.$$.fragment,l),m(te.$$.fragment,l),m(ae.$$.fragment,l),m(Je.$$.fragment,l),m(we.$$.fragment,l),m(oe.$$.fragment,l),m(re.$$.fragment,l),m(he.$$.fragment,l),m(je.$$.fragment,l),m(de.$$.fragment,l),m(Ae.$$.fragment,l),m(_e.$$.fragment,l),m(Xe.$$.fragment,l),m(We.$$.fragment,l),m(Se.$$.fragment,l),m(He.$$.fragment,l),m(Ve.$$.fragment,l),m(Qe.$$.fragment,l),m($e.$$.fragment,l),m(Ee.$$.fragment,l),m(Ye.$$.fragment,l),m(xe.$$.fragment,l),m(Fe.$$.fragment,l),m(Le.$$.fragment,l),m(qe.$$.fragment,l),m(Ke.$$.fragment,l),m(Pe.$$.fragment,l),m(Ms.$$.fragment,l),m(ys.$$.fragment,l),m(ws.$$.fragment,l),m(os.$$.fragment,l),m(Ts.$$.fragment,l),m(rs.$$.fragment,l),m(cs.$$.fragment,l),m(Cs.$$.fragment,l),m(fs.$$.fragment,l),m(Bs.$$.fragment,l),m(gs.$$.fragment,l),m(Gs.$$.fragment,l),m(vs.$$.fragment,l),m(As.$$.fragment,l),m(Xs.$$.fragment,l),m(Ws.$$.fragment,l),m(ks.$$.fragment,l),m(Ss.$$.fragment,l),m(Hs.$$.fragment,l),m(Ls.$$.fragment,l),YM=!1},d(l){l&&(s(it),s(at),s(yt),s(Jt),s(wt),s(A),s(ot),s(_),s(mt),s(f),s(Tt),s(X),s(rt),s(W),s(ct),s(k),s(Ut),s(S),s(ht),s(H),s(jt),s(V),s(It),s(Q),s(ut),s(R),s(dt),s($),s(Ct),s(E),s(bt),s(ft),s(x),s(Bt),s(z),s(gt),s(N),s(Gt),s(F),s(Zt),s(L),s(vt),s(q),s(At),s(K),s(_t),s(P),s(Xt),s(Wt),s(O),s(kt),s(St),s(el),s(Ht),s(sl),s(Vt),s(Qt),s(al),s(Rt),s(nl),s($t),s(Et),s(pl),s(Yt),s(il),s(xt),s(zt),s(Nt),s(wl),s(Ft),s(ol),s(Lt),s(qt),s(Tl),s(Kt),s(rl),s(Pt),s(cl),s(Dt),s(Ul),s(Ot),s(la),s(jl),s(ea),s(Il),s(sa),s(ta),s(aa),s(na),s(bl),s(Ma),s(fl),s(pa),s(Bl),s(ia),s(gl),s(ya),s(Gl),s(Ja),s(Zl),s(wa),s(vl),s(oa),s(Al),s(ma),s(Ta),s(ra),s(Wl),s(ca),s(kl),s(Ua),s(ha),s(ja),s(Vl),s(Ia),s(ua),s(da),s($l),s(Ca),s(ba),s(fa),s(Ba),s(ga),s(Nl),s(Ga),s(Fl),s(Za),s(Ll),s(va),s(Aa),s(Kl),s(_a),s(Pl),s(Xa),s(Dl),s(Wa),s(Ol),s(ka),s(le),s(Sa),s(Ha),s(Va),s(Qa),s(Ra),s(ne),s($a),s(Me),s(Ea),s(pe),s(Ya),s(ie),s(xa),s(ye),s(za),s(Na),s(Fa),s(La),s(me),s(qa),s(Te),s(Ka),s(Pa),s(ce),s(Da),s(Ue),s(Oa),s(ln),s(en),s(Ie),s(sn),s(ue),s(tn),s(an),s(Ce),s(nn),s(be),s(Mn),s(fe),s(pn),s(Be),s(yn),s(ge),s(Jn),s(qs),s(un),s(dn),s(Cn),s(bn),s(fn),s(ke),s(Bn),s(gn),s(Gn),s(Zn),s(vn),s(Re),s(An),s(_n),s(Xn),s(Wn),s(kn),s(ze),s(Sn),s(Ne),s(Hn),s(et),s(Vn),s(Qn),s(Rn),s($n),s(En),s(Yn),s(De),s(xn),s(Oe),s(zn),s(ls),s(Nn),s(es),s(Fn),s(ss),s(Ln),s(ts),s(qn),s(as),s(Kn),s(ns),s(Pn),s(Dn),s(ps),s(On),s(is),s(lM),s(eM),s(Js),s(sM),s(tM),s(aM),s(ms),s(nM),s(MM),s(pM),s(iM),s(Us),s(yM),s(hs),s(JM),s(js),s(wM),s(Is),s(oM),s(us),s(mM),s(ds),s(TM),s(rM),s(bs),s(cM),s(UM),s(hM),s(jM),s(IM),s(Zs),s(uM),s(dM),s(CM),s(_s),s(bM),s(fM),s(BM),s(gM),s(GM),s(ZM),s(Vs),s(vM),s(Qs),s(AM),s(Rs),s(_M),s($s),s(XM),s(WM),s(kM),s(Es),s(SM),s(Ys),s(HM),s(xs),s(VM),s(zs),s(QM),s(Ns),s(RM),s(Fs),s($M),s(EM),s(nt)),s(b),T(Z,l),T(v,l),T(Y,l),T(D,l),T(ll,l),T(tl,l),T(Ml,l),T(yl,l),T(Jl,l),T(ml,l),T(hl,l),T(ul,l),T(dl,l),T(Cl,l),T(_l,l),T(Xl,l),T(Sl,l),T(Hl,l),T(Ql,l),T(Rl,l),T(El,l),T(Yl,l),T(xl,l),T(zl,l),T(ql,l),T(ee,l),T(se,l),T(te,l),T(ae,l),T(Je,l),T(we,l),T(oe,l),T(re,l),T(he,l),T(je,l),T(de,l),T(Ae,l),T(_e,l),T(Xe,l),T(We,l),T(Se,l),T(He,l),T(Ve,l),T(Qe,l),T($e,l),T(Ee,l),T(Ye,l),T(xe,l),T(Fe,l),T(Le,l),T(qe,l),T(Ke,l),T(Pe,l),T(Ms,l),T(ys,l),T(ws,l),T(os,l),T(Ts,l),T(rs,l),T(cs,l),T(Cs,l),T(fs,l),T(Bs,l),T(gs,l),T(Gs,l),T(vs,l),T(As,l),T(Xs,l),T(Ws,l),T(ks,l),T(Ss,l),T(Hs,l),T(Ls,l)}}}const By='{"title":"Hands on","local":"hands-on","sections":[],"depth":1}';function gy(pp){return Iy(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xy extends uy{constructor(b){super(),dy(this,b,gy,fy,hy,{})}}export{Xy as component};
