import{s as Po,n as $o,o as Mo}from"../chunks/scheduler.0219f8bd.js";import{S as yo,i as go,g as c,s as r,r as p,A as bo,h as d,f as o,c as l,j as n,u as m,x as i,k as a,y as wo,a as s,v as f,d as u,t as _,w as h}from"../chunks/index.f61edf3b.js";import{C as vo}from"../chunks/CodeBlock.15473de1.js";import{H as T,E as xo}from"../chunks/index.ef6fbf3e.js";function jo(Yt){let P,$e,Te,Me,$,ye,M,ge,y,Xt="Processors are used to prepare inputs (e.g., text, image or audio) for a model.",be,g,Gt="<strong>Example:</strong> Using a <code>WhisperProcessor</code> to prepare an audio input for a model.",we,b,ve,w,Wt='<li><a href="#module_processors">processors</a><ul><li><em>static</em><ul><li><a href="#module_processors.Processor">.Processor</a><ul><li><a href="#new_module_processors.Processor_new"><code>new Processor(config, components)</code></a></li> <li><em>instance</em><ul><li><a href="#module_processors.Processor+image_processor"><code>.image_processor</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.Processor+tokenizer"><code>.tokenizer</code></a> ⇒ <code>PreTrainedTokenizer</code> | <code>undefined</code></li> <li><a href="#module_processors.Processor+feature_extractor"><code>.feature_extractor</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.Processor+apply_chat_template"><code>.apply_chat_template(messages, options)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.Processor+batch_decode"><code>.batch_decode(...args)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.Processor+decode"><code>.decode(...args)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.Processor+_call"><code>._call(input, ...args)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><em>static</em><ul><li><a href="#module_processors.Processor.from_pretrained"><code>.from_pretrained(pretrained_model_name_or_path, options)</code></a> ⇒ <code>Promise.&lt;Processor&gt;</code></li></ul></li></ul></li></ul></li> <li><em>inner</em><ul><li><a href="#module_processors..PreTrainedTokenizer"><code>~PreTrainedTokenizer</code></a> : <code>Object</code></li></ul></li></ul></li>',xe,je,He,v,Je,x,ke,j,Ft="Represents a Processor that extracts features from an input.",Le,H,Kt='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a>',Ce,J,Ot='<li><a href="#module_processors.Processor">.Processor</a><ul><li><a href="#new_module_processors.Processor_new"><code>new Processor(config, components)</code></a></li> <li><em>instance</em><ul><li><a href="#module_processors.Processor+image_processor"><code>.image_processor</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.Processor+tokenizer"><code>.tokenizer</code></a> ⇒ <code>PreTrainedTokenizer</code> | <code>undefined</code></li> <li><a href="#module_processors.Processor+feature_extractor"><code>.feature_extractor</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.Processor+apply_chat_template"><code>.apply_chat_template(messages, options)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.Processor+batch_decode"><code>.batch_decode(...args)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.Processor+decode"><code>.decode(...args)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.Processor+_call"><code>._call(input, ...args)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><em>static</em><ul><li><a href="#module_processors.Processor.from_pretrained"><code>.from_pretrained(pretrained_model_name_or_path, options)</code></a> ⇒ <code>Promise.&lt;Processor&gt;</code></li></ul></li></ul></li>',ze,Ae,Ue,k,Ee,L,Re,C,St="Creates a new Processor with the given components",Ie,z,Vt="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>config</td><td><code>Object</code></td> </tr><tr><td>components</td><td><code>Record.&lt;string, Object&gt;</code></td></tr></tbody>",Ne,Be,Qe,A,De,U,Ze,E,qt='<strong>Kind</strong>: instance property of <a href="#module_processors.Processor"><code>Processor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The image processor of the processor, if it exists.',Ye,Xe,Ge,R,We,I,Fe,N,eo='<strong>Kind</strong>: instance property of <a href="#module_processors.Processor"><code>Processor</code></a><br/> <strong>Returns</strong>: <code>PreTrainedTokenizer</code> | <code>undefined</code> - The tokenizer of the processor, if it exists.',Ke,Oe,Se,B,Ve,Q,qe,D,to='<strong>Kind</strong>: instance property of <a href="#module_processors.Processor"><code>Processor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The feature extractor of the processor, if it exists.',et,tt,ot,Z,st,Y,rt,X,oo='<strong>Kind</strong>: instance method of <a href="#module_processors.Processor"><code>Processor</code></a>',lt,G,so="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>messages</td><td><code>*</code></td> </tr><tr><td>options</td><td><code>*</code></td></tr></tbody>",ct,dt,it,W,at,F,pt,K,ro='<strong>Kind</strong>: instance method of <a href="#module_processors.Processor"><code>Processor</code></a>',nt,O,lo="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>...args</td><td><code>*</code></td></tr></tbody>",mt,ft,ut,S,_t,V,ht,q,co='<strong>Kind</strong>: instance method of <a href="#module_processors.Processor"><code>Processor</code></a>',Tt,ee,io="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>...args</td><td><code>*</code></td></tr></tbody>",Pt,$t,Mt,te,yt,oe,gt,se,ao="Calls the feature_extractor function with the given input.",bt,re,po='<strong>Kind</strong>: instance method of <a href="#module_processors.Processor"><code>Processor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - A Promise that resolves with the extracted features.',wt,le,no="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>any</code></td><td><p>The input to extract features from.</p></td> </tr><tr><td>...args</td><td><code>any</code></td><td><p>Additional arguments.</p></td></tr></tbody>",vt,xt,jt,ce,Ht,de,Jt,ie,mo="Instantiate one of the processor classes of the library from a pretrained model.",kt,ae,fo=`The processor class to instantiate is selected based on the <code>image_processor_type</code> (or <code>feature_extractor_type</code>; legacy)
property of the config object (either passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible)`,Lt,pe,uo='<strong>Kind</strong>: static method of <a href="#module_processors.Processor"><code>Processor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Processor&gt;</code> - A new instance of the Processor class.',Ct,ne,_o=`<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>pretrained_model_name_or_path</td><td><code>string</code></td><td><p>The name or path of the pretrained model. Can be either:</p> <ul><li>A string, the <em>model id</em> of a pretrained processor hosted inside a model repo on huggingface.co.
Valid model ids can be located at the root-level, like <code>bert-base-uncased</code>, or namespaced under a
user or organization name, like <code>dbmdz/bert-base-german-cased</code>.</li> <li>A path to a <em>directory</em> containing processor files, e.g., <code>./my_model_directory/</code>.</li></ul></td> </tr><tr><td>options</td><td><code>PretrainedProcessorOptions</code></td><td><p>Additional options for loading the processor.</p></td></tr></tbody>`,zt,At,Ut,me,Et,fe,Rt,ue,ho="Additional processor-specific properties.",It,_e,To='<strong>Kind</strong>: inner typedef of <a href="#module_processors"><code>processors</code></a>',Nt,Bt,Qt,he,Dt,Pe,Zt;return M=new T({props:{title:"processors",local:"processors",headingTag:"h1"}}),b=new vo({props:{code:"aW1wb3J0JTIwJTdCJTIwQXV0b1Byb2Nlc3NvciUyQyUyMHJlYWRfYXVkaW8lMjAlN0QlMjBmcm9tJTIwJyU0MGh1Z2dpbmdmYWNlJTJGdHJhbnNmb3JtZXJzJyUzQiUwQSUwQWNvbnN0JTIwcHJvY2Vzc29yJTIwJTNEJTIwYXdhaXQlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCgnb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJyklM0IlMEFjb25zdCUyMGF1ZGlvJTIwJTNEJTIwYXdhaXQlMjByZWFkX2F1ZGlvKCdodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZOYXJzaWwlMkZhc3JfZHVtbXklMkZyZXNvbHZlJTJGbWFpbiUyRm1say5mbGFjJyUyQyUyMDE2MDAwKSUzQiUwQWNvbnN0JTIwJTdCJTIwaW5wdXRfZmVhdHVyZXMlMjAlN0QlMjAlM0QlMjBhd2FpdCUyMHByb2Nlc3NvcihhdWRpbyklM0IlMEElMkYlMkYlMjBUZW5zb3IlMjAlN0IlMEElMkYlMkYlMjAlMjAlMjBkYXRhJTNBJTIwRmxvYXQzMkFycmF5KDI0MDAwMCklMjAlNUIwLjQ3NTI5ODQ2NDI5ODI0ODMlMkMlMjAwLjU1OTcyNTg4MDYyMjg2MzglMkMlMjAwLjU2NDM0MTY2NDMxNDI3JTJDJTIwLi4uJTVEJTJDJTBBJTJGJTJGJTIwJTIwJTIwZGltcyUzQSUyMCU1QjElMkMlMjA4MCUyQyUyMDMwMDAlNUQlMkMlMEElMkYlMkYlMjAlMjAlMjB0eXBlJTNBJTIwJ2Zsb2F0MzInJTJDJTBBJTJGJTJGJTIwJTIwJTIwc2l6ZSUzQSUyMDI0MDAwMCUyQyUwQSUyRiUyRiUyMCU3RA==",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">AutoProcessor</span>, read_audio } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;@huggingface/transformers&#x27;</span>;

<span class="hljs-keyword">const</span> processor = <span class="hljs-keyword">await</span> <span class="hljs-title class_">AutoProcessor</span>.<span class="hljs-title function_">from_pretrained</span>(<span class="hljs-string">&#x27;openai/whisper-tiny.en&#x27;</span>);
<span class="hljs-keyword">const</span> audio = <span class="hljs-keyword">await</span> <span class="hljs-title function_">read_audio</span>(<span class="hljs-string">&#x27;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&#x27;</span>, <span class="hljs-number">16000</span>);
<span class="hljs-keyword">const</span> { input_features } = <span class="hljs-keyword">await</span> <span class="hljs-title function_">processor</span>(audio);
<span class="hljs-comment">// Tensor {</span>
<span class="hljs-comment">//   data: Float32Array(240000) [0.4752984642982483, 0.5597258806228638, 0.56434166431427, ...],</span>
<span class="hljs-comment">//   dims: [1, 80, 3000],</span>
<span class="hljs-comment">//   type: &#x27;float32&#x27;,</span>
<span class="hljs-comment">//   size: 240000,</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),x=new T({props:{title:"processors.Processor",local:"processorsprocessor",headingTag:"h2"}}),L=new T({props:{title:"new Processor(config, components)",local:"new-processorconfig-components",headingTag:"h3"}}),U=new T({props:{title:"processor.image_processor ⇒ <code> * </code>",local:"processorimageprocessor--code--code",headingTag:"h3"}}),I=new T({props:{title:"processor.tokenizer ⇒ <code> PreTrainedTokenizer </code> | <code> undefined </code>",local:"processortokenizer--code-pretrainedtokenizer-code--code-undefined-code",headingTag:"h3"}}),Q=new T({props:{title:"processor.feature_extractor ⇒ <code> * </code>",local:"processorfeatureextractor--code--code",headingTag:"h3"}}),Y=new T({props:{title:"processor.apply_chat_template(messages, options) ⇒ <code> * </code>",local:"processorapplychattemplatemessages-options--code--code",headingTag:"h3"}}),F=new T({props:{title:"processor.batch_decode(...args) ⇒ <code> * </code>",local:"processorbatchdecodeargs--code--code",headingTag:"h3"}}),V=new T({props:{title:"processor.decode(...args) ⇒ <code> * </code>",local:"processordecodeargs--code--code",headingTag:"h3"}}),oe=new T({props:{title:"processor._call(input, ...args) ⇒ <code> Promise. < any > </code>",local:"processorcallinput-args--code-promise--any--code",headingTag:"h3"}}),de=new T({props:{title:"Processor.from_pretrained(pretrained_model_name_or_path, options) ⇒ <code> Promise. < Processor > </code>",local:"processorfrompretrainedpretrainedmodelnameorpath-options--code-promise--processor--code",headingTag:"h3"}}),fe=new T({props:{title:"processors~PreTrainedTokenizer : <code> Object </code>",local:"processorspretrainedtokenizer--code-object-code",headingTag:"h2"}}),he=new xo({props:{source:"https://github.com/huggingface/transformers.js/blob/main/docs/source/api/processors.md"}}),{c(){P=c("meta"),$e=r(),Te=c("p"),Me=r(),$=c("a"),ye=r(),p(M.$$.fragment),ge=r(),y=c("p"),y.textContent=Xt,be=r(),g=c("p"),g.innerHTML=Gt,we=r(),p(b.$$.fragment),ve=r(),w=c("ul"),w.innerHTML=Wt,xe=r(),je=c("hr"),He=r(),v=c("a"),Je=r(),p(x.$$.fragment),ke=r(),j=c("p"),j.textContent=Ft,Le=r(),H=c("p"),H.innerHTML=Kt,Ce=r(),J=c("ul"),J.innerHTML=Ot,ze=r(),Ae=c("hr"),Ue=r(),k=c("a"),Ee=r(),p(L.$$.fragment),Re=r(),C=c("p"),C.textContent=St,Ie=r(),z=c("table"),z.innerHTML=Vt,Ne=r(),Be=c("hr"),Qe=r(),A=c("a"),De=r(),p(U.$$.fragment),Ze=r(),E=c("p"),E.innerHTML=qt,Ye=r(),Xe=c("hr"),Ge=r(),R=c("a"),We=r(),p(I.$$.fragment),Fe=r(),N=c("p"),N.innerHTML=eo,Ke=r(),Oe=c("hr"),Se=r(),B=c("a"),Ve=r(),p(Q.$$.fragment),qe=r(),D=c("p"),D.innerHTML=to,et=r(),tt=c("hr"),ot=r(),Z=c("a"),st=r(),p(Y.$$.fragment),rt=r(),X=c("p"),X.innerHTML=oo,lt=r(),G=c("table"),G.innerHTML=so,ct=r(),dt=c("hr"),it=r(),W=c("a"),at=r(),p(F.$$.fragment),pt=r(),K=c("p"),K.innerHTML=ro,nt=r(),O=c("table"),O.innerHTML=lo,mt=r(),ft=c("hr"),ut=r(),S=c("a"),_t=r(),p(V.$$.fragment),ht=r(),q=c("p"),q.innerHTML=co,Tt=r(),ee=c("table"),ee.innerHTML=io,Pt=r(),$t=c("hr"),Mt=r(),te=c("a"),yt=r(),p(oe.$$.fragment),gt=r(),se=c("p"),se.textContent=ao,bt=r(),re=c("p"),re.innerHTML=po,wt=r(),le=c("table"),le.innerHTML=no,vt=r(),xt=c("hr"),jt=r(),ce=c("a"),Ht=r(),p(de.$$.fragment),Jt=r(),ie=c("p"),ie.textContent=mo,kt=r(),ae=c("p"),ae.innerHTML=fo,Lt=r(),pe=c("p"),pe.innerHTML=uo,Ct=r(),ne=c("table"),ne.innerHTML=_o,zt=r(),At=c("hr"),Ut=r(),me=c("a"),Et=r(),p(fe.$$.fragment),Rt=r(),ue=c("p"),ue.textContent=ho,It=r(),_e=c("p"),_e.innerHTML=To,Nt=r(),Bt=c("hr"),Qt=r(),p(he.$$.fragment),Dt=r(),Pe=c("p"),this.h()},l(e){const t=bo("svelte-u9bgzb",document.head);P=d(t,"META",{name:!0,content:!0}),t.forEach(o),$e=l(e),Te=d(e,"P",{}),n(Te).forEach(o),Me=l(e),$=d(e,"A",{id:!0,class:!0}),n($).forEach(o),ye=l(e),m(M.$$.fragment,e),ge=l(e),y=d(e,"P",{"data-svelte-h":!0}),i(y)!=="svelte-199vh5q"&&(y.textContent=Xt),be=l(e),g=d(e,"P",{"data-svelte-h":!0}),i(g)!=="svelte-1olsie5"&&(g.innerHTML=Gt),we=l(e),m(b.$$.fragment,e),ve=l(e),w=d(e,"UL",{"data-svelte-h":!0}),i(w)!=="svelte-1lu2rmo"&&(w.innerHTML=Wt),xe=l(e),je=d(e,"HR",{}),He=l(e),v=d(e,"A",{id:!0,class:!0}),n(v).forEach(o),Je=l(e),m(x.$$.fragment,e),ke=l(e),j=d(e,"P",{"data-svelte-h":!0}),i(j)!=="svelte-o9f953"&&(j.textContent=Ft),Le=l(e),H=d(e,"P",{"data-svelte-h":!0}),i(H)!=="svelte-wmyz1o"&&(H.innerHTML=Kt),Ce=l(e),J=d(e,"UL",{"data-svelte-h":!0}),i(J)!=="svelte-19s2rn"&&(J.innerHTML=Ot),ze=l(e),Ae=d(e,"HR",{}),Ue=l(e),k=d(e,"A",{id:!0,class:!0}),n(k).forEach(o),Ee=l(e),m(L.$$.fragment,e),Re=l(e),C=d(e,"P",{"data-svelte-h":!0}),i(C)!=="svelte-rj7jmq"&&(C.textContent=St),Ie=l(e),z=d(e,"TABLE",{"data-svelte-h":!0}),i(z)!=="svelte-4j8lfj"&&(z.innerHTML=Vt),Ne=l(e),Be=d(e,"HR",{}),Qe=l(e),A=d(e,"A",{id:!0,class:!0}),n(A).forEach(o),De=l(e),m(U.$$.fragment,e),Ze=l(e),E=d(e,"P",{"data-svelte-h":!0}),i(E)!=="svelte-gyqxdz"&&(E.innerHTML=qt),Ye=l(e),Xe=d(e,"HR",{}),Ge=l(e),R=d(e,"A",{id:!0,class:!0}),n(R).forEach(o),We=l(e),m(I.$$.fragment,e),Fe=l(e),N=d(e,"P",{"data-svelte-h":!0}),i(N)!=="svelte-ao82kh"&&(N.innerHTML=eo),Ke=l(e),Oe=d(e,"HR",{}),Se=l(e),B=d(e,"A",{id:!0,class:!0}),n(B).forEach(o),Ve=l(e),m(Q.$$.fragment,e),qe=l(e),D=d(e,"P",{"data-svelte-h":!0}),i(D)!=="svelte-iz9woy"&&(D.innerHTML=to),et=l(e),tt=d(e,"HR",{}),ot=l(e),Z=d(e,"A",{id:!0,class:!0}),n(Z).forEach(o),st=l(e),m(Y.$$.fragment,e),rt=l(e),X=d(e,"P",{"data-svelte-h":!0}),i(X)!=="svelte-jg083b"&&(X.innerHTML=oo),lt=l(e),G=d(e,"TABLE",{"data-svelte-h":!0}),i(G)!=="svelte-1dyy5ym"&&(G.innerHTML=so),ct=l(e),dt=d(e,"HR",{}),it=l(e),W=d(e,"A",{id:!0,class:!0}),n(W).forEach(o),at=l(e),m(F.$$.fragment,e),pt=l(e),K=d(e,"P",{"data-svelte-h":!0}),i(K)!=="svelte-jg083b"&&(K.innerHTML=ro),nt=l(e),O=d(e,"TABLE",{"data-svelte-h":!0}),i(O)!=="svelte-ee7emz"&&(O.innerHTML=lo),mt=l(e),ft=d(e,"HR",{}),ut=l(e),S=d(e,"A",{id:!0,class:!0}),n(S).forEach(o),_t=l(e),m(V.$$.fragment,e),ht=l(e),q=d(e,"P",{"data-svelte-h":!0}),i(q)!=="svelte-jg083b"&&(q.innerHTML=co),Tt=l(e),ee=d(e,"TABLE",{"data-svelte-h":!0}),i(ee)!=="svelte-ee7emz"&&(ee.innerHTML=io),Pt=l(e),$t=d(e,"HR",{}),Mt=l(e),te=d(e,"A",{id:!0,class:!0}),n(te).forEach(o),yt=l(e),m(oe.$$.fragment,e),gt=l(e),se=d(e,"P",{"data-svelte-h":!0}),i(se)!=="svelte-zbbm3j"&&(se.textContent=ao),bt=l(e),re=d(e,"P",{"data-svelte-h":!0}),i(re)!=="svelte-kflsb2"&&(re.innerHTML=po),wt=l(e),le=d(e,"TABLE",{"data-svelte-h":!0}),i(le)!=="svelte-pm1u9z"&&(le.innerHTML=no),vt=l(e),xt=d(e,"HR",{}),jt=l(e),ce=d(e,"A",{id:!0,class:!0}),n(ce).forEach(o),Ht=l(e),m(de.$$.fragment,e),Jt=l(e),ie=d(e,"P",{"data-svelte-h":!0}),i(ie)!=="svelte-jwfdp9"&&(ie.textContent=mo),kt=l(e),ae=d(e,"P",{"data-svelte-h":!0}),i(ae)!=="svelte-1l7cuz8"&&(ae.innerHTML=fo),Lt=l(e),pe=d(e,"P",{"data-svelte-h":!0}),i(pe)!=="svelte-vp40qx"&&(pe.innerHTML=uo),Ct=l(e),ne=d(e,"TABLE",{"data-svelte-h":!0}),i(ne)!=="svelte-fupyjd"&&(ne.innerHTML=_o),zt=l(e),At=d(e,"HR",{}),Ut=l(e),me=d(e,"A",{id:!0,class:!0}),n(me).forEach(o),Et=l(e),m(fe.$$.fragment,e),Rt=l(e),ue=d(e,"P",{"data-svelte-h":!0}),i(ue)!=="svelte-ivm759"&&(ue.textContent=ho),It=l(e),_e=d(e,"P",{"data-svelte-h":!0}),i(_e)!=="svelte-3xndnt"&&(_e.innerHTML=To),Nt=l(e),Bt=d(e,"HR",{}),Qt=l(e),m(he.$$.fragment,e),Dt=l(e),Pe=d(e,"P",{}),n(Pe).forEach(o),this.h()},h(){a(P,"name","hf:doc:metadata"),a(P,"content",Ho),a($,"id","module_processors"),a($,"class","group"),a(v,"id","module_processors.Processor"),a(v,"class","group"),a(k,"id","new_module_processors.Processor_new"),a(k,"class","group"),a(A,"id","module_processors.Processor+image_processor"),a(A,"class","group"),a(R,"id","module_processors.Processor+tokenizer"),a(R,"class","group"),a(B,"id","module_processors.Processor+feature_extractor"),a(B,"class","group"),a(Z,"id","module_processors.Processor+apply_chat_template"),a(Z,"class","group"),a(W,"id","module_processors.Processor+batch_decode"),a(W,"class","group"),a(S,"id","module_processors.Processor+decode"),a(S,"class","group"),a(te,"id","module_processors.Processor+_call"),a(te,"class","group"),a(ce,"id","module_processors.Processor.from_pretrained"),a(ce,"class","group"),a(me,"id","module_processors..PreTrainedTokenizer"),a(me,"class","group")},m(e,t){wo(document.head,P),s(e,$e,t),s(e,Te,t),s(e,Me,t),s(e,$,t),s(e,ye,t),f(M,e,t),s(e,ge,t),s(e,y,t),s(e,be,t),s(e,g,t),s(e,we,t),f(b,e,t),s(e,ve,t),s(e,w,t),s(e,xe,t),s(e,je,t),s(e,He,t),s(e,v,t),s(e,Je,t),f(x,e,t),s(e,ke,t),s(e,j,t),s(e,Le,t),s(e,H,t),s(e,Ce,t),s(e,J,t),s(e,ze,t),s(e,Ae,t),s(e,Ue,t),s(e,k,t),s(e,Ee,t),f(L,e,t),s(e,Re,t),s(e,C,t),s(e,Ie,t),s(e,z,t),s(e,Ne,t),s(e,Be,t),s(e,Qe,t),s(e,A,t),s(e,De,t),f(U,e,t),s(e,Ze,t),s(e,E,t),s(e,Ye,t),s(e,Xe,t),s(e,Ge,t),s(e,R,t),s(e,We,t),f(I,e,t),s(e,Fe,t),s(e,N,t),s(e,Ke,t),s(e,Oe,t),s(e,Se,t),s(e,B,t),s(e,Ve,t),f(Q,e,t),s(e,qe,t),s(e,D,t),s(e,et,t),s(e,tt,t),s(e,ot,t),s(e,Z,t),s(e,st,t),f(Y,e,t),s(e,rt,t),s(e,X,t),s(e,lt,t),s(e,G,t),s(e,ct,t),s(e,dt,t),s(e,it,t),s(e,W,t),s(e,at,t),f(F,e,t),s(e,pt,t),s(e,K,t),s(e,nt,t),s(e,O,t),s(e,mt,t),s(e,ft,t),s(e,ut,t),s(e,S,t),s(e,_t,t),f(V,e,t),s(e,ht,t),s(e,q,t),s(e,Tt,t),s(e,ee,t),s(e,Pt,t),s(e,$t,t),s(e,Mt,t),s(e,te,t),s(e,yt,t),f(oe,e,t),s(e,gt,t),s(e,se,t),s(e,bt,t),s(e,re,t),s(e,wt,t),s(e,le,t),s(e,vt,t),s(e,xt,t),s(e,jt,t),s(e,ce,t),s(e,Ht,t),f(de,e,t),s(e,Jt,t),s(e,ie,t),s(e,kt,t),s(e,ae,t),s(e,Lt,t),s(e,pe,t),s(e,Ct,t),s(e,ne,t),s(e,zt,t),s(e,At,t),s(e,Ut,t),s(e,me,t),s(e,Et,t),f(fe,e,t),s(e,Rt,t),s(e,ue,t),s(e,It,t),s(e,_e,t),s(e,Nt,t),s(e,Bt,t),s(e,Qt,t),f(he,e,t),s(e,Dt,t),s(e,Pe,t),Zt=!0},p:$o,i(e){Zt||(u(M.$$.fragment,e),u(b.$$.fragment,e),u(x.$$.fragment,e),u(L.$$.fragment,e),u(U.$$.fragment,e),u(I.$$.fragment,e),u(Q.$$.fragment,e),u(Y.$$.fragment,e),u(F.$$.fragment,e),u(V.$$.fragment,e),u(oe.$$.fragment,e),u(de.$$.fragment,e),u(fe.$$.fragment,e),u(he.$$.fragment,e),Zt=!0)},o(e){_(M.$$.fragment,e),_(b.$$.fragment,e),_(x.$$.fragment,e),_(L.$$.fragment,e),_(U.$$.fragment,e),_(I.$$.fragment,e),_(Q.$$.fragment,e),_(Y.$$.fragment,e),_(F.$$.fragment,e),_(V.$$.fragment,e),_(oe.$$.fragment,e),_(de.$$.fragment,e),_(fe.$$.fragment,e),_(he.$$.fragment,e),Zt=!1},d(e){e&&(o($e),o(Te),o(Me),o($),o(ye),o(ge),o(y),o(be),o(g),o(we),o(ve),o(w),o(xe),o(je),o(He),o(v),o(Je),o(ke),o(j),o(Le),o(H),o(Ce),o(J),o(ze),o(Ae),o(Ue),o(k),o(Ee),o(Re),o(C),o(Ie),o(z),o(Ne),o(Be),o(Qe),o(A),o(De),o(Ze),o(E),o(Ye),o(Xe),o(Ge),o(R),o(We),o(Fe),o(N),o(Ke),o(Oe),o(Se),o(B),o(Ve),o(qe),o(D),o(et),o(tt),o(ot),o(Z),o(st),o(rt),o(X),o(lt),o(G),o(ct),o(dt),o(it),o(W),o(at),o(pt),o(K),o(nt),o(O),o(mt),o(ft),o(ut),o(S),o(_t),o(ht),o(q),o(Tt),o(ee),o(Pt),o($t),o(Mt),o(te),o(yt),o(gt),o(se),o(bt),o(re),o(wt),o(le),o(vt),o(xt),o(jt),o(ce),o(Ht),o(Jt),o(ie),o(kt),o(ae),o(Lt),o(pe),o(Ct),o(ne),o(zt),o(At),o(Ut),o(me),o(Et),o(Rt),o(ue),o(It),o(_e),o(Nt),o(Bt),o(Qt),o(Dt),o(Pe)),o(P),h(M,e),h(b,e),h(x,e),h(L,e),h(U,e),h(I,e),h(Q,e),h(Y,e),h(F,e),h(V,e),h(oe,e),h(de,e),h(fe,e),h(he,e)}}}const Ho='{"title":"processors","local":"processors","sections":[{"title":"processors.Processor","local":"processorsprocessor","sections":[{"title":"new Processor(config, components)","local":"new-processorconfig-components","sections":[],"depth":3},{"title":"processor.image_processor ⇒ <code> * </code>","local":"processorimageprocessor--code--code","sections":[],"depth":3},{"title":"processor.tokenizer ⇒ <code> PreTrainedTokenizer </code> | <code> undefined </code>","local":"processortokenizer--code-pretrainedtokenizer-code--code-undefined-code","sections":[],"depth":3},{"title":"processor.feature_extractor ⇒ <code> * </code>","local":"processorfeatureextractor--code--code","sections":[],"depth":3},{"title":"processor.apply_chat_template(messages, options) ⇒ <code> * </code>","local":"processorapplychattemplatemessages-options--code--code","sections":[],"depth":3},{"title":"processor.batch_decode(...args) ⇒ <code> * </code>","local":"processorbatchdecodeargs--code--code","sections":[],"depth":3},{"title":"processor.decode(...args) ⇒ <code> * </code>","local":"processordecodeargs--code--code","sections":[],"depth":3},{"title":"processor._call(input, ...args) ⇒ <code> Promise. < any > </code>","local":"processorcallinput-args--code-promise--any--code","sections":[],"depth":3},{"title":"Processor.from_pretrained(pretrained_model_name_or_path, options) ⇒ <code> Promise. < Processor > </code>","local":"processorfrompretrainedpretrainedmodelnameorpath-options--code-promise--processor--code","sections":[],"depth":3}],"depth":2},{"title":"processors~PreTrainedTokenizer : <code> Object </code>","local":"processorspretrainedtokenizer--code-object-code","sections":[],"depth":2}],"depth":1}';function Jo(Yt){return Mo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ao extends yo{constructor(P){super(),go(this,P,Jo,jo,Po,{})}}export{Ao as component};
