import{s as Bi,n as Ki,o as Yi}from"../chunks/scheduler.0219f8bd.js";import{S as Ji,i as Ni,g as d,s as i,r as g,A as qi,h as o,f as a,c as m,j as n,u,x as s,k as r,y as Oi,a as l,v as c,d as f,t as p,w as h}from"../chunks/index.f61edf3b.js";import{C as Gi}from"../chunks/CodeBlock.15473de1.js";import{H as w,E as Si}from"../chunks/index.ef6fbf3e.js";function Di(Bl){let R,st,dt,rt,I,gt,v,nt,$,Kl="Helper module for image processing.",ut,_,Yl=`These functions and classes are only used internally,
meaning an end-user shouldn’t need to access anything here.`,ct,T,Jl='<li><a href="#module_utils/image">utils/image</a><ul><li><em>static</em><ul><li><a href="#module_utils/image.RawImage">.RawImage</a><ul><li><a href="#new_module_utils/image.RawImage_new"><code>new RawImage(data, width, height, channels)</code></a></li> <li><em>instance</em><ul><li><a href="#module_utils/image.RawImage+size"><code>.size</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/image.RawImage+grayscale"><code>.grayscale()</code></a> ⇒ <a href="#RawImage"><code>RawImage</code></a></li> <li><a href="#module_utils/image.RawImage+rgb"><code>.rgb()</code></a> ⇒ <a href="#RawImage"><code>RawImage</code></a></li> <li><a href="#module_utils/image.RawImage+rgba"><code>.rgba()</code></a> ⇒ <a href="#RawImage"><code>RawImage</code></a></li> <li><a href="#module_utils/image.RawImage+putAlpha"><code>.putAlpha(mask)</code></a> ⇒ <a href="#RawImage"><code>RawImage</code></a></li> <li><a href="#module_utils/image.RawImage+resize"><code>.resize(width, height, options)</code></a> ⇒ <a href="#RawImage"><code>Promise.&lt;RawImage&gt;</code></a></li> <li><a href="#module_utils/image.RawImage+split"><code>.split()</code></a> ⇒ <a href="#RawImage"><code>Array.&lt;RawImage&gt;</code></a></li> <li><a href="#module_utils/image.RawImage+clone"><code>.clone()</code></a> ⇒ <a href="#RawImage"><code>RawImage</code></a></li> <li><a href="#module_utils/image.RawImage+convert"><code>.convert(numChannels)</code></a> ⇒ <a href="#RawImage"><code>RawImage</code></a></li> <li><a href="#module_utils/image.RawImage+save"><code>.save(path)</code></a></li></ul></li> <li><em>static</em><ul><li><a href="#module_utils/image.RawImage.read"><code>.read(input)</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/image.RawImage.fromCanvas"><code>.fromCanvas(canvas)</code></a> ⇒ <a href="#RawImage"><code>RawImage</code></a></li> <li><a href="#module_utils/image.RawImage.fromURL"><code>.fromURL(url)</code></a> ⇒ <a href="#RawImage"><code>Promise.&lt;RawImage&gt;</code></a></li> <li><a href="#module_utils/image.RawImage.fromBlob"><code>.fromBlob(blob)</code></a> ⇒ <a href="#RawImage"><code>Promise.&lt;RawImage&gt;</code></a></li> <li><a href="#module_utils/image.RawImage.fromTensor"><code>.fromTensor(tensor)</code></a></li></ul></li></ul></li> <li><a href="#module_utils/image.load_image"><code>.load_image</code></a></li></ul></li> <li><em>inner</em><ul><li><a href="#module_utils/image..CONTENT_TYPE_MAP"><code>~CONTENT_TYPE_MAP</code></a></li></ul></li></ul></li>',ft,pt,ht,b,wt,C,Rt,x,Nl='<strong>Kind</strong>: static class of <a href="#module_utils/image"><code>utils/image</code></a>',It,H,ql='<li><a href="#module_utils/image.RawImage">.RawImage</a><ul><li><a href="#new_module_utils/image.RawImage_new"><code>new RawImage(data, width, height, channels)</code></a></li> <li><em>instance</em><ul><li><a href="#module_utils/image.RawImage+size"><code>.size</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/image.RawImage+grayscale"><code>.grayscale()</code></a> ⇒ <a href="#RawImage"><code>RawImage</code></a></li> <li><a href="#module_utils/image.RawImage+rgb"><code>.rgb()</code></a> ⇒ <a href="#RawImage"><code>RawImage</code></a></li> <li><a href="#module_utils/image.RawImage+rgba"><code>.rgba()</code></a> ⇒ <a href="#RawImage"><code>RawImage</code></a></li> <li><a href="#module_utils/image.RawImage+putAlpha"><code>.putAlpha(mask)</code></a> ⇒ <a href="#RawImage"><code>RawImage</code></a></li> <li><a href="#module_utils/image.RawImage+resize"><code>.resize(width, height, options)</code></a> ⇒ <a href="#RawImage"><code>Promise.&lt;RawImage&gt;</code></a></li> <li><a href="#module_utils/image.RawImage+split"><code>.split()</code></a> ⇒ <a href="#RawImage"><code>Array.&lt;RawImage&gt;</code></a></li> <li><a href="#module_utils/image.RawImage+clone"><code>.clone()</code></a> ⇒ <a href="#RawImage"><code>RawImage</code></a></li> <li><a href="#module_utils/image.RawImage+convert"><code>.convert(numChannels)</code></a> ⇒ <a href="#RawImage"><code>RawImage</code></a></li> <li><a href="#module_utils/image.RawImage+save"><code>.save(path)</code></a></li></ul></li> <li><em>static</em><ul><li><a href="#module_utils/image.RawImage.read"><code>.read(input)</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/image.RawImage.fromCanvas"><code>.fromCanvas(canvas)</code></a> ⇒ <a href="#RawImage"><code>RawImage</code></a></li> <li><a href="#module_utils/image.RawImage.fromURL"><code>.fromURL(url)</code></a> ⇒ <a href="#RawImage"><code>Promise.&lt;RawImage&gt;</code></a></li> <li><a href="#module_utils/image.RawImage.fromBlob"><code>.fromBlob(blob)</code></a> ⇒ <a href="#RawImage"><code>Promise.&lt;RawImage&gt;</code></a></li> <li><a href="#module_utils/image.RawImage.fromTensor"><code>.fromTensor(tensor)</code></a></li></ul></li></ul></li>',vt,$t,_t,L,Tt,y,bt,M,Ol="Create a new <code>RawImage</code> object.",Ct,P,Gl="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>Uint8ClampedArray</code> | <code>Uint8Array</code></td><td><p>The pixel data.</p></td> </tr><tr><td>width</td><td><code>number</code></td><td><p>The width of the image.</p></td> </tr><tr><td>height</td><td><code>number</code></td><td><p>The height of the image.</p></td> </tr><tr><td>channels</td><td><code>1</code> | <code>2</code> | <code>3</code> | <code>4</code></td><td><p>The number of channels.</p></td></tr></tbody>",xt,Ht,Lt,A,yt,E,Mt,z,Sl="Returns the size of the image (width, height).",Pt,j,Dl='<strong>Kind</strong>: instance property of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>*</code> - The size of the image (width, height).',At,Et,zt,k,jt,U,kt,B,Zl="Convert the image to grayscale format.",Ut,K,Wl='<strong>Kind</strong>: instance method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <a href="#RawImage"><code>RawImage</code></a> - <code>this</code> to support chaining.',Bt,Kt,Yt,Y,Jt,J,Nt,N,Fl="Convert the image to RGB format.",qt,q,Vl='<strong>Kind</strong>: instance method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <a href="#RawImage"><code>RawImage</code></a> - <code>this</code> to support chaining.',Ot,Gt,St,O,Dt,G,Zt,S,Ql="Convert the image to RGBA format.",Wt,D,Xl='<strong>Kind</strong>: instance method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <a href="#RawImage"><code>RawImage</code></a> - <code>this</code> to support chaining.',Ft,Vt,Qt,Z,Xt,W,ea,F,ei="Apply an alpha mask to the image. Operates in place.",ta,V,ti='<strong>Kind</strong>: instance method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <a href="#RawImage"><code>RawImage</code></a> - The masked image.<br/> <strong>Throws</strong>:',aa,Q,ai="<li><code>Error</code> If the mask is not the same size as the image.</li> <li><code>Error</code> If the image does not have 4 channels.</li> <li><code>Error</code> If the mask is not a single channel.</li>",la,X,li='<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>mask</td><td><code><a href="#RawImage">RawImage</a></code></td><td><p>The mask to apply. It should have a single channel.</p></td></tr></tbody>',ia,ma,da,ee,oa,te,sa,ae,ii="Resize the image to the given dimensions. This method uses the canvas API to perform the resizing.",ra,le,mi='<strong>Kind</strong>: instance method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <a href="#RawImage"><code>Promise.&lt;RawImage&gt;</code></a> - <code>this</code> to support chaining.',ga,ie,di="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>width</td><td><code>number</code></td><td><p>The width of the new image. <code>null</code> or <code>-1</code> will preserve the aspect ratio.</p></td> </tr><tr><td>height</td><td><code>number</code></td><td><p>The height of the new image. <code>null</code> or <code>-1</code> will preserve the aspect ratio.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td><p>Additional options for resizing.</p></td> </tr><tr><td>[options.resample]</td><td><code>0</code> | <code>1</code> | <code>2</code> | <code>3</code> | <code>4</code> | <code>5</code> | <code>string</code></td><td><p>The resampling method to use.</p></td></tr></tbody>",na,ua,ca,me,fa,de,pa,oe,oi=`Split this image into individual bands. This method returns an array of individual image bands from an image.
For example, splitting an “RGB” image creates three new images each containing a copy of one of the original bands (red, green, blue).`,ha,se,si='Inspired by PIL’s <code>Image.split()</code> <a href="https://pillow.readthedocs.io/en/latest/reference/Image.html#PIL.Image.Image.split" rel="nofollow">function</a>.',wa,re,ri='<strong>Kind</strong>: instance method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <a href="#RawImage"><code>Array.&lt;RawImage&gt;</code></a> - An array containing bands.',Ra,Ia,va,ge,$a,ne,_a,ue,gi="Clone the image",Ta,ce,ni='<strong>Kind</strong>: instance method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <a href="#RawImage"><code>RawImage</code></a> - The cloned image',ba,Ca,xa,fe,Ha,pe,La,he,ui="Helper method for converting image to have a certain number of channels",ya,we,ci='<strong>Kind</strong>: instance method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <a href="#RawImage"><code>RawImage</code></a> - <code>this</code> to support chaining.',Ma,Re,fi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>numChannels</td><td><code>number</code></td><td><p>The number of channels. Must be 1, 3, or 4.</p></td></tr></tbody>",Pa,Aa,Ea,Ie,za,ve,ja,$e,pi="Save the image to the given path.",ka,_e,hi='<strong>Kind</strong>: instance method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a>',Ua,Te,wi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>path</td><td><code>string</code></td><td><p>The path to save the image to.</p></td></tr></tbody>",Ba,Ka,Ya,be,Ja,Ce,Na,xe,Ri="Helper method for reading an image from a variety of input types.",qa,He,Ii='<strong>Kind</strong>: static method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <code>*</code> - The image object.',Oa,Le,vi="<strong>Example:</strong> Read image from a URL.",Ga,ye,Sa,Me,$i='<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>input</td><td><code><a href="#RawImage">RawImage</a></code> | <code>string</code> | <code>URL</code> | <code>Blob</code> | <code>HTMLCanvasElement</code> | <code>OffscreenCanvas</code></td></tr></tbody>',Da,Za,Wa,Pe,Fa,Ae,Va,Ee,_i="Read an image from a canvas.",Qa,ze,Ti='<strong>Kind</strong>: static method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <a href="#RawImage"><code>RawImage</code></a> - The image object.',Xa,je,bi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>canvas</td><td><code>HTMLCanvasElement</code> | <code>OffscreenCanvas</code></td><td><p>The canvas to read the image from.</p></td></tr></tbody>",el,tl,al,ke,ll,Ue,il,Be,Ci="Read an image from a URL or file path.",ml,Ke,xi='<strong>Kind</strong>: static method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <a href="#RawImage"><code>Promise.&lt;RawImage&gt;</code></a> - The image object.',dl,Ye,Hi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>url</td><td><code>string</code> | <code>URL</code></td><td><p>The URL or file path to read the image from.</p></td></tr></tbody>",ol,sl,rl,Je,gl,Ne,nl,qe,Li="Helper method to create a new Image from a blob.",ul,Oe,yi='<strong>Kind</strong>: static method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a><br/> <strong>Returns</strong>: <a href="#RawImage"><code>Promise.&lt;RawImage&gt;</code></a> - The image object.',cl,Ge,Mi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>blob</td><td><code>Blob</code></td><td><p>The blob to read the image from.</p></td></tr></tbody>",fl,pl,hl,Se,wl,De,Rl,Ze,Pi="Helper method to create a new Image from a tensor",Il,We,Ai='<strong>Kind</strong>: static method of <a href="#module_utils/image.RawImage"><code>RawImage</code></a>',vl,Fe,Ei='<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>tensor</td><td><code><a href="#Tensor">Tensor</a></code></td></tr></tbody>',$l,_l,Tl,Ve,bl,Qe,Cl,Xe,zi="Helper function to load an image from a URL, path, etc.",xl,et,ji='<strong>Kind</strong>: static constant of <a href="#module_utils/image"><code>utils/image</code></a>',Hl,Ll,yl,tt,Ml,at,Pl,lt,ki="Mapping from file extensions to MIME types.",Al,it,Ui='<strong>Kind</strong>: inner constant of <a href="#module_utils/image"><code>utils/image</code></a>',El,zl,jl,mt,kl,ot,Ul;return v=new w({props:{title:"utils/image",local:"utilsimage",headingTag:"h1"}}),C=new w({props:{title:"utils/image.RawImage",local:"utilsimagerawimage",headingTag:"h2"}}),y=new w({props:{title:"new RawImage(data, width, height, channels)",local:"new-rawimagedata-width-height-channels",headingTag:"h3"}}),E=new w({props:{title:"rawImage.size ⇒ <code> * </code>",local:"rawimagesize--code--code",headingTag:"h3"}}),U=new w({props:{title:"rawImage.grayscale() ⇒ <code> RawImage </code>",local:"rawimagegrayscale--code-rawimage-code",headingTag:"h3"}}),J=new w({props:{title:"rawImage.rgb() ⇒ <code> RawImage </code>",local:"rawimagergb--code-rawimage-code",headingTag:"h3"}}),G=new w({props:{title:"rawImage.rgba() ⇒ <code> RawImage </code>",local:"rawimagergba--code-rawimage-code",headingTag:"h3"}}),W=new w({props:{title:"rawImage.putAlpha(mask) ⇒ <code> RawImage </code>",local:"rawimageputalphamask--code-rawimage-code",headingTag:"h3"}}),te=new w({props:{title:"rawImage.resize(width, height, options) ⇒ <code> Promise. < RawImage > </code>",local:"rawimageresizewidth-height-options--code-promise--rawimage--code",headingTag:"h3"}}),de=new w({props:{title:"rawImage.split() ⇒ <code> Array. < RawImage > </code>",local:"rawimagesplit--code-array--rawimage--code",headingTag:"h3"}}),ne=new w({props:{title:"rawImage.clone() ⇒ <code> RawImage </code>",local:"rawimageclone--code-rawimage-code",headingTag:"h3"}}),pe=new w({props:{title:"rawImage.convert(numChannels) ⇒ <code> RawImage </code>",local:"rawimageconvertnumchannels--code-rawimage-code",headingTag:"h3"}}),ve=new w({props:{title:"rawImage.save(path)",local:"rawimagesavepath",headingTag:"h3"}}),Ce=new w({props:{title:"RawImage.read(input) ⇒ <code> * </code>",local:"rawimagereadinput--code--code",headingTag:"h3"}}),ye=new Gi({props:{code:"bGV0JTIwaW1hZ2UlMjAlM0QlMjBhd2FpdCUyMFJhd0ltYWdlLnJlYWQoJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZmb290YmFsbC1tYXRjaC5qcGcnKSUzQiUwQSUyRiUyRiUyMFJhd0ltYWdlJTIw",highlighted:`<span class="hljs-keyword">let</span> image = <span class="hljs-keyword">await</span> <span class="hljs-title class_">RawImage</span>.<span class="hljs-title function_">read</span>(<span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/football-match.jpg&#x27;</span>);
<span class="hljs-comment">// RawImage </span>`,wrap:!1}}),Ae=new w({props:{title:"RawImage.fromCanvas(canvas) ⇒ <code> RawImage </code>",local:"rawimagefromcanvascanvas--code-rawimage-code",headingTag:"h3"}}),Ue=new w({props:{title:"RawImage.fromURL(url) ⇒ <code> Promise. < RawImage > </code>",local:"rawimagefromurlurl--code-promise--rawimage--code",headingTag:"h3"}}),Ne=new w({props:{title:"RawImage.fromBlob(blob) ⇒ <code> Promise. < RawImage > </code>",local:"rawimagefromblobblob--code-promise--rawimage--code",headingTag:"h3"}}),De=new w({props:{title:"RawImage.fromTensor(tensor)",local:"rawimagefromtensortensor",headingTag:"h3"}}),Qe=new w({props:{title:"utils/image.load_image",local:"utilsimageloadimage",headingTag:"h2"}}),at=new w({props:{title:"utils/image~CONTENT_TYPE_MAP",local:"utilsimagecontenttypemap",headingTag:"h2"}}),mt=new Si({props:{source:"https://github.com/huggingface/transformers.js/blob/main/docs/source/api/utils/image.md"}}),{c(){R=d("meta"),st=i(),dt=d("p"),rt=i(),I=d("a"),gt=i(),g(v.$$.fragment),nt=i(),$=d("p"),$.textContent=Kl,ut=i(),_=d("p"),_.textContent=Yl,ct=i(),T=d("ul"),T.innerHTML=Jl,ft=i(),pt=d("hr"),ht=i(),b=d("a"),wt=i(),g(C.$$.fragment),Rt=i(),x=d("p"),x.innerHTML=Nl,It=i(),H=d("ul"),H.innerHTML=ql,vt=i(),$t=d("hr"),_t=i(),L=d("a"),Tt=i(),g(y.$$.fragment),bt=i(),M=d("p"),M.innerHTML=Ol,Ct=i(),P=d("table"),P.innerHTML=Gl,xt=i(),Ht=d("hr"),Lt=i(),A=d("a"),yt=i(),g(E.$$.fragment),Mt=i(),z=d("p"),z.textContent=Sl,Pt=i(),j=d("p"),j.innerHTML=Dl,At=i(),Et=d("hr"),zt=i(),k=d("a"),jt=i(),g(U.$$.fragment),kt=i(),B=d("p"),B.textContent=Zl,Ut=i(),K=d("p"),K.innerHTML=Wl,Bt=i(),Kt=d("hr"),Yt=i(),Y=d("a"),Jt=i(),g(J.$$.fragment),Nt=i(),N=d("p"),N.textContent=Fl,qt=i(),q=d("p"),q.innerHTML=Vl,Ot=i(),Gt=d("hr"),St=i(),O=d("a"),Dt=i(),g(G.$$.fragment),Zt=i(),S=d("p"),S.textContent=Ql,Wt=i(),D=d("p"),D.innerHTML=Xl,Ft=i(),Vt=d("hr"),Qt=i(),Z=d("a"),Xt=i(),g(W.$$.fragment),ea=i(),F=d("p"),F.textContent=ei,ta=i(),V=d("p"),V.innerHTML=ti,aa=i(),Q=d("ul"),Q.innerHTML=ai,la=i(),X=d("table"),X.innerHTML=li,ia=i(),ma=d("hr"),da=i(),ee=d("a"),oa=i(),g(te.$$.fragment),sa=i(),ae=d("p"),ae.textContent=ii,ra=i(),le=d("p"),le.innerHTML=mi,ga=i(),ie=d("table"),ie.innerHTML=di,na=i(),ua=d("hr"),ca=i(),me=d("a"),fa=i(),g(de.$$.fragment),pa=i(),oe=d("p"),oe.textContent=oi,ha=i(),se=d("p"),se.innerHTML=si,wa=i(),re=d("p"),re.innerHTML=ri,Ra=i(),Ia=d("hr"),va=i(),ge=d("a"),$a=i(),g(ne.$$.fragment),_a=i(),ue=d("p"),ue.textContent=gi,Ta=i(),ce=d("p"),ce.innerHTML=ni,ba=i(),Ca=d("hr"),xa=i(),fe=d("a"),Ha=i(),g(pe.$$.fragment),La=i(),he=d("p"),he.textContent=ui,ya=i(),we=d("p"),we.innerHTML=ci,Ma=i(),Re=d("table"),Re.innerHTML=fi,Pa=i(),Aa=d("hr"),Ea=i(),Ie=d("a"),za=i(),g(ve.$$.fragment),ja=i(),$e=d("p"),$e.textContent=pi,ka=i(),_e=d("p"),_e.innerHTML=hi,Ua=i(),Te=d("table"),Te.innerHTML=wi,Ba=i(),Ka=d("hr"),Ya=i(),be=d("a"),Ja=i(),g(Ce.$$.fragment),Na=i(),xe=d("p"),xe.textContent=Ri,qa=i(),He=d("p"),He.innerHTML=Ii,Oa=i(),Le=d("p"),Le.innerHTML=vi,Ga=i(),g(ye.$$.fragment),Sa=i(),Me=d("table"),Me.innerHTML=$i,Da=i(),Za=d("hr"),Wa=i(),Pe=d("a"),Fa=i(),g(Ae.$$.fragment),Va=i(),Ee=d("p"),Ee.textContent=_i,Qa=i(),ze=d("p"),ze.innerHTML=Ti,Xa=i(),je=d("table"),je.innerHTML=bi,el=i(),tl=d("hr"),al=i(),ke=d("a"),ll=i(),g(Ue.$$.fragment),il=i(),Be=d("p"),Be.textContent=Ci,ml=i(),Ke=d("p"),Ke.innerHTML=xi,dl=i(),Ye=d("table"),Ye.innerHTML=Hi,ol=i(),sl=d("hr"),rl=i(),Je=d("a"),gl=i(),g(Ne.$$.fragment),nl=i(),qe=d("p"),qe.textContent=Li,ul=i(),Oe=d("p"),Oe.innerHTML=yi,cl=i(),Ge=d("table"),Ge.innerHTML=Mi,fl=i(),pl=d("hr"),hl=i(),Se=d("a"),wl=i(),g(De.$$.fragment),Rl=i(),Ze=d("p"),Ze.textContent=Pi,Il=i(),We=d("p"),We.innerHTML=Ai,vl=i(),Fe=d("table"),Fe.innerHTML=Ei,$l=i(),_l=d("hr"),Tl=i(),Ve=d("a"),bl=i(),g(Qe.$$.fragment),Cl=i(),Xe=d("p"),Xe.textContent=zi,xl=i(),et=d("p"),et.innerHTML=ji,Hl=i(),Ll=d("hr"),yl=i(),tt=d("a"),Ml=i(),g(at.$$.fragment),Pl=i(),lt=d("p"),lt.textContent=ki,Al=i(),it=d("p"),it.innerHTML=Ui,El=i(),zl=d("hr"),jl=i(),g(mt.$$.fragment),kl=i(),ot=d("p"),this.h()},l(e){const t=qi("svelte-u9bgzb",document.head);R=o(t,"META",{name:!0,content:!0}),t.forEach(a),st=m(e),dt=o(e,"P",{}),n(dt).forEach(a),rt=m(e),I=o(e,"A",{id:!0,class:!0}),n(I).forEach(a),gt=m(e),u(v.$$.fragment,e),nt=m(e),$=o(e,"P",{"data-svelte-h":!0}),s($)!=="svelte-1uts7np"&&($.textContent=Kl),ut=m(e),_=o(e,"P",{"data-svelte-h":!0}),s(_)!=="svelte-il3kl8"&&(_.textContent=Yl),ct=m(e),T=o(e,"UL",{"data-svelte-h":!0}),s(T)!=="svelte-6e4at9"&&(T.innerHTML=Jl),ft=m(e),pt=o(e,"HR",{}),ht=m(e),b=o(e,"A",{id:!0,class:!0}),n(b).forEach(a),wt=m(e),u(C.$$.fragment,e),Rt=m(e),x=o(e,"P",{"data-svelte-h":!0}),s(x)!=="svelte-f7iksk"&&(x.innerHTML=Nl),It=m(e),H=o(e,"UL",{"data-svelte-h":!0}),s(H)!=="svelte-1s5rkbs"&&(H.innerHTML=ql),vt=m(e),$t=o(e,"HR",{}),_t=m(e),L=o(e,"A",{id:!0,class:!0}),n(L).forEach(a),Tt=m(e),u(y.$$.fragment,e),bt=m(e),M=o(e,"P",{"data-svelte-h":!0}),s(M)!=="svelte-36fe9a"&&(M.innerHTML=Ol),Ct=m(e),P=o(e,"TABLE",{"data-svelte-h":!0}),s(P)!=="svelte-vkeoul"&&(P.innerHTML=Gl),xt=m(e),Ht=o(e,"HR",{}),Lt=m(e),A=o(e,"A",{id:!0,class:!0}),n(A).forEach(a),yt=m(e),u(E.$$.fragment,e),Mt=m(e),z=o(e,"P",{"data-svelte-h":!0}),s(z)!=="svelte-2j0n9s"&&(z.textContent=Sl),Pt=m(e),j=o(e,"P",{"data-svelte-h":!0}),s(j)!=="svelte-gwg1mu"&&(j.innerHTML=Dl),At=m(e),Et=o(e,"HR",{}),zt=m(e),k=o(e,"A",{id:!0,class:!0}),n(k).forEach(a),jt=m(e),u(U.$$.fragment,e),kt=m(e),B=o(e,"P",{"data-svelte-h":!0}),s(B)!=="svelte-1owjjfe"&&(B.textContent=Zl),Ut=m(e),K=o(e,"P",{"data-svelte-h":!0}),s(K)!=="svelte-wnhar1"&&(K.innerHTML=Wl),Bt=m(e),Kt=o(e,"HR",{}),Yt=m(e),Y=o(e,"A",{id:!0,class:!0}),n(Y).forEach(a),Jt=m(e),u(J.$$.fragment,e),Nt=m(e),N=o(e,"P",{"data-svelte-h":!0}),s(N)!=="svelte-qyo04e"&&(N.textContent=Fl),qt=m(e),q=o(e,"P",{"data-svelte-h":!0}),s(q)!=="svelte-wnhar1"&&(q.innerHTML=Vl),Ot=m(e),Gt=o(e,"HR",{}),St=m(e),O=o(e,"A",{id:!0,class:!0}),n(O).forEach(a),Dt=m(e),u(G.$$.fragment,e),Zt=m(e),S=o(e,"P",{"data-svelte-h":!0}),s(S)!=="svelte-19kp14j"&&(S.textContent=Ql),Wt=m(e),D=o(e,"P",{"data-svelte-h":!0}),s(D)!=="svelte-wnhar1"&&(D.innerHTML=Xl),Ft=m(e),Vt=o(e,"HR",{}),Qt=m(e),Z=o(e,"A",{id:!0,class:!0}),n(Z).forEach(a),Xt=m(e),u(W.$$.fragment,e),ea=m(e),F=o(e,"P",{"data-svelte-h":!0}),s(F)!=="svelte-1r4j26z"&&(F.textContent=ei),ta=m(e),V=o(e,"P",{"data-svelte-h":!0}),s(V)!=="svelte-1uu1yss"&&(V.innerHTML=ti),aa=m(e),Q=o(e,"UL",{"data-svelte-h":!0}),s(Q)!=="svelte-1jw508h"&&(Q.innerHTML=ai),la=m(e),X=o(e,"TABLE",{"data-svelte-h":!0}),s(X)!=="svelte-1bvqhoj"&&(X.innerHTML=li),ia=m(e),ma=o(e,"HR",{}),da=m(e),ee=o(e,"A",{id:!0,class:!0}),n(ee).forEach(a),oa=m(e),u(te.$$.fragment,e),sa=m(e),ae=o(e,"P",{"data-svelte-h":!0}),s(ae)!=="svelte-s4dm9o"&&(ae.textContent=ii),ra=m(e),le=o(e,"P",{"data-svelte-h":!0}),s(le)!=="svelte-1eyxxva"&&(le.innerHTML=mi),ga=m(e),ie=o(e,"TABLE",{"data-svelte-h":!0}),s(ie)!=="svelte-h7uulu"&&(ie.innerHTML=di),na=m(e),ua=o(e,"HR",{}),ca=m(e),me=o(e,"A",{id:!0,class:!0}),n(me).forEach(a),fa=m(e),u(de.$$.fragment,e),pa=m(e),oe=o(e,"P",{"data-svelte-h":!0}),s(oe)!=="svelte-2m63ix"&&(oe.textContent=oi),ha=m(e),se=o(e,"P",{"data-svelte-h":!0}),s(se)!=="svelte-k44jcf"&&(se.innerHTML=si),wa=m(e),re=o(e,"P",{"data-svelte-h":!0}),s(re)!=="svelte-av6gr8"&&(re.innerHTML=ri),Ra=m(e),Ia=o(e,"HR",{}),va=m(e),ge=o(e,"A",{id:!0,class:!0}),n(ge).forEach(a),$a=m(e),u(ne.$$.fragment,e),_a=m(e),ue=o(e,"P",{"data-svelte-h":!0}),s(ue)!=="svelte-1eu6jk3"&&(ue.textContent=gi),Ta=m(e),ce=o(e,"P",{"data-svelte-h":!0}),s(ce)!=="svelte-14yxs34"&&(ce.innerHTML=ni),ba=m(e),Ca=o(e,"HR",{}),xa=m(e),fe=o(e,"A",{id:!0,class:!0}),n(fe).forEach(a),Ha=m(e),u(pe.$$.fragment,e),La=m(e),he=o(e,"P",{"data-svelte-h":!0}),s(he)!=="svelte-5ze294"&&(he.textContent=ui),ya=m(e),we=o(e,"P",{"data-svelte-h":!0}),s(we)!=="svelte-wnhar1"&&(we.innerHTML=ci),Ma=m(e),Re=o(e,"TABLE",{"data-svelte-h":!0}),s(Re)!=="svelte-1hxqxaq"&&(Re.innerHTML=fi),Pa=m(e),Aa=o(e,"HR",{}),Ea=m(e),Ie=o(e,"A",{id:!0,class:!0}),n(Ie).forEach(a),za=m(e),u(ve.$$.fragment,e),ja=m(e),$e=o(e,"P",{"data-svelte-h":!0}),s($e)!=="svelte-119su55"&&($e.textContent=pi),ka=m(e),_e=o(e,"P",{"data-svelte-h":!0}),s(_e)!=="svelte-1epyezb"&&(_e.innerHTML=hi),Ua=m(e),Te=o(e,"TABLE",{"data-svelte-h":!0}),s(Te)!=="svelte-1h4z9xq"&&(Te.innerHTML=wi),Ba=m(e),Ka=o(e,"HR",{}),Ya=m(e),be=o(e,"A",{id:!0,class:!0}),n(be).forEach(a),Ja=m(e),u(Ce.$$.fragment,e),Na=m(e),xe=o(e,"P",{"data-svelte-h":!0}),s(xe)!=="svelte-5659h9"&&(xe.textContent=Ri),qa=m(e),He=o(e,"P",{"data-svelte-h":!0}),s(He)!=="svelte-1800vfp"&&(He.innerHTML=Ii),Oa=m(e),Le=o(e,"P",{"data-svelte-h":!0}),s(Le)!=="svelte-14z54gq"&&(Le.innerHTML=vi),Ga=m(e),u(ye.$$.fragment,e),Sa=m(e),Me=o(e,"TABLE",{"data-svelte-h":!0}),s(Me)!=="svelte-6lf1w0"&&(Me.innerHTML=$i),Da=m(e),Za=o(e,"HR",{}),Wa=m(e),Pe=o(e,"A",{id:!0,class:!0}),n(Pe).forEach(a),Fa=m(e),u(Ae.$$.fragment,e),Va=m(e),Ee=o(e,"P",{"data-svelte-h":!0}),s(Ee)!=="svelte-mjjjch"&&(Ee.textContent=_i),Qa=m(e),ze=o(e,"P",{"data-svelte-h":!0}),s(ze)!=="svelte-uuk5nt"&&(ze.innerHTML=Ti),Xa=m(e),je=o(e,"TABLE",{"data-svelte-h":!0}),s(je)!=="svelte-hzvu44"&&(je.innerHTML=bi),el=m(e),tl=o(e,"HR",{}),al=m(e),ke=o(e,"A",{id:!0,class:!0}),n(ke).forEach(a),ll=m(e),u(Ue.$$.fragment,e),il=m(e),Be=o(e,"P",{"data-svelte-h":!0}),s(Be)!=="svelte-1355z3u"&&(Be.textContent=Ci),ml=m(e),Ke=o(e,"P",{"data-svelte-h":!0}),s(Ke)!=="svelte-1vm5ou6"&&(Ke.innerHTML=xi),dl=m(e),Ye=o(e,"TABLE",{"data-svelte-h":!0}),s(Ye)!=="svelte-ncveta"&&(Ye.innerHTML=Hi),ol=m(e),sl=o(e,"HR",{}),rl=m(e),Je=o(e,"A",{id:!0,class:!0}),n(Je).forEach(a),gl=m(e),u(Ne.$$.fragment,e),nl=m(e),qe=o(e,"P",{"data-svelte-h":!0}),s(qe)!=="svelte-1s704mu"&&(qe.textContent=Li),ul=m(e),Oe=o(e,"P",{"data-svelte-h":!0}),s(Oe)!=="svelte-1vm5ou6"&&(Oe.innerHTML=yi),cl=m(e),Ge=o(e,"TABLE",{"data-svelte-h":!0}),s(Ge)!=="svelte-34rbhe"&&(Ge.innerHTML=Mi),fl=m(e),pl=o(e,"HR",{}),hl=m(e),Se=o(e,"A",{id:!0,class:!0}),n(Se).forEach(a),wl=m(e),u(De.$$.fragment,e),Rl=m(e),Ze=o(e,"P",{"data-svelte-h":!0}),s(Ze)!=="svelte-nwy2y"&&(Ze.textContent=Pi),Il=m(e),We=o(e,"P",{"data-svelte-h":!0}),s(We)!=="svelte-sl3vqa"&&(We.innerHTML=Ai),vl=m(e),Fe=o(e,"TABLE",{"data-svelte-h":!0}),s(Fe)!=="svelte-16eqzfb"&&(Fe.innerHTML=Ei),$l=m(e),_l=o(e,"HR",{}),Tl=m(e),Ve=o(e,"A",{id:!0,class:!0}),n(Ve).forEach(a),bl=m(e),u(Qe.$$.fragment,e),Cl=m(e),Xe=o(e,"P",{"data-svelte-h":!0}),s(Xe)!=="svelte-eu8o7o"&&(Xe.textContent=zi),xl=m(e),et=o(e,"P",{"data-svelte-h":!0}),s(et)!=="svelte-1ricti2"&&(et.innerHTML=ji),Hl=m(e),Ll=o(e,"HR",{}),yl=m(e),tt=o(e,"A",{id:!0,class:!0}),n(tt).forEach(a),Ml=m(e),u(at.$$.fragment,e),Pl=m(e),lt=o(e,"P",{"data-svelte-h":!0}),s(lt)!=="svelte-15u13r6"&&(lt.textContent=ki),Al=m(e),it=o(e,"P",{"data-svelte-h":!0}),s(it)!=="svelte-1cwm6ga"&&(it.innerHTML=Ui),El=m(e),zl=o(e,"HR",{}),jl=m(e),u(mt.$$.fragment,e),kl=m(e),ot=o(e,"P",{}),n(ot).forEach(a),this.h()},h(){r(R,"name","hf:doc:metadata"),r(R,"content",Zi),r(I,"id","module_utils/image"),r(I,"class","group"),r(b,"id","module_utils/image.RawImage"),r(b,"class","group"),r(L,"id","new_module_utils/image.RawImage_new"),r(L,"class","group"),r(A,"id","module_utils/image.RawImage+size"),r(A,"class","group"),r(k,"id","module_utils/image.RawImage+grayscale"),r(k,"class","group"),r(Y,"id","module_utils/image.RawImage+rgb"),r(Y,"class","group"),r(O,"id","module_utils/image.RawImage+rgba"),r(O,"class","group"),r(Z,"id","module_utils/image.RawImage+putAlpha"),r(Z,"class","group"),r(ee,"id","module_utils/image.RawImage+resize"),r(ee,"class","group"),r(me,"id","module_utils/image.RawImage+split"),r(me,"class","group"),r(ge,"id","module_utils/image.RawImage+clone"),r(ge,"class","group"),r(fe,"id","module_utils/image.RawImage+convert"),r(fe,"class","group"),r(Ie,"id","module_utils/image.RawImage+save"),r(Ie,"class","group"),r(be,"id","module_utils/image.RawImage.read"),r(be,"class","group"),r(Pe,"id","module_utils/image.RawImage.fromCanvas"),r(Pe,"class","group"),r(ke,"id","module_utils/image.RawImage.fromURL"),r(ke,"class","group"),r(Je,"id","module_utils/image.RawImage.fromBlob"),r(Je,"class","group"),r(Se,"id","module_utils/image.RawImage.fromTensor"),r(Se,"class","group"),r(Ve,"id","module_utils/image.load_image"),r(Ve,"class","group"),r(tt,"id","module_utils/image..CONTENT_TYPE_MAP"),r(tt,"class","group")},m(e,t){Oi(document.head,R),l(e,st,t),l(e,dt,t),l(e,rt,t),l(e,I,t),l(e,gt,t),c(v,e,t),l(e,nt,t),l(e,$,t),l(e,ut,t),l(e,_,t),l(e,ct,t),l(e,T,t),l(e,ft,t),l(e,pt,t),l(e,ht,t),l(e,b,t),l(e,wt,t),c(C,e,t),l(e,Rt,t),l(e,x,t),l(e,It,t),l(e,H,t),l(e,vt,t),l(e,$t,t),l(e,_t,t),l(e,L,t),l(e,Tt,t),c(y,e,t),l(e,bt,t),l(e,M,t),l(e,Ct,t),l(e,P,t),l(e,xt,t),l(e,Ht,t),l(e,Lt,t),l(e,A,t),l(e,yt,t),c(E,e,t),l(e,Mt,t),l(e,z,t),l(e,Pt,t),l(e,j,t),l(e,At,t),l(e,Et,t),l(e,zt,t),l(e,k,t),l(e,jt,t),c(U,e,t),l(e,kt,t),l(e,B,t),l(e,Ut,t),l(e,K,t),l(e,Bt,t),l(e,Kt,t),l(e,Yt,t),l(e,Y,t),l(e,Jt,t),c(J,e,t),l(e,Nt,t),l(e,N,t),l(e,qt,t),l(e,q,t),l(e,Ot,t),l(e,Gt,t),l(e,St,t),l(e,O,t),l(e,Dt,t),c(G,e,t),l(e,Zt,t),l(e,S,t),l(e,Wt,t),l(e,D,t),l(e,Ft,t),l(e,Vt,t),l(e,Qt,t),l(e,Z,t),l(e,Xt,t),c(W,e,t),l(e,ea,t),l(e,F,t),l(e,ta,t),l(e,V,t),l(e,aa,t),l(e,Q,t),l(e,la,t),l(e,X,t),l(e,ia,t),l(e,ma,t),l(e,da,t),l(e,ee,t),l(e,oa,t),c(te,e,t),l(e,sa,t),l(e,ae,t),l(e,ra,t),l(e,le,t),l(e,ga,t),l(e,ie,t),l(e,na,t),l(e,ua,t),l(e,ca,t),l(e,me,t),l(e,fa,t),c(de,e,t),l(e,pa,t),l(e,oe,t),l(e,ha,t),l(e,se,t),l(e,wa,t),l(e,re,t),l(e,Ra,t),l(e,Ia,t),l(e,va,t),l(e,ge,t),l(e,$a,t),c(ne,e,t),l(e,_a,t),l(e,ue,t),l(e,Ta,t),l(e,ce,t),l(e,ba,t),l(e,Ca,t),l(e,xa,t),l(e,fe,t),l(e,Ha,t),c(pe,e,t),l(e,La,t),l(e,he,t),l(e,ya,t),l(e,we,t),l(e,Ma,t),l(e,Re,t),l(e,Pa,t),l(e,Aa,t),l(e,Ea,t),l(e,Ie,t),l(e,za,t),c(ve,e,t),l(e,ja,t),l(e,$e,t),l(e,ka,t),l(e,_e,t),l(e,Ua,t),l(e,Te,t),l(e,Ba,t),l(e,Ka,t),l(e,Ya,t),l(e,be,t),l(e,Ja,t),c(Ce,e,t),l(e,Na,t),l(e,xe,t),l(e,qa,t),l(e,He,t),l(e,Oa,t),l(e,Le,t),l(e,Ga,t),c(ye,e,t),l(e,Sa,t),l(e,Me,t),l(e,Da,t),l(e,Za,t),l(e,Wa,t),l(e,Pe,t),l(e,Fa,t),c(Ae,e,t),l(e,Va,t),l(e,Ee,t),l(e,Qa,t),l(e,ze,t),l(e,Xa,t),l(e,je,t),l(e,el,t),l(e,tl,t),l(e,al,t),l(e,ke,t),l(e,ll,t),c(Ue,e,t),l(e,il,t),l(e,Be,t),l(e,ml,t),l(e,Ke,t),l(e,dl,t),l(e,Ye,t),l(e,ol,t),l(e,sl,t),l(e,rl,t),l(e,Je,t),l(e,gl,t),c(Ne,e,t),l(e,nl,t),l(e,qe,t),l(e,ul,t),l(e,Oe,t),l(e,cl,t),l(e,Ge,t),l(e,fl,t),l(e,pl,t),l(e,hl,t),l(e,Se,t),l(e,wl,t),c(De,e,t),l(e,Rl,t),l(e,Ze,t),l(e,Il,t),l(e,We,t),l(e,vl,t),l(e,Fe,t),l(e,$l,t),l(e,_l,t),l(e,Tl,t),l(e,Ve,t),l(e,bl,t),c(Qe,e,t),l(e,Cl,t),l(e,Xe,t),l(e,xl,t),l(e,et,t),l(e,Hl,t),l(e,Ll,t),l(e,yl,t),l(e,tt,t),l(e,Ml,t),c(at,e,t),l(e,Pl,t),l(e,lt,t),l(e,Al,t),l(e,it,t),l(e,El,t),l(e,zl,t),l(e,jl,t),c(mt,e,t),l(e,kl,t),l(e,ot,t),Ul=!0},p:Ki,i(e){Ul||(f(v.$$.fragment,e),f(C.$$.fragment,e),f(y.$$.fragment,e),f(E.$$.fragment,e),f(U.$$.fragment,e),f(J.$$.fragment,e),f(G.$$.fragment,e),f(W.$$.fragment,e),f(te.$$.fragment,e),f(de.$$.fragment,e),f(ne.$$.fragment,e),f(pe.$$.fragment,e),f(ve.$$.fragment,e),f(Ce.$$.fragment,e),f(ye.$$.fragment,e),f(Ae.$$.fragment,e),f(Ue.$$.fragment,e),f(Ne.$$.fragment,e),f(De.$$.fragment,e),f(Qe.$$.fragment,e),f(at.$$.fragment,e),f(mt.$$.fragment,e),Ul=!0)},o(e){p(v.$$.fragment,e),p(C.$$.fragment,e),p(y.$$.fragment,e),p(E.$$.fragment,e),p(U.$$.fragment,e),p(J.$$.fragment,e),p(G.$$.fragment,e),p(W.$$.fragment,e),p(te.$$.fragment,e),p(de.$$.fragment,e),p(ne.$$.fragment,e),p(pe.$$.fragment,e),p(ve.$$.fragment,e),p(Ce.$$.fragment,e),p(ye.$$.fragment,e),p(Ae.$$.fragment,e),p(Ue.$$.fragment,e),p(Ne.$$.fragment,e),p(De.$$.fragment,e),p(Qe.$$.fragment,e),p(at.$$.fragment,e),p(mt.$$.fragment,e),Ul=!1},d(e){e&&(a(st),a(dt),a(rt),a(I),a(gt),a(nt),a($),a(ut),a(_),a(ct),a(T),a(ft),a(pt),a(ht),a(b),a(wt),a(Rt),a(x),a(It),a(H),a(vt),a($t),a(_t),a(L),a(Tt),a(bt),a(M),a(Ct),a(P),a(xt),a(Ht),a(Lt),a(A),a(yt),a(Mt),a(z),a(Pt),a(j),a(At),a(Et),a(zt),a(k),a(jt),a(kt),a(B),a(Ut),a(K),a(Bt),a(Kt),a(Yt),a(Y),a(Jt),a(Nt),a(N),a(qt),a(q),a(Ot),a(Gt),a(St),a(O),a(Dt),a(Zt),a(S),a(Wt),a(D),a(Ft),a(Vt),a(Qt),a(Z),a(Xt),a(ea),a(F),a(ta),a(V),a(aa),a(Q),a(la),a(X),a(ia),a(ma),a(da),a(ee),a(oa),a(sa),a(ae),a(ra),a(le),a(ga),a(ie),a(na),a(ua),a(ca),a(me),a(fa),a(pa),a(oe),a(ha),a(se),a(wa),a(re),a(Ra),a(Ia),a(va),a(ge),a($a),a(_a),a(ue),a(Ta),a(ce),a(ba),a(Ca),a(xa),a(fe),a(Ha),a(La),a(he),a(ya),a(we),a(Ma),a(Re),a(Pa),a(Aa),a(Ea),a(Ie),a(za),a(ja),a($e),a(ka),a(_e),a(Ua),a(Te),a(Ba),a(Ka),a(Ya),a(be),a(Ja),a(Na),a(xe),a(qa),a(He),a(Oa),a(Le),a(Ga),a(Sa),a(Me),a(Da),a(Za),a(Wa),a(Pe),a(Fa),a(Va),a(Ee),a(Qa),a(ze),a(Xa),a(je),a(el),a(tl),a(al),a(ke),a(ll),a(il),a(Be),a(ml),a(Ke),a(dl),a(Ye),a(ol),a(sl),a(rl),a(Je),a(gl),a(nl),a(qe),a(ul),a(Oe),a(cl),a(Ge),a(fl),a(pl),a(hl),a(Se),a(wl),a(Rl),a(Ze),a(Il),a(We),a(vl),a(Fe),a($l),a(_l),a(Tl),a(Ve),a(bl),a(Cl),a(Xe),a(xl),a(et),a(Hl),a(Ll),a(yl),a(tt),a(Ml),a(Pl),a(lt),a(Al),a(it),a(El),a(zl),a(jl),a(kl),a(ot)),a(R),h(v,e),h(C,e),h(y,e),h(E,e),h(U,e),h(J,e),h(G,e),h(W,e),h(te,e),h(de,e),h(ne,e),h(pe,e),h(ve,e),h(Ce,e),h(ye,e),h(Ae,e),h(Ue,e),h(Ne,e),h(De,e),h(Qe,e),h(at,e),h(mt,e)}}}const Zi='{"title":"utils/image","local":"utilsimage","sections":[{"title":"utils/image.RawImage","local":"utilsimagerawimage","sections":[{"title":"new RawImage(data, width, height, channels)","local":"new-rawimagedata-width-height-channels","sections":[],"depth":3},{"title":"rawImage.size ⇒ <code> * </code>","local":"rawimagesize--code--code","sections":[],"depth":3},{"title":"rawImage.grayscale() ⇒ <code> RawImage </code>","local":"rawimagegrayscale--code-rawimage-code","sections":[],"depth":3},{"title":"rawImage.rgb() ⇒ <code> RawImage </code>","local":"rawimagergb--code-rawimage-code","sections":[],"depth":3},{"title":"rawImage.rgba() ⇒ <code> RawImage </code>","local":"rawimagergba--code-rawimage-code","sections":[],"depth":3},{"title":"rawImage.putAlpha(mask) ⇒ <code> RawImage </code>","local":"rawimageputalphamask--code-rawimage-code","sections":[],"depth":3},{"title":"rawImage.resize(width, height, options) ⇒ <code> Promise. < RawImage > </code>","local":"rawimageresizewidth-height-options--code-promise--rawimage--code","sections":[],"depth":3},{"title":"rawImage.split() ⇒ <code> Array. < RawImage > </code>","local":"rawimagesplit--code-array--rawimage--code","sections":[],"depth":3},{"title":"rawImage.clone() ⇒ <code> RawImage </code>","local":"rawimageclone--code-rawimage-code","sections":[],"depth":3},{"title":"rawImage.convert(numChannels) ⇒ <code> RawImage </code>","local":"rawimageconvertnumchannels--code-rawimage-code","sections":[],"depth":3},{"title":"rawImage.save(path)","local":"rawimagesavepath","sections":[],"depth":3},{"title":"RawImage.read(input) ⇒ <code> * </code>","local":"rawimagereadinput--code--code","sections":[],"depth":3},{"title":"RawImage.fromCanvas(canvas) ⇒ <code> RawImage </code>","local":"rawimagefromcanvascanvas--code-rawimage-code","sections":[],"depth":3},{"title":"RawImage.fromURL(url) ⇒ <code> Promise. < RawImage > </code>","local":"rawimagefromurlurl--code-promise--rawimage--code","sections":[],"depth":3},{"title":"RawImage.fromBlob(blob) ⇒ <code> Promise. < RawImage > </code>","local":"rawimagefromblobblob--code-promise--rawimage--code","sections":[],"depth":3},{"title":"RawImage.fromTensor(tensor)","local":"rawimagefromtensortensor","sections":[],"depth":3}],"depth":2},{"title":"utils/image.load_image","local":"utilsimageloadimage","sections":[],"depth":2},{"title":"utils/image~CONTENT_TYPE_MAP","local":"utilsimagecontenttypemap","sections":[],"depth":2}],"depth":1}';function Wi(Bl){return Yi(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class em extends Ji{constructor(R){super(),Ni(this,R,Wi,Di,Bi,{})}}export{em as component};
