import{s as Mt,n as ft,o as Tt}from"../chunks/scheduler.d627b047.js";import{S as gt,i as Jt,g as i,s,r as p,A as Ut,h as o,f as l,c as a,j as wt,u as c,x as r,k as yt,y as bt,a as n,v as d,d as m,t as h,w as u}from"../chunks/index.73c51727.js";import{C as O}from"../chunks/CodeBlock.5f78c87f.js";import{H as le,E as jt}from"../chunks/index.bb4866f7.js";function Ct(Qe){let w,ne,ee,se,y,ae,M,Fe='We’ve begun rolling out examples to use Meta’s LLaMA models in <code>trl</code> (see <a href="https://ai.facebook.com/blog/large-language-model-llama-meta-ai/" rel="nofollow">Meta’s LLaMA release</a> for the original LLaMA model).',ie,f,oe,T,Ne='Even training the smallest LLaMA model requires an enormous amount of memory. Some quick math: in bf16, every parameter uses 2 bytes (in fp32 4 bytes) in addition to 8 bytes used, e.g., in the Adam optimizer (see the <a href="https://huggingface.co/docs/transformers/perf_train_gpu_one#optimizer" rel="nofollow">performance docs</a> in Transformers for more info). So a 7B parameter model would use <code>(2+8)*7B=70GB</code> just to fit in memory and would likely need more when you compute intermediate values such as attention scores. So you couldn’t train the model even on a single 80GB A100 like that. You can use some tricks, like more efficient optimizers of half-precision training, to squeeze a bit more into memory, but you’ll run out sooner or later.',re,g,Se=`Another option is to use Parameter-Efficient Fine-Tuning (PEFT) techniques, such as the <a href="https://github.com/huggingface/peft" rel="nofollow"><code>peft</code></a> library, which can perform low-rank adaptation (LoRA) on a model loaded in 8-bit.
For more on <code>peft</code> + <code>trl</code>, see the <a href="https://huggingface.co/docs/trl/sentiment_tuning_peft" rel="nofollow">docs</a>.`,pe,J,Ee=`Loading the model in 8bit reduces the memory footprint drastically since you only need one byte per parameter for the weights (e.g. 7B LlaMa is 7GB in memory).
Instead of training the original weights directly, LoRA adds small adapter layers on top of some specific layers (usually the attention layers); thus, the number of trainable parameters is drastically reduced.`,ce,U,qe=`In this scenario, a rule of thumb is to allocate ~1.2-1.4GB per billion parameters (depending on the batch size and sequence length) to fit the entire fine-tuning setup.
This enables fine-tuning larger models (up to 50-60B scale models on a NVIDIA A100 80GB) at low cost.`,de,b,Ye=`Now we can fit very large models into a single GPU, but the training might still be very slow.
The simplest strategy in this scenario is data parallelism: we replicate the same training setup into separate GPUs and pass different batches to each GPU.
With this, you can parallelize the forward/backward passes of the model and scale with the number of GPUs.`,me,j,Pe='<img src="https://huggingface.co/datasets/trl-lib/documentation-images/resolve/main/chapter10_ddp.png" alt="chapter10_ddp.png"/>',he,C,Ke="We use either the <code>transformers.Trainer</code> or <code>accelerate</code>, which both support data parallelism without any code changes, by simply passing arguments when calling the scripts with <code>torchrun</code> or <code>accelerate launch</code>. The following runs a training script with 8 GPUs on a single machine with <code>accelerate</code> and <code>torchrun</code>, respectively.",ue,I,we,_,ye,v,De=`Before we start training reward models and tuning our model with RL, it helps if the model is already good in the domain we are interested in.
In our case, we want it to answer questions, while for other use cases, we might want it to follow instructions, in which case instruction tuning is a great idea.
The easiest way to achieve this is by continuing to train the language model with the language modeling objective on texts from the domain or task.
The <a href="https://huggingface.co/datasets/HuggingFaceH4/stack-exchange-preferences" rel="nofollow">StackExchange dataset</a> is enormous (over 10 million instructions), so we can easily train the language model on a subset of it.`,Me,k,Oe=`There is nothing special about fine-tuning the model before doing RLHF - it’s just the causal language modeling objective from pretraining that we apply here.
To use the data efficiently, we use a technique called packing: instead of having one text per sample in the batch and then padding to either the longest text or the maximal context of the model, we concatenate a lot of texts with a EOS token in between and cut chunks of the context size to fill the batch without any padding.`,fe,B,et='<img src="https://huggingface.co/datasets/trl-lib/documentation-images/resolve/main/chapter10_preprocessing-clm.png" alt="chapter10_preprocessing-clm.png"/>',Te,R,tt=`With this approach the training is much more efficient as each token that is passed through the model is also trained in contrast to padding tokens which are usually masked from the loss.
If you don’t have much data and are more concerned about occasionally cutting off some tokens that are overflowing the context you can also use a classical data loader.`,ge,x,Je,H,lt=`We train the model for a few thousand steps with the causal language modeling objective and save the model.
Since we will tune the model again with different objectives, we merge the adapter weights with the original model weights.`,Ue,$,nt=`<strong>Disclaimer:</strong> due to LLaMA’s license, we release only the adapter weights for this and the model checkpoints in the following sections.
You can apply for access to the base model’s weights by filling out Meta AI’s <a href="https://docs.google.com/forms/d/e/1FAIpQLSfqNECQnMkycAp2jP4Z9TFX0cGR4uf7b_fBxjY_OjhJILlKGA/viewform" rel="nofollow">form</a> and then converting them to the 🤗 Transformers format by running this <a href="https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama/convert_llama_weights_to_hf.py" rel="nofollow">script</a>.
Note that you’ll also need to install 🤗 Transformers from source until the <code>v4.28</code> is released.`,be,A,st="Now that we have fine-tuned the model for the task, we are ready to train a reward model.",je,G,Ce,Z,at=`In principle, we could fine-tune the model using RLHF directly with the human annotations.
However, this would require us to send some samples to humans for rating after each optimization iteration.
This is expensive and slow due to the number of training samples needed for convergence and the inherent latency of human reading and annotator speed.`,Ie,L,it=`A trick that works well instead of direct feedback is training a reward model on human annotations collected before the RL loop.
The goal of the reward model is to imitate how a human would rate a text. There are several possible strategies to build a reward model: the most straightforward way would be to predict the annotation (e.g. a rating score or a binary value for “good”/”bad”).
In practice, what works better is to predict the ranking of two examples, where the reward model is presented with two candidates <code>(y_k, y_j)</code> for a given prompt <code>x</code> and has to predict which one would be rated higher by a human annotator.`,_e,V,ot=`With the StackExchange dataset, we can infer which of the two answers was preferred by the users based on the score.
With that information and the loss defined above, we can then modify the <code>transformers.Trainer</code> by adding a custom loss function.`,ve,X,ke,z,rt="We utilize a subset of a 100,000 pair of candidates and evaluate on a held-out set of 50,000. With a modest training batch size of 4, we train the Llama model using the LoRA <code>peft</code> adapter for a single epoch using the Adam optimizer with BF16 precision. Our LoRA configuration is:",Be,W,Re,Q,pt="As detailed in the next section, the resulting adapter can be merged into the frozen model and saved for further downstream use.",xe,F,He,N,ct="With the fine-tuned language model and the reward model at hand, we are now ready to run the RL loop. It follows roughly three steps:",$e,S,dt="<li>Generate responses from prompts,</li> <li>Rate the responses with the reward model,</li> <li>Run a reinforcement learning policy-optimization step with the ratings.</li>",Ae,E,mt="The Query and Response prompts are templated as follows before being tokenized and passed to the model:",Ge,q,Ze,Y,ht=`The same template was used for SFT, RM and RLHF stages.
Once more, we utilize <code>peft</code> for memory-efficient training, which offers an extra advantage in the RLHF context.
Here, the reference model and policy share the same base, the SFT model, which we load in 8-bit and freeze during training.
We exclusively optimize the policy’s LoRA weights using PPO while sharing the base model’s weights.`,Le,P,Ve,K,ut='For the rest of the details and evaluation, please refer to our <a href="https://huggingface.co/blog/stackllama" rel="nofollow">blog post on StackLLaMA</a>.',Xe,D,ze,te,We;return y=new le({props:{title:"Using LLaMA models with TRL",local:"using-llama-models-with-trl",headingTag:"h1"}}),f=new le({props:{title:"Efficient training strategies",local:"efficient-training-strategies",headingTag:"h2"}}),I=new O({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMC0tbXVsdGlfZ3B1JTIwLS1udW1fbWFjaGluZXMlMjAxJTIwJTIwLS1udW1fcHJvY2Vzc2VzJTIwOCUyMG15X2FjY2VsZXJhdGVfc2NyaXB0LnB5JTBBdG9yY2hydW4lMjAtLW5ub2RlcyUyMDElMjAlMjAtLW5wcm9jX3Blcl9ub2RlJTIwOCUyMG15X3RvcmNoX3NjcmlwdC5weQ==",highlighted:`accelerate launch --multi_gpu --num_machines 1  --num_processes 8 my_accelerate_script.py
torchrun --nnodes 1  --nproc_per_node 8 my_torch_script.py`,wrap:!1}}),_=new le({props:{title:"Supervised fine-tuning",local:"supervised-fine-tuning",headingTag:"h2"}}),x=new O({props:{code:"JTIzJTIwbG9hZCUyMG1vZGVsJTIwaW4lMjA4Yml0JTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXJncy5tb2RlbF9wYXRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9hZF9pbl84Yml0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlN0IlMjIlMjIlM0ElMjBBY2NlbGVyYXRvcigpLmxvY2FsX3Byb2Nlc3NfaW5kZXglN0QlMEElMjAlMjAlMjAlMjApJTBBbW9kZWwlMjAlM0QlMjBwcmVwYXJlX21vZGVsX2Zvcl9rYml0X3RyYWluaW5nKG1vZGVsKSUwQSUwQSUyMyUyMGFkZCUyMExvUkElMjB0byUyMG1vZGVsJTBBbG9yYV9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHIlM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfYWxwaGElM0QzMiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfZHJvcG91dCUzRDAuMDUlMkMlMEElMjAlMjAlMjAlMjBiaWFzJTNEJTIybm9uZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRhc2tfdHlwZSUzRCUyMkNBVVNBTF9MTSUyMiUyQyUwQSklMEElMEFtb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKG1vZGVsJTJDJTIwY29uZmlnKQ==",highlighted:`<span class="hljs-comment"># load model in 8bit</span>
model = AutoModelForCausalLM.from_pretrained(
        args.model_path,
        load_in_8bit=<span class="hljs-literal">True</span>,
        device_map={<span class="hljs-string">&quot;&quot;</span>: Accelerator().local_process_index}
    )
model = prepare_model_for_kbit_training(model)

<span class="hljs-comment"># add LoRA to model</span>
lora_config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)

model = get_peft_model(model, config)`,wrap:!1}}),G=new le({props:{title:"Reward modeling and human preferences",local:"reward-modeling-and-human-preferences",headingTag:"h2"}}),X=new O({props:{code:"Y2xhc3MlMjBSZXdhcmRUcmFpbmVyKFRyYWluZXIpJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwY29tcHV0ZV9sb3NzKHNlbGYlMkMlMjBtb2RlbCUyQyUyMGlucHV0cyUyQyUyMHJldHVybl9vdXRwdXRzJTNERmFsc2UpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV3YXJkc19qJTIwJTNEJTIwbW9kZWwoaW5wdXRfaWRzJTNEaW5wdXRzJTVCJTIyaW5wdXRfaWRzX2olMjIlNUQlMkMlMjAlMjBhdHRlbnRpb25fbWFzayUzRGlucHV0cyU1QiUyMmF0dGVudGlvbl9tYXNrX2olMjIlNUQpJTVCMCU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJld2FyZHNfayUyMCUzRCUyMG1vZGVsKGlucHV0X2lkcyUzRGlucHV0cyU1QiUyMmlucHV0X2lkc19rJTIyJTVEJTJDJTIwYXR0ZW50aW9uX21hc2slM0RpbnB1dHMlNUIlMjJhdHRlbnRpb25fbWFza19rJTIyJTVEKSU1QjAlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwLW5uLmZ1bmN0aW9uYWwubG9nc2lnbW9pZChyZXdhcmRzX2olMjAtJTIwcmV3YXJkc19rKS5tZWFuKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMHJldHVybl9vdXRwdXRzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwbG9zcyUyQyUyMCU3QiUyMnJld2FyZHNfaiUyMiUzQSUyMHJld2FyZHNfaiUyQyUyMCUyMnJld2FyZHNfayUyMiUzQSUyMHJld2FyZHNfayU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGxvc3M=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">RewardTrainer</span>(<span class="hljs-title class_ inherited__">Trainer</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_loss</span>(<span class="hljs-params">self, model, inputs, return_outputs=<span class="hljs-literal">False</span></span>):
        rewards_j = model(input_ids=inputs[<span class="hljs-string">&quot;input_ids_j&quot;</span>],  attention_mask=inputs[<span class="hljs-string">&quot;attention_mask_j&quot;</span>])[<span class="hljs-number">0</span>]
        rewards_k = model(input_ids=inputs[<span class="hljs-string">&quot;input_ids_k&quot;</span>], attention_mask=inputs[<span class="hljs-string">&quot;attention_mask_k&quot;</span>])[<span class="hljs-number">0</span>]
        loss = -nn.functional.logsigmoid(rewards_j - rewards_k).mean()
        <span class="hljs-keyword">if</span> return_outputs:
            <span class="hljs-keyword">return</span> loss, {<span class="hljs-string">&quot;rewards_j&quot;</span>: rewards_j, <span class="hljs-string">&quot;rewards_k&quot;</span>: rewards_k}
        <span class="hljs-keyword">return</span> loss`,wrap:!1}}),W=new O({props:{code:"cGVmdF9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHRhc2tfdHlwZSUzRFRhc2tUeXBlLlNFUV9DTFMlMkMlMEElMjAlMjAlMjAlMjBpbmZlcmVuY2VfbW9kZSUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwciUzRDglMkMlMEElMjAlMjAlMjAlMjBsb3JhX2FscGhhJTNEMzIlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2Ryb3BvdXQlM0QwLjElMkMlMEEp",highlighted:`peft_config = LoraConfig(
    task_type=TaskType.SEQ_CLS,
    inference_mode=<span class="hljs-literal">False</span>,
    r=<span class="hljs-number">8</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lora_dropout=<span class="hljs-number">0.1</span>,
)`,wrap:!1}}),F=new le({props:{title:"Reinforcement Learning from Human Feedback",local:"reinforcement-learning-from-human-feedback",headingTag:"h2"}}),q=new O({props:{code:"UXVlc3Rpb24lM0ElMjAlM0NRdWVyeSUzRSUwQSUwQUFuc3dlciUzQSUyMCUzQ1Jlc3BvbnNlJTNF",highlighted:`Question: &lt;Query&gt;

Answer: &lt;Response&gt;`,wrap:!1}}),P=new O({props:{code:"Zm9yJTIwZXBvY2glMkMlMjBiYXRjaCUyMGluJTIwdHFkbShlbnVtZXJhdGUocHBvX3RyYWluZXIuZGF0YWxvYWRlcikpJTNBJTBBJTIwJTIwJTIwJTIwcXVlc3Rpb25fdGVuc29ycyUyMCUzRCUyMGJhdGNoJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTBBJTBBJTA5JTIzJTIwc2FtcGxlJTIwZnJvbSUyMHRoZSUyMHBvbGljeSUyMGFuZCUyMHRvJTIwZ2VuZXJhdGUlMjByZXNwb25zZXMlMEElMjAlMjAlMjAlMjByZXNwb25zZV90ZW5zb3JzJTIwJTNEJTIwcHBvX3RyYWluZXIuZ2VuZXJhdGUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcXVlc3Rpb25fdGVuc29ycyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybl9wcm9tcHQlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxlbmd0aF9zYW1wbGVyJTNEb3V0cHV0X2xlbmd0aF9zYW1wbGVyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKipnZW5lcmF0aW9uX2t3YXJncyUyQyUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjBiYXRjaCU1QiUyMnJlc3BvbnNlJTIyJTVEJTIwJTNEJTIwdG9rZW5pemVyLmJhdGNoX2RlY29kZShyZXNwb25zZV90ZW5zb3JzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwQ29tcHV0ZSUyMHNlbnRpbWVudCUyMHNjb3JlJTBBJTIwJTIwJTIwJTIwdGV4dHMlMjAlM0QlMjAlNUJxJTIwJTJCJTIwciUyMGZvciUyMHElMkMlMjByJTIwaW4lMjB6aXAoYmF0Y2glNUIlMjJxdWVyeSUyMiU1RCUyQyUyMGJhdGNoJTVCJTIycmVzcG9uc2UlMjIlNUQpJTVEJTBBJTIwJTIwJTIwJTIwcGlwZV9vdXRwdXRzJTIwJTNEJTIwc2VudGltZW50X3BpcGUodGV4dHMlMkMlMjAqKnNlbnRfa3dhcmdzKSUwQSUyMCUyMCUyMCUyMHJld2FyZHMlMjAlM0QlMjAlNUJ0b3JjaC50ZW5zb3Iob3V0cHV0JTVCMCU1RCU1QiUyMnNjb3JlJTIyJTVEJTIwLSUyMHNjcmlwdF9hcmdzLnJld2FyZF9iYXNlbGluZSklMjBmb3IlMjBvdXRwdXQlMjBpbiUyMHBpcGVfb3V0cHV0cyU1RCUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFJ1biUyMFBQTyUyMHN0ZXAlMEElMjAlMjAlMjAlMjBzdGF0cyUyMCUzRCUyMHBwb190cmFpbmVyLnN0ZXAocXVlc3Rpb25fdGVuc29ycyUyQyUyMHJlc3BvbnNlX3RlbnNvcnMlMkMlMjByZXdhcmRzKSUwQSUwOSUyMyUyMExvZyUyMHN0YXRzJTIwdG8lMjBXYW5kYiUwQSUyMCUyMCUyMCUyMHBwb190cmFpbmVyLmxvZ19zdGF0cyhzdGF0cyUyQyUyMGJhdGNoJTJDJTIwcmV3YXJkcyk=",highlighted:`<span class="hljs-keyword">for</span> epoch, batch <span class="hljs-keyword">in</span> tqdm(<span class="hljs-built_in">enumerate</span>(ppo_trainer.dataloader)):
    question_tensors = batch[<span class="hljs-string">&quot;input_ids&quot;</span>]

	<span class="hljs-comment"># sample from the policy and to generate responses</span>
    response_tensors = ppo_trainer.generate(
        question_tensors,
        return_prompt=<span class="hljs-literal">False</span>,
        length_sampler=output_length_sampler,
        **generation_kwargs,
    )
    batch[<span class="hljs-string">&quot;response&quot;</span>] = tokenizer.batch_decode(response_tensors, skip_special_tokens=<span class="hljs-literal">True</span>)

    <span class="hljs-comment"># Compute sentiment score</span>
    texts = [q + r <span class="hljs-keyword">for</span> q, r <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(batch[<span class="hljs-string">&quot;query&quot;</span>], batch[<span class="hljs-string">&quot;response&quot;</span>])]
    pipe_outputs = sentiment_pipe(texts, **sent_kwargs)
    rewards = [torch.tensor(output[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;score&quot;</span>] - script_args.reward_baseline) <span class="hljs-keyword">for</span> output <span class="hljs-keyword">in</span> pipe_outputs]

    <span class="hljs-comment"># Run PPO step</span>
    stats = ppo_trainer.step(question_tensors, response_tensors, rewards)
	<span class="hljs-comment"># Log stats to Wandb</span>
    ppo_trainer.log_stats(stats, batch, rewards)`,wrap:!1}}),D=new jt({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/using_llama_models.md"}}),{c(){w=i("meta"),ne=s(),ee=i("p"),se=s(),p(y.$$.fragment),ae=s(),M=i("p"),M.innerHTML=Fe,ie=s(),p(f.$$.fragment),oe=s(),T=i("p"),T.innerHTML=Ne,re=s(),g=i("p"),g.innerHTML=Se,pe=s(),J=i("p"),J.textContent=Ee,ce=s(),U=i("p"),U.textContent=qe,de=s(),b=i("p"),b.textContent=Ye,me=s(),j=i("p"),j.innerHTML=Pe,he=s(),C=i("p"),C.innerHTML=Ke,ue=s(),p(I.$$.fragment),we=s(),p(_.$$.fragment),ye=s(),v=i("p"),v.innerHTML=De,Me=s(),k=i("p"),k.textContent=Oe,fe=s(),B=i("p"),B.innerHTML=et,Te=s(),R=i("p"),R.textContent=tt,ge=s(),p(x.$$.fragment),Je=s(),H=i("p"),H.textContent=lt,Ue=s(),$=i("p"),$.innerHTML=nt,be=s(),A=i("p"),A.textContent=st,je=s(),p(G.$$.fragment),Ce=s(),Z=i("p"),Z.textContent=at,Ie=s(),L=i("p"),L.innerHTML=it,_e=s(),V=i("p"),V.innerHTML=ot,ve=s(),p(X.$$.fragment),ke=s(),z=i("p"),z.innerHTML=rt,Be=s(),p(W.$$.fragment),Re=s(),Q=i("p"),Q.textContent=pt,xe=s(),p(F.$$.fragment),He=s(),N=i("p"),N.textContent=ct,$e=s(),S=i("ol"),S.innerHTML=dt,Ae=s(),E=i("p"),E.textContent=mt,Ge=s(),p(q.$$.fragment),Ze=s(),Y=i("p"),Y.innerHTML=ht,Le=s(),p(P.$$.fragment),Ve=s(),K=i("p"),K.innerHTML=ut,Xe=s(),p(D.$$.fragment),ze=s(),te=i("p"),this.h()},l(e){const t=Ut("svelte-u9bgzb",document.head);w=o(t,"META",{name:!0,content:!0}),t.forEach(l),ne=a(e),ee=o(e,"P",{}),wt(ee).forEach(l),se=a(e),c(y.$$.fragment,e),ae=a(e),M=o(e,"P",{"data-svelte-h":!0}),r(M)!=="svelte-e13aq4"&&(M.innerHTML=Fe),ie=a(e),c(f.$$.fragment,e),oe=a(e),T=o(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-16n3a3d"&&(T.innerHTML=Ne),re=a(e),g=o(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-15jce6t"&&(g.innerHTML=Se),pe=a(e),J=o(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-13fiyhv"&&(J.textContent=Ee),ce=a(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-14acoww"&&(U.textContent=qe),de=a(e),b=o(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-4ezqnt"&&(b.textContent=Ye),me=a(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-135llhq"&&(j.innerHTML=Pe),he=a(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-iudduc"&&(C.innerHTML=Ke),ue=a(e),c(I.$$.fragment,e),we=a(e),c(_.$$.fragment,e),ye=a(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-lj6rat"&&(v.innerHTML=De),Me=a(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-qefjfd"&&(k.textContent=Oe),fe=a(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1ip2zai"&&(B.innerHTML=et),Te=a(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1gv8jsw"&&(R.textContent=tt),ge=a(e),c(x.$$.fragment,e),Je=a(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-n2utf9"&&(H.textContent=lt),Ue=a(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1rx67l9"&&($.innerHTML=nt),be=a(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-exsorg"&&(A.textContent=st),je=a(e),c(G.$$.fragment,e),Ce=a(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-yra23x"&&(Z.textContent=at),Ie=a(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-14koobd"&&(L.innerHTML=it),_e=a(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-15d99ek"&&(V.innerHTML=ot),ve=a(e),c(X.$$.fragment,e),ke=a(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-14vojqw"&&(z.innerHTML=rt),Be=a(e),c(W.$$.fragment,e),Re=a(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-103ifl4"&&(Q.textContent=pt),xe=a(e),c(F.$$.fragment,e),He=a(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1hyr34n"&&(N.textContent=ct),$e=a(e),S=o(e,"OL",{"data-svelte-h":!0}),r(S)!=="svelte-oi045r"&&(S.innerHTML=dt),Ae=a(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-ffg2nl"&&(E.textContent=mt),Ge=a(e),c(q.$$.fragment,e),Ze=a(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-unvala"&&(Y.innerHTML=ht),Le=a(e),c(P.$$.fragment,e),Ve=a(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-hi9qdh"&&(K.innerHTML=ut),Xe=a(e),c(D.$$.fragment,e),ze=a(e),te=o(e,"P",{}),wt(te).forEach(l),this.h()},h(){yt(w,"name","hf:doc:metadata"),yt(w,"content",It)},m(e,t){bt(document.head,w),n(e,ne,t),n(e,ee,t),n(e,se,t),d(y,e,t),n(e,ae,t),n(e,M,t),n(e,ie,t),d(f,e,t),n(e,oe,t),n(e,T,t),n(e,re,t),n(e,g,t),n(e,pe,t),n(e,J,t),n(e,ce,t),n(e,U,t),n(e,de,t),n(e,b,t),n(e,me,t),n(e,j,t),n(e,he,t),n(e,C,t),n(e,ue,t),d(I,e,t),n(e,we,t),d(_,e,t),n(e,ye,t),n(e,v,t),n(e,Me,t),n(e,k,t),n(e,fe,t),n(e,B,t),n(e,Te,t),n(e,R,t),n(e,ge,t),d(x,e,t),n(e,Je,t),n(e,H,t),n(e,Ue,t),n(e,$,t),n(e,be,t),n(e,A,t),n(e,je,t),d(G,e,t),n(e,Ce,t),n(e,Z,t),n(e,Ie,t),n(e,L,t),n(e,_e,t),n(e,V,t),n(e,ve,t),d(X,e,t),n(e,ke,t),n(e,z,t),n(e,Be,t),d(W,e,t),n(e,Re,t),n(e,Q,t),n(e,xe,t),d(F,e,t),n(e,He,t),n(e,N,t),n(e,$e,t),n(e,S,t),n(e,Ae,t),n(e,E,t),n(e,Ge,t),d(q,e,t),n(e,Ze,t),n(e,Y,t),n(e,Le,t),d(P,e,t),n(e,Ve,t),n(e,K,t),n(e,Xe,t),d(D,e,t),n(e,ze,t),n(e,te,t),We=!0},p:ft,i(e){We||(m(y.$$.fragment,e),m(f.$$.fragment,e),m(I.$$.fragment,e),m(_.$$.fragment,e),m(x.$$.fragment,e),m(G.$$.fragment,e),m(X.$$.fragment,e),m(W.$$.fragment,e),m(F.$$.fragment,e),m(q.$$.fragment,e),m(P.$$.fragment,e),m(D.$$.fragment,e),We=!0)},o(e){h(y.$$.fragment,e),h(f.$$.fragment,e),h(I.$$.fragment,e),h(_.$$.fragment,e),h(x.$$.fragment,e),h(G.$$.fragment,e),h(X.$$.fragment,e),h(W.$$.fragment,e),h(F.$$.fragment,e),h(q.$$.fragment,e),h(P.$$.fragment,e),h(D.$$.fragment,e),We=!1},d(e){e&&(l(ne),l(ee),l(se),l(ae),l(M),l(ie),l(oe),l(T),l(re),l(g),l(pe),l(J),l(ce),l(U),l(de),l(b),l(me),l(j),l(he),l(C),l(ue),l(we),l(ye),l(v),l(Me),l(k),l(fe),l(B),l(Te),l(R),l(ge),l(Je),l(H),l(Ue),l($),l(be),l(A),l(je),l(Ce),l(Z),l(Ie),l(L),l(_e),l(V),l(ve),l(ke),l(z),l(Be),l(Re),l(Q),l(xe),l(He),l(N),l($e),l(S),l(Ae),l(E),l(Ge),l(Ze),l(Y),l(Le),l(Ve),l(K),l(Xe),l(ze),l(te)),l(w),u(y,e),u(f,e),u(I,e),u(_,e),u(x,e),u(G,e),u(X,e),u(W,e),u(F,e),u(q,e),u(P,e),u(D,e)}}}const It='{"title":"Using LLaMA models with TRL","local":"using-llama-models-with-trl","sections":[{"title":"Efficient training strategies","local":"efficient-training-strategies","sections":[],"depth":2},{"title":"Supervised fine-tuning","local":"supervised-fine-tuning","sections":[],"depth":2},{"title":"Reward modeling and human preferences","local":"reward-modeling-and-human-preferences","sections":[],"depth":2},{"title":"Reinforcement Learning from Human Feedback","local":"reinforcement-learning-from-human-feedback","sections":[],"depth":2}],"depth":1}';function _t(Qe){return Tt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class xt extends gt{constructor(w){super(),Jt(this,w,_t,Ct,Mt,{})}}export{xt as component};
