import{s as BT,n as YT,o as ET}from"../chunks/scheduler.d6170356.js";import{S as LT,i as ZT,g as k,s as M,r as w,A as _T,h as j,f as J,c as y,j as $T,u as I,x as t,k as bT,y as xT,a as l,v as A,d as C,t as g,w as i}from"../chunks/index.fcd4cc08.js";import{C as O}from"../chunks/CodeBlock.db16bf50.js";import{H as G,E as GT}from"../chunks/index.57043804.js";function qT(oT){let e,z,q,W,s,X,a,mT='On this page we’ll guide you through some of the most common operations used when doing data analysis. This is only a small subset of what’s possible in Polars. For more information, please visit the <a href="https://docs.pola.rs/" rel="nofollow">Documentation</a>.',H,n,rT='For the example we will use the <a href="https://huggingface.co/datasets/commoncrawl/statistics" rel="nofollow">Common Crawl statistics</a> dataset. These statistics include: number of pages, distribution of top-level domains, crawl overlaps, etc. For more detailed information and graphs please visit their <a href="https://commoncrawl.github.io/cc-crawl-statistics/plots/tlds" rel="nofollow">official statistics page</a>.',K,N,P,R,TT,F,UT,V,JT,p,ST="The dataset contains some columns we don’t need. To remove them, we will use the <code>select</code> method:",lT,o,MT,m,yT,r,wT,S,QT="We can filter the dataset using the <code>filter</code> method. This method accepts complex expressions, but let’s start simple by filtering based on the crawl date:",IT,Q,AT,D,DT="You can combine multiple predicates with <code>&amp;</code> or <code>|</code> operators:",CT,u,gT,c,iT,f,uT='In order to add new columns to the dataset, use <code>with_columns</code>. In the example below we calculate the total number of pages per domain and add a new column <code>pages_per_domain</code> using the <code>alias</code> method. The entire statement within <code>with_columns</code> is called an expression. Read more about expressions and how to use them in the <a href="https://docs.pola.rs/user-guide/expressions/" rel="nofollow">Polars user guide</a>',kT,d,jT,h,OT,$,tT,b,cT="In order to aggregate data together you can use the <code>group_by</code>, <code>agg</code> and <code>sort</code> methods. Within the aggregation context you can combine expressions to create powerful statements which are still easy to read.",eT,B,fT="First, we aggregate all the data to the top-level domain <code>tld</code> per scraped date:",sT,Y,aT,E,dT="Now we can calculate several statistics per top level domain:",nT,L,hT="<li>Number of unique scrape dates</li> <li>Average number of domains in the scraped period</li> <li>Average growth rate in terms of number of pages</li>",NT,Z,RT,_,FT,x,VT,v,pT;return s=new G({props:{title:"Transforming your dataset",local:"transforming-your-dataset",headingTag:"h1"}}),N=new G({props:{title:"Reading",local:"reading",headingTag:"h2"}}),R=new O({props:{code:"aW1wb3J0JTIwcG9sYXJzJTIwYXMlMjBwbCUwQSUwQWRmJTIwJTNEJTIwcGwucmVhZF9jc3YoJTBBJTIwJTIwJTIwJTIwJTIyaGYlM0ElMkYlMkZkYXRhc2V0cyUyRmNvbW1vbmNyYXdsJTJGc3RhdGlzdGljcyUyRnRsZHMuY3N2JTIyJTJDJTBBJTIwJTIwJTIwJTIwdHJ5X3BhcnNlX2RhdGVzJTNEVHJ1ZSUyQyUwQSklMEFkZi5oZWFkKDMp",highlighted:`<span class="hljs-keyword">import</span> polars <span class="hljs-keyword">as</span> pl

df = pl.read_csv(
    <span class="hljs-string">&quot;hf://datasets/commoncrawl/statistics/tlds.csv&quot;</span>,
    try_parse_dates=<span class="hljs-literal">True</span>,
)
df.head(<span class="hljs-number">3</span>)`,wrap:!1}}),F=new O({props:{code:"JUUyJTk0JThDJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JUFDJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JUFDJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JUFDJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JUFDJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JUFDJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JUFDJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JUFDJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JUFDJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTkwJTBBJUUyJTk0JTgyJTIwJTIwJTIwJTIwJTIwJUUyJTk0JTg2JTIwc3VmZml4JTIwJUUyJTk0JTg2JTIwY3Jhd2wlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlRTIlOTQlODYlMjBkYXRlJTIwJTIwJTIwJTIwJTIwJTIwJTIwJUUyJTk0JTg2JTIwJUUyJTgwJUE2JTIwJUUyJTk0JTg2JTIwcGFnZXMlMjAlRTIlOTQlODYlMjB1cmxzJTIwJUUyJTk0JTg2JTIwaG9zdHMlMjAlRTIlOTQlODYlMjBkb21haW5zJTIwJUUyJTk0JTgyJTBBJUUyJTk0JTgyJTIwLS0tJTIwJUUyJTk0JTg2JTIwLS0tJTIwJTIwJTIwJTIwJUUyJTk0JTg2JTIwLS0tJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJUUyJTk0JTg2JTIwLS0tJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJUUyJTk0JTg2JTIwJTIwJTIwJUUyJTk0JTg2JTIwLS0tJTIwJTIwJTIwJUUyJTk0JTg2JTIwLS0tJTIwJTIwJUUyJTk0JTg2JTIwLS0tJTIwJTIwJTIwJUUyJTk0JTg2JTIwLS0tJTIwJTIwJTIwJTIwJTIwJUUyJTk0JTgyJTBBJUUyJTk0JTgyJTIwaTY0JTIwJUUyJTk0JTg2JTIwc3RyJTIwJTIwJTIwJTIwJUUyJTk0JTg2JTIwc3RyJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJUUyJTk0JTg2JTIwZGF0ZSUyMCUyMCUyMCUyMCUyMCUyMCUyMCVFMiU5NCU4NiUyMCUyMCUyMCVFMiU5NCU4NiUyMGk2NCUyMCUyMCUyMCVFMiU5NCU4NiUyMGk2NCUyMCUyMCVFMiU5NCU4NiUyMGY2NCUyMCUyMCUyMCVFMiU5NCU4NiUyMGY2NCUyMCUyMCUyMCUyMCUyMCVFMiU5NCU4MiUwQSVFMiU5NSU5RSVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSVBQSVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSVBQSVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSVBQSVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSVBQSVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSVBQSVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSVBQSVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSVBQSVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSVBQSVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSVBMSUwQSVFMiU5NCU4MiUyMDAlMjAlMjAlMjAlRTIlOTQlODYlMjBhLnNlJTIwJTIwJTIwJUUyJTk0JTg2JTIwQ0MtTUFJTi0yMDA4LTIwMDklMjAlRTIlOTQlODYlMjAyMDA5LTAxLTEyJTIwJUUyJTk0JTg2JTIwJUUyJTgwJUE2JTIwJUUyJTk0JTg2JTIwMTglMjAlMjAlMjAlMjAlRTIlOTQlODYlMjAxOCUyMCUyMCUyMCVFMiU5NCU4NiUyMDEuMCUyMCUyMCUyMCVFMiU5NCU4NiUyMDEuMCUyMCUyMCUyMCUyMCUyMCVFMiU5NCU4MiUwQSVFMiU5NCU4MiUyMDElMjAlMjAlMjAlRTIlOTQlODYlMjBhLnNlJTIwJTIwJTIwJUUyJTk0JTg2JTIwQ0MtTUFJTi0yMDA5LTIwMTAlMjAlRTIlOTQlODYlMjAyMDEwLTA5LTI1JTIwJUUyJTk0JTg2JTIwJUUyJTgwJUE2JTIwJUUyJTk0JTg2JTIwMzQ2MiUyMCUyMCVFMiU5NCU4NiUyMDMyNTklMjAlRTIlOTQlODYlMjAxNjYuMCUyMCVFMiU5NCU4NiUyMDE1MS4wJTIwJTIwJTIwJUUyJTk0JTgyJTBBJUUyJTk0JTgyJTIwMiUyMCUyMCUyMCVFMiU5NCU4NiUyMGEuc2UlMjAlMjAlMjAlRTIlOTQlODYlMjBDQy1NQUlOLTIwMTIlMjAlMjAlMjAlMjAlMjAlMjAlRTIlOTQlODYlMjAyMDEyLTExLTAyJTIwJUUyJTk0JTg2JTIwJUUyJTgwJUE2JTIwJUUyJTk0JTg2JTIwNjk1NyUyMCUyMCVFMiU5NCU4NiUyMDY3OTQlMjAlRTIlOTQlODYlMjAxNzIuMCUyMCVFMiU5NCU4NiUyMDE1MC4wJTIwJTIwJTIwJUUyJTk0JTgyJTBBJUUyJTk0JTk0JUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JUI0JUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JUI0JUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JUI0JUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JUI0JUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JUI0JUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JUI0JUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JUI0JUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JUI0JUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTk4",highlighted:`┌─────┬────────┬───────────────────┬────────────┬───┬───────┬──────┬───────┬─────────┐
│     ┆ suffix ┆ crawl             ┆ <span class="hljs-built_in">date</span>       ┆ … ┆ pages ┆ urls ┆ hosts ┆ domains │
│ --- ┆ ---    ┆ ---               ┆ ---        ┆   ┆ ---   ┆ ---  ┆ ---   ┆ ---     │
│ i64 ┆ str    ┆ str               ┆ <span class="hljs-built_in">date</span>       ┆   ┆ i64   ┆ i64  ┆ f64   ┆ f64     │
╞═════╪════════╪═══════════════════╪════════════╪═══╪═══════╪══════╪═══════╪═════════╡
│ 0   ┆ a.se   ┆ CC-MAIN-2008-2009 ┆ 2009-01-12 ┆ … ┆ 18    ┆ 18   ┆ 1.0   ┆ 1.0     │
│ 1   ┆ a.se   ┆ CC-MAIN-2009-2010 ┆ 2010-09-25 ┆ … ┆ 3462  ┆ 3259 ┆ 166.0 ┆ 151.0   │
│ 2   ┆ a.se   ┆ CC-MAIN-2012      ┆ 2012-11-02 ┆ … ┆ 6957  ┆ 6794 ┆ 172.0 ┆ 150.0   │
└─────┴────────┴───────────────────┴────────────┴───┴───────┴──────┴───────┴─────────┘`,wrap:!1}}),V=new G({props:{title:"Selecting columns",local:"selecting-columns",headingTag:"h2"}}),o=new O({props:{code:"ZGYlMjAlM0QlMjBkZi5zZWxlY3QoJTIyc3VmZml4JTIyJTJDJTIwJTIyZGF0ZSUyMiUyQyUyMCUyMnRsZCUyMiUyQyUyMCUyMnBhZ2VzJTIyJTJDJTIwJTIyZG9tYWlucyUyMiklMEFkZi5oZWFkKDMp",highlighted:`df = df.select(<span class="hljs-string">&quot;suffix&quot;</span>, <span class="hljs-string">&quot;date&quot;</span>, <span class="hljs-string">&quot;tld&quot;</span>, <span class="hljs-string">&quot;pages&quot;</span>, <span class="hljs-string">&quot;domains&quot;</span>)
df.head(<span class="hljs-number">3</span>)`,wrap:!1}}),m=new O({props:{code:"JUUyJTk0JThDJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JUFDJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JUFDJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JUFDJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JUFDJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JUFDJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTkwJTBBJUUyJTk0JTgyJTIwc3VmZml4JTIwJUUyJTk0JTg2JTIwY3Jhd2wlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlRTIlOTQlODYlMjBkYXRlJTIwJTIwJTIwJTIwJTIwJTIwJTIwJUUyJTk0JTg2JTIwdGxkJTIwJUUyJTk0JTg2JTIwcGFnZXMlMjAlRTIlOTQlODYlMjBkb21haW5zJTIwJUUyJTk0JTgyJTBBJUUyJTk0JTgyJTIwLS0tJTIwJTIwJTIwJTIwJUUyJTk0JTg2JTIwLS0tJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJUUyJTk0JTg2JTIwLS0tJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJUUyJTk0JTg2JTIwLS0tJTIwJUUyJTk0JTg2JTIwLS0tJTIwJTIwJTIwJUUyJTk0JTg2JTIwLS0tJTIwJTIwJTIwJTIwJTIwJUUyJTk0JTgyJTBBJUUyJTk0JTgyJTIwc3RyJTIwJTIwJTIwJTIwJUUyJTk0JTg2JTIwc3RyJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJUUyJTk0JTg2JTIwZGF0ZSUyMCUyMCUyMCUyMCUyMCUyMCUyMCVFMiU5NCU4NiUyMHN0ciUyMCVFMiU5NCU4NiUyMGk2NCUyMCUyMCUyMCVFMiU5NCU4NiUyMGY2NCUyMCUyMCUyMCUyMCUyMCVFMiU5NCU4MiUwQSVFMiU5NSU5RSVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSVBQSVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSVBQSVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSVBQSVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSVBQSVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSVBQSVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSU5MCVFMiU5NSVBMSUwQSVFMiU5NCU4MiUyMGEuc2UlMjAlMjAlMjAlRTIlOTQlODYlMjBDQy1NQUlOLTIwMDgtMjAwOSUyMCVFMiU5NCU4NiUyMDIwMDktMDEtMTIlMjAlRTIlOTQlODYlMjBzZSUyMCUyMCVFMiU5NCU4NiUyMDE4JTIwJTIwJTIwJTIwJUUyJTk0JTg2JTIwMS4wJTIwJTIwJTIwJTIwJTIwJUUyJTk0JTgyJTBBJUUyJTk0JTgyJTIwYS5zZSUyMCUyMCUyMCVFMiU5NCU4NiUyMENDLU1BSU4tMjAwOS0yMDEwJTIwJUUyJTk0JTg2JTIwMjAxMC0wOS0yNSUyMCVFMiU5NCU4NiUyMHNlJTIwJTIwJUUyJTk0JTg2JTIwMzQ2MiUyMCUyMCVFMiU5NCU4NiUyMDE1MS4wJTIwJTIwJTIwJUUyJTk0JTgyJTBBJUUyJTk0JTgyJTIwYS5zZSUyMCUyMCUyMCVFMiU5NCU4NiUyMENDLU1BSU4tMjAxMiUyMCUyMCUyMCUyMCUyMCUyMCVFMiU5NCU4NiUyMDIwMTItMTEtMDIlMjAlRTIlOTQlODYlMjBzZSUyMCUyMCVFMiU5NCU4NiUyMDY5NTclMjAlMjAlRTIlOTQlODYlMjAxNTAuMCUyMCUyMCUyMCVFMiU5NCU4MiUwQSVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCVCNCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCVCNCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCVCNCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCVCNCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCVCNCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU5OA==",highlighted:`┌────────┬───────────────────┬────────────┬─────┬───────┬─────────┐
│ suffix ┆ crawl             ┆ <span class="hljs-built_in">date</span>       ┆ tld ┆ pages ┆ domains │
│ ---    ┆ ---               ┆ ---        ┆ --- ┆ ---   ┆ ---     │
│ str    ┆ str               ┆ <span class="hljs-built_in">date</span>       ┆ str ┆ i64   ┆ f64     │
╞════════╪═══════════════════╪════════════╪═════╪═══════╪═════════╡
│ a.se   ┆ CC-MAIN-2008-2009 ┆ 2009-01-12 ┆ se  ┆ 18    ┆ 1.0     │
│ a.se   ┆ CC-MAIN-2009-2010 ┆ 2010-09-25 ┆ se  ┆ 3462  ┆ 151.0   │
│ a.se   ┆ CC-MAIN-2012      ┆ 2012-11-02 ┆ se  ┆ 6957  ┆ 150.0   │
└────────┴───────────────────┴────────────┴─────┴───────┴─────────┘`,wrap:!1}}),r=new G({props:{title:"Filtering",local:"filtering",headingTag:"h2"}}),Q=new O({props:{code:"aW1wb3J0JTIwZGF0ZXRpbWUlMEElMEFkZiUyMCUzRCUyMGRmLmZpbHRlcihwbC5jb2woJTIyZGF0ZSUyMiklMjAlM0UlM0QlMjBkYXRldGltZS5kYXRlKDIwMjAlMkMlMjAxJTJDJTIwMSkp",highlighted:`<span class="hljs-keyword">import</span> datetime

df = df.<span class="hljs-built_in">filter</span>(pl.col(<span class="hljs-string">&quot;date&quot;</span>) &gt;= datetime.date(<span class="hljs-number">2020</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>))`,wrap:!1}}),u=new O({props:{code:"ZGYlMjAlM0QlMjBkZi5maWx0ZXIoJTBBJTIwJTIwJTIwJTIwKHBsLmNvbCglMjJkYXRlJTIyKSUyMCUzRSUzRCUyMGRhdGV0aW1lLmRhdGUoMjAyMCUyQyUyMDElMkMlMjAxKSklMjAlN0MlMEElMjAlMjAlMjAlMjBwbC5jb2woJTIyY3Jhd2wlMjIpLnN0ci5jb250YWlucyglMjJDQyUyMiklMEEp",highlighted:`df = df.<span class="hljs-built_in">filter</span>(
    (pl.col(<span class="hljs-string">&quot;date&quot;</span>) &gt;= datetime.date(<span class="hljs-number">2020</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>)) |
    pl.col(<span class="hljs-string">&quot;crawl&quot;</span>).<span class="hljs-built_in">str</span>.contains(<span class="hljs-string">&quot;CC&quot;</span>)
)`,wrap:!1}}),c=new G({props:{title:"Transforming",local:"transforming",headingTag:"h2"}}),d=new O({props:{code:"ZGYlMjAlM0QlMjBkZi53aXRoX2NvbHVtbnMoJTBBJTIwJTIwJTIwJTIwKHBsLmNvbCglMjJwYWdlcyUyMiklMjAlMkYlMjBwbC5jb2woJTIyZG9tYWlucyUyMikpLmFsaWFzKCUyMnBhZ2VzX3Blcl9kb21haW4lMjIpJTBBKSUwQWRmLnNhbXBsZSgzKQ==",highlighted:`df = df.with_columns(
    (pl.col(<span class="hljs-string">&quot;pages&quot;</span>) / pl.col(<span class="hljs-string">&quot;domains&quot;</span>)).alias(<span class="hljs-string">&quot;pages_per_domain&quot;</span>)
)
df.sample(<span class="hljs-number">3</span>)`,wrap:!1}}),h=new O({props:{code:"JUUyJTk0JThDJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JUFDJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JUFDJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JUFDJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JUFDJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JUFDJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JUFDJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTkwJTBBJUUyJTk0JTgyJTIwc3VmZml4JTIwJUUyJTk0JTg2JTIwY3Jhd2wlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlRTIlOTQlODYlMjBkYXRlJTIwJTIwJTIwJTIwJTIwJTIwJTIwJUUyJTk0JTg2JTIwdGxkJTIwJUUyJTk0JTg2JTIwcGFnZXMlMjAlRTIlOTQlODYlMjBkb21haW5zJTIwJUUyJTk0JTg2JTIwcGFnZXNfcGVyX2RvbWFpbiUyMCVFMiU5NCU4MiUwQSVFMiU5NCU4MiUyMC0tLSUyMCUyMCUyMCUyMCVFMiU5NCU4NiUyMC0tLSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCVFMiU5NCU4NiUyMC0tLSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCVFMiU5NCU4NiUyMC0tLSUyMCVFMiU5NCU4NiUyMC0tLSUyMCUyMCUyMCVFMiU5NCU4NiUyMC0tLSUyMCUyMCUyMCUyMCUyMCVFMiU5NCU4NiUyMC0tLSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCVFMiU5NCU4MiUwQSVFMiU5NCU4MiUyMHN0ciUyMCUyMCUyMCUyMCVFMiU5NCU4NiUyMHN0ciUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCVFMiU5NCU4NiUyMGRhdGUlMjAlMjAlMjAlMjAlMjAlMjAlMjAlRTIlOTQlODYlMjBzdHIlMjAlRTIlOTQlODYlMjBpNjQlMjAlMjAlMjAlRTIlOTQlODYlMjBmNjQlMjAlMjAlMjAlMjAlMjAlRTIlOTQlODYlMjBmNjQlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlRTIlOTQlODIlMEElRTIlOTUlOUUlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlQUElRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlQUElRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlQUElRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlQUElRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlQUElRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlQUElRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlOTAlRTIlOTUlQTElMEElRTIlOTQlODIlMjBuZXQuYnQlMjAlRTIlOTQlODYlMjBDQy1NQUlOLTIwMTQtNDElMjAlRTIlOTQlODYlMjAyMDE0LTEwLTA2JTIwJUUyJTk0JTg2JTIwYnQlMjAlMjAlRTIlOTQlODYlMjA0JTIwJTIwJTIwJTIwJTIwJUUyJTk0JTg2JTIwMS4wJTIwJTIwJTIwJTIwJTIwJUUyJTk0JTg2JTIwNC4wJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJUUyJTk0JTgyJTBBJUUyJTk0JTgyJTIwb3JnLm1rJTIwJUUyJTk0JTg2JTIwQ0MtTUFJTi0yMDE2LTQ0JTIwJUUyJTk0JTg2JTIwMjAxNi0xMC0zMSUyMCVFMiU5NCU4NiUyMG1rJTIwJTIwJUUyJTk0JTg2JTIwMTQ0NSUyMCUyMCVFMiU5NCU4NiUyMDQzMC4wJTIwJTIwJTIwJUUyJTk0JTg2JTIwMy4zNjA0NjUlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlRTIlOTQlODIlMEElRTIlOTQlODIlMjBjb20ubGMlMjAlRTIlOTQlODYlMjBDQy1NQUlOLTIwMTYtNDQlMjAlRTIlOTQlODYlMjAyMDE2LTEwLTMxJTIwJUUyJTk0JTg2JTIwbGMlMjAlMjAlRTIlOTQlODYlMjAxJTIwJTIwJTIwJTIwJTIwJUUyJTk0JTg2JTIwMS4wJTIwJTIwJTIwJTIwJTIwJUUyJTk0JTg2JTIwMS4wJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJUUyJTk0JTgyJTBBJUUyJTk0JTk0JUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JUI0JUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JUI0JUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JUI0JUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JUI0JUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JUI0JUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JUI0JUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTk4",highlighted:`┌────────┬─────────────────┬────────────┬─────┬───────┬─────────┬──────────────────┐
│ suffix ┆ crawl           ┆ <span class="hljs-built_in">date</span>       ┆ tld ┆ pages ┆ domains ┆ pages_per_domain │
│ ---    ┆ ---             ┆ ---        ┆ --- ┆ ---   ┆ ---     ┆ ---              │
│ str    ┆ str             ┆ <span class="hljs-built_in">date</span>       ┆ str ┆ i64   ┆ f64     ┆ f64              │
╞════════╪═════════════════╪════════════╪═════╪═══════╪═════════╪══════════════════╡
│ net.bt ┆ CC-MAIN-2014-41 ┆ 2014-10-06 ┆ bt  ┆ 4     ┆ 1.0     ┆ 4.0              │
│ org.mk ┆ CC-MAIN-2016-44 ┆ 2016-10-31 ┆ mk  ┆ 1445  ┆ 430.0   ┆ 3.360465         │
│ com.lc ┆ CC-MAIN-2016-44 ┆ 2016-10-31 ┆ lc  ┆ 1     ┆ 1.0     ┆ 1.0              │
└────────┴─────────────────┴────────────┴─────┴───────┴─────────┴──────────────────┘`,wrap:!1}}),$=new G({props:{title:"Aggregation & Sorting",local:"aggregation--sorting",headingTag:"h2"}}),Y=new O({props:{code:"ZGYlMjAlM0QlMjBkZi5ncm91cF9ieSglMjJ0bGQlMjIlMkMlMjAlMjJkYXRlJTIyKS5hZ2coJTBBJTIwJTIwJTIwJTIwcGwuY29sKCUyMnBhZ2VzJTIyKS5zdW0oKSUyQyUwQSUyMCUyMCUyMCUyMHBsLmNvbCglMjJkb21haW5zJTIyKS5zdW0oKSUyQyUwQSk=",highlighted:`df = df.group_by(<span class="hljs-string">&quot;tld&quot;</span>, <span class="hljs-string">&quot;date&quot;</span>).agg(
    pl.col(<span class="hljs-string">&quot;pages&quot;</span>).<span class="hljs-built_in">sum</span>(),
    pl.col(<span class="hljs-string">&quot;domains&quot;</span>).<span class="hljs-built_in">sum</span>(),
)`,wrap:!1}}),Z=new O({props:{code:"ZGYlMjAlM0QlMjBkZi5ncm91cF9ieSglMjJ0bGQlMjIpLmFnZyglMEElMjAlMjAlMjAlMjBwbC5jb2woJTIyZGF0ZSUyMikudW5pcXVlKCkuY291bnQoKS5hbGlhcyglMjJudW1iZXJfb2Zfc2NyYXBlcyUyMiklMkMlMEElMjAlMjAlMjAlMjBwbC5jb2woJTIyZG9tYWlucyUyMikubWVhbigpLmFsaWFzKCUyMmF2Z19udW1iZXJfb2ZfZG9tYWlucyUyMiklMkMlMEElMjAlMjAlMjAlMjBwbC5jb2woJTIycGFnZXMlMjIpLnNvcnRfYnkoJTIyZGF0ZSUyMikucGN0X2NoYW5nZSgpLm1lYW4oKS5hbGlhcyglMjJhdmdfcGFnZV9ncm93dGhfcmF0ZSUyMiklMkMlMEEpJTBBZGYlMjAlM0QlMjBkZi5zb3J0KCUyMmF2Z19udW1iZXJfb2ZfZG9tYWlucyUyMiUyQyUyMGRlc2NlbmRpbmclM0RUcnVlKSUwQWRmLmhlYWQoMTAp",highlighted:`df = df.group_by(<span class="hljs-string">&quot;tld&quot;</span>).agg(
    pl.col(<span class="hljs-string">&quot;date&quot;</span>).unique().count().alias(<span class="hljs-string">&quot;number_of_scrapes&quot;</span>),
    pl.col(<span class="hljs-string">&quot;domains&quot;</span>).mean().alias(<span class="hljs-string">&quot;avg_number_of_domains&quot;</span>),
    pl.col(<span class="hljs-string">&quot;pages&quot;</span>).sort_by(<span class="hljs-string">&quot;date&quot;</span>).pct_change().mean().alias(<span class="hljs-string">&quot;avg_page_growth_rate&quot;</span>),
)
df = df.sort(<span class="hljs-string">&quot;avg_number_of_domains&quot;</span>, descending=<span class="hljs-literal">True</span>)
df.head(<span class="hljs-number">10</span>)`,wrap:!1}}),_=new O({props:{code:"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",highlighted:`┌─────┬───────────────────┬───────────────────────┬─────────────────────────────────┐
│ tld ┆ number_of_scrapes ┆ avg_number_of_domains ┆ avg_percent_change_in_number_o… │
│ --- ┆ ---               ┆ ---                   ┆ ---                             │
│ str ┆ u32               ┆ f64                   ┆ f64                             │
╞═════╪═══════════════════╪═══════════════════════╪═════════════════════════════════╡
│ com ┆ 101               ┆ 1.9571e7              ┆ 0.022182                        │
│ de  ┆ 101               ┆ 1.8633e6              ┆ 0.5232                          │
│ org ┆ 101               ┆ 1.5049e6              ┆ 0.019604                        │
│ net ┆ 101               ┆ 1.5020e6              ┆ 0.021002                        │
│ cn  ┆ 101               ┆ 1.1101e6              ┆ 0.281726                        │
│ ru  ┆ 101               ┆ 1.0561e6              ┆ 0.416303                        │
│ uk  ┆ 101               ┆ 827453.732673         ┆ 0.065299                        │
│ <span class="hljs-built_in">nl</span>  ┆ 101               ┆ 710492.623762         ┆ 1.040096                        │
│ fr  ┆ 101               ┆ 615471.594059         ┆ 0.419181                        │
│ jp  ┆ 101               ┆ 615391.455446         ┆ 0.246162                        │
└─────┴───────────────────┴───────────────────────┴─────────────────────────────────┘`,wrap:!1}}),x=new GT({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/hub/datasets-polars-operations.md"}}),{c(){e=k("meta"),z=M(),q=k("p"),W=M(),w(s.$$.fragment),X=M(),a=k("p"),a.innerHTML=mT,H=M(),n=k("p"),n.innerHTML=rT,K=M(),w(N.$$.fragment),P=M(),w(R.$$.fragment),TT=M(),w(F.$$.fragment),UT=M(),w(V.$$.fragment),JT=M(),p=k("p"),p.innerHTML=ST,lT=M(),w(o.$$.fragment),MT=M(),w(m.$$.fragment),yT=M(),w(r.$$.fragment),wT=M(),S=k("p"),S.innerHTML=QT,IT=M(),w(Q.$$.fragment),AT=M(),D=k("p"),D.innerHTML=DT,CT=M(),w(u.$$.fragment),gT=M(),w(c.$$.fragment),iT=M(),f=k("p"),f.innerHTML=uT,kT=M(),w(d.$$.fragment),jT=M(),w(h.$$.fragment),OT=M(),w($.$$.fragment),tT=M(),b=k("p"),b.innerHTML=cT,eT=M(),B=k("p"),B.innerHTML=fT,sT=M(),w(Y.$$.fragment),aT=M(),E=k("p"),E.textContent=dT,nT=M(),L=k("ul"),L.innerHTML=hT,NT=M(),w(Z.$$.fragment),RT=M(),w(_.$$.fragment),FT=M(),w(x.$$.fragment),VT=M(),v=k("p"),this.h()},l(T){const U=_T("svelte-u9bgzb",document.head);e=j(U,"META",{name:!0,content:!0}),U.forEach(J),z=y(T),q=j(T,"P",{}),$T(q).forEach(J),W=y(T),I(s.$$.fragment,T),X=y(T),a=j(T,"P",{"data-svelte-h":!0}),t(a)!=="svelte-14quumy"&&(a.innerHTML=mT),H=y(T),n=j(T,"P",{"data-svelte-h":!0}),t(n)!=="svelte-cvpc7g"&&(n.innerHTML=rT),K=y(T),I(N.$$.fragment,T),P=y(T),I(R.$$.fragment,T),TT=y(T),I(F.$$.fragment,T),UT=y(T),I(V.$$.fragment,T),JT=y(T),p=j(T,"P",{"data-svelte-h":!0}),t(p)!=="svelte-dn21je"&&(p.innerHTML=ST),lT=y(T),I(o.$$.fragment,T),MT=y(T),I(m.$$.fragment,T),yT=y(T),I(r.$$.fragment,T),wT=y(T),S=j(T,"P",{"data-svelte-h":!0}),t(S)!=="svelte-1nw7hvm"&&(S.innerHTML=QT),IT=y(T),I(Q.$$.fragment,T),AT=y(T),D=j(T,"P",{"data-svelte-h":!0}),t(D)!=="svelte-j5zxl8"&&(D.innerHTML=DT),CT=y(T),I(u.$$.fragment,T),gT=y(T),I(c.$$.fragment,T),iT=y(T),f=j(T,"P",{"data-svelte-h":!0}),t(f)!=="svelte-6wog1g"&&(f.innerHTML=uT),kT=y(T),I(d.$$.fragment,T),jT=y(T),I(h.$$.fragment,T),OT=y(T),I($.$$.fragment,T),tT=y(T),b=j(T,"P",{"data-svelte-h":!0}),t(b)!=="svelte-z90hq9"&&(b.innerHTML=cT),eT=y(T),B=j(T,"P",{"data-svelte-h":!0}),t(B)!=="svelte-b0wb1l"&&(B.innerHTML=fT),sT=y(T),I(Y.$$.fragment,T),aT=y(T),E=j(T,"P",{"data-svelte-h":!0}),t(E)!=="svelte-1qd7wm9"&&(E.textContent=dT),nT=y(T),L=j(T,"UL",{"data-svelte-h":!0}),t(L)!=="svelte-zpwkeh"&&(L.innerHTML=hT),NT=y(T),I(Z.$$.fragment,T),RT=y(T),I(_.$$.fragment,T),FT=y(T),I(x.$$.fragment,T),VT=y(T),v=j(T,"P",{}),$T(v).forEach(J),this.h()},h(){bT(e,"name","hf:doc:metadata"),bT(e,"content",vT)},m(T,U){xT(document.head,e),l(T,z,U),l(T,q,U),l(T,W,U),A(s,T,U),l(T,X,U),l(T,a,U),l(T,H,U),l(T,n,U),l(T,K,U),A(N,T,U),l(T,P,U),A(R,T,U),l(T,TT,U),A(F,T,U),l(T,UT,U),A(V,T,U),l(T,JT,U),l(T,p,U),l(T,lT,U),A(o,T,U),l(T,MT,U),A(m,T,U),l(T,yT,U),A(r,T,U),l(T,wT,U),l(T,S,U),l(T,IT,U),A(Q,T,U),l(T,AT,U),l(T,D,U),l(T,CT,U),A(u,T,U),l(T,gT,U),A(c,T,U),l(T,iT,U),l(T,f,U),l(T,kT,U),A(d,T,U),l(T,jT,U),A(h,T,U),l(T,OT,U),A($,T,U),l(T,tT,U),l(T,b,U),l(T,eT,U),l(T,B,U),l(T,sT,U),A(Y,T,U),l(T,aT,U),l(T,E,U),l(T,nT,U),l(T,L,U),l(T,NT,U),A(Z,T,U),l(T,RT,U),A(_,T,U),l(T,FT,U),A(x,T,U),l(T,VT,U),l(T,v,U),pT=!0},p:YT,i(T){pT||(C(s.$$.fragment,T),C(N.$$.fragment,T),C(R.$$.fragment,T),C(F.$$.fragment,T),C(V.$$.fragment,T),C(o.$$.fragment,T),C(m.$$.fragment,T),C(r.$$.fragment,T),C(Q.$$.fragment,T),C(u.$$.fragment,T),C(c.$$.fragment,T),C(d.$$.fragment,T),C(h.$$.fragment,T),C($.$$.fragment,T),C(Y.$$.fragment,T),C(Z.$$.fragment,T),C(_.$$.fragment,T),C(x.$$.fragment,T),pT=!0)},o(T){g(s.$$.fragment,T),g(N.$$.fragment,T),g(R.$$.fragment,T),g(F.$$.fragment,T),g(V.$$.fragment,T),g(o.$$.fragment,T),g(m.$$.fragment,T),g(r.$$.fragment,T),g(Q.$$.fragment,T),g(u.$$.fragment,T),g(c.$$.fragment,T),g(d.$$.fragment,T),g(h.$$.fragment,T),g($.$$.fragment,T),g(Y.$$.fragment,T),g(Z.$$.fragment,T),g(_.$$.fragment,T),g(x.$$.fragment,T),pT=!1},d(T){T&&(J(z),J(q),J(W),J(X),J(a),J(H),J(n),J(K),J(P),J(TT),J(UT),J(JT),J(p),J(lT),J(MT),J(yT),J(wT),J(S),J(IT),J(AT),J(D),J(CT),J(gT),J(iT),J(f),J(kT),J(jT),J(OT),J(tT),J(b),J(eT),J(B),J(sT),J(aT),J(E),J(nT),J(L),J(NT),J(RT),J(FT),J(VT),J(v)),J(e),i(s,T),i(N,T),i(R,T),i(F,T),i(V,T),i(o,T),i(m,T),i(r,T),i(Q,T),i(u,T),i(c,T),i(d,T),i(h,T),i($,T),i(Y,T),i(Z,T),i(_,T),i(x,T)}}}const vT='{"title":"Transforming your dataset","local":"transforming-your-dataset","sections":[{"title":"Reading","local":"reading","sections":[],"depth":2},{"title":"Selecting columns","local":"selecting-columns","sections":[],"depth":2},{"title":"Filtering","local":"filtering","sections":[],"depth":2},{"title":"Transforming","local":"transforming","sections":[],"depth":2},{"title":"Aggregation & Sorting","local":"aggregation--sorting","sections":[],"depth":2}],"depth":1}';function zT(oT){return ET(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class PT extends LT{constructor(e){super(),ZT(this,e,zT,qT,BT,{})}}export{PT as component};
