import{s as ht,n as yt,o as bt}from"../chunks/scheduler.6062bdaf.js";import{S as Tt,i as gt,g as i,s as a,r as m,A as Ut,h as o,f as l,c as s,j as ut,u as p,x as r,k as ft,y as Jt,a as n,v as c,d as M,t as d,w as u}from"../chunks/index.4bca734e.js";import{C as y}from"../chunks/CodeBlock.fa01571c.js";import{H as f}from"../chunks/Heading.723dceba.js";function wt(qe){let h,se,ne,ie,b,oe,T,Ae="This quick tour is intended for developers who are ready to dive into the code and see examples of how to integrate 🤗 Optimum into their model training and inference workflows.",re,g,me,U,pe,J,Le=`To load a model and run inference with OpenVINO Runtime, you can just replace your <code>AutoModelForXxx</code> class with the corresponding <code>OVModelForXxx</code> class.
If you want to load a PyTorch checkpoint, set <code>export=True</code> to convert your model to the OpenVINO IR (Intermediate Representation).`,ce,w,Me,j,Oe='You can find more examples in the <a href="https://huggingface.co/docs/optimum/intel/inference" rel="nofollow">documentation</a> and in the <a href="https://github.com/huggingface/optimum-intel/tree/main/examples/openvino" rel="nofollow">examples</a>.',de,Z,ue,W,Pe="To accelerate inference with ONNX Runtime, 🤗 Optimum uses <em>configuration objects</em> to define parameters for graph optimization and quantization. These objects are then used to instantiate dedicated <em>optimizers</em> and <em>quantizers</em>.",fe,C,De='Before applying quantization or optimization, first we need to load our model. To load a model and run inference with ONNX Runtime, you can just replace the canonical Transformers <a href="https://huggingface.co/docs/transformers/model_doc/auto#transformers.AutoModel" rel="nofollow"><code>AutoModelForXxx</code></a> class with the corresponding <a href="https://huggingface.co/docs/optimum/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel" rel="nofollow"><code>ORTModelForXxx</code></a> class. If you want to load from a PyTorch checkpoint, set <code>export=True</code> to export your model to the ONNX format.',he,B,ye,X,Ke="Let’s see now how we can apply dynamic quantization with ONNX Runtime:",be,R,Te,I,et="In this example, we’ve quantized a model from the Hugging Face Hub, in the same manner we can quantize a model hosted locally by providing the path to the directory containing the model weights. The result from applying the <code>quantize()</code> method is a <code>model_quantized.onnx</code> file that can be used to run inference. Here’s an example of how to load an ONNX Runtime model and generate predictions with it:",ge,v,Ue,x,tt='You can find more examples in the <a href="https://huggingface.co/docs/optimum/onnxruntime/quickstart" rel="nofollow">documentation</a> and in the <a href="https://github.com/huggingface/optimum/tree/main/examples/onnxruntime" rel="nofollow">examples</a>.',Je,$,we,k,je,V,lt='To train transformers on Habana’s Gaudi processors, 🤗 Optimum provides a <code>GaudiTrainer</code> that is very similar to the 🤗 Transformers <a href="https://huggingface.co/docs/transformers/main_classes/trainer" rel="nofollow">Trainer</a>. Here is a simple example:',Ze,G,We,H,nt='You can find more examples in the <a href="https://huggingface.co/docs/optimum/habana/quickstart" rel="nofollow">documentation</a> and in the <a href="https://github.com/huggingface/optimum-habana/tree/main/examples" rel="nofollow">examples</a>.',Ce,N,Be,Q,at='To train transformers with ONNX Runtime’s acceleration features, 🤗 Optimum provides a <code>ORTTrainer</code> that is very similar to the 🤗 Transformers <a href="https://huggingface.co/docs/transformers/main_classes/trainer" rel="nofollow">Trainer</a>. Here is a simple example:',Xe,F,Re,_,st='You can find more examples in the <a href="https://huggingface.co/docs/optimum/onnxruntime/usage_guides/trainer" rel="nofollow">documentation</a> and in the <a href="https://github.com/huggingface/optimum/tree/main/examples/onnxruntime/training" rel="nofollow">examples</a>.',Ie,z,ve,Y,it="The Optimum library handles out of the box the ONNX export of Transformers and Diffusers models!",xe,E,ot="Exporting a model to ONNX is as simple as",$e,S,ke,q,rt="Check out the help for more options:",Ve,A,Ge,L,mt='Check out the <a href="https://huggingface.co/docs/optimum/exporters/onnx/usage_guides/export_a_model" rel="nofollow">documentation</a> for more.',He,O,Ne,P,pt='<a href="https://pytorch.org/blog/a-better-transformer-for-fast-transformer-encoder-inference/" rel="nofollow">BetterTransformer</a> is a free-lunch PyTorch-native optimization to gain x1.25 - x4 speedup on the inference of Transformer-based models. It has been marked as stable in <a href="https://pytorch.org/blog/PyTorch-1.13-release/" rel="nofollow">PyTorch 1.13</a>. We integrated BetterTransformer with the most-used models from the 🤗 Transformers libary, and using the integration is as simple as:',Qe,D,Fe,K,ct='Check out the <a href="https://huggingface.co/docs/optimum/bettertransformer/overview" rel="nofollow">documentation</a> for more details, and the <a href="https://medium.com/pytorch/bettertransformer-out-of-the-box-performance-for-huggingface-transformers-3fbe27d50ab2" rel="nofollow">blog post on PyTorch’s Medium</a> to find out more about the integration!',_e,ee,ze,te,Mt='Optimum integrates with <code>torch.fx</code>, providing as a one-liner several graph transformations. We aim at supporting a better management of <a href="https://huggingface.co/docs/optimum/concept_guides/quantization" rel="nofollow">quantization</a> through <code>torch.fx</code>, both for quantization-aware training (QAT) and post-training quantization (PTQ).',Ye,le,dt='Check out the <a href="https://huggingface.co/docs/optimum/torch_fx/usage_guides/optimization" rel="nofollow">documentation</a> and <a href="https://huggingface.co/docs/optimum/torch_fx/package_reference/optimization" rel="nofollow">reference</a> for more!',Ee,ae,Se;return b=new f({props:{title:"Quick tour",local:"quick-tour",headingTag:"h1"}}),g=new f({props:{title:"Accelerated inference",local:"accelerated-inference",headingTag:"h2"}}),U=new f({props:{title:"OpenVINO",local:"openvino",headingTag:"h4"}}),w=new y({props:{code:"LSUyMGZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTJCJTIwZnJvbSUyMG9wdGltdW0uaW50ZWwub3BlbnZpbm8lMjBpbXBvcnQlMjBPVk1vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUwQSUyMCUyMGZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvVG9rZW5pemVyJTJDJTIwcGlwZWxpbmUlMEElMEElMjAlMjAlMjMlMjBEb3dubG9hZCUyMGElMjB0b2tlbml6ZXIlMjBhbmQlMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBIdWIlMjBhbmQlMjBjb252ZXJ0JTIwdG8lMjBPcGVuVklOTyUyMGZvcm1hdCUwQSUyMCUyMHRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQSUyMCUyMG1vZGVsX2lkJTIwJTNEJTIwJTIyZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNzdC0yLWVuZ2xpc2glMjIlMEEtJTIwbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEElMkIlMjBtb2RlbCUyMCUzRCUyME9WTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMGV4cG9ydCUzRFRydWUpJTBBJTBBJTIwJTIwJTIzJTIwUnVuJTIwaW5mZXJlbmNlISUwQSUyMCUyMGNsYXNzaWZpZXIlMjAlM0QlMjBwaXBlbGluZSglMjJ0ZXh0LWNsYXNzaWZpY2F0aW9uJTIyJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMHRva2VuaXplciUzRHRva2VuaXplciklMEElMjAlMjByZXN1bHRzJTIwJTNEJTIwY2xhc3NpZmllciglMjJIZSdzJTIwYSUyMGRyZWFkZnVsJTIwbWFnaWNpYW4uJTIyKQ==",highlighted:`<span class="hljs-deletion">- from transformers import AutoModelForSequenceClassification</span>
<span class="hljs-addition">+ from optimum.intel.openvino import OVModelForSequenceClassification</span>
  from transformers import AutoTokenizer, pipeline

  # Download a tokenizer and model from the Hub and convert to OpenVINO format
  tokenizer = AutoTokenizer.from_pretrained(model_id)
  model_id = &quot;distilbert-base-uncased-finetuned-sst-2-english&quot;
<span class="hljs-deletion">- model = AutoModelForSequenceClassification.from_pretrained(model_id)</span>
<span class="hljs-addition">+ model = OVModelForSequenceClassification.from_pretrained(model_id, export=True)</span>

  # Run inference!
  classifier = pipeline(&quot;text-classification&quot;, model=model, tokenizer=tokenizer)
  results = classifier(&quot;He&#x27;s a dreadful magician.&quot;)`,wrap:!1}}),Z=new f({props:{title:"ONNX Runtime",local:"onnx-runtime",headingTag:"h4"}}),B=new y({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUwQSUwQW1vZGVsX2NoZWNrcG9pbnQlMjAlM0QlMjAlMjJkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1maW5ldHVuZWQtc3N0LTItZW5nbGlzaCUyMiUwQXNhdmVfZGlyZWN0b3J5JTIwJTNEJTIwJTIydG1wJTJGb25ueCUyRiUyMiUwQSUwQSUyMyUyMExvYWQlMjBhJTIwbW9kZWwlMjBmcm9tJTIwdHJhbnNmb3JtZXJzJTIwYW5kJTIwZXhwb3J0JTIwaXQlMjB0byUyME9OTlglMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9jaGVja3BvaW50KSUwQW9ydF9tb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQobW9kZWxfY2hlY2twb2ludCUyQyUyMGV4cG9ydCUzRFRydWUpJTBBJTBBJTIzJTIwU2F2ZSUyMHRoZSUyME9OTlglMjBtb2RlbCUyMGFuZCUyMHRva2VuaXplciUwQW9ydF9tb2RlbC5zYXZlX3ByZXRyYWluZWQoc2F2ZV9kaXJlY3RvcnkpJTBBdG9rZW5pemVyLnNhdmVfcHJldHJhaW5lZChzYXZlX2RpcmVjdG9yeSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>model_checkpoint = <span class="hljs-string">&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>save_directory = <span class="hljs-string">&quot;tmp/onnx/&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load a model from transformers and export it to ONNX</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(model_checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>ort_model = ORTModelForSequenceClassification.from_pretrained(model_checkpoint, export=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Save the ONNX model and tokenizer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>ort_model.save_pretrained(save_directory)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.save_pretrained(save_directory)`,wrap:!1}}),R=new y({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUuY29uZmlndXJhdGlvbiUyMGltcG9ydCUyMEF1dG9RdWFudGl6YXRpb25Db25maWclMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVFF1YW50aXplciUwQSUwQSUyMyUyMERlZmluZSUyMHRoZSUyMHF1YW50aXphdGlvbiUyMG1ldGhvZG9sb2d5JTBBcWNvbmZpZyUyMCUzRCUyMEF1dG9RdWFudGl6YXRpb25Db25maWcuYXJtNjQoaXNfc3RhdGljJTNERmFsc2UlMkMlMjBwZXJfY2hhbm5lbCUzREZhbHNlKSUwQXF1YW50aXplciUyMCUzRCUyME9SVFF1YW50aXplci5mcm9tX3ByZXRyYWluZWQob3J0X21vZGVsKSUwQSUwQSUyMyUyMEFwcGx5JTIwZHluYW1pYyUyMHF1YW50aXphdGlvbiUyMG9uJTIwdGhlJTIwbW9kZWwlMEFxdWFudGl6ZXIucXVhbnRpemUoc2F2ZV9kaXIlM0RzYXZlX2RpcmVjdG9yeSUyQyUyMHF1YW50aXphdGlvbl9jb25maWclM0RxY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime.configuration <span class="hljs-keyword">import</span> AutoQuantizationConfig
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTQuantizer

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Define the quantization methodology</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>qconfig = AutoQuantizationConfig.arm64(is_static=<span class="hljs-literal">False</span>, per_channel=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>quantizer = ORTQuantizer.from_pretrained(ort_model)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Apply dynamic quantization on the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>quantizer.quantize(save_dir=save_directory, quantization_config=qconfig)`,wrap:!1}}),v=new y({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwcGlwZWxpbmUlMkMlMjBBdXRvVG9rZW5pemVyJTBBJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKHNhdmVfZGlyZWN0b3J5JTJDJTIwZmlsZV9uYW1lJTNEJTIybW9kZWxfcXVhbnRpemVkLm9ubnglMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoc2F2ZV9kaXJlY3RvcnkpJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUyMnRleHQtY2xhc3NpZmljYXRpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQXJlc3VsdHMlMjAlM0QlMjBjbGFzc2lmaWVyKCUyMkklMjBsb3ZlJTIwYnVycml0b3MhJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSequenceClassification.from_pretrained(save_directory, file_name=<span class="hljs-string">&quot;model_quantized.onnx&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(save_directory)
<span class="hljs-meta">&gt;&gt;&gt; </span>classifier = pipeline(<span class="hljs-string">&quot;text-classification&quot;</span>, model=model, tokenizer=tokenizer)
<span class="hljs-meta">&gt;&gt;&gt; </span>results = classifier(<span class="hljs-string">&quot;I love burritos!&quot;</span>)`,wrap:!1}}),$=new f({props:{title:"Accelerated training",local:"accelerated-training",headingTag:"h2"}}),k=new f({props:{title:"Habana",local:"habana",headingTag:"h4"}}),G=new y({props:{code:"LSUyMGZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBUcmFpbmVyJTJDJTIwVHJhaW5pbmdBcmd1bWVudHMlMEElMkIlMjBmcm9tJTIwb3B0aW11bS5oYWJhbmElMjBpbXBvcnQlMjBHYXVkaVRyYWluZXIlMkMlMjBHYXVkaVRyYWluaW5nQXJndW1lbnRzJTBBJTBBJTIwJTIwJTIzJTIwRG93bmxvYWQlMjBhJTIwcHJldHJhaW5lZCUyMG1vZGVsJTIwZnJvbSUyMHRoZSUyMEh1YiUwQSUyMCUyMG1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yWHh4LmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtdW5jYXNlZCUyMiklMEElMEElMjAlMjAlMjMlMjBEZWZpbmUlMjB0aGUlMjB0cmFpbmluZyUyMGFyZ3VtZW50cyUwQS0lMjB0cmFpbmluZ19hcmdzJTIwJTNEJTIwVHJhaW5pbmdBcmd1bWVudHMoJTBBJTJCJTIwdHJhaW5pbmdfYXJncyUyMCUzRCUyMEdhdWRpVHJhaW5pbmdBcmd1bWVudHMoJTBBJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0X2RpciUzRCUyMnBhdGglMkZ0byUyRnNhdmUlMkZmb2xkZXIlMkYlMjIlMkMlMEElMkIlMjAlMjAlMjAlMjAlMjB1c2VfaGFiYW5hJTNEVHJ1ZSUyQyUwQSUyQiUyMCUyMCUyMCUyMCUyMHVzZV9sYXp5X21vZGUlM0RUcnVlJTJDJTBBJTJCJTIwJTIwJTIwJTIwJTIwZ2F1ZGlfY29uZmlnX25hbWUlM0QlMjJIYWJhbmElMkZiZXJ0LWJhc2UtdW5jYXNlZCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMC4uLiUwQSUyMCUyMCklMEElMEElMjAlMjAlMjMlMjBJbml0aWFsaXplJTIwdGhlJTIwdHJhaW5lciUwQS0lMjB0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMkIlMjB0cmFpbmVyJTIwJTNEJTIwR2F1ZGlUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBhcmdzJTNEdHJhaW5pbmdfYXJncyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0R0cmFpbl9kYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwLi4uJTBBJTIwJTIwKSUwQSUwQSUyMCUyMCUyMyUyMFVzZSUyMEhhYmFuYSUyMEdhdWRpJTIwcHJvY2Vzc29yJTIwZm9yJTIwdHJhaW5pbmchJTBBJTIwJTIwdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-deletion">- from transformers import Trainer, TrainingArguments</span>
<span class="hljs-addition">+ from optimum.habana import GaudiTrainer, GaudiTrainingArguments</span>

  # Download a pretrained model from the Hub
  model = AutoModelForXxx.from_pretrained(&quot;bert-base-uncased&quot;)

  # Define the training arguments
<span class="hljs-deletion">- training_args = TrainingArguments(</span>
<span class="hljs-addition">+ training_args = GaudiTrainingArguments(</span>
      output_dir=&quot;path/to/save/folder/&quot;,
<span class="hljs-addition">+     use_habana=True,</span>
<span class="hljs-addition">+     use_lazy_mode=True,</span>
<span class="hljs-addition">+     gaudi_config_name=&quot;Habana/bert-base-uncased&quot;,</span>
      ...
  )

  # Initialize the trainer
<span class="hljs-deletion">- trainer = Trainer(</span>
<span class="hljs-addition">+ trainer = GaudiTrainer(</span>
      model=model,
      args=training_args,
      train_dataset=train_dataset,
      ...
  )

  # Use Habana Gaudi processor for training!
  trainer.train()`,wrap:!1}}),N=new f({props:{title:"ONNX Runtime",local:"onnx-runtime",headingTag:"h4"}}),F=new y({props:{code:"LSUyMGZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBUcmFpbmVyJTJDJTIwVHJhaW5pbmdBcmd1bWVudHMlMEElMkIlMjBmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVFRyYWluZXIlMkMlMjBPUlRUcmFpbmluZ0FyZ3VtZW50cyUwQSUwQSUyMCUyMCUyMyUyMERvd25sb2FkJTIwYSUyMHByZXRyYWluZWQlMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBIdWIlMEElMjAlMjBtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS11bmNhc2VkJTIyKSUwQSUwQSUyMCUyMCUyMyUyMERlZmluZSUyMHRoZSUyMHRyYWluaW5nJTIwYXJndW1lbnRzJTBBLSUyMHRyYWluaW5nX2FyZ3MlMjAlM0QlMjBUcmFpbmluZ0FyZ3VtZW50cyglMEElMkIlMjB0cmFpbmluZ19hcmdzJTIwJTNEJTIwT1JUVHJhaW5pbmdBcmd1bWVudHMoJTBBJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0X2RpciUzRCUyMnBhdGglMkZ0byUyRnNhdmUlMkZmb2xkZXIlMkYlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBvcHRpbSUzRCUyMmFkYW13X29ydF9mdXNlZCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMC4uLiUwQSUyMCUyMCklMEElMEElMjAlMjAlMjMlMjBDcmVhdGUlMjBhJTIwT05OWCUyMFJ1bnRpbWUlMjBUcmFpbmVyJTBBLSUyMHRyYWluZXIlMjAlM0QlMjBUcmFpbmVyKCUwQSUyQiUyMHRyYWluZXIlMjAlM0QlMjBPUlRUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBhcmdzJTNEdHJhaW5pbmdfYXJncyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0R0cmFpbl9kYXRhc2V0JTJDJTBBJTJCJTIwJTIwJTIwJTIwJTIwZmVhdHVyZSUzRCUyMnRleHQtY2xhc3NpZmljYXRpb24lMjIlMkMlMjAlMjMlMjBUaGUlMjBtb2RlbCUyMHR5cGUlMjB0byUyMGV4cG9ydCUyMHRvJTIwT05OWCUwQSUyMCUyMCUyMCUyMCUyMCUyMC4uLiUwQSUyMCUyMCklMEElMEElMjAlMjAlMjMlMjBVc2UlMjBPTk5YJTIwUnVudGltZSUyMGZvciUyMHRyYWluaW5nISUwQSUyMCUyMHRyYWluZXIudHJhaW4oKQ==",highlighted:`<span class="hljs-deletion">- from transformers import Trainer, TrainingArguments</span>
<span class="hljs-addition">+ from optimum.onnxruntime import ORTTrainer, ORTTrainingArguments</span>

  # Download a pretrained model from the Hub
  model = AutoModelForSequenceClassification.from_pretrained(&quot;bert-base-uncased&quot;)

  # Define the training arguments
<span class="hljs-deletion">- training_args = TrainingArguments(</span>
<span class="hljs-addition">+ training_args = ORTTrainingArguments(</span>
      output_dir=&quot;path/to/save/folder/&quot;,
      optim=&quot;adamw_ort_fused&quot;,
      ...
  )

  # Create a ONNX Runtime Trainer
<span class="hljs-deletion">- trainer = Trainer(</span>
<span class="hljs-addition">+ trainer = ORTTrainer(</span>
      model=model,
      args=training_args,
      train_dataset=train_dataset,
<span class="hljs-addition">+     feature=&quot;text-classification&quot;, # The model type to export to ONNX</span>
      ...
  )

  # Use ONNX Runtime for training!
  trainer.train()`,wrap:!1}}),z=new f({props:{title:"Out of the box ONNX export",local:"out-of-the-box-onnx-export",headingTag:"h2"}}),S=new y({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBvbm54JTIwLS1tb2RlbCUyMGdwdDIlMjBncHQyX29ubnglMkY=",highlighted:'optimum-cli <span class="hljs-built_in">export</span> onnx --model gpt2 gpt2_onnx/',wrap:!1}}),A=new y({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBvbm54JTIwLS1oZWxw",highlighted:'optimum-cli <span class="hljs-built_in">export</span> onnx --<span class="hljs-built_in">help</span>',wrap:!1}}),O=new f({props:{title:"PyTorch’s BetterTransformer support",local:"pytorchs-bettertransformer-support",headingTag:"h2"}}),D=new y({props:{code:"ZnJvbSUyMG9wdGltdW0uYmV0dGVydHJhbnNmb3JtZXIlMjBpbXBvcnQlMjBCZXR0ZXJUcmFuc2Zvcm1lciUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1maW5ldHVuZWQtc3N0LTItZW5nbGlzaCUyMiklMEFtb2RlbCUyMCUzRCUyMEJldHRlclRyYW5zZm9ybWVyLnRyYW5zZm9ybShtb2RlbCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.bettertransformer <span class="hljs-keyword">import</span> BetterTransformer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = BetterTransformer.transform(model)`,wrap:!1}}),ee=new f({props:{title:"torch.fx integration",local:"torchfx-integration",headingTag:"h2"}}),{c(){h=i("meta"),se=a(),ne=i("p"),ie=a(),m(b.$$.fragment),oe=a(),T=i("p"),T.textContent=Ae,re=a(),m(g.$$.fragment),me=a(),m(U.$$.fragment),pe=a(),J=i("p"),J.innerHTML=Le,ce=a(),m(w.$$.fragment),Me=a(),j=i("p"),j.innerHTML=Oe,de=a(),m(Z.$$.fragment),ue=a(),W=i("p"),W.innerHTML=Pe,fe=a(),C=i("p"),C.innerHTML=De,he=a(),m(B.$$.fragment),ye=a(),X=i("p"),X.textContent=Ke,be=a(),m(R.$$.fragment),Te=a(),I=i("p"),I.innerHTML=et,ge=a(),m(v.$$.fragment),Ue=a(),x=i("p"),x.innerHTML=tt,Je=a(),m($.$$.fragment),we=a(),m(k.$$.fragment),je=a(),V=i("p"),V.innerHTML=lt,Ze=a(),m(G.$$.fragment),We=a(),H=i("p"),H.innerHTML=nt,Ce=a(),m(N.$$.fragment),Be=a(),Q=i("p"),Q.innerHTML=at,Xe=a(),m(F.$$.fragment),Re=a(),_=i("p"),_.innerHTML=st,Ie=a(),m(z.$$.fragment),ve=a(),Y=i("p"),Y.textContent=it,xe=a(),E=i("p"),E.textContent=ot,$e=a(),m(S.$$.fragment),ke=a(),q=i("p"),q.textContent=rt,Ve=a(),m(A.$$.fragment),Ge=a(),L=i("p"),L.innerHTML=mt,He=a(),m(O.$$.fragment),Ne=a(),P=i("p"),P.innerHTML=pt,Qe=a(),m(D.$$.fragment),Fe=a(),K=i("p"),K.innerHTML=ct,_e=a(),m(ee.$$.fragment),ze=a(),te=i("p"),te.innerHTML=Mt,Ye=a(),le=i("p"),le.innerHTML=dt,Ee=a(),ae=i("p"),this.h()},l(e){const t=Ut("svelte-u9bgzb",document.head);h=o(t,"META",{name:!0,content:!0}),t.forEach(l),se=s(e),ne=o(e,"P",{}),ut(ne).forEach(l),ie=s(e),p(b.$$.fragment,e),oe=s(e),T=o(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-3d25f3"&&(T.textContent=Ae),re=s(e),p(g.$$.fragment,e),me=s(e),p(U.$$.fragment,e),pe=s(e),J=o(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-6jviwr"&&(J.innerHTML=Le),ce=s(e),p(w.$$.fragment,e),Me=s(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1tmum2f"&&(j.innerHTML=Oe),de=s(e),p(Z.$$.fragment,e),ue=s(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-bjfa3x"&&(W.innerHTML=Pe),fe=s(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-a1kook"&&(C.innerHTML=De),he=s(e),p(B.$$.fragment,e),ye=s(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-e7rpqh"&&(X.textContent=Ke),be=s(e),p(R.$$.fragment,e),Te=s(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-eh7tzg"&&(I.innerHTML=et),ge=s(e),p(v.$$.fragment,e),Ue=s(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-19cbrlu"&&(x.innerHTML=tt),Je=s(e),p($.$$.fragment,e),we=s(e),p(k.$$.fragment,e),je=s(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-8h57ng"&&(V.innerHTML=lt),Ze=s(e),p(G.$$.fragment,e),We=s(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-nvdwz8"&&(H.innerHTML=nt),Ce=s(e),p(N.$$.fragment,e),Be=s(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1q2r63q"&&(Q.innerHTML=at),Xe=s(e),p(F.$$.fragment,e),Re=s(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-sgbmo9"&&(_.innerHTML=st),Ie=s(e),p(z.$$.fragment,e),ve=s(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1qcigt9"&&(Y.textContent=it),xe=s(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1oa09xy"&&(E.textContent=ot),$e=s(e),p(S.$$.fragment,e),ke=s(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-b35baa"&&(q.textContent=rt),Ve=s(e),p(A.$$.fragment,e),Ge=s(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-q4y2mt"&&(L.innerHTML=mt),He=s(e),p(O.$$.fragment,e),Ne=s(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1arwil2"&&(P.innerHTML=pt),Qe=s(e),p(D.$$.fragment,e),Fe=s(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1ufsnqk"&&(K.innerHTML=ct),_e=s(e),p(ee.$$.fragment,e),ze=s(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1psut32"&&(te.innerHTML=Mt),Ye=s(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-p7b5of"&&(le.innerHTML=dt),Ee=s(e),ae=o(e,"P",{}),ut(ae).forEach(l),this.h()},h(){ft(h,"name","hf:doc:metadata"),ft(h,"content",jt)},m(e,t){Jt(document.head,h),n(e,se,t),n(e,ne,t),n(e,ie,t),c(b,e,t),n(e,oe,t),n(e,T,t),n(e,re,t),c(g,e,t),n(e,me,t),c(U,e,t),n(e,pe,t),n(e,J,t),n(e,ce,t),c(w,e,t),n(e,Me,t),n(e,j,t),n(e,de,t),c(Z,e,t),n(e,ue,t),n(e,W,t),n(e,fe,t),n(e,C,t),n(e,he,t),c(B,e,t),n(e,ye,t),n(e,X,t),n(e,be,t),c(R,e,t),n(e,Te,t),n(e,I,t),n(e,ge,t),c(v,e,t),n(e,Ue,t),n(e,x,t),n(e,Je,t),c($,e,t),n(e,we,t),c(k,e,t),n(e,je,t),n(e,V,t),n(e,Ze,t),c(G,e,t),n(e,We,t),n(e,H,t),n(e,Ce,t),c(N,e,t),n(e,Be,t),n(e,Q,t),n(e,Xe,t),c(F,e,t),n(e,Re,t),n(e,_,t),n(e,Ie,t),c(z,e,t),n(e,ve,t),n(e,Y,t),n(e,xe,t),n(e,E,t),n(e,$e,t),c(S,e,t),n(e,ke,t),n(e,q,t),n(e,Ve,t),c(A,e,t),n(e,Ge,t),n(e,L,t),n(e,He,t),c(O,e,t),n(e,Ne,t),n(e,P,t),n(e,Qe,t),c(D,e,t),n(e,Fe,t),n(e,K,t),n(e,_e,t),c(ee,e,t),n(e,ze,t),n(e,te,t),n(e,Ye,t),n(e,le,t),n(e,Ee,t),n(e,ae,t),Se=!0},p:yt,i(e){Se||(M(b.$$.fragment,e),M(g.$$.fragment,e),M(U.$$.fragment,e),M(w.$$.fragment,e),M(Z.$$.fragment,e),M(B.$$.fragment,e),M(R.$$.fragment,e),M(v.$$.fragment,e),M($.$$.fragment,e),M(k.$$.fragment,e),M(G.$$.fragment,e),M(N.$$.fragment,e),M(F.$$.fragment,e),M(z.$$.fragment,e),M(S.$$.fragment,e),M(A.$$.fragment,e),M(O.$$.fragment,e),M(D.$$.fragment,e),M(ee.$$.fragment,e),Se=!0)},o(e){d(b.$$.fragment,e),d(g.$$.fragment,e),d(U.$$.fragment,e),d(w.$$.fragment,e),d(Z.$$.fragment,e),d(B.$$.fragment,e),d(R.$$.fragment,e),d(v.$$.fragment,e),d($.$$.fragment,e),d(k.$$.fragment,e),d(G.$$.fragment,e),d(N.$$.fragment,e),d(F.$$.fragment,e),d(z.$$.fragment,e),d(S.$$.fragment,e),d(A.$$.fragment,e),d(O.$$.fragment,e),d(D.$$.fragment,e),d(ee.$$.fragment,e),Se=!1},d(e){e&&(l(se),l(ne),l(ie),l(oe),l(T),l(re),l(me),l(pe),l(J),l(ce),l(Me),l(j),l(de),l(ue),l(W),l(fe),l(C),l(he),l(ye),l(X),l(be),l(Te),l(I),l(ge),l(Ue),l(x),l(Je),l(we),l(je),l(V),l(Ze),l(We),l(H),l(Ce),l(Be),l(Q),l(Xe),l(Re),l(_),l(Ie),l(ve),l(Y),l(xe),l(E),l($e),l(ke),l(q),l(Ve),l(Ge),l(L),l(He),l(Ne),l(P),l(Qe),l(Fe),l(K),l(_e),l(ze),l(te),l(Ye),l(le),l(Ee),l(ae)),l(h),u(b,e),u(g,e),u(U,e),u(w,e),u(Z,e),u(B,e),u(R,e),u(v,e),u($,e),u(k,e),u(G,e),u(N,e),u(F,e),u(z,e),u(S,e),u(A,e),u(O,e),u(D,e),u(ee,e)}}}const jt='{"title":"Quick tour","local":"quick-tour","sections":[{"title":"Accelerated inference","local":"accelerated-inference","sections":[{"title":"OpenVINO","local":"openvino","sections":[],"depth":4},{"title":"ONNX Runtime","local":"onnx-runtime","sections":[],"depth":4}],"depth":2},{"title":"Accelerated training","local":"accelerated-training","sections":[{"title":"Habana","local":"habana","sections":[],"depth":4},{"title":"ONNX Runtime","local":"onnx-runtime","sections":[],"depth":4}],"depth":2},{"title":"Out of the box ONNX export","local":"out-of-the-box-onnx-export","sections":[],"depth":2},{"title":"PyTorch’s BetterTransformer support","local":"pytorchs-bettertransformer-support","sections":[],"depth":2},{"title":"torch.fx integration","local":"torchfx-integration","sections":[],"depth":2}],"depth":1}';function Zt(qe){return bt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Rt extends Tt{constructor(h){super(),gt(this,h,Zt,wt,ht,{})}}export{Rt as component};
