import{s as Us,n as Is,o as Ns}from"../chunks/scheduler.85c25b89.js";import{S as xs,i as Zs,g as p,s as e,r as i,A as Bs,h as m,f as a,c as n,j as bs,u as o,x as g,k as fs,y as Ws,a as t,v as c,d as M,t as r,w as h}from"../chunks/index.c9837788.js";import{C as v}from"../chunks/CodeBlock.52fa569e.js";import{H as Y}from"../chunks/Heading.3097d2ed.js";function ks(Ms){let J,X,R,S,j,_,d,rs='<strong>Res2NeXt</strong> is an image model that employs a variation on <a href="https://paperswithcode.com/method/resnext" rel="nofollow">ResNeXt</a> bottleneck residual blocks. The motivation is to be able to represent features at multiple scales. This is achieved through a novel building block for CNNs that constructs hierarchical residual-like connections within one single residual block. This represents multi-scale features at a granular level and increases the range of receptive fields for each network layer.',H,y,A,T,hs="To load a pretrained model:",F,u,z,w,gs="To load and preprocess the image:",L,b,D,f,Js="To get the model predictions:",P,U,q,I,js="To get the top-5 predictions class names:",K,N,O,x,ds="Replace the model name with the variant you want to use, e.g. <code>res2next50</code>. You can find the IDs in the model summaries at the top of this page.",ss,Z,ys='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',ls,B,as,W,Ts="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",ts,k,es,$,us=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,ns,C,ps,E,ws='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',ms,G,is,Q,os,V,cs;return j=new Y({props:{title:"Res2NeXt",local:"res2next",headingTag:"h1"}}),y=new Y({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),u=new v({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3JlczJuZXh0NTAnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;res2next50&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),b=new v({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),U=new v({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),N=new v({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),B=new Y({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),k=new v({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgncmVzMm5leHQ1MCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;res2next50&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),C=new Y({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),G=new Y({props:{title:"Citation",local:"citation",headingTag:"h2"}}),Q=new v({props:{code:"JTQwYXJ0aWNsZSU3Qkdhb18yMDIxJTJDJTBBJTIwJTIwJTIwdGl0bGUlM0QlN0JSZXMyTmV0JTNBJTIwQSUyME5ldyUyME11bHRpLVNjYWxlJTIwQmFja2JvbmUlMjBBcmNoaXRlY3R1cmUlN0QlMkMlMEElMjAlMjAlMjB2b2x1bWUlM0QlN0I0MyU3RCUyQyUwQSUyMCUyMCUyMElTU04lM0QlN0IxOTM5LTM1MzklN0QlMkMlMEElMjAlMjAlMjB1cmwlM0QlN0JodHRwJTNBJTJGJTJGZHguZG9pLm9yZyUyRjEwLjExMDklMkZUUEFNSS4yMDE5LjI5Mzg3NTglN0QlMkMlMEElMjAlMjAlMjBET0klM0QlN0IxMC4xMTA5JTJGdHBhbWkuMjAxOS4yOTM4NzU4JTdEJTJDJTBBJTIwJTIwJTIwbnVtYmVyJTNEJTdCMiU3RCUyQyUwQSUyMCUyMCUyMGpvdXJuYWwlM0QlN0JJRUVFJTIwVHJhbnNhY3Rpb25zJTIwb24lMjBQYXR0ZXJuJTIwQW5hbHlzaXMlMjBhbmQlMjBNYWNoaW5lJTIwSW50ZWxsaWdlbmNlJTdEJTJDJTBBJTIwJTIwJTIwcHVibGlzaGVyJTNEJTdCSW5zdGl0dXRlJTIwb2YlMjBFbGVjdHJpY2FsJTIwYW5kJTIwRWxlY3Ryb25pY3MlMjBFbmdpbmVlcnMlMjAoSUVFRSklN0QlMkMlMEElMjAlMjAlMjBhdXRob3IlM0QlN0JHYW8lMkMlMjBTaGFuZy1IdWElMjBhbmQlMjBDaGVuZyUyQyUyME1pbmctTWluZyUyMGFuZCUyMFpoYW8lMkMlMjBLYWklMjBhbmQlMjBaaGFuZyUyQyUyMFhpbi1ZdSUyMGFuZCUyMFlhbmclMkMlMjBNaW5nLUhzdWFuJTIwYW5kJTIwVG9yciUyQyUyMFBoaWxpcCU3RCUyQyUwQSUyMCUyMCUyMHllYXIlM0QlN0IyMDIxJTdEJTJDJTBBJTIwJTIwJTIwbW9udGglM0QlN0JGZWIlN0QlMkMlMEElMjAlMjAlMjBwYWdlcyUzRCU3QjY1MiVFMiU4MCU5MzY2MiU3RCUwQSU3RA==",highlighted:`<span class="language-xml">@article</span><span class="hljs-template-variable">{Gao_2021,
   title={Res2Net: A New Multi-Scale Backbone Architecture}</span><span class="language-xml">,
   volume=</span><span class="hljs-template-variable">{43}</span><span class="language-xml">,
   ISSN=</span><span class="hljs-template-variable">{1939-3539}</span><span class="language-xml">,
   url=</span><span class="hljs-template-variable">{http://dx.doi.org/10.1109/TPAMI.2019.2938758}</span><span class="language-xml">,
   DOI=</span><span class="hljs-template-variable">{10.1109/tpami.2019.2938758}</span><span class="language-xml">,
   number=</span><span class="hljs-template-variable">{2}</span><span class="language-xml">,
   journal=</span><span class="hljs-template-variable">{IEEE Transactions on Pattern Analysis and Machine Intelligence}</span><span class="language-xml">,
   publisher=</span><span class="hljs-template-variable">{Institute of Electrical and Electronics Engineers (IEEE)}</span><span class="language-xml">,
   author=</span><span class="hljs-template-variable">{Gao, Shang-Hua and Cheng, Ming-Ming and Zhao, Kai and Zhang, Xin-Yu and Yang, Ming-Hsuan and Torr, Philip}</span><span class="language-xml">,
   year=</span><span class="hljs-template-variable">{2021}</span><span class="language-xml">,
   month=</span><span class="hljs-template-variable">{Feb}</span><span class="language-xml">,
   pages=</span><span class="hljs-template-variable">{652–662}</span><span class="language-xml">
}</span>`,wrap:!1}}),{c(){J=p("meta"),X=e(),R=p("p"),S=e(),i(j.$$.fragment),_=e(),d=p("p"),d.innerHTML=rs,H=e(),i(y.$$.fragment),A=e(),T=p("p"),T.textContent=hs,F=e(),i(u.$$.fragment),z=e(),w=p("p"),w.textContent=gs,L=e(),i(b.$$.fragment),D=e(),f=p("p"),f.textContent=Js,P=e(),i(U.$$.fragment),q=e(),I=p("p"),I.textContent=js,K=e(),i(N.$$.fragment),O=e(),x=p("p"),x.innerHTML=ds,ss=e(),Z=p("p"),Z.innerHTML=ys,ls=e(),i(B.$$.fragment),as=e(),W=p("p"),W.textContent=Ts,ts=e(),i(k.$$.fragment),es=e(),$=p("p"),$.innerHTML=us,ns=e(),i(C.$$.fragment),ps=e(),E=p("p"),E.innerHTML=ws,ms=e(),i(G.$$.fragment),is=e(),i(Q.$$.fragment),os=e(),V=p("p"),this.h()},l(s){const l=Bs("svelte-u9bgzb",document.head);J=m(l,"META",{name:!0,content:!0}),l.forEach(a),X=n(s),R=m(s,"P",{}),bs(R).forEach(a),S=n(s),o(j.$$.fragment,s),_=n(s),d=m(s,"P",{"data-svelte-h":!0}),g(d)!=="svelte-ayu0xr"&&(d.innerHTML=rs),H=n(s),o(y.$$.fragment,s),A=n(s),T=m(s,"P",{"data-svelte-h":!0}),g(T)!=="svelte-18ywhxh"&&(T.textContent=hs),F=n(s),o(u.$$.fragment,s),z=n(s),w=m(s,"P",{"data-svelte-h":!0}),g(w)!=="svelte-1c2ipa8"&&(w.textContent=gs),L=n(s),o(b.$$.fragment,s),D=n(s),f=m(s,"P",{"data-svelte-h":!0}),g(f)!=="svelte-1n9qsq1"&&(f.textContent=Js),P=n(s),o(U.$$.fragment,s),q=n(s),I=m(s,"P",{"data-svelte-h":!0}),g(I)!=="svelte-19cnvx1"&&(I.textContent=js),K=n(s),o(N.$$.fragment,s),O=n(s),x=m(s,"P",{"data-svelte-h":!0}),g(x)!=="svelte-199rhg"&&(x.innerHTML=ds),ss=n(s),Z=m(s,"P",{"data-svelte-h":!0}),g(Z)!=="svelte-1wmi3ea"&&(Z.innerHTML=ys),ls=n(s),o(B.$$.fragment,s),as=n(s),W=m(s,"P",{"data-svelte-h":!0}),g(W)!=="svelte-9sr7nh"&&(W.textContent=Ts),ts=n(s),o(k.$$.fragment,s),es=n(s),$=m(s,"P",{"data-svelte-h":!0}),g($)!=="svelte-1kguc51"&&($.innerHTML=us),ns=n(s),o(C.$$.fragment,s),ps=n(s),E=m(s,"P",{"data-svelte-h":!0}),g(E)!=="svelte-1n0coha"&&(E.innerHTML=ws),ms=n(s),o(G.$$.fragment,s),is=n(s),o(Q.$$.fragment,s),os=n(s),V=m(s,"P",{}),bs(V).forEach(a),this.h()},h(){fs(J,"name","hf:doc:metadata"),fs(J,"content",$s)},m(s,l){Ws(document.head,J),t(s,X,l),t(s,R,l),t(s,S,l),c(j,s,l),t(s,_,l),t(s,d,l),t(s,H,l),c(y,s,l),t(s,A,l),t(s,T,l),t(s,F,l),c(u,s,l),t(s,z,l),t(s,w,l),t(s,L,l),c(b,s,l),t(s,D,l),t(s,f,l),t(s,P,l),c(U,s,l),t(s,q,l),t(s,I,l),t(s,K,l),c(N,s,l),t(s,O,l),t(s,x,l),t(s,ss,l),t(s,Z,l),t(s,ls,l),c(B,s,l),t(s,as,l),t(s,W,l),t(s,ts,l),c(k,s,l),t(s,es,l),t(s,$,l),t(s,ns,l),c(C,s,l),t(s,ps,l),t(s,E,l),t(s,ms,l),c(G,s,l),t(s,is,l),c(Q,s,l),t(s,os,l),t(s,V,l),cs=!0},p:Is,i(s){cs||(M(j.$$.fragment,s),M(y.$$.fragment,s),M(u.$$.fragment,s),M(b.$$.fragment,s),M(U.$$.fragment,s),M(N.$$.fragment,s),M(B.$$.fragment,s),M(k.$$.fragment,s),M(C.$$.fragment,s),M(G.$$.fragment,s),M(Q.$$.fragment,s),cs=!0)},o(s){r(j.$$.fragment,s),r(y.$$.fragment,s),r(u.$$.fragment,s),r(b.$$.fragment,s),r(U.$$.fragment,s),r(N.$$.fragment,s),r(B.$$.fragment,s),r(k.$$.fragment,s),r(C.$$.fragment,s),r(G.$$.fragment,s),r(Q.$$.fragment,s),cs=!1},d(s){s&&(a(X),a(R),a(S),a(_),a(d),a(H),a(A),a(T),a(F),a(z),a(w),a(L),a(D),a(f),a(P),a(q),a(I),a(K),a(O),a(x),a(ss),a(Z),a(ls),a(as),a(W),a(ts),a(es),a($),a(ns),a(ps),a(E),a(ms),a(is),a(os),a(V)),a(J),h(j,s),h(y,s),h(u,s),h(b,s),h(U,s),h(N,s),h(B,s),h(k,s),h(C,s),h(G,s),h(Q,s)}}}const $s='{"title":"Res2NeXt","local":"res2next","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Cs(Ms){return Ns(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Rs extends xs{constructor(J){super(),Zs(this,J,Cs,ks,Us,{})}}export{Rs as component};
