import{s as Ys,f as Qs,n as Fs,o as Ls}from"../chunks/scheduler.389d799c.js";import{S as qs,i as Ds,g as i,s as a,r as p,A as Ps,h as r,f as s,c as n,j as es,u as J,x as o,k as u,y as Ks,a as l,v as M,d as T,t as c,w as y}from"../chunks/index.8f81d18f.js";import{C as w}from"../chunks/CodeBlock.3845caa1.js";import{H as d}from"../chunks/Heading.41733039.js";function Os(ts){let h,He,Ne,ze,U,Xe,m,ss,Ge,g,ls="This guide will show you how to train a 🤗 Transformers model with the <code>HuggingFace</code> SageMaker Python SDK. Learn how to:",$e,I,as='<li><a href="#installation-and-setup">Install and setup your training environment</a>.</li> <li><a href="#prepare-a-transformers-fine-tuning-script">Prepare a training script</a>.</li> <li><a href="#create-a-hugging-face-estimator">Create a Hugging Face Estimator</a>.</li> <li><a href="#execute-training">Run training with the <code>fit</code> method</a>.</li> <li><a href="#access-trained-model">Access your trained model</a>.</li> <li><a href="#distributed-training">Perform distributed training</a>.</li> <li><a href="#spot-instances">Create a spot instance</a>.</li> <li><a href="#git-repository">Load a training script from a GitHub repository</a>.</li> <li><a href="#sagemaker-metrics">Collect training metrics</a>.</li>',Se,j,Re,f,ns='Before you can train a 🤗 Transformers model with SageMaker, you need to sign up for an AWS account. If you don’t have an AWS account yet, learn more <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/gs-set-up.html" rel="nofollow">here</a>.',Ee,C,is="Once you have an AWS account, get started using one of the following:",Ve,b,rs='<li><a href="https://docs.aws.amazon.com/sagemaker/latest/dg/gs-studio-onboard.html" rel="nofollow">SageMaker Studio</a></li> <li><a href="https://docs.aws.amazon.com/sagemaker/latest/dg/gs-console.html" rel="nofollow">SageMaker notebook instance</a></li> <li>Local environment</li>',Ye,_,os='To start training locally, you need to setup an appropriate <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html" rel="nofollow">IAM role</a>.',Qe,x,ps="Upgrade to the latest <code>sagemaker</code> version:",Fe,Z,Le,B,Js="<strong>SageMaker environment</strong>",qe,v,Ms="Setup your SageMaker environment as shown below:",De,k,Pe,W,Ts="<em>Note: The execution role is only available when running a notebook within SageMaker. If you run <code>get_execution_role</code> in a notebook not on SageMaker, expect a <code>region</code> error.</em>",Ke,N,cs="<strong>Local environment</strong>",Oe,A,ys="Setup your local environment as shown below:",et,H,tt,z,st,X,ms='Our training script is very similar to a training script you might run outside of SageMaker. However, you can access useful properties about the training environment through various environment variables (see <a href="https://github.com/aws/sagemaker-training-toolkit/blob/master/ENVIRONMENT_VARIABLES.md" rel="nofollow">here</a> for a complete list), such as:',lt,G,ws="<li><p><code>SM_MODEL_DIR</code>: A string representing the path to which the training job writes the model artifacts. After training, artifacts in this directory are uploaded to S3 for model hosting. <code>SM_MODEL_DIR</code> is always set to <code>/opt/ml/model</code>.</p></li> <li><p><code>SM_NUM_GPUS</code>: An integer representing the number of GPUs available to the host.</p></li> <li><p><code>SM_CHANNEL_XXXX:</code> A string representing the path to the directory that contains the input data for the specified channel. For example, when you specify <code>train</code> and <code>test</code> in the Hugging Face Estimator <code>fit</code> method, the environment variables are set to <code>SM_CHANNEL_TRAIN</code> and <code>SM_CHANNEL_TEST</code>.</p></li>",at,$,ds='The <code>hyperparameters</code> defined in the <a href="#create-an-huggingface-estimator">Hugging Face Estimator</a> are passed as named arguments and processed by <code>ArgumentParser()</code>.',nt,S,it,R,hs="<em>Note that SageMaker doesn’t support argparse actions. For example, if you want to use a boolean hyperparameter, specify <code>type</code> as <code>bool</code> in your script and provide an explicit <code>True</code> or <code>False</code> value.</em>",rt,E,us='Look <a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/01_getting_started_pytorch/scripts/train.py" rel="nofollow">here</a> for a complete example of a 🤗 Transformers training script.',ot,V,pt,Y,Us=`If <code>output_dir</code> in the <code>TrainingArguments</code> is set to ‘/opt/ml/model’ the Trainer saves all training artifacts, including logs, checkpoints, and models. Amazon SageMaker archives the whole ‘/opt/ml/model’ directory as <code>model.tar.gz</code> and uploads it at the end of the training job to Amazon S3. Depending on your Hyperparameters and <code>TrainingArguments</code> this could lead to a large artifact (&gt; 5GB), which can slow down deployment for Amazon SageMaker Inference.
You can control how checkpoints, logs, and artifacts are saved by customization the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">TrainingArguments</a>. For example by providing <code>save_total_limit</code> as <code>TrainingArgument</code> you can control the limit of the total amount of checkpoints. Deletes the older checkpoints in <code>output_dir</code> if new ones are saved and the maximum limit is reached.`,Jt,Q,gs=`In addition to the options already mentioned above, there is another option to save the training artifacts during the training session. Amazon SageMaker supports <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-checkpoints.html" rel="nofollow">Checkpointing</a>, which allows you to continuously save your artifacts during training to Amazon S3 rather than at the end of your training. To enable <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-checkpoints.html" rel="nofollow">Checkpointing</a> you need to provide the <code>checkpoint_s3_uri</code> parameter pointing to an Amazon S3 location in the <code>HuggingFace</code> estimator and set <code>output_dir</code> to <code>/opt/ml/checkpoints</code>.
<em>Note: If you set <code>output_dir</code> to <code>/opt/ml/checkpoints</code> make sure to call <code>trainer.save_model(&quot;/opt/ml/model&quot;)</code> or model.save_pretrained(“/opt/ml/model”)/<code>tokenizer.save_pretrained(&quot;/opt/ml/model&quot;)</code> at the end of your training to be able to deploy your model seamlessly to Amazon SageMaker for Inference.</em>`,Mt,F,Tt,L,Is='Run 🤗 Transformers training scripts on SageMaker by creating a <a href="https://sagemaker.readthedocs.io/en/stable/frameworks/huggingface/sagemaker.huggingface.html#huggingface-estimator" rel="nofollow">Hugging Face Estimator</a>. The Estimator handles end-to-end SageMaker training. There are several parameters you should define in the Estimator:',ct,q,js='<li><code>entry_point</code> specifies which fine-tuning script to use.</li> <li><code>instance_type</code> specifies an Amazon instance to launch. Refer <a href="https://aws.amazon.com/sagemaker/pricing/" rel="nofollow">here</a> for a complete list of instance types.</li> <li><code>hyperparameters</code> specifies training hyperparameters. View additional available hyperparameters <a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/01_getting_started_pytorch/scripts/train.py" rel="nofollow">here</a>.</li>',yt,D,fs="The following code sample shows how to train with a custom script <code>train.py</code> with three hyperparameters (<code>epochs</code>, <code>per_device_train_batch_size</code>, and <code>model_name_or_path</code>):",mt,P,wt,K,Cs="If you are running a <code>TrainingJob</code> locally, define <code>instance_type=&#39;local&#39;</code> or <code>instance_type=&#39;local_gpu&#39;</code> for GPU usage. Note that this will not work with SageMaker Studio.",dt,O,ht,ee,bs="Start your <code>TrainingJob</code> by calling <code>fit</code> on a Hugging Face Estimator. Specify your input training data in <code>fit</code>. The input training data can be a:",ut,te,_s='<li>S3 URI such as <code>s3://my-bucket/my-training-data</code>.</li> <li><code>FileSystemInput</code> for Amazon Elastic File System or FSx for Lustre. See <a href="https://sagemaker.readthedocs.io/en/stable/overview.html?highlight=FileSystemInput#use-file-systems-as-training-inputs" rel="nofollow">here</a> for more details about using these file systems as input.</li>',Ut,se,xs="Call <code>fit</code> to begin training:",gt,le,It,ae,Zs="SageMaker starts and manages all the required EC2 instances and initiates the <code>TrainingJob</code> by running:",jt,ne,ft,ie,Ct,re,Bs='Once training is complete, you can access your model through the <a href="https://console.aws.amazon.com/console/home?nc2=h_ct&amp;src=header-signin" rel="nofollow">AWS console</a> or download it directly from S3.',bt,oe,_t,pe,xt,Je,vs="SageMaker provides two strategies for distributed training: data parallelism and model parallelism. Data parallelism splits a training set across several GPUs, while model parallelism splits a model across several GPUs.",Zt,Me,Bt,Te,ks='The Hugging Face <a href="https://huggingface.co/docs/transformers/main_classes/trainer" rel="nofollow">Trainer</a> supports SageMaker’s data parallelism library. If your training script uses the Trainer API, you only need to define the distribution parameter in the Hugging Face Estimator:',vt,ce,kt,ye,Ws='📓 Open the <a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/07_tensorflow_distributed_training_data_parallelism/sagemaker-notebook.ipynb" rel="nofollow">notebook</a> for an example of how to run the data parallelism library with TensorFlow.',Wt,me,Nt,we,Ns='The Hugging Face [Trainer] also supports SageMaker’s model parallelism library. If your training script uses the Trainer API, you only need to define the distribution parameter in the Hugging Face Estimator (see <a href="https://sagemaker.readthedocs.io/en/stable/api/training/smd_model_parallel_general.html?highlight=modelparallel#required-sagemaker-python-sdk-parameters" rel="nofollow">here</a> for more detailed information about using model parallelism):',At,de,Ht,he,As='📓 Open the <a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/04_distributed_training_model_parallelism/sagemaker-notebook.ipynb" rel="nofollow">notebook</a> for an example of how to run the model parallelism library.',zt,ue,Xt,Ue,Hs='The Hugging Face extension for the SageMaker Python SDK means we can benefit from <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-managed-spot-training.html" rel="nofollow">fully-managed EC2 spot instances</a>. This can help you save up to 90% of training costs!',Gt,ge,zs='<em>Note: Unless your training job completes quickly, we recommend you use <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-checkpoints.html" rel="nofollow">checkpointing</a> with managed spot training. In this case, you need to define the <code>checkpoint_s3_uri</code>.</em>',$t,Ie,Xs="Set <code>use_spot_instances=True</code> and define your <code>max_wait</code> and <code>max_run</code> time in the Estimator to use spot instances:",St,je,Rt,fe,Gs='📓 Open the <a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/05_spot_instances/sagemaker-notebook.ipynb" rel="nofollow">notebook</a> for an example of how to use spot instances.',Et,Ce,Vt,be,$s='The Hugging Face Estimator can load a training script <a href="https://sagemaker.readthedocs.io/en/stable/overview.html#use-scripts-stored-in-a-git-repository" rel="nofollow">stored in a GitHub repository</a>. Provide the relative path to the training script in <code>entry_point</code> and the relative path to the directory in <code>source_dir</code>.',Yt,_e,Ss='If you are using <code>git_config</code> to run the <a href="https://github.com/huggingface/transformers/tree/main/examples" rel="nofollow">🤗 Transformers example scripts</a>, you need to configure the correct <code>&#39;branch&#39;</code> in <code>transformers_version</code> (e.g. if you use <code>transformers_version=&#39;4.4.2</code> you have to use <code>&#39;branch&#39;:&#39;v4.4.2&#39;</code>).',Qt,xe,Rs="<em>Tip: Save your model to S3 by setting <code>output_dir=/opt/ml/model</code> in the hyperparameter of your training script.</em>",Ft,Ze,Lt,Be,qt,ve,Es='<a href="https://docs.aws.amazon.com/sagemaker/latest/dg/training-metrics.html#define-train-metrics" rel="nofollow">SageMaker metrics</a> automatically parses training job logs for metrics and sends them to CloudWatch. If you want SageMaker to parse the logs, you must specify the metric’s name and a regular expression for SageMaker to use to find the metric.',Dt,ke,Pt,We,Vs='📓 Open the <a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/06_sagemaker_metrics/sagemaker-notebook.ipynb" rel="nofollow">notebook</a> for an example of how to capture metrics in SageMaker.',Kt,Ae,Ot;return U=new d({props:{title:"Run training on Amazon SageMaker",local:"run-training-on-amazon-sagemaker",headingTag:"h1"}}),j=new d({props:{title:"Installation and setup",local:"installation-and-setup",headingTag:"h2"}}),Z=new w({props:{code:"cGlwJTIwaW5zdGFsbCUyMHNhZ2VtYWtlciUyMC0tdXBncmFkZQ==",highlighted:"pip install sagemaker --upgrade",wrap:!1}}),k=new w({props:{code:"aW1wb3J0JTIwc2FnZW1ha2VyJTBBc2VzcyUyMCUzRCUyMHNhZ2VtYWtlci5TZXNzaW9uKCklMEFyb2xlJTIwJTNEJTIwc2FnZW1ha2VyLmdldF9leGVjdXRpb25fcm9sZSgp",highlighted:`<span class="hljs-keyword">import</span> sagemaker
sess = sagemaker.Session()
role = sagemaker.get_execution_role()`,wrap:!1}}),H=new w({props:{code:"aW1wb3J0JTIwc2FnZW1ha2VyJTBBaW1wb3J0JTIwYm90bzMlMEElMEFpYW1fY2xpZW50JTIwJTNEJTIwYm90bzMuY2xpZW50KCdpYW0nKSUwQXJvbGUlMjAlM0QlMjBpYW1fY2xpZW50LmdldF9yb2xlKFJvbGVOYW1lJTNEJ3JvbGUtbmFtZS1vZi15b3VyLWlhbS1yb2xlLXdpdGgtcmlnaHQtcGVybWlzc2lvbnMnKSU1QidSb2xlJyU1RCU1QidBcm4nJTVEJTBBc2VzcyUyMCUzRCUyMHNhZ2VtYWtlci5TZXNzaW9uKCk=",highlighted:`<span class="hljs-keyword">import</span> sagemaker
<span class="hljs-keyword">import</span> boto3

iam_client = boto3.client(<span class="hljs-string">&#x27;iam&#x27;</span>)
role = iam_client.get_role(RoleName=<span class="hljs-string">&#x27;role-name-of-your-iam-role-with-right-permissions&#x27;</span>)[<span class="hljs-string">&#x27;Role&#x27;</span>][<span class="hljs-string">&#x27;Arn&#x27;</span>]
sess = sagemaker.Session()`,wrap:!1}}),z=new d({props:{title:"Prepare a 🤗 Transformers fine-tuning script",local:"prepare-a--transformers-fine-tuning-script",headingTag:"h2"}}),S=new w({props:{code:"aW1wb3J0JTIwdHJhbnNmb3JtZXJzJTBBaW1wb3J0JTIwZGF0YXNldHMlMEFpbXBvcnQlMjBhcmdwYXJzZSUwQWltcG9ydCUyMG9zJTBBJTBBaWYlMjBfX25hbWVfXyUyMCUzRCUzRCUyMCUyMl9fbWFpbl9fJTIyJTNBJTBBJTBBJTIwJTIwJTIwJTIwcGFyc2VyJTIwJTNEJTIwYXJncGFyc2UuQXJndW1lbnRQYXJzZXIoKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMGh5cGVycGFyYW1ldGVycyUyMHNlbnQlMjBieSUyMHRoZSUyMGNsaWVudCUyMGFyZSUyMHBhc3NlZCUyMGFzJTIwY29tbWFuZC1saW5lJTIwYXJndW1lbnRzJTIwdG8lMjB0aGUlMjBzY3JpcHQlMEElMjAlMjAlMjAlMjBwYXJzZXIuYWRkX2FyZ3VtZW50KCUyMi0tZXBvY2hzJTIyJTJDJTIwdHlwZSUzRGludCUyQyUyMGRlZmF1bHQlM0QzKSUwQSUyMCUyMCUyMCUyMHBhcnNlci5hZGRfYXJndW1lbnQoJTIyLS1wZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlMjIlMkMlMjB0eXBlJTNEaW50JTJDJTIwZGVmYXVsdCUzRDMyKSUwQSUyMCUyMCUyMCUyMHBhcnNlci5hZGRfYXJndW1lbnQoJTIyLS1tb2RlbF9uYW1lX29yX3BhdGglMjIlMkMlMjB0eXBlJTNEc3RyKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMGRhdGElMkMlMjBtb2RlbCUyQyUyMGFuZCUyMG91dHB1dCUyMGRpcmVjdG9yaWVzJTBBJTIwJTIwJTIwJTIwcGFyc2VyLmFkZF9hcmd1bWVudCglMjItLW1vZGVsLWRpciUyMiUyQyUyMHR5cGUlM0RzdHIlMkMlMjBkZWZhdWx0JTNEb3MuZW52aXJvbiU1QiUyMlNNX01PREVMX0RJUiUyMiU1RCklMEElMjAlMjAlMjAlMjBwYXJzZXIuYWRkX2FyZ3VtZW50KCUyMi0tdHJhaW5pbmdfZGlyJTIyJTJDJTIwdHlwZSUzRHN0ciUyQyUyMGRlZmF1bHQlM0Rvcy5lbnZpcm9uJTVCJTIyU01fQ0hBTk5FTF9UUkFJTiUyMiU1RCklMEElMjAlMjAlMjAlMjBwYXJzZXIuYWRkX2FyZ3VtZW50KCUyMi0tdGVzdF9kaXIlMjIlMkMlMjB0eXBlJTNEc3RyJTJDJTIwZGVmYXVsdCUzRG9zLmVudmlyb24lNUIlMjJTTV9DSEFOTkVMX1RFU1QlMjIlNUQp",highlighted:`<span class="hljs-keyword">import</span> transformers
<span class="hljs-keyword">import</span> datasets
<span class="hljs-keyword">import</span> argparse
<span class="hljs-keyword">import</span> os

<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:

    parser = argparse.ArgumentParser()

    <span class="hljs-comment"># hyperparameters sent by the client are passed as command-line arguments to the script</span>
    parser.add_argument(<span class="hljs-string">&quot;--epochs&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-built_in">int</span>, default=<span class="hljs-number">3</span>)
    parser.add_argument(<span class="hljs-string">&quot;--per_device_train_batch_size&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-built_in">int</span>, default=<span class="hljs-number">32</span>)
    parser.add_argument(<span class="hljs-string">&quot;--model_name_or_path&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-built_in">str</span>)

    <span class="hljs-comment"># data, model, and output directories</span>
    parser.add_argument(<span class="hljs-string">&quot;--model-dir&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-built_in">str</span>, default=os.environ[<span class="hljs-string">&quot;SM_MODEL_DIR&quot;</span>])
    parser.add_argument(<span class="hljs-string">&quot;--training_dir&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-built_in">str</span>, default=os.environ[<span class="hljs-string">&quot;SM_CHANNEL_TRAIN&quot;</span>])
    parser.add_argument(<span class="hljs-string">&quot;--test_dir&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-built_in">str</span>, default=os.environ[<span class="hljs-string">&quot;SM_CHANNEL_TEST&quot;</span>])`,wrap:!1}}),V=new d({props:{title:"Training Output Management",local:"training-output-management",headingTag:"h2"}}),F=new d({props:{title:"Create a Hugging Face Estimator",local:"create-a-hugging-face-estimator",headingTag:"h2"}}),P=new w({props:{code:"ZnJvbSUyMHNhZ2VtYWtlci5odWdnaW5nZmFjZSUyMGltcG9ydCUyMEh1Z2dpbmdGYWNlJTBBJTBBJTBBJTIzJTIwaHlwZXJwYXJhbWV0ZXJzJTIwd2hpY2glMjBhcmUlMjBwYXNzZWQlMjB0byUyMHRoZSUyMHRyYWluaW5nJTIwam9iJTBBaHlwZXJwYXJhbWV0ZXJzJTNEJTdCJ2Vwb2NocyclM0ElMjAxJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJ3Blcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSclM0ElMjAzMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCdtb2RlbF9uYW1lX29yX3BhdGgnJTNBJTIwJ2Rpc3RpbGJlcnQtYmFzZS11bmNhc2VkJyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUwQSUyMyUyMGNyZWF0ZSUyMHRoZSUyMEVzdGltYXRvciUwQWh1Z2dpbmdmYWNlX2VzdGltYXRvciUyMCUzRCUyMEh1Z2dpbmdGYWNlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVudHJ5X3BvaW50JTNEJ3RyYWluLnB5JyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNvdXJjZV9kaXIlM0QnLiUyRnNjcmlwdHMnJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW5zdGFuY2VfdHlwZSUzRCdtbC5wMy4yeGxhcmdlJyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGluc3RhbmNlX2NvdW50JTNEMSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJvbGUlM0Ryb2xlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdHJhbnNmb3JtZXJzX3ZlcnNpb24lM0QnNC4yNiclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBweXRvcmNoX3ZlcnNpb24lM0QnMS4xMyclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBweV92ZXJzaW9uJTNEJ3B5MzknJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaHlwZXJwYXJhbWV0ZXJzJTIwJTNEJTIwaHlwZXJwYXJhbWV0ZXJzJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> sagemaker.huggingface <span class="hljs-keyword">import</span> HuggingFace


<span class="hljs-comment"># hyperparameters which are passed to the training job</span>
hyperparameters={<span class="hljs-string">&#x27;epochs&#x27;</span>: <span class="hljs-number">1</span>,
                 <span class="hljs-string">&#x27;per_device_train_batch_size&#x27;</span>: <span class="hljs-number">32</span>,
                 <span class="hljs-string">&#x27;model_name_or_path&#x27;</span>: <span class="hljs-string">&#x27;distilbert-base-uncased&#x27;</span>
                 }

<span class="hljs-comment"># create the Estimator</span>
huggingface_estimator = HuggingFace(
        entry_point=<span class="hljs-string">&#x27;train.py&#x27;</span>,
        source_dir=<span class="hljs-string">&#x27;./scripts&#x27;</span>,
        instance_type=<span class="hljs-string">&#x27;ml.p3.2xlarge&#x27;</span>,
        instance_count=<span class="hljs-number">1</span>,
        role=role,
        transformers_version=<span class="hljs-string">&#x27;4.26&#x27;</span>,
        pytorch_version=<span class="hljs-string">&#x27;1.13&#x27;</span>,
        py_version=<span class="hljs-string">&#x27;py39&#x27;</span>,
        hyperparameters = hyperparameters
)`,wrap:!1}}),O=new d({props:{title:"Execute training",local:"execute-training",headingTag:"h2"}}),le=new w({props:{code:"aHVnZ2luZ2ZhY2VfZXN0aW1hdG9yLmZpdCglMEElMjAlMjAlN0IndHJhaW4nJTNBJTIwJ3MzJTNBJTJGJTJGc2FnZW1ha2VyLXVzLWVhc3QtMS01NTgxMDUxNDE3MjElMkZzYW1wbGVzJTJGZGF0YXNldHMlMkZpbWRiJTJGdHJhaW4nJTJDJTBBJTIwJTIwJTIwJ3Rlc3QnJTNBJTIwJ3MzJTNBJTJGJTJGc2FnZW1ha2VyLXVzLWVhc3QtMS01NTgxMDUxNDE3MjElMkZzYW1wbGVzJTJGZGF0YXNldHMlMkZpbWRiJTJGdGVzdCclN0QlMEEp",highlighted:`huggingface_estimator.fit(
  {<span class="hljs-string">&#x27;train&#x27;</span>: <span class="hljs-string">&#x27;s3://sagemaker-us-east-1-558105141721/samples/datasets/imdb/train&#x27;</span>,
   <span class="hljs-string">&#x27;test&#x27;</span>: <span class="hljs-string">&#x27;s3://sagemaker-us-east-1-558105141721/samples/datasets/imdb/test&#x27;</span>}
)`,wrap:!1}}),ne=new w({props:{code:"JTJGb3B0JTJGY29uZGElMkZiaW4lMkZweXRob24lMjB0cmFpbi5weSUyMC0tZXBvY2hzJTIwMSUyMC0tbW9kZWxfbmFtZV9vcl9wYXRoJTIwZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQlMjAtLXBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUyMDMy",highlighted:"/opt/conda/bin/python train.py --epochs 1 --model_name_or_path distilbert-base-uncased --per_device_train_batch_size 32",wrap:!1}}),ie=new d({props:{title:"Access trained model",local:"access-trained-model",headingTag:"h2"}}),oe=new w({props:{code:"ZnJvbSUyMHNhZ2VtYWtlci5zMyUyMGltcG9ydCUyMFMzRG93bmxvYWRlciUwQSUwQVMzRG93bmxvYWRlci5kb3dubG9hZCglMEElMjAlMjAlMjAlMjBzM191cmklM0RodWdnaW5nZmFjZV9lc3RpbWF0b3IubW9kZWxfZGF0YSUyQyUyMCUyMyUyMFMzJTIwVVJJJTIwd2hlcmUlMjB0aGUlMjB0cmFpbmVkJTIwbW9kZWwlMjBpcyUyMGxvY2F0ZWQlMEElMjAlMjAlMjAlMjBsb2NhbF9wYXRoJTNEJy4nJTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwbG9jYWwlMjBwYXRoJTIwd2hlcmUlMjAqLnRhcmcuZ3olMjBpcyUyMHNhdmVkJTBBJTIwJTIwJTIwJTIwc2FnZW1ha2VyX3Nlc3Npb24lM0RzZXNzJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwU2FnZU1ha2VyJTIwc2Vzc2lvbiUyMHVzZWQlMjBmb3IlMjB0cmFpbmluZyUyMHRoZSUyMG1vZGVsJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> sagemaker.s3 <span class="hljs-keyword">import</span> S3Downloader

S3Downloader.download(
    s3_uri=huggingface_estimator.model_data, <span class="hljs-comment"># S3 URI where the trained model is located</span>
    local_path=<span class="hljs-string">&#x27;.&#x27;</span>,                          <span class="hljs-comment"># local path where *.targ.gz is saved</span>
    sagemaker_session=sess                   <span class="hljs-comment"># SageMaker session used for training the model</span>
)`,wrap:!1}}),pe=new d({props:{title:"Distributed training",local:"distributed-training",headingTag:"h2"}}),Me=new d({props:{title:"Data parallelism",local:"data-parallelism",headingTag:"h3"}}),ce=new w({props:{code:"JTIzJTIwY29uZmlndXJhdGlvbiUyMGZvciUyMHJ1bm5pbmclMjB0cmFpbmluZyUyMG9uJTIwc21kaXN0cmlidXRlZCUyMGRhdGElMjBwYXJhbGxlbCUwQWRpc3RyaWJ1dGlvbiUyMCUzRCUyMCU3QidzbWRpc3RyaWJ1dGVkJyUzQSU3QidkYXRhcGFyYWxsZWwnJTNBJTdCJTIwJ2VuYWJsZWQnJTNBJTIwVHJ1ZSUyMCU3RCU3RCU3RCUwQSUwQSUyMyUyMGNyZWF0ZSUyMHRoZSUyMEVzdGltYXRvciUwQWh1Z2dpbmdmYWNlX2VzdGltYXRvciUyMCUzRCUyMEh1Z2dpbmdGYWNlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVudHJ5X3BvaW50JTNEJ3RyYWluLnB5JyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNvdXJjZV9kaXIlM0QnLiUyRnNjcmlwdHMnJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW5zdGFuY2VfdHlwZSUzRCdtbC5wM2RuLjI0eGxhcmdlJyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGluc3RhbmNlX2NvdW50JTNEMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJvbGUlM0Ryb2xlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdHJhbnNmb3JtZXJzX3ZlcnNpb24lM0QnNC4yNi4wJyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHB5dG9yY2hfdmVyc2lvbiUzRCcxLjEzLjEnJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHlfdmVyc2lvbiUzRCdweTM5JyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGh5cGVycGFyYW1ldGVycyUyMCUzRCUyMGh5cGVycGFyYW1ldGVycyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRpc3RyaWJ1dGlvbiUyMCUzRCUyMGRpc3RyaWJ1dGlvbiUwQSk=",highlighted:`<span class="hljs-comment"># configuration for running training on smdistributed data parallel</span>
distribution = {<span class="hljs-string">&#x27;smdistributed&#x27;</span>:{<span class="hljs-string">&#x27;dataparallel&#x27;</span>:{ <span class="hljs-string">&#x27;enabled&#x27;</span>: <span class="hljs-literal">True</span> }}}

<span class="hljs-comment"># create the Estimator</span>
huggingface_estimator = HuggingFace(
        entry_point=<span class="hljs-string">&#x27;train.py&#x27;</span>,
        source_dir=<span class="hljs-string">&#x27;./scripts&#x27;</span>,
        instance_type=<span class="hljs-string">&#x27;ml.p3dn.24xlarge&#x27;</span>,
        instance_count=<span class="hljs-number">2</span>,
        role=role,
        transformers_version=<span class="hljs-string">&#x27;4.26.0&#x27;</span>,
        pytorch_version=<span class="hljs-string">&#x27;1.13.1&#x27;</span>,
        py_version=<span class="hljs-string">&#x27;py39&#x27;</span>,
        hyperparameters = hyperparameters,
        distribution = distribution
)`,wrap:!1}}),me=new d({props:{title:"Model parallelism",local:"model-parallelism",headingTag:"h3"}}),de=new w({props:{code:"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",highlighted:`<span class="hljs-comment"># configuration for running training on smdistributed model parallel</span>
mpi_options = {
    <span class="hljs-string">&quot;enabled&quot;</span> : <span class="hljs-literal">True</span>,
    <span class="hljs-string">&quot;processes_per_host&quot;</span> : <span class="hljs-number">8</span>
}

smp_options = {
    <span class="hljs-string">&quot;enabled&quot;</span>:<span class="hljs-literal">True</span>,
    <span class="hljs-string">&quot;parameters&quot;</span>: {
        <span class="hljs-string">&quot;microbatches&quot;</span>: <span class="hljs-number">4</span>,
        <span class="hljs-string">&quot;placement_strategy&quot;</span>: <span class="hljs-string">&quot;spread&quot;</span>,
        <span class="hljs-string">&quot;pipeline&quot;</span>: <span class="hljs-string">&quot;interleaved&quot;</span>,
        <span class="hljs-string">&quot;optimize&quot;</span>: <span class="hljs-string">&quot;speed&quot;</span>,
        <span class="hljs-string">&quot;partitions&quot;</span>: <span class="hljs-number">4</span>,
        <span class="hljs-string">&quot;ddp&quot;</span>: <span class="hljs-literal">True</span>,
    }
}

distribution={
    <span class="hljs-string">&quot;smdistributed&quot;</span>: {<span class="hljs-string">&quot;modelparallel&quot;</span>: smp_options},
    <span class="hljs-string">&quot;mpi&quot;</span>: mpi_options
}

 <span class="hljs-comment"># create the Estimator</span>
huggingface_estimator = HuggingFace(
        entry_point=<span class="hljs-string">&#x27;train.py&#x27;</span>,
        source_dir=<span class="hljs-string">&#x27;./scripts&#x27;</span>,
        instance_type=<span class="hljs-string">&#x27;ml.p3dn.24xlarge&#x27;</span>,
        instance_count=<span class="hljs-number">2</span>,
        role=role,
        transformers_version=<span class="hljs-string">&#x27;4.26.0&#x27;</span>,
        pytorch_version=<span class="hljs-string">&#x27;1.13.1&#x27;</span>,
        py_version=<span class="hljs-string">&#x27;py39&#x27;</span>,
        hyperparameters = hyperparameters,
        distribution = distribution
)`,wrap:!1}}),ue=new d({props:{title:"Spot instances",local:"spot-instances",headingTag:"h2"}}),je=new w({props:{code:"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",highlighted:`<span class="hljs-comment"># hyperparameters which are passed to the training job</span>
hyperparameters={<span class="hljs-string">&#x27;epochs&#x27;</span>: <span class="hljs-number">1</span>,
                 <span class="hljs-string">&#x27;train_batch_size&#x27;</span>: <span class="hljs-number">32</span>,
                 <span class="hljs-string">&#x27;model_name&#x27;</span>:<span class="hljs-string">&#x27;distilbert-base-uncased&#x27;</span>,
                 <span class="hljs-string">&#x27;output_dir&#x27;</span>:<span class="hljs-string">&#x27;/opt/ml/checkpoints&#x27;</span>
                 }

<span class="hljs-comment"># create the Estimator</span>
huggingface_estimator = HuggingFace(
        entry_point=<span class="hljs-string">&#x27;train.py&#x27;</span>,
        source_dir=<span class="hljs-string">&#x27;./scripts&#x27;</span>,
        instance_type=<span class="hljs-string">&#x27;ml.p3.2xlarge&#x27;</span>,
        instance_count=<span class="hljs-number">1</span>,
	    checkpoint_s3_uri=<span class="hljs-string">f&#x27;s3://<span class="hljs-subst">{sess.default_bucket()}</span>/checkpoints&#x27;</span>
        use_spot_instances=<span class="hljs-literal">True</span>,
        <span class="hljs-comment"># max_wait should be equal to or greater than max_run in seconds</span>
        max_wait=<span class="hljs-number">3600</span>,
        max_run=<span class="hljs-number">1000</span>,
        role=role,
        transformers_version=<span class="hljs-string">&#x27;4.26&#x27;</span>,
        pytorch_version=<span class="hljs-string">&#x27;1.13&#x27;</span>,
        py_version=<span class="hljs-string">&#x27;py39&#x27;</span>,
        hyperparameters = hyperparameters
)

<span class="hljs-comment"># Training seconds: 874</span>
<span class="hljs-comment"># Billable seconds: 262</span>
<span class="hljs-comment"># Managed Spot Training savings: 70.0%</span>`,wrap:!1}}),Ce=new d({props:{title:"Git repository",local:"git-repository",headingTag:"h2"}}),Ze=new w({props:{code:"JTIzJTIwY29uZmlndXJlJTIwZ2l0JTIwc2V0dGluZ3MlMEFnaXRfY29uZmlnJTIwJTNEJTIwJTdCJ3JlcG8nJTNBJTIwJ2h0dHBzJTNBJTJGJTJGZ2l0aHViLmNvbSUyRmh1Z2dpbmdmYWNlJTJGdHJhbnNmb3JtZXJzLmdpdCclMkMnYnJhbmNoJyUzQSUyMCd2NC40LjInJTdEJTIwJTIzJTIwdjQuNC4yJTIwcmVmZXJzJTIwdG8lMjB0aGUlMjB0cmFuc2Zvcm1lcnNfdmVyc2lvbiUyMHlvdSUyMHVzZSUyMGluJTIwdGhlJTIwZXN0aW1hdG9yJTBBJTBBJTIwJTIzJTIwY3JlYXRlJTIwdGhlJTIwRXN0aW1hdG9yJTBBaHVnZ2luZ2ZhY2VfZXN0aW1hdG9yJTIwJTNEJTIwSHVnZ2luZ0ZhY2UoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZW50cnlfcG9pbnQlM0QncnVuX2dsdWUucHknJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc291cmNlX2RpciUzRCcuJTJGZXhhbXBsZXMlMkZweXRvcmNoJTJGdGV4dC1jbGFzc2lmaWNhdGlvbiclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnaXRfY29uZmlnJTNEZ2l0X2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGluc3RhbmNlX3R5cGUlM0QnbWwucDMuMnhsYXJnZSclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnN0YW5jZV9jb3VudCUzRDElMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByb2xlJTNEcm9sZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRyYW5zZm9ybWVyc192ZXJzaW9uJTNEJzQuMjYnJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHl0b3JjaF92ZXJzaW9uJTNEJzEuMTMnJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHlfdmVyc2lvbiUzRCdweTM5JyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGh5cGVycGFyYW1ldGVycyUzRGh5cGVycGFyYW1ldGVycyUwQSk=",highlighted:`<span class="hljs-comment"># configure git settings</span>
git_config = {<span class="hljs-string">&#x27;repo&#x27;</span>: <span class="hljs-string">&#x27;https://github.com/huggingface/transformers.git&#x27;</span>,<span class="hljs-string">&#x27;branch&#x27;</span>: <span class="hljs-string">&#x27;v4.4.2&#x27;</span>} <span class="hljs-comment"># v4.4.2 refers to the transformers_version you use in the estimator</span>

 <span class="hljs-comment"># create the Estimator</span>
huggingface_estimator = HuggingFace(
        entry_point=<span class="hljs-string">&#x27;run_glue.py&#x27;</span>,
        source_dir=<span class="hljs-string">&#x27;./examples/pytorch/text-classification&#x27;</span>,
        git_config=git_config,
        instance_type=<span class="hljs-string">&#x27;ml.p3.2xlarge&#x27;</span>,
        instance_count=<span class="hljs-number">1</span>,
        role=role,
        transformers_version=<span class="hljs-string">&#x27;4.26&#x27;</span>,
        pytorch_version=<span class="hljs-string">&#x27;1.13&#x27;</span>,
        py_version=<span class="hljs-string">&#x27;py39&#x27;</span>,
        hyperparameters=hyperparameters
)`,wrap:!1}}),Be=new d({props:{title:"SageMaker metrics",local:"sagemaker-metrics",headingTag:"h2"}}),ke=new w({props:{code:"JTIzJTIwZGVmaW5lJTIwbWV0cmljcyUyMGRlZmluaXRpb25zJTBBbWV0cmljX2RlZmluaXRpb25zJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIyTmFtZSUyMiUzQSUyMCUyMnRyYWluX3J1bnRpbWUlMjIlMkMlMjAlMjJSZWdleCUyMiUzQSUyMCUyMnRyYWluX3J1bnRpbWUuKiUzRCU1Q0QqKC4qJTNGKSUyNCUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMk5hbWUlMjIlM0ElMjAlMjJldmFsX2FjY3VyYWN5JTIyJTJDJTIwJTIyUmVnZXglMjIlM0ElMjAlMjJldmFsX2FjY3VyYWN5LiolM0QlNUNEKiguKiUzRiklMjQlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJOYW1lJTIyJTNBJTIwJTIyZXZhbF9sb3NzJTIyJTJDJTIwJTIyUmVnZXglMjIlM0ElMjAlMjJldmFsX2xvc3MuKiUzRCU1Q0QqKC4qJTNGKSUyNCUyMiU3RCUyQyUwQSU1RCUwQSUwQSUyMyUyMGNyZWF0ZSUyMHRoZSUyMEVzdGltYXRvciUwQWh1Z2dpbmdmYWNlX2VzdGltYXRvciUyMCUzRCUyMEh1Z2dpbmdGYWNlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVudHJ5X3BvaW50JTNEJ3RyYWluLnB5JyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNvdXJjZV9kaXIlM0QnLiUyRnNjcmlwdHMnJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW5zdGFuY2VfdHlwZSUzRCdtbC5wMy4yeGxhcmdlJyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGluc3RhbmNlX2NvdW50JTNEMSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJvbGUlM0Ryb2xlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdHJhbnNmb3JtZXJzX3ZlcnNpb24lM0QnNC4yNiclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBweXRvcmNoX3ZlcnNpb24lM0QnMS4xMyclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBweV92ZXJzaW9uJTNEJ3B5MzknJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWV0cmljX2RlZmluaXRpb25zJTNEbWV0cmljX2RlZmluaXRpb25zJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaHlwZXJwYXJhbWV0ZXJzJTIwJTNEJTIwaHlwZXJwYXJhbWV0ZXJzKQ==",highlighted:`<span class="hljs-comment"># define metrics definitions</span>
metric_definitions = [
    {<span class="hljs-string">&quot;Name&quot;</span>: <span class="hljs-string">&quot;train_runtime&quot;</span>, <span class="hljs-string">&quot;Regex&quot;</span>: <span class="hljs-string">&quot;train_runtime.*=\\D*(.*?)$&quot;</span>},
    {<span class="hljs-string">&quot;Name&quot;</span>: <span class="hljs-string">&quot;eval_accuracy&quot;</span>, <span class="hljs-string">&quot;Regex&quot;</span>: <span class="hljs-string">&quot;eval_accuracy.*=\\D*(.*?)$&quot;</span>},
    {<span class="hljs-string">&quot;Name&quot;</span>: <span class="hljs-string">&quot;eval_loss&quot;</span>, <span class="hljs-string">&quot;Regex&quot;</span>: <span class="hljs-string">&quot;eval_loss.*=\\D*(.*?)$&quot;</span>},
]

<span class="hljs-comment"># create the Estimator</span>
huggingface_estimator = HuggingFace(
        entry_point=<span class="hljs-string">&#x27;train.py&#x27;</span>,
        source_dir=<span class="hljs-string">&#x27;./scripts&#x27;</span>,
        instance_type=<span class="hljs-string">&#x27;ml.p3.2xlarge&#x27;</span>,
        instance_count=<span class="hljs-number">1</span>,
        role=role,
        transformers_version=<span class="hljs-string">&#x27;4.26&#x27;</span>,
        pytorch_version=<span class="hljs-string">&#x27;1.13&#x27;</span>,
        py_version=<span class="hljs-string">&#x27;py39&#x27;</span>,
        metric_definitions=metric_definitions,
        hyperparameters = hyperparameters)`,wrap:!1}}),{c(){h=i("meta"),He=a(),Ne=i("p"),ze=a(),p(U.$$.fragment),Xe=a(),m=i("iframe"),Ge=a(),g=i("p"),g.innerHTML=ls,$e=a(),I=i("ul"),I.innerHTML=as,Se=a(),p(j.$$.fragment),Re=a(),f=i("p"),f.innerHTML=ns,Ee=a(),C=i("p"),C.textContent=is,Ve=a(),b=i("ul"),b.innerHTML=rs,Ye=a(),_=i("p"),_.innerHTML=os,Qe=a(),x=i("p"),x.innerHTML=ps,Fe=a(),p(Z.$$.fragment),Le=a(),B=i("p"),B.innerHTML=Js,qe=a(),v=i("p"),v.textContent=Ms,De=a(),p(k.$$.fragment),Pe=a(),W=i("p"),W.innerHTML=Ts,Ke=a(),N=i("p"),N.innerHTML=cs,Oe=a(),A=i("p"),A.textContent=ys,et=a(),p(H.$$.fragment),tt=a(),p(z.$$.fragment),st=a(),X=i("p"),X.innerHTML=ms,lt=a(),G=i("ul"),G.innerHTML=ws,at=a(),$=i("p"),$.innerHTML=ds,nt=a(),p(S.$$.fragment),it=a(),R=i("p"),R.innerHTML=hs,rt=a(),E=i("p"),E.innerHTML=us,ot=a(),p(V.$$.fragment),pt=a(),Y=i("p"),Y.innerHTML=Us,Jt=a(),Q=i("p"),Q.innerHTML=gs,Mt=a(),p(F.$$.fragment),Tt=a(),L=i("p"),L.innerHTML=Is,ct=a(),q=i("ol"),q.innerHTML=js,yt=a(),D=i("p"),D.innerHTML=fs,mt=a(),p(P.$$.fragment),wt=a(),K=i("p"),K.innerHTML=Cs,dt=a(),p(O.$$.fragment),ht=a(),ee=i("p"),ee.innerHTML=bs,ut=a(),te=i("ul"),te.innerHTML=_s,Ut=a(),se=i("p"),se.innerHTML=xs,gt=a(),p(le.$$.fragment),It=a(),ae=i("p"),ae.innerHTML=Zs,jt=a(),p(ne.$$.fragment),ft=a(),p(ie.$$.fragment),Ct=a(),re=i("p"),re.innerHTML=Bs,bt=a(),p(oe.$$.fragment),_t=a(),p(pe.$$.fragment),xt=a(),Je=i("p"),Je.textContent=vs,Zt=a(),p(Me.$$.fragment),Bt=a(),Te=i("p"),Te.innerHTML=ks,vt=a(),p(ce.$$.fragment),kt=a(),ye=i("p"),ye.innerHTML=Ws,Wt=a(),p(me.$$.fragment),Nt=a(),we=i("p"),we.innerHTML=Ns,At=a(),p(de.$$.fragment),Ht=a(),he=i("p"),he.innerHTML=As,zt=a(),p(ue.$$.fragment),Xt=a(),Ue=i("p"),Ue.innerHTML=Hs,Gt=a(),ge=i("p"),ge.innerHTML=zs,$t=a(),Ie=i("p"),Ie.innerHTML=Xs,St=a(),p(je.$$.fragment),Rt=a(),fe=i("p"),fe.innerHTML=Gs,Et=a(),p(Ce.$$.fragment),Vt=a(),be=i("p"),be.innerHTML=$s,Yt=a(),_e=i("p"),_e.innerHTML=Ss,Qt=a(),xe=i("p"),xe.innerHTML=Rs,Ft=a(),p(Ze.$$.fragment),Lt=a(),p(Be.$$.fragment),qt=a(),ve=i("p"),ve.innerHTML=Es,Dt=a(),p(ke.$$.fragment),Pt=a(),We=i("p"),We.innerHTML=Vs,Kt=a(),Ae=i("p"),this.h()},l(e){const t=Ps("svelte-u9bgzb",document.head);h=r(t,"META",{name:!0,content:!0}),t.forEach(s),He=n(e),Ne=r(e,"P",{}),es(Ne).forEach(s),ze=n(e),J(U.$$.fragment,e),Xe=n(e),m=r(e,"IFRAME",{width:!0,height:!0,src:!0,title:!0,frameborder:!0,allow:!0}),es(m).forEach(s),Ge=n(e),g=r(e,"P",{"data-svelte-h":!0}),o(g)!=="svelte-zhmf4d"&&(g.innerHTML=ls),$e=n(e),I=r(e,"UL",{"data-svelte-h":!0}),o(I)!=="svelte-d99lsl"&&(I.innerHTML=as),Se=n(e),J(j.$$.fragment,e),Re=n(e),f=r(e,"P",{"data-svelte-h":!0}),o(f)!=="svelte-9mb7jq"&&(f.innerHTML=ns),Ee=n(e),C=r(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-14pz1nf"&&(C.textContent=is),Ve=n(e),b=r(e,"UL",{"data-svelte-h":!0}),o(b)!=="svelte-nu9uzs"&&(b.innerHTML=rs),Ye=n(e),_=r(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-10vylvb"&&(_.innerHTML=os),Qe=n(e),x=r(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-1q1gn32"&&(x.innerHTML=ps),Fe=n(e),J(Z.$$.fragment,e),Le=n(e),B=r(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-aqpf90"&&(B.innerHTML=Js),qe=n(e),v=r(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-1n86nit"&&(v.textContent=Ms),De=n(e),J(k.$$.fragment,e),Pe=n(e),W=r(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-bmcgfj"&&(W.innerHTML=Ts),Ke=n(e),N=r(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-12o7543"&&(N.innerHTML=cs),Oe=n(e),A=r(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-qjt50s"&&(A.textContent=ys),et=n(e),J(H.$$.fragment,e),tt=n(e),J(z.$$.fragment,e),st=n(e),X=r(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-1u3xeug"&&(X.innerHTML=ms),lt=n(e),G=r(e,"UL",{"data-svelte-h":!0}),o(G)!=="svelte-1owy1vd"&&(G.innerHTML=ws),at=n(e),$=r(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-1djq75m"&&($.innerHTML=ds),nt=n(e),J(S.$$.fragment,e),it=n(e),R=r(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-x146s4"&&(R.innerHTML=hs),rt=n(e),E=r(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-1bopft3"&&(E.innerHTML=us),ot=n(e),J(V.$$.fragment,e),pt=n(e),Y=r(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1iromrn"&&(Y.innerHTML=Us),Jt=n(e),Q=r(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-17anpad"&&(Q.innerHTML=gs),Mt=n(e),J(F.$$.fragment,e),Tt=n(e),L=r(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-w7qkuf"&&(L.innerHTML=Is),ct=n(e),q=r(e,"OL",{"data-svelte-h":!0}),o(q)!=="svelte-w1lnk7"&&(q.innerHTML=js),yt=n(e),D=r(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-129am2x"&&(D.innerHTML=fs),mt=n(e),J(P.$$.fragment,e),wt=n(e),K=r(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-1dwzx5g"&&(K.innerHTML=Cs),dt=n(e),J(O.$$.fragment,e),ht=n(e),ee=r(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-1rykzxi"&&(ee.innerHTML=bs),ut=n(e),te=r(e,"UL",{"data-svelte-h":!0}),o(te)!=="svelte-n55cqy"&&(te.innerHTML=_s),Ut=n(e),se=r(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-1v0hjve"&&(se.innerHTML=xs),gt=n(e),J(le.$$.fragment,e),It=n(e),ae=r(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-pdxcpx"&&(ae.innerHTML=Zs),jt=n(e),J(ne.$$.fragment,e),ft=n(e),J(ie.$$.fragment,e),Ct=n(e),re=r(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-l786pq"&&(re.innerHTML=Bs),bt=n(e),J(oe.$$.fragment,e),_t=n(e),J(pe.$$.fragment,e),xt=n(e),Je=r(e,"P",{"data-svelte-h":!0}),o(Je)!=="svelte-8hyjxi"&&(Je.textContent=vs),Zt=n(e),J(Me.$$.fragment,e),Bt=n(e),Te=r(e,"P",{"data-svelte-h":!0}),o(Te)!=="svelte-170csdj"&&(Te.innerHTML=ks),vt=n(e),J(ce.$$.fragment,e),kt=n(e),ye=r(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-1v93yyh"&&(ye.innerHTML=Ws),Wt=n(e),J(me.$$.fragment,e),Nt=n(e),we=r(e,"P",{"data-svelte-h":!0}),o(we)!=="svelte-o081ci"&&(we.innerHTML=Ns),At=n(e),J(de.$$.fragment,e),Ht=n(e),he=r(e,"P",{"data-svelte-h":!0}),o(he)!=="svelte-1xlsl63"&&(he.innerHTML=As),zt=n(e),J(ue.$$.fragment,e),Xt=n(e),Ue=r(e,"P",{"data-svelte-h":!0}),o(Ue)!=="svelte-1yk874x"&&(Ue.innerHTML=Hs),Gt=n(e),ge=r(e,"P",{"data-svelte-h":!0}),o(ge)!=="svelte-11t96qn"&&(ge.innerHTML=zs),$t=n(e),Ie=r(e,"P",{"data-svelte-h":!0}),o(Ie)!=="svelte-1d0l8c6"&&(Ie.innerHTML=Xs),St=n(e),J(je.$$.fragment,e),Rt=n(e),fe=r(e,"P",{"data-svelte-h":!0}),o(fe)!=="svelte-vxilj7"&&(fe.innerHTML=Gs),Et=n(e),J(Ce.$$.fragment,e),Vt=n(e),be=r(e,"P",{"data-svelte-h":!0}),o(be)!=="svelte-1rsnmrd"&&(be.innerHTML=$s),Yt=n(e),_e=r(e,"P",{"data-svelte-h":!0}),o(_e)!=="svelte-1mokhnw"&&(_e.innerHTML=Ss),Qt=n(e),xe=r(e,"P",{"data-svelte-h":!0}),o(xe)!=="svelte-hhyk3e"&&(xe.innerHTML=Rs),Ft=n(e),J(Ze.$$.fragment,e),Lt=n(e),J(Be.$$.fragment,e),qt=n(e),ve=r(e,"P",{"data-svelte-h":!0}),o(ve)!=="svelte-xro6kp"&&(ve.innerHTML=Es),Dt=n(e),J(ke.$$.fragment,e),Pt=n(e),We=r(e,"P",{"data-svelte-h":!0}),o(We)!=="svelte-1y5r5uo"&&(We.innerHTML=Vs),Kt=n(e),Ae=r(e,"P",{}),es(Ae).forEach(s),this.h()},h(){u(h,"name","hf:doc:metadata"),u(h,"content",el),u(m,"width","700"),u(m,"height","394"),Qs(m.src,ss="https://www.youtube.com/embed/ok3hetb42gU")||u(m,"src",ss),u(m,"title","YouTube video player"),u(m,"frameborder","0"),u(m,"allow","accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"),m.allowFullscreen=""},m(e,t){Ks(document.head,h),l(e,He,t),l(e,Ne,t),l(e,ze,t),M(U,e,t),l(e,Xe,t),l(e,m,t),l(e,Ge,t),l(e,g,t),l(e,$e,t),l(e,I,t),l(e,Se,t),M(j,e,t),l(e,Re,t),l(e,f,t),l(e,Ee,t),l(e,C,t),l(e,Ve,t),l(e,b,t),l(e,Ye,t),l(e,_,t),l(e,Qe,t),l(e,x,t),l(e,Fe,t),M(Z,e,t),l(e,Le,t),l(e,B,t),l(e,qe,t),l(e,v,t),l(e,De,t),M(k,e,t),l(e,Pe,t),l(e,W,t),l(e,Ke,t),l(e,N,t),l(e,Oe,t),l(e,A,t),l(e,et,t),M(H,e,t),l(e,tt,t),M(z,e,t),l(e,st,t),l(e,X,t),l(e,lt,t),l(e,G,t),l(e,at,t),l(e,$,t),l(e,nt,t),M(S,e,t),l(e,it,t),l(e,R,t),l(e,rt,t),l(e,E,t),l(e,ot,t),M(V,e,t),l(e,pt,t),l(e,Y,t),l(e,Jt,t),l(e,Q,t),l(e,Mt,t),M(F,e,t),l(e,Tt,t),l(e,L,t),l(e,ct,t),l(e,q,t),l(e,yt,t),l(e,D,t),l(e,mt,t),M(P,e,t),l(e,wt,t),l(e,K,t),l(e,dt,t),M(O,e,t),l(e,ht,t),l(e,ee,t),l(e,ut,t),l(e,te,t),l(e,Ut,t),l(e,se,t),l(e,gt,t),M(le,e,t),l(e,It,t),l(e,ae,t),l(e,jt,t),M(ne,e,t),l(e,ft,t),M(ie,e,t),l(e,Ct,t),l(e,re,t),l(e,bt,t),M(oe,e,t),l(e,_t,t),M(pe,e,t),l(e,xt,t),l(e,Je,t),l(e,Zt,t),M(Me,e,t),l(e,Bt,t),l(e,Te,t),l(e,vt,t),M(ce,e,t),l(e,kt,t),l(e,ye,t),l(e,Wt,t),M(me,e,t),l(e,Nt,t),l(e,we,t),l(e,At,t),M(de,e,t),l(e,Ht,t),l(e,he,t),l(e,zt,t),M(ue,e,t),l(e,Xt,t),l(e,Ue,t),l(e,Gt,t),l(e,ge,t),l(e,$t,t),l(e,Ie,t),l(e,St,t),M(je,e,t),l(e,Rt,t),l(e,fe,t),l(e,Et,t),M(Ce,e,t),l(e,Vt,t),l(e,be,t),l(e,Yt,t),l(e,_e,t),l(e,Qt,t),l(e,xe,t),l(e,Ft,t),M(Ze,e,t),l(e,Lt,t),M(Be,e,t),l(e,qt,t),l(e,ve,t),l(e,Dt,t),M(ke,e,t),l(e,Pt,t),l(e,We,t),l(e,Kt,t),l(e,Ae,t),Ot=!0},p:Fs,i(e){Ot||(T(U.$$.fragment,e),T(j.$$.fragment,e),T(Z.$$.fragment,e),T(k.$$.fragment,e),T(H.$$.fragment,e),T(z.$$.fragment,e),T(S.$$.fragment,e),T(V.$$.fragment,e),T(F.$$.fragment,e),T(P.$$.fragment,e),T(O.$$.fragment,e),T(le.$$.fragment,e),T(ne.$$.fragment,e),T(ie.$$.fragment,e),T(oe.$$.fragment,e),T(pe.$$.fragment,e),T(Me.$$.fragment,e),T(ce.$$.fragment,e),T(me.$$.fragment,e),T(de.$$.fragment,e),T(ue.$$.fragment,e),T(je.$$.fragment,e),T(Ce.$$.fragment,e),T(Ze.$$.fragment,e),T(Be.$$.fragment,e),T(ke.$$.fragment,e),Ot=!0)},o(e){c(U.$$.fragment,e),c(j.$$.fragment,e),c(Z.$$.fragment,e),c(k.$$.fragment,e),c(H.$$.fragment,e),c(z.$$.fragment,e),c(S.$$.fragment,e),c(V.$$.fragment,e),c(F.$$.fragment,e),c(P.$$.fragment,e),c(O.$$.fragment,e),c(le.$$.fragment,e),c(ne.$$.fragment,e),c(ie.$$.fragment,e),c(oe.$$.fragment,e),c(pe.$$.fragment,e),c(Me.$$.fragment,e),c(ce.$$.fragment,e),c(me.$$.fragment,e),c(de.$$.fragment,e),c(ue.$$.fragment,e),c(je.$$.fragment,e),c(Ce.$$.fragment,e),c(Ze.$$.fragment,e),c(Be.$$.fragment,e),c(ke.$$.fragment,e),Ot=!1},d(e){e&&(s(He),s(Ne),s(ze),s(Xe),s(m),s(Ge),s(g),s($e),s(I),s(Se),s(Re),s(f),s(Ee),s(C),s(Ve),s(b),s(Ye),s(_),s(Qe),s(x),s(Fe),s(Le),s(B),s(qe),s(v),s(De),s(Pe),s(W),s(Ke),s(N),s(Oe),s(A),s(et),s(tt),s(st),s(X),s(lt),s(G),s(at),s($),s(nt),s(it),s(R),s(rt),s(E),s(ot),s(pt),s(Y),s(Jt),s(Q),s(Mt),s(Tt),s(L),s(ct),s(q),s(yt),s(D),s(mt),s(wt),s(K),s(dt),s(ht),s(ee),s(ut),s(te),s(Ut),s(se),s(gt),s(It),s(ae),s(jt),s(ft),s(Ct),s(re),s(bt),s(_t),s(xt),s(Je),s(Zt),s(Bt),s(Te),s(vt),s(kt),s(ye),s(Wt),s(Nt),s(we),s(At),s(Ht),s(he),s(zt),s(Xt),s(Ue),s(Gt),s(ge),s($t),s(Ie),s(St),s(Rt),s(fe),s(Et),s(Vt),s(be),s(Yt),s(_e),s(Qt),s(xe),s(Ft),s(Lt),s(qt),s(ve),s(Dt),s(Pt),s(We),s(Kt),s(Ae)),s(h),y(U,e),y(j,e),y(Z,e),y(k,e),y(H,e),y(z,e),y(S,e),y(V,e),y(F,e),y(P,e),y(O,e),y(le,e),y(ne,e),y(ie,e),y(oe,e),y(pe,e),y(Me,e),y(ce,e),y(me,e),y(de,e),y(ue,e),y(je,e),y(Ce,e),y(Ze,e),y(Be,e),y(ke,e)}}}const el='{"title":"Run training on Amazon SageMaker","local":"run-training-on-amazon-sagemaker","sections":[{"title":"Installation and setup","local":"installation-and-setup","sections":[],"depth":2},{"title":"Prepare a 🤗 Transformers fine-tuning script","local":"prepare-a--transformers-fine-tuning-script","sections":[],"depth":2},{"title":"Training Output Management","local":"training-output-management","sections":[],"depth":2},{"title":"Create a Hugging Face Estimator","local":"create-a-hugging-face-estimator","sections":[],"depth":2},{"title":"Execute training","local":"execute-training","sections":[],"depth":2},{"title":"Access trained model","local":"access-trained-model","sections":[],"depth":2},{"title":"Distributed training","local":"distributed-training","sections":[{"title":"Data parallelism","local":"data-parallelism","sections":[],"depth":3},{"title":"Model parallelism","local":"model-parallelism","sections":[],"depth":3}],"depth":2},{"title":"Spot instances","local":"spot-instances","sections":[],"depth":2},{"title":"Git repository","local":"git-repository","sections":[],"depth":2},{"title":"SageMaker metrics","local":"sagemaker-metrics","sections":[],"depth":2}],"depth":1}';function tl(ts){return Ls(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class il extends qs{constructor(h){super(),Ds(this,h,tl,Os,Ys,{})}}export{il as component};
