import{s as _s,o as ks,n as Ft}from"../chunks/scheduler.9bc65507.js";import{S as vs,i as bs,g as o,s as r,u as g,A as ys,h as s,f as n,c as a,j as m,v as _,y as h,k as p,o as t,a as d,w as k,d as v,t as b,x as y}from"../chunks/index.78c82d43.js";import{T as fo}from"../chunks/Tip.87d55b76.js";import{D as z}from"../chunks/Docstring.f3d04bd2.js";import{C as _o}from"../chunks/CodeBlock.48618ec2.js";import{I as D}from"../chunks/IconCopyLink.bedaa44d.js";import{E as go}from"../chunks/ExampleCodeBlock.872b014d.js";function ws(x){let l,T="Example:",u,f,w;return f=new _o({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwbGludGVyTW9kZWwlMkMlMjBTcGxpbnRlckNvbmZpZyUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBTcGxpbnRlciUyMHRhdSUyRnNwbGludGVyLWJhc2UlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwU3BsaW50ZXJDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMGZyb20lMjB0aGUlMjB0YXUlMkZzcGxpbnRlci1iYXNlJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBTcGxpbnRlck1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SplinterModel, SplinterConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Splinter tau/splinter-base style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = SplinterConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the tau/splinter-base style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SplinterModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`}}),{c(){l=o("p"),l.textContent=T,u=r(),g(f.$$.fragment)},l(c){l=s(c,"P",{"data-svelte-h":!0}),h(l)!=="svelte-11lpom8"&&(l.textContent=T),u=a(c),_(f.$$.fragment,c)},m(c,$){d(c,l,$),d(c,u,$),k(f,c,$),w=!0},p:Ft,i(c){w||(v(f.$$.fragment,c),w=!0)},o(c){b(f.$$.fragment,c),w=!1},d(c){c&&(n(l),n(u)),y(f,c)}}}function Ts(x){let l,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){l=o("p"),l.innerHTML=T},l(u){l=s(u,"P",{"data-svelte-h":!0}),h(l)!=="svelte-fincs2"&&(l.innerHTML=T)},m(u,f){d(u,l,f)},p:Ft,d(u){u&&n(l)}}}function Ss(x){let l,T="Example:",u,f,w;return f=new _o({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBTcGxpbnRlck1vZGVsJTBBaW1wb3J0JTIwdG9yY2glMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJ0YXUlMkZzcGxpbnRlci1iYXNlJTIyKSUwQW1vZGVsJTIwJTNEJTIwU3BsaW50ZXJNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIydGF1JTJGc3BsaW50ZXItYmFzZSUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIySGVsbG8lMkMlMjBteSUyMGRvZyUyMGlzJTIwY3V0ZSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQWxhc3RfaGlkZGVuX3N0YXRlcyUyMCUzRCUyMG91dHB1dHMubGFzdF9oaWRkZW5fc3RhdGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, SplinterModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;tau/splinter-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SplinterModel.from_pretrained(<span class="hljs-string">&quot;tau/splinter-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`}}),{c(){l=o("p"),l.textContent=T,u=r(),g(f.$$.fragment)},l(c){l=s(c,"P",{"data-svelte-h":!0}),h(l)!=="svelte-11lpom8"&&(l.textContent=T),u=a(c),_(f.$$.fragment,c)},m(c,$){d(c,l,$),d(c,u,$),k(f,c,$),w=!0},p:Ft,i(c){w||(v(f.$$.fragment,c),w=!0)},o(c){b(f.$$.fragment,c),w=!1},d(c){c&&(n(l),n(u)),y(f,c)}}}function $s(x){let l,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){l=o("p"),l.innerHTML=T},l(u){l=s(u,"P",{"data-svelte-h":!0}),h(l)!=="svelte-fincs2"&&(l.innerHTML=T)},m(u,f){d(u,l,f)},p:Ft,d(u){u&&n(l)}}}function xs(x){let l,T="Example:",u,f,w;return f=new _o({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBTcGxpbnRlckZvclF1ZXN0aW9uQW5zd2VyaW5nJTBBaW1wb3J0JTIwdG9yY2glMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJ0YXUlMkZzcGxpbnRlci1iYXNlJTIyKSUwQW1vZGVsJTIwJTNEJTIwU3BsaW50ZXJGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIydGF1JTJGc3BsaW50ZXItYmFzZSUyMiklMEElMEFxdWVzdGlvbiUyQyUyMHRleHQlMjAlM0QlMjAlMjJXaG8lMjB3YXMlMjBKaW0lMjBIZW5zb24lM0YlMjIlMkMlMjAlMjJKaW0lMjBIZW5zb24lMjB3YXMlMjBhJTIwbmljZSUyMHB1cHBldCUyMiUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcihxdWVzdGlvbiUyQyUyMHRleHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBYW5zd2VyX3N0YXJ0X2luZGV4JTIwJTNEJTIwb3V0cHV0cy5zdGFydF9sb2dpdHMuYXJnbWF4KCklMEFhbnN3ZXJfZW5kX2luZGV4JTIwJTNEJTIwb3V0cHV0cy5lbmRfbG9naXRzLmFyZ21heCgpJTBBJTBBcHJlZGljdF9hbnN3ZXJfdG9rZW5zJTIwJTNEJTIwaW5wdXRzLmlucHV0X2lkcyU1QjAlMkMlMjBhbnN3ZXJfc3RhcnRfaW5kZXglMjAlM0ElMjBhbnN3ZXJfZW5kX2luZGV4JTIwJTJCJTIwMSU1RCUwQSUwQSUyMyUyMHRhcmdldCUyMGlzJTIwJTIybmljZSUyMHB1cHBldCUyMiUwQXRhcmdldF9zdGFydF9pbmRleCUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUIxNCU1RCklMEF0YXJnZXRfZW5kX2luZGV4JTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QjE1JTVEKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMHN0YXJ0X3Bvc2l0aW9ucyUzRHRhcmdldF9zdGFydF9pbmRleCUyQyUyMGVuZF9wb3NpdGlvbnMlM0R0YXJnZXRfZW5kX2luZGV4KSUwQWxvc3MlMjAlM0QlMjBvdXRwdXRzLmxvc3M=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, SplinterForQuestionAnswering
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;tau/splinter-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SplinterForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;tau/splinter-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>question, text = <span class="hljs-string">&quot;Who was Jim Henson?&quot;</span>, <span class="hljs-string">&quot;Jim Henson was a nice puppet&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(question, text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>answer_start_index = outputs.start_logits.argmax()
<span class="hljs-meta">&gt;&gt;&gt; </span>answer_end_index = outputs.end_logits.argmax()

<span class="hljs-meta">&gt;&gt;&gt; </span>predict_answer_tokens = inputs.input_ids[<span class="hljs-number">0</span>, answer_start_index : answer_end_index + <span class="hljs-number">1</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># target is &quot;nice puppet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>target_start_index = torch.tensor([<span class="hljs-number">14</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>target_end_index = torch.tensor([<span class="hljs-number">15</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, start_positions=target_start_index, end_positions=target_end_index)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss`}}),{c(){l=o("p"),l.textContent=T,u=r(),g(f.$$.fragment)},l(c){l=s(c,"P",{"data-svelte-h":!0}),h(l)!=="svelte-11lpom8"&&(l.textContent=T),u=a(c),_(f.$$.fragment,c)},m(c,$){d(c,l,$),d(c,u,$),k(f,c,$),w=!0},p:Ft,i(c){w||(v(f.$$.fragment,c),w=!0)},o(c){b(f.$$.fragment,c),w=!1},d(c){c&&(n(l),n(u)),y(f,c)}}}function Ms(x){let l,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){l=o("p"),l.innerHTML=T},l(u){l=s(u,"P",{"data-svelte-h":!0}),h(l)!=="svelte-fincs2"&&(l.innerHTML=T)},m(u,f){d(u,l,f)},p:Ft,d(u){u&&n(l)}}}function zs(x){let l,T,u,f,w,c,$,_e,Tn,Re,ko="Splinter",Qt,E,R,Pt,ke,Sn,Xe,vo="Overview",Gt,ve,bo=`The Splinter model was proposed in <a href="https://arxiv.org/abs/2101.00438" rel="nofollow">Few-Shot Question Answering by Pretraining Span Selection</a> by Ori Ram, Yuval Kirstain, Jonathan Berant, Amir Globerson, Omer Levy. Splinter
is an encoder-only transformer (similar to BERT) pretrained using the recurring span selection task on a large corpus
comprising Wikipedia and the Toronto Book Corpus.`,Ot,be,yo="The abstract from the paper is the following:",Dt,ye,wo=`In several question answering benchmarks, pretrained models have reached human parity through fine-tuning on an order
of 100,000 annotated questions and answers. We explore the more realistic few-shot setting, where only a few hundred
training examples are available, and observe that standard models perform poorly, highlighting the discrepancy between
current pretraining objectives and question answering. We propose a new pretraining scheme tailored for question
answering: recurring span selection. Given a passage with multiple sets of recurring spans, we mask in each set all
recurring spans but one, and ask the model to select the correct span in the passage for each masked span. Masked spans
are replaced with a special token, viewed as a question representation, that is later used during fine-tuning to select
the answer span. The resulting model obtains surprisingly good results on multiple benchmarks (e.g., 72.7 F1 on SQuAD
with only 128 training examples), while maintaining competitive performance in the high-resource setting.`,Rt,we,To="Tips:",Xt,Te,So=`<li>Splinter was trained to predict answers spans conditioned on a special [QUESTION] token. These tokens contextualize
to question representations which are used to predict the answers. This layer is called QASS, and is the default
behaviour in the <a href="/docs/transformers/v4.33.3/en/model_doc/splinter#transformers.SplinterForQuestionAnswering">SplinterForQuestionAnswering</a> class. Therefore:</li> <li>Use <a href="/docs/transformers/v4.33.3/en/model_doc/splinter#transformers.SplinterTokenizer">SplinterTokenizer</a> (rather than <a href="/docs/transformers/v4.33.3/en/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a>), as it already
contains this special token. Also, its default behavior is to use this token when two sequences are given (for
example, in the <em>run_qa.py</em> script).</li> <li>If you plan on using Splinter outside <em>run_qa.py</em>, please keep in mind the question token - it might be important for
the success of your model, especially in a few-shot setting.</li> <li>Please note there are two different checkpoints for each size of Splinter. Both are basically the same, except that
one also has the pretrained weights of the QASS layer (<em>tau/splinter-base-qass</em> and <em>tau/splinter-large-qass</em>) and one
doesn’t (<em>tau/splinter-base</em> and <em>tau/splinter-large</em>). This is done to support randomly initializing this layer at
fine-tuning, as it is shown to yield better results for some cases in the paper.</li>`,Vt,Se,$o='This model was contributed by <a href="https://huggingface.co/yuvalkirstain" rel="nofollow">yuvalkirstain</a> and <a href="https://huggingface.co/oriram" rel="nofollow">oriram</a>. The original code can be found <a href="https://github.com/oriram/splinter" rel="nofollow">here</a>.',Yt,J,X,Lt,$e,$n,Ve,xo="Documentation resources",Kt,xe,Mo='<li><a href="../tasks/question-answering">Question answering task guide</a></li>',en,H,V,It,Me,xn,Ye,zo="SplinterConfig",tn,q,ze,Mn,Ke,qo=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.33.3/en/model_doc/splinter#transformers.SplinterModel">SplinterModel</a>. It is used to instantiate an
Splinter model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the Splinter
<a href="https://huggingface.co/tau/splinter-base" rel="nofollow">tau/splinter-base</a> architecture.`,zn,et,Co=`Configuration objects inherit from <a href="/docs/transformers/v4.33.3/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.33.3/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,qn,Y,nn,B,K,At,qe,Cn,tt,Fo="SplinterTokenizer",on,S,Ce,Fn,nt,Po="Construct a Splinter tokenizer. Based on WordPiece.",Pn,ot,Lo=`This tokenizer inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a> which contains most of the main methods. Users should refer to
this superclass for more information regarding those methods.`,Ln,j,Fe,In,st,Io=`Build model inputs from a pair of sequence for question answering tasks by concatenating and adding special
tokens. A Splinter sequence has the following format:`,An,rt,Ao="<li>single sequence: <code>[CLS] X [SEP]</code></li> <li>pair of sequences for question answering: <code>[CLS] question_tokens [QUESTION] . [SEP] context_tokens [SEP]</code></li>",jn,ee,Pe,Nn,at,jo=`Retrieve sequence ids from a token list that has no special tokens added. This method is called when adding
special tokens using the tokenizer <code>prepare_for_model</code> method.`,Un,N,Le,Wn,it,No=`Create the token type IDs corresponding to the sequences passed. <a href="../glossary#token-type-ids">What are token type
IDs?</a>`,En,lt,Uo="Should be overridden in a subclass if the model has a special way of building those.",Jn,dt,Ie,sn,Z,te,jt,Ae,Hn,ct,Wo="SplinterTokenizerFast",rn,C,je,Bn,pt,Eo="Construct a “fast” Splinter tokenizer (backed by HuggingFace’s <em>tokenizers</em> library). Based on WordPiece.",Zn,ht,Jo=`This tokenizer inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast">PreTrainedTokenizerFast</a> which contains most of the main methods. Users should
refer to this superclass for more information regarding those methods.`,Qn,U,Ne,Gn,mt,Ho=`Build model inputs from a pair of sequence for question answering tasks by concatenating and adding special
tokens. A Splinter sequence has the following format:`,On,ut,Bo="<li>single sequence: <code>[CLS] X [SEP]</code></li> <li>pair of sequences for question answering: <code>[CLS] question_tokens [QUESTION] . [SEP] context_tokens [SEP]</code></li>",an,Q,ne,Nt,Ue,Dn,ft,Zo="SplinterModel",ln,F,We,Rn,gt,Qo=`The bare Splinter Model transformer outputting raw hidden-states without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Xn,_t,Go=`The model is an encoder (with only self-attention) following the architecture described in <a href="https://arxiv.org/abs/1706.03762" rel="nofollow">Attention is all you
need</a> by Ashish Vaswani, Noam Shazeer, Niki Parmar, Jakob Uszkoreit, Llion Jones,
Aidan N. Gomez, Lukasz Kaiser and Illia Polosukhin.`,Vn,I,Ee,Yn,kt,Oo='The <a href="/docs/transformers/v4.33.3/en/model_doc/splinter#transformers.SplinterModel">SplinterModel</a> forward method, overrides the <code>__call__</code> special method.',Kn,oe,eo,se,dn,G,re,Ut,Je,to,vt,Do="SplinterForQuestionAnswering",cn,P,He,no,bt,Ro=`Splinter Model with a span classification head on top for extractive question-answering tasks like SQuAD (a linear
layers on top of the hidden-states output to compute <code>span start logits</code> and <code>span end logits</code>).`,oo,yt,Xo=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,so,A,Be,ro,wt,Vo='The <a href="/docs/transformers/v4.33.3/en/model_doc/splinter#transformers.SplinterForQuestionAnswering">SplinterForQuestionAnswering</a> forward method, overrides the <code>__call__</code> special method.',ao,ae,io,ie,pn,O,le,Wt,Ze,lo,Tt,Yo="SplinterForPreTraining",hn,L,Qe,co,St,Ko=`Splinter Model for the recurring span selection task as done during the pretraining. The difference to the QA task
is that we do not have a question, but multiple question tokens that replace the occurrences of recurring spans
instead.`,po,$t,es=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,ho,W,Ge,mo,xt,ts='The <a href="/docs/transformers/v4.33.3/en/model_doc/splinter#transformers.SplinterForPreTraining">SplinterForPreTraining</a> forward method, overrides the <code>__call__</code> special method.',uo,de,mn,Et,un;return _e=new D({}),ke=new D({}),$e=new D({}),Me=new D({}),ze=new z({props:{name:"class transformers.SplinterConfig",anchor:"transformers.SplinterConfig",parameters:[{name:"vocab_size",val:" = 30522"},{name:"hidden_size",val:" = 768"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 12"},{name:"intermediate_size",val:" = 3072"},{name:"hidden_act",val:" = 'gelu'"},{name:"hidden_dropout_prob",val:" = 0.1"},{name:"attention_probs_dropout_prob",val:" = 0.1"},{name:"max_position_embeddings",val:" = 512"},{name:"type_vocab_size",val:" = 2"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-12"},{name:"use_cache",val:" = True"},{name:"pad_token_id",val:" = 0"},{name:"question_token_id",val:" = 104"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SplinterConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 30522) &#x2014;
Vocabulary size of the Splinter model. Defines the number of different tokens that can be represented by
the <code>inputs_ids</code> passed when calling <a href="/docs/transformers/v4.33.3/en/model_doc/splinter#transformers.SplinterModel">SplinterModel</a>.`,name:"vocab_size"},{anchor:"transformers.SplinterConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimension of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.SplinterConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.SplinterConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.SplinterConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimension of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.SplinterConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.SplinterConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probabilitiy for all fully connected layers in the embeddings, encoder, and pooler.`,name:"hidden_dropout_prob"},{anchor:"transformers.SplinterConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.SplinterConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The maximum sequence length that this model might ever be used with. Typically set this to something large
just in case (e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.SplinterConfig.type_vocab_size",description:`<strong>type_vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The vocabulary size of the <code>token_type_ids</code> passed when calling <a href="/docs/transformers/v4.33.3/en/model_doc/splinter#transformers.SplinterModel">SplinterModel</a>.`,name:"type_vocab_size"},{anchor:"transformers.SplinterConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.SplinterConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-12) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.SplinterConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models). Only
relevant if <code>config.is_decoder=True</code>.`,name:"use_cache"},{anchor:"transformers.SplinterConfig.question_token_id",description:`<strong>question_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 104) &#x2014;
The id of the <code>[QUESTION]</code> token.`,name:"question_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/splinter/configuration_splinter.py#L32"}}),Y=new go({props:{anchor:"transformers.SplinterConfig.example",$$slots:{default:[ws]},$$scope:{ctx:x}}}),qe=new D({}),Ce=new z({props:{name:"class transformers.SplinterTokenizer",anchor:"transformers.SplinterTokenizer",parameters:[{name:"vocab_file",val:""},{name:"do_lower_case",val:" = True"},{name:"do_basic_tokenize",val:" = True"},{name:"never_split",val:" = None"},{name:"unk_token",val:" = '[UNK]'"},{name:"sep_token",val:" = '[SEP]'"},{name:"pad_token",val:" = '[PAD]'"},{name:"cls_token",val:" = '[CLS]'"},{name:"mask_token",val:" = '[MASK]'"},{name:"question_token",val:" = '[QUESTION]'"},{name:"tokenize_chinese_chars",val:" = True"},{name:"strip_accents",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SplinterTokenizer.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
File containing the vocabulary.`,name:"vocab_file"},{anchor:"transformers.SplinterTokenizer.do_lower_case",description:`<strong>do_lower_case</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to lowercase the input when tokenizing.`,name:"do_lower_case"},{anchor:"transformers.SplinterTokenizer.do_basic_tokenize",description:`<strong>do_basic_tokenize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to do basic tokenization before WordPiece.`,name:"do_basic_tokenize"},{anchor:"transformers.SplinterTokenizer.never_split",description:`<strong>never_split</strong> (<code>Iterable</code>, <em>optional</em>) &#x2014;
Collection of tokens which will never be split during tokenization. Only has an effect when
<code>do_basic_tokenize=True</code>`,name:"never_split"},{anchor:"transformers.SplinterTokenizer.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[UNK]&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.SplinterTokenizer.sep_token",description:`<strong>sep_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[SEP]&quot;</code>) &#x2014;
The separator token, which is used when building a sequence from multiple sequences, e.g. two sequences for
sequence classification or for a text and a question for question answering. It is also used as the last
token of a sequence built with special tokens.`,name:"sep_token"},{anchor:"transformers.SplinterTokenizer.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[PAD]&quot;</code>) &#x2014;
The token used for padding, for example when batching sequences of different lengths.`,name:"pad_token"},{anchor:"transformers.SplinterTokenizer.cls_token",description:`<strong>cls_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[CLS]&quot;</code>) &#x2014;
The classifier token which is used when doing sequence classification (classification of the whole sequence
instead of per-token classification). It is the first token of the sequence when built with special tokens.`,name:"cls_token"},{anchor:"transformers.SplinterTokenizer.mask_token",description:`<strong>mask_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[MASK]&quot;</code>) &#x2014;
The token used for masking values. This is the token used when training this model with masked language
modeling. This is the token which the model will try to predict.`,name:"mask_token"},{anchor:"transformers.SplinterTokenizer.question_token",description:`<strong>question_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[QUESTION]&quot;</code>) &#x2014;
The token used for constructing question representations.`,name:"question_token"},{anchor:"transformers.SplinterTokenizer.tokenize_chinese_chars",description:`<strong>tokenize_chinese_chars</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to tokenize Chinese characters.</p>
<p>This should likely be deactivated for Japanese (see this
<a href="https://github.com/huggingface/transformers/issues/328" rel="nofollow">issue</a>).`,name:"tokenize_chinese_chars"},{anchor:"transformers.SplinterTokenizer.strip_accents",description:`<strong>strip_accents</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to strip all accents. If this option is not specified, then it will be determined by the
value for <code>lowercase</code> (as in the original BERT).`,name:"strip_accents"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/splinter/tokenization_splinter.py#L75"}}),Fe=new z({props:{name:"build_inputs_with_special_tokens",anchor:"transformers.SplinterTokenizer.build_inputs_with_special_tokens",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"transformers.SplinterTokenizer.build_inputs_with_special_tokens.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
The question token IDs if pad_on_right, else context tokens IDs`,name:"token_ids_0"},{anchor:"transformers.SplinterTokenizer.build_inputs_with_special_tokens.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
The context token IDs if pad_on_right, else question token IDs`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/splinter/tokenization_splinter.py#L217",returnDescription:`
<p>List of <a href="../glossary#input-ids">input IDs</a> with the appropriate special tokens.</p>
`,returnType:`
<p><code>List[int]</code></p>
`}}),Pe=new z({props:{name:"get_special_tokens_mask",anchor:"transformers.SplinterTokenizer.get_special_tokens_mask",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"},{name:"already_has_special_tokens",val:": bool = False"}],parametersDescription:[{anchor:"transformers.SplinterTokenizer.get_special_tokens_mask.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs.`,name:"token_ids_0"},{anchor:"transformers.SplinterTokenizer.get_special_tokens_mask.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"},{anchor:"transformers.SplinterTokenizer.get_special_tokens_mask.already_has_special_tokens",description:`<strong>already_has_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the token list is already formatted with special tokens for the model.`,name:"already_has_special_tokens"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/splinter/tokenization_splinter.py#L249",returnDescription:`
<p>A list of integers in the range [0, 1]: 1 for a special token, 0 for a sequence token.</p>
`,returnType:`
<p><code>List[int]</code></p>
`}}),Le=new z({props:{name:"create_token_type_ids_from_sequences",anchor:"transformers.SplinterTokenizer.create_token_type_ids_from_sequences",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"transformers.SplinterTokenizer.create_token_type_ids_from_sequences.token_ids_0",description:"<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014; The first tokenized sequence.",name:"token_ids_0"},{anchor:"transformers.SplinterTokenizer.create_token_type_ids_from_sequences.token_ids_1",description:"<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014; The second tokenized sequence.",name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/splinter/tokenization_splinter.py#L277",returnDescription:`
<p>The token type ids.</p>
`,returnType:`
<p><code>List[int]</code></p>
`}}),Ie=new z({props:{name:"save_vocabulary",anchor:"transformers.SplinterTokenizer.save_vocabulary",parameters:[{name:"save_directory",val:": str"},{name:"filename_prefix",val:": typing.Optional[str] = None"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/splinter/tokenization_splinter.py#L306"}}),Ae=new D({}),je=new z({props:{name:"class transformers.SplinterTokenizerFast",anchor:"transformers.SplinterTokenizerFast",parameters:[{name:"vocab_file",val:" = None"},{name:"tokenizer_file",val:" = None"},{name:"do_lower_case",val:" = True"},{name:"unk_token",val:" = '[UNK]'"},{name:"sep_token",val:" = '[SEP]'"},{name:"pad_token",val:" = '[PAD]'"},{name:"cls_token",val:" = '[CLS]'"},{name:"mask_token",val:" = '[MASK]'"},{name:"question_token",val:" = '[QUESTION]'"},{name:"tokenize_chinese_chars",val:" = True"},{name:"strip_accents",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SplinterTokenizerFast.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
File containing the vocabulary.`,name:"vocab_file"},{anchor:"transformers.SplinterTokenizerFast.do_lower_case",description:`<strong>do_lower_case</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to lowercase the input when tokenizing.`,name:"do_lower_case"},{anchor:"transformers.SplinterTokenizerFast.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[UNK]&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.SplinterTokenizerFast.sep_token",description:`<strong>sep_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[SEP]&quot;</code>) &#x2014;
The separator token, which is used when building a sequence from multiple sequences, e.g. two sequences for
sequence classification or for a text and a question for question answering. It is also used as the last
token of a sequence built with special tokens.`,name:"sep_token"},{anchor:"transformers.SplinterTokenizerFast.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[PAD]&quot;</code>) &#x2014;
The token used for padding, for example when batching sequences of different lengths.`,name:"pad_token"},{anchor:"transformers.SplinterTokenizerFast.cls_token",description:`<strong>cls_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[CLS]&quot;</code>) &#x2014;
The classifier token which is used when doing sequence classification (classification of the whole sequence
instead of per-token classification). It is the first token of the sequence when built with special tokens.`,name:"cls_token"},{anchor:"transformers.SplinterTokenizerFast.mask_token",description:`<strong>mask_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[MASK]&quot;</code>) &#x2014;
The token used for masking values. This is the token used when training this model with masked language
modeling. This is the token which the model will try to predict.`,name:"mask_token"},{anchor:"transformers.SplinterTokenizerFast.question_token",description:`<strong>question_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[QUESTION]&quot;</code>) &#x2014;
The token used for constructing question representations.`,name:"question_token"},{anchor:"transformers.SplinterTokenizerFast.clean_text",description:`<strong>clean_text</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to clean the text before tokenization by removing any control characters and replacing all
whitespaces by the classic one.`,name:"clean_text"},{anchor:"transformers.SplinterTokenizerFast.tokenize_chinese_chars",description:`<strong>tokenize_chinese_chars</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to tokenize Chinese characters. This should likely be deactivated for Japanese (see <a href="https://github.com/huggingface/transformers/issues/328" rel="nofollow">this
issue</a>).`,name:"tokenize_chinese_chars"},{anchor:"transformers.SplinterTokenizerFast.strip_accents",description:`<strong>strip_accents</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to strip all accents. If this option is not specified, then it will be determined by the
value for <code>lowercase</code> (as in the original BERT).`,name:"strip_accents"},{anchor:"transformers.SplinterTokenizerFast.wordpieces_prefix",description:`<strong>wordpieces_prefix</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;##&quot;</code>) &#x2014;
The prefix for subwords.`,name:"wordpieces_prefix"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/splinter/tokenization_splinter_fast.py#L55"}}),Ne=new z({props:{name:"build_inputs_with_special_tokens",anchor:"transformers.SplinterTokenizerFast.build_inputs_with_special_tokens",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"transformers.SplinterTokenizerFast.build_inputs_with_special_tokens.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
The question token IDs if pad_on_right, else context tokens IDs`,name:"token_ids_0"},{anchor:"transformers.SplinterTokenizerFast.build_inputs_with_special_tokens.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
The context token IDs if pad_on_right, else question token IDs`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/splinter/tokenization_splinter_fast.py#L153",returnDescription:`
<p>List of <a href="../glossary#input-ids">input IDs</a> with the appropriate special tokens.</p>
`,returnType:`
<p><code>List[int]</code></p>
`}}),Ue=new D({}),We=new z({props:{name:"class transformers.SplinterModel",anchor:"transformers.SplinterModel",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.SplinterModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/splinter#transformers.SplinterConfig">SplinterConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/splinter/modeling_splinter.py#L617"}}),Ee=new z({props:{name:"forward",anchor:"transformers.SplinterModel.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.SplinterModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SplinterModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.SplinterModel.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.SplinterModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.SplinterModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.SplinterModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <em>input_ids</em> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.SplinterModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.SplinterModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.SplinterModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.SplinterModel.forward.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong>  (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder. Used in the cross-attention if
the model is configured as a decoder.`,name:"encoder_hidden_states"},{anchor:"transformers.SplinterModel.forward.encoder_attention_mask",description:`<strong>encoder_attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on the padding token indices of the encoder input. This mask is used in
the cross-attention if the model is configured as a decoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>`,name:"encoder_attention_mask"},{anchor:"transformers.SplinterModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code> of length <code>config.n_layers</code> with each tuple having 4 tensors of shape <code>(batch_size, num_heads, sequence_length - 1, embed_size_per_head)</code>) &#x2014;
Contains precomputed key and value hidden states of the attention blocks. Can be used to speed up decoding.
If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.SplinterModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/splinter/modeling_splinter.py#L648",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions"
>transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/splinter#transformers.SplinterConfig"
>SplinterConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and optionally if
<code>config.is_encoder_decoder=True</code> in the cross-attention blocks) that can be used (see <code>past_key_values</code>
input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> and <code>config.add_cross_attention=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions"
>transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),oe=new fo({props:{$$slots:{default:[Ts]},$$scope:{ctx:x}}}),se=new go({props:{anchor:"transformers.SplinterModel.forward.example",$$slots:{default:[Ss]},$$scope:{ctx:x}}}),Je=new D({}),He=new z({props:{name:"class transformers.SplinterForQuestionAnswering",anchor:"transformers.SplinterForQuestionAnswering",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.SplinterForQuestionAnswering.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/splinter#transformers.SplinterConfig">SplinterConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/splinter/modeling_splinter.py#L839"}}),Be=new z({props:{name:"forward",anchor:"transformers.SplinterForQuestionAnswering.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"start_positions",val:": typing.Optional[torch.LongTensor] = None"},{name:"end_positions",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"question_positions",val:": typing.Optional[torch.LongTensor] = None"}],parametersDescription:[{anchor:"transformers.SplinterForQuestionAnswering.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SplinterForQuestionAnswering.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.SplinterForQuestionAnswering.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.SplinterForQuestionAnswering.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.SplinterForQuestionAnswering.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.SplinterForQuestionAnswering.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <em>input_ids</em> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.SplinterForQuestionAnswering.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.SplinterForQuestionAnswering.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.SplinterForQuestionAnswering.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.SplinterForQuestionAnswering.forward.start_positions",description:`<strong>start_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the start of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<code>sequence_length</code>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"start_positions"},{anchor:"transformers.SplinterForQuestionAnswering.forward.end_positions",description:`<strong>end_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the end of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<code>sequence_length</code>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"end_positions"},{anchor:"transformers.SplinterForQuestionAnswering.forward.question_positions",description:`<strong>question_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_questions)</code>, <em>optional</em>) &#x2014;
The positions of all question tokens. If given, start_logits and end_logits will be of shape <code>(batch_size, num_questions, sequence_length)</code>. If None, the first question token in each sequence in the batch will be
the only one for which start_logits and end_logits are calculated and they will be of shape <code>(batch_size, sequence_length)</code>.`,name:"question_positions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/splinter/modeling_splinter.py#L850",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.QuestionAnsweringModelOutput"
>transformers.modeling_outputs.QuestionAnsweringModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/splinter#transformers.SplinterConfig"
>SplinterConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Total span extraction loss is the sum of a Cross-Entropy for the start and end positions.</p>
</li>
<li>
<p><strong>start_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) — Span-start scores (before SoftMax).</p>
</li>
<li>
<p><strong>end_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) — Span-end scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.QuestionAnsweringModelOutput"
>transformers.modeling_outputs.QuestionAnsweringModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ae=new fo({props:{$$slots:{default:[$s]},$$scope:{ctx:x}}}),ie=new go({props:{anchor:"transformers.SplinterForQuestionAnswering.forward.example",$$slots:{default:[xs]},$$scope:{ctx:x}}}),Ze=new D({}),Qe=new z({props:{name:"class transformers.SplinterForPreTraining",anchor:"transformers.SplinterForPreTraining",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.SplinterForPreTraining.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/splinter#transformers.SplinterConfig">SplinterConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/splinter/modeling_splinter.py#L993"}}),Ge=new z({props:{name:"forward",anchor:"transformers.SplinterForPreTraining.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"start_positions",val:": typing.Optional[torch.LongTensor] = None"},{name:"end_positions",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"question_positions",val:": typing.Optional[torch.LongTensor] = None"}],parametersDescription:[{anchor:"transformers.SplinterForPreTraining.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_questions, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SplinterForPreTraining.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>batch_size, num_questions, sequence_length</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.SplinterForPreTraining.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>batch_size, num_questions, sequence_length</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.SplinterForPreTraining.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>batch_size, num_questions, sequence_length</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.SplinterForPreTraining.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.SplinterForPreTraining.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_questions, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <em>input_ids</em> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.SplinterForPreTraining.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.SplinterForPreTraining.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.SplinterForPreTraining.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.SplinterForPreTraining.forward.start_positions",description:`<strong>start_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_questions)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the start of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<code>sequence_length</code>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"start_positions"},{anchor:"transformers.SplinterForPreTraining.forward.end_positions",description:`<strong>end_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_questions)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the end of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<code>sequence_length</code>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"end_positions"},{anchor:"transformers.SplinterForPreTraining.forward.question_positions",description:`<strong>question_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_questions)</code>, <em>optional</em>) &#x2014;
The positions of all question tokens. If given, start_logits and end_logits will be of shape <code>(batch_size, num_questions, sequence_length)</code>. If None, the first question token in each sequence in the batch will be
the only one for which start_logits and end_logits are calculated and they will be of shape <code>(batch_size, sequence_length)</code>.`,name:"question_positions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/splinter/modeling_splinter.py#L1004"}}),de=new fo({props:{$$slots:{default:[Ms]},$$scope:{ctx:x}}}),{c(){l=o("meta"),T=r(),u=o("p"),f=r(),w=o("h1"),c=o("a"),$=o("span"),g(_e.$$.fragment),Tn=r(),Re=o("span"),Re.textContent=ko,Qt=r(),E=o("h2"),R=o("a"),Pt=o("span"),g(ke.$$.fragment),Sn=r(),Xe=o("span"),Xe.textContent=vo,Gt=r(),ve=o("p"),ve.innerHTML=bo,Ot=r(),be=o("p"),be.textContent=yo,Dt=r(),ye=o("p"),ye.textContent=wo,Rt=r(),we=o("p"),we.textContent=To,Xt=r(),Te=o("ul"),Te.innerHTML=So,Vt=r(),Se=o("p"),Se.innerHTML=$o,Yt=r(),J=o("h2"),X=o("a"),Lt=o("span"),g($e.$$.fragment),$n=r(),Ve=o("span"),Ve.textContent=xo,Kt=r(),xe=o("ul"),xe.innerHTML=Mo,en=r(),H=o("h2"),V=o("a"),It=o("span"),g(Me.$$.fragment),xn=r(),Ye=o("span"),Ye.textContent=zo,tn=r(),q=o("div"),g(ze.$$.fragment),Mn=r(),Ke=o("p"),Ke.innerHTML=qo,zn=r(),et=o("p"),et.innerHTML=Co,qn=r(),g(Y.$$.fragment),nn=r(),B=o("h2"),K=o("a"),At=o("span"),g(qe.$$.fragment),Cn=r(),tt=o("span"),tt.textContent=Fo,on=r(),S=o("div"),g(Ce.$$.fragment),Fn=r(),nt=o("p"),nt.textContent=Po,Pn=r(),ot=o("p"),ot.innerHTML=Lo,Ln=r(),j=o("div"),g(Fe.$$.fragment),In=r(),st=o("p"),st.textContent=Io,An=r(),rt=o("ul"),rt.innerHTML=Ao,jn=r(),ee=o("div"),g(Pe.$$.fragment),Nn=r(),at=o("p"),at.innerHTML=jo,Un=r(),N=o("div"),g(Le.$$.fragment),Wn=r(),it=o("p"),it.innerHTML=No,En=r(),lt=o("p"),lt.textContent=Uo,Jn=r(),dt=o("div"),g(Ie.$$.fragment),sn=r(),Z=o("h2"),te=o("a"),jt=o("span"),g(Ae.$$.fragment),Hn=r(),ct=o("span"),ct.textContent=Wo,rn=r(),C=o("div"),g(je.$$.fragment),Bn=r(),pt=o("p"),pt.innerHTML=Eo,Zn=r(),ht=o("p"),ht.innerHTML=Jo,Qn=r(),U=o("div"),g(Ne.$$.fragment),Gn=r(),mt=o("p"),mt.textContent=Ho,On=r(),ut=o("ul"),ut.innerHTML=Bo,an=r(),Q=o("h2"),ne=o("a"),Nt=o("span"),g(Ue.$$.fragment),Dn=r(),ft=o("span"),ft.textContent=Zo,ln=r(),F=o("div"),g(We.$$.fragment),Rn=r(),gt=o("p"),gt.innerHTML=Qo,Xn=r(),_t=o("p"),_t.innerHTML=Go,Vn=r(),I=o("div"),g(Ee.$$.fragment),Yn=r(),kt=o("p"),kt.innerHTML=Oo,Kn=r(),g(oe.$$.fragment),eo=r(),g(se.$$.fragment),dn=r(),G=o("h2"),re=o("a"),Ut=o("span"),g(Je.$$.fragment),to=r(),vt=o("span"),vt.textContent=Do,cn=r(),P=o("div"),g(He.$$.fragment),no=r(),bt=o("p"),bt.innerHTML=Ro,oo=r(),yt=o("p"),yt.innerHTML=Xo,so=r(),A=o("div"),g(Be.$$.fragment),ro=r(),wt=o("p"),wt.innerHTML=Vo,ao=r(),g(ae.$$.fragment),io=r(),g(ie.$$.fragment),pn=r(),O=o("h2"),le=o("a"),Wt=o("span"),g(Ze.$$.fragment),lo=r(),Tt=o("span"),Tt.textContent=Yo,hn=r(),L=o("div"),g(Qe.$$.fragment),co=r(),St=o("p"),St.textContent=Ko,po=r(),$t=o("p"),$t.innerHTML=es,ho=r(),W=o("div"),g(Ge.$$.fragment),mo=r(),xt=o("p"),xt.innerHTML=ts,uo=r(),g(de.$$.fragment),mn=r(),Et=o("p"),this.h()},l(e){const i=ys("svelte-1phssyn",document.head);l=s(i,"META",{name:!0,content:!0}),i.forEach(n),T=a(e),u=s(e,"P",{}),m(u).forEach(n),f=a(e),w=s(e,"H1",{class:!0});var Oe=m(w);c=s(Oe,"A",{id:!0,class:!0,href:!0});var Jt=m(c);$=s(Jt,"SPAN",{});var Ht=m($);_(_e.$$.fragment,Ht),Ht.forEach(n),Jt.forEach(n),Tn=a(Oe),Re=s(Oe,"SPAN",{"data-svelte-h":!0}),h(Re)!=="svelte-1t9rgtm"&&(Re.textContent=ko),Oe.forEach(n),Qt=a(e),E=s(e,"H2",{class:!0});var De=m(E);R=s(De,"A",{id:!0,class:!0,href:!0});var Bt=m(R);Pt=s(Bt,"SPAN",{});var Zt=m(Pt);_(ke.$$.fragment,Zt),Zt.forEach(n),Bt.forEach(n),Sn=a(De),Xe=s(De,"SPAN",{"data-svelte-h":!0}),h(Xe)!=="svelte-1jsw1pg"&&(Xe.textContent=vo),De.forEach(n),Gt=a(e),ve=s(e,"P",{"data-svelte-h":!0}),h(ve)!=="svelte-1nfobji"&&(ve.innerHTML=bo),Ot=a(e),be=s(e,"P",{"data-svelte-h":!0}),h(be)!=="svelte-vfdo9a"&&(be.textContent=yo),Dt=a(e),ye=s(e,"P",{"data-svelte-h":!0}),h(ye)!=="svelte-m8m8di"&&(ye.textContent=wo),Rt=a(e),we=s(e,"P",{"data-svelte-h":!0}),h(we)!=="svelte-axv494"&&(we.textContent=To),Xt=a(e),Te=s(e,"UL",{"data-svelte-h":!0}),h(Te)!=="svelte-1gja5d7"&&(Te.innerHTML=So),Vt=a(e),Se=s(e,"P",{"data-svelte-h":!0}),h(Se)!=="svelte-1hzgtbk"&&(Se.innerHTML=$o),Yt=a(e),J=s(e,"H2",{class:!0});var fn=m(J);X=s(fn,"A",{id:!0,class:!0,href:!0});var ns=m(X);Lt=s(ns,"SPAN",{});var os=m(Lt);_($e.$$.fragment,os),os.forEach(n),ns.forEach(n),$n=a(fn),Ve=s(fn,"SPAN",{"data-svelte-h":!0}),h(Ve)!=="svelte-n3f0j0"&&(Ve.textContent=xo),fn.forEach(n),Kt=a(e),xe=s(e,"UL",{"data-svelte-h":!0}),h(xe)!=="svelte-1orm8os"&&(xe.innerHTML=Mo),en=a(e),H=s(e,"H2",{class:!0});var gn=m(H);V=s(gn,"A",{id:!0,class:!0,href:!0});var ss=m(V);It=s(ss,"SPAN",{});var rs=m(It);_(Me.$$.fragment,rs),rs.forEach(n),ss.forEach(n),xn=a(gn),Ye=s(gn,"SPAN",{"data-svelte-h":!0}),h(Ye)!=="svelte-8jruu4"&&(Ye.textContent=zo),gn.forEach(n),tn=a(e),q=s(e,"DIV",{class:!0});var ce=m(q);_(ze.$$.fragment,ce),Mn=a(ce),Ke=s(ce,"P",{"data-svelte-h":!0}),h(Ke)!=="svelte-1i9gchy"&&(Ke.innerHTML=qo),zn=a(ce),et=s(ce,"P",{"data-svelte-h":!0}),h(et)!=="svelte-cfh5wl"&&(et.innerHTML=Co),qn=a(ce),_(Y.$$.fragment,ce),ce.forEach(n),nn=a(e),B=s(e,"H2",{class:!0});var _n=m(B);K=s(_n,"A",{id:!0,class:!0,href:!0});var as=m(K);At=s(as,"SPAN",{});var is=m(At);_(qe.$$.fragment,is),is.forEach(n),as.forEach(n),Cn=a(_n),tt=s(_n,"SPAN",{"data-svelte-h":!0}),h(tt)!=="svelte-t0pomt"&&(tt.textContent=Fo),_n.forEach(n),on=a(e),S=s(e,"DIV",{class:!0});var M=m(S);_(Ce.$$.fragment,M),Fn=a(M),nt=s(M,"P",{"data-svelte-h":!0}),h(nt)!=="svelte-1auu3gg"&&(nt.textContent=Po),Pn=a(M),ot=s(M,"P",{"data-svelte-h":!0}),h(ot)!=="svelte-14xlfoy"&&(ot.innerHTML=Lo),Ln=a(M),j=s(M,"DIV",{class:!0});var Mt=m(j);_(Fe.$$.fragment,Mt),In=a(Mt),st=s(Mt,"P",{"data-svelte-h":!0}),h(st)!=="svelte-1di5c8i"&&(st.textContent=Io),An=a(Mt),rt=s(Mt,"UL",{"data-svelte-h":!0}),h(rt)!=="svelte-18p1y68"&&(rt.innerHTML=Ao),Mt.forEach(n),jn=a(M),ee=s(M,"DIV",{class:!0});var kn=m(ee);_(Pe.$$.fragment,kn),Nn=a(kn),at=s(kn,"P",{"data-svelte-h":!0}),h(at)!=="svelte-1f4f5kp"&&(at.innerHTML=jo),kn.forEach(n),Un=a(M),N=s(M,"DIV",{class:!0});var zt=m(N);_(Le.$$.fragment,zt),Wn=a(zt),it=s(zt,"P",{"data-svelte-h":!0}),h(it)!=="svelte-zj1vf1"&&(it.innerHTML=No),En=a(zt),lt=s(zt,"P",{"data-svelte-h":!0}),h(lt)!=="svelte-9vptpw"&&(lt.textContent=Uo),zt.forEach(n),Jn=a(M),dt=s(M,"DIV",{class:!0});var ls=m(dt);_(Ie.$$.fragment,ls),ls.forEach(n),M.forEach(n),sn=a(e),Z=s(e,"H2",{class:!0});var vn=m(Z);te=s(vn,"A",{id:!0,class:!0,href:!0});var ds=m(te);jt=s(ds,"SPAN",{});var cs=m(jt);_(Ae.$$.fragment,cs),cs.forEach(n),ds.forEach(n),Hn=a(vn),ct=s(vn,"SPAN",{"data-svelte-h":!0}),h(ct)!=="svelte-1v9en8v"&&(ct.textContent=Wo),vn.forEach(n),rn=a(e),C=s(e,"DIV",{class:!0});var pe=m(C);_(je.$$.fragment,pe),Bn=a(pe),pt=s(pe,"P",{"data-svelte-h":!0}),h(pt)!=="svelte-t7sr0h"&&(pt.innerHTML=Eo),Zn=a(pe),ht=s(pe,"P",{"data-svelte-h":!0}),h(ht)!=="svelte-10uwgx2"&&(ht.innerHTML=Jo),Qn=a(pe),U=s(pe,"DIV",{class:!0});var qt=m(U);_(Ne.$$.fragment,qt),Gn=a(qt),mt=s(qt,"P",{"data-svelte-h":!0}),h(mt)!=="svelte-1di5c8i"&&(mt.textContent=Ho),On=a(qt),ut=s(qt,"UL",{"data-svelte-h":!0}),h(ut)!=="svelte-18p1y68"&&(ut.innerHTML=Bo),qt.forEach(n),pe.forEach(n),an=a(e),Q=s(e,"H2",{class:!0});var bn=m(Q);ne=s(bn,"A",{id:!0,class:!0,href:!0});var ps=m(ne);Nt=s(ps,"SPAN",{});var hs=m(Nt);_(Ue.$$.fragment,hs),hs.forEach(n),ps.forEach(n),Dn=a(bn),ft=s(bn,"SPAN",{"data-svelte-h":!0}),h(ft)!=="svelte-uzymmt"&&(ft.textContent=Zo),bn.forEach(n),ln=a(e),F=s(e,"DIV",{class:!0});var he=m(F);_(We.$$.fragment,he),Rn=a(he),gt=s(he,"P",{"data-svelte-h":!0}),h(gt)!=="svelte-mflokx"&&(gt.innerHTML=Qo),Xn=a(he),_t=s(he,"P",{"data-svelte-h":!0}),h(_t)!=="svelte-ocipx3"&&(_t.innerHTML=Go),Vn=a(he),I=s(he,"DIV",{class:!0});var me=m(I);_(Ee.$$.fragment,me),Yn=a(me),kt=s(me,"P",{"data-svelte-h":!0}),h(kt)!=="svelte-wfcgk"&&(kt.innerHTML=Oo),Kn=a(me),_(oe.$$.fragment,me),eo=a(me),_(se.$$.fragment,me),me.forEach(n),he.forEach(n),dn=a(e),G=s(e,"H2",{class:!0});var yn=m(G);re=s(yn,"A",{id:!0,class:!0,href:!0});var ms=m(re);Ut=s(ms,"SPAN",{});var us=m(Ut);_(Je.$$.fragment,us),us.forEach(n),ms.forEach(n),to=a(yn),vt=s(yn,"SPAN",{"data-svelte-h":!0}),h(vt)!=="svelte-1jctdrj"&&(vt.textContent=Do),yn.forEach(n),cn=a(e),P=s(e,"DIV",{class:!0});var ue=m(P);_(He.$$.fragment,ue),no=a(ue),bt=s(ue,"P",{"data-svelte-h":!0}),h(bt)!=="svelte-cet2uw"&&(bt.innerHTML=Ro),oo=a(ue),yt=s(ue,"P",{"data-svelte-h":!0}),h(yt)!=="svelte-68lg8f"&&(yt.innerHTML=Xo),so=a(ue),A=s(ue,"DIV",{class:!0});var fe=m(A);_(Be.$$.fragment,fe),ro=a(fe),wt=s(fe,"P",{"data-svelte-h":!0}),h(wt)!=="svelte-h799fg"&&(wt.innerHTML=Vo),ao=a(fe),_(ae.$$.fragment,fe),io=a(fe),_(ie.$$.fragment,fe),fe.forEach(n),ue.forEach(n),pn=a(e),O=s(e,"H2",{class:!0});var wn=m(O);le=s(wn,"A",{id:!0,class:!0,href:!0});var fs=m(le);Wt=s(fs,"SPAN",{});var gs=m(Wt);_(Ze.$$.fragment,gs),gs.forEach(n),fs.forEach(n),lo=a(wn),Tt=s(wn,"SPAN",{"data-svelte-h":!0}),h(Tt)!=="svelte-rrnt4"&&(Tt.textContent=Yo),wn.forEach(n),hn=a(e),L=s(e,"DIV",{class:!0});var ge=m(L);_(Qe.$$.fragment,ge),co=a(ge),St=s(ge,"P",{"data-svelte-h":!0}),h(St)!=="svelte-1fwuwic"&&(St.textContent=Ko),po=a(ge),$t=s(ge,"P",{"data-svelte-h":!0}),h($t)!=="svelte-68lg8f"&&($t.innerHTML=es),ho=a(ge),W=s(ge,"DIV",{class:!0});var Ct=m(W);_(Ge.$$.fragment,Ct),mo=a(Ct),xt=s(Ct,"P",{"data-svelte-h":!0}),h(xt)!=="svelte-4f1xnu"&&(xt.innerHTML=ts),uo=a(Ct),_(de.$$.fragment,Ct),Ct.forEach(n),ge.forEach(n),mn=a(e),Et=s(e,"P",{}),m(Et).forEach(n),this.h()},h(){p(l,"name","hf:doc:metadata"),p(l,"content",JSON.stringify(qs)),p(c,"id","splinter"),p(c,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(c,"href","#splinter"),p(w,"class","relative group"),p(R,"id","overview"),p(R,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(R,"href","#overview"),p(E,"class","relative group"),p(X,"id","documentation-resources"),p(X,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(X,"href","#documentation-resources"),p(J,"class","relative group"),p(V,"id","transformers.SplinterConfig"),p(V,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(V,"href","#transformers.SplinterConfig"),p(H,"class","relative group"),p(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(K,"id","transformers.SplinterTokenizer"),p(K,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(K,"href","#transformers.SplinterTokenizer"),p(B,"class","relative group"),p(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(dt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(te,"id","transformers.SplinterTokenizerFast"),p(te,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(te,"href","#transformers.SplinterTokenizerFast"),p(Z,"class","relative group"),p(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(ne,"id","transformers.SplinterModel"),p(ne,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(ne,"href","#transformers.SplinterModel"),p(Q,"class","relative group"),p(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(re,"id","transformers.SplinterForQuestionAnswering"),p(re,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(re,"href","#transformers.SplinterForQuestionAnswering"),p(G,"class","relative group"),p(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(le,"id","transformers.SplinterForPreTraining"),p(le,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(le,"href","#transformers.SplinterForPreTraining"),p(O,"class","relative group"),p(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,i){t(document.head,l),d(e,T,i),d(e,u,i),d(e,f,i),d(e,w,i),t(w,c),t(c,$),k(_e,$,null),t(w,Tn),t(w,Re),d(e,Qt,i),d(e,E,i),t(E,R),t(R,Pt),k(ke,Pt,null),t(E,Sn),t(E,Xe),d(e,Gt,i),d(e,ve,i),d(e,Ot,i),d(e,be,i),d(e,Dt,i),d(e,ye,i),d(e,Rt,i),d(e,we,i),d(e,Xt,i),d(e,Te,i),d(e,Vt,i),d(e,Se,i),d(e,Yt,i),d(e,J,i),t(J,X),t(X,Lt),k($e,Lt,null),t(J,$n),t(J,Ve),d(e,Kt,i),d(e,xe,i),d(e,en,i),d(e,H,i),t(H,V),t(V,It),k(Me,It,null),t(H,xn),t(H,Ye),d(e,tn,i),d(e,q,i),k(ze,q,null),t(q,Mn),t(q,Ke),t(q,zn),t(q,et),t(q,qn),k(Y,q,null),d(e,nn,i),d(e,B,i),t(B,K),t(K,At),k(qe,At,null),t(B,Cn),t(B,tt),d(e,on,i),d(e,S,i),k(Ce,S,null),t(S,Fn),t(S,nt),t(S,Pn),t(S,ot),t(S,Ln),t(S,j),k(Fe,j,null),t(j,In),t(j,st),t(j,An),t(j,rt),t(S,jn),t(S,ee),k(Pe,ee,null),t(ee,Nn),t(ee,at),t(S,Un),t(S,N),k(Le,N,null),t(N,Wn),t(N,it),t(N,En),t(N,lt),t(S,Jn),t(S,dt),k(Ie,dt,null),d(e,sn,i),d(e,Z,i),t(Z,te),t(te,jt),k(Ae,jt,null),t(Z,Hn),t(Z,ct),d(e,rn,i),d(e,C,i),k(je,C,null),t(C,Bn),t(C,pt),t(C,Zn),t(C,ht),t(C,Qn),t(C,U),k(Ne,U,null),t(U,Gn),t(U,mt),t(U,On),t(U,ut),d(e,an,i),d(e,Q,i),t(Q,ne),t(ne,Nt),k(Ue,Nt,null),t(Q,Dn),t(Q,ft),d(e,ln,i),d(e,F,i),k(We,F,null),t(F,Rn),t(F,gt),t(F,Xn),t(F,_t),t(F,Vn),t(F,I),k(Ee,I,null),t(I,Yn),t(I,kt),t(I,Kn),k(oe,I,null),t(I,eo),k(se,I,null),d(e,dn,i),d(e,G,i),t(G,re),t(re,Ut),k(Je,Ut,null),t(G,to),t(G,vt),d(e,cn,i),d(e,P,i),k(He,P,null),t(P,no),t(P,bt),t(P,oo),t(P,yt),t(P,so),t(P,A),k(Be,A,null),t(A,ro),t(A,wt),t(A,ao),k(ae,A,null),t(A,io),k(ie,A,null),d(e,pn,i),d(e,O,i),t(O,le),t(le,Wt),k(Ze,Wt,null),t(O,lo),t(O,Tt),d(e,hn,i),d(e,L,i),k(Qe,L,null),t(L,co),t(L,St),t(L,po),t(L,$t),t(L,ho),t(L,W),k(Ge,W,null),t(W,mo),t(W,xt),t(W,uo),k(de,W,null),d(e,mn,i),d(e,Et,i),un=!0},p(e,[i]){const Oe={};i&2&&(Oe.$$scope={dirty:i,ctx:e}),Y.$set(Oe);const Jt={};i&2&&(Jt.$$scope={dirty:i,ctx:e}),oe.$set(Jt);const Ht={};i&2&&(Ht.$$scope={dirty:i,ctx:e}),se.$set(Ht);const De={};i&2&&(De.$$scope={dirty:i,ctx:e}),ae.$set(De);const Bt={};i&2&&(Bt.$$scope={dirty:i,ctx:e}),ie.$set(Bt);const Zt={};i&2&&(Zt.$$scope={dirty:i,ctx:e}),de.$set(Zt)},i(e){un||(v(_e.$$.fragment,e),v(ke.$$.fragment,e),v($e.$$.fragment,e),v(Me.$$.fragment,e),v(ze.$$.fragment,e),v(Y.$$.fragment,e),v(qe.$$.fragment,e),v(Ce.$$.fragment,e),v(Fe.$$.fragment,e),v(Pe.$$.fragment,e),v(Le.$$.fragment,e),v(Ie.$$.fragment,e),v(Ae.$$.fragment,e),v(je.$$.fragment,e),v(Ne.$$.fragment,e),v(Ue.$$.fragment,e),v(We.$$.fragment,e),v(Ee.$$.fragment,e),v(oe.$$.fragment,e),v(se.$$.fragment,e),v(Je.$$.fragment,e),v(He.$$.fragment,e),v(Be.$$.fragment,e),v(ae.$$.fragment,e),v(ie.$$.fragment,e),v(Ze.$$.fragment,e),v(Qe.$$.fragment,e),v(Ge.$$.fragment,e),v(de.$$.fragment,e),un=!0)},o(e){b(_e.$$.fragment,e),b(ke.$$.fragment,e),b($e.$$.fragment,e),b(Me.$$.fragment,e),b(ze.$$.fragment,e),b(Y.$$.fragment,e),b(qe.$$.fragment,e),b(Ce.$$.fragment,e),b(Fe.$$.fragment,e),b(Pe.$$.fragment,e),b(Le.$$.fragment,e),b(Ie.$$.fragment,e),b(Ae.$$.fragment,e),b(je.$$.fragment,e),b(Ne.$$.fragment,e),b(Ue.$$.fragment,e),b(We.$$.fragment,e),b(Ee.$$.fragment,e),b(oe.$$.fragment,e),b(se.$$.fragment,e),b(Je.$$.fragment,e),b(He.$$.fragment,e),b(Be.$$.fragment,e),b(ae.$$.fragment,e),b(ie.$$.fragment,e),b(Ze.$$.fragment,e),b(Qe.$$.fragment,e),b(Ge.$$.fragment,e),b(de.$$.fragment,e),un=!1},d(e){e&&(n(T),n(u),n(f),n(w),n(Qt),n(E),n(Gt),n(ve),n(Ot),n(be),n(Dt),n(ye),n(Rt),n(we),n(Xt),n(Te),n(Vt),n(Se),n(Yt),n(J),n(Kt),n(xe),n(en),n(H),n(tn),n(q),n(nn),n(B),n(on),n(S),n(sn),n(Z),n(rn),n(C),n(an),n(Q),n(ln),n(F),n(dn),n(G),n(cn),n(P),n(pn),n(O),n(hn),n(L),n(mn),n(Et)),n(l),y(_e),y(ke),y($e),y(Me),y(ze),y(Y),y(qe),y(Ce),y(Fe),y(Pe),y(Le),y(Ie),y(Ae),y(je),y(Ne),y(Ue),y(We),y(Ee),y(oe),y(se),y(Je),y(He),y(Be),y(ae),y(ie),y(Ze),y(Qe),y(Ge),y(de)}}}const qs={local:"splinter",sections:[{local:"overview",title:"Overview"},{local:"documentation-resources",title:"Documentation resources"},{local:"transformers.SplinterConfig",title:"SplinterConfig"},{local:"transformers.SplinterTokenizer",title:"SplinterTokenizer"},{local:"transformers.SplinterTokenizerFast",title:"SplinterTokenizerFast"},{local:"transformers.SplinterModel",title:"SplinterModel"},{local:"transformers.SplinterForQuestionAnswering",title:"SplinterForQuestionAnswering"},{local:"transformers.SplinterForPreTraining",title:"SplinterForPreTraining"}],title:"Splinter"};function Cs(x){return ks(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Us extends vs{constructor(l){super(),bs(this,l,Cs,zs,_s,{})}}export{Us as component};
