import{s as fa,n as Ma,o as ba}from"../chunks/scheduler.d586627e.js";import{S as va,i as ya,g as s,s as o,u,A as Ja,h as n,f as t,c as i,j as p,v as c,y as r,k as m,o as d,a,w as g,d as h,t as f,x as M}from"../chunks/index.b757c891.js";import{I}from"../chunks/IconCopyLink.c074b82b.js";import{C as b}from"../chunks/CodeBlock.36019a2e.js";import{D as Ta}from"../chunks/DocNotebookDropdown.6b8c1d89.js";function Ua(gl){let v,Ke,He,Oe,y,_,qe,R,ol,ze,hl="Modelos multilinguísticos para inferência",et,W,tt,V,fl=`Existem vários modelos multilinguísticos no 🤗 Transformers e seus usos para inferência diferem dos modelos monolíngues.
No entanto, nem <em>todos</em> os usos dos modelos multilíngues são tão diferentes.
Alguns modelos, como o <a href="https://huggingface.co/bert-base-multilingual-uncased" rel="nofollow">bert-base-multilingual-uncased</a>,
podem ser usados como se fossem monolíngues. Este guia irá te ajudar a usar modelos multilíngues cujo uso difere
para o propósito de inferência.`,lt,J,j,Ne,L,il,Ge,Ml="XLM",at,B,bl=`O XLM tem dez checkpoints diferentes dos quais apenas um é monolíngue.
Os nove checkpoints restantes do modelo são subdivididos em duas categorias:
checkpoints que usam de language embeddings e os que não.`,st,T,C,Fe,H,rl,Ie,vl="XLM com language embeddings",nt,q,yl="Os seguintes modelos de XLM usam language embeddings para especificar a linguagem utilizada para a inferência.",ot,N,Jl="<li><code>xlm-mlm-ende-1024</code> (Masked language modeling, English-German)</li> <li><code>xlm-mlm-enfr-1024</code> (Masked language modeling, English-French)</li> <li><code>xlm-mlm-enro-1024</code> (Masked language modeling, English-Romanian)</li> <li><code>xlm-mlm-xnli15-1024</code> (Masked language modeling, XNLI languages)</li> <li><code>xlm-mlm-tlm-xnli15-1024</code> (Masked language modeling + translation, XNLI languages)</li> <li><code>xlm-clm-enfr-1024</code> (Causal language modeling, English-French)</li> <li><code>xlm-clm-ende-1024</code> (Causal language modeling, English-German)</li>",it,F,Tl=`Os language embeddings são representados por um tensor de mesma dimensão que os <code>input_ids</code> passados ao modelo.
Os valores destes tensores dependem do idioma utilizado e se identificam pelos atributos <code>lang2id</code> e <code>id2lang</code> do tokenizador.`,rt,P,Ul="Neste exemplo, carregamos o checkpoint <code>xlm-clm-enfr-1024</code>(Causal language modeling, English-French):",mt,Q,dt,A,xl="O atributo <code>lang2id</code> do tokenizador mostra os idiomas deste modelo e seus ids:",pt,Y,ut,S,wl="Em seguida, cria-se um input de exemplo:",ct,D,gt,K,kl=`Estabelece-se o id do idioma, por exemplo <code>&quot;en&quot;</code>, e utiliza-se o mesmo para definir a language embedding.
A language embedding é um tensor preenchido com <code>0</code>, que é o id de idioma para o inglês.
Este tensor deve ser do mesmo tamanho que os <code>input_ids</code>.`,ht,O,ft,ee,$l="Agora você pode passar os <code>input_ids</code> e a language embedding ao modelo:",Mt,te,bt,le,_l='O script <a href="https://github.com/huggingface/transformers/tree/master/examples/pytorch/text-generation/run_generation.py" rel="nofollow">run_generation.py</a> pode gerar um texto com language embeddings utilizando os checkpoints <code>xlm-clm</code>.',vt,U,Z,Pe,ae,ml,Re,jl="XLM sem language embeddings",yt,se,Cl="Os seguintes modelos XLM não requerem o uso de language embeddings durante a inferência:",Jt,ne,Zl="<li><code>xlm-mlm-17-1280</code> (Modelagem de linguagem com máscara, 17 idiomas)</li> <li><code>xlm-mlm-100-1280</code> (Modelagem de linguagem com máscara, 100 idiomas)</li>",Tt,oe,Xl="Estes modelos são utilizados para representações genéricas de frase diferentemente dos checkpoints XLM anteriores.",Ut,x,X,Qe,ie,dl,We,El="BERT",xt,re,zl="Os seguintes modelos do BERT podem ser utilizados para tarefas multilinguísticas:",wt,me,Gl="<li><code>bert-base-multilingual-uncased</code> (Modelagem de linguagem com máscara + Previsão de frases, 102 idiomas)</li> <li><code>bert-base-multilingual-cased</code> (Modelagem de linguagem com máscara + Previsão de frases, 104 idiomas)</li>",kt,de,Il=`Estes modelos não requerem language embeddings durante a inferência. Devem identificar a linguagem a partir
do contexto e realizar a inferência em sequência.`,$t,w,E,Ae,pe,pl,Ve,Rl="XLM-RoBERTa",_t,ue,Wl="Os seguintes modelos do XLM-RoBERTa podem ser utilizados para tarefas multilinguísticas:",jt,ce,Vl="<li><code>xlm-roberta-base</code> (Modelagem de linguagem com máscara, 100 idiomas)</li> <li><code>xlm-roberta-large</code> Modelagem de linguagem com máscara, 100 idiomas)</li>",Ct,ge,Ll=`O XLM-RoBERTa foi treinado com 2,5 TB de dados do CommonCrawl recém-criados e testados em 100 idiomas.
Proporciona fortes vantagens sobre os modelos multilinguísticos publicados anteriormente como o mBERT e o XLM em tarefas
subsequentes como a classificação, a rotulagem de sequências e à respostas a perguntas.`,Zt,k,z,Ye,he,ul,Le,Bl="M2M100",Xt,fe,Hl="Os seguintes modelos de M2M100 podem ser utilizados para traduções multilinguísticas:",Et,Me,ql="<li><code>facebook/m2m100_418M</code> (Tradução)</li> <li><code>facebook/m2m100_1.2B</code> (Tradução)</li>",zt,be,Nl=`Neste exemplo, o checkpoint <code>facebook/m2m100_418M</code> é carregado para traduzir do mandarim ao inglês. É possível
estabelecer o idioma de origem no tokenizador:`,Gt,ve,It,ye,Fl="Tokenização do texto:",Rt,Je,Wt,Te,Pl=`O M2M100 força o id do idioma de destino como o primeiro token gerado para traduzir ao idioma de destino.
É definido o <code>forced_bos_token_id</code> como <code>en</code> no método <code>generate</code> para traduzir ao inglês.`,Vt,Ue,Lt,$,G,Se,xe,cl,Be,Ql="MBart",Bt,we,Al="Os seguintes modelos do MBart podem ser utilizados para tradução multilinguística:",Ht,ke,Yl="<li><code>facebook/mbart-large-50-one-to-many-mmt</code> (Tradução automática multilinguística de um a vários, 50 idiomas)</li> <li><code>facebook/mbart-large-50-many-to-many-mmt</code> (Tradução automática multilinguística de vários a vários, 50 idiomas)</li> <li><code>facebook/mbart-large-50-many-to-one-mmt</code> (Tradução automática multilinguística vários a um, 50 idiomas)</li> <li><code>facebook/mbart-large-50</code> (Tradução multilinguística, 50 idiomas)</li> <li><code>facebook/mbart-large-cc25</code></li>",qt,$e,Sl=`Neste exemplo, carrega-se o checkpoint <code>facebook/mbart-large-50-many-to-many-mmt</code> para traduzir do finlandês ao inglês.
Pode-se definir o idioma de origem no tokenizador:`,Nt,_e,Ft,je,Dl="Tokenizando o texto:",Pt,Ce,Qt,Ze,Kl=`O MBart força o id do idioma de destino como o primeiro token gerado para traduzir ao idioma de destino.
É definido o <code>forced_bos_token_id</code> como <code>en</code> no método <code>generate</code> para traduzir ao inglês.`,At,Xe,Yt,Ee,Ol=`Se estiver usando o checkpoint <code>facebook/mbart-large-50-many-to-one-mmt</code> não será necessário forçar o id do idioma de destino
como sendo o primeiro token generado, caso contrário a usagem é a mesma.`,St,De,Dt;return R=new I({}),W=new Ta({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/pt/multilingual.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/pt/pytorch/multilingual.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/pt/tensorflow/multilingual.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/pt/multilingual.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/pt/pytorch/multilingual.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/pt/tensorflow/multilingual.ipynb"}]}}),L=new I({}),H=new I({}),Q=new b({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwWExNVG9rZW5pemVyJTJDJTIwWExNV2l0aExNSGVhZE1vZGVsJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwWExNVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJ4bG0tY2xtLWVuZnItMTAyNCUyMiklMEFtb2RlbCUyMCUzRCUyMFhMTVdpdGhMTUhlYWRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyeGxtLWNsbS1lbmZyLTEwMjQlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> XLMTokenizer, XLMWithLMHeadModel

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = XLMTokenizer.from_pretrained(<span class="hljs-string">&quot;xlm-clm-enfr-1024&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = XLMWithLMHeadModel.from_pretrained(<span class="hljs-string">&quot;xlm-clm-enfr-1024&quot;</span>)`}}),Y=new b({props:{code:"cHJpbnQodG9rZW5pemVyLmxhbmcyaWQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.lang2id)
{<span class="hljs-string">&#x27;en&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;fr&#x27;</span>: <span class="hljs-number">1</span>}`}}),D=new b({props:{code:"aW5wdXRfaWRzJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QnRva2VuaXplci5lbmNvZGUoJTIyV2lraXBlZGlhJTIwd2FzJTIwdXNlZCUyMHRvJTIyKSU1RCklMjAlMjAlMjMlMjBiYXRjaCUyMHNpemUlMjBvZiUyMDE=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = torch.tensor([tokenizer.encode(<span class="hljs-string">&quot;Wikipedia was used to&quot;</span>)])  <span class="hljs-comment"># batch size of 1</span>'}}),O=new b({props:{code:"bGFuZ3VhZ2VfaWQlMjAlM0QlMjB0b2tlbml6ZXIubGFuZzJpZCU1QiUyMmVuJTIyJTVEJTIwJTIwJTIzJTIwMCUwQWxhbmdzJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1Qmxhbmd1YWdlX2lkJTVEJTIwKiUyMGlucHV0X2lkcy5zaGFwZSU1QjElNUQpJTIwJTIwJTIzJTIwdG9yY2gudGVuc29yKCU1QjAlMkMlMjAwJTJDJTIwMCUyQyUyMC4uLiUyQyUyMDAlNUQpJTBBJTBBJTIzJTIwV2UlMjByZXNoYXBlJTIwaXQlMjB0byUyMGJlJTIwb2YlMjBzaXplJTIwKGJhdGNoX3NpemUlMkMlMjBzZXF1ZW5jZV9sZW5ndGgpJTBBbGFuZ3MlMjAlM0QlMjBsYW5ncy52aWV3KDElMkMlMjAtMSklMjAlMjAlMjMlMjBpcyUyMG5vdyUyMG9mJTIwc2hhcGUlMjAlNUIxJTJDJTIwc2VxdWVuY2VfbGVuZ3RoJTVEJTIwKHdlJTIwaGF2ZSUyMGElMjBiYXRjaCUyMHNpemUlMjBvZiUyMDEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>language_id = tokenizer.lang2id[<span class="hljs-string">&quot;en&quot;</span>]  <span class="hljs-comment"># 0</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>langs = torch.tensor([language_id] * input_ids.shape[<span class="hljs-number">1</span>])  <span class="hljs-comment"># torch.tensor([0, 0, 0, ..., 0])</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We reshape it to be of size (batch_size, sequence_length)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>langs = langs.view(<span class="hljs-number">1</span>, -<span class="hljs-number">1</span>)  <span class="hljs-comment"># is now of shape [1, sequence_length] (we have a batch size of 1)</span>`}}),te=new b({props:{code:"b3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0X2lkcyUyQyUyMGxhbmdzJTNEbGFuZ3Mp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(input_ids, langs=langs)'}}),ae=new I({}),ie=new I({}),pe=new I({}),he=new I({}),ve=new b({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME0yTTEwMEZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUyQyUyME0yTTEwMFRva2VuaXplciUwQSUwQWVuX3RleHQlMjAlM0QlMjAlMjJEbyUyMG5vdCUyMG1lZGRsZSUyMGluJTIwdGhlJTIwYWZmYWlycyUyMG9mJTIwd2l6YXJkcyUyQyUyMGZvciUyMHRoZXklMjBhcmUlMjBzdWJ0bGUlMjBhbmQlMjBxdWljayUyMHRvJTIwYW5nZXIuJTIyJTBBY2hpbmVzZV90ZXh0JTIwJTNEJTIwJTIyJUU0JUI4JThEJUU4JUE2JTgxJUU2JThGJTkyJUU2JTg5JThCJUU1JUI3JUFCJUU1JUI4JUFCJUU3JTlBJTg0JUU0JUJBJThCJUU1JThCJTk5JTJDJTIwJUU1JTlCJUEwJUU3JTgyJUJBJUU0JUJCJTk2JUU1JTgwJTkxJUU2JTk4JUFGJUU1JUJFJUFFJUU1JUE2JTk5JUU3JTlBJTg0JTJDJTIwJUU1JUJFJTg4JUU1JUJGJUFCJUU1JUIwJUIxJUU2JTlDJTgzJUU3JTk5JUJDJUU2JTgwJTkyLiUyMiUwQSUwQXRva2VuaXplciUyMCUzRCUyME0yTTEwMFRva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtMm0xMDBfNDE4TSUyMiUyQyUyMHNyY19sYW5nJTNEJTIyemglMjIpJTBBbW9kZWwlMjAlM0QlMjBNMk0xMDBGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbTJtMTAwXzQxOE0lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> M2M100ForConditionalGeneration, M2M100Tokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>en_text = <span class="hljs-string">&quot;Do not meddle in the affairs of wizards, for they are subtle and quick to anger.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>chinese_text = <span class="hljs-string">&quot;不要插手巫師的事務, 因為他們是微妙的, 很快就會發怒.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = M2M100Tokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/m2m100_418M&quot;</span>, src_lang=<span class="hljs-string">&quot;zh&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = M2M100ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/m2m100_418M&quot;</span>)`}}),Je=new b({props:{code:"ZW5jb2RlZF96aCUyMCUzRCUyMHRva2VuaXplcihjaGluZXNlX3RleHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_zh = tokenizer(chinese_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)'}}),Ue=new b({props:{code:"Z2VuZXJhdGVkX3Rva2VucyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqZW5jb2RlZF96aCUyQyUyMGZvcmNlZF9ib3NfdG9rZW5faWQlM0R0b2tlbml6ZXIuZ2V0X2xhbmdfaWQoJTIyZW4lMjIpKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX3Rva2VucyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generated_tokens = model.generate(**encoded_zh, forced_bos_token_id=tokenizer.get_lang_id(<span class="hljs-string">&quot;en&quot;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-string">&#x27;Do not interfere with the matters of the witches, because they are delicate and will soon be angry.&#x27;</span>`}}),xe=new I({}),_e=new b({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JTZXEyU2VxTE0lMEElMEFlbl90ZXh0JTIwJTNEJTIwJTIyRG8lMjBub3QlMjBtZWRkbGUlMjBpbiUyMHRoZSUyMGFmZmFpcnMlMjBvZiUyMHdpemFyZHMlMkMlMjBmb3IlMjB0aGV5JTIwYXJlJTIwc3VidGxlJTIwYW5kJTIwcXVpY2slMjB0byUyMGFuZ2VyLiUyMiUwQWZpX3RleHQlMjAlM0QlMjAlMjIlQzMlODRsJUMzJUE0JTIwc2VrYWFubnUlMjB2ZWxob2plbiUyMGFzaW9paGluJTJDJTIwc2lsbCVDMyVBNCUyMG5lJTIwb3ZhdCUyMGhpZW5vdmFyYWlzaWElMjBqYSUyMG5vcGVhc3RpJTIwdmloYWlzaWEuJTIyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtYmFydC1sYXJnZS01MC1tYW55LXRvLW1hbnktbW10JTIyJTJDJTIwc3JjX2xhbmclM0QlMjJmaV9GSSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtYmFydC1sYXJnZS01MC1tYW55LXRvLW1hbnktbW10JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span>en_text = <span class="hljs-string">&quot;Do not meddle in the affairs of wizards, for they are subtle and quick to anger.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fi_text = <span class="hljs-string">&quot;Älä sekaannu velhojen asioihin, sillä ne ovat hienovaraisia ja nopeasti vihaisia.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/mbart-large-50-many-to-many-mmt&quot;</span>, src_lang=<span class="hljs-string">&quot;fi_FI&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;facebook/mbart-large-50-many-to-many-mmt&quot;</span>)`}}),Ce=new b({props:{code:"ZW5jb2RlZF9lbiUyMCUzRCUyMHRva2VuaXplcihlbl90ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_en = tokenizer(en_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)'}}),Xe=new b({props:{code:"Z2VuZXJhdGVkX3Rva2VucyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqZW5jb2RlZF9lbiUyQyUyMGZvcmNlZF9ib3NfdG9rZW5faWQlM0R0b2tlbml6ZXIubGFuZ19jb2RlX3RvX2lkKCUyMmVuX1hYJTIyKSklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlZF90b2tlbnMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generated_tokens = model.generate(**encoded_en, forced_bos_token_id=tokenizer.lang_code_to_id(<span class="hljs-string">&quot;en_XX&quot;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-string">&quot;Don&#x27;t interfere with the wizard&#x27;s affairs, because they are subtle, will soon get angry.&quot;</span>`}}),{c(){v=s("meta"),Ke=o(),He=s("p"),Oe=o(),y=s("h1"),_=s("a"),qe=s("span"),u(R.$$.fragment),ol=o(),ze=s("span"),ze.textContent=hl,et=o(),u(W.$$.fragment),tt=o(),V=s("p"),V.innerHTML=fl,lt=o(),J=s("h2"),j=s("a"),Ne=s("span"),u(L.$$.fragment),il=o(),Ge=s("span"),Ge.textContent=Ml,at=o(),B=s("p"),B.textContent=bl,st=o(),T=s("h3"),C=s("a"),Fe=s("span"),u(H.$$.fragment),rl=o(),Ie=s("span"),Ie.textContent=vl,nt=o(),q=s("p"),q.textContent=yl,ot=o(),N=s("ul"),N.innerHTML=Jl,it=o(),F=s("p"),F.innerHTML=Tl,rt=o(),P=s("p"),P.innerHTML=Ul,mt=o(),u(Q.$$.fragment),dt=o(),A=s("p"),A.innerHTML=xl,pt=o(),u(Y.$$.fragment),ut=o(),S=s("p"),S.textContent=wl,ct=o(),u(D.$$.fragment),gt=o(),K=s("p"),K.innerHTML=kl,ht=o(),u(O.$$.fragment),ft=o(),ee=s("p"),ee.innerHTML=$l,Mt=o(),u(te.$$.fragment),bt=o(),le=s("p"),le.innerHTML=_l,vt=o(),U=s("h3"),Z=s("a"),Pe=s("span"),u(ae.$$.fragment),ml=o(),Re=s("span"),Re.textContent=jl,yt=o(),se=s("p"),se.textContent=Cl,Jt=o(),ne=s("ul"),ne.innerHTML=Zl,Tt=o(),oe=s("p"),oe.textContent=Xl,Ut=o(),x=s("h2"),X=s("a"),Qe=s("span"),u(ie.$$.fragment),dl=o(),We=s("span"),We.textContent=El,xt=o(),re=s("p"),re.textContent=zl,wt=o(),me=s("ul"),me.innerHTML=Gl,kt=o(),de=s("p"),de.textContent=Il,$t=o(),w=s("h2"),E=s("a"),Ae=s("span"),u(pe.$$.fragment),pl=o(),Ve=s("span"),Ve.textContent=Rl,_t=o(),ue=s("p"),ue.textContent=Wl,jt=o(),ce=s("ul"),ce.innerHTML=Vl,Ct=o(),ge=s("p"),ge.textContent=Ll,Zt=o(),k=s("h2"),z=s("a"),Ye=s("span"),u(he.$$.fragment),ul=o(),Le=s("span"),Le.textContent=Bl,Xt=o(),fe=s("p"),fe.textContent=Hl,Et=o(),Me=s("ul"),Me.innerHTML=ql,zt=o(),be=s("p"),be.innerHTML=Nl,Gt=o(),u(ve.$$.fragment),It=o(),ye=s("p"),ye.textContent=Fl,Rt=o(),u(Je.$$.fragment),Wt=o(),Te=s("p"),Te.innerHTML=Pl,Vt=o(),u(Ue.$$.fragment),Lt=o(),$=s("h2"),G=s("a"),Se=s("span"),u(xe.$$.fragment),cl=o(),Be=s("span"),Be.textContent=Ql,Bt=o(),we=s("p"),we.textContent=Al,Ht=o(),ke=s("ul"),ke.innerHTML=Yl,qt=o(),$e=s("p"),$e.innerHTML=Sl,Nt=o(),u(_e.$$.fragment),Ft=o(),je=s("p"),je.textContent=Dl,Pt=o(),u(Ce.$$.fragment),Qt=o(),Ze=s("p"),Ze.innerHTML=Kl,At=o(),u(Xe.$$.fragment),Yt=o(),Ee=s("p"),Ee.innerHTML=Ol,St=o(),De=s("p"),this.h()},l(e){const l=Ja("svelte-1phssyn",document.head);v=n(l,"META",{name:!0,content:!0}),l.forEach(t),Ke=i(e),He=n(e,"P",{}),p(He).forEach(t),Oe=i(e),y=n(e,"H1",{class:!0});var Kt=p(y);_=n(Kt,"A",{id:!0,class:!0,href:!0});var ea=p(_);qe=n(ea,"SPAN",{});var ta=p(qe);c(R.$$.fragment,ta),ta.forEach(t),ea.forEach(t),ol=i(Kt),ze=n(Kt,"SPAN",{"data-svelte-h":!0}),r(ze)!=="svelte-11he7zn"&&(ze.textContent=hl),Kt.forEach(t),et=i(e),c(W.$$.fragment,e),tt=i(e),V=n(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-2yvpqx"&&(V.innerHTML=fl),lt=i(e),J=n(e,"H2",{class:!0});var Ot=p(J);j=n(Ot,"A",{id:!0,class:!0,href:!0});var la=p(j);Ne=n(la,"SPAN",{});var aa=p(Ne);c(L.$$.fragment,aa),aa.forEach(t),la.forEach(t),il=i(Ot),Ge=n(Ot,"SPAN",{"data-svelte-h":!0}),r(Ge)!=="svelte-zmv7xk"&&(Ge.textContent=Ml),Ot.forEach(t),at=i(e),B=n(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1b8wedt"&&(B.textContent=bl),st=i(e),T=n(e,"H3",{class:!0});var el=p(T);C=n(el,"A",{id:!0,class:!0,href:!0});var sa=p(C);Fe=n(sa,"SPAN",{});var na=p(Fe);c(H.$$.fragment,na),na.forEach(t),sa.forEach(t),rl=i(el),Ie=n(el,"SPAN",{"data-svelte-h":!0}),r(Ie)!=="svelte-jzwpcd"&&(Ie.textContent=vl),el.forEach(t),nt=i(e),q=n(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1g05fmh"&&(q.textContent=yl),ot=i(e),N=n(e,"UL",{"data-svelte-h":!0}),r(N)!=="svelte-1iu32ge"&&(N.innerHTML=Jl),it=i(e),F=n(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1wzx267"&&(F.innerHTML=Tl),rt=i(e),P=n(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-m23kr5"&&(P.innerHTML=Ul),mt=i(e),c(Q.$$.fragment,e),dt=i(e),A=n(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1jlw8vy"&&(A.innerHTML=xl),pt=i(e),c(Y.$$.fragment,e),ut=i(e),S=n(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-fdserj"&&(S.textContent=wl),ct=i(e),c(D.$$.fragment,e),gt=i(e),K=n(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-gr6p76"&&(K.innerHTML=kl),ht=i(e),c(O.$$.fragment,e),ft=i(e),ee=n(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-syxnxn"&&(ee.innerHTML=$l),Mt=i(e),c(te.$$.fragment,e),bt=i(e),le=n(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1olpich"&&(le.innerHTML=_l),vt=i(e),U=n(e,"H3",{class:!0});var tl=p(U);Z=n(tl,"A",{id:!0,class:!0,href:!0});var oa=p(Z);Pe=n(oa,"SPAN",{});var ia=p(Pe);c(ae.$$.fragment,ia),ia.forEach(t),oa.forEach(t),ml=i(tl),Re=n(tl,"SPAN",{"data-svelte-h":!0}),r(Re)!=="svelte-svqcwr"&&(Re.textContent=jl),tl.forEach(t),yt=i(e),se=n(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-uu1fkj"&&(se.textContent=Cl),Jt=i(e),ne=n(e,"UL",{"data-svelte-h":!0}),r(ne)!=="svelte-ggmk6q"&&(ne.innerHTML=Zl),Tt=i(e),oe=n(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1647i4h"&&(oe.textContent=Xl),Ut=i(e),x=n(e,"H2",{class:!0});var ll=p(x);X=n(ll,"A",{id:!0,class:!0,href:!0});var ra=p(X);Qe=n(ra,"SPAN",{});var ma=p(Qe);c(ie.$$.fragment,ma),ma.forEach(t),ra.forEach(t),dl=i(ll),We=n(ll,"SPAN",{"data-svelte-h":!0}),r(We)!=="svelte-d1aweg"&&(We.textContent=El),ll.forEach(t),xt=i(e),re=n(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-1otw1i1"&&(re.textContent=zl),wt=i(e),me=n(e,"UL",{"data-svelte-h":!0}),r(me)!=="svelte-1em2xx"&&(me.innerHTML=Gl),kt=i(e),de=n(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-188d9hb"&&(de.textContent=Il),$t=i(e),w=n(e,"H2",{class:!0});var al=p(w);E=n(al,"A",{id:!0,class:!0,href:!0});var da=p(E);Ae=n(da,"SPAN",{});var pa=p(Ae);c(pe.$$.fragment,pa),pa.forEach(t),da.forEach(t),pl=i(al),Ve=n(al,"SPAN",{"data-svelte-h":!0}),r(Ve)!=="svelte-on8il6"&&(Ve.textContent=Rl),al.forEach(t),_t=i(e),ue=n(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1on8run"&&(ue.textContent=Wl),jt=i(e),ce=n(e,"UL",{"data-svelte-h":!0}),r(ce)!=="svelte-1u28pca"&&(ce.innerHTML=Vl),Ct=i(e),ge=n(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-1mo7moz"&&(ge.textContent=Ll),Zt=i(e),k=n(e,"H2",{class:!0});var sl=p(k);z=n(sl,"A",{id:!0,class:!0,href:!0});var ua=p(z);Ye=n(ua,"SPAN",{});var ca=p(Ye);c(he.$$.fragment,ca),ca.forEach(t),ua.forEach(t),ul=i(sl),Le=n(sl,"SPAN",{"data-svelte-h":!0}),r(Le)!=="svelte-1qywztq"&&(Le.textContent=Bl),sl.forEach(t),Xt=i(e),fe=n(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-1uzzyuv"&&(fe.textContent=Hl),Et=i(e),Me=n(e,"UL",{"data-svelte-h":!0}),r(Me)!=="svelte-1811mz9"&&(Me.innerHTML=ql),zt=i(e),be=n(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-18dxqmr"&&(be.innerHTML=Nl),Gt=i(e),c(ve.$$.fragment,e),It=i(e),ye=n(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-6ksz4d"&&(ye.textContent=Fl),Rt=i(e),c(Je.$$.fragment,e),Wt=i(e),Te=n(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1k8y33q"&&(Te.innerHTML=Pl),Vt=i(e),c(Ue.$$.fragment,e),Lt=i(e),$=n(e,"H2",{class:!0});var nl=p($);G=n(nl,"A",{id:!0,class:!0,href:!0});var ga=p(G);Se=n(ga,"SPAN",{});var ha=p(Se);c(xe.$$.fragment,ha),ha.forEach(t),ga.forEach(t),cl=i(nl),Be=n(nl,"SPAN",{"data-svelte-h":!0}),r(Be)!=="svelte-1ncd2v"&&(Be.textContent=Ql),nl.forEach(t),Bt=i(e),we=n(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-i72hny"&&(we.textContent=Al),Ht=i(e),ke=n(e,"UL",{"data-svelte-h":!0}),r(ke)!=="svelte-1wsg399"&&(ke.innerHTML=Yl),qt=i(e),$e=n(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-134fnsi"&&($e.innerHTML=Sl),Nt=i(e),c(_e.$$.fragment,e),Ft=i(e),je=n(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-u1agxv"&&(je.textContent=Dl),Pt=i(e),c(Ce.$$.fragment,e),Qt=i(e),Ze=n(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-ybbnzp"&&(Ze.innerHTML=Kl),At=i(e),c(Xe.$$.fragment,e),Yt=i(e),Ee=n(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-quxms0"&&(Ee.innerHTML=Ol),St=i(e),De=n(e,"P",{}),p(De).forEach(t),this.h()},h(){m(v,"name","hf:doc:metadata"),m(v,"content",JSON.stringify(xa)),m(_,"id","modelos-multilingusticos-para-inferncia"),m(_,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(_,"href","#modelos-multilingusticos-para-inferncia"),m(y,"class","relative group"),m(j,"id","xlm"),m(j,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(j,"href","#xlm"),m(J,"class","relative group"),m(C,"id","xlm-com-language-embeddings"),m(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(C,"href","#xlm-com-language-embeddings"),m(T,"class","relative group"),m(Z,"id","xlm-sem-language-embeddings"),m(Z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(Z,"href","#xlm-sem-language-embeddings"),m(U,"class","relative group"),m(X,"id","bert"),m(X,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(X,"href","#bert"),m(x,"class","relative group"),m(E,"id","xlmroberta"),m(E,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(E,"href","#xlmroberta"),m(w,"class","relative group"),m(z,"id","m2m100"),m(z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(z,"href","#m2m100"),m(k,"class","relative group"),m(G,"id","mbart"),m(G,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(G,"href","#mbart"),m($,"class","relative group")},m(e,l){d(document.head,v),a(e,Ke,l),a(e,He,l),a(e,Oe,l),a(e,y,l),d(y,_),d(_,qe),g(R,qe,null),d(y,ol),d(y,ze),a(e,et,l),g(W,e,l),a(e,tt,l),a(e,V,l),a(e,lt,l),a(e,J,l),d(J,j),d(j,Ne),g(L,Ne,null),d(J,il),d(J,Ge),a(e,at,l),a(e,B,l),a(e,st,l),a(e,T,l),d(T,C),d(C,Fe),g(H,Fe,null),d(T,rl),d(T,Ie),a(e,nt,l),a(e,q,l),a(e,ot,l),a(e,N,l),a(e,it,l),a(e,F,l),a(e,rt,l),a(e,P,l),a(e,mt,l),g(Q,e,l),a(e,dt,l),a(e,A,l),a(e,pt,l),g(Y,e,l),a(e,ut,l),a(e,S,l),a(e,ct,l),g(D,e,l),a(e,gt,l),a(e,K,l),a(e,ht,l),g(O,e,l),a(e,ft,l),a(e,ee,l),a(e,Mt,l),g(te,e,l),a(e,bt,l),a(e,le,l),a(e,vt,l),a(e,U,l),d(U,Z),d(Z,Pe),g(ae,Pe,null),d(U,ml),d(U,Re),a(e,yt,l),a(e,se,l),a(e,Jt,l),a(e,ne,l),a(e,Tt,l),a(e,oe,l),a(e,Ut,l),a(e,x,l),d(x,X),d(X,Qe),g(ie,Qe,null),d(x,dl),d(x,We),a(e,xt,l),a(e,re,l),a(e,wt,l),a(e,me,l),a(e,kt,l),a(e,de,l),a(e,$t,l),a(e,w,l),d(w,E),d(E,Ae),g(pe,Ae,null),d(w,pl),d(w,Ve),a(e,_t,l),a(e,ue,l),a(e,jt,l),a(e,ce,l),a(e,Ct,l),a(e,ge,l),a(e,Zt,l),a(e,k,l),d(k,z),d(z,Ye),g(he,Ye,null),d(k,ul),d(k,Le),a(e,Xt,l),a(e,fe,l),a(e,Et,l),a(e,Me,l),a(e,zt,l),a(e,be,l),a(e,Gt,l),g(ve,e,l),a(e,It,l),a(e,ye,l),a(e,Rt,l),g(Je,e,l),a(e,Wt,l),a(e,Te,l),a(e,Vt,l),g(Ue,e,l),a(e,Lt,l),a(e,$,l),d($,G),d(G,Se),g(xe,Se,null),d($,cl),d($,Be),a(e,Bt,l),a(e,we,l),a(e,Ht,l),a(e,ke,l),a(e,qt,l),a(e,$e,l),a(e,Nt,l),g(_e,e,l),a(e,Ft,l),a(e,je,l),a(e,Pt,l),g(Ce,e,l),a(e,Qt,l),a(e,Ze,l),a(e,At,l),g(Xe,e,l),a(e,Yt,l),a(e,Ee,l),a(e,St,l),a(e,De,l),Dt=!0},p:Ma,i(e){Dt||(h(R.$$.fragment,e),h(W.$$.fragment,e),h(L.$$.fragment,e),h(H.$$.fragment,e),h(Q.$$.fragment,e),h(Y.$$.fragment,e),h(D.$$.fragment,e),h(O.$$.fragment,e),h(te.$$.fragment,e),h(ae.$$.fragment,e),h(ie.$$.fragment,e),h(pe.$$.fragment,e),h(he.$$.fragment,e),h(ve.$$.fragment,e),h(Je.$$.fragment,e),h(Ue.$$.fragment,e),h(xe.$$.fragment,e),h(_e.$$.fragment,e),h(Ce.$$.fragment,e),h(Xe.$$.fragment,e),Dt=!0)},o(e){f(R.$$.fragment,e),f(W.$$.fragment,e),f(L.$$.fragment,e),f(H.$$.fragment,e),f(Q.$$.fragment,e),f(Y.$$.fragment,e),f(D.$$.fragment,e),f(O.$$.fragment,e),f(te.$$.fragment,e),f(ae.$$.fragment,e),f(ie.$$.fragment,e),f(pe.$$.fragment,e),f(he.$$.fragment,e),f(ve.$$.fragment,e),f(Je.$$.fragment,e),f(Ue.$$.fragment,e),f(xe.$$.fragment,e),f(_e.$$.fragment,e),f(Ce.$$.fragment,e),f(Xe.$$.fragment,e),Dt=!1},d(e){e&&(t(Ke),t(He),t(Oe),t(y),t(et),t(tt),t(V),t(lt),t(J),t(at),t(B),t(st),t(T),t(nt),t(q),t(ot),t(N),t(it),t(F),t(rt),t(P),t(mt),t(dt),t(A),t(pt),t(ut),t(S),t(ct),t(gt),t(K),t(ht),t(ft),t(ee),t(Mt),t(bt),t(le),t(vt),t(U),t(yt),t(se),t(Jt),t(ne),t(Tt),t(oe),t(Ut),t(x),t(xt),t(re),t(wt),t(me),t(kt),t(de),t($t),t(w),t(_t),t(ue),t(jt),t(ce),t(Ct),t(ge),t(Zt),t(k),t(Xt),t(fe),t(Et),t(Me),t(zt),t(be),t(Gt),t(It),t(ye),t(Rt),t(Wt),t(Te),t(Vt),t(Lt),t($),t(Bt),t(we),t(Ht),t(ke),t(qt),t($e),t(Nt),t(Ft),t(je),t(Pt),t(Qt),t(Ze),t(At),t(Yt),t(Ee),t(St),t(De)),t(v),M(R),M(W,e),M(L),M(H),M(Q,e),M(Y,e),M(D,e),M(O,e),M(te,e),M(ae),M(ie),M(pe),M(he),M(ve,e),M(Je,e),M(Ue,e),M(xe),M(_e,e),M(Ce,e),M(Xe,e)}}}const xa={local:"modelos-multilingusticos-para-inferncia",sections:[{local:"xlm",sections:[{local:"xlm-com-language-embeddings",title:"XLM com language embeddings"},{local:"xlm-sem-language-embeddings",title:"XLM sem language embeddings"}],title:"XLM"},{local:"bert",title:"BERT"},{local:"xlmroberta",title:"XLM-RoBERTa"},{local:"m2m100",title:"M2M100"},{local:"mbart",title:"MBart"}],title:"Modelos multilinguísticos para inferência"};function wa(gl){return ba(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Za extends va{constructor(v){super(),ya(this,v,wa,Ua,fa,{})}}export{Za as component};
