import{s as Zt,n as Ct,o as kt}from"../chunks/scheduler.85c25b89.js";import{S as It,i as Wt,g as p,s as e,r as i,A as Gt,h as m,f as l,c as n,j as Ut,u as o,x as g,k as $t,y as Nt,a,v as c,d as r,t as h,w as M}from"../chunks/index.c9837788.js";import{C as X}from"../chunks/CodeBlock.52fa569e.js";import{H as R,E as xt}from"../chunks/EditOnGithub.b65eee75.js";function Bt(Mt){let j,Y,A,_,d,S,y,gt="<strong>NASNet</strong> is a type of convolutional neural network discovered through neural architecture search. The building blocks consist of normal and reduction cells.",z,J,F,u,jt="To load a pretrained model:",H,w,L,f,dt="To load and preprocess the image:",q,b,D,T,yt="To get the model predictions:",P,U,K,$,Jt="To get the top-5 predictions class names:",O,Z,tt,C,ut="Replace the model name with the variant you want to use, e.g. <code>nasnetalarge</code>. You can find the IDs in the model summaries at the top of this page.",st,k,wt='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',lt,I,at,W,ft="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",et,G,nt,N,bt=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,pt,x,mt,B,Tt='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',it,v,ot,E,ct,Q,rt,V,ht;return d=new R({props:{title:"NASNet",local:"nasnet",headingTag:"h1"}}),J=new R({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),w=new X({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ25hc25ldGFsYXJnZSclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;nasnetalarge&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),b=new X({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),U=new X({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),Z=new X({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),I=new R({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),G=new X({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnbmFzbmV0YWxhcmdlJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;nasnetalarge&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),x=new R({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),v=new R({props:{title:"Citation",local:"citation",headingTag:"h2"}}),E=new X({props:{code:"JTQwbWlzYyU3QnpvcGgyMDE4bGVhcm5pbmclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB0aXRsZSUzRCU3QkxlYXJuaW5nJTIwVHJhbnNmZXJhYmxlJTIwQXJjaGl0ZWN0dXJlcyUyMGZvciUyMFNjYWxhYmxlJTIwSW1hZ2UlMjBSZWNvZ25pdGlvbiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGF1dGhvciUzRCU3QkJhcnJldCUyMFpvcGglMjBhbmQlMjBWaWpheSUyMFZhc3VkZXZhbiUyMGFuZCUyMEpvbmF0aG9uJTIwU2hsZW5zJTIwYW5kJTIwUXVvYyUyMFYuJTIwTGUlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB5ZWFyJTNEJTdCMjAxOCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGVwcmludCUzRCU3QjE3MDcuMDcwMTIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBhcmNoaXZlUHJlZml4JTNEJTdCYXJYaXYlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBwcmltYXJ5Q2xhc3MlM0QlN0Jjcy5DViU3RCUwQSU3RA==",highlighted:`@misc{zoph2018learning,
      title={Learning Transferable Architectures for <span class="hljs-keyword">Scalable </span>Image Recognition},
      author={<span class="hljs-keyword">Barret </span>Zoph <span class="hljs-keyword">and </span>Vijay Vasudevan <span class="hljs-keyword">and </span><span class="hljs-keyword">Jonathon </span><span class="hljs-keyword">Shlens </span><span class="hljs-keyword">and </span>Quoc V. Le},
      year={<span class="hljs-number">2018</span>},
      eprint={<span class="hljs-number">1707</span>.<span class="hljs-number">07012</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`,wrap:!1}}),Q=new xt({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/nasnet.mdx"}}),{c(){j=p("meta"),Y=e(),A=p("p"),_=e(),i(d.$$.fragment),S=e(),y=p("p"),y.innerHTML=gt,z=e(),i(J.$$.fragment),F=e(),u=p("p"),u.textContent=jt,H=e(),i(w.$$.fragment),L=e(),f=p("p"),f.textContent=dt,q=e(),i(b.$$.fragment),D=e(),T=p("p"),T.textContent=yt,P=e(),i(U.$$.fragment),K=e(),$=p("p"),$.textContent=Jt,O=e(),i(Z.$$.fragment),tt=e(),C=p("p"),C.innerHTML=ut,st=e(),k=p("p"),k.innerHTML=wt,lt=e(),i(I.$$.fragment),at=e(),W=p("p"),W.textContent=ft,et=e(),i(G.$$.fragment),nt=e(),N=p("p"),N.innerHTML=bt,pt=e(),i(x.$$.fragment),mt=e(),B=p("p"),B.innerHTML=Tt,it=e(),i(v.$$.fragment),ot=e(),i(E.$$.fragment),ct=e(),i(Q.$$.fragment),rt=e(),V=p("p"),this.h()},l(t){const s=Gt("svelte-u9bgzb",document.head);j=m(s,"META",{name:!0,content:!0}),s.forEach(l),Y=n(t),A=m(t,"P",{}),Ut(A).forEach(l),_=n(t),o(d.$$.fragment,t),S=n(t),y=m(t,"P",{"data-svelte-h":!0}),g(y)!=="svelte-1u56z5m"&&(y.innerHTML=gt),z=n(t),o(J.$$.fragment,t),F=n(t),u=m(t,"P",{"data-svelte-h":!0}),g(u)!=="svelte-18ywhxh"&&(u.textContent=jt),H=n(t),o(w.$$.fragment,t),L=n(t),f=m(t,"P",{"data-svelte-h":!0}),g(f)!=="svelte-1c2ipa8"&&(f.textContent=dt),q=n(t),o(b.$$.fragment,t),D=n(t),T=m(t,"P",{"data-svelte-h":!0}),g(T)!=="svelte-1n9qsq1"&&(T.textContent=yt),P=n(t),o(U.$$.fragment,t),K=n(t),$=m(t,"P",{"data-svelte-h":!0}),g($)!=="svelte-19cnvx1"&&($.textContent=Jt),O=n(t),o(Z.$$.fragment,t),tt=n(t),C=m(t,"P",{"data-svelte-h":!0}),g(C)!=="svelte-qu63rt"&&(C.innerHTML=ut),st=n(t),k=m(t,"P",{"data-svelte-h":!0}),g(k)!=="svelte-1wmi3ea"&&(k.innerHTML=wt),lt=n(t),o(I.$$.fragment,t),at=n(t),W=m(t,"P",{"data-svelte-h":!0}),g(W)!=="svelte-9sr7nh"&&(W.textContent=ft),et=n(t),o(G.$$.fragment,t),nt=n(t),N=m(t,"P",{"data-svelte-h":!0}),g(N)!=="svelte-1kguc51"&&(N.innerHTML=bt),pt=n(t),o(x.$$.fragment,t),mt=n(t),B=m(t,"P",{"data-svelte-h":!0}),g(B)!=="svelte-1n0coha"&&(B.innerHTML=Tt),it=n(t),o(v.$$.fragment,t),ot=n(t),o(E.$$.fragment,t),ct=n(t),o(Q.$$.fragment,t),rt=n(t),V=m(t,"P",{}),Ut(V).forEach(l),this.h()},h(){$t(j,"name","hf:doc:metadata"),$t(j,"content",vt)},m(t,s){Nt(document.head,j),a(t,Y,s),a(t,A,s),a(t,_,s),c(d,t,s),a(t,S,s),a(t,y,s),a(t,z,s),c(J,t,s),a(t,F,s),a(t,u,s),a(t,H,s),c(w,t,s),a(t,L,s),a(t,f,s),a(t,q,s),c(b,t,s),a(t,D,s),a(t,T,s),a(t,P,s),c(U,t,s),a(t,K,s),a(t,$,s),a(t,O,s),c(Z,t,s),a(t,tt,s),a(t,C,s),a(t,st,s),a(t,k,s),a(t,lt,s),c(I,t,s),a(t,at,s),a(t,W,s),a(t,et,s),c(G,t,s),a(t,nt,s),a(t,N,s),a(t,pt,s),c(x,t,s),a(t,mt,s),a(t,B,s),a(t,it,s),c(v,t,s),a(t,ot,s),c(E,t,s),a(t,ct,s),c(Q,t,s),a(t,rt,s),a(t,V,s),ht=!0},p:Ct,i(t){ht||(r(d.$$.fragment,t),r(J.$$.fragment,t),r(w.$$.fragment,t),r(b.$$.fragment,t),r(U.$$.fragment,t),r(Z.$$.fragment,t),r(I.$$.fragment,t),r(G.$$.fragment,t),r(x.$$.fragment,t),r(v.$$.fragment,t),r(E.$$.fragment,t),r(Q.$$.fragment,t),ht=!0)},o(t){h(d.$$.fragment,t),h(J.$$.fragment,t),h(w.$$.fragment,t),h(b.$$.fragment,t),h(U.$$.fragment,t),h(Z.$$.fragment,t),h(I.$$.fragment,t),h(G.$$.fragment,t),h(x.$$.fragment,t),h(v.$$.fragment,t),h(E.$$.fragment,t),h(Q.$$.fragment,t),ht=!1},d(t){t&&(l(Y),l(A),l(_),l(S),l(y),l(z),l(F),l(u),l(H),l(L),l(f),l(q),l(D),l(T),l(P),l(K),l($),l(O),l(tt),l(C),l(st),l(k),l(lt),l(at),l(W),l(et),l(nt),l(N),l(pt),l(mt),l(B),l(it),l(ot),l(ct),l(rt),l(V)),l(j),M(d,t),M(J,t),M(w,t),M(b,t),M(U,t),M(Z,t),M(I,t),M(G,t),M(x,t),M(v,t),M(E,t),M(Q,t)}}}const vt='{"title":"NASNet","local":"nasnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Et(Mt){return kt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Rt extends It{constructor(j){super(),Wt(this,j,Et,Bt,Zt,{})}}export{Rt as component};
