import{s as xn,o as Mn,n as oe}from"../chunks/scheduler.defa9a21.js";import{S as Tn,i as Un,g as f,s as a,r as c,A as Cn,h as u,f as o,c as n,j as w,u as r,x as b,k as y,y as d,a as s,v as i,d as m,t as h,w as p}from"../chunks/index.fe795e71.js";import{T as sa}from"../chunks/Tip.179eb360.js";import{D as M}from"../chunks/Docstring.cb3521fa.js";import{C as Qt}from"../chunks/CodeBlock.204b6c34.js";import{E as zt}from"../chunks/ExampleCodeBlock.317a749b.js";import{H as x,E as jn}from"../chunks/getInferenceSnippets.02fcfee2.js";function Jn(C){let l,k="Example:",g,v,$;return v=new Qt({props:{code:"aW1wb3J0JTIwdG9yY2gubm4lMjBhcyUyMG5uJTBBZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBpbml0X2VtcHR5X3dlaWdodHMlMEElMEElMjMlMjBJbml0aWFsaXplJTIwYSUyMG1vZGVsJTIwd2l0aCUyMDEwMCUyMGJpbGxpb25zJTIwcGFyYW1ldGVycyUyMGluJTIwbm8lMjB0aW1lJTIwYW5kJTIwd2l0aG91dCUyMHVzaW5nJTIwYW55JTIwUkFNLiUwQXdpdGglMjBpbml0X2VtcHR5X3dlaWdodHMoKSUzQSUwQSUyMCUyMCUyMCUyMHRzdCUyMCUzRCUyMG5uLlNlcXVlbnRpYWwoKiU1Qm5uLkxpbmVhcigxMDAwMCUyQyUyMDEwMDAwKSUyMGZvciUyMF8lMjBpbiUyMHJhbmdlKDEwMDApJTVEKQ==",highlighted:`<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn
<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> init_empty_weights

<span class="hljs-comment"># Initialize a model with 100 billions parameters in no time and without using any RAM.</span>
<span class="hljs-keyword">with</span> init_empty_weights():
    tst = nn.Sequential(*[nn.Linear(<span class="hljs-number">10000</span>, <span class="hljs-number">10000</span>) <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>)])`,wrap:!1}}),{c(){l=f("p"),l.textContent=k,g=a(),c(v.$$.fragment)},l(_){l=u(_,"P",{"data-svelte-h":!0}),b(l)!=="svelte-11lpom8"&&(l.textContent=k),g=n(_),r(v.$$.fragment,_)},m(_,T){s(_,l,T),s(_,g,T),i(v,_,T),$=!0},p:oe,i(_){$||(m(v.$$.fragment,_),$=!0)},o(_){h(v.$$.fragment,_),$=!1},d(_){_&&(o(l),o(g)),p(v,_)}}}function Gn(C){let l,k=`Any model created under this context manager has no weights. As such you can’t do something like
<code>model.to(some_device)</code> with it. To load weights inside your empty model, see <a href="/docs/accelerate/main/en/package_reference/big_modeling#accelerate.load_checkpoint_and_dispatch">load_checkpoint_and_dispatch()</a>.
Make sure to overwrite the default device_map param for <a href="/docs/accelerate/main/en/package_reference/big_modeling#accelerate.load_checkpoint_and_dispatch">load_checkpoint_and_dispatch()</a>, otherwise dispatch is not
called.`;return{c(){l=f("p"),l.innerHTML=k},l(g){l=u(g,"P",{"data-svelte-h":!0}),b(l)!=="svelte-18rw2wy"&&(l.innerHTML=k)},m(g,v){s(g,l,v)},p:oe,d(g){g&&o(l)}}}function In(C){let l,k="Example:",g,v,$;return v=new Qt({props:{code:"bW9kZWxfMSUyQyUyMGhvb2tfMSUyMCUzRCUyMGNwdV9vZmZsb2FkX3dpdGhfaG9vayhtb2RlbF8xJTJDJTIwY3VkYV9kZXZpY2UpJTBBbW9kZWxfMiUyQyUyMGhvb2tfMiUyMCUzRCUyMGNwdV9vZmZsb2FkX3dpdGhfaG9vayhtb2RlbF8yJTJDJTIwY3VkYV9kZXZpY2UlMkMlMjBwcmV2X21vZHVsZV9ob29rJTNEaG9va18xKSUwQW1vZGVsXzMlMkMlMjBob29rXzMlMjAlM0QlMjBjcHVfb2ZmbG9hZF93aXRoX2hvb2sobW9kZWxfMyUyQyUyMGN1ZGFfZGV2aWNlJTJDJTIwcHJldl9tb2R1bGVfaG9vayUzRGhvb2tfMiklMEElMEFoaWRfMSUyMCUzRCUyMG1vZGVsXzEoaW5wdXQpJTBBZm9yJTIwaSUyMGluJTIwcmFuZ2UoNTApJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwbW9kZWwxJTIwaXMlMjBvZmZsb2FkZWQlMjBvbiUyMHRoZSUyMENQVSUyMGF0JTIwdGhlJTIwZmlyc3QlMjBpdGVyYXRpb24lMkMlMjBtb2RlbCUyMDIlMjBzdGF5cyUyMG9uJTIwdGhlJTIwR1BVJTIwZm9yJTIwdGhpcyUyMHdob2xlJTIwbG9vcC4lMEElMjAlMjAlMjAlMjBoaWRfMiUyMCUzRCUyMG1vZGVsXzIoaGlkXzEpJTBBJTIzJTIwbW9kZWwyJTIwaXMlMjBvZmZsb2FkZWQlMjB0byUyMHRoZSUyMENQVSUyMGp1c3QlMjBiZWZvcmUlMjB0aGlzJTIwZm9yd2FyZC4lMEFoaWRfMyUyMCUzRCUyMG1vZGVsXzMoaGlkXzMpJTBBJTBBJTIzJTIwRm9yJTIwbW9kZWwzJTJDJTIweW91JTIwbmVlZCUyMHRvJTIwbWFudWFsbHklMjBjYWxsJTIwdGhlJTIwaG9vayUyMG9mZmxvYWQlMjBtZXRob2QuJTBBaG9va18zLm9mZmxvYWQoKQ==",highlighted:`model_1, hook_1 = cpu_offload_with_hook(model_1, cuda_device)
model_2, hook_2 = cpu_offload_with_hook(model_2, cuda_device, prev_module_hook=hook_1)
model_3, hook_3 = cpu_offload_with_hook(model_3, cuda_device, prev_module_hook=hook_2)

hid_1 = model_1(<span class="hljs-built_in">input</span>)
<span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">50</span>):
    <span class="hljs-comment"># model1 is offloaded on the CPU at the first iteration, model 2 stays on the GPU for this whole loop.</span>
    hid_2 = model_2(hid_1)
<span class="hljs-comment"># model2 is offloaded to the CPU just before this forward.</span>
hid_3 = model_3(hid_3)

<span class="hljs-comment"># For model3, you need to manually call the hook offload method.</span>
hook_3.offload()`,wrap:!1}}),{c(){l=f("p"),l.textContent=k,g=a(),c(v.$$.fragment)},l(_){l=u(_,"P",{"data-svelte-h":!0}),b(l)!=="svelte-11lpom8"&&(l.textContent=k),g=n(_),r(v.$$.fragment,_)},m(_,T){s(_,l,T),s(_,g,T),i(v,_,T),$=!0},p:oe,i(_){$||(m(v.$$.fragment,_),$=!0)},o(_){h(v.$$.fragment,_),$=!1},d(_){_&&(o(l),o(g)),p(v,_)}}}function Nn(C){let l,k="Example:",g,v,$;return v=new Qt({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBpbml0X2VtcHR5X3dlaWdodHMlMkMlMjBsb2FkX2NoZWNrcG9pbnRfYW5kX2Rpc3BhdGNoJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvQ29uZmlnJTJDJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMEElMjMlMjBEb3dubG9hZCUyMHRoZSUyMFdlaWdodHMlMEFjaGVja3BvaW50JTIwJTNEJTIwJTIyRWxldXRoZXJBSSUyRmdwdC1qLTZCJTIyJTBBd2VpZ2h0c19sb2NhdGlvbiUyMCUzRCUyMGhmX2h1Yl9kb3dubG9hZChjaGVja3BvaW50JTJDJTIwJTIycHl0b3JjaF9tb2RlbC5iaW4lMjIpJTBBJTBBJTIzJTIwQ3JlYXRlJTIwYSUyMG1vZGVsJTIwYW5kJTIwaW5pdGlhbGl6ZSUyMGl0JTIwd2l0aCUyMGVtcHR5JTIwd2VpZ2h0cyUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQpJTBBd2l0aCUyMGluaXRfZW1wdHlfd2VpZ2h0cygpJTNBJTBBJTIwJTIwJTIwJTIwbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX2NvbmZpZyhjb25maWcpJTBBJTBBJTIzJTIwTG9hZCUyMHRoZSUyMGNoZWNrcG9pbnQlMjBhbmQlMjBkaXNwYXRjaCUyMGl0JTIwdG8lMjB0aGUlMjByaWdodCUyMGRldmljZXMlMEFtb2RlbCUyMCUzRCUyMGxvYWRfY2hlY2twb2ludF9hbmRfZGlzcGF0Y2goJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMjB3ZWlnaHRzX2xvY2F0aW9uJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjBub19zcGxpdF9tb2R1bGVfY2xhc3NlcyUzRCU1QiUyMkdQVEpCbG9jayUyMiU1RCUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> init_empty_weights, load_checkpoint_and_dispatch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download the Weights</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;EleutherAI/gpt-j-6B&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>weights_location = hf_hub_download(checkpoint, <span class="hljs-string">&quot;pytorch_model.bin&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Create a model and initialize it with empty weights</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> init_empty_weights():
<span class="hljs-meta">... </span>    model = AutoModelForCausalLM.from_config(config)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load the checkpoint and dispatch it to the right devices</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = load_checkpoint_and_dispatch(
<span class="hljs-meta">... </span>    model, weights_location, device_map=<span class="hljs-string">&quot;auto&quot;</span>, no_split_module_classes=[<span class="hljs-string">&quot;GPTJBlock&quot;</span>]
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){l=f("p"),l.textContent=k,g=a(),c(v.$$.fragment)},l(_){l=u(_,"P",{"data-svelte-h":!0}),b(l)!=="svelte-11lpom8"&&(l.textContent=k),g=n(_),r(v.$$.fragment,_)},m(_,T){s(_,l,T),s(_,g,T),i(v,_,T),$=!0},p:oe,i(_){$||(m(v.$$.fragment,_),$=!0)},o(_){h(v.$$.fragment,_),$=!1},d(_){_&&(o(l),o(g)),p(v,_)}}}function Fn(C){let l,k=`Once loaded across devices, you still need to call <a href="/docs/accelerate/main/en/package_reference/big_modeling#accelerate.dispatch_model">dispatch_model()</a> on your model to make it able to run. To
group the checkpoint loading and dispatch in one single call, use <a href="/docs/accelerate/main/en/package_reference/big_modeling#accelerate.load_checkpoint_and_dispatch">load_checkpoint_and_dispatch()</a>.`;return{c(){l=f("p"),l.innerHTML=k},l(g){l=u(g,"P",{"data-svelte-h":!0}),b(l)!=="svelte-13sragn"&&(l.innerHTML=k)},m(g,v){s(g,l,v)},p:oe,d(g){g&&o(l)}}}function Hn(C){let l,k=`All computation is done analyzing sizes and dtypes of the model parameters. As a result, the model can be on the
meta device (as it would if initialized within the <code>init_empty_weights</code> context manager).`;return{c(){l=f("p"),l.innerHTML=k},l(g){l=u(g,"P",{"data-svelte-h":!0}),b(l)!=="svelte-1d9m3bn"&&(l.innerHTML=k)},m(g,v){s(g,l,v)},p:oe,d(g){g&&o(l)}}}function Wn(C){let l,k=`If the module already contains a hook, this will replace it with the new hook passed by default. To chain two hooks
together, pass <code>append=True</code>, so it chains the current and new hook into an instance of the <code>SequentialHook</code> class.`;return{c(){l=f("p"),l.innerHTML=k},l(g){l=u(g,"P",{"data-svelte-h":!0}),b(l)!=="svelte-1dclc89"&&(l.innerHTML=k)},m(g,v){s(g,l,v)},p:oe,d(g){g&&o(l)}}}function Zn(C){let l,k="Example:",g,v,$;return v=new Qt({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUuaG9va3MlMjBpbXBvcnQlMjBhdHRhY2hfbGF5ZXJ3aXNlX2Nhc3RpbmdfaG9va3MlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEFpbXBvcnQlMjB0b3JjaCUwQSUwQSUyMyUyME1vZGVsJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMkVsZXV0aGVyQUklMkZncHQtai02QiUyMiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQpJTBBJTBBJTIzJTIwQXR0YWNoJTIwaG9va3MlMjBhbmQlMjBwZXJmb3JtJTIwaW5mZXJlbmNlJTBBYXR0YWNoX2xheWVyd2lzZV9jYXN0aW5nX2hvb2tzKG1vZGVsJTJDJTIwc3RvcmFnZV9kdHlwZSUzRHRvcmNoLmZsb2F0OF9lNG0zZm4lMkMlMjBjb21wdXRlX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYpJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG1vZGVsKC4uLik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate.hooks <span class="hljs-keyword">import</span> attach_layerwise_casting_hooks
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;EleutherAI/gpt-j-6B&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(checkpoint)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Attach hooks and perform inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>attach_layerwise_casting_hooks(model, storage_dtype=torch.float8_e4m3fn, compute_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    model(...)`,wrap:!1}}),{c(){l=f("p"),l.textContent=k,g=a(),c(v.$$.fragment)},l(_){l=u(_,"P",{"data-svelte-h":!0}),b(l)!=="svelte-11lpom8"&&(l.textContent=k),g=n(_),r(v.$$.fragment,_)},m(_,T){s(_,l,T),s(_,g,T),i(v,_,T),$=!0},p:oe,i(_){$||(m(v.$$.fragment,_),$=!0)},o(_){h(v.$$.fragment,_),$=!1},d(_){_&&(o(l),o(g)),p(v,_)}}}function Dn(C){let l,k;return l=new Qt({props:{code:"YXR0YWNoX2xheWVyd2lzZV9jYXN0aW5nX2hvb2tzKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTJDJTIwc3RvcmFnZV9kdHlwZSUzRHRvcmNoLmZsb2F0OF9lNG0zZm4lMkMlMjBjb21wdXRlX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMjBza2lwX21vZHVsZXNfcGF0dGVybiUzRCU1QiUyMm5vcm0lMjIlNUQlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>attach_layerwise_casting_hooks(
<span class="hljs-meta">... </span>    model, storage_dtype=torch.float8_e4m3fn, compute_dtype=torch.bfloat16, skip_modules_pattern=[<span class="hljs-string">&quot;norm&quot;</span>]
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){c(l.$$.fragment)},l(g){r(l.$$.fragment,g)},m(g,v){i(l,g,v),k=!0},p:oe,i(g){k||(m(l.$$.fragment,g),k=!0)},o(g){h(l.$$.fragment,g),k=!1},d(g){p(l,g)}}}function Bn(C){let l,k,g,v,$,_,T,qt,_e,Yt,G,ge,la,_t,Qa=`A context manager under which models are initialized with all parameters on the meta device, therefore creating an
empty model. Useful when just initializing the model would blow the available RAM.`,da,ae,ca,ne,St,ve,Ot,L,be,ra,gt,qa=`Activates full CPU offload for a model. As a result, all parameters of the model will be offloaded and only one
copy of the state dict of the model will be kept. During the forward pass, parameters will be extracted from that
state dict and put on the execution device passed as they are needed, then offloaded again.`,Kt,ke,eo,N,$e,ia,vt,Ya=`Offloads a model on the CPU and puts it back to an execution device when executed. The difference with
<a href="/docs/accelerate/main/en/package_reference/big_modeling#accelerate.cpu_offload">cpu_offload()</a> is that the model stays on the execution device after the forward and is only offloaded again when
the <code>offload</code> method of the returned <code>hook</code> is called. Useful for pipelines running a model in a loop.`,ma,se,to,we,oo,V,ye,ha,bt,Sa=`Activates full disk offload for a model. As a result, all parameters of the model will be offloaded as
memory-mapped array in a given folder. During the forward pass, parameters will be accessed from that folder and
put on the execution device passed as they are needed, then offloaded again.`,ao,xe,no,A,Me,pa,kt,Oa=`Dispatches a model according to a given device map. Layers of the model might be spread across GPUs, offloaded on
the CPU or even the disk.`,so,Te,lo,F,Ue,fa,$t,Ka=`Loads a (potentially sharded) checkpoint inside a model, potentially sending weights to a given device as they are
loaded and adds the various hooks that will make this model run properly (even if split across devices).`,ua,le,co,Ce,ro,H,je,_a,wt,en=`Loads a (potentially sharded) checkpoint inside a model, potentially sending weights to a given device as they are
loaded.`,ga,de,io,Je,mo,I,Ge,va,yt,tn=`Compute a device map for a given model giving priority to GPUs, then offload on CPU and finally offload to disk,
such that:`,ba,xt,on=`<li>we don’t exceed the memory available of any of the GPU.</li> <li>if offload to the CPU is needed, there is always room left on GPU 0 to put back the layer offloaded on CPU that
has the largest size.</li> <li>if offload to the CPU is needed,we don’t exceed the RAM available on the CPU.</li> <li>if offload to the disk is needed, there is always room left on the CPU to put back the layer offloaded on disk
that has the largest size.</li>`,ka,ce,ho,Ie,po,Ne,fo,U,Fe,$a,Mt,an=`A hook that contains callbacks to be executed just before and after the forward method of a model. The difference
with PyTorch existing hooks is that they get passed along the kwargs.`,wa,Tt,nn="Class attribute:",ya,Ut,sn=`<li><strong>no_grad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) — Whether or not to execute the actual forward pass under
the <code>torch.no_grad()</code> context manager.</li>`,xa,re,He,Ma,Ct,ln="To be executed when the hook is detached from a module.",Ta,ie,We,Ua,jt,dn="To be executed when the hook is attached to the module.",Ca,me,Ze,ja,Jt,cn="To be executed just after the forward method of the model.",Ja,he,De,Ga,Gt,rn="To be executed just before the forward method of the model.",uo,Be,_o,P,Le,Ia,It,mn=`A generic <code>ModelHook</code> that ensures inputs and model weights are on the same device for the forward pass of the
associated module, potentially offloading the weights after the forward pass.`,go,Ve,vo,R,Ae,Na,Nt,hn="A hook that can contain several hooks and iterates through them at each event.",bo,Pe,ko,X,Re,Fa,Ft,pn=`A hook that casts the weights of a module to a high precision dtype for computation, and to a low precision dtype
for storage. This process may lead to quality loss in the output, but can significantly reduce the memory
footprint.`,$o,Xe,wo,Ee,yo,W,ze,Ha,Ht,fn=`Adds a hook to a given module. This will rewrite the <code>forward</code> method of the module to include the hook, to remove
this behavior and restore the original <code>forward</code> method, use <code>remove_hook_from_module</code>.`,Wa,pe,xo,Qe,Mo,E,qe,Za,Wt,un=`Recursively attaches <code>AlignDevicesHook</code> to all submodules of a given model to make sure they have the right
execution device`,To,Ye,Uo,z,Se,Da,Zt,_n=`Recursively attaches <code>AlignDevicesHook</code> to all submodules of a given model that have direct parameters and/or
buffers.`,Co,Oe,jo,Q,Ke,Ba,Dt,gn="Attaches <code>AlignDevicesHook</code> to all blocks of a given model as needed.",Jo,et,Go,J,tt,La,Bt,vn=`Applies layerwise casting to a given module. The module expected here is a PyTorch <code>nn.Module</code>. This is helpful for
reducing memory requirements when one doesn’t want to fully quantize a model. Model params can be kept in say,
<code>torch.float8_e4m3fn</code> and upcasted to a higher precision like <code>torch.bfloat16</code> during forward pass and downcasted
back to <code>torch.float8_e4m3fn</code> to realize memory savings.`,Va,fe,Aa,Lt,bn="Users can also pass modules they want to avoid from getting downcasted.",Pa,ue,Io,ot,No,at,Fo,q,nt,Ra,Vt,kn="Removes any hook attached to a module via <code>add_hook_to_module</code>.",Ho,st,Wo,Y,lt,Xa,At,$n="Recursively removes all hooks attached on the submodules of a given model.",Zo,dt,Do,ct,Bo,S,rt,Ea,Pt,wn=`Checks if a module has offloaded parameters by checking if the given module has a AlignDevicesHook attached with
offloading enabled`,Lo,it,Vo,O,mt,za,Rt,yn="Context manager that moves a module’s parameters to the specified execution device.",Ao,ht,Po,Et,Ro;return $=new x({props:{title:"Working with large models",local:"working-with-large-models",headingTag:"h1"}}),T=new x({props:{title:"Dispatch and offload",local:"dispatch-and-offload",headingTag:"h2"}}),_e=new x({props:{title:"init_empty_weights",local:"accelerate.init_empty_weights",headingTag:"h3"}}),ge=new M({props:{name:"accelerate.init_empty_weights",anchor:"accelerate.init_empty_weights",parameters:[{name:"include_buffers",val:": bool = None"}],parametersDescription:[{anchor:"accelerate.init_empty_weights.include_buffers",description:`<strong>include_buffers</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to also put all buffers on the meta device while initializing.`,name:"include_buffers"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/big_modeling.py#L60"}}),ae=new zt({props:{anchor:"accelerate.init_empty_weights.example",$$slots:{default:[Jn]},$$scope:{ctx:C}}}),ne=new sa({props:{warning:!0,$$slots:{default:[Gn]},$$scope:{ctx:C}}}),ve=new x({props:{title:"cpu_offload",local:"accelerate.cpu_offload",headingTag:"h3"}}),be=new M({props:{name:"accelerate.cpu_offload",anchor:"accelerate.cpu_offload",parameters:[{name:"model",val:": Module"},{name:"execution_device",val:": typing.Optional[torch.device] = None"},{name:"offload_buffers",val:": bool = False"},{name:"state_dict",val:": typing.Optional[dict[str, torch.Tensor]] = None"},{name:"preload_module_classes",val:": typing.Optional[list[str]] = None"}],parametersDescription:[{anchor:"accelerate.cpu_offload.model",description:`<strong>model</strong> (<code>torch.nn.Module</code>) &#x2014;
The model to offload.`,name:"model"},{anchor:"accelerate.cpu_offload.execution_device",description:`<strong>execution_device</strong> (<code>torch.device</code>, <em>optional</em>) &#x2014;
The device on which the forward pass of the model will be executed (should be a GPU). Will default to the
model first parameter device.`,name:"execution_device"},{anchor:"accelerate.cpu_offload.offload_buffers",description:`<strong>offload_buffers</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to offload the buffers with the model parameters.`,name:"offload_buffers"},{anchor:"accelerate.cpu_offload.state_dict",description:`<strong>state_dict</strong> (<code>Dict[str, torch.Tensor]</code>, <em>optional</em>) &#x2014;
The state dict of the model that will be kept on CPU.`,name:"state_dict"},{anchor:"accelerate.cpu_offload.preload_module_classes",description:`<strong>preload_module_classes</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
A list of classes whose instances should load all their weights (even in the submodules) at the beginning
of the forward. This should only be used for classes that have submodules which are registered but not
called directly during the forward, for instance if a <code>dense</code> linear layer is registered, but at forward,
<code>dense.weight</code> and <code>dense.bias</code> are used in some operations instead of calling <code>dense</code> directly.`,name:"preload_module_classes"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/big_modeling.py#L173"}}),ke=new x({props:{title:"cpu_offload_with_hook",local:"accelerate.cpu_offload_with_hook",headingTag:"h3"}}),$e=new M({props:{name:"accelerate.cpu_offload_with_hook",anchor:"accelerate.cpu_offload_with_hook",parameters:[{name:"model",val:": Module"},{name:"execution_device",val:": typing.Union[int, str, torch.device, NoneType] = None"},{name:"prev_module_hook",val:": typing.Optional[accelerate.hooks.UserCpuOffloadHook] = None"}],parametersDescription:[{anchor:"accelerate.cpu_offload_with_hook.model",description:`<strong>model</strong> (<code>torch.nn.Module</code>) &#x2014;
The model to offload.`,name:"model"},{anchor:"accelerate.cpu_offload_with_hook.execution_device(str,",description:`<strong>execution_device(<code>str</code>,</strong> <code>int</code> or <code>torch.device</code>, <em>optional</em>) &#x2014;
The device on which the model should be executed. Will default to the MPS device if it&#x2019;s available, then
GPU 0 if there is a GPU, and finally to the CPU.`,name:"execution_device(str,"},{anchor:"accelerate.cpu_offload_with_hook.prev_module_hook",description:`<strong>prev_module_hook</strong> (<code>UserCpuOffloadHook</code>, <em>optional</em>) &#x2014;
The hook sent back by this function for a previous model in the pipeline you are running. If passed, its
offload method will be called just before the forward of the model to which this hook is attached.`,name:"prev_module_hook"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/big_modeling.py#L219"}}),se=new zt({props:{anchor:"accelerate.cpu_offload_with_hook.example",$$slots:{default:[In]},$$scope:{ctx:C}}}),we=new x({props:{title:"disk_offload",local:"accelerate.disk_offload",headingTag:"h3"}}),ye=new M({props:{name:"accelerate.disk_offload",anchor:"accelerate.disk_offload",parameters:[{name:"model",val:": Module"},{name:"offload_dir",val:": typing.Union[str, os.PathLike]"},{name:"execution_device",val:": typing.Optional[torch.device] = None"},{name:"offload_buffers",val:": bool = False"},{name:"preload_module_classes",val:": typing.Optional[list[str]] = None"}],parametersDescription:[{anchor:"accelerate.disk_offload.model",description:"<strong>model</strong> (<code>torch.nn.Module</code>) &#x2014; The model to offload.",name:"model"},{anchor:"accelerate.disk_offload.offload_dir",description:`<strong>offload_dir</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
The folder in which to offload the model weights (or where the model weights are already offloaded).`,name:"offload_dir"},{anchor:"accelerate.disk_offload.execution_device",description:`<strong>execution_device</strong> (<code>torch.device</code>, <em>optional</em>) &#x2014;
The device on which the forward pass of the model will be executed (should be a GPU). Will default to the
model&#x2019;s first parameter device.`,name:"execution_device"},{anchor:"accelerate.disk_offload.offload_buffers",description:`<strong>offload_buffers</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to offload the buffers with the model parameters.`,name:"offload_buffers"},{anchor:"accelerate.disk_offload.preload_module_classes",description:`<strong>preload_module_classes</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
A list of classes whose instances should load all their weights (even in the submodules) at the beginning
of the forward. This should only be used for classes that have submodules which are registered but not
called directly during the forward, for instance if a <code>dense</code> linear layer is registered, but at forward,
<code>dense.weight</code> and <code>dense.bias</code> are used in some operations instead of calling <code>dense</code> directly.`,name:"preload_module_classes"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/big_modeling.py#L263"}}),xe=new x({props:{title:"dispatch_model",local:"accelerate.dispatch_model",headingTag:"h3"}}),Me=new M({props:{name:"accelerate.dispatch_model",anchor:"accelerate.dispatch_model",parameters:[{name:"model",val:": Module"},{name:"device_map",val:": dict"},{name:"main_device",val:": typing.Optional[torch.device] = None"},{name:"state_dict",val:": typing.Optional[dict[str, torch.Tensor]] = None"},{name:"offload_dir",val:": typing.Union[str, os.PathLike, NoneType] = None"},{name:"offload_index",val:": typing.Optional[dict[str, str]] = None"},{name:"offload_buffers",val:": bool = False"},{name:"skip_keys",val:": typing.Union[str, list[str], NoneType] = None"},{name:"preload_module_classes",val:": typing.Optional[list[str]] = None"},{name:"force_hooks",val:": bool = False"}],parametersDescription:[{anchor:"accelerate.dispatch_model.model",description:`<strong>model</strong> (<code>torch.nn.Module</code>) &#x2014;
The model to dispatch.`,name:"model"},{anchor:"accelerate.dispatch_model.device_map",description:`<strong>device_map</strong> (<code>Dict[str, Union[str, int, torch.device]]</code>) &#x2014;
A dictionary mapping module names in the models <code>state_dict</code> to the device they should go to. Note that
<code>&quot;disk&quot;</code> is accepted even if it&#x2019;s not a proper value for <code>torch.device</code>.`,name:"device_map"},{anchor:"accelerate.dispatch_model.main_device",description:`<strong>main_device</strong> (<code>str</code>, <code>int</code> or <code>torch.device</code>, <em>optional</em>) &#x2014;
The main execution device. Will default to the first device in the <code>device_map</code> different from <code>&quot;cpu&quot;</code> or
<code>&quot;disk&quot;</code>.`,name:"main_device"},{anchor:"accelerate.dispatch_model.state_dict",description:`<strong>state_dict</strong> (<code>Dict[str, torch.Tensor]</code>, <em>optional</em>) &#x2014;
The state dict of the part of the model that will be kept on CPU.`,name:"state_dict"},{anchor:"accelerate.dispatch_model.offload_dir",description:`<strong>offload_dir</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
The folder in which to offload the model weights (or where the model weights are already offloaded).`,name:"offload_dir"},{anchor:"accelerate.dispatch_model.offload_index",description:`<strong>offload_index</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
A dictionary from weight name to their information (<code>dtype</code>/ <code>shape</code> or safetensors filename). Will default
to the index saved in <code>save_folder</code>.`,name:"offload_index"},{anchor:"accelerate.dispatch_model.offload_buffers",description:`<strong>offload_buffers</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to offload the buffers with the model parameters.`,name:"offload_buffers"},{anchor:"accelerate.dispatch_model.skip_keys",description:`<strong>skip_keys</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
A list of keys to ignore when moving inputs or outputs between devices.`,name:"skip_keys"},{anchor:"accelerate.dispatch_model.preload_module_classes",description:`<strong>preload_module_classes</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
A list of classes whose instances should load all their weights (even in the submodules) at the beginning
of the forward. This should only be used for classes that have submodules which are registered but not
called directly during the forward, for instance if a <code>dense</code> linear layer is registered, but at forward,
<code>dense.weight</code> and <code>dense.bias</code> are used in some operations instead of calling <code>dense</code> directly.`,name:"preload_module_classes"},{anchor:"accelerate.dispatch_model.force_hooks",description:`<strong>force_hooks</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force device hooks to be attached to the model even if all layers are dispatched to a
single device.`,name:"force_hooks"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/big_modeling.py#L309"}}),Te=new x({props:{title:"load_checkpoint_and_dispatch",local:"accelerate.load_checkpoint_and_dispatch",headingTag:"h3"}}),Ue=new M({props:{name:"accelerate.load_checkpoint_and_dispatch",anchor:"accelerate.load_checkpoint_and_dispatch",parameters:[{name:"model",val:": Module"},{name:"checkpoint",val:": typing.Union[str, os.PathLike]"},{name:"device_map",val:": typing.Union[str, dict[str, typing.Union[int, str, torch.device]], NoneType] = None"},{name:"max_memory",val:": typing.Optional[dict[typing.Union[int, str], typing.Union[int, str]]] = None"},{name:"no_split_module_classes",val:": typing.Optional[list[str]] = None"},{name:"offload_folder",val:": typing.Union[str, os.PathLike, NoneType] = None"},{name:"offload_buffers",val:": bool = False"},{name:"dtype",val:": typing.Union[str, torch.dtype, NoneType] = None"},{name:"offload_state_dict",val:": typing.Optional[bool] = None"},{name:"skip_keys",val:": typing.Union[str, list[str], NoneType] = None"},{name:"preload_module_classes",val:": typing.Optional[list[str]] = None"},{name:"force_hooks",val:": bool = False"},{name:"strict",val:": bool = False"},{name:"full_state_dict",val:": bool = True"},{name:"broadcast_from_rank0",val:": bool = False"}],parametersDescription:[{anchor:"accelerate.load_checkpoint_and_dispatch.model",description:"<strong>model</strong> (<code>torch.nn.Module</code>) &#x2014; The model in which we want to load a checkpoint.",name:"model"},{anchor:"accelerate.load_checkpoint_and_dispatch.checkpoint",description:`<strong>checkpoint</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
The folder checkpoint to load. It can be:</p>
<ul>
<li>a path to a file containing a whole model state dict</li>
<li>a path to a <code>.json</code> file containing the index to a sharded checkpoint</li>
<li>a path to a folder containing a unique <code>.index.json</code> file and the shards of a checkpoint.</li>
</ul>`,name:"checkpoint"},{anchor:"accelerate.load_checkpoint_and_dispatch.device_map",description:`<strong>device_map</strong> (<code>Dict[str, Union[int, str, torch.device]]</code>, <em>optional</em>) &#x2014;
A map that specifies where each submodule should go. It doesn&#x2019;t need to be refined to each parameter/buffer
name, once a given module name is inside, every submodule of it will be sent to the same device.</p>
<p>To have Accelerate compute the most optimized <code>device_map</code> automatically, set <code>device_map=&quot;auto&quot;</code>. For more
information about each option see <a href="../concept_guides/big_model_inference#designing-a-device-map">here</a>.
Defaults to None, which means <a href="/docs/accelerate/main/en/package_reference/big_modeling#accelerate.dispatch_model">dispatch_model()</a> will not be called.`,name:"device_map"},{anchor:"accelerate.load_checkpoint_and_dispatch.max_memory",description:`<strong>max_memory</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
A dictionary device identifier to maximum memory. Will default to the maximum memory available for each GPU
and the available CPU RAM if unset.`,name:"max_memory"},{anchor:"accelerate.load_checkpoint_and_dispatch.no_split_module_classes",description:`<strong>no_split_module_classes</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
A list of layer class names that should never be split across device (for instance any layer that has a
residual connection).`,name:"no_split_module_classes"},{anchor:"accelerate.load_checkpoint_and_dispatch.offload_folder",description:`<strong>offload_folder</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
If the <code>device_map</code> contains any value <code>&quot;disk&quot;</code>, the folder where we will offload weights.`,name:"offload_folder"},{anchor:"accelerate.load_checkpoint_and_dispatch.offload_buffers",description:`<strong>offload_buffers</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
In the layers that are offloaded on the CPU or the hard drive, whether or not to offload the buffers as
well as the parameters.`,name:"offload_buffers"},{anchor:"accelerate.load_checkpoint_and_dispatch.dtype",description:`<strong>dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
If provided, the weights will be converted to that type when loaded.`,name:"dtype"},{anchor:"accelerate.load_checkpoint_and_dispatch.offload_state_dict",description:`<strong>offload_state_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If <code>True</code>, will temporarily offload the CPU state dict on the hard drive to avoid getting out of CPU RAM if
the weight of the CPU state dict + the biggest shard does not fit. Will default to <code>True</code> if the device map
picked contains <code>&quot;disk&quot;</code> values.`,name:"offload_state_dict"},{anchor:"accelerate.load_checkpoint_and_dispatch.skip_keys",description:`<strong>skip_keys</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
A list of keys to ignore when moving inputs or outputs between devices.`,name:"skip_keys"},{anchor:"accelerate.load_checkpoint_and_dispatch.preload_module_classes",description:`<strong>preload_module_classes</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
A list of classes whose instances should load all their weights (even in the submodules) at the beginning
of the forward. This should only be used for classes that have submodules which are registered but not
called directly during the forward, for instance if a <code>dense</code> linear layer is registered, but at forward,
<code>dense.weight</code> and <code>dense.bias</code> are used in some operations instead of calling <code>dense</code> directly.`,name:"preload_module_classes"},{anchor:"accelerate.load_checkpoint_and_dispatch.force_hooks",description:`<strong>force_hooks</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force device hooks to be attached to the model even if all layers are dispatched to a
single device.`,name:"force_hooks"},{anchor:"accelerate.load_checkpoint_and_dispatch.strict",description:`<strong>strict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to strictly enforce that the keys in the checkpoint state_dict match the keys of the model&#x2019;s
state_dict.`,name:"strict"},{anchor:"accelerate.load_checkpoint_and_dispatch.full_state_dict",description:`<strong>full_state_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014; if this is set to <code>True</code>, all the tensors in the
loaded state_dict will be gathered. No ShardedTensor and DTensor will be in the loaded state_dict.`,name:"full_state_dict"},{anchor:"accelerate.load_checkpoint_and_dispatch.broadcast_from_rank0",description:`<strong>broadcast_from_rank0</strong> (<code>False</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014; when the option is <code>True</code>, a distributed
<code>ProcessGroup</code> must be initialized. rank0 should receive a full state_dict and will broadcast the tensors
in the state_dict one by one to other ranks. Other ranks will receive the tensors and shard (if applicable)
according to the local shards in the model.`,name:"broadcast_from_rank0"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/big_modeling.py#L512"}}),le=new zt({props:{anchor:"accelerate.load_checkpoint_and_dispatch.example",$$slots:{default:[Nn]},$$scope:{ctx:C}}}),Ce=new x({props:{title:"load_checkpoint_in_model",local:"accelerate.load_checkpoint_in_model",headingTag:"h3"}}),je=new M({props:{name:"accelerate.load_checkpoint_in_model",anchor:"accelerate.load_checkpoint_in_model",parameters:[{name:"model",val:": Module"},{name:"checkpoint",val:": typing.Union[str, os.PathLike]"},{name:"device_map",val:": typing.Optional[dict[str, typing.Union[int, str, torch.device]]] = None"},{name:"offload_folder",val:": typing.Union[str, os.PathLike, NoneType] = None"},{name:"dtype",val:": typing.Union[str, torch.dtype, NoneType] = None"},{name:"offload_state_dict",val:": bool = False"},{name:"offload_buffers",val:": bool = False"},{name:"keep_in_fp32_modules",val:": list = None"},{name:"offload_8bit_bnb",val:": bool = False"},{name:"strict",val:": bool = False"},{name:"full_state_dict",val:": bool = True"},{name:"broadcast_from_rank0",val:": bool = False"}],parametersDescription:[{anchor:"accelerate.load_checkpoint_in_model.model",description:`<strong>model</strong> (<code>torch.nn.Module</code>) &#x2014;
The model in which we want to load a checkpoint.`,name:"model"},{anchor:"accelerate.load_checkpoint_in_model.checkpoint",description:`<strong>checkpoint</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
The folder checkpoint to load. It can be:<ul>
<li>a path to a file containing a whole model state dict</li>
<li>a path to a <code>.json</code> file containing the index to a sharded checkpoint</li>
<li>a path to a folder containing a unique <code>.index.json</code> file and the shards of a checkpoint.</li>
<li>a path to a folder containing a unique pytorch_model.bin or a model.safetensors file.</li>
</ul>`,name:"checkpoint"},{anchor:"accelerate.load_checkpoint_in_model.device_map",description:`<strong>device_map</strong> (<code>Dict[str, Union[int, str, torch.device]]</code>, <em>optional</em>) &#x2014;
A map that specifies where each submodule should go. It doesn&#x2019;t need to be refined to each parameter/buffer
name, once a given module name is inside, every submodule of it will be sent to the same device.`,name:"device_map"},{anchor:"accelerate.load_checkpoint_in_model.offload_folder",description:`<strong>offload_folder</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
If the <code>device_map</code> contains any value <code>&quot;disk&quot;</code>, the folder where we will offload weights.`,name:"offload_folder"},{anchor:"accelerate.load_checkpoint_in_model.dtype",description:`<strong>dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
If provided, the weights will be converted to that type when loaded.`,name:"dtype"},{anchor:"accelerate.load_checkpoint_in_model.offload_state_dict",description:`<strong>offload_state_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, will temporarily offload the CPU state dict on the hard drive to avoid getting out of CPU RAM if
the weight of the CPU state dict + the biggest shard does not fit.`,name:"offload_state_dict"},{anchor:"accelerate.load_checkpoint_in_model.offload_buffers",description:`<strong>offload_buffers</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to include the buffers in the weights offloaded to disk.`,name:"offload_buffers"},{anchor:"accelerate.load_checkpoint_in_model.keep_in_fp32_modules(List[str],",description:`<strong>keep_in_fp32_modules(<code>List[str]</code>,</strong> <em>optional</em>) &#x2014;
A list of the modules that we keep in <code>torch.float32</code> dtype.`,name:"keep_in_fp32_modules(List[str],"},{anchor:"accelerate.load_checkpoint_in_model.offload_8bit_bnb",description:`<strong>offload_8bit_bnb</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to enable offload of 8-bit modules on cpu/disk.`,name:"offload_8bit_bnb"},{anchor:"accelerate.load_checkpoint_in_model.strict",description:`<strong>strict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to strictly enforce that the keys in the checkpoint state_dict match the keys of the model&#x2019;s
state_dict.`,name:"strict"},{anchor:"accelerate.load_checkpoint_in_model.full_state_dict",description:`<strong>full_state_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014; if this is set to <code>True</code>, all the tensors in the
loaded state_dict will be gathered. No ShardedTensor and DTensor will be in the loaded state_dict.`,name:"full_state_dict"},{anchor:"accelerate.load_checkpoint_in_model.broadcast_from_rank0",description:`<strong>broadcast_from_rank0</strong> (<code>False</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014; when the option is <code>True</code>, a distributed
<code>ProcessGroup</code> must be initialized. rank0 should receive a full state_dict and will broadcast the tensors
in the state_dict one by one to other ranks. Other ranks will receive the tensors and shard (if applicable)
according to the local shards in the model.`,name:"broadcast_from_rank0"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/utils/modeling.py#L1804"}}),de=new sa({props:{warning:!0,$$slots:{default:[Fn]},$$scope:{ctx:C}}}),Je=new x({props:{title:"infer_auto_device_map",local:"accelerate.infer_auto_device_map",headingTag:"h3"}}),Ge=new M({props:{name:"accelerate.infer_auto_device_map",anchor:"accelerate.infer_auto_device_map",parameters:[{name:"model",val:": Module"},{name:"max_memory",val:": typing.Optional[dict[typing.Union[int, str], typing.Union[int, str]]] = None"},{name:"no_split_module_classes",val:": typing.Optional[list[str]] = None"},{name:"dtype",val:": typing.Union[str, torch.dtype, NoneType] = None"},{name:"special_dtypes",val:": typing.Optional[dict[str, typing.Union[str, torch.dtype]]] = None"},{name:"verbose",val:": bool = False"},{name:"clean_result",val:": bool = True"},{name:"offload_buffers",val:": bool = False"},{name:"fallback_allocation",val:": bool = False"}],parametersDescription:[{anchor:"accelerate.infer_auto_device_map.model",description:`<strong>model</strong> (<code>torch.nn.Module</code>) &#x2014;
The model to analyze.`,name:"model"},{anchor:"accelerate.infer_auto_device_map.max_memory",description:`<strong>max_memory</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
A dictionary device identifier to maximum memory. Will default to the maximum memory available if unset.
Example: <code>max_memory={0: &quot;1GB&quot;}</code>.`,name:"max_memory"},{anchor:"accelerate.infer_auto_device_map.no_split_module_classes",description:`<strong>no_split_module_classes</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
A list of layer class names that should never be split across device (for instance any layer that has a
residual connection).`,name:"no_split_module_classes"},{anchor:"accelerate.infer_auto_device_map.dtype",description:`<strong>dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
If provided, the weights will be converted to that type when loaded.`,name:"dtype"},{anchor:"accelerate.infer_auto_device_map.special_dtypes",description:`<strong>special_dtypes</strong> (<code>Dict[str, Union[str, torch.device]]</code>, <em>optional</em>) &#x2014;
If provided, special dtypes to consider for some specific weights (will override dtype used as default for
all weights).`,name:"special_dtypes"},{anchor:"accelerate.infer_auto_device_map.verbose",description:`<strong>verbose</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to provide debugging statements as the function builds the device_map.`,name:"verbose"},{anchor:"accelerate.infer_auto_device_map.clean_result",description:`<strong>clean_result</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Clean the resulting device_map by grouping all submodules that go on the same device together.`,name:"clean_result"},{anchor:"accelerate.infer_auto_device_map.offload_buffers",description:`<strong>offload_buffers</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
In the layers that are offloaded on the CPU or the hard drive, whether or not to offload the buffers as
well as the parameters.`,name:"offload_buffers"},{anchor:"accelerate.infer_auto_device_map.fallback_allocation",description:`<strong>fallback_allocation</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
When regular allocation fails, try to allocate a module that fits in the size limit using BFS.`,name:"fallback_allocation"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/utils/modeling.py#L1294"}}),ce=new sa({props:{$$slots:{default:[Hn]},$$scope:{ctx:C}}}),Ie=new x({props:{title:"Hooks",local:"hooks",headingTag:"h2"}}),Ne=new x({props:{title:"ModelHook",local:"accelerate.hooks.ModelHook",headingTag:"h3"}}),Fe=new M({props:{name:"class accelerate.hooks.ModelHook",anchor:"accelerate.hooks.ModelHook",parameters:[],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/hooks.py#L43"}}),He=new M({props:{name:"detach_hook",anchor:"accelerate.hooks.ModelHook.detach_hook",parameters:[{name:"module",val:""}],parametersDescription:[{anchor:"accelerate.hooks.ModelHook.detach_hook.module",description:"<strong>module</strong> (<code>torch.nn.Module</code>) &#x2014; The module detached from this hook.",name:"module"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/hooks.py#L91"}}),We=new M({props:{name:"init_hook",anchor:"accelerate.hooks.ModelHook.init_hook",parameters:[{name:"module",val:""}],parametersDescription:[{anchor:"accelerate.hooks.ModelHook.init_hook.module",description:"<strong>module</strong> (<code>torch.nn.Module</code>) &#x2014; The module attached to this hook.",name:"module"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/hooks.py#L55"}}),Ze=new M({props:{name:"post_forward",anchor:"accelerate.hooks.ModelHook.post_forward",parameters:[{name:"module",val:""},{name:"output",val:""}],parametersDescription:[{anchor:"accelerate.hooks.ModelHook.post_forward.module",description:"<strong>module</strong> (<code>torch.nn.Module</code>) &#x2014; The module whose forward pass been executed just before this event.",name:"module"},{anchor:"accelerate.hooks.ModelHook.post_forward.output",description:"<strong>output</strong> (<code>Any</code>) &#x2014; The output of the module.",name:"output"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/hooks.py#L78",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed <code>output</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Any</code></p>
`}}),De=new M({props:{name:"pre_forward",anchor:"accelerate.hooks.ModelHook.pre_forward",parameters:[{name:"module",val:""},{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"accelerate.hooks.ModelHook.pre_forward.module",description:"<strong>module</strong> (<code>torch.nn.Module</code>) &#x2014; The module whose forward pass will be executed just after this event.",name:"module"},{anchor:"accelerate.hooks.ModelHook.pre_forward.args",description:"<strong>args</strong> (<code>Tuple[Any]</code>) &#x2014; The positional arguments passed to the module.",name:"args"},{anchor:"accelerate.hooks.ModelHook.pre_forward.kwargs",description:"<strong>kwargs</strong> (<code>Dict[Str, Any]</code>) &#x2014; The keyword arguments passed to the module.",name:"kwargs"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/hooks.py#L64",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple with the treated <code>args</code> and <code>kwargs</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Tuple[Tuple[Any], Dict[Str, Any]]</code></p>
`}}),Be=new x({props:{title:"AlignDevicesHook",local:"accelerate.hooks.AlignDevicesHook",headingTag:"h3"}}),Le=new M({props:{name:"class accelerate.hooks.AlignDevicesHook",anchor:"accelerate.hooks.AlignDevicesHook",parameters:[{name:"execution_device",val:": typing.Union[int, str, torch.device, NoneType] = None"},{name:"offload",val:": bool = False"},{name:"io_same_device",val:": bool = False"},{name:"weights_map",val:": typing.Optional[collections.abc.Mapping] = None"},{name:"offload_buffers",val:": bool = False"},{name:"place_submodules",val:": bool = False"},{name:"skip_keys",val:": typing.Union[str, list[str], NoneType] = None"},{name:"tied_params_map",val:": typing.Optional[dict[int, dict[torch.device, torch.Tensor]]] = None"}],parametersDescription:[{anchor:"accelerate.hooks.AlignDevicesHook.execution_device",description:`<strong>execution_device</strong> (<code>torch.device</code>, <em>optional</em>) &#x2014;
The device on which inputs and model weights should be placed before the forward pass.`,name:"execution_device"},{anchor:"accelerate.hooks.AlignDevicesHook.offload",description:`<strong>offload</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the weights should be offloaded after the forward pass.`,name:"offload"},{anchor:"accelerate.hooks.AlignDevicesHook.io_same_device",description:`<strong>io_same_device</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the output should be placed on the same device as the input was.`,name:"io_same_device"},{anchor:"accelerate.hooks.AlignDevicesHook.weights_map",description:`<strong>weights_map</strong> (<code>Mapping[str, torch.Tensor]</code>, <em>optional</em>) &#x2014;
When the model weights are offloaded, a (potentially lazy) map from param names to the tensor values.`,name:"weights_map"},{anchor:"accelerate.hooks.AlignDevicesHook.offload_buffers",description:`<strong>offload_buffers</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to include the associated module&#x2019;s buffers when offloading.`,name:"offload_buffers"},{anchor:"accelerate.hooks.AlignDevicesHook.place_submodules",description:`<strong>place_submodules</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to place the submodules on <code>execution_device</code> during the <code>init_hook</code> event.`,name:"place_submodules"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/hooks.py#L225"}}),Ve=new x({props:{title:"SequentialHook",local:"accelerate.hooks.SequentialHook",headingTag:"h3"}}),Ae=new M({props:{name:"class accelerate.hooks.SequentialHook",anchor:"accelerate.hooks.SequentialHook",parameters:[{name:"*hooks",val:""}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/hooks.py#L101"}}),Pe=new x({props:{title:"LayerwiseCastingHook",local:"accelerate.hooks.LayerwiseCastingHook",headingTag:"h3"}}),Re=new M({props:{name:"class accelerate.hooks.LayerwiseCastingHook",anchor:"accelerate.hooks.LayerwiseCastingHook",parameters:[{name:"storage_dtype",val:": dtype"},{name:"compute_dtype",val:": dtype"},{name:"non_blocking",val:": bool"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/hooks.py#L741"}}),Xe=new x({props:{title:"Adding Hooks",local:"adding-hooks",headingTag:"h2"}}),Ee=new x({props:{title:"add_hook_to_module",local:"accelerate.hooks.add_hook_to_module",headingTag:"h3"}}),ze=new M({props:{name:"accelerate.hooks.add_hook_to_module",anchor:"accelerate.hooks.add_hook_to_module",parameters:[{name:"module",val:": Module"},{name:"hook",val:": ModelHook"},{name:"append",val:": bool = False"}],parametersDescription:[{anchor:"accelerate.hooks.add_hook_to_module.module",description:`<strong>module</strong> (<code>torch.nn.Module</code>) &#x2014;
The module to attach a hook to.`,name:"module"},{anchor:"accelerate.hooks.add_hook_to_module.hook",description:`<strong>hook</strong> (<code>ModelHook</code>) &#x2014;
The hook to attach.`,name:"hook"},{anchor:"accelerate.hooks.add_hook_to_module.append",description:`<strong>append</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the hook should be chained with an existing one (if module already contains a hook) or not.`,name:"append"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/hooks.py#L130",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The same module, with the hook attached (the module is modified in place, so the result can
be discarded).</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.nn.Module</code></p>
`}}),pe=new sa({props:{warning:!0,$$slots:{default:[Wn]},$$scope:{ctx:C}}}),Qe=new x({props:{title:"attach_execution_device_hook",local:"accelerate.hooks.attach_execution_device_hook",headingTag:"h3"}}),qe=new M({props:{name:"accelerate.hooks.attach_execution_device_hook",anchor:"accelerate.hooks.attach_execution_device_hook",parameters:[{name:"module",val:": Module"},{name:"execution_device",val:": typing.Union[int, str, torch.device]"},{name:"skip_keys",val:": typing.Union[str, list[str], NoneType] = None"},{name:"preload_module_classes",val:": typing.Optional[list[str]] = None"},{name:"tied_params_map",val:": typing.Optional[dict[int, dict[torch.device, torch.Tensor]]] = None"}],parametersDescription:[{anchor:"accelerate.hooks.attach_execution_device_hook.module",description:`<strong>module</strong> (<code>torch.nn.Module</code>) &#x2014;
The module where we want to attach the hooks.`,name:"module"},{anchor:"accelerate.hooks.attach_execution_device_hook.execution_device",description:`<strong>execution_device</strong> (<code>int</code>, <code>str</code> or <code>torch.device</code>) &#x2014;
The device on which inputs and model weights should be placed before the forward pass.`,name:"execution_device"},{anchor:"accelerate.hooks.attach_execution_device_hook.skip_keys",description:`<strong>skip_keys</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
A list of keys to ignore when moving inputs or outputs between devices.`,name:"skip_keys"},{anchor:"accelerate.hooks.attach_execution_device_hook.preload_module_classes",description:`<strong>preload_module_classes</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
A list of classes whose instances should load all their weights (even in the submodules) at the beginning
of the forward. This should only be used for classes that have submodules which are registered but not
called directly during the forward, for instance if a <code>dense</code> linear layer is registered, but at forward,
<code>dense.weight</code> and <code>dense.bias</code> are used in some operations instead of calling <code>dense</code> directly.`,name:"preload_module_classes"},{anchor:"accelerate.hooks.attach_execution_device_hook.tied_params_map",description:`<strong>tied_params_map</strong> (Optional[Dict[int, Dict[torch.device, torch.Tensor]]], <em>optional</em>, defaults to <code>None</code>) &#x2014;
A map of data pointers to dictionaries of devices to already dispatched tied weights. For a given execution
device, this parameter is useful to reuse the first available pointer of a shared weight for all others,
instead of duplicating memory.`,name:"tied_params_map"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/hooks.py#L412"}}),Ye=new x({props:{title:"attach_align_device_hook",local:"accelerate.hooks.attach_align_device_hook",headingTag:"h3"}}),Se=new M({props:{name:"accelerate.hooks.attach_align_device_hook",anchor:"accelerate.hooks.attach_align_device_hook",parameters:[{name:"module",val:": Module"},{name:"execution_device",val:": typing.Optional[torch.device] = None"},{name:"offload",val:": bool = False"},{name:"weights_map",val:": typing.Optional[collections.abc.Mapping] = None"},{name:"offload_buffers",val:": bool = False"},{name:"module_name",val:": str = ''"},{name:"skip_keys",val:": typing.Union[str, list[str], NoneType] = None"},{name:"preload_module_classes",val:": typing.Optional[list[str]] = None"},{name:"tied_params_map",val:": typing.Optional[dict[int, dict[torch.device, torch.Tensor]]] = None"}],parametersDescription:[{anchor:"accelerate.hooks.attach_align_device_hook.module",description:`<strong>module</strong> (<code>torch.nn.Module</code>) &#x2014;
The module where we want to attach the hooks.`,name:"module"},{anchor:"accelerate.hooks.attach_align_device_hook.execution_device",description:`<strong>execution_device</strong> (<code>torch.device</code>, <em>optional</em>) &#x2014;
The device on which inputs and model weights should be placed before the forward pass.`,name:"execution_device"},{anchor:"accelerate.hooks.attach_align_device_hook.offload",description:`<strong>offload</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the weights should be offloaded after the forward pass.`,name:"offload"},{anchor:"accelerate.hooks.attach_align_device_hook.weights_map",description:`<strong>weights_map</strong> (<code>Mapping[str, torch.Tensor]</code>, <em>optional</em>) &#x2014;
When the model weights are offloaded, a (potentially lazy) map from param names to the tensor values.`,name:"weights_map"},{anchor:"accelerate.hooks.attach_align_device_hook.offload_buffers",description:`<strong>offload_buffers</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to include the associated module&#x2019;s buffers when offloading.`,name:"offload_buffers"},{anchor:"accelerate.hooks.attach_align_device_hook.module_name",description:`<strong>module_name</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
The name of the module.`,name:"module_name"},{anchor:"accelerate.hooks.attach_align_device_hook.skip_keys",description:`<strong>skip_keys</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
A list of keys to ignore when moving inputs or outputs between devices.`,name:"skip_keys"},{anchor:"accelerate.hooks.attach_align_device_hook.preload_module_classes",description:`<strong>preload_module_classes</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
A list of classes whose instances should load all their weights (even in the submodules) at the beginning
of the forward. This should only be used for classes that have submodules which are registered but not
called directly during the forward, for instance if a <code>dense</code> linear layer is registered, but at forward,
<code>dense.weight</code> and <code>dense.bias</code> are used in some operations instead of calling <code>dense</code> directly.`,name:"preload_module_classes"},{anchor:"accelerate.hooks.attach_align_device_hook.tied_params_map",description:`<strong>tied_params_map</strong> (Optional[Dict[int, Dict[torch.device, torch.Tensor]]], <em>optional</em>, defaults to <code>None</code>) &#x2014;
A map of data pointers to dictionaries of devices to already dispatched tied weights. For a given execution
device, this parameter is useful to reuse the first available pointer of a shared weight for all others,
instead of duplicating memory.`,name:"tied_params_map"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/hooks.py#L460"}}),Oe=new x({props:{title:"attach_align_device_hook_on_blocks",local:"accelerate.hooks.attach_align_device_hook_on_blocks",headingTag:"h3"}}),Ke=new M({props:{name:"accelerate.hooks.attach_align_device_hook_on_blocks",anchor:"accelerate.hooks.attach_align_device_hook_on_blocks",parameters:[{name:"module",val:": Module"},{name:"execution_device",val:": typing.Union[torch.device, dict[str, torch.device], NoneType] = None"},{name:"offload",val:": typing.Union[bool, dict[str, bool]] = False"},{name:"weights_map",val:": Mapping = None"},{name:"offload_buffers",val:": bool = False"},{name:"module_name",val:": str = ''"},{name:"skip_keys",val:": typing.Union[str, list[str], NoneType] = None"},{name:"preload_module_classes",val:": typing.Optional[list[str]] = None"},{name:"tied_params_map",val:": typing.Optional[dict[int, dict[torch.device, torch.Tensor]]] = None"}],parametersDescription:[{anchor:"accelerate.hooks.attach_align_device_hook_on_blocks.module",description:`<strong>module</strong> (<code>torch.nn.Module</code>) &#x2014;
The module where we want to attach the hooks.`,name:"module"},{anchor:"accelerate.hooks.attach_align_device_hook_on_blocks.execution_device",description:`<strong>execution_device</strong> (<code>torch.device</code> or <code>Dict[str, torch.device]</code>, <em>optional</em>) &#x2014;
The device on which inputs and model weights should be placed before the forward pass. It can be one device
for the whole module, or a dictionary mapping module name to device.`,name:"execution_device"},{anchor:"accelerate.hooks.attach_align_device_hook_on_blocks.offload",description:`<strong>offload</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the weights should be offloaded after the forward pass. It can be one boolean for the whole
module, or a dictionary mapping module name to boolean.`,name:"offload"},{anchor:"accelerate.hooks.attach_align_device_hook_on_blocks.weights_map",description:`<strong>weights_map</strong> (<code>Mapping[str, torch.Tensor]</code>, <em>optional</em>) &#x2014;
When the model weights are offloaded, a (potentially lazy) map from param names to the tensor values.`,name:"weights_map"},{anchor:"accelerate.hooks.attach_align_device_hook_on_blocks.offload_buffers",description:`<strong>offload_buffers</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to include the associated module&#x2019;s buffers when offloading.`,name:"offload_buffers"},{anchor:"accelerate.hooks.attach_align_device_hook_on_blocks.module_name",description:`<strong>module_name</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
The name of the module.`,name:"module_name"},{anchor:"accelerate.hooks.attach_align_device_hook_on_blocks.skip_keys",description:`<strong>skip_keys</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
A list of keys to ignore when moving inputs or outputs between devices.`,name:"skip_keys"},{anchor:"accelerate.hooks.attach_align_device_hook_on_blocks.preload_module_classes",description:`<strong>preload_module_classes</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
A list of classes whose instances should load all their weights (even in the submodules) at the beginning
of the forward. This should only be used for classes that have submodules which are registered but not
called directly during the forward, for instance if a <code>dense</code> linear layer is registered, but at forward,
<code>dense.weight</code> and <code>dense.bias</code> are used in some operations instead of calling <code>dense</code> directly.`,name:"preload_module_classes"},{anchor:"accelerate.hooks.attach_align_device_hook_on_blocks.tied_params_map",description:`<strong>tied_params_map</strong> (Optional[Dict[int, Dict[torch.device, torch.Tensor]]], <em>optional</em>, defaults to <code>None</code>) &#x2014;
A map of data pointers to dictionaries of devices to already dispatched tied weights. For a given execution
device, this parameter is useful to reuse the first available pointer of a shared weight for all others,
instead of duplicating memory.`,name:"tied_params_map"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/hooks.py#L555"}}),et=new x({props:{title:"attach_layerwise_casting_hooks",local:"accelerate.big_modeling.attach_layerwise_casting_hooks",headingTag:"h3"}}),tt=new M({props:{name:"accelerate.big_modeling.attach_layerwise_casting_hooks",anchor:"accelerate.big_modeling.attach_layerwise_casting_hooks",parameters:[{name:"module",val:": Module"},{name:"storage_dtype",val:": dtype"},{name:"compute_dtype",val:": dtype"},{name:"skip_modules_pattern",val:": typing.Union[str, tuple[str, ...]] = None"},{name:"skip_modules_classes",val:": typing.Optional[tuple[type[torch.nn.modules.module.Module], ...]] = None"},{name:"non_blocking",val:": bool = False"}],parametersDescription:[{anchor:"accelerate.big_modeling.attach_layerwise_casting_hooks.module",description:`<strong>module</strong> (<code>torch.nn.Module</code>) &#x2014;
The module whose leaf modules will be cast to a high precision dtype for computation, and to a low
precision dtype for storage.`,name:"module"},{anchor:"accelerate.big_modeling.attach_layerwise_casting_hooks.storage_dtype",description:`<strong>storage_dtype</strong> (<code>torch.dtype</code>) &#x2014;
The dtype to cast the module to before/after the forward pass for storage.`,name:"storage_dtype"},{anchor:"accelerate.big_modeling.attach_layerwise_casting_hooks.compute_dtype",description:`<strong>compute_dtype</strong> (<code>torch.dtype</code>) &#x2014;
The dtype to cast the module to during the forward pass for computation.`,name:"compute_dtype"},{anchor:"accelerate.big_modeling.attach_layerwise_casting_hooks.skip_modules_pattern",description:`<strong>skip_modules_pattern</strong> (<code>tuple[str, ...]</code>, defaults to <code>None</code>) &#x2014;
A list of patterns to match the names of the modules to skip during the layerwise casting process. If set
to <code>None</code> alongside <code>skip_modules_classes</code> being <code>None</code>, the layerwise casting is applied directly to the
module instead of its internal submodules.`,name:"skip_modules_pattern"},{anchor:"accelerate.big_modeling.attach_layerwise_casting_hooks.skip_modules_classes",description:`<strong>skip_modules_classes</strong> (<code>tuple[type[torch.nn.Module], ...]</code>, defaults to <code>None</code>) &#x2014;
A list of module classes to skip during the layerwise casting process.`,name:"skip_modules_classes"},{anchor:"accelerate.big_modeling.attach_layerwise_casting_hooks.non_blocking",description:`<strong>non_blocking</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, the weight casting operations are non-blocking.`,name:"non_blocking"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/big_modeling.py#L653"}}),fe=new zt({props:{anchor:"accelerate.big_modeling.attach_layerwise_casting_hooks.example",$$slots:{default:[Zn]},$$scope:{ctx:C}}}),ue=new zt({props:{anchor:"accelerate.big_modeling.attach_layerwise_casting_hooks.example-2",$$slots:{default:[Dn]},$$scope:{ctx:C}}}),ot=new x({props:{title:"Removing Hooks",local:"removing-hooks",headingTag:"h2"}}),at=new x({props:{title:"remove_hook_from_module",local:"accelerate.hooks.remove_hook_from_module",headingTag:"h3"}}),nt=new M({props:{name:"accelerate.hooks.remove_hook_from_module",anchor:"accelerate.hooks.remove_hook_from_module",parameters:[{name:"module",val:": Module"},{name:"recurse",val:" = False"}],parametersDescription:[{anchor:"accelerate.hooks.remove_hook_from_module.module",description:"<strong>module</strong> (<code>torch.nn.Module</code>) &#x2014; The module to attach a hook to.",name:"module"},{anchor:"accelerate.hooks.remove_hook_from_module.recurse",description:"<strong>recurse</strong> (<code>bool</code>, <strong>optional</strong>) &#x2014; Whether to remove the hooks recursively",name:"recurse"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/hooks.py#L188",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The same module, with the hook detached (the module is modified in place, so the result can
be discarded).</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.nn.Module</code></p>
`}}),st=new x({props:{title:"remove_hook_from_submodules",local:"accelerate.hooks.remove_hook_from_submodules",headingTag:"h3"}}),lt=new M({props:{name:"accelerate.hooks.remove_hook_from_submodules",anchor:"accelerate.hooks.remove_hook_from_submodules",parameters:[{name:"module",val:": Module"}],parametersDescription:[{anchor:"accelerate.hooks.remove_hook_from_submodules.module",description:"<strong>module</strong> (<code>torch.nn.Module</code>) &#x2014; The module on which to remove all hooks.",name:"module"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/hooks.py#L543"}}),dt=new x({props:{title:"Utilities",local:"utilities",headingTag:"h2"}}),ct=new x({props:{title:"has_offloaded_params",local:"accelerate.utils.has_offloaded_params",headingTag:"h3"}}),rt=new M({props:{name:"accelerate.utils.has_offloaded_params",anchor:"accelerate.utils.has_offloaded_params",parameters:[{name:"module",val:": Module"}],parametersDescription:[{anchor:"accelerate.utils.has_offloaded_params.module",description:"<strong>module</strong> (<code>torch.nn.Module</code>) &#x2014; The module to check for an offload hook.",name:"module"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/utils/modeling.py#L2147",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>True</code> if the module has an offload hook and offloading is enabled, <code>False</code> otherwise.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>bool</p>
`}}),it=new x({props:{title:"align_module_device",local:"accelerate.utils.align_module_device",headingTag:"h3"}}),mt=new M({props:{name:"accelerate.utils.align_module_device",anchor:"accelerate.utils.align_module_device",parameters:[{name:"module",val:": Module"},{name:"execution_device",val:": typing.Optional[torch.device] = None"}],parametersDescription:[{anchor:"accelerate.utils.align_module_device.module",description:`<strong>module</strong> (<code>torch.nn.Module</code>) &#x2014;
Module with parameters to align.`,name:"module"},{anchor:"accelerate.utils.align_module_device.execution_device",description:`<strong>execution_device</strong> (<code>torch.device</code>, <em>optional</em>) &#x2014;
If provided, overrides the module&#x2019;s execution device within the context. Otherwise, use hook execution
device or pass`,name:"execution_device"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/utils/modeling.py#L2163"}}),ht=new jn({props:{source:"https://github.com/huggingface/accelerate/blob/main/docs/source/package_reference/big_modeling.md"}}),{c(){l=f("meta"),k=a(),g=f("p"),v=a(),c($.$$.fragment),_=a(),c(T.$$.fragment),qt=a(),c(_e.$$.fragment),Yt=a(),G=f("div"),c(ge.$$.fragment),la=a(),_t=f("p"),_t.textContent=Qa,da=a(),c(ae.$$.fragment),ca=a(),c(ne.$$.fragment),St=a(),c(ve.$$.fragment),Ot=a(),L=f("div"),c(be.$$.fragment),ra=a(),gt=f("p"),gt.textContent=qa,Kt=a(),c(ke.$$.fragment),eo=a(),N=f("div"),c($e.$$.fragment),ia=a(),vt=f("p"),vt.innerHTML=Ya,ma=a(),c(se.$$.fragment),to=a(),c(we.$$.fragment),oo=a(),V=f("div"),c(ye.$$.fragment),ha=a(),bt=f("p"),bt.textContent=Sa,ao=a(),c(xe.$$.fragment),no=a(),A=f("div"),c(Me.$$.fragment),pa=a(),kt=f("p"),kt.textContent=Oa,so=a(),c(Te.$$.fragment),lo=a(),F=f("div"),c(Ue.$$.fragment),fa=a(),$t=f("p"),$t.textContent=Ka,ua=a(),c(le.$$.fragment),co=a(),c(Ce.$$.fragment),ro=a(),H=f("div"),c(je.$$.fragment),_a=a(),wt=f("p"),wt.textContent=en,ga=a(),c(de.$$.fragment),io=a(),c(Je.$$.fragment),mo=a(),I=f("div"),c(Ge.$$.fragment),va=a(),yt=f("p"),yt.textContent=tn,ba=a(),xt=f("ul"),xt.innerHTML=on,ka=a(),c(ce.$$.fragment),ho=a(),c(Ie.$$.fragment),po=a(),c(Ne.$$.fragment),fo=a(),U=f("div"),c(Fe.$$.fragment),$a=a(),Mt=f("p"),Mt.textContent=an,wa=a(),Tt=f("p"),Tt.textContent=nn,ya=a(),Ut=f("ul"),Ut.innerHTML=sn,xa=a(),re=f("div"),c(He.$$.fragment),Ma=a(),Ct=f("p"),Ct.textContent=ln,Ta=a(),ie=f("div"),c(We.$$.fragment),Ua=a(),jt=f("p"),jt.textContent=dn,Ca=a(),me=f("div"),c(Ze.$$.fragment),ja=a(),Jt=f("p"),Jt.textContent=cn,Ja=a(),he=f("div"),c(De.$$.fragment),Ga=a(),Gt=f("p"),Gt.textContent=rn,uo=a(),c(Be.$$.fragment),_o=a(),P=f("div"),c(Le.$$.fragment),Ia=a(),It=f("p"),It.innerHTML=mn,go=a(),c(Ve.$$.fragment),vo=a(),R=f("div"),c(Ae.$$.fragment),Na=a(),Nt=f("p"),Nt.textContent=hn,bo=a(),c(Pe.$$.fragment),ko=a(),X=f("div"),c(Re.$$.fragment),Fa=a(),Ft=f("p"),Ft.textContent=pn,$o=a(),c(Xe.$$.fragment),wo=a(),c(Ee.$$.fragment),yo=a(),W=f("div"),c(ze.$$.fragment),Ha=a(),Ht=f("p"),Ht.innerHTML=fn,Wa=a(),c(pe.$$.fragment),xo=a(),c(Qe.$$.fragment),Mo=a(),E=f("div"),c(qe.$$.fragment),Za=a(),Wt=f("p"),Wt.innerHTML=un,To=a(),c(Ye.$$.fragment),Uo=a(),z=f("div"),c(Se.$$.fragment),Da=a(),Zt=f("p"),Zt.innerHTML=_n,Co=a(),c(Oe.$$.fragment),jo=a(),Q=f("div"),c(Ke.$$.fragment),Ba=a(),Dt=f("p"),Dt.innerHTML=gn,Jo=a(),c(et.$$.fragment),Go=a(),J=f("div"),c(tt.$$.fragment),La=a(),Bt=f("p"),Bt.innerHTML=vn,Va=a(),c(fe.$$.fragment),Aa=a(),Lt=f("p"),Lt.textContent=bn,Pa=a(),c(ue.$$.fragment),Io=a(),c(ot.$$.fragment),No=a(),c(at.$$.fragment),Fo=a(),q=f("div"),c(nt.$$.fragment),Ra=a(),Vt=f("p"),Vt.innerHTML=kn,Ho=a(),c(st.$$.fragment),Wo=a(),Y=f("div"),c(lt.$$.fragment),Xa=a(),At=f("p"),At.textContent=$n,Zo=a(),c(dt.$$.fragment),Do=a(),c(ct.$$.fragment),Bo=a(),S=f("div"),c(rt.$$.fragment),Ea=a(),Pt=f("p"),Pt.textContent=wn,Lo=a(),c(it.$$.fragment),Vo=a(),O=f("div"),c(mt.$$.fragment),za=a(),Rt=f("p"),Rt.textContent=yn,Ao=a(),c(ht.$$.fragment),Po=a(),Et=f("p"),this.h()},l(e){const t=Cn("svelte-u9bgzb",document.head);l=u(t,"META",{name:!0,content:!0}),t.forEach(o),k=n(e),g=u(e,"P",{}),w(g).forEach(o),v=n(e),r($.$$.fragment,e),_=n(e),r(T.$$.fragment,e),qt=n(e),r(_e.$$.fragment,e),Yt=n(e),G=u(e,"DIV",{class:!0});var Z=w(G);r(ge.$$.fragment,Z),la=n(Z),_t=u(Z,"P",{"data-svelte-h":!0}),b(_t)!=="svelte-1u5mepw"&&(_t.textContent=Qa),da=n(Z),r(ae.$$.fragment,Z),ca=n(Z),r(ne.$$.fragment,Z),Z.forEach(o),St=n(e),r(ve.$$.fragment,e),Ot=n(e),L=u(e,"DIV",{class:!0});var pt=w(L);r(be.$$.fragment,pt),ra=n(pt),gt=u(pt,"P",{"data-svelte-h":!0}),b(gt)!=="svelte-1gp9ghs"&&(gt.textContent=qa),pt.forEach(o),Kt=n(e),r(ke.$$.fragment,e),eo=n(e),N=u(e,"DIV",{class:!0});var K=w(N);r($e.$$.fragment,K),ia=n(K),vt=u(K,"P",{"data-svelte-h":!0}),b(vt)!=="svelte-6j2oun"&&(vt.innerHTML=Ya),ma=n(K),r(se.$$.fragment,K),K.forEach(o),to=n(e),r(we.$$.fragment,e),oo=n(e),V=u(e,"DIV",{class:!0});var ft=w(V);r(ye.$$.fragment,ft),ha=n(ft),bt=u(ft,"P",{"data-svelte-h":!0}),b(bt)!=="svelte-js7ro5"&&(bt.textContent=Sa),ft.forEach(o),ao=n(e),r(xe.$$.fragment,e),no=n(e),A=u(e,"DIV",{class:!0});var ut=w(A);r(Me.$$.fragment,ut),pa=n(ut),kt=u(ut,"P",{"data-svelte-h":!0}),b(kt)!=="svelte-1p13mzc"&&(kt.textContent=Oa),ut.forEach(o),so=n(e),r(Te.$$.fragment,e),lo=n(e),F=u(e,"DIV",{class:!0});var ee=w(F);r(Ue.$$.fragment,ee),fa=n(ee),$t=u(ee,"P",{"data-svelte-h":!0}),b($t)!=="svelte-1ikrez4"&&($t.textContent=Ka),ua=n(ee),r(le.$$.fragment,ee),ee.forEach(o),co=n(e),r(Ce.$$.fragment,e),ro=n(e),H=u(e,"DIV",{class:!0});var te=w(H);r(je.$$.fragment,te),_a=n(te),wt=u(te,"P",{"data-svelte-h":!0}),b(wt)!=="svelte-qft9nv"&&(wt.textContent=en),ga=n(te),r(de.$$.fragment,te),te.forEach(o),io=n(e),r(Je.$$.fragment,e),mo=n(e),I=u(e,"DIV",{class:!0});var D=w(I);r(Ge.$$.fragment,D),va=n(D),yt=u(D,"P",{"data-svelte-h":!0}),b(yt)!=="svelte-ou57jw"&&(yt.textContent=tn),ba=n(D),xt=u(D,"UL",{"data-svelte-h":!0}),b(xt)!=="svelte-17tb5w2"&&(xt.innerHTML=on),ka=n(D),r(ce.$$.fragment,D),D.forEach(o),ho=n(e),r(Ie.$$.fragment,e),po=n(e),r(Ne.$$.fragment,e),fo=n(e),U=u(e,"DIV",{class:!0});var j=w(U);r(Fe.$$.fragment,j),$a=n(j),Mt=u(j,"P",{"data-svelte-h":!0}),b(Mt)!=="svelte-jjeczj"&&(Mt.textContent=an),wa=n(j),Tt=u(j,"P",{"data-svelte-h":!0}),b(Tt)!=="svelte-1aqkkwa"&&(Tt.textContent=nn),ya=n(j),Ut=u(j,"UL",{"data-svelte-h":!0}),b(Ut)!=="svelte-1ny2lfh"&&(Ut.innerHTML=sn),xa=n(j),re=u(j,"DIV",{class:!0});var Xo=w(re);r(He.$$.fragment,Xo),Ma=n(Xo),Ct=u(Xo,"P",{"data-svelte-h":!0}),b(Ct)!=="svelte-13obmts"&&(Ct.textContent=ln),Xo.forEach(o),Ta=n(j),ie=u(j,"DIV",{class:!0});var Eo=w(ie);r(We.$$.fragment,Eo),Ua=n(Eo),jt=u(Eo,"P",{"data-svelte-h":!0}),b(jt)!=="svelte-2npthr"&&(jt.textContent=dn),Eo.forEach(o),Ca=n(j),me=u(j,"DIV",{class:!0});var zo=w(me);r(Ze.$$.fragment,zo),ja=n(zo),Jt=u(zo,"P",{"data-svelte-h":!0}),b(Jt)!=="svelte-17hlov5"&&(Jt.textContent=cn),zo.forEach(o),Ja=n(j),he=u(j,"DIV",{class:!0});var Qo=w(he);r(De.$$.fragment,Qo),Ga=n(Qo),Gt=u(Qo,"P",{"data-svelte-h":!0}),b(Gt)!=="svelte-53qfnq"&&(Gt.textContent=rn),Qo.forEach(o),j.forEach(o),uo=n(e),r(Be.$$.fragment,e),_o=n(e),P=u(e,"DIV",{class:!0});var qo=w(P);r(Le.$$.fragment,qo),Ia=n(qo),It=u(qo,"P",{"data-svelte-h":!0}),b(It)!=="svelte-15d0s2c"&&(It.innerHTML=mn),qo.forEach(o),go=n(e),r(Ve.$$.fragment,e),vo=n(e),R=u(e,"DIV",{class:!0});var Yo=w(R);r(Ae.$$.fragment,Yo),Na=n(Yo),Nt=u(Yo,"P",{"data-svelte-h":!0}),b(Nt)!=="svelte-kxjaug"&&(Nt.textContent=hn),Yo.forEach(o),bo=n(e),r(Pe.$$.fragment,e),ko=n(e),X=u(e,"DIV",{class:!0});var So=w(X);r(Re.$$.fragment,So),Fa=n(So),Ft=u(So,"P",{"data-svelte-h":!0}),b(Ft)!=="svelte-v8znqi"&&(Ft.textContent=pn),So.forEach(o),$o=n(e),r(Xe.$$.fragment,e),wo=n(e),r(Ee.$$.fragment,e),yo=n(e),W=u(e,"DIV",{class:!0});var Xt=w(W);r(ze.$$.fragment,Xt),Ha=n(Xt),Ht=u(Xt,"P",{"data-svelte-h":!0}),b(Ht)!=="svelte-12byttf"&&(Ht.innerHTML=fn),Wa=n(Xt),r(pe.$$.fragment,Xt),Xt.forEach(o),xo=n(e),r(Qe.$$.fragment,e),Mo=n(e),E=u(e,"DIV",{class:!0});var Oo=w(E);r(qe.$$.fragment,Oo),Za=n(Oo),Wt=u(Oo,"P",{"data-svelte-h":!0}),b(Wt)!=="svelte-rf1vym"&&(Wt.innerHTML=un),Oo.forEach(o),To=n(e),r(Ye.$$.fragment,e),Uo=n(e),z=u(e,"DIV",{class:!0});var Ko=w(z);r(Se.$$.fragment,Ko),Da=n(Ko),Zt=u(Ko,"P",{"data-svelte-h":!0}),b(Zt)!=="svelte-5orloz"&&(Zt.innerHTML=_n),Ko.forEach(o),Co=n(e),r(Oe.$$.fragment,e),jo=n(e),Q=u(e,"DIV",{class:!0});var ea=w(Q);r(Ke.$$.fragment,ea),Ba=n(ea),Dt=u(ea,"P",{"data-svelte-h":!0}),b(Dt)!=="svelte-1anoa02"&&(Dt.innerHTML=gn),ea.forEach(o),Jo=n(e),r(et.$$.fragment,e),Go=n(e),J=u(e,"DIV",{class:!0});var B=w(J);r(tt.$$.fragment,B),La=n(B),Bt=u(B,"P",{"data-svelte-h":!0}),b(Bt)!=="svelte-q70bcf"&&(Bt.innerHTML=vn),Va=n(B),r(fe.$$.fragment,B),Aa=n(B),Lt=u(B,"P",{"data-svelte-h":!0}),b(Lt)!=="svelte-3cloev"&&(Lt.textContent=bn),Pa=n(B),r(ue.$$.fragment,B),B.forEach(o),Io=n(e),r(ot.$$.fragment,e),No=n(e),r(at.$$.fragment,e),Fo=n(e),q=u(e,"DIV",{class:!0});var ta=w(q);r(nt.$$.fragment,ta),Ra=n(ta),Vt=u(ta,"P",{"data-svelte-h":!0}),b(Vt)!=="svelte-1kj8409"&&(Vt.innerHTML=kn),ta.forEach(o),Ho=n(e),r(st.$$.fragment,e),Wo=n(e),Y=u(e,"DIV",{class:!0});var oa=w(Y);r(lt.$$.fragment,oa),Xa=n(oa),At=u(oa,"P",{"data-svelte-h":!0}),b(At)!=="svelte-xlirjm"&&(At.textContent=$n),oa.forEach(o),Zo=n(e),r(dt.$$.fragment,e),Do=n(e),r(ct.$$.fragment,e),Bo=n(e),S=u(e,"DIV",{class:!0});var aa=w(S);r(rt.$$.fragment,aa),Ea=n(aa),Pt=u(aa,"P",{"data-svelte-h":!0}),b(Pt)!=="svelte-195dvsx"&&(Pt.textContent=wn),aa.forEach(o),Lo=n(e),r(it.$$.fragment,e),Vo=n(e),O=u(e,"DIV",{class:!0});var na=w(O);r(mt.$$.fragment,na),za=n(na),Rt=u(na,"P",{"data-svelte-h":!0}),b(Rt)!=="svelte-17fy5vm"&&(Rt.textContent=yn),na.forEach(o),Ao=n(e),r(ht.$$.fragment,e),Po=n(e),Et=u(e,"P",{}),w(Et).forEach(o),this.h()},h(){y(l,"name","hf:doc:metadata"),y(l,"content",Ln),y(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){d(document.head,l),s(e,k,t),s(e,g,t),s(e,v,t),i($,e,t),s(e,_,t),i(T,e,t),s(e,qt,t),i(_e,e,t),s(e,Yt,t),s(e,G,t),i(ge,G,null),d(G,la),d(G,_t),d(G,da),i(ae,G,null),d(G,ca),i(ne,G,null),s(e,St,t),i(ve,e,t),s(e,Ot,t),s(e,L,t),i(be,L,null),d(L,ra),d(L,gt),s(e,Kt,t),i(ke,e,t),s(e,eo,t),s(e,N,t),i($e,N,null),d(N,ia),d(N,vt),d(N,ma),i(se,N,null),s(e,to,t),i(we,e,t),s(e,oo,t),s(e,V,t),i(ye,V,null),d(V,ha),d(V,bt),s(e,ao,t),i(xe,e,t),s(e,no,t),s(e,A,t),i(Me,A,null),d(A,pa),d(A,kt),s(e,so,t),i(Te,e,t),s(e,lo,t),s(e,F,t),i(Ue,F,null),d(F,fa),d(F,$t),d(F,ua),i(le,F,null),s(e,co,t),i(Ce,e,t),s(e,ro,t),s(e,H,t),i(je,H,null),d(H,_a),d(H,wt),d(H,ga),i(de,H,null),s(e,io,t),i(Je,e,t),s(e,mo,t),s(e,I,t),i(Ge,I,null),d(I,va),d(I,yt),d(I,ba),d(I,xt),d(I,ka),i(ce,I,null),s(e,ho,t),i(Ie,e,t),s(e,po,t),i(Ne,e,t),s(e,fo,t),s(e,U,t),i(Fe,U,null),d(U,$a),d(U,Mt),d(U,wa),d(U,Tt),d(U,ya),d(U,Ut),d(U,xa),d(U,re),i(He,re,null),d(re,Ma),d(re,Ct),d(U,Ta),d(U,ie),i(We,ie,null),d(ie,Ua),d(ie,jt),d(U,Ca),d(U,me),i(Ze,me,null),d(me,ja),d(me,Jt),d(U,Ja),d(U,he),i(De,he,null),d(he,Ga),d(he,Gt),s(e,uo,t),i(Be,e,t),s(e,_o,t),s(e,P,t),i(Le,P,null),d(P,Ia),d(P,It),s(e,go,t),i(Ve,e,t),s(e,vo,t),s(e,R,t),i(Ae,R,null),d(R,Na),d(R,Nt),s(e,bo,t),i(Pe,e,t),s(e,ko,t),s(e,X,t),i(Re,X,null),d(X,Fa),d(X,Ft),s(e,$o,t),i(Xe,e,t),s(e,wo,t),i(Ee,e,t),s(e,yo,t),s(e,W,t),i(ze,W,null),d(W,Ha),d(W,Ht),d(W,Wa),i(pe,W,null),s(e,xo,t),i(Qe,e,t),s(e,Mo,t),s(e,E,t),i(qe,E,null),d(E,Za),d(E,Wt),s(e,To,t),i(Ye,e,t),s(e,Uo,t),s(e,z,t),i(Se,z,null),d(z,Da),d(z,Zt),s(e,Co,t),i(Oe,e,t),s(e,jo,t),s(e,Q,t),i(Ke,Q,null),d(Q,Ba),d(Q,Dt),s(e,Jo,t),i(et,e,t),s(e,Go,t),s(e,J,t),i(tt,J,null),d(J,La),d(J,Bt),d(J,Va),i(fe,J,null),d(J,Aa),d(J,Lt),d(J,Pa),i(ue,J,null),s(e,Io,t),i(ot,e,t),s(e,No,t),i(at,e,t),s(e,Fo,t),s(e,q,t),i(nt,q,null),d(q,Ra),d(q,Vt),s(e,Ho,t),i(st,e,t),s(e,Wo,t),s(e,Y,t),i(lt,Y,null),d(Y,Xa),d(Y,At),s(e,Zo,t),i(dt,e,t),s(e,Do,t),i(ct,e,t),s(e,Bo,t),s(e,S,t),i(rt,S,null),d(S,Ea),d(S,Pt),s(e,Lo,t),i(it,e,t),s(e,Vo,t),s(e,O,t),i(mt,O,null),d(O,za),d(O,Rt),s(e,Ao,t),i(ht,e,t),s(e,Po,t),s(e,Et,t),Ro=!0},p(e,[t]){const Z={};t&2&&(Z.$$scope={dirty:t,ctx:e}),ae.$set(Z);const pt={};t&2&&(pt.$$scope={dirty:t,ctx:e}),ne.$set(pt);const K={};t&2&&(K.$$scope={dirty:t,ctx:e}),se.$set(K);const ft={};t&2&&(ft.$$scope={dirty:t,ctx:e}),le.$set(ft);const ut={};t&2&&(ut.$$scope={dirty:t,ctx:e}),de.$set(ut);const ee={};t&2&&(ee.$$scope={dirty:t,ctx:e}),ce.$set(ee);const te={};t&2&&(te.$$scope={dirty:t,ctx:e}),pe.$set(te);const D={};t&2&&(D.$$scope={dirty:t,ctx:e}),fe.$set(D);const j={};t&2&&(j.$$scope={dirty:t,ctx:e}),ue.$set(j)},i(e){Ro||(m($.$$.fragment,e),m(T.$$.fragment,e),m(_e.$$.fragment,e),m(ge.$$.fragment,e),m(ae.$$.fragment,e),m(ne.$$.fragment,e),m(ve.$$.fragment,e),m(be.$$.fragment,e),m(ke.$$.fragment,e),m($e.$$.fragment,e),m(se.$$.fragment,e),m(we.$$.fragment,e),m(ye.$$.fragment,e),m(xe.$$.fragment,e),m(Me.$$.fragment,e),m(Te.$$.fragment,e),m(Ue.$$.fragment,e),m(le.$$.fragment,e),m(Ce.$$.fragment,e),m(je.$$.fragment,e),m(de.$$.fragment,e),m(Je.$$.fragment,e),m(Ge.$$.fragment,e),m(ce.$$.fragment,e),m(Ie.$$.fragment,e),m(Ne.$$.fragment,e),m(Fe.$$.fragment,e),m(He.$$.fragment,e),m(We.$$.fragment,e),m(Ze.$$.fragment,e),m(De.$$.fragment,e),m(Be.$$.fragment,e),m(Le.$$.fragment,e),m(Ve.$$.fragment,e),m(Ae.$$.fragment,e),m(Pe.$$.fragment,e),m(Re.$$.fragment,e),m(Xe.$$.fragment,e),m(Ee.$$.fragment,e),m(ze.$$.fragment,e),m(pe.$$.fragment,e),m(Qe.$$.fragment,e),m(qe.$$.fragment,e),m(Ye.$$.fragment,e),m(Se.$$.fragment,e),m(Oe.$$.fragment,e),m(Ke.$$.fragment,e),m(et.$$.fragment,e),m(tt.$$.fragment,e),m(fe.$$.fragment,e),m(ue.$$.fragment,e),m(ot.$$.fragment,e),m(at.$$.fragment,e),m(nt.$$.fragment,e),m(st.$$.fragment,e),m(lt.$$.fragment,e),m(dt.$$.fragment,e),m(ct.$$.fragment,e),m(rt.$$.fragment,e),m(it.$$.fragment,e),m(mt.$$.fragment,e),m(ht.$$.fragment,e),Ro=!0)},o(e){h($.$$.fragment,e),h(T.$$.fragment,e),h(_e.$$.fragment,e),h(ge.$$.fragment,e),h(ae.$$.fragment,e),h(ne.$$.fragment,e),h(ve.$$.fragment,e),h(be.$$.fragment,e),h(ke.$$.fragment,e),h($e.$$.fragment,e),h(se.$$.fragment,e),h(we.$$.fragment,e),h(ye.$$.fragment,e),h(xe.$$.fragment,e),h(Me.$$.fragment,e),h(Te.$$.fragment,e),h(Ue.$$.fragment,e),h(le.$$.fragment,e),h(Ce.$$.fragment,e),h(je.$$.fragment,e),h(de.$$.fragment,e),h(Je.$$.fragment,e),h(Ge.$$.fragment,e),h(ce.$$.fragment,e),h(Ie.$$.fragment,e),h(Ne.$$.fragment,e),h(Fe.$$.fragment,e),h(He.$$.fragment,e),h(We.$$.fragment,e),h(Ze.$$.fragment,e),h(De.$$.fragment,e),h(Be.$$.fragment,e),h(Le.$$.fragment,e),h(Ve.$$.fragment,e),h(Ae.$$.fragment,e),h(Pe.$$.fragment,e),h(Re.$$.fragment,e),h(Xe.$$.fragment,e),h(Ee.$$.fragment,e),h(ze.$$.fragment,e),h(pe.$$.fragment,e),h(Qe.$$.fragment,e),h(qe.$$.fragment,e),h(Ye.$$.fragment,e),h(Se.$$.fragment,e),h(Oe.$$.fragment,e),h(Ke.$$.fragment,e),h(et.$$.fragment,e),h(tt.$$.fragment,e),h(fe.$$.fragment,e),h(ue.$$.fragment,e),h(ot.$$.fragment,e),h(at.$$.fragment,e),h(nt.$$.fragment,e),h(st.$$.fragment,e),h(lt.$$.fragment,e),h(dt.$$.fragment,e),h(ct.$$.fragment,e),h(rt.$$.fragment,e),h(it.$$.fragment,e),h(mt.$$.fragment,e),h(ht.$$.fragment,e),Ro=!1},d(e){e&&(o(k),o(g),o(v),o(_),o(qt),o(Yt),o(G),o(St),o(Ot),o(L),o(Kt),o(eo),o(N),o(to),o(oo),o(V),o(ao),o(no),o(A),o(so),o(lo),o(F),o(co),o(ro),o(H),o(io),o(mo),o(I),o(ho),o(po),o(fo),o(U),o(uo),o(_o),o(P),o(go),o(vo),o(R),o(bo),o(ko),o(X),o($o),o(wo),o(yo),o(W),o(xo),o(Mo),o(E),o(To),o(Uo),o(z),o(Co),o(jo),o(Q),o(Jo),o(Go),o(J),o(Io),o(No),o(Fo),o(q),o(Ho),o(Wo),o(Y),o(Zo),o(Do),o(Bo),o(S),o(Lo),o(Vo),o(O),o(Ao),o(Po),o(Et)),o(l),p($,e),p(T,e),p(_e,e),p(ge),p(ae),p(ne),p(ve,e),p(be),p(ke,e),p($e),p(se),p(we,e),p(ye),p(xe,e),p(Me),p(Te,e),p(Ue),p(le),p(Ce,e),p(je),p(de),p(Je,e),p(Ge),p(ce),p(Ie,e),p(Ne,e),p(Fe),p(He),p(We),p(Ze),p(De),p(Be,e),p(Le),p(Ve,e),p(Ae),p(Pe,e),p(Re),p(Xe,e),p(Ee,e),p(ze),p(pe),p(Qe,e),p(qe),p(Ye,e),p(Se),p(Oe,e),p(Ke),p(et,e),p(tt),p(fe),p(ue),p(ot,e),p(at,e),p(nt),p(st,e),p(lt),p(dt,e),p(ct,e),p(rt),p(it,e),p(mt),p(ht,e)}}}const Ln='{"title":"Working with large models","local":"working-with-large-models","sections":[{"title":"Dispatch and offload","local":"dispatch-and-offload","sections":[{"title":"init_empty_weights","local":"accelerate.init_empty_weights","sections":[],"depth":3},{"title":"cpu_offload","local":"accelerate.cpu_offload","sections":[],"depth":3},{"title":"cpu_offload_with_hook","local":"accelerate.cpu_offload_with_hook","sections":[],"depth":3},{"title":"disk_offload","local":"accelerate.disk_offload","sections":[],"depth":3},{"title":"dispatch_model","local":"accelerate.dispatch_model","sections":[],"depth":3},{"title":"load_checkpoint_and_dispatch","local":"accelerate.load_checkpoint_and_dispatch","sections":[],"depth":3},{"title":"load_checkpoint_in_model","local":"accelerate.load_checkpoint_in_model","sections":[],"depth":3},{"title":"infer_auto_device_map","local":"accelerate.infer_auto_device_map","sections":[],"depth":3}],"depth":2},{"title":"Hooks","local":"hooks","sections":[{"title":"ModelHook","local":"accelerate.hooks.ModelHook","sections":[],"depth":3},{"title":"AlignDevicesHook","local":"accelerate.hooks.AlignDevicesHook","sections":[],"depth":3},{"title":"SequentialHook","local":"accelerate.hooks.SequentialHook","sections":[],"depth":3},{"title":"LayerwiseCastingHook","local":"accelerate.hooks.LayerwiseCastingHook","sections":[],"depth":3}],"depth":2},{"title":"Adding Hooks","local":"adding-hooks","sections":[{"title":"add_hook_to_module","local":"accelerate.hooks.add_hook_to_module","sections":[],"depth":3},{"title":"attach_execution_device_hook","local":"accelerate.hooks.attach_execution_device_hook","sections":[],"depth":3},{"title":"attach_align_device_hook","local":"accelerate.hooks.attach_align_device_hook","sections":[],"depth":3},{"title":"attach_align_device_hook_on_blocks","local":"accelerate.hooks.attach_align_device_hook_on_blocks","sections":[],"depth":3},{"title":"attach_layerwise_casting_hooks","local":"accelerate.big_modeling.attach_layerwise_casting_hooks","sections":[],"depth":3}],"depth":2},{"title":"Removing Hooks","local":"removing-hooks","sections":[{"title":"remove_hook_from_module","local":"accelerate.hooks.remove_hook_from_module","sections":[],"depth":3},{"title":"remove_hook_from_submodules","local":"accelerate.hooks.remove_hook_from_submodules","sections":[],"depth":3}],"depth":2},{"title":"Utilities","local":"utilities","sections":[{"title":"has_offloaded_params","local":"accelerate.utils.has_offloaded_params","sections":[],"depth":3},{"title":"align_module_device","local":"accelerate.utils.align_module_device","sections":[],"depth":3}],"depth":2}],"depth":1}';function Vn(C){return Mn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class qn extends Tn{constructor(l){super(),Un(this,l,Vn,Bn,xn,{})}}export{qn as component};
