import{s as st,n as pt,o as rt}from"../chunks/scheduler.8c3d61f6.js";import{S as ot,i as mt,g as s,s as n,r as o,m as ut,A as ft,h as p,f as l,c as a,j as at,u as m,x as r,n as ct,k as d,y as Mt,a as i,v as u,d as f,t as c,w as M}from"../chunks/index.da70eac4.js";import{C as He}from"../chunks/CodeBlock.a9c4becf.js";import{H as N,E as dt}from"../chunks/getInferenceSnippets.a8672208.js";function yt(Ve){let y,O,q,ee,b,te,v,Xe='<a href="https://github.com/xdit-project/xDiT" rel="nofollow">xDiT</a> is an inference engine designed for the large scale parallel deployment of Diffusion Transformers (DiTs). xDiT provides a suite of efficient parallel approaches for Diffusion Models, as well as GPU kernel accelerations.',le,Z,We='There are four parallel methods supported in xDiT, including <a href="https://huggingface.co/papers/2405.07719" rel="nofollow">Unified Sequence Parallelism</a>, <a href="https://huggingface.co/papers/2405.14430" rel="nofollow">PipeFusion</a>, CFG parallelism and data parallelism. The four parallel methods in xDiT can be configured in a hybrid manner, optimizing communication patterns to best suit the underlying network hardware.',ie,I,Le="Optimization orthogonal to parallelization focuses on accelerating single GPU performance. In addition to utilizing well-known Attention optimization libraries, we leverage compilation acceleration technologies such as torch.compile and onediff.",ne,_,Se="The overview of xDiT is shown as follows.",ae,T,Ae='<img src="https://huggingface.co/datasets/xDiT/documentation-images/resolve/main/methods/xdit_overview.png"/>',se,j,pe,$,Qe="Here’s an example of using xDiT to accelerate inference of a Diffusers model.",re,G,oe,B,Re="As you can see, we only need to use xFuserArgs from xDiT to get configuration parameters, and pass these parameters along with the pipeline object from the Diffusers library into xDiTParallel to complete the parallelization of a specific pipeline in Diffusers.",me,D,Fe='xDiT runtime parameters can be viewed in the command line using <code>-h</code>, and you can refer to this <a href="https://github.com/xdit-project/xDiT?tab=readme-ov-file#2-usage" rel="nofollow">usage</a> example for more details.',ue,H,ze="xDiT needs to be launched using torchrun to support its multi-node, multi-GPU parallel capabilities. For example, the following command can be used for 8-GPU parallel inference:",fe,V,ce,X,Me,W,ke='A subset of Diffusers models are supported in xDiT, such as Flux.1, Stable Diffusion 3, etc. The latest supported models can be found <a href="https://github.com/xdit-project/xDiT?tab=readme-ov-file#-supported-dits" rel="nofollow">here</a>.',de,L,ye,S,Ee="We tested different models on various machines, and here is some of the benchmark data.",Te,A,we,w,Pe='<img src="https://huggingface.co/datasets/xDiT/documentation-images/resolve/main/performance/flux/Flux-2k-L40.png"/>',ge,g,Ye='<img src="https://huggingface.co/datasets/xDiT/documentation-images/resolve/main/performance/flux/Flux-2K-A100.png"/>',Ue,Q,he,U,Ne='<img src="https://huggingface.co/datasets/xDiT/documentation-images/resolve/main/performance/sd3/L40-SD3.png"/>',Je,h,qe='<img src="https://huggingface.co/datasets/xDiT/documentation-images/resolve/main/performance/sd3/A100-SD3.png"/>',xe,R,Ce,J,Ke='<img src="https://huggingface.co/datasets/xDiT/documentation-images/resolve/main/performance/hunuyuandit/L40-HunyuanDiT.png"/>',be,x,Oe='<img src="https://huggingface.co/datasets/xDiT/documentation-images/resolve/main/performance/hunuyuandit/V100-HunyuanDiT.png"/>',ve,C,et='<img src="https://huggingface.co/datasets/xDiT/documentation-images/resolve/main/performance/hunuyuandit/T4-HunyuanDiT.png"/>',Ze,F,tt='More detailed performance metric can be found on our <a href="https://github.com/xdit-project/xDiT?tab=readme-ov-file#perf" rel="nofollow">github page</a>.',Ie,z,_e,k,lt='<a href="https://github.com/xdit-project/xDiT" rel="nofollow">xDiT-project</a>',je,E,it='<a href="https://huggingface.co/papers/2405.07719" rel="nofollow">USP: A Unified Sequence Parallelism Approach for Long Context Generative AI</a>',$e,P,nt='<a href="https://huggingface.co/papers/2405.14430" rel="nofollow">PipeFusion: Displaced Patch Pipeline Parallelism for Inference of Diffusion Transformer Models</a>',Ge,Y,Be,K,De;return b=new N({props:{title:"xDiT",local:"xdit",headingTag:"h1"}}),j=new He({props:{code:"cGlwJTIwaW5zdGFsbCUyMHhmdXNlcg==",highlighted:"pip install xfuser",wrap:!1}}),G=new He({props:{code:"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",highlighted:` import torch
 from diffusers import StableDiffusion3Pipeline

 from xfuser import xFuserArgs, xDiTParallel
 from xfuser.config import FlexibleArgumentParser
 from xfuser.core.distributed import get_world_group

 def main():
<span class="hljs-addition">+    parser = FlexibleArgumentParser(description=&quot;xFuser Arguments&quot;)</span>
<span class="hljs-addition">+    args = xFuserArgs.add_cli_args(parser).parse_args()</span>
<span class="hljs-addition">+    engine_args = xFuserArgs.from_cli_args(args)</span>
<span class="hljs-addition">+    engine_config, input_config = engine_args.create_config()</span>

     local_rank = get_world_group().local_rank
     pipe = StableDiffusion3Pipeline.from_pretrained(
         pretrained_model_name_or_path=engine_config.model_config.model,
         torch_dtype=torch.float16,
     ).to(f&quot;cuda:{local_rank}&quot;)
    
# do anything you want with pipeline here

<span class="hljs-addition">+    pipe = xDiTParallel(pipe, engine_config, input_config)</span>

     pipe(
         height=input_config.height,
         width=input_config.height,
         prompt=input_config.prompt,
         num_inference_steps=input_config.num_inference_steps,
         output_type=input_config.output_type,
         generator=torch.Generator(device=&quot;cuda&quot;).manual_seed(input_config.seed),
     )

<span class="hljs-addition">+    if input_config.output_type == &quot;pil&quot;:</span>
<span class="hljs-addition">+        pipe.save(&quot;results&quot;, &quot;stable_diffusion_3&quot;)</span>

if __name__ == &quot;__main__&quot;:
    main()
`,wrap:!1}}),V=new He({props:{code:"dG9yY2hydW4lMjAtLW5wcm9jX3Blcl9ub2RlJTNEOCUyMC4lMkZpbmZlcmVuY2UucHklMjAtLW1vZGVsJTIwbW9kZWxzJTJGRkxVWC4xLWRldiUyMC0tZGF0YV9wYXJhbGxlbF9kZWdyZWUlMjAyJTIwLS11bHlzc2VzX2RlZ3JlZSUyMDIlMjAtLXJpbmdfZGVncmVlJTIwMiUyMC0tcHJvbXB0JTIwJTIyQSUyMHNub3d5JTIwbW91bnRhaW4lMjIlMjAlMjJBJTIwc21hbGwlMjBkb2clMjIlMjAtLW51bV9pbmZlcmVuY2Vfc3RlcHMlMjA1MA==",highlighted:'torchrun --nproc_per_node=8 ./inference.py --model models/FLUX.1-dev --data_parallel_degree 2 --ulysses_degree 2 --ring_degree 2 --prompt <span class="hljs-string">&quot;A snowy mountain&quot;</span> <span class="hljs-string">&quot;A small dog&quot;</span> --num_inference_steps 50',wrap:!1}}),X=new N({props:{title:"Supported models",local:"supported-models",headingTag:"h2"}}),L=new N({props:{title:"Benchmark",local:"benchmark",headingTag:"h2"}}),A=new N({props:{title:"Flux.1-schnell",local:"flux1-schnell",headingTag:"h3"}}),Q=new N({props:{title:"Stable Diffusion 3",local:"stable-diffusion-3",headingTag:"h3"}}),R=new N({props:{title:"HunyuanDiT",local:"hunyuandit",headingTag:"h3"}}),z=new N({props:{title:"Reference",local:"reference",headingTag:"h2"}}),Y=new dt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/optimization/xdit.md"}}),{c(){y=s("meta"),O=n(),q=s("p"),ee=n(),o(b.$$.fragment),te=n(),v=s("p"),v.innerHTML=Xe,le=n(),Z=s("p"),Z.innerHTML=We,ie=n(),I=s("p"),I.textContent=Le,ne=n(),_=s("p"),_.textContent=Se,ae=n(),T=s("div"),T.innerHTML=Ae,se=ut(`
You can install xDiT using the following command:

	`),o(j.$$.fragment),pe=n(),$=s("p"),$.textContent=Qe,re=n(),o(G.$$.fragment),oe=n(),B=s("p"),B.textContent=Re,me=n(),D=s("p"),D.innerHTML=Fe,ue=n(),H=s("p"),H.textContent=ze,fe=n(),o(V.$$.fragment),ce=n(),o(X.$$.fragment),Me=n(),W=s("p"),W.innerHTML=ke,de=n(),o(L.$$.fragment),ye=n(),S=s("p"),S.textContent=Ee,Te=n(),o(A.$$.fragment),we=n(),w=s("div"),w.innerHTML=Pe,ge=n(),g=s("div"),g.innerHTML=Ye,Ue=n(),o(Q.$$.fragment),he=n(),U=s("div"),U.innerHTML=Ne,Je=n(),h=s("div"),h.innerHTML=qe,xe=n(),o(R.$$.fragment),Ce=n(),J=s("div"),J.innerHTML=Ke,be=n(),x=s("div"),x.innerHTML=Oe,ve=n(),C=s("div"),C.innerHTML=et,Ze=n(),F=s("p"),F.innerHTML=tt,Ie=n(),o(z.$$.fragment),_e=n(),k=s("p"),k.innerHTML=lt,je=n(),E=s("p"),E.innerHTML=it,$e=n(),P=s("p"),P.innerHTML=nt,Ge=n(),o(Y.$$.fragment),Be=n(),K=s("p"),this.h()},l(e){const t=ft("svelte-u9bgzb",document.head);y=p(t,"META",{name:!0,content:!0}),t.forEach(l),O=a(e),q=p(e,"P",{}),at(q).forEach(l),ee=a(e),m(b.$$.fragment,e),te=a(e),v=p(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-18ay52p"&&(v.innerHTML=Xe),le=a(e),Z=p(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-vagkpn"&&(Z.innerHTML=We),ie=a(e),I=p(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1gdgl9y"&&(I.textContent=Le),ne=a(e),_=p(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1q3693h"&&(_.textContent=Se),ae=a(e),T=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(T)!=="svelte-1jymm8y"&&(T.innerHTML=Ae),se=ct(e,`
You can install xDiT using the following command:

	`),m(j.$$.fragment,e),pe=a(e),$=p(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1tjpbb8"&&($.textContent=Qe),re=a(e),m(G.$$.fragment,e),oe=a(e),B=p(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-mvd4f5"&&(B.textContent=Re),me=a(e),D=p(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1soaacc"&&(D.innerHTML=Fe),ue=a(e),H=p(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-bfdume"&&(H.textContent=ze),fe=a(e),m(V.$$.fragment,e),ce=a(e),m(X.$$.fragment,e),Me=a(e),W=p(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1990k65"&&(W.innerHTML=ke),de=a(e),m(L.$$.fragment,e),ye=a(e),S=p(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1j2z5cw"&&(S.textContent=Ee),Te=a(e),m(A.$$.fragment,e),we=a(e),w=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(w)!=="svelte-ysqez7"&&(w.innerHTML=Pe),ge=a(e),g=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(g)!=="svelte-195epjt"&&(g.innerHTML=Ye),Ue=a(e),m(Q.$$.fragment,e),he=a(e),U=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(U)!=="svelte-6afexp"&&(U.innerHTML=Ne),Je=a(e),h=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(h)!=="svelte-1ju6xid"&&(h.innerHTML=qe),xe=a(e),m(R.$$.fragment,e),Ce=a(e),J=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(J)!=="svelte-1wq76oc"&&(J.innerHTML=Ke),be=a(e),x=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(x)!=="svelte-c4plsv"&&(x.innerHTML=Oe),ve=a(e),C=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(C)!=="svelte-srcu1c"&&(C.innerHTML=et),Ze=a(e),F=p(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1i0skaz"&&(F.innerHTML=tt),Ie=a(e),m(z.$$.fragment,e),_e=a(e),k=p(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1tn43qd"&&(k.innerHTML=lt),je=a(e),E=p(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-5nrl9w"&&(E.innerHTML=it),$e=a(e),P=p(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-fllf4"&&(P.innerHTML=nt),Ge=a(e),m(Y.$$.fragment,e),Be=a(e),K=p(e,"P",{}),at(K).forEach(l),this.h()},h(){d(y,"name","hf:doc:metadata"),d(y,"content",Tt),d(T,"class","flex justify-center"),d(w,"class","flex justify-center"),d(g,"class","flex justify-center"),d(U,"class","flex justify-center"),d(h,"class","flex justify-center"),d(J,"class","flex justify-center"),d(x,"class","flex justify-center"),d(C,"class","flex justify-center")},m(e,t){Mt(document.head,y),i(e,O,t),i(e,q,t),i(e,ee,t),u(b,e,t),i(e,te,t),i(e,v,t),i(e,le,t),i(e,Z,t),i(e,ie,t),i(e,I,t),i(e,ne,t),i(e,_,t),i(e,ae,t),i(e,T,t),i(e,se,t),u(j,e,t),i(e,pe,t),i(e,$,t),i(e,re,t),u(G,e,t),i(e,oe,t),i(e,B,t),i(e,me,t),i(e,D,t),i(e,ue,t),i(e,H,t),i(e,fe,t),u(V,e,t),i(e,ce,t),u(X,e,t),i(e,Me,t),i(e,W,t),i(e,de,t),u(L,e,t),i(e,ye,t),i(e,S,t),i(e,Te,t),u(A,e,t),i(e,we,t),i(e,w,t),i(e,ge,t),i(e,g,t),i(e,Ue,t),u(Q,e,t),i(e,he,t),i(e,U,t),i(e,Je,t),i(e,h,t),i(e,xe,t),u(R,e,t),i(e,Ce,t),i(e,J,t),i(e,be,t),i(e,x,t),i(e,ve,t),i(e,C,t),i(e,Ze,t),i(e,F,t),i(e,Ie,t),u(z,e,t),i(e,_e,t),i(e,k,t),i(e,je,t),i(e,E,t),i(e,$e,t),i(e,P,t),i(e,Ge,t),u(Y,e,t),i(e,Be,t),i(e,K,t),De=!0},p:pt,i(e){De||(f(b.$$.fragment,e),f(j.$$.fragment,e),f(G.$$.fragment,e),f(V.$$.fragment,e),f(X.$$.fragment,e),f(L.$$.fragment,e),f(A.$$.fragment,e),f(Q.$$.fragment,e),f(R.$$.fragment,e),f(z.$$.fragment,e),f(Y.$$.fragment,e),De=!0)},o(e){c(b.$$.fragment,e),c(j.$$.fragment,e),c(G.$$.fragment,e),c(V.$$.fragment,e),c(X.$$.fragment,e),c(L.$$.fragment,e),c(A.$$.fragment,e),c(Q.$$.fragment,e),c(R.$$.fragment,e),c(z.$$.fragment,e),c(Y.$$.fragment,e),De=!1},d(e){e&&(l(O),l(q),l(ee),l(te),l(v),l(le),l(Z),l(ie),l(I),l(ne),l(_),l(ae),l(T),l(se),l(pe),l($),l(re),l(oe),l(B),l(me),l(D),l(ue),l(H),l(fe),l(ce),l(Me),l(W),l(de),l(ye),l(S),l(Te),l(we),l(w),l(ge),l(g),l(Ue),l(he),l(U),l(Je),l(h),l(xe),l(Ce),l(J),l(be),l(x),l(ve),l(C),l(Ze),l(F),l(Ie),l(_e),l(k),l(je),l(E),l($e),l(P),l(Ge),l(Be),l(K)),l(y),M(b,e),M(j,e),M(G,e),M(V,e),M(X,e),M(L,e),M(A,e),M(Q,e),M(R,e),M(z,e),M(Y,e)}}}const Tt='{"title":"xDiT","local":"xdit","sections":[{"title":"Supported models","local":"supported-models","sections":[],"depth":2},{"title":"Benchmark","local":"benchmark","sections":[{"title":"Flux.1-schnell","local":"flux1-schnell","sections":[],"depth":3},{"title":"Stable Diffusion 3","local":"stable-diffusion-3","sections":[],"depth":3},{"title":"HunyuanDiT","local":"hunyuandit","sections":[],"depth":3}],"depth":2},{"title":"Reference","local":"reference","sections":[],"depth":2}],"depth":1}';function wt(Ve){return rt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class xt extends ot{constructor(y){super(),mt(this,y,wt,yt,st,{})}}export{xt as component};
