import{s as Un,f as os,n as jn,o as Tn}from"../chunks/scheduler.389d799c.js";import{S as wn,i as Jn,g as M,s as n,r,A as hn,h as o,f as t,c as a,j as dl,u as p,x as i,k as U,y as fn,a as s,v as y,d,t as m,w as c}from"../chunks/index.8f81d18f.js";import{C as u}from"../chunks/CodeBlock.c0898180.js";import{H as J,E as bn}from"../chunks/getInferenceSnippets.623c9250.js";function In(is){let h,ml,pl,cl,I,ul,g,rs="Deploying a 🤗 Transformers models in SageMaker for inference is as easy as:",Ul,C,jl,Z,ps='This guide will show you how to deploy models with zero-code using the <a href="https://github.com/aws/sagemaker-huggingface-inference-toolkit" rel="nofollow">Inference Toolkit</a>. The Inference Toolkit builds on top of the <a href="https://huggingface.co/docs/transformers/main_classes/pipelines" rel="nofollow"><code>pipeline</code> feature</a> from 🤗 Transformers. Learn how to:',Tl,B,ys='<li><a href="#installation-and-setup">Install and setup the Inference Toolkit</a>.</li> <li><a href="#deploy-a-transformer-model-trained-in-sagemaker">Deploy a 🤗 Transformers model trained in SageMaker</a>.</li> <li><a href="#deploy-a-model-from-the-hub">Deploy a 🤗 Transformers model from the Hugging Face [model Hub](https://huggingface.co/models)</a>.</li> <li><a href="#run-batch-transform-with-transformers-and-sagemaker">Run a Batch Transform Job using 🤗 Transformers and Amazon SageMaker</a>.</li> <li><a href="#user-defined-code-and-modules">Create a custom inference module</a>.</li>',wl,k,Jl,G,ds='Before deploying a 🤗 Transformers model to SageMaker, you need to sign up for an AWS account. If you don’t have an AWS account yet, learn more <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/gs-set-up.html" rel="nofollow">here</a>.',hl,W,ms="Once you have an AWS account, get started using one of the following:",fl,A,cs='<li><a href="https://docs.aws.amazon.com/sagemaker/latest/dg/gs-studio-onboard.html" rel="nofollow">SageMaker Studio</a></li> <li><a href="https://docs.aws.amazon.com/sagemaker/latest/dg/gs-console.html" rel="nofollow">SageMaker notebook instance</a></li> <li>Local environment</li>',bl,v,us='To start training locally, you need to setup an appropriate <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html" rel="nofollow">IAM role</a>.',Il,_,Us="Upgrade to the latest <code>sagemaker</code> version.",gl,$,Cl,S,js="<strong>SageMaker environment</strong>",Zl,H,Ts="Setup your SageMaker environment as shown below:",Bl,R,kl,E,ws="<em>Note: The execution role is only available when running a notebook within SageMaker. If you run <code>get_execution_role</code> in a notebook not on SageMaker, expect a <code>region</code> error.</em>",Gl,V,Js="<strong>Local environment</strong>",Wl,x,hs="Setup your local environment as shown below:",Al,Y,vl,N,_l,j,fs,$l,z,bs="There are two ways to deploy your Hugging Face model trained in SageMaker:",Sl,F,Is="<li>Deploy it after your training has finished.</li> <li>Deploy your saved model at a later time from S3 with the <code>model_data</code>.</li>",Hl,X,gs='📓 Open the <a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/10_deploy_model_from_s3/deploy_transformer_model_from_s3.ipynb" rel="nofollow">deploy_transformer_model_from_s3.ipynb notebook</a> for an example of how to deploy a model from S3 to SageMaker for inference.',Rl,Q,El,L,Cs="To deploy your model directly after training, ensure all required files are saved in your training script, including the tokenizer and the model.",Vl,q,Zs="If you use the Hugging Face <code>Trainer</code>, you can pass your tokenizer as an argument to the <code>Trainer</code>. It will be automatically saved when you call <code>trainer.save_model()</code>.",xl,P,Yl,D,Bs="After you run your request you can delete the endpoint as shown:",Nl,K,zl,O,Fl,ee,ks="If you’ve already trained your model and want to deploy it at a later time, use the <code>model_data</code> argument to specify the location of your tokenizer and model weights.",Xl,le,Ql,te,Gs="After you run our request, you can delete the endpoint again with:",Ll,se,ql,ne,Pl,ae,Ws="For later deployment, you can create a <code>model.tar.gz</code> file that contains all the required files, such as:",Dl,Me,As="<li><code>pytorch_model.bin</code></li> <li><code>tf_model.h5</code></li> <li><code>tokenizer.json</code></li> <li><code>tokenizer_config.json</code></li>",Kl,oe,vs="For example, your file should look like this:",Ol,ie,et,re,_s="Create your own <code>model.tar.gz</code> from a model from the 🤗 Hub:",lt,pe,$s="<li>Download a model:</li>",tt,ye,st,f,Ss="<li>Create a <code>tar</code> file:</li>",nt,de,at,b,Hs="<li>Upload <code>model.tar.gz</code> to S3:</li>",Mt,me,ot,ce,Rs="Now you can provide the S3 URI to the <code>model_data</code> argument to deploy your model later.",it,ue,rt,T,Es,pt,Ue,Vs="To deploy a model directly from the 🤗 Hub to SageMaker, define two environment variables when you create a <code>HuggingFaceModel</code>:",yt,je,xs='<li><code>HF_MODEL_ID</code> defines the model ID which is automatically loaded from <a href="http://huggingface.co/models" rel="nofollow">huggingface.co/models</a> when you create a SageMaker endpoint. Access 10,000+ models on he 🤗 Hub through this environment variable.</li> <li><code>HF_TASK</code> defines the task for the 🤗 Transformers <code>pipeline</code>. A complete list of tasks can be found <a href="https://huggingface.co/docs/transformers/main_classes/pipelines" rel="nofollow">here</a>.</li>',dt,Te,Ys='<p>⚠️ ** Pipelines are not optimized for parallelism (multi-threading) and tend to consume a lot of RAM. For example, on a GPU-based instance, the pipeline operates on a single vCPU. When this vCPU becomes saturated with the inference requests preprocessing, it can create a bottleneck, preventing the GPU from being fully utilized for model inference. Learn more <a href="https://huggingface.co/docs/transformers/en/pipeline_webserver#using-pipelines-for-a-webserver" rel="nofollow">here</a></p>',mt,we,ct,Je,Ns="After you run our request, you can delete the endpoint again with:",ut,he,Ut,fe,zs='📓 Open the <a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/11_deploy_model_from_hf_hub/deploy_transformer_model_from_hf_hub.ipynb" rel="nofollow">deploy_transformer_model_from_hf_hub.ipynb notebook</a> for an example of how to deploy a model from the 🤗 Hub to SageMaker for inference.',jt,be,Tt,w,Fs,wt,Ie,Xs='After training a model, you can use <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works-batch.html" rel="nofollow">SageMaker batch transform</a> to perform inference with the model. Batch transform accepts your inference data as an S3 URI  and then SageMaker will take care of downloading the data, running the prediction, and uploading the results to S3. For more details about batch transform, take a look <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform.html" rel="nofollow">here</a>.',Jt,ge,Qs="⚠️ The Hugging Face Inference DLC currently only supports <code>.jsonl</code> for batch transform due to the complex structure of textual data.",ht,Ce,Ls="<em>Note: Make sure your <code>inputs</code> fit the <code>max_length</code> of the model during preprocessing.</em>",ft,Ze,qs='If you trained a model using the Hugging Face Estimator, call the <code>transformer()</code> method to create a transform job for a model based on the training job (see <a href="https://sagemaker.readthedocs.io/en/stable/overview.html#sagemaker-batch-transform" rel="nofollow">here</a> for more details):',bt,Be,It,ke,Ps="If you want to run your batch transform job later or with a model from the 🤗 Hub, create a <code>HuggingFaceModel</code> instance and then call the <code>transformer()</code> method:",gt,Ge,Ct,We,Ds="The <code>input.jsonl</code> looks like this:",Zt,Ae,Bt,ve,Ks='📓 Open the <a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/12_batch_transform_inference/sagemaker-notebook.ipynb" rel="nofollow">sagemaker-notebook.ipynb notebook</a> for an example of how to run a batch transform job for inference.',kt,_e,Gt,$e,Os='If you are interested in using a high-performance serving container for LLMs, you can use the Hugging Face TGI container. This utilizes the <a href="https://github.com/huggingface/text-generation-inference" rel="nofollow">Text Generation Inference</a> library. A list of compatible models can be found <a href="https://huggingface.co/docs/text-generation-inference/supported_models#supported-models" rel="nofollow">here</a>.',Wt,Se,en="First, make sure that the latest version of SageMaker SDK is installed:",At,He,vt,Re,ln="Then, we import the SageMaker Python SDK and instantiate a sagemaker_session to find the current region and execution role.",_t,Ee,$t,Ve,tn="Next we retrieve the LLM image URI. We use the helper function get_huggingface_llm_image_uri() to generate the appropriate image URI for the Hugging Face Large Language Model (LLM) inference. The function takes a required parameter backend and several optional parameters. The backend specifies the type of backend to use for the model:  “huggingface” refers to using Hugging Face TGI backend.",St,xe,Ht,Ye,sn="Now that we have the image uri, the next step is to configure the model object. We specify a unique name, the image_uri for the managed TGI container, and the execution role for the endpoint. Additionally, we specify a number of environment variables including the <code>HF_MODEL_ID</code> which corresponds to the model from the HuggingFace Hub that will be deployed, and the <code>HF_TASK</code> which configures the inference task to be performed by the model.",Rt,Ne,nn="You should also define <code>SM_NUM_GPUS</code>, which specifies the tensor parallelism degree of the model. Tensor parallelism can be used to split the model across multiple GPUs, which is necessary when working with LLMs that are too big for a single GPU. To learn more about tensor parallelism with inference, see our previous blog post. Here, you should set <code>SM_NUM_GPUS</code> to the number of available GPUs on your selected instance type. For example, in this tutorial, we set <code>SM_NUM_GPUS</code> to 4 because our selected instance type ml.g4dn.12xlarge has 4 available GPUs.",Et,ze,an="Note that you can optionally reduce the memory and computational footprint of the model by setting the <code>HF_MODEL_QUANTIZE</code> environment variable to <code>true</code>, but this lower weight precision could affect the quality of the output for some models.",Vt,Fe,xt,Xe,Mn="Next, we invoke the deploy method to deploy the model.",Yt,Qe,Nt,Le,on="Once the model is deployed, we can invoke it to generate text. We pass an input prompt and run the predict method to generate a text response from the LLM running in the TGI container.",zt,qe,Ft,Pe,rn="We receive the following auto-generated text response:",Xt,De,Qt,Ke,pn="Once we are done experimenting, we delete the endpoint and the model resources.",Lt,Oe,qt,el,Pt,ll,yn='The Hugging Face Inference Toolkit allows the user to override the default methods of the <code>HuggingFaceHandlerService</code>. You will need to create a folder named <code>code/</code> with an <code>inference.py</code> file in it. See <a href="#create-a-model-artifact-for-deployment">here</a> for more details on how to archive your model artifacts. For example:',Dt,tl,Kt,sl,dn="The <code>inference.py</code> file contains your custom inference module, and the <code>requirements.txt</code> file contains additional dependencies that should be added. The custom module can override the following methods:",Ot,nl,mn="<li><code>model_fn(model_dir)</code> overrides the default method for loading a model. The return value <code>model</code> will be used in <code>predict</code> for predictions. <code>predict</code> receives argument the <code>model_dir</code>, the path to your unzipped <code>model.tar.gz</code>.</li> <li><code>transform_fn(model, data, content_type, accept_type)</code> overrides the default transform function with your custom implementation. You will need to implement your own <code>preprocess</code>, <code>predict</code> and <code>postprocess</code> steps in the <code>transform_fn</code>. This method can’t be combined with <code>input_fn</code>, <code>predict_fn</code> or <code>output_fn</code> mentioned below.</li> <li><code>input_fn(input_data, content_type)</code> overrides the default method for preprocessing. The return value <code>data</code> will be used in <code>predict</code> for predictions. The inputs are:<ul><li><code>input_data</code> is the raw body of your request.</li> <li><code>content_type</code> is the content type from the request header.</li></ul></li> <li><code>predict_fn(processed_data, model)</code> overrides the default method for predictions. The return value <code>predictions</code> will be used in <code>postprocess</code>. The input is <code>processed_data</code>, the result from <code>preprocess</code>.</li> <li><code>output_fn(prediction, accept)</code> overrides the default method for postprocessing. The return value <code>result</code> will be the response of your request (e.g.<code>JSON</code>). The inputs are:<ul><li><code>predictions</code> is the result from <code>predict</code>.</li> <li><code>accept</code> is the return accept type from the HTTP Request, e.g. <code>application/json</code>.</li></ul></li>",es,al,cn="Here is an example of a custom inference module with <code>model_fn</code>, <code>input_fn</code>, <code>predict_fn</code>, and <code>output_fn</code>:",ls,Ml,ts,ol,un="Customize your inference module with only <code>model_fn</code> and <code>transform_fn</code>:",ss,il,ns,rl,as,yl,Ms;return I=new J({props:{title:"Deploy models to Amazon SageMaker",local:"deploy-models-to-amazon-sagemaker",headingTag:"h1"}}),C=new u({props:{code:"ZnJvbSUyMHNhZ2VtYWtlci5odWdnaW5nZmFjZSUyMGltcG9ydCUyMEh1Z2dpbmdGYWNlTW9kZWwlMEElMEElMjMlMjBjcmVhdGUlMjBIdWdnaW5nJTIwRmFjZSUyME1vZGVsJTIwQ2xhc3MlMjBhbmQlMjBkZXBsb3klMjBpdCUyMGFzJTIwU2FnZU1ha2VyJTIwZW5kcG9pbnQlMEFodWdnaW5nZmFjZV9tb2RlbCUyMCUzRCUyMEh1Z2dpbmdGYWNlTW9kZWwoLi4uKS5kZXBsb3koKQ==",highlighted:`<span class="hljs-keyword">from</span> sagemaker.huggingface <span class="hljs-keyword">import</span> HuggingFaceModel

<span class="hljs-comment"># create Hugging Face Model Class and deploy it as SageMaker endpoint</span>
huggingface_model = HuggingFaceModel(...).deploy()`,wrap:!1}}),k=new J({props:{title:"Installation and setup",local:"installation-and-setup",headingTag:"h2"}}),$=new u({props:{code:"cGlwJTIwaW5zdGFsbCUyMHNhZ2VtYWtlciUyMC0tdXBncmFkZQ==",highlighted:"pip install sagemaker --upgrade",wrap:!1}}),R=new u({props:{code:"aW1wb3J0JTIwc2FnZW1ha2VyJTBBc2VzcyUyMCUzRCUyMHNhZ2VtYWtlci5TZXNzaW9uKCklMEFyb2xlJTIwJTNEJTIwc2FnZW1ha2VyLmdldF9leGVjdXRpb25fcm9sZSgp",highlighted:`<span class="hljs-keyword">import</span> sagemaker
sess = sagemaker.Session()
role = sagemaker.get_execution_role()`,wrap:!1}}),Y=new u({props:{code:"aW1wb3J0JTIwc2FnZW1ha2VyJTBBaW1wb3J0JTIwYm90bzMlMEElMEFpYW1fY2xpZW50JTIwJTNEJTIwYm90bzMuY2xpZW50KCdpYW0nKSUwQXJvbGUlMjAlM0QlMjBpYW1fY2xpZW50LmdldF9yb2xlKFJvbGVOYW1lJTNEJ3JvbGUtbmFtZS1vZi15b3VyLWlhbS1yb2xlLXdpdGgtcmlnaHQtcGVybWlzc2lvbnMnKSU1QidSb2xlJyU1RCU1QidBcm4nJTVEJTBBc2VzcyUyMCUzRCUyMHNhZ2VtYWtlci5TZXNzaW9uKCk=",highlighted:`<span class="hljs-keyword">import</span> sagemaker
<span class="hljs-keyword">import</span> boto3

iam_client = boto3.client(<span class="hljs-string">&#x27;iam&#x27;</span>)
role = iam_client.get_role(RoleName=<span class="hljs-string">&#x27;role-name-of-your-iam-role-with-right-permissions&#x27;</span>)[<span class="hljs-string">&#x27;Role&#x27;</span>][<span class="hljs-string">&#x27;Arn&#x27;</span>]
sess = sagemaker.Session()`,wrap:!1}}),N=new J({props:{title:"Deploy a 🤗 Transformers model trained in SageMaker",local:"deploy-a--transformers-model-trained-in-sagemaker",headingTag:"h2"}}),Q=new J({props:{title:"Deploy after training",local:"deploy-after-training",headingTag:"h3"}}),P=new u({props:{code:"ZnJvbSUyMHNhZ2VtYWtlci5odWdnaW5nZmFjZSUyMGltcG9ydCUyMEh1Z2dpbmdGYWNlJTBBJTBBJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIwcHNldWRvJTIwY29kZSUyMHN0YXJ0JTIwJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTIzJTBBJTBBJTIzJTIwY3JlYXRlJTIwSHVnZ2luZyUyMEZhY2UlMjBFc3RpbWF0b3IlMjBmb3IlMjB0cmFpbmluZyUwQWh1Z2dpbmdmYWNlX2VzdGltYXRvciUyMCUzRCUyMEh1Z2dpbmdGYWNlKC4uLi4pJTBBJTBBJTIzJTIwc3RhcnQlMjB0aGUlMjB0cmFpbiUyMGpvYiUyMHdpdGglMjBvdXIlMjB1cGxvYWRlZCUyMGRhdGFzZXRzJTIwYXMlMjBpbnB1dCUwQWh1Z2dpbmdmYWNlX2VzdGltYXRvci5maXQoLi4uKSUwQSUwQSUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMyUyMHBzZXVkbyUyMGNvZGUlMjBlbmQlMjAlMjMlMjMlMjMlMjMlMjMlMjMlMjMlMjMlMjMlMjMlMjMlMjMlMEElMEElMjMlMjBkZXBsb3klMjBtb2RlbCUyMHRvJTIwU2FnZU1ha2VyJTIwSW5mZXJlbmNlJTBBcHJlZGljdG9yJTIwJTNEJTIwaGZfZXN0aW1hdG9yLmRlcGxveShpbml0aWFsX2luc3RhbmNlX2NvdW50JTNEMSUyQyUyMGluc3RhbmNlX3R5cGUlM0QlMjJtbC5tNS54bGFyZ2UlMjIpJTBBJTBBJTIzJTIwZXhhbXBsZSUyMHJlcXVlc3QlM0ElMjB5b3UlMjBhbHdheXMlMjBuZWVkJTIwdG8lMjBkZWZpbmUlMjAlMjJpbnB1dHMlMjIlMEFkYXRhJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyQ2FtZXJhJTIwLSUyMFlvdSUyMGFyZSUyMGF3YXJkZWQlMjBhJTIwU2lQaXglMjBEaWdpdGFsJTIwQ2FtZXJhISUyMGNhbGwlMjAwOTA2MTIyMTA2NiUyMGZyb20lMjBsYW5kbGluZS4lMjBEZWxpdmVyeSUyMHdpdGhpbiUyMDI4JTIwZGF5cy4lMjIlMEElN0QlMEElMEElMjMlMjByZXF1ZXN0JTBBcHJlZGljdG9yLnByZWRpY3QoZGF0YSk=",highlighted:`<span class="hljs-keyword">from</span> sagemaker.huggingface <span class="hljs-keyword">import</span> HuggingFace

<span class="hljs-comment">############ pseudo code start ############</span>

<span class="hljs-comment"># create Hugging Face Estimator for training</span>
huggingface_estimator = HuggingFace(....)

<span class="hljs-comment"># start the train job with our uploaded datasets as input</span>
huggingface_estimator.fit(...)

<span class="hljs-comment">############ pseudo code end ############</span>

<span class="hljs-comment"># deploy model to SageMaker Inference</span>
predictor = hf_estimator.deploy(initial_instance_count=<span class="hljs-number">1</span>, instance_type=<span class="hljs-string">&quot;ml.m5.xlarge&quot;</span>)

<span class="hljs-comment"># example request: you always need to define &quot;inputs&quot;</span>
data = {
   <span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;Camera - You are awarded a SiPix Digital Camera! call 09061221066 from landline. Delivery within 28 days.&quot;</span>
}

<span class="hljs-comment"># request</span>
predictor.predict(data)`,wrap:!1}}),K=new u({props:{code:"JTIzJTIwZGVsZXRlJTIwZW5kcG9pbnQlMEFwcmVkaWN0b3IuZGVsZXRlX2VuZHBvaW50KCk=",highlighted:`<span class="hljs-comment"># delete endpoint</span>
predictor.delete_endpoint()`,wrap:!1}}),O=new J({props:{title:"Deploy with model_data",local:"deploy-with-modeldata",headingTag:"h3"}}),le=new u({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> sagemaker.huggingface.model <span class="hljs-keyword">import</span> HuggingFaceModel

<span class="hljs-comment"># create Hugging Face Model Class</span>
huggingface_model = HuggingFaceModel(
   model_data=<span class="hljs-string">&quot;s3://models/my-bert-model/model.tar.gz&quot;</span>,  <span class="hljs-comment"># path to your trained SageMaker model</span>
   role=role,                                            <span class="hljs-comment"># IAM role with permissions to create an endpoint</span>
   transformers_version=<span class="hljs-string">&quot;4.26&quot;</span>,                           <span class="hljs-comment"># Transformers version used</span>
   pytorch_version=<span class="hljs-string">&quot;1.13&quot;</span>,                                <span class="hljs-comment"># PyTorch version used</span>
   py_version=<span class="hljs-string">&#x27;py39&#x27;</span>,                                    <span class="hljs-comment"># Python version used</span>
)

<span class="hljs-comment"># deploy model to SageMaker Inference</span>
predictor = huggingface_model.deploy(
   initial_instance_count=<span class="hljs-number">1</span>,
   instance_type=<span class="hljs-string">&quot;ml.m5.xlarge&quot;</span>
)

<span class="hljs-comment"># example request: you always need to define &quot;inputs&quot;</span>
data = {
   <span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;Camera - You are awarded a SiPix Digital Camera! call 09061221066 from landline. Delivery within 28 days.&quot;</span>
}

<span class="hljs-comment"># request</span>
predictor.predict(data)`,wrap:!1}}),se=new u({props:{code:"JTIzJTIwZGVsZXRlJTIwZW5kcG9pbnQlMEFwcmVkaWN0b3IuZGVsZXRlX2VuZHBvaW50KCk=",highlighted:`<span class="hljs-comment"># delete endpoint</span>
predictor.delete_endpoint()`,wrap:!1}}),ne=new J({props:{title:"Create a model artifact for deployment",local:"create-a-model-artifact-for-deployment",headingTag:"h3"}}),ie=new u({props:{code:"bW9kZWwudGFyLmd6JTJGJTBBJTdDLSUyMHB5dG9yY2hfbW9kZWwuYmluJTBBJTdDLSUyMHZvY2FiLnR4dCUwQSU3Qy0lMjB0b2tlbml6ZXJfY29uZmlnLmpzb24lMEElN0MtJTIwY29uZmlnLmpzb24lMEElN0MtJTIwc3BlY2lhbF90b2tlbnNfbWFwLmpzb24=",highlighted:`model.tar.gz/
|- pytorch_model.bin
|- vocab.txt
|- tokenizer_config.json
|- config.json
|- special_tokens_map.json`,wrap:!1}}),ye=new u({props:{code:"Z2l0JTIwbGZzJTIwaW5zdGFsbCUwQWdpdCUyMGNsb25lJTIwZ2l0JTQwaGYuY28lM0ElN0JyZXBvc2l0b3J5JTdE",highlighted:`git lfs install
git <span class="hljs-built_in">clone</span> git@hf.co:{repository}`,wrap:!1}}),de=new u({props:{code:"Y2QlMjAlN0JyZXBvc2l0b3J5JTdEJTBBdGFyJTIwemN2ZiUyMG1vZGVsLnRhci5neiUyMCo=",highlighted:`<span class="hljs-built_in">cd</span> {repository}
tar zcvf model.tar.gz *`,wrap:!1}}),me=new u({props:{code:"YXdzJTIwczMlMjBjcCUyMG1vZGVsLnRhci5neiUyMCUzQ3MzJTNBJTJGJTJGJTdCbXktczMtcGF0aCU3RCUzRQ==",highlighted:'aws s3 <span class="hljs-built_in">cp</span> model.tar.gz &lt;s3://{my-s3-path}&gt;',wrap:!1}}),ue=new J({props:{title:"Deploy a model from the 🤗 Hub",local:"deploy-a-model-from-the--hub",headingTag:"h2"}}),we=new u({props:{code:"ZnJvbSUyMHNhZ2VtYWtlci5odWdnaW5nZmFjZS5tb2RlbCUyMGltcG9ydCUyMEh1Z2dpbmdGYWNlTW9kZWwlMEElMEElMjMlMjBIdWIlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMjAlM0NodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGbW9kZWxzJTNFJTBBaHViJTIwJTNEJTIwJTdCJTBBJTIwJTIwJ0hGX01PREVMX0lEJyUzQSdkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1kaXN0aWxsZWQtc3F1YWQnJTJDJTIwJTIzJTIwbW9kZWxfaWQlMjBmcm9tJTIwaGYuY28lMkZtb2RlbHMlMEElMjAlMjAnSEZfVEFTSyclM0EncXVlc3Rpb24tYW5zd2VyaW5nJyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyME5MUCUyMHRhc2slMjB5b3UlMjB3YW50JTIwdG8lMjB1c2UlMjBmb3IlMjBwcmVkaWN0aW9ucyUwQSU3RCUwQSUwQSUyMyUyMGNyZWF0ZSUyMEh1Z2dpbmclMjBGYWNlJTIwTW9kZWwlMjBDbGFzcyUwQWh1Z2dpbmdmYWNlX21vZGVsJTIwJTNEJTIwSHVnZ2luZ0ZhY2VNb2RlbCglMEElMjAlMjAlMjBlbnYlM0RodWIlMkMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBjb25maWd1cmF0aW9uJTIwZm9yJTIwbG9hZGluZyUyMG1vZGVsJTIwZnJvbSUyMEh1YiUwQSUyMCUyMCUyMHJvbGUlM0Ryb2xlJTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwSUFNJTIwcm9sZSUyMHdpdGglMjBwZXJtaXNzaW9ucyUyMHRvJTIwY3JlYXRlJTIwYW4lMjBlbmRwb2ludCUwQSUyMCUyMCUyMHRyYW5zZm9ybWVyc192ZXJzaW9uJTNEJTIyNC4yNiUyMiUyQyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFRyYW5zZm9ybWVycyUyMHZlcnNpb24lMjB1c2VkJTBBJTIwJTIwJTIwcHl0b3JjaF92ZXJzaW9uJTNEJTIyMS4xMyUyMiUyQyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFB5VG9yY2glMjB2ZXJzaW9uJTIwdXNlZCUwQSUyMCUyMCUyMHB5X3ZlcnNpb24lM0QncHkzOSclMkMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBQeXRob24lMjB2ZXJzaW9uJTIwdXNlZCUwQSklMEElMEElMjMlMjBkZXBsb3klMjBtb2RlbCUyMHRvJTIwU2FnZU1ha2VyJTIwSW5mZXJlbmNlJTBBcHJlZGljdG9yJTIwJTNEJTIwaHVnZ2luZ2ZhY2VfbW9kZWwuZGVwbG95KCUwQSUyMCUyMCUyMGluaXRpYWxfaW5zdGFuY2VfY291bnQlM0QxJTJDJTBBJTIwJTIwJTIwaW5zdGFuY2VfdHlwZSUzRCUyMm1sLm01LnhsYXJnZSUyMiUwQSklMEElMEElMjMlMjBleGFtcGxlJTIwcmVxdWVzdCUzQSUyMHlvdSUyMGFsd2F5cyUyMG5lZWQlMjB0byUyMGRlZmluZSUyMCUyMmlucHV0cyUyMiUwQWRhdGElMjAlM0QlMjAlN0IlMEElMjJpbnB1dHMlMjIlM0ElMjAlN0IlMEElMDklMjJxdWVzdGlvbiUyMiUzQSUyMCUyMldoYXQlMjBpcyUyMHVzZWQlMjBmb3IlMjBpbmZlcmVuY2UlM0YlMjIlMkMlMEElMDklMjJjb250ZXh0JTIyJTNBJTIwJTIyTXklMjBOYW1lJTIwaXMlMjBQaGlsaXBwJTIwYW5kJTIwSSUyMGxpdmUlMjBpbiUyME51cmVtYmVyZy4lMjBUaGlzJTIwbW9kZWwlMjBpcyUyMHVzZWQlMjB3aXRoJTIwc2FnZW1ha2VyJTIwZm9yJTIwaW5mZXJlbmNlLiUyMiUwQSUwOSU3RCUwQSU3RCUwQSUwQSUyMyUyMHJlcXVlc3QlMEFwcmVkaWN0b3IucHJlZGljdChkYXRhKQ==",highlighted:`<span class="hljs-keyword">from</span> sagemaker.huggingface.model <span class="hljs-keyword">import</span> HuggingFaceModel

<span class="hljs-comment"># Hub model configuration &lt;https://huggingface.co/models&gt;</span>
hub = {
  <span class="hljs-string">&#x27;HF_MODEL_ID&#x27;</span>:<span class="hljs-string">&#x27;distilbert-base-uncased-distilled-squad&#x27;</span>, <span class="hljs-comment"># model_id from hf.co/models</span>
  <span class="hljs-string">&#x27;HF_TASK&#x27;</span>:<span class="hljs-string">&#x27;question-answering&#x27;</span>                           <span class="hljs-comment"># NLP task you want to use for predictions</span>
}

<span class="hljs-comment"># create Hugging Face Model Class</span>
huggingface_model = HuggingFaceModel(
   env=hub,                                                <span class="hljs-comment"># configuration for loading model from Hub</span>
   role=role,                                              <span class="hljs-comment"># IAM role with permissions to create an endpoint</span>
   transformers_version=<span class="hljs-string">&quot;4.26&quot;</span>,                             <span class="hljs-comment"># Transformers version used</span>
   pytorch_version=<span class="hljs-string">&quot;1.13&quot;</span>,                                  <span class="hljs-comment"># PyTorch version used</span>
   py_version=<span class="hljs-string">&#x27;py39&#x27;</span>,                                      <span class="hljs-comment"># Python version used</span>
)

<span class="hljs-comment"># deploy model to SageMaker Inference</span>
predictor = huggingface_model.deploy(
   initial_instance_count=<span class="hljs-number">1</span>,
   instance_type=<span class="hljs-string">&quot;ml.m5.xlarge&quot;</span>
)

<span class="hljs-comment"># example request: you always need to define &quot;inputs&quot;</span>
data = {
<span class="hljs-string">&quot;inputs&quot;</span>: {
	<span class="hljs-string">&quot;question&quot;</span>: <span class="hljs-string">&quot;What is used for inference?&quot;</span>,
	<span class="hljs-string">&quot;context&quot;</span>: <span class="hljs-string">&quot;My Name is Philipp and I live in Nuremberg. This model is used with sagemaker for inference.&quot;</span>
	}
}

<span class="hljs-comment"># request</span>
predictor.predict(data)`,wrap:!1}}),he=new u({props:{code:"JTIzJTIwZGVsZXRlJTIwZW5kcG9pbnQlMEFwcmVkaWN0b3IuZGVsZXRlX2VuZHBvaW50KCk=",highlighted:`<span class="hljs-comment"># delete endpoint</span>
predictor.delete_endpoint()`,wrap:!1}}),be=new J({props:{title:"Run batch transform with 🤗 Transformers and SageMaker",local:"run-batch-transform-with--transformers-and-sagemaker",headingTag:"h2"}}),Be=new u({props:{code:"YmF0Y2hfam9iJTIwJTNEJTIwaHVnZ2luZ2ZhY2VfZXN0aW1hdG9yLnRyYW5zZm9ybWVyKCUwQSUyMCUyMCUyMCUyMGluc3RhbmNlX2NvdW50JTNEMSUyQyUwQSUyMCUyMCUyMCUyMGluc3RhbmNlX3R5cGUlM0QnbWwucDMuMnhsYXJnZSclMkMlMEElMjAlMjAlMjAlMjBzdHJhdGVneSUzRCdTaW5nbGVSZWNvcmQnKSUwQSUwQSUwQWJhdGNoX2pvYi50cmFuc2Zvcm0oJTBBJTIwJTIwJTIwJTIwZGF0YSUzRCdzMyUzQSUyRiUyRnMzLXVyaS10by1iYXRjaC1kYXRhJyUyQyUwQSUyMCUyMCUyMCUyMGNvbnRlbnRfdHlwZSUzRCdhcHBsaWNhdGlvbiUyRmpzb24nJTJDJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwc3BsaXRfdHlwZSUzRCdMaW5lJyk=",highlighted:`batch_job = huggingface_estimator.transformer(
    instance_count=<span class="hljs-number">1</span>,
    instance_type=<span class="hljs-string">&#x27;ml.p3.2xlarge&#x27;</span>,
    strategy=<span class="hljs-string">&#x27;SingleRecord&#x27;</span>)


batch_job.transform(
    data=<span class="hljs-string">&#x27;s3://s3-uri-to-batch-data&#x27;</span>,
    content_type=<span class="hljs-string">&#x27;application/json&#x27;</span>,    
    split_type=<span class="hljs-string">&#x27;Line&#x27;</span>)`,wrap:!1}}),Ge=new u({props:{code:"ZnJvbSUyMHNhZ2VtYWtlci5odWdnaW5nZmFjZS5tb2RlbCUyMGltcG9ydCUyMEh1Z2dpbmdGYWNlTW9kZWwlMEElMEElMjMlMjBIdWIlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMjAlM0NodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGbW9kZWxzJTNFJTBBaHViJTIwJTNEJTIwJTdCJTBBJTA5J0hGX01PREVMX0lEJyUzQSdkaXN0aWxiZXJ0JTJGZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNzdC0yLWVuZ2xpc2gnJTJDJTBBJTA5J0hGX1RBU0snJTNBJ3RleHQtY2xhc3NpZmljYXRpb24nJTBBJTdEJTBBJTBBJTIzJTIwY3JlYXRlJTIwSHVnZ2luZyUyMEZhY2UlMjBNb2RlbCUyMENsYXNzJTBBaHVnZ2luZ2ZhY2VfbW9kZWwlMjAlM0QlMjBIdWdnaW5nRmFjZU1vZGVsKCUwQSUyMCUyMCUyMGVudiUzRGh1YiUyQyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMGNvbmZpZ3VyYXRpb24lMjBmb3IlMjBsb2FkaW5nJTIwbW9kZWwlMjBmcm9tJTIwSHViJTBBJTIwJTIwJTIwcm9sZSUzRHJvbGUlMkMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBJQU0lMjByb2xlJTIwd2l0aCUyMHBlcm1pc3Npb25zJTIwdG8lMjBjcmVhdGUlMjBhbiUyMGVuZHBvaW50JTBBJTIwJTIwJTIwdHJhbnNmb3JtZXJzX3ZlcnNpb24lM0QlMjI0LjI2JTIyJTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwVHJhbnNmb3JtZXJzJTIwdmVyc2lvbiUyMHVzZWQlMEElMjAlMjAlMjBweXRvcmNoX3ZlcnNpb24lM0QlMjIxLjEzJTIyJTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwUHlUb3JjaCUyMHZlcnNpb24lMjB1c2VkJTBBJTIwJTIwJTIwcHlfdmVyc2lvbiUzRCdweTM5JyUyQyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFB5dGhvbiUyMHZlcnNpb24lMjB1c2VkJTBBKSUwQSUwQSUyMyUyMGNyZWF0ZSUyMHRyYW5zZm9ybWVyJTIwdG8lMjBydW4lMjBhJTIwYmF0Y2glMjBqb2IlMEFiYXRjaF9qb2IlMjAlM0QlMjBodWdnaW5nZmFjZV9tb2RlbC50cmFuc2Zvcm1lciglMEElMjAlMjAlMjAlMjBpbnN0YW5jZV9jb3VudCUzRDElMkMlMEElMjAlMjAlMjAlMjBpbnN0YW5jZV90eXBlJTNEJ21sLnAzLjJ4bGFyZ2UnJTJDJTBBJTIwJTIwJTIwJTIwc3RyYXRlZ3klM0QnU2luZ2xlUmVjb3JkJyUwQSklMEElMEElMjMlMjBzdGFydHMlMjBiYXRjaCUyMHRyYW5zZm9ybSUyMGpvYiUyMGFuZCUyMHVzZXMlMjBTMyUyMGRhdGElMjBhcyUyMGlucHV0JTBBYmF0Y2hfam9iLnRyYW5zZm9ybSglMEElMjAlMjAlMjAlMjBkYXRhJTNEJ3MzJTNBJTJGJTJGc2FnZW1ha2VyLXMzLWRlbW8tdGVzdCUyRnNhbXBsZXMlMkZpbnB1dC5qc29ubCclMkMlMEElMjAlMjAlMjAlMjBjb250ZW50X3R5cGUlM0QnYXBwbGljYXRpb24lMkZqc29uJyUyQyUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMHNwbGl0X3R5cGUlM0QnTGluZSclMEEp",highlighted:`<span class="hljs-keyword">from</span> sagemaker.huggingface.model <span class="hljs-keyword">import</span> HuggingFaceModel

<span class="hljs-comment"># Hub model configuration &lt;https://huggingface.co/models&gt;</span>
hub = {
	<span class="hljs-string">&#x27;HF_MODEL_ID&#x27;</span>:<span class="hljs-string">&#x27;distilbert/distilbert-base-uncased-finetuned-sst-2-english&#x27;</span>,
	<span class="hljs-string">&#x27;HF_TASK&#x27;</span>:<span class="hljs-string">&#x27;text-classification&#x27;</span>
}

<span class="hljs-comment"># create Hugging Face Model Class</span>
huggingface_model = HuggingFaceModel(
   env=hub,                                                <span class="hljs-comment"># configuration for loading model from Hub</span>
   role=role,                                              <span class="hljs-comment"># IAM role with permissions to create an endpoint</span>
   transformers_version=<span class="hljs-string">&quot;4.26&quot;</span>,                             <span class="hljs-comment"># Transformers version used</span>
   pytorch_version=<span class="hljs-string">&quot;1.13&quot;</span>,                                  <span class="hljs-comment"># PyTorch version used</span>
   py_version=<span class="hljs-string">&#x27;py39&#x27;</span>,                                      <span class="hljs-comment"># Python version used</span>
)

<span class="hljs-comment"># create transformer to run a batch job</span>
batch_job = huggingface_model.transformer(
    instance_count=<span class="hljs-number">1</span>,
    instance_type=<span class="hljs-string">&#x27;ml.p3.2xlarge&#x27;</span>,
    strategy=<span class="hljs-string">&#x27;SingleRecord&#x27;</span>
)

<span class="hljs-comment"># starts batch transform job and uses S3 data as input</span>
batch_job.transform(
    data=<span class="hljs-string">&#x27;s3://sagemaker-s3-demo-test/samples/input.jsonl&#x27;</span>,
    content_type=<span class="hljs-string">&#x27;application/json&#x27;</span>,    
    split_type=<span class="hljs-string">&#x27;Line&#x27;</span>
)`,wrap:!1}}),Ae=new u({props:{code:"JTdCJTIyaW5wdXRzJTIyJTNBJTIydGhpcyUyMG1vdmllJTIwaXMlMjB0ZXJyaWJsZSUyMiU3RCUwQSU3QiUyMmlucHV0cyUyMiUzQSUyMnRoaXMlMjBtb3ZpZSUyMGlzJTIwYW1hemluZyUyMiU3RCUwQSU3QiUyMmlucHV0cyUyMiUzQSUyMlNhZ2VNYWtlciUyMGlzJTIwcHJldHR5JTIwY29vbCUyMiU3RCUwQSU3QiUyMmlucHV0cyUyMiUzQSUyMlNhZ2VNYWtlciUyMGlzJTIwcHJldHR5JTIwY29vbCUyMiU3RCUwQSU3QiUyMmlucHV0cyUyMiUzQSUyMnRoaXMlMjBtb3ZpZSUyMGlzJTIwdGVycmlibGUlMjIlN0QlMEElN0IlMjJpbnB1dHMlMjIlM0ElMjJ0aGlzJTIwbW92aWUlMjBpcyUyMGFtYXppbmclMjIlN0Q=",highlighted:`<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span><span class="hljs-string">&quot;this movie is terrible&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span><span class="hljs-string">&quot;this movie is amazing&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span><span class="hljs-string">&quot;SageMaker is pretty cool&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span><span class="hljs-string">&quot;SageMaker is pretty cool&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span><span class="hljs-string">&quot;this movie is terrible&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span><span class="hljs-string">&quot;this movie is amazing&quot;</span><span class="hljs-punctuation">}</span>`,wrap:!1}}),_e=new J({props:{title:"Deploy an LLM to SageMaker using TGI",local:"deploy-an-llm-to-sagemaker-using-tgi",headingTag:"h2"}}),He=new u({props:{code:"cGlwJTIwaW5zdGFsbCUyMHNhZ2VtYWtlciUzRSUzRDIuMjMxLjA=",highlighted:"pip install sagemaker&gt;=2.231.0",wrap:!1}}),Ee=new u({props:{code:"aW1wb3J0JTIwc2FnZW1ha2VyJTBBZnJvbSUyMHNhZ2VtYWtlci5odWdnaW5nZmFjZSUyMGltcG9ydCUyMEh1Z2dpbmdGYWNlTW9kZWwlMkMlMjBnZXRfaHVnZ2luZ2ZhY2VfbGxtX2ltYWdlX3VyaSUwQWltcG9ydCUyMHRpbWUlMEElMEFzYWdlbWFrZXJfc2Vzc2lvbiUyMCUzRCUyMHNhZ2VtYWtlci5TZXNzaW9uKCklMEFyZWdpb24lMjAlM0QlMjBzYWdlbWFrZXJfc2Vzc2lvbi5ib3RvX3JlZ2lvbl9uYW1lJTBBcm9sZSUyMCUzRCUyMHNhZ2VtYWtlci5nZXRfZXhlY3V0aW9uX3JvbGUoKQ==",highlighted:`<span class="hljs-keyword">import</span> sagemaker
<span class="hljs-keyword">from</span> sagemaker.huggingface <span class="hljs-keyword">import</span> HuggingFaceModel, get_huggingface_llm_image_uri
<span class="hljs-keyword">import</span> time

sagemaker_session = sagemaker.Session()
region = sagemaker_session.boto_region_name
role = sagemaker.get_execution_role()`,wrap:!1}}),xe=new u({props:{code:"aW1hZ2VfdXJpJTIwJTNEJTIwZ2V0X2h1Z2dpbmdmYWNlX2xsbV9pbWFnZV91cmkoJTBBJTIwJTIwYmFja2VuZCUzRCUyMmh1Z2dpbmdmYWNlJTIyJTJDJTBBJTIwJTIwcmVnaW9uJTNEcmVnaW9uJTBBKQ==",highlighted:`image_uri = get_huggingface_llm_image_uri(
  backend=<span class="hljs-string">&quot;huggingface&quot;</span>,
  region=region
)`,wrap:!1}}),Fe=new u({props:{code:"bW9kZWxfbmFtZSUyMCUzRCUyMCUyMmxsYW1hLTMtMS04Yi1pbnN0cnVjdCUyMiUyMCUyQiUyMHRpbWUuc3RyZnRpbWUoJTIyJTI1WS0lMjVtLSUyNWQtJTI1SC0lMjVNLSUyNVMlMjIlMkMlMjB0aW1lLmdtdGltZSgpKSUwQSUwQWh1YiUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCdIRl9NT0RFTF9JRCclM0EnbWV0YS1sbGFtYSUyRkxsYW1hLTMuMS04Qi1JbnN0cnVjdCclMkMlMEElMjAlMjAlMjAlMjAnU01fTlVNX0dQVVMnJTNBJzEnJTJDJTBBJTA5J0hVR0dJTkdfRkFDRV9IVUJfVE9LRU4nJTNBJTIwJyUzQ1JFUExBQ0UlMjBXSVRIJTIwWU9VUiUyMFRPS0VOJTNFJyUyQyUwQSU3RCUwQSUwQWFzc2VydCUyMGh1YiU1QidIVUdHSU5HX0ZBQ0VfSFVCX1RPS0VOJyU1RCUyMCElM0QlMjAnJTNDUkVQTEFDRSUyMFdJVEglMjBZT1VSJTIwVE9LRU4lM0UnJTJDJTIwJTIyWW91JTIwaGF2ZSUyMHRvJTIwcHJvdmlkZSUyMGElMjB0b2tlbi4lMjIlMEElMEElMEFtb2RlbCUyMCUzRCUyMEh1Z2dpbmdGYWNlTW9kZWwoJTBBJTIwJTIwJTIwJTIwbmFtZSUzRG1vZGVsX25hbWUlMkMlMEElMjAlMjAlMjAlMjBlbnYlM0RodWIlMkMlMEElMjAlMjAlMjAlMjByb2xlJTNEcm9sZSUyQyUwQSUyMCUyMCUyMCUyMGltYWdlX3VyaSUzRGltYWdlX3VyaSUwQSk=",highlighted:`model_name = <span class="hljs-string">&quot;llama-3-1-8b-instruct&quot;</span> + time.strftime(<span class="hljs-string">&quot;%Y-%m-%d-%H-%M-%S&quot;</span>, time.gmtime())

hub = {
    <span class="hljs-string">&#x27;HF_MODEL_ID&#x27;</span>:<span class="hljs-string">&#x27;meta-llama/Llama-3.1-8B-Instruct&#x27;</span>,
    <span class="hljs-string">&#x27;SM_NUM_GPUS&#x27;</span>:<span class="hljs-string">&#x27;1&#x27;</span>,
	<span class="hljs-string">&#x27;HUGGING_FACE_HUB_TOKEN&#x27;</span>: <span class="hljs-string">&#x27;&lt;REPLACE WITH YOUR TOKEN&gt;&#x27;</span>,
}

<span class="hljs-keyword">assert</span> hub[<span class="hljs-string">&#x27;HUGGING_FACE_HUB_TOKEN&#x27;</span>] != <span class="hljs-string">&#x27;&lt;REPLACE WITH YOUR TOKEN&gt;&#x27;</span>, <span class="hljs-string">&quot;You have to provide a token.&quot;</span>


model = HuggingFaceModel(
    name=model_name,
    env=hub,
    role=role,
    image_uri=image_uri
)`,wrap:!1}}),Qe=new u({props:{code:"cHJlZGljdG9yJTIwJTNEJTIwbW9kZWwuZGVwbG95KCUwQSUyMCUyMGluaXRpYWxfaW5zdGFuY2VfY291bnQlM0QxJTJDJTBBJTIwJTIwaW5zdGFuY2VfdHlwZSUzRCUyMm1sLmc1LjJ4bGFyZ2UlMjIlMkMlMEElMjAlMjBlbmRwb2ludF9uYW1lJTNEbW9kZWxfbmFtZSUwQSk=",highlighted:`predictor = model.deploy(
  initial_instance_count=<span class="hljs-number">1</span>,
  instance_type=<span class="hljs-string">&quot;ml.g5.2xlarge&quot;</span>,
  endpoint_name=model_name
)`,wrap:!1}}),qe=new u({props:{code:"aW5wdXRfZGF0YSUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMmlucHV0cyUyMiUzQSUyMCUyMlRoZSUyMGRpYW1vbmRiYWNrJTIwdGVycmFwaW4lMjB3YXMlMjB0aGUlMjBmaXJzdCUyMHJlcHRpbGUlMjB0byUyMiUyQyUwQSUyMCUyMCUyMnBhcmFtZXRlcnMlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJkb19zYW1wbGUlMjIlM0ElMjBUcnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIybWF4X25ld190b2tlbnMlMjIlM0ElMjAxMDAlMkMlMEElMjAlMjAlMjAlMjAlMjJ0ZW1wZXJhdHVyZSUyMiUzQSUyMDAuNyUyQyUwQSUyMCUyMCUyMCUyMCUyMndhdGVybWFyayUyMiUzQSUyMFRydWUlMEElMjAlMjAlN0QlMEElN0QlMEElMEFwcmVkaWN0b3IucHJlZGljdChpbnB1dF9kYXRhKQ==",highlighted:`input_data = {
  <span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;The diamondback terrapin was the first reptile to&quot;</span>,
  <span class="hljs-string">&quot;parameters&quot;</span>: {
    <span class="hljs-string">&quot;do_sample&quot;</span>: <span class="hljs-literal">True</span>,
    <span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">100</span>,
    <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">0.7</span>,
    <span class="hljs-string">&quot;watermark&quot;</span>: <span class="hljs-literal">True</span>
  }
}

predictor.predict(input_data)`,wrap:!1}}),De=new u({props:{code:"JTVCJTdCJ2dlbmVyYXRlZF90ZXh0JyUzQSUyMCdUaGUlMjBkaWFtb25kYmFjayUyMHRlcnJhcGluJTIwd2FzJTIwdGhlJTIwZmlyc3QlMjByZXB0aWxlJTIwdG8lMjBtYWtlJTIwdGhlJTIwbGlzdCUyQyUyMGZvbGxvd2VkJTIwYnklMjB0aGUlMjBBbWVyaWNhbiUyMGFsbGlnYXRvciUyQyUyMHRoZSUyMEFtZXJpY2FuJTIwY3JvY29kaWxlJTJDJTIwYW5kJTIwdGhlJTIwQW1lcmljYW4lMjBib3glMjB0dXJ0bGUuJTIwVGhlJTIwcG9sZWNhdCUyQyUyMGElMjBmZXJyZXQtbGlrZSUyMGFuaW1hbCUyQyUyMGFuZCUyMHRoZSUyMHNrdW5rJTIwcm91bmRlZCUyMG91dCUyMHRoZSUyMGxpc3QlMkMlMjBib3RoJTIwaGF2aW5nJTIwZ2FpbmVkJTIwdGhlaXIlMjBzbG90cyUyMGJlY2F1c2UlMjB0aGV5JTIwaGF2ZSUyMHByb3ZlbiUyMHRvJTIwYmUlMjBwYXJ0aWN1bGFybHklMjBkYW5nZXJvdXMlMjB0byUyMGh1bWFucy4lNUNuJTVDbkNhbGlmb3JuaWFucyUyMGFsc28lMjBzZWVtZWQlMjB0byUyMGFwcHJlY2lhdGUlMjB0aGUlMjBuZXclMjBsaXN0JTJDJTIwanVkZ2luZyUyMGJ5JTIwdGhlJTIwY29tbWVudHMlMjBsZWZ0JTIwYWZ0ZXIlMjB0aGUlMjBlbGVjdGlvbi4lNUNuJTVDbiVFMiU4MCU5Q1RoaXMlMjBpcyUyMGZhbnRhc3RpYyUyQyVFMiU4MCU5RCUyMG9uZSUyMGNvbW1lbnRlciUyMGRlY2xhcmVkLiU1Q24lNUNuJUUyJTgwJTlDQ2FsaWZvcm5pYSUyMGlzJTIwYSUyMHZlcnknJTdEJTVE",highlighted:'[{<span class="hljs-string">&#x27;generated_text&#x27;</span>: <span class="hljs-string">&#x27;The diamondback terrapin was the first reptile to make the list, followed by the American alligator, the American crocodile, and the American box turtle. The polecat, a ferret-like animal, and the skunk rounded out the list, both having gained their slots because they have proven to be particularly dangerous to humans.\\n\\nCalifornians also seemed to appreciate the new list, judging by the comments left after the election.\\n\\n“This is fantastic,” one commenter declared.\\n\\n“California is a very&#x27;</span>}]',wrap:!1}}),Oe=new u({props:{code:"cHJlZGljdG9yLmRlbGV0ZV9tb2RlbCgpJTBBcHJlZGljdG9yLmRlbGV0ZV9lbmRwb2ludCgp",highlighted:`predictor.delete_model()
predictor.delete_endpoint()`,wrap:!1}}),el=new J({props:{title:"User defined code and modules",local:"user-defined-code-and-modules",headingTag:"h2"}}),tl=new u({props:{code:"bW9kZWwudGFyLmd6JTJGJTBBJTdDLSUyMHB5dG9yY2hfbW9kZWwuYmluJTBBJTdDLSUyMC4uLi4lMEElN0MtJTIwY29kZSUyRiUwQSUyMCUyMCU3Qy0lMjBpbmZlcmVuY2UucHklMEElMjAlMjAlN0MtJTIwcmVxdWlyZW1lbnRzLnR4dCUyMA==",highlighted:`model.tar.gz/
|- pytorch_model.bin
|- ....
|- code/
  |- inference.py
  |- requirements.txt `,wrap:!1}}),Ml=new u({props:{code:"ZnJvbSUyMHNhZ2VtYWtlcl9odWdnaW5nZmFjZV9pbmZlcmVuY2VfdG9vbGtpdCUyMGltcG9ydCUyMGRlY29kZXJfZW5jb2RlciUwQSUwQWRlZiUyMG1vZGVsX2ZuKG1vZGVsX2RpciklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBpbXBsZW1lbnQlMjBjdXN0b20lMjBjb2RlJTIwdG8lMjBsb2FkJTIwdGhlJTIwbW9kZWwlMEElMjAlMjAlMjAlMjBsb2FkZWRfbW9kZWwlMjAlM0QlMjAuLi4lMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBsb2FkZWRfbW9kZWwlMjAlMEElMEFkZWYlMjBpbnB1dF9mbihpbnB1dF9kYXRhJTJDJTIwY29udGVudF90eXBlKSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMGRlY29kZSUyMHRoZSUyMGlucHV0JTIwZGF0YSUyMCUyMChlLmcuJTIwSlNPTiUyMHN0cmluZyUyMC0lM0UlMjBkaWN0KSUwQSUyMCUyMCUyMCUyMGRhdGElMjAlM0QlMjBkZWNvZGVyX2VuY29kZXIuZGVjb2RlKGlucHV0X2RhdGElMkMlMjBjb250ZW50X3R5cGUpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZGF0YSUwQSUwQWRlZiUyMHByZWRpY3RfZm4oZGF0YSUyQyUyMG1vZGVsKSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMGNhbGwlMjB5b3VyJTIwY3VzdG9tJTIwbW9kZWwlMjB3aXRoJTIwdGhlJTIwZGF0YSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbChkYXRhJTIwJTJDJTIwLi4uJTIwKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHByZWRpY3Rpb25zJTBBJTBBZGVmJTIwb3V0cHV0X2ZuKHByZWRpY3Rpb24lMkMlMjBhY2NlcHQpJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwY29udmVydCUyMHRoZSUyMG1vZGVsJTIwb3V0cHV0JTIwdG8lMjB0aGUlMjBkZXNpcmVkJTIwb3V0cHV0JTIwZm9ybWF0JTIwKGUuZy4lMjBkaWN0JTIwLSUzRSUyMEpTT04lMjBzdHJpbmcpJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjBkZWNvZGVyX2VuY29kZXIuZW5jb2RlKHByZWRpY3Rpb24lMkMlMjBhY2NlcHQpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwcmVzcG9uc2U=",highlighted:`<span class="hljs-keyword">from</span> sagemaker_huggingface_inference_toolkit <span class="hljs-keyword">import</span> decoder_encoder

<span class="hljs-keyword">def</span> <span class="hljs-title function_">model_fn</span>(<span class="hljs-params">model_dir</span>):
    <span class="hljs-comment"># implement custom code to load the model</span>
    loaded_model = ...
    
    <span class="hljs-keyword">return</span> loaded_model 

<span class="hljs-keyword">def</span> <span class="hljs-title function_">input_fn</span>(<span class="hljs-params">input_data, content_type</span>):
    <span class="hljs-comment"># decode the input data  (e.g. JSON string -&gt; dict)</span>
    data = decoder_encoder.decode(input_data, content_type)
    <span class="hljs-keyword">return</span> data

<span class="hljs-keyword">def</span> <span class="hljs-title function_">predict_fn</span>(<span class="hljs-params">data, model</span>):
    <span class="hljs-comment"># call your custom model with the data</span>
    outputs = model(data , ... )
    <span class="hljs-keyword">return</span> predictions

<span class="hljs-keyword">def</span> <span class="hljs-title function_">output_fn</span>(<span class="hljs-params">prediction, accept</span>):
    <span class="hljs-comment"># convert the model output to the desired output format (e.g. dict -&gt; JSON string)</span>
    response = decoder_encoder.encode(prediction, accept)
    <span class="hljs-keyword">return</span> response`,wrap:!1}}),il=new u({props:{code:"ZnJvbSUyMHNhZ2VtYWtlcl9odWdnaW5nZmFjZV9pbmZlcmVuY2VfdG9vbGtpdCUyMGltcG9ydCUyMGRlY29kZXJfZW5jb2RlciUwQSUwQWRlZiUyMG1vZGVsX2ZuKG1vZGVsX2RpciklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBpbXBsZW1lbnQlMjBjdXN0b20lMjBjb2RlJTIwdG8lMjBsb2FkJTIwdGhlJTIwbW9kZWwlMEElMjAlMjAlMjAlMjBsb2FkZWRfbW9kZWwlMjAlM0QlMjAuLi4lMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBsb2FkZWRfbW9kZWwlMjAlMEElMEFkZWYlMjB0cmFuc2Zvcm1fZm4obW9kZWwlMkMlMjBpbnB1dF9kYXRhJTJDJTIwY29udGVudF90eXBlJTJDJTIwYWNjZXB0KSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMyUyMGRlY29kZSUyMHRoZSUyMGlucHV0JTIwZGF0YSUyMChlLmcuJTIwSlNPTiUyMHN0cmluZyUyMC0lM0UlMjBkaWN0KSUwQSUyMCUyMCUyMCUyMGRhdGElMjAlM0QlMjBkZWNvZGVyX2VuY29kZXIuZGVjb2RlKGlucHV0X2RhdGElMkMlMjBjb250ZW50X3R5cGUpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwY2FsbCUyMHlvdXIlMjBjdXN0b20lMjBtb2RlbCUyMHdpdGglMjB0aGUlMjBkYXRhJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGRhdGElMjAlMkMlMjAuLi4lMjApJTIwJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwY29udmVydCUyMHRoZSUyMG1vZGVsJTIwb3V0cHV0JTIwdG8lMjB0aGUlMjBkZXNpcmVkJTIwb3V0cHV0JTIwZm9ybWF0JTIwKGUuZy4lMjBkaWN0JTIwLSUzRSUyMEpTT04lMjBzdHJpbmcpJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjBkZWNvZGVyX2VuY29kZXIuZW5jb2RlKG91dHB1dCUyQyUyMGFjY2VwdCklMEElMEElMjAlMjAlMjAlMjByZXR1cm4lMjByZXNwb25zZQ==",highlighted:`<span class="hljs-keyword">from</span> sagemaker_huggingface_inference_toolkit <span class="hljs-keyword">import</span> decoder_encoder

<span class="hljs-keyword">def</span> <span class="hljs-title function_">model_fn</span>(<span class="hljs-params">model_dir</span>):
    <span class="hljs-comment"># implement custom code to load the model</span>
    loaded_model = ...
    
    <span class="hljs-keyword">return</span> loaded_model 

<span class="hljs-keyword">def</span> <span class="hljs-title function_">transform_fn</span>(<span class="hljs-params">model, input_data, content_type, accept</span>):
     <span class="hljs-comment"># decode the input data (e.g. JSON string -&gt; dict)</span>
    data = decoder_encoder.decode(input_data, content_type)

    <span class="hljs-comment"># call your custom model with the data</span>
    outputs = model(data , ... ) 

    <span class="hljs-comment"># convert the model output to the desired output format (e.g. dict -&gt; JSON string)</span>
    response = decoder_encoder.encode(output, accept)

    <span class="hljs-keyword">return</span> response`,wrap:!1}}),rl=new bn({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/sagemaker/source/tutorials/sagemaker-sdk/deploy-sagemaker-sdk.md"}}),{c(){h=M("meta"),ml=n(),pl=M("p"),cl=n(),r(I.$$.fragment),ul=n(),g=M("p"),g.textContent=rs,Ul=n(),r(C.$$.fragment),jl=n(),Z=M("p"),Z.innerHTML=ps,Tl=n(),B=M("ul"),B.innerHTML=ys,wl=n(),r(k.$$.fragment),Jl=n(),G=M("p"),G.innerHTML=ds,hl=n(),W=M("p"),W.textContent=ms,fl=n(),A=M("ul"),A.innerHTML=cs,bl=n(),v=M("p"),v.innerHTML=us,Il=n(),_=M("p"),_.innerHTML=Us,gl=n(),r($.$$.fragment),Cl=n(),S=M("p"),S.innerHTML=js,Zl=n(),H=M("p"),H.textContent=Ts,Bl=n(),r(R.$$.fragment),kl=n(),E=M("p"),E.innerHTML=ws,Gl=n(),V=M("p"),V.innerHTML=Js,Wl=n(),x=M("p"),x.textContent=hs,Al=n(),r(Y.$$.fragment),vl=n(),r(N.$$.fragment),_l=n(),j=M("iframe"),$l=n(),z=M("p"),z.textContent=bs,Sl=n(),F=M("ul"),F.innerHTML=Is,Hl=n(),X=M("p"),X.innerHTML=gs,Rl=n(),r(Q.$$.fragment),El=n(),L=M("p"),L.textContent=Cs,Vl=n(),q=M("p"),q.innerHTML=Zs,xl=n(),r(P.$$.fragment),Yl=n(),D=M("p"),D.textContent=Bs,Nl=n(),r(K.$$.fragment),zl=n(),r(O.$$.fragment),Fl=n(),ee=M("p"),ee.innerHTML=ks,Xl=n(),r(le.$$.fragment),Ql=n(),te=M("p"),te.textContent=Gs,Ll=n(),r(se.$$.fragment),ql=n(),r(ne.$$.fragment),Pl=n(),ae=M("p"),ae.innerHTML=Ws,Dl=n(),Me=M("ul"),Me.innerHTML=As,Kl=n(),oe=M("p"),oe.textContent=vs,Ol=n(),r(ie.$$.fragment),et=n(),re=M("p"),re.innerHTML=_s,lt=n(),pe=M("ol"),pe.innerHTML=$s,tt=n(),r(ye.$$.fragment),st=n(),f=M("ol"),f.innerHTML=Ss,nt=n(),r(de.$$.fragment),at=n(),b=M("ol"),b.innerHTML=Hs,Mt=n(),r(me.$$.fragment),ot=n(),ce=M("p"),ce.innerHTML=Rs,it=n(),r(ue.$$.fragment),rt=n(),T=M("iframe"),pt=n(),Ue=M("p"),Ue.innerHTML=Vs,yt=n(),je=M("ul"),je.innerHTML=xs,dt=n(),Te=M("blockquote"),Te.innerHTML=Ys,mt=n(),r(we.$$.fragment),ct=n(),Je=M("p"),Je.textContent=Ns,ut=n(),r(he.$$.fragment),Ut=n(),fe=M("p"),fe.innerHTML=zs,jt=n(),r(be.$$.fragment),Tt=n(),w=M("iframe"),wt=n(),Ie=M("p"),Ie.innerHTML=Xs,Jt=n(),ge=M("p"),ge.innerHTML=Qs,ht=n(),Ce=M("p"),Ce.innerHTML=Ls,ft=n(),Ze=M("p"),Ze.innerHTML=qs,bt=n(),r(Be.$$.fragment),It=n(),ke=M("p"),ke.innerHTML=Ps,gt=n(),r(Ge.$$.fragment),Ct=n(),We=M("p"),We.innerHTML=Ds,Zt=n(),r(Ae.$$.fragment),Bt=n(),ve=M("p"),ve.innerHTML=Ks,kt=n(),r(_e.$$.fragment),Gt=n(),$e=M("p"),$e.innerHTML=Os,Wt=n(),Se=M("p"),Se.textContent=en,At=n(),r(He.$$.fragment),vt=n(),Re=M("p"),Re.textContent=ln,_t=n(),r(Ee.$$.fragment),$t=n(),Ve=M("p"),Ve.textContent=tn,St=n(),r(xe.$$.fragment),Ht=n(),Ye=M("p"),Ye.innerHTML=sn,Rt=n(),Ne=M("p"),Ne.innerHTML=nn,Et=n(),ze=M("p"),ze.innerHTML=an,Vt=n(),r(Fe.$$.fragment),xt=n(),Xe=M("p"),Xe.textContent=Mn,Yt=n(),r(Qe.$$.fragment),Nt=n(),Le=M("p"),Le.textContent=on,zt=n(),r(qe.$$.fragment),Ft=n(),Pe=M("p"),Pe.textContent=rn,Xt=n(),r(De.$$.fragment),Qt=n(),Ke=M("p"),Ke.textContent=pn,Lt=n(),r(Oe.$$.fragment),qt=n(),r(el.$$.fragment),Pt=n(),ll=M("p"),ll.innerHTML=yn,Dt=n(),r(tl.$$.fragment),Kt=n(),sl=M("p"),sl.innerHTML=dn,Ot=n(),nl=M("ul"),nl.innerHTML=mn,es=n(),al=M("p"),al.innerHTML=cn,ls=n(),r(Ml.$$.fragment),ts=n(),ol=M("p"),ol.innerHTML=un,ss=n(),r(il.$$.fragment),ns=n(),r(rl.$$.fragment),as=n(),yl=M("p"),this.h()},l(e){const l=hn("svelte-u9bgzb",document.head);h=o(l,"META",{name:!0,content:!0}),l.forEach(t),ml=a(e),pl=o(e,"P",{}),dl(pl).forEach(t),cl=a(e),p(I.$$.fragment,e),ul=a(e),g=o(e,"P",{"data-svelte-h":!0}),i(g)!=="svelte-ywypfi"&&(g.textContent=rs),Ul=a(e),p(C.$$.fragment,e),jl=a(e),Z=o(e,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-lx9xk7"&&(Z.innerHTML=ps),Tl=a(e),B=o(e,"UL",{"data-svelte-h":!0}),i(B)!=="svelte-lmxuwx"&&(B.innerHTML=ys),wl=a(e),p(k.$$.fragment,e),Jl=a(e),G=o(e,"P",{"data-svelte-h":!0}),i(G)!=="svelte-uia7yx"&&(G.innerHTML=ds),hl=a(e),W=o(e,"P",{"data-svelte-h":!0}),i(W)!=="svelte-14pz1nf"&&(W.textContent=ms),fl=a(e),A=o(e,"UL",{"data-svelte-h":!0}),i(A)!=="svelte-nu9uzs"&&(A.innerHTML=cs),bl=a(e),v=o(e,"P",{"data-svelte-h":!0}),i(v)!=="svelte-10vylvb"&&(v.innerHTML=us),Il=a(e),_=o(e,"P",{"data-svelte-h":!0}),i(_)!=="svelte-183wm56"&&(_.innerHTML=Us),gl=a(e),p($.$$.fragment,e),Cl=a(e),S=o(e,"P",{"data-svelte-h":!0}),i(S)!=="svelte-aqpf90"&&(S.innerHTML=js),Zl=a(e),H=o(e,"P",{"data-svelte-h":!0}),i(H)!=="svelte-1n86nit"&&(H.textContent=Ts),Bl=a(e),p(R.$$.fragment,e),kl=a(e),E=o(e,"P",{"data-svelte-h":!0}),i(E)!=="svelte-bmcgfj"&&(E.innerHTML=ws),Gl=a(e),V=o(e,"P",{"data-svelte-h":!0}),i(V)!=="svelte-12o7543"&&(V.innerHTML=Js),Wl=a(e),x=o(e,"P",{"data-svelte-h":!0}),i(x)!=="svelte-qjt50s"&&(x.textContent=hs),Al=a(e),p(Y.$$.fragment,e),vl=a(e),p(N.$$.fragment,e),_l=a(e),j=o(e,"IFRAME",{width:!0,height:!0,src:!0,title:!0,frameborder:!0,allow:!0}),dl(j).forEach(t),$l=a(e),z=o(e,"P",{"data-svelte-h":!0}),i(z)!=="svelte-gux9y"&&(z.textContent=bs),Sl=a(e),F=o(e,"UL",{"data-svelte-h":!0}),i(F)!=="svelte-g9t1l6"&&(F.innerHTML=Is),Hl=a(e),X=o(e,"P",{"data-svelte-h":!0}),i(X)!=="svelte-1kzoo7i"&&(X.innerHTML=gs),Rl=a(e),p(Q.$$.fragment,e),El=a(e),L=o(e,"P",{"data-svelte-h":!0}),i(L)!=="svelte-1bnjjtb"&&(L.textContent=Cs),Vl=a(e),q=o(e,"P",{"data-svelte-h":!0}),i(q)!=="svelte-qrjq9z"&&(q.innerHTML=Zs),xl=a(e),p(P.$$.fragment,e),Yl=a(e),D=o(e,"P",{"data-svelte-h":!0}),i(D)!=="svelte-1704hsx"&&(D.textContent=Bs),Nl=a(e),p(K.$$.fragment,e),zl=a(e),p(O.$$.fragment,e),Fl=a(e),ee=o(e,"P",{"data-svelte-h":!0}),i(ee)!=="svelte-xplu1m"&&(ee.innerHTML=ks),Xl=a(e),p(le.$$.fragment,e),Ql=a(e),te=o(e,"P",{"data-svelte-h":!0}),i(te)!=="svelte-10df72h"&&(te.textContent=Gs),Ll=a(e),p(se.$$.fragment,e),ql=a(e),p(ne.$$.fragment,e),Pl=a(e),ae=o(e,"P",{"data-svelte-h":!0}),i(ae)!=="svelte-1bx7pn1"&&(ae.innerHTML=Ws),Dl=a(e),Me=o(e,"UL",{"data-svelte-h":!0}),i(Me)!=="svelte-1yevczk"&&(Me.innerHTML=As),Kl=a(e),oe=o(e,"P",{"data-svelte-h":!0}),i(oe)!=="svelte-1fj2qwz"&&(oe.textContent=vs),Ol=a(e),p(ie.$$.fragment,e),et=a(e),re=o(e,"P",{"data-svelte-h":!0}),i(re)!=="svelte-6vx79s"&&(re.innerHTML=_s),lt=a(e),pe=o(e,"OL",{"data-svelte-h":!0}),i(pe)!=="svelte-1oe4mbx"&&(pe.innerHTML=$s),tt=a(e),p(ye.$$.fragment,e),st=a(e),f=o(e,"OL",{start:!0,"data-svelte-h":!0}),i(f)!=="svelte-1dpsw5r"&&(f.innerHTML=Ss),nt=a(e),p(de.$$.fragment,e),at=a(e),b=o(e,"OL",{start:!0,"data-svelte-h":!0}),i(b)!=="svelte-1jup9fl"&&(b.innerHTML=Hs),Mt=a(e),p(me.$$.fragment,e),ot=a(e),ce=o(e,"P",{"data-svelte-h":!0}),i(ce)!=="svelte-fiqqyd"&&(ce.innerHTML=Rs),it=a(e),p(ue.$$.fragment,e),rt=a(e),T=o(e,"IFRAME",{width:!0,height:!0,src:!0,title:!0,frameborder:!0,allow:!0}),dl(T).forEach(t),pt=a(e),Ue=o(e,"P",{"data-svelte-h":!0}),i(Ue)!=="svelte-1rqi6h3"&&(Ue.innerHTML=Vs),yt=a(e),je=o(e,"UL",{"data-svelte-h":!0}),i(je)!=="svelte-24bif2"&&(je.innerHTML=xs),dt=a(e),Te=o(e,"BLOCKQUOTE",{"data-svelte-h":!0}),i(Te)!=="svelte-1me1jis"&&(Te.innerHTML=Ys),mt=a(e),p(we.$$.fragment,e),ct=a(e),Je=o(e,"P",{"data-svelte-h":!0}),i(Je)!=="svelte-10df72h"&&(Je.textContent=Ns),ut=a(e),p(he.$$.fragment,e),Ut=a(e),fe=o(e,"P",{"data-svelte-h":!0}),i(fe)!=="svelte-116ugu4"&&(fe.innerHTML=zs),jt=a(e),p(be.$$.fragment,e),Tt=a(e),w=o(e,"IFRAME",{width:!0,height:!0,src:!0,title:!0,frameborder:!0,allow:!0}),dl(w).forEach(t),wt=a(e),Ie=o(e,"P",{"data-svelte-h":!0}),i(Ie)!=="svelte-6zcket"&&(Ie.innerHTML=Xs),Jt=a(e),ge=o(e,"P",{"data-svelte-h":!0}),i(ge)!=="svelte-11i511d"&&(ge.innerHTML=Qs),ht=a(e),Ce=o(e,"P",{"data-svelte-h":!0}),i(Ce)!=="svelte-1aa5m67"&&(Ce.innerHTML=Ls),ft=a(e),Ze=o(e,"P",{"data-svelte-h":!0}),i(Ze)!=="svelte-h98oit"&&(Ze.innerHTML=qs),bt=a(e),p(Be.$$.fragment,e),It=a(e),ke=o(e,"P",{"data-svelte-h":!0}),i(ke)!=="svelte-1ttbskl"&&(ke.innerHTML=Ps),gt=a(e),p(Ge.$$.fragment,e),Ct=a(e),We=o(e,"P",{"data-svelte-h":!0}),i(We)!=="svelte-1pml3h7"&&(We.innerHTML=Ds),Zt=a(e),p(Ae.$$.fragment,e),Bt=a(e),ve=o(e,"P",{"data-svelte-h":!0}),i(ve)!=="svelte-1uayvx5"&&(ve.innerHTML=Ks),kt=a(e),p(_e.$$.fragment,e),Gt=a(e),$e=o(e,"P",{"data-svelte-h":!0}),i($e)!=="svelte-oqngf7"&&($e.innerHTML=Os),Wt=a(e),Se=o(e,"P",{"data-svelte-h":!0}),i(Se)!=="svelte-kb3ib5"&&(Se.textContent=en),At=a(e),p(He.$$.fragment,e),vt=a(e),Re=o(e,"P",{"data-svelte-h":!0}),i(Re)!=="svelte-1alenu9"&&(Re.textContent=ln),_t=a(e),p(Ee.$$.fragment,e),$t=a(e),Ve=o(e,"P",{"data-svelte-h":!0}),i(Ve)!=="svelte-wr9zty"&&(Ve.textContent=tn),St=a(e),p(xe.$$.fragment,e),Ht=a(e),Ye=o(e,"P",{"data-svelte-h":!0}),i(Ye)!=="svelte-pyh7bd"&&(Ye.innerHTML=sn),Rt=a(e),Ne=o(e,"P",{"data-svelte-h":!0}),i(Ne)!=="svelte-w1qvv3"&&(Ne.innerHTML=nn),Et=a(e),ze=o(e,"P",{"data-svelte-h":!0}),i(ze)!=="svelte-2gsa94"&&(ze.innerHTML=an),Vt=a(e),p(Fe.$$.fragment,e),xt=a(e),Xe=o(e,"P",{"data-svelte-h":!0}),i(Xe)!=="svelte-1dpe0gw"&&(Xe.textContent=Mn),Yt=a(e),p(Qe.$$.fragment,e),Nt=a(e),Le=o(e,"P",{"data-svelte-h":!0}),i(Le)!=="svelte-16le46z"&&(Le.textContent=on),zt=a(e),p(qe.$$.fragment,e),Ft=a(e),Pe=o(e,"P",{"data-svelte-h":!0}),i(Pe)!=="svelte-v1a1yw"&&(Pe.textContent=rn),Xt=a(e),p(De.$$.fragment,e),Qt=a(e),Ke=o(e,"P",{"data-svelte-h":!0}),i(Ke)!=="svelte-1vaiyhh"&&(Ke.textContent=pn),Lt=a(e),p(Oe.$$.fragment,e),qt=a(e),p(el.$$.fragment,e),Pt=a(e),ll=o(e,"P",{"data-svelte-h":!0}),i(ll)!=="svelte-1ryqcdi"&&(ll.innerHTML=yn),Dt=a(e),p(tl.$$.fragment,e),Kt=a(e),sl=o(e,"P",{"data-svelte-h":!0}),i(sl)!=="svelte-1jy9y33"&&(sl.innerHTML=dn),Ot=a(e),nl=o(e,"UL",{"data-svelte-h":!0}),i(nl)!=="svelte-1m8cp8l"&&(nl.innerHTML=mn),es=a(e),al=o(e,"P",{"data-svelte-h":!0}),i(al)!=="svelte-d9i7vl"&&(al.innerHTML=cn),ls=a(e),p(Ml.$$.fragment,e),ts=a(e),ol=o(e,"P",{"data-svelte-h":!0}),i(ol)!=="svelte-1cih48j"&&(ol.innerHTML=un),ss=a(e),p(il.$$.fragment,e),ns=a(e),p(rl.$$.fragment,e),as=a(e),yl=o(e,"P",{}),dl(yl).forEach(t),this.h()},h(){U(h,"name","hf:doc:metadata"),U(h,"content",gn),U(j,"width","700"),U(j,"height","394"),os(j.src,fs="https://www.youtube.com/embed/pfBGgSGnYLs")||U(j,"src",fs),U(j,"title","YouTube video player"),U(j,"frameborder","0"),U(j,"allow","accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"),j.allowFullscreen="",U(f,"start","2"),U(b,"start","3"),U(T,"width","700"),U(T,"height","394"),os(T.src,Es="https://www.youtube.com/embed/l9QZuazbzWM")||U(T,"src",Es),U(T,"title","YouTube video player"),U(T,"frameborder","0"),U(T,"allow","accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"),T.allowFullscreen="",U(w,"width","700"),U(w,"height","394"),os(w.src,Fs="https://www.youtube.com/embed/lnTixz0tUBg")||U(w,"src",Fs),U(w,"title","YouTube video player"),U(w,"frameborder","0"),U(w,"allow","accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"),w.allowFullscreen=""},m(e,l){fn(document.head,h),s(e,ml,l),s(e,pl,l),s(e,cl,l),y(I,e,l),s(e,ul,l),s(e,g,l),s(e,Ul,l),y(C,e,l),s(e,jl,l),s(e,Z,l),s(e,Tl,l),s(e,B,l),s(e,wl,l),y(k,e,l),s(e,Jl,l),s(e,G,l),s(e,hl,l),s(e,W,l),s(e,fl,l),s(e,A,l),s(e,bl,l),s(e,v,l),s(e,Il,l),s(e,_,l),s(e,gl,l),y($,e,l),s(e,Cl,l),s(e,S,l),s(e,Zl,l),s(e,H,l),s(e,Bl,l),y(R,e,l),s(e,kl,l),s(e,E,l),s(e,Gl,l),s(e,V,l),s(e,Wl,l),s(e,x,l),s(e,Al,l),y(Y,e,l),s(e,vl,l),y(N,e,l),s(e,_l,l),s(e,j,l),s(e,$l,l),s(e,z,l),s(e,Sl,l),s(e,F,l),s(e,Hl,l),s(e,X,l),s(e,Rl,l),y(Q,e,l),s(e,El,l),s(e,L,l),s(e,Vl,l),s(e,q,l),s(e,xl,l),y(P,e,l),s(e,Yl,l),s(e,D,l),s(e,Nl,l),y(K,e,l),s(e,zl,l),y(O,e,l),s(e,Fl,l),s(e,ee,l),s(e,Xl,l),y(le,e,l),s(e,Ql,l),s(e,te,l),s(e,Ll,l),y(se,e,l),s(e,ql,l),y(ne,e,l),s(e,Pl,l),s(e,ae,l),s(e,Dl,l),s(e,Me,l),s(e,Kl,l),s(e,oe,l),s(e,Ol,l),y(ie,e,l),s(e,et,l),s(e,re,l),s(e,lt,l),s(e,pe,l),s(e,tt,l),y(ye,e,l),s(e,st,l),s(e,f,l),s(e,nt,l),y(de,e,l),s(e,at,l),s(e,b,l),s(e,Mt,l),y(me,e,l),s(e,ot,l),s(e,ce,l),s(e,it,l),y(ue,e,l),s(e,rt,l),s(e,T,l),s(e,pt,l),s(e,Ue,l),s(e,yt,l),s(e,je,l),s(e,dt,l),s(e,Te,l),s(e,mt,l),y(we,e,l),s(e,ct,l),s(e,Je,l),s(e,ut,l),y(he,e,l),s(e,Ut,l),s(e,fe,l),s(e,jt,l),y(be,e,l),s(e,Tt,l),s(e,w,l),s(e,wt,l),s(e,Ie,l),s(e,Jt,l),s(e,ge,l),s(e,ht,l),s(e,Ce,l),s(e,ft,l),s(e,Ze,l),s(e,bt,l),y(Be,e,l),s(e,It,l),s(e,ke,l),s(e,gt,l),y(Ge,e,l),s(e,Ct,l),s(e,We,l),s(e,Zt,l),y(Ae,e,l),s(e,Bt,l),s(e,ve,l),s(e,kt,l),y(_e,e,l),s(e,Gt,l),s(e,$e,l),s(e,Wt,l),s(e,Se,l),s(e,At,l),y(He,e,l),s(e,vt,l),s(e,Re,l),s(e,_t,l),y(Ee,e,l),s(e,$t,l),s(e,Ve,l),s(e,St,l),y(xe,e,l),s(e,Ht,l),s(e,Ye,l),s(e,Rt,l),s(e,Ne,l),s(e,Et,l),s(e,ze,l),s(e,Vt,l),y(Fe,e,l),s(e,xt,l),s(e,Xe,l),s(e,Yt,l),y(Qe,e,l),s(e,Nt,l),s(e,Le,l),s(e,zt,l),y(qe,e,l),s(e,Ft,l),s(e,Pe,l),s(e,Xt,l),y(De,e,l),s(e,Qt,l),s(e,Ke,l),s(e,Lt,l),y(Oe,e,l),s(e,qt,l),y(el,e,l),s(e,Pt,l),s(e,ll,l),s(e,Dt,l),y(tl,e,l),s(e,Kt,l),s(e,sl,l),s(e,Ot,l),s(e,nl,l),s(e,es,l),s(e,al,l),s(e,ls,l),y(Ml,e,l),s(e,ts,l),s(e,ol,l),s(e,ss,l),y(il,e,l),s(e,ns,l),y(rl,e,l),s(e,as,l),s(e,yl,l),Ms=!0},p:jn,i(e){Ms||(d(I.$$.fragment,e),d(C.$$.fragment,e),d(k.$$.fragment,e),d($.$$.fragment,e),d(R.$$.fragment,e),d(Y.$$.fragment,e),d(N.$$.fragment,e),d(Q.$$.fragment,e),d(P.$$.fragment,e),d(K.$$.fragment,e),d(O.$$.fragment,e),d(le.$$.fragment,e),d(se.$$.fragment,e),d(ne.$$.fragment,e),d(ie.$$.fragment,e),d(ye.$$.fragment,e),d(de.$$.fragment,e),d(me.$$.fragment,e),d(ue.$$.fragment,e),d(we.$$.fragment,e),d(he.$$.fragment,e),d(be.$$.fragment,e),d(Be.$$.fragment,e),d(Ge.$$.fragment,e),d(Ae.$$.fragment,e),d(_e.$$.fragment,e),d(He.$$.fragment,e),d(Ee.$$.fragment,e),d(xe.$$.fragment,e),d(Fe.$$.fragment,e),d(Qe.$$.fragment,e),d(qe.$$.fragment,e),d(De.$$.fragment,e),d(Oe.$$.fragment,e),d(el.$$.fragment,e),d(tl.$$.fragment,e),d(Ml.$$.fragment,e),d(il.$$.fragment,e),d(rl.$$.fragment,e),Ms=!0)},o(e){m(I.$$.fragment,e),m(C.$$.fragment,e),m(k.$$.fragment,e),m($.$$.fragment,e),m(R.$$.fragment,e),m(Y.$$.fragment,e),m(N.$$.fragment,e),m(Q.$$.fragment,e),m(P.$$.fragment,e),m(K.$$.fragment,e),m(O.$$.fragment,e),m(le.$$.fragment,e),m(se.$$.fragment,e),m(ne.$$.fragment,e),m(ie.$$.fragment,e),m(ye.$$.fragment,e),m(de.$$.fragment,e),m(me.$$.fragment,e),m(ue.$$.fragment,e),m(we.$$.fragment,e),m(he.$$.fragment,e),m(be.$$.fragment,e),m(Be.$$.fragment,e),m(Ge.$$.fragment,e),m(Ae.$$.fragment,e),m(_e.$$.fragment,e),m(He.$$.fragment,e),m(Ee.$$.fragment,e),m(xe.$$.fragment,e),m(Fe.$$.fragment,e),m(Qe.$$.fragment,e),m(qe.$$.fragment,e),m(De.$$.fragment,e),m(Oe.$$.fragment,e),m(el.$$.fragment,e),m(tl.$$.fragment,e),m(Ml.$$.fragment,e),m(il.$$.fragment,e),m(rl.$$.fragment,e),Ms=!1},d(e){e&&(t(ml),t(pl),t(cl),t(ul),t(g),t(Ul),t(jl),t(Z),t(Tl),t(B),t(wl),t(Jl),t(G),t(hl),t(W),t(fl),t(A),t(bl),t(v),t(Il),t(_),t(gl),t(Cl),t(S),t(Zl),t(H),t(Bl),t(kl),t(E),t(Gl),t(V),t(Wl),t(x),t(Al),t(vl),t(_l),t(j),t($l),t(z),t(Sl),t(F),t(Hl),t(X),t(Rl),t(El),t(L),t(Vl),t(q),t(xl),t(Yl),t(D),t(Nl),t(zl),t(Fl),t(ee),t(Xl),t(Ql),t(te),t(Ll),t(ql),t(Pl),t(ae),t(Dl),t(Me),t(Kl),t(oe),t(Ol),t(et),t(re),t(lt),t(pe),t(tt),t(st),t(f),t(nt),t(at),t(b),t(Mt),t(ot),t(ce),t(it),t(rt),t(T),t(pt),t(Ue),t(yt),t(je),t(dt),t(Te),t(mt),t(ct),t(Je),t(ut),t(Ut),t(fe),t(jt),t(Tt),t(w),t(wt),t(Ie),t(Jt),t(ge),t(ht),t(Ce),t(ft),t(Ze),t(bt),t(It),t(ke),t(gt),t(Ct),t(We),t(Zt),t(Bt),t(ve),t(kt),t(Gt),t($e),t(Wt),t(Se),t(At),t(vt),t(Re),t(_t),t($t),t(Ve),t(St),t(Ht),t(Ye),t(Rt),t(Ne),t(Et),t(ze),t(Vt),t(xt),t(Xe),t(Yt),t(Nt),t(Le),t(zt),t(Ft),t(Pe),t(Xt),t(Qt),t(Ke),t(Lt),t(qt),t(Pt),t(ll),t(Dt),t(Kt),t(sl),t(Ot),t(nl),t(es),t(al),t(ls),t(ts),t(ol),t(ss),t(ns),t(as),t(yl)),t(h),c(I,e),c(C,e),c(k,e),c($,e),c(R,e),c(Y,e),c(N,e),c(Q,e),c(P,e),c(K,e),c(O,e),c(le,e),c(se,e),c(ne,e),c(ie,e),c(ye,e),c(de,e),c(me,e),c(ue,e),c(we,e),c(he,e),c(be,e),c(Be,e),c(Ge,e),c(Ae,e),c(_e,e),c(He,e),c(Ee,e),c(xe,e),c(Fe,e),c(Qe,e),c(qe,e),c(De,e),c(Oe,e),c(el,e),c(tl,e),c(Ml,e),c(il,e),c(rl,e)}}}const gn='{"title":"Deploy models to Amazon SageMaker","local":"deploy-models-to-amazon-sagemaker","sections":[{"title":"Installation and setup","local":"installation-and-setup","sections":[],"depth":2},{"title":"Deploy a 🤗 Transformers model trained in SageMaker","local":"deploy-a--transformers-model-trained-in-sagemaker","sections":[{"title":"Deploy after training","local":"deploy-after-training","sections":[],"depth":3},{"title":"Deploy with model_data","local":"deploy-with-modeldata","sections":[],"depth":3},{"title":"Create a model artifact for deployment","local":"create-a-model-artifact-for-deployment","sections":[],"depth":3}],"depth":2},{"title":"Deploy a model from the 🤗 Hub","local":"deploy-a-model-from-the--hub","sections":[],"depth":2},{"title":"Run batch transform with 🤗 Transformers and SageMaker","local":"run-batch-transform-with--transformers-and-sagemaker","sections":[],"depth":2},{"title":"Deploy an LLM to SageMaker using TGI","local":"deploy-an-llm-to-sagemaker-using-tgi","sections":[],"depth":2},{"title":"User defined code and modules","local":"user-defined-code-and-modules","sections":[],"depth":2}],"depth":1}';function Cn(is){return Tn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Wn extends wn{constructor(h){super(),Jn(this,h,Cn,In,Un,{})}}export{Wn as component};
