import{s as Il,o as Wl,n as kl}from"../chunks/scheduler.389d799c.js";import{S as Gl,i as Bl,g as i,s as a,r as m,A as vl,h as o,f as t,c as s,j as Ul,u as d,x as r,k as Zl,y as Cl,a as n,v as p,d as c,t as M,w as h}from"../chunks/index.8f81d18f.js";import{T as Hl}from"../chunks/Tip.ad26ce4a.js";import{C as w}from"../chunks/CodeBlock.c0898180.js";import{H as ie,E as Vl}from"../chunks/getInferenceSnippets.623c9250.js";function Sl(me){let u,f='📍 Find the complete example on GitHub <a href="https://github.com/huggingface/hub-docs/tree/main/notebooks/sagemaker-sdk/deploy-embedding-models/sagemaker-notebook.ipynb" rel="nofollow">here</a>!';return{c(){u=i("p"),u.innerHTML=f},l(y){u=o(y,"P",{"data-svelte-h":!0}),r(u)!=="svelte-17nt2nn"&&(u.innerHTML=f)},m(y,oe){n(y,u,oe)},p:kl,d(y){y&&t(u)}}}function $l(me){let u,f,y,oe,b,de,J,el='This is an example on how to deploy the open Embedding Models, like <a href="https://huggingface.co/Snowflake/snowflake-arctic-embed-l" rel="nofollow">Snowflake/snowflake-arctic-embed-l</a>, <a href="https://huggingface.co/BAAI/bge-large-en-v1.5" rel="nofollow">BAAI/bge-large-en-v1.5</a> or <a href="https://huggingface.co/sentence-transformers/all-MiniLM-L6-v2" rel="nofollow">sentence-transformers/all-MiniLM-L6-v2</a> to Amazon SageMaker for inference using the new Hugging Face Embedding Inference Container. We will deploy the <a href="https://huggingface.co/Snowflake/snowflake-arctic-embed-m" rel="nofollow">Snowflake/snowflake-arctic-embed-m</a> one of the best open Embedding Models for retrieval and ranking on the <a href="https://huggingface.co/spaces/mteb/leaderboard" rel="nofollow">MTEB Leaderboard</a>.',pe,T,ll="The example covers:",ce,j,tl='<li><a href="#1-setup-development-environment">Setup development environment</a></li> <li><a href="#2-retrieve-the-new-hugging-face-embedding-container">Retrieve the new Hugging Face Embedding Container</a></li> <li><a href="#3-deploy-snowflake-arctic-to-amazon-sagemaker">Deploy Snowflake Arctic to Amazon SageMaker</a></li> <li><a href="#4-run-and-evaluate-inference-performance">Run and evaluate Inference performance</a></li> <li><a href="#5-delete-model-and-endpoint">Delete model and endpoint</a></li>',Me,U,he,Z,nl='The Hugging Face Embedding DLC is a new purpose-built Inference Container to easily deploy Embedding Models in a secure and managed environment. The DLC is powered by <a href="https://github.com/huggingface/text-embeddings-inference" rel="nofollow">Text Embedding Inference (TEI)</a> a blazing fast and memory efficient solution for deploying and serving Embedding Models. TEI enables high-performance extraction for the most popular models, including FlagEmbedding, Ember, GTE and E5. TEI implements many features such as:',ue,I,al="<li>No model graph compilation step</li> <li>Small docker images and fast boot times</li> <li>Token based dynamic batching</li> <li>Optimized transformers code for inference using Flash Attention, Candle and cuBLASLt</li> <li>Safetensors weight loading</li> <li>Production ready (distributed tracing with Open Telemetry, Prometheus metrics)</li>",ye,W,sl="TEI supports the following model architectures",we,k,il='<li>BERT/CamemBERT, e.g. <a href="https://huggingface.co/BAAI/bge-large-en-v1.5" rel="nofollow">BAAI/bge-large-en-v1.5</a> or <a href="https://huggingface.co/Snowflake/snowflake-arctic-embed-m" rel="nofollow">Snowflake/snowflake-arctic-embed-m</a></li> <li>RoBERTa, <a href="https://huggingface.co/sentence-transformers/all-roberta-large-v1" rel="nofollow">sentence-transformers/all-roberta-large-v1</a></li> <li>XLM-RoBERTa, e.g. <a href="https://huggingface.co/sentence-transformers/paraphrase-xlm-r-multilingual-v1" rel="nofollow">sentence-transformers/paraphrase-xlm-r-multilingual-v1</a></li> <li>NomicBert, e.g. <a href="https://huggingface.co/jinaai/jina-embeddings-v2-base-en" rel="nofollow">jinaai/jina-embeddings-v2-base-en</a></li> <li>JinaBert, e.g. <a href="https://huggingface.co/nomic-ai/nomic-embed-text-v1.5" rel="nofollow">nomic-ai/nomic-embed-text-v1.5</a></li>',ge,G,ol="Lets get started!",fe,B,be,v,rl="We are going to use the <code>sagemaker</code> python SDK to deploy Snowflake Arctic to Amazon SageMaker. We need to make sure to have an AWS account configured and the <code>sagemaker</code> python SDK installed.",Je,C,Te,H,ml='If you are going to use Sagemaker in a local environment. You need access to an IAM Role with the required permissions for Sagemaker. You can find <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html" rel="nofollow">here</a> more about it.',je,V,Ue,S,Ze,$,dl="Compared to deploying regular Hugging Face models we first need to retrieve the container uri and provide it to our <code>HuggingFaceModel</code> model class with a <code>image_uri</code> pointing to the image. To retrieve the new Hugging Face Embedding Container in Amazon SageMaker, we can use the <code>get_huggingface_llm_image_uri</code> method provided by the <code>sagemaker</code> SDK. This method allows us to retrieve the URI for the desired Hugging Face Embedding Container. Important to note is that TEI has 2 different versions for cpu and gpu, so we create a helper function to retrieve the correct image uri based on the instance type.",Ie,N,We,Y,ke,F,pl='To deploy  <a href="https://huggingface.co/Snowflake/snowflake-arctic-embed-m" rel="nofollow">Snowflake/snowflake-arctic-embed-m</a> to Amazon SageMaker we create a <code>HuggingFaceModel</code> model class and define our endpoint configuration including the <code>HF_MODEL_ID</code>, <code>instance_type</code> etc. We will use a <code>c6i.2xlarge</code> instance type, which has 4 Intel Ice-Lake vCPUs, 8GB of memory and costs around $0.204 per hour.',Ge,R,Be,E,cl="After we have created the <code>HuggingFaceModel</code> we can deploy it to Amazon SageMaker using the <code>deploy</code> method. We will deploy the model with the <code>ml.c6i.2xlarge</code> instance type.",ve,_,Ce,X,Ml="SageMaker will now create our endpoint and deploy the model to it. This can takes  ~5 minutes.",He,z,Ve,x,hl="After our endpoint is deployed we can run inference on it. We will use the <code>predict</code> method from the <code>predictor</code> to run inference on our endpoint.",Se,A,$e,Q,ul="Awesome we can now generate embeddings with our model, Lets test the performance of our model.",Ne,L,yl="We will send 3,900 requests to our endpoint use threading with 10 concurrent threads. We will measure the average latency and throughput of our endpoint. We are going to sent an input of 256 tokens to have a total of ~1 Million tokens. We decided to use 256 tokens as input length to find the balance between shorter and longer inputs.",Ye,q,wl="Note: When running the load test, the requests are sent from europe and the endpoint is deployed in us-east-1. This adds a network overhead to it.",Fe,P,Re,K,gl="Sending 3,900 requests or embedding 1 million tokens took around 841 seconds. This means we can run around ~5 requests per second. But keep in mind that includes the network latency from europe to us-east-1. When we inspect the latency of the endpoint through cloudwatch we can see that latency for our Embeddings model is 2s at 10 concurrent requests. This is very impressive for a small & old CPU instance, which cost ~150$ per month. You can deploy the model to a GPU instance to get faster inference times.",Ee,D,fl="<em>Note: We ran the same test on a <code>ml.g5.xlarge</code> with 1x NVIDIA A10G GPU. Embedding 1 million tokens took around 30 seconds. This means we can run around ~130 requests per second. The latency for the endpoint is 4ms at 10 concurrent requests. The <code>ml.g5.xlarge</code> costs around $1.408 per hour on Amazon SageMaker.</em>",_e,O,bl="GPU instance are much faster than CPU instances, but they are also more expensive. If you want to bulk process embeddings, you can use a GPU instance. If you want to run a small endpoint with low costs, you can use a CPU instance. We plan to work on a dedicated benchmark for the Hugging Face Embedding DLC in the future.",Xe,ee,ze,le,Jl='<img src="https://raw.githubusercontent.com/huggingface/hub-docs/refs/heads/main/docs/sagemaker/notebooks/sagemaker-sdk/deploy-embedding-models/assets/cw.png" alt="cw"/>',xe,te,Ae,ne,Tl="To clean up, we can delete the model and endpoint",Qe,ae,Le,qe,Pe,g,Ke,se,De,re,Oe;return b=new ie({props:{title:"How to deploy Embedding Models to Amazon SageMaker using new Hugging Face Embedding DLC",local:"how-to-deploy-embedding-models-to-amazon-sagemaker-using-new-hugging-face-embedding-dlc",headingTag:"h1"}}),U=new ie({props:{title:"What is Hugging Face Embedding DLC?",local:"what-is-hugging-face-embedding-dlc",headingTag:"h2"}}),B=new ie({props:{title:"1. Setup development environment",local:"1-setup-development-environment",headingTag:"h2"}}),C=new w({props:{code:"IXBpcCUyMGluc3RhbGwlMjAlMjJzYWdlbWFrZXIlM0UlM0QyLjIyMS4xJTIyJTIwLS11cGdyYWRlJTIwLS1xdWlldA==",highlighted:'!pip install <span class="hljs-string">&quot;sagemaker&gt;=2.221.1&quot;</span> --upgrade --quiet',wrap:!1}}),V=new w({props:{code:"aW1wb3J0JTIwc2FnZW1ha2VyJTBBaW1wb3J0JTIwYm90bzMlMEElMEFzZXNzJTIwJTNEJTIwc2FnZW1ha2VyLlNlc3Npb24oKSUwQSUyMyUyMHNhZ2VtYWtlciUyMHNlc3Npb24lMjBidWNrZXQlMjAtJTNFJTIwdXNlZCUyMGZvciUyMHVwbG9hZGluZyUyMGRhdGElMkMlMjBtb2RlbHMlMjBhbmQlMjBsb2dzJTBBJTIzJTIwc2FnZW1ha2VyJTIwd2lsbCUyMGF1dG9tYXRpY2FsbHklMjBjcmVhdGUlMjB0aGlzJTIwYnVja2V0JTIwaWYlMjBpdCUyMG5vdCUyMGV4aXN0cyUwQXNhZ2VtYWtlcl9zZXNzaW9uX2J1Y2tldCUyMCUzRCUyME5vbmUlMEFpZiUyMHNhZ2VtYWtlcl9zZXNzaW9uX2J1Y2tldCUyMGlzJTIwTm9uZSUyMGFuZCUyMHNlc3MlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBzZXQlMjB0byUyMGRlZmF1bHQlMjBidWNrZXQlMjBpZiUyMGElMjBidWNrZXQlMjBuYW1lJTIwaXMlMjBub3QlMjBnaXZlbiUwQSUyMCUyMCUyMCUyMHNhZ2VtYWtlcl9zZXNzaW9uX2J1Y2tldCUyMCUzRCUyMHNlc3MuZGVmYXVsdF9idWNrZXQoKSUwQSUwQXRyeSUzQSUwQSUyMCUyMCUyMCUyMHJvbGUlMjAlM0QlMjBzYWdlbWFrZXIuZ2V0X2V4ZWN1dGlvbl9yb2xlKCklMEFleGNlcHQlMjBWYWx1ZUVycm9yJTNBJTBBJTIwJTIwJTIwJTIwaWFtJTIwJTNEJTIwYm90bzMuY2xpZW50KCUyMmlhbSUyMiklMEElMjAlMjAlMjAlMjByb2xlJTIwJTNEJTIwaWFtLmdldF9yb2xlKFJvbGVOYW1lJTNEJTIyc2FnZW1ha2VyX2V4ZWN1dGlvbl9yb2xlJTIyKSU1QiUyMlJvbGUlMjIlNUQlNUIlMjJBcm4lMjIlNUQlMEElMEFzZXNzJTIwJTNEJTIwc2FnZW1ha2VyLlNlc3Npb24oZGVmYXVsdF9idWNrZXQlM0RzYWdlbWFrZXJfc2Vzc2lvbl9idWNrZXQpJTBBJTBBcHJpbnQoZiUyMnNhZ2VtYWtlciUyMHJvbGUlMjBhcm4lM0ElMjAlN0Jyb2xlJTdEJTIyKSUwQXByaW50KGYlMjJzYWdlbWFrZXIlMjBzZXNzaW9uJTIwcmVnaW9uJTNBJTIwJTdCc2Vzcy5ib3RvX3JlZ2lvbl9uYW1lJTdEJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> sagemaker
<span class="hljs-keyword">import</span> boto3

sess = sagemaker.Session()
<span class="hljs-comment"># sagemaker session bucket -&gt; used for uploading data, models and logs</span>
<span class="hljs-comment"># sagemaker will automatically create this bucket if it not exists</span>
sagemaker_session_bucket = <span class="hljs-literal">None</span>
<span class="hljs-keyword">if</span> sagemaker_session_bucket <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">and</span> sess <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
    <span class="hljs-comment"># set to default bucket if a bucket name is not given</span>
    sagemaker_session_bucket = sess.default_bucket()

<span class="hljs-keyword">try</span>:
    role = sagemaker.get_execution_role()
<span class="hljs-keyword">except</span> ValueError:
    iam = boto3.client(<span class="hljs-string">&quot;iam&quot;</span>)
    role = iam.get_role(RoleName=<span class="hljs-string">&quot;sagemaker_execution_role&quot;</span>)[<span class="hljs-string">&quot;Role&quot;</span>][<span class="hljs-string">&quot;Arn&quot;</span>]

sess = sagemaker.Session(default_bucket=sagemaker_session_bucket)

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;sagemaker role arn: <span class="hljs-subst">{role}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;sagemaker session region: <span class="hljs-subst">{sess.boto_region_name}</span>&quot;</span>)`,wrap:!1}}),S=new ie({props:{title:"2. Retrieve the new Hugging Face Embedding Container",local:"2-retrieve-the-new-hugging-face-embedding-container",headingTag:"h2"}}),N=new w({props:{code:"ZnJvbSUyMHNhZ2VtYWtlci5odWdnaW5nZmFjZSUyMGltcG9ydCUyMGdldF9odWdnaW5nZmFjZV9sbG1faW1hZ2VfdXJpJTBBJTBBJTBBJTIzJTIwcmV0cmlldmUlMjB0aGUlMjBpbWFnZSUyMHVyaSUyMGJhc2VkJTIwb24lMjBpbnN0YW5jZSUyMHR5cGUlMEFkZWYlMjBnZXRfaW1hZ2VfdXJpKGluc3RhbmNlX3R5cGUpJTNBJTBBJTIwJTIwJTIwJTIwa2V5JTIwJTNEJTIwKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmh1Z2dpbmdmYWNlLXRlaSUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwaW5zdGFuY2VfdHlwZS5zdGFydHN3aXRoKCUyMm1sLmclMjIpJTIwb3IlMjBpbnN0YW5jZV90eXBlLnN0YXJ0c3dpdGgoJTIybWwucCUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbHNlJTIwJTIyaHVnZ2luZ2ZhY2UtdGVpLWNwdSUyMiUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBnZXRfaHVnZ2luZ2ZhY2VfbGxtX2ltYWdlX3VyaShrZXklMkMlMjB2ZXJzaW9uJTNEJTIyMS40LjAlMjIp",highlighted:`<span class="hljs-keyword">from</span> sagemaker.huggingface <span class="hljs-keyword">import</span> get_huggingface_llm_image_uri


<span class="hljs-comment"># retrieve the image uri based on instance type</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_image_uri</span>(<span class="hljs-params">instance_type</span>):
    key = (
        <span class="hljs-string">&quot;huggingface-tei&quot;</span>
        <span class="hljs-keyword">if</span> instance_type.startswith(<span class="hljs-string">&quot;ml.g&quot;</span>) <span class="hljs-keyword">or</span> instance_type.startswith(<span class="hljs-string">&quot;ml.p&quot;</span>)
        <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;huggingface-tei-cpu&quot;</span>
    )
    <span class="hljs-keyword">return</span> get_huggingface_llm_image_uri(key, version=<span class="hljs-string">&quot;1.4.0&quot;</span>)`,wrap:!1}}),Y=new ie({props:{title:"3. Deploy Snowflake Arctic to Amazon SageMaker",local:"3-deploy-snowflake-arctic-to-amazon-sagemaker",headingTag:"h2"}}),R=new w({props:{code:"aW1wb3J0JTIwanNvbiUwQWZyb20lMjBzYWdlbWFrZXIuaHVnZ2luZ2ZhY2UlMjBpbXBvcnQlMjBIdWdnaW5nRmFjZU1vZGVsJTBBJTBBJTIzJTIwc2FnZW1ha2VyJTIwY29uZmlnJTBBaW5zdGFuY2VfdHlwZSUyMCUzRCUyMCUyMm1sLmc1LnhsYXJnZSUyMiUwQSUwQSUyMyUyMERlZmluZSUyME1vZGVsJTIwYW5kJTIwRW5kcG9pbnQlMjBjb25maWd1cmF0aW9uJTIwcGFyYW1ldGVyJTBBY29uZmlnJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIySEZfTU9ERUxfSUQlMjIlM0ElMjAlMjJTbm93Zmxha2UlMkZzbm93Zmxha2UtYXJjdGljLWVtYmVkLW0lMjIlMkMlMjAlMjAlMjMlMjBtb2RlbF9pZCUyMGZyb20lMjBoZi5jbyUyRm1vZGVscyUwQSU3RCUwQSUwQSUyMyUyMGNyZWF0ZSUyMEh1Z2dpbmdGYWNlTW9kZWwlMjB3aXRoJTIwdGhlJTIwaW1hZ2UlMjB1cmklMEFlbWJfbW9kZWwlMjAlM0QlMjBIdWdnaW5nRmFjZU1vZGVsKHJvbGUlM0Ryb2xlJTJDJTIwaW1hZ2VfdXJpJTNEZ2V0X2ltYWdlX3VyaShpbnN0YW5jZV90eXBlKSUyQyUyMGVudiUzRGNvbmZpZyk=",highlighted:`<span class="hljs-keyword">import</span> json
<span class="hljs-keyword">from</span> sagemaker.huggingface <span class="hljs-keyword">import</span> HuggingFaceModel

<span class="hljs-comment"># sagemaker config</span>
instance_type = <span class="hljs-string">&quot;ml.g5.xlarge&quot;</span>

<span class="hljs-comment"># Define Model and Endpoint configuration parameter</span>
config = {
    <span class="hljs-string">&quot;HF_MODEL_ID&quot;</span>: <span class="hljs-string">&quot;Snowflake/snowflake-arctic-embed-m&quot;</span>,  <span class="hljs-comment"># model_id from hf.co/models</span>
}

<span class="hljs-comment"># create HuggingFaceModel with the image uri</span>
emb_model = HuggingFaceModel(role=role, image_uri=get_image_uri(instance_type), env=config)`,wrap:!1}}),_=new w({props:{code:"JTIzJTIwRGVwbG95JTIwbW9kZWwlMjB0byUyMGFuJTIwZW5kcG9pbnQlMEElMjMlMjBodHRwcyUzQSUyRiUyRnNhZ2VtYWtlci5yZWFkdGhlZG9jcy5pbyUyRmVuJTJGc3RhYmxlJTJGYXBpJTJGaW5mZXJlbmNlJTJGbW9kZWwuaHRtbCUyM3NhZ2VtYWtlci5tb2RlbC5Nb2RlbC5kZXBsb3klMEFlbWIlMjAlM0QlMjBlbWJfbW9kZWwuZGVwbG95KCUwQSUyMCUyMCUyMCUyMGluaXRpYWxfaW5zdGFuY2VfY291bnQlM0QxJTJDJTBBJTIwJTIwJTIwJTIwaW5zdGFuY2VfdHlwZSUzRGluc3RhbmNlX3R5cGUlMkMlMEEp",highlighted:`<span class="hljs-comment"># Deploy model to an endpoint</span>
<span class="hljs-comment"># https://sagemaker.readthedocs.io/en/stable/api/inference/model.html#sagemaker.model.Model.deploy</span>
emb = emb_model.deploy(
    initial_instance_count=<span class="hljs-number">1</span>,
    instance_type=instance_type,
)`,wrap:!1}}),z=new ie({props:{title:"4. Run and evaluate Inference performance",local:"4-run-and-evaluate-inference-performance",headingTag:"h2"}}),A=new w({props:{code:"ZGF0YSUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMmlucHV0cyUyMiUzQSUyMCUyMnRoZSUyMG1lc21lcml6aW5nJTIwcGVyZm9ybWFuY2VzJTIwb2YlMjB0aGUlMjBsZWFkcyUyMGtlZXAlMjB0aGUlMjBmaWxtJTIwZ3JvdW5kZWQlMjBhbmQlMjBrZWVwJTIwdGhlJTIwYXVkaWVuY2UlMjByaXZldGVkJTIwLiUyMiUyQyUwQSU3RCUwQSUwQXJlcyUyMCUzRCUyMGVtYi5wcmVkaWN0KGRhdGElM0RkYXRhKSUwQSUwQSUwQSUyMyUyMHByaW50JTIwc29tZSUyMHJlc3VsdHMlMEFwcmludChmJTIybGVuZ3RoJTIwb2YlMjBlbWJlZGRpbmdzJTNBJTIwJTdCbGVuKHJlcyU1QjAlNUQpJTdEJTIyKSUwQXByaW50KGYlMjJmaXJzdCUyMDEwJTIwZWxlbWVudHMlMjBvZiUyMGVtYmVkZGluZ3MlM0ElMjAlN0JyZXMlNUIwJTVEJTVCJTNBMTAlNUQlN0QlMjIp",highlighted:`data = {
    <span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;the mesmerizing performances of the leads keep the film grounded and keep the audience riveted .&quot;</span>,
}

res = emb.predict(data=data)


<span class="hljs-comment"># print some results</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;length of embeddings: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(res[<span class="hljs-number">0</span>])}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;first 10 elements of embeddings: <span class="hljs-subst">{res[<span class="hljs-number">0</span>][:<span class="hljs-number">10</span>]}</span>&quot;</span>)`,wrap:!1}}),P=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> threading
<span class="hljs-keyword">import</span> time

number_of_threads = <span class="hljs-number">10</span>
number_of_requests = <span class="hljs-built_in">int</span>(<span class="hljs-number">3900</span> // number_of_threads)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;number of threads: <span class="hljs-subst">{number_of_threads}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;number of requests per thread: <span class="hljs-subst">{number_of_requests}</span>&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">send_rquests</span>():
    <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(number_of_requests):
        <span class="hljs-comment"># input counted at https://huggingface.co/spaces/Xenova/the-tokenizer-playground for 100 tokens</span>
        emb.predict(
            data={
                <span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;Hugging Face is a company and a popular platform in the field of natural language processing (NLP) and machine learning. They are known for their contributions to the development of state-of-the-art models for various NLP tasks and for providing a platform that facilitates the sharing and usage of pre-trained models. One of the key offerings from Hugging Face is the Transformers library, which is an open-source library for working with a variety of pre-trained transformer models, including those for text generation, translation, summarization, question answering, and more. The library is widely used in the research and development of NLP applications and is supported by a large and active community. Hugging Face also provides a model hub where users can discover, share, and download pre-trained models. Additionally, they offer tools and frameworks to make it easier for developers to integrate and use these models in their own projects. The company has played a significant role in advancing the field of NLP and making cutting-edge models more accessible to the broader community. Hugging Face also provides a model hub where users can discover, share, and download pre-trained models. Additionally, they offer tools and frameworks to make it easier for developers and ma&quot;</span>
            }
        )


<span class="hljs-comment"># Create multiple threads</span>
threads = [threading.Thread(target=send_rquests) <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(number_of_threads)]
<span class="hljs-comment"># start all threads</span>
start = time.time()
[t.start() <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> threads]
<span class="hljs-comment"># wait for all threads to finish</span>
[t.join() <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> threads]
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;total time: <span class="hljs-subst">{<span class="hljs-built_in">round</span>(time.time() - start)}</span> seconds&quot;</span>)`,wrap:!1}}),ee=new w({props:{code:"cHJpbnQoJTBBJTIwJTIwJTIwJTIwZiUyMmh0dHBzJTNBJTJGJTJGY29uc29sZS5hd3MuYW1hem9uLmNvbSUyRmNsb3Vkd2F0Y2glMkZob21lJTNGcmVnaW9uJTNEJTdCc2Vzcy5ib3RvX3JlZ2lvbl9uYW1lJTdEJTIzbWV0cmljc1YyJTNBZ3JhcGglM0R+KG1ldHJpY3N+KH4ofidBV1MqMmZTYWdlTWFrZXJ+J01vZGVsTGF0ZW5jeX4nRW5kcG9pbnROYW1lficlN0JlbWIuZW5kcG9pbnRfbmFtZSU3RH4nVmFyaWFudE5hbWV+J0FsbFRyYWZmaWMpKX52aWV3fid0aW1lU2VyaWVzfnN0YWNrZWR+ZmFsc2V+cmVnaW9uficlN0JzZXNzLmJvdG9fcmVnaW9uX25hbWUlN0R+c3RhcnR+Jy1QVDVNfmVuZH4nUDBEfnN0YXR+J0F2ZXJhZ2V+cGVyaW9kfjMwKSUzQnF1ZXJ5JTNEficqN2JBV1MqMmZTYWdlTWFrZXIqMmNFbmRwb2ludE5hbWUqMmNWYXJpYW50TmFtZSo3ZCoyMCU3QmVtYi5lbmRwb2ludF9uYW1lJTdEJTIyJTBBKQ==",highlighted:`<span class="hljs-built_in">print</span>(
    <span class="hljs-string">f&quot;https://console.aws.amazon.com/cloudwatch/home?region=<span class="hljs-subst">{sess.boto_region_name}</span>#metricsV2:graph=~(metrics~(~(~&#x27;AWS*2fSageMaker~&#x27;ModelLatency~&#x27;EndpointName~&#x27;<span class="hljs-subst">{emb.endpoint_name}</span>~&#x27;VariantName~&#x27;AllTraffic))~view~&#x27;timeSeries~stacked~false~region~&#x27;<span class="hljs-subst">{sess.boto_region_name}</span>~start~&#x27;-PT5M~end~&#x27;P0D~stat~&#x27;Average~period~30);query=~&#x27;*7bAWS*2fSageMaker*2cEndpointName*2cVariantName*7d*20<span class="hljs-subst">{emb.endpoint_name}</span>&quot;</span>
)`,wrap:!1}}),te=new ie({props:{title:"5. Delete model and endpoint",local:"5-delete-model-and-endpoint",headingTag:"h2"}}),ae=new w({props:{code:"ZW1iLmRlbGV0ZV9tb2RlbCgpJTBBZW1iLmRlbGV0ZV9lbmRwb2ludCgp",highlighted:`emb.delete_model()
emb.delete_endpoint()`,wrap:!1}}),g=new Hl({props:{$$slots:{default:[Sl]},$$scope:{ctx:me}}}),se=new Vl({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/sagemaker/source/examples/sagemaker-sdk-deploy-embedding-models.mdx"}}),{c(){u=i("meta"),f=a(),y=i("p"),oe=a(),m(b.$$.fragment),de=a(),J=i("p"),J.innerHTML=el,pe=a(),T=i("p"),T.textContent=ll,ce=a(),j=i("ol"),j.innerHTML=tl,Me=a(),m(U.$$.fragment),he=a(),Z=i("p"),Z.innerHTML=nl,ue=a(),I=i("ul"),I.innerHTML=al,ye=a(),W=i("p"),W.textContent=sl,we=a(),k=i("ul"),k.innerHTML=il,ge=a(),G=i("p"),G.textContent=ol,fe=a(),m(B.$$.fragment),be=a(),v=i("p"),v.innerHTML=rl,Je=a(),m(C.$$.fragment),Te=a(),H=i("p"),H.innerHTML=ml,je=a(),m(V.$$.fragment),Ue=a(),m(S.$$.fragment),Ze=a(),$=i("p"),$.innerHTML=dl,Ie=a(),m(N.$$.fragment),We=a(),m(Y.$$.fragment),ke=a(),F=i("p"),F.innerHTML=pl,Ge=a(),m(R.$$.fragment),Be=a(),E=i("p"),E.innerHTML=cl,ve=a(),m(_.$$.fragment),Ce=a(),X=i("p"),X.textContent=Ml,He=a(),m(z.$$.fragment),Ve=a(),x=i("p"),x.innerHTML=hl,Se=a(),m(A.$$.fragment),$e=a(),Q=i("p"),Q.textContent=ul,Ne=a(),L=i("p"),L.textContent=yl,Ye=a(),q=i("p"),q.textContent=wl,Fe=a(),m(P.$$.fragment),Re=a(),K=i("p"),K.textContent=gl,Ee=a(),D=i("p"),D.innerHTML=fl,_e=a(),O=i("p"),O.textContent=bl,Xe=a(),m(ee.$$.fragment),ze=a(),le=i("p"),le.innerHTML=Jl,xe=a(),m(te.$$.fragment),Ae=a(),ne=i("p"),ne.textContent=Tl,Qe=a(),m(ae.$$.fragment),Le=a(),qe=i("hr"),Pe=a(),m(g.$$.fragment),Ke=a(),m(se.$$.fragment),De=a(),re=i("p"),this.h()},l(e){const l=vl("svelte-u9bgzb",document.head);u=o(l,"META",{name:!0,content:!0}),l.forEach(t),f=s(e),y=o(e,"P",{}),Ul(y).forEach(t),oe=s(e),d(b.$$.fragment,e),de=s(e),J=o(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-107ao9g"&&(J.innerHTML=el),pe=s(e),T=o(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-1fk91jb"&&(T.textContent=ll),ce=s(e),j=o(e,"OL",{"data-svelte-h":!0}),r(j)!=="svelte-t9j2qn"&&(j.innerHTML=tl),Me=s(e),d(U.$$.fragment,e),he=s(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1g12ipz"&&(Z.innerHTML=nl),ue=s(e),I=o(e,"UL",{"data-svelte-h":!0}),r(I)!=="svelte-13nwd7v"&&(I.innerHTML=al),ye=s(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-dbg7bd"&&(W.textContent=sl),we=s(e),k=o(e,"UL",{"data-svelte-h":!0}),r(k)!=="svelte-1qk5wei"&&(k.innerHTML=il),ge=s(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-6zk712"&&(G.textContent=ol),fe=s(e),d(B.$$.fragment,e),be=s(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-ivso52"&&(v.innerHTML=rl),Je=s(e),d(C.$$.fragment,e),Te=s(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-s0u97w"&&(H.innerHTML=ml),je=s(e),d(V.$$.fragment,e),Ue=s(e),d(S.$$.fragment,e),Ze=s(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-aifr08"&&($.innerHTML=dl),Ie=s(e),d(N.$$.fragment,e),We=s(e),d(Y.$$.fragment,e),ke=s(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1nrpwhp"&&(F.innerHTML=pl),Ge=s(e),d(R.$$.fragment,e),Be=s(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-rq9vzg"&&(E.innerHTML=cl),ve=s(e),d(_.$$.fragment,e),Ce=s(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-fhd04v"&&(X.textContent=Ml),He=s(e),d(z.$$.fragment,e),Ve=s(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-u88v21"&&(x.innerHTML=hl),Se=s(e),d(A.$$.fragment,e),$e=s(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-mxy82q"&&(Q.textContent=ul),Ne=s(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-mcpcg9"&&(L.textContent=yl),Ye=s(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-4wtzg0"&&(q.textContent=wl),Fe=s(e),d(P.$$.fragment,e),Re=s(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1fbhrxg"&&(K.textContent=gl),Ee=s(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1gr1muv"&&(D.innerHTML=fl),_e=s(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1bwshbf"&&(O.textContent=bl),Xe=s(e),d(ee.$$.fragment,e),ze=s(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-kooosy"&&(le.innerHTML=Jl),xe=s(e),d(te.$$.fragment,e),Ae=s(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1y233zi"&&(ne.textContent=Tl),Qe=s(e),d(ae.$$.fragment,e),Le=s(e),qe=o(e,"HR",{}),Pe=s(e),d(g.$$.fragment,e),Ke=s(e),d(se.$$.fragment,e),De=s(e),re=o(e,"P",{}),Ul(re).forEach(t),this.h()},h(){Zl(u,"name","hf:doc:metadata"),Zl(u,"content",Nl)},m(e,l){Cl(document.head,u),n(e,f,l),n(e,y,l),n(e,oe,l),p(b,e,l),n(e,de,l),n(e,J,l),n(e,pe,l),n(e,T,l),n(e,ce,l),n(e,j,l),n(e,Me,l),p(U,e,l),n(e,he,l),n(e,Z,l),n(e,ue,l),n(e,I,l),n(e,ye,l),n(e,W,l),n(e,we,l),n(e,k,l),n(e,ge,l),n(e,G,l),n(e,fe,l),p(B,e,l),n(e,be,l),n(e,v,l),n(e,Je,l),p(C,e,l),n(e,Te,l),n(e,H,l),n(e,je,l),p(V,e,l),n(e,Ue,l),p(S,e,l),n(e,Ze,l),n(e,$,l),n(e,Ie,l),p(N,e,l),n(e,We,l),p(Y,e,l),n(e,ke,l),n(e,F,l),n(e,Ge,l),p(R,e,l),n(e,Be,l),n(e,E,l),n(e,ve,l),p(_,e,l),n(e,Ce,l),n(e,X,l),n(e,He,l),p(z,e,l),n(e,Ve,l),n(e,x,l),n(e,Se,l),p(A,e,l),n(e,$e,l),n(e,Q,l),n(e,Ne,l),n(e,L,l),n(e,Ye,l),n(e,q,l),n(e,Fe,l),p(P,e,l),n(e,Re,l),n(e,K,l),n(e,Ee,l),n(e,D,l),n(e,_e,l),n(e,O,l),n(e,Xe,l),p(ee,e,l),n(e,ze,l),n(e,le,l),n(e,xe,l),p(te,e,l),n(e,Ae,l),n(e,ne,l),n(e,Qe,l),p(ae,e,l),n(e,Le,l),n(e,qe,l),n(e,Pe,l),p(g,e,l),n(e,Ke,l),p(se,e,l),n(e,De,l),n(e,re,l),Oe=!0},p(e,[l]){const jl={};l&2&&(jl.$$scope={dirty:l,ctx:e}),g.$set(jl)},i(e){Oe||(c(b.$$.fragment,e),c(U.$$.fragment,e),c(B.$$.fragment,e),c(C.$$.fragment,e),c(V.$$.fragment,e),c(S.$$.fragment,e),c(N.$$.fragment,e),c(Y.$$.fragment,e),c(R.$$.fragment,e),c(_.$$.fragment,e),c(z.$$.fragment,e),c(A.$$.fragment,e),c(P.$$.fragment,e),c(ee.$$.fragment,e),c(te.$$.fragment,e),c(ae.$$.fragment,e),c(g.$$.fragment,e),c(se.$$.fragment,e),Oe=!0)},o(e){M(b.$$.fragment,e),M(U.$$.fragment,e),M(B.$$.fragment,e),M(C.$$.fragment,e),M(V.$$.fragment,e),M(S.$$.fragment,e),M(N.$$.fragment,e),M(Y.$$.fragment,e),M(R.$$.fragment,e),M(_.$$.fragment,e),M(z.$$.fragment,e),M(A.$$.fragment,e),M(P.$$.fragment,e),M(ee.$$.fragment,e),M(te.$$.fragment,e),M(ae.$$.fragment,e),M(g.$$.fragment,e),M(se.$$.fragment,e),Oe=!1},d(e){e&&(t(f),t(y),t(oe),t(de),t(J),t(pe),t(T),t(ce),t(j),t(Me),t(he),t(Z),t(ue),t(I),t(ye),t(W),t(we),t(k),t(ge),t(G),t(fe),t(be),t(v),t(Je),t(Te),t(H),t(je),t(Ue),t(Ze),t($),t(Ie),t(We),t(ke),t(F),t(Ge),t(Be),t(E),t(ve),t(Ce),t(X),t(He),t(Ve),t(x),t(Se),t($e),t(Q),t(Ne),t(L),t(Ye),t(q),t(Fe),t(Re),t(K),t(Ee),t(D),t(_e),t(O),t(Xe),t(ze),t(le),t(xe),t(Ae),t(ne),t(Qe),t(Le),t(qe),t(Pe),t(Ke),t(De),t(re)),t(u),h(b,e),h(U,e),h(B,e),h(C,e),h(V,e),h(S,e),h(N,e),h(Y,e),h(R,e),h(_,e),h(z,e),h(A,e),h(P,e),h(ee,e),h(te,e),h(ae,e),h(g,e),h(se,e)}}}const Nl='{"title":"How to deploy Embedding Models to Amazon SageMaker using new Hugging Face Embedding DLC","local":"how-to-deploy-embedding-models-to-amazon-sagemaker-using-new-hugging-face-embedding-dlc","sections":[{"title":"What is Hugging Face Embedding DLC?","local":"what-is-hugging-face-embedding-dlc","sections":[],"depth":2},{"title":"1. Setup development environment","local":"1-setup-development-environment","sections":[],"depth":2},{"title":"2. Retrieve the new Hugging Face Embedding Container","local":"2-retrieve-the-new-hugging-face-embedding-container","sections":[],"depth":2},{"title":"3. Deploy Snowflake Arctic to Amazon SageMaker","local":"3-deploy-snowflake-arctic-to-amazon-sagemaker","sections":[],"depth":2},{"title":"4. Run and evaluate Inference performance","local":"4-run-and-evaluate-inference-performance","sections":[],"depth":2},{"title":"5. Delete model and endpoint","local":"5-delete-model-and-endpoint","sections":[],"depth":2}],"depth":1}';function Yl(me){return Wl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class zl extends Gl{constructor(u){super(),Bl(this,u,Yl,$l,Il,{})}}export{zl as component};
