import{s as ys,n as is,o as os}from"../chunks/scheduler.56730f09.js";import{S as js,i as ws,g as J,s as M,r as T,A as cs,h as a,f as e,c as n,j as Ts,u as p,x as U,k as ps,y as ms,a as t,v as y,d as i,t as o,w as j}from"../chunks/index.61415d3e.js";import{C as sl}from"../chunks/CodeBlock.501e762d.js";import{H as c,E as Cs}from"../chunks/getInferenceSnippets.179f160e.js";function ds(vl){let w,el,P,tl,m,Ml,C,$l='توفر مكتبة <a href="https://github.com/huggingface/transformers" rel="nofollow">🤗 Transformers</a> مجموعة من النماذج المسبقة التدريب والأدوات لمعالجة اللغات الطبيعية، والرؤية، وما إلى ذلك. على الرغم من أن هذه النماذج تغطي مجموعة واسعة من التطبيقات، فقد تواجه حالات استخدام لا تدعمها المكتبة بشكل افتراضي. يُمكن للتخصيص أن يفتح إمكانيات جديدة، مثل إضافة طبقات جديدة، أو تعديل البنية المعمارية، أو تحسين آليات الانتباه. سيُوضح لك هذا الدليل كيفية تعديل نماذج Transformers الموجودة لتلبية احتياجاتك المحددة. الشيء الرائع هو أنك لست بحاجة إلى الخروج من إطار عمل Transformers لإجراء هذه التغييرات. ي يمكنك تعديل النماذج مباشرةً في Transformers والاستفادة من الميزات مثل <a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer" rel="nofollow">واجهة برمجة التطبيقات Trainer</a>، و <a href="https://huggingface.co/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel" rel="nofollow">PreTrainedModel</a>، والضبط الدقيق الفعال باستخدام أدوات مثل <a href="https://huggingface.co/docs/peft/index" rel="nofollow">PEFT</a>.',nl,d,Xl="سنرشدك في هذا الدليل  لكيفية تخصيص نماذج Transformers الموجودة لتلبية متطلباتك، دون فقدان مزايا الإطار. ستتعلم كيفية:",Jl,r,Hl="<li>تعديل بنية نموذج ما من خلال تغيير آلية الانتباه الخاصة به.</li> <li>تطبيق تقنيات مثل Low-Rank Adaptation (LoRA) على مكونات نموذج محددة.</li>",al,h,zl="نحن نشجعك على المساهمة باختراقاتك الخاصة ومشاركتها هنا مع المجتمع1",Ul,I,Tl,Q,xl="نموذج <strong>Segment Anything (SAM)</strong> هو نموذج رائد في مجال تجزئة الصور. في تنفيذه الافتراضي، يستخدم SAM إسقاطًا مجمعًا للاستعلام والمفتاح والقيمة (<code>qkv</code>) في آلية الانتباه الخاصة به. ومع ذلك، قد ترغب في ضبط مكونات محددة فقط من آلية الانتباه، مثل إسقاطات الاستعلام (<code>q</code>) والقيمة (<code>v</code>)، لتقليل عدد المعلمات القابلة للتدريب والموارد الحسابية المطلوبة.",pl,g,yl,u,Wl="من خلال تقسيم الإسقاط المجمع <code>qkv</code> إلى إسقاطات منفصلة <code>q</code> و <code>k</code> و <code>v</code>، يمكنك تطبيق تقنيات مثل <strong>LoRA</strong> (Low-Rank Adaptation) على إسقاطي <code>q</code> و <code>v</code> فقط. يسمح لك هذا بما يلي:",il,V,Yl="<li>ضبط عدد أقل من المعلمات، مما يقلل من العبء الحسابي.</li> <li>تحقيق أداء أفضل من خلال التركيز على مكونات محددة.</li> <li>تجربة استراتيجيات تعديل مختلفة في آلية الانتباه.</li>",ol,f,jl,k,wl,E,Ll="بعد ذلك، قم بإنشاء فئة فرعية من فئة <code>SamVisionAttention</code> الأصلية وعدلها لتضم إسقاطات <code>q</code> و <code>k</code> و <code>v</code> منفصلة.",cl,A,ml,b,Fl="<strong>الشرح:</strong>",Cl,R,ql="<li><strong>الإسقاطات المنفصلة:</strong> يتم إزالة الإسقاط المُجمع <code>qkv</code>، وإنشاء إسقاطات خطية منفصلة <code>q</code> و <code>k</code> و <code>v</code>.</li> <li><strong>دالة استدعاء  تحميل الأوزان:</strong> تقوم طريقة <code>_split_qkv_load_hook</code> بتقسيم أوزان <code>qkv</code> المسبقة التدريب إلى أوزان <code>q</code> و <code>k</code> و <code>v</code> منفصلة عند تحميل النموذج. يضمن هذا التوافق مع أي نموذج مسبق التدريب.</li> <li><strong>التنفيذ الأمامي:</strong> يتم حساب الاستعلامات والمفاتيح والقيم بشكل منفصل، وتستمر آلية الانتباه كالمعتاد.</li>",dl,B,rl,D,Kl="استبدل فئة <code>SamVisionAttention</code> الأصلية بفئتك المخصصة بحيث يستخدم النموذج آلية الانتباه المعدلة.",hl,_,Il,S,Pl="<strong>الشرح:</strong>",Ql,Z,ls="<li><strong>استبدال الفئة:</strong> من خلال تعيين فئتك المخصصة إلى <code>modeling_sam.SamVisionAttention</code>، فإن أي حالات من فئة <code>SamVisionAttention</code> في النموذج ستستخدم النسخة المعدلة. وبالتالي، عند استدعاء <code>SamModel</code>، سيتم استخدام <code>SamVisionAttentionSplit</code> المحددة حديثًا.</li> <li><strong>تحميل النموذج:</strong> يتم تحميل النموذج باستخدام <code>from_pretrained</code>، ويتم دمج آلية الانتباه المخصصة.</li>",gl,O,ul,G,ss="مع وجود إسقاطات <code>q</code> و <code>k</code> و <code>v</code> منفصلة، يمكنك الآن تطبيق LoRA على مكونات محددة، مثل إسقاطات <code>q</code> و <code>v</code>.",Vl,N,fl,v,es="<strong>الشرح:</strong>",kl,$,ts="<li><strong>تكوين LoRA:</strong> تحدد <code>LoraConfig</code> المرتبة <code>r</code>، وعامل القياس <code>lora_alpha</code>، والوحدات المستهدفة (<code>&quot;q&quot;</code> و <code>&quot;v&quot;</code>)، ومعدل التخلي، ونوع المهمة.</li> <li><strong>تطبيق LoRA:</strong> تقوم دالة <code>get_peft_model</code> بتطبيق LoRA على الوحدات المحددة في النموذج.</li> <li><strong>تقليل المعلمات:</strong> من خلال التركيز على <code>q</code> و <code>v</code>، فإنك تقلل عدد المعلمات القابلة للتدريب، مما يؤدي إلى تسريع التدريب وتقليل استخدام الذاكرة.</li>",El,X,Al,H,Ms="من السهل التحقق من عدد المعلمات القابلة للتدريب ومعرفة تأثير تعديلك.",bl,z,Rl,x,ns="<strong>الناتج المتوقع:</strong>",Bl,W,Dl,Y,_l,L,Js="يمكن لتعديل النماذج المسبقة التدريب أن يفتح آفاقًا جديدة للبحث والتطبيق. من خلال فهم وتعديل الآليات الداخلية للنماذج مثل SAM، يمكنك تخصيصها لتلبية احتياجاتك المحددة، وتحسين الأداء، وتجربة أفكار جديدة.",Sl,F,as="إذا قمت بتطوير تعديﻻتك الخاصة لنماذج Transformers وترغب في مشاركتها، ففكر في المساهمة في هذه الوثيقة.",Zl,q,Us="<li><strong>إنشاء طلب سحب (Pull Request):</strong> شارك تغييراتك وتحسيناتك في التعليمات البرمجية مباشرة في المستودع.</li> <li><strong>كتابة التوثيق:</strong> قدم تفسيرات وأمثلة واضحة لتعديلاتك.</li> <li><strong>التفاعل مع المجتمع:</strong> ناقش أفكارك واحصل على تعليقات من المطورين والباحثين الآخرين من خلال فتح مشكلة.</li>",Ol,K,Gl,ll,Nl;return m=new c({props:{title:"كيفية تعديل أي نموذج من نماذج Transformers",local:"كيفية-تعديل-أي-نموذج-من-نماذج-transformers",headingTag:"h1"}}),I=new c({props:{title:"مثال: تعديل آلية الانتباه في نموذج Segment Anything (SAM)",local:"مثال-تعديل-آلية-الانتباه-في-نموذج-segment-anything-sam",headingTag:"h2"}}),g=new c({props:{title:"الدافع",local:"الدافع",headingTag:"h3"}}),f=new c({props:{title:"التنفيذ",local:"التنفيذ",headingTag:"h3"}}),k=new c({props:{title:"الخطوة 1: إنشاء فئة اهتمام مخصصة",local:"الخطوة-1-إنشاء-فئة-اهتمام-مخصصة",headingTag:"h4"}}),A=new sl({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn
<span class="hljs-keyword">from</span> transformers.models.sam.modeling_sam <span class="hljs-keyword">import</span> SamVisionAttention

<span class="hljs-keyword">class</span> <span class="hljs-title class_">SamVisionAttentionSplit</span>(SamVisionAttention, nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config, window_size</span>):
        <span class="hljs-built_in">super</span>().__init__(config, window_size)
        <span class="hljs-keyword">del</span> self.qkv
        <span class="hljs-comment"># إسقاطات منفصلة q و k و v</span>
        self.q = nn.Linear(config.hidden_size, config.hidden_size, bias=config.qkv_bias)
        self.k = nn.Linear(config.hidden_size, config.hidden_size, bias=config.qkv_bias)
        self.v = nn.Linear(config.hidden_size, config.hidden_size, bias=config.qkv_bias)
        self._register_load_state_dict_pre_hook(self.split_q_k_v_load_hook)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">split_q_k_v_load_hook</span>(<span class="hljs-params">self, state_dict, prefix, *args</span>):
        keys_to_delete = []
        <span class="hljs-keyword">for</span> key <span class="hljs-keyword">in</span> <span class="hljs-built_in">list</span>(state_dict.keys()):
            <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;qkv.&quot;</span> <span class="hljs-keyword">in</span> key:
                <span class="hljs-comment"># تقسيم q و k و v من الإسقاط المجمع</span>
                q, k, v = state_dict[key].chunk(<span class="hljs-number">3</span>, dim=<span class="hljs-number">0</span>)
                <span class="hljs-comment"># استبدال الإسقاطات الفردية q و k و v</span>
                state_dict[key.replace(<span class="hljs-string">&quot;qkv.&quot;</span>, <span class="hljs-string">&quot;q.&quot;</span>)] = q
                state_dict[key.replace(<span class="hljs-string">&quot;qkv.&quot;</span>, <span class="hljs-string">&quot;k.&quot;</span>)] = k
                state_dict[key.replace(<span class="hljs-string">&quot;qkv.&quot;</span>, <span class="hljs-string">&quot;v.&quot;</span>)] = v
                <span class="hljs-comment"># وضع علامة على مفتاح qkv القديم للحذف</span>
                keys_to_delete.append(key)
        
        <span class="hljs-comment"># حذف مفاتيح qkv القديمة</span>
        <span class="hljs-keyword">for</span> key <span class="hljs-keyword">in</span> keys_to_delete:
            <span class="hljs-keyword">del</span> state_dict[key]

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, hidden_states: torch.Tensor, output_attentions=<span class="hljs-literal">False</span></span>) -&gt; torch.Tensor:
        batch_size, height, width, _ = hidden_states.shape
        qkv_shapes = (batch_size *  self.num_attention_heads,  height * width, -<span class="hljs-number">1</span>)
        query = self.q(hidden_states).reshape((batch_size,  height * width,self.num_attention_heads, -<span class="hljs-number">1</span>)).permute(<span class="hljs-number">0</span>,<span class="hljs-number">2</span>,<span class="hljs-number">1</span>,<span class="hljs-number">3</span>).reshape(qkv_shapes)
        key = self.k(hidden_states).reshape((batch_size,  height * width,self.num_attention_heads, -<span class="hljs-number">1</span>)).permute(<span class="hljs-number">0</span>,<span class="hljs-number">2</span>,<span class="hljs-number">1</span>,<span class="hljs-number">3</span>).reshape(qkv_shapes)
        value = self.v(hidden_states).reshape((batch_size,  height * width,self.num_attention_heads, -<span class="hljs-number">1</span>)).permute(<span class="hljs-number">0</span>,<span class="hljs-number">2</span>,<span class="hljs-number">1</span>,<span class="hljs-number">3</span>).reshape(qkv_shapes)

        attn_weights = (query * self.scale) @ key.transpose(-<span class="hljs-number">2</span>, -<span class="hljs-number">1</span>)

        <span class="hljs-keyword">if</span> self.use_rel_pos:
            attn_weights = self.add_decomposed_rel_pos(
                attn_weights, query, self.rel_pos_h, self.rel_pos_w, (height, width), (height, width)
            )

        attn_weights = torch.nn.functional.softmax(attn_weights, dtype=torch.float32, dim=-<span class="hljs-number">1</span>).to(query.dtype)
        attn_probs = nn.functional.dropout(attn_weights, p=self.dropout, training=self.training)
        attn_output = (attn_probs @ value).reshape(batch_size, self.num_attention_heads, height, width, -<span class="hljs-number">1</span>)
        attn_output = attn_output.permute(<span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">1</span>, <span class="hljs-number">4</span>).reshape(batch_size, height, width, -<span class="hljs-number">1</span>)
        attn_output = self.proj(attn_output)

        <span class="hljs-keyword">if</span> output_attentions:
            outputs = (attn_output, attn_weights)
        <span class="hljs-keyword">else</span>:
            outputs = (attn_output, <span class="hljs-literal">None</span>)
        <span class="hljs-keyword">return</span> outputs`,wrap:!1}}),B=new c({props:{title:"الخطوة 2: استبدال فئة الانتباه الأصلية",local:"الخطوة-2-استبدال-فئة-الانتباه-الأصلية",headingTag:"h4"}}),_=new sl({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNhbU1vZGVsJTBBZnJvbSUyMHRyYW5zZm9ybWVycy5tb2RlbHMuc2FtJTIwaW1wb3J0JTIwbW9kZWxpbmdfc2FtJTBBJTBBJTIzJTIwJUQ4JUE3JUQ4JUIzJUQ4JUFBJUQ4JUE4JUQ4JUFGJUQ4JUE3JUQ5JTg0JTIwJUQ5JTgxJUQ4JUE2JUQ4JUE5JTIwJUQ4JUE3JUQ5JTg0JUQ4JUE3JUQ5JTg3JUQ4JUFBJUQ5JTg1JUQ4JUE3JUQ5JTg1JTIwJUQ5JTgxJUQ5JThBJTIwJUQ5JTg4JUQ4JUFEJUQ4JUFGJUQ4JUE5JTIwJUQ5JTg2JUQ5JTg1JUQ4JUI3JUQ5JThBJUQ4JUE5JTIwbW9kZWxpbmdfc2FtJTBBbW9kZWxpbmdfc2FtLlNhbVZpc2lvbkF0dGVudGlvbiUyMCUzRCUyMFNhbVZpc2lvbkF0dGVudGlvblNwbGl0JTBBJTBBJTIzJTIwJUQ4JUFBJUQ4JUFEJUQ5JTg1JUQ5JThBJUQ5JTg0JTIwJUQ5JTg2JUQ5JTg1JUQ5JTg4JUQ4JUIwJUQ4JUFDJTIwU0FNJTIwJUQ4JUE3JUQ5JTg0JUQ5JTg1JUQ4JUIzJUQ4JUE4JUQ5JTgyJTIwJUQ4JUE3JUQ5JTg0JUQ4JUFBJUQ4JUFGJUQ4JUIxJUQ5JThBJUQ4JUE4JTBBbW9kZWwlMjAlM0QlMjBTYW1Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZzYW0tdml0LWJhc2UlMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SamModel
<span class="hljs-keyword">from</span> transformers.models.sam <span class="hljs-keyword">import</span> modeling_sam

<span class="hljs-comment"># استبدال فئة الاهتمام في وحدة نمطية modeling_sam</span>
modeling_sam.SamVisionAttention = SamVisionAttentionSplit

<span class="hljs-comment"># تحميل نموذج SAM المسبق التدريب</span>
model = SamModel.from_pretrained(<span class="hljs-string">&quot;facebook/sam-vit-base&quot;</span>)`,wrap:!1}}),O=new c({props:{title:"الخطوة 3: تطبيق LoRA على إسقاطات محددة",local:"الخطوة-3-تطبيق-lora-على-إسقاطات-محددة",headingTag:"h4"}}),N=new sl({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEFjb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHIlM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfYWxwaGElM0QzMiUyQyUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIycSUyMiUyQyUyMCUyMnYlMjIlNUQlMkMlMjAlMjAlMjMlMjAlRDglQUElRDglQjclRDglQTglRDklOEElRDklODIlMjBMb1JBJTIwJUQ4JUI5JUQ5JTg0JUQ5JTg5JTIwJUQ4JUE1JUQ4JUIzJUQ5JTgyJUQ4JUE3JUQ4JUI3JUQ4JUE3JUQ4JUFBJTIwcSUyMCVEOSU4OCUyMHYlMEElMjAlMjAlMjAlMjBsb3JhX2Ryb3BvdXQlM0QwLjElMkMlMEElMjAlMjAlMjAlMjB0YXNrX3R5cGUlM0QlMjJtYXNrLWdlbmVyYXRpb24lMjIlMEEpJTBBJTBBJTIzJTIwJUQ4JUFBJUQ4JUI3JUQ4JUE4JUQ5JThBJUQ5JTgyJTIwTG9SQSUyMCVEOCVCOSVEOSU4NCVEOSU4OSUyMCVEOCVBNyVEOSU4NCVEOSU4NiVEOSU4NSVEOSU4OCVEOCVCMCVEOCVBQyUwQW1vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobW9kZWwlMkMlMjBjb25maWcp",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model

config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    target_modules=[<span class="hljs-string">&quot;q&quot;</span>, <span class="hljs-string">&quot;v&quot;</span>],  <span class="hljs-comment"># تطبيق LoRA على إسقاطات q و v</span>
    lora_dropout=<span class="hljs-number">0.1</span>,
    task_type=<span class="hljs-string">&quot;mask-generation&quot;</span>
)

<span class="hljs-comment"># تطبيق LoRA على النموذج</span>
model = get_peft_model(model, config)`,wrap:!1}}),X=new c({props:{title:"الخطوة 4: التحقق من عدد المعلمات القابلة للتدريب",local:"الخطوة-4-التحقق-من-عدد-المعلمات-القابلة-للتدريب",headingTag:"h4"}}),z=new sl({props:{code:"bW9kZWwucHJpbnRfdHJhaW5hYmxlX3BhcmFtZXRlcnMoKQ==",highlighted:"model.print_trainable_parameters()",wrap:!1}}),W=new sl({props:{code:"JUQ4JUI5JUQ4JUFGJUQ4JUFGJTIwJUQ4JUE3JUQ5JTg0JUQ5JTg1JUQ4JUI5JUQ5JTg0JUQ5JTg1JUQ4JUE3JUQ4JUFBJTIwJUQ4JUE3JUQ5JTg0JUQ5JTgyJUQ4JUE3JUQ4JUE4JUQ5JTg0JUQ4JUE5JTIwJUQ5JTg0JUQ5JTg0JUQ4JUFBJUQ4JUFGJUQ4JUIxJUQ5JThBJUQ4JUE4JTNBJTIwNjA4JTJDMjU2JTIwJTdDJTdDJTIwJUQ4JUFDJUQ5JTg1JUQ5JThBJUQ4JUI5JTIwJUQ4JUE3JUQ5JTg0JUQ5JTg1JUQ4JUI5JUQ5JTg0JUQ5JTg1JUQ4JUE3JUQ4JUFBJTNBJTIwOTQlMkMzNDMlMkM3MjglMjAlN0MlN0MlMjAlRDklODYlRDglQjMlRDglQTglRDglQTklMjAlRDglQTclRDklODQlRDklODUlRDglQjklRDklODQlRDklODUlRDglQTclRDglQUElMjAlRDglQTclRDklODQlRDklODIlRDglQTclRDglQTglRDklODQlRDglQTklMjAlRDklODQlRDklODQlRDglQUElRDglQUYlRDglQjElRDklOEElRDglQTglM0ElMjAwLjY0NDclMEElRDglQjklRDglQUYlRDglQUYlMjAlRDglQTclRDklODQlRDklODUlRDglQjklRDklODQlRDklODUlRDglQTclRDglQUElMjAlRDglQTclRDklODQlRDklODIlRDglQTclRDglQTglRDklODQlRDglQTklMjAlRDklODQlRDklODQlRDglQUElRDglQUYlRDglQjElRDklOEElRDglQTglM0ElMjA5MTIlMkMzODQlMjAlN0MlN0MlMjAlRDglQUMlRDklODUlRDklOEElRDglQjklMjAlRDglQTclRDklODQlRDklODUlRDglQjklRDklODQlRDklODUlRDglQTclRDglQUElM0ElMjA5NCUyQzY0NyUyQzg1NiUyMCU3QyU3QyUyMCVEOSU4NiVEOCVCMyVEOCVBOCVEOCVBOSUyMCVEOCVBNyVEOSU4NCVEOSU4NSVEOCVCOSVEOSU4NCVEOSU4NSVEOCVBNyVEOCVBQSUyMCVEOCVBNyVEOSU4NCVEOSU4MiVEOCVBNyVEOCVBOCVEOSU4NCVEOCVBOSUyMCVEOSU4NCVEOSU4NCVEOCVBQSVEOCVBRiVEOCVCMSVEOSU4QSVEOCVBOCUzQSUyMDAuOTY0MCUyMCUyMyUyMCVEOSU4NSVEOCVCOSUyMGs=",highlighted:`عدد المعلمات القابلة للتدريب: <span class="hljs-number">608</span>,<span class="hljs-number">256</span> |<span class="hljs-type">| جميع المعلمات: 94</span>,<span class="hljs-number">343</span>,<span class="hljs-number">728</span> |<span class="hljs-type">| نسبة المعلمات القابلة للتدريب: 0</span><span class="hljs-number">.6447</span>
عدد المعلمات القابلة للتدريب: <span class="hljs-number">912</span>,<span class="hljs-number">384</span> |<span class="hljs-type">| جميع المعلمات: 94</span>,<span class="hljs-number">647</span>,<span class="hljs-number">856</span> |<span class="hljs-type">| نسبة المعلمات القابلة للتدريب: 0</span><span class="hljs-number">.9640</span> # مع k`,wrap:!1}}),Y=new c({props:{title:"المساهمة بابداعاتك الخاصة",local:"المساهمة-بابداعاتك-الخاصة",headingTag:"h2"}}),K=new Cs({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/ar/how_to_hack_models.md"}}),{c(){w=J("meta"),el=M(),P=J("p"),tl=M(),T(m.$$.fragment),Ml=M(),C=J("p"),C.innerHTML=$l,nl=M(),d=J("p"),d.textContent=Xl,Jl=M(),r=J("ul"),r.innerHTML=Hl,al=M(),h=J("p"),h.textContent=zl,Ul=M(),T(I.$$.fragment),Tl=M(),Q=J("p"),Q.innerHTML=xl,pl=M(),T(g.$$.fragment),yl=M(),u=J("p"),u.innerHTML=Wl,il=M(),V=J("ul"),V.innerHTML=Yl,ol=M(),T(f.$$.fragment),jl=M(),T(k.$$.fragment),wl=M(),E=J("p"),E.innerHTML=Ll,cl=M(),T(A.$$.fragment),ml=M(),b=J("p"),b.innerHTML=Fl,Cl=M(),R=J("ul"),R.innerHTML=ql,dl=M(),T(B.$$.fragment),rl=M(),D=J("p"),D.innerHTML=Kl,hl=M(),T(_.$$.fragment),Il=M(),S=J("p"),S.innerHTML=Pl,Ql=M(),Z=J("ul"),Z.innerHTML=ls,gl=M(),T(O.$$.fragment),ul=M(),G=J("p"),G.innerHTML=ss,Vl=M(),T(N.$$.fragment),fl=M(),v=J("p"),v.innerHTML=es,kl=M(),$=J("ul"),$.innerHTML=ts,El=M(),T(X.$$.fragment),Al=M(),H=J("p"),H.textContent=Ms,bl=M(),T(z.$$.fragment),Rl=M(),x=J("p"),x.innerHTML=ns,Bl=M(),T(W.$$.fragment),Dl=M(),T(Y.$$.fragment),_l=M(),L=J("p"),L.textContent=Js,Sl=M(),F=J("p"),F.textContent=as,Zl=M(),q=J("ul"),q.innerHTML=Us,Ol=M(),T(K.$$.fragment),Gl=M(),ll=J("p"),this.h()},l(l){const s=cs("svelte-u9bgzb",document.head);w=a(s,"META",{name:!0,content:!0}),s.forEach(e),el=n(l),P=a(l,"P",{}),Ts(P).forEach(e),tl=n(l),p(m.$$.fragment,l),Ml=n(l),C=a(l,"P",{"data-svelte-h":!0}),U(C)!=="svelte-1mgmjto"&&(C.innerHTML=$l),nl=n(l),d=a(l,"P",{"data-svelte-h":!0}),U(d)!=="svelte-1732u89"&&(d.textContent=Xl),Jl=n(l),r=a(l,"UL",{"data-svelte-h":!0}),U(r)!=="svelte-2hv98t"&&(r.innerHTML=Hl),al=n(l),h=a(l,"P",{"data-svelte-h":!0}),U(h)!=="svelte-1p8gsw8"&&(h.textContent=zl),Ul=n(l),p(I.$$.fragment,l),Tl=n(l),Q=a(l,"P",{"data-svelte-h":!0}),U(Q)!=="svelte-1bz3xzx"&&(Q.innerHTML=xl),pl=n(l),p(g.$$.fragment,l),yl=n(l),u=a(l,"P",{"data-svelte-h":!0}),U(u)!=="svelte-1pl2dvy"&&(u.innerHTML=Wl),il=n(l),V=a(l,"UL",{"data-svelte-h":!0}),U(V)!=="svelte-1p6h3vz"&&(V.innerHTML=Yl),ol=n(l),p(f.$$.fragment,l),jl=n(l),p(k.$$.fragment,l),wl=n(l),E=a(l,"P",{"data-svelte-h":!0}),U(E)!=="svelte-1nzt6k1"&&(E.innerHTML=Ll),cl=n(l),p(A.$$.fragment,l),ml=n(l),b=a(l,"P",{"data-svelte-h":!0}),U(b)!=="svelte-19wirwg"&&(b.innerHTML=Fl),Cl=n(l),R=a(l,"UL",{"data-svelte-h":!0}),U(R)!=="svelte-sp19qy"&&(R.innerHTML=ql),dl=n(l),p(B.$$.fragment,l),rl=n(l),D=a(l,"P",{"data-svelte-h":!0}),U(D)!=="svelte-15x9xcr"&&(D.innerHTML=Kl),hl=n(l),p(_.$$.fragment,l),Il=n(l),S=a(l,"P",{"data-svelte-h":!0}),U(S)!=="svelte-19wirwg"&&(S.innerHTML=Pl),Ql=n(l),Z=a(l,"UL",{"data-svelte-h":!0}),U(Z)!=="svelte-1ccnkwy"&&(Z.innerHTML=ls),gl=n(l),p(O.$$.fragment,l),ul=n(l),G=a(l,"P",{"data-svelte-h":!0}),U(G)!=="svelte-25uips"&&(G.innerHTML=ss),Vl=n(l),p(N.$$.fragment,l),fl=n(l),v=a(l,"P",{"data-svelte-h":!0}),U(v)!=="svelte-19wirwg"&&(v.innerHTML=es),kl=n(l),$=a(l,"UL",{"data-svelte-h":!0}),U($)!=="svelte-zi3ifu"&&($.innerHTML=ts),El=n(l),p(X.$$.fragment,l),Al=n(l),H=a(l,"P",{"data-svelte-h":!0}),U(H)!=="svelte-c77z7p"&&(H.textContent=Ms),bl=n(l),p(z.$$.fragment,l),Rl=n(l),x=a(l,"P",{"data-svelte-h":!0}),U(x)!=="svelte-awqv7y"&&(x.innerHTML=ns),Bl=n(l),p(W.$$.fragment,l),Dl=n(l),p(Y.$$.fragment,l),_l=n(l),L=a(l,"P",{"data-svelte-h":!0}),U(L)!=="svelte-15z7lpy"&&(L.textContent=Js),Sl=n(l),F=a(l,"P",{"data-svelte-h":!0}),U(F)!=="svelte-5uzo05"&&(F.textContent=as),Zl=n(l),q=a(l,"UL",{"data-svelte-h":!0}),U(q)!=="svelte-gqwp2k"&&(q.innerHTML=Us),Ol=n(l),p(K.$$.fragment,l),Gl=n(l),ll=a(l,"P",{}),Ts(ll).forEach(e),this.h()},h(){ps(w,"name","hf:doc:metadata"),ps(w,"content",rs)},m(l,s){ms(document.head,w),t(l,el,s),t(l,P,s),t(l,tl,s),y(m,l,s),t(l,Ml,s),t(l,C,s),t(l,nl,s),t(l,d,s),t(l,Jl,s),t(l,r,s),t(l,al,s),t(l,h,s),t(l,Ul,s),y(I,l,s),t(l,Tl,s),t(l,Q,s),t(l,pl,s),y(g,l,s),t(l,yl,s),t(l,u,s),t(l,il,s),t(l,V,s),t(l,ol,s),y(f,l,s),t(l,jl,s),y(k,l,s),t(l,wl,s),t(l,E,s),t(l,cl,s),y(A,l,s),t(l,ml,s),t(l,b,s),t(l,Cl,s),t(l,R,s),t(l,dl,s),y(B,l,s),t(l,rl,s),t(l,D,s),t(l,hl,s),y(_,l,s),t(l,Il,s),t(l,S,s),t(l,Ql,s),t(l,Z,s),t(l,gl,s),y(O,l,s),t(l,ul,s),t(l,G,s),t(l,Vl,s),y(N,l,s),t(l,fl,s),t(l,v,s),t(l,kl,s),t(l,$,s),t(l,El,s),y(X,l,s),t(l,Al,s),t(l,H,s),t(l,bl,s),y(z,l,s),t(l,Rl,s),t(l,x,s),t(l,Bl,s),y(W,l,s),t(l,Dl,s),y(Y,l,s),t(l,_l,s),t(l,L,s),t(l,Sl,s),t(l,F,s),t(l,Zl,s),t(l,q,s),t(l,Ol,s),y(K,l,s),t(l,Gl,s),t(l,ll,s),Nl=!0},p:is,i(l){Nl||(i(m.$$.fragment,l),i(I.$$.fragment,l),i(g.$$.fragment,l),i(f.$$.fragment,l),i(k.$$.fragment,l),i(A.$$.fragment,l),i(B.$$.fragment,l),i(_.$$.fragment,l),i(O.$$.fragment,l),i(N.$$.fragment,l),i(X.$$.fragment,l),i(z.$$.fragment,l),i(W.$$.fragment,l),i(Y.$$.fragment,l),i(K.$$.fragment,l),Nl=!0)},o(l){o(m.$$.fragment,l),o(I.$$.fragment,l),o(g.$$.fragment,l),o(f.$$.fragment,l),o(k.$$.fragment,l),o(A.$$.fragment,l),o(B.$$.fragment,l),o(_.$$.fragment,l),o(O.$$.fragment,l),o(N.$$.fragment,l),o(X.$$.fragment,l),o(z.$$.fragment,l),o(W.$$.fragment,l),o(Y.$$.fragment,l),o(K.$$.fragment,l),Nl=!1},d(l){l&&(e(el),e(P),e(tl),e(Ml),e(C),e(nl),e(d),e(Jl),e(r),e(al),e(h),e(Ul),e(Tl),e(Q),e(pl),e(yl),e(u),e(il),e(V),e(ol),e(jl),e(wl),e(E),e(cl),e(ml),e(b),e(Cl),e(R),e(dl),e(rl),e(D),e(hl),e(Il),e(S),e(Ql),e(Z),e(gl),e(ul),e(G),e(Vl),e(fl),e(v),e(kl),e($),e(El),e(Al),e(H),e(bl),e(Rl),e(x),e(Bl),e(Dl),e(_l),e(L),e(Sl),e(F),e(Zl),e(q),e(Ol),e(Gl),e(ll)),e(w),j(m,l),j(I,l),j(g,l),j(f,l),j(k,l),j(A,l),j(B,l),j(_,l),j(O,l),j(N,l),j(X,l),j(z,l),j(W,l),j(Y,l),j(K,l)}}}const rs='{"title":"كيفية تعديل أي نموذج من نماذج Transformers","local":"كيفية-تعديل-أي-نموذج-من-نماذج-transformers","sections":[{"title":"مثال: تعديل آلية الانتباه في نموذج Segment Anything (SAM)","local":"مثال-تعديل-آلية-الانتباه-في-نموذج-segment-anything-sam","sections":[{"title":"الدافع","local":"الدافع","sections":[],"depth":3},{"title":"التنفيذ","local":"التنفيذ","sections":[{"title":"الخطوة 1: إنشاء فئة اهتمام مخصصة","local":"الخطوة-1-إنشاء-فئة-اهتمام-مخصصة","sections":[],"depth":4},{"title":"الخطوة 2: استبدال فئة الانتباه الأصلية","local":"الخطوة-2-استبدال-فئة-الانتباه-الأصلية","sections":[],"depth":4},{"title":"الخطوة 3: تطبيق LoRA على إسقاطات محددة","local":"الخطوة-3-تطبيق-lora-على-إسقاطات-محددة","sections":[],"depth":4},{"title":"الخطوة 4: التحقق من عدد المعلمات القابلة للتدريب","local":"الخطوة-4-التحقق-من-عدد-المعلمات-القابلة-للتدريب","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"المساهمة بابداعاتك الخاصة","local":"المساهمة-بابداعاتك-الخاصة","sections":[],"depth":2}],"depth":1}';function hs(vl){return os(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Vs extends js{constructor(w){super(),ws(this,w,hs,ds,ys,{})}}export{Vs as component};
