import{s as Jn,z as Zn,o as kn,n as z}from"../chunks/scheduler.18a86fab.js";import{S as Un,i as zn,g as m,s as a,r as g,A as Wn,h as p,f as s,c as r,j as w,u as f,x as C,k as v,y as c,a as l,v as u,d as h,t as _,w as b}from"../chunks/index.98837b22.js";import{T as co}from"../chunks/Tip.77304350.js";import{D as S}from"../chunks/Docstring.6758ea23.js";import{C as A}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as D}from"../chunks/ExampleCodeBlock.0c42463f.js";import{P as Bn}from"../chunks/PipelineTag.7749150e.js";import{H as F}from"../chunks/Heading.7e7e0c5b.js";import{E as Vn}from"../chunks/getInferenceSnippets.de10bc7d.js";function Nn(I){let o,M="Example:",d,i,T;return i=new A({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENMSVBTZWdDb25maWclMkMlMjBDTElQU2VnTW9kZWwlMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwQ0xJUFNlZ0NvbmZpZyUyMHdpdGglMjBDSURBUyUyRmNsaXBzZWctcmQ2NCUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBDTElQU2VnQ29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwQ0xJUFNlZ01vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBDSURBUyUyRmNsaXBzZWctcmQ2NCUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwQ0xJUFNlZ01vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZyUwQSUwQSUyMyUyMFdlJTIwY2FuJTIwYWxzbyUyMGluaXRpYWxpemUlMjBhJTIwQ0xJUFNlZ0NvbmZpZyUyMGZyb20lMjBhJTIwQ0xJUFNlZ1RleHRDb25maWclMjBhbmQlMjBhJTIwQ0xJUFNlZ1Zpc2lvbkNvbmZpZyUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBDTElQU2VnVGV4dCUyMGFuZCUyMENMSVBTZWdWaXNpb24lMjBjb25maWd1cmF0aW9uJTBBY29uZmlnX3RleHQlMjAlM0QlMjBDTElQU2VnVGV4dENvbmZpZygpJTBBY29uZmlnX3Zpc2lvbiUyMCUzRCUyMENMSVBTZWdWaXNpb25Db25maWcoKSUwQSUwQWNvbmZpZyUyMCUzRCUyMENMSVBTZWdDb25maWcuZnJvbV90ZXh0X3Zpc2lvbl9jb25maWdzKGNvbmZpZ190ZXh0JTJDJTIwY29uZmlnX3Zpc2lvbik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPSegConfig, CLIPSegModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a CLIPSegConfig with CIDAS/clipseg-rd64 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = CLIPSegConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a CLIPSegModel (with random weights) from the CIDAS/clipseg-rd64 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = CLIPSegModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can also initialize a CLIPSegConfig from a CLIPSegTextConfig and a CLIPSegVisionConfig</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a CLIPSegText and CLIPSegVision configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config_text = CLIPSegTextConfig()
<span class="hljs-meta">&gt;&gt;&gt; </span>config_vision = CLIPSegVisionConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span>config = CLIPSegConfig.from_text_vision_configs(config_text, config_vision)`,wrap:!1}}),{c(){o=m("p"),o.textContent=M,d=a(),g(i.$$.fragment)},l(t){o=p(t,"P",{"data-svelte-h":!0}),C(o)!=="svelte-11lpom8"&&(o.textContent=M),d=r(t),f(i.$$.fragment,t)},m(t,y){l(t,o,y),l(t,d,y),u(i,t,y),T=!0},p:z,i(t){T||(h(i.$$.fragment,t),T=!0)},o(t){_(i.$$.fragment,t),T=!1},d(t){t&&(s(o),s(d)),b(i,t)}}}function Fn(I){let o,M="Example:",d,i,T;return i=new A({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENMSVBTZWdUZXh0Q29uZmlnJTJDJTIwQ0xJUFNlZ1RleHRNb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBDTElQU2VnVGV4dENvbmZpZyUyMHdpdGglMjBDSURBUyUyRmNsaXBzZWctcmQ2NCUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBDTElQU2VnVGV4dENvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMENMSVBTZWdUZXh0TW9kZWwlMjAod2l0aCUyMHJhbmRvbSUyMHdlaWdodHMpJTIwZnJvbSUyMHRoZSUyMENJREFTJTJGY2xpcHNlZy1yZDY0JTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBDTElQU2VnVGV4dE1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPSegTextConfig, CLIPSegTextModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a CLIPSegTextConfig with CIDAS/clipseg-rd64 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = CLIPSegTextConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a CLIPSegTextModel (with random weights) from the CIDAS/clipseg-rd64 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = CLIPSegTextModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){o=m("p"),o.textContent=M,d=a(),g(i.$$.fragment)},l(t){o=p(t,"P",{"data-svelte-h":!0}),C(o)!=="svelte-11lpom8"&&(o.textContent=M),d=r(t),f(i.$$.fragment,t)},m(t,y){l(t,o,y),l(t,d,y),u(i,t,y),T=!0},p:z,i(t){T||(h(i.$$.fragment,t),T=!0)},o(t){_(i.$$.fragment,t),T=!1},d(t){t&&(s(o),s(d)),b(i,t)}}}function En(I){let o,M="Example:",d,i,T;return i=new A({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENMSVBTZWdWaXNpb25Db25maWclMkMlMjBDTElQU2VnVmlzaW9uTW9kZWwlMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwQ0xJUFNlZ1Zpc2lvbkNvbmZpZyUyMHdpdGglMjBDSURBUyUyRmNsaXBzZWctcmQ2NCUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBDTElQU2VnVmlzaW9uQ29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwQ0xJUFNlZ1Zpc2lvbk1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBDSURBUyUyRmNsaXBzZWctcmQ2NCUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwQ0xJUFNlZ1Zpc2lvbk1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPSegVisionConfig, CLIPSegVisionModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a CLIPSegVisionConfig with CIDAS/clipseg-rd64 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = CLIPSegVisionConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a CLIPSegVisionModel (with random weights) from the CIDAS/clipseg-rd64 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = CLIPSegVisionModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){o=m("p"),o.textContent=M,d=a(),g(i.$$.fragment)},l(t){o=p(t,"P",{"data-svelte-h":!0}),C(o)!=="svelte-11lpom8"&&(o.textContent=M),d=r(t),f(i.$$.fragment,t)},m(t,y){l(t,o,y),l(t,d,y),u(i,t,y),T=!0},p:z,i(t){T||(h(i.$$.fragment,t),T=!0)},o(t){_(i.$$.fragment,t),T=!1},d(t){t&&(s(o),s(d)),b(i,t)}}}function qn(I){let o,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=m("p"),o.innerHTML=M},l(d){o=p(d,"P",{"data-svelte-h":!0}),C(o)!=="svelte-fincs2"&&(o.innerHTML=M)},m(d,i){l(d,o,i)},p:z,d(d){d&&s(o)}}}function Hn(I){let o,M="Examples:",d,i,T;return i=new A({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyMENMSVBTZWdNb2RlbCUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMkNJREFTJTJGY2xpcHNlZy1yZDY0LXJlZmluZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBDTElQU2VnTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMkNJREFTJTJGY2xpcHNlZy1yZDY0LXJlZmluZWQlMjIpJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvciglMEElMjAlMjAlMjAlMjB0ZXh0JTNEJTVCJTIyYSUyMHBob3RvJTIwb2YlMjBhJTIwY2F0JTIyJTJDJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhJTIwZG9nJTIyJTVEJTJDJTIwaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTIwcGFkZGluZyUzRFRydWUlMEEpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxvZ2l0c19wZXJfaW1hZ2UlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0c19wZXJfaW1hZ2UlMjAlMjAlMjMlMjB0aGlzJTIwaXMlMjB0aGUlMjBpbWFnZS10ZXh0JTIwc2ltaWxhcml0eSUyMHNjb3JlJTBBcHJvYnMlMjAlM0QlMjBsb2dpdHNfcGVyX2ltYWdlLnNvZnRtYXgoZGltJTNEMSklMjAlMjAlMjMlMjB3ZSUyMGNhbiUyMHRha2UlMjB0aGUlMjBzb2Z0bWF4JTIwdG8lMjBnZXQlMjB0aGUlMjBsYWJlbCUyMHByb2JhYmlsaXRpZXM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, CLIPSegModel

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;CIDAS/clipseg-rd64-refined&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = CLIPSegModel.from_pretrained(<span class="hljs-string">&quot;CIDAS/clipseg-rd64-refined&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    text=[<span class="hljs-string">&quot;a photo of a cat&quot;</span>, <span class="hljs-string">&quot;a photo of a dog&quot;</span>], images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_per_image = outputs.logits_per_image  <span class="hljs-comment"># this is the image-text similarity score</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>probs = logits_per_image.softmax(dim=<span class="hljs-number">1</span>)  <span class="hljs-comment"># we can take the softmax to get the label probabilities</span>`,wrap:!1}}),{c(){o=m("p"),o.textContent=M,d=a(),g(i.$$.fragment)},l(t){o=p(t,"P",{"data-svelte-h":!0}),C(o)!=="svelte-kvfsh7"&&(o.textContent=M),d=r(t),f(i.$$.fragment,t)},m(t,y){l(t,o,y),l(t,d,y),u(i,t,y),T=!0},p:z,i(t){T||(h(i.$$.fragment,t),T=!0)},o(t){_(i.$$.fragment,t),T=!1},d(t){t&&(s(o),s(d)),b(i,t)}}}function Xn(I){let o,M="Examples:",d,i,T;return i=new A({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBDTElQU2VnTW9kZWwlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJDSURBUyUyRmNsaXBzZWctcmQ2NC1yZWZpbmVkJTIyKSUwQW1vZGVsJTIwJTNEJTIwQ0xJUFNlZ01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJDSURBUyUyRmNsaXBzZWctcmQ2NC1yZWZpbmVkJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJhJTIwcGhvdG8lMjBvZiUyMGElMjBjYXQlMjIlMkMlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGElMjBkb2clMjIlNUQlMkMlMjBwYWRkaW5nJTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBdGV4dF9mZWF0dXJlcyUyMCUzRCUyMG1vZGVsLmdldF90ZXh0X2ZlYXR1cmVzKCoqaW5wdXRzKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, CLIPSegModel

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;CIDAS/clipseg-rd64-refined&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = CLIPSegModel.from_pretrained(<span class="hljs-string">&quot;CIDAS/clipseg-rd64-refined&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;a photo of a cat&quot;</span>, <span class="hljs-string">&quot;a photo of a dog&quot;</span>], padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>text_features = model.get_text_features(**inputs)`,wrap:!1}}),{c(){o=m("p"),o.textContent=M,d=a(),g(i.$$.fragment)},l(t){o=p(t,"P",{"data-svelte-h":!0}),C(o)!=="svelte-kvfsh7"&&(o.textContent=M),d=r(t),f(i.$$.fragment,t)},m(t,y){l(t,o,y),l(t,d,y),u(i,t,y),T=!0},p:z,i(t){T||(h(i.$$.fragment,t),T=!0)},o(t){_(i.$$.fragment,t),T=!1},d(t){t&&(s(o),s(d)),b(i,t)}}}function Gn(I){let o,M="Examples:",d,i,T;return i=new A({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyMENMSVBTZWdNb2RlbCUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMkNJREFTJTJGY2xpcHNlZy1yZDY0LXJlZmluZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBDTElQU2VnTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMkNJREFTJTJGY2xpcHNlZy1yZDY0LXJlZmluZWQlMjIpJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvcihpbWFnZXMlM0RpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBaW1hZ2VfZmVhdHVyZXMlMjAlM0QlMjBtb2RlbC5nZXRfaW1hZ2VfZmVhdHVyZXMoKippbnB1dHMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, CLIPSegModel

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;CIDAS/clipseg-rd64-refined&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = CLIPSegModel.from_pretrained(<span class="hljs-string">&quot;CIDAS/clipseg-rd64-refined&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_features = model.get_image_features(**inputs)`,wrap:!1}}),{c(){o=m("p"),o.textContent=M,d=a(),g(i.$$.fragment)},l(t){o=p(t,"P",{"data-svelte-h":!0}),C(o)!=="svelte-kvfsh7"&&(o.textContent=M),d=r(t),f(i.$$.fragment,t)},m(t,y){l(t,o,y),l(t,d,y),u(i,t,y),T=!0},p:z,i(t){T||(h(i.$$.fragment,t),T=!0)},o(t){_(i.$$.fragment,t),T=!1},d(t){t&&(s(o),s(d)),b(i,t)}}}function Rn(I){let o,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=m("p"),o.innerHTML=M},l(d){o=p(d,"P",{"data-svelte-h":!0}),C(o)!=="svelte-fincs2"&&(o.innerHTML=M)},m(d,i){l(d,o,i)},p:z,d(d){d&&s(o)}}}function Qn(I){let o,M="Examples:",d,i,T;return i=new A({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBDTElQU2VnVGV4dE1vZGVsJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyQ0lEQVMlMkZjbGlwc2VnLXJkNjQtcmVmaW5lZCUyMiklMEFtb2RlbCUyMCUzRCUyMENMSVBTZWdUZXh0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMkNJREFTJTJGY2xpcHNlZy1yZDY0LXJlZmluZWQlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMmElMjBwaG90byUyMG9mJTIwYSUyMGNhdCUyMiUyQyUyMCUyMmElMjBwaG90byUyMG9mJTIwYSUyMGRvZyUyMiU1RCUyQyUyMHBhZGRpbmclM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBbGFzdF9oaWRkZW5fc3RhdGUlMjAlM0QlMjBvdXRwdXRzLmxhc3RfaGlkZGVuX3N0YXRlJTBBcG9vbGVkX291dHB1dCUyMCUzRCUyMG91dHB1dHMucG9vbGVyX291dHB1dCUyMCUyMCUyMyUyMHBvb2xlZCUyMChFT1MlMjB0b2tlbiklMjBzdGF0ZXM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, CLIPSegTextModel

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;CIDAS/clipseg-rd64-refined&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = CLIPSegTextModel.from_pretrained(<span class="hljs-string">&quot;CIDAS/clipseg-rd64-refined&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;a photo of a cat&quot;</span>, <span class="hljs-string">&quot;a photo of a dog&quot;</span>], padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_state = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span>pooled_output = outputs.pooler_output  <span class="hljs-comment"># pooled (EOS token) states</span>`,wrap:!1}}),{c(){o=m("p"),o.textContent=M,d=a(),g(i.$$.fragment)},l(t){o=p(t,"P",{"data-svelte-h":!0}),C(o)!=="svelte-kvfsh7"&&(o.textContent=M),d=r(t),f(i.$$.fragment,t)},m(t,y){l(t,o,y),l(t,d,y),u(i,t,y),T=!0},p:z,i(t){T||(h(i.$$.fragment,t),T=!0)},o(t){_(i.$$.fragment,t),T=!1},d(t){t&&(s(o),s(d)),b(i,t)}}}function Dn(I){let o,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=m("p"),o.innerHTML=M},l(d){o=p(d,"P",{"data-svelte-h":!0}),C(o)!=="svelte-fincs2"&&(o.innerHTML=M)},m(d,i){l(d,o,i)},p:z,d(d){d&&s(o)}}}function An(I){let o,M="Examples:",d,i,T;return i=new A({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyMENMSVBTZWdWaXNpb25Nb2RlbCUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMkNJREFTJTJGY2xpcHNlZy1yZDY0LXJlZmluZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBDTElQU2VnVmlzaW9uTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMkNJREFTJTJGY2xpcHNlZy1yZDY0LXJlZmluZWQlMjIpJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvcihpbWFnZXMlM0RpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxhc3RfaGlkZGVuX3N0YXRlJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZSUwQXBvb2xlZF9vdXRwdXQlMjAlM0QlMjBvdXRwdXRzLnBvb2xlcl9vdXRwdXQlMjAlMjAlMjMlMjBwb29sZWQlMjBDTFMlMjBzdGF0ZXM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, CLIPSegVisionModel

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;CIDAS/clipseg-rd64-refined&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = CLIPSegVisionModel.from_pretrained(<span class="hljs-string">&quot;CIDAS/clipseg-rd64-refined&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_state = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span>pooled_output = outputs.pooler_output  <span class="hljs-comment"># pooled CLS states</span>`,wrap:!1}}),{c(){o=m("p"),o.textContent=M,d=a(),g(i.$$.fragment)},l(t){o=p(t,"P",{"data-svelte-h":!0}),C(o)!=="svelte-kvfsh7"&&(o.textContent=M),d=r(t),f(i.$$.fragment,t)},m(t,y){l(t,o,y),l(t,d,y),u(i,t,y),T=!0},p:z,i(t){T||(h(i.$$.fragment,t),T=!0)},o(t){_(i.$$.fragment,t),T=!1},d(t){t&&(s(o),s(d)),b(i,t)}}}function Yn(I){let o,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=m("p"),o.innerHTML=M},l(d){o=p(d,"P",{"data-svelte-h":!0}),C(o)!=="svelte-fincs2"&&(o.innerHTML=M)},m(d,i){l(d,o,i)},p:z,d(d){d&&s(o)}}}function On(I){let o,M="Examples:",d,i,T;return i=new A({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBDTElQU2VnRm9ySW1hZ2VTZWdtZW50YXRpb24lMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMkNJREFTJTJGY2xpcHNlZy1yZDY0LXJlZmluZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBDTElQU2VnRm9ySW1hZ2VTZWdtZW50YXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMkNJREFTJTJGY2xpcHNlZy1yZDY0LXJlZmluZWQlMjIpJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQXRleHRzJTIwJTNEJTIwJTVCJTIyYSUyMGNhdCUyMiUyQyUyMCUyMmElMjByZW1vdGUlMjIlMkMlMjAlMjJhJTIwYmxhbmtldCUyMiU1RCUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvcih0ZXh0JTNEdGV4dHMlMkMlMjBpbWFnZXMlM0QlNUJpbWFnZSU1RCUyMColMjBsZW4odGV4dHMpJTJDJTIwcGFkZGluZyUzRFRydWUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQXByaW50KGxvZ2l0cy5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, CLIPSegForImageSegmentation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;CIDAS/clipseg-rd64-refined&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = CLIPSegForImageSegmentation.from_pretrained(<span class="hljs-string">&quot;CIDAS/clipseg-rd64-refined&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>texts = [<span class="hljs-string">&quot;a cat&quot;</span>, <span class="hljs-string">&quot;a remote&quot;</span>, <span class="hljs-string">&quot;a blanket&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=texts, images=[image] * <span class="hljs-built_in">len</span>(texts), padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(logits.shape)
torch.Size([<span class="hljs-number">3</span>, <span class="hljs-number">352</span>, <span class="hljs-number">352</span>])`,wrap:!1}}),{c(){o=m("p"),o.textContent=M,d=a(),g(i.$$.fragment)},l(t){o=p(t,"P",{"data-svelte-h":!0}),C(o)!=="svelte-kvfsh7"&&(o.textContent=M),d=r(t),f(i.$$.fragment,t)},m(t,y){l(t,o,y),l(t,d,y),u(i,t,y),T=!0},p:z,i(t){T||(h(i.$$.fragment,t),T=!0)},o(t){_(i.$$.fragment,t),T=!1},d(t){t&&(s(o),s(d)),b(i,t)}}}function Kn(I){let o,M,d,i,T,t,y,en='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',Lt,be,jt,Te,tn=`The CLIPSeg model was proposed in <a href="https://arxiv.org/abs/2112.10003" rel="nofollow">Image Segmentation Using Text and Image Prompts</a> by Timo Lüddecke
and Alexander Ecker. CLIPSeg adds a minimal decoder on top of a frozen <a href="clip">CLIP</a> model for zero-shot and one-shot image segmentation.`,Jt,ye,on="The abstract from the paper is the following:",Zt,Me,nn=`<em>Image segmentation is usually addressed by training a
model for a fixed set of object classes. Incorporating additional classes or more complex queries later is expensive
as it requires re-training the model on a dataset that encompasses these expressions. Here we propose a system
that can generate image segmentations based on arbitrary
prompts at test time. A prompt can be either a text or an
image. This approach enables us to create a unified model
(trained once) for three common segmentation tasks, which
come with distinct challenges: referring expression segmentation, zero-shot segmentation and one-shot segmentation.
We build upon the CLIP model as a backbone which we extend with a transformer-based decoder that enables dense
prediction. After training on an extended version of the
PhraseCut dataset, our system generates a binary segmentation map for an image based on a free-text prompt or on
an additional image expressing the query. We analyze different variants of the latter image-based prompts in detail.
This novel hybrid input allows for dynamic adaptation not
only to the three segmentation tasks mentioned above, but
to any binary segmentation task where a text or image query
can be formulated. Finally, we find our system to adapt well
to generalized queries involving affordances or properties</em>`,kt,Y,sn,Ut,Ce,an='CLIPSeg overview. Taken from the <a href="https://arxiv.org/abs/2112.10003">original paper.</a>',zt,Ie,rn=`This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>.
The original code can be found <a href="https://github.com/timojl/clipseg" rel="nofollow">here</a>.`,Wt,ve,Bt,$e,ln=`<li><a href="/docs/transformers/main/en/model_doc/clipseg#transformers.CLIPSegForImageSegmentation">CLIPSegForImageSegmentation</a> adds a decoder on top of <a href="/docs/transformers/main/en/model_doc/clipseg#transformers.CLIPSegModel">CLIPSegModel</a>. The latter is identical to <a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPModel">CLIPModel</a>.</li> <li><a href="/docs/transformers/main/en/model_doc/clipseg#transformers.CLIPSegForImageSegmentation">CLIPSegForImageSegmentation</a> can generate image segmentations based on arbitrary prompts at test time. A prompt can be either a text
(provided to the model as <code>input_ids</code>) or an image (provided to the model as <code>conditional_pixel_values</code>). One can also provide custom
conditional embeddings (provided to the model as <code>conditional_embeddings</code>).</li>`,Vt,we,Nt,xe,dn="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with CLIPSeg. If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.",Ft,Se,Et,Pe,cn='<li>A notebook that illustrates <a href="https://github.com/NielsRogge/Transformers-Tutorials/blob/master/CLIPSeg/Zero_shot_image_segmentation_with_CLIPSeg.ipynb" rel="nofollow">zero-shot image segmentation with CLIPSeg</a>.</li>',qt,Le,Ht,P,je,mo,lt,mn=`<a href="/docs/transformers/main/en/model_doc/clipseg#transformers.CLIPSegConfig">CLIPSegConfig</a> is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/clipseg#transformers.CLIPSegModel">CLIPSegModel</a>. It is used to
instantiate a CLIPSeg model according to the specified arguments, defining the text model and vision model configs.
Instantiating a configuration with the defaults will yield a similar configuration to that of the CLIPSeg
<a href="https://huggingface.co/CIDAS/clipseg-rd64" rel="nofollow">CIDAS/clipseg-rd64</a> architecture.`,po,dt,pn=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,go,O,fo,K,Je,uo,ct,gn=`Instantiate a <a href="/docs/transformers/main/en/model_doc/clipseg#transformers.CLIPSegConfig">CLIPSegConfig</a> (or a derived class) from clipseg text model configuration and clipseg vision
model configuration.`,Xt,Ze,Gt,J,ke,ho,mt,fn=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/clipseg#transformers.CLIPSegModel">CLIPSegModel</a>. It is used to instantiate an
CLIPSeg model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the CLIPSeg
<a href="https://huggingface.co/CIDAS/clipseg-rd64" rel="nofollow">CIDAS/clipseg-rd64</a> architecture.`,_o,pt,un=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,bo,ee,Rt,Ue,Qt,Z,ze,To,gt,hn=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/clipseg#transformers.CLIPSegModel">CLIPSegModel</a>. It is used to instantiate an
CLIPSeg model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the CLIPSeg
<a href="https://huggingface.co/CIDAS/clipseg-rd64" rel="nofollow">CIDAS/clipseg-rd64</a> architecture.`,yo,ft,_n=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Mo,te,Dt,We,At,L,Be,Co,ut,bn="Constructs a CLIPSeg processor which wraps a CLIPSeg image processor and a CLIP tokenizer into a single processor.",Io,ht,Tn=`<a href="/docs/transformers/main/en/model_doc/clipseg#transformers.CLIPSegProcessor">CLIPSegProcessor</a> offers all the functionalities of <a href="/docs/transformers/main/en/model_doc/vit#transformers.ViTImageProcessor">ViTImageProcessor</a> and <a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizerFast">CLIPTokenizerFast</a>. See the
<code>__call__()</code> and <a href="/docs/transformers/main/en/model_doc/clipseg#transformers.CLIPSegProcessor.decode">decode()</a> for more information.`,vo,oe,Ve,$o,_t,yn=`This method forwards all its arguments to CLIPTokenizerFast’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.batch_decode">batch_decode()</a>. Please
refer to the docstring of this method for more information.`,wo,ne,Ne,xo,bt,Mn=`This method forwards all its arguments to CLIPTokenizerFast’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.decode">decode()</a>. Please refer to
the docstring of this method for more information.`,Yt,Fe,Ot,$,Ee,So,Tt,Cn="The bare Clipseg Model outputting raw hidden-states without any specific head on top.",Po,yt,In=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Lo,Mt,vn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,jo,W,qe,Jo,Ct,$n='The <a href="/docs/transformers/main/en/model_doc/clipseg#transformers.CLIPSegModel">CLIPSegModel</a> forward method, overrides the <code>__call__</code> special method.',Zo,se,ko,ae,Uo,re,He,zo,ie,Wo,le,Xe,Bo,de,Kt,Ge,eo,R,Re,Vo,B,Qe,No,It,wn='The <a href="/docs/transformers/main/en/model_doc/clipseg#transformers.CLIPSegTextModel">CLIPSegTextModel</a> forward method, overrides the <code>__call__</code> special method.',Fo,ce,Eo,me,to,De,oo,Q,Ae,qo,V,Ye,Ho,vt,xn='The <a href="/docs/transformers/main/en/model_doc/clipseg#transformers.CLIPSegVisionModel">CLIPSegVisionModel</a> forward method, overrides the <code>__call__</code> special method.',Xo,pe,Go,ge,no,Oe,so,j,Ke,Ro,$t,Sn="CLIPSeg model with a Transformer-based decoder on top for zero-shot and one-shot image segmentation.",Qo,wt,Pn=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Do,xt,Ln=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Ao,N,et,Yo,St,jn='The <a href="/docs/transformers/main/en/model_doc/clipseg#transformers.CLIPSegForImageSegmentation">CLIPSegForImageSegmentation</a> forward method, overrides the <code>__call__</code> special method.',Oo,fe,Ko,ue,ao,tt,ro,Pt,io;return T=new F({props:{title:"CLIPSeg",local:"clipseg",headingTag:"h1"}}),be=new F({props:{title:"Overview",local:"overview",headingTag:"h2"}}),ve=new F({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),we=new F({props:{title:"Resources",local:"resources",headingTag:"h2"}}),Se=new Bn({props:{pipeline:"image-segmentation"}}),Le=new F({props:{title:"CLIPSegConfig",local:"transformers.CLIPSegConfig",headingTag:"h2"}}),je=new S({props:{name:"class transformers.CLIPSegConfig",anchor:"transformers.CLIPSegConfig",parameters:[{name:"text_config",val:" = None"},{name:"vision_config",val:" = None"},{name:"projection_dim",val:" = 512"},{name:"logit_scale_init_value",val:" = 2.6592"},{name:"extract_layers",val:" = [3, 6, 9]"},{name:"reduce_dim",val:" = 64"},{name:"decoder_num_attention_heads",val:" = 4"},{name:"decoder_attention_dropout",val:" = 0.0"},{name:"decoder_hidden_act",val:" = 'quick_gelu'"},{name:"decoder_intermediate_size",val:" = 2048"},{name:"conditional_layer",val:" = 0"},{name:"use_complex_transposed_convolution",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.CLIPSegConfig.text_config",description:`<strong>text_config</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Dictionary of configuration options used to initialize <a href="/docs/transformers/main/en/model_doc/clipseg#transformers.CLIPSegTextConfig">CLIPSegTextConfig</a>.`,name:"text_config"},{anchor:"transformers.CLIPSegConfig.vision_config",description:`<strong>vision_config</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Dictionary of configuration options used to initialize <a href="/docs/transformers/main/en/model_doc/clipseg#transformers.CLIPSegVisionConfig">CLIPSegVisionConfig</a>.`,name:"vision_config"},{anchor:"transformers.CLIPSegConfig.projection_dim",description:`<strong>projection_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Dimensionality of text and vision projection layers.`,name:"projection_dim"},{anchor:"transformers.CLIPSegConfig.logit_scale_init_value",description:`<strong>logit_scale_init_value</strong> (<code>float</code>, <em>optional</em>, defaults to 2.6592) &#x2014;
The initial value of the <em>logit_scale</em> parameter. Default is used as per the original CLIPSeg implementation.`,name:"logit_scale_init_value"},{anchor:"transformers.CLIPSegConfig.extract_layers",description:`<strong>extract_layers</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[3, 6, 9]</code>) &#x2014;
Layers to extract when forwarding the query image through the frozen visual backbone of CLIP.`,name:"extract_layers"},{anchor:"transformers.CLIPSegConfig.reduce_dim",description:`<strong>reduce_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Dimensionality to reduce the CLIP vision embedding.`,name:"reduce_dim"},{anchor:"transformers.CLIPSegConfig.decoder_num_attention_heads",description:`<strong>decoder_num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
Number of attention heads in the decoder of CLIPSeg.`,name:"decoder_num_attention_heads"},{anchor:"transformers.CLIPSegConfig.decoder_attention_dropout",description:`<strong>decoder_attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"decoder_attention_dropout"},{anchor:"transformers.CLIPSegConfig.decoder_hidden_act",description:`<strong>decoder_hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;quick_gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> <code>&quot;quick_gelu&quot;</code> are supported.`,name:"decoder_hidden_act"},{anchor:"transformers.CLIPSegConfig.decoder_intermediate_size",description:`<strong>decoder_intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layers in the Transformer decoder.`,name:"decoder_intermediate_size"},{anchor:"transformers.CLIPSegConfig.conditional_layer",description:`<strong>conditional_layer</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
The layer to use of the Transformer encoder whose activations will be combined with the condition
embeddings using FiLM (Feature-wise Linear Modulation). If 0, the last layer is used.`,name:"conditional_layer"},{anchor:"transformers.CLIPSegConfig.use_complex_transposed_convolution",description:`<strong>use_complex_transposed_convolution</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use a more complex transposed convolution in the decoder, enabling more fine-grained
segmentation.`,name:"use_complex_transposed_convolution"},{anchor:"transformers.CLIPSegConfig.kwargs",description:`<strong>kwargs</strong> (<em>optional</em>) &#x2014;
Dictionary of keyword arguments.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/clipseg/configuration_clipseg.py#L207"}}),O=new D({props:{anchor:"transformers.CLIPSegConfig.example",$$slots:{default:[Nn]},$$scope:{ctx:I}}}),Je=new S({props:{name:"from_text_vision_configs",anchor:"transformers.CLIPSegConfig.from_text_vision_configs",parameters:[{name:"text_config",val:": CLIPSegTextConfig"},{name:"vision_config",val:": CLIPSegVisionConfig"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/clipseg/configuration_clipseg.py#L383",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An instance of a configuration object</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/clipseg#transformers.CLIPSegConfig"
>CLIPSegConfig</a></p>
`}}),Ze=new F({props:{title:"CLIPSegTextConfig",local:"transformers.CLIPSegTextConfig",headingTag:"h2"}}),ke=new S({props:{name:"class transformers.CLIPSegTextConfig",anchor:"transformers.CLIPSegTextConfig",parameters:[{name:"vocab_size",val:" = 49408"},{name:"hidden_size",val:" = 512"},{name:"intermediate_size",val:" = 2048"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 8"},{name:"max_position_embeddings",val:" = 77"},{name:"hidden_act",val:" = 'quick_gelu'"},{name:"layer_norm_eps",val:" = 1e-05"},{name:"attention_dropout",val:" = 0.0"},{name:"initializer_range",val:" = 0.02"},{name:"initializer_factor",val:" = 1.0"},{name:"pad_token_id",val:" = 1"},{name:"bos_token_id",val:" = 49406"},{name:"eos_token_id",val:" = 49407"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.CLIPSegTextConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 49408) &#x2014;
Vocabulary size of the CLIPSeg text model. Defines the number of different tokens that can be represented
by the <code>inputs_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/clipseg#transformers.CLIPSegModel">CLIPSegModel</a>.`,name:"vocab_size"},{anchor:"transformers.CLIPSegTextConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.CLIPSegTextConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.CLIPSegTextConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.CLIPSegTextConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.CLIPSegTextConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 77) &#x2014;
The maximum sequence length that this model might ever be used with. Typically set this to something large
just in case (e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.CLIPSegTextConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;quick_gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> <code>&quot;quick_gelu&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.CLIPSegTextConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.CLIPSegTextConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.CLIPSegTextConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.CLIPSegTextConfig.initializer_factor",description:`<strong>initializer_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
A factor for initializing all weight matrices (should be kept to 1, used internally for initialization
testing).`,name:"initializer_factor"},{anchor:"transformers.CLIPSegTextConfig.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Padding token id.`,name:"pad_token_id"},{anchor:"transformers.CLIPSegTextConfig.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 49406) &#x2014;
Beginning of stream token id.`,name:"bos_token_id"},{anchor:"transformers.CLIPSegTextConfig.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 49407) &#x2014;
End of stream token id.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/clipseg/configuration_clipseg.py#L24"}}),ee=new D({props:{anchor:"transformers.CLIPSegTextConfig.example",$$slots:{default:[Fn]},$$scope:{ctx:I}}}),Ue=new F({props:{title:"CLIPSegVisionConfig",local:"transformers.CLIPSegVisionConfig",headingTag:"h2"}}),ze=new S({props:{name:"class transformers.CLIPSegVisionConfig",anchor:"transformers.CLIPSegVisionConfig",parameters:[{name:"hidden_size",val:" = 768"},{name:"intermediate_size",val:" = 3072"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 12"},{name:"num_channels",val:" = 3"},{name:"image_size",val:" = 224"},{name:"patch_size",val:" = 32"},{name:"hidden_act",val:" = 'quick_gelu'"},{name:"layer_norm_eps",val:" = 1e-05"},{name:"attention_dropout",val:" = 0.0"},{name:"initializer_range",val:" = 0.02"},{name:"initializer_factor",val:" = 1.0"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.CLIPSegVisionConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.CLIPSegVisionConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.CLIPSegVisionConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.CLIPSegVisionConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.CLIPSegVisionConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of input channels.`,name:"num_channels"},{anchor:"transformers.CLIPSegVisionConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 224) &#x2014;
The size (resolution) of each image.`,name:"image_size"},{anchor:"transformers.CLIPSegVisionConfig.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
The size (resolution) of each patch.`,name:"patch_size"},{anchor:"transformers.CLIPSegVisionConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;quick_gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> <code>&quot;quick_gelu&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.CLIPSegVisionConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.CLIPSegVisionConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.CLIPSegVisionConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.CLIPSegVisionConfig.initializer_factor",description:`<strong>initializer_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
A factor for initializing all weight matrices (should be kept to 1, used internally for initialization
testing).`,name:"initializer_factor"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/clipseg/configuration_clipseg.py#L119"}}),te=new D({props:{anchor:"transformers.CLIPSegVisionConfig.example",$$slots:{default:[En]},$$scope:{ctx:I}}}),We=new F({props:{title:"CLIPSegProcessor",local:"transformers.CLIPSegProcessor",headingTag:"h2"}}),Be=new S({props:{name:"class transformers.CLIPSegProcessor",anchor:"transformers.CLIPSegProcessor",parameters:[{name:"image_processor",val:" = None"},{name:"tokenizer",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.CLIPSegProcessor.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/main/en/model_doc/vit#transformers.ViTImageProcessor">ViTImageProcessor</a>, <em>optional</em>) &#x2014;
The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.CLIPSegProcessor.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizerFast">CLIPTokenizerFast</a>, <em>optional</em>) &#x2014;
The tokenizer is a required input.`,name:"tokenizer"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/clipseg/processing_clipseg.py#L25"}}),Ve=new S({props:{name:"batch_decode",anchor:"transformers.CLIPSegProcessor.batch_decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/clipseg/processing_clipseg.py#L133"}}),Ne=new S({props:{name:"decode",anchor:"transformers.CLIPSegProcessor.decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/clipseg/processing_clipseg.py#L140"}}),Fe=new F({props:{title:"CLIPSegModel",local:"transformers.CLIPSegModel",headingTag:"h2"}}),Ee=new S({props:{name:"class transformers.CLIPSegModel",anchor:"transformers.CLIPSegModel",parameters:[{name:"config",val:": CLIPSegConfig"}],parametersDescription:[{anchor:"transformers.CLIPSegModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/clipseg#transformers.CLIPSegConfig">CLIPSegConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/clipseg/modeling_clipseg.py#L819"}}),qe=new S({props:{name:"forward",anchor:"transformers.CLIPSegModel.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"return_loss",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"interpolate_pos_encoding",val:": bool = True"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.CLIPSegModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.CLIPSegModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>, <em>optional</em>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.CLIPSegModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.CLIPSegModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.CLIPSegModel.forward.return_loss",description:`<strong>return_loss</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the contrastive loss.`,name:"return_loss"},{anchor:"transformers.CLIPSegModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.CLIPSegModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.CLIPSegModel.forward.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"},{anchor:"transformers.CLIPSegModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/clipseg/modeling_clipseg.py#L953",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.clipseg.modeling_clipseg.CLIPSegOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/clipseg#transformers.CLIPSegConfig"
>CLIPSegConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>return_loss</code> is <code>True</code>) — Contrastive loss for image-text similarity.</li>
<li><strong>logits_per_image</strong> (<code>torch.FloatTensor</code> of shape <code>(image_batch_size, text_batch_size)</code>) — The scaled dot product scores between <code>image_embeds</code> and <code>text_embeds</code>. This represents the image-text
similarity scores.</li>
<li><strong>logits_per_text</strong> (<code>torch.FloatTensor</code> of shape <code>(text_batch_size, image_batch_size)</code>) — The scaled dot product scores between <code>text_embeds</code> and <code>image_embeds</code>. This represents the text-image
similarity scores.</li>
<li><strong>text_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, output_dim</code>) — The text embeddings obtained by applying the projection layer to the pooled output of <a
  href="/docs/transformers/main/en/model_doc/clipseg#transformers.CLIPSegTextModel"
>CLIPSegTextModel</a>.</li>
<li><strong>image_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, output_dim</code>) — The image embeddings obtained by applying the projection layer to the pooled output of <a
  href="/docs/transformers/main/en/model_doc/clipseg#transformers.CLIPSegVisionModel"
>CLIPSegVisionModel</a>.</li>
<li><strong>text_model_output</strong> (<code>BaseModelOutputWithPooling</code>) — The output of the <a
  href="/docs/transformers/main/en/model_doc/clipseg#transformers.CLIPSegTextModel"
>CLIPSegTextModel</a>.</li>
<li><strong>vision_model_output</strong> (<code>BaseModelOutputWithPooling</code>) — The output of the <a
  href="/docs/transformers/main/en/model_doc/clipseg#transformers.CLIPSegVisionModel"
>CLIPSegVisionModel</a>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.clipseg.modeling_clipseg.CLIPSegOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),se=new co({props:{$$slots:{default:[qn]},$$scope:{ctx:I}}}),ae=new D({props:{anchor:"transformers.CLIPSegModel.forward.example",$$slots:{default:[Hn]},$$scope:{ctx:I}}}),He=new S({props:{name:"get_text_features",anchor:"transformers.CLIPSegModel.get_text_features",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.CLIPSegModel.get_text_features.input_ids",description:`<strong>input_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.CLIPSegModel.get_text_features.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.CLIPSegModel.get_text_features.position_ids",description:`<strong>position_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.CLIPSegModel.get_text_features.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.CLIPSegModel.get_text_features.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.CLIPSegModel.get_text_features.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/clipseg/modeling_clipseg.py#L855",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The text embeddings obtained by
applying the projection layer to the pooled output of <a
  href="/docs/transformers/main/en/model_doc/clipseg#transformers.CLIPSegTextModel"
>CLIPSegTextModel</a>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>text_features (<code>torch.FloatTensor</code> of shape <code>(batch_size, output_dim</code>)</p>
`}}),ie=new D({props:{anchor:"transformers.CLIPSegModel.get_text_features.example",$$slots:{default:[Xn]},$$scope:{ctx:I}}}),Xe=new S({props:{name:"get_image_features",anchor:"transformers.CLIPSegModel.get_image_features",parameters:[{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"interpolate_pos_encoding",val:": bool = True"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.CLIPSegModel.get_image_features.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>, <em>optional</em>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.CLIPSegModel.get_image_features.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.CLIPSegModel.get_image_features.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.CLIPSegModel.get_image_features.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"},{anchor:"transformers.CLIPSegModel.get_image_features.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/clipseg/modeling_clipseg.py#L902",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The image embeddings obtained by
applying the projection layer to the pooled output of <a
  href="/docs/transformers/main/en/model_doc/clipseg#transformers.CLIPSegVisionModel"
>CLIPSegVisionModel</a>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>image_features (<code>torch.FloatTensor</code> of shape <code>(batch_size, output_dim</code>)</p>
`}}),de=new D({props:{anchor:"transformers.CLIPSegModel.get_image_features.example",$$slots:{default:[Gn]},$$scope:{ctx:I}}}),Ge=new F({props:{title:"CLIPSegTextModel",local:"transformers.CLIPSegTextModel",headingTag:"h2"}}),Re=new S({props:{name:"class transformers.CLIPSegTextModel",anchor:"transformers.CLIPSegTextModel",parameters:[{name:"config",val:": CLIPSegTextConfig"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/clipseg/modeling_clipseg.py#L664"}}),Qe=new S({props:{name:"forward",anchor:"transformers.CLIPSegTextModel.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.CLIPSegTextModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.CLIPSegTextModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.CLIPSegTextModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.CLIPSegTextModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.CLIPSegTextModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.CLIPSegTextModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/clipseg/modeling_clipseg.py#L681",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/clipseg#transformers.CLIPSegConfig"
>CLIPSegConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state of the first token of the sequence (classification token) after further processing
through the layers used for the auxiliary pretraining task. E.g. for BERT-family of models, this returns
the classification token after processing through a linear layer and a tanh activation function. The linear
layer weights are trained from the next sentence prediction (classification) objective during pretraining.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ce=new co({props:{$$slots:{default:[Rn]},$$scope:{ctx:I}}}),me=new D({props:{anchor:"transformers.CLIPSegTextModel.forward.example",$$slots:{default:[Qn]},$$scope:{ctx:I}}}),De=new F({props:{title:"CLIPSegVisionModel",local:"transformers.CLIPSegVisionModel",headingTag:"h2"}}),Ae=new S({props:{name:"class transformers.CLIPSegVisionModel",anchor:"transformers.CLIPSegVisionModel",parameters:[{name:"config",val:": CLIPSegVisionConfig"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/clipseg/modeling_clipseg.py#L768"}}),Ye=new S({props:{name:"forward",anchor:"transformers.CLIPSegVisionModel.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"interpolate_pos_encoding",val:": typing.Optional[bool] = True"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.CLIPSegVisionModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>, <em>optional</em>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.CLIPSegVisionModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.CLIPSegVisionModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.CLIPSegVisionModel.forward.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"},{anchor:"transformers.CLIPSegVisionModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/clipseg/modeling_clipseg.py#L781",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/clipseg#transformers.CLIPSegConfig"
>CLIPSegConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state of the first token of the sequence (classification token) after further processing
through the layers used for the auxiliary pretraining task. E.g. for BERT-family of models, this returns
the classification token after processing through a linear layer and a tanh activation function. The linear
layer weights are trained from the next sentence prediction (classification) objective during pretraining.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),pe=new co({props:{$$slots:{default:[Dn]},$$scope:{ctx:I}}}),ge=new D({props:{anchor:"transformers.CLIPSegVisionModel.forward.example",$$slots:{default:[An]},$$scope:{ctx:I}}}),Oe=new F({props:{title:"CLIPSegForImageSegmentation",local:"transformers.CLIPSegForImageSegmentation",headingTag:"h2"}}),Ke=new S({props:{name:"class transformers.CLIPSegForImageSegmentation",anchor:"transformers.CLIPSegForImageSegmentation",parameters:[{name:"config",val:": CLIPSegConfig"}],parametersDescription:[{anchor:"transformers.CLIPSegForImageSegmentation.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/clipseg#transformers.CLIPSegConfig">CLIPSegConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/clipseg/modeling_clipseg.py#L1206"}}),et=new S({props:{name:"forward",anchor:"transformers.CLIPSegForImageSegmentation.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"conditional_pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"conditional_embeddings",val:": typing.Optional[torch.FloatTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"interpolate_pos_encoding",val:": bool = True"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.CLIPSegForImageSegmentation.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.CLIPSegForImageSegmentation.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>, <em>optional</em>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.CLIPSegForImageSegmentation.forward.conditional_pixel_values",description:`<strong>conditional_pixel_values</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
The pixel values of the conditional images.`,name:"conditional_pixel_values"},{anchor:"transformers.CLIPSegForImageSegmentation.forward.conditional_embeddings",description:`<strong>conditional_embeddings</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.projection_dim)</code>, <em>optional</em>) &#x2014;
The conditional embeddings for the query images. If provided, the model will use this instead of computing
the embeddings from the conditional_pixel_values.`,name:"conditional_embeddings"},{anchor:"transformers.CLIPSegForImageSegmentation.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.CLIPSegForImageSegmentation.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.CLIPSegForImageSegmentation.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"},{anchor:"transformers.CLIPSegForImageSegmentation.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.CLIPSegForImageSegmentation.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.CLIPSegForImageSegmentation.forward.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"},{anchor:"transformers.CLIPSegForImageSegmentation.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/clipseg/modeling_clipseg.py#L1256",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.clipseg.modeling_clipseg.CLIPSegOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/clipseg#transformers.CLIPSegConfig"
>CLIPSegConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>return_loss</code> is <code>True</code>) — Contrastive loss for image-text similarity.</li>
<li><strong>logits_per_image</strong> (<code>torch.FloatTensor</code> of shape <code>(image_batch_size, text_batch_size)</code>) — The scaled dot product scores between <code>image_embeds</code> and <code>text_embeds</code>. This represents the image-text
similarity scores.</li>
<li><strong>logits_per_text</strong> (<code>torch.FloatTensor</code> of shape <code>(text_batch_size, image_batch_size)</code>) — The scaled dot product scores between <code>text_embeds</code> and <code>image_embeds</code>. This represents the text-image
similarity scores.</li>
<li><strong>text_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, output_dim</code>) — The text embeddings obtained by applying the projection layer to the pooled output of <a
  href="/docs/transformers/main/en/model_doc/clipseg#transformers.CLIPSegTextModel"
>CLIPSegTextModel</a>.</li>
<li><strong>image_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, output_dim</code>) — The image embeddings obtained by applying the projection layer to the pooled output of <a
  href="/docs/transformers/main/en/model_doc/clipseg#transformers.CLIPSegVisionModel"
>CLIPSegVisionModel</a>.</li>
<li><strong>text_model_output</strong> (<code>BaseModelOutputWithPooling</code>) — The output of the <a
  href="/docs/transformers/main/en/model_doc/clipseg#transformers.CLIPSegTextModel"
>CLIPSegTextModel</a>.</li>
<li><strong>vision_model_output</strong> (<code>BaseModelOutputWithPooling</code>) — The output of the <a
  href="/docs/transformers/main/en/model_doc/clipseg#transformers.CLIPSegVisionModel"
>CLIPSegVisionModel</a>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.clipseg.modeling_clipseg.CLIPSegOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),fe=new co({props:{$$slots:{default:[Yn]},$$scope:{ctx:I}}}),ue=new D({props:{anchor:"transformers.CLIPSegForImageSegmentation.forward.example",$$slots:{default:[On]},$$scope:{ctx:I}}}),tt=new Vn({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/clipseg.md"}}),{c(){o=m("meta"),M=a(),d=m("p"),i=a(),g(T.$$.fragment),t=a(),y=m("div"),y.innerHTML=en,Lt=a(),g(be.$$.fragment),jt=a(),Te=m("p"),Te.innerHTML=tn,Jt=a(),ye=m("p"),ye.textContent=on,Zt=a(),Me=m("p"),Me.innerHTML=nn,kt=a(),Y=m("img"),Ut=a(),Ce=m("small"),Ce.innerHTML=an,zt=a(),Ie=m("p"),Ie.innerHTML=rn,Wt=a(),g(ve.$$.fragment),Bt=a(),$e=m("ul"),$e.innerHTML=ln,Vt=a(),g(we.$$.fragment),Nt=a(),xe=m("p"),xe.textContent=dn,Ft=a(),g(Se.$$.fragment),Et=a(),Pe=m("ul"),Pe.innerHTML=cn,qt=a(),g(Le.$$.fragment),Ht=a(),P=m("div"),g(je.$$.fragment),mo=a(),lt=m("p"),lt.innerHTML=mn,po=a(),dt=m("p"),dt.innerHTML=pn,go=a(),g(O.$$.fragment),fo=a(),K=m("div"),g(Je.$$.fragment),uo=a(),ct=m("p"),ct.innerHTML=gn,Xt=a(),g(Ze.$$.fragment),Gt=a(),J=m("div"),g(ke.$$.fragment),ho=a(),mt=m("p"),mt.innerHTML=fn,_o=a(),pt=m("p"),pt.innerHTML=un,bo=a(),g(ee.$$.fragment),Rt=a(),g(Ue.$$.fragment),Qt=a(),Z=m("div"),g(ze.$$.fragment),To=a(),gt=m("p"),gt.innerHTML=hn,yo=a(),ft=m("p"),ft.innerHTML=_n,Mo=a(),g(te.$$.fragment),Dt=a(),g(We.$$.fragment),At=a(),L=m("div"),g(Be.$$.fragment),Co=a(),ut=m("p"),ut.textContent=bn,Io=a(),ht=m("p"),ht.innerHTML=Tn,vo=a(),oe=m("div"),g(Ve.$$.fragment),$o=a(),_t=m("p"),_t.innerHTML=yn,wo=a(),ne=m("div"),g(Ne.$$.fragment),xo=a(),bt=m("p"),bt.innerHTML=Mn,Yt=a(),g(Fe.$$.fragment),Ot=a(),$=m("div"),g(Ee.$$.fragment),So=a(),Tt=m("p"),Tt.textContent=Cn,Po=a(),yt=m("p"),yt.innerHTML=In,Lo=a(),Mt=m("p"),Mt.innerHTML=vn,jo=a(),W=m("div"),g(qe.$$.fragment),Jo=a(),Ct=m("p"),Ct.innerHTML=$n,Zo=a(),g(se.$$.fragment),ko=a(),g(ae.$$.fragment),Uo=a(),re=m("div"),g(He.$$.fragment),zo=a(),g(ie.$$.fragment),Wo=a(),le=m("div"),g(Xe.$$.fragment),Bo=a(),g(de.$$.fragment),Kt=a(),g(Ge.$$.fragment),eo=a(),R=m("div"),g(Re.$$.fragment),Vo=a(),B=m("div"),g(Qe.$$.fragment),No=a(),It=m("p"),It.innerHTML=wn,Fo=a(),g(ce.$$.fragment),Eo=a(),g(me.$$.fragment),to=a(),g(De.$$.fragment),oo=a(),Q=m("div"),g(Ae.$$.fragment),qo=a(),V=m("div"),g(Ye.$$.fragment),Ho=a(),vt=m("p"),vt.innerHTML=xn,Xo=a(),g(pe.$$.fragment),Go=a(),g(ge.$$.fragment),no=a(),g(Oe.$$.fragment),so=a(),j=m("div"),g(Ke.$$.fragment),Ro=a(),$t=m("p"),$t.textContent=Sn,Qo=a(),wt=m("p"),wt.innerHTML=Pn,Do=a(),xt=m("p"),xt.innerHTML=Ln,Ao=a(),N=m("div"),g(et.$$.fragment),Yo=a(),St=m("p"),St.innerHTML=jn,Oo=a(),g(fe.$$.fragment),Ko=a(),g(ue.$$.fragment),ao=a(),g(tt.$$.fragment),ro=a(),Pt=m("p"),this.h()},l(e){const n=Wn("svelte-u9bgzb",document.head);o=p(n,"META",{name:!0,content:!0}),n.forEach(s),M=r(e),d=p(e,"P",{}),w(d).forEach(s),i=r(e),f(T.$$.fragment,e),t=r(e),y=p(e,"DIV",{class:!0,"data-svelte-h":!0}),C(y)!=="svelte-13t8s2t"&&(y.innerHTML=en),Lt=r(e),f(be.$$.fragment,e),jt=r(e),Te=p(e,"P",{"data-svelte-h":!0}),C(Te)!=="svelte-wjbpa9"&&(Te.innerHTML=tn),Jt=r(e),ye=p(e,"P",{"data-svelte-h":!0}),C(ye)!=="svelte-vfdo9a"&&(ye.textContent=on),Zt=r(e),Me=p(e,"P",{"data-svelte-h":!0}),C(Me)!=="svelte-2767bu"&&(Me.innerHTML=nn),kt=r(e),Y=p(e,"IMG",{src:!0,alt:!0,width:!0}),Ut=r(e),Ce=p(e,"SMALL",{"data-svelte-h":!0}),C(Ce)!=="svelte-r8s5wt"&&(Ce.innerHTML=an),zt=r(e),Ie=p(e,"P",{"data-svelte-h":!0}),C(Ie)!=="svelte-14bl8yt"&&(Ie.innerHTML=rn),Wt=r(e),f(ve.$$.fragment,e),Bt=r(e),$e=p(e,"UL",{"data-svelte-h":!0}),C($e)!=="svelte-1i9xdxd"&&($e.innerHTML=ln),Vt=r(e),f(we.$$.fragment,e),Nt=r(e),xe=p(e,"P",{"data-svelte-h":!0}),C(xe)!=="svelte-i5etz8"&&(xe.textContent=dn),Ft=r(e),f(Se.$$.fragment,e),Et=r(e),Pe=p(e,"UL",{"data-svelte-h":!0}),C(Pe)!=="svelte-ksa1e9"&&(Pe.innerHTML=cn),qt=r(e),f(Le.$$.fragment,e),Ht=r(e),P=p(e,"DIV",{class:!0});var k=w(P);f(je.$$.fragment,k),mo=r(k),lt=p(k,"P",{"data-svelte-h":!0}),C(lt)!=="svelte-n9fv2j"&&(lt.innerHTML=mn),po=r(k),dt=p(k,"P",{"data-svelte-h":!0}),C(dt)!=="svelte-o55m63"&&(dt.innerHTML=pn),go=r(k),f(O.$$.fragment,k),fo=r(k),K=p(k,"DIV",{class:!0});var ot=w(K);f(Je.$$.fragment,ot),uo=r(ot),ct=p(ot,"P",{"data-svelte-h":!0}),C(ct)!=="svelte-1jbt4n9"&&(ct.innerHTML=gn),ot.forEach(s),k.forEach(s),Xt=r(e),f(Ze.$$.fragment,e),Gt=r(e),J=p(e,"DIV",{class:!0});var E=w(J);f(ke.$$.fragment,E),ho=r(E),mt=p(E,"P",{"data-svelte-h":!0}),C(mt)!=="svelte-dj3u6s"&&(mt.innerHTML=fn),_o=r(E),pt=p(E,"P",{"data-svelte-h":!0}),C(pt)!=="svelte-o55m63"&&(pt.innerHTML=un),bo=r(E),f(ee.$$.fragment,E),E.forEach(s),Rt=r(e),f(Ue.$$.fragment,e),Qt=r(e),Z=p(e,"DIV",{class:!0});var q=w(Z);f(ze.$$.fragment,q),To=r(q),gt=p(q,"P",{"data-svelte-h":!0}),C(gt)!=="svelte-dj3u6s"&&(gt.innerHTML=hn),yo=r(q),ft=p(q,"P",{"data-svelte-h":!0}),C(ft)!=="svelte-o55m63"&&(ft.innerHTML=_n),Mo=r(q),f(te.$$.fragment,q),q.forEach(s),Dt=r(e),f(We.$$.fragment,e),At=r(e),L=p(e,"DIV",{class:!0});var U=w(L);f(Be.$$.fragment,U),Co=r(U),ut=p(U,"P",{"data-svelte-h":!0}),C(ut)!=="svelte-9hszhx"&&(ut.textContent=bn),Io=r(U),ht=p(U,"P",{"data-svelte-h":!0}),C(ht)!=="svelte-hb9pu0"&&(ht.innerHTML=Tn),vo=r(U),oe=p(U,"DIV",{class:!0});var nt=w(oe);f(Ve.$$.fragment,nt),$o=r(nt),_t=p(nt,"P",{"data-svelte-h":!0}),C(_t)!=="svelte-vahtpx"&&(_t.innerHTML=yn),nt.forEach(s),wo=r(U),ne=p(U,"DIV",{class:!0});var st=w(ne);f(Ne.$$.fragment,st),xo=r(st),bt=p(st,"P",{"data-svelte-h":!0}),C(bt)!=="svelte-174p0in"&&(bt.innerHTML=Mn),st.forEach(s),U.forEach(s),Yt=r(e),f(Fe.$$.fragment,e),Ot=r(e),$=p(e,"DIV",{class:!0});var x=w($);f(Ee.$$.fragment,x),So=r(x),Tt=p(x,"P",{"data-svelte-h":!0}),C(Tt)!=="svelte-9mbg47"&&(Tt.textContent=Cn),Po=r(x),yt=p(x,"P",{"data-svelte-h":!0}),C(yt)!=="svelte-6pahdo"&&(yt.innerHTML=In),Lo=r(x),Mt=p(x,"P",{"data-svelte-h":!0}),C(Mt)!=="svelte-hswkmf"&&(Mt.innerHTML=vn),jo=r(x),W=p(x,"DIV",{class:!0});var H=w(W);f(qe.$$.fragment,H),Jo=r(H),Ct=p(H,"P",{"data-svelte-h":!0}),C(Ct)!=="svelte-t3a68g"&&(Ct.innerHTML=$n),Zo=r(H),f(se.$$.fragment,H),ko=r(H),f(ae.$$.fragment,H),H.forEach(s),Uo=r(x),re=p(x,"DIV",{class:!0});var at=w(re);f(He.$$.fragment,at),zo=r(at),f(ie.$$.fragment,at),at.forEach(s),Wo=r(x),le=p(x,"DIV",{class:!0});var rt=w(le);f(Xe.$$.fragment,rt),Bo=r(rt),f(de.$$.fragment,rt),rt.forEach(s),x.forEach(s),Kt=r(e),f(Ge.$$.fragment,e),eo=r(e),R=p(e,"DIV",{class:!0});var it=w(R);f(Re.$$.fragment,it),Vo=r(it),B=p(it,"DIV",{class:!0});var X=w(B);f(Qe.$$.fragment,X),No=r(X),It=p(X,"P",{"data-svelte-h":!0}),C(It)!=="svelte-1cmt72u"&&(It.innerHTML=wn),Fo=r(X),f(ce.$$.fragment,X),Eo=r(X),f(me.$$.fragment,X),X.forEach(s),it.forEach(s),to=r(e),f(De.$$.fragment,e),oo=r(e),Q=p(e,"DIV",{class:!0});var lo=w(Q);f(Ae.$$.fragment,lo),qo=r(lo),V=p(lo,"DIV",{class:!0});var he=w(V);f(Ye.$$.fragment,he),Ho=r(he),vt=p(he,"P",{"data-svelte-h":!0}),C(vt)!=="svelte-1ipxvuo"&&(vt.innerHTML=xn),Xo=r(he),f(pe.$$.fragment,he),Go=r(he),f(ge.$$.fragment,he),he.forEach(s),lo.forEach(s),no=r(e),f(Oe.$$.fragment,e),so=r(e),j=p(e,"DIV",{class:!0});var G=w(j);f(Ke.$$.fragment,G),Ro=r(G),$t=p(G,"P",{"data-svelte-h":!0}),C($t)!=="svelte-qndran"&&($t.textContent=Sn),Qo=r(G),wt=p(G,"P",{"data-svelte-h":!0}),C(wt)!=="svelte-6pahdo"&&(wt.innerHTML=Pn),Do=r(G),xt=p(G,"P",{"data-svelte-h":!0}),C(xt)!=="svelte-hswkmf"&&(xt.innerHTML=Ln),Ao=r(G),N=p(G,"DIV",{class:!0});var _e=w(N);f(et.$$.fragment,_e),Yo=r(_e),St=p(_e,"P",{"data-svelte-h":!0}),C(St)!=="svelte-3xvx5w"&&(St.innerHTML=jn),Oo=r(_e),f(fe.$$.fragment,_e),Ko=r(_e),f(ue.$$.fragment,_e),_e.forEach(s),G.forEach(s),ao=r(e),f(tt.$$.fragment,e),ro=r(e),Pt=p(e,"P",{}),w(Pt).forEach(s),this.h()},h(){v(o,"name","hf:doc:metadata"),v(o,"content",es),v(y,"class","flex flex-wrap space-x-1"),Zn(Y.src,sn="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/clipseg_architecture.png")||v(Y,"src",sn),v(Y,"alt","drawing"),v(Y,"width","600"),v(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,n){c(document.head,o),l(e,M,n),l(e,d,n),l(e,i,n),u(T,e,n),l(e,t,n),l(e,y,n),l(e,Lt,n),u(be,e,n),l(e,jt,n),l(e,Te,n),l(e,Jt,n),l(e,ye,n),l(e,Zt,n),l(e,Me,n),l(e,kt,n),l(e,Y,n),l(e,Ut,n),l(e,Ce,n),l(e,zt,n),l(e,Ie,n),l(e,Wt,n),u(ve,e,n),l(e,Bt,n),l(e,$e,n),l(e,Vt,n),u(we,e,n),l(e,Nt,n),l(e,xe,n),l(e,Ft,n),u(Se,e,n),l(e,Et,n),l(e,Pe,n),l(e,qt,n),u(Le,e,n),l(e,Ht,n),l(e,P,n),u(je,P,null),c(P,mo),c(P,lt),c(P,po),c(P,dt),c(P,go),u(O,P,null),c(P,fo),c(P,K),u(Je,K,null),c(K,uo),c(K,ct),l(e,Xt,n),u(Ze,e,n),l(e,Gt,n),l(e,J,n),u(ke,J,null),c(J,ho),c(J,mt),c(J,_o),c(J,pt),c(J,bo),u(ee,J,null),l(e,Rt,n),u(Ue,e,n),l(e,Qt,n),l(e,Z,n),u(ze,Z,null),c(Z,To),c(Z,gt),c(Z,yo),c(Z,ft),c(Z,Mo),u(te,Z,null),l(e,Dt,n),u(We,e,n),l(e,At,n),l(e,L,n),u(Be,L,null),c(L,Co),c(L,ut),c(L,Io),c(L,ht),c(L,vo),c(L,oe),u(Ve,oe,null),c(oe,$o),c(oe,_t),c(L,wo),c(L,ne),u(Ne,ne,null),c(ne,xo),c(ne,bt),l(e,Yt,n),u(Fe,e,n),l(e,Ot,n),l(e,$,n),u(Ee,$,null),c($,So),c($,Tt),c($,Po),c($,yt),c($,Lo),c($,Mt),c($,jo),c($,W),u(qe,W,null),c(W,Jo),c(W,Ct),c(W,Zo),u(se,W,null),c(W,ko),u(ae,W,null),c($,Uo),c($,re),u(He,re,null),c(re,zo),u(ie,re,null),c($,Wo),c($,le),u(Xe,le,null),c(le,Bo),u(de,le,null),l(e,Kt,n),u(Ge,e,n),l(e,eo,n),l(e,R,n),u(Re,R,null),c(R,Vo),c(R,B),u(Qe,B,null),c(B,No),c(B,It),c(B,Fo),u(ce,B,null),c(B,Eo),u(me,B,null),l(e,to,n),u(De,e,n),l(e,oo,n),l(e,Q,n),u(Ae,Q,null),c(Q,qo),c(Q,V),u(Ye,V,null),c(V,Ho),c(V,vt),c(V,Xo),u(pe,V,null),c(V,Go),u(ge,V,null),l(e,no,n),u(Oe,e,n),l(e,so,n),l(e,j,n),u(Ke,j,null),c(j,Ro),c(j,$t),c(j,Qo),c(j,wt),c(j,Do),c(j,xt),c(j,Ao),c(j,N),u(et,N,null),c(N,Yo),c(N,St),c(N,Oo),u(fe,N,null),c(N,Ko),u(ue,N,null),l(e,ao,n),u(tt,e,n),l(e,ro,n),l(e,Pt,n),io=!0},p(e,[n]){const k={};n&2&&(k.$$scope={dirty:n,ctx:e}),O.$set(k);const ot={};n&2&&(ot.$$scope={dirty:n,ctx:e}),ee.$set(ot);const E={};n&2&&(E.$$scope={dirty:n,ctx:e}),te.$set(E);const q={};n&2&&(q.$$scope={dirty:n,ctx:e}),se.$set(q);const U={};n&2&&(U.$$scope={dirty:n,ctx:e}),ae.$set(U);const nt={};n&2&&(nt.$$scope={dirty:n,ctx:e}),ie.$set(nt);const st={};n&2&&(st.$$scope={dirty:n,ctx:e}),de.$set(st);const x={};n&2&&(x.$$scope={dirty:n,ctx:e}),ce.$set(x);const H={};n&2&&(H.$$scope={dirty:n,ctx:e}),me.$set(H);const at={};n&2&&(at.$$scope={dirty:n,ctx:e}),pe.$set(at);const rt={};n&2&&(rt.$$scope={dirty:n,ctx:e}),ge.$set(rt);const it={};n&2&&(it.$$scope={dirty:n,ctx:e}),fe.$set(it);const X={};n&2&&(X.$$scope={dirty:n,ctx:e}),ue.$set(X)},i(e){io||(h(T.$$.fragment,e),h(be.$$.fragment,e),h(ve.$$.fragment,e),h(we.$$.fragment,e),h(Se.$$.fragment,e),h(Le.$$.fragment,e),h(je.$$.fragment,e),h(O.$$.fragment,e),h(Je.$$.fragment,e),h(Ze.$$.fragment,e),h(ke.$$.fragment,e),h(ee.$$.fragment,e),h(Ue.$$.fragment,e),h(ze.$$.fragment,e),h(te.$$.fragment,e),h(We.$$.fragment,e),h(Be.$$.fragment,e),h(Ve.$$.fragment,e),h(Ne.$$.fragment,e),h(Fe.$$.fragment,e),h(Ee.$$.fragment,e),h(qe.$$.fragment,e),h(se.$$.fragment,e),h(ae.$$.fragment,e),h(He.$$.fragment,e),h(ie.$$.fragment,e),h(Xe.$$.fragment,e),h(de.$$.fragment,e),h(Ge.$$.fragment,e),h(Re.$$.fragment,e),h(Qe.$$.fragment,e),h(ce.$$.fragment,e),h(me.$$.fragment,e),h(De.$$.fragment,e),h(Ae.$$.fragment,e),h(Ye.$$.fragment,e),h(pe.$$.fragment,e),h(ge.$$.fragment,e),h(Oe.$$.fragment,e),h(Ke.$$.fragment,e),h(et.$$.fragment,e),h(fe.$$.fragment,e),h(ue.$$.fragment,e),h(tt.$$.fragment,e),io=!0)},o(e){_(T.$$.fragment,e),_(be.$$.fragment,e),_(ve.$$.fragment,e),_(we.$$.fragment,e),_(Se.$$.fragment,e),_(Le.$$.fragment,e),_(je.$$.fragment,e),_(O.$$.fragment,e),_(Je.$$.fragment,e),_(Ze.$$.fragment,e),_(ke.$$.fragment,e),_(ee.$$.fragment,e),_(Ue.$$.fragment,e),_(ze.$$.fragment,e),_(te.$$.fragment,e),_(We.$$.fragment,e),_(Be.$$.fragment,e),_(Ve.$$.fragment,e),_(Ne.$$.fragment,e),_(Fe.$$.fragment,e),_(Ee.$$.fragment,e),_(qe.$$.fragment,e),_(se.$$.fragment,e),_(ae.$$.fragment,e),_(He.$$.fragment,e),_(ie.$$.fragment,e),_(Xe.$$.fragment,e),_(de.$$.fragment,e),_(Ge.$$.fragment,e),_(Re.$$.fragment,e),_(Qe.$$.fragment,e),_(ce.$$.fragment,e),_(me.$$.fragment,e),_(De.$$.fragment,e),_(Ae.$$.fragment,e),_(Ye.$$.fragment,e),_(pe.$$.fragment,e),_(ge.$$.fragment,e),_(Oe.$$.fragment,e),_(Ke.$$.fragment,e),_(et.$$.fragment,e),_(fe.$$.fragment,e),_(ue.$$.fragment,e),_(tt.$$.fragment,e),io=!1},d(e){e&&(s(M),s(d),s(i),s(t),s(y),s(Lt),s(jt),s(Te),s(Jt),s(ye),s(Zt),s(Me),s(kt),s(Y),s(Ut),s(Ce),s(zt),s(Ie),s(Wt),s(Bt),s($e),s(Vt),s(Nt),s(xe),s(Ft),s(Et),s(Pe),s(qt),s(Ht),s(P),s(Xt),s(Gt),s(J),s(Rt),s(Qt),s(Z),s(Dt),s(At),s(L),s(Yt),s(Ot),s($),s(Kt),s(eo),s(R),s(to),s(oo),s(Q),s(no),s(so),s(j),s(ao),s(ro),s(Pt)),s(o),b(T,e),b(be,e),b(ve,e),b(we,e),b(Se,e),b(Le,e),b(je),b(O),b(Je),b(Ze,e),b(ke),b(ee),b(Ue,e),b(ze),b(te),b(We,e),b(Be),b(Ve),b(Ne),b(Fe,e),b(Ee),b(qe),b(se),b(ae),b(He),b(ie),b(Xe),b(de),b(Ge,e),b(Re),b(Qe),b(ce),b(me),b(De,e),b(Ae),b(Ye),b(pe),b(ge),b(Oe,e),b(Ke),b(et),b(fe),b(ue),b(tt,e)}}}const es='{"title":"CLIPSeg","local":"clipseg","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"CLIPSegConfig","local":"transformers.CLIPSegConfig","sections":[],"depth":2},{"title":"CLIPSegTextConfig","local":"transformers.CLIPSegTextConfig","sections":[],"depth":2},{"title":"CLIPSegVisionConfig","local":"transformers.CLIPSegVisionConfig","sections":[],"depth":2},{"title":"CLIPSegProcessor","local":"transformers.CLIPSegProcessor","sections":[],"depth":2},{"title":"CLIPSegModel","local":"transformers.CLIPSegModel","sections":[],"depth":2},{"title":"CLIPSegTextModel","local":"transformers.CLIPSegTextModel","sections":[],"depth":2},{"title":"CLIPSegVisionModel","local":"transformers.CLIPSegVisionModel","sections":[],"depth":2},{"title":"CLIPSegForImageSegmentation","local":"transformers.CLIPSegForImageSegmentation","sections":[],"depth":2}],"depth":1}';function ts(I){return kn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ms extends Un{constructor(o){super(),zn(this,o,ts,Kn,Jn,{})}}export{ms as component};
