import{s as mo,o as po,n as Ee}from"../chunks/scheduler.18a86fab.js";import{S as uo,i as fo,g as i,s as r,r as M,A as ho,h as c,f as s,c as a,j as Z,x as u,u as b,k as B,l as go,y as n,a as d,v as y,d as _,t as w,w as v}from"../chunks/index.98837b22.js";import{T as io}from"../chunks/Tip.77304350.js";import{D as V}from"../chunks/Docstring.6758ea23.js";import{C as qe}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as co}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as ze}from"../chunks/Heading.7e7e0c5b.js";import{H as Mo,a as bo}from"../chunks/HfOption.6641485e.js";import{E as yo}from"../chunks/getInferenceSnippets.de10bc7d.js";function _o(P){let t,h="Click on the ColPali models in the right sidebar for more examples of how to use ColPali for image retrieval.";return{c(){t=i("p"),t.textContent=h},l(l){t=c(l,"P",{"data-svelte-h":!0}),u(t)!=="svelte-19qg7yk"&&(t.textContent=h)},m(l,p){d(l,t,p)},p:Ee,d(l){l&&s(t)}}}function wo(P){let t,h,l,p="If you have issue with loading the images with PIL, you can use the following code to create dummy images:",g,m,J;return t=new qe({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBDb2xQYWxpRm9yUmV0cmlldmFsJTJDJTIwQ29sUGFsaVByb2Nlc3NvciUwQSUwQSUwQSUyMyUyMExvYWQlMjB0aGUlMjBtb2RlbCUyMGFuZCUyMHRoZSUyMHByb2Nlc3NvciUwQW1vZGVsX25hbWUlMjAlM0QlMjAlMjJ2aWRvcmUlMkZjb2xwYWxpLXYxLjMtaGYlMjIlMEElMEFtb2RlbCUyMCUzRCUyMENvbFBhbGlGb3JSZXRyaWV2YWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX25hbWUlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjAlMjAlMjMlMjAlMjJjcHUlMjIlMkMlMjAlMjJjdWRhJTIyJTJDJTIwb3IlMjAlMjJtcHMlMjIlMjBmb3IlMjBBcHBsZSUyMFNpbGljb24lMEEpJTBBcHJvY2Vzc29yJTIwJTNEJTIwQ29sUGFsaVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQobW9kZWxfbmFtZSklMEElMEElMjMlMjBUaGUlMjBkb2N1bWVudCUyMHBhZ2UlMjBzY3JlZW5zaG90cyUyMGZyb20lMjB5b3VyJTIwY29ycHVzJTBBdXJsMSUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGdXBsb2FkLndpa2ltZWRpYS5vcmclMkZ3aWtpcGVkaWElMkZjb21tb25zJTJGOCUyRjg5JTJGVVMtb3JpZ2luYWwtRGVjbGFyYXRpb24tMTc3Ni5qcGclMjIlMEF1cmwyJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZ1cGxvYWQud2lraW1lZGlhLm9yZyUyRndpa2lwZWRpYSUyRmNvbW1vbnMlMkZ0aHVtYiUyRjQlMkY0YyUyRlJvbWVvYW5kanVsaWV0MTU5Ny5qcGclMkY1MDBweC1Sb21lb2FuZGp1bGlldDE1OTcuanBnJTIyJTBBJTBBaW1hZ2VzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsMSUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMkMlMEElMjAlMjAlMjAlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwyJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUyQyUwQSU1RCUwQSUwQSUyMyUyMFRoZSUyMHF1ZXJpZXMlMjB5b3UlMjB3YW50JTIwdG8lMjByZXRyaWV2ZSUyMGRvY3VtZW50cyUyMGZvciUwQXF1ZXJpZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJXaGVuJTIwd2FzJTIwdGhlJTIwVW5pdGVkJTIwU3RhdGVzJTIwRGVjbGFyYXRpb24lMjBvZiUyMEluZGVwZW5kZW5jZSUyMHByb2NsYWltZWQlM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJXaG8lMjBwcmludGVkJTIwdGhlJTIwZWRpdGlvbiUyMG9mJTIwUm9tZW8lMjBhbmQlMjBKdWxpZXQlM0YlMjIlMkMlMEElNUQlMEElMEElMjMlMjBQcm9jZXNzJTIwdGhlJTIwaW5wdXRzJTBBaW5wdXRzX2ltYWdlcyUyMCUzRCUyMHByb2Nlc3NvcihpbWFnZXMlM0RpbWFnZXMpLnRvKG1vZGVsLmRldmljZSklMEFpbnB1dHNfdGV4dCUyMCUzRCUyMHByb2Nlc3Nvcih0ZXh0JTNEcXVlcmllcykudG8obW9kZWwuZGV2aWNlKSUwQSUwQSUyMyUyMEZvcndhcmQlMjBwYXNzJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlX2VtYmVkZGluZ3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0c19pbWFnZXMpLmVtYmVkZGluZ3MlMEElMjAlMjAlMjAlMjBxdWVyeV9lbWJlZGRpbmdzJTIwJTNEJTIwbW9kZWwoKippbnB1dHNfdGV4dCkuZW1iZWRkaW5ncyUwQSUwQSUyMyUyMFNjb3JlJTIwdGhlJTIwcXVlcmllcyUyMGFnYWluc3QlMjB0aGUlMjBpbWFnZXMlMEFzY29yZXMlMjAlM0QlMjBwcm9jZXNzb3Iuc2NvcmVfcmV0cmlldmFsKHF1ZXJ5X2VtYmVkZGluZ3MlMkMlMjBpbWFnZV9lbWJlZGRpbmdzKSUwQSUwQXByaW50KCUyMlJldHJpZXZhbCUyMHNjb3JlcyUyMChxdWVyeSUyMHglMjBpbWFnZSklM0ElMjIpJTBBcHJpbnQoc2NvcmVzKQ==",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ColPaliForRetrieval, ColPaliProcessor


<span class="hljs-comment"># Load the model and the processor</span>
model_name = <span class="hljs-string">&quot;vidore/colpali-v1.3-hf&quot;</span>

model = ColPaliForRetrieval.from_pretrained(
    model_name,
    torch_dtype=torch.bfloat16,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,  <span class="hljs-comment"># &quot;cpu&quot;, &quot;cuda&quot;, or &quot;mps&quot; for Apple Silicon</span>
)
processor = ColPaliProcessor.from_pretrained(model_name)

<span class="hljs-comment"># The document page screenshots from your corpus</span>
url1 = <span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/8/89/US-original-Declaration-1776.jpg&quot;</span>
url2 = <span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/4c/Romeoandjuliet1597.jpg/500px-Romeoandjuliet1597.jpg&quot;</span>

images = [
    Image.<span class="hljs-built_in">open</span>(requests.get(url1, stream=<span class="hljs-literal">True</span>).raw),
    Image.<span class="hljs-built_in">open</span>(requests.get(url2, stream=<span class="hljs-literal">True</span>).raw),
]

<span class="hljs-comment"># The queries you want to retrieve documents for</span>
queries = [
    <span class="hljs-string">&quot;When was the United States Declaration of Independence proclaimed?&quot;</span>,
    <span class="hljs-string">&quot;Who printed the edition of Romeo and Juliet?&quot;</span>,
]

<span class="hljs-comment"># Process the inputs</span>
inputs_images = processor(images=images).to(model.device)
inputs_text = processor(text=queries).to(model.device)

<span class="hljs-comment"># Forward pass</span>
<span class="hljs-keyword">with</span> torch.no_grad():
    image_embeddings = model(**inputs_images).embeddings
    query_embeddings = model(**inputs_text).embeddings

<span class="hljs-comment"># Score the queries against the images</span>
scores = processor.score_retrieval(query_embeddings, image_embeddings)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Retrieval scores (query x image):&quot;</span>)
<span class="hljs-built_in">print</span>(scores)`,wrap:!1}}),m=new qe({props:{code:"aW1hZ2VzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwSW1hZ2UubmV3KCUyMlJHQiUyMiUyQyUyMCgxMjglMkMlMjAxMjgpJTJDJTIwY29sb3IlM0QlMjJ3aGl0ZSUyMiklMkMlMEElMjAlMjAlMjAlMjBJbWFnZS5uZXcoJTIyUkdCJTIyJTJDJTIwKDY0JTJDJTIwMzIpJTJDJTIwY29sb3IlM0QlMjJibGFjayUyMiklMkMlMEElNUQ=",highlighted:`images = [
    Image.new(<span class="hljs-string">&quot;RGB&quot;</span>, (<span class="hljs-number">128</span>, <span class="hljs-number">128</span>), color=<span class="hljs-string">&quot;white&quot;</span>),
    Image.new(<span class="hljs-string">&quot;RGB&quot;</span>, (<span class="hljs-number">64</span>, <span class="hljs-number">32</span>), color=<span class="hljs-string">&quot;black&quot;</span>),
]`,wrap:!1}}),{c(){M(t.$$.fragment),h=r(),l=i("p"),l.textContent=p,g=r(),M(m.$$.fragment)},l(f){b(t.$$.fragment,f),h=a(f),l=c(f,"P",{"data-svelte-h":!0}),u(l)!=="svelte-19pwz5p"&&(l.textContent=p),g=a(f),b(m.$$.fragment,f)},m(f,R){y(t,f,R),d(f,h,R),d(f,l,R),d(f,g,R),y(m,f,R),J=!0},p:Ee,i(f){J||(_(t.$$.fragment,f),_(m.$$.fragment,f),J=!0)},o(f){w(t.$$.fragment,f),w(m.$$.fragment,f),J=!1},d(f){f&&(s(h),s(l),s(g)),v(t,f),v(m,f)}}}function vo(P){let t,h;return t=new bo({props:{id:"usage",option:"image retrieval",$$slots:{default:[wo]},$$scope:{ctx:P}}}),{c(){M(t.$$.fragment)},l(l){b(t.$$.fragment,l)},m(l,p){y(t,l,p),h=!0},p(l,p){const g={};p&2&&(g.$$scope={dirty:p,ctx:l}),t.$set(g)},i(l){h||(_(t.$$.fragment,l),h=!0)},o(l){w(t.$$.fragment,l),h=!1},d(l){v(t,l)}}}function To(P){let t,h="Example:",l,p,g;return p=new qe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5tb2RlbHMuY29scGFsaSUyMGltcG9ydCUyMENvbFBhbGlDb25maWclMkMlMjBDb2xQYWxpRm9yUmV0cmlldmFsJTBBJTBBY29uZmlnJTIwJTNEJTIwQ29sUGFsaUNvbmZpZygpJTBBbW9kZWwlMjAlM0QlMjBDb2xQYWxpRm9yUmV0cmlldmFsKGNvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> transformers.models.colpali <span class="hljs-keyword">import</span> ColPaliConfig, ColPaliForRetrieval

config = ColPaliConfig()
model = ColPaliForRetrieval(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=h,l=r(),M(p.$$.fragment)},l(m){t=c(m,"P",{"data-svelte-h":!0}),u(t)!=="svelte-11lpom8"&&(t.textContent=h),l=a(m),b(p.$$.fragment,m)},m(m,J){d(m,t,J),d(m,l,J),y(p,m,J),g=!0},p:Ee,i(m){g||(_(p.$$.fragment,m),g=!0)},o(m){w(p.$$.fragment,m),g=!1},d(m){m&&(s(t),s(l)),v(p,m)}}}function Co(P){let t,h=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=i("p"),t.innerHTML=h},l(l){t=c(l,"P",{"data-svelte-h":!0}),u(t)!=="svelte-fincs2"&&(t.innerHTML=h)},m(l,p){d(l,t,p)},p:Ee,d(l){l&&s(t)}}}function jo(P){let t,h="Example:",l,p,g;return p=new qe({props:{code:"",highlighted:"",wrap:!1}}),{c(){t=i("p"),t.textContent=h,l=r(),M(p.$$.fragment)},l(m){t=c(m,"P",{"data-svelte-h":!0}),u(t)!=="svelte-11lpom8"&&(t.textContent=h),l=a(m),b(p.$$.fragment,m)},m(m,J){d(m,t,J),d(m,l,J),y(p,m,J),g=!0},p:Ee,i(m){g||(_(p.$$.fragment,m),g=!0)},o(m){w(p.$$.fragment,m),g=!1},d(m){m&&(s(t),s(l)),v(p,m)}}}function Jo(P){let t,h,l,p,g,m='<div class="flex flex-wrap space-x-1"><img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/></div>',J,f,R,S,It='<a href="https://huggingface.co/papers/2407.01449" rel="nofollow">ColPali</a> is a model designed to retrieve documents by analyzing their visual features. Unlike traditional systems that rely heavily on text extraction and OCR, ColPali treats each page as an image. It uses <a href="./paligemma">Paligemma-3B</a> to capture not only text, but also the layout, tables, charts, and other visual elements to create detailed multi-vector embeddings that can be used for retrieval by computing pairwise late interaction similarity scores. This offers a more comprehensive understanding of documents and enables more efficient and accurate retrieval.',Xe,Y,Ft='This model was contributed by <a href="https://huggingface.co/tonywu71" rel="nofollow">@tonywu71</a> (ILLUIN Technology) and <a href="https://huggingface.co/yonigozlan" rel="nofollow">@yonigozlan</a> (HuggingFace).',Qe,A,Gt='You can find all the original ColPali checkpoints under Vidore’s <a href="https://huggingface.co/collections/vidore/hf-native-colvision-models-6755d68fc60a8553acaa96f7" rel="nofollow">Hf-native ColVision Models</a> collection.',Le,z,He,q,Ne,D,Vt='Quantization reduces the memory burden of large models by representing the weights in a lower precision. Refer to the <a href="../quantization/overview">Quantization</a> overview for more available quantization backends.',Se,K,zt='The example below uses <a href="../quantization/bitsandbytes.md">bitsandbytes</a> to quantize the weights to int4.',Ye,O,Ae,ee,De,te,qt='<li><a href="/docs/transformers/main/en/model_doc/colpali#transformers.ColPaliProcessor.score_retrieval">score_retrieval()</a> returns a 2D tensor where the first dimension is the number of queries and the second dimension is the number of images. A higher score indicates more similarity between the query and image.</li>',Ke,oe,Oe,$,ne,lt,Me,Et=`Configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/colpali#transformers.ColPaliForRetrieval">ColPaliForRetrieval</a>. It is used to instantiate an instance
of <code>ColPaliForRetrieval</code> according to the specified arguments, defining the model architecture following the methodology
from the “ColPali: Efficient Document Retrieval with Vision Language Models” paper.`,it,be,Xt=`Creating a configuration with the default settings will result in a configuration where the VLM backbone is set to the
default PaliGemma configuration, i.e the one from <a href="https://huggingface.co/vidore/colpali-v1.2" rel="nofollow">vidore/colpali-v1.2</a>.`,ct,ye,Qt=`Note that contrarily to what the class name suggests (actually the name refers to the ColPali <strong>methodology</strong>), you can
use a different VLM backbone model than PaliGemma by passing the corresponding VLM configuration to the class constructor.`,dt,_e,Lt=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,mt,E,et,se,tt,T,re,pt,we,Ht=`Constructs a ColPali processor which wraps a PaliGemmaProcessor and special methods to process images and queries, as
well as to compute the late-interaction retrieval score.`,ut,ve,Nt=`<a href="/docs/transformers/main/en/model_doc/colpali#transformers.ColPaliProcessor">ColPaliProcessor</a> offers all the functionalities of <a href="/docs/transformers/main/en/model_doc/paligemma#transformers.PaliGemmaProcessor">PaliGemmaProcessor</a>. See the <code>__call__()</code>
for more information.`,ft,X,ae,ht,Te,St=`This method forwards all its arguments to GemmaTokenizerFast’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.batch_decode">batch_decode()</a>. Please
refer to the docstring of this method for more information.`,gt,Q,le,Mt,Ce,Yt=`This method forwards all its arguments to GemmaTokenizerFast’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.decode">decode()</a>. Please refer to
the docstring of this method for more information.`,bt,W,ie,yt,je,At=`Prepare for the model one or several image(s). This method is a wrapper around the <code>__call__</code> method of the ColPaliProcessor’s
<code>ColPaliProcessor.__call__()</code>.`,_t,Je,Dt="This method forwards the <code>images</code> and <code>kwargs</code> arguments to the image processor.",wt,I,ce,vt,$e,Kt=`Prepare for the model one or several texts. This method is a wrapper around the <code>__call__</code> method of the ColPaliProcessor’s
<code>ColPaliProcessor.__call__()</code>.`,Tt,Ue,Ot="This method forwards the <code>text</code> and <code>kwargs</code> arguments to the tokenizer.",Ct,F,de,jt,Pe,eo=`Compute the late-interaction/MaxSim score (ColBERT-like) for the given multi-vector
query embeddings (<code>qs</code>) and passage embeddings (<code>ps</code>). For ColPali, a passage is the
image of a document page.`,Jt,ke,to=`Because the embedding tensors are multi-vector and can thus have different shapes, they
should be fed as:
(1) a list of tensors, where the i-th tensor is of shape (sequence_length_i, embedding_dim)
(2) a single tensor of shape (n_passages, max_sequence_length, embedding_dim) -> usually
obtained by padding the list of tensors.`,ot,me,nt,C,pe,$t,xe,oo=`The ColPali architecture leverages VLMs to construct efficient multi-vector embeddings directly
from document images (“screenshots”) for document retrieval. The model is trained to maximize the similarity
between these document embeddings and the corresponding query embeddings, using the late interaction method
introduced in ColBERT.`,Ut,Ze,no=`Using ColPali removes the need for potentially complex and brittle layout recognition and OCR pipelines with a
single model that can take into account both the textual and visual content (layout, charts, etc.) of a document.`,Pt,Be,so=`ColPali is part of the ColVision model family, which was first introduced in the following paper:
<a href="https://arxiv.org/abs/2407.01449" rel="nofollow"><em>ColPali: Efficient Document Retrieval with Vision Language Models</em></a>.`,kt,Re,ro=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,xt,We,ao=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Zt,x,ue,Bt,Ie,lo='The <a href="/docs/transformers/main/en/model_doc/colpali#transformers.ColPaliForRetrieval">ColPaliForRetrieval</a> forward method, overrides the <code>__call__</code> special method.',Rt,L,Wt,H,st,fe,rt,Ve,at;return f=new ze({props:{title:"ColPali",local:"colpali",headingTag:"h1"}}),z=new io({props:{warning:!1,$$slots:{default:[_o]},$$scope:{ctx:P}}}),q=new Mo({props:{id:"usage",options:["image retrieval"],$$slots:{default:[vo]},$$scope:{ctx:P}}}),O=new qe({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig, ColPaliForRetrieval, ColPaliProcessor


model_name = <span class="hljs-string">&quot;vidore/colpali-v1.3-hf&quot;</span>

<span class="hljs-comment"># 4-bit quantization configuration</span>
bnb_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
    bnb_4bit_compute_dtype=torch.float16,
)

model = ColPaliForRetrieval.from_pretrained(
    model_name,
    quantization_config=bnb_config,
    device_map=<span class="hljs-string">&quot;cuda&quot;</span>,
)

processor = ColPaliProcessor.from_pretrained(model_name)

url1 = <span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/8/89/US-original-Declaration-1776.jpg&quot;</span>
url2 = <span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/4c/Romeoandjuliet1597.jpg/500px-Romeoandjuliet1597.jpg&quot;</span>

images = [
    Image.<span class="hljs-built_in">open</span>(requests.get(url1, stream=<span class="hljs-literal">True</span>).raw),
    Image.<span class="hljs-built_in">open</span>(requests.get(url2, stream=<span class="hljs-literal">True</span>).raw),
]

queries = [
    <span class="hljs-string">&quot;When was the United States Declaration of Independence proclaimed?&quot;</span>,
    <span class="hljs-string">&quot;Who printed the edition of Romeo and Juliet?&quot;</span>,
]

<span class="hljs-comment"># Process the inputs</span>
inputs_images = processor(images=images, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)
inputs_text = processor(text=queries, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)

<span class="hljs-comment"># Forward pass</span>
<span class="hljs-keyword">with</span> torch.no_grad():
    image_embeddings = model(**inputs_images).embeddings
    query_embeddings = model(**inputs_text).embeddings

<span class="hljs-comment"># Score the queries against the images</span>
scores = processor.score_retrieval(query_embeddings, image_embeddings)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Retrieval scores (query x image):&quot;</span>)
<span class="hljs-built_in">print</span>(scores)`,wrap:!1}}),ee=new ze({props:{title:"Notes",local:"notes",headingTag:"h2"}}),oe=new ze({props:{title:"ColPaliConfig",local:"transformers.ColPaliConfig",headingTag:"h2"}}),ne=new V({props:{name:"class transformers.ColPaliConfig",anchor:"transformers.ColPaliConfig",parameters:[{name:"vlm_config",val:" = None"},{name:"text_config",val:" = None"},{name:"embedding_dim",val:": int = 128"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ColPaliConfig.vlm_config",description:`<strong>vlm_config</strong> (<code>PretrainedConfig</code>, <em>optional</em>) &#x2014;
Configuration of the VLM backbone model.`,name:"vlm_config"},{anchor:"transformers.ColPaliConfig.text_config",description:`<strong>text_config</strong> (<code>PretrainedConfig</code>, <em>optional</em>) &#x2014;
Configuration of the text backbone model. Overrides the <code>text_config</code> attribute of the <code>vlm_config</code> if provided.`,name:"text_config"},{anchor:"transformers.ColPaliConfig.embedding_dim",description:`<strong>embedding_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
Dimension of the multi-vector embeddings produced by the model.`,name:"embedding_dim"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/colpali/configuration_colpali.py#L27"}}),E=new co({props:{anchor:"transformers.ColPaliConfig.example",$$slots:{default:[To]},$$scope:{ctx:P}}}),se=new ze({props:{title:"ColPaliProcessor",local:"transformers.ColPaliProcessor",headingTag:"h2"}}),re=new V({props:{name:"class transformers.ColPaliProcessor",anchor:"transformers.ColPaliProcessor",parameters:[{name:"image_processor",val:" = None"},{name:"tokenizer",val:" = None"},{name:"chat_template",val:" = None"},{name:"visual_prompt_prefix",val:": str = 'Describe the image.'"},{name:"query_prefix",val:": str = 'Question: '"}],parametersDescription:[{anchor:"transformers.ColPaliProcessor.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/main/en/model_doc/siglip#transformers.SiglipImageProcessor">SiglipImageProcessor</a>, <em>optional</em>) &#x2014;
The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.ColPaliProcessor.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>, <em>optional</em>) &#x2014;
The tokenizer is a required input.`,name:"tokenizer"},{anchor:"transformers.ColPaliProcessor.chat_template",description:`<strong>chat_template</strong> (<code>str</code>, <em>optional</em>) &#x2014; A Jinja template which will be used to convert lists of messages
in a chat into a tokenizable string.`,name:"chat_template"},{anchor:"transformers.ColPaliProcessor.visual_prompt_prefix",description:`<strong>visual_prompt_prefix</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;Describe the image.&quot;</code>) &#x2014;
A string that gets tokenized and prepended to the image tokens.`,name:"visual_prompt_prefix"},{anchor:"transformers.ColPaliProcessor.query_prefix",description:`<strong>query_prefix</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;Question -- &quot;</code>):
A prefix to be used for the query.`,name:"query_prefix"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/colpali/processing_colpali.py#L75"}}),ae=new V({props:{name:"batch_decode",anchor:"transformers.ColPaliProcessor.batch_decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/colpali/processing_colpali.py#L278"}}),le=new V({props:{name:"decode",anchor:"transformers.ColPaliProcessor.decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/colpali/processing_colpali.py#L285"}}),ie=new V({props:{name:"process_images",anchor:"transformers.ColPaliProcessor.process_images",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']] = None"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.colpali.processing_colpali.ColPaliProcessorKwargs]"}],parametersDescription:[{anchor:"transformers.ColPaliProcessor.process_images.images",description:`<strong>images</strong> (<code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>torch.Tensor</code>, <code>List[PIL.Image.Image]</code>, <code>List[np.ndarray]</code>, <code>List[torch.Tensor]</code>) &#x2014;
The image or batch of images to be prepared. Each image can be a PIL image, NumPy array or PyTorch
tensor. In case of a NumPy array/PyTorch tensor, each image should be of shape (C, H, W), where C is a
number of channels, H and W are image height and width.`,name:"images"},{anchor:"transformers.ColPaliProcessor.process_images.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/main/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>) &#x2014;
If set, will return tensors of a particular framework. Acceptable values are:</p>
<ul>
<li><code>&apos;tf&apos;</code>: Return TensorFlow <code>tf.constant</code> objects.</li>
<li><code>&apos;pt&apos;</code>: Return PyTorch <code>torch.Tensor</code> objects.</li>
<li><code>&apos;np&apos;</code>: Return NumPy <code>np.ndarray</code> objects.</li>
<li><code>&apos;jax&apos;</code>: Return JAX <code>jnp.ndarray</code> objects.</li>
</ul>`,name:"return_tensors"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/colpali/processing_colpali.py#L307",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/feature_extractor#transformers.BatchFeature"
>BatchFeature</a> with the following fields:</p>
<ul>
<li><strong>input_ids</strong> — List of token ids to be fed to a model.</li>
<li><strong>attention_mask</strong> — List of indices specifying which tokens should be attended to by the model (when
<code>return_attention_mask=True</code> or if <em>“attention_mask”</em> is in <code>self.model_input_names</code> and if <code>text</code> is not
<code>None</code>).</li>
<li><strong>pixel_values</strong> — Pixel values to be fed to a model. Returned when <code>images</code> is not <code>None</code>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/feature_extractor#transformers.BatchFeature"
>BatchFeature</a></p>
`}}),ce=new V({props:{name:"process_queries",anchor:"transformers.ColPaliProcessor.process_queries",parameters:[{name:"text",val:": typing.Union[str, typing.List[str]]"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.colpali.processing_colpali.ColPaliProcessorKwargs]"}],parametersDescription:[{anchor:"transformers.ColPaliProcessor.process_queries.text",description:`<strong>text</strong> (<code>str</code>, <code>List[str]</code>, <code>List[List[str]]</code>) &#x2014;
The sequence or batch of sequences to be encoded. Each sequence can be a string or a list of strings
(pretokenized string). If the sequences are provided as list of strings (pretokenized), you must set
<code>is_split_into_words=True</code> (to lift the ambiguity with a batch of sequences).`,name:"text"},{anchor:"transformers.ColPaliProcessor.process_queries.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/main/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>) &#x2014;
If set, will return tensors of a particular framework. Acceptable values are:</p>
<ul>
<li><code>&apos;tf&apos;</code>: Return TensorFlow <code>tf.constant</code> objects.</li>
<li><code>&apos;pt&apos;</code>: Return PyTorch <code>torch.Tensor</code> objects.</li>
<li><code>&apos;np&apos;</code>: Return NumPy <code>np.ndarray</code> objects.</li>
<li><code>&apos;jax&apos;</code>: Return JAX <code>jnp.ndarray</code> objects.</li>
</ul>`,name:"return_tensors"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/colpali/processing_colpali.py#L342",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/feature_extractor#transformers.BatchFeature"
>BatchFeature</a> with the following fields:</p>
<ul>
<li><strong>input_ids</strong> — List of token ids to be fed to a model.</li>
<li><strong>attention_mask</strong> — List of indices specifying which tokens should be attended to by the model (when
<code>return_attention_mask=True</code> or if <em>“attention_mask”</em> is in <code>self.model_input_names</code> and if <code>text</code> is not
<code>None</code>).</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/feature_extractor#transformers.BatchFeature"
>BatchFeature</a></p>
`}}),de=new V({props:{name:"score_retrieval",anchor:"transformers.ColPaliProcessor.score_retrieval",parameters:[{name:"query_embeddings",val:": typing.Union[ForwardRef('torch.Tensor'), typing.List[ForwardRef('torch.Tensor')]]"},{name:"passage_embeddings",val:": typing.Union[ForwardRef('torch.Tensor'), typing.List[ForwardRef('torch.Tensor')]]"},{name:"batch_size",val:": int = 128"},{name:"output_dtype",val:": typing.Optional[ForwardRef('torch.dtype')] = None"},{name:"output_device",val:": typing.Union[ForwardRef('torch.device'), str] = 'cpu'"}],parametersDescription:[{anchor:"transformers.ColPaliProcessor.score_retrieval.query_embeddings",description:"<strong>query_embeddings</strong> (<code>Union[torch.Tensor, List[torch.Tensor]</code>) &#x2014; Query embeddings.",name:"query_embeddings"},{anchor:"transformers.ColPaliProcessor.score_retrieval.passage_embeddings",description:"<strong>passage_embeddings</strong> (<code>Union[torch.Tensor, List[torch.Tensor]</code>) &#x2014; Passage embeddings.",name:"passage_embeddings"},{anchor:"transformers.ColPaliProcessor.score_retrieval.batch_size",description:"<strong>batch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014; Batch size for computing scores.",name:"batch_size"},{anchor:"transformers.ColPaliProcessor.score_retrieval.output_dtype",description:`<strong>output_dtype</strong> (<code>torch.dtype</code>, <em>optional</em>, defaults to <code>torch.float32</code>) &#x2014; The dtype of the output tensor.
If <code>None</code>, the dtype of the input embeddings is used.`,name:"output_dtype"},{anchor:"transformers.ColPaliProcessor.score_retrieval.output_device",description:"<strong>output_device</strong> (<code>torch.device</code> or <code>str</code>, <em>optional</em>, defaults to &#x201C;cpu&#x201D;) &#x2014; The device of the output tensor.",name:"output_device"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/colpali/processing_colpali.py#L376",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape <code>(n_queries, n_passages)</code> containing the scores. The score
tensor is saved on the “cpu” device.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code></p>
`}}),me=new ze({props:{title:"ColPaliForRetrieval",local:"transformers.ColPaliForRetrieval",headingTag:"h2"}}),pe=new V({props:{name:"class transformers.ColPaliForRetrieval",anchor:"transformers.ColPaliForRetrieval",parameters:[{name:"config",val:": ColPaliConfig"}],parametersDescription:[{anchor:"transformers.ColPaliForRetrieval.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/colpali#transformers.ColPaliConfig">ColPaliConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/colpali/modeling_colpali.py#L93"}}),ue=new V({props:{name:"forward",anchor:"transformers.ColPaliForRetrieval.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ColPaliForRetrieval.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ColPaliForRetrieval.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>, <em>optional</em>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.ColPaliForRetrieval.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.ColPaliForRetrieval.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ColPaliForRetrieval.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ColPaliForRetrieval.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/colpali/modeling_colpali.py#L126",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.colpali.modeling_colpali.ColPaliForRetrievalOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/colpali#transformers.ColPaliConfig"
>ColPaliConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>embeddings</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — The embeddings of the model.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>image_hidden_states</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) — A <code>torch.FloatTensor</code> of size <code>(batch_size, num_images, sequence_length, hidden_size)</code>.
image_hidden_states of the model produced by the vision encoder after projecting last hidden state.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.colpali.modeling_colpali.ColPaliForRetrievalOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),L=new io({props:{$$slots:{default:[Co]},$$scope:{ctx:P}}}),H=new co({props:{anchor:"transformers.ColPaliForRetrieval.forward.example",$$slots:{default:[jo]},$$scope:{ctx:P}}}),fe=new yo({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/colpali.md"}}),{c(){t=i("meta"),h=r(),l=i("p"),p=r(),g=i("div"),g.innerHTML=m,J=r(),M(f.$$.fragment),R=r(),S=i("p"),S.innerHTML=It,Xe=r(),Y=i("p"),Y.innerHTML=Ft,Qe=r(),A=i("p"),A.innerHTML=Gt,Le=r(),M(z.$$.fragment),He=r(),M(q.$$.fragment),Ne=r(),D=i("p"),D.innerHTML=Vt,Se=r(),K=i("p"),K.innerHTML=zt,Ye=r(),M(O.$$.fragment),Ae=r(),M(ee.$$.fragment),De=r(),te=i("ul"),te.innerHTML=qt,Ke=r(),M(oe.$$.fragment),Oe=r(),$=i("div"),M(ne.$$.fragment),lt=r(),Me=i("p"),Me.innerHTML=Et,it=r(),be=i("p"),be.innerHTML=Xt,ct=r(),ye=i("p"),ye.innerHTML=Qt,dt=r(),_e=i("p"),_e.innerHTML=Lt,mt=r(),M(E.$$.fragment),et=r(),M(se.$$.fragment),tt=r(),T=i("div"),M(re.$$.fragment),pt=r(),we=i("p"),we.textContent=Ht,ut=r(),ve=i("p"),ve.innerHTML=Nt,ft=r(),X=i("div"),M(ae.$$.fragment),ht=r(),Te=i("p"),Te.innerHTML=St,gt=r(),Q=i("div"),M(le.$$.fragment),Mt=r(),Ce=i("p"),Ce.innerHTML=Yt,bt=r(),W=i("div"),M(ie.$$.fragment),yt=r(),je=i("p"),je.innerHTML=At,_t=r(),Je=i("p"),Je.innerHTML=Dt,wt=r(),I=i("div"),M(ce.$$.fragment),vt=r(),$e=i("p"),$e.innerHTML=Kt,Tt=r(),Ue=i("p"),Ue.innerHTML=Ot,Ct=r(),F=i("div"),M(de.$$.fragment),jt=r(),Pe=i("p"),Pe.innerHTML=eo,Jt=r(),ke=i("p"),ke.textContent=to,ot=r(),M(me.$$.fragment),nt=r(),C=i("div"),M(pe.$$.fragment),$t=r(),xe=i("p"),xe.textContent=oo,Ut=r(),Ze=i("p"),Ze.textContent=no,Pt=r(),Be=i("p"),Be.innerHTML=so,kt=r(),Re=i("p"),Re.innerHTML=ro,xt=r(),We=i("p"),We.innerHTML=ao,Zt=r(),x=i("div"),M(ue.$$.fragment),Bt=r(),Ie=i("p"),Ie.innerHTML=lo,Rt=r(),M(L.$$.fragment),Wt=r(),M(H.$$.fragment),st=r(),M(fe.$$.fragment),rt=r(),Ve=i("p"),this.h()},l(e){const o=ho("svelte-u9bgzb",document.head);t=c(o,"META",{name:!0,content:!0}),o.forEach(s),h=a(e),l=c(e,"P",{}),Z(l).forEach(s),p=a(e),g=c(e,"DIV",{style:!0,"data-svelte-h":!0}),u(g)!=="svelte-wa5t4p"&&(g.innerHTML=m),J=a(e),b(f.$$.fragment,e),R=a(e),S=c(e,"P",{"data-svelte-h":!0}),u(S)!=="svelte-zfv536"&&(S.innerHTML=It),Xe=a(e),Y=c(e,"P",{"data-svelte-h":!0}),u(Y)!=="svelte-1usq28k"&&(Y.innerHTML=Ft),Qe=a(e),A=c(e,"P",{"data-svelte-h":!0}),u(A)!=="svelte-st4jp7"&&(A.innerHTML=Gt),Le=a(e),b(z.$$.fragment,e),He=a(e),b(q.$$.fragment,e),Ne=a(e),D=c(e,"P",{"data-svelte-h":!0}),u(D)!=="svelte-nf5ooi"&&(D.innerHTML=Vt),Se=a(e),K=c(e,"P",{"data-svelte-h":!0}),u(K)!=="svelte-1u51sr7"&&(K.innerHTML=zt),Ye=a(e),b(O.$$.fragment,e),Ae=a(e),b(ee.$$.fragment,e),De=a(e),te=c(e,"UL",{"data-svelte-h":!0}),u(te)!=="svelte-1zb4tp"&&(te.innerHTML=qt),Ke=a(e),b(oe.$$.fragment,e),Oe=a(e),$=c(e,"DIV",{class:!0});var U=Z($);b(ne.$$.fragment,U),lt=a(U),Me=c(U,"P",{"data-svelte-h":!0}),u(Me)!=="svelte-bap4zu"&&(Me.innerHTML=Et),it=a(U),be=c(U,"P",{"data-svelte-h":!0}),u(be)!=="svelte-1fyeyvm"&&(be.innerHTML=Xt),ct=a(U),ye=c(U,"P",{"data-svelte-h":!0}),u(ye)!=="svelte-bnl7k3"&&(ye.innerHTML=Qt),dt=a(U),_e=c(U,"P",{"data-svelte-h":!0}),u(_e)!=="svelte-o55m63"&&(_e.innerHTML=Lt),mt=a(U),b(E.$$.fragment,U),U.forEach(s),et=a(e),b(se.$$.fragment,e),tt=a(e),T=c(e,"DIV",{class:!0});var j=Z(T);b(re.$$.fragment,j),pt=a(j),we=c(j,"P",{"data-svelte-h":!0}),u(we)!=="svelte-1xjue1y"&&(we.textContent=Ht),ut=a(j),ve=c(j,"P",{"data-svelte-h":!0}),u(ve)!=="svelte-1gyme3e"&&(ve.innerHTML=Nt),ft=a(j),X=c(j,"DIV",{class:!0});var he=Z(X);b(ae.$$.fragment,he),ht=a(he),Te=c(he,"P",{"data-svelte-h":!0}),u(Te)!=="svelte-4dbgxy"&&(Te.innerHTML=St),he.forEach(s),gt=a(j),Q=c(j,"DIV",{class:!0});var ge=Z(Q);b(le.$$.fragment,ge),Mt=a(ge),Ce=c(ge,"P",{"data-svelte-h":!0}),u(Ce)!=="svelte-1ha4zc4"&&(Ce.innerHTML=Yt),ge.forEach(s),bt=a(j),W=c(j,"DIV",{class:!0});var G=Z(W);b(ie.$$.fragment,G),yt=a(G),je=c(G,"P",{"data-svelte-h":!0}),u(je)!=="svelte-1gls1hp"&&(je.innerHTML=At),_t=a(G),Je=c(G,"P",{"data-svelte-h":!0}),u(Je)!=="svelte-1at6zp"&&(Je.innerHTML=Dt),G.forEach(s),wt=a(j),I=c(j,"DIV",{class:!0});var Fe=Z(I);b(ce.$$.fragment,Fe),vt=a(Fe),$e=c(Fe,"P",{"data-svelte-h":!0}),u($e)!=="svelte-d7fz8o"&&($e.innerHTML=Kt),Tt=a(Fe),Ue=c(Fe,"P",{"data-svelte-h":!0}),u(Ue)!=="svelte-1y7x5ok"&&(Ue.innerHTML=Ot),Fe.forEach(s),Ct=a(j),F=c(j,"DIV",{class:!0});var Ge=Z(F);b(de.$$.fragment,Ge),jt=a(Ge),Pe=c(Ge,"P",{"data-svelte-h":!0}),u(Pe)!=="svelte-1728slr"&&(Pe.innerHTML=eo),Jt=a(Ge),ke=c(Ge,"P",{"data-svelte-h":!0}),u(ke)!=="svelte-3nd4tx"&&(ke.textContent=to),Ge.forEach(s),j.forEach(s),ot=a(e),b(me.$$.fragment,e),nt=a(e),C=c(e,"DIV",{class:!0});var k=Z(C);b(pe.$$.fragment,k),$t=a(k),xe=c(k,"P",{"data-svelte-h":!0}),u(xe)!=="svelte-2l0au6"&&(xe.textContent=oo),Ut=a(k),Ze=c(k,"P",{"data-svelte-h":!0}),u(Ze)!=="svelte-rxcp7f"&&(Ze.textContent=no),Pt=a(k),Be=c(k,"P",{"data-svelte-h":!0}),u(Be)!=="svelte-ef48gi"&&(Be.innerHTML=so),kt=a(k),Re=c(k,"P",{"data-svelte-h":!0}),u(Re)!=="svelte-6pahdo"&&(Re.innerHTML=ro),xt=a(k),We=c(k,"P",{"data-svelte-h":!0}),u(We)!=="svelte-hswkmf"&&(We.innerHTML=ao),Zt=a(k),x=c(k,"DIV",{class:!0});var N=Z(x);b(ue.$$.fragment,N),Bt=a(N),Ie=c(N,"P",{"data-svelte-h":!0}),u(Ie)!=="svelte-1cncon1"&&(Ie.innerHTML=lo),Rt=a(N),b(L.$$.fragment,N),Wt=a(N),b(H.$$.fragment,N),N.forEach(s),k.forEach(s),st=a(e),b(fe.$$.fragment,e),rt=a(e),Ve=c(e,"P",{}),Z(Ve).forEach(s),this.h()},h(){B(t,"name","hf:doc:metadata"),B(t,"content",$o),go(g,"float","right"),B($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),B(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),B(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),B(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),B(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),B(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),B(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),B(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),B(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,o){n(document.head,t),d(e,h,o),d(e,l,o),d(e,p,o),d(e,g,o),d(e,J,o),y(f,e,o),d(e,R,o),d(e,S,o),d(e,Xe,o),d(e,Y,o),d(e,Qe,o),d(e,A,o),d(e,Le,o),y(z,e,o),d(e,He,o),y(q,e,o),d(e,Ne,o),d(e,D,o),d(e,Se,o),d(e,K,o),d(e,Ye,o),y(O,e,o),d(e,Ae,o),y(ee,e,o),d(e,De,o),d(e,te,o),d(e,Ke,o),y(oe,e,o),d(e,Oe,o),d(e,$,o),y(ne,$,null),n($,lt),n($,Me),n($,it),n($,be),n($,ct),n($,ye),n($,dt),n($,_e),n($,mt),y(E,$,null),d(e,et,o),y(se,e,o),d(e,tt,o),d(e,T,o),y(re,T,null),n(T,pt),n(T,we),n(T,ut),n(T,ve),n(T,ft),n(T,X),y(ae,X,null),n(X,ht),n(X,Te),n(T,gt),n(T,Q),y(le,Q,null),n(Q,Mt),n(Q,Ce),n(T,bt),n(T,W),y(ie,W,null),n(W,yt),n(W,je),n(W,_t),n(W,Je),n(T,wt),n(T,I),y(ce,I,null),n(I,vt),n(I,$e),n(I,Tt),n(I,Ue),n(T,Ct),n(T,F),y(de,F,null),n(F,jt),n(F,Pe),n(F,Jt),n(F,ke),d(e,ot,o),y(me,e,o),d(e,nt,o),d(e,C,o),y(pe,C,null),n(C,$t),n(C,xe),n(C,Ut),n(C,Ze),n(C,Pt),n(C,Be),n(C,kt),n(C,Re),n(C,xt),n(C,We),n(C,Zt),n(C,x),y(ue,x,null),n(x,Bt),n(x,Ie),n(x,Rt),y(L,x,null),n(x,Wt),y(H,x,null),d(e,st,o),y(fe,e,o),d(e,rt,o),d(e,Ve,o),at=!0},p(e,[o]){const U={};o&2&&(U.$$scope={dirty:o,ctx:e}),z.$set(U);const j={};o&2&&(j.$$scope={dirty:o,ctx:e}),q.$set(j);const he={};o&2&&(he.$$scope={dirty:o,ctx:e}),E.$set(he);const ge={};o&2&&(ge.$$scope={dirty:o,ctx:e}),L.$set(ge);const G={};o&2&&(G.$$scope={dirty:o,ctx:e}),H.$set(G)},i(e){at||(_(f.$$.fragment,e),_(z.$$.fragment,e),_(q.$$.fragment,e),_(O.$$.fragment,e),_(ee.$$.fragment,e),_(oe.$$.fragment,e),_(ne.$$.fragment,e),_(E.$$.fragment,e),_(se.$$.fragment,e),_(re.$$.fragment,e),_(ae.$$.fragment,e),_(le.$$.fragment,e),_(ie.$$.fragment,e),_(ce.$$.fragment,e),_(de.$$.fragment,e),_(me.$$.fragment,e),_(pe.$$.fragment,e),_(ue.$$.fragment,e),_(L.$$.fragment,e),_(H.$$.fragment,e),_(fe.$$.fragment,e),at=!0)},o(e){w(f.$$.fragment,e),w(z.$$.fragment,e),w(q.$$.fragment,e),w(O.$$.fragment,e),w(ee.$$.fragment,e),w(oe.$$.fragment,e),w(ne.$$.fragment,e),w(E.$$.fragment,e),w(se.$$.fragment,e),w(re.$$.fragment,e),w(ae.$$.fragment,e),w(le.$$.fragment,e),w(ie.$$.fragment,e),w(ce.$$.fragment,e),w(de.$$.fragment,e),w(me.$$.fragment,e),w(pe.$$.fragment,e),w(ue.$$.fragment,e),w(L.$$.fragment,e),w(H.$$.fragment,e),w(fe.$$.fragment,e),at=!1},d(e){e&&(s(h),s(l),s(p),s(g),s(J),s(R),s(S),s(Xe),s(Y),s(Qe),s(A),s(Le),s(He),s(Ne),s(D),s(Se),s(K),s(Ye),s(Ae),s(De),s(te),s(Ke),s(Oe),s($),s(et),s(tt),s(T),s(ot),s(nt),s(C),s(st),s(rt),s(Ve)),s(t),v(f,e),v(z,e),v(q,e),v(O,e),v(ee,e),v(oe,e),v(ne),v(E),v(se,e),v(re),v(ae),v(le),v(ie),v(ce),v(de),v(me,e),v(pe),v(ue),v(L),v(H),v(fe,e)}}}const $o='{"title":"ColPali","local":"colpali","sections":[{"title":"Notes","local":"notes","sections":[],"depth":2},{"title":"ColPaliConfig","local":"transformers.ColPaliConfig","sections":[],"depth":2},{"title":"ColPaliProcessor","local":"transformers.ColPaliProcessor","sections":[],"depth":2},{"title":"ColPaliForRetrieval","local":"transformers.ColPaliForRetrieval","sections":[],"depth":2}],"depth":1}';function Uo(P){return po(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Go extends uo{constructor(t){super(),fo(this,t,Uo,Jo,mo,{})}}export{Go as component};
