import{s as lo,o as io,n as Xe}from"../chunks/scheduler.18a86fab.js";import{S as co,i as mo,g as i,s as r,r as w,A as po,h as c,f as n,c as a,j as x,x as u,u as y,k as I,l as uo,y as s,a as d,v as b,d as _,t as M,w as T}from"../chunks/index.98837b22.js";import{T as ro}from"../chunks/Tip.77304350.js";import{D as z}from"../chunks/Docstring.6758ea23.js";import{C as Ve}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as ao}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as ze}from"../chunks/Heading.7e7e0c5b.js";import{H as ho,a as fo}from"../chunks/HfOption.6641485e.js";import{E as go}from"../chunks/getInferenceSnippets.de10bc7d.js";function wo(U){let t,f="Click on the ColQwen2 models in the right sidebar for more examples of how to use ColQwen2 for image retrieval.";return{c(){t=i("p"),t.textContent=f},l(l){t=c(l,"P",{"data-svelte-h":!0}),u(t)!=="svelte-2qyslm"&&(t.textContent=f)},m(l,p){d(l,t,p)},p:Xe,d(l){l&&n(t)}}}function yo(U){let t,f,l,p="If you have issue with loading the images with PIL, you can use the following code to create dummy images:",g,m,j;return t=new Ve({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ColQwen2ForRetrieval, ColQwen2Processor
<span class="hljs-keyword">from</span> transformers.utils.import_utils <span class="hljs-keyword">import</span> is_flash_attn_2_available


<span class="hljs-comment"># Load the model and the processor</span>
model_name = <span class="hljs-string">&quot;vidore/colqwen2-v1.0-hf&quot;</span>

model = ColQwen2ForRetrieval.from_pretrained(
    model_name,
    torch_dtype=torch.bfloat16,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,  <span class="hljs-comment"># &quot;cpu&quot;, &quot;cuda&quot;, or &quot;mps&quot; for Apple Silicon</span>
    attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span> <span class="hljs-keyword">if</span> is_flash_attn_2_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;sdpa&quot;</span>,
)
processor = ColQwen2Processor.from_pretrained(model_name)

<span class="hljs-comment"># The document page screenshots from your corpus</span>
url1 = <span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/8/89/US-original-Declaration-1776.jpg&quot;</span>
url2 = <span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/4c/Romeoandjuliet1597.jpg/500px-Romeoandjuliet1597.jpg&quot;</span>

images = [
    Image.<span class="hljs-built_in">open</span>(requests.get(url1, stream=<span class="hljs-literal">True</span>).raw),
    Image.<span class="hljs-built_in">open</span>(requests.get(url2, stream=<span class="hljs-literal">True</span>).raw),
]

<span class="hljs-comment"># The queries you want to retrieve documents for</span>
queries = [
    <span class="hljs-string">&quot;When was the United States Declaration of Independence proclaimed?&quot;</span>,
    <span class="hljs-string">&quot;Who printed the edition of Romeo and Juliet?&quot;</span>,
]

<span class="hljs-comment"># Process the inputs</span>
inputs_images = processor(images=images).to(model.device)
inputs_text = processor(text=queries).to(model.device)

<span class="hljs-comment"># Forward pass</span>
<span class="hljs-keyword">with</span> torch.no_grad():
    image_embeddings = model(**inputs_images).embeddings
    query_embeddings = model(**inputs_text).embeddings

<span class="hljs-comment"># Score the queries against the images</span>
scores = processor.score_retrieval(query_embeddings, image_embeddings)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Retrieval scores (query x image):&quot;</span>)
<span class="hljs-built_in">print</span>(scores)`,wrap:!1}}),m=new Ve({props:{code:"aW1hZ2VzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwSW1hZ2UubmV3KCUyMlJHQiUyMiUyQyUyMCgxMjglMkMlMjAxMjgpJTJDJTIwY29sb3IlM0QlMjJ3aGl0ZSUyMiklMkMlMEElMjAlMjAlMjAlMjBJbWFnZS5uZXcoJTIyUkdCJTIyJTJDJTIwKDY0JTJDJTIwMzIpJTJDJTIwY29sb3IlM0QlMjJibGFjayUyMiklMkMlMEElNUQ=",highlighted:`images = [
    Image.new(<span class="hljs-string">&quot;RGB&quot;</span>, (<span class="hljs-number">128</span>, <span class="hljs-number">128</span>), color=<span class="hljs-string">&quot;white&quot;</span>),
    Image.new(<span class="hljs-string">&quot;RGB&quot;</span>, (<span class="hljs-number">64</span>, <span class="hljs-number">32</span>), color=<span class="hljs-string">&quot;black&quot;</span>),
]`,wrap:!1}}),{c(){w(t.$$.fragment),f=r(),l=i("p"),l.textContent=p,g=r(),w(m.$$.fragment)},l(h){y(t.$$.fragment,h),f=a(h),l=c(h,"P",{"data-svelte-h":!0}),u(l)!=="svelte-19pwz5p"&&(l.textContent=p),g=a(h),y(m.$$.fragment,h)},m(h,B){b(t,h,B),d(h,f,B),d(h,l,B),d(h,g,B),b(m,h,B),j=!0},p:Xe,i(h){j||(_(t.$$.fragment,h),_(m.$$.fragment,h),j=!0)},o(h){M(t.$$.fragment,h),M(m.$$.fragment,h),j=!1},d(h){h&&(n(f),n(l),n(g)),T(t,h),T(m,h)}}}function bo(U){let t,f;return t=new fo({props:{id:"usage",option:"image retrieval",$$slots:{default:[yo]},$$scope:{ctx:U}}}),{c(){w(t.$$.fragment)},l(l){y(t.$$.fragment,l)},m(l,p){b(t,l,p),f=!0},p(l,p){const g={};p&2&&(g.$$scope={dirty:p,ctx:l}),t.$set(g)},i(l){f||(_(t.$$.fragment,l),f=!0)},o(l){M(t.$$.fragment,l),f=!1},d(l){T(t,l)}}}function _o(U){let t,f="Example:",l,p,g;return p=new Ve({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5tb2RlbHMuY29scXdlbjIlMjBpbXBvcnQlMjBDb2xRd2VuMkNvbmZpZyUyQyUyMENvbFF3ZW4yRm9yUmV0cmlldmFsJTBBJTBBY29uZmlnJTIwJTNEJTIwQ29sUXdlbjJDb25maWcoKSUwQW1vZGVsJTIwJTNEJTIwQ29sUXdlbjJGb3JSZXRyaWV2YWwoY29uZmlnKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers.models.colqwen2 <span class="hljs-keyword">import</span> ColQwen2Config, ColQwen2ForRetrieval

config = ColQwen2Config()
model = ColQwen2ForRetrieval(config)`,wrap:!1}}),{c(){t=i("p"),t.textContent=f,l=r(),w(p.$$.fragment)},l(m){t=c(m,"P",{"data-svelte-h":!0}),u(t)!=="svelte-11lpom8"&&(t.textContent=f),l=a(m),y(p.$$.fragment,m)},m(m,j){d(m,t,j),d(m,l,j),b(p,m,j),g=!0},p:Xe,i(m){g||(_(p.$$.fragment,m),g=!0)},o(m){M(p.$$.fragment,m),g=!1},d(m){m&&(n(t),n(l)),T(p,m)}}}function Mo(U){let t,f=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=i("p"),t.innerHTML=f},l(l){t=c(l,"P",{"data-svelte-h":!0}),u(t)!=="svelte-fincs2"&&(t.innerHTML=f)},m(l,p){d(l,t,p)},p:Xe,d(l){l&&n(t)}}}function To(U){let t,f="Example:",l,p,g;return p=new Ve({props:{code:"",highlighted:"",wrap:!1}}),{c(){t=i("p"),t.textContent=f,l=r(),w(p.$$.fragment)},l(m){t=c(m,"P",{"data-svelte-h":!0}),u(t)!=="svelte-11lpom8"&&(t.textContent=f),l=a(m),y(p.$$.fragment,m)},m(m,j){d(m,t,j),d(m,l,j),b(p,m,j),g=!0},p:Xe,i(m){g||(_(p.$$.fragment,m),g=!0)},o(m){M(p.$$.fragment,m),g=!1},d(m){m&&(n(t),n(l)),T(p,m)}}}function vo(U){let t,f,l,p,g,m='<div class="flex flex-wrap space-x-1"><img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/></div>',j,h,B,Y,Bt='<a href="https://doi.org/10.48550/arXiv.2407.01449" rel="nofollow">ColQwen2</a> is a variant of the <a href="./colpali">ColPali</a> model designed to retrieve documents by analyzing their visual features. Unlike traditional systems that rely heavily on text extraction and OCR, ColQwen2 treats each page as an image. It uses the <a href="./qwen2_vl">Qwen2-VL</a> backbone to capture not only text, but also the layout, tables, charts, and other visual elements to create detailed multi-vector embeddings that can be used for retrieval by computing pairwise late interaction similarity scores. This offers a more comprehensive understanding of documents and enables more efficient and accurate retrieval.',Pe,S,Rt='This model was contributed by <a href="https://huggingface.co/tonywu71" rel="nofollow">@tonywu71</a> (ILLUIN Technology) and <a href="https://huggingface.co/yonigozlan" rel="nofollow">@yonigozlan</a> (HuggingFace).',Ge,A,qt='You can find all the original ColPali checkpoints under Vidore’s <a href="https://huggingface.co/collections/vidore/hf-native-colvision-models-6755d68fc60a8553acaa96f7" rel="nofollow">Hf-native ColVision Models</a> collection.',Le,V,Ee,X,He,D,Wt='Quantization reduces the memory burden of large models by representing the weights in a lower precision. Refer to the <a href="../quantization/overview">Quantization</a> overview for more available quantization backends.',Ne,K,Ft='The example below uses <a href="../quantization/bitsandbytes.md">bitsandbytes</a> to quantize the weights to int4.',Ye,O,Se,ee,Ae,te,zt='<li><a href="/docs/transformers/main/en/model_doc/colqwen2#transformers.ColQwen2Processor.score_retrieval">score_retrieval()</a> returns a 2D tensor where the first dimension is the number of queries and the second dimension is the number of images. A higher score indicates more similarity between the query and image.</li> <li>Unlike ColPali, ColQwen2 supports arbitrary image resolutions and aspect ratios, which means images are not resized into fixed-size squares. This preserves more of the original input signal.</li> <li>Larger input images generate longer multi-vector embeddings, allowing users to adjust image resolution to balance performance and memory usage.</li>',De,oe,Ke,$,ne,at,we,Vt=`Configuration class to store the configuration of a <code>ColQ2en2ForRetrieval</code>. It is used to instantiate an instance
of <code>ColQwen2ForRetrieval</code> according to the specified arguments, defining the model architecture following the methodology
from the “ColPali: Efficient Document Retrieval with Vision Language Models” paper.`,lt,ye,Xt=`Instantiating a configuration with the defaults will yield a similar configuration to the vision encoder used by the pre-trained
ColQwen2-v1.0 model, e.g. <a href="https://huggingface.co/vidore/colqwen2-v1.0-hf" rel="nofollow">vidore/colqwen2-v1.0-hf</a>.`,it,be,Pt=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,ct,P,Oe,se,et,v,re,dt,_e,Gt=`Constructs a ColQwen2 processor which wraps a Qwen2VLProcessor and special methods to process images and queries, as
well as to compute the late-interaction retrieval score.`,mt,Me,Lt=`<a href="/docs/transformers/main/en/model_doc/colqwen2#transformers.ColQwen2Processor">ColQwen2Processor</a> offers all the functionalities of <a href="/docs/transformers/main/en/model_doc/qwen2_vl#transformers.Qwen2VLProcessor">Qwen2VLProcessor</a>. See the <code>__call__()</code>
for more information.`,pt,G,ae,ut,Te,Et=`This method forwards all its arguments to GemmaTokenizerFast’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.batch_decode">batch_decode()</a>. Please
refer to the docstring of this method for more information.`,ht,L,le,ft,ve,Ht=`This method forwards all its arguments to GemmaTokenizerFast’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.decode">decode()</a>. Please refer to
the docstring of this method for more information.`,gt,R,ie,wt,Je,Nt=`Prepare for the model one or several image(s). This method is a wrapper around the <code>__call__</code> method of the ColQwen2Processor’s
<code>ColQwen2Processor.__call__()</code>.`,yt,Ce,Yt="This method forwards the <code>images</code> and <code>kwargs</code> arguments to the image processor.",bt,q,ce,_t,je,St=`Prepare for the model one or several texts. This method is a wrapper around the <code>__call__</code> method of the ColQwen2Processor’s
<code>ColQwen2Processor.__call__()</code>.`,Mt,$e,At="This method forwards the <code>text</code> and <code>kwargs</code> arguments to the tokenizer.",Tt,W,de,vt,Ue,Dt=`Compute the late-interaction/MaxSim score (ColBERT-like) for the given multi-vector
query embeddings (<code>qs</code>) and passage embeddings (<code>ps</code>). For ColQwen2, a passage is the
image of a document page.`,Jt,ke,Kt=`Because the embedding tensors are multi-vector and can thus have different shapes, they
should be fed as:
(1) a list of tensors, where the i-th tensor is of shape (sequence_length_i, embedding_dim)
(2) a single tensor of shape (n_passages, max_sequence_length, embedding_dim) -> usually
obtained by padding the list of tensors.`,tt,me,ot,J,pe,Ct,Qe,Ot=`Following the ColPali approach, ColQwen2 leverages VLMs to construct efficient multi-vector embeddings directly
from document images (“screenshots”) for document retrieval. The model is trained to maximize the similarity
between these document embeddings and the corresponding query embeddings, using the late interaction method
introduced in ColBERT.`,jt,Ze,eo=`Using ColQwen2 removes the need for potentially complex and brittle layout recognition and OCR pipelines with
a single model that can take into account both the textual and visual content (layout, charts, …) of a document.`,$t,xe,to=`ColQwen2 is part of the ColVision model family, which was introduced with ColPali in the following paper:
<a href="https://arxiv.org/abs/2407.01449" rel="nofollow"><em>ColPali: Efficient Document Retrieval with Vision Language Models</em></a>.`,Ut,Ie,oo=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,kt,Be,no=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Qt,Z,ue,Zt,Re,so='The <a href="/docs/transformers/main/en/model_doc/colqwen2#transformers.ColQwen2ForRetrieval">ColQwen2ForRetrieval</a> forward method, overrides the <code>__call__</code> special method.',xt,E,It,H,nt,he,st,Fe,rt;return h=new ze({props:{title:"ColQwen2",local:"colqwen2",headingTag:"h1"}}),V=new ro({props:{warning:!1,$$slots:{default:[wo]},$$scope:{ctx:U}}}),X=new ho({props:{id:"usage",options:["image retrieval"],$$slots:{default:[bo]},$$scope:{ctx:U}}}),O=new Ve({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBCaXRzQW5kQnl0ZXNDb25maWclMkMlMjBDb2xRd2VuMkZvclJldHJpZXZhbCUyQyUyMENvbFF3ZW4yUHJvY2Vzc29yJTBBJTBBJTBBbW9kZWxfbmFtZSUyMCUzRCUyMCUyMnZpZG9yZSUyRmNvbHF3ZW4yLXYxLjAtaGYlMjIlMEElMEElMjMlMjA0LWJpdCUyMHF1YW50aXphdGlvbiUyMGNvbmZpZ3VyYXRpb24lMEFibmJfY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF91c2VfZG91YmxlX3F1YW50JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X3F1YW50X3R5cGUlM0QlMjJuZjQlMjIlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF9jb21wdXRlX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSklMEElMEFtb2RlbCUyMCUzRCUyMENvbFF3ZW4yRm9yUmV0cmlldmFsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRGJuYl9jb25maWclMkMlMEElMjAlMjAlMjAlMjBkZXZpY2VfbWFwJTNEJTIyY3VkYSUyMiUyQyUwQSkuZXZhbCgpJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQ29sUXdlbjJQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX25hbWUpJTBBJTBBdXJsMSUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGdXBsb2FkLndpa2ltZWRpYS5vcmclMkZ3aWtpcGVkaWElMkZjb21tb25zJTJGOCUyRjg5JTJGVVMtb3JpZ2luYWwtRGVjbGFyYXRpb24tMTc3Ni5qcGclMjIlMEF1cmwyJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZ1cGxvYWQud2lraW1lZGlhLm9yZyUyRndpa2lwZWRpYSUyRmNvbW1vbnMlMkZ0aHVtYiUyRjQlMkY0YyUyRlJvbWVvYW5kanVsaWV0MTU5Ny5qcGclMkY1MDBweC1Sb21lb2FuZGp1bGlldDE1OTcuanBnJTIyJTBBJTBBaW1hZ2VzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsMSUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMkMlMEElMjAlMjAlMjAlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwyJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUyQyUwQSU1RCUwQSUwQXF1ZXJpZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJXaGVuJTIwd2FzJTIwdGhlJTIwVW5pdGVkJTIwU3RhdGVzJTIwRGVjbGFyYXRpb24lMjBvZiUyMEluZGVwZW5kZW5jZSUyMHByb2NsYWltZWQlM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJXaG8lMjBwcmludGVkJTIwdGhlJTIwZWRpdGlvbiUyMG9mJTIwUm9tZW8lMjBhbmQlMjBKdWxpZXQlM0YlMjIlMkMlMEElNUQlMEElMEElMjMlMjBQcm9jZXNzJTIwdGhlJTIwaW5wdXRzJTBBaW5wdXRzX2ltYWdlcyUyMCUzRCUyMHByb2Nlc3NvcihpbWFnZXMlM0RpbWFnZXMlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byhtb2RlbC5kZXZpY2UpJTBBaW5wdXRzX3RleHQlMjAlM0QlMjBwcm9jZXNzb3IodGV4dCUzRHF1ZXJpZXMlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byhtb2RlbC5kZXZpY2UpJTBBJTBBJTIzJTIwRm9yd2FyZCUyMHBhc3MlMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwaW1hZ2VfZW1iZWRkaW5ncyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzX2ltYWdlcykuZW1iZWRkaW5ncyUwQSUyMCUyMCUyMCUyMHF1ZXJ5X2VtYmVkZGluZ3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0c190ZXh0KS5lbWJlZGRpbmdzJTBBJTBBJTIzJTIwU2NvcmUlMjB0aGUlMjBxdWVyaWVzJTIwYWdhaW5zdCUyMHRoZSUyMGltYWdlcyUwQXNjb3JlcyUyMCUzRCUyMHByb2Nlc3Nvci5zY29yZV9yZXRyaWV2YWwocXVlcnlfZW1iZWRkaW5ncyUyQyUyMGltYWdlX2VtYmVkZGluZ3MpJTBBJTBBcHJpbnQoJTIyUmV0cmlldmFsJTIwc2NvcmVzJTIwKHF1ZXJ5JTIweCUyMGltYWdlKSUzQSUyMiklMEFwcmludChzY29yZXMp",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig, ColQwen2ForRetrieval, ColQwen2Processor


model_name = <span class="hljs-string">&quot;vidore/colqwen2-v1.0-hf&quot;</span>

<span class="hljs-comment"># 4-bit quantization configuration</span>
bnb_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
    bnb_4bit_compute_dtype=torch.float16,
)

model = ColQwen2ForRetrieval.from_pretrained(
    model_name,
    quantization_config=bnb_config,
    device_map=<span class="hljs-string">&quot;cuda&quot;</span>,
).<span class="hljs-built_in">eval</span>()

processor = ColQwen2Processor.from_pretrained(model_name)

url1 = <span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/8/89/US-original-Declaration-1776.jpg&quot;</span>
url2 = <span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/4c/Romeoandjuliet1597.jpg/500px-Romeoandjuliet1597.jpg&quot;</span>

images = [
    Image.<span class="hljs-built_in">open</span>(requests.get(url1, stream=<span class="hljs-literal">True</span>).raw),
    Image.<span class="hljs-built_in">open</span>(requests.get(url2, stream=<span class="hljs-literal">True</span>).raw),
]

queries = [
    <span class="hljs-string">&quot;When was the United States Declaration of Independence proclaimed?&quot;</span>,
    <span class="hljs-string">&quot;Who printed the edition of Romeo and Juliet?&quot;</span>,
]

<span class="hljs-comment"># Process the inputs</span>
inputs_images = processor(images=images, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)
inputs_text = processor(text=queries, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)

<span class="hljs-comment"># Forward pass</span>
<span class="hljs-keyword">with</span> torch.no_grad():
    image_embeddings = model(**inputs_images).embeddings
    query_embeddings = model(**inputs_text).embeddings

<span class="hljs-comment"># Score the queries against the images</span>
scores = processor.score_retrieval(query_embeddings, image_embeddings)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Retrieval scores (query x image):&quot;</span>)
<span class="hljs-built_in">print</span>(scores)`,wrap:!1}}),ee=new ze({props:{title:"Notes",local:"notes",headingTag:"h2"}}),oe=new ze({props:{title:"ColQwen2Config",local:"transformers.ColQwen2Config",headingTag:"h2"}}),ne=new z({props:{name:"class transformers.ColQwen2Config",anchor:"transformers.ColQwen2Config",parameters:[{name:"vlm_config",val:" = None"},{name:"embedding_dim",val:": int = 128"},{name:"initializer_range",val:": float = 0.02"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ColQwen2Config.vlm_config",description:`<strong>vlm_config</strong> (<code>PretrainedConfig</code>, <em>optional</em>) &#x2014;
Configuration of the VLM backbone model.`,name:"vlm_config"},{anchor:"transformers.ColQwen2Config.embedding_dim",description:`<strong>embedding_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
Dimension of the multi-vector embeddings produced by the model.`,name:"embedding_dim"},{anchor:"transformers.ColQwen2Config.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/colqwen2/configuration_colqwen2.py#L27"}}),P=new ao({props:{anchor:"transformers.ColQwen2Config.example",$$slots:{default:[_o]},$$scope:{ctx:U}}}),se=new ze({props:{title:"ColQwen2Processor",local:"transformers.ColQwen2Processor",headingTag:"h2"}}),re=new z({props:{name:"class transformers.ColQwen2Processor",anchor:"transformers.ColQwen2Processor",parameters:[{name:"image_processor",val:" = None"},{name:"tokenizer",val:" = None"},{name:"chat_template",val:" = None"},{name:"visual_prompt_prefix",val:": typing.Optional[str] = None"},{name:"query_prefix",val:": typing.Optional[str] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ColQwen2Processor.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/main/en/model_doc/qwen2_vl#transformers.Qwen2VLImageProcessor">Qwen2VLImageProcessor</a>, <em>optional</em>) &#x2014;
The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.ColQwen2Processor.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/main/en/model_doc/qwen2#transformers.Qwen2TokenizerFast">Qwen2TokenizerFast</a>, <em>optional</em>) &#x2014;
The tokenizer is a required input.`,name:"tokenizer"},{anchor:"transformers.ColQwen2Processor.chat_template",description:`<strong>chat_template</strong> (<code>str</code>, <em>optional</em>) &#x2014; A Jinja template which will be used to convert lists of messages
in a chat into a tokenizable string.`,name:"chat_template"},{anchor:"transformers.ColQwen2Processor.visual_prompt_prefix",description:"<strong>visual_prompt_prefix</strong> (<code>str</code>, <em>optional</em>) &#x2014; A string that gets tokenized and prepended to the image tokens.",name:"visual_prompt_prefix"},{anchor:"transformers.ColQwen2Processor.query_prefix",description:"<strong>query_prefix</strong> (<code>str</code>, <em>optional</em>) &#x2014; A prefix to be used for the query.",name:"query_prefix"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/colqwen2/processing_colqwen2.py#L48"}}),ae=new z({props:{name:"batch_decode",anchor:"transformers.ColQwen2Processor.batch_decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/colqwen2/processing_colqwen2.py#L245"}}),le=new z({props:{name:"decode",anchor:"transformers.ColQwen2Processor.decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/colqwen2/processing_colqwen2.py#L252"}}),ie=new z({props:{name:"process_images",anchor:"transformers.ColQwen2Processor.process_images",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']] = None"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.colqwen2.processing_colqwen2.ColQwen2ProcessorKwargs]"}],parametersDescription:[{anchor:"transformers.ColQwen2Processor.process_images.images",description:`<strong>images</strong> (<code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>torch.Tensor</code>, <code>List[PIL.Image.Image]</code>, <code>List[np.ndarray]</code>, <code>List[torch.Tensor]</code>) &#x2014;
The image or batch of images to be prepared. Each image can be a PIL image, NumPy array or PyTorch
tensor. In case of a NumPy array/PyTorch tensor, each image should be of shape (C, H, W), where C is a
number of channels, H and W are image height and width.`,name:"images"},{anchor:"transformers.ColQwen2Processor.process_images.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/main/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>) &#x2014;
If set, will return tensors of a particular framework. Acceptable values are:</p>
<ul>
<li><code>&apos;tf&apos;</code>: Return TensorFlow <code>tf.constant</code> objects.</li>
<li><code>&apos;pt&apos;</code>: Return PyTorch <code>torch.Tensor</code> objects.</li>
<li><code>&apos;np&apos;</code>: Return NumPy <code>np.ndarray</code> objects.</li>
<li><code>&apos;jax&apos;</code>: Return JAX <code>jnp.ndarray</code> objects.</li>
</ul>`,name:"return_tensors"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/colqwen2/processing_colqwen2.py#L274",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/feature_extractor#transformers.BatchFeature"
>BatchFeature</a> with the following fields:</p>
<ul>
<li><strong>input_ids</strong> — List of token ids to be fed to a model.</li>
<li><strong>attention_mask</strong> — List of indices specifying which tokens should be attended to by the model (when
<code>return_attention_mask=True</code> or if <em>“attention_mask”</em> is in <code>self.model_input_names</code> and if <code>text</code> is not
<code>None</code>).</li>
<li><strong>pixel_values</strong> — Pixel values to be fed to a model. Returned when <code>images</code> is not <code>None</code>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/feature_extractor#transformers.BatchFeature"
>BatchFeature</a></p>
`}}),ce=new z({props:{name:"process_queries",anchor:"transformers.ColQwen2Processor.process_queries",parameters:[{name:"text",val:": typing.Union[str, typing.List[str]]"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.colqwen2.processing_colqwen2.ColQwen2ProcessorKwargs]"}],parametersDescription:[{anchor:"transformers.ColQwen2Processor.process_queries.text",description:`<strong>text</strong> (<code>str</code>, <code>List[str]</code>, <code>List[List[str]]</code>) &#x2014;
The sequence or batch of sequences to be encoded. Each sequence can be a string or a list of strings
(pretokenized string). If the sequences are provided as list of strings (pretokenized), you must set
<code>is_split_into_words=True</code> (to lift the ambiguity with a batch of sequences).`,name:"text"},{anchor:"transformers.ColQwen2Processor.process_queries.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/main/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>) &#x2014;
If set, will return tensors of a particular framework. Acceptable values are:</p>
<ul>
<li><code>&apos;tf&apos;</code>: Return TensorFlow <code>tf.constant</code> objects.</li>
<li><code>&apos;pt&apos;</code>: Return PyTorch <code>torch.Tensor</code> objects.</li>
<li><code>&apos;np&apos;</code>: Return NumPy <code>np.ndarray</code> objects.</li>
<li><code>&apos;jax&apos;</code>: Return JAX <code>jnp.ndarray</code> objects.</li>
</ul>`,name:"return_tensors"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/colqwen2/processing_colqwen2.py#L309",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/feature_extractor#transformers.BatchFeature"
>BatchFeature</a> with the following fields:</p>
<ul>
<li><strong>input_ids</strong> — List of token ids to be fed to a model.</li>
<li><strong>attention_mask</strong> — List of indices specifying which tokens should be attended to by the model (when
<code>return_attention_mask=True</code> or if <em>“attention_mask”</em> is in <code>self.model_input_names</code> and if <code>text</code> is not
<code>None</code>).</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/feature_extractor#transformers.BatchFeature"
>BatchFeature</a></p>
`}}),de=new z({props:{name:"score_retrieval",anchor:"transformers.ColQwen2Processor.score_retrieval",parameters:[{name:"query_embeddings",val:": typing.Union[ForwardRef('torch.Tensor'), typing.List[ForwardRef('torch.Tensor')]]"},{name:"passage_embeddings",val:": typing.Union[ForwardRef('torch.Tensor'), typing.List[ForwardRef('torch.Tensor')]]"},{name:"batch_size",val:": int = 128"},{name:"output_dtype",val:": typing.Optional[ForwardRef('torch.dtype')] = None"},{name:"output_device",val:": typing.Union[ForwardRef('torch.device'), str] = 'cpu'"}],parametersDescription:[{anchor:"transformers.ColQwen2Processor.score_retrieval.query_embeddings",description:"<strong>query_embeddings</strong> (<code>Union[torch.Tensor, List[torch.Tensor]</code>) &#x2014; Query embeddings.",name:"query_embeddings"},{anchor:"transformers.ColQwen2Processor.score_retrieval.passage_embeddings",description:"<strong>passage_embeddings</strong> (<code>Union[torch.Tensor, List[torch.Tensor]</code>) &#x2014; Passage embeddings.",name:"passage_embeddings"},{anchor:"transformers.ColQwen2Processor.score_retrieval.batch_size",description:"<strong>batch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014; Batch size for computing scores.",name:"batch_size"},{anchor:"transformers.ColQwen2Processor.score_retrieval.output_dtype",description:`<strong>output_dtype</strong> (<code>torch.dtype</code>, <em>optional</em>, defaults to <code>torch.float32</code>) &#x2014; The dtype of the output tensor.
If <code>None</code>, the dtype of the input embeddings is used.`,name:"output_dtype"},{anchor:"transformers.ColQwen2Processor.score_retrieval.output_device",description:"<strong>output_device</strong> (<code>torch.device</code> or <code>str</code>, <em>optional</em>, defaults to &#x201C;cpu&#x201D;) &#x2014; The device of the output tensor.",name:"output_device"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/colqwen2/processing_colqwen2.py#L343",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape <code>(n_queries, n_passages)</code> containing the scores. The score
tensor is saved on the “cpu” device.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code></p>
`}}),me=new ze({props:{title:"ColQwen2ForRetrieval",local:"transformers.ColQwen2ForRetrieval",headingTag:"h2"}}),pe=new z({props:{name:"class transformers.ColQwen2ForRetrieval",anchor:"transformers.ColQwen2ForRetrieval",parameters:[{name:"config",val:": ColQwen2Config"}],parametersDescription:[{anchor:"transformers.ColQwen2ForRetrieval.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/colqwen2#transformers.ColQwen2Config">ColQwen2Config</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/colqwen2/modeling_colqwen2.py#L100"}}),ue=new z({props:{name:"forward",anchor:"transformers.ColQwen2ForRetrieval.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"},{name:"image_grid_thw",val:": typing.Optional[torch.LongTensor] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"}],parametersDescription:[{anchor:"transformers.ColQwen2ForRetrieval.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ColQwen2ForRetrieval.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.ColQwen2ForRetrieval.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.ColQwen2ForRetrieval.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>List[torch.FloatTensor]</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.ColQwen2ForRetrieval.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"labels"},{anchor:"transformers.ColQwen2ForRetrieval.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.ColQwen2ForRetrieval.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.ColQwen2ForRetrieval.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ColQwen2ForRetrieval.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ColQwen2ForRetrieval.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.ColQwen2ForRetrieval.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>, <em>optional</em>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.ColQwen2ForRetrieval.forward.image_grid_thw",description:`<strong>image_grid_thw</strong> (<code>torch.LongTensor</code> of shape <code>(num_images, 3)</code>, <em>optional</em>) &#x2014;
The temporal, height and width of feature shape of each image in LLM.`,name:"image_grid_thw"},{anchor:"transformers.ColQwen2ForRetrieval.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/colqwen2/modeling_colqwen2.py#L133",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.colqwen2.modeling_colqwen2.ColQwen2ForRetrievalOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/colqwen2#transformers.ColQwen2Config"
>ColQwen2Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>embeddings</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — The embeddings of the model.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.colqwen2.modeling_colqwen2.ColQwen2ForRetrievalOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),E=new ro({props:{$$slots:{default:[Mo]},$$scope:{ctx:U}}}),H=new ao({props:{anchor:"transformers.ColQwen2ForRetrieval.forward.example",$$slots:{default:[To]},$$scope:{ctx:U}}}),he=new go({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/colqwen2.md"}}),{c(){t=i("meta"),f=r(),l=i("p"),p=r(),g=i("div"),g.innerHTML=m,j=r(),w(h.$$.fragment),B=r(),Y=i("p"),Y.innerHTML=Bt,Pe=r(),S=i("p"),S.innerHTML=Rt,Ge=r(),A=i("p"),A.innerHTML=qt,Le=r(),w(V.$$.fragment),Ee=r(),w(X.$$.fragment),He=r(),D=i("p"),D.innerHTML=Wt,Ne=r(),K=i("p"),K.innerHTML=Ft,Ye=r(),w(O.$$.fragment),Se=r(),w(ee.$$.fragment),Ae=r(),te=i("ul"),te.innerHTML=zt,De=r(),w(oe.$$.fragment),Ke=r(),$=i("div"),w(ne.$$.fragment),at=r(),we=i("p"),we.innerHTML=Vt,lt=r(),ye=i("p"),ye.innerHTML=Xt,it=r(),be=i("p"),be.innerHTML=Pt,ct=r(),w(P.$$.fragment),Oe=r(),w(se.$$.fragment),et=r(),v=i("div"),w(re.$$.fragment),dt=r(),_e=i("p"),_e.textContent=Gt,mt=r(),Me=i("p"),Me.innerHTML=Lt,pt=r(),G=i("div"),w(ae.$$.fragment),ut=r(),Te=i("p"),Te.innerHTML=Et,ht=r(),L=i("div"),w(le.$$.fragment),ft=r(),ve=i("p"),ve.innerHTML=Ht,gt=r(),R=i("div"),w(ie.$$.fragment),wt=r(),Je=i("p"),Je.innerHTML=Nt,yt=r(),Ce=i("p"),Ce.innerHTML=Yt,bt=r(),q=i("div"),w(ce.$$.fragment),_t=r(),je=i("p"),je.innerHTML=St,Mt=r(),$e=i("p"),$e.innerHTML=At,Tt=r(),W=i("div"),w(de.$$.fragment),vt=r(),Ue=i("p"),Ue.innerHTML=Dt,Jt=r(),ke=i("p"),ke.textContent=Kt,tt=r(),w(me.$$.fragment),ot=r(),J=i("div"),w(pe.$$.fragment),Ct=r(),Qe=i("p"),Qe.textContent=Ot,jt=r(),Ze=i("p"),Ze.textContent=eo,$t=r(),xe=i("p"),xe.innerHTML=to,Ut=r(),Ie=i("p"),Ie.innerHTML=oo,kt=r(),Be=i("p"),Be.innerHTML=no,Qt=r(),Z=i("div"),w(ue.$$.fragment),Zt=r(),Re=i("p"),Re.innerHTML=so,xt=r(),w(E.$$.fragment),It=r(),w(H.$$.fragment),nt=r(),w(he.$$.fragment),st=r(),Fe=i("p"),this.h()},l(e){const o=po("svelte-u9bgzb",document.head);t=c(o,"META",{name:!0,content:!0}),o.forEach(n),f=a(e),l=c(e,"P",{}),x(l).forEach(n),p=a(e),g=c(e,"DIV",{style:!0,"data-svelte-h":!0}),u(g)!=="svelte-wa5t4p"&&(g.innerHTML=m),j=a(e),y(h.$$.fragment,e),B=a(e),Y=c(e,"P",{"data-svelte-h":!0}),u(Y)!=="svelte-13f3pbx"&&(Y.innerHTML=Bt),Pe=a(e),S=c(e,"P",{"data-svelte-h":!0}),u(S)!=="svelte-1usq28k"&&(S.innerHTML=Rt),Ge=a(e),A=c(e,"P",{"data-svelte-h":!0}),u(A)!=="svelte-st4jp7"&&(A.innerHTML=qt),Le=a(e),y(V.$$.fragment,e),Ee=a(e),y(X.$$.fragment,e),He=a(e),D=c(e,"P",{"data-svelte-h":!0}),u(D)!=="svelte-nf5ooi"&&(D.innerHTML=Wt),Ne=a(e),K=c(e,"P",{"data-svelte-h":!0}),u(K)!=="svelte-1u51sr7"&&(K.innerHTML=Ft),Ye=a(e),y(O.$$.fragment,e),Se=a(e),y(ee.$$.fragment,e),Ae=a(e),te=c(e,"UL",{"data-svelte-h":!0}),u(te)!=="svelte-brnne6"&&(te.innerHTML=zt),De=a(e),y(oe.$$.fragment,e),Ke=a(e),$=c(e,"DIV",{class:!0});var Q=x($);y(ne.$$.fragment,Q),at=a(Q),we=c(Q,"P",{"data-svelte-h":!0}),u(we)!=="svelte-13u0c3g"&&(we.innerHTML=Vt),lt=a(Q),ye=c(Q,"P",{"data-svelte-h":!0}),u(ye)!=="svelte-s1jvyl"&&(ye.innerHTML=Xt),it=a(Q),be=c(Q,"P",{"data-svelte-h":!0}),u(be)!=="svelte-o55m63"&&(be.innerHTML=Pt),ct=a(Q),y(P.$$.fragment,Q),Q.forEach(n),Oe=a(e),y(se.$$.fragment,e),et=a(e),v=c(e,"DIV",{class:!0});var C=x(v);y(re.$$.fragment,C),dt=a(C),_e=c(C,"P",{"data-svelte-h":!0}),u(_e)!=="svelte-1byksx7"&&(_e.textContent=Gt),mt=a(C),Me=c(C,"P",{"data-svelte-h":!0}),u(Me)!=="svelte-1beydii"&&(Me.innerHTML=Lt),pt=a(C),G=c(C,"DIV",{class:!0});var fe=x(G);y(ae.$$.fragment,fe),ut=a(fe),Te=c(fe,"P",{"data-svelte-h":!0}),u(Te)!=="svelte-4dbgxy"&&(Te.innerHTML=Et),fe.forEach(n),ht=a(C),L=c(C,"DIV",{class:!0});var ge=x(L);y(le.$$.fragment,ge),ft=a(ge),ve=c(ge,"P",{"data-svelte-h":!0}),u(ve)!=="svelte-1ha4zc4"&&(ve.innerHTML=Ht),ge.forEach(n),gt=a(C),R=c(C,"DIV",{class:!0});var F=x(R);y(ie.$$.fragment,F),wt=a(F),Je=c(F,"P",{"data-svelte-h":!0}),u(Je)!=="svelte-zcwhrr"&&(Je.innerHTML=Nt),yt=a(F),Ce=c(F,"P",{"data-svelte-h":!0}),u(Ce)!=="svelte-1at6zp"&&(Ce.innerHTML=Yt),F.forEach(n),bt=a(C),q=c(C,"DIV",{class:!0});var qe=x(q);y(ce.$$.fragment,qe),_t=a(qe),je=c(qe,"P",{"data-svelte-h":!0}),u(je)!=="svelte-1dfsyqi"&&(je.innerHTML=St),Mt=a(qe),$e=c(qe,"P",{"data-svelte-h":!0}),u($e)!=="svelte-1y7x5ok"&&($e.innerHTML=At),qe.forEach(n),Tt=a(C),W=c(C,"DIV",{class:!0});var We=x(W);y(de.$$.fragment,We),vt=a(We),Ue=c(We,"P",{"data-svelte-h":!0}),u(Ue)!=="svelte-12e1v66"&&(Ue.innerHTML=Dt),Jt=a(We),ke=c(We,"P",{"data-svelte-h":!0}),u(ke)!=="svelte-3nd4tx"&&(ke.textContent=Kt),We.forEach(n),C.forEach(n),tt=a(e),y(me.$$.fragment,e),ot=a(e),J=c(e,"DIV",{class:!0});var k=x(J);y(pe.$$.fragment,k),Ct=a(k),Qe=c(k,"P",{"data-svelte-h":!0}),u(Qe)!=="svelte-zb0dff"&&(Qe.textContent=Ot),jt=a(k),Ze=c(k,"P",{"data-svelte-h":!0}),u(Ze)!=="svelte-1xlbnaa"&&(Ze.textContent=eo),$t=a(k),xe=c(k,"P",{"data-svelte-h":!0}),u(xe)!=="svelte-n2e6bh"&&(xe.innerHTML=to),Ut=a(k),Ie=c(k,"P",{"data-svelte-h":!0}),u(Ie)!=="svelte-6pahdo"&&(Ie.innerHTML=oo),kt=a(k),Be=c(k,"P",{"data-svelte-h":!0}),u(Be)!=="svelte-hswkmf"&&(Be.innerHTML=no),Qt=a(k),Z=c(k,"DIV",{class:!0});var N=x(Z);y(ue.$$.fragment,N),Zt=a(N),Re=c(N,"P",{"data-svelte-h":!0}),u(Re)!=="svelte-smpvoc"&&(Re.innerHTML=so),xt=a(N),y(E.$$.fragment,N),It=a(N),y(H.$$.fragment,N),N.forEach(n),k.forEach(n),nt=a(e),y(he.$$.fragment,e),st=a(e),Fe=c(e,"P",{}),x(Fe).forEach(n),this.h()},h(){I(t,"name","hf:doc:metadata"),I(t,"content",Jo),uo(g,"float","right"),I($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,o){s(document.head,t),d(e,f,o),d(e,l,o),d(e,p,o),d(e,g,o),d(e,j,o),b(h,e,o),d(e,B,o),d(e,Y,o),d(e,Pe,o),d(e,S,o),d(e,Ge,o),d(e,A,o),d(e,Le,o),b(V,e,o),d(e,Ee,o),b(X,e,o),d(e,He,o),d(e,D,o),d(e,Ne,o),d(e,K,o),d(e,Ye,o),b(O,e,o),d(e,Se,o),b(ee,e,o),d(e,Ae,o),d(e,te,o),d(e,De,o),b(oe,e,o),d(e,Ke,o),d(e,$,o),b(ne,$,null),s($,at),s($,we),s($,lt),s($,ye),s($,it),s($,be),s($,ct),b(P,$,null),d(e,Oe,o),b(se,e,o),d(e,et,o),d(e,v,o),b(re,v,null),s(v,dt),s(v,_e),s(v,mt),s(v,Me),s(v,pt),s(v,G),b(ae,G,null),s(G,ut),s(G,Te),s(v,ht),s(v,L),b(le,L,null),s(L,ft),s(L,ve),s(v,gt),s(v,R),b(ie,R,null),s(R,wt),s(R,Je),s(R,yt),s(R,Ce),s(v,bt),s(v,q),b(ce,q,null),s(q,_t),s(q,je),s(q,Mt),s(q,$e),s(v,Tt),s(v,W),b(de,W,null),s(W,vt),s(W,Ue),s(W,Jt),s(W,ke),d(e,tt,o),b(me,e,o),d(e,ot,o),d(e,J,o),b(pe,J,null),s(J,Ct),s(J,Qe),s(J,jt),s(J,Ze),s(J,$t),s(J,xe),s(J,Ut),s(J,Ie),s(J,kt),s(J,Be),s(J,Qt),s(J,Z),b(ue,Z,null),s(Z,Zt),s(Z,Re),s(Z,xt),b(E,Z,null),s(Z,It),b(H,Z,null),d(e,nt,o),b(he,e,o),d(e,st,o),d(e,Fe,o),rt=!0},p(e,[o]){const Q={};o&2&&(Q.$$scope={dirty:o,ctx:e}),V.$set(Q);const C={};o&2&&(C.$$scope={dirty:o,ctx:e}),X.$set(C);const fe={};o&2&&(fe.$$scope={dirty:o,ctx:e}),P.$set(fe);const ge={};o&2&&(ge.$$scope={dirty:o,ctx:e}),E.$set(ge);const F={};o&2&&(F.$$scope={dirty:o,ctx:e}),H.$set(F)},i(e){rt||(_(h.$$.fragment,e),_(V.$$.fragment,e),_(X.$$.fragment,e),_(O.$$.fragment,e),_(ee.$$.fragment,e),_(oe.$$.fragment,e),_(ne.$$.fragment,e),_(P.$$.fragment,e),_(se.$$.fragment,e),_(re.$$.fragment,e),_(ae.$$.fragment,e),_(le.$$.fragment,e),_(ie.$$.fragment,e),_(ce.$$.fragment,e),_(de.$$.fragment,e),_(me.$$.fragment,e),_(pe.$$.fragment,e),_(ue.$$.fragment,e),_(E.$$.fragment,e),_(H.$$.fragment,e),_(he.$$.fragment,e),rt=!0)},o(e){M(h.$$.fragment,e),M(V.$$.fragment,e),M(X.$$.fragment,e),M(O.$$.fragment,e),M(ee.$$.fragment,e),M(oe.$$.fragment,e),M(ne.$$.fragment,e),M(P.$$.fragment,e),M(se.$$.fragment,e),M(re.$$.fragment,e),M(ae.$$.fragment,e),M(le.$$.fragment,e),M(ie.$$.fragment,e),M(ce.$$.fragment,e),M(de.$$.fragment,e),M(me.$$.fragment,e),M(pe.$$.fragment,e),M(ue.$$.fragment,e),M(E.$$.fragment,e),M(H.$$.fragment,e),M(he.$$.fragment,e),rt=!1},d(e){e&&(n(f),n(l),n(p),n(g),n(j),n(B),n(Y),n(Pe),n(S),n(Ge),n(A),n(Le),n(Ee),n(He),n(D),n(Ne),n(K),n(Ye),n(Se),n(Ae),n(te),n(De),n(Ke),n($),n(Oe),n(et),n(v),n(tt),n(ot),n(J),n(nt),n(st),n(Fe)),n(t),T(h,e),T(V,e),T(X,e),T(O,e),T(ee,e),T(oe,e),T(ne),T(P),T(se,e),T(re),T(ae),T(le),T(ie),T(ce),T(de),T(me,e),T(pe),T(ue),T(E),T(H),T(he,e)}}}const Jo='{"title":"ColQwen2","local":"colqwen2","sections":[{"title":"Notes","local":"notes","sections":[],"depth":2},{"title":"ColQwen2Config","local":"transformers.ColQwen2Config","sections":[],"depth":2},{"title":"ColQwen2Processor","local":"transformers.ColQwen2Processor","sections":[],"depth":2},{"title":"ColQwen2ForRetrieval","local":"transformers.ColQwen2ForRetrieval","sections":[],"depth":2}],"depth":1}';function Co(U){return io(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ro extends co{constructor(t){super(),mo(this,t,Co,vo,lo,{})}}export{Ro as component};
