import{s as Ts,o as Ms,n as Y}from"../chunks/scheduler.18a86fab.js";import{S as ws,i as vs,g as d,s as n,r as m,A as ks,h as c,f as o,c as s,j as w,u as p,x as _,k as M,y as a,a as i,v as u,d as h,t as g,w as f}from"../chunks/index.98837b22.js";import{T as Pt}from"../chunks/Tip.77304350.js";import{D as k}from"../chunks/Docstring.6758ea23.js";import{C as qt}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as Fo}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as I}from"../chunks/Heading.7e7e0c5b.js";import{E as Js}from"../chunks/getInferenceSnippets.de10bc7d.js";function Es(v){let r,y="Emu3 implementation in Transformers uses a special image token to indicate where to merge image embeddings. The special image token isn’t new and uses one of the reserved tokens: <code>&lt;|extra_0|&gt;</code>. You have to add <code>&lt;image&gt;</code> to your prompt in the place where the image should be embedded for correct generation.";return{c(){r=d("p"),r.innerHTML=y},l(l){r=c(l,"P",{"data-svelte-h":!0}),_(r)!=="svelte-1tre9uw"&&(r.innerHTML=y)},m(l,b){i(l,r,b)},p:Y,d(l){l&&o(r)}}}function Cs(v){let r,y;return r=new qt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEVtdTNWUVZBRSUyQyUyMEVtdTNWUVZBRUNvbmZpZyUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjB2aWRlbyUyMFZRJTIwbW9kZWwlMjBvZiUyMEVtdTMlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMEVtdTNWUVZBRUNvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwZnJvbSUyMHRoZSUyMEVtdTMlMjBWUSUyMG1vZGVsJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBFbXUzVlFWQUUoY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Emu3VQVAE, Emu3VQVAEConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a video VQ model of Emu3 configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = Emu3VQVAEConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the Emu3 VQ model style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Emu3VQVAE(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){m(r.$$.fragment)},l(l){p(r.$$.fragment,l)},m(l,b){u(r,l,b),y=!0},p:Y,i(l){y||(h(r.$$.fragment,l),y=!0)},o(l){g(r.$$.fragment,l),y=!1},d(l){f(r,l)}}}function xs(v){let r,y;return r=new qt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEVtdTNNb2RlbCUyQyUyMEVtdTNDb25maWclMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwRW11My1jb21tdW5pdHklMkZFbXUzLUNoYXQtaGYlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwRW11M0NvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwZnJvbSUyMHRoZSUyMEVtdTMtY29tbXVuaXR5JTJGRW11My1DaGF0LWhmJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBFbXUzTW9kZWwoY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Emu3Model, Emu3Config

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Emu3-community/Emu3-Chat-hf style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = Emu3Config()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the Emu3-community/Emu3-Chat-hf style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Emu3Model(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){m(r.$$.fragment)},l(l){p(r.$$.fragment,l)},m(l,b){u(r,l,b),y=!0},p:Y,i(l){y||(h(r.$$.fragment,l),y=!0)},o(l){g(r.$$.fragment,l),y=!1},d(l){f(r,l)}}}function Us(v){let r,y=`Although the recipe for forward pass needs to be defined within
this function, one should call the <code>Module</code> instance afterwards
instead of this since the former takes care of running the
registered hooks while the latter silently ignores them.`;return{c(){r=d("p"),r.innerHTML=y},l(l){r=c(l,"P",{"data-svelte-h":!0}),_(r)!=="svelte-rqqap8"&&(r.innerHTML=y)},m(l,b){i(l,r,b)},p:Y,d(l){l&&o(r)}}}function js(v){let r,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=d("p"),r.innerHTML=y},l(l){r=c(l,"P",{"data-svelte-h":!0}),_(r)!=="svelte-fincs2"&&(r.innerHTML=y)},m(l,b){i(l,r,b)},p:Y,d(l){l&&o(r)}}}function $s(v){let r,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=d("p"),r.innerHTML=y},l(l){r=c(l,"P",{"data-svelte-h":!0}),_(r)!=="svelte-fincs2"&&(r.innerHTML=y)},m(l,b){i(l,r,b)},p:Y,d(l){l&&o(r)}}}function Is(v){let r,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=d("p"),r.innerHTML=y},l(l){r=c(l,"P",{"data-svelte-h":!0}),_(r)!=="svelte-fincs2"&&(r.innerHTML=y)},m(l,b){i(l,r,b)},p:Y,d(l){l&&o(r)}}}function zs(v){let r,y="Example:",l,b,J;return b=new qt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEVtdTNQcm9jZXNzb3IlMkMlMjBFbXUzRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBaW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjByZXF1ZXN0cyUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQSUwQW1vZGVsJTIwJTNEJTIwRW11M0ZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJCQUFJJTJGRW11My1DaGF0LWhmJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiklMEFwcm9jZXNzb3IlMjAlM0QlMjBFbXUzUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJCQUFJJTJGRW11My1DaGF0LWhmJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvcih0ZXh0JTNEJTVCJTIyQ2FuJTIweW91JTIwd3JpdGUlMjBtZSUyMGElMjBwb2VtJTIwYWJvdXQlMjB3aW50ZXIuJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8obW9kZWwuZGV2aWNlKSUwQSUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTAwJTJDJTIwZG9fc2FtcGxlJTNERmFsc2UpJTBBcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Emu3Processor, Emu3ForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span>model = Emu3ForCausalLM.from_pretrained(<span class="hljs-string">&quot;BAAI/Emu3-Chat-hf&quot;</span>, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = Emu3Processor.from_pretrained(<span class="hljs-string">&quot;BAAI/Emu3-Chat-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=[<span class="hljs-string">&quot;Can you write me a poem about winter.&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">100</span>, do_sample=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){r=d("p"),r.textContent=y,l=n(),m(b.$$.fragment)},l(T){r=c(T,"P",{"data-svelte-h":!0}),_(r)!=="svelte-11lpom8"&&(r.textContent=y),l=s(T),p(b.$$.fragment,T)},m(T,E){i(T,r,E),i(T,l,E),u(b,T,E),J=!0},p:Y,i(T){J||(h(b.$$.fragment,T),J=!0)},o(T){g(b.$$.fragment,T),J=!1},d(T){T&&(o(r),o(l)),f(b,T)}}}function Ws(v){let r,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=d("p"),r.innerHTML=y},l(l){r=c(l,"P",{"data-svelte-h":!0}),_(r)!=="svelte-fincs2"&&(r.innerHTML=y)},m(l,b){i(l,r,b)},p:Y,d(l){l&&o(r)}}}function Zs(v){let r,y="Example:",l,b,J;return b=new qt({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Emu3Processor, Emu3ForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span>model = Emu3ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;BAAI/Emu3-Chat-hf&quot;</span>, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = Emu3Processor.from_pretrained(<span class="hljs-string">&quot;BAAI/Emu3-Chat-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>conversation = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;content&quot;</span>: [
<span class="hljs-meta">... </span>        {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span>},
<span class="hljs-meta">... </span>        ],
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;content&quot;</span>: [
<span class="hljs-meta">... </span>        {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
<span class="hljs-meta">... </span>        {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Please describe the image.&quot;</span>},
<span class="hljs-meta">... </span>        ],
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = processor.apply_chat_template(conversation, add_generation_prompt=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(<span class="hljs-string">&quot;https://www.ilankelman.org/stopsigns/australia.jpg&quot;</span>, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=[image], text=[prompt], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device, torch.bfloat16)

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">100</span>, do_sample=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){r=d("p"),r.textContent=y,l=n(),m(b.$$.fragment)},l(T){r=c(T,"P",{"data-svelte-h":!0}),_(r)!=="svelte-11lpom8"&&(r.textContent=y),l=s(T),p(b.$$.fragment,T)},m(T,E){i(T,r,E),i(T,l,E),u(b,T,E),J=!0},p:Y,i(T){J||(h(b.$$.fragment,T),J=!0)},o(T){g(b.$$.fragment,T),J=!1},d(T){T&&(o(r),o(l)),f(b,T)}}}function Vs(v){let r,y,l,b,J,T,E,Zn='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/> <img alt="FlashAttention" src="https://img.shields.io/badge/%E2%9A%A1%EF%B8%8E%20FlashAttention-eae0c8?style=flat"/> <img alt="SDPA" src="https://img.shields.io/badge/SDPA-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',Ht,_e,St,ye,Vn='The Emu3 model was proposed in <a href="https://arxiv.org/abs/2409.18869" rel="nofollow">Emu3: Next-Token Prediction is All You Need</a> by Xinlong Wang, Xiaosong Zhang, Zhengxiong Luo, Quan Sun, Yufeng Cui, Jinsheng Wang, Fan Zhang, Yueze Wang, Zhen Li, Qiying Yu, Yingli Zhao, Yulong Ao, Xuebin Min, Tao Li, Boya Wu, Bo Zhao, Bowen Zhang, Liangdong Wang, Guang Liu, Zheqi He, Xi Yang, Jingjing Liu, Yonghua Lin, Tiejun Huang, Zhongyuan Wang.',Yt,be,Bn="Emu3 is a multimodal LLM that uses vector quantization to tokenize images into discrete tokens. Discretized image tokens are later fused with text token ids for image and text generation. The model can additionally generate images by predicting image token ids.",Dt,Te,Fn="The abstract from the paper is the following:",Ot,Me,Gn="<em>While next-token prediction is considered a promising path towards artificial general intelligence, it has struggled to excel in multimodal tasks, which are still dominated by diffusion models (e.g., Stable Diffusion) and compositional approaches (e.g., CLIP combined with LLMs). In this paper, we introduce Emu3, a new suite of state-of-the-art multimodal models trained solely with next-token prediction. By tokenizing images, text, and videos into a discrete space, we train a single transformer from scratch on a mixture of multimodal sequences. Emu3 outperforms several well-established task-specific models in both generation and perception tasks, surpassing flagship models such as SDXL and LLaVA-1.6, while eliminating the need for diffusion or compositional architectures. Emu3 is also capable of generating high-fidelity video via predicting the next token in a video sequence. We simplify complex multimodal model designs by converging on a singular focus: tokens, unlocking great potential for scaling both during training and inference. Our results demonstrate that next-token prediction is a promising path towards building general multimodal intelligence beyond language. We open-source key techniques and models to support further research in this direction.</em>",Kt,we,Rn="Tips:",eo,ve,Qn="<li><p>We advise users to set <code>processor.tokenizer.padding_side = &quot;left&quot;</code> before batched generation as it leads to more accurate results.</p></li> <li><p>Note that the model has been trained with a specific prompt format for chatting. Use <code>processor.apply_chat_template(my_conversation_dict)</code> to correctly format your prompts.</p></li> <li><p>Emu3 has two different checkpoints for image-generation and text-generation, make sure to use the correct checkpoint when loading the model. To generate an image, it is advised to use <code>prefix_constraints</code> so that the generated tokens are sampled only from possible image tokens. See more below for usage examples.</p></li>",to,ee,oo,ke,Ln=`This model was contributed by <a href="https://huggingface.co/RaushanTurganbay" rel="nofollow">RaushanTurganbay</a>.
The original code can be found <a href="https://github.com/baaivision/Emu3" rel="nofollow">here</a>.`,no,Je,so,Ee,ao,Ce,Nn="Here’s how to load the model and perform inference in half-precision (<code>torch.bfloat16</code>) to generate textual output from text or text and image inputs:",ro,xe,io,Ue,lo,je,Pn="Emu3 can also generate images from textual input. Here is how you can do it:",co,$e,mo,Ie,po,R,ze,Go,pt,qn=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/emu3#transformers.Emu3Model">Emu3Model</a>. It is used to instantiate a
emu3 model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the
<a href="https://huggingface.co/Emu3-community/Emu3-Chat-hf" rel="nofollow">Emu3-community/Emu3-Chat-hf</a>.`,Ro,ut,An=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,uo,We,ho,z,Ze,Qo,ht,Xn=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/emu3#transformers.Emu3VQVAE">Emu3VQVAE</a>. It is used to instantiate an VQ-VAE
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a configuration to the VQ model presented in Emu3 paper.`,Lo,gt,Hn=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,No,te,go,Ve,fo,W,Be,Po,ft,Sn=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/emu3#transformers.Emu3TextModel">Emu3TextModel</a>. It is used to instantiate a
emu3 model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the
<a href="https://huggingface.co/Emu3-community/Emu3-Chat-hf" rel="nofollow">Emu3-community/Emu3-Chat-hf</a>.`,qo,_t,Yn=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Ao,oe,_o,Fe,yo,C,Ge,Xo,yt,Dn=`Constructs a Emu3 processor which wraps a Emu3 image processor and a GPT2 tokenizer into a single
processor.`,Ho,bt,On=`<a href="/docs/transformers/main/en/model_doc/emu3#transformers.Emu3Processor">Emu3Processor</a> offers all the functionalities of <a href="/docs/transformers/main/en/model_doc/emu3#transformers.Emu3ImageProcessor">Emu3ImageProcessor</a> and <a href="/docs/transformers/main/en/model_doc/gpt2#transformers.GPT2TokenizerFast">GPT2TokenizerFast</a>.
See the <code>__call__()</code> and <a href="/docs/transformers/main/en/model_doc/emu3#transformers.Emu3Processor.decode">decode()</a> for more information.`,So,ne,Re,Yo,Tt,Kn=`This method forwards all its arguments to Emu3TokenizerFast’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.batch_decode">batch_decode()</a>. Please
refer to the docstring of this method for more information.`,Do,se,Qe,Oo,Mt,es=`This method forwards all its arguments to Emu3TokenizerFast’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.decode">decode()</a>. Please refer to
the docstring of this method for more information.`,bo,Le,To,Q,Ne,Ko,wt,ts="Constructs a Emu3 image processor that dynamically resizes images based on the original images.",en,vt,Pe,Mo,qe,wo,x,Ae,tn,kt,os=`The VQ-VAE model used in Emu3 for encoding/decoding images into discrete tokens.
This model follows the “Make-a-scene: Scene-based text-to-image generation with human priors” paper from
<a href="https://arxiv.org/abs/2203.13131" rel="nofollow">Oran Gafni, Adam Polyak, Oron Ashual, Shelly Sheynin, Devi Parikh, and Yaniv Taigman</a>.`,on,Jt,ns=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,nn,Et,ss=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,sn,B,Xe,an,Ct,as="Define the computation performed at every call.",rn,xt,rs="Should be overridden by all subclasses.",ln,ae,vo,He,ko,U,Se,dn,Ut,is="The bare Emu3 Text Model outputting raw hidden-states without any specific head on to.",cn,jt,ls=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,mn,$t,ds=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,pn,q,Ye,un,It,cs='The <a href="/docs/transformers/main/en/model_doc/emu3#transformers.Emu3TextModel">Emu3TextModel</a> forward method, overrides the <code>__call__</code> special method.',hn,re,Jo,De,Eo,j,Oe,gn,ie,Ke,fn,zt,ms=`Decodes generated image tokens from language model to continuous pixel values
with VQGAN module via upsampling.`,_n,A,et,yn,Wt,ps='The <a href="/docs/transformers/main/en/model_doc/emu3#transformers.Emu3Model">Emu3Model</a> forward method, overrides the <code>__call__</code> special method.',bn,le,Tn,de,tt,Mn,Zt,us=`Tokenizes images into discrete tokens with VQGAN module and embeds
them with text embeddings layer`,wn,ce,ot,vn,Vt,hs=`Tokenizes images into discrete tokens with VQGAN module. Converts
obtained image tokens into BPE tokens and wraps with “boi” and “eoi”
special tokens.`,Co,nt,xo,$,st,kn,Bt,gs="The Emu3 Model for causal language modeling.",Jn,Ft,fs=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,En,Gt,_s=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Cn,F,at,xn,Rt,ys='The <a href="/docs/transformers/main/en/model_doc/emu3#transformers.Emu3ForCausalLM">Emu3ForCausalLM</a> forward method, overrides the <code>__call__</code> special method.',Un,me,jn,pe,Uo,rt,jo,D,it,$n,G,lt,In,Qt,bs='The <a href="/docs/transformers/main/en/model_doc/emu3#transformers.Emu3ForConditionalGeneration">Emu3ForConditionalGeneration</a> forward method, overrides the <code>__call__</code> special method.',zn,ue,Wn,he,$o,dt,Io,At,zo;return J=new I({props:{title:"Emu3",local:"emu3",headingTag:"h1"}}),_e=new I({props:{title:"Overview",local:"overview",headingTag:"h2"}}),ee=new Pt({props:{warning:!1,$$slots:{default:[Es]},$$scope:{ctx:v}}}),Je=new I({props:{title:"Usage example",local:"usage-example",headingTag:"h2"}}),Ee=new I({props:{title:"Text generation inference",local:"text-generation-inference",headingTag:"h3"}}),xe=new qt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEVtdTNQcm9jZXNzb3IlMkMlMjBFbXUzRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEVtdTNQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMkJBQUklMkZFbXUzLUNoYXQtaGYlMjIpJTBBbW9kZWwlMjAlM0QlMjBFbXUzRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJCQUFJJTJGRW11My1DaGF0LWhmJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUyMGRldmljZV9tYXAlM0QlMjJjdWRhJTIyKSUwQSUwQSUyMyUyMHByZXBhcmUlMjBpbWFnZSUyMGFuZCUyMHRleHQlMjBwcm9tcHQlMEF1cmwlMjAlM0QlMjAnaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyclMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEFwcm9tcHQlMjAlM0QlMjAlMjJXaGF0JTIwZG8lMjB5b3UlMjBzZWUlMjBpbiUyMHRoaXMlMjBpbWFnZSUzRiUzQ2ltYWdlJTNFJTIyJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwdGV4dCUzRHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKG1vZGVsLmRldmljZSUyQyUyMGR0eXBlJTNEdG9yY2guYmZsb2F0MTYpJTBBJTBBJTIzJTIwYXV0b3JlZ3Jlc3NpdmVseSUyMGNvbXBsZXRlJTIwcHJvbXB0JTBBb3V0cHV0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDUwKSUwQXByaW50KHByb2Nlc3Nvci5kZWNvZGUob3V0cHV0JTVCMCU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Emu3Processor, Emu3ForConditionalGeneration
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

processor = Emu3Processor.from_pretrained(<span class="hljs-string">&quot;BAAI/Emu3-Chat-hf&quot;</span>)
model = Emu3ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;BAAI/Emu3-Chat-hf&quot;</span>, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># prepare image and text prompt</span>
url = <span class="hljs-string">&#x27;http://images.cocodataset.org/val2017/000000039769.jpg&#x27;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
prompt = <span class="hljs-string">&quot;What do you see in this image?&lt;image&gt;&quot;</span>

inputs = processor(images=image, text=prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device, dtype=torch.bfloat16)

<span class="hljs-comment"># autoregressively complete prompt</span>
output = model.generate(**inputs, max_new_tokens=<span class="hljs-number">50</span>)
<span class="hljs-built_in">print</span>(processor.decode(output[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))`,wrap:!1}}),Ue=new I({props:{title:"Image generation inference",local:"image-generation-inference",headingTag:"h3"}}),$e=new qt({props:{code:"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",highlighted:`processor = Emu3Processor.from_pretrained(<span class="hljs-string">&quot;BAAI/Emu3-Gen-hf&quot;</span>)
model = Emu3ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;BAAI/Emu3-Gen-hf&quot;</span>, torch_dtype=<span class="hljs-string">&quot;bfloat16&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>)


inputs = processor(
    text=[<span class="hljs-string">&quot;a portrait of young girl. masterpiece, film grained, best quality.&quot;</span>, <span class="hljs-string">&quot;a dog running under the rain&quot;</span>],
    padding=<span class="hljs-literal">True</span>,
    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
    return_for_image_generation=<span class="hljs-literal">True</span>,
)
inputs = inputs.to(device=<span class="hljs-string">&quot;cuda:0&quot;</span>, dtype=torch.bfloat16)

neg_prompt = <span class="hljs-string">&quot;lowres, bad anatomy, bad hands, text, error, missing fingers, extra digit, fewer digits, cropped, worst quality, low quality, normal quality, jpeg artifacts, signature, watermark, username, blurry.&quot;</span>
neg_inputs = processor(text=[neg_prompt] * <span class="hljs-number">2</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device=<span class="hljs-string">&quot;cuda:0&quot;</span>)

image_sizes = inputs.pop(<span class="hljs-string">&quot;image_sizes&quot;</span>)
HEIGHT, WIDTH = image_sizes[<span class="hljs-number">0</span>]
VISUAL_TOKENS = model.vocabulary_mapping.image_tokens

<span class="hljs-keyword">def</span> <span class="hljs-title function_">prefix_allowed_tokens_fn</span>(<span class="hljs-params">batch_id, input_ids</span>):
    height, width = HEIGHT, WIDTH
    visual_tokens = VISUAL_TOKENS
    image_wrapper_token_id = torch.tensor([processor.tokenizer.image_wrapper_token_id], device=model.device)
    eoi_token_id = torch.tensor([processor.tokenizer.eoi_token_id], device=model.device)
    eos_token_id = torch.tensor([processor.tokenizer.eos_token_id], device=model.device)
    pad_token_id = torch.tensor([processor.tokenizer.pad_token_id], device=model.device)
    eof_token_id = torch.tensor([processor.tokenizer.eof_token_id], device=model.device)
    eol_token_id = processor.tokenizer.encode(<span class="hljs-string">&quot;&lt;|extra_200|&gt;&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)[<span class="hljs-number">0</span>]

    position = torch.nonzero(input_ids == image_wrapper_token_id, as_tuple=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>]
    offset = input_ids.shape[<span class="hljs-number">0</span>] - position
    <span class="hljs-keyword">if</span> offset % (width + <span class="hljs-number">1</span>) == <span class="hljs-number">0</span>:
        <span class="hljs-keyword">return</span> (eol_token_id, )
    <span class="hljs-keyword">elif</span> offset == (width + <span class="hljs-number">1</span>) * height + <span class="hljs-number">1</span>:
        <span class="hljs-keyword">return</span> (eof_token_id, )
    <span class="hljs-keyword">elif</span> offset == (width + <span class="hljs-number">1</span>) * height + <span class="hljs-number">2</span>:
        <span class="hljs-keyword">return</span> (eoi_token_id, )
    <span class="hljs-keyword">elif</span> offset == (width + <span class="hljs-number">1</span>) * height + <span class="hljs-number">3</span>:
        <span class="hljs-keyword">return</span> (eos_token_id, )
    <span class="hljs-keyword">elif</span> offset &gt; (width + <span class="hljs-number">1</span>) * height + <span class="hljs-number">3</span>:
        <span class="hljs-keyword">return</span> (pad_token_id, )
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> visual_tokens


out = model.generate(
    **inputs,
    max_new_tokens=<span class="hljs-number">50_000</span>, <span class="hljs-comment"># make sure to have enough tokens for one image</span>
    prefix_allowed_tokens_fn=prefix_allowed_tokens_fn,
    return_dict_in_generate=<span class="hljs-literal">True</span>,
    negative_prompt_ids=neg_inputs.input_ids, <span class="hljs-comment"># indicate for Classifier-Free Guidance</span>
    negative_prompt_attention_mask=neg_inputs.attention_mask,
)

image = model.decode_image_tokens(out.sequences[:, inputs.input_ids.shape[<span class="hljs-number">1</span>]: ], height=HEIGHT, width=WIDTH)
images = processor.postprocess(<span class="hljs-built_in">list</span>(image.<span class="hljs-built_in">float</span>()), return_tensors=<span class="hljs-string">&quot;PIL.Image.Image&quot;</span>) <span class="hljs-comment"># internally we convert to np but it&#x27;s not supported in bf16 precision</span>
<span class="hljs-keyword">for</span> i, image <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(images[<span class="hljs-string">&#x27;pixel_values&#x27;</span>]):
    image.save(<span class="hljs-string">f&quot;result<span class="hljs-subst">{i}</span>.png&quot;</span>)
`,wrap:!1}}),Ie=new I({props:{title:"Emu3Config",local:"transformers.Emu3Config",headingTag:"h2"}}),ze=new k({props:{name:"class transformers.Emu3Config",anchor:"transformers.Emu3Config",parameters:[{name:"vq_config",val:": typing.Union[typing.Dict, transformers.models.emu3.configuration_emu3.Emu3VQVAEConfig] = None"},{name:"text_config",val:": typing.Union[typing.Dict, transformers.models.emu3.configuration_emu3.Emu3TextConfig] = None"},{name:"vocabulary_map",val:": typing.Optional[typing.Dict[int, int]] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Emu3Config.vq_config",description:`<strong>vq_config</strong> (<code>Union[Dict, Emu3VQVAEConfig]</code>, <em>optional</em>) &#x2014;
Emu3VQVAEConfig instance containing the configuration for the VQ-VAE model.`,name:"vq_config"},{anchor:"transformers.Emu3Config.text_config",description:"<strong>text_config</strong> (`Union[Dict, Emu3TextConfig]&#x201C;, <em>optional</em>) &#x2014;\nEmu3TextConfig instance containing the configuration for the language model.",name:"text_config"},{anchor:"transformers.Emu3Config.vocabulary_map",description:`<strong>vocabulary_map</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A dictionary containing the vocabulary map from the tokenizer. Used to obtain tokens from the image inputs.`,name:"vocabulary_map"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/emu3/configuration_emu3.py#L279"}}),We=new I({props:{title:"Emu3VQVAEConfig",local:"transformers.Emu3VQVAEConfig",headingTag:"h2"}}),Ze=new k({props:{name:"class transformers.Emu3VQVAEConfig",anchor:"transformers.Emu3VQVAEConfig",parameters:[{name:"codebook_size",val:": int = 32768"},{name:"embed_dim",val:": int = 4"},{name:"latent_channels",val:": int = 4"},{name:"double_latent",val:": bool = False"},{name:"in_channels",val:": int = 3"},{name:"out_channels",val:": int = 3"},{name:"temporal_downsample_factor",val:": int = 4"},{name:"base_channels",val:": int = 256"},{name:"channel_multiplier",val:": typing.List[int] = [1, 2, 2, 4]"},{name:"num_res_blocks",val:": int = 2"},{name:"attn_resolutions",val:": typing.List[int] = [3]"},{name:"hidden_size",val:": int = 1024"},{name:"num_attention_heads",val:": int = 1"},{name:"attention_dropout",val:": float = 0.0"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Emu3VQVAEConfig.codebook_size",description:`<strong>codebook_size</strong> (<code>int</code>, <em>optional</em>, defaults to 32768) &#x2014;
Codebook size of the VQ model.`,name:"codebook_size"},{anchor:"transformers.Emu3VQVAEConfig.embed_dim",description:`<strong>embed_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
Dimension of the quantized vector in codebook.`,name:"embed_dim"},{anchor:"transformers.Emu3VQVAEConfig.latent_channels",description:`<strong>latent_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
Dimension of the output channel of encoder and the input channel of decoder`,name:"latent_channels"},{anchor:"transformers.Emu3VQVAEConfig.double_latent",description:`<strong>double_latent</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether double the output dim of the encoder.`,name:"double_latent"},{anchor:"transformers.Emu3VQVAEConfig.in_channels",description:`<strong>in_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
Input channel of encoder.`,name:"in_channels"},{anchor:"transformers.Emu3VQVAEConfig.out_channels",description:`<strong>out_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
Output channel of decoder.`,name:"out_channels"},{anchor:"transformers.Emu3VQVAEConfig.temporal_downsample_factor",description:`<strong>temporal_downsample_factor</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
Temporal downsample factor.`,name:"temporal_downsample_factor"},{anchor:"transformers.Emu3VQVAEConfig.base_channels",description:`<strong>base_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Basic channel number of the intermediate blocks.`,name:"base_channels"},{anchor:"transformers.Emu3VQVAEConfig.channel_multiplier",description:`<strong>channel_multiplier</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[1, 2, 2, 4]</code>) &#x2014;
Channel scaling factor of the intermediate blocks.`,name:"channel_multiplier"},{anchor:"transformers.Emu3VQVAEConfig.num_res_blocks",description:`<strong>num_res_blocks</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
Residual block number in each stage.`,name:"num_res_blocks"},{anchor:"transformers.Emu3VQVAEConfig.attn_resolutions",description:`<strong>attn_resolutions</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[3]</code>) &#x2014;
Stage indices to apply attention.`,name:"attn_resolutions"},{anchor:"transformers.Emu3VQVAEConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
Dimension of the hidden representations in the attention layer.`,name:"hidden_size"},{anchor:"transformers.Emu3VQVAEConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of attention heads for each attention layer.`,name:"num_attention_heads"},{anchor:"transformers.Emu3VQVAEConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/emu3/configuration_emu3.py#L23"}}),te=new Fo({props:{anchor:"transformers.Emu3VQVAEConfig.example",$$slots:{default:[Cs]},$$scope:{ctx:v}}}),Ve=new I({props:{title:"Emu3TextConfig",local:"transformers.Emu3TextConfig",headingTag:"h2"}}),Be=new k({props:{name:"class transformers.Emu3TextConfig",anchor:"transformers.Emu3TextConfig",parameters:[{name:"vocab_size",val:": int = 184622"},{name:"hidden_size",val:": int = 4096"},{name:"intermediate_size",val:": int = 14336"},{name:"num_hidden_layers",val:": int = 32"},{name:"num_attention_heads",val:": int = 32"},{name:"num_key_value_heads",val:": typing.Optional[int] = 8"},{name:"hidden_act",val:": str = 'silu'"},{name:"max_position_embeddings",val:": int = 9216"},{name:"rms_norm_eps",val:": float = 1e-05"},{name:"use_cache",val:": bool = True"},{name:"pad_token_id",val:": int = 151643"},{name:"bos_token_id",val:": int = 151849"},{name:"eos_token_id",val:": int = 151850"},{name:"tie_word_embeddings",val:": bool = False"},{name:"rope_theta",val:": float = 1000000.0"},{name:"rope_scaling",val:": typing.Optional = None"},{name:"mlp_bias",val:" = False"},{name:"attention_bias",val:" = False"},{name:"attention_dropout",val:": float = 0.1"},{name:"initializer_range",val:": float = 0.02"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Emu3TextConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 184622) &#x2014;
Vocabulary size of the Emu3 model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/emu3#transformers.Emu3Model">Emu3Model</a>`,name:"vocab_size"},{anchor:"transformers.Emu3TextConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Dimension of the hidden representations.`,name:"hidden_size"},{anchor:"transformers.Emu3TextConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 14336) &#x2014;
Dimension of the MLP representations.`,name:"intermediate_size"},{anchor:"transformers.Emu3TextConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Number of hidden layers in the Transformer decoder.`,name:"num_hidden_layers"},{anchor:"transformers.Emu3TextConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Number of attention heads for each attention layer in the Transformer decoder.`,name:"num_attention_heads"},{anchor:"transformers.Emu3TextConfig.num_key_value_heads",description:`<strong>num_key_value_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
This is the number of key_value heads that should be used to implement Grouped Query Attention. If
<code>num_key_value_heads=num_attention_heads</code>, the model will use Multi Head Attention (MHA), if
<code>num_key_value_heads=1 the model will use Multi Query Attention (MQA) otherwise GQA is used. When converting a multi-head checkpoint to a GQA checkpoint, each group key and value head should be constructed by meanpooling all the original heads within that group. For more details, check out [this paper](https://arxiv.org/pdf/2305.13245.pdf). If it is not specified, will default to </code>num_attention_heads\`.`,name:"num_key_value_heads"},{anchor:"transformers.Emu3TextConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;silu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the decoder.`,name:"hidden_act"},{anchor:"transformers.Emu3TextConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 9216) &#x2014;
The maximum sequence length that this model might ever be used with. Emu supports up to 9216 tokens,`,name:"max_position_embeddings"},{anchor:"transformers.Emu3TextConfig.rms_norm_eps",description:`<strong>rms_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the rms normalization layers.`,name:"rms_norm_eps"},{anchor:"transformers.Emu3TextConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models). Only
relevant if <code>config.is_decoder=True</code>.`,name:"use_cache"},{anchor:"transformers.Emu3TextConfig.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 151643) &#x2014;
Padding token id.`,name:"pad_token_id"},{anchor:"transformers.Emu3TextConfig.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 151849) &#x2014;
Beginning of stream token id.`,name:"bos_token_id"},{anchor:"transformers.Emu3TextConfig.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 151850) &#x2014;
End of stream token id.`,name:"eos_token_id"},{anchor:"transformers.Emu3TextConfig.tie_word_embeddings",description:`<strong>tie_word_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to tie weight embeddings`,name:"tie_word_embeddings"},{anchor:"transformers.Emu3TextConfig.rope_theta",description:`<strong>rope_theta</strong> (<code>float</code>, <em>optional</em>, defaults to 1000000.0) &#x2014;
The base period of the RoPE embeddings.`,name:"rope_theta"},{anchor:"transformers.Emu3TextConfig.rope_scaling",description:`<strong>rope_scaling</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Dictionary containing the scaling configuration for the RoPE embeddings. NOTE: if you apply new rope type
and you expect the model to work on longer <code>max_position_embeddings</code>, we recommend you to update this value
accordingly.
Expected contents:
<code>rope_type</code> (<code>str</code>):
The sub-variant of RoPE to use. Can be one of [&#x2018;default&#x2019;, &#x2018;linear&#x2019;, &#x2018;dynamic&#x2019;, &#x2018;yarn&#x2019;, &#x2018;longrope&#x2019;,
&#x2018;llama3&#x2019;], with &#x2018;default&#x2019; being the original RoPE implementation.
<code>factor</code> (<code>float</code>, <em>optional</em>):
Used with all rope types except &#x2018;default&#x2019;. The scaling factor to apply to the RoPE embeddings. In
most scaling types, a <code>factor</code> of x will enable the model to handle sequences of length x <em>
original maximum pre-trained length.
<code>original_max_position_embeddings</code> (<code>int</code>, </em>optional<em>):
Used with &#x2018;dynamic&#x2019;, &#x2018;longrope&#x2019; and &#x2018;llama3&#x2019;. The original max position embeddings used during
pretraining.
<code>attention_factor</code> (<code>float</code>, </em>optional<em>):
Used with &#x2018;yarn&#x2019; and &#x2018;longrope&#x2019;. The scaling factor to be applied on the attention
computation. If unspecified, it defaults to value recommended by the implementation, using the
<code>factor</code> field to infer the suggested value.
<code>beta_fast</code> (<code>float</code>, </em>optional<em>):
Only used with &#x2018;yarn&#x2019;. Parameter to set the boundary for extrapolation (only) in the linear
ramp function. If unspecified, it defaults to 32.
<code>beta_slow</code> (<code>float</code>, </em>optional<em>):
Only used with &#x2018;yarn&#x2019;. Parameter to set the boundary for interpolation (only) in the linear
ramp function. If unspecified, it defaults to 1.
<code>short_factor</code> (<code>List[float]</code>, </em>optional<em>):
Only used with &#x2018;longrope&#x2019;. The scaling factor to be applied to short contexts (&lt;
<code>original_max_position_embeddings</code>). Must be a list of numbers with the same length as the hidden
size divided by the number of attention heads divided by 2
<code>long_factor</code> (<code>List[float]</code>, </em>optional<em>):
Only used with &#x2018;longrope&#x2019;. The scaling factor to be applied to long contexts (&lt;
<code>original_max_position_embeddings</code>). Must be a list of numbers with the same length as the hidden
size divided by the number of attention heads divided by 2
<code>low_freq_factor</code> (<code>float</code>, </em>optional<em>):
Only used with &#x2018;llama3&#x2019;. Scaling factor applied to low frequency components of the RoPE
<code>high_freq_factor</code> (<code>float</code>, </em>optional*):
Only used with &#x2018;llama3&#x2019;. Scaling factor applied to high frequency components of the RoPE`,name:"rope_scaling"},{anchor:"transformers.Emu3TextConfig.mlp_bias",description:`<strong>mlp_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use a bias in up_proj, down_proj and gate_proj layers in the MLP layers.`,name:"mlp_bias"},{anchor:"transformers.Emu3TextConfig.attention_bias",description:`<strong>attention_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use a bias in the query, key, value and output projection layers during self-attention.`,name:"attention_bias"},{anchor:"transformers.Emu3TextConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.Emu3TextConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/emu3/configuration_emu3.py#L113"}}),oe=new Fo({props:{anchor:"transformers.Emu3TextConfig.example",$$slots:{default:[xs]},$$scope:{ctx:v}}}),Fe=new I({props:{title:"Emu3Processor",local:"transformers.Emu3Processor",headingTag:"h2"}}),Ge=new k({props:{name:"class transformers.Emu3Processor",anchor:"transformers.Emu3Processor",parameters:[{name:"image_processor",val:""},{name:"tokenizer",val:""},{name:"chat_template",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Emu3Processor.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/main/en/model_doc/emu3#transformers.Emu3ImageProcessor">Emu3ImageProcessor</a>) &#x2014;
The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.Emu3Processor.tokenizer",description:`<strong>tokenizer</strong> (<code>Emu3TokenizerFast</code>) &#x2014;
The tokenizer is a required input.`,name:"tokenizer"},{anchor:"transformers.Emu3Processor.chat_template",description:`<strong>chat_template</strong> (<code>str</code>, <em>optional</em>) &#x2014; A Jinja template which will be used to convert lists of messages
in a chat into a tokenizable string.`,name:"chat_template"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/emu3/processing_emu3.py#L56"}}),Re=new k({props:{name:"batch_decode",anchor:"transformers.Emu3Processor.batch_decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/emu3/processing_emu3.py#L247"}}),Qe=new k({props:{name:"decode",anchor:"transformers.Emu3Processor.decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/emu3/processing_emu3.py#L254"}}),Le=new I({props:{title:"Emu3ImageProcessor",local:"transformers.Emu3ImageProcessor",headingTag:"h2"}}),Ne=new k({props:{name:"class transformers.Emu3ImageProcessor",anchor:"transformers.Emu3ImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"resample",val:": Resampling = <Resampling.BICUBIC: 3>"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_convert_rgb",val:": bool = True"},{name:"do_pad",val:": bool = True"},{name:"min_pixels",val:": int = 262144"},{name:"max_pixels",val:": int = 1048576"},{name:"spatial_factor",val:": int = 8"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Emu3ImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions.`,name:"do_resize"},{anchor:"transformers.Emu3ImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>Resampling.BICUBIC</code>) &#x2014;
Resampling filter to use when resizing the image.`,name:"resample"},{anchor:"transformers.Emu3ImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>.`,name:"do_rescale"},{anchor:"transformers.Emu3ImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image.`,name:"rescale_factor"},{anchor:"transformers.Emu3ImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.Emu3ImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>[0.48145466, 0.4578275, 0.40821073]</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats for each channel in the image.`,name:"image_mean"},{anchor:"transformers.Emu3ImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>[0.26862954, 0.26130258, 0.27577711]</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats for each channel in the image.`,name:"image_std"},{anchor:"transformers.Emu3ImageProcessor.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.Emu3ImageProcessor.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to pad the image. If <code>True</code>, will pad the patch dimension of the images in the batch to the largest
number of patches in the batch. Padding will be applied to the bottom and right with zeros.`,name:"do_pad"},{anchor:"transformers.Emu3ImageProcessor.min_pixels",description:`<strong>min_pixels</strong> (<code>int</code>, <em>optional</em>, defaults to <code>512 * 512</code>) &#x2014;
The min pixels of the image to resize the image.`,name:"min_pixels"},{anchor:"transformers.Emu3ImageProcessor.max_pixels",description:`<strong>max_pixels</strong> (<code>int</code>, <em>optional</em>, defaults to <code>1024 * 1024</code>) &#x2014;
The max pixels of the image to resize the image.`,name:"max_pixels"},{anchor:"transformers.Emu3ImageProcessor.spatial_factor",description:`<strong>spatial_factor</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
The spatial downsample factor the image will be downsampled in feature extracting phase`,name:"spatial_factor"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/emu3/image_processing_emu3.py#L103"}}),Pe=new k({props:{name:"preprocess",anchor:"transformers.Emu3ImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']]"},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"resample",val:": Resampling = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Optional[float] = None"},{name:"do_normalize",val:": typing.Optional[bool] = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_convert_rgb",val:": typing.Optional[bool] = None"},{name:"do_pad",val:": bool = True"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": typing.Optional[transformers.image_utils.ChannelDimension] = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.Emu3ImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.Emu3ImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.Emu3ImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the image after resizing. Shortest edge of the image is resized to size[&#x201C;shortest_edge&#x201D;], with
the longest edge resized to keep the input aspect ratio.`,name:"size"},{anchor:"transformers.Emu3ImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>. Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.Emu3ImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.Emu3ImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.Emu3ImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.Emu3ImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean to use for normalization. Only has an effect if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.Emu3ImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation to use for normalization. Only has an effect if <code>do_normalize</code> is set to
<code>True</code>.`,name:"image_std"},{anchor:"transformers.Emu3ImageProcessor.preprocess.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_convert_rgb</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.Emu3ImageProcessor.preprocess.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to pad the image. If <code>True</code>, will pad the patch dimension of the images in the batch to the largest
number of patches in the batch. Padding will be applied to the bottom and right with zeros.`,name:"do_pad"},{anchor:"transformers.Emu3ImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.Emu3ImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.Emu3ImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/emu3/image_processing_emu3.py#L308"}}),qe=new I({props:{title:"Emu3VQVAE",local:"transformers.Emu3VQVAE",headingTag:"h2"}}),Ae=new k({props:{name:"class transformers.Emu3VQVAE",anchor:"transformers.Emu3VQVAE",parameters:[{name:"config",val:": Emu3VQVAEConfig"}],parametersDescription:[{anchor:"transformers.Emu3VQVAE.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/emu3#transformers.Emu3VQVAEConfig">Emu3VQVAEConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/emu3/modeling_emu3.py#L958"}}),Xe=new k({props:{name:"_forward_unimplemented",anchor:"transformers.Emu3VQVAE.forward",parameters:[{name:"*input",val:": typing.Any"}],source:"https://github.com/huggingface/transformers/blob/main/src/torch/nn/modules/module.py#L386"}}),ae=new Pt({props:{$$slots:{default:[Us]},$$scope:{ctx:v}}}),He=new I({props:{title:"Emu3TextModel",local:"transformers.Emu3TextModel",headingTag:"h2"}}),Se=new k({props:{name:"class transformers.Emu3TextModel",anchor:"transformers.Emu3TextModel",parameters:[{name:"config",val:": Emu3Config"}],parametersDescription:[{anchor:"transformers.Emu3TextModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/emu3#transformers.Emu3Config">Emu3Config</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/emu3/modeling_emu3.py#L1196"}}),Ye=new k({props:{name:"forward",anchor:"transformers.Emu3TextModel.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[transformers.cache_utils.Cache] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"**flash_attn_kwargs",val:": typing_extensions.Unpack[transformers.modeling_flash_attention_utils.FlashAttentionKwargs]"}],parametersDescription:[{anchor:"transformers.Emu3TextModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.Emu3TextModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.Emu3TextModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.Emu3TextModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>~cache_utils.Cache</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.Emu3TextModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.Emu3TextModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.Emu3TextModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Emu3TextModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Emu3TextModel.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/emu3/modeling_emu3.py#L1220",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPast"
>transformers.modeling_outputs.BaseModelOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/emu3#transformers.Emu3Config"
>Emu3Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>Cache</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — It is a <a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache"
>Cache</a> instance. For more details, see our <a
  href="https://huggingface.co/docs/transformers/en/kv_cache"
  rel="nofollow"
>kv cache guide</a>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and optionally if
<code>config.is_encoder_decoder=True</code> in the cross-attention blocks) that can be used (see <code>past_key_values</code>
input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPast"
>transformers.modeling_outputs.BaseModelOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),re=new Pt({props:{$$slots:{default:[js]},$$scope:{ctx:v}}}),De=new I({props:{title:"Emu3Model",local:"transformers.Emu3Model",headingTag:"h2"}}),Oe=new k({props:{name:"class transformers.Emu3Model",anchor:"transformers.Emu3Model",parameters:[{name:"config",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/emu3/modeling_emu3.py#L1434"}}),Ke=new k({props:{name:"decode_image_tokens",anchor:"transformers.Emu3Model.decode_image_tokens",parameters:[{name:"image_tokens",val:": LongTensor"},{name:"height",val:": int"},{name:"width",val:": int"}],parametersDescription:[{anchor:"transformers.Emu3Model.decode_image_tokens.image_tokens",description:`<strong>image_tokens</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_of_tokens)</code>) &#x2014;
The tensors corresponding to the input images.`,name:"image_tokens"},{anchor:"transformers.Emu3Model.decode_image_tokens.height",description:`<strong>height</strong> (<code>int</code>) &#x2014;
Height of the generated image before upsampling.`,name:"height"},{anchor:"transformers.Emu3Model.decode_image_tokens.width",description:`<strong>width</strong> (<code>int</code>) &#x2014;
Width of the generated image before upsampling.`,name:"width"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/emu3/modeling_emu3.py#L1488"}}),et=new k({props:{name:"forward",anchor:"transformers.Emu3Model.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"pixel_values",val:": FloatTensor = None"},{name:"image_sizes",val:": Tensor = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[transformers.cache_utils.Cache] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.modeling_flash_attention_utils.FlashAttentionKwargs]"}],parametersDescription:[{anchor:"transformers.Emu3Model.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.Emu3Model.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.Emu3Model.forward.image_sizes",description:`<strong>image_sizes</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, 2)</code>) &#x2014;
The sizes of the images in the batch, being (height, width) for each image. Image sizes can be obtained using
<a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/main/en/model_doc/vilt#transformers.ViltFeatureExtractor.__call__">Emu3ImageProcessor.<strong>call</strong>()</a> for details ([]<code>Emu3Processor</code>] uses
<a href="/docs/transformers/main/en/model_doc/emu3#transformers.Emu3ImageProcessor">Emu3ImageProcessor</a> for processing images).`,name:"image_sizes"},{anchor:"transformers.Emu3Model.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.Emu3Model.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.Emu3Model.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>~cache_utils.Cache</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.Emu3Model.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.Emu3Model.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.Emu3Model.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Emu3Model.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Emu3Model.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.Emu3Model.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/emu3/modeling_emu3.py#L1507",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/emu3#transformers.Emu3Config"
>Emu3Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>Cache</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — It is a <a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache"
>Cache</a> instance. For more details, see our <a
  href="https://huggingface.co/docs/transformers/en/kv_cache"
  rel="nofollow"
>kv cache guide</a>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),le=new Pt({props:{$$slots:{default:[$s]},$$scope:{ctx:v}}}),tt=new k({props:{name:"get_image_features",anchor:"transformers.Emu3Model.get_image_features",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"image_sizes",val:": LongTensor"}],parametersDescription:[{anchor:"transformers.Emu3Model.get_image_features.pixel_values",description:"<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape `(batch_size, num_channels, image_size, image_size)) &#x2014;\nThe tensors corresponding to the input images.",name:"pixel_values"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/emu3/modeling_emu3.py#L1470"}}),ot=new k({props:{name:"get_image_tokens",anchor:"transformers.Emu3Model.get_image_tokens",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"image_sizes",val:": LongTensor"}],parametersDescription:[{anchor:"transformers.Emu3Model.get_image_tokens.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>) &#x2014;
The tensors corresponding to the input images.`,name:"pixel_values"},{anchor:"transformers.Emu3Model.get_image_tokens.image_sizes",description:`<strong>image_sizes</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2)</code>) &#x2014;
The sizes of the images in the batch, being (height, width) for each image.`,name:"image_sizes"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/emu3/modeling_emu3.py#L1453"}}),nt=new I({props:{title:"Emu3ForCausalLM",local:"transformers.Emu3ForCausalLM",headingTag:"h2"}}),st=new k({props:{name:"class transformers.Emu3ForCausalLM",anchor:"transformers.Emu3ForCausalLM",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.Emu3ForCausalLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/emu3#transformers.Emu3ForCausalLM">Emu3ForCausalLM</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/emu3/modeling_emu3.py#L1324"}}),at=new k({props:{name:"forward",anchor:"transformers.Emu3ForCausalLM.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[transformers.cache_utils.Cache] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"logits_to_keep",val:": typing.Union[int, torch.Tensor] = 0"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.emu3.modeling_emu3.KwargsForCausalLM]"}],parametersDescription:[{anchor:"transformers.Emu3ForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.Emu3ForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.Emu3ForCausalLM.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.Emu3ForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>~cache_utils.Cache</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.Emu3ForCausalLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.Emu3ForCausalLM.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"labels"},{anchor:"transformers.Emu3ForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.Emu3ForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Emu3ForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Emu3ForCausalLM.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"},{anchor:"transformers.Emu3ForCausalLM.forward.logits_to_keep",description:`<strong>logits_to_keep</strong> (<code>Union[int, torch.Tensor]</code>, defaults to <code>0</code>) &#x2014;
If an <code>int</code>, compute logits for the last <code>logits_to_keep</code> tokens. If <code>0</code>, calculate logits for all
<code>input_ids</code> (special case). Only last token logits are needed for generation, and calculating them only for that
token can save memory, which becomes pretty significant for long sequences or large vocabulary size.
If a <code>torch.Tensor</code>, must be 1D corresponding to the indices to keep in the sequence length dimension.
This is useful when using packed tensor format (single dimension for batch and sequence length).`,name:"logits_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/emu3/modeling_emu3.py#L1358",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/emu3#transformers.Emu3Config"
>Emu3Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>Cache</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — It is a <a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache"
>Cache</a> instance. For more details, see our <a
  href="https://huggingface.co/docs/transformers/en/kv_cache"
  rel="nofollow"
>kv cache guide</a>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),me=new Pt({props:{$$slots:{default:[Is]},$$scope:{ctx:v}}}),pe=new Fo({props:{anchor:"transformers.Emu3ForCausalLM.forward.example",$$slots:{default:[zs]},$$scope:{ctx:v}}}),rt=new I({props:{title:"Emu3ForConditionalGeneration",local:"transformers.Emu3ForConditionalGeneration",headingTag:"h2"}}),it=new k({props:{name:"class transformers.Emu3ForConditionalGeneration",anchor:"transformers.Emu3ForConditionalGeneration",parameters:[{name:"config",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/emu3/modeling_emu3.py#L1571"}}),lt=new k({props:{name:"forward",anchor:"transformers.Emu3ForConditionalGeneration.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"pixel_values",val:": FloatTensor = None"},{name:"image_sizes",val:": Tensor = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[transformers.cache_utils.Cache] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"logits_to_keep",val:": typing.Union[int, torch.Tensor] = 0"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.emu3.modeling_emu3.KwargsForCausalLM]"}],parametersDescription:[{anchor:"transformers.Emu3ForConditionalGeneration.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.Emu3ForConditionalGeneration.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.Emu3ForConditionalGeneration.forward.image_sizes",description:`<strong>image_sizes</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, 2)</code>) &#x2014;
The sizes of the images in the batch, being (height, width) for each image. Image sizes can be obtained using
<a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/main/en/model_doc/vilt#transformers.ViltFeatureExtractor.__call__">Emu3ImageProcessor.<strong>call</strong>()</a> for details ([]<code>Emu3Processor</code>] uses
<a href="/docs/transformers/main/en/model_doc/emu3#transformers.Emu3ImageProcessor">Emu3ImageProcessor</a> for processing images).`,name:"image_sizes"},{anchor:"transformers.Emu3ForConditionalGeneration.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.Emu3ForConditionalGeneration.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.Emu3ForConditionalGeneration.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>~cache_utils.Cache</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.Emu3ForConditionalGeneration.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.Emu3ForConditionalGeneration.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.Emu3ForConditionalGeneration.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Emu3ForConditionalGeneration.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Emu3ForConditionalGeneration.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.Emu3ForConditionalGeneration.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"},{anchor:"transformers.Emu3ForConditionalGeneration.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"labels"},{anchor:"transformers.Emu3ForConditionalGeneration.forward.logits_to_keep",description:`<strong>logits_to_keep</strong> (<code>Union[int, torch.Tensor]</code>, defaults to <code>0</code>) &#x2014;
If an <code>int</code>, compute logits for the last <code>logits_to_keep</code> tokens. If <code>0</code>, calculate logits for all
<code>input_ids</code> (special case). Only last token logits are needed for generation, and calculating them only for that
token can save memory, which becomes pretty significant for long sequences or large vocabulary size.
If a <code>torch.Tensor</code>, must be 1D corresponding to the indices to keep in the sequence length dimension.
This is useful when using packed tensor format (single dimension for batch and sequence length).`,name:"logits_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/emu3/modeling_emu3.py#L1622",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/emu3#transformers.Emu3Config"
>Emu3Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>Cache</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — It is a <a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache"
>Cache</a> instance. For more details, see our <a
  href="https://huggingface.co/docs/transformers/en/kv_cache"
  rel="nofollow"
>kv cache guide</a>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ue=new Pt({props:{$$slots:{default:[Ws]},$$scope:{ctx:v}}}),he=new Fo({props:{anchor:"transformers.Emu3ForConditionalGeneration.forward.example",$$slots:{default:[Zs]},$$scope:{ctx:v}}}),dt=new Js({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/emu3.md"}}),{c(){r=d("meta"),y=n(),l=d("p"),b=n(),m(J.$$.fragment),T=n(),E=d("div"),E.innerHTML=Zn,Ht=n(),m(_e.$$.fragment),St=n(),ye=d("p"),ye.innerHTML=Vn,Yt=n(),be=d("p"),be.textContent=Bn,Dt=n(),Te=d("p"),Te.textContent=Fn,Ot=n(),Me=d("p"),Me.innerHTML=Gn,Kt=n(),we=d("p"),we.textContent=Rn,eo=n(),ve=d("ul"),ve.innerHTML=Qn,to=n(),m(ee.$$.fragment),oo=n(),ke=d("p"),ke.innerHTML=Ln,no=n(),m(Je.$$.fragment),so=n(),m(Ee.$$.fragment),ao=n(),Ce=d("p"),Ce.innerHTML=Nn,ro=n(),m(xe.$$.fragment),io=n(),m(Ue.$$.fragment),lo=n(),je=d("p"),je.textContent=Pn,co=n(),m($e.$$.fragment),mo=n(),m(Ie.$$.fragment),po=n(),R=d("div"),m(ze.$$.fragment),Go=n(),pt=d("p"),pt.innerHTML=qn,Ro=n(),ut=d("p"),ut.innerHTML=An,uo=n(),m(We.$$.fragment),ho=n(),z=d("div"),m(Ze.$$.fragment),Qo=n(),ht=d("p"),ht.innerHTML=Xn,Lo=n(),gt=d("p"),gt.innerHTML=Hn,No=n(),m(te.$$.fragment),go=n(),m(Ve.$$.fragment),fo=n(),W=d("div"),m(Be.$$.fragment),Po=n(),ft=d("p"),ft.innerHTML=Sn,qo=n(),_t=d("p"),_t.innerHTML=Yn,Ao=n(),m(oe.$$.fragment),_o=n(),m(Fe.$$.fragment),yo=n(),C=d("div"),m(Ge.$$.fragment),Xo=n(),yt=d("p"),yt.textContent=Dn,Ho=n(),bt=d("p"),bt.innerHTML=On,So=n(),ne=d("div"),m(Re.$$.fragment),Yo=n(),Tt=d("p"),Tt.innerHTML=Kn,Do=n(),se=d("div"),m(Qe.$$.fragment),Oo=n(),Mt=d("p"),Mt.innerHTML=es,bo=n(),m(Le.$$.fragment),To=n(),Q=d("div"),m(Ne.$$.fragment),Ko=n(),wt=d("p"),wt.textContent=ts,en=n(),vt=d("div"),m(Pe.$$.fragment),Mo=n(),m(qe.$$.fragment),wo=n(),x=d("div"),m(Ae.$$.fragment),tn=n(),kt=d("p"),kt.innerHTML=os,on=n(),Jt=d("p"),Jt.innerHTML=ns,nn=n(),Et=d("p"),Et.innerHTML=ss,sn=n(),B=d("div"),m(Xe.$$.fragment),an=n(),Ct=d("p"),Ct.textContent=as,rn=n(),xt=d("p"),xt.textContent=rs,ln=n(),m(ae.$$.fragment),vo=n(),m(He.$$.fragment),ko=n(),U=d("div"),m(Se.$$.fragment),dn=n(),Ut=d("p"),Ut.textContent=is,cn=n(),jt=d("p"),jt.innerHTML=ls,mn=n(),$t=d("p"),$t.innerHTML=ds,pn=n(),q=d("div"),m(Ye.$$.fragment),un=n(),It=d("p"),It.innerHTML=cs,hn=n(),m(re.$$.fragment),Jo=n(),m(De.$$.fragment),Eo=n(),j=d("div"),m(Oe.$$.fragment),gn=n(),ie=d("div"),m(Ke.$$.fragment),fn=n(),zt=d("p"),zt.textContent=ms,_n=n(),A=d("div"),m(et.$$.fragment),yn=n(),Wt=d("p"),Wt.innerHTML=ps,bn=n(),m(le.$$.fragment),Tn=n(),de=d("div"),m(tt.$$.fragment),Mn=n(),Zt=d("p"),Zt.textContent=us,wn=n(),ce=d("div"),m(ot.$$.fragment),vn=n(),Vt=d("p"),Vt.textContent=hs,Co=n(),m(nt.$$.fragment),xo=n(),$=d("div"),m(st.$$.fragment),kn=n(),Bt=d("p"),Bt.textContent=gs,Jn=n(),Ft=d("p"),Ft.innerHTML=fs,En=n(),Gt=d("p"),Gt.innerHTML=_s,Cn=n(),F=d("div"),m(at.$$.fragment),xn=n(),Rt=d("p"),Rt.innerHTML=ys,Un=n(),m(me.$$.fragment),jn=n(),m(pe.$$.fragment),Uo=n(),m(rt.$$.fragment),jo=n(),D=d("div"),m(it.$$.fragment),$n=n(),G=d("div"),m(lt.$$.fragment),In=n(),Qt=d("p"),Qt.innerHTML=bs,zn=n(),m(ue.$$.fragment),Wn=n(),m(he.$$.fragment),$o=n(),m(dt.$$.fragment),Io=n(),At=d("p"),this.h()},l(e){const t=ks("svelte-u9bgzb",document.head);r=c(t,"META",{name:!0,content:!0}),t.forEach(o),y=s(e),l=c(e,"P",{}),w(l).forEach(o),b=s(e),p(J.$$.fragment,e),T=s(e),E=c(e,"DIV",{class:!0,"data-svelte-h":!0}),_(E)!=="svelte-b95w5j"&&(E.innerHTML=Zn),Ht=s(e),p(_e.$$.fragment,e),St=s(e),ye=c(e,"P",{"data-svelte-h":!0}),_(ye)!=="svelte-1obcc32"&&(ye.innerHTML=Vn),Yt=s(e),be=c(e,"P",{"data-svelte-h":!0}),_(be)!=="svelte-e8x44f"&&(be.textContent=Bn),Dt=s(e),Te=c(e,"P",{"data-svelte-h":!0}),_(Te)!=="svelte-vfdo9a"&&(Te.textContent=Fn),Ot=s(e),Me=c(e,"P",{"data-svelte-h":!0}),_(Me)!=="svelte-1h0gla8"&&(Me.innerHTML=Gn),Kt=s(e),we=c(e,"P",{"data-svelte-h":!0}),_(we)!=="svelte-axv494"&&(we.textContent=Rn),eo=s(e),ve=c(e,"UL",{"data-svelte-h":!0}),_(ve)!=="svelte-70x06q"&&(ve.innerHTML=Qn),to=s(e),p(ee.$$.fragment,e),oo=s(e),ke=c(e,"P",{"data-svelte-h":!0}),_(ke)!=="svelte-icel92"&&(ke.innerHTML=Ln),no=s(e),p(Je.$$.fragment,e),so=s(e),p(Ee.$$.fragment,e),ao=s(e),Ce=c(e,"P",{"data-svelte-h":!0}),_(Ce)!=="svelte-1krl2ia"&&(Ce.innerHTML=Nn),ro=s(e),p(xe.$$.fragment,e),io=s(e),p(Ue.$$.fragment,e),lo=s(e),je=c(e,"P",{"data-svelte-h":!0}),_(je)!=="svelte-a7zypi"&&(je.textContent=Pn),co=s(e),p($e.$$.fragment,e),mo=s(e),p(Ie.$$.fragment,e),po=s(e),R=c(e,"DIV",{class:!0});var O=w(R);p(ze.$$.fragment,O),Go=s(O),pt=c(O,"P",{"data-svelte-h":!0}),_(pt)!=="svelte-1tz5rb2"&&(pt.innerHTML=qn),Ro=s(O),ut=c(O,"P",{"data-svelte-h":!0}),_(ut)!=="svelte-o55m63"&&(ut.innerHTML=An),O.forEach(o),uo=s(e),p(We.$$.fragment,e),ho=s(e),z=c(e,"DIV",{class:!0});var L=w(z);p(Ze.$$.fragment,L),Qo=s(L),ht=c(L,"P",{"data-svelte-h":!0}),_(ht)!=="svelte-1b4awql"&&(ht.innerHTML=Xn),Lo=s(L),gt=c(L,"P",{"data-svelte-h":!0}),_(gt)!=="svelte-o55m63"&&(gt.innerHTML=Hn),No=s(L),p(te.$$.fragment,L),L.forEach(o),go=s(e),p(Ve.$$.fragment,e),fo=s(e),W=c(e,"DIV",{class:!0});var N=w(W);p(Be.$$.fragment,N),Po=s(N),ft=c(N,"P",{"data-svelte-h":!0}),_(ft)!=="svelte-uux9ae"&&(ft.innerHTML=Sn),qo=s(N),_t=c(N,"P",{"data-svelte-h":!0}),_(_t)!=="svelte-o55m63"&&(_t.innerHTML=Yn),Ao=s(N),p(oe.$$.fragment,N),N.forEach(o),_o=s(e),p(Fe.$$.fragment,e),yo=s(e),C=c(e,"DIV",{class:!0});var Z=w(C);p(Ge.$$.fragment,Z),Xo=s(Z),yt=c(Z,"P",{"data-svelte-h":!0}),_(yt)!=="svelte-jza07y"&&(yt.textContent=Dn),Ho=s(Z),bt=c(Z,"P",{"data-svelte-h":!0}),_(bt)!=="svelte-120txaj"&&(bt.innerHTML=On),So=s(Z),ne=c(Z,"DIV",{class:!0});var ct=w(ne);p(Re.$$.fragment,ct),Yo=s(ct),Tt=c(ct,"P",{"data-svelte-h":!0}),_(Tt)!=="svelte-xyq33x"&&(Tt.innerHTML=Kn),ct.forEach(o),Do=s(Z),se=c(Z,"DIV",{class:!0});var mt=w(se);p(Qe.$$.fragment,mt),Oo=s(mt),Mt=c(mt,"P",{"data-svelte-h":!0}),_(Mt)!=="svelte-15q229j"&&(Mt.innerHTML=es),mt.forEach(o),Z.forEach(o),bo=s(e),p(Le.$$.fragment,e),To=s(e),Q=c(e,"DIV",{class:!0});var K=w(Q);p(Ne.$$.fragment,K),Ko=s(K),wt=c(K,"P",{"data-svelte-h":!0}),_(wt)!=="svelte-16rx7fp"&&(wt.textContent=ts),en=s(K),vt=c(K,"DIV",{class:!0});var Xt=w(vt);p(Pe.$$.fragment,Xt),Xt.forEach(o),K.forEach(o),Mo=s(e),p(qe.$$.fragment,e),wo=s(e),x=c(e,"DIV",{class:!0});var V=w(x);p(Ae.$$.fragment,V),tn=s(V),kt=c(V,"P",{"data-svelte-h":!0}),_(kt)!=="svelte-1bqqyxl"&&(kt.innerHTML=os),on=s(V),Jt=c(V,"P",{"data-svelte-h":!0}),_(Jt)!=="svelte-6pahdo"&&(Jt.innerHTML=ns),nn=s(V),Et=c(V,"P",{"data-svelte-h":!0}),_(Et)!=="svelte-hswkmf"&&(Et.innerHTML=ss),sn=s(V),B=c(V,"DIV",{class:!0});var P=w(B);p(Xe.$$.fragment,P),an=s(P),Ct=c(P,"P",{"data-svelte-h":!0}),_(Ct)!=="svelte-1q5ym45"&&(Ct.textContent=as),rn=s(P),xt=c(P,"P",{"data-svelte-h":!0}),_(xt)!=="svelte-w8wo9i"&&(xt.textContent=rs),ln=s(P),p(ae.$$.fragment,P),P.forEach(o),V.forEach(o),vo=s(e),p(He.$$.fragment,e),ko=s(e),U=c(e,"DIV",{class:!0});var X=w(U);p(Se.$$.fragment,X),dn=s(X),Ut=c(X,"P",{"data-svelte-h":!0}),_(Ut)!=="svelte-dfog0h"&&(Ut.textContent=is),cn=s(X),jt=c(X,"P",{"data-svelte-h":!0}),_(jt)!=="svelte-6pahdo"&&(jt.innerHTML=ls),mn=s(X),$t=c(X,"P",{"data-svelte-h":!0}),_($t)!=="svelte-hswkmf"&&($t.innerHTML=ds),pn=s(X),q=c(X,"DIV",{class:!0});var Lt=w(q);p(Ye.$$.fragment,Lt),un=s(Lt),It=c(Lt,"P",{"data-svelte-h":!0}),_(It)!=="svelte-1ndfvqx"&&(It.innerHTML=cs),hn=s(Lt),p(re.$$.fragment,Lt),Lt.forEach(o),X.forEach(o),Jo=s(e),p(De.$$.fragment,e),Eo=s(e),j=c(e,"DIV",{class:!0});var H=w(j);p(Oe.$$.fragment,H),gn=s(H),ie=c(H,"DIV",{class:!0});var Wo=w(ie);p(Ke.$$.fragment,Wo),fn=s(Wo),zt=c(Wo,"P",{"data-svelte-h":!0}),_(zt)!=="svelte-jutbh1"&&(zt.textContent=ms),Wo.forEach(o),_n=s(H),A=c(H,"DIV",{class:!0});var Nt=w(A);p(et.$$.fragment,Nt),yn=s(Nt),Wt=c(Nt,"P",{"data-svelte-h":!0}),_(Wt)!=="svelte-y5xkoh"&&(Wt.innerHTML=ps),bn=s(Nt),p(le.$$.fragment,Nt),Nt.forEach(o),Tn=s(H),de=c(H,"DIV",{class:!0});var Zo=w(de);p(tt.$$.fragment,Zo),Mn=s(Zo),Zt=c(Zo,"P",{"data-svelte-h":!0}),_(Zt)!=="svelte-1xu5pjr"&&(Zt.textContent=us),Zo.forEach(o),wn=s(H),ce=c(H,"DIV",{class:!0});var Vo=w(ce);p(ot.$$.fragment,Vo),vn=s(Vo),Vt=c(Vo,"P",{"data-svelte-h":!0}),_(Vt)!=="svelte-1d6cjnh"&&(Vt.textContent=hs),Vo.forEach(o),H.forEach(o),Co=s(e),p(nt.$$.fragment,e),xo=s(e),$=c(e,"DIV",{class:!0});var S=w($);p(st.$$.fragment,S),kn=s(S),Bt=c(S,"P",{"data-svelte-h":!0}),_(Bt)!=="svelte-1ifml6t"&&(Bt.textContent=gs),Jn=s(S),Ft=c(S,"P",{"data-svelte-h":!0}),_(Ft)!=="svelte-6pahdo"&&(Ft.innerHTML=fs),En=s(S),Gt=c(S,"P",{"data-svelte-h":!0}),_(Gt)!=="svelte-hswkmf"&&(Gt.innerHTML=_s),Cn=s(S),F=c(S,"DIV",{class:!0});var ge=w(F);p(at.$$.fragment,ge),xn=s(ge),Rt=c(ge,"P",{"data-svelte-h":!0}),_(Rt)!=="svelte-7wcvwl"&&(Rt.innerHTML=ys),Un=s(ge),p(me.$$.fragment,ge),jn=s(ge),p(pe.$$.fragment,ge),ge.forEach(o),S.forEach(o),Uo=s(e),p(rt.$$.fragment,e),jo=s(e),D=c(e,"DIV",{class:!0});var Bo=w(D);p(it.$$.fragment,Bo),$n=s(Bo),G=c(Bo,"DIV",{class:!0});var fe=w(G);p(lt.$$.fragment,fe),In=s(fe),Qt=c(fe,"P",{"data-svelte-h":!0}),_(Qt)!=="svelte-b8oeq3"&&(Qt.innerHTML=bs),zn=s(fe),p(ue.$$.fragment,fe),Wn=s(fe),p(he.$$.fragment,fe),fe.forEach(o),Bo.forEach(o),$o=s(e),p(dt.$$.fragment,e),Io=s(e),At=c(e,"P",{}),w(At).forEach(o),this.h()},h(){M(r,"name","hf:doc:metadata"),M(r,"content",Bs),M(E,"class","flex flex-wrap space-x-1"),M(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(vt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){a(document.head,r),i(e,y,t),i(e,l,t),i(e,b,t),u(J,e,t),i(e,T,t),i(e,E,t),i(e,Ht,t),u(_e,e,t),i(e,St,t),i(e,ye,t),i(e,Yt,t),i(e,be,t),i(e,Dt,t),i(e,Te,t),i(e,Ot,t),i(e,Me,t),i(e,Kt,t),i(e,we,t),i(e,eo,t),i(e,ve,t),i(e,to,t),u(ee,e,t),i(e,oo,t),i(e,ke,t),i(e,no,t),u(Je,e,t),i(e,so,t),u(Ee,e,t),i(e,ao,t),i(e,Ce,t),i(e,ro,t),u(xe,e,t),i(e,io,t),u(Ue,e,t),i(e,lo,t),i(e,je,t),i(e,co,t),u($e,e,t),i(e,mo,t),u(Ie,e,t),i(e,po,t),i(e,R,t),u(ze,R,null),a(R,Go),a(R,pt),a(R,Ro),a(R,ut),i(e,uo,t),u(We,e,t),i(e,ho,t),i(e,z,t),u(Ze,z,null),a(z,Qo),a(z,ht),a(z,Lo),a(z,gt),a(z,No),u(te,z,null),i(e,go,t),u(Ve,e,t),i(e,fo,t),i(e,W,t),u(Be,W,null),a(W,Po),a(W,ft),a(W,qo),a(W,_t),a(W,Ao),u(oe,W,null),i(e,_o,t),u(Fe,e,t),i(e,yo,t),i(e,C,t),u(Ge,C,null),a(C,Xo),a(C,yt),a(C,Ho),a(C,bt),a(C,So),a(C,ne),u(Re,ne,null),a(ne,Yo),a(ne,Tt),a(C,Do),a(C,se),u(Qe,se,null),a(se,Oo),a(se,Mt),i(e,bo,t),u(Le,e,t),i(e,To,t),i(e,Q,t),u(Ne,Q,null),a(Q,Ko),a(Q,wt),a(Q,en),a(Q,vt),u(Pe,vt,null),i(e,Mo,t),u(qe,e,t),i(e,wo,t),i(e,x,t),u(Ae,x,null),a(x,tn),a(x,kt),a(x,on),a(x,Jt),a(x,nn),a(x,Et),a(x,sn),a(x,B),u(Xe,B,null),a(B,an),a(B,Ct),a(B,rn),a(B,xt),a(B,ln),u(ae,B,null),i(e,vo,t),u(He,e,t),i(e,ko,t),i(e,U,t),u(Se,U,null),a(U,dn),a(U,Ut),a(U,cn),a(U,jt),a(U,mn),a(U,$t),a(U,pn),a(U,q),u(Ye,q,null),a(q,un),a(q,It),a(q,hn),u(re,q,null),i(e,Jo,t),u(De,e,t),i(e,Eo,t),i(e,j,t),u(Oe,j,null),a(j,gn),a(j,ie),u(Ke,ie,null),a(ie,fn),a(ie,zt),a(j,_n),a(j,A),u(et,A,null),a(A,yn),a(A,Wt),a(A,bn),u(le,A,null),a(j,Tn),a(j,de),u(tt,de,null),a(de,Mn),a(de,Zt),a(j,wn),a(j,ce),u(ot,ce,null),a(ce,vn),a(ce,Vt),i(e,Co,t),u(nt,e,t),i(e,xo,t),i(e,$,t),u(st,$,null),a($,kn),a($,Bt),a($,Jn),a($,Ft),a($,En),a($,Gt),a($,Cn),a($,F),u(at,F,null),a(F,xn),a(F,Rt),a(F,Un),u(me,F,null),a(F,jn),u(pe,F,null),i(e,Uo,t),u(rt,e,t),i(e,jo,t),i(e,D,t),u(it,D,null),a(D,$n),a(D,G),u(lt,G,null),a(G,In),a(G,Qt),a(G,zn),u(ue,G,null),a(G,Wn),u(he,G,null),i(e,$o,t),u(dt,e,t),i(e,Io,t),i(e,At,t),zo=!0},p(e,[t]){const O={};t&2&&(O.$$scope={dirty:t,ctx:e}),ee.$set(O);const L={};t&2&&(L.$$scope={dirty:t,ctx:e}),te.$set(L);const N={};t&2&&(N.$$scope={dirty:t,ctx:e}),oe.$set(N);const Z={};t&2&&(Z.$$scope={dirty:t,ctx:e}),ae.$set(Z);const ct={};t&2&&(ct.$$scope={dirty:t,ctx:e}),re.$set(ct);const mt={};t&2&&(mt.$$scope={dirty:t,ctx:e}),le.$set(mt);const K={};t&2&&(K.$$scope={dirty:t,ctx:e}),me.$set(K);const Xt={};t&2&&(Xt.$$scope={dirty:t,ctx:e}),pe.$set(Xt);const V={};t&2&&(V.$$scope={dirty:t,ctx:e}),ue.$set(V);const P={};t&2&&(P.$$scope={dirty:t,ctx:e}),he.$set(P)},i(e){zo||(h(J.$$.fragment,e),h(_e.$$.fragment,e),h(ee.$$.fragment,e),h(Je.$$.fragment,e),h(Ee.$$.fragment,e),h(xe.$$.fragment,e),h(Ue.$$.fragment,e),h($e.$$.fragment,e),h(Ie.$$.fragment,e),h(ze.$$.fragment,e),h(We.$$.fragment,e),h(Ze.$$.fragment,e),h(te.$$.fragment,e),h(Ve.$$.fragment,e),h(Be.$$.fragment,e),h(oe.$$.fragment,e),h(Fe.$$.fragment,e),h(Ge.$$.fragment,e),h(Re.$$.fragment,e),h(Qe.$$.fragment,e),h(Le.$$.fragment,e),h(Ne.$$.fragment,e),h(Pe.$$.fragment,e),h(qe.$$.fragment,e),h(Ae.$$.fragment,e),h(Xe.$$.fragment,e),h(ae.$$.fragment,e),h(He.$$.fragment,e),h(Se.$$.fragment,e),h(Ye.$$.fragment,e),h(re.$$.fragment,e),h(De.$$.fragment,e),h(Oe.$$.fragment,e),h(Ke.$$.fragment,e),h(et.$$.fragment,e),h(le.$$.fragment,e),h(tt.$$.fragment,e),h(ot.$$.fragment,e),h(nt.$$.fragment,e),h(st.$$.fragment,e),h(at.$$.fragment,e),h(me.$$.fragment,e),h(pe.$$.fragment,e),h(rt.$$.fragment,e),h(it.$$.fragment,e),h(lt.$$.fragment,e),h(ue.$$.fragment,e),h(he.$$.fragment,e),h(dt.$$.fragment,e),zo=!0)},o(e){g(J.$$.fragment,e),g(_e.$$.fragment,e),g(ee.$$.fragment,e),g(Je.$$.fragment,e),g(Ee.$$.fragment,e),g(xe.$$.fragment,e),g(Ue.$$.fragment,e),g($e.$$.fragment,e),g(Ie.$$.fragment,e),g(ze.$$.fragment,e),g(We.$$.fragment,e),g(Ze.$$.fragment,e),g(te.$$.fragment,e),g(Ve.$$.fragment,e),g(Be.$$.fragment,e),g(oe.$$.fragment,e),g(Fe.$$.fragment,e),g(Ge.$$.fragment,e),g(Re.$$.fragment,e),g(Qe.$$.fragment,e),g(Le.$$.fragment,e),g(Ne.$$.fragment,e),g(Pe.$$.fragment,e),g(qe.$$.fragment,e),g(Ae.$$.fragment,e),g(Xe.$$.fragment,e),g(ae.$$.fragment,e),g(He.$$.fragment,e),g(Se.$$.fragment,e),g(Ye.$$.fragment,e),g(re.$$.fragment,e),g(De.$$.fragment,e),g(Oe.$$.fragment,e),g(Ke.$$.fragment,e),g(et.$$.fragment,e),g(le.$$.fragment,e),g(tt.$$.fragment,e),g(ot.$$.fragment,e),g(nt.$$.fragment,e),g(st.$$.fragment,e),g(at.$$.fragment,e),g(me.$$.fragment,e),g(pe.$$.fragment,e),g(rt.$$.fragment,e),g(it.$$.fragment,e),g(lt.$$.fragment,e),g(ue.$$.fragment,e),g(he.$$.fragment,e),g(dt.$$.fragment,e),zo=!1},d(e){e&&(o(y),o(l),o(b),o(T),o(E),o(Ht),o(St),o(ye),o(Yt),o(be),o(Dt),o(Te),o(Ot),o(Me),o(Kt),o(we),o(eo),o(ve),o(to),o(oo),o(ke),o(no),o(so),o(ao),o(Ce),o(ro),o(io),o(lo),o(je),o(co),o(mo),o(po),o(R),o(uo),o(ho),o(z),o(go),o(fo),o(W),o(_o),o(yo),o(C),o(bo),o(To),o(Q),o(Mo),o(wo),o(x),o(vo),o(ko),o(U),o(Jo),o(Eo),o(j),o(Co),o(xo),o($),o(Uo),o(jo),o(D),o($o),o(Io),o(At)),o(r),f(J,e),f(_e,e),f(ee,e),f(Je,e),f(Ee,e),f(xe,e),f(Ue,e),f($e,e),f(Ie,e),f(ze),f(We,e),f(Ze),f(te),f(Ve,e),f(Be),f(oe),f(Fe,e),f(Ge),f(Re),f(Qe),f(Le,e),f(Ne),f(Pe),f(qe,e),f(Ae),f(Xe),f(ae),f(He,e),f(Se),f(Ye),f(re),f(De,e),f(Oe),f(Ke),f(et),f(le),f(tt),f(ot),f(nt,e),f(st),f(at),f(me),f(pe),f(rt,e),f(it),f(lt),f(ue),f(he),f(dt,e)}}}const Bs='{"title":"Emu3","local":"emu3","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage example","local":"usage-example","sections":[{"title":"Text generation inference","local":"text-generation-inference","sections":[],"depth":3},{"title":"Image generation inference","local":"image-generation-inference","sections":[],"depth":3}],"depth":2},{"title":"Emu3Config","local":"transformers.Emu3Config","sections":[],"depth":2},{"title":"Emu3VQVAEConfig","local":"transformers.Emu3VQVAEConfig","sections":[],"depth":2},{"title":"Emu3TextConfig","local":"transformers.Emu3TextConfig","sections":[],"depth":2},{"title":"Emu3Processor","local":"transformers.Emu3Processor","sections":[],"depth":2},{"title":"Emu3ImageProcessor","local":"transformers.Emu3ImageProcessor","sections":[],"depth":2},{"title":"Emu3VQVAE","local":"transformers.Emu3VQVAE","sections":[],"depth":2},{"title":"Emu3TextModel","local":"transformers.Emu3TextModel","sections":[],"depth":2},{"title":"Emu3Model","local":"transformers.Emu3Model","sections":[],"depth":2},{"title":"Emu3ForCausalLM","local":"transformers.Emu3ForCausalLM","sections":[],"depth":2},{"title":"Emu3ForConditionalGeneration","local":"transformers.Emu3ForConditionalGeneration","sections":[],"depth":2}],"depth":1}';function Fs(v){return Ms(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xs extends ws{constructor(r){super(),vs(this,r,Fs,Vs,Ts,{})}}export{Xs as component};
