import{s as Uo,o as Wo,n as Ke}from"../chunks/scheduler.18a86fab.js";import{S as jo,i as qo,g as d,s as n,r as u,A as Vo,h as l,f as o,c as s,j as Z,u as p,x as m,k as x,y as r,a,v as h,d as f,t as g,w as _}from"../chunks/index.98837b22.js";import{T as so}from"../chunks/Tip.77304350.js";import{D as W}from"../chunks/Docstring.6758ea23.js";import{C as Qe}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as Po}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as Ie}from"../chunks/Heading.7e7e0c5b.js";import{E as Xo}from"../chunks/getInferenceSnippets.de10bc7d.js";function Go(J){let i,v=`The <code>Fuyu</code> models were trained using <code>bfloat16</code>, but the original inference uses <code>float16</code> The checkpoints uploaded on the hub use <code>torch_dtype = &#39;float16&#39;</code> which will be
used by the <code>AutoModel</code> API to cast the checkpoints from <code>torch.float32</code> to <code>torch.float16</code>.`,c,y,k="The <code>dtype</code> of the online weights is mostly irrelevant, unless you are using <code>torch_dtype=&quot;auto&quot;</code> when initializing a model using <code>model = AutoModelForCausalLM.from_pretrained(&quot;path&quot;, torch_dtype = &quot;auto&quot;)</code>. The reason is that the model will first be downloaded ( using the <code>dtype</code> of the checkpoints online) then it will be cast to the default <code>dtype</code> of <code>torch</code> (becomes <code>torch.float32</code>). Users should specify the <code>torch_dtype</code> they want, and if they don’t it will be <code>torch.float32</code>.",b,T,Ae="Finetuning the model in <code>float16</code> is not recommended and known to produce <code>nan</code>, as such the model should be fine-tuned in <code>bfloat16</code>.";return{c(){i=d("p"),i.innerHTML=v,c=n(),y=d("p"),y.innerHTML=k,b=n(),T=d("p"),T.innerHTML=Ae},l(M){i=l(M,"P",{"data-svelte-h":!0}),m(i)!=="svelte-ydwkb0"&&(i.innerHTML=v),c=s(M),y=l(M,"P",{"data-svelte-h":!0}),m(y)!=="svelte-1mgue3n"&&(y.innerHTML=k),b=s(M),T=l(M,"P",{"data-svelte-h":!0}),m(T)!=="svelte-1p3drsu"&&(T.innerHTML=Ae)},m(M,C){a(M,i,C),a(M,c,C),a(M,y,C),a(M,b,C),a(M,T,C)},p:Ke,d(M){M&&(o(i),o(c),o(y),o(b),o(T))}}}function Ho(J){let i,v;return i=new Qe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEZ1eXVDb25maWclMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwRnV5dSUyMGZ1eXUtN2IlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwRnV5dUNvbmZpZygp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> FuyuConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Fuyu fuyu-7b style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = FuyuConfig()`,wrap:!1}}),{c(){u(i.$$.fragment)},l(c){p(i.$$.fragment,c)},m(c,y){h(i,c,y),v=!0},p:Ke,i(c){v||(f(i.$$.fragment,c),v=!0)},o(c){g(i.$$.fragment,c),v=!1},d(c){_(i,c)}}}function No(J){let i,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){i=d("p"),i.innerHTML=v},l(c){i=l(c,"P",{"data-svelte-h":!0}),m(i)!=="svelte-fincs2"&&(i.innerHTML=v)},m(c,y){a(c,i,y)},p:Ke,d(c){c&&o(i)}}}function Ro(J){let i,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){i=d("p"),i.innerHTML=v},l(c){i=l(c,"P",{"data-svelte-h":!0}),m(i)!=="svelte-fincs2"&&(i.innerHTML=v)},m(c,y){a(c,i,y)},p:Ke,d(c){c&&o(i)}}}function Bo(J){let i,v="Examples:",c,y,k;return y=new Qe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEZ1eXVQcm9jZXNzb3IlMkMlMjBGdXl1Rm9yQ2F1c2FsTE0lMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEZ1eXVQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmFkZXB0JTJGZnV5dS04YiUyMiklMEFtb2RlbCUyMCUzRCUyMEZ1eXVGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyYWRlcHQlMkZmdXl1LThiJTIyKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmhmLWludGVybmFsLXRlc3RpbmclMkZmaXh0dXJlcy1jYXB0aW9uaW5nJTJGcmVzb2x2ZSUyRm1haW4lMkZidXMucG5nJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBcHJvbXB0JTIwJTNEJTIwJTIyR2VuZXJhdGUlMjBhJTIwY29jby1zdHlsZSUyMGNhcHRpb24uJTVDbiUyMiUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvcihpbWFnZXMlM0RpbWFnZSUyQyUyMHRleHQlM0Rwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMEFnZW5lcmF0ZWRfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDcpJTBBZ2VuZXJhdGlvbl90ZXh0JTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTVCJTNBJTJDJTIwLTclM0ElNUQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklMEFwcmludChnZW5lcmF0aW9uX3RleHQlNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> FuyuProcessor, FuyuForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = FuyuProcessor.from_pretrained(<span class="hljs-string">&quot;adept/fuyu-8b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FuyuForCausalLM.from_pretrained(<span class="hljs-string">&quot;adept/fuyu-8b&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/fixtures-captioning/resolve/main/bus.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Generate a coco-style caption.\\n&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, text=prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">7</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_text = processor.batch_decode(generated_ids[:, -<span class="hljs-number">7</span>:], skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(generation_text[<span class="hljs-number">0</span>])
A blue bus parked on the side of a road.`,wrap:!1}}),{c(){i=d("p"),i.textContent=v,c=n(),u(y.$$.fragment)},l(b){i=l(b,"P",{"data-svelte-h":!0}),m(i)!=="svelte-kvfsh7"&&(i.textContent=v),c=s(b),p(y.$$.fragment,b)},m(b,T){a(b,i,T),a(b,c,T),h(y,b,T),k=!0},p:Ke,i(b){k||(f(y.$$.fragment,b),k=!0)},o(b){g(y.$$.fragment,b),k=!1},d(b){b&&(o(i),o(c)),_(y,b)}}}function Eo(J){let i,v,c,y,k,b,T,Ae='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',M,C,et,O,ao='The Fuyu model was created by <a href="https://www.adept.ai/blog/fuyu-8b" rel="nofollow">ADEPT</a>, and authored by Rohan Bavishi, Erich Elsen, Curtis Hawthorne, Maxwell Nye, Augustus Odena, Arushi Somani, Sağnak Taşırlar.',tt,K,ro="The authors introduced Fuyu-8B, a decoder-only multimodal model based on the classic transformers architecture, with query and key normalization. A linear encoder is added to create multimodal embeddings from image inputs.",ot,ee,io="By treating image tokens like text tokens and using a special image-newline character, the model knows when an image line ends. Image positional embeddings are removed. This avoids the need for different training phases for various image resolutions. With 8 billion parameters and licensed under CC-BY-NC, Fuyu-8B is notable for its ability to handle both text and images, its impressive context size of 16K, and its overall performance.",nt,X,st,te,lo="Tips:",at,oe,co="<li>To convert the model, you need to clone the original repository using <code>git clone https://github.com/persimmon-ai-labs/adept-inference</code>, then get the checkpoints:</li>",rt,ne,it,se,mo="For the chat model:",dt,ae,lt,re,uo="Then, model can be loaded via:",ct,ie,mt,de,po=`Inputs need to be passed through a specific Processor to have the correct formats.
A processor requires an image_processor and a tokenizer. Hence, inputs can be loaded via:`,ut,le,pt,ce,ho=`This model was contributed by <a href="https://huggingface.co/Molbap" rel="nofollow">Molbap</a>.
The original code can be found <a href="https://github.com/persimmon-ai-labs/adept-inference" rel="nofollow">here</a>.`,ht,me,fo=`<li><p>Fuyu uses a <code>sentencepiece</code> based tokenizer, with a <code>Unigram</code> model. It supports bytefallback, which is only available in <code>tokenizers==0.14.0</code> for the fast tokenizer.
The <code>LlamaTokenizer</code> is used as it is a standard wrapper around sentencepiece.</p></li> <li><p>The authors suggest to use the following prompt for image captioning: <code>f&quot;Generate a coco-style caption.\\\\n&quot;</code></p></li>`,ft,ue,gt,z,pe,Lt,Ze,go=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/fuyu#transformers.FuyuForCausalLM">FuyuForCausalLM</a>. It is used to instantiate an
Fuyu model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the
<a href="https://huggingface.co/adept/fuyu-8b" rel="nofollow">adept/fuyu-8b</a>.`,It,Je,_o=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Zt,G,_t,he,yt,w,fe,Jt,Pe,yo="The Fuyu model which consists of a vision backbone and a language model, without a language modeling head.",Pt,Ue,bo=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Ut,We,vo=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Wt,j,ge,jt,je,To='The <a href="/docs/transformers/main/en/model_doc/fuyu#transformers.FuyuModel">FuyuModel</a> forward method, overrides the <code>__call__</code> special method.',qt,H,Vt,N,_e,Xt,qe,wo=`This function places the continuous_embeddings into the word_embeddings at the locations
indicated by image_patch_input_indices. Different batch elements can have different numbers of continuous
embeddings.`,Gt,R,ye,Ht,Ve,Mo="Encodes images into continuous embeddings that can be forwarded to the language model.",bt,be,vt,$,ve,Nt,Xe,Fo="Fuyu Model with a language modeling head on top for causal language model conditioned on image patches and text.",Rt,Ge,ko=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Bt,He,$o=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Et,P,Te,Dt,Ne,xo='The <a href="/docs/transformers/main/en/model_doc/fuyu#transformers.FuyuForCausalLM">FuyuForCausalLM</a> forward method, overrides the <code>__call__</code> special method.',St,B,Yt,E,Tt,we,wt,L,Me,Qt,Re,Co=`This class should handle the image processing part before the main FuyuForCausalLM. In particular, it should
handle:`,At,Be,zo=`<li><p>Processing Images:
Taking a batch of images as input. If the images are variable-sized, it resizes them based on the desired patch
dimensions. The image output is always img_h, img_w of (1080, 1920)</p> <p>Then, it patches up these images using the patchify_image function.</p></li> <li><p>Creating Image Input IDs:
For each patch, a placeholder ID is given to identify where these patches belong in a token sequence. For
variable-sized images, each line of patches is terminated with a newline ID.</p></li> <li><p>Image Patch Indices:
For each image patch, the code maintains an index where these patches should be inserted in a token stream.</p></li>`,Ot,D,Fe,Kt,Ee,Lo="Preprocess an image or a batch of images.",Mt,ke,Ft,I,$e,eo,De,Io="Constructs a Fuyu processor which wraps a Fuyu image processor and a Llama tokenizer into a single processor.",to,Se,Zo=`<a href="/docs/transformers/main/en/model_doc/fuyu#transformers.FuyuProcessor">FuyuProcessor</a> offers all the functionalities of <a href="/docs/transformers/main/en/model_doc/fuyu#transformers.FuyuImageProcessor">FuyuImageProcessor</a> and <a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>. See the
<a href="/docs/transformers/main/en/model_doc/fuyu#transformers.FuyuProcessor.__call__"><strong>call</strong>()</a> and <code>decode()</code> for more information.`,oo,S,xe,no,Ye,Jo=`Main method to prepare for the model one or several sequences(s) and image(s). This method forwards the <code>text</code>
and <code>kwargs</code> arguments to LlamaTokenizerFast’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__"><strong>call</strong>()</a> if <code>text</code> is not <code>None</code> to
encode the text. To prepare the image(s), this method forwards the <code>images</code> and <code>kwargs</code> arguments to
FuyuImageProcessor’s <a href="/docs/transformers/main/en/model_doc/vilt#transformers.ViltFeatureExtractor.__call__"><strong>call</strong>()</a> if <code>images</code> is not <code>None</code>. Please refer to the docstring
of the above two methods for more information.`,kt,Ce,$t,Oe,xt;return k=new Ie({props:{title:"Fuyu",local:"fuyu",headingTag:"h1"}}),C=new Ie({props:{title:"Overview",local:"overview",headingTag:"h2"}}),X=new so({props:{warning:!0,$$slots:{default:[Go]},$$scope:{ctx:J}}}),ne=new Qe({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZwZXJzaW1tb24tYWktbGFicyUyRmFkZXB0LWluZmVyZW5jZSUwQXdnZXQlMjBwYXRoJTJGdG8lMkZmdXl1LThiLW1vZGVsLXdlaWdodHMudGFyJTBBdGFyJTIwLXh2ZiUyMGZ1eXUtOGItbW9kZWwtd2VpZ2h0cy50YXIlMEFweXRob24lMjBzcmMlMkZ0cmFuc2Zvcm1lcnMlMkZtb2RlbHMlMkZmdXl1JTJGY29udmVydF9mdXl1X3dlaWdodHNfdG9faGYucHklMjAlMjAtLWlucHV0X2RpciUyMCUyRnBhdGglMkZ0byUyRmRvd25sb2FkZWQlMkZmdXl1JTJGd2VpZ2h0cyUyRiUyMC0tb3V0cHV0X2RpciUyMCUyRm91dHB1dCUyRnBhdGglMjAlNUMlMEElMjAlMjAlMjAlMjAtLXB0X21vZGVsX3BhdGglMjAlMkZwYXRoJTJGdG8lMkZmdXl1XzhiX3JlbGVhc2UlMkZpdGVyXzAwMDEyNTElMkZtcF9yYW5rXzAwJTJGbW9kZWxfb3B0aW1fcm5nLnB0JTBBJTIwJTIwJTIwJTIwLS1hZGFfbGliX3BhdGglMjAlMkZwYXRoJTJGdG8lMkZhZGVwdC1pbmZlcmVuY2U=",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/persimmon-ai-labs/adept-inference
wget path/to/fuyu-8b-model-weights.tar
tar -xvf fuyu-8b-model-weights.tar
python src/transformers/models/fuyu/convert_fuyu_weights_to_hf.py  --input_dir /path/to/downloaded/fuyu/weights/ --output_dir /output/path \\
    --pt_model_path /path/to/fuyu_8b_release/iter_0001251/mp_rank_00/model_optim_rng.pt
    --ada_lib_path /path/to/adept-inference`,wrap:!1}}),ae=new Qe({props:{code:"d2dldCUyMGh0dHBzJTNBJTJGJTJGYXh0a240eGw1Y2lwLm9iamVjdHN0b3JhZ2UudXMtcGhvZW5peC0xLm9jaS5jdXN0b21lci1vY2kuY29tJTJGbiUyRmF4dGtuNHhsNWNpcCUyRmIlMkZhZGVwdC1wdWJsaWMtZGF0YSUyRm8lMkY4Yl9jaGF0X21vZGVsX3JlbGVhc2UudGFyJTBBdGFyJTIwLXh2ZiUyMDhiX2Jhc2VfbW9kZWxfcmVsZWFzZS50YXI=",highlighted:`wget https://axtkn4xl5cip.objectstorage.us-phoenix-1.oci.customer-oci.com/n/axtkn4xl5cip/b/adept-public-data/o/8b_chat_model_release.tar
tar -xvf 8b_base_model_release.tar`,wrap:!1}}),ie=new Qe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEZ1eXVDb25maWclMkMlMjBGdXl1Rm9yQ2F1c2FsTE0lMEFtb2RlbF9jb25maWclMjAlM0QlMjBGdXl1Q29uZmlnKCklMEFtb2RlbCUyMCUzRCUyMEZ1eXVGb3JDYXVzYWxMTShtb2RlbF9jb25maWcpLmZyb21fcHJldHJhaW5lZCgnJTJGb3V0cHV0JTJGcGF0aCcp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> FuyuConfig, FuyuForCausalLM
model_config = FuyuConfig()
model = FuyuForCausalLM(model_config).from_pretrained(<span class="hljs-string">&#x27;/output/path&#x27;</span>)`,wrap:!1}}),le=new Qe({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwdHJhbnNmb3JtZXJzLm1vZGVscy5mdXl1LnByb2Nlc3NpbmdfZnV5dSUyMGltcG9ydCUyMEZ1eXVQcm9jZXNzb3IlMEFmcm9tJTIwdHJhbnNmb3JtZXJzLm1vZGVscy5mdXl1LmltYWdlX3Byb2Nlc3NpbmdfZnV5dSUyMGltcG9ydCUyMEZ1eXVJbWFnZVByb2Nlc3NvciUwQSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCdhZGVwdC1oZi1jb2xsYWIlMkZmdXl1LThiJyklMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBGdXl1SW1hZ2VQcm9jZXNzb3IoKSUwQSUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEZ1eXVQcm9jZXNzb3IoaW1hZ2VfcHJvY2Vzc29yJTNEaW1hZ2VfcHJvY2Vzc29yJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQXRleHRfcHJvbXB0JTIwJTNEJTIwJTIyR2VuZXJhdGUlMjBhJTIwY29jby1zdHlsZSUyMGNhcHRpb24uJTVDJTVDbiUyMiUwQSUwQWJ1c19pbWFnZV91cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZml4dHVyZXMtY2FwdGlvbmluZyUyRnJlc29sdmUlMkZtYWluJTJGYnVzLnBuZyUyMiUwQWJ1c19pbWFnZV9waWwlMjAlM0QlMjBJbWFnZS5vcGVuKGlvLkJ5dGVzSU8ocmVxdWVzdHMuZ2V0KGJ1c19pbWFnZV91cmwpLmNvbnRlbnQpKSUwQWlucHV0c190b19tb2RlbCUyMCUzRCUyMHByb2Nlc3NvcihpbWFnZXMlM0RidXNfaW1hZ2VfcGlsJTJDJTIwdGV4dCUzRHRleHRfcHJvbXB0KSUwQSUwQQ==",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-keyword">from</span> transformers.models.fuyu.processing_fuyu <span class="hljs-keyword">import</span> FuyuProcessor
<span class="hljs-keyword">from</span> transformers.models.fuyu.image_processing_fuyu <span class="hljs-keyword">import</span> FuyuImageProcessor


tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&#x27;adept-hf-collab/fuyu-8b&#x27;</span>)
image_processor = FuyuImageProcessor()


processor = FuyuProcessor(image_processor=image_processor, tokenizer=tokenizer)
text_prompt = <span class="hljs-string">&quot;Generate a coco-style caption.\\\\n&quot;</span>

bus_image_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/fixtures-captioning/resolve/main/bus.png&quot;</span>
bus_image_pil = Image.<span class="hljs-built_in">open</span>(io.BytesIO(requests.get(bus_image_url).content))
inputs_to_model = processor(images=bus_image_pil, text=text_prompt)

`,wrap:!1}}),ue=new Ie({props:{title:"FuyuConfig",local:"transformers.FuyuConfig",headingTag:"h2"}}),pe=new W({props:{name:"class transformers.FuyuConfig",anchor:"transformers.FuyuConfig",parameters:[{name:"vocab_size",val:" = 262144"},{name:"hidden_size",val:" = 4096"},{name:"intermediate_size",val:" = 16384"},{name:"num_hidden_layers",val:" = 36"},{name:"num_attention_heads",val:" = 64"},{name:"hidden_act",val:" = 'relu2'"},{name:"max_position_embeddings",val:" = 16384"},{name:"image_size",val:" = 300"},{name:"patch_size",val:" = 30"},{name:"num_channels",val:" = 3"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-05"},{name:"use_cache",val:" = True"},{name:"tie_word_embeddings",val:" = False"},{name:"rope_theta",val:" = 25000.0"},{name:"rope_scaling",val:" = None"},{name:"qk_layernorm",val:" = True"},{name:"hidden_dropout",val:" = 0.0"},{name:"attention_dropout",val:" = 0.0"},{name:"partial_rotary_factor",val:" = 0.5"},{name:"pad_token_id",val:" = None"},{name:"bos_token_id",val:" = 1"},{name:"eos_token_id",val:" = 2"},{name:"image_token_id",val:" = 71011"},{name:"text_config",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FuyuConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 262144) &#x2014;
Vocabulary size of the Fuyu model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/fuyu#transformers.FuyuForCausalLM">FuyuForCausalLM</a>`,name:"vocab_size"},{anchor:"transformers.FuyuConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Dimension of the hidden representations.`,name:"hidden_size"},{anchor:"transformers.FuyuConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 16384) &#x2014;
Dimension of the MLP representations.`,name:"intermediate_size"},{anchor:"transformers.FuyuConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 36) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.FuyuConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.FuyuConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;relu2&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the decoder.`,name:"hidden_act"},{anchor:"transformers.FuyuConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 16384) &#x2014;
The maximum sequence length that this model might ever be used with.`,name:"max_position_embeddings"},{anchor:"transformers.FuyuConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 300) &#x2014;
The input image size.`,name:"image_size"},{anchor:"transformers.FuyuConfig.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 30) &#x2014;
The input vision transformer encoding patch size.`,name:"patch_size"},{anchor:"transformers.FuyuConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The input image number of channels.`,name:"num_channels"},{anchor:"transformers.FuyuConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.FuyuConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the rms normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.FuyuConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models). Only
relevant if <code>config.is_decoder=True</code>. Whether to tie weight embeddings`,name:"use_cache"},{anchor:"transformers.FuyuConfig.tie_word_embeddings",description:`<strong>tie_word_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to tie input and output embeddings.`,name:"tie_word_embeddings"},{anchor:"transformers.FuyuConfig.rope_theta",description:`<strong>rope_theta</strong> (<code>float</code>, <em>optional</em>, defaults to 25000.0) &#x2014;
The base period of the RoPE embeddings.`,name:"rope_theta"},{anchor:"transformers.FuyuConfig.rope_scaling",description:`<strong>rope_scaling</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Dictionary containing the scaling configuration for the RoPE embeddings. Currently supports two scaling
strategies: linear and dynamic. Their scaling factor must be a float greater than 1. The expected format is
<code>{&quot;type&quot;: strategy name, &quot;factor&quot;: scaling factor}</code>. When using this flag, don&#x2019;t update
<code>max_position_embeddings</code> to the expected new maximum. See the following thread for more information on how
these scaling strategies behave:
<a href="https://www.reddit.com/r/LocalFuyu/comments/14mrgpr/dynamically_scaled_rope_further_increases/" rel="nofollow">https://www.reddit.com/r/LocalFuyu/comments/14mrgpr/dynamically_scaled_rope_further_increases/</a>. This is an
experimental feature, subject to breaking API changes in future versions.`,name:"rope_scaling"},{anchor:"transformers.FuyuConfig.qk_layernorm",description:`<strong>qk_layernorm</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to normalize the Queries and Keys after projecting the hidden states`,name:"qk_layernorm"},{anchor:"transformers.FuyuConfig.hidden_dropout",description:`<strong>hidden_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio after applying the MLP to the hidden states.`,name:"hidden_dropout"},{anchor:"transformers.FuyuConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio after computing the attention scores.`,name:"attention_dropout"},{anchor:"transformers.FuyuConfig.partial_rotary_factor",description:`<strong>partial_rotary_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Percentage of the query and keys which will have rotary embedding.`,name:"partial_rotary_factor"},{anchor:"transformers.FuyuConfig.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.FuyuConfig.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The id of the <em>beginning-of-sequence</em> token.`,name:"bos_token_id"},{anchor:"transformers.FuyuConfig.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>, defaults to 2) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.FuyuConfig.image_token_id",description:`<strong>image_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 71011) &#x2014;
The id of the image placeholder token.`,name:"image_token_id"},{anchor:"transformers.FuyuConfig.text_config",description:"<strong>text_config</strong> (<code>dict</code>, <em>optional</em>) &#x2014;\nDictionary of configuration options used to initialize the <code>language```Aut</code>.",name:"text_config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/fuyu/configuration_fuyu.py#L25"}}),G=new Po({props:{anchor:"transformers.FuyuConfig.example",$$slots:{default:[Ho]},$$scope:{ctx:J}}}),he=new Ie({props:{title:"FuyuModel",local:"transformers.FuyuModel",headingTag:"h2"}}),fe=new W({props:{name:"class transformers.FuyuModel",anchor:"transformers.FuyuModel",parameters:[{name:"config",val:": FuyuConfig"}],parametersDescription:[{anchor:"transformers.FuyuModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/fuyu#transformers.FuyuConfig">FuyuConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/fuyu/modeling_fuyu.py#L62"}}),ge=new W({props:{name:"forward",anchor:"transformers.FuyuModel.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"image_patches",val:": Tensor = None"},{name:"image_patches_indices",val:": Tensor = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FuyuModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FuyuModel.forward.image_patches",description:`<strong>image_patches</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, num_total_patches, patch_size_ x patch_size x num_channels)</code>, <em>optional</em>) &#x2014;
Image patches to be used as continuous embeddings. The patches are flattened and then projected to the
hidden size of the model.`,name:"image_patches"},{anchor:"transformers.FuyuModel.forward.image_patches_indices",description:`<strong>image_patches_indices</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Tensor of indices of the image patches in the input_ids tensor.`,name:"image_patches_indices"},{anchor:"transformers.FuyuModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.FuyuModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.FuyuModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>List[torch.FloatTensor]</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.FuyuModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.FuyuModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.FuyuModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.FuyuModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.FuyuModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/fuyu/modeling_fuyu.py#L147",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/fuyu#transformers.FuyuConfig"
>FuyuConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>Cache</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — It is a <a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache"
>Cache</a> instance. For more details, see our <a
  href="https://huggingface.co/docs/transformers/en/kv_cache"
  rel="nofollow"
>kv cache guide</a>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),H=new so({props:{$$slots:{default:[No]},$$scope:{ctx:J}}}),_e=new W({props:{name:"gather_continuous_embeddings",anchor:"transformers.FuyuModel.gather_continuous_embeddings",parameters:[{name:"word_embeddings",val:": Tensor"},{name:"continuous_embeddings",val:": typing.List[torch.Tensor]"},{name:"image_patch_input_indices",val:": Tensor"}],parametersDescription:[{anchor:"transformers.FuyuModel.gather_continuous_embeddings.word_embeddings",description:`<strong>word_embeddings</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Tensor of word embeddings.`,name:"word_embeddings"},{anchor:"transformers.FuyuModel.gather_continuous_embeddings.continuous_embeddings",description:`<strong>continuous_embeddings</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_patches, hidden_size)</code>) &#x2014;
Tensor of continuous embeddings. The length of the list is the batch size. Each entry is shape
[num_image_embeddings, hidden], and num_image_embeddings needs to match the number of non-negative
indices in image_patch_input_indices for that batch element.`,name:"continuous_embeddings"},{anchor:"transformers.FuyuModel.gather_continuous_embeddings.image_patch_input_indices",description:`<strong>image_patch_input_indices</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Tensor of indices of the image patches in the input_ids tensor.`,name:"image_patch_input_indices"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/fuyu/modeling_fuyu.py#L89"}}),ye=new W({props:{name:"get_image_features",anchor:"transformers.FuyuModel.get_image_features",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FuyuModel.get_image_features.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>) &#x2014;
The tensors corresponding to the input images.`,name:"pixel_values"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/fuyu/modeling_fuyu.py#L133"}}),be=new Ie({props:{title:"FuyuForCausalLM",local:"transformers.FuyuForCausalLM",headingTag:"h2"}}),ve=new W({props:{name:"class transformers.FuyuForCausalLM",anchor:"transformers.FuyuForCausalLM",parameters:[{name:"config",val:": FuyuConfig"}],parametersDescription:[{anchor:"transformers.FuyuForCausalLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/fuyu#transformers.FuyuConfig">FuyuConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/fuyu/modeling_fuyu.py#L227"}}),Te=new W({props:{name:"forward",anchor:"transformers.FuyuForCausalLM.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"image_patches",val:": Tensor = None"},{name:"image_patches_indices",val:": Tensor = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"logits_to_keep",val:": typing.Optional[int] = 0"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FuyuForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FuyuForCausalLM.forward.image_patches",description:`<strong>image_patches</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, num_total_patches, patch_size_ x patch_size x num_channels)</code>, <em>optional</em>) &#x2014;
Image patches to be used as continuous embeddings. The patches are flattened and then projected to the
hidden size of the model.`,name:"image_patches"},{anchor:"transformers.FuyuForCausalLM.forward.image_patches_indices",description:`<strong>image_patches_indices</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Tensor of indices of the image patches in the input_ids tensor.`,name:"image_patches_indices"},{anchor:"transformers.FuyuForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.FuyuForCausalLM.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.FuyuForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>List[torch.FloatTensor]</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.FuyuForCausalLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.FuyuForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.FuyuForCausalLM.forward.labels",description:`<strong>labels</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.text_config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.text_config.vocab_size]</code>.`,name:"labels"},{anchor:"transformers.FuyuForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.FuyuForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.FuyuForCausalLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.FuyuForCausalLM.forward.logits_to_keep",description:`<strong>logits_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to <code>0</code>) &#x2014;
If an <code>int</code>, compute logits for the last <code>logits_to_keep</code> tokens. If <code>0</code>, calculate logits for all
<code>input_ids</code> (special case). Only last token logits are needed for generation, and calculating them only for that
token can save memory, which becomes pretty significant for long sequences or large vocabulary size.
If a <code>torch.Tensor</code>, must be 1D corresponding to the indices to keep in the sequence length dimension.
This is useful when using packed tensor format (single dimension for batch and sequence length).`,name:"logits_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/fuyu/modeling_fuyu.py#L264",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/fuyu#transformers.FuyuConfig"
>FuyuConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>Cache</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — It is a <a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache"
>Cache</a> instance. For more details, see our <a
  href="https://huggingface.co/docs/transformers/en/kv_cache"
  rel="nofollow"
>kv cache guide</a>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),B=new so({props:{$$slots:{default:[Ro]},$$scope:{ctx:J}}}),E=new Po({props:{anchor:"transformers.FuyuForCausalLM.forward.example",$$slots:{default:[Bo]},$$scope:{ctx:J}}}),we=new Ie({props:{title:"FuyuImageProcessor",local:"transformers.FuyuImageProcessor",headingTag:"h2"}}),Me=new W({props:{name:"class transformers.FuyuImageProcessor",anchor:"transformers.FuyuImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"do_pad",val:": bool = True"},{name:"padding_value",val:": float = 1.0"},{name:"padding_mode",val:": str = 'constant'"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float]] = 0.5"},{name:"image_std",val:": typing.Union[float, typing.List[float]] = 0.5"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": float = 0.00392156862745098"},{name:"patch_size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FuyuImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image to <code>size</code>.`,name:"do_resize"},{anchor:"transformers.FuyuImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>{&quot;height&quot; -- 1080, &quot;width&quot;: 1920}</code>):
Dictionary in the format <code>{&quot;height&quot;: int, &quot;width&quot;: int}</code> specifying the size of the output image.`,name:"size"},{anchor:"transformers.FuyuImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>Resampling.BILINEAR</code>) &#x2014;
<code>PILImageResampling</code> filter to use when resizing the image e.g. <code>PILImageResampling.BILINEAR</code>.`,name:"resample"},{anchor:"transformers.FuyuImageProcessor.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to pad the image to <code>size</code>.`,name:"do_pad"},{anchor:"transformers.FuyuImageProcessor.padding_value",description:`<strong>padding_value</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The value to pad the image with.`,name:"padding_value"},{anchor:"transformers.FuyuImageProcessor.padding_mode",description:`<strong>padding_mode</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;constant&quot;</code>) &#x2014;
The padding mode to use when padding the image.`,name:"padding_mode"},{anchor:"transformers.FuyuImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.FuyuImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The mean to use when normalizing the image.`,name:"image_mean"},{anchor:"transformers.FuyuImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The standard deviation to use when normalizing the image.`,name:"image_std"},{anchor:"transformers.FuyuImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.FuyuImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>1 / 255</code>) &#x2014;
The factor to use when rescaling the image.`,name:"rescale_factor"},{anchor:"transformers.FuyuImageProcessor.patch_size",description:`<strong>patch_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>{&quot;height&quot; -- 30, &quot;width&quot;: 30}</code>):
Dictionary in the format <code>{&quot;height&quot;: int, &quot;width&quot;: int}</code> specifying the size of the patches.`,name:"patch_size"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/fuyu/image_processing_fuyu.py#L182"}}),Fe=new W({props:{name:"__call__",anchor:"transformers.FuyuImageProcessor.__call__",parameters:[{name:"images",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/image_processing_utils.py#L42"}}),ke=new Ie({props:{title:"FuyuProcessor",local:"transformers.FuyuProcessor",headingTag:"h2"}}),$e=new W({props:{name:"class transformers.FuyuProcessor",anchor:"transformers.FuyuProcessor",parameters:[{name:"image_processor",val:""},{name:"tokenizer",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FuyuProcessor.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/main/en/model_doc/fuyu#transformers.FuyuImageProcessor">FuyuImageProcessor</a>) &#x2014;
The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.FuyuProcessor.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>) &#x2014;
The tokenizer is a required input.`,name:"tokenizer"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/fuyu/processing_fuyu.py#L337"}}),xe=new W({props:{name:"__call__",anchor:"transformers.FuyuProcessor.__call__",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']] = None"},{name:"text",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"audio",val:" = None"},{name:"videos",val:" = None"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.fuyu.processing_fuyu.FuyuProcessorKwargs]"}],parametersDescription:[{anchor:"transformers.FuyuProcessor.__call__.images",description:`<strong>images</strong> (<code>PIL.Image.Image</code>, <code>List[PIL.Image.Image]</code>) &#x2014;
The image or batch of images to be prepared. Each image can be a PIL image, NumPy array or PyTorch
tensor. Both channels-first and channels-last formats are supported.`,name:"images"},{anchor:"transformers.FuyuProcessor.__call__.text",description:`<strong>text</strong> (<code>str</code>, <code>List[str]</code>) &#x2014;
The sequence or batch of sequences to be encoded. Each sequence can be a string or a list of strings
(pretokenized string). If the sequences are provided as list of strings (pretokenized), you must set
<code>is_split_into_words=True</code> (to lift the ambiguity with a batch of sequences).`,name:"text"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/fuyu/processing_fuyu.py#L487",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>FuyuBatchEncoding</code> with the following fields:</p>
<ul>
<li><strong>input_ids</strong> — Tensor of token ids to be fed to a model. Returned when <code>text</code> is not <code>None</code>.</li>
<li><strong>image_patches</strong> — List of Tensor of image patches. Returned when <code>images</code> is not <code>None</code>.</li>
<li><strong>image_patches_indices</strong> — Tensor of indices where patch embeddings have to be inserted by the model.</li>
<li><strong>attention_mask</strong> — List of indices specifying which tokens should be attended to by the model when
<code>return_attention_mask=True</code>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>FuyuBatchEncoding</code></p>
`}}),Ce=new Xo({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/fuyu.md"}}),{c(){i=d("meta"),v=n(),c=d("p"),y=n(),u(k.$$.fragment),b=n(),T=d("div"),T.innerHTML=Ae,M=n(),u(C.$$.fragment),et=n(),O=d("p"),O.innerHTML=ao,tt=n(),K=d("p"),K.textContent=ro,ot=n(),ee=d("p"),ee.textContent=io,nt=n(),u(X.$$.fragment),st=n(),te=d("p"),te.textContent=lo,at=n(),oe=d("ul"),oe.innerHTML=co,rt=n(),u(ne.$$.fragment),it=n(),se=d("p"),se.textContent=mo,dt=n(),u(ae.$$.fragment),lt=n(),re=d("p"),re.textContent=uo,ct=n(),u(ie.$$.fragment),mt=n(),de=d("p"),de.textContent=po,ut=n(),u(le.$$.fragment),pt=n(),ce=d("p"),ce.innerHTML=ho,ht=n(),me=d("ul"),me.innerHTML=fo,ft=n(),u(ue.$$.fragment),gt=n(),z=d("div"),u(pe.$$.fragment),Lt=n(),Ze=d("p"),Ze.innerHTML=go,It=n(),Je=d("p"),Je.innerHTML=_o,Zt=n(),u(G.$$.fragment),_t=n(),u(he.$$.fragment),yt=n(),w=d("div"),u(fe.$$.fragment),Jt=n(),Pe=d("p"),Pe.textContent=yo,Pt=n(),Ue=d("p"),Ue.innerHTML=bo,Ut=n(),We=d("p"),We.innerHTML=vo,Wt=n(),j=d("div"),u(ge.$$.fragment),jt=n(),je=d("p"),je.innerHTML=To,qt=n(),u(H.$$.fragment),Vt=n(),N=d("div"),u(_e.$$.fragment),Xt=n(),qe=d("p"),qe.textContent=wo,Gt=n(),R=d("div"),u(ye.$$.fragment),Ht=n(),Ve=d("p"),Ve.textContent=Mo,bt=n(),u(be.$$.fragment),vt=n(),$=d("div"),u(ve.$$.fragment),Nt=n(),Xe=d("p"),Xe.textContent=Fo,Rt=n(),Ge=d("p"),Ge.innerHTML=ko,Bt=n(),He=d("p"),He.innerHTML=$o,Et=n(),P=d("div"),u(Te.$$.fragment),Dt=n(),Ne=d("p"),Ne.innerHTML=xo,St=n(),u(B.$$.fragment),Yt=n(),u(E.$$.fragment),Tt=n(),u(we.$$.fragment),wt=n(),L=d("div"),u(Me.$$.fragment),Qt=n(),Re=d("p"),Re.textContent=Co,At=n(),Be=d("ul"),Be.innerHTML=zo,Ot=n(),D=d("div"),u(Fe.$$.fragment),Kt=n(),Ee=d("p"),Ee.textContent=Lo,Mt=n(),u(ke.$$.fragment),Ft=n(),I=d("div"),u($e.$$.fragment),eo=n(),De=d("p"),De.textContent=Io,to=n(),Se=d("p"),Se.innerHTML=Zo,oo=n(),S=d("div"),u(xe.$$.fragment),no=n(),Ye=d("p"),Ye.innerHTML=Jo,kt=n(),u(Ce.$$.fragment),$t=n(),Oe=d("p"),this.h()},l(e){const t=Vo("svelte-u9bgzb",document.head);i=l(t,"META",{name:!0,content:!0}),t.forEach(o),v=s(e),c=l(e,"P",{}),Z(c).forEach(o),y=s(e),p(k.$$.fragment,e),b=s(e),T=l(e,"DIV",{class:!0,"data-svelte-h":!0}),m(T)!=="svelte-13t8s2t"&&(T.innerHTML=Ae),M=s(e),p(C.$$.fragment,e),et=s(e),O=l(e,"P",{"data-svelte-h":!0}),m(O)!=="svelte-1f0fj96"&&(O.innerHTML=ao),tt=s(e),K=l(e,"P",{"data-svelte-h":!0}),m(K)!=="svelte-d0qe5n"&&(K.textContent=ro),ot=s(e),ee=l(e,"P",{"data-svelte-h":!0}),m(ee)!=="svelte-1xp7ehr"&&(ee.textContent=io),nt=s(e),p(X.$$.fragment,e),st=s(e),te=l(e,"P",{"data-svelte-h":!0}),m(te)!=="svelte-axv494"&&(te.textContent=lo),at=s(e),oe=l(e,"UL",{"data-svelte-h":!0}),m(oe)!=="svelte-g9ue9k"&&(oe.innerHTML=co),rt=s(e),p(ne.$$.fragment,e),it=s(e),se=l(e,"P",{"data-svelte-h":!0}),m(se)!=="svelte-1cs7acv"&&(se.textContent=mo),dt=s(e),p(ae.$$.fragment,e),lt=s(e),re=l(e,"P",{"data-svelte-h":!0}),m(re)!=="svelte-1c7gnsu"&&(re.textContent=uo),ct=s(e),p(ie.$$.fragment,e),mt=s(e),de=l(e,"P",{"data-svelte-h":!0}),m(de)!=="svelte-60q0vi"&&(de.textContent=po),ut=s(e),p(le.$$.fragment,e),pt=s(e),ce=l(e,"P",{"data-svelte-h":!0}),m(ce)!=="svelte-1ius34j"&&(ce.innerHTML=ho),ht=s(e),me=l(e,"UL",{"data-svelte-h":!0}),m(me)!=="svelte-1pf7ero"&&(me.innerHTML=fo),ft=s(e),p(ue.$$.fragment,e),gt=s(e),z=l(e,"DIV",{class:!0});var U=Z(z);p(pe.$$.fragment,U),Lt=s(U),Ze=l(U,"P",{"data-svelte-h":!0}),m(Ze)!=="svelte-14kk906"&&(Ze.innerHTML=go),It=s(U),Je=l(U,"P",{"data-svelte-h":!0}),m(Je)!=="svelte-o55m63"&&(Je.innerHTML=_o),Zt=s(U),p(G.$$.fragment,U),U.forEach(o),_t=s(e),p(he.$$.fragment,e),yt=s(e),w=l(e,"DIV",{class:!0});var F=Z(w);p(fe.$$.fragment,F),Jt=s(F),Pe=l(F,"P",{"data-svelte-h":!0}),m(Pe)!=="svelte-qirfp8"&&(Pe.textContent=yo),Pt=s(F),Ue=l(F,"P",{"data-svelte-h":!0}),m(Ue)!=="svelte-6pahdo"&&(Ue.innerHTML=bo),Ut=s(F),We=l(F,"P",{"data-svelte-h":!0}),m(We)!=="svelte-hswkmf"&&(We.innerHTML=vo),Wt=s(F),j=l(F,"DIV",{class:!0});var V=Z(j);p(ge.$$.fragment,V),jt=s(V),je=l(V,"P",{"data-svelte-h":!0}),m(je)!=="svelte-101v11e"&&(je.innerHTML=To),qt=s(V),p(H.$$.fragment,V),V.forEach(o),Vt=s(F),N=l(F,"DIV",{class:!0});var ze=Z(N);p(_e.$$.fragment,ze),Xt=s(ze),qe=l(ze,"P",{"data-svelte-h":!0}),m(qe)!=="svelte-13frnol"&&(qe.textContent=wo),ze.forEach(o),Gt=s(F),R=l(F,"DIV",{class:!0});var Le=Z(R);p(ye.$$.fragment,Le),Ht=s(Le),Ve=l(Le,"P",{"data-svelte-h":!0}),m(Ve)!=="svelte-16izj0z"&&(Ve.textContent=Mo),Le.forEach(o),F.forEach(o),bt=s(e),p(be.$$.fragment,e),vt=s(e),$=l(e,"DIV",{class:!0});var q=Z($);p(ve.$$.fragment,q),Nt=s(q),Xe=l(q,"P",{"data-svelte-h":!0}),m(Xe)!=="svelte-zplmlv"&&(Xe.textContent=Fo),Rt=s(q),Ge=l(q,"P",{"data-svelte-h":!0}),m(Ge)!=="svelte-6pahdo"&&(Ge.innerHTML=ko),Bt=s(q),He=l(q,"P",{"data-svelte-h":!0}),m(He)!=="svelte-hswkmf"&&(He.innerHTML=$o),Et=s(q),P=l(q,"DIV",{class:!0});var Y=Z(P);p(Te.$$.fragment,Y),Dt=s(Y),Ne=l(Y,"P",{"data-svelte-h":!0}),m(Ne)!=="svelte-15glyuy"&&(Ne.innerHTML=xo),St=s(Y),p(B.$$.fragment,Y),Yt=s(Y),p(E.$$.fragment,Y),Y.forEach(o),q.forEach(o),Tt=s(e),p(we.$$.fragment,e),wt=s(e),L=l(e,"DIV",{class:!0});var Q=Z(L);p(Me.$$.fragment,Q),Qt=s(Q),Re=l(Q,"P",{"data-svelte-h":!0}),m(Re)!=="svelte-psqr0m"&&(Re.textContent=Co),At=s(Q),Be=l(Q,"UL",{"data-svelte-h":!0}),m(Be)!=="svelte-16e0qf2"&&(Be.innerHTML=zo),Ot=s(Q),D=l(Q,"DIV",{class:!0});var Ct=Z(D);p(Fe.$$.fragment,Ct),Kt=s(Ct),Ee=l(Ct,"P",{"data-svelte-h":!0}),m(Ee)!=="svelte-khengj"&&(Ee.textContent=Lo),Ct.forEach(o),Q.forEach(o),Mt=s(e),p(ke.$$.fragment,e),Ft=s(e),I=l(e,"DIV",{class:!0});var A=Z(I);p($e.$$.fragment,A),eo=s(A),De=l(A,"P",{"data-svelte-h":!0}),m(De)!=="svelte-1wc4ris"&&(De.textContent=Io),to=s(A),Se=l(A,"P",{"data-svelte-h":!0}),m(Se)!=="svelte-m4qk42"&&(Se.innerHTML=Zo),oo=s(A),S=l(A,"DIV",{class:!0});var zt=Z(S);p(xe.$$.fragment,zt),no=s(zt),Ye=l(zt,"P",{"data-svelte-h":!0}),m(Ye)!=="svelte-9ukj87"&&(Ye.innerHTML=Jo),zt.forEach(o),A.forEach(o),kt=s(e),p(Ce.$$.fragment,e),$t=s(e),Oe=l(e,"P",{}),Z(Oe).forEach(o),this.h()},h(){x(i,"name","hf:doc:metadata"),x(i,"content",Do),x(T,"class","flex flex-wrap space-x-1"),x(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){r(document.head,i),a(e,v,t),a(e,c,t),a(e,y,t),h(k,e,t),a(e,b,t),a(e,T,t),a(e,M,t),h(C,e,t),a(e,et,t),a(e,O,t),a(e,tt,t),a(e,K,t),a(e,ot,t),a(e,ee,t),a(e,nt,t),h(X,e,t),a(e,st,t),a(e,te,t),a(e,at,t),a(e,oe,t),a(e,rt,t),h(ne,e,t),a(e,it,t),a(e,se,t),a(e,dt,t),h(ae,e,t),a(e,lt,t),a(e,re,t),a(e,ct,t),h(ie,e,t),a(e,mt,t),a(e,de,t),a(e,ut,t),h(le,e,t),a(e,pt,t),a(e,ce,t),a(e,ht,t),a(e,me,t),a(e,ft,t),h(ue,e,t),a(e,gt,t),a(e,z,t),h(pe,z,null),r(z,Lt),r(z,Ze),r(z,It),r(z,Je),r(z,Zt),h(G,z,null),a(e,_t,t),h(he,e,t),a(e,yt,t),a(e,w,t),h(fe,w,null),r(w,Jt),r(w,Pe),r(w,Pt),r(w,Ue),r(w,Ut),r(w,We),r(w,Wt),r(w,j),h(ge,j,null),r(j,jt),r(j,je),r(j,qt),h(H,j,null),r(w,Vt),r(w,N),h(_e,N,null),r(N,Xt),r(N,qe),r(w,Gt),r(w,R),h(ye,R,null),r(R,Ht),r(R,Ve),a(e,bt,t),h(be,e,t),a(e,vt,t),a(e,$,t),h(ve,$,null),r($,Nt),r($,Xe),r($,Rt),r($,Ge),r($,Bt),r($,He),r($,Et),r($,P),h(Te,P,null),r(P,Dt),r(P,Ne),r(P,St),h(B,P,null),r(P,Yt),h(E,P,null),a(e,Tt,t),h(we,e,t),a(e,wt,t),a(e,L,t),h(Me,L,null),r(L,Qt),r(L,Re),r(L,At),r(L,Be),r(L,Ot),r(L,D),h(Fe,D,null),r(D,Kt),r(D,Ee),a(e,Mt,t),h(ke,e,t),a(e,Ft,t),a(e,I,t),h($e,I,null),r(I,eo),r(I,De),r(I,to),r(I,Se),r(I,oo),r(I,S),h(xe,S,null),r(S,no),r(S,Ye),a(e,kt,t),h(Ce,e,t),a(e,$t,t),a(e,Oe,t),xt=!0},p(e,[t]){const U={};t&2&&(U.$$scope={dirty:t,ctx:e}),X.$set(U);const F={};t&2&&(F.$$scope={dirty:t,ctx:e}),G.$set(F);const V={};t&2&&(V.$$scope={dirty:t,ctx:e}),H.$set(V);const ze={};t&2&&(ze.$$scope={dirty:t,ctx:e}),B.$set(ze);const Le={};t&2&&(Le.$$scope={dirty:t,ctx:e}),E.$set(Le)},i(e){xt||(f(k.$$.fragment,e),f(C.$$.fragment,e),f(X.$$.fragment,e),f(ne.$$.fragment,e),f(ae.$$.fragment,e),f(ie.$$.fragment,e),f(le.$$.fragment,e),f(ue.$$.fragment,e),f(pe.$$.fragment,e),f(G.$$.fragment,e),f(he.$$.fragment,e),f(fe.$$.fragment,e),f(ge.$$.fragment,e),f(H.$$.fragment,e),f(_e.$$.fragment,e),f(ye.$$.fragment,e),f(be.$$.fragment,e),f(ve.$$.fragment,e),f(Te.$$.fragment,e),f(B.$$.fragment,e),f(E.$$.fragment,e),f(we.$$.fragment,e),f(Me.$$.fragment,e),f(Fe.$$.fragment,e),f(ke.$$.fragment,e),f($e.$$.fragment,e),f(xe.$$.fragment,e),f(Ce.$$.fragment,e),xt=!0)},o(e){g(k.$$.fragment,e),g(C.$$.fragment,e),g(X.$$.fragment,e),g(ne.$$.fragment,e),g(ae.$$.fragment,e),g(ie.$$.fragment,e),g(le.$$.fragment,e),g(ue.$$.fragment,e),g(pe.$$.fragment,e),g(G.$$.fragment,e),g(he.$$.fragment,e),g(fe.$$.fragment,e),g(ge.$$.fragment,e),g(H.$$.fragment,e),g(_e.$$.fragment,e),g(ye.$$.fragment,e),g(be.$$.fragment,e),g(ve.$$.fragment,e),g(Te.$$.fragment,e),g(B.$$.fragment,e),g(E.$$.fragment,e),g(we.$$.fragment,e),g(Me.$$.fragment,e),g(Fe.$$.fragment,e),g(ke.$$.fragment,e),g($e.$$.fragment,e),g(xe.$$.fragment,e),g(Ce.$$.fragment,e),xt=!1},d(e){e&&(o(v),o(c),o(y),o(b),o(T),o(M),o(et),o(O),o(tt),o(K),o(ot),o(ee),o(nt),o(st),o(te),o(at),o(oe),o(rt),o(it),o(se),o(dt),o(lt),o(re),o(ct),o(mt),o(de),o(ut),o(pt),o(ce),o(ht),o(me),o(ft),o(gt),o(z),o(_t),o(yt),o(w),o(bt),o(vt),o($),o(Tt),o(wt),o(L),o(Mt),o(Ft),o(I),o(kt),o($t),o(Oe)),o(i),_(k,e),_(C,e),_(X,e),_(ne,e),_(ae,e),_(ie,e),_(le,e),_(ue,e),_(pe),_(G),_(he,e),_(fe),_(ge),_(H),_(_e),_(ye),_(be,e),_(ve),_(Te),_(B),_(E),_(we,e),_(Me),_(Fe),_(ke,e),_($e),_(xe),_(Ce,e)}}}const Do='{"title":"Fuyu","local":"fuyu","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"FuyuConfig","local":"transformers.FuyuConfig","sections":[],"depth":2},{"title":"FuyuModel","local":"transformers.FuyuModel","sections":[],"depth":2},{"title":"FuyuForCausalLM","local":"transformers.FuyuForCausalLM","sections":[],"depth":2},{"title":"FuyuImageProcessor","local":"transformers.FuyuImageProcessor","sections":[],"depth":2},{"title":"FuyuProcessor","local":"transformers.FuyuProcessor","sections":[],"depth":2}],"depth":1}';function So(J){return Wo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class nn extends jo{constructor(i){super(),qo(this,i,So,Eo,Uo,{})}}export{nn as component};
