import{s as yn,z as un,o as Tn,n as Fo}from"../chunks/scheduler.18a86fab.js";import{S as bn,i as Mn,g as i,s,r as l,A as wn,h as c,f as o,c as n,j as T,u as d,x as f,k as y,y as a,a as r,v as m,d as p,t as h,w as g}from"../chunks/index.98837b22.js";import{T as fn}from"../chunks/Tip.77304350.js";import{D as M}from"../chunks/Docstring.6758ea23.js";import{C as P}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as _n}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as I}from"../chunks/Heading.7e7e0c5b.js";import{E as vn}from"../chunks/getInferenceSnippets.de10bc7d.js";function jn(N){let u,w;return u=new P({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdvdE9jcjJGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMkMlMjBHb3RPY3IyQ29uZmlnJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMEdvdE9jcjIlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwR290T2NyMkNvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwZnJvbSUyMHRoZSUyMFF3ZW4yLVZMLTdCJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBHb3RPY3IyRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GotOcr2ForConditionalGeneration, GotOcr2Config

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a GotOcr2 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = GotOcr2Config()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the Qwen2-VL-7B style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = GotOcr2ForConditionalGeneration(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){l(u.$$.fragment)},l(_){d(u.$$.fragment,_)},m(_,v){m(u,_,v),w=!0},p:Fo,i(_){w||(p(u.$$.fragment,_),w=!0)},o(_){h(u.$$.fragment,_),w=!1},d(_){g(u,_)}}}function Jn(N){let u,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){u=i("p"),u.innerHTML=w},l(_){u=c(_,"P",{"data-svelte-h":!0}),f(u)!=="svelte-fincs2"&&(u.innerHTML=w)},m(_,v){r(_,u,v)},p:Fo,d(_){_&&o(u)}}}function In(N){let u,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){u=i("p"),u.innerHTML=w},l(_){u=c(_,"P",{"data-svelte-h":!0}),f(u)!=="svelte-fincs2"&&(u.innerHTML=w)},m(_,v){r(_,u,v)},p:Fo,d(_){_&&o(u)}}}function Un(N){let u,w="Example:",_,v,Z;return v=new P({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyMEdvdE9jcjJGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMkMlMjBUZXh0U3RyZWFtZXIlMEElMEFtb2RlbCUyMCUzRCUyMEdvdE9jcjJGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMnN0ZXBmdW4tYWklMkZHT1QtT0NSLTIuMC1oZiUyMikudG8oJTIyY3VkYSUyMiklMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJzdGVwZnVuLWFpJTJGR09ULU9DUi0yLjAtaGYlMjIpJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaGYtaW50ZXJuYWwtdGVzdGluZyUyRmZpeHR1cmVzX2dvdF9vY3IlMkZyZXNvbHZlJTJGbWFpbiUyRm11bHRpX2JveC5wbmclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTIwY29sb3IlM0QlMjJncmVlbiUyMikudG8oJTIyY3VkYSUyMiklMEElMEElMjMlMjBHZW5lcmF0ZSUwQXN0cmVhbWVyJTIwJTNEJTIwVGV4dFN0cmVhbWVyKHByb2Nlc3Nvci50b2tlbml6ZXIlMkMlMjBza2lwX3Byb21wdCUzRFRydWUlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklMEFnZW5lcmF0ZV9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSglMEElMjAlMjAlMjAlMjAqKmlucHV0cyUyQyUwQSUyMCUyMCUyMCUyMGRvX3NhbXBsZSUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTIwJTNEJTIwcHJvY2Vzc29yLnRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMHN0b3Bfc3RyaW5ncyUzRCclM0MlN0NpbV9lbmQlN0MlM0UnJTJDJTBBJTIwJTIwJTIwJTIwc3RyZWFtZXIlM0RzdHJlYW1lciUyQyUwQSUyMCUyMCUyMCUyMG1heF9uZXdfdG9rZW5zJTNENDA5NiUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, GotOcr2ForConditionalGeneration, TextStreamer

<span class="hljs-meta">&gt;&gt;&gt; </span>model = GotOcr2ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;stepfun-ai/GOT-OCR-2.0-hf&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;stepfun-ai/GOT-OCR-2.0-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/fixtures_got_ocr/resolve/main/multi_box.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, color=<span class="hljs-string">&quot;green&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>streamer = TextStreamer(processor.tokenizer, skip_prompt=<span class="hljs-literal">True</span>, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    do_sample=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    tokenizer = processor.tokenizer,
<span class="hljs-meta">... </span>    stop_strings=<span class="hljs-string">&#x27;&lt;|im_end|&gt;&#x27;</span>,
<span class="hljs-meta">... </span>    streamer=streamer,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">4096</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-string">&quot;You should keep in mind what features from the module should be used, especially
when you&#x27;re planning to sell a template.&quot;</span>`,wrap:!1}}),{c(){u=i("p"),u.textContent=w,_=s(),l(v.$$.fragment)},l(b){u=c(b,"P",{"data-svelte-h":!0}),f(u)!=="svelte-11lpom8"&&(u.textContent=w),_=n(b),d(v.$$.fragment,b)},m(b,R){r(b,u,R),r(b,_,R),m(v,b,R),Z=!0},p:Fo,i(b){Z||(p(v.$$.fragment,b),Z=!0)},o(b){h(v.$$.fragment,b),Z=!1},d(b){b&&(o(u),o(_)),g(v,b)}}}function Gn(N){let u,w,_,v,Z,b,R,Us='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',Wt,ie,Nt,ce,Gs='The GOT-OCR2 model was proposed in <a href="https://arxiv.org/abs/2409.01704" rel="nofollow">General OCR Theory: Towards OCR-2.0 via a Unified End-to-end Model</a> by Haoran Wei, Chenglong Liu, Jinyue Chen, Jia Wang, Lingyu Kong, Yanming Xu, Zheng Ge, Liang Zhao, Jianjian Sun, Yuang Peng, Chunrui Han, Xiangyu Zhang.',Ft,le,xs="The abstract from the paper is the following:",Bt,de,Cs="<em>Traditional OCR systems (OCR-1.0) are increasingly unable to meet people’snusage due to the growing demand for intelligent processing of man-made opticalncharacters. In this paper, we collectively refer to all artificial optical signals (e.g., plain texts, math/molecular formulas, tables, charts, sheet music, and even geometric shapes) as “characters” and propose the General OCR Theory along with an excellent model, namely GOT, to promote the arrival of OCR-2.0. The GOT, with 580M parameters, is a unified, elegant, and end-to-end model, consisting of a high-compression encoder and a long-contexts decoder. As an OCR-2.0 model, GOT can handle all the above “characters” under various OCR tasks. On the input side, the model supports commonly used scene- and document-style images in slice and whole-page styles. On the output side, GOT can generate plain or formatted results (markdown/tikz/smiles/kern) via an easy prompt. Besides, the model enjoys interactive OCR features, i.e., region-level recognition guided by coordinates or colors. Furthermore, we also adapt dynamic resolution and multipage OCR technologies to GOT for better practicality. In experiments, we provide sufficient results to prove the superiority of our model.</em>",Vt,X,ks,qt,me,zs='GOT-OCR2 training stages. Taken from the <a href="https://arxiv.org/abs/2409.01704">original paper.</a>',Pt,pe,Zs="Tips:",Xt,he,Rs=`GOT-OCR2 works on a wide range of tasks, including plain document OCR, scene text OCR, formatted document OCR, and even OCR for tables, charts, mathematical formulas, geometric shapes, molecular formulas and sheet music. While this implementation of the model will only output plain text, the outputs can be further processed to render the desired format, with packages like <code>pdftex</code>, <code>mathpix</code>, <code>matplotlib</code>, <code>tikz</code>, <code>verovio</code> or <code>pyecharts</code>.
The model can also be used for interactive OCR, where the user can specify the region to be recognized by providing the coordinates or the color of the region’s bounding box.`,Ht,ge,$s=`This model was contributed by <a href="https://huggingface.co/yonigozlan" rel="nofollow">yonigozlan</a>.
The original code can be found <a href="https://github.com/Ucas-HaoranWei/GOT-OCR2.0" rel="nofollow">here</a>.`,Et,ue,Qt,fe,St,_e,Yt,ye,Lt,Te,At,be,Dt,Me,Os="GOT-OCR2 can also generate formatted text, such as markdown or LaTeX. Here is an example of how to generate formatted text:",Kt,we,eo,ve,to,je,Ws=`Although it might be reasonable in most cases to use a “for loop” for multi-page processing, some text data with formatting across several pages make it necessary to process all pages at once. GOT introduces a multi-page OCR (without “for loop”) feature, where multiple pages can be processed by the model at once, whith the output being one continuous text.
Here is an example of how to process multiple pages at once:`,oo,Je,so,Ie,no,Ue,Ns=`GOT supports a 1024×1024 input resolution, which is sufficient for most OCR tasks, such as scene OCR or processing A4-sized PDF pages. However, certain scenarios, like horizontally stitched two-page PDFs commonly found in academic papers or images with unusual aspect ratios, can lead to accuracy issues when processed as a single image. To address this, GOT can dynamically crop an image into patches, process them all at once, and merge the results for better accuracy with such inputs.
Here is an example of how to process cropped patches:`,ao,Ge,ro,xe,io,Ce,Fs="GOT supports interactive OCR, where the user can specify the region to be recognized by providing the coordinates or the color of the region’s bounding box. Here is an example of how to process a specific region:",co,ke,lo,ze,mo,Ze,Bs=`Although this implementation of the model will only output plain text, the outputs can be further processed to render the desired format, with packages like <code>pdftex</code>, <code>mathpix</code>, <code>matplotlib</code>, <code>tikz</code>, <code>verovio</code> or <code>pyecharts</code>.
Here is an example of how to process sheet music:`,po,Re,ho,H,Vs,go,$e,uo,U,Oe,Bo,lt,qs=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/got_ocr2#transformers.GotOcr2ForConditionalGeneration">GotOcr2ForConditionalGeneration</a>. It is used to instantiate a
GotOcr2 model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of GOT-OCR-2.0.`,Vo,dt,Ps='e.g <a href="https://huggingface.co/stepfun-ai/GOT-OCR-2.0-hf" rel="nofollow">stepfun-ai/GOT-OCR-2.0-hf</a>',qo,mt,Xs=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Po,E,fo,We,_o,W,Ne,Xo,pt,Hs=`This is the configuration class to store the configuration of a <code>GotOcr2VisionModel</code>. It is used to instantiate a GOT_OCR2
vision encoder according to the specified arguments, defining the model architecture. Instantiating a configuration
defaults will yield a similar configuration to that of the SAM ViT-h
<a href="https://huggingface.co/facebook/sam-vit-huge" rel="nofollow">facebook/sam-vit-huge</a> architecture.`,Ho,ht,Es=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,yo,Fe,To,j,Be,Eo,gt,Qs="Constructs a GOT_OCR2 image processor.",Qo,Q,Ve,So,ut,Ss=`Crop the image to patches and return a list of cropped images.
The number of patches and their grid arrangement are determined by the original image size,
the target patch size and the minimum and maximum number of patches.
The aspect ratio of the patches grid is chosen to be the closest to the original image aspect ratio.`,Yo,S,qe,Lo,ft,Ys="A utility that returns number patches for a given image size.",Ao,Y,Pe,Do,_t,Ls="Preprocess an image or batch of images.",Ko,L,Xe,es,yt,As="Resize an image to <code>(size[&quot;height&quot;], size[&quot;width&quot;])</code>.",bo,He,Mo,G,Ee,ts,Tt,Ds="Constructs a fast Got Ocr2 image processor.",os,A,Qe,ss,bt,Ks=`Crop the images to patches and return a list of cropped images.
The number of patches and their grid arrangement are determined by the original image size,
the target patch size and the minimum and maximum number of patches.
The aspect ratio of the patches grid is chosen to be the closest to the original image aspect ratio.`,ns,D,Se,as,Mt,en="A utility that returns number patches for a given image size.",rs,wt,Ye,wo,Le,vo,k,Ae,is,vt,tn=`Constructs a GotOcr2 processor which wraps a <a href="/docs/transformers/main/en/model_doc/got_ocr2#transformers.GotOcr2ImageProcessor">GotOcr2ImageProcessor</a> and
<code>PretrainedTokenizerFast</code> tokenizer into a single processor that inherits both the image processor and
tokenizer functionalities. See the <code>__call__()</code> and <a href="/docs/transformers/main/en/model_doc/got_ocr2#transformers.GotOcr2Processor.decode">decode()</a> for more information.`,cs,K,De,ls,jt,on=`This method forwards all its arguments to PreTrainedTokenizerFast’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.batch_decode">batch_decode()</a>. Please
refer to the docstring of this method for more information.`,ds,ee,Ke,ms,Jt,sn=`This method forwards all its arguments to PreTrainedTokenizerFast’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.decode">decode()</a>. Please refer to
the docstring of this method for more information.`,jo,et,Jo,J,tt,ps,It,nn="The GotOcr2 model which consists of a vision backbone and a language model, without a language modeling head.",hs,Ut,an=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,gs,Gt,rn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,us,F,ot,fs,xt,cn='The <a href="/docs/transformers/main/en/model_doc/got_ocr2#transformers.GotOcr2Model">GotOcr2Model</a> forward method, overrides the <code>__call__</code> special method.',_s,te,ys,oe,st,Ts,Ct,ln="Obtains image last hidden states from the vision tower and apply multimodal projection.",Io,nt,Uo,x,at,bs,kt,dn="The GOT_OCR2 model which consists of a vision backbone and a language model.",Ms,zt,mn=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,ws,Zt,pn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,vs,$,rt,js,Rt,hn='The <a href="/docs/transformers/main/en/model_doc/got_ocr2#transformers.GotOcr2ForConditionalGeneration">GotOcr2ForConditionalGeneration</a> forward method, overrides the <code>__call__</code> special method.',Js,se,Is,ne,Go,it,xo,Ot,Co;return Z=new I({props:{title:"GOT-OCR2",local:"got-ocr2",headingTag:"h1"}}),ie=new I({props:{title:"Overview",local:"overview",headingTag:"h2"}}),ue=new I({props:{title:"Usage example",local:"usage-example",headingTag:"h2"}}),fe=new I({props:{title:"Plain text inference",local:"plain-text-inference",headingTag:"h3"}}),_e=new P({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBBdXRvTW9kZWxGb3JJbWFnZVRleHRUb1RleHQlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWRldmljZSUyMCUzRCUyMCUyMmN1ZGElMjIlMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwJTIyY3B1JTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZVRleHRUb1RleHQuZnJvbV9wcmV0cmFpbmVkKCUyMnN0ZXBmdW4tYWklMkZHT1QtT0NSLTIuMC1oZiUyMiUyQyUyMGRldmljZV9tYXAlM0RkZXZpY2UpJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyc3RlcGZ1bi1haSUyRkdPVC1PQ1ItMi4wLWhmJTIyJTJDJTIwdXNlX2Zhc3QlM0RUcnVlKSUwQSUwQWltYWdlJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaGYtaW50ZXJuYWwtdGVzdGluZyUyRmZpeHR1cmVzX2dvdF9vY3IlMkZyZXNvbHZlJTJGbWFpbiUyRmltYWdlX29jci5qcGclMjIlMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTIwZGV2aWNlJTNEZGV2aWNlKS50byhkZXZpY2UpJTBBJTBBZ2VuZXJhdGVfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoJTBBJTIwJTIwJTIwJTIwKippbnB1dHMlMkMlMEElMjAlMjAlMjAlMjBkb19zYW1wbGUlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHByb2Nlc3Nvci50b2tlbml6ZXIlMkMlMEElMjAlMjAlMjAlMjBzdG9wX3N0cmluZ3MlM0QlMjIlM0MlN0NpbV9lbmQlN0MlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDQwOTYlMkMlMEEpJTBBJTBBcHJvY2Vzc29yLmRlY29kZShnZW5lcmF0ZV9pZHMlNUIwJTJDJTIwaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVELnNoYXBlJTVCMSU1RCUzQSU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModelForImageTextToText
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForImageTextToText.from_pretrained(<span class="hljs-string">&quot;stepfun-ai/GOT-OCR-2.0-hf&quot;</span>, device_map=device)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;stepfun-ai/GOT-OCR-2.0-hf&quot;</span>, use_fast=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/fixtures_got_ocr/resolve/main/image_ocr.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, device=device).to(device)

<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    do_sample=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    tokenizer=processor.tokenizer,
<span class="hljs-meta">... </span>    stop_strings=<span class="hljs-string">&quot;&lt;|im_end|&gt;&quot;</span>,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">4096</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>processor.decode(generate_ids[<span class="hljs-number">0</span>, inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].shape[<span class="hljs-number">1</span>]:], skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-string">&quot;R&amp;D QUALITY IMPROVEMENT\\nSUGGESTION/SOLUTION FORM\\nName/Phone Ext. : (...)&quot;</span>`,wrap:!1}}),ye=new I({props:{title:"Plain text inference batched",local:"plain-text-inference-batched",headingTag:"h3"}}),Te=new P({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBBdXRvTW9kZWxGb3JJbWFnZVRleHRUb1RleHQlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWRldmljZSUyMCUzRCUyMCUyMmN1ZGElMjIlMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwJTIyY3B1JTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZVRleHRUb1RleHQuZnJvbV9wcmV0cmFpbmVkKCUyMnN0ZXBmdW4tYWklMkZHT1QtT0NSLTIuMC1oZiUyMiUyQyUyMGRldmljZV9tYXAlM0RkZXZpY2UpJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyc3RlcGZ1bi1haSUyRkdPVC1PQ1ItMi4wLWhmJTIyJTJDJTIwdXNlX2Zhc3QlM0RUcnVlKSUwQSUwQWltYWdlMSUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmhmLWludGVybmFsLXRlc3RpbmclMkZmaXh0dXJlc19nb3Rfb2NyJTJGcmVzb2x2ZSUyRm1haW4lMkZtdWx0aV9ib3gucG5nJTIyJTBBaW1hZ2UyJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaGYtaW50ZXJuYWwtdGVzdGluZyUyRmZpeHR1cmVzX2dvdF9vY3IlMkZyZXNvbHZlJTJGbWFpbiUyRmltYWdlX29jci5qcGclMjIlMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoJTVCaW1hZ2UxJTJDJTIwaW1hZ2UyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUyMGRldmljZSUzRGRldmljZSkudG8oZGV2aWNlKSUwQSUwQWdlbmVyYXRlX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCUwQSUyMCUyMCUyMCUyMCoqaW5wdXRzJTJDJTBBJTIwJTIwJTIwJTIwZG9fc2FtcGxlJTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0Rwcm9jZXNzb3IudG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwc3RvcF9zdHJpbmdzJTNEJTIyJTNDJTdDaW1fZW5kJTdDJTNFJTIyJTJDJTBBJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0Q0JTJDJTBBKSUwQSUwQXByb2Nlc3Nvci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVfaWRzJTVCJTNBJTJDJTIwaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVELnNoYXBlJTVCMSU1RCUyMCUzQSU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModelForImageTextToText
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForImageTextToText.from_pretrained(<span class="hljs-string">&quot;stepfun-ai/GOT-OCR-2.0-hf&quot;</span>, device_map=device)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;stepfun-ai/GOT-OCR-2.0-hf&quot;</span>, use_fast=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image1 = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/fixtures_got_ocr/resolve/main/multi_box.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image2 = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/fixtures_got_ocr/resolve/main/image_ocr.jpg&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor([image1, image2], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, device=device).to(device)

<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    do_sample=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    tokenizer=processor.tokenizer,
<span class="hljs-meta">... </span>    stop_strings=<span class="hljs-string">&quot;&lt;|im_end|&gt;&quot;</span>,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>processor.batch_decode(generate_ids[:, inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].shape[<span class="hljs-number">1</span>] :], skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&quot;Reducing the number&quot;</span>, <span class="hljs-string">&quot;R&amp;D QUALITY&quot;</span>]`,wrap:!1}}),be=new I({props:{title:"Formatted text inference",local:"formatted-text-inference",headingTag:"h3"}}),we=new P({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBBdXRvTW9kZWxGb3JJbWFnZVRleHRUb1RleHQlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWRldmljZSUyMCUzRCUyMCUyMmN1ZGElMjIlMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwJTIyY3B1JTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZVRleHRUb1RleHQuZnJvbV9wcmV0cmFpbmVkKCUyMnN0ZXBmdW4tYWklMkZHT1QtT0NSLTIuMC1oZiUyMiUyQyUyMGRldmljZV9tYXAlM0RkZXZpY2UpJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyc3RlcGZ1bi1haSUyRkdPVC1PQ1ItMi4wLWhmJTIyJTJDJTIwdXNlX2Zhc3QlM0RUcnVlKSUwQSUwQWltYWdlJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaGYtaW50ZXJuYWwtdGVzdGluZyUyRmZpeHR1cmVzX2dvdF9vY3IlMkZyZXNvbHZlJTJGbWFpbiUyRmxhdGV4LnBuZyUyMiUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvcihpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMkMlMjBmb3JtYXQlM0RUcnVlJTJDJTIwZGV2aWNlJTNEZGV2aWNlKS50byhkZXZpY2UpJTBBJTBBZ2VuZXJhdGVfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoJTBBJTIwJTIwJTIwJTIwKippbnB1dHMlMkMlMEElMjAlMjAlMjAlMjBkb19zYW1wbGUlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHByb2Nlc3Nvci50b2tlbml6ZXIlMkMlMEElMjAlMjAlMjAlMjBzdG9wX3N0cmluZ3MlM0QlMjIlM0MlN0NpbV9lbmQlN0MlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDQwOTYlMkMlMEEpJTBBJTBBcHJvY2Vzc29yLmRlY29kZShnZW5lcmF0ZV9pZHMlNUIwJTJDJTIwaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVELnNoYXBlJTVCMSU1RCUzQSU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModelForImageTextToText
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForImageTextToText.from_pretrained(<span class="hljs-string">&quot;stepfun-ai/GOT-OCR-2.0-hf&quot;</span>, device_map=device)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;stepfun-ai/GOT-OCR-2.0-hf&quot;</span>, use_fast=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/fixtures_got_ocr/resolve/main/latex.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, <span class="hljs-built_in">format</span>=<span class="hljs-literal">True</span>, device=device).to(device)

<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    do_sample=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    tokenizer=processor.tokenizer,
<span class="hljs-meta">... </span>    stop_strings=<span class="hljs-string">&quot;&lt;|im_end|&gt;&quot;</span>,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">4096</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>processor.decode(generate_ids[<span class="hljs-number">0</span>, inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].shape[<span class="hljs-number">1</span>]:], skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-string">&quot;\\\\author{\\nHanwen Jiang*{@html "<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mspace linebreak="newline"></mspace><mi>q</mi><mi>u</mi><mi>a</mi><mi>d</mi></mrow><annotation encoding="application/x-tex">\\\\quad</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="mspace newline"></span><span class="base"><span class="strut" style="height:0.8889em;vertical-align:-0.1944em;"></span><span class="mord mathnormal" style="margin-right:0.03588em;">q</span><span class="mord mathnormal">u</span><span class="mord mathnormal">a</span><span class="mord mathnormal">d</span></span></span></span>"} Arjun Karpur{@html "<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msup><mrow></mrow><mrow><mspace linebreak="newline"></mspace><mi>d</mi><mi>a</mi><mi>g</mi><mi>g</mi><mi>e</mi><mi>r</mi></mrow></msup><mspace linebreak="newline"></mspace><mi>q</mi><mi>u</mi><mi>a</mi><mi>d</mi></mrow><annotation encoding="application/x-tex">{ }^{\\\\dagger} \\\\quad</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8491em;"></span><span class="mord"><span class="mord"></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8491em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mspace mtight newline"></span><span class="mord mathnormal mtight">d</span><span class="mord mathnormal mtight">a</span><span class="mord mathnormal mtight" style="margin-right:0.03588em;">gg</span><span class="mord mathnormal mtight" style="margin-right:0.02778em;">er</span></span></span></span></span></span></span></span></span></span><span class="mspace newline"></span><span class="base"><span class="strut" style="height:0.8889em;vertical-align:-0.1944em;"></span><span class="mord mathnormal" style="margin-right:0.03588em;">q</span><span class="mord mathnormal">u</span><span class="mord mathnormal">a</span><span class="mord mathnormal">d</span></span></span></span>"} Bingyi Cao{@html "<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msup><mrow></mrow><mrow><mspace linebreak="newline"></mspace><mi>d</mi><mi>a</mi><mi>g</mi><mi>g</mi><mi>e</mi><mi>r</mi></mrow></msup><mspace linebreak="newline"></mspace><mi>q</mi><mi>u</mi><mi>a</mi><mi>d</mi></mrow><annotation encoding="application/x-tex">{ }^{\\\\dagger} \\\\quad</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8491em;"></span><span class="mord"><span class="mord"></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8491em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mspace mtight newline"></span><span class="mord mathnormal mtight">d</span><span class="mord mathnormal mtight">a</span><span class="mord mathnormal mtight" style="margin-right:0.03588em;">gg</span><span class="mord mathnormal mtight" style="margin-right:0.02778em;">er</span></span></span></span></span></span></span></span></span></span><span class="mspace newline"></span><span class="base"><span class="strut" style="height:0.8889em;vertical-align:-0.1944em;"></span><span class="mord mathnormal" style="margin-right:0.03588em;">q</span><span class="mord mathnormal">u</span><span class="mord mathnormal">a</span><span class="mord mathnormal">d</span></span></span></span>"} (...)&quot;</span>`,wrap:!1}}),ve=new I({props:{title:"Inference on multiple pages",local:"inference-on-multiple-pages",headingTag:"h3"}}),Je=new P({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBBdXRvTW9kZWxGb3JJbWFnZVRleHRUb1RleHQlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWRldmljZSUyMCUzRCUyMCUyMmN1ZGElMjIlMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwJTIyY3B1JTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZVRleHRUb1RleHQuZnJvbV9wcmV0cmFpbmVkKCUyMnN0ZXBmdW4tYWklMkZHT1QtT0NSLTIuMC1oZiUyMiUyQyUyMGRldmljZV9tYXAlM0RkZXZpY2UpJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyc3RlcGZ1bi1haSUyRkdPVC1PQ1ItMi4wLWhmJTIyJTJDJTIwdXNlX2Zhc3QlM0RUcnVlKSUwQSUwQWltYWdlMSUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmhmLWludGVybmFsLXRlc3RpbmclMkZmaXh0dXJlc19nb3Rfb2NyJTJGcmVzb2x2ZSUyRm1haW4lMkZwYWdlMS5wbmclMjIlMEFpbWFnZTIlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZml4dHVyZXNfZ290X29jciUyRnJlc29sdmUlMkZtYWluJTJGcGFnZTIucG5nJTIyJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKCU1QmltYWdlMSUyQyUyMGltYWdlMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMkMlMjBtdWx0aV9wYWdlJTNEVHJ1ZSUyQyUyMGZvcm1hdCUzRFRydWUlMkMlMjBkZXZpY2UlM0RkZXZpY2UpLnRvKGRldmljZSklMEElMEFnZW5lcmF0ZV9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSglMEElMjAlMjAlMjAlMjAqKmlucHV0cyUyQyUwQSUyMCUyMCUyMCUyMGRvX3NhbXBsZSUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEcHJvY2Vzc29yLnRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMHN0b3Bfc3RyaW5ncyUzRCUyMiUzQyU3Q2ltX2VuZCU3QyUzRSUyMiUyQyUwQSUyMCUyMCUyMCUyMG1heF9uZXdfdG9rZW5zJTNENDA5NiUyQyUwQSklMEElMEFwcm9jZXNzb3IuZGVjb2RlKGdlbmVyYXRlX2lkcyU1QjAlMkMlMjBpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQuc2hhcGUlNUIxJTVEJTNBJTVEJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModelForImageTextToText
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForImageTextToText.from_pretrained(<span class="hljs-string">&quot;stepfun-ai/GOT-OCR-2.0-hf&quot;</span>, device_map=device)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;stepfun-ai/GOT-OCR-2.0-hf&quot;</span>, use_fast=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image1 = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/fixtures_got_ocr/resolve/main/page1.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image2 = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/fixtures_got_ocr/resolve/main/page2.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor([image1, image2], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, multi_page=<span class="hljs-literal">True</span>, <span class="hljs-built_in">format</span>=<span class="hljs-literal">True</span>, device=device).to(device)

<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    do_sample=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    tokenizer=processor.tokenizer,
<span class="hljs-meta">... </span>    stop_strings=<span class="hljs-string">&quot;&lt;|im_end|&gt;&quot;</span>,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">4096</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>processor.decode(generate_ids[<span class="hljs-number">0</span>, inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].shape[<span class="hljs-number">1</span>]:], skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-string">&quot;\\\\title{\\nGeneral OCR Theory: Towards OCR-2.0 via a Unified End-to-end Model\\n}\\n\\\\author{\\nHaoran Wei (...)&quot;</span>`,wrap:!1}}),Ie=new I({props:{title:"Inference on cropped patches",local:"inference-on-cropped-patches",headingTag:"h3"}}),Ge=new P({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyMEF1dG9Nb2RlbEZvckltYWdlVGV4dFRvVGV4dCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlVGV4dFRvVGV4dC5mcm9tX3ByZXRyYWluZWQoJTIyc3RlcGZ1bi1haSUyRkdPVC1PQ1ItMi4wLWhmJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUyMGRldmljZV9tYXAlM0RkZXZpY2UpJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyc3RlcGZ1bi1haSUyRkdPVC1PQ1ItMi4wLWhmJTIyJTJDJTIwdXNlX2Zhc3QlM0RUcnVlKSUwQSUwQWltYWdlJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaGYtaW50ZXJuYWwtdGVzdGluZyUyRmZpeHR1cmVzX2dvdF9vY3IlMkZyZXNvbHZlJTJGbWFpbiUyRm9uZV9jb2x1bW4ucG5nJTIyJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUyMGZvcm1hdCUzRFRydWUlMkMlMjBjcm9wX3RvX3BhdGNoZXMlM0RUcnVlJTJDJTIwbWF4X3BhdGNoZXMlM0QzJTJDJTIwZGV2aWNlJTNEZGV2aWNlKS50byhkZXZpY2UpJTBBJTBBZ2VuZXJhdGVfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoJTBBJTIwJTIwJTIwJTIwKippbnB1dHMlMkMlMEElMjAlMjAlMjAlMjBkb19zYW1wbGUlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHByb2Nlc3Nvci50b2tlbml6ZXIlMkMlMEElMjAlMjAlMjAlMjBzdG9wX3N0cmluZ3MlM0QlMjIlM0MlN0NpbV9lbmQlN0MlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDQwOTYlMkMlMEEpJTBBJTBBcHJvY2Vzc29yLmRlY29kZShnZW5lcmF0ZV9pZHMlNUIwJTJDJTIwaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVELnNoYXBlJTVCMSU1RCUzQSU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModelForImageTextToText
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForImageTextToText.from_pretrained(<span class="hljs-string">&quot;stepfun-ai/GOT-OCR-2.0-hf&quot;</span>, torch_dtype=torch.bfloat16, device_map=device)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;stepfun-ai/GOT-OCR-2.0-hf&quot;</span>, use_fast=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/fixtures_got_ocr/resolve/main/one_column.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, <span class="hljs-built_in">format</span>=<span class="hljs-literal">True</span>, crop_to_patches=<span class="hljs-literal">True</span>, max_patches=<span class="hljs-number">3</span>, device=device).to(device)

<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    do_sample=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    tokenizer=processor.tokenizer,
<span class="hljs-meta">... </span>    stop_strings=<span class="hljs-string">&quot;&lt;|im_end|&gt;&quot;</span>,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">4096</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>processor.decode(generate_ids[<span class="hljs-number">0</span>, inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].shape[<span class="hljs-number">1</span>]:], skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-string">&quot;on developing architectural improvements to make learnable matching methods generalize.\\nMotivated by the above observations, (...)&quot;</span>`,wrap:!1}}),xe=new I({props:{title:"Inference on a specific region",local:"inference-on-a-specific-region",headingTag:"h3"}}),ke=new P({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBBdXRvTW9kZWxGb3JJbWFnZVRleHRUb1RleHQlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWRldmljZSUyMCUzRCUyMCUyMmN1ZGElMjIlMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwJTIyY3B1JTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZVRleHRUb1RleHQuZnJvbV9wcmV0cmFpbmVkKCUyMnN0ZXBmdW4tYWklMkZHT1QtT0NSLTIuMC1oZiUyMiUyQyUyMGRldmljZV9tYXAlM0RkZXZpY2UpJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyc3RlcGZ1bi1haSUyRkdPVC1PQ1ItMi4wLWhmJTIyJTJDJTIwdXNlX2Zhc3QlM0RUcnVlKSUwQSUwQWltYWdlJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaGYtaW50ZXJuYWwtdGVzdGluZyUyRmZpeHR1cmVzX2dvdF9vY3IlMkZyZXNvbHZlJTJGbWFpbiUyRm11bHRpX2JveC5wbmclMjIlMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTIwY29sb3IlM0QlMjJncmVlbiUyMiUyQyUyMGRldmljZSUzRGRldmljZSkudG8oZGV2aWNlKSUyMCUyMyUyMG9yJTIwYm94JTNEJTVCeDElMkMlMjB5MSUyQyUyMHgyJTJDJTIweTIlNUQlMjBmb3IlMjBjb29yZGluYXRlcyUyMChpbWFnZSUyMHBpeGVscyklMEElMEFnZW5lcmF0ZV9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSglMEElMjAlMjAlMjAlMjAqKmlucHV0cyUyQyUwQSUyMCUyMCUyMCUyMGRvX3NhbXBsZSUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEcHJvY2Vzc29yLnRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMHN0b3Bfc3RyaW5ncyUzRCUyMiUzQyU3Q2ltX2VuZCU3QyUzRSUyMiUyQyUwQSUyMCUyMCUyMCUyMG1heF9uZXdfdG9rZW5zJTNENDA5NiUyQyUwQSklMEElMEFwcm9jZXNzb3IuZGVjb2RlKGdlbmVyYXRlX2lkcyU1QjAlMkMlMjBpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQuc2hhcGUlNUIxJTVEJTNBJTVEJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModelForImageTextToText
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForImageTextToText.from_pretrained(<span class="hljs-string">&quot;stepfun-ai/GOT-OCR-2.0-hf&quot;</span>, device_map=device)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;stepfun-ai/GOT-OCR-2.0-hf&quot;</span>, use_fast=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/fixtures_got_ocr/resolve/main/multi_box.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, color=<span class="hljs-string">&quot;green&quot;</span>, device=device).to(device) <span class="hljs-comment"># or box=[x1, y1, x2, y2] for coordinates (image pixels)</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    do_sample=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    tokenizer=processor.tokenizer,
<span class="hljs-meta">... </span>    stop_strings=<span class="hljs-string">&quot;&lt;|im_end|&gt;&quot;</span>,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">4096</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>processor.decode(generate_ids[<span class="hljs-number">0</span>, inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].shape[<span class="hljs-number">1</span>]:], skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-string">&quot;You should keep in mind what features from the module should be used, especially \\nwhen you’re planning to sell a template.&quot;</span>`,wrap:!1}}),ze=new I({props:{title:"Inference on general OCR data example: sheet music",local:"inference-on-general-ocr-data-example-sheet-music",headingTag:"h3"}}),Re=new P({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModelForImageTextToText
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> verovio

<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForImageTextToText.from_pretrained(<span class="hljs-string">&quot;stepfun-ai/GOT-OCR-2.0-hf&quot;</span>, device_map=device)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;stepfun-ai/GOT-OCR-2.0-hf&quot;</span>, use_fast=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/fixtures_got_ocr/resolve/main/sheet_music.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, <span class="hljs-built_in">format</span>=<span class="hljs-literal">True</span>, device=device).to(device)

<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    do_sample=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    tokenizer=processor.tokenizer,
<span class="hljs-meta">... </span>    stop_strings=<span class="hljs-string">&quot;&lt;|im_end|&gt;&quot;</span>,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">4096</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = processor.decode(generate_ids[<span class="hljs-number">0</span>, inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].shape[<span class="hljs-number">1</span>]:], skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tk = verovio.toolkit()
<span class="hljs-meta">&gt;&gt;&gt; </span>tk.loadData(outputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tk.setOptions(
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;pageWidth&quot;</span>: <span class="hljs-number">2100</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;pageHeight&quot;</span>: <span class="hljs-number">800</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;footer&quot;</span>: <span class="hljs-string">&quot;none&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;barLineWidth&quot;</span>: <span class="hljs-number">0.5</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;beamMaxSlope&quot;</span>: <span class="hljs-number">15</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;staffLineWidth&quot;</span>: <span class="hljs-number">0.2</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;spacingStaff&quot;</span>: <span class="hljs-number">6</span>,
<span class="hljs-meta">... </span>    }
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tk.getPageCount()
<span class="hljs-meta">&gt;&gt;&gt; </span>svg = tk.renderToSVG()
<span class="hljs-meta">&gt;&gt;&gt; </span>svg = svg.replace(<span class="hljs-string">&#x27;overflow=&quot;inherit&quot;&#x27;</span>, <span class="hljs-string">&#x27;overflow=&quot;visible&quot;&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;output.svg&quot;</span>, <span class="hljs-string">&quot;w&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">&gt;&gt;&gt; </span>    f.write(svg)`,wrap:!1}}),$e=new I({props:{title:"GotOcr2Config",local:"transformers.GotOcr2Config",headingTag:"h2"}}),Oe=new M({props:{name:"class transformers.GotOcr2Config",anchor:"transformers.GotOcr2Config",parameters:[{name:"vision_config",val:" = None"},{name:"text_config",val:" = None"},{name:"image_token_index",val:" = 151859"},{name:"image_seq_length",val:" = 576"},{name:"pad_token_id",val:" = -1"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GotOcr2Config.vision_config",description:`<strong>vision_config</strong> (<code>Union[AutoConfig, dict]</code>,  <em>optional</em>, defaults to <code>CLIPVisionConfig</code>) &#x2014;
The config object or dictionary of the vision backbone.`,name:"vision_config"},{anchor:"transformers.GotOcr2Config.text_config",description:`<strong>text_config</strong> (<code>Union[AutoConfig, dict]</code>, <em>optional</em>, defaults to <code>LlamaConfig</code>) &#x2014;
The config object or dictionary of the text backbone.`,name:"text_config"},{anchor:"transformers.GotOcr2Config.image_token_index",description:`<strong>image_token_index</strong> (<code>int</code>, <em>optional</em>, defaults to 151859) &#x2014;
The image token index to encode the image prompt.`,name:"image_token_index"},{anchor:"transformers.GotOcr2Config.image_seq_length",description:`<strong>image_seq_length</strong> (<code>int</code>, <em>optional</em>, defaults to 576) &#x2014;
Sequence length of one image embedding.`,name:"image_seq_length"},{anchor:"transformers.GotOcr2Config.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
Padding token id.`,name:"pad_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/got_ocr2/configuration_got_ocr2.py#L118"}}),E=new _n({props:{anchor:"transformers.GotOcr2Config.example",$$slots:{default:[jn]},$$scope:{ctx:N}}}),We=new I({props:{title:"GotOcr2VisionConfig",local:"transformers.GotOcr2VisionConfig",headingTag:"h2"}}),Ne=new M({props:{name:"class transformers.GotOcr2VisionConfig",anchor:"transformers.GotOcr2VisionConfig",parameters:[{name:"hidden_size",val:" = 768"},{name:"output_channels",val:" = 256"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 12"},{name:"num_channels",val:" = 3"},{name:"image_size",val:" = 1024"},{name:"patch_size",val:" = 16"},{name:"hidden_act",val:" = 'gelu'"},{name:"layer_norm_eps",val:" = 1e-06"},{name:"attention_dropout",val:" = 0.0"},{name:"initializer_range",val:" = 1e-10"},{name:"qkv_bias",val:" = True"},{name:"use_abs_pos",val:" = True"},{name:"use_rel_pos",val:" = True"},{name:"window_size",val:" = 14"},{name:"global_attn_indexes",val:" = [2, 5, 8, 11]"},{name:"mlp_dim",val:" = 3072"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GotOcr2VisionConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.GotOcr2VisionConfig.output_channels",description:`<strong>output_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Dimensionality of the output channels in the Patch Encoder.`,name:"output_channels"},{anchor:"transformers.GotOcr2VisionConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.GotOcr2VisionConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.GotOcr2VisionConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
Number of channels in the input image.`,name:"num_channels"},{anchor:"transformers.GotOcr2VisionConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
Expected resolution. Target size of the resized input image.`,name:"image_size"},{anchor:"transformers.GotOcr2VisionConfig.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Size of the patches to be extracted from the input image.`,name:"patch_size"},{anchor:"transformers.GotOcr2VisionConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string)`,name:"hidden_act"},{anchor:"transformers.GotOcr2VisionConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-06) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.GotOcr2VisionConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.GotOcr2VisionConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-10) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.GotOcr2VisionConfig.qkv_bias",description:`<strong>qkv_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to add a bias to query, key, value projections.`,name:"qkv_bias"},{anchor:"transformers.GotOcr2VisionConfig.use_abs_pos",description:`<strong>use_abs_pos</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use absolute position embedding.`,name:"use_abs_pos"},{anchor:"transformers.GotOcr2VisionConfig.use_rel_pos",description:`<strong>use_rel_pos</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use relative position embedding.`,name:"use_rel_pos"},{anchor:"transformers.GotOcr2VisionConfig.window_size",description:`<strong>window_size</strong> (<code>int</code>, <em>optional</em>, defaults to 14) &#x2014;
Window size for relative position.`,name:"window_size"},{anchor:"transformers.GotOcr2VisionConfig.global_attn_indexes",description:`<strong>global_attn_indexes</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[2, 5, 8, 11]</code>) &#x2014;
The indexes of the global attention layers.`,name:"global_attn_indexes"},{anchor:"transformers.GotOcr2VisionConfig.mlp_dim",description:`<strong>mlp_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
The dimensionality of the MLP layer in the Transformer encoder.`,name:"mlp_dim"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/got_ocr2/configuration_got_ocr2.py#L27"}}),Fe=new I({props:{title:"GotOcr2ImageProcessor",local:"transformers.GotOcr2ImageProcessor",headingTag:"h2"}}),Be=new M({props:{name:"class transformers.GotOcr2ImageProcessor",anchor:"transformers.GotOcr2ImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"crop_to_patches",val:": bool = False"},{name:"min_patches",val:": int = 1"},{name:"max_patches",val:": int = 12"},{name:"resample",val:": Resampling = <Resampling.BICUBIC: 3>"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_convert_rgb",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GotOcr2ImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overridden by the
<code>do_resize</code> parameter in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.GotOcr2ImageProcessor.size",description:`<strong>size</strong> (<code>dict</code>, <em>optional</em>, defaults to <code>{&quot;height&quot; -- 384, &quot;width&quot;: 384}</code>):
Size of the output image after resizing. Can be overridden by the <code>size</code> parameter in the <code>preprocess</code>
method.`,name:"size"},{anchor:"transformers.GotOcr2ImageProcessor.crop_to_patches",description:`<strong>crop_to_patches</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to crop the image to patches. Can be overridden by the <code>crop_to_patches</code> parameter in the
<code>preprocess</code> method.`,name:"crop_to_patches"},{anchor:"transformers.GotOcr2ImageProcessor.min_patches",description:`<strong>min_patches</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The minimum number of patches to be extracted from the image. Only has an effect if <code>crop_to_patches</code> is
set to <code>True</code>. Can be overridden by the <code>min_patches</code> parameter in the <code>preprocess</code> method.`,name:"min_patches"},{anchor:"transformers.GotOcr2ImageProcessor.max_patches",description:`<strong>max_patches</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
The maximum number of patches to be extracted from the image. Only has an effect if <code>crop_to_patches</code> is
set to <code>True</code>. Can be overridden by the <code>max_patches</code> parameter in the <code>preprocess</code> method.`,name:"max_patches"},{anchor:"transformers.GotOcr2ImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>Resampling.BICUBIC</code>) &#x2014;
Resampling filter to use if resizing the image. Only has an effect if <code>do_resize</code> is set to <code>True</code>. Can be
overridden by the <code>resample</code> parameter in the <code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.GotOcr2ImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the
<code>do_rescale</code> parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.GotOcr2ImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Only has an effect if <code>do_rescale</code> is set to <code>True</code>. Can be
overridden by the <code>rescale_factor</code> parameter in the <code>preprocess</code> method.`,name:"rescale_factor"},{anchor:"transformers.GotOcr2ImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code>
method. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code> method.`,name:"do_normalize"},{anchor:"transformers.GotOcr2ImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_MEAN</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method. Can be
overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.GotOcr2ImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_STD</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.
Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.GotOcr2ImageProcessor.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/got_ocr2/image_processing_got_ocr2.py#L126"}}),Ve=new M({props:{name:"crop_image_to_patches",anchor:"transformers.GotOcr2ImageProcessor.crop_image_to_patches",parameters:[{name:"images",val:": ndarray"},{name:"min_patches",val:": int"},{name:"max_patches",val:": int"},{name:"use_thumbnail",val:": bool = True"},{name:"patch_size",val:": typing.Union[typing.Tuple, int, dict, NoneType] = None"},{name:"data_format",val:": ChannelDimension = None"}],parametersDescription:[{anchor:"transformers.GotOcr2ImageProcessor.crop_image_to_patches.images",description:`<strong>images</strong> (<code>np.ndarray</code>) &#x2014;
The image to be cropped.`,name:"images"},{anchor:"transformers.GotOcr2ImageProcessor.crop_image_to_patches.min_patches",description:`<strong>min_patches</strong> (<code>int</code>) &#x2014;
The minimum number of patches to be extracted from the image.`,name:"min_patches"},{anchor:"transformers.GotOcr2ImageProcessor.crop_image_to_patches.max_patches",description:`<strong>max_patches</strong> (<code>int</code>) &#x2014;
The maximum number of patches to be extracted from the image.`,name:"max_patches"},{anchor:"transformers.GotOcr2ImageProcessor.crop_image_to_patches.use_thumbnail",description:`<strong>use_thumbnail</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to add a thumbnail image to the list of cropped patches.`,name:"use_thumbnail"},{anchor:"transformers.GotOcr2ImageProcessor.crop_image_to_patches.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <code>Tuple[int, int]</code>, <code>dict</code>, <em>optional</em>) &#x2014;
The size of the output patches.`,name:"patch_size"},{anchor:"transformers.GotOcr2ImageProcessor.crop_image_to_patches.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code>, <em>optional</em>) &#x2014;
The format of the image data. If <code>None</code>, the format is inferred from the input image.`,name:"data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/got_ocr2/image_processing_got_ocr2.py#L416",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The list of cropped images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List<code>PIL.Image.Image</code> or List[np.ndarray]</p>
`}}),qe=new M({props:{name:"get_number_of_image_patches",anchor:"transformers.GotOcr2ImageProcessor.get_number_of_image_patches",parameters:[{name:"height",val:": int"},{name:"width",val:": int"},{name:"images_kwargs",val:" = None"}],parametersDescription:[{anchor:"transformers.GotOcr2ImageProcessor.get_number_of_image_patches.height",description:`<strong>height</strong> (<code>int</code>) &#x2014;
Height of the input image.`,name:"height"},{anchor:"transformers.GotOcr2ImageProcessor.get_number_of_image_patches.width",description:`<strong>width</strong> (<code>int</code>) &#x2014;
Width of the input image.`,name:"width"},{anchor:"transformers.GotOcr2ImageProcessor.get_number_of_image_patches.images_kwargs",description:`<strong>images_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Any kwargs to override defaults of the image processor.`,name:"images_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/got_ocr2/image_processing_got_ocr2.py#L494",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Number of patches per image.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>int</code></p>
`}}),Pe=new M({props:{name:"preprocess",anchor:"transformers.GotOcr2ImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']]"},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"crop_to_patches",val:": typing.Optional[bool] = None"},{name:"min_patches",val:": typing.Optional[int] = None"},{name:"max_patches",val:": typing.Optional[int] = None"},{name:"resample",val:": Resampling = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Optional[float] = None"},{name:"do_normalize",val:": typing.Optional[bool] = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"do_convert_rgb",val:": typing.Optional[bool] = None"},{name:"data_format",val:": ChannelDimension = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.GotOcr2ImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.GotOcr2ImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.GotOcr2ImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Controls the size of the image after <code>resize</code>. The shortest edge of the image is resized to
<code>size[&quot;shortest_edge&quot;]</code> whilst preserving the aspect ratio. If the longest edge of this resized image
is &gt; <code>int(size[&quot;shortest_edge&quot;] * (1333 / 800))</code>, then the image is resized again to make the longest
edge equal to <code>int(size[&quot;shortest_edge&quot;] * (1333 / 800))</code>.`,name:"size"},{anchor:"transformers.GotOcr2ImageProcessor.preprocess.crop_to_patches",description:`<strong>crop_to_patches</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.crop_to_patches</code>) &#x2014;
Whether to crop the image to patches.`,name:"crop_to_patches"},{anchor:"transformers.GotOcr2ImageProcessor.preprocess.min_patches",description:`<strong>min_patches</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.min_patches</code>) &#x2014;
The minimum number of patches to be extracted from the image. Only has an effect if <code>crop_to_patches</code> is
set to <code>True</code>.`,name:"min_patches"},{anchor:"transformers.GotOcr2ImageProcessor.preprocess.max_patches",description:`<strong>max_patches</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.max_patches</code>) &#x2014;
The maximum number of patches to be extracted from the image. Only has an effect if <code>crop_to_patches</code> is
set to <code>True</code>.`,name:"max_patches"},{anchor:"transformers.GotOcr2ImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. Only has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.GotOcr2ImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image values between [0 - 1].`,name:"do_rescale"},{anchor:"transformers.GotOcr2ImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.GotOcr2ImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.GotOcr2ImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean to normalize the image by if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.GotOcr2ImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation to normalize the image by if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_std"},{anchor:"transformers.GotOcr2ImageProcessor.preprocess.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_convert_rgb</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.GotOcr2ImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.GotOcr2ImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.GotOcr2ImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/got_ocr2/image_processing_got_ocr2.py#L253"}}),Xe=new M({props:{name:"resize",anchor:"transformers.GotOcr2ImageProcessor.resize",parameters:[{name:"image",val:": ndarray"},{name:"size",val:": typing.Dict[str, int]"},{name:"resample",val:": Resampling = <Resampling.BICUBIC: 3>"},{name:"data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GotOcr2ImageProcessor.resize.image",description:`<strong>image</strong> (<code>np.ndarray</code>) &#x2014;
Image to resize.`,name:"image"},{anchor:"transformers.GotOcr2ImageProcessor.resize.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>) &#x2014;
Dictionary in the format <code>{&quot;height&quot;: int, &quot;width&quot;: int}</code> specifying the size of the output image.`,name:"size"},{anchor:"transformers.GotOcr2ImageProcessor.resize.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>PILImageResampling.BICUBIC</code>) &#x2014;
<code>PILImageResampling</code> filter to use when resizing the image e.g. <code>PILImageResampling.BICUBIC</code>.`,name:"resample"},{anchor:"transformers.GotOcr2ImageProcessor.resize.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the output image. If unset, the channel dimension format of the input
image is used. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"data_format"},{anchor:"transformers.GotOcr2ImageProcessor.resize.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/got_ocr2/image_processing_got_ocr2.py#L205",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The resized image.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>np.ndarray</code></p>
`}}),He=new I({props:{title:"GotOcr2ImageProcessorFast",local:"transformers.GotOcr2ImageProcessorFast",headingTag:"h2"}}),Ee=new M({props:{name:"class transformers.GotOcr2ImageProcessorFast",anchor:"transformers.GotOcr2ImageProcessorFast",parameters:[{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.got_ocr2.image_processing_got_ocr2_fast.GotOcr2ImageProcessorKwargs]"}],parametersDescription:[{anchor:"transformers.GotOcr2ImageProcessorFast.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.GotOcr2ImageProcessorFast.size",description:`<strong>size</strong> (<code>dict[str, int]</code>, <em>optional</em>, defaults to <code>{&apos;height&apos; -- 384, &apos;width&apos;: 384}</code>):
Describes the maximum input dimensions to the model.`,name:"size"},{anchor:"transformers.GotOcr2ImageProcessorFast.default_to_square",description:`<strong>default_to_square</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to default to a square image when resizing, if size is an int.`,name:"default_to_square"},{anchor:"transformers.GotOcr2ImageProcessorFast.resample",description:`<strong>resample</strong> (<code>Union[PILImageResampling, F.InterpolationMode, NoneType]</code>, defaults to <code>Resampling.BICUBIC</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>. Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.GotOcr2ImageProcessorFast.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Whether to center crop the image.`,name:"do_center_crop"},{anchor:"transformers.GotOcr2ImageProcessorFast.crop_size",description:`<strong>crop_size</strong> (<code>dict[str, int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Size of the output image after applying <code>center_crop</code>.`,name:"crop_size"},{anchor:"transformers.GotOcr2ImageProcessorFast.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.GotOcr2ImageProcessorFast.rescale_factor",description:`<strong>rescale_factor</strong> (<code>Union[int, float, NoneType]</code>, defaults to <code>0.00392156862745098</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.GotOcr2ImageProcessorFast.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.GotOcr2ImageProcessorFast.image_mean",description:`<strong>image_mean</strong> (<code>Union[float, list[float], NoneType]</code>, defaults to <code>[0.48145466, 0.4578275, 0.40821073]</code>) &#x2014;
Image mean to use for normalization. Only has an effect if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.GotOcr2ImageProcessorFast.image_std",description:`<strong>image_std</strong> (<code>Union[float, list[float], NoneType]</code>, defaults to <code>[0.26862954, 0.26130258, 0.27577711]</code>) &#x2014;
Image standard deviation to use for normalization. Only has an effect if <code>do_normalize</code> is set to
<code>True</code>.`,name:"image_std"},{anchor:"transformers.GotOcr2ImageProcessorFast.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.GotOcr2ImageProcessorFast.return_tensors",description:"<strong>return_tensors</strong> (<code>Union[str, ~utils.generic.TensorType, NoneType]</code>, defaults to <code>None</code>) &#x2014;\nReturns stacked tensors if set to `pt, otherwise returns a list of tensors.",name:"return_tensors"},{anchor:"transformers.GotOcr2ImageProcessorFast.data_format",description:`<strong>data_format</strong> (<code>~image_utils.ChannelDimension</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
Only <code>ChannelDimension.FIRST</code> is supported. Added for compatibility with slow processors.`,name:"data_format"},{anchor:"transformers.GotOcr2ImageProcessorFast.input_data_format",description:`<strong>input_data_format</strong> (<code>Union[~image_utils.ChannelDimension, str, NoneType]</code>, defaults to <code>None</code>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"},{anchor:"transformers.GotOcr2ImageProcessorFast.device",description:`<strong>device</strong> (<code>torch.device</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The device to process the images on. If unset, the device is inferred from the input images.`,name:"device"},{anchor:"transformers.GotOcr2ImageProcessorFast.crop_to_patches",description:`<strong>crop_to_patches</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to crop the image to patches. Can be overridden by the <code>crop_to_patches</code> parameter in the
<code>preprocess</code> method.`,name:"crop_to_patches"},{anchor:"transformers.GotOcr2ImageProcessorFast.min_patches",description:`<strong>min_patches</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The minimum number of patches to be extracted from the image. Only has an effect if <code>crop_to_patches</code> is
set to <code>True</code>. Can be overridden by the <code>min_patches</code> parameter in the <code>preprocess</code> method.`,name:"min_patches"},{anchor:"transformers.GotOcr2ImageProcessorFast.max_patches",description:`<strong>max_patches</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
The maximum number of patches to be extracted from the image. Only has an effect if <code>crop_to_patches</code> is
set to <code>True</code>. Can be overridden by the <code>max_patches</code> parameter in the <code>preprocess</code> method.`,name:"max_patches"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/got_ocr2/image_processing_got_ocr2_fast.py#L72"}}),Qe=new M({props:{name:"crop_image_to_patches",anchor:"transformers.GotOcr2ImageProcessorFast.crop_image_to_patches",parameters:[{name:"images",val:": torch.Tensor"},{name:"min_patches",val:": int"},{name:"max_patches",val:": int"},{name:"use_thumbnail",val:": bool = True"},{name:"patch_size",val:": typing.Union[typing.Tuple, int, dict, NoneType] = None"},{name:"interpolation",val:": typing.Optional[ForwardRef('F.InterpolationMode')] = None"}],parametersDescription:[{anchor:"transformers.GotOcr2ImageProcessorFast.crop_image_to_patches.images",description:`<strong>images</strong> (<code>torch.Tensor</code>) &#x2014;
The images to be cropped.`,name:"images"},{anchor:"transformers.GotOcr2ImageProcessorFast.crop_image_to_patches.min_patches",description:`<strong>min_patches</strong> (<code>int</code>) &#x2014;
The minimum number of patches to be extracted from the image.`,name:"min_patches"},{anchor:"transformers.GotOcr2ImageProcessorFast.crop_image_to_patches.max_patches",description:`<strong>max_patches</strong> (<code>int</code>) &#x2014;
The maximum number of patches to be extracted from the image.`,name:"max_patches"},{anchor:"transformers.GotOcr2ImageProcessorFast.crop_image_to_patches.use_thumbnail",description:`<strong>use_thumbnail</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to add a thumbnail image to the list of cropped patches.`,name:"use_thumbnail"},{anchor:"transformers.GotOcr2ImageProcessorFast.crop_image_to_patches.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <code>Tuple[int, int]</code>, <code>dict</code>, <em>optional</em>) &#x2014;
The size of the output patches.
The format of the image data. If <code>None</code>, the format is inferred from the input image.`,name:"patch_size"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/got_ocr2/image_processing_got_ocr2_fast.py#L94",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The list of cropped images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List<code>PIL.Image.Image</code> or List[np.ndarray]</p>
`}}),Se=new M({props:{name:"get_number_of_image_tokens",anchor:"transformers.GotOcr2ImageProcessorFast.get_number_of_image_tokens",parameters:[{name:"height",val:": int"},{name:"width",val:": int"},{name:"images_kwargs",val:" = None"}],parametersDescription:[{anchor:"transformers.GotOcr2ImageProcessorFast.get_number_of_image_tokens.height",description:`<strong>height</strong> (<code>int</code>) &#x2014;
Height of the input image.`,name:"height"},{anchor:"transformers.GotOcr2ImageProcessorFast.get_number_of_image_tokens.width",description:`<strong>width</strong> (<code>int</code>) &#x2014;
Width of the input image.`,name:"width"},{anchor:"transformers.GotOcr2ImageProcessorFast.get_number_of_image_tokens.images_kwargs",description:`<strong>images_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Any kwargs to override defaults of the image processor.`,name:"images_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/got_ocr2/image_processing_got_ocr2_fast.py#L231",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Number of patches per image.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>int</code></p>
`}}),Ye=new M({props:{name:"preprocess",anchor:"transformers.GotOcr2ImageProcessorFast.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']]"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.got_ocr2.image_processing_got_ocr2_fast.GotOcr2ImageProcessorKwargs]"}],parametersDescription:[{anchor:"transformers.GotOcr2ImageProcessorFast.preprocess.images",description:`<strong>images</strong> (<code>Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, list[&apos;PIL.Image.Image&apos;], list[numpy.ndarray], list[&apos;torch.Tensor&apos;]]</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.GotOcr2ImageProcessorFast.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.GotOcr2ImageProcessorFast.preprocess.size",description:`<strong>size</strong> (<code>dict[str, int]</code>, <em>optional</em>) &#x2014;
Describes the maximum input dimensions to the model.`,name:"size"},{anchor:"transformers.GotOcr2ImageProcessorFast.preprocess.default_to_square",description:`<strong>default_to_square</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to default to a square image when resizing, if size is an int.`,name:"default_to_square"},{anchor:"transformers.GotOcr2ImageProcessorFast.preprocess.resample",description:`<strong>resample</strong> (<code>Union[PILImageResampling, F.InterpolationMode, NoneType]</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>. Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.GotOcr2ImageProcessorFast.preprocess.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to center crop the image.`,name:"do_center_crop"},{anchor:"transformers.GotOcr2ImageProcessorFast.preprocess.crop_size",description:`<strong>crop_size</strong> (<code>dict[str, int]</code>, <em>optional</em>) &#x2014;
Size of the output image after applying <code>center_crop</code>.`,name:"crop_size"},{anchor:"transformers.GotOcr2ImageProcessorFast.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.GotOcr2ImageProcessorFast.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>Union[int, float, NoneType]</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.GotOcr2ImageProcessorFast.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.GotOcr2ImageProcessorFast.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>Union[float, list[float], NoneType]</code>) &#x2014;
Image mean to use for normalization. Only has an effect if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.GotOcr2ImageProcessorFast.preprocess.image_std",description:`<strong>image_std</strong> (<code>Union[float, list[float], NoneType]</code>) &#x2014;
Image standard deviation to use for normalization. Only has an effect if <code>do_normalize</code> is set to
<code>True</code>.`,name:"image_std"},{anchor:"transformers.GotOcr2ImageProcessorFast.preprocess.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.GotOcr2ImageProcessorFast.preprocess.return_tensors",description:"<strong>return_tensors</strong> (<code>Union[str, ~utils.generic.TensorType, NoneType]</code>) &#x2014;\nReturns stacked tensors if set to `pt, otherwise returns a list of tensors.",name:"return_tensors"},{anchor:"transformers.GotOcr2ImageProcessorFast.preprocess.data_format",description:`<strong>data_format</strong> (<code>~image_utils.ChannelDimension</code>, <em>optional</em>) &#x2014;
Only <code>ChannelDimension.FIRST</code> is supported. Added for compatibility with slow processors.`,name:"data_format"},{anchor:"transformers.GotOcr2ImageProcessorFast.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>Union[~image_utils.ChannelDimension, str, NoneType]</code>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"},{anchor:"transformers.GotOcr2ImageProcessorFast.preprocess.device",description:`<strong>device</strong> (<code>torch.device</code>, <em>optional</em>) &#x2014;
The device to process the images on. If unset, the device is inferred from the input images.`,name:"device"},{anchor:"transformers.GotOcr2ImageProcessorFast.preprocess.crop_to_patches",description:`<strong>crop_to_patches</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to crop the image to patches. Can be overridden by the <code>crop_to_patches</code> parameter in the
<code>preprocess</code> method.`,name:"crop_to_patches"},{anchor:"transformers.GotOcr2ImageProcessorFast.preprocess.min_patches",description:`<strong>min_patches</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The minimum number of patches to be extracted from the image. Only has an effect if <code>crop_to_patches</code> is
set to <code>True</code>. Can be overridden by the <code>min_patches</code> parameter in the <code>preprocess</code> method.`,name:"min_patches"},{anchor:"transformers.GotOcr2ImageProcessorFast.preprocess.max_patches",description:`<strong>max_patches</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
The maximum number of patches to be extracted from the image. Only has an effect if <code>crop_to_patches</code> is
set to <code>True</code>. Can be overridden by the <code>max_patches</code> parameter in the <code>preprocess</code> method.`,name:"max_patches"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/got_ocr2/image_processing_got_ocr2_fast.py#L90",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><strong>data</strong> (<code>dict</code>) — Dictionary of lists/arrays/tensors returned by the <strong>call</strong> method (‘pixel_values’, etc.).</li>
<li><strong>tensor_type</strong> (<code>Union[None, str, TensorType]</code>, <em>optional</em>) — You can give a tensor_type here to convert the lists of integers in PyTorch/TensorFlow/Numpy Tensors at
initialization.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>&lt;class 'transformers.image_processing_base.BatchFeature'&gt;</code></p>
`}}),Le=new I({props:{title:"GotOcr2Processor",local:"transformers.GotOcr2Processor",headingTag:"h2"}}),Ae=new M({props:{name:"class transformers.GotOcr2Processor",anchor:"transformers.GotOcr2Processor",parameters:[{name:"image_processor",val:" = None"},{name:"tokenizer",val:" = None"},{name:"chat_template",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GotOcr2Processor.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/main/en/model_doc/got_ocr2#transformers.GotOcr2ImageProcessor">GotOcr2ImageProcessor</a>, <em>optional</em>) &#x2014;
The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.GotOcr2Processor.tokenizer",description:`<strong>tokenizer</strong> ([<code>PreTrainedTokenizer</code>, <code>PreTrainedTokenizerFast</code>], <em>optional</em>) &#x2014;
The tokenizer is a required input.`,name:"tokenizer"},{anchor:"transformers.GotOcr2Processor.chat_template",description:`<strong>chat_template</strong> (<code>str</code>, <em>optional</em>) &#x2014; A Jinja template which will be used to convert lists of messages
in a chat into a tokenizable string.`,name:"chat_template"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/got_ocr2/processing_got_ocr2.py#L83"}}),De=new M({props:{name:"batch_decode",anchor:"transformers.GotOcr2Processor.batch_decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/got_ocr2/processing_got_ocr2.py#L260"}}),Ke=new M({props:{name:"decode",anchor:"transformers.GotOcr2Processor.decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/got_ocr2/processing_got_ocr2.py#L267"}}),et=new I({props:{title:"GotOcr2Model",local:"transformers.GotOcr2Model",headingTag:"h2"}}),tt=new M({props:{name:"class transformers.GotOcr2Model",anchor:"transformers.GotOcr2Model",parameters:[{name:"config",val:": GotOcr2Config"}],parametersDescription:[{anchor:"transformers.GotOcr2Model.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/got_ocr2#transformers.GotOcr2Config">GotOcr2Config</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/got_ocr2/modeling_got_ocr2.py#L618"}}),ot=new M({props:{name:"forward",anchor:"transformers.GotOcr2Model.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"pixel_values",val:": FloatTensor = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.modeling_flash_attention_utils.FlashAttentionKwargs]"}],parametersDescription:[{anchor:"transformers.GotOcr2Model.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.GotOcr2Model.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.GotOcr2Model.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.GotOcr2Model.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.GotOcr2Model.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>List[torch.FloatTensor]</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.GotOcr2Model.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.GotOcr2Model.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.GotOcr2Model.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.GotOcr2Model.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.GotOcr2Model.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.GotOcr2Model.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/got_ocr2/modeling_got_ocr2.py#L655",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.got_ocr2.modeling_got_ocr2.GotOcr2ModelOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/got_ocr2#transformers.GotOcr2Config"
>GotOcr2Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>image_hidden_states</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) — A <code>torch.FloatTensor</code> of size <code>(batch_size, num_images, sequence_length, hidden_size)</code>.
image_hidden_states of the model produced by the vision encoder and after projecting the last hidden state.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.got_ocr2.modeling_got_ocr2.GotOcr2ModelOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),te=new fn({props:{$$slots:{default:[Jn]},$$scope:{ctx:N}}}),st=new M({props:{name:"get_image_features",anchor:"transformers.GotOcr2Model.get_image_features",parameters:[{name:"pixel_values",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.GotOcr2Model.get_image_features.pixel_values",description:"<strong>pixel_values</strong> (<code>torch.FloatTensor]</code> of shape <code>(batch_size, channels, height, width)</code>) &#x2014;",name:"pixel_values"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/got_ocr2/modeling_got_ocr2.py#L640",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Image feature tensor of shape <code>(num_images, image_length, embed_dim)</code>).</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>image_features (<code>torch.Tensor</code>)</p>
`}}),nt=new I({props:{title:"GotOcr2ForConditionalGeneration",local:"transformers.GotOcr2ForConditionalGeneration",headingTag:"h2"}}),at=new M({props:{name:"class transformers.GotOcr2ForConditionalGeneration",anchor:"transformers.GotOcr2ForConditionalGeneration",parameters:[{name:"config",val:": GotOcr2Config"}],parametersDescription:[{anchor:"transformers.GotOcr2ForConditionalGeneration.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/got_ocr2#transformers.GotOcr2Config">GotOcr2Config</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/got_ocr2/modeling_got_ocr2.py#L727"}}),rt=new M({props:{name:"forward",anchor:"transformers.GotOcr2ForConditionalGeneration.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"pixel_values",val:": FloatTensor = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"logits_to_keep",val:": typing.Union[int, torch.Tensor] = 0"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.got_ocr2.modeling_got_ocr2.KwargsForCausalLM]"}],parametersDescription:[{anchor:"transformers.GotOcr2ForConditionalGeneration.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.GotOcr2ForConditionalGeneration.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.GotOcr2ForConditionalGeneration.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.GotOcr2ForConditionalGeneration.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.GotOcr2ForConditionalGeneration.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>List[torch.FloatTensor]</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.GotOcr2ForConditionalGeneration.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.GotOcr2ForConditionalGeneration.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"labels"},{anchor:"transformers.GotOcr2ForConditionalGeneration.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.GotOcr2ForConditionalGeneration.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.GotOcr2ForConditionalGeneration.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.GotOcr2ForConditionalGeneration.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.GotOcr2ForConditionalGeneration.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"},{anchor:"transformers.GotOcr2ForConditionalGeneration.forward.logits_to_keep",description:`<strong>logits_to_keep</strong> (<code>Union[int, torch.Tensor]</code>, defaults to <code>0</code>) &#x2014;
If an <code>int</code>, compute logits for the last <code>logits_to_keep</code> tokens. If <code>0</code>, calculate logits for all
<code>input_ids</code> (special case). Only last token logits are needed for generation, and calculating them only for that
token can save memory, which becomes pretty significant for long sequences or large vocabulary size.
If a <code>torch.Tensor</code>, must be 1D corresponding to the indices to keep in the sequence length dimension.
This is useful when using packed tensor format (single dimension for batch and sequence length).`,name:"logits_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/got_ocr2/modeling_got_ocr2.py#L778",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.got_ocr2.modeling_got_ocr2.GotOcr2CausalLMOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/got_ocr2#transformers.GotOcr2Config"
>GotOcr2Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>image_hidden_states</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) — A <code>torch.FloatTensor</code> of size <code>(batch_size, num_images, sequence_length, hidden_size)</code>.
image_hidden_states of the model produced by the vision encoder and after projecting the last hidden state.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.got_ocr2.modeling_got_ocr2.GotOcr2CausalLMOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),se=new fn({props:{$$slots:{default:[In]},$$scope:{ctx:N}}}),ne=new _n({props:{anchor:"transformers.GotOcr2ForConditionalGeneration.forward.example",$$slots:{default:[Un]},$$scope:{ctx:N}}}),it=new vn({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/got_ocr2.md"}}),{c(){u=i("meta"),w=s(),_=i("p"),v=s(),l(Z.$$.fragment),b=s(),R=i("div"),R.innerHTML=Us,Wt=s(),l(ie.$$.fragment),Nt=s(),ce=i("p"),ce.innerHTML=Gs,Ft=s(),le=i("p"),le.textContent=xs,Bt=s(),de=i("p"),de.innerHTML=Cs,Vt=s(),X=i("img"),qt=s(),me=i("small"),me.innerHTML=zs,Pt=s(),pe=i("p"),pe.textContent=Zs,Xt=s(),he=i("p"),he.innerHTML=Rs,Ht=s(),ge=i("p"),ge.innerHTML=$s,Et=s(),l(ue.$$.fragment),Qt=s(),l(fe.$$.fragment),St=s(),l(_e.$$.fragment),Yt=s(),l(ye.$$.fragment),Lt=s(),l(Te.$$.fragment),At=s(),l(be.$$.fragment),Dt=s(),Me=i("p"),Me.textContent=Os,Kt=s(),l(we.$$.fragment),eo=s(),l(ve.$$.fragment),to=s(),je=i("p"),je.textContent=Ws,oo=s(),l(Je.$$.fragment),so=s(),l(Ie.$$.fragment),no=s(),Ue=i("p"),Ue.textContent=Ns,ao=s(),l(Ge.$$.fragment),ro=s(),l(xe.$$.fragment),io=s(),Ce=i("p"),Ce.textContent=Fs,co=s(),l(ke.$$.fragment),lo=s(),l(ze.$$.fragment),mo=s(),Ze=i("p"),Ze.innerHTML=Bs,po=s(),l(Re.$$.fragment),ho=s(),H=i("img"),go=s(),l($e.$$.fragment),uo=s(),U=i("div"),l(Oe.$$.fragment),Bo=s(),lt=i("p"),lt.innerHTML=qs,Vo=s(),dt=i("p"),dt.innerHTML=Ps,qo=s(),mt=i("p"),mt.innerHTML=Xs,Po=s(),l(E.$$.fragment),fo=s(),l(We.$$.fragment),_o=s(),W=i("div"),l(Ne.$$.fragment),Xo=s(),pt=i("p"),pt.innerHTML=Hs,Ho=s(),ht=i("p"),ht.innerHTML=Es,yo=s(),l(Fe.$$.fragment),To=s(),j=i("div"),l(Be.$$.fragment),Eo=s(),gt=i("p"),gt.textContent=Qs,Qo=s(),Q=i("div"),l(Ve.$$.fragment),So=s(),ut=i("p"),ut.textContent=Ss,Yo=s(),S=i("div"),l(qe.$$.fragment),Lo=s(),ft=i("p"),ft.textContent=Ys,Ao=s(),Y=i("div"),l(Pe.$$.fragment),Do=s(),_t=i("p"),_t.textContent=Ls,Ko=s(),L=i("div"),l(Xe.$$.fragment),es=s(),yt=i("p"),yt.innerHTML=As,bo=s(),l(He.$$.fragment),Mo=s(),G=i("div"),l(Ee.$$.fragment),ts=s(),Tt=i("p"),Tt.textContent=Ds,os=s(),A=i("div"),l(Qe.$$.fragment),ss=s(),bt=i("p"),bt.textContent=Ks,ns=s(),D=i("div"),l(Se.$$.fragment),as=s(),Mt=i("p"),Mt.textContent=en,rs=s(),wt=i("div"),l(Ye.$$.fragment),wo=s(),l(Le.$$.fragment),vo=s(),k=i("div"),l(Ae.$$.fragment),is=s(),vt=i("p"),vt.innerHTML=tn,cs=s(),K=i("div"),l(De.$$.fragment),ls=s(),jt=i("p"),jt.innerHTML=on,ds=s(),ee=i("div"),l(Ke.$$.fragment),ms=s(),Jt=i("p"),Jt.innerHTML=sn,jo=s(),l(et.$$.fragment),Jo=s(),J=i("div"),l(tt.$$.fragment),ps=s(),It=i("p"),It.textContent=nn,hs=s(),Ut=i("p"),Ut.innerHTML=an,gs=s(),Gt=i("p"),Gt.innerHTML=rn,us=s(),F=i("div"),l(ot.$$.fragment),fs=s(),xt=i("p"),xt.innerHTML=cn,_s=s(),l(te.$$.fragment),ys=s(),oe=i("div"),l(st.$$.fragment),Ts=s(),Ct=i("p"),Ct.textContent=ln,Io=s(),l(nt.$$.fragment),Uo=s(),x=i("div"),l(at.$$.fragment),bs=s(),kt=i("p"),kt.textContent=dn,Ms=s(),zt=i("p"),zt.innerHTML=mn,ws=s(),Zt=i("p"),Zt.innerHTML=pn,vs=s(),$=i("div"),l(rt.$$.fragment),js=s(),Rt=i("p"),Rt.innerHTML=hn,Js=s(),l(se.$$.fragment),Is=s(),l(ne.$$.fragment),Go=s(),l(it.$$.fragment),xo=s(),Ot=i("p"),this.h()},l(e){const t=wn("svelte-u9bgzb",document.head);u=c(t,"META",{name:!0,content:!0}),t.forEach(o),w=n(e),_=c(e,"P",{}),T(_).forEach(o),v=n(e),d(Z.$$.fragment,e),b=n(e),R=c(e,"DIV",{class:!0,"data-svelte-h":!0}),f(R)!=="svelte-13t8s2t"&&(R.innerHTML=Us),Wt=n(e),d(ie.$$.fragment,e),Nt=n(e),ce=c(e,"P",{"data-svelte-h":!0}),f(ce)!=="svelte-g5p5bk"&&(ce.innerHTML=Gs),Ft=n(e),le=c(e,"P",{"data-svelte-h":!0}),f(le)!=="svelte-vfdo9a"&&(le.textContent=xs),Bt=n(e),de=c(e,"P",{"data-svelte-h":!0}),f(de)!=="svelte-1gg8rmy"&&(de.innerHTML=Cs),Vt=n(e),X=c(e,"IMG",{src:!0,alt:!0,width:!0}),qt=n(e),me=c(e,"SMALL",{"data-svelte-h":!0}),f(me)!=="svelte-a6x3c0"&&(me.innerHTML=zs),Pt=n(e),pe=c(e,"P",{"data-svelte-h":!0}),f(pe)!=="svelte-axv494"&&(pe.textContent=Zs),Xt=n(e),he=c(e,"P",{"data-svelte-h":!0}),f(he)!=="svelte-16ypbp5"&&(he.innerHTML=Rs),Ht=n(e),ge=c(e,"P",{"data-svelte-h":!0}),f(ge)!=="svelte-1m1qiop"&&(ge.innerHTML=$s),Et=n(e),d(ue.$$.fragment,e),Qt=n(e),d(fe.$$.fragment,e),St=n(e),d(_e.$$.fragment,e),Yt=n(e),d(ye.$$.fragment,e),Lt=n(e),d(Te.$$.fragment,e),At=n(e),d(be.$$.fragment,e),Dt=n(e),Me=c(e,"P",{"data-svelte-h":!0}),f(Me)!=="svelte-148y0f4"&&(Me.textContent=Os),Kt=n(e),d(we.$$.fragment,e),eo=n(e),d(ve.$$.fragment,e),to=n(e),je=c(e,"P",{"data-svelte-h":!0}),f(je)!=="svelte-14wxjuz"&&(je.textContent=Ws),oo=n(e),d(Je.$$.fragment,e),so=n(e),d(Ie.$$.fragment,e),no=n(e),Ue=c(e,"P",{"data-svelte-h":!0}),f(Ue)!=="svelte-17mhybv"&&(Ue.textContent=Ns),ao=n(e),d(Ge.$$.fragment,e),ro=n(e),d(xe.$$.fragment,e),io=n(e),Ce=c(e,"P",{"data-svelte-h":!0}),f(Ce)!=="svelte-2al3wt"&&(Ce.textContent=Fs),co=n(e),d(ke.$$.fragment,e),lo=n(e),d(ze.$$.fragment,e),mo=n(e),Ze=c(e,"P",{"data-svelte-h":!0}),f(Ze)!=="svelte-ebj6ng"&&(Ze.innerHTML=Bs),po=n(e),d(Re.$$.fragment,e),ho=n(e),H=c(e,"IMG",{src:!0,alt:!0,width:!0}),go=n(e),d($e.$$.fragment,e),uo=n(e),U=c(e,"DIV",{class:!0});var z=T(U);d(Oe.$$.fragment,z),Bo=n(z),lt=c(z,"P",{"data-svelte-h":!0}),f(lt)!=="svelte-nodo4f"&&(lt.innerHTML=qs),Vo=n(z),dt=c(z,"P",{"data-svelte-h":!0}),f(dt)!=="svelte-t42ckt"&&(dt.innerHTML=Ps),qo=n(z),mt=c(z,"P",{"data-svelte-h":!0}),f(mt)!=="svelte-o55m63"&&(mt.innerHTML=Xs),Po=n(z),d(E.$$.fragment,z),z.forEach(o),fo=n(e),d(We.$$.fragment,e),_o=n(e),W=c(e,"DIV",{class:!0});var q=T(W);d(Ne.$$.fragment,q),Xo=n(q),pt=c(q,"P",{"data-svelte-h":!0}),f(pt)!=="svelte-1dcilvq"&&(pt.innerHTML=Hs),Ho=n(q),ht=c(q,"P",{"data-svelte-h":!0}),f(ht)!=="svelte-o55m63"&&(ht.innerHTML=Es),q.forEach(o),yo=n(e),d(Fe.$$.fragment,e),To=n(e),j=c(e,"DIV",{class:!0});var C=T(j);d(Be.$$.fragment,C),Eo=n(C),gt=c(C,"P",{"data-svelte-h":!0}),f(gt)!=="svelte-youup"&&(gt.textContent=Qs),Qo=n(C),Q=c(C,"DIV",{class:!0});var ct=T(Q);d(Ve.$$.fragment,ct),So=n(ct),ut=c(ct,"P",{"data-svelte-h":!0}),f(ut)!=="svelte-j3z5fq"&&(ut.textContent=Ss),ct.forEach(o),Yo=n(C),S=c(C,"DIV",{class:!0});var ko=T(S);d(qe.$$.fragment,ko),Lo=n(ko),ft=c(ko,"P",{"data-svelte-h":!0}),f(ft)!=="svelte-1g7w44j"&&(ft.textContent=Ys),ko.forEach(o),Ao=n(C),Y=c(C,"DIV",{class:!0});var zo=T(Y);d(Pe.$$.fragment,zo),Do=n(zo),_t=c(zo,"P",{"data-svelte-h":!0}),f(_t)!=="svelte-1x3yxsa"&&(_t.textContent=Ls),zo.forEach(o),Ko=n(C),L=c(C,"DIV",{class:!0});var Zo=T(L);d(Xe.$$.fragment,Zo),es=n(Zo),yt=c(Zo,"P",{"data-svelte-h":!0}),f(yt)!=="svelte-1oee9wu"&&(yt.innerHTML=As),Zo.forEach(o),C.forEach(o),bo=n(e),d(He.$$.fragment,e),Mo=n(e),G=c(e,"DIV",{class:!0});var B=T(G);d(Ee.$$.fragment,B),ts=n(B),Tt=c(B,"P",{"data-svelte-h":!0}),f(Tt)!=="svelte-gf7af0"&&(Tt.textContent=Ds),os=n(B),A=c(B,"DIV",{class:!0});var Ro=T(A);d(Qe.$$.fragment,Ro),ss=n(Ro),bt=c(Ro,"P",{"data-svelte-h":!0}),f(bt)!=="svelte-n3q7zj"&&(bt.textContent=Ks),Ro.forEach(o),ns=n(B),D=c(B,"DIV",{class:!0});var $o=T(D);d(Se.$$.fragment,$o),as=n($o),Mt=c($o,"P",{"data-svelte-h":!0}),f(Mt)!=="svelte-1g7w44j"&&(Mt.textContent=en),$o.forEach(o),rs=n(B),wt=c(B,"DIV",{class:!0});var gn=T(wt);d(Ye.$$.fragment,gn),gn.forEach(o),B.forEach(o),wo=n(e),d(Le.$$.fragment,e),vo=n(e),k=c(e,"DIV",{class:!0});var ae=T(k);d(Ae.$$.fragment,ae),is=n(ae),vt=c(ae,"P",{"data-svelte-h":!0}),f(vt)!=="svelte-1v291js"&&(vt.innerHTML=tn),cs=n(ae),K=c(ae,"DIV",{class:!0});var Oo=T(K);d(De.$$.fragment,Oo),ls=n(Oo),jt=c(Oo,"P",{"data-svelte-h":!0}),f(jt)!=="svelte-1yrf9bj"&&(jt.innerHTML=on),Oo.forEach(o),ds=n(ae),ee=c(ae,"DIV",{class:!0});var Wo=T(ee);d(Ke.$$.fragment,Wo),ms=n(Wo),Jt=c(Wo,"P",{"data-svelte-h":!0}),f(Jt)!=="svelte-1jl7gd5"&&(Jt.innerHTML=sn),Wo.forEach(o),ae.forEach(o),jo=n(e),d(et.$$.fragment,e),Jo=n(e),J=c(e,"DIV",{class:!0});var O=T(J);d(tt.$$.fragment,O),ps=n(O),It=c(O,"P",{"data-svelte-h":!0}),f(It)!=="svelte-c3j7d5"&&(It.textContent=nn),hs=n(O),Ut=c(O,"P",{"data-svelte-h":!0}),f(Ut)!=="svelte-6pahdo"&&(Ut.innerHTML=an),gs=n(O),Gt=c(O,"P",{"data-svelte-h":!0}),f(Gt)!=="svelte-hswkmf"&&(Gt.innerHTML=rn),us=n(O),F=c(O,"DIV",{class:!0});var $t=T(F);d(ot.$$.fragment,$t),fs=n($t),xt=c($t,"P",{"data-svelte-h":!0}),f(xt)!=="svelte-1qrfon2"&&(xt.innerHTML=cn),_s=n($t),d(te.$$.fragment,$t),$t.forEach(o),ys=n(O),oe=c(O,"DIV",{class:!0});var No=T(oe);d(st.$$.fragment,No),Ts=n(No),Ct=c(No,"P",{"data-svelte-h":!0}),f(Ct)!=="svelte-1vzo9k5"&&(Ct.textContent=ln),No.forEach(o),O.forEach(o),Io=n(e),d(nt.$$.fragment,e),Uo=n(e),x=c(e,"DIV",{class:!0});var V=T(x);d(at.$$.fragment,V),bs=n(V),kt=c(V,"P",{"data-svelte-h":!0}),f(kt)!=="svelte-gmv7g2"&&(kt.textContent=dn),Ms=n(V),zt=c(V,"P",{"data-svelte-h":!0}),f(zt)!=="svelte-6pahdo"&&(zt.innerHTML=mn),ws=n(V),Zt=c(V,"P",{"data-svelte-h":!0}),f(Zt)!=="svelte-hswkmf"&&(Zt.innerHTML=pn),vs=n(V),$=c(V,"DIV",{class:!0});var re=T($);d(rt.$$.fragment,re),js=n(re),Rt=c(re,"P",{"data-svelte-h":!0}),f(Rt)!=="svelte-17arr04"&&(Rt.innerHTML=hn),Js=n(re),d(se.$$.fragment,re),Is=n(re),d(ne.$$.fragment,re),re.forEach(o),V.forEach(o),Go=n(e),d(it.$$.fragment,e),xo=n(e),Ot=c(e,"P",{}),T(Ot).forEach(o),this.h()},h(){y(u,"name","hf:doc:metadata"),y(u,"content",xn),y(R,"class","flex flex-wrap space-x-1"),un(X.src,ks="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/got_ocr_overview.png")||y(X,"src",ks),y(X,"alt","drawing"),y(X,"width","600"),un(H.src,Vs="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/sheet_music.svg")||y(H,"src",Vs),y(H,"alt","drawing"),y(H,"width","600"),y(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(wt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){a(document.head,u),r(e,w,t),r(e,_,t),r(e,v,t),m(Z,e,t),r(e,b,t),r(e,R,t),r(e,Wt,t),m(ie,e,t),r(e,Nt,t),r(e,ce,t),r(e,Ft,t),r(e,le,t),r(e,Bt,t),r(e,de,t),r(e,Vt,t),r(e,X,t),r(e,qt,t),r(e,me,t),r(e,Pt,t),r(e,pe,t),r(e,Xt,t),r(e,he,t),r(e,Ht,t),r(e,ge,t),r(e,Et,t),m(ue,e,t),r(e,Qt,t),m(fe,e,t),r(e,St,t),m(_e,e,t),r(e,Yt,t),m(ye,e,t),r(e,Lt,t),m(Te,e,t),r(e,At,t),m(be,e,t),r(e,Dt,t),r(e,Me,t),r(e,Kt,t),m(we,e,t),r(e,eo,t),m(ve,e,t),r(e,to,t),r(e,je,t),r(e,oo,t),m(Je,e,t),r(e,so,t),m(Ie,e,t),r(e,no,t),r(e,Ue,t),r(e,ao,t),m(Ge,e,t),r(e,ro,t),m(xe,e,t),r(e,io,t),r(e,Ce,t),r(e,co,t),m(ke,e,t),r(e,lo,t),m(ze,e,t),r(e,mo,t),r(e,Ze,t),r(e,po,t),m(Re,e,t),r(e,ho,t),r(e,H,t),r(e,go,t),m($e,e,t),r(e,uo,t),r(e,U,t),m(Oe,U,null),a(U,Bo),a(U,lt),a(U,Vo),a(U,dt),a(U,qo),a(U,mt),a(U,Po),m(E,U,null),r(e,fo,t),m(We,e,t),r(e,_o,t),r(e,W,t),m(Ne,W,null),a(W,Xo),a(W,pt),a(W,Ho),a(W,ht),r(e,yo,t),m(Fe,e,t),r(e,To,t),r(e,j,t),m(Be,j,null),a(j,Eo),a(j,gt),a(j,Qo),a(j,Q),m(Ve,Q,null),a(Q,So),a(Q,ut),a(j,Yo),a(j,S),m(qe,S,null),a(S,Lo),a(S,ft),a(j,Ao),a(j,Y),m(Pe,Y,null),a(Y,Do),a(Y,_t),a(j,Ko),a(j,L),m(Xe,L,null),a(L,es),a(L,yt),r(e,bo,t),m(He,e,t),r(e,Mo,t),r(e,G,t),m(Ee,G,null),a(G,ts),a(G,Tt),a(G,os),a(G,A),m(Qe,A,null),a(A,ss),a(A,bt),a(G,ns),a(G,D),m(Se,D,null),a(D,as),a(D,Mt),a(G,rs),a(G,wt),m(Ye,wt,null),r(e,wo,t),m(Le,e,t),r(e,vo,t),r(e,k,t),m(Ae,k,null),a(k,is),a(k,vt),a(k,cs),a(k,K),m(De,K,null),a(K,ls),a(K,jt),a(k,ds),a(k,ee),m(Ke,ee,null),a(ee,ms),a(ee,Jt),r(e,jo,t),m(et,e,t),r(e,Jo,t),r(e,J,t),m(tt,J,null),a(J,ps),a(J,It),a(J,hs),a(J,Ut),a(J,gs),a(J,Gt),a(J,us),a(J,F),m(ot,F,null),a(F,fs),a(F,xt),a(F,_s),m(te,F,null),a(J,ys),a(J,oe),m(st,oe,null),a(oe,Ts),a(oe,Ct),r(e,Io,t),m(nt,e,t),r(e,Uo,t),r(e,x,t),m(at,x,null),a(x,bs),a(x,kt),a(x,Ms),a(x,zt),a(x,ws),a(x,Zt),a(x,vs),a(x,$),m(rt,$,null),a($,js),a($,Rt),a($,Js),m(se,$,null),a($,Is),m(ne,$,null),r(e,Go,t),m(it,e,t),r(e,xo,t),r(e,Ot,t),Co=!0},p(e,[t]){const z={};t&2&&(z.$$scope={dirty:t,ctx:e}),E.$set(z);const q={};t&2&&(q.$$scope={dirty:t,ctx:e}),te.$set(q);const C={};t&2&&(C.$$scope={dirty:t,ctx:e}),se.$set(C);const ct={};t&2&&(ct.$$scope={dirty:t,ctx:e}),ne.$set(ct)},i(e){Co||(p(Z.$$.fragment,e),p(ie.$$.fragment,e),p(ue.$$.fragment,e),p(fe.$$.fragment,e),p(_e.$$.fragment,e),p(ye.$$.fragment,e),p(Te.$$.fragment,e),p(be.$$.fragment,e),p(we.$$.fragment,e),p(ve.$$.fragment,e),p(Je.$$.fragment,e),p(Ie.$$.fragment,e),p(Ge.$$.fragment,e),p(xe.$$.fragment,e),p(ke.$$.fragment,e),p(ze.$$.fragment,e),p(Re.$$.fragment,e),p($e.$$.fragment,e),p(Oe.$$.fragment,e),p(E.$$.fragment,e),p(We.$$.fragment,e),p(Ne.$$.fragment,e),p(Fe.$$.fragment,e),p(Be.$$.fragment,e),p(Ve.$$.fragment,e),p(qe.$$.fragment,e),p(Pe.$$.fragment,e),p(Xe.$$.fragment,e),p(He.$$.fragment,e),p(Ee.$$.fragment,e),p(Qe.$$.fragment,e),p(Se.$$.fragment,e),p(Ye.$$.fragment,e),p(Le.$$.fragment,e),p(Ae.$$.fragment,e),p(De.$$.fragment,e),p(Ke.$$.fragment,e),p(et.$$.fragment,e),p(tt.$$.fragment,e),p(ot.$$.fragment,e),p(te.$$.fragment,e),p(st.$$.fragment,e),p(nt.$$.fragment,e),p(at.$$.fragment,e),p(rt.$$.fragment,e),p(se.$$.fragment,e),p(ne.$$.fragment,e),p(it.$$.fragment,e),Co=!0)},o(e){h(Z.$$.fragment,e),h(ie.$$.fragment,e),h(ue.$$.fragment,e),h(fe.$$.fragment,e),h(_e.$$.fragment,e),h(ye.$$.fragment,e),h(Te.$$.fragment,e),h(be.$$.fragment,e),h(we.$$.fragment,e),h(ve.$$.fragment,e),h(Je.$$.fragment,e),h(Ie.$$.fragment,e),h(Ge.$$.fragment,e),h(xe.$$.fragment,e),h(ke.$$.fragment,e),h(ze.$$.fragment,e),h(Re.$$.fragment,e),h($e.$$.fragment,e),h(Oe.$$.fragment,e),h(E.$$.fragment,e),h(We.$$.fragment,e),h(Ne.$$.fragment,e),h(Fe.$$.fragment,e),h(Be.$$.fragment,e),h(Ve.$$.fragment,e),h(qe.$$.fragment,e),h(Pe.$$.fragment,e),h(Xe.$$.fragment,e),h(He.$$.fragment,e),h(Ee.$$.fragment,e),h(Qe.$$.fragment,e),h(Se.$$.fragment,e),h(Ye.$$.fragment,e),h(Le.$$.fragment,e),h(Ae.$$.fragment,e),h(De.$$.fragment,e),h(Ke.$$.fragment,e),h(et.$$.fragment,e),h(tt.$$.fragment,e),h(ot.$$.fragment,e),h(te.$$.fragment,e),h(st.$$.fragment,e),h(nt.$$.fragment,e),h(at.$$.fragment,e),h(rt.$$.fragment,e),h(se.$$.fragment,e),h(ne.$$.fragment,e),h(it.$$.fragment,e),Co=!1},d(e){e&&(o(w),o(_),o(v),o(b),o(R),o(Wt),o(Nt),o(ce),o(Ft),o(le),o(Bt),o(de),o(Vt),o(X),o(qt),o(me),o(Pt),o(pe),o(Xt),o(he),o(Ht),o(ge),o(Et),o(Qt),o(St),o(Yt),o(Lt),o(At),o(Dt),o(Me),o(Kt),o(eo),o(to),o(je),o(oo),o(so),o(no),o(Ue),o(ao),o(ro),o(io),o(Ce),o(co),o(lo),o(mo),o(Ze),o(po),o(ho),o(H),o(go),o(uo),o(U),o(fo),o(_o),o(W),o(yo),o(To),o(j),o(bo),o(Mo),o(G),o(wo),o(vo),o(k),o(jo),o(Jo),o(J),o(Io),o(Uo),o(x),o(Go),o(xo),o(Ot)),o(u),g(Z,e),g(ie,e),g(ue,e),g(fe,e),g(_e,e),g(ye,e),g(Te,e),g(be,e),g(we,e),g(ve,e),g(Je,e),g(Ie,e),g(Ge,e),g(xe,e),g(ke,e),g(ze,e),g(Re,e),g($e,e),g(Oe),g(E),g(We,e),g(Ne),g(Fe,e),g(Be),g(Ve),g(qe),g(Pe),g(Xe),g(He,e),g(Ee),g(Qe),g(Se),g(Ye),g(Le,e),g(Ae),g(De),g(Ke),g(et,e),g(tt),g(ot),g(te),g(st),g(nt,e),g(at),g(rt),g(se),g(ne),g(it,e)}}}const xn='{"title":"GOT-OCR2","local":"got-ocr2","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage example","local":"usage-example","sections":[{"title":"Plain text inference","local":"plain-text-inference","sections":[],"depth":3},{"title":"Plain text inference batched","local":"plain-text-inference-batched","sections":[],"depth":3},{"title":"Formatted text inference","local":"formatted-text-inference","sections":[],"depth":3},{"title":"Inference on multiple pages","local":"inference-on-multiple-pages","sections":[],"depth":3},{"title":"Inference on cropped patches","local":"inference-on-cropped-patches","sections":[],"depth":3},{"title":"Inference on a specific region","local":"inference-on-a-specific-region","sections":[],"depth":3},{"title":"Inference on general OCR data example: sheet music","local":"inference-on-general-ocr-data-example-sheet-music","sections":[],"depth":3}],"depth":2},{"title":"GotOcr2Config","local":"transformers.GotOcr2Config","sections":[],"depth":2},{"title":"GotOcr2VisionConfig","local":"transformers.GotOcr2VisionConfig","sections":[],"depth":2},{"title":"GotOcr2ImageProcessor","local":"transformers.GotOcr2ImageProcessor","sections":[],"depth":2},{"title":"GotOcr2ImageProcessorFast","local":"transformers.GotOcr2ImageProcessorFast","sections":[],"depth":2},{"title":"GotOcr2Processor","local":"transformers.GotOcr2Processor","sections":[],"depth":2},{"title":"GotOcr2Model","local":"transformers.GotOcr2Model","sections":[],"depth":2},{"title":"GotOcr2ForConditionalGeneration","local":"transformers.GotOcr2ForConditionalGeneration","sections":[],"depth":2}],"depth":1}';function Cn(N){return Tn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Fn extends bn{constructor(u){super(),Mn(this,u,Cn,Gn,yn,{})}}export{Fn as component};
