import{s as ts,z as os,o as ss,n as Yt}from"../chunks/scheduler.18a86fab.js";import{S as ns,i as as,g as i,s as n,r as p,A as is,h as r,f as o,c as a,j as W,u as h,x as m,k as v,y as c,a as s,v as g,d as f,t as u,w as _}from"../chunks/index.98837b22.js";import{T as rs}from"../chunks/Tip.77304350.js";import{D as G}from"../chunks/Docstring.6758ea23.js";import{C as L}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as yo}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as F}from"../chunks/Heading.7e7e0c5b.js";import{E as ls}from"../chunks/getInferenceSnippets.de10bc7d.js";function cs(R){let d,w="Example:",T,y,M;return y=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMElkZWZpY3MyTW9kZWwlMkMlMjBJZGVmaWNzMkNvbmZpZyUwQSUyMyUyMEluaXRpYWxpemluZyUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwSWRlZmljczJDb25maWcoKSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBJZGVmaWNzMk1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Idefics2Model, Idefics2Config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = Idefics2Config()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Idefics2Model(configuration)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){d=i("p"),d.textContent=w,T=n(),p(y.$$.fragment)},l(l){d=r(l,"P",{"data-svelte-h":!0}),m(d)!=="svelte-11lpom8"&&(d.textContent=w),T=a(l),h(y.$$.fragment,l)},m(l,b){s(l,d,b),s(l,T,b),g(y,l,b),M=!0},p:Yt,i(l){M||(f(y.$$.fragment,l),M=!0)},o(l){u(y.$$.fragment,l),M=!1},d(l){l&&(o(d),o(T)),_(y,l)}}}function ds(R){let d,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){d=i("p"),d.innerHTML=w},l(T){d=r(T,"P",{"data-svelte-h":!0}),m(d)!=="svelte-fincs2"&&(d.innerHTML=w)},m(T,y){s(T,d,y)},p:Yt,d(T){T&&o(d)}}}function ms(R){let d,w="Example:",T,y,M;return y=new L({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModelForVision2Seq
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers.image_utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Note that passing the image urls (instead of the actual pil images) to the processor is also possible</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image1 = load_image(<span class="hljs-string">&quot;https://cdn.britannica.com/61/93061-050-99147DCE/Statue-of-Liberty-Island-New-York-Bay.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image2 = load_image(<span class="hljs-string">&quot;https://cdn.britannica.com/59/94459-050-DBA42467/Skyline-Chicago.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image3 = load_image(<span class="hljs-string">&quot;https://cdn.britannica.com/68/170868-050-8DDE8263/Golden-Gate-Bridge-San-Francisco.jpg&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;HuggingFaceM4/idefics2-8b-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForVision2Seq.from_pretrained(<span class="hljs-string">&quot;HuggingFaceM4/idefics2-8b-base&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>BAD_WORDS_IDS = processor.tokenizer([<span class="hljs-string">&quot;&lt;image&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;fake_token_around_image&gt;&quot;</span>], add_special_tokens=<span class="hljs-literal">False</span>).input_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>EOS_WORDS_IDS = [processor.tokenizer.eos_token_id]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Create inputs</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prompts = [
<span class="hljs-meta">... </span>  <span class="hljs-string">&quot;&lt;image&gt;In this image, we can see the city of New York, and more specifically the Statue of Liberty.&lt;image&gt;In this image,&quot;</span>,
<span class="hljs-meta">... </span>  <span class="hljs-string">&quot;In which city is that bridge located?&lt;image&gt;&quot;</span>,
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>images = [[image1, image2], [image3]]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=images, text=prompts, padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**inputs, bad_words_ids=BAD_WORDS_IDS, max_new_tokens=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_texts = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(generated_texts)
[<span class="hljs-string">&#x27;In this image, we can see the city of New York, and more specifically the Statue of Liberty. In this image, we can see the city of New York, and more specifically the Statue of Liberty.\\n\\n&#x27;</span>, <span class="hljs-string">&#x27;In which city is that bridge located?\\n\\nThe bridge is located in the city of Pittsburgh, Pennsylvania.\\n\\n\\nThe bridge is&#x27;</span>]`,wrap:!1}}),{c(){d=i("p"),d.textContent=w,T=n(),p(y.$$.fragment)},l(l){d=r(l,"P",{"data-svelte-h":!0}),m(d)!=="svelte-11lpom8"&&(d.textContent=w),T=a(l),h(y.$$.fragment,l)},m(l,b){s(l,d,b),s(l,T,b),g(y,l,b),M=!0},p:Yt,i(l){M||(f(y.$$.fragment,l),M=!0)},o(l){u(y.$$.fragment,l),M=!1},d(l){l&&(o(d),o(T)),_(y,l)}}}function ps(R){let d,w="Example:",T,y,M;return y=new L({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwSWRlZmljczJQcm9jZXNzb3IlMEFmcm9tJTIwdHJhbnNmb3JtZXJzLmltYWdlX3V0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMElkZWZpY3MyUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJIdWdnaW5nRmFjZU00JTJGaWRlZmljczItOGIlMjIlMkMlMjBpbWFnZV9zZXFfbGVuJTNEMiklMEFwcm9jZXNzb3IuaW1hZ2VfcHJvY2Vzc29yLmRvX2ltYWdlX3NwbGl0dGluZyUyMCUzRCUyMEZhbHNlJTIwJTIwJTIzJTIwRm9yY2UlMjBhcyUyMEZhbHNlJTIwdG8lMjBzaW1wbGlmeSUyMHRoZSUyMGV4YW1wbGUlMEElMEF1cmwxJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZjZG4uYnJpdGFubmljYS5jb20lMkY2MSUyRjkzMDYxLTA1MC05OTE0N0RDRSUyRlN0YXR1ZS1vZi1MaWJlcnR5LUlzbGFuZC1OZXctWW9yay1CYXkuanBnJTIyJTBBdXJsMiUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGY2RuLmJyaXRhbm5pY2EuY29tJTJGNTklMkY5NDQ1OS0wNTAtREJBNDI0NjclMkZTa3lsaW5lLUNoaWNhZ28uanBnJTIyJTBBJTBBaW1hZ2UxJTJDJTIwaW1hZ2UyJTIwJTNEJTIwbG9hZF9pbWFnZSh1cmwxKSUyQyUyMGxvYWRfaW1hZ2UodXJsMiklMEFpbWFnZXMlMjAlM0QlMjAlNUIlNUJpbWFnZTElNUQlMkMlMjAlNUJpbWFnZTIlNUQlNUQlMEElMEF0ZXh0JTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyJTNDaW1hZ2UlM0VJbiUyMHRoaXMlMjBpbWFnZSUyQyUyMHdlJTIwc2VlJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyYmxhJTIwYmxhJTIwYmxhJTNDaW1hZ2UlM0UlMjIlMkMlMEElNUQlMEFvdXRwdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlcyUyQyUyMHRleHQlM0R0ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUyMHBhZGRpbmclM0RUcnVlKSUwQWlucHV0X2lkcyUyMCUzRCUyMG91dHB1dHMuaW5wdXRfaWRzJTBBaW5wdXRfdG9rZW5zJTIwJTNEJTIwcHJvY2Vzc29yLnRva2VuaXplci5iYXRjaF9kZWNvZGUoaW5wdXRfaWRzKSUwQXByaW50KGlucHV0X3Rva2Vucyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Idefics2Processor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers.image_utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = Idefics2Processor.from_pretrained(<span class="hljs-string">&quot;HuggingFaceM4/idefics2-8b&quot;</span>, image_seq_len=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor.image_processor.do_image_splitting = <span class="hljs-literal">False</span>  <span class="hljs-comment"># Force as False to simplify the example</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>url1 = <span class="hljs-string">&quot;https://cdn.britannica.com/61/93061-050-99147DCE/Statue-of-Liberty-Island-New-York-Bay.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url2 = <span class="hljs-string">&quot;https://cdn.britannica.com/59/94459-050-DBA42467/Skyline-Chicago.jpg&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>image1, image2 = load_image(url1), load_image(url2)
<span class="hljs-meta">&gt;&gt;&gt; </span>images = [[image1], [image2]]

<span class="hljs-meta">&gt;&gt;&gt; </span>text = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;&lt;image&gt;In this image, we see&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;bla bla bla&lt;image&gt;&quot;</span>,
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = processor(images=images, text=text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = outputs.input_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>input_tokens = processor.tokenizer.batch_decode(input_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(input_tokens)
[<span class="hljs-string">&#x27;&lt;s&gt;&lt;fake_token_around_image&gt;&lt;image&gt;&lt;image&gt;&lt;fake_token_around_image&gt; In this image, we see&#x27;</span>, <span class="hljs-string">&#x27;&lt;s&gt; bla bla bla&lt;fake_token_around_image&gt;&lt;image&gt;&lt;image&gt;&lt;fake_token_around_image&gt;&#x27;</span>]`,wrap:!1}}),{c(){d=i("p"),d.textContent=w,T=n(),p(y.$$.fragment)},l(l){d=r(l,"P",{"data-svelte-h":!0}),m(d)!=="svelte-11lpom8"&&(d.textContent=w),T=a(l),h(y.$$.fragment,l)},m(l,b){s(l,d,b),s(l,T,b),g(y,l,b),M=!0},p:Yt,i(l){M||(f(y.$$.fragment,l),M=!0)},o(l){u(y.$$.fragment,l),M=!1},d(l){l&&(o(d),o(T)),_(y,l)}}}function hs(R){let d,w,T,y,M,l,b,To='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/> <img alt="FlashAttention" src="https://img.shields.io/badge/%E2%9A%A1%EF%B8%8E%20FlashAttention-eae0c8?style=flat"/> <img alt="SDPA" src="https://img.shields.io/badge/SDPA-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',st,Q,nt,A,Mo='The Idefics2 model was proposed in <a href="https://arxiv.org/abs/2405.02246" rel="nofollow">What matters when building vision-language models?</a> by Léo Tronchon, Hugo Laurencon, Victor Sanh. The accompanying blog post can be found <a href="https://huggingface.co/blog/idefics2" rel="nofollow">here</a>.',at,D,bo=`Idefics2 is an open multimodal model that accepts arbitrary sequences of image and text inputs and produces text
outputs. The model can answer questions about images, describe visual content, create stories grounded on multiple
images, or simply behave as a pure language model without visual inputs. It improves upon IDEFICS-1, notably on
document understanding, OCR, or visual reasoning. Idefics2 is lightweight (8 billion parameters) and treats
images in their native aspect ratio and resolution, which allows for varying inference efficiency.`,it,O,wo="The abstract from the paper is the following:",rt,K,Io="<em>The growing interest in vision-language models (VLMs) has been driven by improvements in large language models and vision transformers. Despite the abundance of literature on this subject, we observe that critical decisions regarding the design of VLMs are often not justified. We argue that these unsupported decisions impede progress in the field by making it difficult to identify which choices improve model performance. To address this issue, we conduct extensive experiments around pre-trained models, architecture choice, data, and training methods. Our consolidation of findings includes the development of Idefics2, an efficient foundational VLM of 8 billion parameters. Idefics2 achieves state-of-the-art performance within its size category across various multimodal benchmarks, and is often on par with models four times its size. We release the model (base, instructed, and chat) along with the datasets created for its training.</em>",lt,q,Jo,ct,ee,vo='Idefics2 architecture. Taken from the <a href="https://arxiv.org/abs/2405.02246">original paper.</a>',dt,te,jo=`This model was contributed by <a href="https://huggingface.co/amyeroberts" rel="nofollow">amyeroberts</a>.
The original code can be found <a href="https://huggingface.co/HuggingFaceM4/idefics2" rel="nofollow">here</a>.`,mt,oe,pt,se,Uo="<li>Each sample can contain multiple images, and the number of images can vary between samples. The processor will pad the inputs to the maximum number of images in a batch for input to the model.</li> <li>The processor has a <code>do_image_splitting</code> option. If <code>True</code>, each input image will be split into 4 sub-images, and concatenated with the original to form 5 images. This is useful for increasing model performance. Make sure <code>processor.image_processor.do_image_splitting</code> is set to <code>False</code> if the model was not trained with this option.</li> <li><code>text</code> passed to the processor should have the <code>&lt;image&gt;</code> tokens where the images should be inserted. And <code>&lt;end_of_utterance&gt;</code> at the end of each utterance if the text is a chat message.</li> <li>The processor has its own <code>apply_chat_template</code> method to convert chat messages to text that can then be passed as <code>text</code> to the processor.</li>",ht,ne,ko="Example of how to use the processor on chat messages:",gt,ae,ft,ie,Co="<li>During training, it’s important to determine which tokens the model should not learn. For Idefics2, this typically comes down to the image and padding tokens. This means that one can create the labels as follows:</li>",ut,re,_t,le,zo="Do note that when training Idefics2 on multi-turn conversations between a user and an assistant, one typically also sets all the tokens corresponding to the user messages to -100.",yt,ce,Tt,de,Zo='The code snippets above showcase inference without any optimization tricks. However, one can drastically speed up the model by leveraging <a href="../perf_train_gpu_one#flash-attention-2">Flash Attention</a>, which is a faster implementation of the attention mechanism used inside the model.',Mt,me,xo="First, make sure to install the latest version of Flash Attention 2 to include the sliding window attention feature.",bt,pe,wt,he,Wo='Make also sure that you have a hardware that is compatible with Flash-Attention 2. Read more about it in the official documentation of the <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">flash attention repository</a>. Make also sure to load your model in half-precision (e.g. <code>torch.float16</code>)',It,ge,Fo="To load and run a model using Flash Attention-2, simply change the code snippet above with the following change:",Jt,fe,vt,ue,jt,_e,Ro='As the Idefics2 model has 8 billion parameters, that would require about 16GB of GPU RAM in half precision (float16), since each parameter is stored in 2 bytes. However, one can shrink down the size of the model using <a href="../quantization.md">quantization</a>. If the model is quantized to 4 bits (or half a byte per parameter), that requires only about 3.5GB of RAM.',Ut,ye,No='Quantizing a model is as simple as passing a <code>quantization_config</code> to the model. One can change the code snippet above with the changes below. We’ll leverage the BitsAndyBytes quantization (but refer to <a href="../quantization.md">this page</a> for other quantization methods):',kt,Te,Ct,Me,zt,be,$o="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with Idefics2. If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.",Zt,we,Bo='<li>A notebook on how to fine-tune Idefics2 on a custom dataset using the <a href="../main_classes/trainer.md">Trainer</a> can be found <a href="https://colab.research.google.com/drive/1NtcTgRbSBKN7pYD3Vdx1j9m8pt3fhFDB?usp=sharing" rel="nofollow">here</a>. It supports both full fine-tuning as well as (quantized) LoRa.</li> <li>A script regarding how to fine-tune Idefics2 using the TRL library can be found <a href="https://gist.github.com/edbeeching/228652fc6c2b29a1641be5a5778223cb" rel="nofollow">here</a>.</li> <li>Demo notebook regarding fine-tuning Idefics2 for JSON extraction use cases can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/Idefics2" rel="nofollow">here</a>. 🌎</li>',xt,Ie,Wt,j,Je,Pt,Be,Go=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/idefics2#transformers.Idefics2Model">Idefics2Model</a>. It is used to instantiate a
Idefics2 model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the model of the Idefics2
<a href="https://huggingface.co/HuggingFaceM4/idefics2-8b" rel="nofollow">HuggingFaceM4/idefics2-8b</a> architecture.`,Lt,Ge,qo=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Qt,E,Ft,ve,Rt,I,je,At,qe,Eo="Idefics2 model consisting of a SIGLIP vision encoder and Mistral language decoder",Dt,Ee,Vo=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Ot,Ve,Xo=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Kt,N,Ue,eo,Xe,Ho=`Inputs fed to the model can have an arbitrary number of images. To account for this, pixel_values fed to
the model have image padding -> (batch_size, max_num_images, 3, max_heights, max_widths) where
max_num_images is the maximum number of images among the batch_size samples in the batch.`,to,He,So=`Padding images are not needed beyond padding the pixel_values at the entrance of the model.
For efficiency, we only pass through the vision_model’s forward the real images by
discarding the padding images i.e. pixel_values of size (image_batch_size, 3, height, width) where
image_batch_size would be 7 when num_images_per_sample=[1, 3, 1, 2] and max_num_images would be 3.`,Nt,ke,$t,J,Ce,oo,Se,Yo="The Idefics2 Model with a language modeling head. It is made up a SigLIP vision encoder, with a language modeling head on top.",so,Ye,Po=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,no,Pe,Lo=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,ao,z,ze,io,Le,Qo='The <a href="/docs/transformers/main/en/model_doc/idefics2#transformers.Idefics2ForConditionalGeneration">Idefics2ForConditionalGeneration</a> forward method, overrides the <code>__call__</code> special method.',ro,V,lo,X,Bt,Ze,Gt,Z,xe,co,Qe,Ao="Constructs a Idefics image processor.",mo,H,We,po,Ae,Do="Preprocess a batch of images.",qt,Fe,Et,U,Re,ho,De,Oo="Constructs a IDEFICS2 processor which wraps a LLama tokenizer and IDEFICS2 image processor into a single processor.",go,Oe,Ko=`<a href="/docs/transformers/main/en/model_doc/idefics#transformers.IdeficsProcessor">IdeficsProcessor</a> offers all the functionalities of <a href="/docs/transformers/main/en/model_doc/idefics2#transformers.Idefics2ImageProcessor">Idefics2ImageProcessor</a> and <a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>. See
the docstring of <a href="/docs/transformers/main/en/model_doc/idefics#transformers.IdeficsProcessor.__call__"><strong>call</strong>()</a> and <code>decode()</code> for more information.`,fo,$,Ne,uo,Ke,es="Processes the input prompts and returns a BatchEncoding.",_o,S,Vt,$e,Xt,ot,Ht;return M=new F({props:{title:"Idefics2",local:"idefics2",headingTag:"h1"}}),Q=new F({props:{title:"Overview",local:"overview",headingTag:"h2"}}),oe=new F({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),ae=new L({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Idefics2Processor, Idefics2ForConditionalGeneration
<span class="hljs-keyword">import</span> torch

device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>

url_1 = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
url_2 = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000219578.jpg&quot;</span>

image_1 = Image.<span class="hljs-built_in">open</span>(requests.get(url_1, stream=<span class="hljs-literal">True</span>).raw)
image_2 = Image.<span class="hljs-built_in">open</span>(requests.get(url_2, stream=<span class="hljs-literal">True</span>).raw)
images = [image_1, image_2]

messages = [{
    <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
    <span class="hljs-string">&quot;content&quot;</span>: [
        {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What’s the difference between these two images?&quot;</span>},
        {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
        {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
    ],
}]

processor = Idefics2Processor.from_pretrained(<span class="hljs-string">&quot;HuggingFaceM4/idefics2-8b&quot;</span>)
model = Idefics2ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;HuggingFaceM4/idefics2-8b&quot;</span>)
model.to(device)

<span class="hljs-comment"># at inference time, one needs to pass \`add_generation_prompt=True\` in order to make sure the model completes the prompt</span>
text = processor.apply_chat_template(messages, add_generation_prompt=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(text)
<span class="hljs-comment"># &#x27;User: What’s the difference between these two images?&lt;image&gt;&lt;image&gt;&lt;end_of_utterance&gt;\\nAssistant:&#x27;</span>

inputs = processor(images=images, text=text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

generated_text = model.generate(**inputs, max_new_tokens=<span class="hljs-number">500</span>)
generated_text = processor.batch_decode(generated_text, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Generated text:&quot;</span>, generated_text)`,wrap:!1}}),re=new L({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Idefics2Processor, Idefics2ForConditionalGeneration
<span class="hljs-keyword">import</span> torch

url_1 = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
url_2 = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000219578.jpg&quot;</span>

image_1 = Image.<span class="hljs-built_in">open</span>(requests.get(url_1, stream=<span class="hljs-literal">True</span>).raw)
image_2 = Image.<span class="hljs-built_in">open</span>(requests.get(url_2, stream=<span class="hljs-literal">True</span>).raw)
images = [image_1, image_2]

messages = [{
    <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
    <span class="hljs-string">&quot;content&quot;</span>: [
        {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What’s the difference between these two images?&quot;</span>},
        {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
        {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
    ],
},
{
    <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>,
    <span class="hljs-string">&quot;content&quot;</span>: [
        {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;The difference is that one image is about dogs and the other one about cats.&quot;</span>},
    ],
}]

device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>

processor = Idefics2Processor.from_pretrained(<span class="hljs-string">&quot;HuggingFaceM4/idefics2-8b&quot;</span>)
model = Idefics2ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;HuggingFaceM4/idefics2-8b&quot;</span>)
model.to(device)

text = processor.apply_chat_template(messages, add_generation_prompt=<span class="hljs-literal">False</span>)
inputs = processor(images=images, text=text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

labels = inputs.input_ids.clone()
labels[labels == processor.tokenizer.pad_token_id] = -<span class="hljs-number">100</span>
labels[labels == model.config.image_token_id] = -<span class="hljs-number">100</span>

inputs[<span class="hljs-string">&quot;labels&quot;</span>] = labels

outputs = model(**inputs)
loss = outputs.loss
loss.backward()`,wrap:!1}}),ce=new F({props:{title:"Model optimizations: Flash Attention",local:"model-optimizations-flash-attention",headingTag:"h2"}}),pe=new L({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwZmxhc2gtYXR0biUyMC0tbm8tYnVpbGQtaXNvbGF0aW9u",highlighted:"pip install -U flash-attn --no-build-isolation",wrap:!1}}),fe=new L({props:{code:"bW9kZWwlMjAlM0QlMjBJZGVmaWNzMkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIySHVnZ2luZ0ZhY2VNNCUyRmlkZWZpY3MyLThiJTIyJTJDJTBBJTJCJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwJTIwJTIwJTIwJTBBJTJCJTIwJTIwJTIwJTIwYXR0bl9pbXBsZW1lbnRhdGlvbiUzRCUyMmZsYXNoX2F0dGVudGlvbl8yJTIyJTJDJTBBKS50byhkZXZpY2Up",highlighted:`model = Idefics2ForConditionalGeneration.from_pretrained(
    &quot;HuggingFaceM4/idefics2-8b&quot;,
<span class="hljs-addition">+    torch_dtype=torch.float16,    </span>
<span class="hljs-addition">+    attn_implementation=&quot;flash_attention_2&quot;,</span>
).to(device)`,wrap:!1}}),ue=new F({props:{title:"Shrinking down Idefics2 using quantization",local:"shrinking-down-idefics2-using-quantization",headingTag:"h2"}}),Te=new L({props:{code:"JTJCJTIwZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQSUwQSUyQiUyMHF1YW50aXphdGlvbl9jb25maWclMjAlM0QlMjBCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTJCJTIwJTIwJTIwJTIwbG9hZF9pbl80Yml0JTNEVHJ1ZSUyQyUwQSUyQiUyMCUyMCUyMCUyMGJuYl80Yml0X3F1YW50X3R5cGUlM0QlMjJuZjQlMjIlMkMlMEElMkIlMjAlMjAlMjAlMjBibmJfNGJpdF91c2VfZG91YmxlX3F1YW50JTNEVHJ1ZSUyQyUwQSUyQiUyMCUyMCUyMCUyMGJuYl80Yml0X2NvbXB1dGVfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBJTJCJTIwKSUwQW1vZGVsJTIwJTNEJTIwSWRlZmljczJGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMkh1Z2dpbmdGYWNlTTQlMkZpZGVmaWNzMi04YiUyMiUyQyUwQSUyQiUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMCUyMCUyMCUyMCUwQSUyQiUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudGl6YXRpb25fY29uZmlnJTJDJTBBKS50byhkZXZpY2Up",highlighted:`<span class="hljs-addition">+ from transformers import BitsAndBytesConfig</span>

<span class="hljs-addition">+ quantization_config = BitsAndBytesConfig(</span>
<span class="hljs-addition">+    load_in_4bit=True,</span>
<span class="hljs-addition">+    bnb_4bit_quant_type=&quot;nf4&quot;,</span>
<span class="hljs-addition">+    bnb_4bit_use_double_quant=True,</span>
<span class="hljs-addition">+    bnb_4bit_compute_dtype=torch.float16</span>
<span class="hljs-addition">+ )</span>
model = Idefics2ForConditionalGeneration.from_pretrained(
    &quot;HuggingFaceM4/idefics2-8b&quot;,
<span class="hljs-addition">+    torch_dtype=torch.float16,    </span>
<span class="hljs-addition">+    quantization_config=quantization_config,</span>
).to(device)`,wrap:!1}}),Me=new F({props:{title:"Resources",local:"resources",headingTag:"h2"}}),Ie=new F({props:{title:"Idefics2Config",local:"transformers.Idefics2Config",headingTag:"h2"}}),Je=new G({props:{name:"class transformers.Idefics2Config",anchor:"transformers.Idefics2Config",parameters:[{name:"use_cache",val:" = True"},{name:"image_token_id",val:" = 32001"},{name:"tie_word_embeddings",val:" = False"},{name:"vision_config",val:" = None"},{name:"perceiver_config",val:" = None"},{name:"text_config",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Idefics2Config.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should cache the key/value pairs of the attention mechanism.`,name:"use_cache"},{anchor:"transformers.Idefics2Config.image_token_id",description:`<strong>image_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 32001) &#x2014;
The id of the &#x201C;image&#x201D; token.`,name:"image_token_id"},{anchor:"transformers.Idefics2Config.tie_word_embeddings",description:`<strong>tie_word_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to tie the word embeddings with the token embeddings.`,name:"tie_word_embeddings"},{anchor:"transformers.Idefics2Config.vision_config",description:`<strong>vision_config</strong> (<code>IdeficsVisionConfig</code> or <code>dict</code>, <em>optional</em>) &#x2014;
Custom vision config or dict`,name:"vision_config"},{anchor:"transformers.Idefics2Config.perceiver_config",description:`<strong>perceiver_config</strong> (<code>IdeficsPerceiverConfig</code> or <code>dict</code>, <em>optional</em>) &#x2014;
Custom perceiver config or dict`,name:"perceiver_config"},{anchor:"transformers.Idefics2Config.text_config",description:`<strong>text_config</strong> (<code>MistralConfig</code> or <code>dict</code>, <em>optional</em>) &#x2014;
Custom text config or dict for the text model`,name:"text_config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/idefics2/configuration_idefics2.py#L171"}}),E=new yo({props:{anchor:"transformers.Idefics2Config.example",$$slots:{default:[cs]},$$scope:{ctx:R}}}),ve=new F({props:{title:"Idefics2Model",local:"transformers.Idefics2Model",headingTag:"h2"}}),je=new G({props:{name:"class transformers.Idefics2Model",anchor:"transformers.Idefics2Model",parameters:[{name:"config",val:": Idefics2Config"}],parametersDescription:[{anchor:"transformers.Idefics2Model.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/idefics2#transformers.Idefics2Config">Idefics2Config</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/idefics2/modeling_idefics2.py#L891"}}),Ue=new G({props:{name:"forward",anchor:"transformers.Idefics2Model.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pixel_attention_mask",val:": typing.Optional[torch.BoolTensor] = None"},{name:"image_hidden_states",val:": typing.Optional[torch.FloatTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.modeling_flash_attention_utils.FlashAttentionKwargs]"}],parametersDescription:[{anchor:"transformers.Idefics2Model.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.Idefics2Model.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.Idefics2Model.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.Idefics2Model.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>List[torch.FloatTensor]</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.Idefics2Model.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.Idefics2Model.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>, <em>optional</em>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.Idefics2Model.forward.pixel_attention_mask",description:`<strong>pixel_attention_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, image_size, image_size)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel indices.`,name:"pixel_attention_mask"},{anchor:"transformers.Idefics2Model.forward.image_hidden_states",description:`<strong>image_hidden_states</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>) &#x2014;
The hidden states of the image encoder after modality projection and perceiver resampling.`,name:"image_hidden_states"},{anchor:"transformers.Idefics2Model.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.Idefics2Model.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Idefics2Model.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Idefics2Model.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"},{anchor:"transformers.Idefics2Model.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/idefics2/modeling_idefics2.py#L1015",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.idefics2.modeling_idefics2.Idefics2BaseModelOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/idefics2#transformers.Idefics2Config"
>Idefics2Config</a>) and inputs.</p>
<ul>
<li><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.
If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.</li>
<li><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.
Contains pre-computed hidden-states (key and values in the self-attention blocks and optionally if
<code>config.is_encoder_decoder=True</code> in the cross-attention blocks) that can be used (see <code>past_key_values</code>
input) to speed up sequential decoding.</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.
Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.
Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</li>
<li><strong>image_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the image embeddings, <code>(batch_size, num_images, sequence_length, hidden_size)</code>.
image_hidden_states of the model produced by the vision encoder, and optionally by the perceiver</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.idefics2.modeling_idefics2.Idefics2BaseModelOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ke=new F({props:{title:"Idefics2ForConditionalGeneration",local:"transformers.Idefics2ForConditionalGeneration",headingTag:"h2"}}),Ce=new G({props:{name:"class transformers.Idefics2ForConditionalGeneration",anchor:"transformers.Idefics2ForConditionalGeneration",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.Idefics2ForConditionalGeneration.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/idefics2#transformers.Idefics2ForConditionalGeneration">Idefics2ForConditionalGeneration</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/idefics2/modeling_idefics2.py#L1140"}}),ze=new G({props:{name:"forward",anchor:"transformers.Idefics2ForConditionalGeneration.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pixel_attention_mask",val:": typing.Optional[torch.BoolTensor] = None"},{name:"image_hidden_states",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"logits_to_keep",val:": typing.Union[int, torch.Tensor] = 0"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.idefics2.modeling_idefics2.KwargsForCausalLM]"}],parametersDescription:[{anchor:"transformers.Idefics2ForConditionalGeneration.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.Idefics2ForConditionalGeneration.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.Idefics2ForConditionalGeneration.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.Idefics2ForConditionalGeneration.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>List[torch.FloatTensor]</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.Idefics2ForConditionalGeneration.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.Idefics2ForConditionalGeneration.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>, <em>optional</em>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.Idefics2ForConditionalGeneration.forward.pixel_attention_mask",description:`<strong>pixel_attention_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, image_size, image_size)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel indices.`,name:"pixel_attention_mask"},{anchor:"transformers.Idefics2ForConditionalGeneration.forward.image_hidden_states",description:`<strong>image_hidden_states</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>) &#x2014;
The hidden states of the image encoder after modality projection and perceiver resampling.`,name:"image_hidden_states"},{anchor:"transformers.Idefics2ForConditionalGeneration.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or <code>model.image_token_id</code> (where <code>model</code> is your instance of <code>Idefics2ForConditionalGeneration</code>).
Tokens with indices set to <code>model.image_token_id</code> are ignored (masked), the loss is only
computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"labels"},{anchor:"transformers.Idefics2ForConditionalGeneration.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.Idefics2ForConditionalGeneration.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Idefics2ForConditionalGeneration.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Idefics2ForConditionalGeneration.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.Idefics2ForConditionalGeneration.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"},{anchor:"transformers.Idefics2ForConditionalGeneration.forward.logits_to_keep",description:`<strong>logits_to_keep</strong> (<code>Union[int, torch.Tensor]</code>, defaults to <code>0</code>) &#x2014;
If an <code>int</code>, compute logits for the last <code>logits_to_keep</code> tokens. If <code>0</code>, calculate logits for all
<code>input_ids</code> (special case). Only last token logits are needed for generation, and calculating them only for that
token can save memory, which becomes pretty significant for long sequences or large vocabulary size.
If a <code>torch.Tensor</code>, must be 1D corresponding to the indices to keep in the sequence length dimension.
This is useful when using packed tensor format (single dimension for batch and sequence length).`,name:"logits_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/idefics2/modeling_idefics2.py#L1189",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.idefics2.modeling_idefics2.Idefics2CausalLMOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/idefics2#transformers.Idefics2Config"
>Idefics2Config</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</li>
<li><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)
Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.
Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.
Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</li>
<li><strong>image_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the image embeddings, <code>(batch_size, num_images, sequence_length, hidden_size)</code>.
image_hidden_states of the model produced by the vision encoder, and optionally by the perceiver</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.idefics2.modeling_idefics2.Idefics2CausalLMOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),V=new rs({props:{$$slots:{default:[ds]},$$scope:{ctx:R}}}),X=new yo({props:{anchor:"transformers.Idefics2ForConditionalGeneration.forward.example",$$slots:{default:[ms]},$$scope:{ctx:R}}}),Ze=new F({props:{title:"Idefics2ImageProcessor",local:"transformers.Idefics2ImageProcessor",headingTag:"h2"}}),xe=new G({props:{name:"class transformers.Idefics2ImageProcessor",anchor:"transformers.Idefics2ImageProcessor",parameters:[{name:"do_convert_rgb",val:": bool = True"},{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": float = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_pad",val:": bool = True"},{name:"do_image_splitting",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Idefics2ImageProcessor.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to convert the image to RGB. This is useful if the input image is of a different format e.g. RGBA.
Only has an effect if the input image is in the PIL format.`,name:"do_convert_rgb"},{anchor:"transformers.Idefics2ImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image. The longest edge of the image is resized to  be &lt;= <code>size[&quot;longest_edge&quot;]</code>, with the
shortest edge resized to keep the input aspect ratio, with a minimum size of <code>size[&quot;shortest_edge&quot;]</code>.`,name:"do_resize"},{anchor:"transformers.Idefics2ImageProcessor.size",description:`<strong>size</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Controls the size of the output image. This is a dictionary containing the keys &#x201C;shortest_edge&#x201D; and &#x201C;longest_edge&#x201D;.`,name:"size"},{anchor:"transformers.Idefics2ImageProcessor.resample",description:`<strong>resample</strong> (<code>Resampling</code>, <em>optional</em>, defaults to <code>Resampling.BILINEAR</code>) &#x2014;
Resampling filter to use when resizing the image.`,name:"resample"},{anchor:"transformers.Idefics2ImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image. If set to <code>True</code>, the image is rescaled to have pixel values between 0 and 1.`,name:"do_rescale"},{anchor:"transformers.Idefics2ImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.Idefics2ImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. If set to <code>True</code>, the image is normalized to have a mean of <code>image_mean</code> and
a standard deviation of <code>image_std</code>.`,name:"do_normalize"},{anchor:"transformers.Idefics2ImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IDEFICS_STANDARD_MEAN</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method. Can be
overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.Idefics2ImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IDEFICS_STANDARD_STD</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.
Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.Idefics2ImageProcessor.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to pad the images to the largest height and width in the batch and number of images per
sample in the batch, such that the returned tensor is of shape (batch_size, max_num_images, num_channels, max_height, max_width).`,name:"do_pad"},{anchor:"transformers.Idefics2ImageProcessor.do_image_splitting",description:`<strong>do_image_splitting</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to split the image into a sequence 4 equal sub-images concatenated with the original image. That
strategy was first introduced in <a href="https://arxiv.org/abs/2311.06607" rel="nofollow">https://arxiv.org/abs/2311.06607</a>.`,name:"do_image_splitting"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/idefics2/image_processing_idefics2.py#L150"}}),We=new G({props:{name:"preprocess",anchor:"transformers.Idefics2ImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']]"},{name:"do_convert_rgb",val:": typing.Optional[bool] = None"},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"resample",val:": Resampling = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Optional[float] = None"},{name:"do_normalize",val:": typing.Optional[bool] = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_pad",val:": typing.Optional[bool] = None"},{name:"do_image_splitting",val:": typing.Optional[bool] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"input_data_format",val:": typing.Optional[transformers.image_utils.ChannelDimension] = None"},{name:"data_format",val:": typing.Optional[transformers.image_utils.ChannelDimension] = <ChannelDimension.FIRST: 'channels_first'>"}],parametersDescription:[{anchor:"transformers.Idefics2ImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
A list of images to preprocess.`,name:"images"},{anchor:"transformers.Idefics2ImageProcessor.preprocess.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_convert_rgb</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.Idefics2ImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.Idefics2ImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the image after resizing. Shortest edge of the image is resized to size[&#x201C;shortest_edge&#x201D;], with
the longest edge resized to keep the input aspect ratio.`,name:"size"},{anchor:"transformers.Idefics2ImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>. Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.Idefics2ImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.Idefics2ImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.Idefics2ImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.Idefics2ImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean to use for normalization. Only has an effect if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.Idefics2ImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation to use for normalization. Only has an effect if <code>do_normalize</code> is set to
<code>True</code>.`,name:"image_std"},{anchor:"transformers.Idefics2ImageProcessor.preprocess.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_pad</code>) &#x2014;
Whether or not to pad the images to the largest height and width in the batch.`,name:"do_pad"},{anchor:"transformers.Idefics2ImageProcessor.preprocess.do_image_splitting",description:`<strong>do_image_splitting</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_image_splitting</code>) &#x2014;
Whether to split the image into a sequence 4 equal sub-images concatenated with the original image. That
strategy was first introduced in <a href="https://arxiv.org/abs/2311.06607" rel="nofollow">https://arxiv.org/abs/2311.06607</a>.`,name:"do_image_splitting"},{anchor:"transformers.Idefics2ImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.Idefics2ImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.Idefics2ImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/idefics2/image_processing_idefics2.py#L394"}}),Fe=new F({props:{title:"Idefics2Processor",local:"transformers.Idefics2Processor",headingTag:"h2"}}),Re=new G({props:{name:"class transformers.Idefics2Processor",anchor:"transformers.Idefics2Processor",parameters:[{name:"image_processor",val:""},{name:"tokenizer",val:" = None"},{name:"image_seq_len",val:": int = 64"},{name:"chat_template",val:": typing.Optional[str] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Idefics2Processor.image_processor",description:`<strong>image_processor</strong> (<code>Idefics2ImageProcessor</code>) &#x2014;
An instance of <a href="/docs/transformers/main/en/model_doc/idefics2#transformers.Idefics2ImageProcessor">Idefics2ImageProcessor</a>. The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.Idefics2Processor.tokenizer",description:`<strong>tokenizer</strong> (<code>PreTrainedTokenizerBase</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase">PreTrainedTokenizerBase</a>. This should correspond with the model&#x2019;s text model. The tokenizer is a required input.`,name:"tokenizer"},{anchor:"transformers.Idefics2Processor.image_seq_len",description:`<strong>image_seq_len</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
The length of the image sequence i.e. the number of <image> tokens per image in the input.
This parameter is used to build the string from the input prompt and image tokens and should match the
config.perceiver_config.resampler_n_latents value for the model used.</image>`,name:"image_seq_len"},{anchor:"transformers.Idefics2Processor.chat_template",description:`<strong>chat_template</strong> (<code>str</code>, <em>optional</em>) &#x2014; A Jinja template which will be used to convert lists of messages
in a chat into a tokenizable string.`,name:"chat_template"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/idefics2/processing_idefics2.py#L67"}}),Ne=new G({props:{name:"__call__",anchor:"transformers.Idefics2Processor.__call__",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor'], typing.List[typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']]], typing.List[typing.List[typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']]]]] = None"},{name:"text",val:": typing.Union[str, ForwardRef('PreTokenizedInput'), typing.List[str], typing.List[ForwardRef('PreTokenizedInput')]] = None"},{name:"audio",val:" = None"},{name:"videos",val:" = None"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.idefics2.processing_idefics2.Idefics2ProcessorKwargs]"}],parametersDescription:[{anchor:"transformers.Idefics2Processor.__call__.images",description:`<strong>images</strong> (<code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>torch.Tensor</code>, <code>List[PIL.Image.Image]</code>, <code>List[np.ndarray]</code>, <code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
The image or batch of images to be prepared. Each image can be a PIL image, NumPy array or PyTorch
tensor. If is of type <code>List[ImageInput]</code>, it&#x2019;s assumed that this is for a single prompt i.e. of batch size 1.`,name:"images"},{anchor:"transformers.Idefics2Processor.__call__.text",description:`<strong>text</strong> (<code>Union[TextInput, PreTokenizedInput, List[TextInput], List[PreTokenizedInput]]</code>, <em>optional</em>) &#x2014;
The sequence or batch of sequences to be encoded. Each sequence can be a string or a list of strings
(pretokenized string). If the sequences are provided as list of strings (pretokenized), you must set
<code>is_split_into_words=True</code> (to lift the ambiguity with a batch of sequences).</p>
<p>Wherever an image token, <code>&lt;image&gt;</code> is encountered it is expanded to
<code>&lt;fake_token_around_image&gt;</code> + <code>&lt;image&gt;</code> <em> <code>image_seq_len</code> </em> <fake_token_around_image>\`.</fake_token_around_image>`,name:"text"},{anchor:"transformers.Idefics2Processor.__call__.return_tensors",description:`<strong>return_tensors</strong> (<code>Union[str, TensorType]</code>, <em>optional</em>) &#x2014;
If set, will return tensors of a particular framework. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizerFast.<strong>call</strong>()</a> for more
information.`,name:"return_tensors"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/idefics2/processing_idefics2.py#L128"}}),S=new yo({props:{anchor:"transformers.Idefics2Processor.__call__.example",$$slots:{default:[ps]},$$scope:{ctx:R}}}),$e=new ls({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/idefics2.md"}}),{c(){d=i("meta"),w=n(),T=i("p"),y=n(),p(M.$$.fragment),l=n(),b=i("div"),b.innerHTML=To,st=n(),p(Q.$$.fragment),nt=n(),A=i("p"),A.innerHTML=Mo,at=n(),D=i("p"),D.textContent=bo,it=n(),O=i("p"),O.textContent=wo,rt=n(),K=i("p"),K.innerHTML=Io,lt=n(),q=i("img"),ct=n(),ee=i("small"),ee.innerHTML=vo,dt=n(),te=i("p"),te.innerHTML=jo,mt=n(),p(oe.$$.fragment),pt=n(),se=i("ul"),se.innerHTML=Uo,ht=n(),ne=i("p"),ne.textContent=ko,gt=n(),p(ae.$$.fragment),ft=n(),ie=i("ul"),ie.innerHTML=Co,ut=n(),p(re.$$.fragment),_t=n(),le=i("p"),le.textContent=zo,yt=n(),p(ce.$$.fragment),Tt=n(),de=i("p"),de.innerHTML=Zo,Mt=n(),me=i("p"),me.textContent=xo,bt=n(),p(pe.$$.fragment),wt=n(),he=i("p"),he.innerHTML=Wo,It=n(),ge=i("p"),ge.textContent=Fo,Jt=n(),p(fe.$$.fragment),vt=n(),p(ue.$$.fragment),jt=n(),_e=i("p"),_e.innerHTML=Ro,Ut=n(),ye=i("p"),ye.innerHTML=No,kt=n(),p(Te.$$.fragment),Ct=n(),p(Me.$$.fragment),zt=n(),be=i("p"),be.textContent=$o,Zt=n(),we=i("ul"),we.innerHTML=Bo,xt=n(),p(Ie.$$.fragment),Wt=n(),j=i("div"),p(Je.$$.fragment),Pt=n(),Be=i("p"),Be.innerHTML=Go,Lt=n(),Ge=i("p"),Ge.innerHTML=qo,Qt=n(),p(E.$$.fragment),Ft=n(),p(ve.$$.fragment),Rt=n(),I=i("div"),p(je.$$.fragment),At=n(),qe=i("p"),qe.textContent=Eo,Dt=n(),Ee=i("p"),Ee.innerHTML=Vo,Ot=n(),Ve=i("p"),Ve.innerHTML=Xo,Kt=n(),N=i("div"),p(Ue.$$.fragment),eo=n(),Xe=i("p"),Xe.textContent=Ho,to=n(),He=i("p"),He.textContent=So,Nt=n(),p(ke.$$.fragment),$t=n(),J=i("div"),p(Ce.$$.fragment),oo=n(),Se=i("p"),Se.textContent=Yo,so=n(),Ye=i("p"),Ye.innerHTML=Po,no=n(),Pe=i("p"),Pe.innerHTML=Lo,ao=n(),z=i("div"),p(ze.$$.fragment),io=n(),Le=i("p"),Le.innerHTML=Qo,ro=n(),p(V.$$.fragment),lo=n(),p(X.$$.fragment),Bt=n(),p(Ze.$$.fragment),Gt=n(),Z=i("div"),p(xe.$$.fragment),co=n(),Qe=i("p"),Qe.textContent=Ao,mo=n(),H=i("div"),p(We.$$.fragment),po=n(),Ae=i("p"),Ae.textContent=Do,qt=n(),p(Fe.$$.fragment),Et=n(),U=i("div"),p(Re.$$.fragment),ho=n(),De=i("p"),De.textContent=Oo,go=n(),Oe=i("p"),Oe.innerHTML=Ko,fo=n(),$=i("div"),p(Ne.$$.fragment),uo=n(),Ke=i("p"),Ke.textContent=es,_o=n(),p(S.$$.fragment),Vt=n(),p($e.$$.fragment),Xt=n(),ot=i("p"),this.h()},l(e){const t=is("svelte-u9bgzb",document.head);d=r(t,"META",{name:!0,content:!0}),t.forEach(o),w=a(e),T=r(e,"P",{}),W(T).forEach(o),y=a(e),h(M.$$.fragment,e),l=a(e),b=r(e,"DIV",{class:!0,"data-svelte-h":!0}),m(b)!=="svelte-b95w5j"&&(b.innerHTML=To),st=a(e),h(Q.$$.fragment,e),nt=a(e),A=r(e,"P",{"data-svelte-h":!0}),m(A)!=="svelte-2yybt7"&&(A.innerHTML=Mo),at=a(e),D=r(e,"P",{"data-svelte-h":!0}),m(D)!=="svelte-5h9xv8"&&(D.textContent=bo),it=a(e),O=r(e,"P",{"data-svelte-h":!0}),m(O)!=="svelte-vfdo9a"&&(O.textContent=wo),rt=a(e),K=r(e,"P",{"data-svelte-h":!0}),m(K)!=="svelte-1d8hoqd"&&(K.innerHTML=Io),lt=a(e),q=r(e,"IMG",{src:!0,alt:!0,width:!0}),ct=a(e),ee=r(e,"SMALL",{"data-svelte-h":!0}),m(ee)!=="svelte-1ry3ulw"&&(ee.innerHTML=vo),dt=a(e),te=r(e,"P",{"data-svelte-h":!0}),m(te)!=="svelte-yuhhqz"&&(te.innerHTML=jo),mt=a(e),h(oe.$$.fragment,e),pt=a(e),se=r(e,"UL",{"data-svelte-h":!0}),m(se)!=="svelte-ejgnpl"&&(se.innerHTML=Uo),ht=a(e),ne=r(e,"P",{"data-svelte-h":!0}),m(ne)!=="svelte-hckg3t"&&(ne.textContent=ko),gt=a(e),h(ae.$$.fragment,e),ft=a(e),ie=r(e,"UL",{"data-svelte-h":!0}),m(ie)!=="svelte-18iwa30"&&(ie.innerHTML=Co),ut=a(e),h(re.$$.fragment,e),_t=a(e),le=r(e,"P",{"data-svelte-h":!0}),m(le)!=="svelte-7z8spz"&&(le.textContent=zo),yt=a(e),h(ce.$$.fragment,e),Tt=a(e),de=r(e,"P",{"data-svelte-h":!0}),m(de)!=="svelte-uke0yx"&&(de.innerHTML=Zo),Mt=a(e),me=r(e,"P",{"data-svelte-h":!0}),m(me)!=="svelte-o3pzzu"&&(me.textContent=xo),bt=a(e),h(pe.$$.fragment,e),wt=a(e),he=r(e,"P",{"data-svelte-h":!0}),m(he)!=="svelte-1ehkek3"&&(he.innerHTML=Wo),It=a(e),ge=r(e,"P",{"data-svelte-h":!0}),m(ge)!=="svelte-1pidlee"&&(ge.textContent=Fo),Jt=a(e),h(fe.$$.fragment,e),vt=a(e),h(ue.$$.fragment,e),jt=a(e),_e=r(e,"P",{"data-svelte-h":!0}),m(_e)!=="svelte-1ai4ii"&&(_e.innerHTML=Ro),Ut=a(e),ye=r(e,"P",{"data-svelte-h":!0}),m(ye)!=="svelte-mp60zk"&&(ye.innerHTML=No),kt=a(e),h(Te.$$.fragment,e),Ct=a(e),h(Me.$$.fragment,e),zt=a(e),be=r(e,"P",{"data-svelte-h":!0}),m(be)!=="svelte-ig9dca"&&(be.textContent=$o),Zt=a(e),we=r(e,"UL",{"data-svelte-h":!0}),m(we)!=="svelte-1sz5atq"&&(we.innerHTML=Bo),xt=a(e),h(Ie.$$.fragment,e),Wt=a(e),j=r(e,"DIV",{class:!0});var x=W(j);h(Je.$$.fragment,x),Pt=a(x),Be=r(x,"P",{"data-svelte-h":!0}),m(Be)!=="svelte-1ngts0f"&&(Be.innerHTML=Go),Lt=a(x),Ge=r(x,"P",{"data-svelte-h":!0}),m(Ge)!=="svelte-o55m63"&&(Ge.innerHTML=qo),Qt=a(x),h(E.$$.fragment,x),x.forEach(o),Ft=a(e),h(ve.$$.fragment,e),Rt=a(e),I=r(e,"DIV",{class:!0});var k=W(I);h(je.$$.fragment,k),At=a(k),qe=r(k,"P",{"data-svelte-h":!0}),m(qe)!=="svelte-1uy0n3m"&&(qe.textContent=Eo),Dt=a(k),Ee=r(k,"P",{"data-svelte-h":!0}),m(Ee)!=="svelte-6pahdo"&&(Ee.innerHTML=Vo),Ot=a(k),Ve=r(k,"P",{"data-svelte-h":!0}),m(Ve)!=="svelte-hswkmf"&&(Ve.innerHTML=Xo),Kt=a(k),N=r(k,"DIV",{class:!0});var B=W(N);h(Ue.$$.fragment,B),eo=a(B),Xe=r(B,"P",{"data-svelte-h":!0}),m(Xe)!=="svelte-felb7u"&&(Xe.textContent=Ho),to=a(B),He=r(B,"P",{"data-svelte-h":!0}),m(He)!=="svelte-58ee4k"&&(He.textContent=So),B.forEach(o),k.forEach(o),Nt=a(e),h(ke.$$.fragment,e),$t=a(e),J=r(e,"DIV",{class:!0});var C=W(J);h(Ce.$$.fragment,C),oo=a(C),Se=r(C,"P",{"data-svelte-h":!0}),m(Se)!=="svelte-n5mg2z"&&(Se.textContent=Yo),so=a(C),Ye=r(C,"P",{"data-svelte-h":!0}),m(Ye)!=="svelte-6pahdo"&&(Ye.innerHTML=Po),no=a(C),Pe=r(C,"P",{"data-svelte-h":!0}),m(Pe)!=="svelte-hswkmf"&&(Pe.innerHTML=Lo),ao=a(C),z=r(C,"DIV",{class:!0});var Y=W(z);h(ze.$$.fragment,Y),io=a(Y),Le=r(Y,"P",{"data-svelte-h":!0}),m(Le)!=="svelte-sq5c5e"&&(Le.innerHTML=Qo),ro=a(Y),h(V.$$.fragment,Y),lo=a(Y),h(X.$$.fragment,Y),Y.forEach(o),C.forEach(o),Bt=a(e),h(Ze.$$.fragment,e),Gt=a(e),Z=r(e,"DIV",{class:!0});var et=W(Z);h(xe.$$.fragment,et),co=a(et),Qe=r(et,"P",{"data-svelte-h":!0}),m(Qe)!=="svelte-1m1ucrf"&&(Qe.textContent=Ao),mo=a(et),H=r(et,"DIV",{class:!0});var St=W(H);h(We.$$.fragment,St),po=a(St),Ae=r(St,"P",{"data-svelte-h":!0}),m(Ae)!=="svelte-1xds4wy"&&(Ae.textContent=Do),St.forEach(o),et.forEach(o),qt=a(e),h(Fe.$$.fragment,e),Et=a(e),U=r(e,"DIV",{class:!0});var P=W(U);h(Re.$$.fragment,P),ho=a(P),De=r(P,"P",{"data-svelte-h":!0}),m(De)!=="svelte-1jys543"&&(De.textContent=Oo),go=a(P),Oe=r(P,"P",{"data-svelte-h":!0}),m(Oe)!=="svelte-1efqgl8"&&(Oe.innerHTML=Ko),fo=a(P),$=r(P,"DIV",{class:!0});var tt=W($);h(Ne.$$.fragment,tt),uo=a(tt),Ke=r(tt,"P",{"data-svelte-h":!0}),m(Ke)!=="svelte-421t2f"&&(Ke.textContent=es),_o=a(tt),h(S.$$.fragment,tt),tt.forEach(o),P.forEach(o),Vt=a(e),h($e.$$.fragment,e),Xt=a(e),ot=r(e,"P",{}),W(ot).forEach(o),this.h()},h(){v(d,"name","hf:doc:metadata"),v(d,"content",gs),v(b,"class","flex flex-wrap space-x-1"),os(q.src,Jo="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/idefics2_architecture.png")||v(q,"src",Jo),v(q,"alt","drawing"),v(q,"width","600"),v(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){c(document.head,d),s(e,w,t),s(e,T,t),s(e,y,t),g(M,e,t),s(e,l,t),s(e,b,t),s(e,st,t),g(Q,e,t),s(e,nt,t),s(e,A,t),s(e,at,t),s(e,D,t),s(e,it,t),s(e,O,t),s(e,rt,t),s(e,K,t),s(e,lt,t),s(e,q,t),s(e,ct,t),s(e,ee,t),s(e,dt,t),s(e,te,t),s(e,mt,t),g(oe,e,t),s(e,pt,t),s(e,se,t),s(e,ht,t),s(e,ne,t),s(e,gt,t),g(ae,e,t),s(e,ft,t),s(e,ie,t),s(e,ut,t),g(re,e,t),s(e,_t,t),s(e,le,t),s(e,yt,t),g(ce,e,t),s(e,Tt,t),s(e,de,t),s(e,Mt,t),s(e,me,t),s(e,bt,t),g(pe,e,t),s(e,wt,t),s(e,he,t),s(e,It,t),s(e,ge,t),s(e,Jt,t),g(fe,e,t),s(e,vt,t),g(ue,e,t),s(e,jt,t),s(e,_e,t),s(e,Ut,t),s(e,ye,t),s(e,kt,t),g(Te,e,t),s(e,Ct,t),g(Me,e,t),s(e,zt,t),s(e,be,t),s(e,Zt,t),s(e,we,t),s(e,xt,t),g(Ie,e,t),s(e,Wt,t),s(e,j,t),g(Je,j,null),c(j,Pt),c(j,Be),c(j,Lt),c(j,Ge),c(j,Qt),g(E,j,null),s(e,Ft,t),g(ve,e,t),s(e,Rt,t),s(e,I,t),g(je,I,null),c(I,At),c(I,qe),c(I,Dt),c(I,Ee),c(I,Ot),c(I,Ve),c(I,Kt),c(I,N),g(Ue,N,null),c(N,eo),c(N,Xe),c(N,to),c(N,He),s(e,Nt,t),g(ke,e,t),s(e,$t,t),s(e,J,t),g(Ce,J,null),c(J,oo),c(J,Se),c(J,so),c(J,Ye),c(J,no),c(J,Pe),c(J,ao),c(J,z),g(ze,z,null),c(z,io),c(z,Le),c(z,ro),g(V,z,null),c(z,lo),g(X,z,null),s(e,Bt,t),g(Ze,e,t),s(e,Gt,t),s(e,Z,t),g(xe,Z,null),c(Z,co),c(Z,Qe),c(Z,mo),c(Z,H),g(We,H,null),c(H,po),c(H,Ae),s(e,qt,t),g(Fe,e,t),s(e,Et,t),s(e,U,t),g(Re,U,null),c(U,ho),c(U,De),c(U,go),c(U,Oe),c(U,fo),c(U,$),g(Ne,$,null),c($,uo),c($,Ke),c($,_o),g(S,$,null),s(e,Vt,t),g($e,e,t),s(e,Xt,t),s(e,ot,t),Ht=!0},p(e,[t]){const x={};t&2&&(x.$$scope={dirty:t,ctx:e}),E.$set(x);const k={};t&2&&(k.$$scope={dirty:t,ctx:e}),V.$set(k);const B={};t&2&&(B.$$scope={dirty:t,ctx:e}),X.$set(B);const C={};t&2&&(C.$$scope={dirty:t,ctx:e}),S.$set(C)},i(e){Ht||(f(M.$$.fragment,e),f(Q.$$.fragment,e),f(oe.$$.fragment,e),f(ae.$$.fragment,e),f(re.$$.fragment,e),f(ce.$$.fragment,e),f(pe.$$.fragment,e),f(fe.$$.fragment,e),f(ue.$$.fragment,e),f(Te.$$.fragment,e),f(Me.$$.fragment,e),f(Ie.$$.fragment,e),f(Je.$$.fragment,e),f(E.$$.fragment,e),f(ve.$$.fragment,e),f(je.$$.fragment,e),f(Ue.$$.fragment,e),f(ke.$$.fragment,e),f(Ce.$$.fragment,e),f(ze.$$.fragment,e),f(V.$$.fragment,e),f(X.$$.fragment,e),f(Ze.$$.fragment,e),f(xe.$$.fragment,e),f(We.$$.fragment,e),f(Fe.$$.fragment,e),f(Re.$$.fragment,e),f(Ne.$$.fragment,e),f(S.$$.fragment,e),f($e.$$.fragment,e),Ht=!0)},o(e){u(M.$$.fragment,e),u(Q.$$.fragment,e),u(oe.$$.fragment,e),u(ae.$$.fragment,e),u(re.$$.fragment,e),u(ce.$$.fragment,e),u(pe.$$.fragment,e),u(fe.$$.fragment,e),u(ue.$$.fragment,e),u(Te.$$.fragment,e),u(Me.$$.fragment,e),u(Ie.$$.fragment,e),u(Je.$$.fragment,e),u(E.$$.fragment,e),u(ve.$$.fragment,e),u(je.$$.fragment,e),u(Ue.$$.fragment,e),u(ke.$$.fragment,e),u(Ce.$$.fragment,e),u(ze.$$.fragment,e),u(V.$$.fragment,e),u(X.$$.fragment,e),u(Ze.$$.fragment,e),u(xe.$$.fragment,e),u(We.$$.fragment,e),u(Fe.$$.fragment,e),u(Re.$$.fragment,e),u(Ne.$$.fragment,e),u(S.$$.fragment,e),u($e.$$.fragment,e),Ht=!1},d(e){e&&(o(w),o(T),o(y),o(l),o(b),o(st),o(nt),o(A),o(at),o(D),o(it),o(O),o(rt),o(K),o(lt),o(q),o(ct),o(ee),o(dt),o(te),o(mt),o(pt),o(se),o(ht),o(ne),o(gt),o(ft),o(ie),o(ut),o(_t),o(le),o(yt),o(Tt),o(de),o(Mt),o(me),o(bt),o(wt),o(he),o(It),o(ge),o(Jt),o(vt),o(jt),o(_e),o(Ut),o(ye),o(kt),o(Ct),o(zt),o(be),o(Zt),o(we),o(xt),o(Wt),o(j),o(Ft),o(Rt),o(I),o(Nt),o($t),o(J),o(Bt),o(Gt),o(Z),o(qt),o(Et),o(U),o(Vt),o(Xt),o(ot)),o(d),_(M,e),_(Q,e),_(oe,e),_(ae,e),_(re,e),_(ce,e),_(pe,e),_(fe,e),_(ue,e),_(Te,e),_(Me,e),_(Ie,e),_(Je),_(E),_(ve,e),_(je),_(Ue),_(ke,e),_(Ce),_(ze),_(V),_(X),_(Ze,e),_(xe),_(We),_(Fe,e),_(Re),_(Ne),_(S),_($e,e)}}}const gs='{"title":"Idefics2","local":"idefics2","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Model optimizations: Flash Attention","local":"model-optimizations-flash-attention","sections":[],"depth":2},{"title":"Shrinking down Idefics2 using quantization","local":"shrinking-down-idefics2-using-quantization","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"Idefics2Config","local":"transformers.Idefics2Config","sections":[],"depth":2},{"title":"Idefics2Model","local":"transformers.Idefics2Model","sections":[],"depth":2},{"title":"Idefics2ForConditionalGeneration","local":"transformers.Idefics2ForConditionalGeneration","sections":[],"depth":2},{"title":"Idefics2ImageProcessor","local":"transformers.Idefics2ImageProcessor","sections":[],"depth":2},{"title":"Idefics2Processor","local":"transformers.Idefics2Processor","sections":[],"depth":2}],"depth":1}';function fs(R){return ss(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Js extends ns{constructor(d){super(),as(this,d,fs,hs,ts,{})}}export{Js as component};
