import{s as Et,z as Bt,o as Pt,n as $e}from"../chunks/scheduler.18a86fab.js";import{S as Nt,i as Ht,g as c,s as r,r as h,A as Vt,h as p,f as o,c as i,j as ce,u,x as f,k as z,y as m,a as s,v as g,d as _,t as b,w as y}from"../chunks/index.98837b22.js";import{T as ft}from"../chunks/Tip.77304350.js";import{D as Je}from"../chunks/Docstring.6758ea23.js";import{C as Le}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as ht}from"../chunks/ExampleCodeBlock.0c42463f.js";import{P as Gt}from"../chunks/PipelineTag.7749150e.js";import{H as pe}from"../chunks/Heading.7e7e0c5b.js";import{E as Rt}from"../chunks/getInferenceSnippets.de10bc7d.js";function St(I){let n,w="Example:",l,d,M;return d=new Le({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMElKZXBhQ29uZmlnJTJDJTIwSUplcGFNb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBJSkVQQSUyMGlqZXBhLWJhc2UtcGF0Y2gxNi0yMjQlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwSUplcGFDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMCh3aXRoJTIwcmFuZG9tJTIwd2VpZ2h0cyklMjBmcm9tJTIwdGhlJTIwaWplcGEtYmFzZS1wYXRjaDE2LTIyNCUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwSUplcGFNb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> IJepaConfig, IJepaModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a IJEPA ijepa-base-patch16-224 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = IJepaConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the ijepa-base-patch16-224 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = IJepaModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){n=c("p"),n.textContent=w,l=r(),h(d.$$.fragment)},l(a){n=p(a,"P",{"data-svelte-h":!0}),f(n)!=="svelte-11lpom8"&&(n.textContent=w),l=i(a),u(d.$$.fragment,a)},m(a,$){s(a,n,$),s(a,l,$),g(d,a,$),M=!0},p:$e,i(a){M||(_(d.$$.fragment,a),M=!0)},o(a){b(d.$$.fragment,a),M=!1},d(a){a&&(o(n),o(l)),y(d,a)}}}function Xt(I){let n,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=c("p"),n.innerHTML=w},l(l){n=p(l,"P",{"data-svelte-h":!0}),f(n)!=="svelte-fincs2"&&(n.innerHTML=w)},m(l,d){s(l,n,d)},p:$e,d(l){l&&o(n)}}}function At(I){let n,w="Example:",l,d,M;return d=new Le({props:{code:"",highlighted:"",wrap:!1}}),{c(){n=c("p"),n.textContent=w,l=r(),h(d.$$.fragment)},l(a){n=p(a,"P",{"data-svelte-h":!0}),f(n)!=="svelte-11lpom8"&&(n.textContent=w),l=i(a),u(d.$$.fragment,a)},m(a,$){s(a,n,$),s(a,l,$),g(d,a,$),M=!0},p:$e,i(a){M||(_(d.$$.fragment,a),M=!0)},o(a){b(d.$$.fragment,a),M=!1},d(a){a&&(o(n),o(l)),y(d,a)}}}function Qt(I){let n,w=`Note that it’s possible to fine-tune IJepa on higher resolution images than the ones it has been trained on, by
setting <code>interpolate_pos_encoding</code> to <code>True</code> in the forward of the model. This will interpolate the pre-trained
position embeddings to the higher resolution.`;return{c(){n=c("p"),n.innerHTML=w},l(l){n=p(l,"P",{"data-svelte-h":!0}),f(n)!=="svelte-lhh59f"&&(n.innerHTML=w)},m(l,d){s(l,n,d)},p:$e,d(l){l&&o(n)}}}function Lt(I){let n,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=c("p"),n.innerHTML=w},l(l){n=p(l,"P",{"data-svelte-h":!0}),f(n)!=="svelte-fincs2"&&(n.innerHTML=w)},m(l,d){s(l,n,d)},p:$e,d(l){l&&o(n)}}}function qt(I){let n,w="Example:",l,d,M;return d=new Le({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMElKZXBhRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJodWdnaW5nZmFjZSUyRmNhdHMtaW1hZ2UlMjIlMkMlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUpJTBBaW1hZ2UlMjAlM0QlMjBkYXRhc2V0JTVCJTIydGVzdCUyMiU1RCU1QiUyMmltYWdlJTIyJTVEJTVCMCU1RCUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZpamVwYV92aXRoMTRfMWslMjIpJTBBbW9kZWwlMjAlM0QlMjBJSmVwYUZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGaWplcGFfdml0aDE0XzFrJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5sb2dpdHMlMEElMEElMjMlMjBtb2RlbCUyMHByZWRpY3RzJTIwb25lJTIwb2YlMjB0aGUlMjAxMDAwJTIwSW1hZ2VOZXQlMjBjbGFzc2VzJTBBcHJlZGljdGVkX2xhYmVsJTIwJTNEJTIwbG9naXRzLmFyZ21heCgtMSkuaXRlbSgpJTBBcHJpbnQobW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCcHJlZGljdGVkX2xhYmVsJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, IJepaForImageClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/ijepa_vith14_1k&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = IJepaForImageClassification.from_pretrained(<span class="hljs-string">&quot;facebook/ijepa_vith14_1k&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(model.config.id2label[predicted_label])
...`,wrap:!1}}),{c(){n=c("p"),n.textContent=w,l=r(),h(d.$$.fragment)},l(a){n=p(a,"P",{"data-svelte-h":!0}),f(n)!=="svelte-11lpom8"&&(n.textContent=w),l=i(a),u(d.$$.fragment,a)},m(a,$){s(a,n,$),s(a,l,$),g(d,a,$),M=!0},p:$e,i(a){M||(_(d.$$.fragment,a),M=!0)},o(a){b(d.$$.fragment,a),M=!1},d(a){a&&(o(n),o(l)),y(d,a)}}}function Yt(I){let n,w,l,d,M,a,$,ut='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/> <img alt="FlashAttention" src="https://img.shields.io/badge/%E2%9A%A1%EF%B8%8E%20FlashAttention-eae0c8?style=flat"/> <img alt="SDPA" src="https://img.shields.io/badge/SDPA-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',ve,G,Ie,R,gt=`The I-JEPA model was proposed in <a href="https://arxiv.org/abs/2301.08243" rel="nofollow">Image-based Joint-Embedding Predictive Architecture</a> by Mahmoud Assran, Quentin Duval, Ishan Misra, Piotr Bojanowski, Pascal Vincent, Michael Rabbat, Yann LeCun, Nicolas Ballas.
I-JEPA is a self-supervised learning method that predicts the representations of one part of an image based on other parts of the same image. This approach focuses on learning semantic features without relying on pre-defined invariances from hand-crafted data transformations, which can bias specific tasks, or on filling in pixel-level details, which often leads to less meaningful representations.`,je,S,_t="The abstract from the paper is the following:",Ce,X,bt="This paper demonstrates an approach for learning highly semantic image representations without relying on hand-crafted data-augmentations. We introduce the Image- based Joint-Embedding Predictive Architecture (I-JEPA), a non-generative approach for self-supervised learning from images. The idea behind I-JEPA is simple: from a single context block, predict the representations of various target blocks in the same image. A core design choice to guide I-JEPA towards producing semantic representations is the masking strategy; specifically, it is crucial to (a) sample tar- get blocks with sufficiently large scale (semantic), and to (b) use a sufficiently informative (spatially distributed) context block. Empirically, when combined with Vision Transform- ers, we find I-JEPA to be highly scalable. For instance, we train a ViT-Huge/14 on ImageNet using 16 A100 GPUs in under 72 hours to achieve strong downstream performance across a wide range of tasks, from linear classification to object counting and depth prediction.",xe,Z,yt,ke,A,wt='I-JEPA architecture. Taken from the <a href="https://arxiv.org/abs/2301.08243">original paper.</a>',Ue,Q,Mt=`This model was contributed by <a href="https://huggingface.co/jmtzt" rel="nofollow">jmtzt</a>.
The original code can be found <a href="https://github.com/facebookresearch/ijepa" rel="nofollow">here</a>.`,We,L,Fe,q,$t="Here is how to use this model for image feature extraction:",ze,Y,Ze,D,Ee,O,Tt="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with I-JEPA.",Be,K,Pe,ee,Jt='<li><a href="/docs/transformers/main/en/model_doc/ijepa#transformers.IJepaForImageClassification">IJepaForImageClassification</a> is supported by this <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/image-classification" rel="nofollow">example script</a> and <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/examples/image_classification.ipynb" rel="nofollow">notebook</a>.</li> <li>See also: <a href="../tasks/image_classification">Image classification task guide</a></li>',Ne,te,He,j,oe,qe,me,vt=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/ijepa#transformers.IJepaModel">IJepaModel</a>. It is used to instantiate an IJEPA
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the I-JEPA
<a href="https://huggingface.co/facebook/ijepa_vith14_1k" rel="nofollow">facebook/ijepa_vith14_1k</a> architecture.`,Ye,fe,It=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,De,E,Ve,ne,Ge,J,ae,Oe,he,jt="The bare Ijepa Model outputting raw hidden-states without any specific head on top.",Ke,ue,Ct=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,et,ge,xt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,tt,x,se,ot,_e,kt='The <a href="/docs/transformers/main/en/model_doc/ijepa#transformers.IJepaModel">IJepaModel</a> forward method, overrides the <code>__call__</code> special method.',nt,B,at,P,Re,re,Se,T,ie,st,be,Ut=`IJepa Model transformer with an image classification head on top (a linear layer on top of the final hidden states)
e.g. for ImageNet.`,rt,N,it,ye,Wt=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,lt,we,Ft=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,dt,k,le,ct,Me,zt='The <a href="/docs/transformers/main/en/model_doc/ijepa#transformers.IJepaForImageClassification">IJepaForImageClassification</a> forward method, overrides the <code>__call__</code> special method.',pt,H,mt,V,Xe,de,Ae,Te,Qe;return M=new pe({props:{title:"I-JEPA",local:"i-jepa",headingTag:"h1"}}),G=new pe({props:{title:"Overview",local:"overview",headingTag:"h2"}}),L=new pe({props:{title:"How to use",local:"how-to-use",headingTag:"h2"}}),Y=new Le({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWZyb20lMjB0b3JjaC5ubi5mdW5jdGlvbmFsJTIwaW1wb3J0JTIwY29zaW5lX3NpbWlsYXJpdHklMEElMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsJTJDJTIwQXV0b1Byb2Nlc3NvciUwQSUwQXVybF8xJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQXVybF8yJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMjE5NTc4LmpwZyUyMiUwQWltYWdlXzElMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmxfMSUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEFpbWFnZV8yJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsXzIlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJmYWNlYm9vayUyRmlqZXBhX3ZpdGgxNF8xayUyMiUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEElMEElNDB0b3JjaC5ub19ncmFkKCklMEFkZWYlMjBpbmZlcihpbWFnZSklM0ElMEElMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBvdXRwdXRzLmxhc3RfaGlkZGVuX3N0YXRlLm1lYW4oZGltJTNEMSklMEElMEElMEFlbWJlZF8xJTIwJTNEJTIwaW5mZXIoaW1hZ2VfMSklMEFlbWJlZF8yJTIwJTNEJTIwaW5mZXIoaW1hZ2VfMiklMEElMEFzaW1pbGFyaXR5JTIwJTNEJTIwY29zaW5lX3NpbWlsYXJpdHkoZW1iZWRfMSUyQyUyMGVtYmVkXzIpJTBBcHJpbnQoc2ltaWxhcml0eSk=",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> torch.nn.functional <span class="hljs-keyword">import</span> cosine_similarity

<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel, AutoProcessor

url_1 = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
url_2 = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000219578.jpg&quot;</span>
image_1 = Image.<span class="hljs-built_in">open</span>(requests.get(url_1, stream=<span class="hljs-literal">True</span>).raw)
image_2 = Image.<span class="hljs-built_in">open</span>(requests.get(url_2, stream=<span class="hljs-literal">True</span>).raw)

model_id = <span class="hljs-string">&quot;facebook/ijepa_vith14_1k&quot;</span>
processor = AutoProcessor.from_pretrained(model_id)
model = AutoModel.from_pretrained(model_id)

<span class="hljs-meta">@torch.no_grad()</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">infer</span>(<span class="hljs-params">image</span>):
    inputs = processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
    outputs = model(**inputs)
    <span class="hljs-keyword">return</span> outputs.last_hidden_state.mean(dim=<span class="hljs-number">1</span>)


embed_1 = infer(image_1)
embed_2 = infer(image_2)

similarity = cosine_similarity(embed_1, embed_2)
<span class="hljs-built_in">print</span>(similarity)`,wrap:!1}}),D=new pe({props:{title:"Resources",local:"resources",headingTag:"h2"}}),K=new Gt({props:{pipeline:"image-classification"}}),te=new pe({props:{title:"IJepaConfig",local:"transformers.IJepaConfig",headingTag:"h2"}}),oe=new Je({props:{name:"class transformers.IJepaConfig",anchor:"transformers.IJepaConfig",parameters:[{name:"hidden_size",val:" = 768"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 12"},{name:"intermediate_size",val:" = 3072"},{name:"hidden_act",val:" = 'gelu'"},{name:"hidden_dropout_prob",val:" = 0.0"},{name:"attention_probs_dropout_prob",val:" = 0.0"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-12"},{name:"image_size",val:" = 224"},{name:"patch_size",val:" = 16"},{name:"num_channels",val:" = 3"},{name:"qkv_bias",val:" = True"},{name:"pooler_output_size",val:" = None"},{name:"pooler_act",val:" = 'tanh'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.IJepaConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.IJepaConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.IJepaConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.IJepaConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.IJepaConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.IJepaConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"hidden_dropout_prob"},{anchor:"transformers.IJepaConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.IJepaConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.IJepaConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-12) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.IJepaConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 224) &#x2014;
The size (resolution) of each image.`,name:"image_size"},{anchor:"transformers.IJepaConfig.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The size (resolution) of each patch.`,name:"patch_size"},{anchor:"transformers.IJepaConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of input channels.`,name:"num_channels"},{anchor:"transformers.IJepaConfig.qkv_bias",description:`<strong>qkv_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to add a bias to the queries, keys and values.`,name:"qkv_bias"},{anchor:"transformers.IJepaConfig.pooler_output_size",description:`<strong>pooler_output_size</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Dimensionality of the pooler layer. If None, defaults to <code>hidden_size</code>.`,name:"pooler_output_size"},{anchor:"transformers.IJepaConfig.pooler_act",description:`<strong>pooler_act</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;tanh&quot;</code>) &#x2014;
The activation function to be used by the pooler. Keys of ACT2FN are supported for Flax and
Pytorch, and elements of <a href="https://www.tensorflow.org/api_docs/python/tf/keras/activations" rel="nofollow">https://www.tensorflow.org/api_docs/python/tf/keras/activations</a> are
supported for Tensorflow.`,name:"pooler_act"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/ijepa/configuration_ijepa.py#L20"}}),E=new ht({props:{anchor:"transformers.IJepaConfig.example",$$slots:{default:[St]},$$scope:{ctx:I}}}),ne=new pe({props:{title:"IJepaModel",local:"transformers.IJepaModel",headingTag:"h2"}}),ae=new Je({props:{name:"class transformers.IJepaModel",anchor:"transformers.IJepaModel",parameters:[{name:"config",val:": IJepaConfig"},{name:"add_pooling_layer",val:": bool = False"},{name:"use_mask_token",val:": bool = False"}],parametersDescription:[{anchor:"transformers.IJepaModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/ijepa#transformers.IJepaConfig">IJepaConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.IJepaModel.add_pooling_layer",description:`<strong>add_pooling_layer</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to add a pooling layer`,name:"add_pooling_layer"},{anchor:"transformers.IJepaModel.use_mask_token",description:`<strong>use_mask_token</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use a mask token for masked image modeling.`,name:"use_mask_token"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/ijepa/modeling_ijepa.py#L468"}}),se=new Je({props:{name:"forward",anchor:"transformers.IJepaModel.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"},{name:"bool_masked_pos",val:": typing.Optional[torch.BoolTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"interpolate_pos_encoding",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.IJepaModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>, <em>optional</em>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.IJepaModel.forward.bool_masked_pos",description:`<strong>bool_masked_pos</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, num_patches)</code>, <em>optional</em>) &#x2014;
Boolean masked positions. Indicates which patches are masked (1) and which aren&#x2019;t (0).`,name:"bool_masked_pos"},{anchor:"transformers.IJepaModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.IJepaModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.IJepaModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.IJepaModel.forward.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"},{anchor:"transformers.IJepaModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/ijepa/modeling_ijepa.py#L499",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/ijepa#transformers.IJepaConfig"
>IJepaConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state of the first token of the sequence (classification token) after further processing
through the layers used for the auxiliary pretraining task. E.g. for BERT-family of models, this returns
the classification token after processing through a linear layer and a tanh activation function. The linear
layer weights are trained from the next sentence prediction (classification) objective during pretraining.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),B=new ft({props:{$$slots:{default:[Xt]},$$scope:{ctx:I}}}),P=new ht({props:{anchor:"transformers.IJepaModel.forward.example",$$slots:{default:[At]},$$scope:{ctx:I}}}),re=new pe({props:{title:"IJepaForImageClassification",local:"transformers.IJepaForImageClassification",headingTag:"h2"}}),ie=new Je({props:{name:"class transformers.IJepaForImageClassification",anchor:"transformers.IJepaForImageClassification",parameters:[{name:"config",val:": IJepaConfig"}],parametersDescription:[{anchor:"transformers.IJepaForImageClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/ijepa#transformers.IJepaConfig">IJepaConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/ijepa/modeling_ijepa.py#L562"}}),N=new ft({props:{$$slots:{default:[Qt]},$$scope:{ctx:I}}}),le=new Je({props:{name:"forward",anchor:"transformers.IJepaForImageClassification.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"interpolate_pos_encoding",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.IJepaForImageClassification.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>, <em>optional</em>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.IJepaForImageClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.IJepaForImageClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.Tensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"},{anchor:"transformers.IJepaForImageClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.IJepaForImageClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.IJepaForImageClassification.forward.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"},{anchor:"transformers.IJepaForImageClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/ijepa/modeling_ijepa.py#L589",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.ImageClassifierOutput"
>transformers.modeling_outputs.ImageClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/ijepa#transformers.IJepaConfig"
>IJepaConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each stage) of shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states
(also called feature maps) of the model at the output of each stage.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.ImageClassifierOutput"
>transformers.modeling_outputs.ImageClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),H=new ft({props:{$$slots:{default:[Lt]},$$scope:{ctx:I}}}),V=new ht({props:{anchor:"transformers.IJepaForImageClassification.forward.example",$$slots:{default:[qt]},$$scope:{ctx:I}}}),de=new Rt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/ijepa.md"}}),{c(){n=c("meta"),w=r(),l=c("p"),d=r(),h(M.$$.fragment),a=r(),$=c("div"),$.innerHTML=ut,ve=r(),h(G.$$.fragment),Ie=r(),R=c("p"),R.innerHTML=gt,je=r(),S=c("p"),S.textContent=_t,Ce=r(),X=c("p"),X.textContent=bt,xe=r(),Z=c("img"),ke=r(),A=c("small"),A.innerHTML=wt,Ue=r(),Q=c("p"),Q.innerHTML=Mt,We=r(),h(L.$$.fragment),Fe=r(),q=c("p"),q.textContent=$t,ze=r(),h(Y.$$.fragment),Ze=r(),h(D.$$.fragment),Ee=r(),O=c("p"),O.textContent=Tt,Be=r(),h(K.$$.fragment),Pe=r(),ee=c("ul"),ee.innerHTML=Jt,Ne=r(),h(te.$$.fragment),He=r(),j=c("div"),h(oe.$$.fragment),qe=r(),me=c("p"),me.innerHTML=vt,Ye=r(),fe=c("p"),fe.innerHTML=It,De=r(),h(E.$$.fragment),Ve=r(),h(ne.$$.fragment),Ge=r(),J=c("div"),h(ae.$$.fragment),Oe=r(),he=c("p"),he.textContent=jt,Ke=r(),ue=c("p"),ue.innerHTML=Ct,et=r(),ge=c("p"),ge.innerHTML=xt,tt=r(),x=c("div"),h(se.$$.fragment),ot=r(),_e=c("p"),_e.innerHTML=kt,nt=r(),h(B.$$.fragment),at=r(),h(P.$$.fragment),Re=r(),h(re.$$.fragment),Se=r(),T=c("div"),h(ie.$$.fragment),st=r(),be=c("p"),be.textContent=Ut,rt=r(),h(N.$$.fragment),it=r(),ye=c("p"),ye.innerHTML=Wt,lt=r(),we=c("p"),we.innerHTML=Ft,dt=r(),k=c("div"),h(le.$$.fragment),ct=r(),Me=c("p"),Me.innerHTML=zt,pt=r(),h(H.$$.fragment),mt=r(),h(V.$$.fragment),Xe=r(),h(de.$$.fragment),Ae=r(),Te=c("p"),this.h()},l(e){const t=Vt("svelte-u9bgzb",document.head);n=p(t,"META",{name:!0,content:!0}),t.forEach(o),w=i(e),l=p(e,"P",{}),ce(l).forEach(o),d=i(e),u(M.$$.fragment,e),a=i(e),$=p(e,"DIV",{class:!0,"data-svelte-h":!0}),f($)!=="svelte-b95w5j"&&($.innerHTML=ut),ve=i(e),u(G.$$.fragment,e),Ie=i(e),R=p(e,"P",{"data-svelte-h":!0}),f(R)!=="svelte-1bycs9t"&&(R.innerHTML=gt),je=i(e),S=p(e,"P",{"data-svelte-h":!0}),f(S)!=="svelte-vfdo9a"&&(S.textContent=_t),Ce=i(e),X=p(e,"P",{"data-svelte-h":!0}),f(X)!=="svelte-1urhz7d"&&(X.textContent=bt),xe=i(e),Z=p(e,"IMG",{src:!0,alt:!0,width:!0}),ke=i(e),A=p(e,"SMALL",{"data-svelte-h":!0}),f(A)!=="svelte-pcs53f"&&(A.innerHTML=wt),Ue=i(e),Q=p(e,"P",{"data-svelte-h":!0}),f(Q)!=="svelte-1rsx8jp"&&(Q.innerHTML=Mt),We=i(e),u(L.$$.fragment,e),Fe=i(e),q=p(e,"P",{"data-svelte-h":!0}),f(q)!=="svelte-6hgymu"&&(q.textContent=$t),ze=i(e),u(Y.$$.fragment,e),Ze=i(e),u(D.$$.fragment,e),Ee=i(e),O=p(e,"P",{"data-svelte-h":!0}),f(O)!=="svelte-1mr8fcj"&&(O.textContent=Tt),Be=i(e),u(K.$$.fragment,e),Pe=i(e),ee=p(e,"UL",{"data-svelte-h":!0}),f(ee)!=="svelte-1ukrali"&&(ee.innerHTML=Jt),Ne=i(e),u(te.$$.fragment,e),He=i(e),j=p(e,"DIV",{class:!0});var U=ce(j);u(oe.$$.fragment,U),qe=i(U),me=p(U,"P",{"data-svelte-h":!0}),f(me)!=="svelte-d8odtj"&&(me.innerHTML=vt),Ye=i(U),fe=p(U,"P",{"data-svelte-h":!0}),f(fe)!=="svelte-o55m63"&&(fe.innerHTML=It),De=i(U),u(E.$$.fragment,U),U.forEach(o),Ve=i(e),u(ne.$$.fragment,e),Ge=i(e),J=p(e,"DIV",{class:!0});var C=ce(J);u(ae.$$.fragment,C),Oe=i(C),he=p(C,"P",{"data-svelte-h":!0}),f(he)!=="svelte-1tis1v9"&&(he.textContent=jt),Ke=i(C),ue=p(C,"P",{"data-svelte-h":!0}),f(ue)!=="svelte-6pahdo"&&(ue.innerHTML=Ct),et=i(C),ge=p(C,"P",{"data-svelte-h":!0}),f(ge)!=="svelte-hswkmf"&&(ge.innerHTML=xt),tt=i(C),x=p(C,"DIV",{class:!0});var W=ce(x);u(se.$$.fragment,W),ot=i(W),_e=p(W,"P",{"data-svelte-h":!0}),f(_e)!=="svelte-1j2g6ne"&&(_e.innerHTML=kt),nt=i(W),u(B.$$.fragment,W),at=i(W),u(P.$$.fragment,W),W.forEach(o),C.forEach(o),Re=i(e),u(re.$$.fragment,e),Se=i(e),T=p(e,"DIV",{class:!0});var v=ce(T);u(ie.$$.fragment,v),st=i(v),be=p(v,"P",{"data-svelte-h":!0}),f(be)!=="svelte-1htoj90"&&(be.textContent=Ut),rt=i(v),u(N.$$.fragment,v),it=i(v),ye=p(v,"P",{"data-svelte-h":!0}),f(ye)!=="svelte-6pahdo"&&(ye.innerHTML=Wt),lt=i(v),we=p(v,"P",{"data-svelte-h":!0}),f(we)!=="svelte-hswkmf"&&(we.innerHTML=Ft),dt=i(v),k=p(v,"DIV",{class:!0});var F=ce(k);u(le.$$.fragment,F),ct=i(F),Me=p(F,"P",{"data-svelte-h":!0}),f(Me)!=="svelte-tqpz4e"&&(Me.innerHTML=zt),pt=i(F),u(H.$$.fragment,F),mt=i(F),u(V.$$.fragment,F),F.forEach(o),v.forEach(o),Xe=i(e),u(de.$$.fragment,e),Ae=i(e),Te=p(e,"P",{}),ce(Te).forEach(o),this.h()},h(){z(n,"name","hf:doc:metadata"),z(n,"content",Dt),z($,"class","flex flex-wrap space-x-1"),Bt(Z.src,yt="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/ijepa_architecture.jpg")||z(Z,"src",yt),z(Z,"alt","drawing"),z(Z,"width","600"),z(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){m(document.head,n),s(e,w,t),s(e,l,t),s(e,d,t),g(M,e,t),s(e,a,t),s(e,$,t),s(e,ve,t),g(G,e,t),s(e,Ie,t),s(e,R,t),s(e,je,t),s(e,S,t),s(e,Ce,t),s(e,X,t),s(e,xe,t),s(e,Z,t),s(e,ke,t),s(e,A,t),s(e,Ue,t),s(e,Q,t),s(e,We,t),g(L,e,t),s(e,Fe,t),s(e,q,t),s(e,ze,t),g(Y,e,t),s(e,Ze,t),g(D,e,t),s(e,Ee,t),s(e,O,t),s(e,Be,t),g(K,e,t),s(e,Pe,t),s(e,ee,t),s(e,Ne,t),g(te,e,t),s(e,He,t),s(e,j,t),g(oe,j,null),m(j,qe),m(j,me),m(j,Ye),m(j,fe),m(j,De),g(E,j,null),s(e,Ve,t),g(ne,e,t),s(e,Ge,t),s(e,J,t),g(ae,J,null),m(J,Oe),m(J,he),m(J,Ke),m(J,ue),m(J,et),m(J,ge),m(J,tt),m(J,x),g(se,x,null),m(x,ot),m(x,_e),m(x,nt),g(B,x,null),m(x,at),g(P,x,null),s(e,Re,t),g(re,e,t),s(e,Se,t),s(e,T,t),g(ie,T,null),m(T,st),m(T,be),m(T,rt),g(N,T,null),m(T,it),m(T,ye),m(T,lt),m(T,we),m(T,dt),m(T,k),g(le,k,null),m(k,ct),m(k,Me),m(k,pt),g(H,k,null),m(k,mt),g(V,k,null),s(e,Xe,t),g(de,e,t),s(e,Ae,t),s(e,Te,t),Qe=!0},p(e,[t]){const U={};t&2&&(U.$$scope={dirty:t,ctx:e}),E.$set(U);const C={};t&2&&(C.$$scope={dirty:t,ctx:e}),B.$set(C);const W={};t&2&&(W.$$scope={dirty:t,ctx:e}),P.$set(W);const v={};t&2&&(v.$$scope={dirty:t,ctx:e}),N.$set(v);const F={};t&2&&(F.$$scope={dirty:t,ctx:e}),H.$set(F);const Zt={};t&2&&(Zt.$$scope={dirty:t,ctx:e}),V.$set(Zt)},i(e){Qe||(_(M.$$.fragment,e),_(G.$$.fragment,e),_(L.$$.fragment,e),_(Y.$$.fragment,e),_(D.$$.fragment,e),_(K.$$.fragment,e),_(te.$$.fragment,e),_(oe.$$.fragment,e),_(E.$$.fragment,e),_(ne.$$.fragment,e),_(ae.$$.fragment,e),_(se.$$.fragment,e),_(B.$$.fragment,e),_(P.$$.fragment,e),_(re.$$.fragment,e),_(ie.$$.fragment,e),_(N.$$.fragment,e),_(le.$$.fragment,e),_(H.$$.fragment,e),_(V.$$.fragment,e),_(de.$$.fragment,e),Qe=!0)},o(e){b(M.$$.fragment,e),b(G.$$.fragment,e),b(L.$$.fragment,e),b(Y.$$.fragment,e),b(D.$$.fragment,e),b(K.$$.fragment,e),b(te.$$.fragment,e),b(oe.$$.fragment,e),b(E.$$.fragment,e),b(ne.$$.fragment,e),b(ae.$$.fragment,e),b(se.$$.fragment,e),b(B.$$.fragment,e),b(P.$$.fragment,e),b(re.$$.fragment,e),b(ie.$$.fragment,e),b(N.$$.fragment,e),b(le.$$.fragment,e),b(H.$$.fragment,e),b(V.$$.fragment,e),b(de.$$.fragment,e),Qe=!1},d(e){e&&(o(w),o(l),o(d),o(a),o($),o(ve),o(Ie),o(R),o(je),o(S),o(Ce),o(X),o(xe),o(Z),o(ke),o(A),o(Ue),o(Q),o(We),o(Fe),o(q),o(ze),o(Ze),o(Ee),o(O),o(Be),o(Pe),o(ee),o(Ne),o(He),o(j),o(Ve),o(Ge),o(J),o(Re),o(Se),o(T),o(Xe),o(Ae),o(Te)),o(n),y(M,e),y(G,e),y(L,e),y(Y,e),y(D,e),y(K,e),y(te,e),y(oe),y(E),y(ne,e),y(ae),y(se),y(B),y(P),y(re,e),y(ie),y(N),y(le),y(H),y(V),y(de,e)}}}const Dt='{"title":"I-JEPA","local":"i-jepa","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"How to use","local":"how-to-use","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"IJepaConfig","local":"transformers.IJepaConfig","sections":[],"depth":2},{"title":"IJepaModel","local":"transformers.IJepaModel","sections":[],"depth":2},{"title":"IJepaForImageClassification","local":"transformers.IJepaForImageClassification","sections":[],"depth":2}],"depth":1}';function Ot(I){return Pt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class lo extends Nt{constructor(n){super(),Ht(this,n,Ot,Yt,Et,{})}}export{lo as component};
