import{s as Js,o as Ts,n as Qn}from"../chunks/scheduler.18a86fab.js";import{S as bs,i as ws,g as r,s,r as c,A as js,h as i,f as t,c as a,j as J,u as m,x as f,k as T,y as o,a as l,v as p,d as u,t as g,w as h}from"../chunks/index.98837b22.js";import{T as Bt}from"../chunks/Tip.77304350.js";import{D as w}from"../chunks/Docstring.6758ea23.js";import{C as Rn}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as ys}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as A}from"../chunks/Heading.7e7e0c5b.js";import{E as Us}from"../chunks/getInferenceSnippets.de10bc7d.js";function vs(Z){let d,b="Example:",M,y,U;return y=new Rn({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEphbnVzRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTJDJTIwSmFudXNDb25maWclMkMlMjBKYW51c1Zpc2lvbkNvbmZpZyUyQyUyMEphbnVzVlFWQUVDb25maWclMkMlMjBMbGFtYUNvbmZpZyUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBKYW51cyUyMHZpc2lvbiUyMGNvbmZpZyUwQXZpc2lvbl9jb25maWclMjAlM0QlMjBKYW51c1Zpc2lvbkNvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMExsYW1hJTIwY29uZmlnJTBBdGV4dF9jb25maWclMjAlM0QlMjBMbGFtYUNvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMFZRJTIwY29uZmlnJTBBdnFfY29uZmlnJTIwJTNEJTIwSmFudXNWUVZBRUNvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMEphbnVzJTIwUHJvJTIwMUIlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwSmFudXNDb25maWcodmlzaW9uX2NvbmZpZyUzRHZpc2lvbl9jb25maWclMkMlMjB0ZXh0X2NvbmZpZyUzRHRleHRfY29uZmlnJTJDJTIwdnFfY29uZmlnJTNEdnFfY29uZmlnKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBKYW51cyUyMFBybyUyMDFCJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBKYW51c0ZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbihjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> JanusForConditionalGeneration, JanusConfig, JanusVisionConfig, JanusVQVAEConfig, LlamaConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Janus vision config</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>vision_config = JanusVisionConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Llama config</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text_config = LlamaConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a VQ config</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>vq_config = JanusVQVAEConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Janus Pro 1B style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = JanusConfig(vision_config=vision_config, text_config=text_config, vq_config=vq_config)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the Janus Pro 1B style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = JanusForConditionalGeneration(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){d=r("p"),d.textContent=b,M=s(),c(y.$$.fragment)},l(_){d=i(_,"P",{"data-svelte-h":!0}),f(d)!=="svelte-11lpom8"&&(d.textContent=b),M=a(_),m(y.$$.fragment,_)},m(_,C){l(_,d,C),l(_,M,C),p(y,_,C),U=!0},p:Qn,i(_){U||(u(y.$$.fragment,_),U=!0)},o(_){g(y.$$.fragment,_),U=!1},d(_){_&&(t(d),t(M)),h(y,_)}}}function Cs(Z){let d,b=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){d=r("p"),d.innerHTML=b},l(M){d=i(M,"P",{"data-svelte-h":!0}),f(d)!=="svelte-fincs2"&&(d.innerHTML=b)},m(M,y){l(M,d,y)},p:Qn,d(M){M&&t(d)}}}function Is(Z){let d,b=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){d=r("p"),d.innerHTML=b},l(M){d=i(M,"P",{"data-svelte-h":!0}),f(d)!=="svelte-fincs2"&&(d.innerHTML=b)},m(M,y){l(M,d,y)},p:Qn,d(M){M&&t(d)}}}function $s(Z){let d,b=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){d=r("p"),d.innerHTML=b},l(M){d=i(M,"P",{"data-svelte-h":!0}),f(d)!=="svelte-fincs2"&&(d.innerHTML=b)},m(M,y){l(M,d,y)},p:Qn,d(M){M&&t(d)}}}function ks(Z){let d,b=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){d=r("p"),d.innerHTML=b},l(M){d=i(M,"P",{"data-svelte-h":!0}),f(d)!=="svelte-fincs2"&&(d.innerHTML=b)},m(M,y){l(M,d,y)},p:Qn,d(M){M&&t(d)}}}function xs(Z){let d,b="Example:",M,y,U;return y=new Rn({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyMEphbnVzRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBJTBBbW9kZWwlMjAlM0QlMjBKYW51c0ZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZGVlcHNlZWstY29tbXVuaXR5JTJGSmFudXMtUHJvLTFCJTIyKSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmRlZXBzZWVrLWNvbW11bml0eSUyRkphbnVzLVByby0xQiUyMiklMEElMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnR5cGUlMjIlM0ElMjAlMjJpbWFnZSUyMiUyQyUyMCUyMnVybCUyMiUzQSUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnBpcGVsaW5lLWNhdC1jaG9uay5qcGVnJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIydHlwZSUyMiUzQSUyMCUyMnRleHQlMjIlMkMlMjAlMjJ0ZXh0JTIyJTNBJTIwJTIyV2hlcmUlMjBpcyUyMHRoZSUyMGNhdCUyMHN0YW5kaW5nJTNGJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTVEJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yLmFwcGx5X2NoYXRfdGVtcGxhdGUoJTBBJTIwJTIwJTIwJTIwbWVzc2FnZXMlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjByZXR1cm5fZGljdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTBBJTIwJTIwJTIwJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSUwQSklMEElMjMlMjBHZW5lcmF0ZSUwQWdlbmVyYXRlX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzKSUwQXByb2Nlc3Nvci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, JanusForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>model = JanusForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;deepseek-community/Janus-Pro-1B&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;deepseek-community/Janus-Pro-1B&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: [
<span class="hljs-meta">... </span>            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>, <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg&quot;</span>},
<span class="hljs-meta">... </span>            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Where is the cat standing?&quot;</span>},
<span class="hljs-meta">... </span>        ]
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor.apply_chat_template(
<span class="hljs-meta">... </span>    messages,
<span class="hljs-meta">... </span>    tokenize=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    return_dict=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
<span class="hljs-meta">... </span>    add_generation_prompt=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){d=r("p"),d.textContent=b,M=s(),c(y.$$.fragment)},l(_){d=i(_,"P",{"data-svelte-h":!0}),f(d)!=="svelte-11lpom8"&&(d.textContent=b),M=a(_),m(y.$$.fragment,_)},m(_,C){l(_,d,C),l(_,M,C),p(y,_,C),U=!0},p:Qn,i(_){U||(u(y.$$.fragment,_),U=!0)},o(_){g(y.$$.fragment,_),U=!1},d(_){_&&(t(d),t(M)),h(y,_)}}}function zs(Z){let d,b,M,y,U,_,C,Pn,de,zo='The Janus Model was originally proposed in <a href="https://arxiv.org/abs/2410.13848" rel="nofollow">Janus: Decoupling Visual Encoding for Unified Multimodal Understanding and Generation</a> by DeepSeek AI team and later refined in <a href="https://arxiv.org/abs/2501.17811" rel="nofollow">Janus-Pro: Unified Multimodal Understanding and Generation with Data and Model Scaling</a>. Janus is a vision-language model that can generate both image and text output, it can also take both images and text as input.',Gn,ce,Ao=`<p>[!NOTE]
The model doesn’t generate both images and text in an interleaved format. The user has to pass a parameter indicating whether to generate text or image.</p>`,Ln,me,Zo="The abstract from the original paper is the following:",Hn,pe,Vo="<em>In this paper, we introduce Janus, an autoregressive framework that unifies multimodal understanding and generation. Prior research often relies on a single visual encoder for both tasks, such as Chameleon. However, due to the differing levels of information granularity required by multimodal understanding and generation, this approach can lead to suboptimal performance, particularly in multimodal understanding. To address this issue, we decouple visual encoding into separate pathways, while still leveraging a single, unified transformer architecture for processing. The decoupling not only alleviates the conflict between the visual encoder’s roles in understanding and generation, but also enhances the framework’s flexibility. For instance, both the multimodal understanding and generation components can independently select their most suitable encoding methods. Experiments show that Janus surpasses previous unified model and matches or exceeds the performance of task-specific models. The simplicity, high flexibility, and effectiveness of Janus make it a strong candidate for next-generation unified multimodal models.</em>",Sn,ue,Bo="The abstract from the aforementioned <code>Janus-Pro</code> paper, released afterwards, is the following:",Xn,ge,qo="<em>In this work, we introduce Janus-Pro, an advanced version of the previous work Janus. Specifically, Janus-Pro incorporates (1) an optimized training strate (2) expanded training data, and (3) scaling to larger model size. With these improvements, Janus-Pro achieves significant advancements in both multimodal understanding and text-to-image instruction-following capabilities, while also enhancing the stability of text-to-image generation. We hope this work will inspire further exploration in the field. Code and models are publicly available.</em>",Dn,he,Wo=`This model was contributed by <a href="https://huggingface.co/yaswanthgali" rel="nofollow">Yaswanth Gali</a> and <a href="https://huggingface.co/hugosilva664" rel="nofollow">Hugo Silva</a>.
The original code can be found <a href="https://github.com/deepseek-ai/Janus" rel="nofollow">here</a>.`,Yn,fe,On,Me,Kn,_e,Eo="Here is the example of visual understanding with a single image.",et,ye,No=`<p>[!NOTE]
Note that the model has been trained with a specific prompt format for chatting. Use <code>processor.apply_chat_template(my_conversation_dict)</code> to correctly format your prompts.</p>`,nt,Je,tt,Te,ot,be,Qo="Janus can perform inference with multiple images as input, where images can belong to the same prompt or different prompts in batched inference, where the model processes many conversations in parallel. Here is how you can do it:",st,we,at,je,rt,Ue,Fo="Janus can also generate images given a prompt.",it,ve,lt,Ce,dt,I,Ie,qt,ln,Ro=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/janus#transformers.JanusModel">JanusModel</a>. It is used to instantiate an
Janus model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the Janus-1B or Janus-7B models.`,Wt,dn,Po=`e.g. <a href="https://huggingface.co/deepseek-community/Janus-Pro-1B" rel="nofollow">deepseek-community/Janus-Pro-1B</a> or
<a href="https://huggingface.co/deepseek-community/Janus-Pro-7B" rel="nofollow">deepseek-community/Janus-Pro-7B</a>`,Et,cn,Go=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Nt,S,ct,$e,mt,W,ke,Qt,mn,Lo=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/janus#transformers.JanusVisionModel">JanusVisionModel</a>. It is used to instantiate a
<code>JanusVisionModel</code> according to the specified arguments, defining the model architecture.`,Ft,pn,Ho=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,pt,xe,ut,G,ze,Rt,un,So=`This is the configuration class to store the configuration of a <code>JanusVQVAEModel</code>. It is used to instantiate a
<code>JanusVQVAEModel</code> according to the specified arguments, defining the model architecture.
Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information. Instantiating a
configuration with the defaults will yield a similar configuration to the VQModel of the
<a href="https://huggingface.co/deepseek-community/Janus-Pro-1B" rel="nofollow">deepseek-community/Janus-Pro-1B</a>.`,gt,Ae,ht,v,Ze,Pt,gn,Xo="Constructs a Janus processor which wraps a Janus Image Processor and a Llama tokenizer into a single processor.",Gt,hn,Do=`<a href="/docs/transformers/main/en/model_doc/janus#transformers.JanusProcessor">JanusProcessor</a> offers all the functionalities of <a href="/docs/transformers/main/en/model_doc/janus#transformers.JanusImageProcessor">JanusImageProcessor</a> and <a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>. See the
<code>__call__()</code> and <a href="/docs/transformers/main/en/model_doc/janus#transformers.JanusProcessor.decode">decode()</a> for more information.`,Lt,X,Ve,Ht,fn,Yo=`This method forwards all its arguments to LlamaTokenizerFast’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.batch_decode">batch_decode()</a>. Please
refer to the docstring of this method for more information.`,St,D,Be,Xt,Mn,Oo=`This method forwards all its arguments to LlamaTokenizerFast’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.decode">decode()</a>. Please refer to
the docstring of this method for more information.`,Dt,Y,qe,Yt,_n,Ko=`Forwards all arguments to the image processor’s <code>postprocess</code> method.
Refer to the original method’s docstring for more details.`,ft,We,Mt,j,Ee,Ot,yn,es="Constructs a JANUS image processor.",Kt,O,Ne,eo,Jn,ns="Pads an image to a square based on the longest edge.",no,K,Qe,to,Tn,ts="Applies post-processing to the decoded image tokens by reversing transformations applied during preprocessing.",oo,ee,Fe,so,bn,os="Preprocess an image or batch of images.",ao,ne,Re,ro,wn,ss="Resize an image to dynamically calculated size.",io,te,Pe,lo,jn,as=`Unnormalizes <code>image</code> using the mean and standard deviation specified by <code>mean</code> and <code>std</code>.
image = (image * image_std) + image_mean`,_t,Ge,yt,$,Le,co,Un,rs="The bare Janus Model outputting raw hidden-states without any specific head on top.",mo,vn,is=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,po,Cn,ls=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,uo,E,He,go,In,ds='The <a href="/docs/transformers/main/en/model_doc/janus#transformers.JanusVisionModel">JanusVisionModel</a> forward method, overrides the <code>__call__</code> special method.',ho,oe,Jt,Se,Tt,k,Xe,fo,$n,cs=`The VQ-VAE model used in Janus for encoding/decoding images into discrete tokens.
This model follows the “Make-a-scene: Scene-based text-to-image generation with human priors” paper from
<a href="https://arxiv.org/abs/2203.13131" rel="nofollow">Oran Gafni, Adam Polyak, Oron Ashual, Shelly Sheynin, Devi Parikh, and Yaniv Taigman</a>.`,Mo,kn,ms=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,_o,xn,ps=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,yo,N,De,Jo,zn,us='The <a href="/docs/transformers/main/en/model_doc/janus#transformers.JanusVQVAE">JanusVQVAE</a> forward method, overrides the <code>__call__</code> special method.',To,se,bt,Ye,wt,x,Oe,bo,An,gs="The Janus model which consists of a siglip vision backbone, a Llama language model and a VQ model.",wo,Zn,hs=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,jo,Vn,fs=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Uo,Q,Ke,vo,Bn,Ms='The <a href="/docs/transformers/main/en/model_doc/janus#transformers.JanusModel">JanusModel</a> forward method, overrides the <code>__call__</code> special method.',Co,ae,jt,en,Ut,L,nn,Io,q,tn,$o,qn,_s='The <a href="/docs/transformers/main/en/model_doc/janus#transformers.JanusForConditionalGeneration">JanusForConditionalGeneration</a> forward method, overrides the <code>__call__</code> special method.',ko,re,xo,ie,vt,on,Ct,Fn,It;return U=new A({props:{title:"Janus",local:"janus",headingTag:"h1"}}),C=new A({props:{title:"Overview",local:"overview",headingTag:"h2"}}),fe=new A({props:{title:"Usage Example",local:"usage-example",headingTag:"h2"}}),Me=new A({props:{title:"Single image inference",local:"single-image-inference",headingTag:"h3"}}),Je=new Rn({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch  
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image  
<span class="hljs-keyword">import</span> requests  

<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> JanusForConditionalGeneration, JanusProcessor  

model_id = <span class="hljs-string">&quot;deepseek-community/Janus-Pro-1B&quot;</span>
<span class="hljs-comment"># Prepare Input for generation.</span>
messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&#x27;type&#x27;</span>:<span class="hljs-string">&#x27;image&#x27;</span>, <span class="hljs-string">&#x27;url&#x27;</span>: <span class="hljs-string">&#x27;http://images.cocodataset.org/val2017/000000039769.jpg&#x27;</span>},
            {<span class="hljs-string">&#x27;type&#x27;</span>:<span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>:<span class="hljs-string">&quot;What do you see in this image?.&quot;</span>}
        ]
    },
]

<span class="hljs-comment"># Set generation mode to \`text\` to perform text generation.</span>
processor = JanusProcessor.from_pretrained(model_id)
model = JanusForConditionalGeneration.from_pretrained(model_id,     
        torch_dtype=torch.bfloat16,
        device_map=<span class="hljs-string">&quot;auto&quot;</span>)

inputs = processor.apply_chat_template(
    messages,
    add_generation_prompt=<span class="hljs-literal">True</span>,
    generation_mode=<span class="hljs-string">&quot;text&quot;</span>,
    tokenize=<span class="hljs-literal">True</span>,
    return_dict=<span class="hljs-literal">True</span>,
    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
).to(model.device, dtype=torch.bfloat16)

output = model.generate(**inputs, max_new_tokens=<span class="hljs-number">40</span>,generation_mode=<span class="hljs-string">&#x27;text&#x27;</span>,do_sample=<span class="hljs-literal">True</span>)
text = processor.decode(output[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(text)`,wrap:!1}}),Te=new A({props:{title:"Multi image inference",local:"multi-image-inference",headingTag:"h3"}}),we=new Rn({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> JanusForConditionalGeneration, JanusProcessor

model_id = <span class="hljs-string">&quot;deepseek-community/Janus-Pro-1B&quot;</span>

image_urls = [
    <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>,
    <span class="hljs-string">&quot;https://www.ilankelman.org/stopsigns/australia.jpg&quot;</span>,
    <span class="hljs-string">&quot;https://huggingface.co/microsoft/kosmos-2-patch14-224/resolve/main/snowman.jpg&quot;</span>
]

messages = [
    [
        {
            <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
            <span class="hljs-string">&quot;content&quot;</span>: [
                {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What’s the difference between&quot;</span>},
                {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>, <span class="hljs-string">&quot;url&quot;</span>: image_urls[<span class="hljs-number">0</span>]},
                {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot; and &quot;</span>},
                {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>, <span class="hljs-string">&quot;url&quot;</span>: image_urls[<span class="hljs-number">1</span>]}
            ]
        }
    ],
    [
        {
            <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
            <span class="hljs-string">&quot;content&quot;</span>: [
                {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>, <span class="hljs-string">&quot;url&quot;</span>: image_urls[<span class="hljs-number">2</span>]},
                {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What do you see in this image?&quot;</span>}
            ]
        }
    ]
]

<span class="hljs-comment"># Load model and processor</span>
processor = JanusProcessor.from_pretrained(model_id)
model = JanusForConditionalGeneration.from_pretrained(
    model_id, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;auto&quot;</span>
)

inputs = processor.apply_chat_template(
    messages,
    add_generation_prompt=<span class="hljs-literal">True</span>,
    generation_mode=<span class="hljs-string">&quot;text&quot;</span>,
    tokenize=<span class="hljs-literal">True</span>,
    padding=<span class="hljs-literal">True</span>,
    return_dict=<span class="hljs-literal">True</span>,
    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
).to(model.device, dtype=torch.bfloat16)

<span class="hljs-comment"># Generate response</span>
output = model.generate(**inputs, max_new_tokens=<span class="hljs-number">40</span>, generation_mode=<span class="hljs-string">&#x27;text&#x27;</span>, do_sample=<span class="hljs-literal">False</span>)
text = processor.batch_decode(output, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(text)`,wrap:!1}}),je=new A({props:{title:"Text to Image generation",local:"text-to-image-generation",headingTag:"h2"}}),ve=new Rn({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> JanusForConditionalGeneration, JanusProcessor

<span class="hljs-comment"># Set generation mode to \`image\` to prepare inputs for image generation..</span>

model_id = <span class="hljs-string">&quot;deepseek-community/Janus-Pro-1B&quot;</span>
processor = JanusProcessor.from_pretrained(model_id)
model = JanusForConditionalGeneration.from_pretrained(model_id,
        torch_dtype=torch.bfloat16,
        device_map=<span class="hljs-string">&quot;auto&quot;</span>)

messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;A dog running under the rain.&quot;</span>},
        ],
     }
]

prompt = processor.apply_chat_template(messages, add_generation_prompt=<span class="hljs-literal">True</span>)
inputs = processor(text=prompt,generation_mode=<span class="hljs-string">&quot;image&quot;</span>,return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device, dtype=torch.bfloat16)

<span class="hljs-comment"># Set num_return_sequence parameter to generate multiple images per prompt.</span>
model.generation_config.num_return_sequences = <span class="hljs-number">2</span>
outputs = model.generate(**inputs,
                         generation_mode=<span class="hljs-string">&quot;image&quot;</span>,
                         do_sample=<span class="hljs-literal">True</span>,
                         use_cache=<span class="hljs-literal">True</span>,
                         )
<span class="hljs-comment"># Perform post-processing on the generated token ids.</span>
decoded_image = model.decode_image_tokens(outputs)
images = processor.postprocess(<span class="hljs-built_in">list</span>(decoded_image.<span class="hljs-built_in">float</span>()),return_tensors=<span class="hljs-string">&quot;PIL.Image.Image&quot;</span>)
<span class="hljs-comment"># Save the image</span>
<span class="hljs-keyword">for</span> i, image <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(images[<span class="hljs-string">&#x27;pixel_values&#x27;</span>]):
    image.save(<span class="hljs-string">f&quot;result<span class="hljs-subst">{i}</span>.png&quot;</span>)`,wrap:!1}}),Ce=new A({props:{title:"JanusConfig",local:"transformers.JanusConfig",headingTag:"h2"}}),Ie=new w({props:{name:"class transformers.JanusConfig",anchor:"transformers.JanusConfig",parameters:[{name:"text_config",val:" = None"},{name:"vision_config",val:" = None"},{name:"vq_config",val:" = None"},{name:"image_token_id",val:" = 100581"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.JanusConfig.text_config",description:`<strong>text_config</strong> (<code>Union[AutoConfig, dict]</code>, <em>optional</em>, defaults to <code>LlamaConfig</code>) &#x2014;
The config object or dictionary of the text backbone.`,name:"text_config"},{anchor:"transformers.JanusConfig.vision_config",description:`<strong>vision_config</strong> (<code>Union[AutoConfig, dict]</code>,  <em>optional</em>, defaults to <code>JanusVisionConfig</code>) &#x2014;
The config object or dictionary of the vision backbone.`,name:"vision_config"},{anchor:"transformers.JanusConfig.vq_config",description:`<strong>vq_config</strong> (<code>Union[AutoConfig, dict]</code>,  <em>optional</em>, defaults to <code>JanusVQVAEConfig</code>) &#x2014;
The config object or dictionary of the VQVAE backbone.`,name:"vq_config"},{anchor:"transformers.JanusConfig.image_token_id",description:`<strong>image_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 100581) &#x2014;
Token index of a placeholder image token.`,name:"image_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/janus/configuration_janus.py#L214"}}),S=new ys({props:{anchor:"transformers.JanusConfig.example",$$slots:{default:[vs]},$$scope:{ctx:Z}}}),$e=new A({props:{title:"JanusVisionConfig",local:"transformers.JanusVisionConfig",headingTag:"h2"}}),ke=new w({props:{name:"class transformers.JanusVisionConfig",anchor:"transformers.JanusVisionConfig",parameters:[{name:"hidden_size",val:" = 1024"},{name:"num_hidden_layers",val:" = 24"},{name:"num_attention_heads",val:" = 16"},{name:"num_channels",val:" = 3"},{name:"patch_size",val:" = 16"},{name:"image_size",val:" = 384"},{name:"attention_dropout",val:" = 0.0"},{name:"layer_norm_eps",val:" = 1e-06"},{name:"hidden_act",val:" = 'gelu'"},{name:"mlp_ratio",val:" = 4.0"},{name:"attention_bias",val:" = True"},{name:"hidden_dropout_rate",val:" = 0.0"},{name:"projection_dim",val:" = 2048"},{name:"projection_dropout",val:" = 0.0"},{name:"use_qk_norm",val:" = False"},{name:"initializer_range",val:" = 0.02"},{name:"depth",val:" = 2"},{name:"num_image_tokens",val:" = 576"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.JanusVisionConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.JanusVisionConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 24) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.JanusVisionConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.JanusVisionConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of input channels.`,name:"num_channels"},{anchor:"transformers.JanusVisionConfig.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The size (resolution) of each patch.`,name:"patch_size"},{anchor:"transformers.JanusVisionConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 384) &#x2014;
The size (resolution) of each image.`,name:"image_size"},{anchor:"transformers.JanusVisionConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Dropout probability for attention weights.`,name:"attention_dropout"},{anchor:"transformers.JanusVisionConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-06) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.JanusVisionConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code>, and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.JanusVisionConfig.mlp_ratio",description:`<strong>mlp_ratio</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Ratio of MLP hidden dimensionality to embedding dimensionality.`,name:"mlp_ratio"},{anchor:"transformers.JanusVisionConfig.attention_bias",description:`<strong>attention_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to add a bias to the queries, keys, and values in the attention layers.`,name:"attention_bias"},{anchor:"transformers.JanusVisionConfig.hidden_dropout_rate",description:`<strong>hidden_dropout_rate</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for fully connected layers in the encoder.`,name:"hidden_dropout_rate"},{anchor:"transformers.JanusVisionConfig.projection_dim",description:`<strong>projection_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Dimensionality of the MLP projection head.`,name:"projection_dim"},{anchor:"transformers.JanusVisionConfig.projection_dropout",description:`<strong>projection_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Dropout probability for the projection layer.`,name:"projection_dropout"},{anchor:"transformers.JanusVisionConfig.use_qk_norm",description:`<strong>use_qk_norm</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to normalize the query and key matrices.`,name:"use_qk_norm"},{anchor:"transformers.JanusVisionConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated normal initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.JanusVisionConfig.depth",description:`<strong>depth</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
Number of hidden layers in the aligner module.`,name:"depth"},{anchor:"transformers.JanusVisionConfig.num_image_tokens",description:`<strong>num_image_tokens</strong> (<code>int</code>, <em>optional</em>, defaults to 576) &#x2014;
Number of image tokens.`,name:"num_image_tokens"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/janus/configuration_janus.py#L32"}}),xe=new A({props:{title:"JanusVQVAEConfig",local:"transformers.JanusVQVAEConfig",headingTag:"h2"}}),ze=new w({props:{name:"class transformers.JanusVQVAEConfig",anchor:"transformers.JanusVQVAEConfig",parameters:[{name:"embed_dim",val:": int = 8"},{name:"num_embeddings",val:": int = 16384"},{name:"double_latent",val:": bool = False"},{name:"latent_channels",val:": int = 256"},{name:"num_patches",val:": int = 32"},{name:"in_channels",val:": int = 3"},{name:"out_channels",val:": int = 3"},{name:"base_channels",val:": int = 128"},{name:"channel_multiplier",val:": typing.List[int] = [1, 1, 2, 2, 4]"},{name:"num_res_blocks",val:": int = 2"},{name:"dropout",val:": float = 0.0"},{name:"initializer_range",val:" = 0.02"},{name:"projection_dim",val:" = 2048"},{name:"num_hidden_layers",val:" = 2"},{name:"hidden_act",val:" = 'gelu'"},{name:"image_token_embed_dim",val:" = 2048"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.JanusVQVAEConfig.embed_dim",description:`<strong>embed_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Dimensionality of each embedding vector.`,name:"embed_dim"},{anchor:"transformers.JanusVQVAEConfig.num_embeddings",description:`<strong>num_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 16384) &#x2014;
Number of codebook embeddings.`,name:"num_embeddings"},{anchor:"transformers.JanusVQVAEConfig.double_latent",description:`<strong>double_latent</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use double z channels.`,name:"double_latent"},{anchor:"transformers.JanusVQVAEConfig.latent_channels",description:`<strong>latent_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Number of channels for the latent space.`,name:"latent_channels"},{anchor:"transformers.JanusVQVAEConfig.num_patches",description:`<strong>num_patches</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Num of patches the input images can be divided into.`,name:"num_patches"},{anchor:"transformers.JanusVQVAEConfig.in_channels",description:`<strong>in_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
Number of input channels.`,name:"in_channels"},{anchor:"transformers.JanusVQVAEConfig.out_channels",description:`<strong>out_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
Number of out channels.`,name:"out_channels"},{anchor:"transformers.JanusVQVAEConfig.base_channels",description:`<strong>base_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
Base channel count.`,name:"base_channels"},{anchor:"transformers.JanusVQVAEConfig.channel_multiplier",description:`<strong>channel_multiplier</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[1, 1, 2, 2, 4]</code>) &#x2014;
Channel multipliers for each resolution.`,name:"channel_multiplier"},{anchor:"transformers.JanusVQVAEConfig.num_res_blocks",description:`<strong>num_res_blocks</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
Number of residual blocks.`,name:"num_res_blocks"},{anchor:"transformers.JanusVQVAEConfig.dropout",description:`<strong>dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Dropout rate.`,name:"dropout"},{anchor:"transformers.JanusVQVAEConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.JanusVQVAEConfig.projection_dim",description:`<strong>projection_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Dimensionality of the MLP projection head.`,name:"projection_dim"},{anchor:"transformers.JanusVQVAEConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
Number of hidden layers in VAVAE MLP Connecter module.`,name:"num_hidden_layers"},{anchor:"transformers.JanusVQVAEConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>Callable</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;silu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.JanusVQVAEConfig.image_token_embed_dim",description:`<strong>image_token_embed_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Dimension of image embeddings. It should be same as the dimensionality of text embeddings.`,name:"image_token_embed_dim"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/janus/configuration_janus.py#L127"}}),Ae=new A({props:{title:"JanusProcessor",local:"transformers.JanusProcessor",headingTag:"h2"}}),Ze=new w({props:{name:"class transformers.JanusProcessor",anchor:"transformers.JanusProcessor",parameters:[{name:"image_processor",val:""},{name:"tokenizer",val:""},{name:"chat_template",val:" = None"},{name:"use_default_system_prompt",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.JanusProcessor.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/main/en/model_doc/janus#transformers.JanusImageProcessor">JanusImageProcessor</a>) &#x2014;
The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.JanusProcessor.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>) &#x2014;
The tokenizer is a required input.`,name:"tokenizer"},{anchor:"transformers.JanusProcessor.chat_template",description:`<strong>chat_template</strong> (<code>str</code>, <em>optional</em>) &#x2014; A Jinja template which will be used to convert lists of messages
in a chat into a tokenizable string.`,name:"chat_template"},{anchor:"transformers.JanusProcessor.use_default_system_prompt",description:`<strong>use_default_system_prompt</strong> (<code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Use default system prompt for Text Generation.`,name:"use_default_system_prompt"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/janus/processing_janus.py#L49"}}),Ve=new w({props:{name:"batch_decode",anchor:"transformers.JanusProcessor.batch_decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/janus/processing_janus.py#L156"}}),Be=new w({props:{name:"decode",anchor:"transformers.JanusProcessor.decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/janus/processing_janus.py#L163"}}),qe=new w({props:{name:"postprocess",anchor:"transformers.JanusProcessor.postprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']]"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/janus/processing_janus.py#L170"}}),We=new A({props:{title:"JanusImageProcessor",local:"transformers.JanusImageProcessor",headingTag:"h2"}}),Ee=new w({props:{name:"class transformers.JanusImageProcessor",anchor:"transformers.JanusImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"min_size",val:": int = 14"},{name:"resample",val:": Resampling = <Resampling.BICUBIC: 3>"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_convert_rgb",val:": typing.Optional[bool] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.JanusImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overridden by the
<code>do_resize</code> parameter in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.JanusImageProcessor.size",description:`<strong>size</strong> (<code>dict</code>, <em>optional</em>, defaults to <code>{&quot;height&quot; -- 384, &quot;width&quot;: 384}</code>):
Size of the output image after resizing. Can be overridden by the <code>size</code> parameter in the <code>preprocess</code>
method.`,name:"size"},{anchor:"transformers.JanusImageProcessor.min_size",description:`<strong>min_size</strong> (<code>int</code>, <em>optional</em>, defaults to 14) &#x2014;
The minimum allowed size for the resized image. Ensures that neither the height nor width
falls below this value after resizing.`,name:"min_size"},{anchor:"transformers.JanusImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>Resampling.BICUBIC</code>) &#x2014;
Resampling filter to use if resizing the image. Only has an effect if <code>do_resize</code> is set to <code>True</code>. Can be
overridden by the <code>resample</code> parameter in the <code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.JanusImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the
<code>do_rescale</code> parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.JanusImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Only has an effect if <code>do_rescale</code> is set to <code>True</code>. Can be
overridden by the <code>rescale_factor</code> parameter in the <code>preprocess</code> method.`,name:"rescale_factor"},{anchor:"transformers.JanusImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code>
method. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code> method.`,name:"do_normalize"},{anchor:"transformers.JanusImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_MEAN</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method. Can be
overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.JanusImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_STD</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.
Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.JanusImageProcessor.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/janus/image_processing_janus.py#L59"}}),Ne=new w({props:{name:"pad_to_square",anchor:"transformers.JanusImageProcessor.pad_to_square",parameters:[{name:"image",val:": ndarray"},{name:"background_color",val:": typing.Union[int, typing.Tuple[int, int, int]] = 0"},{name:"data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.JanusImageProcessor.pad_to_square.image",description:`<strong>image</strong> (<code>np.ndarray</code>) &#x2014;
The image to pad.`,name:"image"},{anchor:"transformers.JanusImageProcessor.pad_to_square.background_color",description:`<strong>background_color</strong> (<code>int</code> or <code>Tuple[int, int, int]</code>, <em>optional</em>, defaults to 0) &#x2014;
The color to use for the padding. Can be an integer for single channel or a
tuple of integers representing for multi-channel images. If passed as integer
in mutli-channel mode, it will default to <code>0</code> in subsequent channels.`,name:"background_color"},{anchor:"transformers.JanusImageProcessor.pad_to_square.data_format",description:`<strong>data_format</strong> (<code>str</code> or <code>ChannelDimension</code>, <em>optional</em>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.
If unset, will use same as the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.JanusImageProcessor.pad_to_square.input_data_format",description:`<strong>input_data_format</strong> (<code>str</code> or <code>ChannelDimension</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/janus/image_processing_janus.py#L338",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The padded image.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>np.ndarray</code></p>
`}}),Qe=new w({props:{name:"postprocess",anchor:"transformers.JanusImageProcessor.postprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']]"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Optional[float] = None"},{name:"do_normalize",val:": typing.Optional[bool] = None"},{name:"image_mean",val:": typing.Optional[typing.List[float]] = None"},{name:"image_std",val:": typing.Optional[typing.List[float]] = None"},{name:"input_data_format",val:": typing.Optional[str] = None"},{name:"return_tensors",val:": typing.Optional[str] = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/janus/image_processing_janus.py#L412"}}),Fe=new w({props:{name:"preprocess",anchor:"transformers.JanusImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']]"},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"resample",val:": Resampling = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Optional[float] = None"},{name:"do_normalize",val:": typing.Optional[bool] = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"do_convert_rgb",val:": typing.Optional[bool] = None"},{name:"data_format",val:": ChannelDimension = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.JanusImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.JanusImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.JanusImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Controls the size of the image after <code>resize</code>. The shortest edge of the image is resized to
<code>size[&quot;shortest_edge&quot;]</code> whilst preserving the aspect ratio. If the longest edge of this resized image
is &gt; <code>int(size[&quot;shortest_edge&quot;] * (1333 / 800))</code>, then the image is resized again to make the longest
edge equal to <code>int(size[&quot;shortest_edge&quot;] * (1333 / 800))</code>.`,name:"size"},{anchor:"transformers.JanusImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. Only has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.JanusImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image values between [0 - 1].`,name:"do_rescale"},{anchor:"transformers.JanusImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.JanusImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.JanusImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean to normalize the image by if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.JanusImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation to normalize the image by if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_std"},{anchor:"transformers.JanusImageProcessor.preprocess.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_convert_rgb</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.JanusImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.JanusImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.JanusImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/janus/image_processing_janus.py#L202"}}),Re=new w({props:{name:"resize",anchor:"transformers.JanusImageProcessor.resize",parameters:[{name:"image",val:": ndarray"},{name:"size",val:": typing.Union[typing.Dict[str, int], int]"},{name:"resample",val:": Resampling = <Resampling.BICUBIC: 3>"},{name:"data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.JanusImageProcessor.resize.image",description:`<strong>image</strong> (<code>np.ndarray</code>) &#x2014;
Image to resize.`,name:"image"},{anchor:"transformers.JanusImageProcessor.resize.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>PILImageResampling.BICUBIC</code>) &#x2014;
<code>PILImageResampling</code> filter to use when resizing the image e.g. <code>PILImageResampling.BICUBIC</code>.`,name:"resample"},{anchor:"transformers.JanusImageProcessor.resize.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the output image. If unset, the channel dimension format of the input
image is used. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>None</code>: will be inferred from input</li>
</ul>`,name:"data_format"},{anchor:"transformers.JanusImageProcessor.resize.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/janus/image_processing_janus.py#L133",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The resized image.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>np.ndarray</code></p>
`}}),Pe=new w({props:{name:"unnormalize",anchor:"transformers.JanusImageProcessor.unnormalize",parameters:[{name:"image",val:": <built-in function array>"},{name:"image_mean",val:": typing.Union[float, collections.abc.Iterable[float]]"},{name:"image_std",val:": typing.Union[float, collections.abc.Iterable[float]]"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.JanusImageProcessor.unnormalize.image",description:`<strong>image</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code> or <code>(num_channels, image_size, image_size)</code>) &#x2014;
Batch of pixel values to postprocess.`,name:"image"},{anchor:"transformers.JanusImageProcessor.unnormalize.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>Iterable[float]</code>) &#x2014;
The mean to use for unnormalization.`,name:"image_mean"},{anchor:"transformers.JanusImageProcessor.unnormalize.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>Iterable[float]</code>) &#x2014;
The standard deviation to use for unnormalization.`,name:"image_std"},{anchor:"transformers.JanusImageProcessor.unnormalize.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/janus/image_processing_janus.py#L463"}}),Ge=new A({props:{title:"JanusVisionModel",local:"transformers.JanusVisionModel",headingTag:"h2"}}),Le=new w({props:{name:"class transformers.JanusVisionModel",anchor:"transformers.JanusVisionModel",parameters:[{name:"config",val:": JanusVisionConfig"}],parametersDescription:[{anchor:"transformers.JanusVisionModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/janus#transformers.JanusVisionConfig">JanusVisionConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/janus/modeling_janus.py#L532"}}),He=new w({props:{name:"forward",anchor:"transformers.JanusVisionModel.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"interpolate_pos_encoding",val:": bool = False"}],parametersDescription:[{anchor:"transformers.JanusVisionModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>, <em>optional</em>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.JanusVisionModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.JanusVisionModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.JanusVisionModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.JanusVisionModel.forward.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/janus/modeling_janus.py#L548",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/janus#transformers.JanusConfig"
>JanusConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state of the first token of the sequence (classification token) after further processing
through the layers used for the auxiliary pretraining task. E.g. for BERT-family of models, this returns
the classification token after processing through a linear layer and a tanh activation function. The linear
layer weights are trained from the next sentence prediction (classification) objective during pretraining.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),oe=new Bt({props:{$$slots:{default:[Cs]},$$scope:{ctx:Z}}}),Se=new A({props:{title:"JanusVQVAE",local:"transformers.JanusVQVAE",headingTag:"h2"}}),Xe=new w({props:{name:"class transformers.JanusVQVAE",anchor:"transformers.JanusVQVAE",parameters:[{name:"config",val:": JanusVQVAEConfig"}],parametersDescription:[{anchor:"transformers.JanusVQVAE.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/janus#transformers.JanusVQVAEConfig">JanusVQVAEConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/janus/modeling_janus.py#L945"}}),De=new w({props:{name:"forward",anchor:"transformers.JanusVQVAE.forward",parameters:[{name:"pixel_values",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.JanusVQVAE.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/janus/modeling_janus.py#L1000",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Tuple[torch.FloatTensor, torch.FloatTensor]</code></p>
`}}),se=new Bt({props:{$$slots:{default:[Is]},$$scope:{ctx:Z}}}),Ye=new A({props:{title:"JanusModel",local:"transformers.JanusModel",headingTag:"h2"}}),Oe=new w({props:{name:"class transformers.JanusModel",anchor:"transformers.JanusModel",parameters:[{name:"config",val:": JanusConfig"}],parametersDescription:[{anchor:"transformers.JanusModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/janus#transformers.JanusConfig">JanusConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/janus/modeling_janus.py#L1048"}}),Ke=new w({props:{name:"forward",anchor:"transformers.JanusModel.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"pixel_values",val:": FloatTensor = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[transformers.cache_utils.Cache] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"logits_to_keep",val:": typing.Union[int, torch.Tensor] = 0"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.JanusModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.JanusModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.JanusModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.JanusModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.JanusModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>~cache_utils.Cache</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.JanusModel.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"},{anchor:"transformers.JanusModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.JanusModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.JanusModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.JanusModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.JanusModel.forward.logits_to_keep",description:`<strong>logits_to_keep</strong> (<code>Union[int, torch.Tensor]</code>, defaults to <code>0</code>) &#x2014;
If an <code>int</code>, compute logits for the last <code>logits_to_keep</code> tokens. If <code>0</code>, calculate logits for all
<code>input_ids</code> (special case). Only last token logits are needed for generation, and calculating them only for that
token can save memory, which becomes pretty significant for long sequences or large vocabulary size.
If a <code>torch.Tensor</code>, must be 1D corresponding to the indices to keep in the sequence length dimension.
This is useful when using packed tensor format (single dimension for batch and sequence length).`,name:"logits_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/janus/modeling_janus.py#L1086"}}),ae=new Bt({props:{$$slots:{default:[$s]},$$scope:{ctx:Z}}}),en=new A({props:{title:"JanusForConditionalGeneration",local:"transformers.JanusForConditionalGeneration",headingTag:"h2"}}),nn=new w({props:{name:"class transformers.JanusForConditionalGeneration",anchor:"transformers.JanusForConditionalGeneration",parameters:[{name:"config",val:": JanusConfig"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/janus/modeling_janus.py#L1164"}}),tn=new w({props:{name:"forward",anchor:"transformers.JanusForConditionalGeneration.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"pixel_values",val:": FloatTensor = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[transformers.cache_utils.Cache] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"logits_to_keep",val:": typing.Union[int, torch.Tensor] = 0"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.JanusForConditionalGeneration.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.JanusForConditionalGeneration.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.JanusForConditionalGeneration.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.JanusForConditionalGeneration.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.JanusForConditionalGeneration.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>~cache_utils.Cache</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.JanusForConditionalGeneration.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"},{anchor:"transformers.JanusForConditionalGeneration.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.JanusForConditionalGeneration.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"labels"},{anchor:"transformers.JanusForConditionalGeneration.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.JanusForConditionalGeneration.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.JanusForConditionalGeneration.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.JanusForConditionalGeneration.forward.logits_to_keep",description:`<strong>logits_to_keep</strong> (<code>Union[int, torch.Tensor]</code>, defaults to <code>0</code>) &#x2014;
If an <code>int</code>, compute logits for the last <code>logits_to_keep</code> tokens. If <code>0</code>, calculate logits for all
<code>input_ids</code> (special case). Only last token logits are needed for generation, and calculating them only for that
token can save memory, which becomes pretty significant for long sequences or large vocabulary size.
If a <code>torch.Tensor</code>, must be 1D corresponding to the indices to keep in the sequence length dimension.
This is useful when using packed tensor format (single dimension for batch and sequence length).`,name:"logits_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/janus/modeling_janus.py#L1200"}}),re=new Bt({props:{$$slots:{default:[ks]},$$scope:{ctx:Z}}}),ie=new ys({props:{anchor:"transformers.JanusForConditionalGeneration.forward.example",$$slots:{default:[xs]},$$scope:{ctx:Z}}}),on=new Us({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/janus.md"}}),{c(){d=r("meta"),b=s(),M=r("p"),y=s(),c(U.$$.fragment),_=s(),c(C.$$.fragment),Pn=s(),de=r("p"),de.innerHTML=zo,Gn=s(),ce=r("blockquote"),ce.innerHTML=Ao,Ln=s(),me=r("p"),me.textContent=Zo,Hn=s(),pe=r("p"),pe.innerHTML=Vo,Sn=s(),ue=r("p"),ue.innerHTML=Bo,Xn=s(),ge=r("p"),ge.innerHTML=qo,Dn=s(),he=r("p"),he.innerHTML=Wo,Yn=s(),c(fe.$$.fragment),On=s(),c(Me.$$.fragment),Kn=s(),_e=r("p"),_e.textContent=Eo,et=s(),ye=r("blockquote"),ye.innerHTML=No,nt=s(),c(Je.$$.fragment),tt=s(),c(Te.$$.fragment),ot=s(),be=r("p"),be.textContent=Qo,st=s(),c(we.$$.fragment),at=s(),c(je.$$.fragment),rt=s(),Ue=r("p"),Ue.textContent=Fo,it=s(),c(ve.$$.fragment),lt=s(),c(Ce.$$.fragment),dt=s(),I=r("div"),c(Ie.$$.fragment),qt=s(),ln=r("p"),ln.innerHTML=Ro,Wt=s(),dn=r("p"),dn.innerHTML=Po,Et=s(),cn=r("p"),cn.innerHTML=Go,Nt=s(),c(S.$$.fragment),ct=s(),c($e.$$.fragment),mt=s(),W=r("div"),c(ke.$$.fragment),Qt=s(),mn=r("p"),mn.innerHTML=Lo,Ft=s(),pn=r("p"),pn.innerHTML=Ho,pt=s(),c(xe.$$.fragment),ut=s(),G=r("div"),c(ze.$$.fragment),Rt=s(),un=r("p"),un.innerHTML=So,gt=s(),c(Ae.$$.fragment),ht=s(),v=r("div"),c(Ze.$$.fragment),Pt=s(),gn=r("p"),gn.textContent=Xo,Gt=s(),hn=r("p"),hn.innerHTML=Do,Lt=s(),X=r("div"),c(Ve.$$.fragment),Ht=s(),fn=r("p"),fn.innerHTML=Yo,St=s(),D=r("div"),c(Be.$$.fragment),Xt=s(),Mn=r("p"),Mn.innerHTML=Oo,Dt=s(),Y=r("div"),c(qe.$$.fragment),Yt=s(),_n=r("p"),_n.innerHTML=Ko,ft=s(),c(We.$$.fragment),Mt=s(),j=r("div"),c(Ee.$$.fragment),Ot=s(),yn=r("p"),yn.textContent=es,Kt=s(),O=r("div"),c(Ne.$$.fragment),eo=s(),Jn=r("p"),Jn.textContent=ns,no=s(),K=r("div"),c(Qe.$$.fragment),to=s(),Tn=r("p"),Tn.textContent=ts,oo=s(),ee=r("div"),c(Fe.$$.fragment),so=s(),bn=r("p"),bn.textContent=os,ao=s(),ne=r("div"),c(Re.$$.fragment),ro=s(),wn=r("p"),wn.textContent=ss,io=s(),te=r("div"),c(Pe.$$.fragment),lo=s(),jn=r("p"),jn.innerHTML=as,_t=s(),c(Ge.$$.fragment),yt=s(),$=r("div"),c(Le.$$.fragment),co=s(),Un=r("p"),Un.textContent=rs,mo=s(),vn=r("p"),vn.innerHTML=is,po=s(),Cn=r("p"),Cn.innerHTML=ls,uo=s(),E=r("div"),c(He.$$.fragment),go=s(),In=r("p"),In.innerHTML=ds,ho=s(),c(oe.$$.fragment),Jt=s(),c(Se.$$.fragment),Tt=s(),k=r("div"),c(Xe.$$.fragment),fo=s(),$n=r("p"),$n.innerHTML=cs,Mo=s(),kn=r("p"),kn.innerHTML=ms,_o=s(),xn=r("p"),xn.innerHTML=ps,yo=s(),N=r("div"),c(De.$$.fragment),Jo=s(),zn=r("p"),zn.innerHTML=us,To=s(),c(se.$$.fragment),bt=s(),c(Ye.$$.fragment),wt=s(),x=r("div"),c(Oe.$$.fragment),bo=s(),An=r("p"),An.textContent=gs,wo=s(),Zn=r("p"),Zn.innerHTML=hs,jo=s(),Vn=r("p"),Vn.innerHTML=fs,Uo=s(),Q=r("div"),c(Ke.$$.fragment),vo=s(),Bn=r("p"),Bn.innerHTML=Ms,Co=s(),c(ae.$$.fragment),jt=s(),c(en.$$.fragment),Ut=s(),L=r("div"),c(nn.$$.fragment),Io=s(),q=r("div"),c(tn.$$.fragment),$o=s(),qn=r("p"),qn.innerHTML=_s,ko=s(),c(re.$$.fragment),xo=s(),c(ie.$$.fragment),vt=s(),c(on.$$.fragment),Ct=s(),Fn=r("p"),this.h()},l(e){const n=js("svelte-u9bgzb",document.head);d=i(n,"META",{name:!0,content:!0}),n.forEach(t),b=a(e),M=i(e,"P",{}),J(M).forEach(t),y=a(e),m(U.$$.fragment,e),_=a(e),m(C.$$.fragment,e),Pn=a(e),de=i(e,"P",{"data-svelte-h":!0}),f(de)!=="svelte-1lzrasd"&&(de.innerHTML=zo),Gn=a(e),ce=i(e,"BLOCKQUOTE",{"data-svelte-h":!0}),f(ce)!=="svelte-1x4u6cq"&&(ce.innerHTML=Ao),Ln=a(e),me=i(e,"P",{"data-svelte-h":!0}),f(me)!=="svelte-177aco3"&&(me.textContent=Zo),Hn=a(e),pe=i(e,"P",{"data-svelte-h":!0}),f(pe)!=="svelte-jhuj19"&&(pe.innerHTML=Vo),Sn=a(e),ue=i(e,"P",{"data-svelte-h":!0}),f(ue)!=="svelte-1vgoitc"&&(ue.innerHTML=Bo),Xn=a(e),ge=i(e,"P",{"data-svelte-h":!0}),f(ge)!=="svelte-49qhap"&&(ge.innerHTML=qo),Dn=a(e),he=i(e,"P",{"data-svelte-h":!0}),f(he)!=="svelte-5svxst"&&(he.innerHTML=Wo),Yn=a(e),m(fe.$$.fragment,e),On=a(e),m(Me.$$.fragment,e),Kn=a(e),_e=i(e,"P",{"data-svelte-h":!0}),f(_e)!=="svelte-8gjb1g"&&(_e.textContent=Eo),et=a(e),ye=i(e,"BLOCKQUOTE",{"data-svelte-h":!0}),f(ye)!=="svelte-jn2bty"&&(ye.innerHTML=No),nt=a(e),m(Je.$$.fragment,e),tt=a(e),m(Te.$$.fragment,e),ot=a(e),be=i(e,"P",{"data-svelte-h":!0}),f(be)!=="svelte-1d12bbh"&&(be.textContent=Qo),st=a(e),m(we.$$.fragment,e),at=a(e),m(je.$$.fragment,e),rt=a(e),Ue=i(e,"P",{"data-svelte-h":!0}),f(Ue)!=="svelte-1qde7m1"&&(Ue.textContent=Fo),it=a(e),m(ve.$$.fragment,e),lt=a(e),m(Ce.$$.fragment,e),dt=a(e),I=i(e,"DIV",{class:!0});var B=J(I);m(Ie.$$.fragment,B),qt=a(B),ln=i(B,"P",{"data-svelte-h":!0}),f(ln)!=="svelte-ay00fu"&&(ln.innerHTML=Ro),Wt=a(B),dn=i(B,"P",{"data-svelte-h":!0}),f(dn)!=="svelte-wbmgyb"&&(dn.innerHTML=Po),Et=a(B),cn=i(B,"P",{"data-svelte-h":!0}),f(cn)!=="svelte-o55m63"&&(cn.innerHTML=Go),Nt=a(B),m(S.$$.fragment,B),B.forEach(t),ct=a(e),m($e.$$.fragment,e),mt=a(e),W=i(e,"DIV",{class:!0});var H=J(W);m(ke.$$.fragment,H),Qt=a(H),mn=i(H,"P",{"data-svelte-h":!0}),f(mn)!=="svelte-1wwjspi"&&(mn.innerHTML=Lo),Ft=a(H),pn=i(H,"P",{"data-svelte-h":!0}),f(pn)!=="svelte-o55m63"&&(pn.innerHTML=Ho),H.forEach(t),pt=a(e),m(xe.$$.fragment,e),ut=a(e),G=i(e,"DIV",{class:!0});var sn=J(G);m(ze.$$.fragment,sn),Rt=a(sn),un=i(sn,"P",{"data-svelte-h":!0}),f(un)!=="svelte-vfmm9d"&&(un.innerHTML=So),sn.forEach(t),gt=a(e),m(Ae.$$.fragment,e),ht=a(e),v=i(e,"DIV",{class:!0});var z=J(v);m(Ze.$$.fragment,z),Pt=a(z),gn=i(z,"P",{"data-svelte-h":!0}),f(gn)!=="svelte-c68n8g"&&(gn.textContent=Xo),Gt=a(z),hn=i(z,"P",{"data-svelte-h":!0}),f(hn)!=="svelte-3dhuj3"&&(hn.innerHTML=Do),Lt=a(z),X=i(z,"DIV",{class:!0});var an=J(X);m(Ve.$$.fragment,an),Ht=a(an),fn=i(an,"P",{"data-svelte-h":!0}),f(fn)!=="svelte-1o9eza"&&(fn.innerHTML=Yo),an.forEach(t),St=a(z),D=i(z,"DIV",{class:!0});var rn=J(D);m(Be.$$.fragment,rn),Xt=a(rn),Mn=i(rn,"P",{"data-svelte-h":!0}),f(Mn)!=="svelte-kk16qw"&&(Mn.innerHTML=Oo),rn.forEach(t),Dt=a(z),Y=i(z,"DIV",{class:!0});var $t=J(Y);m(qe.$$.fragment,$t),Yt=a($t),_n=i($t,"P",{"data-svelte-h":!0}),f(_n)!=="svelte-1l9zllg"&&(_n.innerHTML=Ko),$t.forEach(t),z.forEach(t),ft=a(e),m(We.$$.fragment,e),Mt=a(e),j=i(e,"DIV",{class:!0});var V=J(j);m(Ee.$$.fragment,V),Ot=a(V),yn=i(V,"P",{"data-svelte-h":!0}),f(yn)!=="svelte-1aahezl"&&(yn.textContent=es),Kt=a(V),O=i(V,"DIV",{class:!0});var kt=J(O);m(Ne.$$.fragment,kt),eo=a(kt),Jn=i(kt,"P",{"data-svelte-h":!0}),f(Jn)!=="svelte-9psyrp"&&(Jn.textContent=ns),kt.forEach(t),no=a(V),K=i(V,"DIV",{class:!0});var xt=J(K);m(Qe.$$.fragment,xt),to=a(xt),Tn=i(xt,"P",{"data-svelte-h":!0}),f(Tn)!=="svelte-19uby4j"&&(Tn.textContent=ts),xt.forEach(t),oo=a(V),ee=i(V,"DIV",{class:!0});var zt=J(ee);m(Fe.$$.fragment,zt),so=a(zt),bn=i(zt,"P",{"data-svelte-h":!0}),f(bn)!=="svelte-1x3yxsa"&&(bn.textContent=os),zt.forEach(t),ao=a(V),ne=i(V,"DIV",{class:!0});var At=J(ne);m(Re.$$.fragment,At),ro=a(At),wn=i(At,"P",{"data-svelte-h":!0}),f(wn)!=="svelte-uoznpt"&&(wn.textContent=ss),At.forEach(t),io=a(V),te=i(V,"DIV",{class:!0});var Zt=J(te);m(Pe.$$.fragment,Zt),lo=a(Zt),jn=i(Zt,"P",{"data-svelte-h":!0}),f(jn)!=="svelte-1x9mhw3"&&(jn.innerHTML=as),Zt.forEach(t),V.forEach(t),_t=a(e),m(Ge.$$.fragment,e),yt=a(e),$=i(e,"DIV",{class:!0});var F=J($);m(Le.$$.fragment,F),co=a(F),Un=i(F,"P",{"data-svelte-h":!0}),f(Un)!=="svelte-1r45011"&&(Un.textContent=rs),mo=a(F),vn=i(F,"P",{"data-svelte-h":!0}),f(vn)!=="svelte-6pahdo"&&(vn.innerHTML=is),po=a(F),Cn=i(F,"P",{"data-svelte-h":!0}),f(Cn)!=="svelte-hswkmf"&&(Cn.innerHTML=ls),uo=a(F),E=i(F,"DIV",{class:!0});var Wn=J(E);m(He.$$.fragment,Wn),go=a(Wn),In=i(Wn,"P",{"data-svelte-h":!0}),f(In)!=="svelte-bkcw8e"&&(In.innerHTML=ds),ho=a(Wn),m(oe.$$.fragment,Wn),Wn.forEach(t),F.forEach(t),Jt=a(e),m(Se.$$.fragment,e),Tt=a(e),k=i(e,"DIV",{class:!0});var R=J(k);m(Xe.$$.fragment,R),fo=a(R),$n=i(R,"P",{"data-svelte-h":!0}),f($n)!=="svelte-11t66ri"&&($n.innerHTML=cs),Mo=a(R),kn=i(R,"P",{"data-svelte-h":!0}),f(kn)!=="svelte-6pahdo"&&(kn.innerHTML=ms),_o=a(R),xn=i(R,"P",{"data-svelte-h":!0}),f(xn)!=="svelte-hswkmf"&&(xn.innerHTML=ps),yo=a(R),N=i(R,"DIV",{class:!0});var En=J(N);m(De.$$.fragment,En),Jo=a(En),zn=i(En,"P",{"data-svelte-h":!0}),f(zn)!=="svelte-117c42a"&&(zn.innerHTML=us),To=a(En),m(se.$$.fragment,En),En.forEach(t),R.forEach(t),bt=a(e),m(Ye.$$.fragment,e),wt=a(e),x=i(e,"DIV",{class:!0});var P=J(x);m(Oe.$$.fragment,P),bo=a(P),An=i(P,"P",{"data-svelte-h":!0}),f(An)!=="svelte-8k58lq"&&(An.textContent=gs),wo=a(P),Zn=i(P,"P",{"data-svelte-h":!0}),f(Zn)!=="svelte-6pahdo"&&(Zn.innerHTML=hs),jo=a(P),Vn=i(P,"P",{"data-svelte-h":!0}),f(Vn)!=="svelte-hswkmf"&&(Vn.innerHTML=fs),Uo=a(P),Q=i(P,"DIV",{class:!0});var Nn=J(Q);m(Ke.$$.fragment,Nn),vo=a(Nn),Bn=i(Nn,"P",{"data-svelte-h":!0}),f(Bn)!=="svelte-176e4ba"&&(Bn.innerHTML=Ms),Co=a(Nn),m(ae.$$.fragment,Nn),Nn.forEach(t),P.forEach(t),jt=a(e),m(en.$$.fragment,e),Ut=a(e),L=i(e,"DIV",{class:!0});var Vt=J(L);m(nn.$$.fragment,Vt),Io=a(Vt),q=i(Vt,"DIV",{class:!0});var le=J(q);m(tn.$$.fragment,le),$o=a(le),qn=i(le,"P",{"data-svelte-h":!0}),f(qn)!=="svelte-qizvwy"&&(qn.innerHTML=_s),ko=a(le),m(re.$$.fragment,le),xo=a(le),m(ie.$$.fragment,le),le.forEach(t),Vt.forEach(t),vt=a(e),m(on.$$.fragment,e),Ct=a(e),Fn=i(e,"P",{}),J(Fn).forEach(t),this.h()},h(){T(d,"name","hf:doc:metadata"),T(d,"content",As),T(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,n){o(document.head,d),l(e,b,n),l(e,M,n),l(e,y,n),p(U,e,n),l(e,_,n),p(C,e,n),l(e,Pn,n),l(e,de,n),l(e,Gn,n),l(e,ce,n),l(e,Ln,n),l(e,me,n),l(e,Hn,n),l(e,pe,n),l(e,Sn,n),l(e,ue,n),l(e,Xn,n),l(e,ge,n),l(e,Dn,n),l(e,he,n),l(e,Yn,n),p(fe,e,n),l(e,On,n),p(Me,e,n),l(e,Kn,n),l(e,_e,n),l(e,et,n),l(e,ye,n),l(e,nt,n),p(Je,e,n),l(e,tt,n),p(Te,e,n),l(e,ot,n),l(e,be,n),l(e,st,n),p(we,e,n),l(e,at,n),p(je,e,n),l(e,rt,n),l(e,Ue,n),l(e,it,n),p(ve,e,n),l(e,lt,n),p(Ce,e,n),l(e,dt,n),l(e,I,n),p(Ie,I,null),o(I,qt),o(I,ln),o(I,Wt),o(I,dn),o(I,Et),o(I,cn),o(I,Nt),p(S,I,null),l(e,ct,n),p($e,e,n),l(e,mt,n),l(e,W,n),p(ke,W,null),o(W,Qt),o(W,mn),o(W,Ft),o(W,pn),l(e,pt,n),p(xe,e,n),l(e,ut,n),l(e,G,n),p(ze,G,null),o(G,Rt),o(G,un),l(e,gt,n),p(Ae,e,n),l(e,ht,n),l(e,v,n),p(Ze,v,null),o(v,Pt),o(v,gn),o(v,Gt),o(v,hn),o(v,Lt),o(v,X),p(Ve,X,null),o(X,Ht),o(X,fn),o(v,St),o(v,D),p(Be,D,null),o(D,Xt),o(D,Mn),o(v,Dt),o(v,Y),p(qe,Y,null),o(Y,Yt),o(Y,_n),l(e,ft,n),p(We,e,n),l(e,Mt,n),l(e,j,n),p(Ee,j,null),o(j,Ot),o(j,yn),o(j,Kt),o(j,O),p(Ne,O,null),o(O,eo),o(O,Jn),o(j,no),o(j,K),p(Qe,K,null),o(K,to),o(K,Tn),o(j,oo),o(j,ee),p(Fe,ee,null),o(ee,so),o(ee,bn),o(j,ao),o(j,ne),p(Re,ne,null),o(ne,ro),o(ne,wn),o(j,io),o(j,te),p(Pe,te,null),o(te,lo),o(te,jn),l(e,_t,n),p(Ge,e,n),l(e,yt,n),l(e,$,n),p(Le,$,null),o($,co),o($,Un),o($,mo),o($,vn),o($,po),o($,Cn),o($,uo),o($,E),p(He,E,null),o(E,go),o(E,In),o(E,ho),p(oe,E,null),l(e,Jt,n),p(Se,e,n),l(e,Tt,n),l(e,k,n),p(Xe,k,null),o(k,fo),o(k,$n),o(k,Mo),o(k,kn),o(k,_o),o(k,xn),o(k,yo),o(k,N),p(De,N,null),o(N,Jo),o(N,zn),o(N,To),p(se,N,null),l(e,bt,n),p(Ye,e,n),l(e,wt,n),l(e,x,n),p(Oe,x,null),o(x,bo),o(x,An),o(x,wo),o(x,Zn),o(x,jo),o(x,Vn),o(x,Uo),o(x,Q),p(Ke,Q,null),o(Q,vo),o(Q,Bn),o(Q,Co),p(ae,Q,null),l(e,jt,n),p(en,e,n),l(e,Ut,n),l(e,L,n),p(nn,L,null),o(L,Io),o(L,q),p(tn,q,null),o(q,$o),o(q,qn),o(q,ko),p(re,q,null),o(q,xo),p(ie,q,null),l(e,vt,n),p(on,e,n),l(e,Ct,n),l(e,Fn,n),It=!0},p(e,[n]){const B={};n&2&&(B.$$scope={dirty:n,ctx:e}),S.$set(B);const H={};n&2&&(H.$$scope={dirty:n,ctx:e}),oe.$set(H);const sn={};n&2&&(sn.$$scope={dirty:n,ctx:e}),se.$set(sn);const z={};n&2&&(z.$$scope={dirty:n,ctx:e}),ae.$set(z);const an={};n&2&&(an.$$scope={dirty:n,ctx:e}),re.$set(an);const rn={};n&2&&(rn.$$scope={dirty:n,ctx:e}),ie.$set(rn)},i(e){It||(u(U.$$.fragment,e),u(C.$$.fragment,e),u(fe.$$.fragment,e),u(Me.$$.fragment,e),u(Je.$$.fragment,e),u(Te.$$.fragment,e),u(we.$$.fragment,e),u(je.$$.fragment,e),u(ve.$$.fragment,e),u(Ce.$$.fragment,e),u(Ie.$$.fragment,e),u(S.$$.fragment,e),u($e.$$.fragment,e),u(ke.$$.fragment,e),u(xe.$$.fragment,e),u(ze.$$.fragment,e),u(Ae.$$.fragment,e),u(Ze.$$.fragment,e),u(Ve.$$.fragment,e),u(Be.$$.fragment,e),u(qe.$$.fragment,e),u(We.$$.fragment,e),u(Ee.$$.fragment,e),u(Ne.$$.fragment,e),u(Qe.$$.fragment,e),u(Fe.$$.fragment,e),u(Re.$$.fragment,e),u(Pe.$$.fragment,e),u(Ge.$$.fragment,e),u(Le.$$.fragment,e),u(He.$$.fragment,e),u(oe.$$.fragment,e),u(Se.$$.fragment,e),u(Xe.$$.fragment,e),u(De.$$.fragment,e),u(se.$$.fragment,e),u(Ye.$$.fragment,e),u(Oe.$$.fragment,e),u(Ke.$$.fragment,e),u(ae.$$.fragment,e),u(en.$$.fragment,e),u(nn.$$.fragment,e),u(tn.$$.fragment,e),u(re.$$.fragment,e),u(ie.$$.fragment,e),u(on.$$.fragment,e),It=!0)},o(e){g(U.$$.fragment,e),g(C.$$.fragment,e),g(fe.$$.fragment,e),g(Me.$$.fragment,e),g(Je.$$.fragment,e),g(Te.$$.fragment,e),g(we.$$.fragment,e),g(je.$$.fragment,e),g(ve.$$.fragment,e),g(Ce.$$.fragment,e),g(Ie.$$.fragment,e),g(S.$$.fragment,e),g($e.$$.fragment,e),g(ke.$$.fragment,e),g(xe.$$.fragment,e),g(ze.$$.fragment,e),g(Ae.$$.fragment,e),g(Ze.$$.fragment,e),g(Ve.$$.fragment,e),g(Be.$$.fragment,e),g(qe.$$.fragment,e),g(We.$$.fragment,e),g(Ee.$$.fragment,e),g(Ne.$$.fragment,e),g(Qe.$$.fragment,e),g(Fe.$$.fragment,e),g(Re.$$.fragment,e),g(Pe.$$.fragment,e),g(Ge.$$.fragment,e),g(Le.$$.fragment,e),g(He.$$.fragment,e),g(oe.$$.fragment,e),g(Se.$$.fragment,e),g(Xe.$$.fragment,e),g(De.$$.fragment,e),g(se.$$.fragment,e),g(Ye.$$.fragment,e),g(Oe.$$.fragment,e),g(Ke.$$.fragment,e),g(ae.$$.fragment,e),g(en.$$.fragment,e),g(nn.$$.fragment,e),g(tn.$$.fragment,e),g(re.$$.fragment,e),g(ie.$$.fragment,e),g(on.$$.fragment,e),It=!1},d(e){e&&(t(b),t(M),t(y),t(_),t(Pn),t(de),t(Gn),t(ce),t(Ln),t(me),t(Hn),t(pe),t(Sn),t(ue),t(Xn),t(ge),t(Dn),t(he),t(Yn),t(On),t(Kn),t(_e),t(et),t(ye),t(nt),t(tt),t(ot),t(be),t(st),t(at),t(rt),t(Ue),t(it),t(lt),t(dt),t(I),t(ct),t(mt),t(W),t(pt),t(ut),t(G),t(gt),t(ht),t(v),t(ft),t(Mt),t(j),t(_t),t(yt),t($),t(Jt),t(Tt),t(k),t(bt),t(wt),t(x),t(jt),t(Ut),t(L),t(vt),t(Ct),t(Fn)),t(d),h(U,e),h(C,e),h(fe,e),h(Me,e),h(Je,e),h(Te,e),h(we,e),h(je,e),h(ve,e),h(Ce,e),h(Ie),h(S),h($e,e),h(ke),h(xe,e),h(ze),h(Ae,e),h(Ze),h(Ve),h(Be),h(qe),h(We,e),h(Ee),h(Ne),h(Qe),h(Fe),h(Re),h(Pe),h(Ge,e),h(Le),h(He),h(oe),h(Se,e),h(Xe),h(De),h(se),h(Ye,e),h(Oe),h(Ke),h(ae),h(en,e),h(nn),h(tn),h(re),h(ie),h(on,e)}}}const As='{"title":"Janus","local":"janus","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage Example","local":"usage-example","sections":[{"title":"Single image inference","local":"single-image-inference","sections":[],"depth":3},{"title":"Multi image inference","local":"multi-image-inference","sections":[],"depth":3}],"depth":2},{"title":"Text to Image generation","local":"text-to-image-generation","sections":[],"depth":2},{"title":"JanusConfig","local":"transformers.JanusConfig","sections":[],"depth":2},{"title":"JanusVisionConfig","local":"transformers.JanusVisionConfig","sections":[],"depth":2},{"title":"JanusVQVAEConfig","local":"transformers.JanusVQVAEConfig","sections":[],"depth":2},{"title":"JanusProcessor","local":"transformers.JanusProcessor","sections":[],"depth":2},{"title":"JanusImageProcessor","local":"transformers.JanusImageProcessor","sections":[],"depth":2},{"title":"JanusVisionModel","local":"transformers.JanusVisionModel","sections":[],"depth":2},{"title":"JanusVQVAE","local":"transformers.JanusVQVAE","sections":[],"depth":2},{"title":"JanusModel","local":"transformers.JanusModel","sections":[],"depth":2},{"title":"JanusForConditionalGeneration","local":"transformers.JanusForConditionalGeneration","sections":[],"depth":2}],"depth":1}';function Zs(Z){return Ts(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Rs extends bs{constructor(d){super(),ws(this,d,Zs,zs,Js,{})}}export{Rs as component};
