import{s as zt,o as Ft,n as ce}from"../chunks/scheduler.18a86fab.js";import{S as Ut,i as qt,g as p,s as r,r as h,A as Zt,h as m,f as a,c as i,j as S,u as f,x as y,k as I,y as l,a as d,v as g,d as _,t as b,w as M}from"../chunks/index.98837b22.js";import{T as mt}from"../chunks/Tip.77304350.js";import{D as le}from"../chunks/Docstring.6758ea23.js";import{C as Ee}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as Ne}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as ke}from"../chunks/Heading.7e7e0c5b.js";import{E as It}from"../chunks/getInferenceSnippets.de10bc7d.js";function Wt(J){let t,u;return t=new Ee({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEpldE1vZU1vZGVsJTJDJTIwSmV0TW9lQ29uZmlnJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMEpldE1vZSUyMDRCJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMEpldE1vZUNvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwZnJvbSUyMHRoZSUyMEpldE1vZSUyMDRCJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBKZXRNb2VNb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> JetMoeModel, JetMoeConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a JetMoe 4B style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = JetMoeConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the JetMoe 4B style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = JetMoeModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){h(t.$$.fragment)},l(s){f(t.$$.fragment,s)},m(s,c){g(t,s,c),u=!0},p:ce,i(s){u||(_(t.$$.fragment,s),u=!0)},o(s){b(t.$$.fragment,s),u=!1},d(s){M(t,s)}}}function Lt(J){let t,u=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=p("p"),t.innerHTML=u},l(s){t=m(s,"P",{"data-svelte-h":!0}),y(t)!=="svelte-fincs2"&&(t.innerHTML=u)},m(s,c){d(s,t,c)},p:ce,d(s){s&&a(t)}}}function St(J){let t,u=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=p("p"),t.innerHTML=u},l(s){t=m(s,"P",{"data-svelte-h":!0}),y(t)!=="svelte-fincs2"&&(t.innerHTML=u)},m(s,c){d(s,t,c)},p:ce,d(s){s&&a(t)}}}function Gt(J){let t,u="Example:",s,c,T;return c=new Ee({props:{code:"",highlighted:"",wrap:!1}}),{c(){t=p("p"),t.textContent=u,s=r(),h(c.$$.fragment)},l(n){t=m(n,"P",{"data-svelte-h":!0}),y(t)!=="svelte-11lpom8"&&(t.textContent=u),s=i(n),f(c.$$.fragment,n)},m(n,v){d(n,t,v),d(n,s,v),g(c,n,v),T=!0},p:ce,i(n){T||(_(c.$$.fragment,n),T=!0)},o(n){b(c.$$.fragment,n),T=!1},d(n){n&&(a(t),a(s)),M(c,n)}}}function Nt(J){let t,u=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=p("p"),t.innerHTML=u},l(s){t=m(s,"P",{"data-svelte-h":!0}),y(t)!=="svelte-fincs2"&&(t.innerHTML=u)},m(s,c){d(s,t,c)},p:ce,d(s){s&&a(t)}}}function Et(J){let t,u="Example of single-label classification:",s,c,T;return c=new Ee({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEpldE1vZUZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJqZXRtb2UlMkZqZXRtb2UtOGIlMjIpJTBBbW9kZWwlMjAlM0QlMjBKZXRNb2VGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJqZXRtb2UlMkZqZXRtb2UtOGIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJlZGljdGVkX2NsYXNzX2lkJTIwJTNEJTIwbG9naXRzLmFyZ21heCgpLml0ZW0oKSUwQW1vZGVsLmNvbmZpZy5pZDJsYWJlbCU1QnByZWRpY3RlZF9jbGFzc19pZCU1RCUwQSUwQSUyMyUyMFRvJTIwdHJhaW4lMjBhJTIwbW9kZWwlMjBvbiUyMCU2MG51bV9sYWJlbHMlNjAlMjBjbGFzc2VzJTJDJTIweW91JTIwY2FuJTIwcGFzcyUyMCU2MG51bV9sYWJlbHMlM0RudW1fbGFiZWxzJTYwJTIwdG8lMjAlNjAuZnJvbV9wcmV0cmFpbmVkKC4uLiklNjAlMEFudW1fbGFiZWxzJTIwJTNEJTIwbGVuKG1vZGVsLmNvbmZpZy5pZDJsYWJlbCklMEFtb2RlbCUyMCUzRCUyMEpldE1vZUZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmpldG1vZSUyRmpldG1vZS04YiUyMiUyQyUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzKSUwQSUwQWxhYmVscyUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUIxJTVEKSUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcyUwQXJvdW5kKGxvc3MuaXRlbSgpJTJDJTIwMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, JetMoeForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;jetmoe/jetmoe-8b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = JetMoeForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;jetmoe/jetmoe-8b&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_id = logits.argmax().item()
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.id2label[predicted_class_id]
...

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on \`num_labels\` classes, you can pass \`num_labels=num_labels\` to \`.from_pretrained(...)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = JetMoeForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;jetmoe/jetmoe-8b&quot;</span>, num_labels=num_labels)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.tensor([<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(loss.item(), <span class="hljs-number">2</span>)
...`,wrap:!1}}),{c(){t=p("p"),t.textContent=u,s=r(),h(c.$$.fragment)},l(n){t=m(n,"P",{"data-svelte-h":!0}),y(t)!=="svelte-ykxpe4"&&(t.textContent=u),s=i(n),f(c.$$.fragment,n)},m(n,v){d(n,t,v),d(n,s,v),g(c,n,v),T=!0},p:ce,i(n){T||(_(c.$$.fragment,n),T=!0)},o(n){b(c.$$.fragment,n),T=!1},d(n){n&&(a(t),a(s)),M(c,n)}}}function Rt(J){let t,u="Example of multi-label classification:",s,c,T;return c=new Ee({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEpldE1vZUZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJqZXRtb2UlMkZqZXRtb2UtOGIlMjIpJTBBbW9kZWwlMjAlM0QlMjBKZXRNb2VGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJqZXRtb2UlMkZqZXRtb2UtOGIlMjIlMkMlMjBwcm9ibGVtX3R5cGUlM0QlMjJtdWx0aV9sYWJlbF9jbGFzc2lmaWNhdGlvbiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIySGVsbG8lMkMlMjBteSUyMGRvZyUyMGlzJTIwY3V0ZSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5sb2dpdHMlMEElMEFwcmVkaWN0ZWRfY2xhc3NfaWRzJTIwJTNEJTIwdG9yY2guYXJhbmdlKDAlMkMlMjBsb2dpdHMuc2hhcGUlNUItMSU1RCklNUJ0b3JjaC5zaWdtb2lkKGxvZ2l0cykuc3F1ZWV6ZShkaW0lM0QwKSUyMCUzRSUyMDAuNSU1RCUwQSUwQSUyMyUyMFRvJTIwdHJhaW4lMjBhJTIwbW9kZWwlMjBvbiUyMCU2MG51bV9sYWJlbHMlNjAlMjBjbGFzc2VzJTJDJTIweW91JTIwY2FuJTIwcGFzcyUyMCU2MG51bV9sYWJlbHMlM0RudW1fbGFiZWxzJTYwJTIwdG8lMjAlNjAuZnJvbV9wcmV0cmFpbmVkKC4uLiklNjAlMEFudW1fbGFiZWxzJTIwJTNEJTIwbGVuKG1vZGVsLmNvbmZpZy5pZDJsYWJlbCklMEFtb2RlbCUyMCUzRCUyMEpldE1vZUZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmpldG1vZSUyRmpldG1vZS04YiUyMiUyQyUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzJTJDJTIwcHJvYmxlbV90eXBlJTNEJTIybXVsdGlfbGFiZWxfY2xhc3NpZmljYXRpb24lMjIlMEEpJTBBJTBBbGFiZWxzJTIwJTNEJTIwdG9yY2guc3VtKCUwQSUyMCUyMCUyMCUyMHRvcmNoLm5uLmZ1bmN0aW9uYWwub25lX2hvdChwcmVkaWN0ZWRfY2xhc3NfaWRzJTVCTm9uZSUyQyUyMCUzQSU1RC5jbG9uZSgpJTJDJTIwbnVtX2NsYXNzZXMlM0RudW1fbGFiZWxzKSUyQyUyMGRpbSUzRDElMEEpLnRvKHRvcmNoLmZsb2F0KSUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, JetMoeForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;jetmoe/jetmoe-8b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = JetMoeForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;jetmoe/jetmoe-8b&quot;</span>, problem_type=<span class="hljs-string">&quot;multi_label_classification&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_ids = torch.arange(<span class="hljs-number">0</span>, logits.shape[-<span class="hljs-number">1</span>])[torch.sigmoid(logits).squeeze(dim=<span class="hljs-number">0</span>) &gt; <span class="hljs-number">0.5</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on \`num_labels\` classes, you can pass \`num_labels=num_labels\` to \`.from_pretrained(...)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = JetMoeForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;jetmoe/jetmoe-8b&quot;</span>, num_labels=num_labels, problem_type=<span class="hljs-string">&quot;multi_label_classification&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.<span class="hljs-built_in">sum</span>(
<span class="hljs-meta">... </span>    torch.nn.functional.one_hot(predicted_class_ids[<span class="hljs-literal">None</span>, :].clone(), num_classes=num_labels), dim=<span class="hljs-number">1</span>
<span class="hljs-meta">... </span>).to(torch.<span class="hljs-built_in">float</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss`,wrap:!1}}),{c(){t=p("p"),t.textContent=u,s=r(),h(c.$$.fragment)},l(n){t=m(n,"P",{"data-svelte-h":!0}),y(t)!=="svelte-1l8e32d"&&(t.textContent=u),s=i(n),f(c.$$.fragment,n)},m(n,v){d(n,t,v),d(n,s,v),g(c,n,v),T=!0},p:ce,i(n){T||(_(c.$$.fragment,n),T=!0)},o(n){b(c.$$.fragment,n),T=!1},d(n){n&&(a(t),a(s)),M(c,n)}}}function Ht(J){let t,u,s,c,T,n,v,ut='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/> <img alt="FlashAttention" src="https://img.shields.io/badge/%E2%9A%A1%EF%B8%8E%20FlashAttention-eae0c8?style=flat"/> <img alt="SDPA" src="https://img.shields.io/badge/SDPA-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',$e,P,Ce,A,ht=`<strong>JetMoe-8B</strong> is an 8B Mixture-of-Experts (MoE) language model developed by <a href="https://scholar.google.com.hk/citations?user=qff5rRYAAAAJ" rel="nofollow">Yikang Shen</a> and <a href="https://myshell.ai/" rel="nofollow">MyShell</a>.
JetMoe project aims to provide a LLaMA2-level performance and efficient language model with a limited budget.
To achieve this goal, JetMoe uses a sparsely activated architecture inspired by the <a href="https://arxiv.org/abs/2306.04640" rel="nofollow">ModuleFormer</a>.
Each JetMoe block consists of two MoE layers: Mixture of Attention Heads and Mixture of MLP Experts.
Given the input tokens, it activates a subset of its experts to process them.
This sparse activation schema enables JetMoe to achieve much better training throughput than similar size dense models.
The training throughput of JetMoe-8B is around 100B tokens per day on a cluster of 96 H100 GPUs with a straightforward 3-way pipeline parallelism strategy.`,xe,X,ft='This model was contributed by <a href="https://huggingface.co/YikangS" rel="nofollow">Yikang Shen</a>.',je,Y,ze,$,D,Re,de,gt=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/jetmoe#transformers.JetMoeModel">JetMoeModel</a>. It is used to instantiate a
JetMoe model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a configuration of the JetMoe-4B.`,He,pe,_t='<a href="https://huggingface.co/jetmoe/jetmoe-8b" rel="nofollow">jetmoe/jetmoe-8b</a>',Ve,me,bt=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Be,G,Fe,Q,Ue,C,O,Pe,ue,Mt="The bare Jetmoe Model outputting raw hidden-states without any specific head on top.",Ae,he,yt=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Xe,fe,Tt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Ye,Z,K,De,ge,vt='The <a href="/docs/transformers/main/en/model_doc/jetmoe#transformers.JetMoeModel">JetMoeModel</a> forward method, overrides the <code>__call__</code> special method.',Qe,N,qe,ee,Ze,W,te,Oe,U,oe,Ke,_e,wt='The <a href="/docs/transformers/main/en/model_doc/jetmoe#transformers.JetMoeForCausalLM">JetMoeForCausalLM</a> forward method, overrides the <code>__call__</code> special method.',et,E,tt,R,Ie,ne,We,w,se,ot,be,kt="The JetMoe Model transformer with a sequence classification head on top (linear layer).",nt,Me,Jt=`<a href="/docs/transformers/main/en/model_doc/jetmoe#transformers.JetMoeForSequenceClassification">JetMoeForSequenceClassification</a> uses the last token in order to do the classification, as other causal models
(e.g. GPT-2) do.`,st,ye,$t=`Since it does classification on the last token, it requires to know the position of the last token. If a
<code>pad_token_id</code> is defined in the configuration, it finds the last token that is not a padding token in each row. If
no <code>pad_token_id</code> is defined, it simply takes the last value in each row of the batch. Since it cannot guess the
padding tokens when <code>inputs_embeds</code> are passed instead of <code>input_ids</code>, it does the same (take the last value in
each row of the batch).`,at,Te,Ct=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,rt,ve,xt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,it,x,ae,lt,we,jt='The <a href="/docs/transformers/main/en/model_doc/jetmoe#transformers.JetMoeForSequenceClassification">JetMoeForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',ct,H,dt,V,pt,B,Le,re,Se,Je,Ge;return T=new ke({props:{title:"JetMoe",local:"jetmoe",headingTag:"h1"}}),P=new ke({props:{title:"Overview",local:"overview",headingTag:"h2"}}),Y=new ke({props:{title:"JetMoeConfig",local:"transformers.JetMoeConfig",headingTag:"h2"}}),D=new le({props:{name:"class transformers.JetMoeConfig",anchor:"transformers.JetMoeConfig",parameters:[{name:"vocab_size",val:" = 32000"},{name:"hidden_size",val:" = 2048"},{name:"num_hidden_layers",val:" = 12"},{name:"num_key_value_heads",val:" = 16"},{name:"kv_channels",val:" = 128"},{name:"intermediate_size",val:" = 5632"},{name:"max_position_embeddings",val:" = 4096"},{name:"activation_function",val:" = 'silu'"},{name:"num_local_experts",val:" = 8"},{name:"num_experts_per_tok",val:" = 2"},{name:"output_router_logits",val:" = False"},{name:"aux_loss_coef",val:" = 0.01"},{name:"use_cache",val:" = True"},{name:"bos_token_id",val:" = 1"},{name:"eos_token_id",val:" = 2"},{name:"tie_word_embeddings",val:" = True"},{name:"rope_theta",val:" = 10000.0"},{name:"rms_norm_eps",val:" = 1e-06"},{name:"initializer_range",val:" = 0.01"},{name:"attention_dropout",val:" = 0.0"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.JetMoeConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 32000) &#x2014;
Vocabulary size of the JetMoe model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/jetmoe#transformers.JetMoeModel">JetMoeModel</a>`,name:"vocab_size"},{anchor:"transformers.JetMoeConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Dimension of the hidden representations.`,name:"hidden_size"},{anchor:"transformers.JetMoeConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.JetMoeConfig.num_key_value_heads",description:`<strong>num_key_value_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of attention heads for each key and value in the Transformer encoder.`,name:"num_key_value_heads"},{anchor:"transformers.JetMoeConfig.kv_channels",description:`<strong>kv_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
Defines the number of channels for the key and value tensors.`,name:"kv_channels"},{anchor:"transformers.JetMoeConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 5632) &#x2014;
Dimension of the MLP representations.`,name:"intermediate_size"},{anchor:"transformers.JetMoeConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
The maximum sequence length that this model might ever be used with. JetMoe&#x2019;s attention allows sequence of
up to 4096 tokens.`,name:"max_position_embeddings"},{anchor:"transformers.JetMoeConfig.activation_function",description:`<strong>activation_function</strong> (<code>string</code>, <em>optional</em>, defaults to <code>&quot;silu&quot;</code>) &#x2014;
Defines the activation function for MLP experts.`,name:"activation_function"},{anchor:"transformers.JetMoeConfig.num_local_experts",description:`<strong>num_local_experts</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Defines the number of experts in the MoE and MoA.`,name:"num_local_experts"},{anchor:"transformers.JetMoeConfig.num_experts_per_tok",description:"<strong>num_experts_per_tok</strong> (`int, <em>optional</em>, defaults to 2) &#x2014;\nThe number of experts to route per-token and for MoE and MoA.",name:"num_experts_per_tok"},{anchor:"transformers.JetMoeConfig.output_router_logits",description:`<strong>output_router_logits</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the router logits should be returned by the model. Enabling this will also
allow the model to output the auxiliary loss.`,name:"output_router_logits"},{anchor:"transformers.JetMoeConfig.aux_loss_coef",description:`<strong>aux_loss_coef</strong> (<code>float</code>, <em>optional</em>, defaults to 0.01) &#x2014;
The coefficient for the auxiliary loss.`,name:"aux_loss_coef"},{anchor:"transformers.JetMoeConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models). Only
relevant if <code>config.is_decoder=True</code>.`,name:"use_cache"},{anchor:"transformers.JetMoeConfig.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The id of the &#x201C;beginning-of-sequence&#x201D; token.`,name:"bos_token_id"},{anchor:"transformers.JetMoeConfig.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The id of the &#x201C;end-of-sequence&#x201D; token.`,name:"eos_token_id"},{anchor:"transformers.JetMoeConfig.tie_word_embeddings",description:`<strong>tie_word_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the model&#x2019;s input and output word embeddings should be tied.`,name:"tie_word_embeddings"},{anchor:"transformers.JetMoeConfig.rope_theta",description:`<strong>rope_theta</strong> (<code>float</code>, <em>optional</em>, defaults to 10000.0) &#x2014;
The base period of the RoPE embeddings.`,name:"rope_theta"},{anchor:"transformers.JetMoeConfig.rms_norm_eps",description:`<strong>rms_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-06) &#x2014;
The epsilon used by the rms normalization layers.`,name:"rms_norm_eps"},{anchor:"transformers.JetMoeConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.01) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.JetMoeConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/jetmoe/configuration_jetmoe.py#L24"}}),G=new Ne({props:{anchor:"transformers.JetMoeConfig.example",$$slots:{default:[Wt]},$$scope:{ctx:J}}}),Q=new ke({props:{title:"JetMoeModel",local:"transformers.JetMoeModel",headingTag:"h2"}}),O=new le({props:{name:"class transformers.JetMoeModel",anchor:"transformers.JetMoeModel",parameters:[{name:"config",val:": JetMoeConfig"}],parametersDescription:[{anchor:"transformers.JetMoeModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/jetmoe#transformers.JetMoeConfig">JetMoeConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/jetmoe/modeling_jetmoe.py#L850"}}),K=new le({props:{name:"forward",anchor:"transformers.JetMoeModel.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Union[typing.List[torch.FloatTensor], transformers.cache_utils.Cache, NoneType] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_router_logits",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"}],parametersDescription:[{anchor:"transformers.JetMoeModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.JetMoeModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.JetMoeModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.JetMoeModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Union[List[torch.FloatTensor], ~cache_utils.Cache, NoneType]</code>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.JetMoeModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.JetMoeModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.JetMoeModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.JetMoeModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.JetMoeModel.forward.output_router_logits",description:`<strong>output_router_logits</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the logits of all the routers. They are useful for computing the router loss, and
should not be returned during inference.`,name:"output_router_logits"},{anchor:"transformers.JetMoeModel.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/jetmoe/modeling_jetmoe.py#L882",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.modeling_outputs.MoeModelOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/jetmoe#transformers.JetMoeConfig"
>JetMoeConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>Cache</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — It is a <a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache"
>Cache</a> instance. For more details, see our <a
  href="https://huggingface.co/docs/transformers/en/kv_cache"
  rel="nofollow"
>kv cache guide</a>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and optionally if
<code>config.is_encoder_decoder=True</code> in the cross-attention blocks) that can be used (see <code>past_key_values</code>
input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>router_logits</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_router_probs=True</code> and <code>config.add_router_probs=True</code> is passed or when <code>config.output_router_probs=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, sequence_length, num_experts)</code>.</p>
<p>Raw router logtis (post-softmax) that are computed by MoE routers, these terms are used to compute the auxiliary
loss for Mixture of Experts models.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.modeling_outputs.MoeModelOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),N=new mt({props:{$$slots:{default:[Lt]},$$scope:{ctx:J}}}),ee=new ke({props:{title:"JetMoeForCausalLM",local:"transformers.JetMoeForCausalLM",headingTag:"h2"}}),te=new le({props:{name:"class transformers.JetMoeForCausalLM",anchor:"transformers.JetMoeForCausalLM",parameters:[{name:"config",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/jetmoe/modeling_jetmoe.py#L1143"}}),oe=new le({props:{name:"forward",anchor:"transformers.JetMoeForCausalLM.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_router_logits",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"logits_to_keep",val:": typing.Union[int, torch.Tensor] = 0"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.JetMoeForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.JetMoeForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.JetMoeForCausalLM.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.JetMoeForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>List[torch.FloatTensor]</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.JetMoeForCausalLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.JetMoeForCausalLM.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"labels"},{anchor:"transformers.JetMoeForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.JetMoeForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.JetMoeForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.JetMoeForCausalLM.forward.output_router_logits",description:`<strong>output_router_logits</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the logits of all the routers. They are useful for computing the router loss, and
should not be returned during inference.`,name:"output_router_logits"},{anchor:"transformers.JetMoeForCausalLM.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"},{anchor:"transformers.JetMoeForCausalLM.forward.logits_to_keep",description:`<strong>logits_to_keep</strong> (<code>Union[int, torch.Tensor]</code>, defaults to <code>0</code>) &#x2014;
If an <code>int</code>, compute logits for the last <code>logits_to_keep</code> tokens. If <code>0</code>, calculate logits for all
<code>input_ids</code> (special case). Only last token logits are needed for generation, and calculating them only for that
token can save memory, which becomes pretty significant for long sequences or large vocabulary size.
If a <code>torch.Tensor</code>, must be 1D corresponding to the indices to keep in the sequence length dimension.
This is useful when using packed tensor format (single dimension for batch and sequence length).`,name:"logits_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/jetmoe/modeling_jetmoe.py#L1181",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.modeling_outputs.MoeCausalLMOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/jetmoe#transformers.JetMoeConfig"
>JetMoeConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>aux_loss</strong> (<code>torch.FloatTensor</code>, <em>optional</em>, returned when <code>labels</code> is provided) — aux_loss for the sparse modules.</p>
</li>
<li>
<p><strong>router_logits</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_router_probs=True</code> and <code>config.add_router_probs=True</code> is passed or when <code>config.output_router_probs=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, sequence_length, num_experts)</code>.</p>
<p>Raw router logtis (post-softmax) that are computed by MoE routers, these terms are used to compute the auxiliary
loss for Mixture of Experts models.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>Cache</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — It is a <a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache"
>Cache</a> instance. For more details, see our <a
  href="https://huggingface.co/docs/transformers/en/kv_cache"
  rel="nofollow"
>kv cache guide</a>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.modeling_outputs.MoeCausalLMOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),E=new mt({props:{$$slots:{default:[St]},$$scope:{ctx:J}}}),R=new Ne({props:{anchor:"transformers.JetMoeForCausalLM.forward.example",$$slots:{default:[Gt]},$$scope:{ctx:J}}}),ne=new ke({props:{title:"JetMoeForSequenceClassification",local:"transformers.JetMoeForSequenceClassification",headingTag:"h2"}}),se=new le({props:{name:"class transformers.JetMoeForSequenceClassification",anchor:"transformers.JetMoeForSequenceClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.JetMoeForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/jetmoe#transformers.JetMoeForSequenceClassification">JetMoeForSequenceClassification</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/jetmoe/modeling_jetmoe.py#L1270"}}),ae=new le({props:{name:"forward",anchor:"transformers.JetMoeForSequenceClassification.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[transformers.cache_utils.Cache] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.JetMoeForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.JetMoeForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.JetMoeForSequenceClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.JetMoeForSequenceClassification.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>~cache_utils.Cache</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.JetMoeForSequenceClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.JetMoeForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"},{anchor:"transformers.JetMoeForSequenceClassification.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.JetMoeForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.JetMoeForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/jetmoe/modeling_jetmoe.py#L1301",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.modeling_outputs.SequenceClassifierOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/jetmoe#transformers.JetMoeConfig"
>JetMoeConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>Cache</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — It is a <a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache"
>Cache</a> instance. For more details, see our <a
  href="https://huggingface.co/docs/transformers/en/kv_cache"
  rel="nofollow"
>kv cache guide</a>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.modeling_outputs.SequenceClassifierOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),H=new mt({props:{$$slots:{default:[Nt]},$$scope:{ctx:J}}}),V=new Ne({props:{anchor:"transformers.JetMoeForSequenceClassification.forward.example",$$slots:{default:[Et]},$$scope:{ctx:J}}}),B=new Ne({props:{anchor:"transformers.JetMoeForSequenceClassification.forward.example-2",$$slots:{default:[Rt]},$$scope:{ctx:J}}}),re=new It({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/jetmoe.md"}}),{c(){t=p("meta"),u=r(),s=p("p"),c=r(),h(T.$$.fragment),n=r(),v=p("div"),v.innerHTML=ut,$e=r(),h(P.$$.fragment),Ce=r(),A=p("p"),A.innerHTML=ht,xe=r(),X=p("p"),X.innerHTML=ft,je=r(),h(Y.$$.fragment),ze=r(),$=p("div"),h(D.$$.fragment),Re=r(),de=p("p"),de.innerHTML=gt,He=r(),pe=p("p"),pe.innerHTML=_t,Ve=r(),me=p("p"),me.innerHTML=bt,Be=r(),h(G.$$.fragment),Fe=r(),h(Q.$$.fragment),Ue=r(),C=p("div"),h(O.$$.fragment),Pe=r(),ue=p("p"),ue.textContent=Mt,Ae=r(),he=p("p"),he.innerHTML=yt,Xe=r(),fe=p("p"),fe.innerHTML=Tt,Ye=r(),Z=p("div"),h(K.$$.fragment),De=r(),ge=p("p"),ge.innerHTML=vt,Qe=r(),h(N.$$.fragment),qe=r(),h(ee.$$.fragment),Ze=r(),W=p("div"),h(te.$$.fragment),Oe=r(),U=p("div"),h(oe.$$.fragment),Ke=r(),_e=p("p"),_e.innerHTML=wt,et=r(),h(E.$$.fragment),tt=r(),h(R.$$.fragment),Ie=r(),h(ne.$$.fragment),We=r(),w=p("div"),h(se.$$.fragment),ot=r(),be=p("p"),be.textContent=kt,nt=r(),Me=p("p"),Me.innerHTML=Jt,st=r(),ye=p("p"),ye.innerHTML=$t,at=r(),Te=p("p"),Te.innerHTML=Ct,rt=r(),ve=p("p"),ve.innerHTML=xt,it=r(),x=p("div"),h(ae.$$.fragment),lt=r(),we=p("p"),we.innerHTML=jt,ct=r(),h(H.$$.fragment),dt=r(),h(V.$$.fragment),pt=r(),h(B.$$.fragment),Le=r(),h(re.$$.fragment),Se=r(),Je=p("p"),this.h()},l(e){const o=Zt("svelte-u9bgzb",document.head);t=m(o,"META",{name:!0,content:!0}),o.forEach(a),u=i(e),s=m(e,"P",{}),S(s).forEach(a),c=i(e),f(T.$$.fragment,e),n=i(e),v=m(e,"DIV",{class:!0,"data-svelte-h":!0}),y(v)!=="svelte-b95w5j"&&(v.innerHTML=ut),$e=i(e),f(P.$$.fragment,e),Ce=i(e),A=m(e,"P",{"data-svelte-h":!0}),y(A)!=="svelte-o95nje"&&(A.innerHTML=ht),xe=i(e),X=m(e,"P",{"data-svelte-h":!0}),y(X)!=="svelte-8foy02"&&(X.innerHTML=ft),je=i(e),f(Y.$$.fragment,e),ze=i(e),$=m(e,"DIV",{class:!0});var j=S($);f(D.$$.fragment,j),Re=i(j),de=m(j,"P",{"data-svelte-h":!0}),y(de)!=="svelte-14idbpz"&&(de.innerHTML=gt),He=i(j),pe=m(j,"P",{"data-svelte-h":!0}),y(pe)!=="svelte-aqfqqx"&&(pe.innerHTML=_t),Ve=i(j),me=m(j,"P",{"data-svelte-h":!0}),y(me)!=="svelte-o55m63"&&(me.innerHTML=bt),Be=i(j),f(G.$$.fragment,j),j.forEach(a),Fe=i(e),f(Q.$$.fragment,e),Ue=i(e),C=m(e,"DIV",{class:!0});var z=S(C);f(O.$$.fragment,z),Pe=i(z),ue=m(z,"P",{"data-svelte-h":!0}),y(ue)!=="svelte-14wtgkq"&&(ue.textContent=Mt),Ae=i(z),he=m(z,"P",{"data-svelte-h":!0}),y(he)!=="svelte-6pahdo"&&(he.innerHTML=yt),Xe=i(z),fe=m(z,"P",{"data-svelte-h":!0}),y(fe)!=="svelte-hswkmf"&&(fe.innerHTML=Tt),Ye=i(z),Z=m(z,"DIV",{class:!0});var L=S(Z);f(K.$$.fragment,L),De=i(L),ge=m(L,"P",{"data-svelte-h":!0}),y(ge)!=="svelte-nvbk3h"&&(ge.innerHTML=vt),Qe=i(L),f(N.$$.fragment,L),L.forEach(a),z.forEach(a),qe=i(e),f(ee.$$.fragment,e),Ze=i(e),W=m(e,"DIV",{class:!0});var ie=S(W);f(te.$$.fragment,ie),Oe=i(ie),U=m(ie,"DIV",{class:!0});var q=S(U);f(oe.$$.fragment,q),Ke=i(q),_e=m(q,"P",{"data-svelte-h":!0}),y(_e)!=="svelte-jct3wh"&&(_e.innerHTML=wt),et=i(q),f(E.$$.fragment,q),tt=i(q),f(R.$$.fragment,q),q.forEach(a),ie.forEach(a),Ie=i(e),f(ne.$$.fragment,e),We=i(e),w=m(e,"DIV",{class:!0});var k=S(w);f(se.$$.fragment,k),ot=i(k),be=m(k,"P",{"data-svelte-h":!0}),y(be)!=="svelte-1pmdz94"&&(be.textContent=kt),nt=i(k),Me=m(k,"P",{"data-svelte-h":!0}),y(Me)!=="svelte-qp2lg8"&&(Me.innerHTML=Jt),st=i(k),ye=m(k,"P",{"data-svelte-h":!0}),y(ye)!=="svelte-10ugs3m"&&(ye.innerHTML=$t),at=i(k),Te=m(k,"P",{"data-svelte-h":!0}),y(Te)!=="svelte-6pahdo"&&(Te.innerHTML=Ct),rt=i(k),ve=m(k,"P",{"data-svelte-h":!0}),y(ve)!=="svelte-hswkmf"&&(ve.innerHTML=xt),it=i(k),x=m(k,"DIV",{class:!0});var F=S(x);f(ae.$$.fragment,F),lt=i(F),we=m(F,"P",{"data-svelte-h":!0}),y(we)!=="svelte-l80est"&&(we.innerHTML=jt),ct=i(F),f(H.$$.fragment,F),dt=i(F),f(V.$$.fragment,F),pt=i(F),f(B.$$.fragment,F),F.forEach(a),k.forEach(a),Le=i(e),f(re.$$.fragment,e),Se=i(e),Je=m(e,"P",{}),S(Je).forEach(a),this.h()},h(){I(t,"name","hf:doc:metadata"),I(t,"content",Vt),I(v,"class","flex flex-wrap space-x-1"),I($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,o){l(document.head,t),d(e,u,o),d(e,s,o),d(e,c,o),g(T,e,o),d(e,n,o),d(e,v,o),d(e,$e,o),g(P,e,o),d(e,Ce,o),d(e,A,o),d(e,xe,o),d(e,X,o),d(e,je,o),g(Y,e,o),d(e,ze,o),d(e,$,o),g(D,$,null),l($,Re),l($,de),l($,He),l($,pe),l($,Ve),l($,me),l($,Be),g(G,$,null),d(e,Fe,o),g(Q,e,o),d(e,Ue,o),d(e,C,o),g(O,C,null),l(C,Pe),l(C,ue),l(C,Ae),l(C,he),l(C,Xe),l(C,fe),l(C,Ye),l(C,Z),g(K,Z,null),l(Z,De),l(Z,ge),l(Z,Qe),g(N,Z,null),d(e,qe,o),g(ee,e,o),d(e,Ze,o),d(e,W,o),g(te,W,null),l(W,Oe),l(W,U),g(oe,U,null),l(U,Ke),l(U,_e),l(U,et),g(E,U,null),l(U,tt),g(R,U,null),d(e,Ie,o),g(ne,e,o),d(e,We,o),d(e,w,o),g(se,w,null),l(w,ot),l(w,be),l(w,nt),l(w,Me),l(w,st),l(w,ye),l(w,at),l(w,Te),l(w,rt),l(w,ve),l(w,it),l(w,x),g(ae,x,null),l(x,lt),l(x,we),l(x,ct),g(H,x,null),l(x,dt),g(V,x,null),l(x,pt),g(B,x,null),d(e,Le,o),g(re,e,o),d(e,Se,o),d(e,Je,o),Ge=!0},p(e,[o]){const j={};o&2&&(j.$$scope={dirty:o,ctx:e}),G.$set(j);const z={};o&2&&(z.$$scope={dirty:o,ctx:e}),N.$set(z);const L={};o&2&&(L.$$scope={dirty:o,ctx:e}),E.$set(L);const ie={};o&2&&(ie.$$scope={dirty:o,ctx:e}),R.$set(ie);const q={};o&2&&(q.$$scope={dirty:o,ctx:e}),H.$set(q);const k={};o&2&&(k.$$scope={dirty:o,ctx:e}),V.$set(k);const F={};o&2&&(F.$$scope={dirty:o,ctx:e}),B.$set(F)},i(e){Ge||(_(T.$$.fragment,e),_(P.$$.fragment,e),_(Y.$$.fragment,e),_(D.$$.fragment,e),_(G.$$.fragment,e),_(Q.$$.fragment,e),_(O.$$.fragment,e),_(K.$$.fragment,e),_(N.$$.fragment,e),_(ee.$$.fragment,e),_(te.$$.fragment,e),_(oe.$$.fragment,e),_(E.$$.fragment,e),_(R.$$.fragment,e),_(ne.$$.fragment,e),_(se.$$.fragment,e),_(ae.$$.fragment,e),_(H.$$.fragment,e),_(V.$$.fragment,e),_(B.$$.fragment,e),_(re.$$.fragment,e),Ge=!0)},o(e){b(T.$$.fragment,e),b(P.$$.fragment,e),b(Y.$$.fragment,e),b(D.$$.fragment,e),b(G.$$.fragment,e),b(Q.$$.fragment,e),b(O.$$.fragment,e),b(K.$$.fragment,e),b(N.$$.fragment,e),b(ee.$$.fragment,e),b(te.$$.fragment,e),b(oe.$$.fragment,e),b(E.$$.fragment,e),b(R.$$.fragment,e),b(ne.$$.fragment,e),b(se.$$.fragment,e),b(ae.$$.fragment,e),b(H.$$.fragment,e),b(V.$$.fragment,e),b(B.$$.fragment,e),b(re.$$.fragment,e),Ge=!1},d(e){e&&(a(u),a(s),a(c),a(n),a(v),a($e),a(Ce),a(A),a(xe),a(X),a(je),a(ze),a($),a(Fe),a(Ue),a(C),a(qe),a(Ze),a(W),a(Ie),a(We),a(w),a(Le),a(Se),a(Je)),a(t),M(T,e),M(P,e),M(Y,e),M(D),M(G),M(Q,e),M(O),M(K),M(N),M(ee,e),M(te),M(oe),M(E),M(R),M(ne,e),M(se),M(ae),M(H),M(V),M(B),M(re,e)}}}const Vt='{"title":"JetMoe","local":"jetmoe","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"JetMoeConfig","local":"transformers.JetMoeConfig","sections":[],"depth":2},{"title":"JetMoeModel","local":"transformers.JetMoeModel","sections":[],"depth":2},{"title":"JetMoeForCausalLM","local":"transformers.JetMoeForCausalLM","sections":[],"depth":2},{"title":"JetMoeForSequenceClassification","local":"transformers.JetMoeForSequenceClassification","sections":[],"depth":2}],"depth":1}';function Bt(J){return Ft(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class eo extends Ut{constructor(t){super(),qt(this,t,Bt,Ht,zt,{})}}export{eo as component};
