import{s as ra,o as la,n as It}from"../chunks/scheduler.18a86fab.js";import{S as da,i as ca,g as i,s as a,r as m,A as ma,h as r,f as o,c as s,j as U,u as p,x as c,k as J,y as l,a as n,v as h,d as g,t as u,w as f}from"../chunks/index.98837b22.js";import{T as qo}from"../chunks/Tip.77304350.js";import{D as V}from"../chunks/Docstring.6758ea23.js";import{C as K}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as ia}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as j}from"../chunks/Heading.7e7e0c5b.js";import{E as pa}from"../chunks/getInferenceSnippets.de10bc7d.js";function ha(L){let d,M="<li>Llava-Next uses different number of patches for images and thus has to pad the inputs inside modeling code, aside from the padding done when processing the inputs. The default setting is “left-padding” if model is in <code>eval()</code> mode, otherwise “right-padding”.</li>";return{c(){d=i("ul"),d.innerHTML=M},l(y){d=r(y,"UL",{"data-svelte-h":!0}),c(d)!=="svelte-17g7vjy"&&(d.innerHTML=M)},m(y,v){n(y,d,v)},p:It,d(y){y&&o(d)}}}function ga(L){let d,M='bitsandbytes is being refactored to support multiple backends beyond CUDA. Currently, ROCm (AMD GPU) and Intel CPU implementations are mature, with Intel XPU in progress and Apple Silicon support expected by Q4/Q1. For installation instructions and the latest backend updates, visit <a href="https://huggingface.co/docs/bitsandbytes/main/en/installation#multi-backend" rel="nofollow">this link</a>.',y,v,b='We value your feedback to help identify bugs before the full release! Check out <a href="https://huggingface.co/docs/bitsandbytes/main/en/non_cuda_backends" rel="nofollow">these docs</a> for more details and feedback links.';return{c(){d=i("p"),d.innerHTML=M,y=a(),v=i("p"),v.innerHTML=b},l(_){d=r(_,"P",{"data-svelte-h":!0}),c(d)!=="svelte-nz63kd"&&(d.innerHTML=M),y=s(_),v=r(_,"P",{"data-svelte-h":!0}),c(v)!=="svelte-aze40l"&&(v.innerHTML=b)},m(_,w){n(_,d,w),n(_,y,w),n(_,v,w)},p:It,d(_){_&&(o(d),o(y),o(v))}}}function ua(L){let d,M="Example:",y,v,b;return v=new K({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMExsYXZhTmV4dFZpZGVvRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTJDJTIwTGxhdmFOZXh0VmlkZW9Db25maWclMkMlMjBDTElQVmlzaW9uQ29uZmlnJTJDJTIwTGxhbWFDb25maWclMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwQ0xJUC12aXNpb24lMjBjb25maWclMEF2aXNpb25fY29uZmlnJTIwJTNEJTIwQ0xJUFZpc2lvbkNvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMExsYW1hJTIwY29uZmlnJTBBdGV4dF9jb25maWclMjAlM0QlMjBMbGFtYUNvbmZpZygpJTBBJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMExsYXZhTmV4dFZpZGVvQ29uZmlnKHZpc2lvbl9jb25maWclMkMlMjB0ZXh0X2NvbmZpZyklMEElMEFtb2RlbCUyMCUzRCUyMExsYXZhTmV4dFZpZGVvRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlavaNextVideoForConditionalGeneration, LlavaNextVideoConfig, CLIPVisionConfig, LlamaConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a CLIP-vision config</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>vision_config = CLIPVisionConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Llama config</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text_config = LlamaConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = LlavaNextVideoConfig(vision_config, text_config)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = LlavaNextVideoForConditionalGeneration(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){d=i("p"),d.textContent=M,y=a(),m(v.$$.fragment)},l(_){d=r(_,"P",{"data-svelte-h":!0}),c(d)!=="svelte-11lpom8"&&(d.textContent=M),y=s(_),p(v.$$.fragment,_)},m(_,w){n(_,d,w),n(_,y,w),h(v,_,w),b=!0},p:It,i(_){b||(g(v.$$.fragment,_),b=!0)},o(_){u(v.$$.fragment,_),b=!1},d(_){_&&(o(d),o(y)),f(v,_)}}}function fa(L){let d,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){d=i("p"),d.innerHTML=M},l(y){d=r(y,"P",{"data-svelte-h":!0}),c(d)!=="svelte-fincs2"&&(d.innerHTML=M)},m(y,v){n(y,d,v)},p:It,d(y){y&&o(d)}}}function _a(L){let d,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){d=i("p"),d.innerHTML=M},l(y){d=r(y,"P",{"data-svelte-h":!0}),c(d)!=="svelte-fincs2"&&(d.innerHTML=M)},m(y,v){n(y,d,v)},p:It,d(y){y&&o(d)}}}function ya(L){let d,M="Example:",y,v,b;return v=new K({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> av
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, LlavaNextVideoForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">read_video_pyav</span>(<span class="hljs-params">container, indices</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&#x27;&#x27;&#x27;
<span class="hljs-meta">... </span>    Decode the video with PyAV decoder.
<span class="hljs-meta">... </span>    Args:
<span class="hljs-meta">... </span>        container (\`av.container.input.InputContainer\`): PyAV container.
<span class="hljs-meta">... </span>        indices (\`List[int]\`): List of frame indices to decode.
<span class="hljs-meta">... </span>    Returns:
<span class="hljs-meta">... </span>        result (np.ndarray): np array of decoded frames of shape (num_frames, height, width, 3).
<span class="hljs-meta">... </span>    &#x27;&#x27;&#x27;</span>
<span class="hljs-meta">... </span>    frames = []
<span class="hljs-meta">... </span>    container.seek(<span class="hljs-number">0</span>)
<span class="hljs-meta">... </span>    start_index = indices[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>    end_index = indices[-<span class="hljs-number">1</span>]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> i, frame <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(container.decode(video=<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> i &gt; end_index:
<span class="hljs-meta">... </span>            <span class="hljs-keyword">break</span>
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> i &gt;= start_index <span class="hljs-keyword">and</span> i <span class="hljs-keyword">in</span> indices:
<span class="hljs-meta">... </span>            frames.append(frame)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> np.stack([x.to_ndarray(<span class="hljs-built_in">format</span>=<span class="hljs-string">&quot;rgb24&quot;</span>) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> frames])

<span class="hljs-meta">&gt;&gt;&gt; </span>model = LlavaNextVideoForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;llava-hf/LLaVA-NeXT-Video-7B-hf&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;llava-hf/LLaVA-NeXT-Video-7B-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;USER: &lt;video&gt;\\nWhy is this video funny? ASSISTANT:&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>video_path = hf_hub_download(repo_id=<span class="hljs-string">&quot;raushan-testing-hf/videos-test&quot;</span>, filename=<span class="hljs-string">&quot;sample_demo_1.mp4&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>container = av.<span class="hljs-built_in">open</span>(video_path)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># sample uniformly 8 frames from the video (model was trained with 32 frames per video, but this video is short)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>total_frames = container.streams.video[<span class="hljs-number">0</span>].frames
<span class="hljs-meta">&gt;&gt;&gt; </span>indices = np.arange(<span class="hljs-number">0</span>, total_frames, total_frames / <span class="hljs-number">8</span>).astype(<span class="hljs-built_in">int</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>clip = read_video_pyav(container, indices)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs_video = processor(text=prompt, videos=clip, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load an image to generate from an image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;USER:&lt;image&gt;\\nWhat is shown in this image? ASSISTANT:&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://www.ilankelman.org/stopsigns/australia.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs_image = processor(text=prompt, images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate from video</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(**inputs_video, max_length=<span class="hljs-number">50</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;USER:\\nWhy is this video funny? ASSISTANT: The humor in this video comes from the unexpected and endearing sight of a baby wearing glasses and (...)&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate from image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(**inputs_image, max_length=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;USER: \\nWhat&#x27;s the content of the image? ASSISTANT: The image shows a red stop sign on a pole, with a traditional Chinese archway (...)&quot;</span>`,wrap:!1}}),{c(){d=i("p"),d.textContent=M,y=a(),m(v.$$.fragment)},l(_){d=r(_,"P",{"data-svelte-h":!0}),c(d)!=="svelte-11lpom8"&&(d.textContent=M),y=s(_),p(v.$$.fragment,_)},m(_,w){n(_,d,w),n(_,y,w),h(v,_,w),b=!0},p:It,i(_){b||(g(v.$$.fragment,_),b=!0)},o(_){u(v.$$.fragment,_),b=!1},d(_){_&&(o(d),o(y)),f(v,_)}}}function va(L){let d,M,y,v,b,_,w,_n='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/> <img alt="FlashAttention" src="https://img.shields.io/badge/%E2%9A%A1%EF%B8%8E%20FlashAttention-eae0c8?style=flat"/> <img alt="SDPA" src="https://img.shields.io/badge/SDPA-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',Nt,ee,kt,te,yn='The LLaVa-NeXT-Video model was proposed in <a href="https://llava-vl.github.io/blog/2024-04-30-llava-next-video/" rel="nofollow">LLaVA-NeXT: A Strong Zero-shot Video Understanding Model</a> by Yuanhan Zhang, Bo Li, Haotian Liu, Yong Jae Lee, Liangke Gui, Di Fu, Jiashi Feng, Ziwei Liu, Chunyuan Li. LLaVa-NeXT-Video improves upon <a href="llava_next">LLaVa-NeXT</a> by fine-tuning on a mix if video and image dataset thus increasing the model’s performance on videos.',$t,oe,vn='<a href="llava_next">LLaVA-NeXT</a> surprisingly has strong performance in understanding video content in zero-shot fashion with the AnyRes technique that it uses. The AnyRes technique naturally represents a high-resolution image into multiple images. This technique is naturally generalizable to represent videos because videos can be considered as a set of frames (similar to a set of images in LLaVa-NeXT). The current version of LLaVA-NeXT makes use of AnyRes and trains with supervised fine-tuning (SFT) on top of LLaVA-Next on video data to achieves better video understanding capabilities.The model is a current SOTA among open-source models on <a href="https://arxiv.org/abs/2405.21075" rel="nofollow">VideoMME bench</a>.',zt,ne,Mn="The introduction from the blog is the following:",Zt,ae,Tn="On January 30, 2024, we released LLaVA-NeXT, an open-source Large Multimodal Model (LMM) that has been trained exclusively on text-image data. With the proposed AnyRes technique, it boosts capabilities in reasoning, OCR, and world knowledge, demonstrating remarkable performance across a spectrum of image-based multimodal understanding tasks, and even exceeding Gemini-Pro on several image benchmarks, e.g. MMMU and MathVista.",Bt,se,bn="**In today’s exploration, we delve into the performance of LLaVA-NeXT within the realm of video understanding tasks. We reveal that LLaVA-NeXT surprisingly has strong performance in understanding video content. The current version of LLaVA-NeXT for videos has several improvements:",qt,ie,wn="<li>Zero-shot video representation capabilities with AnyRes: The AnyRes technique naturally represents a high-resolution image into multiple images that a pre-trained VIT is able to digest, and forms them into a concatenated sequence. This technique is naturally generalizable to represent videos (consisting of multiple frames), allowing the image-only-trained LLaVA-Next model to perform surprisingly well on video tasks. Notably, this is the first time that LMMs show strong zero-shot modality transfer ability.</li> <li>Inference with length generalization improves on longer videos. The linear scaling technique enables length generalization, allowing LLaVA-NeXT to effectively handle long-video beyond the limitation of the “max_token_length” of the LLM.</li> <li>Strong video understanding ability. (1) LLaVA-Next-Image, which combines the above two techniques, yields superior zero-shot performance than open-source LMMs tuned on videos. (2) LLaVA-Next-Video, further supervised fine-tuning (SFT) LLaVA-Next-Image on video data, achieves better video understanding capabilities compared to LLaVA-Next-Image. (3) LLaVA-Next-Video-DPO, which aligns the model response with AI feedback using direct preference optimization (DPO), showing significant performance boost.</li> <li>Efficient deployment and inference with SGLang. It allows 5x faster inference on video tasks, allowing more scalable serving such as million-level video re-captioning. See instructions in our repo.**</li>",Gt,re,Jn=`This model was contributed by <a href="https://huggingface.co/RaushanTurganbay" rel="nofollow">RaushanTurganbay</a>.
The original code can be found <a href="https://github.com/LLaVA-VL/LLaVA-NeXT/tree/inference" rel="nofollow">here</a>.`,Wt,le,Ft,de,Un="<li>We advise users to use <code>padding_side=&quot;left&quot;</code> when computing batched generation as it leads to more accurate results. Simply make sure to call <code>processor.tokenizer.padding_side = &quot;left&quot;</code> before generating.</li>",Rt,W,At,ce,xn="<p>[!NOTE]\nLLaVA models after release v4.46 will raise warnings about adding <code>processor.patch_size = {{patch_size}}</code>, <code>processor.num_additional_image_tokens = {{num_additional_image_tokens}}</code> and processor.vision_feature_select_strategy = {{vision_feature_select_strategy}}<code>. It is strongly recommended to add the attributes to the processor if you own the model checkpoint, or open a PR if it is not owned by you. Adding these attributes means that LLaVA will try to infer the number of image tokens required per image and expand the text with as many </code>&lt;image&gt;<code>placeholders as there will be tokens. Usually it is around 500 tokens per image, so make sure that the text is not truncated as otherwise there will be failure when merging the embeddings. The attributes can be obtained from model config, as</code>model.config.vision_config.patch_size<code>or</code>model.config.vision_feature_select_strategy<code>. The </code>num_additional_image_tokens<code>should be</code>1<code>if the vision backbone adds a CLS token or</code>0` if nothing extra is added to the vision patches.</p>",Xt,me,Et,pe,jn="Each <strong>checkpoint</strong> is trained with a specific prompt format, depending on the underlying large language model backbone. To ensure correct formatting, use the processor’s <code>apply_chat_template</code> method.",Pt,he,Cn="<strong>Important:</strong>",Qt,ge,In="<li>You must construct a conversation history — passing a plain string won’t work.</li> <li>Each message should be a dictionary with <code>&quot;role&quot;</code> and <code>&quot;content&quot;</code> keys.</li> <li>The <code>&quot;content&quot;</code> should be a list of dictionaries for different modalities like <code>&quot;text&quot;</code> and <code>&quot;image&quot;</code>.</li>",St,ue,Vn='Here’s an example of how to structure your input. We will use <a href="https://huggingface.co/llava-hf/LLaVA-NeXT-Video-7B-hf" rel="nofollow">LLaVA-NeXT-Video-7B-hf</a> and a conversation history of videos and images.',Ht,fe,Yt,_e,Ln="🚀 <strong>Bonus:</strong> If you’re using <code>transformers&gt;=4.49.0</code>, you can also get a vectorized output from <code>apply_chat_template</code>. See the <strong>Usage Examples</strong> below for more details on how to use it.",Dt,ye,Ot,ve,Kt,Me,Nn="The model can accept both images and videos as input. Here’s an example code for inference in half-precision (<code>torch.float16</code>):",eo,Te,to,be,oo,we,kn="The model can also generate from an interleaved image-video inputs. However note, that it was not trained in interleaved image-video setting which might affect the performance. Below is an example usage for mixed media input, add the following lines to the above code snippet:",no,Je,ao,Ue,so,xe,io,je,$n="The model can be loaded in lower bits, significantly reducing memory burden while maintaining the performance of the original model. This allows for efficient deployment on resource-constrained cases.",ro,Ce,zn="First, make sure to install bitsandbytes by running <code>pip install bitsandbytes</code> and to have access to a GPU/accelerator that is supported by the library.",lo,F,co,Ie,Zn='Then simply load the quantized model by adding <a href="../main_classes/quantization#transformers.BitsAndBytesConfig"><code>BitsAndBytesConfig</code></a> as shown below:',mo,Ve,po,Le,ho,Ne,Bn='Additionally, we can greatly speed-up model inference by using <a href="../perf_train_gpu_one#flash-attention-2">Flash Attention</a>, which is a faster implementation of the attention mechanism used inside the model.',go,ke,qn="First, make sure to install the latest version of Flash Attention 2:",uo,$e,fo,ze,Gn='Also, you should have a hardware that is compatible with Flash-Attention 2. Read more about it in the official documentation of the <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">flash attention repository</a>. FlashAttention-2 can only be used when a model is loaded in <code>torch.float16</code> or <code>torch.bfloat16</code>.',_o,Ze,Wn="To load and run a model using Flash Attention-2, simply add <code>attn_implementation=&quot;flash_attention_2&quot;</code> when loading the model as follows:",yo,Be,vo,qe,Mo,z,Ge,Go,dt,Fn=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/llava_next_video#transformers.LlavaNextVideoForConditionalGeneration">LlavaNextVideoForConditionalGeneration</a>. It is used to instantiate an
Llava-NeXT model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the <a href="https://huggingface.co/llava-hf/LLaVA-NeXT-Video-7B-hf" rel="nofollow">llava-hf/LLaVA-NeXT-Video-7B-hf</a>
model.
Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Wo,R,To,We,bo,C,Fe,Fo,ct,Rn=`Constructs a LLaVa-NeXT-Video processor which wraps a LLaVa-NeXT image processor, LLaVa-NeXT-Video video processor and
a LLaMa tokenizer into a single processor.`,Ro,mt,An=`<a href="/docs/transformers/main/en/model_doc/llava_next_video#transformers.LlavaNextVideoProcessor">LlavaNextVideoProcessor</a> offers all the functionalities of <a href="/docs/transformers/main/en/model_doc/llava_next#transformers.LlavaNextImageProcessor">LlavaNextImageProcessor</a>, <a href="/docs/transformers/main/en/model_doc/llava_next_video#transformers.LlavaNextVideoImageProcessor">LlavaNextVideoImageProcessor</a> and
<a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>. See the <code>__call__()</code> and <a href="/docs/transformers/main/en/model_doc/llava_next_video#transformers.LlavaNextVideoProcessor.decode">decode()</a> for more information.`,Ao,A,Re,Xo,pt,Xn=`This method forwards all its arguments to LlamaTokenizerFast’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.batch_decode">batch_decode()</a>. Please
refer to the docstring of this method for more information.`,Eo,X,Ae,Po,ht,En=`This method forwards all its arguments to LlamaTokenizerFast’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.decode">decode()</a>. Please refer to
the docstring of this method for more information.`,wo,Xe,Jo,N,Ee,Qo,gt,Pn='Constructs a LLaVa-NeXT-Video video processor. Based on <a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor">CLIPImageProcessor</a> with incorporation of processing each video frame.',So,ut,Pe,Ho,E,Qe,Yo,ft,Qn=`Resize an image. The shortest edge of the image is resized to size[“shortest_edge”], with the longest edge
resized to keep the input aspect ratio.`,Uo,Se,xo,He,Ye,jo,De,Co,T,Oe,Do,_t,Sn="The Llava-Next model which consists of a vision backbone and a language model without language modeling head.",Oo,yt,Hn=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Ko,vt,Yn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,en,B,Ke,tn,Mt,Dn='The <a href="/docs/transformers/main/en/model_doc/llava_next_video#transformers.LlavaNextVideoModel">LlavaNextVideoModel</a> forward method, overrides the <code>__call__</code> special method.',on,P,nn,Q,et,an,Tt,On="Obtains image last hidden states from the vision tower and apply multimodal projection.",sn,S,tt,rn,bt,Kn="Obtains video last hidden states from the vision tower and apply multimodal projection.",ln,H,ot,dn,wt,ea="Reshape, unpad and then pack each image_feature into a single image_features tensor containing all visual vectors.",Io,nt,Vo,I,at,cn,Jt,ta="The LLAVA-NeXT model which consists of a vision backbone and a language model.",mn,Ut,oa=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,pn,xt,na=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,hn,$,st,gn,jt,aa='The <a href="/docs/transformers/main/en/model_doc/llava_next_video#transformers.LlavaNextVideoForConditionalGeneration">LlavaNextVideoForConditionalGeneration</a> forward method, overrides the <code>__call__</code> special method.',un,Y,fn,D,Lo,it,No,Vt,ko;return b=new j({props:{title:"LLaVa-NeXT-Video",local:"llava-next-video",headingTag:"h1"}}),ee=new j({props:{title:"Overview",local:"overview",headingTag:"h2"}}),le=new j({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),W=new qo({props:{warning:!0,$$slots:{default:[ha]},$$scope:{ctx:L}}}),me=new j({props:{title:"Formatting Prompts with Chat Templates",local:"formatting-prompts-with-chat-templates",headingTag:"h3"}}),fe=new K({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlavaNextVideoProcessor

processor = LlavaNextVideoProcessor.from_pretrained(<span class="hljs-string">&quot;llava-hf/LLaVA-NeXT-Video-7B-hf&quot;</span>)

conversation = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;A chat between a curious human and an artificial intelligence assistant. The assistant gives helpful, detailed, and polite answers to the human&#x27;s questions.&quot;</span>},
            ],
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What’s shown in this image?&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
            ],
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;This image shows a red stop sign.&quot;</span>},]
    },
    {

        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Why is this video funny?&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;video&quot;</span>},
            ],
    },
]

text_prompt = processor.apply_chat_template(conversation, add_generation_prompt=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Note that the template simply formats your prompt, you still have to tokenize it and obtain pixel values for your visuals</span>
<span class="hljs-built_in">print</span>(text_prompt)`,wrap:!1}}),ye=new j({props:{title:"Usage example",local:"usage-example",headingTag:"h2"}}),ve=new j({props:{title:"Single Media Mode",local:"single-media-mode",headingTag:"h3"}}),Te=new K({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlavaNextVideoForConditionalGeneration, LlavaNextVideoProcessor

<span class="hljs-comment"># Load the model in half-precision</span>
model = LlavaNextVideoForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;llava-hf/LLaVA-NeXT-Video-7B-hf&quot;</span>, torch_dtype=torch.float16, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
processor = LlavaNextVideoProcessor.from_pretrained(<span class="hljs-string">&quot;llava-hf/LLaVA-NeXT-Video-7B-hf&quot;</span>)

<span class="hljs-comment"># Load the video as an np.array, sampling uniformly 8 frames (can sample more for longer videos)</span>
video_path = hf_hub_download(repo_id=<span class="hljs-string">&quot;raushan-testing-hf/videos-test&quot;</span>, filename=<span class="hljs-string">&quot;sample_demo_1.mp4&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)

conversation = [
    {

        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Why is this video funny?&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;video&quot;</span>, <span class="hljs-string">&quot;path&quot;</span>: video_path},
            ],
    },
]

inputs = processor.apply_chat_template(conversation, num_frames=<span class="hljs-number">8</span>, add_generation_prompt=<span class="hljs-literal">True</span>, tokenize=<span class="hljs-literal">True</span>, return_dict=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

out = model.generate(**inputs, max_new_tokens=<span class="hljs-number">60</span>)
processor.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">True</span>)`,wrap:!1}}),be=new j({props:{title:"Mixed Media Mode",local:"mixed-media-mode",headingTag:"h3"}}),Je=new K({props:{code:"JTBBJTIzJTIwR2VuZXJhdGUlMjBmcm9tJTIwaW1hZ2UlMjBhbmQlMjB2aWRlbyUyMG1peGVkJTIwaW5wdXRzJTBBY29udmVyc2F0aW9uJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIydHlwZSUyMiUzQSUyMCUyMnRleHQlMjIlMkMlMjAlMjJ0ZXh0JTIyJTNBJTIwJTIySG93JTIwbWFueSUyMGNhdHMlMjBhcmUlMjB0aGVyZSUyMGluJTIwdGhlJTIwaW1hZ2UlM0YlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIyaW1hZ2UlMjIlMkMlMjAlMjJ1cmwlMjIlM0ElMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlNUIlN0IlMjJ0eXBlJTIyJTNBJTIwJTIydGV4dCUyMiUyQyUyMCUyMnRleHQlMjIlM0ElMjAlMjJUaGVyZSUyMGFyZSUyMHR3byUyMGNhdHMlMjIlN0QlNUQlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIydGV4dCUyMiUyQyUyMCUyMnRleHQlMjIlM0ElMjAlMjJXaHklMjBpcyUyMHRoaXMlMjB2aWRlbyUyMGZ1bm55JTNGJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIydHlwZSUyMiUzQSUyMCUyMnZpZGVvJTIyJTJDJTIwJTIycGF0aCUyMiUzQSUyMHZpZGVvX3BhdGglN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElNUQlMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IuYXBwbHlfY2hhdF90ZW1wbGF0ZShjb252ZXJzYXRpb24lMkMlMjBudW1fZnJhbWVzJTNEOCUyQyUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUzRFRydWUlMkMlMjB0b2tlbml6ZSUzRFRydWUlMkMlMjByZXR1cm5fZGljdCUzRFRydWUlMkMlMjBwYWRkaW5nJTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwR2VuZXJhdGUlMEFnZW5lcmF0ZV9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG1heF9sZW5ndGglM0Q1MCklMEFwcm9jZXNzb3IuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlJTJDJTIwY2xlYW5fdXBfdG9rZW5pemF0aW9uX3NwYWNlcyUzRFRydWUpJTBB",highlighted:`
<span class="hljs-comment"># Generate from image and video mixed inputs</span>
conversation = [
    {

        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;How many cats are there in the image?&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>, <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>},
            ],
    },
    {

        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;There are two cats&quot;</span>}],
    },
    {

        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Why is this video funny?&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;video&quot;</span>, <span class="hljs-string">&quot;path&quot;</span>: video_path},
            ],
    },
]
inputs = processor.apply_chat_template(conversation, num_frames=<span class="hljs-number">8</span>, add_generation_prompt=<span class="hljs-literal">True</span>, tokenize=<span class="hljs-literal">True</span>, return_dict=<span class="hljs-literal">True</span>, padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-comment"># Generate</span>
generate_ids = model.generate(**inputs, max_length=<span class="hljs-number">50</span>)
processor.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">True</span>)
`,wrap:!1}}),Ue=new j({props:{title:"Model optimization",local:"model-optimization",headingTag:"h2"}}),xe=new j({props:{title:"Quantization using Bitsandbytes for memory efficiency",local:"quantization-using-bitsandbytes-for-memory-efficiency",headingTag:"h3"}}),F=new qo({props:{$$slots:{default:[ga]},$$scope:{ctx:L}}}),Ve=new K({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMExsYXZhTmV4dFZpZGVvRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTJDJTIwTGxhdmFOZXh0VmlkZW9Qcm9jZXNzb3IlMEElMEElMjMlMjBzcGVjaWZ5JTIwaG93JTIwdG8lMjBxdWFudGl6ZSUyMHRoZSUyMG1vZGVsJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMEJpdHNBbmRCeXRlc0NvbmZpZyglMEElMjAlMjAlMjAlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfcXVhbnRfdHlwZSUzRCUyMm5mNCUyMiUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X2NvbXB1dGVfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKSUwQSUwQW1vZGVsJTIwJTNEJTIwTGxhdmFOZXh0VmlkZW9Gb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmxsYXZhLWhmJTJGTExhVkEtTmVYVC1WaWRlby03Qi1oZiUyMiUyQyUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudGl6YXRpb25fY29uZmlnJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlavaNextVideoForConditionalGeneration, LlavaNextVideoProcessor

<span class="hljs-comment"># specify how to quantize the model</span>
quantization_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
    bnb_4bit_compute_dtype=torch.float16,
)

model = LlavaNextVideoForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;llava-hf/LLaVA-NeXT-Video-7B-hf&quot;</span>, quantization_config=quantization_config, device_map=<span class="hljs-string">&quot;auto&quot;</span>)`,wrap:!1}}),Le=new j({props:{title:"Flash-Attention 2 to speed-up generation",local:"flash-attention-2-to-speed-up-generation",headingTag:"h3"}}),$e=new K({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwZmxhc2gtYXR0biUyMC0tbm8tYnVpbGQtaXNvbGF0aW9u",highlighted:"pip install -U flash-attn --no-build-isolation",wrap:!1}}),Be=new K({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMExsYXZhTmV4dFZpZGVvRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBJTBBbW9kZWwlMjAlM0QlMjBMbGF2YU5leHRWaWRlb0ZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybGxhdmEtaGYlMkZMTGFWQS1OZVhULVZpZGVvLTdCLWhmJTIyJTJDJTIwJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwJTBBJTIwJTIwJTIwJTIwYXR0bl9pbXBsZW1lbnRhdGlvbiUzRCUyMmZsYXNoX2F0dGVudGlvbl8yJTIyJTJDJTBBKS50bygwKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlavaNextVideoForConditionalGeneration

model = LlavaNextVideoForConditionalGeneration.from_pretrained(
    <span class="hljs-string">&quot;llava-hf/LLaVA-NeXT-Video-7B-hf&quot;</span>, 
    torch_dtype=torch.float16, 
    attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>,
).to(<span class="hljs-number">0</span>)`,wrap:!1}}),qe=new j({props:{title:"LlavaNextVideoConfig",local:"transformers.LlavaNextVideoConfig",headingTag:"h2"}}),Ge=new V({props:{name:"class transformers.LlavaNextVideoConfig",anchor:"transformers.LlavaNextVideoConfig",parameters:[{name:"vision_config",val:" = None"},{name:"text_config",val:" = None"},{name:"image_token_index",val:" = 32001"},{name:"projector_hidden_act",val:" = 'gelu'"},{name:"multimodal_projector_bias",val:" = True"},{name:"vision_feature_select_strategy",val:" = 'default'"},{name:"vision_feature_layer",val:" = -2"},{name:"image_grid_pinpoints",val:" = None"},{name:"tie_word_embeddings",val:" = False"},{name:"video_token_index",val:" = 32000"},{name:"spatial_pool_mode",val:" = 'average'"},{name:"spatial_pool_stride",val:" = 2"},{name:"image_seq_length",val:" = 576"},{name:"video_seq_length",val:" = 288"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LlavaNextVideoConfig.vision_config",description:`<strong>vision_config</strong> (<code>Union[AutoConfig, dict]</code>,  <em>optional</em>, defaults to <code>CLIPVisionConfig</code>) &#x2014;
The config object or dictionary of the vision backbone.`,name:"vision_config"},{anchor:"transformers.LlavaNextVideoConfig.text_config",description:`<strong>text_config</strong> (<code>Union[AutoConfig, dict]</code>, <em>optional</em>, defaults to <code>LlamaConfig</code>) &#x2014;
The config object or dictionary of the text backbone.`,name:"text_config"},{anchor:"transformers.LlavaNextVideoConfig.image_token_index",description:`<strong>image_token_index</strong> (<code>int</code>, <em>optional</em>, defaults to 32001) &#x2014;
The image token index to encode the image prompt.`,name:"image_token_index"},{anchor:"transformers.LlavaNextVideoConfig.projector_hidden_act",description:`<strong>projector_hidden_act</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The activation function used by the multimodal projector.`,name:"projector_hidden_act"},{anchor:"transformers.LlavaNextVideoConfig.multimodal_projector_bias",description:`<strong>multimodal_projector_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use bias in the multimodal projector.`,name:"multimodal_projector_bias"},{anchor:"transformers.LlavaNextVideoConfig.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;default&quot;</code>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.
Can be one of <code>&quot;default&quot;</code> or <code>&quot;full&quot;</code>. If <code>&quot;default&quot;</code>, the CLS token is removed from the vision features.
If <code>&quot;full&quot;</code>, the full vision features are used.`,name:"vision_feature_select_strategy"},{anchor:"transformers.LlavaNextVideoConfig.vision_feature_layer",description:`<strong>vision_feature_layer</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>, defaults to -2) &#x2014;
The index of the layer to select the vision feature. If multiple indices are provided,
the vision feature of the corresponding indices will be concatenated to form the
vision features.`,name:"vision_feature_layer"},{anchor:"transformers.LlavaNextVideoConfig.image_grid_pinpoints",description:`<strong>image_grid_pinpoints</strong> (<code>List</code>, <em>optional</em>, defaults to <code>[[336, 672], [672, 336], [672, 672], [1008, 336], [336, 1008]]</code>) &#x2014;
A list of possible resolutions to use for processing high resolution images. Each item in the list should be a tuple or list
of the form <code>(height, width)</code>.`,name:"image_grid_pinpoints"},{anchor:"transformers.LlavaNextVideoConfig.tie_word_embeddings",description:`<strong>tie_word_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the model&#x2019;s input and output word embeddings should be tied.`,name:"tie_word_embeddings"},{anchor:"transformers.LlavaNextVideoConfig.video_token_index",description:`<strong>video_token_index</strong> (<code>int</code>, <em>optional</em>, defaults to 32000) &#x2014;
The video token index to encode the image prompt.`,name:"video_token_index"},{anchor:"transformers.LlavaNextVideoConfig.spatial_pool_mode",description:`<strong>spatial_pool_mode</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;average&quot;</code>) &#x2014;
Pooling mode to use for videos. Can be &#x201C;average&#x201D;, &#x201C;max&#x201D; or &#x201C;conv&#x201D;.`,name:"spatial_pool_mode"},{anchor:"transformers.LlavaNextVideoConfig.spatial_pool_stride",description:`<strong>spatial_pool_stride</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
Stride used in the pooling layer for videos.`,name:"spatial_pool_stride"},{anchor:"transformers.LlavaNextVideoConfig.image_seq_length",description:`<strong>image_seq_length</strong> (<code>int</code>, <em>optional</em>, defaults to 576) &#x2014;
Sequence length of one image embedding.`,name:"image_seq_length"},{anchor:"transformers.LlavaNextVideoConfig.video_seq_length",description:`<strong>video_seq_length</strong> (<code>int</code>, <em>optional</em>, defaults to 288) &#x2014;
Sequence length of one video embedding.`,name:"video_seq_length"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_next_video/configuration_llava_next_video.py#L27"}}),R=new ia({props:{anchor:"transformers.LlavaNextVideoConfig.example",$$slots:{default:[ua]},$$scope:{ctx:L}}}),We=new j({props:{title:"LlavaNextVideoProcessor",local:"transformers.LlavaNextVideoProcessor",headingTag:"h2"}}),Fe=new V({props:{name:"class transformers.LlavaNextVideoProcessor",anchor:"transformers.LlavaNextVideoProcessor",parameters:[{name:"video_processor",val:" = None"},{name:"image_processor",val:" = None"},{name:"tokenizer",val:" = None"},{name:"chat_template",val:" = None"},{name:"patch_size",val:" = None"},{name:"vision_feature_select_strategy",val:" = None"},{name:"video_token",val:" = '<video>'"},{name:"image_token",val:" = '<image>'"},{name:"num_additional_image_tokens",val:" = 0"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LlavaNextVideoProcessor.video_processor",description:`<strong>video_processor</strong> (<a href="/docs/transformers/main/en/model_doc/llava_next_video#transformers.LlavaNextVideoVideoProcessor">LlavaNextVideoVideoProcessor</a>, <em>optional</em>) &#x2014;
The video processor is a required input.`,name:"video_processor"},{anchor:"transformers.LlavaNextVideoProcessor.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/main/en/model_doc/llava_next#transformers.LlavaNextImageProcessor">LlavaNextImageProcessor</a>, <em>optional</em>) &#x2014;
The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.LlavaNextVideoProcessor.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>, <em>optional</em>) &#x2014;
The tokenizer is a required input.`,name:"tokenizer"},{anchor:"transformers.LlavaNextVideoProcessor.chat_template",description:`<strong>chat_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Jinja chat template that will be used in tokenizer&#x2019;s <code>apply_chat_template</code>`,name:"chat_template"},{anchor:"transformers.LlavaNextVideoProcessor.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Patch size from the vision tower.`,name:"patch_size"},{anchor:"transformers.LlavaNextVideoProcessor.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.
Should be same as in model&#x2019;s config`,name:"vision_feature_select_strategy"},{anchor:"transformers.LlavaNextVideoProcessor.video_token",description:`<strong>video_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;video&gt;&quot;</code>) &#x2014;
Special token used to denote video location.`,name:"video_token"},{anchor:"transformers.LlavaNextVideoProcessor.image_token",description:`<strong>image_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;image&gt;&quot;</code>) &#x2014;
Special token used to denote image location.`,name:"image_token"},{anchor:"transformers.LlavaNextVideoProcessor.num_additional_image_tokens",description:`<strong>num_additional_image_tokens</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Number of additional tokens added to the image embeddings, such as CLS (+1). If the backbone has no CLS or other
extra tokens appended, no need to set this arg.`,name:"num_additional_image_tokens"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_next_video/processing_llava_next_video.py#L47"}}),Re=new V({props:{name:"batch_decode",anchor:"transformers.LlavaNextVideoProcessor.batch_decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_next_video/processing_llava_next_video.py#L271"}}),Ae=new V({props:{name:"decode",anchor:"transformers.LlavaNextVideoProcessor.decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_next_video/processing_llava_next_video.py#L279"}}),Xe=new j({props:{title:"LlavaNextVideoImageProcessor",local:"transformers.LlavaNextVideoImageProcessor",headingTag:"h2"}}),Ee=new V({props:{name:"class transformers.LlavaNextVideoImageProcessor",anchor:"transformers.LlavaNextVideoImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"image_grid_pinpoints",val:": typing.Optional[typing.List] = None"},{name:"resample",val:": Resampling = <Resampling.BICUBIC: 3>"},{name:"do_center_crop",val:": bool = True"},{name:"crop_size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_convert_rgb",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LlavaNextVideoImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overridden by
<code>do_resize</code> in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.LlavaNextVideoImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;shortest_edge&quot; -- 224}</code>):
Size of the image after resizing. The shortest edge of the image is resized to size[&#x201C;shortest_edge&#x201D;], with
the longest edge resized to keep the input aspect ratio. Can be overridden by <code>size</code> in the <code>preprocess</code>
method.`,name:"size"},{anchor:"transformers.LlavaNextVideoImageProcessor.image_grid_pinpoints",description:`<strong>image_grid_pinpoints</strong> (<code>List</code> <em>optional</em>, defaults to <code>[[672, 336], [336, 672], [672, 672], [336, 1008], [1008, 336]]</code>) &#x2014;
A list of possible resolutions to use for processing high resolution images. The best resolution is selected
based on the original size of the image. Can be overridden by <code>image_grid_pinpoints</code> in the <code>preprocess</code>
method. Not used for processing videos.`,name:"image_grid_pinpoints"},{anchor:"transformers.LlavaNextVideoImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>Resampling.BICUBIC</code>) &#x2014;
Resampling filter to use if resizing the image. Can be overridden by <code>resample</code> in the <code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.LlavaNextVideoImageProcessor.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to center crop the image to the specified <code>crop_size</code>. Can be overridden by <code>do_center_crop</code> in the
<code>preprocess</code> method.`,name:"do_center_crop"},{anchor:"transformers.LlavaNextVideoImageProcessor.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to 224) &#x2014;
Size of the output image after applying <code>center_crop</code>. Can be overridden by <code>crop_size</code> in the <code>preprocess</code>
method.`,name:"crop_size"},{anchor:"transformers.LlavaNextVideoImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by <code>do_rescale</code> in
the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.LlavaNextVideoImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by <code>rescale_factor</code> in the <code>preprocess</code>
method.`,name:"rescale_factor"},{anchor:"transformers.LlavaNextVideoImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by <code>do_normalize</code> in the <code>preprocess</code> method.`,name:"do_normalize"},{anchor:"transformers.LlavaNextVideoImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>[0.48145466, 0.4578275, 0.40821073]</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.LlavaNextVideoImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>[0.26862954, 0.26130258, 0.27577711]</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.
Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.LlavaNextVideoImageProcessor.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_next_video/image_processing_llava_next_video.py#L47"}}),Pe=new V({props:{name:"preprocess",anchor:"transformers.LlavaNextVideoImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[typing.List[ForwardRef('PIL.Image.Image')], ForwardRef('np.ndarray'), ForwardRef('torch.Tensor'), typing.List[ForwardRef('np.ndarray')], typing.List[ForwardRef('torch.Tensor')], typing.List[typing.List[ForwardRef('PIL.Image.Image')]], typing.List[typing.List[ForwardRef('np.ndarrray')]], typing.List[typing.List[ForwardRef('torch.Tensor')]]]"},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"resample",val:": Resampling = None"},{name:"do_center_crop",val:": typing.Optional[bool] = None"},{name:"crop_size",val:": typing.Optional[int] = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Optional[float] = None"},{name:"do_normalize",val:": typing.Optional[bool] = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_convert_rgb",val:": typing.Optional[bool] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": typing.Optional[transformers.image_utils.ChannelDimension] = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.LlavaNextVideoImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>VideoInput</code>) &#x2014;
Videos to preprocess. Expects a single or batch of videos with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.LlavaNextVideoImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the video.`,name:"do_resize"},{anchor:"transformers.LlavaNextVideoImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the video after resizing. Shortest edge of the video is resized to size[&#x201C;shortest_edge&#x201D;], with
the longest edge resized to keep the input aspect ratio.`,name:"size"},{anchor:"transformers.LlavaNextVideoImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the video. This can be one of the enum <code>PILImageResampling</code>. Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.LlavaNextVideoImageProcessor.preprocess.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_center_crop</code>) &#x2014;
Whether to center crop the video.`,name:"do_center_crop"},{anchor:"transformers.LlavaNextVideoImageProcessor.preprocess.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.crop_size</code>) &#x2014;
Size of the center crop. Only has an effect if <code>do_center_crop</code> is set to <code>True</code>.`,name:"crop_size"},{anchor:"transformers.LlavaNextVideoImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the video.`,name:"do_rescale"},{anchor:"transformers.LlavaNextVideoImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the video by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.LlavaNextVideoImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the video.`,name:"do_normalize"},{anchor:"transformers.LlavaNextVideoImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Frame mean to use for normalization. Only has an effect if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.LlavaNextVideoImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Frame standard deviation to use for normalization. Only has an effect if <code>do_normalize</code> is set to
<code>True</code>.`,name:"image_std"},{anchor:"transformers.LlavaNextVideoImageProcessor.preprocess.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_convert_rgb</code>) &#x2014;
Whether to convert the video to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.LlavaNextVideoImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.LlavaNextVideoImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.LlavaNextVideoImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_next_video/image_processing_llava_next_video.py#L278"}}),Qe=new V({props:{name:"resize",anchor:"transformers.LlavaNextVideoImageProcessor.resize",parameters:[{name:"image",val:": ndarray"},{name:"size",val:": typing.Dict[str, int]"},{name:"resample",val:": Resampling = <Resampling.BICUBIC: 3>"},{name:"data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LlavaNextVideoImageProcessor.resize.image",description:`<strong>image</strong> (<code>np.ndarray</code>) &#x2014;
Image to resize.`,name:"image"},{anchor:"transformers.LlavaNextVideoImageProcessor.resize.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>) &#x2014;
Size of the output image.`,name:"size"},{anchor:"transformers.LlavaNextVideoImageProcessor.resize.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>PILImageResampling.BICUBIC</code>) &#x2014;
Resampling filter to use when resiizing the image.`,name:"resample"},{anchor:"transformers.LlavaNextVideoImageProcessor.resize.data_format",description:`<strong>data_format</strong> (<code>str</code> or <code>ChannelDimension</code>, <em>optional</em>) &#x2014;
The channel dimension format of the image. If not provided, it will be the same as the input image.`,name:"data_format"},{anchor:"transformers.LlavaNextVideoImageProcessor.resize.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format of the input image. If not provided, it will be inferred.`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_next_video/image_processing_llava_next_video.py#L128"}}),Se=new j({props:{title:"LlavaNextVideoVideoProcessor",local:"transformers.LlavaNextVideoVideoProcessor",headingTag:"h2"}}),Ye=new V({props:{name:"class transformers.LlavaNextVideoVideoProcessor",anchor:"transformers.LlavaNextVideoVideoProcessor",parameters:[{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.llava_next_video.video_processing_llava_next_video.LlavaNextVideoFastVideoProcessorInitKwargs]"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_next_video/video_processing_llava_next_video.py#L36"}}),De=new j({props:{title:"LlavaNextVideoModel",local:"transformers.LlavaNextVideoModel",headingTag:"h2"}}),Oe=new V({props:{name:"class transformers.LlavaNextVideoModel",anchor:"transformers.LlavaNextVideoModel",parameters:[{name:"config",val:": LlavaNextVideoConfig"}],parametersDescription:[{anchor:"transformers.LlavaNextVideoModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/llava_next_video#transformers.LlavaNextVideoConfig">LlavaNextVideoConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_next_video/modeling_llava_next_video.py#L320"}}),Ke=new V({props:{name:"forward",anchor:"transformers.LlavaNextVideoModel.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"pixel_values",val:": FloatTensor = None"},{name:"pixel_values_videos",val:": FloatTensor = None"},{name:"image_sizes",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"vision_feature_layer",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"vision_feature_select_strategy",val:": typing.Optional[str] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.modeling_flash_attention_utils.FlashAttentionKwargs]"}],parametersDescription:[{anchor:"transformers.LlavaNextVideoModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LlavaNextVideoModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.LlavaNextVideoModel.forward.pixel_values_videos",description:'<strong>pixel_values_videos</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_frames, num_channels, image_size, image_size)) -- The tensors corresponding to the input videos. Pixel values can be obtained using [AutoImageProcessor](/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor). See </code>LlavaNextVideoVideoProcessor.<strong>call</strong>()` for details. <a href="/docs/transformers/main/en/model_doc/llava#transformers.LlavaProcessor">LlavaProcessor</a> uses\n<a href="/docs/transformers/main/en/model_doc/llava_next_video#transformers.LlavaNextVideoVideoProcessor">LlavaNextVideoVideoProcessor</a> for processing videos.',name:"pixel_values_videos"},{anchor:"transformers.LlavaNextVideoModel.forward.image_sizes",description:`<strong>image_sizes</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2)</code>, <em>optional</em>) &#x2014;
The sizes of the images in the batch, being (height, width) for each image.`,name:"image_sizes"},{anchor:"transformers.LlavaNextVideoModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.LlavaNextVideoModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.LlavaNextVideoModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>List[torch.FloatTensor]</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.LlavaNextVideoModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.LlavaNextVideoModel.forward.vision_feature_layer",description:`<strong>vision_feature_layer</strong> (<code>Union[int, List[int], NoneType]</code>) &#x2014;
The index of the layer to select the vision feature. If multiple indices are provided,
the vision feature of the corresponding indices will be concatenated to form the
vision features.`,name:"vision_feature_layer"},{anchor:"transformers.LlavaNextVideoModel.forward.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.
Can be one of <code>&quot;default&quot;</code> or <code>&quot;full&quot;</code>.`,name:"vision_feature_select_strategy"},{anchor:"transformers.LlavaNextVideoModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.LlavaNextVideoModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.LlavaNextVideoModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.LlavaNextVideoModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.LlavaNextVideoModel.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_next_video/modeling_llava_next_video.py#L494",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.llava_next_video.modeling_llava_next_video.LlavaNextVideoModelOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/llava_next_video#transformers.LlavaNextVideoConfig"
>LlavaNextVideoConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>image_hidden_states</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) — A <code>torch.FloatTensor</code> of size <code>(batch_size, num_images, sequence_length, hidden_size)</code>.
image_hidden_states of the model produced by the vision encoder and after projecting the last hidden state.</p>
</li>
<li>
<p><strong>video_hidden_states</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) — A <code>torch.FloatTensor</code>  of size <code>(batch_size * num_frames, num_videos, sequence_length, hidden_size)</code>.
video_hidden_states of the model produced by the vision encoder and after projecting the last hidden state.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.llava_next_video.modeling_llava_next_video.LlavaNextVideoModelOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),P=new qo({props:{$$slots:{default:[fa]},$$scope:{ctx:L}}}),et=new V({props:{name:"get_image_features",anchor:"transformers.LlavaNextVideoModel.get_image_features",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"image_sizes",val:": Tensor"},{name:"vision_feature_layer",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"vision_feature_select_strategy",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"transformers.LlavaNextVideoModel.get_image_features.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor]</code> of shape <code>(batch_size, num_patches, channels, height, width)</code>) &#x2014;
The tensors corresponding to the input images.`,name:"pixel_values"},{anchor:"transformers.LlavaNextVideoModel.get_image_features.image_sizes",description:`<strong>image_sizes</strong> (<code>torch.Tensor</code> of shape <code>(num_images, 2)</code>) &#x2014;
Actual image size of each images (H, W).`,name:"image_sizes"},{anchor:"transformers.LlavaNextVideoModel.get_image_features.vision_feature_layer",description:`<strong>vision_feature_layer</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The index of the layer to select the vision feature. If multiple indices are provided,
the vision feature of the corresponding indices will be concatenated to form the
vision features.`,name:"vision_feature_layer"},{anchor:"transformers.LlavaNextVideoModel.get_image_features.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.
Can be one of <code>&quot;default&quot;</code> or <code>&quot;full&quot;</code>`,name:"vision_feature_select_strategy"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_next_video/modeling_llava_next_video.py#L418",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of image feature tensor, each contains all the visual feature of all patches
and are of shape <code>(num_patches, image_length, embed_dim)</code>).</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>image_features (List<code>torch.Tensor</code>)</p>
`}}),tt=new V({props:{name:"get_video_features",anchor:"transformers.LlavaNextVideoModel.get_video_features",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"vision_feature_layer",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"vision_feature_select_strategy",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"transformers.LlavaNextVideoModel.get_video_features.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor]</code> of shape <code>(batch_size, num_frames, channels, height, width)</code>) &#x2014;
The tensors corresponding to the input video.`,name:"pixel_values"},{anchor:"transformers.LlavaNextVideoModel.get_video_features.vision_feature_layer",description:`<strong>vision_feature_layer</strong> (<code>Union[int, List[int]]</code>, <em>optiona;</em>) &#x2014;
The index of the layer to select the vision feature. If multiple indices are provided,
the vision feature of the corresponding indices will be concatenated to form the
vision features.`,name:"vision_feature_layer"},{anchor:"transformers.LlavaNextVideoModel.get_video_features.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.
Can be one of <code>&quot;default&quot;</code> or <code>&quot;full&quot;</code>`,name:"vision_feature_select_strategy"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_next_video/modeling_llava_next_video.py#L611",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of video feature tensor, each contains all the visual feature of all patches
and are of shape <code>(num_videos, video_length, embed_dim)</code>).</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>video_features (List<code>torch.Tensor</code>)</p>
`}}),ot=new V({props:{name:"pack_image_features",anchor:"transformers.LlavaNextVideoModel.pack_image_features",parameters:[{name:"image_features",val:""},{name:"image_sizes",val:""},{name:"vision_feature_select_strategy",val:""},{name:"image_newline",val:" = None"}],parametersDescription:[{anchor:"transformers.LlavaNextVideoModel.pack_image_features.image_features",description:`<strong>image_features</strong> (<code>List[torch.Tensor]</code> of length num_images, each of shape <code>(num_patches, image_length, embed_dim)</code>) &#x2014;
List of image feature tensor, each contains all the visual feature of all patches.`,name:"image_features"},{anchor:"transformers.LlavaNextVideoModel.pack_image_features.image_sizes",description:`<strong>image_sizes</strong> (<code>torch.Tensor</code> of shape <code>(num_images, 2)</code>) &#x2014;
Actual image size of each images (H, W).`,name:"image_sizes"},{anchor:"transformers.LlavaNextVideoModel.pack_image_features.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.`,name:"vision_feature_select_strategy"},{anchor:"transformers.LlavaNextVideoModel.pack_image_features.image_newline",description:`<strong>image_newline</strong> (<code>torch.Tensor</code> of shape <code>(embed_dim)</code>) &#x2014;
New line embedding vector.`,name:"image_newline"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_next_video/modeling_llava_next_video.py#L351",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>image_features (<code>torch.Tensor</code> of shape <code>(all_feat_len, embed_dim)</code>)
feature_lens (<code>List[int]</code>)
token length of each image in image_features</p>
`}}),nt=new j({props:{title:"LlavaNextVideoForConditionalGeneration",local:"transformers.LlavaNextVideoForConditionalGeneration",headingTag:"h2"}}),at=new V({props:{name:"class transformers.LlavaNextVideoForConditionalGeneration",anchor:"transformers.LlavaNextVideoForConditionalGeneration",parameters:[{name:"config",val:": LlavaNextVideoConfig"}],parametersDescription:[{anchor:"transformers.LlavaNextVideoForConditionalGeneration.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/llava_next_video#transformers.LlavaNextVideoConfig">LlavaNextVideoConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_next_video/modeling_llava_next_video.py#L670"}}),st=new V({props:{name:"forward",anchor:"transformers.LlavaNextVideoForConditionalGeneration.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"pixel_values",val:": FloatTensor = None"},{name:"pixel_values_videos",val:": FloatTensor = None"},{name:"image_sizes",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"vision_feature_layer",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"vision_feature_select_strategy",val:": typing.Optional[str] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"logits_to_keep",val:": typing.Union[int, torch.Tensor] = 0"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.llava_next_video.modeling_llava_next_video.KwargsForCausalLM]"}],parametersDescription:[{anchor:"transformers.LlavaNextVideoForConditionalGeneration.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LlavaNextVideoForConditionalGeneration.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.LlavaNextVideoForConditionalGeneration.forward.pixel_values_videos",description:'<strong>pixel_values_videos</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_frames, num_channels, image_size, image_size)) -- The tensors corresponding to the input videos. Pixel values can be obtained using [AutoImageProcessor](/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor). See </code>LlavaNextVideoVideoProcessor.<strong>call</strong>()` for details. <a href="/docs/transformers/main/en/model_doc/llava#transformers.LlavaProcessor">LlavaProcessor</a> uses\n<a href="/docs/transformers/main/en/model_doc/llava_next_video#transformers.LlavaNextVideoVideoProcessor">LlavaNextVideoVideoProcessor</a> for processing videos.',name:"pixel_values_videos"},{anchor:"transformers.LlavaNextVideoForConditionalGeneration.forward.image_sizes",description:`<strong>image_sizes</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2)</code>, <em>optional</em>) &#x2014;
The sizes of the images in the batch, being (height, width) for each image.`,name:"image_sizes"},{anchor:"transformers.LlavaNextVideoForConditionalGeneration.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.LlavaNextVideoForConditionalGeneration.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.LlavaNextVideoForConditionalGeneration.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>List[torch.FloatTensor]</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.LlavaNextVideoForConditionalGeneration.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.LlavaNextVideoForConditionalGeneration.forward.vision_feature_layer",description:`<strong>vision_feature_layer</strong> (<code>Union[int, List[int], NoneType]</code>) &#x2014;
The index of the layer to select the vision feature. If multiple indices are provided,
the vision feature of the corresponding indices will be concatenated to form the
vision features.`,name:"vision_feature_layer"},{anchor:"transformers.LlavaNextVideoForConditionalGeneration.forward.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.
Can be one of <code>&quot;default&quot;</code> or <code>&quot;full&quot;</code>.`,name:"vision_feature_select_strategy"},{anchor:"transformers.LlavaNextVideoForConditionalGeneration.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"labels"},{anchor:"transformers.LlavaNextVideoForConditionalGeneration.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.LlavaNextVideoForConditionalGeneration.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.LlavaNextVideoForConditionalGeneration.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.LlavaNextVideoForConditionalGeneration.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.LlavaNextVideoForConditionalGeneration.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"},{anchor:"transformers.LlavaNextVideoForConditionalGeneration.forward.logits_to_keep",description:`<strong>logits_to_keep</strong> (<code>Union[int, torch.Tensor]</code>, defaults to <code>0</code>) &#x2014;
If an <code>int</code>, compute logits for the last <code>logits_to_keep</code> tokens. If <code>0</code>, calculate logits for all
<code>input_ids</code> (special case). Only last token logits are needed for generation, and calculating them only for that
token can save memory, which becomes pretty significant for long sequences or large vocabulary size.
If a <code>torch.Tensor</code>, must be 1D corresponding to the indices to keep in the sequence length dimension.
This is useful when using packed tensor format (single dimension for batch and sequence length).`,name:"logits_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_next_video/modeling_llava_next_video.py#L722",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.llava_next_video.modeling_llava_next_video.LlavaNextVideoCausalLMOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/llava_next_video#transformers.LlavaNextVideoConfig"
>LlavaNextVideoConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>image_hidden_states</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) — A <code>torch.FloatTensor</code> of size (batch_size * num_patches, num_images, sequence_length, hidden_size)\`.
image_hidden_states of the model produced by the vision encoder and after projecting the last hidden state.</p>
</li>
<li>
<p><strong>video_hidden_states</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) — A <code>torch.FloatTensor</code>  of size <code>(batch_size * num_frames, num_videos, sequence_length, hidden_size)</code>.
video_hidden_states of the model produced by the vision encoder and after projecting the last hidden state.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.llava_next_video.modeling_llava_next_video.LlavaNextVideoCausalLMOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Y=new qo({props:{$$slots:{default:[_a]},$$scope:{ctx:L}}}),D=new ia({props:{anchor:"transformers.LlavaNextVideoForConditionalGeneration.forward.example",$$slots:{default:[ya]},$$scope:{ctx:L}}}),it=new pa({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/llava_next_video.md"}}),{c(){d=i("meta"),M=a(),y=i("p"),v=a(),m(b.$$.fragment),_=a(),w=i("div"),w.innerHTML=_n,Nt=a(),m(ee.$$.fragment),kt=a(),te=i("p"),te.innerHTML=yn,$t=a(),oe=i("p"),oe.innerHTML=vn,zt=a(),ne=i("p"),ne.textContent=Mn,Zt=a(),ae=i("p"),ae.textContent=Tn,Bt=a(),se=i("p"),se.textContent=bn,qt=a(),ie=i("ul"),ie.innerHTML=wn,Gt=a(),re=i("p"),re.innerHTML=Jn,Wt=a(),m(le.$$.fragment),Ft=a(),de=i("ul"),de.innerHTML=Un,Rt=a(),m(W.$$.fragment),At=a(),ce=i("blockquote"),ce.innerHTML=xn,Xt=a(),m(me.$$.fragment),Et=a(),pe=i("p"),pe.innerHTML=jn,Pt=a(),he=i("p"),he.innerHTML=Cn,Qt=a(),ge=i("ul"),ge.innerHTML=In,St=a(),ue=i("p"),ue.innerHTML=Vn,Ht=a(),m(fe.$$.fragment),Yt=a(),_e=i("p"),_e.innerHTML=Ln,Dt=a(),m(ye.$$.fragment),Ot=a(),m(ve.$$.fragment),Kt=a(),Me=i("p"),Me.innerHTML=Nn,eo=a(),m(Te.$$.fragment),to=a(),m(be.$$.fragment),oo=a(),we=i("p"),we.textContent=kn,no=a(),m(Je.$$.fragment),ao=a(),m(Ue.$$.fragment),so=a(),m(xe.$$.fragment),io=a(),je=i("p"),je.textContent=$n,ro=a(),Ce=i("p"),Ce.innerHTML=zn,lo=a(),m(F.$$.fragment),co=a(),Ie=i("p"),Ie.innerHTML=Zn,mo=a(),m(Ve.$$.fragment),po=a(),m(Le.$$.fragment),ho=a(),Ne=i("p"),Ne.innerHTML=Bn,go=a(),ke=i("p"),ke.textContent=qn,uo=a(),m($e.$$.fragment),fo=a(),ze=i("p"),ze.innerHTML=Gn,_o=a(),Ze=i("p"),Ze.innerHTML=Wn,yo=a(),m(Be.$$.fragment),vo=a(),m(qe.$$.fragment),Mo=a(),z=i("div"),m(Ge.$$.fragment),Go=a(),dt=i("p"),dt.innerHTML=Fn,Wo=a(),m(R.$$.fragment),To=a(),m(We.$$.fragment),bo=a(),C=i("div"),m(Fe.$$.fragment),Fo=a(),ct=i("p"),ct.textContent=Rn,Ro=a(),mt=i("p"),mt.innerHTML=An,Ao=a(),A=i("div"),m(Re.$$.fragment),Xo=a(),pt=i("p"),pt.innerHTML=Xn,Eo=a(),X=i("div"),m(Ae.$$.fragment),Po=a(),ht=i("p"),ht.innerHTML=En,wo=a(),m(Xe.$$.fragment),Jo=a(),N=i("div"),m(Ee.$$.fragment),Qo=a(),gt=i("p"),gt.innerHTML=Pn,So=a(),ut=i("div"),m(Pe.$$.fragment),Ho=a(),E=i("div"),m(Qe.$$.fragment),Yo=a(),ft=i("p"),ft.textContent=Qn,Uo=a(),m(Se.$$.fragment),xo=a(),He=i("div"),m(Ye.$$.fragment),jo=a(),m(De.$$.fragment),Co=a(),T=i("div"),m(Oe.$$.fragment),Do=a(),_t=i("p"),_t.textContent=Sn,Oo=a(),yt=i("p"),yt.innerHTML=Hn,Ko=a(),vt=i("p"),vt.innerHTML=Yn,en=a(),B=i("div"),m(Ke.$$.fragment),tn=a(),Mt=i("p"),Mt.innerHTML=Dn,on=a(),m(P.$$.fragment),nn=a(),Q=i("div"),m(et.$$.fragment),an=a(),Tt=i("p"),Tt.textContent=On,sn=a(),S=i("div"),m(tt.$$.fragment),rn=a(),bt=i("p"),bt.textContent=Kn,ln=a(),H=i("div"),m(ot.$$.fragment),dn=a(),wt=i("p"),wt.textContent=ea,Io=a(),m(nt.$$.fragment),Vo=a(),I=i("div"),m(at.$$.fragment),cn=a(),Jt=i("p"),Jt.textContent=ta,mn=a(),Ut=i("p"),Ut.innerHTML=oa,pn=a(),xt=i("p"),xt.innerHTML=na,hn=a(),$=i("div"),m(st.$$.fragment),gn=a(),jt=i("p"),jt.innerHTML=aa,un=a(),m(Y.$$.fragment),fn=a(),m(D.$$.fragment),Lo=a(),m(it.$$.fragment),No=a(),Vt=i("p"),this.h()},l(e){const t=ma("svelte-u9bgzb",document.head);d=r(t,"META",{name:!0,content:!0}),t.forEach(o),M=s(e),y=r(e,"P",{}),U(y).forEach(o),v=s(e),p(b.$$.fragment,e),_=s(e),w=r(e,"DIV",{class:!0,"data-svelte-h":!0}),c(w)!=="svelte-b95w5j"&&(w.innerHTML=_n),Nt=s(e),p(ee.$$.fragment,e),kt=s(e),te=r(e,"P",{"data-svelte-h":!0}),c(te)!=="svelte-fz66h5"&&(te.innerHTML=yn),$t=s(e),oe=r(e,"P",{"data-svelte-h":!0}),c(oe)!=="svelte-smxnwa"&&(oe.innerHTML=vn),zt=s(e),ne=r(e,"P",{"data-svelte-h":!0}),c(ne)!=="svelte-1fhv1nu"&&(ne.textContent=Mn),Zt=s(e),ae=r(e,"P",{"data-svelte-h":!0}),c(ae)!=="svelte-1mxjeai"&&(ae.textContent=Tn),Bt=s(e),se=r(e,"P",{"data-svelte-h":!0}),c(se)!=="svelte-1p13ikg"&&(se.textContent=bn),qt=s(e),ie=r(e,"UL",{"data-svelte-h":!0}),c(ie)!=="svelte-15fjr1a"&&(ie.innerHTML=wn),Gt=s(e),re=r(e,"P",{"data-svelte-h":!0}),c(re)!=="svelte-1ddk3wd"&&(re.innerHTML=Jn),Wt=s(e),p(le.$$.fragment,e),Ft=s(e),de=r(e,"UL",{"data-svelte-h":!0}),c(de)!=="svelte-b32abk"&&(de.innerHTML=Un),Rt=s(e),p(W.$$.fragment,e),At=s(e),ce=r(e,"BLOCKQUOTE",{"data-svelte-h":!0}),c(ce)!=="svelte-nygwxc"&&(ce.innerHTML=xn),Xt=s(e),p(me.$$.fragment,e),Et=s(e),pe=r(e,"P",{"data-svelte-h":!0}),c(pe)!=="svelte-pavm2p"&&(pe.innerHTML=jn),Pt=s(e),he=r(e,"P",{"data-svelte-h":!0}),c(he)!=="svelte-1uqcr0x"&&(he.innerHTML=Cn),Qt=s(e),ge=r(e,"UL",{"data-svelte-h":!0}),c(ge)!=="svelte-imbcrg"&&(ge.innerHTML=In),St=s(e),ue=r(e,"P",{"data-svelte-h":!0}),c(ue)!=="svelte-itzdp2"&&(ue.innerHTML=Vn),Ht=s(e),p(fe.$$.fragment,e),Yt=s(e),_e=r(e,"P",{"data-svelte-h":!0}),c(_e)!=="svelte-hqx9qk"&&(_e.innerHTML=Ln),Dt=s(e),p(ye.$$.fragment,e),Ot=s(e),p(ve.$$.fragment,e),Kt=s(e),Me=r(e,"P",{"data-svelte-h":!0}),c(Me)!=="svelte-1pauxcy"&&(Me.innerHTML=Nn),eo=s(e),p(Te.$$.fragment,e),to=s(e),p(be.$$.fragment,e),oo=s(e),we=r(e,"P",{"data-svelte-h":!0}),c(we)!=="svelte-1ngvr6w"&&(we.textContent=kn),no=s(e),p(Je.$$.fragment,e),ao=s(e),p(Ue.$$.fragment,e),so=s(e),p(xe.$$.fragment,e),io=s(e),je=r(e,"P",{"data-svelte-h":!0}),c(je)!=="svelte-jd6m5t"&&(je.textContent=$n),ro=s(e),Ce=r(e,"P",{"data-svelte-h":!0}),c(Ce)!=="svelte-1mhpfy6"&&(Ce.innerHTML=zn),lo=s(e),p(F.$$.fragment,e),co=s(e),Ie=r(e,"P",{"data-svelte-h":!0}),c(Ie)!=="svelte-18yylzu"&&(Ie.innerHTML=Zn),mo=s(e),p(Ve.$$.fragment,e),po=s(e),p(Le.$$.fragment,e),ho=s(e),Ne=r(e,"P",{"data-svelte-h":!0}),c(Ne)!=="svelte-m1vtfc"&&(Ne.innerHTML=Bn),go=s(e),ke=r(e,"P",{"data-svelte-h":!0}),c(ke)!=="svelte-13kjllm"&&(ke.textContent=qn),uo=s(e),p($e.$$.fragment,e),fo=s(e),ze=r(e,"P",{"data-svelte-h":!0}),c(ze)!=="svelte-dzzatn"&&(ze.innerHTML=Gn),_o=s(e),Ze=r(e,"P",{"data-svelte-h":!0}),c(Ze)!=="svelte-z3ioid"&&(Ze.innerHTML=Wn),yo=s(e),p(Be.$$.fragment,e),vo=s(e),p(qe.$$.fragment,e),Mo=s(e),z=r(e,"DIV",{class:!0});var G=U(z);p(Ge.$$.fragment,G),Go=s(G),dt=r(G,"P",{"data-svelte-h":!0}),c(dt)!=="svelte-1ln5y00"&&(dt.innerHTML=Fn),Wo=s(G),p(R.$$.fragment,G),G.forEach(o),To=s(e),p(We.$$.fragment,e),bo=s(e),C=r(e,"DIV",{class:!0});var k=U(C);p(Fe.$$.fragment,k),Fo=s(k),ct=r(k,"P",{"data-svelte-h":!0}),c(ct)!=="svelte-ghr7nt"&&(ct.textContent=Rn),Ro=s(k),mt=r(k,"P",{"data-svelte-h":!0}),c(mt)!=="svelte-107phni"&&(mt.innerHTML=An),Ao=s(k),A=r(k,"DIV",{class:!0});var rt=U(A);p(Re.$$.fragment,rt),Xo=s(rt),pt=r(rt,"P",{"data-svelte-h":!0}),c(pt)!=="svelte-1o9eza"&&(pt.innerHTML=Xn),rt.forEach(o),Eo=s(k),X=r(k,"DIV",{class:!0});var lt=U(X);p(Ae.$$.fragment,lt),Po=s(lt),ht=r(lt,"P",{"data-svelte-h":!0}),c(ht)!=="svelte-kk16qw"&&(ht.innerHTML=En),lt.forEach(o),k.forEach(o),wo=s(e),p(Xe.$$.fragment,e),Jo=s(e),N=r(e,"DIV",{class:!0});var Z=U(N);p(Ee.$$.fragment,Z),Qo=s(Z),gt=r(Z,"P",{"data-svelte-h":!0}),c(gt)!=="svelte-1s9b4sb"&&(gt.innerHTML=Pn),So=s(Z),ut=r(Z,"DIV",{class:!0});var Lt=U(ut);p(Pe.$$.fragment,Lt),Lt.forEach(o),Ho=s(Z),E=r(Z,"DIV",{class:!0});var $o=U(E);p(Qe.$$.fragment,$o),Yo=s($o),ft=r($o,"P",{"data-svelte-h":!0}),c(ft)!=="svelte-1qmgo6y"&&(ft.textContent=Qn),$o.forEach(o),Z.forEach(o),Uo=s(e),p(Se.$$.fragment,e),xo=s(e),He=r(e,"DIV",{class:!0});var sa=U(He);p(Ye.$$.fragment,sa),sa.forEach(o),jo=s(e),p(De.$$.fragment,e),Co=s(e),T=r(e,"DIV",{class:!0});var x=U(T);p(Oe.$$.fragment,x),Do=s(x),_t=r(x,"P",{"data-svelte-h":!0}),c(_t)!=="svelte-yttze"&&(_t.textContent=Sn),Oo=s(x),yt=r(x,"P",{"data-svelte-h":!0}),c(yt)!=="svelte-6pahdo"&&(yt.innerHTML=Hn),Ko=s(x),vt=r(x,"P",{"data-svelte-h":!0}),c(vt)!=="svelte-hswkmf"&&(vt.innerHTML=Yn),en=s(x),B=r(x,"DIV",{class:!0});var Ct=U(B);p(Ke.$$.fragment,Ct),tn=s(Ct),Mt=r(Ct,"P",{"data-svelte-h":!0}),c(Mt)!=="svelte-t94zmp"&&(Mt.innerHTML=Dn),on=s(Ct),p(P.$$.fragment,Ct),Ct.forEach(o),nn=s(x),Q=r(x,"DIV",{class:!0});var zo=U(Q);p(et.$$.fragment,zo),an=s(zo),Tt=r(zo,"P",{"data-svelte-h":!0}),c(Tt)!=="svelte-1vzo9k5"&&(Tt.textContent=On),zo.forEach(o),sn=s(x),S=r(x,"DIV",{class:!0});var Zo=U(S);p(tt.$$.fragment,Zo),rn=s(Zo),bt=r(Zo,"P",{"data-svelte-h":!0}),c(bt)!=="svelte-1pusxhn"&&(bt.textContent=Kn),Zo.forEach(o),ln=s(x),H=r(x,"DIV",{class:!0});var Bo=U(H);p(ot.$$.fragment,Bo),dn=s(Bo),wt=r(Bo,"P",{"data-svelte-h":!0}),c(wt)!=="svelte-1rwyyz6"&&(wt.textContent=ea),Bo.forEach(o),x.forEach(o),Io=s(e),p(nt.$$.fragment,e),Vo=s(e),I=r(e,"DIV",{class:!0});var q=U(I);p(at.$$.fragment,q),cn=s(q),Jt=r(q,"P",{"data-svelte-h":!0}),c(Jt)!=="svelte-1sybkd5"&&(Jt.textContent=ta),mn=s(q),Ut=r(q,"P",{"data-svelte-h":!0}),c(Ut)!=="svelte-6pahdo"&&(Ut.innerHTML=oa),pn=s(q),xt=r(q,"P",{"data-svelte-h":!0}),c(xt)!=="svelte-hswkmf"&&(xt.innerHTML=na),hn=s(q),$=r(q,"DIV",{class:!0});var O=U($);p(st.$$.fragment,O),gn=s(O),jt=r(O,"P",{"data-svelte-h":!0}),c(jt)!=="svelte-fpouuf"&&(jt.innerHTML=aa),un=s(O),p(Y.$$.fragment,O),fn=s(O),p(D.$$.fragment,O),O.forEach(o),q.forEach(o),Lo=s(e),p(it.$$.fragment,e),No=s(e),Vt=r(e,"P",{}),U(Vt).forEach(o),this.h()},h(){J(d,"name","hf:doc:metadata"),J(d,"content",Ma),J(w,"class","flex flex-wrap space-x-1"),J(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(ut,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(He,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){l(document.head,d),n(e,M,t),n(e,y,t),n(e,v,t),h(b,e,t),n(e,_,t),n(e,w,t),n(e,Nt,t),h(ee,e,t),n(e,kt,t),n(e,te,t),n(e,$t,t),n(e,oe,t),n(e,zt,t),n(e,ne,t),n(e,Zt,t),n(e,ae,t),n(e,Bt,t),n(e,se,t),n(e,qt,t),n(e,ie,t),n(e,Gt,t),n(e,re,t),n(e,Wt,t),h(le,e,t),n(e,Ft,t),n(e,de,t),n(e,Rt,t),h(W,e,t),n(e,At,t),n(e,ce,t),n(e,Xt,t),h(me,e,t),n(e,Et,t),n(e,pe,t),n(e,Pt,t),n(e,he,t),n(e,Qt,t),n(e,ge,t),n(e,St,t),n(e,ue,t),n(e,Ht,t),h(fe,e,t),n(e,Yt,t),n(e,_e,t),n(e,Dt,t),h(ye,e,t),n(e,Ot,t),h(ve,e,t),n(e,Kt,t),n(e,Me,t),n(e,eo,t),h(Te,e,t),n(e,to,t),h(be,e,t),n(e,oo,t),n(e,we,t),n(e,no,t),h(Je,e,t),n(e,ao,t),h(Ue,e,t),n(e,so,t),h(xe,e,t),n(e,io,t),n(e,je,t),n(e,ro,t),n(e,Ce,t),n(e,lo,t),h(F,e,t),n(e,co,t),n(e,Ie,t),n(e,mo,t),h(Ve,e,t),n(e,po,t),h(Le,e,t),n(e,ho,t),n(e,Ne,t),n(e,go,t),n(e,ke,t),n(e,uo,t),h($e,e,t),n(e,fo,t),n(e,ze,t),n(e,_o,t),n(e,Ze,t),n(e,yo,t),h(Be,e,t),n(e,vo,t),h(qe,e,t),n(e,Mo,t),n(e,z,t),h(Ge,z,null),l(z,Go),l(z,dt),l(z,Wo),h(R,z,null),n(e,To,t),h(We,e,t),n(e,bo,t),n(e,C,t),h(Fe,C,null),l(C,Fo),l(C,ct),l(C,Ro),l(C,mt),l(C,Ao),l(C,A),h(Re,A,null),l(A,Xo),l(A,pt),l(C,Eo),l(C,X),h(Ae,X,null),l(X,Po),l(X,ht),n(e,wo,t),h(Xe,e,t),n(e,Jo,t),n(e,N,t),h(Ee,N,null),l(N,Qo),l(N,gt),l(N,So),l(N,ut),h(Pe,ut,null),l(N,Ho),l(N,E),h(Qe,E,null),l(E,Yo),l(E,ft),n(e,Uo,t),h(Se,e,t),n(e,xo,t),n(e,He,t),h(Ye,He,null),n(e,jo,t),h(De,e,t),n(e,Co,t),n(e,T,t),h(Oe,T,null),l(T,Do),l(T,_t),l(T,Oo),l(T,yt),l(T,Ko),l(T,vt),l(T,en),l(T,B),h(Ke,B,null),l(B,tn),l(B,Mt),l(B,on),h(P,B,null),l(T,nn),l(T,Q),h(et,Q,null),l(Q,an),l(Q,Tt),l(T,sn),l(T,S),h(tt,S,null),l(S,rn),l(S,bt),l(T,ln),l(T,H),h(ot,H,null),l(H,dn),l(H,wt),n(e,Io,t),h(nt,e,t),n(e,Vo,t),n(e,I,t),h(at,I,null),l(I,cn),l(I,Jt),l(I,mn),l(I,Ut),l(I,pn),l(I,xt),l(I,hn),l(I,$),h(st,$,null),l($,gn),l($,jt),l($,un),h(Y,$,null),l($,fn),h(D,$,null),n(e,Lo,t),h(it,e,t),n(e,No,t),n(e,Vt,t),ko=!0},p(e,[t]){const G={};t&2&&(G.$$scope={dirty:t,ctx:e}),W.$set(G);const k={};t&2&&(k.$$scope={dirty:t,ctx:e}),F.$set(k);const rt={};t&2&&(rt.$$scope={dirty:t,ctx:e}),R.$set(rt);const lt={};t&2&&(lt.$$scope={dirty:t,ctx:e}),P.$set(lt);const Z={};t&2&&(Z.$$scope={dirty:t,ctx:e}),Y.$set(Z);const Lt={};t&2&&(Lt.$$scope={dirty:t,ctx:e}),D.$set(Lt)},i(e){ko||(g(b.$$.fragment,e),g(ee.$$.fragment,e),g(le.$$.fragment,e),g(W.$$.fragment,e),g(me.$$.fragment,e),g(fe.$$.fragment,e),g(ye.$$.fragment,e),g(ve.$$.fragment,e),g(Te.$$.fragment,e),g(be.$$.fragment,e),g(Je.$$.fragment,e),g(Ue.$$.fragment,e),g(xe.$$.fragment,e),g(F.$$.fragment,e),g(Ve.$$.fragment,e),g(Le.$$.fragment,e),g($e.$$.fragment,e),g(Be.$$.fragment,e),g(qe.$$.fragment,e),g(Ge.$$.fragment,e),g(R.$$.fragment,e),g(We.$$.fragment,e),g(Fe.$$.fragment,e),g(Re.$$.fragment,e),g(Ae.$$.fragment,e),g(Xe.$$.fragment,e),g(Ee.$$.fragment,e),g(Pe.$$.fragment,e),g(Qe.$$.fragment,e),g(Se.$$.fragment,e),g(Ye.$$.fragment,e),g(De.$$.fragment,e),g(Oe.$$.fragment,e),g(Ke.$$.fragment,e),g(P.$$.fragment,e),g(et.$$.fragment,e),g(tt.$$.fragment,e),g(ot.$$.fragment,e),g(nt.$$.fragment,e),g(at.$$.fragment,e),g(st.$$.fragment,e),g(Y.$$.fragment,e),g(D.$$.fragment,e),g(it.$$.fragment,e),ko=!0)},o(e){u(b.$$.fragment,e),u(ee.$$.fragment,e),u(le.$$.fragment,e),u(W.$$.fragment,e),u(me.$$.fragment,e),u(fe.$$.fragment,e),u(ye.$$.fragment,e),u(ve.$$.fragment,e),u(Te.$$.fragment,e),u(be.$$.fragment,e),u(Je.$$.fragment,e),u(Ue.$$.fragment,e),u(xe.$$.fragment,e),u(F.$$.fragment,e),u(Ve.$$.fragment,e),u(Le.$$.fragment,e),u($e.$$.fragment,e),u(Be.$$.fragment,e),u(qe.$$.fragment,e),u(Ge.$$.fragment,e),u(R.$$.fragment,e),u(We.$$.fragment,e),u(Fe.$$.fragment,e),u(Re.$$.fragment,e),u(Ae.$$.fragment,e),u(Xe.$$.fragment,e),u(Ee.$$.fragment,e),u(Pe.$$.fragment,e),u(Qe.$$.fragment,e),u(Se.$$.fragment,e),u(Ye.$$.fragment,e),u(De.$$.fragment,e),u(Oe.$$.fragment,e),u(Ke.$$.fragment,e),u(P.$$.fragment,e),u(et.$$.fragment,e),u(tt.$$.fragment,e),u(ot.$$.fragment,e),u(nt.$$.fragment,e),u(at.$$.fragment,e),u(st.$$.fragment,e),u(Y.$$.fragment,e),u(D.$$.fragment,e),u(it.$$.fragment,e),ko=!1},d(e){e&&(o(M),o(y),o(v),o(_),o(w),o(Nt),o(kt),o(te),o($t),o(oe),o(zt),o(ne),o(Zt),o(ae),o(Bt),o(se),o(qt),o(ie),o(Gt),o(re),o(Wt),o(Ft),o(de),o(Rt),o(At),o(ce),o(Xt),o(Et),o(pe),o(Pt),o(he),o(Qt),o(ge),o(St),o(ue),o(Ht),o(Yt),o(_e),o(Dt),o(Ot),o(Kt),o(Me),o(eo),o(to),o(oo),o(we),o(no),o(ao),o(so),o(io),o(je),o(ro),o(Ce),o(lo),o(co),o(Ie),o(mo),o(po),o(ho),o(Ne),o(go),o(ke),o(uo),o(fo),o(ze),o(_o),o(Ze),o(yo),o(vo),o(Mo),o(z),o(To),o(bo),o(C),o(wo),o(Jo),o(N),o(Uo),o(xo),o(He),o(jo),o(Co),o(T),o(Io),o(Vo),o(I),o(Lo),o(No),o(Vt)),o(d),f(b,e),f(ee,e),f(le,e),f(W,e),f(me,e),f(fe,e),f(ye,e),f(ve,e),f(Te,e),f(be,e),f(Je,e),f(Ue,e),f(xe,e),f(F,e),f(Ve,e),f(Le,e),f($e,e),f(Be,e),f(qe,e),f(Ge),f(R),f(We,e),f(Fe),f(Re),f(Ae),f(Xe,e),f(Ee),f(Pe),f(Qe),f(Se,e),f(Ye),f(De,e),f(Oe),f(Ke),f(P),f(et),f(tt),f(ot),f(nt,e),f(at),f(st),f(Y),f(D),f(it,e)}}}const Ma='{"title":"LLaVa-NeXT-Video","local":"llava-next-video","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[{"title":"Formatting Prompts with Chat Templates","local":"formatting-prompts-with-chat-templates","sections":[],"depth":3}],"depth":2},{"title":"Usage example","local":"usage-example","sections":[{"title":"Single Media Mode","local":"single-media-mode","sections":[],"depth":3},{"title":"Mixed Media Mode","local":"mixed-media-mode","sections":[],"depth":3}],"depth":2},{"title":"Model optimization","local":"model-optimization","sections":[{"title":"Quantization using Bitsandbytes for memory efficiency","local":"quantization-using-bitsandbytes-for-memory-efficiency","sections":[],"depth":3},{"title":"Flash-Attention 2 to speed-up generation","local":"flash-attention-2-to-speed-up-generation","sections":[],"depth":3}],"depth":2},{"title":"LlavaNextVideoConfig","local":"transformers.LlavaNextVideoConfig","sections":[],"depth":2},{"title":"LlavaNextVideoProcessor","local":"transformers.LlavaNextVideoProcessor","sections":[],"depth":2},{"title":"LlavaNextVideoImageProcessor","local":"transformers.LlavaNextVideoImageProcessor","sections":[],"depth":2},{"title":"LlavaNextVideoVideoProcessor","local":"transformers.LlavaNextVideoVideoProcessor","sections":[],"depth":2},{"title":"LlavaNextVideoModel","local":"transformers.LlavaNextVideoModel","sections":[],"depth":2},{"title":"LlavaNextVideoForConditionalGeneration","local":"transformers.LlavaNextVideoForConditionalGeneration","sections":[],"depth":2}],"depth":1}';function Ta(L){return la(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Va extends da{constructor(d){super(),ca(this,d,Ta,va,ra,{})}}export{Va as component};
