import{s as Ls,z as Js,o as Rs,n as Ye}from"../chunks/scheduler.18a86fab.js";import{S as Bs,i as Ps,g as l,s as n,r as p,A as Xs,h as c,f as t,c as a,j as T,u as g,x as k,k as F,y as o,a as d,v as h,d as f,t as u,w as _}from"../chunks/index.98837b22.js";import{T as es}from"../chunks/Tip.77304350.js";import{D as x}from"../chunks/Docstring.6758ea23.js";import{C as lo}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as io}from"../chunks/ExampleCodeBlock.0c42463f.js";import{P as Ss}from"../chunks/PipelineTag.7749150e.js";import{H as X}from"../chunks/Heading.7e7e0c5b.js";import{E as Es}from"../chunks/getInferenceSnippets.de10bc7d.js";function Hs(z){let r,y=`This is a recently introduced model so the API hasn’t been tested extensively. There may be some bugs or slight
breaking changes to fix it in the future. If you see something strange, file a <a href="https://github.com/huggingface/transformers/issues/new?assignees=&amp;labels=&amp;template=bug-report.md&amp;title" rel="nofollow">Github Issue</a>.`;return{c(){r=l("p"),r.innerHTML=y},l(m){r=c(m,"P",{"data-svelte-h":!0}),k(r)!=="svelte-j665pk"&&(r.innerHTML=y)},m(m,b){d(m,r,b)},p:Ye,d(m){m&&t(r)}}}function Vs(z){let r,y="Examples:",m,b,M;return b=new lo({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1hc2tGb3JtZXJDb25maWclMkMlMjBNYXNrRm9ybWVyTW9kZWwlMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwTWFza0Zvcm1lciUyMGZhY2Vib29rJTJGbWFza2Zvcm1lci1zd2luLWJhc2UtYWRlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBNYXNrRm9ybWVyQ29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwbW9kZWwlMjAod2l0aCUyMHJhbmRvbSUyMHdlaWdodHMpJTIwZnJvbSUyMHRoZSUyMGZhY2Vib29rJTJGbWFza2Zvcm1lci1zd2luLWJhc2UtYWRlJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBNYXNrRm9ybWVyTW9kZWwoY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MaskFormerConfig, MaskFormerModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a MaskFormer facebook/maskformer-swin-base-ade configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = MaskFormerConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the facebook/maskformer-swin-base-ade style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MaskFormerModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){r=l("p"),r.textContent=y,m=n(),p(b.$$.fragment)},l(i){r=c(i,"P",{"data-svelte-h":!0}),k(r)!=="svelte-kvfsh7"&&(r.textContent=y),m=a(i),g(b.$$.fragment,i)},m(i,w){d(i,r,w),d(i,m,w),h(b,i,w),M=!0},p:Ye,i(i){M||(f(b.$$.fragment,i),M=!0)},o(i){u(b.$$.fragment,i),M=!1},d(i){i&&(t(r),t(m)),_(b,i)}}}function Os(z){let r,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=l("p"),r.innerHTML=y},l(m){r=c(m,"P",{"data-svelte-h":!0}),k(r)!=="svelte-fincs2"&&(r.innerHTML=y)},m(m,b){d(m,r,b)},p:Ye,d(m){m&&t(r)}}}function Gs(z){let r,y="Examples:",m,b,M;return b=new lo({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyME1hc2tGb3JtZXJNb2RlbCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBJTIzJTIwbG9hZCUyME1hc2tGb3JtZXIlMjBmaW5lLXR1bmVkJTIwb24lMjBBREUyMGslMjBzZW1hbnRpYyUyMHNlZ21lbnRhdGlvbiUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtYXNrZm9ybWVyLXN3aW4tYmFzZS1hZGUlMjIpJTBBbW9kZWwlMjAlM0QlMjBNYXNrRm9ybWVyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbWFza2Zvcm1lci1zd2luLWJhc2UtYWRlJTIyKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMGZvcndhcmQlMjBwYXNzJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQSUyMyUyMHRoZSUyMGRlY29kZXIlMjBvZiUyME1hc2tGb3JtZXIlMjBvdXRwdXRzJTIwaGlkZGVuJTIwc3RhdGVzJTIwb2YlMjBzaGFwZSUyMChiYXRjaF9zaXplJTJDJTIwbnVtX3F1ZXJpZXMlMkMlMjBoaWRkZW5fc2l6ZSklMEF0cmFuc2Zvcm1lcl9kZWNvZGVyX2xhc3RfaGlkZGVuX3N0YXRlJTIwJTNEJTIwb3V0cHV0cy50cmFuc2Zvcm1lcl9kZWNvZGVyX2xhc3RfaGlkZGVuX3N0YXRlJTBBbGlzdCh0cmFuc2Zvcm1lcl9kZWNvZGVyX2xhc3RfaGlkZGVuX3N0YXRlLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, MaskFormerModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load MaskFormer fine-tuned on ADE20k semantic segmentation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/maskformer-swin-base-ade&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MaskFormerModel.from_pretrained(<span class="hljs-string">&quot;facebook/maskformer-swin-base-ade&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># the decoder of MaskFormer outputs hidden states of shape (batch_size, num_queries, hidden_size)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>transformer_decoder_last_hidden_state = outputs.transformer_decoder_last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(transformer_decoder_last_hidden_state.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">100</span>, <span class="hljs-number">256</span>]`,wrap:!1}}),{c(){r=l("p"),r.textContent=y,m=n(),p(b.$$.fragment)},l(i){r=c(i,"P",{"data-svelte-h":!0}),k(r)!=="svelte-kvfsh7"&&(r.textContent=y),m=a(i),g(b.$$.fragment,i)},m(i,w){d(i,r,w),d(i,m,w),h(b,i,w),M=!0},p:Ye,i(i){M||(f(b.$$.fragment,i),M=!0)},o(i){u(b.$$.fragment,i),M=!1},d(i){i&&(t(r),t(m)),_(b,i)}}}function Ys(z){let r,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=l("p"),r.innerHTML=y},l(m){r=c(m,"P",{"data-svelte-h":!0}),k(r)!=="svelte-fincs2"&&(r.innerHTML=y)},m(m,b){d(m,r,b)},p:Ye,d(m){m&&t(r)}}}function qs(z){let r,y="Semantic segmentation example:",m,b,M;return b=new lo({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, MaskFormerForInstanceSegmentation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load MaskFormer fine-tuned on ADE20k semantic segmentation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/maskformer-swin-base-ade&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MaskFormerForInstanceSegmentation.from_pretrained(<span class="hljs-string">&quot;facebook/maskformer-swin-base-ade&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/fixtures_ade20k/resolve/main/ADE_val_00000001.jpg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts class_queries_logits of shape \`(batch_size, num_queries)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># and masks_queries_logits of shape \`(batch_size, num_queries, height, width)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>class_queries_logits = outputs.class_queries_logits
<span class="hljs-meta">&gt;&gt;&gt; </span>masks_queries_logits = outputs.masks_queries_logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># you can pass them to image_processor for postprocessing</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_semantic_map = image_processor.post_process_semantic_segmentation(
<span class="hljs-meta">... </span>    outputs, target_sizes=[(image.height, image.width)]
<span class="hljs-meta">... </span>)[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># we refer to the demo notebooks for visualization (see &quot;Resources&quot; section in the MaskFormer docs)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(predicted_semantic_map.shape)
[<span class="hljs-number">512</span>, <span class="hljs-number">683</span>]`,wrap:!1}}),{c(){r=l("p"),r.textContent=y,m=n(),p(b.$$.fragment)},l(i){r=c(i,"P",{"data-svelte-h":!0}),k(r)!=="svelte-ec2k7m"&&(r.textContent=y),m=a(i),g(b.$$.fragment,i)},m(i,w){d(i,r,w),d(i,m,w),h(b,i,w),M=!0},p:Ye,i(i){M||(f(b.$$.fragment,i),M=!0)},o(i){u(b.$$.fragment,i),M=!1},d(i){i&&(t(r),t(m)),_(b,i)}}}function As(z){let r,y="Panoptic segmentation example:",m,b,M;return b=new lo({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, MaskFormerForInstanceSegmentation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load MaskFormer fine-tuned on COCO panoptic segmentation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/maskformer-swin-base-coco&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MaskFormerForInstanceSegmentation.from_pretrained(<span class="hljs-string">&quot;facebook/maskformer-swin-base-coco&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts class_queries_logits of shape \`(batch_size, num_queries)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># and masks_queries_logits of shape \`(batch_size, num_queries, height, width)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>class_queries_logits = outputs.class_queries_logits
<span class="hljs-meta">&gt;&gt;&gt; </span>masks_queries_logits = outputs.masks_queries_logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># you can pass them to image_processor for postprocessing</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>result = image_processor.post_process_panoptic_segmentation(outputs, target_sizes=[(image.height, image.width)])[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># we refer to the demo notebooks for visualization (see &quot;Resources&quot; section in the MaskFormer docs)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_panoptic_map = result[<span class="hljs-string">&quot;segmentation&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(predicted_panoptic_map.shape)
[<span class="hljs-number">480</span>, <span class="hljs-number">640</span>]`,wrap:!1}}),{c(){r=l("p"),r.textContent=y,m=n(),p(b.$$.fragment)},l(i){r=c(i,"P",{"data-svelte-h":!0}),k(r)!=="svelte-1hqqxa2"&&(r.textContent=y),m=a(i),g(b.$$.fragment,i)},m(i,w){d(i,r,w),d(i,m,w),h(b,i,w),M=!0},p:Ye,i(i){M||(f(b.$$.fragment,i),M=!0)},o(i){u(b.$$.fragment,i),M=!1},d(i){i&&(t(r),t(m)),_(b,i)}}}function Ds(z){let r,y,m,b,M,i,w,ts='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',vt,O,xt,ie,$t,le,os='The MaskFormer model was proposed in <a href="https://arxiv.org/abs/2107.06278" rel="nofollow">Per-Pixel Classification is Not All You Need for Semantic Segmentation</a> by Bowen Cheng, Alexander G. Schwing, Alexander Kirillov. MaskFormer addresses semantic segmentation with a mask classification paradigm instead of performing classic pixel-level classification.',It,ce,ss="The abstract from the paper is the following:",jt,de,ns="<em>Modern approaches typically formulate semantic segmentation as a per-pixel classification task, while instance-level segmentation is handled with an alternative mask classification. Our key insight: mask classification is sufficiently general to solve both semantic- and instance-level segmentation tasks in a unified manner using the exact same model, loss, and training procedure. Following this observation, we propose MaskFormer, a simple mask classification model which predicts a set of binary masks, each associated with a single global class label prediction. Overall, the proposed mask classification-based method simplifies the landscape of effective approaches to semantic and panoptic segmentation tasks and shows excellent empirical results. In particular, we observe that MaskFormer outperforms per-pixel classification baselines when the number of classes is large. Our mask classification-based method outperforms both current state-of-the-art semantic (55.6 mIoU on ADE20K) and panoptic segmentation (52.7 PQ on COCO) models.</em>",zt,me,as='The figure below illustrates the architecture of MaskFormer. Taken from the <a href="https://arxiv.org/abs/2107.06278" rel="nofollow">original paper</a>.',Nt,pe,rs,Ut,ge,is='This model was contributed by <a href="https://huggingface.co/francesco" rel="nofollow">francesco</a>. The original code can be found <a href="https://github.com/facebookresearch/MaskFormer" rel="nofollow">here</a>.',Zt,he,Ct,fe,ls=`<li>MaskFormer’s Transformer decoder is identical to the decoder of <a href="detr">DETR</a>. During training, the authors of DETR did find it helpful to use auxiliary losses in the decoder, especially to help the model output the correct number of objects of each class. If you set the parameter <code>use_auxiliary_loss</code> of <a href="/docs/transformers/main/en/model_doc/maskformer#transformers.MaskFormerConfig">MaskFormerConfig</a> to <code>True</code>, then prediction feedforward neural networks and Hungarian losses are added after each decoder layer (with the FFNs sharing parameters).</li> <li>If you want to train the model in a distributed environment across multiple nodes, then one should update the
<code>get_num_masks</code> function inside in the <code>MaskFormerLoss</code> class of <code>modeling_maskformer.py</code>. When training on multiple nodes, this should be
set to the average number of target masks across all nodes, as can be seen in the original implementation <a href="https://github.com/facebookresearch/MaskFormer/blob/da3e60d85fdeedcb31476b5edd7d328826ce56cc/mask_former/modeling/criterion.py#L169" rel="nofollow">here</a>.</li> <li>One can use <a href="/docs/transformers/main/en/model_doc/maskformer#transformers.MaskFormerImageProcessor">MaskFormerImageProcessor</a> to prepare images for the model and optional targets for the model.</li> <li>To get the final segmentation, depending on the task, you can call <a href="/docs/transformers/main/en/model_doc/maskformer#transformers.MaskFormerImageProcessor.post_process_semantic_segmentation">post_process_semantic_segmentation()</a> or <a href="/docs/transformers/main/en/model_doc/maskformer#transformers.MaskFormerImageProcessor.post_process_panoptic_segmentation">post_process_panoptic_segmentation()</a>. Both tasks can be solved using <a href="/docs/transformers/main/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a> output, panoptic segmentation accepts an optional <code>label_ids_to_fuse</code> argument to fuse instances of the target object/s (e.g. sky) together.</li>`,Wt,ue,Lt,_e,Jt,be,cs='<li>All notebooks that illustrate inference as well as fine-tuning on custom data with MaskFormer can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/MaskFormer" rel="nofollow">here</a>.</li> <li>Scripts for finetuning <code>MaskFormer</code> with <a href="/docs/transformers/main/en/main_classes/trainer#transformers.Trainer">Trainer</a> or <a href="https://huggingface.co/docs/accelerate/index" rel="nofollow">Accelerate</a> can be found <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/instance-segmentation" rel="nofollow">here</a>.</li>',Rt,ke,Bt,S,Me,co,qe,ds='Class for outputs of <a href="/docs/transformers/main/en/model_doc/maskformer#transformers.MaskFormerModel">MaskFormerModel</a>. This class returns all the needed hidden states to compute the logits.',Pt,J,ye,mo,Ae,ms='Class for outputs of <a href="/docs/transformers/main/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a>.',po,De,ps=`This output can be directly passed to <a href="/docs/transformers/main/en/model_doc/maskformer#transformers.MaskFormerImageProcessor.post_process_semantic_segmentation">post_process_semantic_segmentation()</a> or or
<a href="/docs/transformers/main/en/model_doc/maskformer#transformers.MaskFormerImageProcessor.post_process_instance_segmentation">post_process_instance_segmentation()</a> or
<a href="/docs/transformers/main/en/model_doc/maskformer#transformers.MaskFormerImageProcessor.post_process_panoptic_segmentation">post_process_panoptic_segmentation()</a> depending on the task. Please, see
[\`~MaskFormerImageProcessor] for details regarding usage.`,Xt,Fe,St,I,we,go,Qe,gs=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/maskformer#transformers.MaskFormerModel">MaskFormerModel</a>. It is used to instantiate a
MaskFormer model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the MaskFormer
<a href="https://huggingface.co/facebook/maskformer-swin-base-ade" rel="nofollow">facebook/maskformer-swin-base-ade</a> architecture trained
on <a href="https://huggingface.co/datasets/scene_parse_150" rel="nofollow">ADE20k-150</a>.`,ho,Ke,hs=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,fo,et,fs='Currently, MaskFormer only supports the <a href="swin">Swin Transformer</a> as backbone.',uo,G,_o,Y,Te,bo,tt,us=`Instantiate a <a href="/docs/transformers/main/en/model_doc/maskformer#transformers.MaskFormerConfig">MaskFormerConfig</a> (or a derived class) from a pre-trained backbone model configuration and DETR model
configuration.`,Et,ve,Ht,v,xe,ko,ot,_s=`Constructs a MaskFormer image processor. The image processor can be used to prepare image(s) and optional targets
for the model.`,Mo,st,bs=`This image processor inherits from <a href="/docs/transformers/main/en/main_classes/image_processor#transformers.BaseImageProcessor">BaseImageProcessor</a> which contains most of the main methods. Users should
refer to this superclass for more information regarding those methods.`,yo,nt,$e,Fo,R,Ie,wo,at,ks="Pad images up to the largest image in a batch and create a corresponding <code>pixel_mask</code>.",To,rt,Ms=`MaskFormer addresses semantic segmentation with a mask classification paradigm, thus input segmentation maps
will be converted to lists of binary masks and their respective labels. Let’s see an example, assuming
<code>segmentation_maps = [[2,6,7,9]]</code>, the output will contain <code>mask_labels = [[1,0,0,0],[0,1,0,0],[0,0,1,0],[0,0,0,1]]</code> (four binary masks) and <code>class_labels = [2,6,7,9]</code>, the labels for
each mask.`,vo,q,je,xo,it,ys=`Converts the output of <a href="/docs/transformers/main/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a> into semantic segmentation maps. Only supports
PyTorch.`,$o,A,ze,Io,lt,Fs=`Converts the output of <code>MaskFormerForInstanceSegmentationOutput</code> into instance segmentation predictions. Only
supports PyTorch. If instances could overlap, set either return_coco_annotation or return_binary_maps
to <code>True</code> to get the correct segmentation result.`,jo,D,Ne,zo,ct,ws=`Converts the output of <code>MaskFormerForInstanceSegmentationOutput</code> into image panoptic segmentation
predictions. Only supports PyTorch.`,Vt,Ue,Ot,j,Ze,No,dt,Ce,Uo,B,We,Zo,mt,Ts="Pad images up to the largest image in a batch and create a corresponding <code>pixel_mask</code>.",Co,pt,vs=`MaskFormer addresses semantic segmentation with a mask classification paradigm, thus input segmentation maps
will be converted to lists of binary masks and their respective labels. Let’s see an example, assuming
<code>segmentation_maps = [[2,6,7,9]]</code>, the output will contain <code>mask_labels = [[1,0,0,0],[0,1,0,0],[0,0,1,0],[0,0,0,1]]</code> (four binary masks) and <code>class_labels = [2,6,7,9]</code>, the labels for
each mask.`,Wo,Q,Le,Lo,gt,xs=`Converts the output of <a href="/docs/transformers/main/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a> into semantic segmentation maps. Only supports
PyTorch.`,Jo,K,Je,Ro,ht,$s=`Converts the output of <code>MaskFormerForInstanceSegmentationOutput</code> into instance segmentation predictions. Only
supports PyTorch. If instances could overlap, set either return_coco_annotation or return_binary_maps
to <code>True</code> to get the correct segmentation result.`,Bo,ee,Re,Po,ft,Is=`Converts the output of <code>MaskFormerForInstanceSegmentationOutput</code> into image panoptic segmentation
predictions. Only supports PyTorch.`,Gt,Be,Yt,U,Pe,Xo,ut,js="The bare Maskformer Model outputting raw hidden-states without any specific head on top.",So,_t,zs=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Eo,bt,Ns=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Ho,C,Xe,Vo,kt,Us='The <a href="/docs/transformers/main/en/model_doc/maskformer#transformers.MaskFormerModel">MaskFormerModel</a> forward method, overrides the <code>__call__</code> special method.',Oo,te,Go,oe,qt,Se,At,E,Ee,Yo,N,He,qo,Mt,Zs='The <a href="/docs/transformers/main/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a> forward method, overrides the <code>__call__</code> special method.',Ao,se,Do,yt,Cs="Examples:",Qo,ne,Ko,ae,Dt,Ve,Qt,wt,Kt;return M=new X({props:{title:"MaskFormer",local:"maskformer",headingTag:"h1"}}),O=new es({props:{$$slots:{default:[Hs]},$$scope:{ctx:z}}}),ie=new X({props:{title:"Overview",local:"overview",headingTag:"h2"}}),he=new X({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),ue=new X({props:{title:"Resources",local:"resources",headingTag:"h2"}}),_e=new Ss({props:{pipeline:"image-segmentation"}}),ke=new X({props:{title:"MaskFormer specific outputs",local:"transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput",headingTag:"h2"}}),Me=new x({props:{name:"class transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput",anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput",parameters:[{name:"encoder_last_hidden_state",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pixel_decoder_last_hidden_state",val:": typing.Optional[torch.FloatTensor] = None"},{name:"transformer_decoder_last_hidden_state",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"pixel_decoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"transformer_decoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Last hidden states (final feature map) of the last stage of the encoder model (backbone).`,name:"encoder_last_hidden_state"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput.pixel_decoder_last_hidden_state",description:`<strong>pixel_decoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Last hidden states (final feature map) of the last stage of the pixel decoder model (FPN).`,name:"pixel_decoder_last_hidden_state"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput.transformer_decoder_last_hidden_state",description:`<strong>transformer_decoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Last hidden states (final feature map) of the last stage of the transformer decoder model.`,name:"transformer_decoder_last_hidden_state"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the encoder
model at the output of each stage.`,name:"encoder_hidden_states"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput.pixel_decoder_hidden_states",description:`<strong>pixel_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the pixel
decoder model at the output of each stage.`,name:"pixel_decoder_hidden_states"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput.transformer_decoder_hidden_states",description:`<strong>transformer_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states (also called feature maps) of the
transformer decoder at the output of each stage.`,name:"transformer_decoder_hidden_states"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput.hidden_states",description:`<strong>hidden_states</strong> <code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> containing <code>encoder_hidden_states</code>, <code>pixel_decoder_hidden_states</code> and
<code>decoder_hidden_states</code>`,name:"hidden_states"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights from Detr&#x2019;s decoder after the attention softmax, used to compute the
weighted average in the self-attention heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/maskformer/modeling_maskformer.py#L140"}}),ye=new x({props:{name:"class transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput",anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"class_queries_logits",val:": typing.Optional[torch.FloatTensor] = None"},{name:"masks_queries_logits",val:": typing.Optional[torch.FloatTensor] = None"},{name:"auxiliary_logits",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_last_hidden_state",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pixel_decoder_last_hidden_state",val:": typing.Optional[torch.FloatTensor] = None"},{name:"transformer_decoder_last_hidden_state",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"pixel_decoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"transformer_decoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput.loss",description:`<strong>loss</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
The computed loss, returned when labels are present.`,name:"loss"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput.class_queries_logits",description:`<strong>class_queries_logits</strong> (<code>torch.FloatTensor</code>) &#x2014;
A tensor of shape <code>(batch_size, num_queries, num_labels + 1)</code> representing the proposed classes for each
query. Note the <code>+ 1</code> is needed because we incorporate the null class.`,name:"class_queries_logits"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput.masks_queries_logits",description:`<strong>masks_queries_logits</strong> (<code>torch.FloatTensor</code>) &#x2014;
A tensor of shape <code>(batch_size, num_queries, height, width)</code> representing the proposed masks for each
query.`,name:"masks_queries_logits"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Last hidden states (final feature map) of the last stage of the encoder model (backbone).`,name:"encoder_last_hidden_state"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput.pixel_decoder_last_hidden_state",description:`<strong>pixel_decoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Last hidden states (final feature map) of the last stage of the pixel decoder model (FPN).`,name:"pixel_decoder_last_hidden_state"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput.transformer_decoder_last_hidden_state",description:`<strong>transformer_decoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Last hidden states (final feature map) of the last stage of the transformer decoder model.`,name:"transformer_decoder_last_hidden_state"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the encoder
model at the output of each stage.`,name:"encoder_hidden_states"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput.pixel_decoder_hidden_states",description:`<strong>pixel_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the pixel
decoder model at the output of each stage.`,name:"pixel_decoder_hidden_states"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput.transformer_decoder_hidden_states",description:`<strong>transformer_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the transformer decoder at the output
of each stage.`,name:"transformer_decoder_hidden_states"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput.hidden_states",description:`<strong>hidden_states</strong> <code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> containing <code>encoder_hidden_states</code>, <code>pixel_decoder_hidden_states</code> and
<code>decoder_hidden_states</code>.`,name:"hidden_states"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights from Detr&#x2019;s decoder after the attention softmax, used to compute the
weighted average in the self-attention heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/maskformer/modeling_maskformer.py#L183"}}),Fe=new X({props:{title:"MaskFormerConfig",local:"transformers.MaskFormerConfig",headingTag:"h2"}}),we=new x({props:{name:"class transformers.MaskFormerConfig",anchor:"transformers.MaskFormerConfig",parameters:[{name:"fpn_feature_size",val:": int = 256"},{name:"mask_feature_size",val:": int = 256"},{name:"no_object_weight",val:": float = 0.1"},{name:"use_auxiliary_loss",val:": bool = False"},{name:"backbone_config",val:": typing.Optional[typing.Dict] = None"},{name:"decoder_config",val:": typing.Optional[typing.Dict] = None"},{name:"init_std",val:": float = 0.02"},{name:"init_xavier_std",val:": float = 1.0"},{name:"dice_weight",val:": float = 1.0"},{name:"cross_entropy_weight",val:": float = 1.0"},{name:"mask_weight",val:": float = 20.0"},{name:"output_auxiliary_logits",val:": typing.Optional[bool] = None"},{name:"backbone",val:": typing.Optional[str] = None"},{name:"use_pretrained_backbone",val:": bool = False"},{name:"use_timm_backbone",val:": bool = False"},{name:"backbone_kwargs",val:": typing.Optional[typing.Dict] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MaskFormerConfig.mask_feature_size",description:`<strong>mask_feature_size</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
The masks&#x2019; features size, this value will also be used to specify the Feature Pyramid Network features&#x2019;
size.`,name:"mask_feature_size"},{anchor:"transformers.MaskFormerConfig.no_object_weight",description:`<strong>no_object_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
Weight to apply to the null (no object) class.`,name:"no_object_weight"},{anchor:"transformers.MaskFormerConfig.use_auxiliary_loss(bool,",description:`<strong>use_auxiliary_loss(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code> <code>MaskFormerForInstanceSegmentationOutput</code> will contain the auxiliary losses computed using the
logits from each decoder&#x2019;s stage.`,name:"use_auxiliary_loss(bool,"},{anchor:"transformers.MaskFormerConfig.backbone_config",description:`<strong>backbone_config</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
The configuration passed to the backbone, if unset, the configuration corresponding to
<code>swin-base-patch4-window12-384</code> will be used.`,name:"backbone_config"},{anchor:"transformers.MaskFormerConfig.backbone",description:`<strong>backbone</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of backbone to use when <code>backbone_config</code> is <code>None</code>. If <code>use_pretrained_backbone</code> is <code>True</code>, this
will load the corresponding pretrained weights from the timm or transformers library. If <code>use_pretrained_backbone</code>
is <code>False</code>, this loads the backbone&#x2019;s config and uses that to initialize the backbone with random weights.`,name:"backbone"},{anchor:"transformers.MaskFormerConfig.use_pretrained_backbone",description:`<strong>use_pretrained_backbone</strong> (<code>bool</code>, <em>optional</em>, <code>False</code>) &#x2014;
Whether to use pretrained weights for the backbone.`,name:"use_pretrained_backbone"},{anchor:"transformers.MaskFormerConfig.use_timm_backbone",description:`<strong>use_timm_backbone</strong> (<code>bool</code>, <em>optional</em>, <code>False</code>) &#x2014;
Whether to load <code>backbone</code> from the timm library. If <code>False</code>, the backbone is loaded from the transformers
library.`,name:"use_timm_backbone"},{anchor:"transformers.MaskFormerConfig.backbone_kwargs",description:`<strong>backbone_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Keyword arguments to be passed to AutoBackbone when loading from a checkpoint
e.g. <code>{&apos;out_indices&apos;: (0, 1, 2, 3)}</code>. Cannot be specified if <code>backbone_config</code> is set.`,name:"backbone_kwargs"},{anchor:"transformers.MaskFormerConfig.decoder_config",description:`<strong>decoder_config</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
The configuration passed to the transformer decoder model, if unset the base config for <code>detr-resnet-50</code>
will be used.`,name:"decoder_config"},{anchor:"transformers.MaskFormerConfig.init_std",description:`<strong>init_std</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"init_std"},{anchor:"transformers.MaskFormerConfig.init_xavier_std",description:`<strong>init_xavier_std</strong> (<code>float</code>, <em>optional</em>, defaults to 1) &#x2014;
The scaling factor used for the Xavier initialization gain in the HM Attention map module.`,name:"init_xavier_std"},{anchor:"transformers.MaskFormerConfig.dice_weight",description:`<strong>dice_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The weight for the dice loss.`,name:"dice_weight"},{anchor:"transformers.MaskFormerConfig.cross_entropy_weight",description:`<strong>cross_entropy_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The weight for the cross entropy loss.`,name:"cross_entropy_weight"},{anchor:"transformers.MaskFormerConfig.mask_weight",description:`<strong>mask_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 20.0) &#x2014;
The weight for the mask loss.`,name:"mask_weight"},{anchor:"transformers.MaskFormerConfig.output_auxiliary_logits",description:`<strong>output_auxiliary_logits</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Should the model output its <code>auxiliary_logits</code> or not.`,name:"output_auxiliary_logits"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/maskformer/configuration_maskformer.py#L30",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>ValueError</code> —
Raised if the backbone model type selected is not in <code>["swin"]</code> or the decoder model type selected is not
in <code>["detr"]</code></li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code></p>
`}}),G=new io({props:{anchor:"transformers.MaskFormerConfig.example",$$slots:{default:[Vs]},$$scope:{ctx:z}}}),Te=new x({props:{name:"from_backbone_and_decoder_configs",anchor:"transformers.MaskFormerConfig.from_backbone_and_decoder_configs",parameters:[{name:"backbone_config",val:": PretrainedConfig"},{name:"decoder_config",val:": PretrainedConfig"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MaskFormerConfig.from_backbone_and_decoder_configs.backbone_config",description:`<strong>backbone_config</strong> (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The backbone configuration.`,name:"backbone_config"},{anchor:"transformers.MaskFormerConfig.from_backbone_and_decoder_configs.decoder_config",description:`<strong>decoder_config</strong> (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The transformer decoder configuration to use.`,name:"decoder_config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/maskformer/configuration_maskformer.py#L203",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An instance of a configuration object</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/maskformer#transformers.MaskFormerConfig"
>MaskFormerConfig</a></p>
`}}),ve=new X({props:{title:"MaskFormerImageProcessor",local:"transformers.MaskFormerImageProcessor",headingTag:"h2"}}),xe=new x({props:{name:"class transformers.MaskFormerImageProcessor",anchor:"transformers.MaskFormerImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"size_divisor",val:": int = 32"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": float = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"ignore_index",val:": typing.Optional[int] = None"},{name:"do_reduce_labels",val:": bool = False"},{name:"num_labels",val:": typing.Optional[int] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MaskFormerImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the input to a certain <code>size</code>.`,name:"do_resize"},{anchor:"transformers.MaskFormerImageProcessor.size",description:`<strong>size</strong> (<code>int</code>, <em>optional</em>, defaults to 800) &#x2014;
Resize the input to the given size. Only has an effect if <code>do_resize</code> is set to <code>True</code>. If size is a
sequence like <code>(width, height)</code>, output size will be matched to this. If size is an int, smaller edge of
the image will be matched to this number. i.e, if <code>height &gt; width</code>, then image will be rescaled to <code>(size * height / width, size)</code>.`,name:"size"},{anchor:"transformers.MaskFormerImageProcessor.size_divisor",description:`<strong>size_divisor</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Some backbones need images divisible by a certain number. If not passed, it defaults to the value used in
Swin Transformer.`,name:"size_divisor"},{anchor:"transformers.MaskFormerImageProcessor.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>Resampling.BILINEAR</code>) &#x2014;
An optional resampling filter. This can be one of <code>PIL.Image.Resampling.NEAREST</code>,
<code>PIL.Image.Resampling.BOX</code>, <code>PIL.Image.Resampling.BILINEAR</code>, <code>PIL.Image.Resampling.HAMMING</code>,
<code>PIL.Image.Resampling.BICUBIC</code> or <code>PIL.Image.Resampling.LANCZOS</code>. Only has an effect if <code>do_resize</code> is set
to <code>True</code>.`,name:"resample"},{anchor:"transformers.MaskFormerImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the input to a certain <code>scale</code>.`,name:"do_rescale"},{anchor:"transformers.MaskFormerImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>1/ 255</code>) &#x2014;
Rescale the input by the given factor. Only has an effect if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.MaskFormerImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to normalize the input with mean and standard deviation.`,name:"do_normalize"},{anchor:"transformers.MaskFormerImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>int</code>, <em>optional</em>, defaults to <code>[0.485, 0.456, 0.406]</code>) &#x2014;
The sequence of means for each channel, to be used when normalizing images. Defaults to the ImageNet mean.`,name:"image_mean"},{anchor:"transformers.MaskFormerImageProcessor.image_std",description:`<strong>image_std</strong> (<code>int</code>, <em>optional</em>, defaults to <code>[0.229, 0.224, 0.225]</code>) &#x2014;
The sequence of standard deviations for each channel, to be used when normalizing images. Defaults to the
ImageNet std.`,name:"image_std"},{anchor:"transformers.MaskFormerImageProcessor.ignore_index",description:`<strong>ignore_index</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Label to be assigned to background pixels in segmentation maps. If provided, segmentation map pixels
denoted with 0 (background) will be replaced with <code>ignore_index</code>.`,name:"ignore_index"},{anchor:"transformers.MaskFormerImageProcessor.do_reduce_labels",description:`<strong>do_reduce_labels</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to decrement all label values of segmentation maps by 1. Usually used for datasets where 0
is used for background, and background itself is not included in all classes of a dataset (e.g. ADE20k).
The background label will be replaced by <code>ignore_index</code>.`,name:"do_reduce_labels"},{anchor:"transformers.MaskFormerImageProcessor.num_labels",description:`<strong>num_labels</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of labels in the segmentation map.`,name:"num_labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/maskformer/image_processing_maskformer.py#L357"}}),$e=new x({props:{name:"preprocess",anchor:"transformers.MaskFormerImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']]"},{name:"segmentation_maps",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor'], NoneType] = None"},{name:"instance_id_to_semantic_id",val:": typing.Optional[typing.Dict[int, int]] = None"},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"size_divisor",val:": typing.Optional[int] = None"},{name:"resample",val:": Resampling = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Optional[float] = None"},{name:"do_normalize",val:": typing.Optional[bool] = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"ignore_index",val:": typing.Optional[int] = None"},{name:"do_reduce_labels",val:": typing.Optional[bool] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension] = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/maskformer/image_processing_maskformer.py#L682"}}),Ie=new x({props:{name:"encode_inputs",anchor:"transformers.MaskFormerImageProcessor.encode_inputs",parameters:[{name:"pixel_values_list",val:": typing.List[typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']]]"},{name:"segmentation_maps",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']] = None"},{name:"instance_id_to_semantic_id",val:": typing.Union[typing.List[typing.Dict[int, int]], typing.Dict[int, int], NoneType] = None"},{name:"ignore_index",val:": typing.Optional[int] = None"},{name:"do_reduce_labels",val:": bool = False"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.MaskFormerImageProcessor.encode_inputs.pixel_values_list",description:`<strong>pixel_values_list</strong> (<code>List[ImageInput]</code>) &#x2014;
List of images (pixel values) to be padded. Each image should be a tensor of shape <code>(channels, height, width)</code>.`,name:"pixel_values_list"},{anchor:"transformers.MaskFormerImageProcessor.encode_inputs.segmentation_maps",description:`<strong>segmentation_maps</strong> (<code>ImageInput</code>, <em>optional</em>) &#x2014;
The corresponding semantic segmentation maps with the pixel-wise annotations.</p>
<p>(<code>bool</code>, <em>optional</em>, defaults to <code>True</code>):
Whether or not to pad images up to the largest image in a batch and create a pixel mask.</p>
<p>If left to the default, will return a pixel mask that is:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>`,name:"segmentation_maps"},{anchor:"transformers.MaskFormerImageProcessor.encode_inputs.instance_id_to_semantic_id",description:`<strong>instance_id_to_semantic_id</strong> (<code>List[Dict[int, int]]</code> or <code>Dict[int, int]</code>, <em>optional</em>) &#x2014;
A mapping between object instance ids and class ids. If passed, <code>segmentation_maps</code> is treated as an
instance segmentation map where each pixel represents an instance id. Can be provided as a single
dictionary with a global/dataset-level mapping or as a list of dictionaries (one per image), to map
instance ids in each image separately.`,name:"instance_id_to_semantic_id"},{anchor:"transformers.MaskFormerImageProcessor.encode_inputs.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/main/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>) &#x2014;
If set, will return tensors instead of NumPy arrays. If set to <code>&apos;pt&apos;</code>, return PyTorch <code>torch.Tensor</code>
objects.`,name:"return_tensors"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/maskformer/image_processing_maskformer.py#L867",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/feature_extractor#transformers.BatchFeature"
>BatchFeature</a> with the following fields:</p>
<ul>
<li><strong>pixel_values</strong> — Pixel values to be fed to a model.</li>
<li><strong>pixel_mask</strong> — Pixel mask to be fed to a model (when <code>=True</code> or if <code>pixel_mask</code> is in
<code>self.model_input_names</code>).</li>
<li><strong>mask_labels</strong> — Optional list of mask labels of shape <code>(labels, height, width)</code> to be fed to a model
(when <code>annotations</code> are provided).</li>
<li><strong>class_labels</strong> — Optional list of class labels of shape <code>(labels)</code> to be fed to a model (when
<code>annotations</code> are provided). They identify the labels of <code>mask_labels</code>, e.g. the label of
<code>mask_labels[i][j]</code> if <code>class_labels[i][j]</code>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/feature_extractor#transformers.BatchFeature"
>BatchFeature</a></p>
`}}),je=new x({props:{name:"post_process_semantic_segmentation",anchor:"transformers.MaskFormerImageProcessor.post_process_semantic_segmentation",parameters:[{name:"outputs",val:""},{name:"target_sizes",val:": typing.Optional[typing.List[typing.Tuple[int, int]]] = None"}],parametersDescription:[{anchor:"transformers.MaskFormerImageProcessor.post_process_semantic_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/main/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.MaskFormerImageProcessor.post_process_semantic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction. If left to None, predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/maskformer/image_processing_maskformer.py#L1024",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of length <code>batch_size</code>, where each item is a semantic segmentation map of shape (height, width)
corresponding to the target_sizes entry (if <code>target_sizes</code> is specified). Each entry of each
<code>torch.Tensor</code> correspond to a semantic class id.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[torch.Tensor]</code></p>
`}}),ze=new x({props:{name:"post_process_instance_segmentation",anchor:"transformers.MaskFormerImageProcessor.post_process_instance_segmentation",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"mask_threshold",val:": float = 0.5"},{name:"overlap_mask_area_threshold",val:": float = 0.8"},{name:"target_sizes",val:": typing.Optional[typing.List[typing.Tuple[int, int]]] = None"},{name:"return_coco_annotation",val:": typing.Optional[bool] = False"},{name:"return_binary_maps",val:": typing.Optional[bool] = False"}],parametersDescription:[{anchor:"transformers.MaskFormerImageProcessor.post_process_instance_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/main/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.MaskFormerImageProcessor.post_process_instance_segmentation.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The probability score threshold to keep predicted instance masks.`,name:"threshold"},{anchor:"transformers.MaskFormerImageProcessor.post_process_instance_segmentation.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Threshold to use when turning the predicted masks into binary values.`,name:"mask_threshold"},{anchor:"transformers.MaskFormerImageProcessor.post_process_instance_segmentation.overlap_mask_area_threshold",description:`<strong>overlap_mask_area_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
The overlap mask area threshold to merge or discard small disconnected parts within each binary
instance mask.`,name:"overlap_mask_area_threshold"},{anchor:"transformers.MaskFormerImageProcessor.post_process_instance_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction. If left to None, predictions will not be resized.`,name:"target_sizes"},{anchor:"transformers.MaskFormerImageProcessor.post_process_instance_segmentation.return_coco_annotation",description:`<strong>return_coco_annotation</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If set to <code>True</code>, segmentation maps are returned in COCO run-length encoding (RLE) format.`,name:"return_coco_annotation"},{anchor:"transformers.MaskFormerImageProcessor.post_process_instance_segmentation.return_binary_maps",description:`<strong>return_binary_maps</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If set to <code>True</code>, segmentation maps are returned as a concatenated tensor of binary segmentation maps
(one per detected instance).`,name:"return_binary_maps"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/maskformer/image_processing_maskformer.py#L1074",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, one per image, each dictionary containing two keys:</p>
<ul>
<li><strong>segmentation</strong> — A tensor of shape <code>(height, width)</code> where each pixel represents a <code>segment_id</code>, or
<code>List[List]</code> run-length encoding (RLE) of the segmentation map if return_coco_annotation is set to
<code>True</code>, or a tensor of shape <code>(num_instances, height, width)</code> if return_binary_maps is set to <code>True</code>.
Set to <code>None</code> if no mask if found above <code>threshold</code>.</li>
<li><strong>segments_info</strong> — A dictionary that contains additional information on each segment.<ul>
<li><strong>id</strong> — An integer representing the <code>segment_id</code>.</li>
<li><strong>label_id</strong> — An integer representing the label / semantic class id corresponding to <code>segment_id</code>.</li>
<li><strong>score</strong> — Prediction score of segment with <code>segment_id</code>.</li>
</ul></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),Ne=new x({props:{name:"post_process_panoptic_segmentation",anchor:"transformers.MaskFormerImageProcessor.post_process_panoptic_segmentation",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"mask_threshold",val:": float = 0.5"},{name:"overlap_mask_area_threshold",val:": float = 0.8"},{name:"label_ids_to_fuse",val:": typing.Optional[typing.Set[int]] = None"},{name:"target_sizes",val:": typing.Optional[typing.List[typing.Tuple[int, int]]] = None"}],parametersDescription:[{anchor:"transformers.MaskFormerImageProcessor.post_process_panoptic_segmentation.outputs",description:`<strong>outputs</strong> (<code>MaskFormerForInstanceSegmentationOutput</code>) &#x2014;
The outputs from <a href="/docs/transformers/main/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a>.`,name:"outputs"},{anchor:"transformers.MaskFormerImageProcessor.post_process_panoptic_segmentation.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The probability score threshold to keep predicted instance masks.`,name:"threshold"},{anchor:"transformers.MaskFormerImageProcessor.post_process_panoptic_segmentation.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Threshold to use when turning the predicted masks into binary values.`,name:"mask_threshold"},{anchor:"transformers.MaskFormerImageProcessor.post_process_panoptic_segmentation.overlap_mask_area_threshold",description:`<strong>overlap_mask_area_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
The overlap mask area threshold to merge or discard small disconnected parts within each binary
instance mask.`,name:"overlap_mask_area_threshold"},{anchor:"transformers.MaskFormerImageProcessor.post_process_panoptic_segmentation.label_ids_to_fuse",description:`<strong>label_ids_to_fuse</strong> (<code>Set[int]</code>, <em>optional</em>) &#x2014;
The labels in this state will have all their instances be fused together. For instance we could say
there can only be one sky in an image, but several persons, so the label ID for sky would be in that
set, but not the one for person.`,name:"label_ids_to_fuse"},{anchor:"transformers.MaskFormerImageProcessor.post_process_panoptic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction in batch. If left to None, predictions will not be
resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/maskformer/image_processing_maskformer.py#L1190",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, one per image, each dictionary containing two keys:</p>
<ul>
<li><strong>segmentation</strong> — a tensor of shape <code>(height, width)</code> where each pixel represents a <code>segment_id</code>, set
to <code>None</code> if no mask if found above <code>threshold</code>. If <code>target_sizes</code> is specified, segmentation is resized
to the corresponding <code>target_sizes</code> entry.</li>
<li><strong>segments_info</strong> — A dictionary that contains additional information on each segment.<ul>
<li><strong>id</strong> — an integer representing the <code>segment_id</code>.</li>
<li><strong>label_id</strong> — An integer representing the label / semantic class id corresponding to <code>segment_id</code>.</li>
<li><strong>was_fused</strong> — a boolean, <code>True</code> if <code>label_id</code> was in <code>label_ids_to_fuse</code>, <code>False</code> otherwise.
Multiple instances of the same class / label were fused and assigned a single <code>segment_id</code>.</li>
<li><strong>score</strong> — Prediction score of segment with <code>segment_id</code>.</li>
</ul></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),Ue=new X({props:{title:"MaskFormerFeatureExtractor",local:"transformers.MaskFormerFeatureExtractor",headingTag:"h2"}}),Ze=new x({props:{name:"class transformers.MaskFormerFeatureExtractor",anchor:"transformers.MaskFormerFeatureExtractor",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/maskformer/feature_extraction_maskformer.py#L27"}}),Ce=new x({props:{name:"__call__",anchor:"transformers.MaskFormerFeatureExtractor.__call__",parameters:[{name:"images",val:""},{name:"segmentation_maps",val:" = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/maskformer/image_processing_maskformer.py#L576"}}),We=new x({props:{name:"encode_inputs",anchor:"transformers.MaskFormerFeatureExtractor.encode_inputs",parameters:[{name:"pixel_values_list",val:": typing.List[typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']]]"},{name:"segmentation_maps",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']] = None"},{name:"instance_id_to_semantic_id",val:": typing.Union[typing.List[typing.Dict[int, int]], typing.Dict[int, int], NoneType] = None"},{name:"ignore_index",val:": typing.Optional[int] = None"},{name:"do_reduce_labels",val:": bool = False"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.MaskFormerFeatureExtractor.encode_inputs.pixel_values_list",description:`<strong>pixel_values_list</strong> (<code>List[ImageInput]</code>) &#x2014;
List of images (pixel values) to be padded. Each image should be a tensor of shape <code>(channels, height, width)</code>.`,name:"pixel_values_list"},{anchor:"transformers.MaskFormerFeatureExtractor.encode_inputs.segmentation_maps",description:`<strong>segmentation_maps</strong> (<code>ImageInput</code>, <em>optional</em>) &#x2014;
The corresponding semantic segmentation maps with the pixel-wise annotations.</p>
<p>(<code>bool</code>, <em>optional</em>, defaults to <code>True</code>):
Whether or not to pad images up to the largest image in a batch and create a pixel mask.</p>
<p>If left to the default, will return a pixel mask that is:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>`,name:"segmentation_maps"},{anchor:"transformers.MaskFormerFeatureExtractor.encode_inputs.instance_id_to_semantic_id",description:`<strong>instance_id_to_semantic_id</strong> (<code>List[Dict[int, int]]</code> or <code>Dict[int, int]</code>, <em>optional</em>) &#x2014;
A mapping between object instance ids and class ids. If passed, <code>segmentation_maps</code> is treated as an
instance segmentation map where each pixel represents an instance id. Can be provided as a single
dictionary with a global/dataset-level mapping or as a list of dictionaries (one per image), to map
instance ids in each image separately.`,name:"instance_id_to_semantic_id"},{anchor:"transformers.MaskFormerFeatureExtractor.encode_inputs.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/main/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>) &#x2014;
If set, will return tensors instead of NumPy arrays. If set to <code>&apos;pt&apos;</code>, return PyTorch <code>torch.Tensor</code>
objects.`,name:"return_tensors"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/maskformer/image_processing_maskformer.py#L867",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/feature_extractor#transformers.BatchFeature"
>BatchFeature</a> with the following fields:</p>
<ul>
<li><strong>pixel_values</strong> — Pixel values to be fed to a model.</li>
<li><strong>pixel_mask</strong> — Pixel mask to be fed to a model (when <code>=True</code> or if <code>pixel_mask</code> is in
<code>self.model_input_names</code>).</li>
<li><strong>mask_labels</strong> — Optional list of mask labels of shape <code>(labels, height, width)</code> to be fed to a model
(when <code>annotations</code> are provided).</li>
<li><strong>class_labels</strong> — Optional list of class labels of shape <code>(labels)</code> to be fed to a model (when
<code>annotations</code> are provided). They identify the labels of <code>mask_labels</code>, e.g. the label of
<code>mask_labels[i][j]</code> if <code>class_labels[i][j]</code>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/feature_extractor#transformers.BatchFeature"
>BatchFeature</a></p>
`}}),Le=new x({props:{name:"post_process_semantic_segmentation",anchor:"transformers.MaskFormerFeatureExtractor.post_process_semantic_segmentation",parameters:[{name:"outputs",val:""},{name:"target_sizes",val:": typing.Optional[typing.List[typing.Tuple[int, int]]] = None"}],parametersDescription:[{anchor:"transformers.MaskFormerFeatureExtractor.post_process_semantic_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/main/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.MaskFormerFeatureExtractor.post_process_semantic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction. If left to None, predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/maskformer/image_processing_maskformer.py#L1024",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of length <code>batch_size</code>, where each item is a semantic segmentation map of shape (height, width)
corresponding to the target_sizes entry (if <code>target_sizes</code> is specified). Each entry of each
<code>torch.Tensor</code> correspond to a semantic class id.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[torch.Tensor]</code></p>
`}}),Je=new x({props:{name:"post_process_instance_segmentation",anchor:"transformers.MaskFormerFeatureExtractor.post_process_instance_segmentation",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"mask_threshold",val:": float = 0.5"},{name:"overlap_mask_area_threshold",val:": float = 0.8"},{name:"target_sizes",val:": typing.Optional[typing.List[typing.Tuple[int, int]]] = None"},{name:"return_coco_annotation",val:": typing.Optional[bool] = False"},{name:"return_binary_maps",val:": typing.Optional[bool] = False"}],parametersDescription:[{anchor:"transformers.MaskFormerFeatureExtractor.post_process_instance_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/main/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.MaskFormerFeatureExtractor.post_process_instance_segmentation.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The probability score threshold to keep predicted instance masks.`,name:"threshold"},{anchor:"transformers.MaskFormerFeatureExtractor.post_process_instance_segmentation.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Threshold to use when turning the predicted masks into binary values.`,name:"mask_threshold"},{anchor:"transformers.MaskFormerFeatureExtractor.post_process_instance_segmentation.overlap_mask_area_threshold",description:`<strong>overlap_mask_area_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
The overlap mask area threshold to merge or discard small disconnected parts within each binary
instance mask.`,name:"overlap_mask_area_threshold"},{anchor:"transformers.MaskFormerFeatureExtractor.post_process_instance_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction. If left to None, predictions will not be resized.`,name:"target_sizes"},{anchor:"transformers.MaskFormerFeatureExtractor.post_process_instance_segmentation.return_coco_annotation",description:`<strong>return_coco_annotation</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If set to <code>True</code>, segmentation maps are returned in COCO run-length encoding (RLE) format.`,name:"return_coco_annotation"},{anchor:"transformers.MaskFormerFeatureExtractor.post_process_instance_segmentation.return_binary_maps",description:`<strong>return_binary_maps</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If set to <code>True</code>, segmentation maps are returned as a concatenated tensor of binary segmentation maps
(one per detected instance).`,name:"return_binary_maps"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/maskformer/image_processing_maskformer.py#L1074",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, one per image, each dictionary containing two keys:</p>
<ul>
<li><strong>segmentation</strong> — A tensor of shape <code>(height, width)</code> where each pixel represents a <code>segment_id</code>, or
<code>List[List]</code> run-length encoding (RLE) of the segmentation map if return_coco_annotation is set to
<code>True</code>, or a tensor of shape <code>(num_instances, height, width)</code> if return_binary_maps is set to <code>True</code>.
Set to <code>None</code> if no mask if found above <code>threshold</code>.</li>
<li><strong>segments_info</strong> — A dictionary that contains additional information on each segment.<ul>
<li><strong>id</strong> — An integer representing the <code>segment_id</code>.</li>
<li><strong>label_id</strong> — An integer representing the label / semantic class id corresponding to <code>segment_id</code>.</li>
<li><strong>score</strong> — Prediction score of segment with <code>segment_id</code>.</li>
</ul></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),Re=new x({props:{name:"post_process_panoptic_segmentation",anchor:"transformers.MaskFormerFeatureExtractor.post_process_panoptic_segmentation",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"mask_threshold",val:": float = 0.5"},{name:"overlap_mask_area_threshold",val:": float = 0.8"},{name:"label_ids_to_fuse",val:": typing.Optional[typing.Set[int]] = None"},{name:"target_sizes",val:": typing.Optional[typing.List[typing.Tuple[int, int]]] = None"}],parametersDescription:[{anchor:"transformers.MaskFormerFeatureExtractor.post_process_panoptic_segmentation.outputs",description:`<strong>outputs</strong> (<code>MaskFormerForInstanceSegmentationOutput</code>) &#x2014;
The outputs from <a href="/docs/transformers/main/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a>.`,name:"outputs"},{anchor:"transformers.MaskFormerFeatureExtractor.post_process_panoptic_segmentation.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The probability score threshold to keep predicted instance masks.`,name:"threshold"},{anchor:"transformers.MaskFormerFeatureExtractor.post_process_panoptic_segmentation.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Threshold to use when turning the predicted masks into binary values.`,name:"mask_threshold"},{anchor:"transformers.MaskFormerFeatureExtractor.post_process_panoptic_segmentation.overlap_mask_area_threshold",description:`<strong>overlap_mask_area_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
The overlap mask area threshold to merge or discard small disconnected parts within each binary
instance mask.`,name:"overlap_mask_area_threshold"},{anchor:"transformers.MaskFormerFeatureExtractor.post_process_panoptic_segmentation.label_ids_to_fuse",description:`<strong>label_ids_to_fuse</strong> (<code>Set[int]</code>, <em>optional</em>) &#x2014;
The labels in this state will have all their instances be fused together. For instance we could say
there can only be one sky in an image, but several persons, so the label ID for sky would be in that
set, but not the one for person.`,name:"label_ids_to_fuse"},{anchor:"transformers.MaskFormerFeatureExtractor.post_process_panoptic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction in batch. If left to None, predictions will not be
resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/maskformer/image_processing_maskformer.py#L1190",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, one per image, each dictionary containing two keys:</p>
<ul>
<li><strong>segmentation</strong> — a tensor of shape <code>(height, width)</code> where each pixel represents a <code>segment_id</code>, set
to <code>None</code> if no mask if found above <code>threshold</code>. If <code>target_sizes</code> is specified, segmentation is resized
to the corresponding <code>target_sizes</code> entry.</li>
<li><strong>segments_info</strong> — A dictionary that contains additional information on each segment.<ul>
<li><strong>id</strong> — an integer representing the <code>segment_id</code>.</li>
<li><strong>label_id</strong> — An integer representing the label / semantic class id corresponding to <code>segment_id</code>.</li>
<li><strong>was_fused</strong> — a boolean, <code>True</code> if <code>label_id</code> was in <code>label_ids_to_fuse</code>, <code>False</code> otherwise.
Multiple instances of the same class / label were fused and assigned a single <code>segment_id</code>.</li>
<li><strong>score</strong> — Prediction score of segment with <code>segment_id</code>.</li>
</ul></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),Be=new X({props:{title:"MaskFormerModel",local:"transformers.MaskFormerModel",headingTag:"h2"}}),Pe=new x({props:{name:"class transformers.MaskFormerModel",anchor:"transformers.MaskFormerModel",parameters:[{name:"config",val:": MaskFormerConfig"}],parametersDescription:[{anchor:"transformers.MaskFormerModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/maskformer#transformers.MaskFormerConfig">MaskFormerConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/maskformer/modeling_maskformer.py#L1490"}}),Xe=new x({props:{name:"forward",anchor:"transformers.MaskFormerModel.forward",parameters:[{name:"pixel_values",val:": Tensor"},{name:"pixel_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.MaskFormerModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.MaskFormerModel.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel values. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"pixel_mask"},{anchor:"transformers.MaskFormerModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MaskFormerModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MaskFormerModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/maskformer/modeling_maskformer.py#L1501",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/model_doc/maskformer#transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput"
>transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/maskformer#transformers.MaskFormerConfig"
>MaskFormerConfig</a>) and inputs.</p>
<ul>
<li><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) — Last hidden states (final feature map) of the last stage of the encoder model (backbone).</li>
<li><strong>pixel_decoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) — Last hidden states (final feature map) of the last stage of the pixel decoder model (FPN).</li>
<li><strong>transformer_decoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Last hidden states (final feature map) of the last stage of the transformer decoder model.</li>
<li><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the encoder
model at the output of each stage.</li>
<li><strong>pixel_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the pixel
decoder model at the output of each stage.</li>
<li><strong>transformer_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states (also called feature maps) of the
transformer decoder at the output of each stage.</li>
<li><strong>hidden_states</strong> <code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> containing <code>encoder_hidden_states</code>, <code>pixel_decoder_hidden_states</code> and
<code>decoder_hidden_states</code></li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights from Detr’s decoder after the attention softmax, used to compute the
weighted average in the self-attention heads.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/maskformer#transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput"
>transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),te=new es({props:{$$slots:{default:[Os]},$$scope:{ctx:z}}}),oe=new io({props:{anchor:"transformers.MaskFormerModel.forward.example",$$slots:{default:[Gs]},$$scope:{ctx:z}}}),Se=new X({props:{title:"MaskFormerForInstanceSegmentation",local:"transformers.MaskFormerForInstanceSegmentation",headingTag:"h2"}}),Ee=new x({props:{name:"class transformers.MaskFormerForInstanceSegmentation",anchor:"transformers.MaskFormerForInstanceSegmentation",parameters:[{name:"config",val:": MaskFormerConfig"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/maskformer/modeling_maskformer.py#L1587"}}),He=new x({props:{name:"forward",anchor:"transformers.MaskFormerForInstanceSegmentation.forward",parameters:[{name:"pixel_values",val:": Tensor"},{name:"mask_labels",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"class_labels",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"pixel_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_auxiliary_logits",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.MaskFormerForInstanceSegmentation.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.MaskFormerForInstanceSegmentation.forward.mask_labels",description:`<strong>mask_labels</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
List of mask labels of shape <code>(num_labels, height, width)</code> to be fed to a model`,name:"mask_labels"},{anchor:"transformers.MaskFormerForInstanceSegmentation.forward.class_labels",description:`<strong>class_labels</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
list of target class labels of shape <code>(num_labels, height, width)</code> to be fed to a model. They identify the
labels of <code>mask_labels</code>, e.g. the label of <code>mask_labels[i][j]</code> if <code>class_labels[i][j]</code>.`,name:"class_labels"},{anchor:"transformers.MaskFormerForInstanceSegmentation.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel values. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"pixel_mask"},{anchor:"transformers.MaskFormerForInstanceSegmentation.forward.output_auxiliary_logits",description:`<strong>output_auxiliary_logits</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to output auxiliary logits.`,name:"output_auxiliary_logits"},{anchor:"transformers.MaskFormerForInstanceSegmentation.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MaskFormerForInstanceSegmentation.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MaskFormerForInstanceSegmentation.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/maskformer/modeling_maskformer.py#L1669",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/model_doc/maskformer#transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput"
>transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/maskformer#transformers.MaskFormerConfig"
>MaskFormerConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.Tensor</code>, <em>optional</em>) — The computed loss, returned when labels are present.</li>
<li><strong>class_queries_logits</strong> (<code>torch.FloatTensor</code>) — A tensor of shape <code>(batch_size, num_queries, num_labels + 1)</code> representing the proposed classes for each
query. Note the <code>+ 1</code> is needed because we incorporate the null class.</li>
<li><strong>masks_queries_logits</strong> (<code>torch.FloatTensor</code>) — A tensor of shape <code>(batch_size, num_queries, height, width)</code> representing the proposed masks for each
query.</li>
<li><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) — Last hidden states (final feature map) of the last stage of the encoder model (backbone).</li>
<li><strong>pixel_decoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) — Last hidden states (final feature map) of the last stage of the pixel decoder model (FPN).</li>
<li><strong>transformer_decoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Last hidden states (final feature map) of the last stage of the transformer decoder model.</li>
<li><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the encoder
model at the output of each stage.</li>
<li><strong>pixel_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the pixel
decoder model at the output of each stage.</li>
<li><strong>transformer_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the transformer decoder at the output
of each stage.</li>
<li><strong>hidden_states</strong> <code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> containing <code>encoder_hidden_states</code>, <code>pixel_decoder_hidden_states</code> and
<code>decoder_hidden_states</code>.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights from Detr’s decoder after the attention softmax, used to compute the
weighted average in the self-attention heads.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/maskformer#transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput"
>transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),se=new es({props:{$$slots:{default:[Ys]},$$scope:{ctx:z}}}),ne=new io({props:{anchor:"transformers.MaskFormerForInstanceSegmentation.forward.example",$$slots:{default:[qs]},$$scope:{ctx:z}}}),ae=new io({props:{anchor:"transformers.MaskFormerForInstanceSegmentation.forward.example-2",$$slots:{default:[As]},$$scope:{ctx:z}}}),Ve=new Es({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/maskformer.md"}}),{c(){r=l("meta"),y=n(),m=l("p"),b=n(),p(M.$$.fragment),i=n(),w=l("div"),w.innerHTML=ts,vt=n(),p(O.$$.fragment),xt=n(),p(ie.$$.fragment),$t=n(),le=l("p"),le.innerHTML=os,It=n(),ce=l("p"),ce.textContent=ss,jt=n(),de=l("p"),de.innerHTML=ns,zt=n(),me=l("p"),me.innerHTML=as,Nt=n(),pe=l("img"),Ut=n(),ge=l("p"),ge.innerHTML=is,Zt=n(),p(he.$$.fragment),Ct=n(),fe=l("ul"),fe.innerHTML=ls,Wt=n(),p(ue.$$.fragment),Lt=n(),p(_e.$$.fragment),Jt=n(),be=l("ul"),be.innerHTML=cs,Rt=n(),p(ke.$$.fragment),Bt=n(),S=l("div"),p(Me.$$.fragment),co=n(),qe=l("p"),qe.innerHTML=ds,Pt=n(),J=l("div"),p(ye.$$.fragment),mo=n(),Ae=l("p"),Ae.innerHTML=ms,po=n(),De=l("p"),De.innerHTML=ps,Xt=n(),p(Fe.$$.fragment),St=n(),I=l("div"),p(we.$$.fragment),go=n(),Qe=l("p"),Qe.innerHTML=gs,ho=n(),Ke=l("p"),Ke.innerHTML=hs,fo=n(),et=l("p"),et.innerHTML=fs,uo=n(),p(G.$$.fragment),_o=n(),Y=l("div"),p(Te.$$.fragment),bo=n(),tt=l("p"),tt.innerHTML=us,Et=n(),p(ve.$$.fragment),Ht=n(),v=l("div"),p(xe.$$.fragment),ko=n(),ot=l("p"),ot.textContent=_s,Mo=n(),st=l("p"),st.innerHTML=bs,yo=n(),nt=l("div"),p($e.$$.fragment),Fo=n(),R=l("div"),p(Ie.$$.fragment),wo=n(),at=l("p"),at.innerHTML=ks,To=n(),rt=l("p"),rt.innerHTML=Ms,vo=n(),q=l("div"),p(je.$$.fragment),xo=n(),it=l("p"),it.innerHTML=ys,$o=n(),A=l("div"),p(ze.$$.fragment),Io=n(),lt=l("p"),lt.innerHTML=Fs,jo=n(),D=l("div"),p(Ne.$$.fragment),zo=n(),ct=l("p"),ct.innerHTML=ws,Vt=n(),p(Ue.$$.fragment),Ot=n(),j=l("div"),p(Ze.$$.fragment),No=n(),dt=l("div"),p(Ce.$$.fragment),Uo=n(),B=l("div"),p(We.$$.fragment),Zo=n(),mt=l("p"),mt.innerHTML=Ts,Co=n(),pt=l("p"),pt.innerHTML=vs,Wo=n(),Q=l("div"),p(Le.$$.fragment),Lo=n(),gt=l("p"),gt.innerHTML=xs,Jo=n(),K=l("div"),p(Je.$$.fragment),Ro=n(),ht=l("p"),ht.innerHTML=$s,Bo=n(),ee=l("div"),p(Re.$$.fragment),Po=n(),ft=l("p"),ft.innerHTML=Is,Gt=n(),p(Be.$$.fragment),Yt=n(),U=l("div"),p(Pe.$$.fragment),Xo=n(),ut=l("p"),ut.textContent=js,So=n(),_t=l("p"),_t.innerHTML=zs,Eo=n(),bt=l("p"),bt.innerHTML=Ns,Ho=n(),C=l("div"),p(Xe.$$.fragment),Vo=n(),kt=l("p"),kt.innerHTML=Us,Oo=n(),p(te.$$.fragment),Go=n(),p(oe.$$.fragment),qt=n(),p(Se.$$.fragment),At=n(),E=l("div"),p(Ee.$$.fragment),Yo=n(),N=l("div"),p(He.$$.fragment),qo=n(),Mt=l("p"),Mt.innerHTML=Zs,Ao=n(),p(se.$$.fragment),Do=n(),yt=l("p"),yt.textContent=Cs,Qo=n(),p(ne.$$.fragment),Ko=n(),p(ae.$$.fragment),Dt=n(),p(Ve.$$.fragment),Qt=n(),wt=l("p"),this.h()},l(e){const s=Xs("svelte-u9bgzb",document.head);r=c(s,"META",{name:!0,content:!0}),s.forEach(t),y=a(e),m=c(e,"P",{}),T(m).forEach(t),b=a(e),g(M.$$.fragment,e),i=a(e),w=c(e,"DIV",{class:!0,"data-svelte-h":!0}),k(w)!=="svelte-13t8s2t"&&(w.innerHTML=ts),vt=a(e),g(O.$$.fragment,e),xt=a(e),g(ie.$$.fragment,e),$t=a(e),le=c(e,"P",{"data-svelte-h":!0}),k(le)!=="svelte-1nc0rjr"&&(le.innerHTML=os),It=a(e),ce=c(e,"P",{"data-svelte-h":!0}),k(ce)!=="svelte-vfdo9a"&&(ce.textContent=ss),jt=a(e),de=c(e,"P",{"data-svelte-h":!0}),k(de)!=="svelte-lfolgg"&&(de.innerHTML=ns),zt=a(e),me=c(e,"P",{"data-svelte-h":!0}),k(me)!=="svelte-58561s"&&(me.innerHTML=as),Nt=a(e),pe=c(e,"IMG",{width:!0,src:!0}),Ut=a(e),ge=c(e,"P",{"data-svelte-h":!0}),k(ge)!=="svelte-1j464j"&&(ge.innerHTML=is),Zt=a(e),g(he.$$.fragment,e),Ct=a(e),fe=c(e,"UL",{"data-svelte-h":!0}),k(fe)!=="svelte-xkcwsz"&&(fe.innerHTML=ls),Wt=a(e),g(ue.$$.fragment,e),Lt=a(e),g(_e.$$.fragment,e),Jt=a(e),be=c(e,"UL",{"data-svelte-h":!0}),k(be)!=="svelte-1vj6t3t"&&(be.innerHTML=cs),Rt=a(e),g(ke.$$.fragment,e),Bt=a(e),S=c(e,"DIV",{class:!0});var Oe=T(S);g(Me.$$.fragment,Oe),co=a(Oe),qe=c(Oe,"P",{"data-svelte-h":!0}),k(qe)!=="svelte-fbg3tl"&&(qe.innerHTML=ds),Oe.forEach(t),Pt=a(e),J=c(e,"DIV",{class:!0});var H=T(J);g(ye.$$.fragment,H),mo=a(H),Ae=c(H,"P",{"data-svelte-h":!0}),k(Ae)!=="svelte-1ozjpzs"&&(Ae.innerHTML=ms),po=a(H),De=c(H,"P",{"data-svelte-h":!0}),k(De)!=="svelte-1qmuime"&&(De.innerHTML=ps),H.forEach(t),Xt=a(e),g(Fe.$$.fragment,e),St=a(e),I=c(e,"DIV",{class:!0});var Z=T(I);g(we.$$.fragment,Z),go=a(Z),Qe=c(Z,"P",{"data-svelte-h":!0}),k(Qe)!=="svelte-129qh7u"&&(Qe.innerHTML=gs),ho=a(Z),Ke=c(Z,"P",{"data-svelte-h":!0}),k(Ke)!=="svelte-o55m63"&&(Ke.innerHTML=hs),fo=a(Z),et=c(Z,"P",{"data-svelte-h":!0}),k(et)!=="svelte-l3soxz"&&(et.innerHTML=fs),uo=a(Z),g(G.$$.fragment,Z),_o=a(Z),Y=c(Z,"DIV",{class:!0});var Ge=T(Y);g(Te.$$.fragment,Ge),bo=a(Ge),tt=c(Ge,"P",{"data-svelte-h":!0}),k(tt)!=="svelte-1xf16is"&&(tt.innerHTML=us),Ge.forEach(t),Z.forEach(t),Et=a(e),g(ve.$$.fragment,e),Ht=a(e),v=c(e,"DIV",{class:!0});var $=T(v);g(xe.$$.fragment,$),ko=a($),ot=c($,"P",{"data-svelte-h":!0}),k(ot)!=="svelte-1fb5les"&&(ot.textContent=_s),Mo=a($),st=c($,"P",{"data-svelte-h":!0}),k(st)!=="svelte-1o6r6pd"&&(st.innerHTML=bs),yo=a($),nt=c($,"DIV",{class:!0});var Tt=T(nt);g($e.$$.fragment,Tt),Tt.forEach(t),Fo=a($),R=c($,"DIV",{class:!0});var V=T(R);g(Ie.$$.fragment,V),wo=a(V),at=c(V,"P",{"data-svelte-h":!0}),k(at)!=="svelte-1tetyua"&&(at.innerHTML=ks),To=a(V),rt=c(V,"P",{"data-svelte-h":!0}),k(rt)!=="svelte-1r85oma"&&(rt.innerHTML=Ms),V.forEach(t),vo=a($),q=c($,"DIV",{class:!0});var eo=T(q);g(je.$$.fragment,eo),xo=a(eo),it=c(eo,"P",{"data-svelte-h":!0}),k(it)!=="svelte-cqk2tl"&&(it.innerHTML=ys),eo.forEach(t),$o=a($),A=c($,"DIV",{class:!0});var to=T(A);g(ze.$$.fragment,to),Io=a(to),lt=c(to,"P",{"data-svelte-h":!0}),k(lt)!=="svelte-1hyddm1"&&(lt.innerHTML=Fs),to.forEach(t),jo=a($),D=c($,"DIV",{class:!0});var oo=T(D);g(Ne.$$.fragment,oo),zo=a(oo),ct=c(oo,"P",{"data-svelte-h":!0}),k(ct)!=="svelte-pw2uru"&&(ct.innerHTML=ws),oo.forEach(t),$.forEach(t),Vt=a(e),g(Ue.$$.fragment,e),Ot=a(e),j=c(e,"DIV",{class:!0});var W=T(j);g(Ze.$$.fragment,W),No=a(W),dt=c(W,"DIV",{class:!0});var Ws=T(dt);g(Ce.$$.fragment,Ws),Ws.forEach(t),Uo=a(W),B=c(W,"DIV",{class:!0});var Ft=T(B);g(We.$$.fragment,Ft),Zo=a(Ft),mt=c(Ft,"P",{"data-svelte-h":!0}),k(mt)!=="svelte-1tetyua"&&(mt.innerHTML=Ts),Co=a(Ft),pt=c(Ft,"P",{"data-svelte-h":!0}),k(pt)!=="svelte-1r85oma"&&(pt.innerHTML=vs),Ft.forEach(t),Wo=a(W),Q=c(W,"DIV",{class:!0});var so=T(Q);g(Le.$$.fragment,so),Lo=a(so),gt=c(so,"P",{"data-svelte-h":!0}),k(gt)!=="svelte-cqk2tl"&&(gt.innerHTML=xs),so.forEach(t),Jo=a(W),K=c(W,"DIV",{class:!0});var no=T(K);g(Je.$$.fragment,no),Ro=a(no),ht=c(no,"P",{"data-svelte-h":!0}),k(ht)!=="svelte-1hyddm1"&&(ht.innerHTML=$s),no.forEach(t),Bo=a(W),ee=c(W,"DIV",{class:!0});var ao=T(ee);g(Re.$$.fragment,ao),Po=a(ao),ft=c(ao,"P",{"data-svelte-h":!0}),k(ft)!=="svelte-pw2uru"&&(ft.innerHTML=Is),ao.forEach(t),W.forEach(t),Gt=a(e),g(Be.$$.fragment,e),Yt=a(e),U=c(e,"DIV",{class:!0});var P=T(U);g(Pe.$$.fragment,P),Xo=a(P),ut=c(P,"P",{"data-svelte-h":!0}),k(ut)!=="svelte-1e0z7at"&&(ut.textContent=js),So=a(P),_t=c(P,"P",{"data-svelte-h":!0}),k(_t)!=="svelte-6pahdo"&&(_t.innerHTML=zs),Eo=a(P),bt=c(P,"P",{"data-svelte-h":!0}),k(bt)!=="svelte-hswkmf"&&(bt.innerHTML=Ns),Ho=a(P),C=c(P,"DIV",{class:!0});var re=T(C);g(Xe.$$.fragment,re),Vo=a(re),kt=c(re,"P",{"data-svelte-h":!0}),k(kt)!=="svelte-7n0pms"&&(kt.innerHTML=Us),Oo=a(re),g(te.$$.fragment,re),Go=a(re),g(oe.$$.fragment,re),re.forEach(t),P.forEach(t),qt=a(e),g(Se.$$.fragment,e),At=a(e),E=c(e,"DIV",{class:!0});var ro=T(E);g(Ee.$$.fragment,ro),Yo=a(ro),N=c(ro,"DIV",{class:!0});var L=T(N);g(He.$$.fragment,L),qo=a(L),Mt=c(L,"P",{"data-svelte-h":!0}),k(Mt)!=="svelte-1lfovws"&&(Mt.innerHTML=Zs),Ao=a(L),g(se.$$.fragment,L),Do=a(L),yt=c(L,"P",{"data-svelte-h":!0}),k(yt)!=="svelte-kvfsh7"&&(yt.textContent=Cs),Qo=a(L),g(ne.$$.fragment,L),Ko=a(L),g(ae.$$.fragment,L),L.forEach(t),ro.forEach(t),Dt=a(e),g(Ve.$$.fragment,e),Qt=a(e),wt=c(e,"P",{}),T(wt).forEach(t),this.h()},h(){F(r,"name","hf:doc:metadata"),F(r,"content",Qs),F(w,"class","flex flex-wrap space-x-1"),F(pe,"width","600"),Js(pe.src,rs="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/maskformer_architecture.png")||F(pe,"src",rs),F(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(nt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(dt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,s){o(document.head,r),d(e,y,s),d(e,m,s),d(e,b,s),h(M,e,s),d(e,i,s),d(e,w,s),d(e,vt,s),h(O,e,s),d(e,xt,s),h(ie,e,s),d(e,$t,s),d(e,le,s),d(e,It,s),d(e,ce,s),d(e,jt,s),d(e,de,s),d(e,zt,s),d(e,me,s),d(e,Nt,s),d(e,pe,s),d(e,Ut,s),d(e,ge,s),d(e,Zt,s),h(he,e,s),d(e,Ct,s),d(e,fe,s),d(e,Wt,s),h(ue,e,s),d(e,Lt,s),h(_e,e,s),d(e,Jt,s),d(e,be,s),d(e,Rt,s),h(ke,e,s),d(e,Bt,s),d(e,S,s),h(Me,S,null),o(S,co),o(S,qe),d(e,Pt,s),d(e,J,s),h(ye,J,null),o(J,mo),o(J,Ae),o(J,po),o(J,De),d(e,Xt,s),h(Fe,e,s),d(e,St,s),d(e,I,s),h(we,I,null),o(I,go),o(I,Qe),o(I,ho),o(I,Ke),o(I,fo),o(I,et),o(I,uo),h(G,I,null),o(I,_o),o(I,Y),h(Te,Y,null),o(Y,bo),o(Y,tt),d(e,Et,s),h(ve,e,s),d(e,Ht,s),d(e,v,s),h(xe,v,null),o(v,ko),o(v,ot),o(v,Mo),o(v,st),o(v,yo),o(v,nt),h($e,nt,null),o(v,Fo),o(v,R),h(Ie,R,null),o(R,wo),o(R,at),o(R,To),o(R,rt),o(v,vo),o(v,q),h(je,q,null),o(q,xo),o(q,it),o(v,$o),o(v,A),h(ze,A,null),o(A,Io),o(A,lt),o(v,jo),o(v,D),h(Ne,D,null),o(D,zo),o(D,ct),d(e,Vt,s),h(Ue,e,s),d(e,Ot,s),d(e,j,s),h(Ze,j,null),o(j,No),o(j,dt),h(Ce,dt,null),o(j,Uo),o(j,B),h(We,B,null),o(B,Zo),o(B,mt),o(B,Co),o(B,pt),o(j,Wo),o(j,Q),h(Le,Q,null),o(Q,Lo),o(Q,gt),o(j,Jo),o(j,K),h(Je,K,null),o(K,Ro),o(K,ht),o(j,Bo),o(j,ee),h(Re,ee,null),o(ee,Po),o(ee,ft),d(e,Gt,s),h(Be,e,s),d(e,Yt,s),d(e,U,s),h(Pe,U,null),o(U,Xo),o(U,ut),o(U,So),o(U,_t),o(U,Eo),o(U,bt),o(U,Ho),o(U,C),h(Xe,C,null),o(C,Vo),o(C,kt),o(C,Oo),h(te,C,null),o(C,Go),h(oe,C,null),d(e,qt,s),h(Se,e,s),d(e,At,s),d(e,E,s),h(Ee,E,null),o(E,Yo),o(E,N),h(He,N,null),o(N,qo),o(N,Mt),o(N,Ao),h(se,N,null),o(N,Do),o(N,yt),o(N,Qo),h(ne,N,null),o(N,Ko),h(ae,N,null),d(e,Dt,s),h(Ve,e,s),d(e,Qt,s),d(e,wt,s),Kt=!0},p(e,[s]){const Oe={};s&2&&(Oe.$$scope={dirty:s,ctx:e}),O.$set(Oe);const H={};s&2&&(H.$$scope={dirty:s,ctx:e}),G.$set(H);const Z={};s&2&&(Z.$$scope={dirty:s,ctx:e}),te.$set(Z);const Ge={};s&2&&(Ge.$$scope={dirty:s,ctx:e}),oe.$set(Ge);const $={};s&2&&($.$$scope={dirty:s,ctx:e}),se.$set($);const Tt={};s&2&&(Tt.$$scope={dirty:s,ctx:e}),ne.$set(Tt);const V={};s&2&&(V.$$scope={dirty:s,ctx:e}),ae.$set(V)},i(e){Kt||(f(M.$$.fragment,e),f(O.$$.fragment,e),f(ie.$$.fragment,e),f(he.$$.fragment,e),f(ue.$$.fragment,e),f(_e.$$.fragment,e),f(ke.$$.fragment,e),f(Me.$$.fragment,e),f(ye.$$.fragment,e),f(Fe.$$.fragment,e),f(we.$$.fragment,e),f(G.$$.fragment,e),f(Te.$$.fragment,e),f(ve.$$.fragment,e),f(xe.$$.fragment,e),f($e.$$.fragment,e),f(Ie.$$.fragment,e),f(je.$$.fragment,e),f(ze.$$.fragment,e),f(Ne.$$.fragment,e),f(Ue.$$.fragment,e),f(Ze.$$.fragment,e),f(Ce.$$.fragment,e),f(We.$$.fragment,e),f(Le.$$.fragment,e),f(Je.$$.fragment,e),f(Re.$$.fragment,e),f(Be.$$.fragment,e),f(Pe.$$.fragment,e),f(Xe.$$.fragment,e),f(te.$$.fragment,e),f(oe.$$.fragment,e),f(Se.$$.fragment,e),f(Ee.$$.fragment,e),f(He.$$.fragment,e),f(se.$$.fragment,e),f(ne.$$.fragment,e),f(ae.$$.fragment,e),f(Ve.$$.fragment,e),Kt=!0)},o(e){u(M.$$.fragment,e),u(O.$$.fragment,e),u(ie.$$.fragment,e),u(he.$$.fragment,e),u(ue.$$.fragment,e),u(_e.$$.fragment,e),u(ke.$$.fragment,e),u(Me.$$.fragment,e),u(ye.$$.fragment,e),u(Fe.$$.fragment,e),u(we.$$.fragment,e),u(G.$$.fragment,e),u(Te.$$.fragment,e),u(ve.$$.fragment,e),u(xe.$$.fragment,e),u($e.$$.fragment,e),u(Ie.$$.fragment,e),u(je.$$.fragment,e),u(ze.$$.fragment,e),u(Ne.$$.fragment,e),u(Ue.$$.fragment,e),u(Ze.$$.fragment,e),u(Ce.$$.fragment,e),u(We.$$.fragment,e),u(Le.$$.fragment,e),u(Je.$$.fragment,e),u(Re.$$.fragment,e),u(Be.$$.fragment,e),u(Pe.$$.fragment,e),u(Xe.$$.fragment,e),u(te.$$.fragment,e),u(oe.$$.fragment,e),u(Se.$$.fragment,e),u(Ee.$$.fragment,e),u(He.$$.fragment,e),u(se.$$.fragment,e),u(ne.$$.fragment,e),u(ae.$$.fragment,e),u(Ve.$$.fragment,e),Kt=!1},d(e){e&&(t(y),t(m),t(b),t(i),t(w),t(vt),t(xt),t($t),t(le),t(It),t(ce),t(jt),t(de),t(zt),t(me),t(Nt),t(pe),t(Ut),t(ge),t(Zt),t(Ct),t(fe),t(Wt),t(Lt),t(Jt),t(be),t(Rt),t(Bt),t(S),t(Pt),t(J),t(Xt),t(St),t(I),t(Et),t(Ht),t(v),t(Vt),t(Ot),t(j),t(Gt),t(Yt),t(U),t(qt),t(At),t(E),t(Dt),t(Qt),t(wt)),t(r),_(M,e),_(O,e),_(ie,e),_(he,e),_(ue,e),_(_e,e),_(ke,e),_(Me),_(ye),_(Fe,e),_(we),_(G),_(Te),_(ve,e),_(xe),_($e),_(Ie),_(je),_(ze),_(Ne),_(Ue,e),_(Ze),_(Ce),_(We),_(Le),_(Je),_(Re),_(Be,e),_(Pe),_(Xe),_(te),_(oe),_(Se,e),_(Ee),_(He),_(se),_(ne),_(ae),_(Ve,e)}}}const Qs='{"title":"MaskFormer","local":"maskformer","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"MaskFormer specific outputs","local":"transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput","sections":[],"depth":2},{"title":"MaskFormerConfig","local":"transformers.MaskFormerConfig","sections":[],"depth":2},{"title":"MaskFormerImageProcessor","local":"transformers.MaskFormerImageProcessor","sections":[],"depth":2},{"title":"MaskFormerFeatureExtractor","local":"transformers.MaskFormerFeatureExtractor","sections":[],"depth":2},{"title":"MaskFormerModel","local":"transformers.MaskFormerModel","sections":[],"depth":2},{"title":"MaskFormerForInstanceSegmentation","local":"transformers.MaskFormerForInstanceSegmentation","sections":[],"depth":2}],"depth":1}';function Ks(z){return Rs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class dn extends Bs{constructor(r){super(),Ps(this,r,Ks,Ds,Ls,{})}}export{dn as component};
