import{s as Os,z as zs,o as Zs,n as ds}from"../chunks/scheduler.18a86fab.js";import{S as Vs,i as $s,g as c,s as o,r as p,A as Rs,h as i,f as t,c as a,j as me,u,x as T,k as D,y as d,a as n,v as h,d as b,t as g,w as f}from"../chunks/index.98837b22.js";import{T as Gs}from"../chunks/Tip.77304350.js";import{D as we}from"../chunks/Docstring.6758ea23.js";import{C as Le}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as Cs}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as C}from"../chunks/Heading.7e7e0c5b.js";import{E as Bs}from"../chunks/getInferenceSnippets.de10bc7d.js";function Ns(O){let l,J="Examples:",_,m,j;return m=new Le({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME9tRGV0VHVyYm9Db25maWclMkMlMjBPbURldFR1cmJvRm9yT2JqZWN0RGV0ZWN0aW9uJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyME9tRGV0LVR1cmJvJTIwb21sYWIlMkZvbWRldC10dXJiby1zd2luLXRpbnktaGYlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwT21EZXRUdXJib0NvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBvbWxhYiUyRm9tZGV0LXR1cmJvLXN3aW4tdGlueS1oZiUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwT21EZXRUdXJib0Zvck9iamVjdERldGVjdGlvbihjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> OmDetTurboConfig, OmDetTurboForObjectDetection

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a OmDet-Turbo omlab/omdet-turbo-swin-tiny-hf style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = OmDetTurboConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the omlab/omdet-turbo-swin-tiny-hf style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = OmDetTurboForObjectDetection(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){l=c("p"),l.textContent=J,_=o(),p(m.$$.fragment)},l(r){l=i(r,"P",{"data-svelte-h":!0}),T(l)!=="svelte-kvfsh7"&&(l.textContent=J),_=a(r),u(m.$$.fragment,r)},m(r,y){n(r,l,y),n(r,_,y),h(m,r,y),j=!0},p:ds,i(r){j||(b(m.$$.fragment,r),j=!0)},o(r){g(m.$$.fragment,r),j=!1},d(r){r&&(t(l),t(_)),f(m,r)}}}function Fs(O){let l,J=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){l=c("p"),l.innerHTML=J},l(_){l=i(_,"P",{"data-svelte-h":!0}),T(l)!=="svelte-fincs2"&&(l.innerHTML=J)},m(_,m){n(_,l,m)},p:ds,d(_){_&&t(l)}}}function qs(O){let l,J="Examples:",_,m,j;return m=new Le({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, OmDetTurboForObjectDetection

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;omlab/omdet-turbo-swin-tiny-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = OmDetTurboForObjectDetection.from_pretrained(<span class="hljs-string">&quot;omlab/omdet-turbo-swin-tiny-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>classes = [<span class="hljs-string">&quot;cat&quot;</span>, <span class="hljs-string">&quot;remote&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>task = <span class="hljs-string">&quot;Detect {}.&quot;</span>.<span class="hljs-built_in">format</span>(<span class="hljs-string">&quot;, &quot;</span>.join(classes))
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, text=classes, task=task, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># convert outputs (bounding boxes and class logits)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>results = processor.post_process_grounded_object_detection(
<span class="hljs-meta">... </span>    outputs,
<span class="hljs-meta">... </span>    classes=classes,
<span class="hljs-meta">... </span>    target_sizes=[image.size[::-<span class="hljs-number">1</span>]],
<span class="hljs-meta">... </span>    score_threshold=<span class="hljs-number">0.3</span>,
<span class="hljs-meta">... </span>    nms_threshold=<span class="hljs-number">0.3</span>,
<span class="hljs-meta">&gt;&gt;&gt; </span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> score, class_name, box <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(results[<span class="hljs-string">&quot;scores&quot;</span>], results[<span class="hljs-string">&quot;classes&quot;</span>], results[<span class="hljs-string">&quot;boxes&quot;</span>]):
<span class="hljs-meta">... </span>    box = [<span class="hljs-built_in">round</span>(i, <span class="hljs-number">1</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> box.tolist()]
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>        <span class="hljs-string">f&quot;Detected <span class="hljs-subst">{class_name}</span> with confidence &quot;</span>
<span class="hljs-meta">... </span>        <span class="hljs-string">f&quot;<span class="hljs-subst">{<span class="hljs-built_in">round</span>(score.item(), <span class="hljs-number">2</span>)}</span> at location <span class="hljs-subst">{box}</span>&quot;</span>
<span class="hljs-meta">... </span>    )
Detected remote <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.76</span> at location [<span class="hljs-number">39.9</span>, <span class="hljs-number">71.3</span>, <span class="hljs-number">176.5</span>, <span class="hljs-number">117.9</span>]
Detected cat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.72</span> at location [<span class="hljs-number">345.1</span>, <span class="hljs-number">22.5</span>, <span class="hljs-number">639.7</span>, <span class="hljs-number">371.9</span>]
Detected cat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.65</span> at location [<span class="hljs-number">12.7</span>, <span class="hljs-number">53.8</span>, <span class="hljs-number">315.5</span>, <span class="hljs-number">475.3</span>]
Detected remote <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.57</span> at location [<span class="hljs-number">333.4</span>, <span class="hljs-number">75.6</span>, <span class="hljs-number">370.7</span>, <span class="hljs-number">187.0</span>]`,wrap:!1}}),{c(){l=c("p"),l.textContent=J,_=o(),p(m.$$.fragment)},l(r){l=i(r,"P",{"data-svelte-h":!0}),T(l)!=="svelte-kvfsh7"&&(l.textContent=J),_=a(r),u(m.$$.fragment,r)},m(r,y){n(r,l,y),n(r,_,y),h(m,r,y),j=!0},p:ds,i(r){j||(b(m.$$.fragment,r),j=!0)},o(r){g(m.$$.fragment,r),j=!1},d(r){r&&(t(l),t(_)),f(m,r)}}}function Ws(O){let l,J,_,m,j,r,y,ms='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',Je,B,Me,N,ps='The OmDet-Turbo model was proposed in <a href="https://arxiv.org/abs/2403.06892" rel="nofollow">Real-time Transformer-based Open-Vocabulary Detection with Efficient Fusion Head</a> by Tiancheng Zhao, Peng Liu, Xuan He, Lu Zhang, Kyusong Lee. OmDet-Turbo incorporates components from RT-DETR and introduces a swift multimodal fusion module to achieve real-time open-vocabulary object detection capabilities while maintaining high accuracy. The base model achieves performance of up to 100.2 FPS and 53.4 AP on COCO zero-shot.',ve,F,us="The abstract from the paper is the following:",Ie,q,hs="<em>End-to-end transformer-based detectors (DETRs) have shown exceptional performance in both closed-set and open-vocabulary object detection (OVD) tasks through the integration of language modalities. However, their demanding computational requirements have hindered their practical application in real-time object detection (OD) scenarios. In this paper, we scrutinize the limitations of two leading models in the OVDEval benchmark, OmDet and Grounding-DINO, and introduce OmDet-Turbo. This novel transformer-based real-time OVD model features an innovative Efficient Fusion Head (EFH) module designed to alleviate the bottlenecks observed in OmDet and Grounding-DINO. Notably, OmDet-Turbo-Base achieves a 100.2 frames per second (FPS) with TensorRT and language cache techniques applied. Notably, in zero-shot scenarios on COCO and LVIS datasets, OmDet-Turbo achieves performance levels nearly on par with current state-of-the-art supervised models. Furthermore, it establishes new state-of-the-art benchmarks on ODinW and OVDEval, boasting an AP of 30.1 and an NMS-AP of 26.86, respectively. The practicality of OmDet-Turbo in industrial applications is underscored by its exceptional performance on benchmark datasets and superior inference speed, positioning it as a compelling choice for real-time object detection tasks.</em>",Ue,z,bs,ke,W,gs='OmDet-Turbo architecture overview. Taken from the <a href="https://arxiv.org/abs/2403.06892">original paper</a>.',De,E,fs=`This model was contributed by <a href="https://huggingface.co/yonigozlan" rel="nofollow">yonigozlan</a>.
The original code can be found <a href="https://github.com/om-ai-lab/OmDet" rel="nofollow">here</a>.`,xe,Q,Ce,H,Ts='One unique property of OmDet-Turbo compared to other zero-shot object detection models, such as <a href="grounding-dino">Grounding DINO</a>, is the decoupled classes and prompt embedding structure that allows caching of text embeddings. This means that the model needs both classes and task as inputs, where classes is a list of objects we want to detect and task is the grounded text used to guide open-vocabulary detection. This approach limits the scope of the open-vocabulary detection and makes the decoding process faster.',Oe,X,_s='<a href="/docs/transformers/main/en/model_doc/omdet-turbo#transformers.OmDetTurboProcessor">OmDetTurboProcessor</a> is used to prepare the classes, task and image triplet. The task input is optional, and when not provided, it will default to <code>&quot;Detect [class1], [class2], [class3], ...&quot;</code>. To process the results from the model, one can use <code>post_process_grounded_object_detection</code> from <a href="/docs/transformers/main/en/model_doc/omdet-turbo#transformers.OmDetTurboProcessor">OmDetTurboProcessor</a>. Notably, this function takes in the input classes, as unlike other zero-shot object detection models, the decoupling of classes and task embeddings means that no decoding of the predicted class embeddings is needed in the post-processing step, and the predicted classes can be matched to the inputted ones directly.',ze,Y,Ze,L,Ve,S,js="Here’s how to load the model and prepare the inputs to perform zero-shot object detection on a single image:",$e,A,Re,P,Ge,K,ys="OmDet-Turbo can perform batched multi-image inference, with support for different text prompts and classes in the same batch:",Be,ee,Ne,se,Fe,M,te,Se,pe,ws=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/omdet-turbo#transformers.OmDetTurboForObjectDetection">OmDetTurboForObjectDetection</a>.
It is used to instantiate a OmDet-Turbo model according to the specified arguments, defining the model architecture
Instantiating a configuration with the defaults will yield a similar configuration to that of the OmDet-Turbo
<a href="https://huggingface.co/omlab/omdet-turbo-swin-tiny-hf" rel="nofollow">omlab/omdet-turbo-swin-tiny-hf</a> architecture.`,Ae,ue,Js=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Pe,Z,qe,ne,We,v,oe,Ke,he,Ms=`Constructs a OmDet-Turbo processor which wraps a Deformable DETR image processor and an AutoTokenizer into a
single processor.`,es,be,vs=`<a href="/docs/transformers/main/en/model_doc/omdet-turbo#transformers.OmDetTurboProcessor">OmDetTurboProcessor</a> offers all the functionalities of <a href="/docs/transformers/main/en/model_doc/detr#transformers.DetrImageProcessor">DetrImageProcessor</a> and
<a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See the docstring of <code>__call__()</code> and <code>decode()</code>
for more information.`,ss,V,ae,ts,ge,Is=`Converts the raw output of <a href="/docs/transformers/main/en/model_doc/omdet-turbo#transformers.OmDetTurboForObjectDetection">OmDetTurboForObjectDetection</a> into final bounding boxes in (top_left_x, top_left_y,
bottom_right_x, bottom_right_y) format and get the associated text class.`,Ee,re,Qe,w,le,ns,fe,Us=`OmDetTurbo Model (consisting of a vision and a text backbone, and encoder-decoder architecture) outputting
bounding boxes and classes scores for tasks such as COCO detection.`,os,Te,ks=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,as,_e,Ds=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,rs,I,ce,ls,je,xs='The <a href="/docs/transformers/main/en/model_doc/omdet-turbo#transformers.OmDetTurboForObjectDetection">OmDetTurboForObjectDetection</a> forward method, overrides the <code>__call__</code> special method.',cs,$,is,R,He,ie,Xe,ye,Ye;return j=new C({props:{title:"OmDet-Turbo",local:"omdet-turbo",headingTag:"h1"}}),B=new C({props:{title:"Overview",local:"overview",headingTag:"h2"}}),Q=new C({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),Y=new C({props:{title:"Usage example",local:"usage-example",headingTag:"h2"}}),L=new C({props:{title:"Single image inference",local:"single-image-inference",headingTag:"h3"}}),A=new Le({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, OmDetTurboForObjectDetection

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;omlab/omdet-turbo-swin-tiny-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = OmDetTurboForObjectDetection.from_pretrained(<span class="hljs-string">&quot;omlab/omdet-turbo-swin-tiny-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>text_labels = [<span class="hljs-string">&quot;cat&quot;</span>, <span class="hljs-string">&quot;remote&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, text=text_labels, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># convert outputs (bounding boxes and class logits)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>results = processor.post_process_grounded_object_detection(
<span class="hljs-meta">... </span>    outputs,
<span class="hljs-meta">... </span>    target_sizes=[(image.height, image.width)],
<span class="hljs-meta">... </span>    text_labels=text_labels,
<span class="hljs-meta">... </span>    threshold=<span class="hljs-number">0.3</span>,
<span class="hljs-meta">... </span>    nms_threshold=<span class="hljs-number">0.3</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>result = results[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes, scores, text_labels = result[<span class="hljs-string">&quot;boxes&quot;</span>], result[<span class="hljs-string">&quot;scores&quot;</span>], result[<span class="hljs-string">&quot;text_labels&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> box, score, text_label <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(boxes, scores, text_labels):
<span class="hljs-meta">... </span>    box = [<span class="hljs-built_in">round</span>(i, <span class="hljs-number">2</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> box.tolist()]
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Detected <span class="hljs-subst">{text_label}</span> with confidence <span class="hljs-subst">{<span class="hljs-built_in">round</span>(score.item(), <span class="hljs-number">3</span>)}</span> at location <span class="hljs-subst">{box}</span>&quot;</span>)
Detected remote <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.768</span> at location [<span class="hljs-number">39.89</span>, <span class="hljs-number">70.35</span>, <span class="hljs-number">176.74</span>, <span class="hljs-number">118.04</span>]
Detected cat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.72</span> at location [<span class="hljs-number">11.6</span>, <span class="hljs-number">54.19</span>, <span class="hljs-number">314.8</span>, <span class="hljs-number">473.95</span>]
Detected remote <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.563</span> at location [<span class="hljs-number">333.38</span>, <span class="hljs-number">75.77</span>, <span class="hljs-number">370.7</span>, <span class="hljs-number">187.03</span>]
Detected cat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.552</span> at location [<span class="hljs-number">345.15</span>, <span class="hljs-number">23.95</span>, <span class="hljs-number">639.75</span>, <span class="hljs-number">371.67</span>]`,wrap:!1}}),P=new C({props:{title:"Multi image inference",local:"multi-image-inference",headingTag:"h3"}}),ee=new Le({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, OmDetTurboForObjectDetection

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;omlab/omdet-turbo-swin-tiny-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = OmDetTurboForObjectDetection.from_pretrained(<span class="hljs-string">&quot;omlab/omdet-turbo-swin-tiny-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url1 = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image1 = Image.<span class="hljs-built_in">open</span>(BytesIO(requests.get(url1).content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>text_labels1 = [<span class="hljs-string">&quot;cat&quot;</span>, <span class="hljs-string">&quot;remote&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>task1 = <span class="hljs-string">&quot;Detect {}.&quot;</span>.<span class="hljs-built_in">format</span>(<span class="hljs-string">&quot;, &quot;</span>.join(text_labels1))

<span class="hljs-meta">&gt;&gt;&gt; </span>url2 = <span class="hljs-string">&quot;http://images.cocodataset.org/train2017/000000257813.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image2 = Image.<span class="hljs-built_in">open</span>(BytesIO(requests.get(url2).content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>text_labels2 = [<span class="hljs-string">&quot;boat&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>task2 = <span class="hljs-string">&quot;Detect everything that looks like a boat.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>url3 = <span class="hljs-string">&quot;https://cdn.britannica.com/61/93061-050-99147DCE/Statue-of-Liberty-Island-New-York-Bay.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image3 = Image.<span class="hljs-built_in">open</span>(BytesIO(requests.get(url3).content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>text_labels3 = [<span class="hljs-string">&quot;statue&quot;</span>, <span class="hljs-string">&quot;trees&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>task3 = <span class="hljs-string">&quot;Focus on the foreground, detect statue and trees.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    images=[image1, image2, image3],
<span class="hljs-meta">... </span>    text=[text_labels1, text_labels2, text_labels3],
<span class="hljs-meta">... </span>    task=[task1, task2, task3],
<span class="hljs-meta">... </span>    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># convert outputs (bounding boxes and class logits)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>results = processor.post_process_grounded_object_detection(
<span class="hljs-meta">... </span>    outputs,
<span class="hljs-meta">... </span>    text_labels=[text_labels1, text_labels2, text_labels3],
<span class="hljs-meta">... </span>    target_sizes=[(image.height, image.width) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> [image1, image2, image3]],
<span class="hljs-meta">... </span>    threshold=<span class="hljs-number">0.2</span>,
<span class="hljs-meta">... </span>    nms_threshold=<span class="hljs-number">0.3</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i, result <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(results):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> score, text_label, box <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(
<span class="hljs-meta">... </span>        result[<span class="hljs-string">&quot;scores&quot;</span>], result[<span class="hljs-string">&quot;text_labels&quot;</span>], result[<span class="hljs-string">&quot;boxes&quot;</span>]
<span class="hljs-meta">... </span>    ):
<span class="hljs-meta">... </span>        box = [<span class="hljs-built_in">round</span>(i, <span class="hljs-number">1</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> box.tolist()]
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>            <span class="hljs-string">f&quot;Detected <span class="hljs-subst">{text_label}</span> with confidence &quot;</span>
<span class="hljs-meta">... </span>            <span class="hljs-string">f&quot;<span class="hljs-subst">{<span class="hljs-built_in">round</span>(score.item(), <span class="hljs-number">2</span>)}</span> at location <span class="hljs-subst">{box}</span> in image <span class="hljs-subst">{i}</span>&quot;</span>
<span class="hljs-meta">... </span>        )
Detected remote <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.77</span> at location [<span class="hljs-number">39.9</span>, <span class="hljs-number">70.4</span>, <span class="hljs-number">176.7</span>, <span class="hljs-number">118.0</span>] <span class="hljs-keyword">in</span> image <span class="hljs-number">0</span>
Detected cat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.72</span> at location [<span class="hljs-number">11.6</span>, <span class="hljs-number">54.2</span>, <span class="hljs-number">314.8</span>, <span class="hljs-number">474.0</span>] <span class="hljs-keyword">in</span> image <span class="hljs-number">0</span>
Detected remote <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.56</span> at location [<span class="hljs-number">333.4</span>, <span class="hljs-number">75.8</span>, <span class="hljs-number">370.7</span>, <span class="hljs-number">187.0</span>] <span class="hljs-keyword">in</span> image <span class="hljs-number">0</span>
Detected cat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.55</span> at location [<span class="hljs-number">345.2</span>, <span class="hljs-number">24.0</span>, <span class="hljs-number">639.8</span>, <span class="hljs-number">371.7</span>] <span class="hljs-keyword">in</span> image <span class="hljs-number">0</span>
Detected boat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.32</span> at location [<span class="hljs-number">146.9</span>, <span class="hljs-number">219.8</span>, <span class="hljs-number">209.6</span>, <span class="hljs-number">250.7</span>] <span class="hljs-keyword">in</span> image <span class="hljs-number">1</span>
Detected boat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.3</span> at location [<span class="hljs-number">319.1</span>, <span class="hljs-number">223.2</span>, <span class="hljs-number">403.2</span>, <span class="hljs-number">238.4</span>] <span class="hljs-keyword">in</span> image <span class="hljs-number">1</span>
Detected boat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.27</span> at location [<span class="hljs-number">37.7</span>, <span class="hljs-number">220.3</span>, <span class="hljs-number">84.0</span>, <span class="hljs-number">235.9</span>] <span class="hljs-keyword">in</span> image <span class="hljs-number">1</span>
Detected boat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.22</span> at location [<span class="hljs-number">407.9</span>, <span class="hljs-number">207.0</span>, <span class="hljs-number">441.7</span>, <span class="hljs-number">220.2</span>] <span class="hljs-keyword">in</span> image <span class="hljs-number">1</span>
Detected statue <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.73</span> at location [<span class="hljs-number">544.7</span>, <span class="hljs-number">210.2</span>, <span class="hljs-number">651.9</span>, <span class="hljs-number">502.8</span>] <span class="hljs-keyword">in</span> image <span class="hljs-number">2</span>
Detected trees <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.25</span> at location [<span class="hljs-number">3.9</span>, <span class="hljs-number">584.3</span>, <span class="hljs-number">391.4</span>, <span class="hljs-number">785.6</span>] <span class="hljs-keyword">in</span> image <span class="hljs-number">2</span>
Detected trees <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.25</span> at location [<span class="hljs-number">1.4</span>, <span class="hljs-number">621.2</span>, <span class="hljs-number">118.2</span>, <span class="hljs-number">787.8</span>] <span class="hljs-keyword">in</span> image <span class="hljs-number">2</span>
Detected statue <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.2</span> at location [<span class="hljs-number">428.1</span>, <span class="hljs-number">205.5</span>, <span class="hljs-number">767.3</span>, <span class="hljs-number">759.5</span>] <span class="hljs-keyword">in</span> image <span class="hljs-number">2</span>
`,wrap:!1}}),se=new C({props:{title:"OmDetTurboConfig",local:"transformers.OmDetTurboConfig",headingTag:"h2"}}),te=new we({props:{name:"class transformers.OmDetTurboConfig",anchor:"transformers.OmDetTurboConfig",parameters:[{name:"text_config",val:" = None"},{name:"backbone_config",val:" = None"},{name:"use_timm_backbone",val:" = True"},{name:"backbone",val:" = 'swin_tiny_patch4_window7_224'"},{name:"backbone_kwargs",val:" = None"},{name:"use_pretrained_backbone",val:" = False"},{name:"apply_layernorm_after_vision_backbone",val:" = True"},{name:"image_size",val:" = 640"},{name:"disable_custom_kernels",val:" = False"},{name:"layer_norm_eps",val:" = 1e-05"},{name:"batch_norm_eps",val:" = 1e-05"},{name:"init_std",val:" = 0.02"},{name:"text_projection_in_dim",val:" = 512"},{name:"text_projection_out_dim",val:" = 512"},{name:"task_encoder_hidden_dim",val:" = 1024"},{name:"class_embed_dim",val:" = 512"},{name:"class_distance_type",val:" = 'cosine'"},{name:"num_queries",val:" = 900"},{name:"csp_activation",val:" = 'silu'"},{name:"conv_norm_activation",val:" = 'gelu'"},{name:"encoder_feedforward_activation",val:" = 'relu'"},{name:"encoder_feedforward_dropout",val:" = 0.0"},{name:"encoder_dropout",val:" = 0.0"},{name:"hidden_expansion",val:" = 1"},{name:"vision_features_channels",val:" = [256, 256, 256]"},{name:"encoder_hidden_dim",val:" = 256"},{name:"encoder_in_channels",val:" = [192, 384, 768]"},{name:"encoder_projection_indices",val:" = [2]"},{name:"encoder_attention_heads",val:" = 8"},{name:"encoder_dim_feedforward",val:" = 2048"},{name:"encoder_layers",val:" = 1"},{name:"positional_encoding_temperature",val:" = 10000"},{name:"num_feature_levels",val:" = 3"},{name:"decoder_hidden_dim",val:" = 256"},{name:"decoder_num_heads",val:" = 8"},{name:"decoder_num_layers",val:" = 6"},{name:"decoder_activation",val:" = 'relu'"},{name:"decoder_dim_feedforward",val:" = 2048"},{name:"decoder_num_points",val:" = 4"},{name:"decoder_dropout",val:" = 0.0"},{name:"eval_size",val:" = None"},{name:"learn_initial_query",val:" = False"},{name:"cache_size",val:" = 100"},{name:"is_encoder_decoder",val:" = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.OmDetTurboConfig.text_config",description:`<strong>text_config</strong> (<code>PretrainedConfig</code>, <em>optional</em>) &#x2014;
The configuration of the text backbone.`,name:"text_config"},{anchor:"transformers.OmDetTurboConfig.backbone_config",description:`<strong>backbone_config</strong> (<code>PretrainedConfig</code>, <em>optional</em>) &#x2014;
The configuration of the vision backbone.`,name:"backbone_config"},{anchor:"transformers.OmDetTurboConfig.use_timm_backbone",description:`<strong>use_timm_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use the timm for the vision backbone.`,name:"use_timm_backbone"},{anchor:"transformers.OmDetTurboConfig.backbone",description:`<strong>backbone</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;swin_tiny_patch4_window7_224&quot;</code>) &#x2014;
The name of the pretrained vision backbone to use. If <code>use_pretrained_backbone=False</code> a randomly initialized
backbone with the same architecture <code>backbone</code> is used.`,name:"backbone"},{anchor:"transformers.OmDetTurboConfig.backbone_kwargs",description:`<strong>backbone_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Additional kwargs for the vision backbone.`,name:"backbone_kwargs"},{anchor:"transformers.OmDetTurboConfig.use_pretrained_backbone",description:`<strong>use_pretrained_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use a pretrained vision backbone.`,name:"use_pretrained_backbone"},{anchor:"transformers.OmDetTurboConfig.apply_layernorm_after_vision_backbone",description:`<strong>apply_layernorm_after_vision_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to apply layer normalization on the feature maps of the vision backbone output.`,name:"apply_layernorm_after_vision_backbone"},{anchor:"transformers.OmDetTurboConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 640) &#x2014;
The size (resolution) of each image.`,name:"image_size"},{anchor:"transformers.OmDetTurboConfig.disable_custom_kernels",description:`<strong>disable_custom_kernels</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to disable custom kernels.`,name:"disable_custom_kernels"},{anchor:"transformers.OmDetTurboConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon value for layer normalization.`,name:"layer_norm_eps"},{anchor:"transformers.OmDetTurboConfig.batch_norm_eps",description:`<strong>batch_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon value for batch normalization.`,name:"batch_norm_eps"},{anchor:"transformers.OmDetTurboConfig.init_std",description:`<strong>init_std</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"init_std"},{anchor:"transformers.OmDetTurboConfig.text_projection_in_dim",description:`<strong>text_projection_in_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The input dimension for the text projection.`,name:"text_projection_in_dim"},{anchor:"transformers.OmDetTurboConfig.text_projection_out_dim",description:`<strong>text_projection_out_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The output dimension for the text projection.`,name:"text_projection_out_dim"},{anchor:"transformers.OmDetTurboConfig.task_encoder_hidden_dim",description:`<strong>task_encoder_hidden_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
The feedforward dimension for the task encoder.`,name:"task_encoder_hidden_dim"},{anchor:"transformers.OmDetTurboConfig.class_embed_dim",description:`<strong>class_embed_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The dimension of the classes embeddings.`,name:"class_embed_dim"},{anchor:"transformers.OmDetTurboConfig.class_distance_type",description:`<strong>class_distance_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;cosine&quot;</code>) &#x2014;
The type of of distance to compare predicted classes to projected classes embeddings.
Can be <code>&quot;cosine&quot;</code> or <code>&quot;dot&quot;</code>.`,name:"class_distance_type"},{anchor:"transformers.OmDetTurboConfig.num_queries",description:`<strong>num_queries</strong> (<code>int</code>, <em>optional</em>, defaults to 900) &#x2014;
The number of queries.`,name:"num_queries"},{anchor:"transformers.OmDetTurboConfig.csp_activation",description:`<strong>csp_activation</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;silu&quot;</code>) &#x2014;
The activation function of the Cross Stage Partial (CSP) networks of the encoder.`,name:"csp_activation"},{anchor:"transformers.OmDetTurboConfig.conv_norm_activation",description:`<strong>conv_norm_activation</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The activation function of the ConvNormLayer layers of the encoder.`,name:"conv_norm_activation"},{anchor:"transformers.OmDetTurboConfig.encoder_feedforward_activation",description:`<strong>encoder_feedforward_activation</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;relu&quot;</code>) &#x2014;
The activation function for the feedforward network of the encoder.`,name:"encoder_feedforward_activation"},{anchor:"transformers.OmDetTurboConfig.encoder_feedforward_dropout",description:`<strong>encoder_feedforward_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout rate following the activation of the encoder feedforward network.`,name:"encoder_feedforward_dropout"},{anchor:"transformers.OmDetTurboConfig.encoder_dropout",description:`<strong>encoder_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout rate of the encoder multi-head attention module.`,name:"encoder_dropout"},{anchor:"transformers.OmDetTurboConfig.hidden_expansion",description:`<strong>hidden_expansion</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The hidden expansion of the CSP networks in the encoder.`,name:"hidden_expansion"},{anchor:"transformers.OmDetTurboConfig.vision_features_channels",description:`<strong>vision_features_channels</strong> (<code>tuple(int)</code>, <em>optional</em>, defaults to <code>[256, 256, 256]</code>) &#x2014;
The projected vision features channels used as inputs for the decoder.`,name:"vision_features_channels"},{anchor:"transformers.OmDetTurboConfig.encoder_hidden_dim",description:`<strong>encoder_hidden_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
The hidden dimension of the encoder.`,name:"encoder_hidden_dim"},{anchor:"transformers.OmDetTurboConfig.encoder_in_channels",description:`<strong>encoder_in_channels</strong> (<code>List(int)</code>, <em>optional</em>, defaults to <code>[192, 384, 768]</code>) &#x2014;
The input channels for the encoder.`,name:"encoder_in_channels"},{anchor:"transformers.OmDetTurboConfig.encoder_projection_indices",description:`<strong>encoder_projection_indices</strong> (<code>List(int)</code>, <em>optional</em>, defaults to <code>[2]</code>) &#x2014;
The indices of the input features projected by each layers.`,name:"encoder_projection_indices"},{anchor:"transformers.OmDetTurboConfig.encoder_attention_heads",description:`<strong>encoder_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
The number of attention heads for the encoder.`,name:"encoder_attention_heads"},{anchor:"transformers.OmDetTurboConfig.encoder_dim_feedforward",description:`<strong>encoder_dim_feedforward</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
The feedforward dimension for the encoder.`,name:"encoder_dim_feedforward"},{anchor:"transformers.OmDetTurboConfig.encoder_layers",description:`<strong>encoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of layers in the encoder.`,name:"encoder_layers"},{anchor:"transformers.OmDetTurboConfig.positional_encoding_temperature",description:`<strong>positional_encoding_temperature</strong> (<code>int</code>, <em>optional</em>, defaults to 10000) &#x2014;
The positional encoding temperature in the encoder.`,name:"positional_encoding_temperature"},{anchor:"transformers.OmDetTurboConfig.num_feature_levels",description:`<strong>num_feature_levels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of feature levels for the multi-scale deformable attention module of the decoder.`,name:"num_feature_levels"},{anchor:"transformers.OmDetTurboConfig.decoder_hidden_dim",description:`<strong>decoder_hidden_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
The hidden dimension of the decoder.`,name:"decoder_hidden_dim"},{anchor:"transformers.OmDetTurboConfig.decoder_num_heads",description:`<strong>decoder_num_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
The number of heads for the decoder.`,name:"decoder_num_heads"},{anchor:"transformers.OmDetTurboConfig.decoder_num_layers",description:`<strong>decoder_num_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
The number of layers for the decoder.`,name:"decoder_num_layers"},{anchor:"transformers.OmDetTurboConfig.decoder_activation",description:`<strong>decoder_activation</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;relu&quot;</code>) &#x2014;
The activation function for the decoder.`,name:"decoder_activation"},{anchor:"transformers.OmDetTurboConfig.decoder_dim_feedforward",description:`<strong>decoder_dim_feedforward</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
The feedforward dimension for the decoder.`,name:"decoder_dim_feedforward"},{anchor:"transformers.OmDetTurboConfig.decoder_num_points",description:`<strong>decoder_num_points</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The number of points sampled in the decoder multi-scale deformable attention module.`,name:"decoder_num_points"},{anchor:"transformers.OmDetTurboConfig.decoder_dropout",description:`<strong>decoder_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout rate for the decoder.`,name:"decoder_dropout"},{anchor:"transformers.OmDetTurboConfig.eval_size",description:`<strong>eval_size</strong> (<code>Tuple[int, int]</code>, <em>optional</em>) &#x2014;
Height and width used to computes the effective height and width of the position embeddings after taking
into account the stride (see RTDetr).`,name:"eval_size"},{anchor:"transformers.OmDetTurboConfig.learn_initial_query",description:`<strong>learn_initial_query</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to learn the initial query.`,name:"learn_initial_query"},{anchor:"transformers.OmDetTurboConfig.cache_size",description:`<strong>cache_size</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The cache size for the classes and prompts caches.`,name:"cache_size"},{anchor:"transformers.OmDetTurboConfig.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the model is used as an encoder-decoder model or not.`,name:"is_encoder_decoder"},{anchor:"transformers.OmDetTurboConfig.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional parameters from the architecture. The values in kwargs will be saved as part of the configuration
and can be used to control the model outputs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/omdet_turbo/configuration_omdet_turbo.py#L26"}}),Z=new Cs({props:{anchor:"transformers.OmDetTurboConfig.example",$$slots:{default:[Ns]},$$scope:{ctx:O}}}),ne=new C({props:{title:"OmDetTurboProcessor",local:"transformers.OmDetTurboProcessor",headingTag:"h2"}}),oe=new we({props:{name:"class transformers.OmDetTurboProcessor",anchor:"transformers.OmDetTurboProcessor",parameters:[{name:"image_processor",val:""},{name:"tokenizer",val:""}],parametersDescription:[{anchor:"transformers.OmDetTurboProcessor.image_processor",description:`<strong>image_processor</strong> (<code>DetrImageProcessor</code>) &#x2014;
An instance of <a href="/docs/transformers/main/en/model_doc/detr#transformers.DetrImageProcessor">DetrImageProcessor</a>. The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.OmDetTurboProcessor.tokenizer",description:"<strong>tokenizer</strong> (<code>AutoTokenizer</code>) &#x2014;\nAn instance of [&#x2018;PreTrainedTokenizer`]. The tokenizer is a required input.",name:"tokenizer"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/omdet_turbo/processing_omdet_turbo.py#L203"}}),ae=new we({props:{name:"post_process_grounded_object_detection",anchor:"transformers.OmDetTurboProcessor.post_process_grounded_object_detection",parameters:[{name:"outputs",val:": OmDetTurboObjectDetectionOutput"},{name:"text_labels",val:": typing.Union[typing.List[str], typing.List[typing.List[str]], NoneType] = None"},{name:"threshold",val:": float = 0.3"},{name:"nms_threshold",val:": float = 0.5"},{name:"target_sizes",val:": typing.Union[transformers.utils.generic.TensorType, typing.List[typing.Tuple], NoneType] = None"},{name:"max_num_det",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"transformers.OmDetTurboProcessor.post_process_grounded_object_detection.outputs",description:`<strong>outputs</strong> (<code>OmDetTurboObjectDetectionOutput</code>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.OmDetTurboProcessor.post_process_grounded_object_detection.text_labels",description:`<strong>text_labels</strong> (Union[List[str], List[List[str]]], <em>optional</em>) &#x2014;
The input classes names. If not provided, <code>text_labels</code> will be set to <code>None</code> in <code>outputs</code>.`,name:"text_labels"},{anchor:"transformers.OmDetTurboProcessor.post_process_grounded_object_detection.threshold",description:`<strong>threshold</strong> (float, defaults to 0.3) &#x2014;
Only return detections with a confidence score exceeding this threshold.`,name:"threshold"},{anchor:"transformers.OmDetTurboProcessor.post_process_grounded_object_detection.nms_threshold",description:`<strong>nms_threshold</strong> (float, defaults to 0.5) &#x2014;
The threshold to use for box non-maximum suppression. Value in [0, 1].`,name:"nms_threshold"},{anchor:"transformers.OmDetTurboProcessor.post_process_grounded_object_detection.target_sizes",description:`<strong>target_sizes</strong> (<code>torch.Tensor</code> or <code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
Tensor of shape <code>(batch_size, 2)</code> or list of tuples (<code>Tuple[int, int]</code>) containing the target size
<code>(height, width)</code> of each image in the batch. If unset, predictions will not be resized.`,name:"target_sizes"},{anchor:"transformers.OmDetTurboProcessor.post_process_grounded_object_detection.max_num_det",description:`<strong>max_num_det</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum number of detections to return.`,name:"max_num_det"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/omdet_turbo/processing_omdet_turbo.py#L322",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, each dictionary containing the scores, classes and boxes for an image
in the batch as predicted by the model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),re=new C({props:{title:"OmDetTurboForObjectDetection",local:"transformers.OmDetTurboForObjectDetection",headingTag:"h2"}}),le=new we({props:{name:"class transformers.OmDetTurboForObjectDetection",anchor:"transformers.OmDetTurboForObjectDetection",parameters:[{name:"config",val:": OmDetTurboConfig"}],parametersDescription:[{anchor:"transformers.OmDetTurboForObjectDetection.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/omdet-turbo#transformers.OmDetTurboConfig">OmDetTurboConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/omdet_turbo/modeling_omdet_turbo.py#L1477"}}),ce=new we({props:{name:"forward",anchor:"transformers.OmDetTurboForObjectDetection.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"classes_input_ids",val:": LongTensor"},{name:"classes_attention_mask",val:": LongTensor"},{name:"tasks_input_ids",val:": LongTensor"},{name:"tasks_attention_mask",val:": LongTensor"},{name:"classes_structure",val:": LongTensor"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.OmDetTurboForObjectDetection.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.OmDetTurboForObjectDetection.forward.classes_input_ids",description:`<strong>classes_input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(total_classes (&gt;= batch_size), sequence_length)</code>) &#x2014;
Indices of input classes sequence tokens in the vocabulary of the language model.
Several classes can be provided for each tasks, thus the tokenized classes are flattened
and the structure of the classes is provided in the <code>classes_structure</code> argument.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/omdet-turbo#transformers.OmDetTurboProcessor">OmDetTurboProcessor</a>. See <code>OmDetTurboProcessor.__call__()</code> for
details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"classes_input_ids"},{anchor:"transformers.OmDetTurboForObjectDetection.forward.classes_attention_mask",description:`<strong>classes_attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(total_classes (&gt;= batch_size), num_classes, sequence_length)</code>) &#x2014;
Attention mask for the classes. This is a binary mask that indicates which tokens should be attended to,
and which should not.`,name:"classes_attention_mask"},{anchor:"transformers.OmDetTurboForObjectDetection.forward.tasks_input_ids",description:`<strong>tasks_input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input tasks sequence tokens in the vocabulary of the language model.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/omdet-turbo#transformers.OmDetTurboProcessor">OmDetTurboProcessor</a>. See <code>OmDetTurboProcessor.__call__()</code> for
details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"tasks_input_ids"},{anchor:"transformers.OmDetTurboForObjectDetection.forward.tasks_attention_mask",description:`<strong>tasks_attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Attention mask for the tasks. This is a binary mask that indicates which tokens should be attended to,
and which should not.`,name:"tasks_attention_mask"},{anchor:"transformers.OmDetTurboForObjectDetection.forward.classes_structure",description:`<strong>classes_structure</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size)</code>) &#x2014;
Structure of the classes. This tensor indicates the number of classes for each task.`,name:"classes_structure"},{anchor:"transformers.OmDetTurboForObjectDetection.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"labels"},{anchor:"transformers.OmDetTurboForObjectDetection.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.OmDetTurboForObjectDetection.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.OmDetTurboForObjectDetection.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/omdet_turbo/modeling_omdet_turbo.py#L1513",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.omdet_turbo.modeling_omdet_turbo.OmDetTurboObjectDetectionOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/omdet-turbo#transformers.OmDetTurboConfig"
>OmDetTurboConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code>) — The loss value.</li>
<li><strong>decoder_coord_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, 4)</code>) — The predicted coordinates logits of the objects.</li>
<li><strong>decoder_class_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, num_classes)</code>) — The predicted class of the objects.</li>
<li><strong>init_reference_points</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, 4)</code>) — The initial reference points.</li>
<li><strong>intermediate_reference_points</strong> (<code>Tuple[Tuple[torch.FloatTensor]]</code>) — The intermediate reference points.</li>
<li><strong>encoder_coord_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, 4)</code>) — The predicted coordinates of the objects from the encoder.</li>
<li><strong>encoder_class_logits</strong> (<code>Tuple[torch.FloatTensor]</code>) — The predicted class of the objects from the encoder.</li>
<li><strong>encoder_extracted_states</strong> (<code>torch.FloatTensor</code>) — The extracted states from the Feature Pyramid Network (FPN) and Path Aggregation Network (PAN) of the encoder.</li>
<li><strong>decoder_hidden_states</strong> (<code>Tuple[torch.FloatTensor]</code>, <em>optional</em>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>decoder_attentions</strong> (<code>Tuple[Tuple[torch.FloatTensor]]</code>, <em>optional</em>) — Tuple of tuples of <code>torch.FloatTensor</code> (one for attention for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the
weighted average in the self-attention, cross-attention and multi-scale deformable attention heads.</li>
<li><strong>encoder_hidden_states</strong> (<code>Tuple[torch.FloatTensor]</code>, <em>optional</em>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>encoder_attentions</strong> (<code>Tuple[Tuple[torch.FloatTensor]]</code>, <em>optional</em>) — Tuple of tuples of <code>torch.FloatTensor</code> (one for attention for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the
weighted average in the self-attention, cross-attention and multi-scale deformable attention heads.</li>
<li><strong>classes_structure</strong> (<code>torch.LongTensor</code>, <em>optional</em>) — The number of queried classes for each image.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.omdet_turbo.modeling_omdet_turbo.OmDetTurboObjectDetectionOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),$=new Gs({props:{$$slots:{default:[Fs]},$$scope:{ctx:O}}}),R=new Cs({props:{anchor:"transformers.OmDetTurboForObjectDetection.forward.example",$$slots:{default:[qs]},$$scope:{ctx:O}}}),ie=new Bs({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/omdet-turbo.md"}}),{c(){l=c("meta"),J=o(),_=c("p"),m=o(),p(j.$$.fragment),r=o(),y=c("div"),y.innerHTML=ms,Je=o(),p(B.$$.fragment),Me=o(),N=c("p"),N.innerHTML=ps,ve=o(),F=c("p"),F.textContent=us,Ie=o(),q=c("p"),q.innerHTML=hs,Ue=o(),z=c("img"),ke=o(),W=c("small"),W.innerHTML=gs,De=o(),E=c("p"),E.innerHTML=fs,xe=o(),p(Q.$$.fragment),Ce=o(),H=c("p"),H.innerHTML=Ts,Oe=o(),X=c("p"),X.innerHTML=_s,ze=o(),p(Y.$$.fragment),Ze=o(),p(L.$$.fragment),Ve=o(),S=c("p"),S.textContent=js,$e=o(),p(A.$$.fragment),Re=o(),p(P.$$.fragment),Ge=o(),K=c("p"),K.textContent=ys,Be=o(),p(ee.$$.fragment),Ne=o(),p(se.$$.fragment),Fe=o(),M=c("div"),p(te.$$.fragment),Se=o(),pe=c("p"),pe.innerHTML=ws,Ae=o(),ue=c("p"),ue.innerHTML=Js,Pe=o(),p(Z.$$.fragment),qe=o(),p(ne.$$.fragment),We=o(),v=c("div"),p(oe.$$.fragment),Ke=o(),he=c("p"),he.textContent=Ms,es=o(),be=c("p"),be.innerHTML=vs,ss=o(),V=c("div"),p(ae.$$.fragment),ts=o(),ge=c("p"),ge.innerHTML=Is,Ee=o(),p(re.$$.fragment),Qe=o(),w=c("div"),p(le.$$.fragment),ns=o(),fe=c("p"),fe.textContent=Us,os=o(),Te=c("p"),Te.innerHTML=ks,as=o(),_e=c("p"),_e.innerHTML=Ds,rs=o(),I=c("div"),p(ce.$$.fragment),ls=o(),je=c("p"),je.innerHTML=xs,cs=o(),p($.$$.fragment),is=o(),p(R.$$.fragment),He=o(),p(ie.$$.fragment),Xe=o(),ye=c("p"),this.h()},l(e){const s=Rs("svelte-u9bgzb",document.head);l=i(s,"META",{name:!0,content:!0}),s.forEach(t),J=a(e),_=i(e,"P",{}),me(_).forEach(t),m=a(e),u(j.$$.fragment,e),r=a(e),y=i(e,"DIV",{class:!0,"data-svelte-h":!0}),T(y)!=="svelte-13t8s2t"&&(y.innerHTML=ms),Je=a(e),u(B.$$.fragment,e),Me=a(e),N=i(e,"P",{"data-svelte-h":!0}),T(N)!=="svelte-o5s894"&&(N.innerHTML=ps),ve=a(e),F=i(e,"P",{"data-svelte-h":!0}),T(F)!=="svelte-vfdo9a"&&(F.textContent=us),Ie=a(e),q=i(e,"P",{"data-svelte-h":!0}),T(q)!=="svelte-1plfyau"&&(q.innerHTML=hs),Ue=a(e),z=i(e,"IMG",{src:!0,alt:!0,width:!0}),ke=a(e),W=i(e,"SMALL",{"data-svelte-h":!0}),T(W)!=="svelte-1lprvf"&&(W.innerHTML=gs),De=a(e),E=i(e,"P",{"data-svelte-h":!0}),T(E)!=="svelte-1anbey3"&&(E.innerHTML=fs),xe=a(e),u(Q.$$.fragment,e),Ce=a(e),H=i(e,"P",{"data-svelte-h":!0}),T(H)!=="svelte-6qxnhs"&&(H.innerHTML=Ts),Oe=a(e),X=i(e,"P",{"data-svelte-h":!0}),T(X)!=="svelte-uxoj4w"&&(X.innerHTML=_s),ze=a(e),u(Y.$$.fragment,e),Ze=a(e),u(L.$$.fragment,e),Ve=a(e),S=i(e,"P",{"data-svelte-h":!0}),T(S)!=="svelte-7rgq3f"&&(S.textContent=js),$e=a(e),u(A.$$.fragment,e),Re=a(e),u(P.$$.fragment,e),Ge=a(e),K=i(e,"P",{"data-svelte-h":!0}),T(K)!=="svelte-s1nkyi"&&(K.textContent=ys),Be=a(e),u(ee.$$.fragment,e),Ne=a(e),u(se.$$.fragment,e),Fe=a(e),M=i(e,"DIV",{class:!0});var U=me(M);u(te.$$.fragment,U),Se=a(U),pe=i(U,"P",{"data-svelte-h":!0}),T(pe)!=="svelte-1ud0jf5"&&(pe.innerHTML=ws),Ae=a(U),ue=i(U,"P",{"data-svelte-h":!0}),T(ue)!=="svelte-o55m63"&&(ue.innerHTML=Js),Pe=a(U),u(Z.$$.fragment,U),U.forEach(t),qe=a(e),u(ne.$$.fragment,e),We=a(e),v=i(e,"DIV",{class:!0});var k=me(v);u(oe.$$.fragment,k),Ke=a(k),he=i(k,"P",{"data-svelte-h":!0}),T(he)!=="svelte-sqqjjc"&&(he.textContent=Ms),es=a(k),be=i(k,"P",{"data-svelte-h":!0}),T(be)!=="svelte-ci7234"&&(be.innerHTML=vs),ss=a(k),V=i(k,"DIV",{class:!0});var de=me(V);u(ae.$$.fragment,de),ts=a(de),ge=i(de,"P",{"data-svelte-h":!0}),T(ge)!=="svelte-7iivmj"&&(ge.innerHTML=Is),de.forEach(t),k.forEach(t),Ee=a(e),u(re.$$.fragment,e),Qe=a(e),w=i(e,"DIV",{class:!0});var x=me(w);u(le.$$.fragment,x),ns=a(x),fe=i(x,"P",{"data-svelte-h":!0}),T(fe)!=="svelte-1cqamoa"&&(fe.textContent=Us),os=a(x),Te=i(x,"P",{"data-svelte-h":!0}),T(Te)!=="svelte-6pahdo"&&(Te.innerHTML=ks),as=a(x),_e=i(x,"P",{"data-svelte-h":!0}),T(_e)!=="svelte-hswkmf"&&(_e.innerHTML=Ds),rs=a(x),I=i(x,"DIV",{class:!0});var G=me(I);u(ce.$$.fragment,G),ls=a(G),je=i(G,"P",{"data-svelte-h":!0}),T(je)!=="svelte-1o12qr"&&(je.innerHTML=xs),cs=a(G),u($.$$.fragment,G),is=a(G),u(R.$$.fragment,G),G.forEach(t),x.forEach(t),He=a(e),u(ie.$$.fragment,e),Xe=a(e),ye=i(e,"P",{}),me(ye).forEach(t),this.h()},h(){D(l,"name","hf:doc:metadata"),D(l,"content",Es),D(y,"class","flex flex-wrap space-x-1"),zs(z.src,bs="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/omdet_turbo_architecture.jpeg")||D(z,"src",bs),D(z,"alt","drawing"),D(z,"width","600"),D(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,s){d(document.head,l),n(e,J,s),n(e,_,s),n(e,m,s),h(j,e,s),n(e,r,s),n(e,y,s),n(e,Je,s),h(B,e,s),n(e,Me,s),n(e,N,s),n(e,ve,s),n(e,F,s),n(e,Ie,s),n(e,q,s),n(e,Ue,s),n(e,z,s),n(e,ke,s),n(e,W,s),n(e,De,s),n(e,E,s),n(e,xe,s),h(Q,e,s),n(e,Ce,s),n(e,H,s),n(e,Oe,s),n(e,X,s),n(e,ze,s),h(Y,e,s),n(e,Ze,s),h(L,e,s),n(e,Ve,s),n(e,S,s),n(e,$e,s),h(A,e,s),n(e,Re,s),h(P,e,s),n(e,Ge,s),n(e,K,s),n(e,Be,s),h(ee,e,s),n(e,Ne,s),h(se,e,s),n(e,Fe,s),n(e,M,s),h(te,M,null),d(M,Se),d(M,pe),d(M,Ae),d(M,ue),d(M,Pe),h(Z,M,null),n(e,qe,s),h(ne,e,s),n(e,We,s),n(e,v,s),h(oe,v,null),d(v,Ke),d(v,he),d(v,es),d(v,be),d(v,ss),d(v,V),h(ae,V,null),d(V,ts),d(V,ge),n(e,Ee,s),h(re,e,s),n(e,Qe,s),n(e,w,s),h(le,w,null),d(w,ns),d(w,fe),d(w,os),d(w,Te),d(w,as),d(w,_e),d(w,rs),d(w,I),h(ce,I,null),d(I,ls),d(I,je),d(I,cs),h($,I,null),d(I,is),h(R,I,null),n(e,He,s),h(ie,e,s),n(e,Xe,s),n(e,ye,s),Ye=!0},p(e,[s]){const U={};s&2&&(U.$$scope={dirty:s,ctx:e}),Z.$set(U);const k={};s&2&&(k.$$scope={dirty:s,ctx:e}),$.$set(k);const de={};s&2&&(de.$$scope={dirty:s,ctx:e}),R.$set(de)},i(e){Ye||(b(j.$$.fragment,e),b(B.$$.fragment,e),b(Q.$$.fragment,e),b(Y.$$.fragment,e),b(L.$$.fragment,e),b(A.$$.fragment,e),b(P.$$.fragment,e),b(ee.$$.fragment,e),b(se.$$.fragment,e),b(te.$$.fragment,e),b(Z.$$.fragment,e),b(ne.$$.fragment,e),b(oe.$$.fragment,e),b(ae.$$.fragment,e),b(re.$$.fragment,e),b(le.$$.fragment,e),b(ce.$$.fragment,e),b($.$$.fragment,e),b(R.$$.fragment,e),b(ie.$$.fragment,e),Ye=!0)},o(e){g(j.$$.fragment,e),g(B.$$.fragment,e),g(Q.$$.fragment,e),g(Y.$$.fragment,e),g(L.$$.fragment,e),g(A.$$.fragment,e),g(P.$$.fragment,e),g(ee.$$.fragment,e),g(se.$$.fragment,e),g(te.$$.fragment,e),g(Z.$$.fragment,e),g(ne.$$.fragment,e),g(oe.$$.fragment,e),g(ae.$$.fragment,e),g(re.$$.fragment,e),g(le.$$.fragment,e),g(ce.$$.fragment,e),g($.$$.fragment,e),g(R.$$.fragment,e),g(ie.$$.fragment,e),Ye=!1},d(e){e&&(t(J),t(_),t(m),t(r),t(y),t(Je),t(Me),t(N),t(ve),t(F),t(Ie),t(q),t(Ue),t(z),t(ke),t(W),t(De),t(E),t(xe),t(Ce),t(H),t(Oe),t(X),t(ze),t(Ze),t(Ve),t(S),t($e),t(Re),t(Ge),t(K),t(Be),t(Ne),t(Fe),t(M),t(qe),t(We),t(v),t(Ee),t(Qe),t(w),t(He),t(Xe),t(ye)),t(l),f(j,e),f(B,e),f(Q,e),f(Y,e),f(L,e),f(A,e),f(P,e),f(ee,e),f(se,e),f(te),f(Z),f(ne,e),f(oe),f(ae),f(re,e),f(le),f(ce),f($),f(R),f(ie,e)}}}const Es='{"title":"OmDet-Turbo","local":"omdet-turbo","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Usage example","local":"usage-example","sections":[{"title":"Single image inference","local":"single-image-inference","sections":[],"depth":3},{"title":"Multi image inference","local":"multi-image-inference","sections":[],"depth":3}],"depth":2},{"title":"OmDetTurboConfig","local":"transformers.OmDetTurboConfig","sections":[],"depth":2},{"title":"OmDetTurboProcessor","local":"transformers.OmDetTurboProcessor","sections":[],"depth":2},{"title":"OmDetTurboForObjectDetection","local":"transformers.OmDetTurboForObjectDetection","sections":[],"depth":2}],"depth":1}';function Qs(O){return Zs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class et extends Vs{constructor(l){super(),$s(this,l,Qs,Ws,Os,{})}}export{et as component};
