import{s as Rl,o as vl,n as Wl}from"../chunks/scheduler.18a86fab.js";import{S as Xl,i as Hl,g as p,s as a,r as c,A as zl,h as i,f as s,c as n,j as Gl,u as r,x as J,k as yl,y as $l,a as t,v as m,d,t as w,w as T}from"../chunks/index.98837b22.js";import{T as Vl}from"../chunks/Tip.77304350.js";import{C as b}from"../chunks/CodeBlock.8d0c2e8a.js";import{H as hl}from"../chunks/Heading.7e7e0c5b.js";import{E as Yl}from"../chunks/getInferenceSnippets.de10bc7d.js";function Ql(E){let M,k='The <a href="https://github.com/huggingface/transformers/blob/9985d06add07a4cc691dc54a7e34f54205c04d40/src/transformers/utils/import_utils.py#L2286" rel="nofollow">clear_import_cache</a> utility is very useful when you’re iteratively modifying and developing model code. It removes all cached Transformers modules and allows Python to reload the modified code without constantly restarting your environment.',u,y,h;return y=new b({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMudXRpbHMuaW1wb3J0X3V0aWxzJTIwaW1wb3J0JTIwY2xlYXJfaW1wb3J0X2NhY2hlJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS11bmNhc2VkJTIyKSUwQSUyMyUyMG1vZGlmaWNhdGlvbnMlMjB0byUyMG1vZGVsJTIwY29kZSUwQSUyMyUyMGNsZWFyJTIwY2FjaGUlMjB0byUyMHJlbG9hZCUyMG1vZGlmaWVkJTIwY29kZSUwQWNsZWFyX2ltcG9ydF9jYWNoZSgpJTBBJTIzJTIwcmUtaW1wb3J0JTIwdG8lMjB1c2UlMjB1cGRhdGVkJTIwY29kZSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtdW5jYXNlZCUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel
<span class="hljs-keyword">from</span> transformers.utils.import_utils <span class="hljs-keyword">import</span> clear_import_cache

model = AutoModel.from_pretrained(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)
<span class="hljs-comment"># modifications to model code</span>
<span class="hljs-comment"># clear cache to reload modified code</span>
clear_import_cache()
<span class="hljs-comment"># re-import to use updated code</span>
model = AutoModel.from_pretrained(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)`,wrap:!1}}),{c(){M=p("p"),M.innerHTML=k,u=a(),c(y.$$.fragment)},l(o){M=i(o,"P",{"data-svelte-h":!0}),J(M)!=="svelte-qq0ajk"&&(M.innerHTML=k),u=n(o),r(y.$$.fragment,o)},m(o,j){t(o,M,j),t(o,u,j),m(y,o,j),h=!0},p:Wl,i(o){h||(d(y.$$.fragment,o),h=!0)},o(o){w(y.$$.fragment,o),h=!1},d(o){o&&(s(M),s(u)),T(y,o)}}}function Sl(E){let M,k,u,y,h,o,j,jl='Another way to customize a model is to modify their components, rather than writing a new model entirely, allowing you to tailor a model to your specific use case. For example, you can add new layers or optimize the attention mechanism of an architecture. Customizations are applied directly to a Transformers model so that you can continue to use features such as <a href="/docs/transformers/main/en/main_classes/trainer#transformers.Trainer">Trainer</a>, <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>, and the <a href="https://huggingface.co/docs/peft/en/index" rel="nofollow">PEFT</a> library.',q,A,ul='This guide will show you how to customize a models attention mechanism in order to apply <a href="https://huggingface.co/docs/peft/conceptual_guides/adapter#low-rank-adaptation-lora" rel="nofollow">Low-Rank Adaptation (LoRA)</a> to it.',F,I,x,Z,D,_,Il='<a href="./model_doc/sam">Segment Anything</a> is an image segmentation model, and it combines the query-key-value (<code>qkv</code>) projection in its attention mechanisms. To reduce the number of trainable parameters and computational overhead, you can apply LoRA to the <code>qkv</code> projection. This requires splitting the <code>qkv</code> projection so that you can separately target the <code>q</code> and <code>v</code> with LoRA.',K,C,Ul="<li>Create a custom attention class, <code>SamVisionAttentionSplit</code>, by subclassing the original <code>SamVisionAttention</code> class. In the <code>__init__</code>, delete the combined <code>qkv</code> and create a separate linear layer for <code>q</code>, <code>k</code> and <code>v</code>.</li>",P,B,O,U,fl="<li>The <code>_split_qkv_load_hook</code> function splits the pretrained <code>qkv</code> weights into separate <code>q</code>, <code>k</code>, and <code>v</code> weights when loading the model to ensure compatibility with any pretrained model.</li>",ll,g,el,f,bl="<li>In the <code>forward</code> pass, <code>q</code>, <code>k</code>, and <code>v</code> are computed separately while the rest of the attention mechanism remains the same.</li>",sl,G,tl,R,kl="Assign the custom <code>SamVisionAttentionSplit</code> class to the original models <code>SamVisionAttention</code> module to replace it. All instances of <code>SamVisionAttention</code> in the model is replaced with the split attention version.",al,v,Al='Load the model with <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a>.',nl,W,ol,X,Ml,H,Zl="With separate <code>q</code>, <code>k</code>, and <code>v</code> projections, apply LoRA to <code>q</code> and <code>v</code>.",pl,z,_l='Create a <a href="https://huggingface.co/docs/peft/package_reference/config#peft.PeftConfig" rel="nofollow">LoraConfig</a> and specify the rank <code>r</code>, <code>lora_alpha</code>, <code>lora_dropout</code>, <code>task_type</code>, and most importantly, the modules to target.',il,$,cl,V,Cl='Pass the model and <a href="https://huggingface.co/docs/peft/package_reference/config#peft.PeftConfig" rel="nofollow">LoraConfig</a> to <a href="https://huggingface.co/docs/peft/package_reference/peft_model#peft.get_peft_model" rel="nofollow">get_peft_model</a> to apply LoRA to the model.',rl,Y,Jl,Q,Bl='Call <a href="https://huggingface.co/docs/peft/package_reference/peft_model#peft.PeftMixedModel.print_trainable_parameters" rel="nofollow">print_trainable_parameters</a> to view the number of parameters you’re training as a result versus the total number of parameters.',ml,S,dl,N,wl,L,Tl;return h=new hl({props:{title:"Customizing model components",local:"customizing-model-components",headingTag:"h1"}}),I=new Vl({props:{warning:!1,$$slots:{default:[Ql]},$$scope:{ctx:E}}}),Z=new hl({props:{title:"Attention class",local:"attention-class",headingTag:"h2"}}),B=new b({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0b3JjaC5ubiUyMGFzJTIwbm4lMEFmcm9tJTIwdHJhbnNmb3JtZXJzLm1vZGVscy5zYW0ubW9kZWxpbmdfc2FtJTIwaW1wb3J0JTIwU2FtVmlzaW9uQXR0ZW50aW9uJTBBJTBBY2xhc3MlMjBTYW1WaXNpb25BdHRlbnRpb25TcGxpdChTYW1WaXNpb25BdHRlbnRpb24lMkMlMjBubi5Nb2R1bGUpJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMGNvbmZpZyUyQyUyMHdpbmRvd19zaXplKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oY29uZmlnJTJDJTIwd2luZG93X3NpemUpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwcmVtb3ZlJTIwY29tYmluZWQlMjBxa3YlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkZWwlMjBzZWxmLnFrdiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMHNlcGFyYXRlJTIwcSUyQyUyMGslMkMlMjB2JTIwcHJvamVjdGlvbnMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLnElMjAlM0QlMjBubi5MaW5lYXIoY29uZmlnLmhpZGRlbl9zaXplJTJDJTIwY29uZmlnLmhpZGRlbl9zaXplJTJDJTIwYmlhcyUzRGNvbmZpZy5xa3ZfYmlhcyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmslMjAlM0QlMjBubi5MaW5lYXIoY29uZmlnLmhpZGRlbl9zaXplJTJDJTIwY29uZmlnLmhpZGRlbl9zaXplJTJDJTIwYmlhcyUzRGNvbmZpZy5xa3ZfYmlhcyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLnYlMjAlM0QlMjBubi5MaW5lYXIoY29uZmlnLmhpZGRlbl9zaXplJTJDJTIwY29uZmlnLmhpZGRlbl9zaXplJTJDJTIwYmlhcyUzRGNvbmZpZy5xa3ZfYmlhcyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLl9yZWdpc3Rlcl9sb2FkX3N0YXRlX2RpY3RfcHJlX2hvb2soc2VsZi5zcGxpdF9xX2tfdl9sb2FkX2hvb2sp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn
<span class="hljs-keyword">from</span> transformers.models.sam.modeling_sam <span class="hljs-keyword">import</span> SamVisionAttention

<span class="hljs-keyword">class</span> <span class="hljs-title class_">SamVisionAttentionSplit</span>(SamVisionAttention, nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config, window_size</span>):
        <span class="hljs-built_in">super</span>().__init__(config, window_size)
        <span class="hljs-comment"># remove combined qkv</span>
        <span class="hljs-keyword">del</span> self.qkv
        <span class="hljs-comment"># separate q, k, v projections</span>
        self.q = nn.Linear(config.hidden_size, config.hidden_size, bias=config.qkv_bias)
        self.k = nn.Linear(config.hidden_size, config.hidden_size, bias=config.qkv_bias)
        self.v = nn.Linear(config.hidden_size, config.hidden_size, bias=config.qkv_bias)
        self._register_load_state_dict_pre_hook(self.split_q_k_v_load_hook)`,wrap:!1}}),g=new b({props:{code:"JTIwJTIwJTIwJTIwZGVmJTIwc3BsaXRfcV9rX3ZfbG9hZF9ob29rKHNlbGYlMkMlMjBzdGF0ZV9kaWN0JTJDJTIwcHJlZml4JTJDJTIwKmFyZ3MpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwa2V5c190b19kZWxldGUlMjAlM0QlMjAlNUIlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBrZXklMjBpbiUyMGxpc3Qoc3RhdGVfZGljdC5rZXlzKCkpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjAlMjJxa3YuJTIyJTIwaW4lMjBrZXklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBzcGxpdCUyMHElMkMlMjBrJTJDJTIwdiUyMGZyb20lMjB0aGUlMjBjb21iaW5lZCUyMHByb2plY3Rpb24lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBxJTJDJTIwayUyQyUyMHYlMjAlM0QlMjBzdGF0ZV9kaWN0JTVCa2V5JTVELmNodW5rKDMlMkMlMjBkaW0lM0QwKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMHJlcGxhY2UlMjB3aXRoJTIwaW5kaXZpZHVhbCUyMHElMkMlMjBrJTJDJTIwdiUyMHByb2plY3Rpb25zJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RhdGVfZGljdCU1QmtleS5yZXBsYWNlKCUyMnFrdi4lMjIlMkMlMjAlMjJxLiUyMiklNUQlMjAlM0QlMjBxJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RhdGVfZGljdCU1QmtleS5yZXBsYWNlKCUyMnFrdi4lMjIlMkMlMjAlMjJrLiUyMiklNUQlMjAlM0QlMjBrJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RhdGVfZGljdCU1QmtleS5yZXBsYWNlKCUyMnFrdi4lMjIlMkMlMjAlMjJ2LiUyMiklNUQlMjAlM0QlMjB2JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwbWFyayUyMHRoZSUyMG9sZCUyMHFrdiUyMGtleSUyMGZvciUyMGRlbGV0aW9uJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwa2V5c190b19kZWxldGUuYXBwZW5kKGtleSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjByZW1vdmUlMjBvbGQlMjBxa3YlMjBrZXlzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm9yJTIwa2V5JTIwaW4lMjBrZXlzX3RvX2RlbGV0ZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRlbCUyMHN0YXRlX2RpY3QlNUJrZXklNUQ=",highlighted:`    <span class="hljs-keyword">def</span> <span class="hljs-title function_">split_q_k_v_load_hook</span>(<span class="hljs-params">self, state_dict, prefix, *args</span>):
        keys_to_delete = []
        <span class="hljs-keyword">for</span> key <span class="hljs-keyword">in</span> <span class="hljs-built_in">list</span>(state_dict.keys()):
            <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;qkv.&quot;</span> <span class="hljs-keyword">in</span> key:
                <span class="hljs-comment"># split q, k, v from the combined projection</span>
                q, k, v = state_dict[key].chunk(<span class="hljs-number">3</span>, dim=<span class="hljs-number">0</span>)
                <span class="hljs-comment"># replace with individual q, k, v projections</span>
                state_dict[key.replace(<span class="hljs-string">&quot;qkv.&quot;</span>, <span class="hljs-string">&quot;q.&quot;</span>)] = q
                state_dict[key.replace(<span class="hljs-string">&quot;qkv.&quot;</span>, <span class="hljs-string">&quot;k.&quot;</span>)] = k
                state_dict[key.replace(<span class="hljs-string">&quot;qkv.&quot;</span>, <span class="hljs-string">&quot;v.&quot;</span>)] = v
                <span class="hljs-comment"># mark the old qkv key for deletion</span>
                keys_to_delete.append(key)
        
        <span class="hljs-comment"># remove old qkv keys</span>
        <span class="hljs-keyword">for</span> key <span class="hljs-keyword">in</span> keys_to_delete:
            <span class="hljs-keyword">del</span> state_dict[key]`,wrap:!1}}),G=new b({props:{code:"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",highlighted:`    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, hidden_states: torch.Tensor, output_attentions=<span class="hljs-literal">False</span></span>) -&gt; torch.Tensor:
        batch_size, height, width, _ = hidden_states.shape
        qkv_shapes = (batch_size *  self.num_attention_heads,  height * width, -<span class="hljs-number">1</span>)
        query = self.q(hidden_states).reshape((batch_size,  height * width,self.num_attention_heads, -<span class="hljs-number">1</span>)).permute(<span class="hljs-number">0</span>,<span class="hljs-number">2</span>,<span class="hljs-number">1</span>,<span class="hljs-number">3</span>).reshape(qkv_shapes)
        key = self.k(hidden_states).reshape((batch_size,  height * width,self.num_attention_heads, -<span class="hljs-number">1</span>)).permute(<span class="hljs-number">0</span>,<span class="hljs-number">2</span>,<span class="hljs-number">1</span>,<span class="hljs-number">3</span>).reshape(qkv_shapes)
        value = self.v(hidden_states).reshape((batch_size,  height * width,self.num_attention_heads, -<span class="hljs-number">1</span>)).permute(<span class="hljs-number">0</span>,<span class="hljs-number">2</span>,<span class="hljs-number">1</span>,<span class="hljs-number">3</span>).reshape(qkv_shapes)

        attn_weights = (query * self.scale) @ key.transpose(-<span class="hljs-number">2</span>, -<span class="hljs-number">1</span>)

        attn_weights = torch.nn.functional.softmax(attn_weights, dtype=torch.float32, dim=-<span class="hljs-number">1</span>).to(query.dtype)
        attn_probs = nn.functional.dropout(attn_weights, p=self.dropout, training=self.training)
        attn_output = (attn_probs @ value).reshape(batch_size, self.num_attention_heads, height, width, -<span class="hljs-number">1</span>)
        attn_output = attn_output.permute(<span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">1</span>, <span class="hljs-number">4</span>).reshape(batch_size, height, width, -<span class="hljs-number">1</span>)
        attn_output = self.proj(attn_output)

        <span class="hljs-keyword">if</span> output_attentions:
            outputs = (attn_output, attn_weights)
        <span class="hljs-keyword">else</span>:
            outputs = (attn_output, <span class="hljs-literal">None</span>)
        <span class="hljs-keyword">return</span> outputs`,wrap:!1}}),W=new b({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNhbU1vZGVsJTBBJTBBJTIzJTIwbG9hZCUyMHRoZSUyMHByZXRyYWluZWQlMjBTQU0lMjBtb2RlbCUwQW1vZGVsJTIwJTNEJTIwU2FtTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGc2FtLXZpdC1iYXNlJTIyKSUwQSUwQSUyMyUyMHJlcGxhY2UlMjB0aGUlMjBhdHRlbnRpb24lMjBjbGFzcyUyMGluJTIwdGhlJTIwdmlzaW9uX2VuY29kZXIlMjBtb2R1bGUlMEFmb3IlMjBsYXllciUyMGluJTIwbW9kZWwudmlzaW9uX2VuY29kZXIubGF5ZXJzJTNBJTBBJTIwJTIwJTIwJTIwaWYlMjBoYXNhdHRyKGxheWVyJTJDJTIwJTIyYXR0biUyMiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsYXllci5hdHRuJTIwJTNEJTIwU2FtVmlzaW9uQXR0ZW50aW9uU3BsaXQobW9kZWwuY29uZmlnLnZpc2lvbl9jb25maWclMkMlMjBtb2RlbC5jb25maWcudmlzaW9uX2NvbmZpZy53aW5kb3dfc2l6ZSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SamModel

<span class="hljs-comment"># load the pretrained SAM model</span>
model = SamModel.from_pretrained(<span class="hljs-string">&quot;facebook/sam-vit-base&quot;</span>)

<span class="hljs-comment"># replace the attention class in the vision_encoder module</span>
<span class="hljs-keyword">for</span> layer <span class="hljs-keyword">in</span> model.vision_encoder.layers:
    <span class="hljs-keyword">if</span> <span class="hljs-built_in">hasattr</span>(layer, <span class="hljs-string">&quot;attn&quot;</span>):
        layer.attn = SamVisionAttentionSplit(model.config.vision_config, model.config.vision_config.window_size)`,wrap:!1}}),X=new hl({props:{title:"LoRA",local:"lora",headingTag:"h2"}}),$=new b({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEFjb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHIlM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfYWxwaGElM0QzMiUyQyUwQSUyMCUyMCUyMCUyMCUyMyUyMGFwcGx5JTIwTG9SQSUyMHRvJTIwcSUyMGFuZCUyMHYlMEElMjAlMjAlMjAlMjB0YXJnZXRfbW9kdWxlcyUzRCU1QiUyMnElMjIlMkMlMjAlMjJ2JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwbG9yYV9kcm9wb3V0JTNEMC4xJTJDJTBBJTIwJTIwJTIwJTIwdGFza190eXBlJTNEJTIyRkVBVFVSRV9FWFRSQUNUSU9OJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model

config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    <span class="hljs-comment"># apply LoRA to q and v</span>
    target_modules=[<span class="hljs-string">&quot;q&quot;</span>, <span class="hljs-string">&quot;v&quot;</span>],
    lora_dropout=<span class="hljs-number">0.1</span>,
    task_type=<span class="hljs-string">&quot;FEATURE_EXTRACTION&quot;</span>
)`,wrap:!1}}),Y=new b({props:{code:"bW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChtb2RlbCUyQyUyMGNvbmZpZyk=",highlighted:"model = get_peft_model(model, config)",wrap:!1}}),S=new b({props:{code:"bW9kZWwucHJpbnRfdHJhaW5hYmxlX3BhcmFtZXRlcnMoKSUwQSUyMnRyYWluYWJsZSUyMHBhcmFtcyUzQSUyMDU4OSUyQzgyNCUyMCU3QyU3QyUyMGFsbCUyMHBhcmFtcyUzQSUyMDk0JTJDMjc0JTJDMDk2JTIwJTdDJTdDJTIwdHJhaW5hYmxlJTI1JTNBJTIwMC42MjU2JTIy",highlighted:`model.print_trainable_parameters()
<span class="hljs-string">&quot;trainable params: 589,824 || all params: 94,274,096 || trainable%: 0.6256&quot;</span>`,wrap:!1}}),N=new Yl({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/how_to_hack_models.md"}}),{c(){M=p("meta"),k=a(),u=p("p"),y=a(),c(h.$$.fragment),o=a(),j=p("p"),j.innerHTML=jl,q=a(),A=p("p"),A.innerHTML=ul,F=a(),c(I.$$.fragment),x=a(),c(Z.$$.fragment),D=a(),_=p("p"),_.innerHTML=Il,K=a(),C=p("ol"),C.innerHTML=Ul,P=a(),c(B.$$.fragment),O=a(),U=p("ol"),U.innerHTML=fl,ll=a(),c(g.$$.fragment),el=a(),f=p("ol"),f.innerHTML=bl,sl=a(),c(G.$$.fragment),tl=a(),R=p("p"),R.innerHTML=kl,al=a(),v=p("p"),v.innerHTML=Al,nl=a(),c(W.$$.fragment),ol=a(),c(X.$$.fragment),Ml=a(),H=p("p"),H.innerHTML=Zl,pl=a(),z=p("p"),z.innerHTML=_l,il=a(),c($.$$.fragment),cl=a(),V=p("p"),V.innerHTML=Cl,rl=a(),c(Y.$$.fragment),Jl=a(),Q=p("p"),Q.innerHTML=Bl,ml=a(),c(S.$$.fragment),dl=a(),c(N.$$.fragment),wl=a(),L=p("p"),this.h()},l(l){const e=zl("svelte-u9bgzb",document.head);M=i(e,"META",{name:!0,content:!0}),e.forEach(s),k=n(l),u=i(l,"P",{}),Gl(u).forEach(s),y=n(l),r(h.$$.fragment,l),o=n(l),j=i(l,"P",{"data-svelte-h":!0}),J(j)!=="svelte-gf3z1d"&&(j.innerHTML=jl),q=n(l),A=i(l,"P",{"data-svelte-h":!0}),J(A)!=="svelte-1rh1a31"&&(A.innerHTML=ul),F=n(l),r(I.$$.fragment,l),x=n(l),r(Z.$$.fragment,l),D=n(l),_=i(l,"P",{"data-svelte-h":!0}),J(_)!=="svelte-64c6cg"&&(_.innerHTML=Il),K=n(l),C=i(l,"OL",{"data-svelte-h":!0}),J(C)!=="svelte-1i23me3"&&(C.innerHTML=Ul),P=n(l),r(B.$$.fragment,l),O=n(l),U=i(l,"OL",{start:!0,"data-svelte-h":!0}),J(U)!=="svelte-11rant"&&(U.innerHTML=fl),ll=n(l),r(g.$$.fragment,l),el=n(l),f=i(l,"OL",{start:!0,"data-svelte-h":!0}),J(f)!=="svelte-6hmxrg"&&(f.innerHTML=bl),sl=n(l),r(G.$$.fragment,l),tl=n(l),R=i(l,"P",{"data-svelte-h":!0}),J(R)!=="svelte-nkh0b4"&&(R.innerHTML=kl),al=n(l),v=i(l,"P",{"data-svelte-h":!0}),J(v)!=="svelte-f5b0fs"&&(v.innerHTML=Al),nl=n(l),r(W.$$.fragment,l),ol=n(l),r(X.$$.fragment,l),Ml=n(l),H=i(l,"P",{"data-svelte-h":!0}),J(H)!=="svelte-1km26rk"&&(H.innerHTML=Zl),pl=n(l),z=i(l,"P",{"data-svelte-h":!0}),J(z)!=="svelte-1hvvkbj"&&(z.innerHTML=_l),il=n(l),r($.$$.fragment,l),cl=n(l),V=i(l,"P",{"data-svelte-h":!0}),J(V)!=="svelte-1gzm1t1"&&(V.innerHTML=Cl),rl=n(l),r(Y.$$.fragment,l),Jl=n(l),Q=i(l,"P",{"data-svelte-h":!0}),J(Q)!=="svelte-1ctingj"&&(Q.innerHTML=Bl),ml=n(l),r(S.$$.fragment,l),dl=n(l),r(N.$$.fragment,l),wl=n(l),L=i(l,"P",{}),Gl(L).forEach(s),this.h()},h(){yl(M,"name","hf:doc:metadata"),yl(M,"content",Nl),yl(U,"start","2"),yl(f,"start","3")},m(l,e){$l(document.head,M),t(l,k,e),t(l,u,e),t(l,y,e),m(h,l,e),t(l,o,e),t(l,j,e),t(l,q,e),t(l,A,e),t(l,F,e),m(I,l,e),t(l,x,e),m(Z,l,e),t(l,D,e),t(l,_,e),t(l,K,e),t(l,C,e),t(l,P,e),m(B,l,e),t(l,O,e),t(l,U,e),t(l,ll,e),m(g,l,e),t(l,el,e),t(l,f,e),t(l,sl,e),m(G,l,e),t(l,tl,e),t(l,R,e),t(l,al,e),t(l,v,e),t(l,nl,e),m(W,l,e),t(l,ol,e),m(X,l,e),t(l,Ml,e),t(l,H,e),t(l,pl,e),t(l,z,e),t(l,il,e),m($,l,e),t(l,cl,e),t(l,V,e),t(l,rl,e),m(Y,l,e),t(l,Jl,e),t(l,Q,e),t(l,ml,e),m(S,l,e),t(l,dl,e),m(N,l,e),t(l,wl,e),t(l,L,e),Tl=!0},p(l,[e]){const gl={};e&2&&(gl.$$scope={dirty:e,ctx:l}),I.$set(gl)},i(l){Tl||(d(h.$$.fragment,l),d(I.$$.fragment,l),d(Z.$$.fragment,l),d(B.$$.fragment,l),d(g.$$.fragment,l),d(G.$$.fragment,l),d(W.$$.fragment,l),d(X.$$.fragment,l),d($.$$.fragment,l),d(Y.$$.fragment,l),d(S.$$.fragment,l),d(N.$$.fragment,l),Tl=!0)},o(l){w(h.$$.fragment,l),w(I.$$.fragment,l),w(Z.$$.fragment,l),w(B.$$.fragment,l),w(g.$$.fragment,l),w(G.$$.fragment,l),w(W.$$.fragment,l),w(X.$$.fragment,l),w($.$$.fragment,l),w(Y.$$.fragment,l),w(S.$$.fragment,l),w(N.$$.fragment,l),Tl=!1},d(l){l&&(s(k),s(u),s(y),s(o),s(j),s(q),s(A),s(F),s(x),s(D),s(_),s(K),s(C),s(P),s(O),s(U),s(ll),s(el),s(f),s(sl),s(tl),s(R),s(al),s(v),s(nl),s(ol),s(Ml),s(H),s(pl),s(z),s(il),s(cl),s(V),s(rl),s(Jl),s(Q),s(ml),s(dl),s(wl),s(L)),s(M),T(h,l),T(I,l),T(Z,l),T(B,l),T(g,l),T(G,l),T(W,l),T(X,l),T($,l),T(Y,l),T(S,l),T(N,l)}}}const Nl='{"title":"Customizing model components","local":"customizing-model-components","sections":[{"title":"Attention class","local":"attention-class","sections":[],"depth":2},{"title":"LoRA","local":"lora","sections":[],"depth":2}],"depth":1}';function Ll(E){return vl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Pl extends Xl{constructor(M){super(),Hl(this,M,Ll,Sl,Rl,{})}}export{Pl as component};
