import{s as Ql,z as Kl,o as ed,n as J}from"../chunks/scheduler.18a86fab.js";import{S as td,i as od,g as i,s as r,r as h,A as nd,h as c,f as o,c as s,j as w,u as g,x as m,k as T,y as n,a as l,v as u,d as f,t as _,w as v}from"../chunks/index.98837b22.js";import{T as me}from"../chunks/Tip.77304350.js";import{D as C}from"../chunks/Docstring.6758ea23.js";import{C as Ue}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as Fe}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as $}from"../chunks/Heading.7e7e0c5b.js";import{E as rd}from"../chunks/getInferenceSnippets.de10bc7d.js";function sd(x){let a,y='Perceiver does <strong>not</strong> work with <code>torch.nn.DataParallel</code> due to a bug in PyTorch, see <a href="https://github.com/pytorch/pytorch/issues/36035" rel="nofollow">issue #36035</a>';return{c(){a=i("p"),a.innerHTML=y},l(p){a=c(p,"P",{"data-svelte-h":!0}),m(a)!=="svelte-1mrs8m2"&&(a.innerHTML=y)},m(p,b){l(p,a,b)},p:J,d(p){p&&o(a)}}}function ad(x){let a,y="Example:",p,b,M;return b=new Ue({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBlcmNlaXZlck1vZGVsJTJDJTIwUGVyY2VpdmVyQ29uZmlnJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMFBlcmNlaXZlciUyMGRlZXBtaW5kJTJGbGFuZ3VhZ2UtcGVyY2VpdmVyJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMFBlcmNlaXZlckNvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwZnJvbSUyMHRoZSUyMGRlZXBtaW5kJTJGbGFuZ3VhZ2UtcGVyY2VpdmVyJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBQZXJjZWl2ZXJNb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PerceiverModel, PerceiverConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Perceiver deepmind/language-perceiver style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = PerceiverConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the deepmind/language-perceiver style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){a=i("p"),a.textContent=y,p=r(),h(b.$$.fragment)},l(d){a=c(d,"P",{"data-svelte-h":!0}),m(a)!=="svelte-11lpom8"&&(a.textContent=y),p=s(d),g(b.$$.fragment,d)},m(d,P){l(d,a,P),l(d,p,P),u(b,d,P),M=!0},p:J,i(d){M||(f(b.$$.fragment,d),M=!0)},o(d){_(b.$$.fragment,d),M=!1},d(d){d&&(o(a),o(p)),v(b,d)}}}function id(x){let a,y=`Note that it’s possible to fine-tune Perceiver on higher resolution images than the ones it has been trained on, by
setting <code>interpolate_pos_encoding</code> to <code>True</code> in the forward of the model. This will interpolate the pre-trained
position embeddings to the higher resolution.`;return{c(){a=i("p"),a.innerHTML=y},l(p){a=c(p,"P",{"data-svelte-h":!0}),m(a)!=="svelte-uwdgm5"&&(a.innerHTML=y)},m(p,b){l(p,a,b)},p:J,d(p){p&&o(a)}}}function cd(x){let a,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){a=i("p"),a.innerHTML=y},l(p){a=c(p,"P",{"data-svelte-h":!0}),m(a)!=="svelte-fincs2"&&(a.innerHTML=y)},m(p,b){l(p,a,b)},p:J,d(p){p&&o(a)}}}function ld(x){let a,y="Examples:",p,b,M;return b=new Ue({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PerceiverConfig, PerceiverTokenizer, PerceiverImageProcessor, PerceiverModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers.models.perceiver.modeling_perceiver <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    PerceiverTextPreprocessor,
<span class="hljs-meta">... </span>    PerceiverImagePreprocessor,
<span class="hljs-meta">... </span>    PerceiverClassificationDecoder,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># EXAMPLE 1: using the Perceiver to classify texts</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># - we define a TextPreprocessor, which can be used to embed tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># - we define a ClassificationDecoder, which can be used to decode the</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># final hidden states of the latents to classification logits</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># using trainable position embeddings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = PerceiverConfig()
<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = PerceiverTextPreprocessor(config)
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder = PerceiverClassificationDecoder(
<span class="hljs-meta">... </span>    config,
<span class="hljs-meta">... </span>    num_channels=config.d_latents,
<span class="hljs-meta">... </span>    trainable_position_encoding_kwargs=<span class="hljs-built_in">dict</span>(num_channels=config.d_latents, index_dims=<span class="hljs-number">1</span>),
<span class="hljs-meta">... </span>    use_query_residual=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverModel(config, input_preprocessor=preprocessor, decoder=decoder)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># you can then do a forward pass as follows:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = PerceiverTokenizer()
<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;hello world&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(inputs=inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># to train, one can train the model using standard cross-entropy:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>criterion = torch.nn.CrossEntropyLoss()

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.tensor([<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = criterion(logits, labels)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># EXAMPLE 2: using the Perceiver to classify images</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># - we define an ImagePreprocessor, which can be used to embed images</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = PerceiverConfig(image_size=<span class="hljs-number">224</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = PerceiverImagePreprocessor(
<span class="hljs-meta">... </span>    config,
<span class="hljs-meta">... </span>    prep_type=<span class="hljs-string">&quot;conv1x1&quot;</span>,
<span class="hljs-meta">... </span>    spatial_downsample=<span class="hljs-number">1</span>,
<span class="hljs-meta">... </span>    out_channels=<span class="hljs-number">256</span>,
<span class="hljs-meta">... </span>    position_encoding_type=<span class="hljs-string">&quot;trainable&quot;</span>,
<span class="hljs-meta">... </span>    concat_or_add_pos=<span class="hljs-string">&quot;concat&quot;</span>,
<span class="hljs-meta">... </span>    project_pos_dim=<span class="hljs-number">256</span>,
<span class="hljs-meta">... </span>    trainable_position_encoding_kwargs=<span class="hljs-built_in">dict</span>(
<span class="hljs-meta">... </span>        num_channels=<span class="hljs-number">256</span>,
<span class="hljs-meta">... </span>        index_dims=config.image_size**<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    ),
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverModel(
<span class="hljs-meta">... </span>    config,
<span class="hljs-meta">... </span>    input_preprocessor=preprocessor,
<span class="hljs-meta">... </span>    decoder=PerceiverClassificationDecoder(
<span class="hljs-meta">... </span>        config,
<span class="hljs-meta">... </span>        num_channels=config.d_latents,
<span class="hljs-meta">... </span>        trainable_position_encoding_kwargs=<span class="hljs-built_in">dict</span>(num_channels=config.d_latents, index_dims=<span class="hljs-number">1</span>),
<span class="hljs-meta">... </span>        use_query_residual=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    ),
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># you can then do a forward pass as follows:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = PerceiverImageProcessor()
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(inputs=inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># to train, one can train the model using standard cross-entropy:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>criterion = torch.nn.CrossEntropyLoss()

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.tensor([<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = criterion(logits, labels)`,wrap:!1}}),{c(){a=i("p"),a.textContent=y,p=r(),h(b.$$.fragment)},l(d){a=c(d,"P",{"data-svelte-h":!0}),m(a)!=="svelte-kvfsh7"&&(a.textContent=y),p=s(d),g(b.$$.fragment,d)},m(d,P){l(d,a,P),l(d,p,P),u(b,d,P),M=!0},p:J,i(d){M||(f(b.$$.fragment,d),M=!0)},o(d){_(b.$$.fragment,d),M=!1},d(d){d&&(o(a),o(p)),v(b,d)}}}function dd(x){let a,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){a=i("p"),a.innerHTML=y},l(p){a=c(p,"P",{"data-svelte-h":!0}),m(a)!=="svelte-fincs2"&&(a.innerHTML=y)},m(p,b){l(p,a,b)},p:J,d(p){p&&o(a)}}}function md(x){let a,y="Examples:",p,b,M;return b=new Ue({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBQZXJjZWl2ZXJGb3JNYXNrZWRMTSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZGVlcG1pbmQlMkZsYW5ndWFnZS1wZXJjZWl2ZXIlMjIpJTBBbW9kZWwlMjAlM0QlMjBQZXJjZWl2ZXJGb3JNYXNrZWRMTS5mcm9tX3ByZXRyYWluZWQoJTIyZGVlcG1pbmQlMkZsYW5ndWFnZS1wZXJjZWl2ZXIlMjIpJTBBJTBBJTIzJTIwdHJhaW5pbmclMEF0ZXh0JTIwJTNEJTIwJTIyVGhpcyUyMGlzJTIwYW4lMjBpbmNvbXBsZXRlJTIwc2VudGVuY2UlMjB3aGVyZSUyMHNvbWUlMjB3b3JkcyUyMGFyZSUyMG1pc3NpbmcuJTIyJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHRleHQlMkMlMjBwYWRkaW5nJTNEJTIybWF4X2xlbmd0aCUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTIzJTIwbWFzayUyMCUyMiUyMG1pc3NpbmcuJTIyJTBBaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTVCMCUyQyUyMDUyJTNBNjElNUQlMjAlM0QlMjB0b2tlbml6ZXIubWFza190b2tlbl9pZCUwQWxhYmVscyUyMCUzRCUyMHRva2VuaXplcih0ZXh0JTJDJTIwcGFkZGluZyUzRCUyMm1heF9sZW5ndGglMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS5pbnB1dF9pZHMlMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMlMkMlMjBsYWJlbHMlM0RsYWJlbHMpJTBBbG9zcyUyMCUzRCUyMG91dHB1dHMubG9zcyUwQXJvdW5kKGxvc3MuaXRlbSgpJTJDJTIwMiklMEElMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQWxpc3QobG9naXRzLnNoYXBlKSUwQSUwQSUyMyUyMGluZmVyZW5jZSUwQXRleHQlMjAlM0QlMjAlMjJUaGlzJTIwaXMlMjBhbiUyMGluY29tcGxldGUlMjBzZW50ZW5jZSUyMHdoZXJlJTIwc29tZSUyMHdvcmRzJTIwYXJlJTIwbWlzc2luZy4lMjIlMEFlbmNvZGluZyUyMCUzRCUyMHRva2VuaXplcih0ZXh0JTJDJTIwcGFkZGluZyUzRCUyMm1heF9sZW5ndGglMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMG1hc2slMjBieXRlcyUyMGNvcnJlc3BvbmRpbmclMjB0byUyMCUyMiUyMG1pc3NpbmcuJTIyLiUyME5vdGUlMjB0aGF0JTIwdGhlJTIwbW9kZWwlMjBwZXJmb3JtcyUyMG11Y2glMjBiZXR0ZXIlMjBpZiUyMHRoZSUyMG1hc2tlZCUyMHNwYW4lMjBzdGFydHMlMjB3aXRoJTIwYSUyMHNwYWNlLiUwQWVuY29kaW5nJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTVCMCUyQyUyMDUyJTNBNjElNUQlMjAlM0QlMjB0b2tlbml6ZXIubWFza190b2tlbl9pZCUwQSUwQSUyMyUyMGZvcndhcmQlMjBwYXNzJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmVuY29kaW5nKSUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRzJTBBbGlzdChsb2dpdHMuc2hhcGUpJTBBJTBBbWFza2VkX3Rva2Vuc19wcmVkaWN0aW9ucyUyMCUzRCUyMGxvZ2l0cyU1QjAlMkMlMjA1MiUzQTYxJTVELmFyZ21heChkaW0lM0QtMSkudG9saXN0KCklMEF0b2tlbml6ZXIuZGVjb2RlKG1hc2tlZF90b2tlbnNfcHJlZGljdGlvbnMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, PerceiverForMaskedLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;deepmind/language-perceiver&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverForMaskedLM.from_pretrained(<span class="hljs-string">&quot;deepmind/language-perceiver&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># training</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;This is an incomplete sentence where some words are missing.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text, padding=<span class="hljs-string">&quot;max_length&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># mask &quot; missing.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs[<span class="hljs-string">&quot;input_ids&quot;</span>][<span class="hljs-number">0</span>, <span class="hljs-number">52</span>:<span class="hljs-number">61</span>] = tokenizer.mask_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = tokenizer(text, padding=<span class="hljs-string">&quot;max_length&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, labels=labels)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(loss.item(), <span class="hljs-number">2</span>)
<span class="hljs-number">19.87</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">2048</span>, <span class="hljs-number">262</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;This is an incomplete sentence where some words are missing.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = tokenizer(text, padding=<span class="hljs-string">&quot;max_length&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># mask bytes corresponding to &quot; missing.&quot;. Note that the model performs much better if the masked span starts with a space.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoding[<span class="hljs-string">&quot;input_ids&quot;</span>][<span class="hljs-number">0</span>, <span class="hljs-number">52</span>:<span class="hljs-number">61</span>] = tokenizer.mask_token_id

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**encoding)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">2048</span>, <span class="hljs-number">262</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>masked_tokens_predictions = logits[<span class="hljs-number">0</span>, <span class="hljs-number">52</span>:<span class="hljs-number">61</span>].argmax(dim=-<span class="hljs-number">1</span>).tolist()
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.decode(masked_tokens_predictions)
<span class="hljs-string">&#x27; missing.&#x27;</span>`,wrap:!1}}),{c(){a=i("p"),a.textContent=y,p=r(),h(b.$$.fragment)},l(d){a=c(d,"P",{"data-svelte-h":!0}),m(a)!=="svelte-kvfsh7"&&(a.textContent=y),p=s(d),g(b.$$.fragment,d)},m(d,P){l(d,a,P),l(d,p,P),u(b,d,P),M=!0},p:J,i(d){M||(f(b.$$.fragment,d),M=!0)},o(d){_(b.$$.fragment,d),M=!1},d(d){d&&(o(a),o(p)),v(b,d)}}}function pd(x){let a,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){a=i("p"),a.innerHTML=y},l(p){a=c(p,"P",{"data-svelte-h":!0}),m(a)!=="svelte-fincs2"&&(a.innerHTML=y)},m(p,b){l(p,a,b)},p:J,d(p){p&&o(a)}}}function hd(x){let a,y="Examples:",p,b,M;return b=new Ue({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBQZXJjZWl2ZXJGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZGVlcG1pbmQlMkZsYW5ndWFnZS1wZXJjZWl2ZXIlMjIpJTBBbW9kZWwlMjAlM0QlMjBQZXJjZWl2ZXJGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJkZWVwbWluZCUyRmxhbmd1YWdlLXBlcmNlaXZlciUyMiklMEElMEF0ZXh0JTIwJTNEJTIwJTIyaGVsbG8lMjB3b3JsZCUyMiUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcih0ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikuaW5wdXRfaWRzJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0cyUzRGlucHV0cyklMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQWxpc3QobG9naXRzLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, PerceiverForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;deepmind/language-perceiver&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;deepmind/language-perceiver&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;hello world&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs=inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>]`,wrap:!1}}),{c(){a=i("p"),a.textContent=y,p=r(),h(b.$$.fragment)},l(d){a=c(d,"P",{"data-svelte-h":!0}),m(a)!=="svelte-kvfsh7"&&(a.textContent=y),p=s(d),g(b.$$.fragment,d)},m(d,P){l(d,a,P),l(d,p,P),u(b,d,P),M=!0},p:J,i(d){M||(f(b.$$.fragment,d),M=!0)},o(d){_(b.$$.fragment,d),M=!1},d(d){d&&(o(a),o(p)),v(b,d)}}}function gd(x){let a,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){a=i("p"),a.innerHTML=y},l(p){a=c(p,"P",{"data-svelte-h":!0}),m(a)!=="svelte-fincs2"&&(a.innerHTML=y)},m(p,b){l(p,a,b)},p:J,d(p){p&&o(a)}}}function ud(x){let a,y="Examples:",p,b,M;return b=new Ue({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFBlcmNlaXZlckZvckltYWdlQ2xhc3NpZmljYXRpb25MZWFybmVkJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJkZWVwbWluZCUyRnZpc2lvbi1wZXJjZWl2ZXItbGVhcm5lZCUyMiklMEFtb2RlbCUyMCUzRCUyMFBlcmNlaXZlckZvckltYWdlQ2xhc3NpZmljYXRpb25MZWFybmVkLmZyb21fcHJldHJhaW5lZCglMjJkZWVwbWluZCUyRnZpc2lvbi1wZXJjZWl2ZXItbGVhcm5lZCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS5waXhlbF92YWx1ZXMlMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoaW5wdXRzJTNEaW5wdXRzKSUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRzJTBBbGlzdChsb2dpdHMuc2hhcGUpJTBBJTBBJTIzJTIwbW9kZWwlMjBwcmVkaWN0cyUyMG9uZSUyMG9mJTIwdGhlJTIwMTAwMCUyMEltYWdlTmV0JTIwY2xhc3NlcyUwQXByZWRpY3RlZF9jbGFzc19pZHglMjAlM0QlMjBsb2dpdHMuYXJnbWF4KC0xKS5pdGVtKCklMEFwcmludCglMjJQcmVkaWN0ZWQlMjBjbGFzcyUzQSUyMiUyQyUyMG1vZGVsLmNvbmZpZy5pZDJsYWJlbCU1QnByZWRpY3RlZF9jbGFzc19pZHglNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, PerceiverForImageClassificationLearned
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;deepmind/vision-perceiver-learned&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverForImageClassificationLearned.from_pretrained(<span class="hljs-string">&quot;deepmind/vision-perceiver-learned&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs=inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">1000</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_idx = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted class:&quot;</span>, model.config.id2label[predicted_class_idx])
Predicted <span class="hljs-keyword">class</span>: tabby, tabby cat`,wrap:!1}}),{c(){a=i("p"),a.textContent=y,p=r(),h(b.$$.fragment)},l(d){a=c(d,"P",{"data-svelte-h":!0}),m(a)!=="svelte-kvfsh7"&&(a.textContent=y),p=s(d),g(b.$$.fragment,d)},m(d,P){l(d,a,P),l(d,p,P),u(b,d,P),M=!0},p:J,i(d){M||(f(b.$$.fragment,d),M=!0)},o(d){_(b.$$.fragment,d),M=!1},d(d){d&&(o(a),o(p)),v(b,d)}}}function fd(x){let a,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){a=i("p"),a.innerHTML=y},l(p){a=c(p,"P",{"data-svelte-h":!0}),m(a)!=="svelte-fincs2"&&(a.innerHTML=y)},m(p,b){l(p,a,b)},p:J,d(p){p&&o(a)}}}function _d(x){let a,y="Examples:",p,b,M;return b=new Ue({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFBlcmNlaXZlckZvckltYWdlQ2xhc3NpZmljYXRpb25Gb3VyaWVyJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJkZWVwbWluZCUyRnZpc2lvbi1wZXJjZWl2ZXItZm91cmllciUyMiklMEFtb2RlbCUyMCUzRCUyMFBlcmNlaXZlckZvckltYWdlQ2xhc3NpZmljYXRpb25Gb3VyaWVyLmZyb21fcHJldHJhaW5lZCglMjJkZWVwbWluZCUyRnZpc2lvbi1wZXJjZWl2ZXItZm91cmllciUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS5waXhlbF92YWx1ZXMlMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoaW5wdXRzJTNEaW5wdXRzKSUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRzJTBBbGlzdChsb2dpdHMuc2hhcGUpJTBBJTBBJTIzJTIwbW9kZWwlMjBwcmVkaWN0cyUyMG9uZSUyMG9mJTIwdGhlJTIwMTAwMCUyMEltYWdlTmV0JTIwY2xhc3NlcyUwQXByZWRpY3RlZF9jbGFzc19pZHglMjAlM0QlMjBsb2dpdHMuYXJnbWF4KC0xKS5pdGVtKCklMEFwcmludCglMjJQcmVkaWN0ZWQlMjBjbGFzcyUzQSUyMiUyQyUyMG1vZGVsLmNvbmZpZy5pZDJsYWJlbCU1QnByZWRpY3RlZF9jbGFzc19pZHglNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, PerceiverForImageClassificationFourier
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;deepmind/vision-perceiver-fourier&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverForImageClassificationFourier.from_pretrained(<span class="hljs-string">&quot;deepmind/vision-perceiver-fourier&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs=inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">1000</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_idx = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted class:&quot;</span>, model.config.id2label[predicted_class_idx])
Predicted <span class="hljs-keyword">class</span>: tabby, tabby cat`,wrap:!1}}),{c(){a=i("p"),a.textContent=y,p=r(),h(b.$$.fragment)},l(d){a=c(d,"P",{"data-svelte-h":!0}),m(a)!=="svelte-kvfsh7"&&(a.textContent=y),p=s(d),g(b.$$.fragment,d)},m(d,P){l(d,a,P),l(d,p,P),u(b,d,P),M=!0},p:J,i(d){M||(f(b.$$.fragment,d),M=!0)},o(d){_(b.$$.fragment,d),M=!1},d(d){d&&(o(a),o(p)),v(b,d)}}}function vd(x){let a,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){a=i("p"),a.innerHTML=y},l(p){a=c(p,"P",{"data-svelte-h":!0}),m(a)!=="svelte-fincs2"&&(a.innerHTML=y)},m(p,b){l(p,a,b)},p:J,d(p){p&&o(a)}}}function bd(x){let a,y="Examples:",p,b,M;return b=new Ue({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFBlcmNlaXZlckZvckltYWdlQ2xhc3NpZmljYXRpb25Db252UHJvY2Vzc2luZyUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZGVlcG1pbmQlMkZ2aXNpb24tcGVyY2VpdmVyLWNvbnYlMjIpJTBBbW9kZWwlMjAlM0QlMjBQZXJjZWl2ZXJGb3JJbWFnZUNsYXNzaWZpY2F0aW9uQ29udlByb2Nlc3NpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMmRlZXBtaW5kJTJGdmlzaW9uLXBlcmNlaXZlci1jb252JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZXMlM0RpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnBpeGVsX3ZhbHVlcyUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbChpbnB1dHMlM0RpbnB1dHMpJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHMlMEFsaXN0KGxvZ2l0cy5zaGFwZSklMEElMEElMjMlMjBtb2RlbCUyMHByZWRpY3RzJTIwb25lJTIwb2YlMjB0aGUlMjAxMDAwJTIwSW1hZ2VOZXQlMjBjbGFzc2VzJTBBcHJlZGljdGVkX2NsYXNzX2lkeCUyMCUzRCUyMGxvZ2l0cy5hcmdtYXgoLTEpLml0ZW0oKSUwQXByaW50KCUyMlByZWRpY3RlZCUyMGNsYXNzJTNBJTIyJTJDJTIwbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCcHJlZGljdGVkX2NsYXNzX2lkeCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, PerceiverForImageClassificationConvProcessing
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;deepmind/vision-perceiver-conv&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverForImageClassificationConvProcessing.from_pretrained(<span class="hljs-string">&quot;deepmind/vision-perceiver-conv&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs=inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">1000</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_idx = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted class:&quot;</span>, model.config.id2label[predicted_class_idx])
Predicted <span class="hljs-keyword">class</span>: tabby, tabby cat`,wrap:!1}}),{c(){a=i("p"),a.textContent=y,p=r(),h(b.$$.fragment)},l(d){a=c(d,"P",{"data-svelte-h":!0}),m(a)!=="svelte-kvfsh7"&&(a.textContent=y),p=s(d),g(b.$$.fragment,d)},m(d,P){l(d,a,P),l(d,p,P),u(b,d,P),M=!0},p:J,i(d){M||(f(b.$$.fragment,d),M=!0)},o(d){_(b.$$.fragment,d),M=!1},d(d){d&&(o(a),o(p)),v(b,d)}}}function yd(x){let a,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){a=i("p"),a.innerHTML=y},l(p){a=c(p,"P",{"data-svelte-h":!0}),m(a)!=="svelte-fincs2"&&(a.innerHTML=y)},m(p,b){l(p,a,b)},p:J,d(p){p&&o(a)}}}function Md(x){let a,y="Examples:",p,b,M;return b=new Ue({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBlcmNlaXZlckZvck9wdGljYWxGbG93JTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbCUyMCUzRCUyMFBlcmNlaXZlckZvck9wdGljYWxGbG93LmZyb21fcHJldHJhaW5lZCglMjJkZWVwbWluZCUyRm9wdGljYWwtZmxvdy1wZXJjZWl2ZXIlMjIpJTBBJTBBJTIzJTIwaW4lMjB0aGUlMjBQZXJjZWl2ZXIlMjBJTyUyMHBhcGVyJTJDJTIwdGhlJTIwYXV0aG9ycyUyMGV4dHJhY3QlMjBhJTIwMyUyMHglMjAzJTIwcGF0Y2glMjBhcm91bmQlMjBlYWNoJTIwcGl4ZWwlMkMlMEElMjMlMjBsZWFkaW5nJTIwdG8lMjAzJTIweCUyMDMlMjB4JTIwMyUyMCUzRCUyMDI3JTIwdmFsdWVzJTIwZm9yJTIwZWFjaCUyMHBpeGVsJTIwKGFzJTIwZWFjaCUyMHBpeGVsJTIwYWxzbyUyMGhhcyUyMDMlMjBjb2xvciUyMGNoYW5uZWxzKSUwQSUyMyUyMHBhdGNoZXMlMjBoYXZlJTIwc2hhcGUlMjAoYmF0Y2hfc2l6ZSUyQyUyMG51bV9mcmFtZXMlMkMlMjBudW1fY2hhbm5lbHMlMkMlMjBoZWlnaHQlMkMlMjB3aWR0aCklMEElMjMlMjB0aGUlMjBhdXRob3JzJTIwdHJhaW4lMjBvbiUyMHJlc29sdXRpb25zJTIwb2YlMjAzNjglMjB4JTIwNDk2JTBBcGF0Y2hlcyUyMCUzRCUyMHRvcmNoLnJhbmRuKDElMkMlMjAyJTJDJTIwMjclMkMlMjAzNjglMkMlMjA0OTYpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0cyUzRHBhdGNoZXMpJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHMlMEFsaXN0KGxvZ2l0cy5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PerceiverForOpticalFlow
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverForOpticalFlow.from_pretrained(<span class="hljs-string">&quot;deepmind/optical-flow-perceiver&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># in the Perceiver IO paper, the authors extract a 3 x 3 patch around each pixel,</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># leading to 3 x 3 x 3 = 27 values for each pixel (as each pixel also has 3 color channels)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># patches have shape (batch_size, num_frames, num_channels, height, width)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># the authors train on resolutions of 368 x 496</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>patches = torch.randn(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">27</span>, <span class="hljs-number">368</span>, <span class="hljs-number">496</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs=patches)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">368</span>, <span class="hljs-number">496</span>, <span class="hljs-number">2</span>]`,wrap:!1}}),{c(){a=i("p"),a.textContent=y,p=r(),h(b.$$.fragment)},l(d){a=c(d,"P",{"data-svelte-h":!0}),m(a)!=="svelte-kvfsh7"&&(a.textContent=y),p=s(d),g(b.$$.fragment,d)},m(d,P){l(d,a,P),l(d,p,P),u(b,d,P),M=!0},p:J,i(d){M||(f(b.$$.fragment,d),M=!0)},o(d){_(b.$$.fragment,d),M=!1},d(d){d&&(o(a),o(p)),v(b,d)}}}function Td(x){let a,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){a=i("p"),a.innerHTML=y},l(p){a=c(p,"P",{"data-svelte-h":!0}),m(a)!=="svelte-fincs2"&&(a.innerHTML=y)},m(p,b){l(p,a,b)},p:J,d(p){p&&o(a)}}}function wd(x){let a,y="Examples:",p,b,M;return b=new Ue({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PerceiverForMultimodalAutoencoding
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># create multimodal inputs</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>images = torch.randn((<span class="hljs-number">1</span>, <span class="hljs-number">16</span>, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>audio = torch.randn((<span class="hljs-number">1</span>, <span class="hljs-number">30720</span>, <span class="hljs-number">1</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = <span class="hljs-built_in">dict</span>(image=images, audio=audio, label=torch.zeros((images.shape[<span class="hljs-number">0</span>], <span class="hljs-number">700</span>)))

<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverForMultimodalAutoencoding.from_pretrained(<span class="hljs-string">&quot;deepmind/multimodal-perceiver&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># in the Perceiver IO paper, videos are auto-encoded in chunks</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># each chunk subsamples different index dimensions of the image and audio modality decoder queries</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>nchunks = <span class="hljs-number">128</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_chunk_size = np.prod((<span class="hljs-number">16</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>)) // nchunks
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_chunk_size = audio.shape[<span class="hljs-number">1</span>] // model.config.samples_per_patch // nchunks
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># process the first chunk</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>chunk_idx = <span class="hljs-number">0</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>subsampling = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;image&quot;</span>: torch.arange(image_chunk_size * chunk_idx, image_chunk_size * (chunk_idx + <span class="hljs-number">1</span>)),
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;audio&quot;</span>: torch.arange(audio_chunk_size * chunk_idx, audio_chunk_size * (chunk_idx + <span class="hljs-number">1</span>)),
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-literal">None</span>,
<span class="hljs-meta">... </span>}

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs=inputs, subsampled_output_points=subsampling)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits[<span class="hljs-string">&quot;audio&quot;</span>].shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">240</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits[<span class="hljs-string">&quot;image&quot;</span>].shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">6272</span>, <span class="hljs-number">3</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits[<span class="hljs-string">&quot;label&quot;</span>].shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">700</span>]`,wrap:!1}}),{c(){a=i("p"),a.textContent=y,p=r(),h(b.$$.fragment)},l(d){a=c(d,"P",{"data-svelte-h":!0}),m(a)!=="svelte-kvfsh7"&&(a.textContent=y),p=s(d),g(b.$$.fragment,d)},m(d,P){l(d,a,P),l(d,p,P),u(b,d,P),M=!0},p:J,i(d){M||(f(b.$$.fragment,d),M=!0)},o(d){_(b.$$.fragment,d),M=!1},d(d){d&&(o(a),o(p)),v(b,d)}}}function Pd(x){let a,y,p,b,M,d,P,hc='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',Jr,dt,zr,mt,gc=`The Perceiver IO model was proposed in <a href="https://arxiv.org/abs/2107.14795" rel="nofollow">Perceiver IO: A General Architecture for Structured Inputs &amp;
Outputs</a> by Andrew Jaegle, Sebastian Borgeaud, Jean-Baptiste Alayrac, Carl Doersch,
Catalin Ionescu, David Ding, Skanda Koppula, Daniel Zoran, Andrew Brock, Evan Shelhamer, Olivier Hénaff, Matthew M.
Botvinick, Andrew Zisserman, Oriol Vinyals, João Carreira.`,Zr,pt,uc=`Perceiver IO is a generalization of <a href="https://arxiv.org/abs/2103.03206" rel="nofollow">Perceiver</a> to handle arbitrary outputs in
addition to arbitrary inputs. The original Perceiver only produced a single classification label. In addition to
classification labels, Perceiver IO can produce (for example) language, optical flow, and multimodal videos with audio.
This is done using the same building blocks as the original Perceiver. The computational complexity of Perceiver IO is
linear in the input and output size and the bulk of the processing occurs in the latent space, allowing us to process
inputs and outputs that are much larger than can be handled by standard Transformers. This means, for example,
Perceiver IO can do BERT-style masked language modeling directly using bytes instead of tokenized inputs.`,Nr,ht,fc="The abstract from the paper is the following:",Wr,gt,_c=`<em>The recently-proposed Perceiver model obtains good results on several domains (images, audio, multimodal, point
clouds) while scaling linearly in compute and memory with the input size. While the Perceiver supports many kinds of
inputs, it can only produce very simple outputs such as class scores. Perceiver IO overcomes this limitation without
sacrificing the original’s appealing properties by learning to flexibly query the model’s latent space to produce
outputs of arbitrary size and semantics. Perceiver IO still decouples model depth from data size and still scales
linearly with data size, but now with respect to both input and output sizes. The full Perceiver IO model achieves
strong results on tasks with highly structured output spaces, such as natural language and visual understanding,
StarCraft II, and multi-task and multi-modal domains. As highlights, Perceiver IO matches a Transformer-based BERT
baseline on the GLUE language benchmark without the need for input tokenization and achieves state-of-the-art
performance on Sintel optical flow estimation.</em>`,qr,ut,vc="Here’s a TLDR explaining how Perceiver works:",Br,ft,bc=`The main problem with the self-attention mechanism of the Transformer is that the time and memory requirements scale
quadratically with the sequence length. Hence, models like BERT and RoBERTa are limited to a max sequence length of 512
tokens. Perceiver aims to solve this issue by, instead of performing self-attention on the inputs, perform it on a set
of latent variables, and only use the inputs for cross-attention. In this way, the time and memory requirements don’t
depend on the length of the inputs anymore, as one uses a fixed amount of latent variables, like 256 or 512. These are
randomly initialized, after which they are trained end-to-end using backpropagation.`,Dr,_t,yc=`Internally, <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverModel">PerceiverModel</a> will create the latents, which is a tensor of shape <code>(batch_size, num_latents, d_latents)</code>. One must provide <code>inputs</code> (which could be text, images, audio, you name it!) to the model, which it will
use to perform cross-attention with the latents. The output of the Perceiver encoder is a tensor of the same shape. One
can then, similar to BERT, convert the last hidden states of the latents to classification logits by averaging along
the sequence dimension, and placing a linear layer on top of that to project the <code>d_latents</code> to <code>num_labels</code>.`,Rr,vt,Mc=`This was the idea of the original Perceiver paper. However, it could only output classification logits. In a follow-up
work, PerceiverIO, they generalized it to let the model also produce outputs of arbitrary size. How, you might ask? The
idea is actually relatively simple: one defines outputs of an arbitrary size, and then applies cross-attention with the
last hidden states of the latents, using the outputs as queries, and the latents as keys and values.`,Lr,bt,Tc=`So let’s say one wants to perform masked language modeling (BERT-style) with the Perceiver. As the Perceiver’s input
length will not have an impact on the computation time of the self-attention layers, one can provide raw bytes,
providing <code>inputs</code> of length 2048 to the model. If one now masks out certain of these 2048 tokens, one can define the
<code>outputs</code> as being of shape: <code>(batch_size, 2048, 768)</code>. Next, one performs cross-attention with the final hidden states
of the latents to update the <code>outputs</code> tensor. After cross-attention, one still has a tensor of shape <code>(batch_size, 2048, 768)</code>. One can then place a regular language modeling head on top, to project the last dimension to the
vocabulary size of the model, i.e. creating logits of shape <code>(batch_size, 2048, 262)</code> (as Perceiver uses a vocabulary
size of 262 byte IDs).`,Gr,Je,wc,Vr,yt,Pc='Perceiver IO architecture. Taken from the <a href="https://arxiv.org/abs/2105.15203">original paper</a>',Hr,Mt,Cc=`This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>. The original code can be found
<a href="https://github.com/deepmind/deepmind-research/tree/master/perceiver" rel="nofollow">here</a>.`,Er,ze,Sr,Tt,Xr,wt,xc=`<li>The quickest way to get started with the Perceiver is by checking the <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/Perceiver" rel="nofollow">tutorial
notebooks</a>.</li> <li>Refer to the <a href="https://huggingface.co/blog/perceiver" rel="nofollow">blog post</a> if you want to fully understand how the model works and
is implemented in the library. Note that the models available in the library only showcase some examples of what you can do
with the Perceiver. There are many more use cases, including question answering, named-entity recognition, object detection,
audio classification, video classification, etc.</li> <li><a href="../tasks/sequence_classification">Text classification task guide</a></li> <li><a href="../tasks/masked_language_modeling">Masked language modeling task guide</a></li> <li><a href="../tasks/image_classification">Image classification task guide</a></li>`,Ar,Pt,Or,pe,Ct,pa,on,$c="Base class for Perceiver base model’s outputs, with potential hidden states, attentions and cross-attentions.",Yr,he,xt,ha,nn,kc="Base class for Perceiver decoder outputs, with potential cross-attentions.",Qr,ge,$t,ga,rn,jc="Base class for Perceiver’s masked language model outputs.",Kr,ue,kt,ua,sn,Ic=`Base class for Perceiver’s outputs of sequence/image classification models, optical flow and multimodal
autoencoding.`,es,jt,ts,L,It,fa,an,Fc=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverModel">PerceiverModel</a>. It is used to instantiate an
Perceiver model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the Perceiver
<a href="https://huggingface.co/deepmind/language-perceiver" rel="nofollow">deepmind/language-perceiver</a> architecture.`,_a,cn,Uc=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,va,Ze,os,Ft,ns,G,Ut,ba,ln,Jc="Construct a Perceiver tokenizer. The Perceiver simply uses raw bytes utf-8 encoding.",ya,dn,zc=`This tokenizer inherits from <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a> which contains most of the main methods. Users should refer to
this superclass for more information regarding those methods.`,Ma,Ne,Jt,Ta,mn,Zc=`Main method to tokenize and prepare for the model one or several sequence(s) or one or several pair(s) of
sequences.`,rs,zt,ss,fe,Zt,wa,We,Nt,Pa,pn,Nc="Preprocess an image or a batch of images.",as,Wt,is,te,qt,Ca,hn,Wc="Constructs a Perceiver image processor.",xa,qe,Bt,$a,gn,qc="Preprocess an image or batch of images.",cs,Dt,ls,N,Rt,ka,un,Bc="Constructs a fast Perceiver image processor.",ja,fn,Dc=`data_format (<code>~image_utils.ChannelDimension</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>):
Only <code>ChannelDimension.FIRST</code> is supported. Added for compatibility with slow processors.
input_data_format (<code>Union[~image_utils.ChannelDimension, str, NoneType]</code>, defaults to <code>None</code>):
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:`,Ia,_n,Rc=`<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li> <li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li> <li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.
device (<code>torch.device</code>, <em>optional</em>, defaults to <code>None</code>):
The device to process the images on. If unset, the device is inferred from the input images.</li>`,Fa,vn,Lt,ds,Gt,ms,oe,Vt,Ua,bn,Lc="Text preprocessing for Perceiver Encoder. Can be used to embed <code>inputs</code> and add positional encodings.",Ja,yn,Gc="The dimensionality of the embeddings is determined by the <code>d_model</code> attribute of the configuration.",ps,Ht,hs,ne,Et,za,Mn,Vc="Image preprocessing for Perceiver Encoder.",Za,Tn,Hc=`Note: the <em>out_channels</em> argument refers to the output channels of a convolutional layer, if <em>prep_type</em> is set to
“conv1x1” or “conv”. If one adds absolute position embeddings, one must make sure the <em>num_channels</em> of the
position encoding kwargs are set equal to the <em>out_channels</em>.`,gs,St,us,_e,Xt,Na,wn,Ec="One-hot preprocessor for Perceiver Encoder. Can be used to add a dummy index dimension to the input.",fs,At,_s,ve,Ot,Wa,Pn,Sc="Audio preprocessing for Perceiver Encoder.",vs,Yt,bs,re,Qt,qa,Cn,Xc="Multimodal preprocessing for Perceiver Encoder.",Ba,xn,Ac=`Inputs for each modality are preprocessed, then padded with trainable position embeddings to have the same number
of channels.`,ys,Kt,Ms,be,eo,Da,$n,Oc="Baseline projection decoder (no cross-attention).",Ts,to,ws,se,oo,Ra,kn,Yc=`Cross-attention-based decoder. This class can be used to decode the final hidden states of the latents using a
cross-attention operation, in which the latents produce keys and values.`,La,jn,Qc="The shape of the output of this class depends on how one defines the output queries (also called decoder queries).",Ps,no,Cs,ye,ro,Ga,In,Kc=`Cross-attention based classification decoder. Light-weight wrapper of <code>PerceiverBasicDecoder</code> for logit output.
Will turn the output of the Perceiver encoder which is of shape (batch_size, num_latents, d_latents) to a tensor of
shape (batch_size, num_labels). The queries are of shape (batch_size, 1, num_labels).`,xs,so,$s,Me,ao,Va,Fn,el="Cross-attention based optical flow decoder.",ks,io,js,Te,co,Ha,Un,tl=`Cross-attention based video-autoencoding decoder. Light-weight wrapper of [<em>PerceiverBasicDecoder</em>] with video
reshaping logic.`,Is,lo,Fs,ae,mo,Ea,Jn,ol=`Multimodal decoding by composing uni-modal decoders. The <em>modalities</em> argument of the constructor is a dictionary
mapping modality name to the decoder of that modality. That decoder will be used to construct queries for that
modality. Modality-specific queries are padded with trainable modality-specific parameters, after which they are
concatenated along the time dimension.`,Sa,zn,nl="Next, there is a shared cross attention operation across all modalities.",Us,po,Js,we,ho,Xa,Zn,rl=`Projection postprocessing for Perceiver. Can be used to project the channels of the decoder output to a lower
dimension.`,zs,go,Zs,Pe,uo,Aa,Nn,sl="Audio postprocessing for Perceiver. Can be used to convert the decoder output to audio features.",Ns,fo,Ws,Ce,_o,Oa,Wn,al="Classification postprocessing for Perceiver. Can be used to convert the decoder output to classification logits.",qs,vo,Bs,xe,bo,Ya,qn,il=`Multimodal postprocessing for Perceiver. Can be used to combine modality-specific postprocessors into a single
postprocessor.`,Ds,yo,Rs,z,Mo,Qa,Bn,cl="The Perceiver: a scalable, fully attentional architecture.",Ka,Be,ei,Dn,ll=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,ti,Rn,dl=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,oi,H,To,ni,Ln,ml='The <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverModel">PerceiverModel</a> forward method, overrides the <code>__call__</code> special method.',ri,De,si,Re,Ls,wo,Gs,W,Po,ai,Gn,pl="Example use of Perceiver for masked language modeling.",ii,Vn,hl=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,ci,Hn,gl=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,li,E,Co,di,En,ul='The <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverForMaskedLM">PerceiverForMaskedLM</a> forward method, overrides the <code>__call__</code> special method.',mi,Le,pi,Ge,Vs,xo,Hs,q,$o,hi,Sn,fl="Example use of Perceiver for text classification.",gi,Xn,_l=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,ui,An,vl=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,fi,S,ko,_i,On,bl='The <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverForSequenceClassification">PerceiverForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',vi,Ve,bi,He,Es,jo,Ss,I,Io,yi,Yn,yl="Example use of Perceiver for image classification, for tasks such as ImageNet.",Mi,Qn,Ml=`This model uses learned position embeddings. In other words, this model is not given any privileged information about
the structure of images. As shown in the paper, this model can achieve a top-1 accuracy of 72.7 on ImageNet.`,Ti,Kn,Tl=`<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverForImageClassificationLearned">PerceiverForImageClassificationLearned</a> uses <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor">PerceiverImagePreprocessor</a>
(with <code>prep_type=&quot;conv1x1&quot;</code>) to preprocess the input images, and
<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder">PerceiverClassificationDecoder</a> to decode the latent representation of
<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverModel">PerceiverModel</a> into classification logits.`,wi,er,wl=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Pi,tr,Pl=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Ci,X,Fo,xi,or,Cl='The <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverForImageClassificationLearned">PerceiverForImageClassificationLearned</a> forward method, overrides the <code>__call__</code> special method.',$i,Ee,ki,Se,Xs,Uo,As,F,Jo,ji,nr,xl="Example use of Perceiver for image classification, for tasks such as ImageNet.",Ii,rr,$l=`This model uses fixed 2D Fourier position embeddings. As shown in the paper, this model can achieve a top-1 accuracy of
79.0 on ImageNet, and 84.5 when pre-trained on a large-scale dataset (i.e. JFT).`,Fi,sr,kl=`<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverForImageClassificationLearned">PerceiverForImageClassificationLearned</a> uses <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor">PerceiverImagePreprocessor</a>
(with <code>prep_type=&quot;pixels&quot;</code>) to preprocess the input images, and
<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder">PerceiverClassificationDecoder</a> to decode the latent representation of
<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverModel">PerceiverModel</a> into classification logits.`,Ui,ar,jl=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Ji,ir,Il=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,zi,A,zo,Zi,cr,Fl='The <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverForImageClassificationFourier">PerceiverForImageClassificationFourier</a> forward method, overrides the <code>__call__</code> special method.',Ni,Xe,Wi,Ae,Os,Zo,Ys,U,No,qi,lr,Ul="Example use of Perceiver for image classification, for tasks such as ImageNet.",Bi,dr,Jl=`This model uses a 2D conv+maxpool preprocessing network. As shown in the paper, this model can achieve a top-1 accuracy
of 82.1 on ImageNet.`,Di,mr,zl=`<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverForImageClassificationLearned">PerceiverForImageClassificationLearned</a> uses <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor">PerceiverImagePreprocessor</a>
(with <code>prep_type=&quot;conv&quot;</code>) to preprocess the input images, and
<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder">PerceiverClassificationDecoder</a> to decode the latent representation of
<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverModel">PerceiverModel</a> into classification logits.`,Ri,pr,Zl=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Li,hr,Nl=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Gi,O,Wo,Vi,gr,Wl='The <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverForImageClassificationConvProcessing">PerceiverForImageClassificationConvProcessing</a> forward method, overrides the <code>__call__</code> special method.',Hi,Oe,Ei,Ye,Qs,qo,Ks,Z,Bo,Si,ur,ql=`Example use of Perceiver for optical flow, for tasks such as Sintel and KITTI. <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverForOpticalFlow">PerceiverForOpticalFlow</a> uses
<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor">PerceiverImagePreprocessor</a> (with <em>prep_type=“patches”</em>) to preprocess the
input images, and <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverOpticalFlowDecoder">PerceiverOpticalFlowDecoder</a> to decode the latent
representation of <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverModel">PerceiverModel</a>.`,Xi,fr,Bl=`As input, one concatenates 2 subsequent frames along the channel dimension and extract a 3 x 3 patch around each pixel
(leading to 3 x 3 x 3 x 2 = 54 values for each pixel). Fixed Fourier position encodings are used to encode the position
of each pixel in the patch. Next, one applies the Perceiver encoder. To decode, one queries the latent representation
using the same encoding used for the input.`,Ai,_r,Dl=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Oi,vr,Rl=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Yi,Y,Do,Qi,br,Ll='The <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverForOpticalFlow">PerceiverForOpticalFlow</a> forward method, overrides the <code>__call__</code> special method.',Ki,Qe,ec,Ke,ea,Ro,ta,k,Lo,tc,yr,Gl="Example use of Perceiver for multimodal (video) autoencoding, for tasks such as Kinetics-700.",oc,Mr,Vl=`<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverForMultimodalAutoencoding">PerceiverForMultimodalAutoencoding</a> uses <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor">PerceiverMultimodalPreprocessor</a> to
preprocess the 3 modalities: images, audio and class labels. This preprocessor uses modality-specific preprocessors to
preprocess every modality separately, after which they are concatenated. Trainable position embeddings are used to pad
each modality to the same number of channels to make concatenation along the time dimension possible. Next, one applies
the Perceiver encoder.`,nc,Tr,Hl=`<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder">PerceiverMultimodalDecoder</a> is used to decode the latent representation of
<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverModel">PerceiverModel</a>. This decoder uses each modality-specific decoder to construct queries. The decoder queries are
created based on the inputs after preprocessing. However, autoencoding an entire video in a single forward pass is
computationally infeasible, hence one only uses parts of the decoder queries to do cross-attention with the latent
representation. This is determined by the subsampled indices for each modality, which can be provided as additional
input to the forward pass of <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverForMultimodalAutoencoding">PerceiverForMultimodalAutoencoding</a>.`,rc,wr,El=`<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder">PerceiverMultimodalDecoder</a> also pads the decoder queries of the different
modalities to the same number of channels, in order to concatenate them along the time dimension. Next, cross-attention
is performed with the latent representation of <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverModel">PerceiverModel</a>.`,sc,Pr,Sl=`Finally, <code>~models.perceiver.modeling_perceiver.PerceiverMultiModalPostprocessor</code> is used to turn this tensor into an
actual video. It first splits up the output into the different modalities, and then applies the respective
postprocessor for each modality.`,ac,Cr,Xl=`Note that, by masking the classification label during evaluation (i.e. simply providing a tensor of zeros for the
“label” modality), this auto-encoding model becomes a Kinetics 700 video classifier.`,ic,xr,Al=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,cc,$r,Ol=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,lc,Q,Go,dc,kr,Yl='The <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverForMultimodalAutoencoding">PerceiverForMultimodalAutoencoding</a> forward method, overrides the <code>__call__</code> special method.',mc,et,pc,tt,oa,Vo,na,Fr,ra;return M=new $({props:{title:"Perceiver",local:"perceiver",headingTag:"h1"}}),dt=new $({props:{title:"Overview",local:"overview",headingTag:"h2"}}),ze=new me({props:{warning:!0,$$slots:{default:[sd]},$$scope:{ctx:x}}}),Tt=new $({props:{title:"Resources",local:"resources",headingTag:"h2"}}),Pt=new $({props:{title:"Perceiver specific outputs",local:"transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput",headingTag:"h2"}}),Ct=new C({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput",parameters:[{name:"logits",val:": typing.Optional[torch.FloatTensor] = None"},{name:"last_hidden_state",val:": typing.Optional[torch.FloatTensor] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_labels)</code>) &#x2014;
Classification (or regression if config.num_labels==1) scores (before SoftMax).`,name:"logits"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.`,name:"last_hidden_state"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.`,name:"attentions"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.`,name:"cross_attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L47"}}),xt=new C({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverDecoderOutput",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverDecoderOutput",parameters:[{name:"logits",val:": typing.Optional[torch.FloatTensor] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverDecoderOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_labels)</code>) &#x2014;
Output of the basic decoder.`,name:"logits"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.`,name:"cross_attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L78"}}),$t=new C({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"logits",val:": typing.Optional[torch.FloatTensor] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Masked language modeling (MLM) loss.`,name:"loss"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) &#x2014;
Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).`,name:"logits"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, num_latents, num_latents)</code>. Attentions weights after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"attentions"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.`,name:"cross_attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L96"}}),kt=new C({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"logits",val:": typing.Optional[torch.FloatTensor] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Classification (or regression if config.num_labels==1) loss.`,name:"loss"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) &#x2014;
Classification (or regression if config.num_labels==1) scores (before SoftMax).`,name:"logits"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.`,name:"attentions"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.`,name:"cross_attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L127"}}),jt=new $({props:{title:"PerceiverConfig",local:"transformers.PerceiverConfig",headingTag:"h2"}}),It=new C({props:{name:"class transformers.PerceiverConfig",anchor:"transformers.PerceiverConfig",parameters:[{name:"num_latents",val:" = 256"},{name:"d_latents",val:" = 1280"},{name:"d_model",val:" = 768"},{name:"num_blocks",val:" = 1"},{name:"num_self_attends_per_block",val:" = 26"},{name:"num_self_attention_heads",val:" = 8"},{name:"num_cross_attention_heads",val:" = 8"},{name:"qk_channels",val:" = None"},{name:"v_channels",val:" = None"},{name:"cross_attention_shape_for_attention",val:" = 'kv'"},{name:"self_attention_widening_factor",val:" = 1"},{name:"cross_attention_widening_factor",val:" = 1"},{name:"hidden_act",val:" = 'gelu'"},{name:"attention_probs_dropout_prob",val:" = 0.1"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-12"},{name:"use_query_residual",val:" = True"},{name:"vocab_size",val:" = 262"},{name:"max_position_embeddings",val:" = 2048"},{name:"image_size",val:" = 56"},{name:"train_size",val:" = [368, 496]"},{name:"num_frames",val:" = 16"},{name:"audio_samples_per_frame",val:" = 1920"},{name:"samples_per_patch",val:" = 16"},{name:"output_shape",val:" = [1, 16, 224, 224]"},{name:"output_num_channels",val:" = 512"},{name:"_label_trainable_num_channels",val:" = 1024"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PerceiverConfig.num_latents",description:`<strong>num_latents</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
The number of latents.`,name:"num_latents"},{anchor:"transformers.PerceiverConfig.d_latents",description:`<strong>d_latents</strong> (<code>int</code>, <em>optional</em>, defaults to 1280) &#x2014;
Dimension of the latent embeddings.`,name:"d_latents"},{anchor:"transformers.PerceiverConfig.d_model",description:`<strong>d_model</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimension of the inputs. Should only be provided in case [<em>PerceiverTextPreprocessor</em>] is used or no
preprocessor is provided.`,name:"d_model"},{anchor:"transformers.PerceiverConfig.num_blocks",description:`<strong>num_blocks</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of blocks in the Transformer encoder.`,name:"num_blocks"},{anchor:"transformers.PerceiverConfig.num_self_attends_per_block",description:`<strong>num_self_attends_per_block</strong> (<code>int</code>, <em>optional</em>, defaults to 26) &#x2014;
The number of self-attention layers per block.`,name:"num_self_attends_per_block"},{anchor:"transformers.PerceiverConfig.num_self_attention_heads",description:`<strong>num_self_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each self-attention layer in the Transformer encoder.`,name:"num_self_attention_heads"},{anchor:"transformers.PerceiverConfig.num_cross_attention_heads",description:`<strong>num_cross_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each cross-attention layer in the Transformer encoder.`,name:"num_cross_attention_heads"},{anchor:"transformers.PerceiverConfig.qk_channels",description:`<strong>qk_channels</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Dimension to project the queries + keys before applying attention in the cross-attention and self-attention
layers of the encoder. Will default to preserving the dimension of the queries if not specified.`,name:"qk_channels"},{anchor:"transformers.PerceiverConfig.v_channels",description:`<strong>v_channels</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Dimension to project the values before applying attention in the cross-attention and self-attention layers
of the encoder. Will default to preserving the dimension of the queries if not specified.`,name:"v_channels"},{anchor:"transformers.PerceiverConfig.cross_attention_shape_for_attention",description:`<strong>cross_attention_shape_for_attention</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;kv&quot;</code>) &#x2014;
Dimension to use when downsampling the queries and keys in the cross-attention layer of the encoder.`,name:"cross_attention_shape_for_attention"},{anchor:"transformers.PerceiverConfig.self_attention_widening_factor",description:`<strong>self_attention_widening_factor</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Dimension of the feed-forward layer in the cross-attention layer of the Transformer encoder.`,name:"self_attention_widening_factor"},{anchor:"transformers.PerceiverConfig.cross_attention_widening_factor",description:`<strong>cross_attention_widening_factor</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Dimension of the feed-forward layer in the self-attention layers of the Transformer encoder.`,name:"cross_attention_widening_factor"},{anchor:"transformers.PerceiverConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.PerceiverConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.PerceiverConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.PerceiverConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-12) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.PerceiverConfig.use_query_residual",description:`<strong>use_query_residual</strong> (<code>float</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to add a query residual in the cross-attention layer of the encoder.`,name:"use_query_residual"},{anchor:"transformers.PerceiverConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 262) &#x2014;
Vocabulary size for the masked language modeling model.`,name:"vocab_size"},{anchor:"transformers.PerceiverConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
The maximum sequence length that the masked language modeling model might ever be used with. Typically set
this to something large just in case (e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.PerceiverConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 56) &#x2014;
Size of the images after preprocessing, for <a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverForImageClassificationLearned">PerceiverForImageClassificationLearned</a>.`,name:"image_size"},{anchor:"transformers.PerceiverConfig.train_size",description:`<strong>train_size</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[368, 496]</code>) &#x2014;
Training size of the images for the optical flow model.`,name:"train_size"},{anchor:"transformers.PerceiverConfig.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of video frames used for the multimodal autoencoding model.`,name:"num_frames"},{anchor:"transformers.PerceiverConfig.audio_samples_per_frame",description:`<strong>audio_samples_per_frame</strong> (<code>int</code>, <em>optional</em>, defaults to 1920) &#x2014;
Number of audio samples per frame for the multimodal autoencoding model.`,name:"audio_samples_per_frame"},{anchor:"transformers.PerceiverConfig.samples_per_patch",description:`<strong>samples_per_patch</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of audio samples per patch when preprocessing the audio for the multimodal autoencoding model.`,name:"samples_per_patch"},{anchor:"transformers.PerceiverConfig.output_shape",description:`<strong>output_shape</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[1, 16, 224, 224]</code>) &#x2014;
Shape of the output (batch_size, num_frames, height, width) for the video decoder queries of the multimodal
autoencoding model. This excludes the channel dimension.`,name:"output_shape"},{anchor:"transformers.PerceiverConfig.output_num_channels",description:`<strong>output_num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Number of output channels for each modalitiy decoder.`,name:"output_num_channels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/configuration_perceiver.py#L32"}}),Ze=new Fe({props:{anchor:"transformers.PerceiverConfig.example",$$slots:{default:[ad]},$$scope:{ctx:x}}}),Ft=new $({props:{title:"PerceiverTokenizer",local:"transformers.PerceiverTokenizer",headingTag:"h2"}}),Ut=new C({props:{name:"class transformers.PerceiverTokenizer",anchor:"transformers.PerceiverTokenizer",parameters:[{name:"pad_token",val:" = '[PAD]'"},{name:"bos_token",val:" = '[BOS]'"},{name:"eos_token",val:" = '[EOS]'"},{name:"mask_token",val:" = '[MASK]'"},{name:"cls_token",val:" = '[CLS]'"},{name:"sep_token",val:" = '[SEP]'"},{name:"model_max_length",val:" = 2048"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PerceiverTokenizer.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[PAD]&quot;</code>) &#x2014;
The token used for padding, for example when batching sequences of different lengths.`,name:"pad_token"},{anchor:"transformers.PerceiverTokenizer.bos_token",description:`<strong>bos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[BOS]&quot;</code>) &#x2014;
The BOS token (reserved in the vocab, but not actually used).`,name:"bos_token"},{anchor:"transformers.PerceiverTokenizer.eos_token",description:`<strong>eos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[EOS]&quot;</code>) &#x2014;
The end of sequence token (reserved in the vocab, but not actually used).</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>When building a sequence using special tokens, this is not the token that is used for the end of sequence.
The token used is the <code>sep_token</code>.</p>

					</div>`,name:"eos_token"},{anchor:"transformers.PerceiverTokenizer.mask_token",description:`<strong>mask_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[MASK]&quot;</code>) &#x2014;
The MASK token, useful for masked language modeling.`,name:"mask_token"},{anchor:"transformers.PerceiverTokenizer.cls_token",description:`<strong>cls_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[CLS]&quot;</code>) &#x2014;
The CLS token (reserved in the vocab, but not actually used).`,name:"cls_token"},{anchor:"transformers.PerceiverTokenizer.sep_token",description:`<strong>sep_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[SEP]&quot;</code>) &#x2014;
The separator token, which is used when building a sequence from two sequences.`,name:"sep_token"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/tokenization_perceiver.py#L26"}}),Jt=new C({props:{name:"__call__",anchor:"transformers.PerceiverTokenizer.__call__",parameters:[{name:"text",val:": typing.Union[str, typing.List[str], typing.List[typing.List[str]], NoneType] = None"},{name:"text_pair",val:": typing.Union[str, typing.List[str], typing.List[typing.List[str]], NoneType] = None"},{name:"text_target",val:": typing.Union[str, typing.List[str], typing.List[typing.List[str]], NoneType] = None"},{name:"text_pair_target",val:": typing.Union[str, typing.List[str], typing.List[typing.List[str]], NoneType] = None"},{name:"add_special_tokens",val:": bool = True"},{name:"padding",val:": typing.Union[bool, str, transformers.utils.generic.PaddingStrategy] = False"},{name:"truncation",val:": typing.Union[bool, str, transformers.tokenization_utils_base.TruncationStrategy, NoneType] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"stride",val:": int = 0"},{name:"is_split_into_words",val:": bool = False"},{name:"pad_to_multiple_of",val:": typing.Optional[int] = None"},{name:"padding_side",val:": typing.Optional[str] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"return_token_type_ids",val:": typing.Optional[bool] = None"},{name:"return_attention_mask",val:": typing.Optional[bool] = None"},{name:"return_overflowing_tokens",val:": bool = False"},{name:"return_special_tokens_mask",val:": bool = False"},{name:"return_offsets_mapping",val:": bool = False"},{name:"return_length",val:": bool = False"},{name:"verbose",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PerceiverTokenizer.__call__.text",description:`<strong>text</strong> (<code>str</code>, <code>List[str]</code>, <code>List[List[str]]</code>, <em>optional</em>) &#x2014;
The sequence or batch of sequences to be encoded. Each sequence can be a string or a list of strings
(pretokenized string). If the sequences are provided as list of strings (pretokenized), you must set
<code>is_split_into_words=True</code> (to lift the ambiguity with a batch of sequences).`,name:"text"},{anchor:"transformers.PerceiverTokenizer.__call__.text_pair",description:`<strong>text_pair</strong> (<code>str</code>, <code>List[str]</code>, <code>List[List[str]]</code>, <em>optional</em>) &#x2014;
The sequence or batch of sequences to be encoded. Each sequence can be a string or a list of strings
(pretokenized string). If the sequences are provided as list of strings (pretokenized), you must set
<code>is_split_into_words=True</code> (to lift the ambiguity with a batch of sequences).`,name:"text_pair"},{anchor:"transformers.PerceiverTokenizer.__call__.text_target",description:`<strong>text_target</strong> (<code>str</code>, <code>List[str]</code>, <code>List[List[str]]</code>, <em>optional</em>) &#x2014;
The sequence or batch of sequences to be encoded as target texts. Each sequence can be a string or a
list of strings (pretokenized string). If the sequences are provided as list of strings (pretokenized),
you must set <code>is_split_into_words=True</code> (to lift the ambiguity with a batch of sequences).`,name:"text_target"},{anchor:"transformers.PerceiverTokenizer.__call__.text_pair_target",description:`<strong>text_pair_target</strong> (<code>str</code>, <code>List[str]</code>, <code>List[List[str]]</code>, <em>optional</em>) &#x2014;
The sequence or batch of sequences to be encoded as target texts. Each sequence can be a string or a
list of strings (pretokenized string). If the sequences are provided as list of strings (pretokenized),
you must set <code>is_split_into_words=True</code> (to lift the ambiguity with a batch of sequences).`,name:"text_pair_target"},{anchor:"transformers.PerceiverTokenizer.__call__.add_special_tokens",description:`<strong>add_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to add special tokens when encoding the sequences. This will use the underlying
<code>PretrainedTokenizerBase.build_inputs_with_special_tokens</code> function, which defines which tokens are
automatically added to the input ids. This is useful if you want to add <code>bos</code> or <code>eos</code> tokens
automatically.`,name:"add_special_tokens"},{anchor:"transformers.PerceiverTokenizer.__call__.padding",description:`<strong>padding</strong> (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/main/en/internal/file_utils#transformers.utils.PaddingStrategy">PaddingStrategy</a>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Activates and controls padding. Accepts the following values:</p>
<ul>
<li><code>True</code> or <code>&apos;longest&apos;</code>: Pad to the longest sequence in the batch (or no padding if only a single
sequence is provided).</li>
<li><code>&apos;max_length&apos;</code>: Pad to a maximum length specified with the argument <code>max_length</code> or to the maximum
acceptable input length for the model if that argument is not provided.</li>
<li><code>False</code> or <code>&apos;do_not_pad&apos;</code> (default): No padding (i.e., can output a batch with sequences of different
lengths).</li>
</ul>`,name:"padding"},{anchor:"transformers.PerceiverTokenizer.__call__.truncation",description:`<strong>truncation</strong> (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.tokenization_utils_base.TruncationStrategy">TruncationStrategy</a>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Activates and controls truncation. Accepts the following values:</p>
<ul>
<li><code>True</code> or <code>&apos;longest_first&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or
to the maximum acceptable input length for the model if that argument is not provided. This will
truncate token by token, removing a token from the longest sequence in the pair if a pair of
sequences (or a batch of pairs) is provided.</li>
<li><code>&apos;only_first&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or to the
maximum acceptable input length for the model if that argument is not provided. This will only
truncate the first sequence of a pair if a pair of sequences (or a batch of pairs) is provided.</li>
<li><code>&apos;only_second&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or to the
maximum acceptable input length for the model if that argument is not provided. This will only
truncate the second sequence of a pair if a pair of sequences (or a batch of pairs) is provided.</li>
<li><code>False</code> or <code>&apos;do_not_truncate&apos;</code> (default): No truncation (i.e., can output batch with sequence lengths
greater than the model maximum admissible input size).</li>
</ul>`,name:"truncation"},{anchor:"transformers.PerceiverTokenizer.__call__.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Controls the maximum length to use by one of the truncation/padding parameters.</p>
<p>If left unset or set to <code>None</code>, this will use the predefined model maximum length if a maximum length
is required by one of the truncation/padding parameters. If the model has no specific maximum input
length (like XLNet) truncation/padding to a maximum length will be deactivated.`,name:"max_length"},{anchor:"transformers.PerceiverTokenizer.__call__.stride",description:`<strong>stride</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
If set to a number along with <code>max_length</code>, the overflowing tokens returned when
<code>return_overflowing_tokens=True</code> will contain some tokens from the end of the truncated sequence
returned to provide some overlap between truncated and overflowing sequences. The value of this
argument defines the number of overlapping tokens.`,name:"stride"},{anchor:"transformers.PerceiverTokenizer.__call__.is_split_into_words",description:`<strong>is_split_into_words</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the input is already pre-tokenized (e.g., split into words). If set to <code>True</code>, the
tokenizer assumes the input is already split into words (for instance, by splitting it on whitespace)
which it will tokenize. This is useful for NER or token classification.`,name:"is_split_into_words"},{anchor:"transformers.PerceiverTokenizer.__call__.pad_to_multiple_of",description:`<strong>pad_to_multiple_of</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If set will pad the sequence to a multiple of the provided value. Requires <code>padding</code> to be activated.
This is especially useful to enable the use of Tensor Cores on NVIDIA hardware with compute capability
<code>&gt;= 7.5</code> (Volta).`,name:"pad_to_multiple_of"},{anchor:"transformers.PerceiverTokenizer.__call__.padding_side",description:`<strong>padding_side</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The side on which the model should have padding applied. Should be selected between [&#x2018;right&#x2019;, &#x2018;left&#x2019;].
Default value is picked from the class attribute of the same name.`,name:"padding_side"},{anchor:"transformers.PerceiverTokenizer.__call__.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/main/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>) &#x2014;
If set, will return tensors instead of list of python integers. Acceptable values are:</p>
<ul>
<li><code>&apos;tf&apos;</code>: Return TensorFlow <code>tf.constant</code> objects.</li>
<li><code>&apos;pt&apos;</code>: Return PyTorch <code>torch.Tensor</code> objects.</li>
<li><code>&apos;np&apos;</code>: Return Numpy <code>np.ndarray</code> objects.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.PerceiverTokenizer.__call__.return_token_type_ids",description:`<strong>return_token_type_ids</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to return token type IDs. If left to the default, will return the token type IDs according to
the specific tokenizer&#x2019;s default, defined by the <code>return_outputs</code> attribute.</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"return_token_type_ids"},{anchor:"transformers.PerceiverTokenizer.__call__.return_attention_mask",description:`<strong>return_attention_mask</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to return the attention mask. If left to the default, will return the attention mask according
to the specific tokenizer&#x2019;s default, defined by the <code>return_outputs</code> attribute.</p>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"return_attention_mask"},{anchor:"transformers.PerceiverTokenizer.__call__.return_overflowing_tokens",description:`<strong>return_overflowing_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return overflowing token sequences. If a pair of sequences of input ids (or a batch
of pairs) is provided with <code>truncation_strategy = longest_first</code> or <code>True</code>, an error is raised instead
of returning overflowing tokens.`,name:"return_overflowing_tokens"},{anchor:"transformers.PerceiverTokenizer.__call__.return_special_tokens_mask",description:`<strong>return_special_tokens_mask</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return special tokens mask information.`,name:"return_special_tokens_mask"},{anchor:"transformers.PerceiverTokenizer.__call__.return_offsets_mapping",description:`<strong>return_offsets_mapping</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return <code>(char_start, char_end)</code> for each token.</p>
<p>This is only available on fast tokenizers inheriting from <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast">PreTrainedTokenizerFast</a>, if using
Python&#x2019;s tokenizer, this method will raise <code>NotImplementedError</code>.`,name:"return_offsets_mapping"},{anchor:"transformers.PerceiverTokenizer.__call__.return_length",description:`<strong>return_length</strong>  (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the lengths of the encoded inputs.`,name:"return_length"},{anchor:"transformers.PerceiverTokenizer.__call__.verbose",description:`<strong>verbose</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to print more information and warnings.`,name:"verbose"},{anchor:"transformers.PerceiverTokenizer.__call__.*kwargs",description:"*<strong>*kwargs</strong> &#x2014; passed to the <code>self.tokenize()</code> method",name:"*kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/tokenization_utils_base.py#L2772",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/tokenizer#transformers.BatchEncoding"
>BatchEncoding</a> with the following fields:</p>
<ul>
<li>
<p><strong>input_ids</strong> — List of token ids to be fed to a model.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a></p>
</li>
<li>
<p><strong>token_type_ids</strong> — List of token type ids to be fed to a model (when <code>return_token_type_ids=True</code> or
if <em>“token_type_ids”</em> is in <code>self.model_input_names</code>).</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a></p>
</li>
<li>
<p><strong>attention_mask</strong> — List of indices specifying which tokens should be attended to by the model (when
<code>return_attention_mask=True</code> or if <em>“attention_mask”</em> is in <code>self.model_input_names</code>).</p>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
</li>
<li>
<p><strong>overflowing_tokens</strong> — List of overflowing tokens sequences (when a <code>max_length</code> is specified and
<code>return_overflowing_tokens=True</code>).</p>
</li>
<li>
<p><strong>num_truncated_tokens</strong> — Number of tokens truncated (when a <code>max_length</code> is specified and
<code>return_overflowing_tokens=True</code>).</p>
</li>
<li>
<p><strong>special_tokens_mask</strong> — List of 0s and 1s, with 1 specifying added special tokens and 0 specifying
regular sequence tokens (when <code>add_special_tokens=True</code> and <code>return_special_tokens_mask=True</code>).</p>
</li>
<li>
<p><strong>length</strong> — The length of the inputs (when <code>return_length=True</code>)</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/tokenizer#transformers.BatchEncoding"
>BatchEncoding</a></p>
`}}),zt=new $({props:{title:"PerceiverFeatureExtractor",local:"transformers.PerceiverFeatureExtractor",headingTag:"h2"}}),Zt=new C({props:{name:"class transformers.PerceiverFeatureExtractor",anchor:"transformers.PerceiverFeatureExtractor",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/feature_extraction_perceiver.py#L27"}}),Nt=new C({props:{name:"__call__",anchor:"transformers.PerceiverFeatureExtractor.__call__",parameters:[{name:"images",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/image_processing_utils.py#L42"}}),Wt=new $({props:{title:"PerceiverImageProcessor",local:"transformers.PerceiverImageProcessor",headingTag:"h2"}}),qt=new C({props:{name:"class transformers.PerceiverImageProcessor",anchor:"transformers.PerceiverImageProcessor",parameters:[{name:"do_center_crop",val:": bool = True"},{name:"crop_size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"resample",val:": Resampling = <Resampling.BICUBIC: 3>"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PerceiverImageProcessor.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <code>optional</code>, defaults to <code>True</code>) &#x2014;
Whether or not to center crop the image. If the input size if smaller than <code>crop_size</code> along any edge, the
image will be padded with zeros and then center cropped. Can be overridden by the <code>do_center_crop</code>
parameter in the <code>preprocess</code> method.`,name:"do_center_crop"},{anchor:"transformers.PerceiverImageProcessor.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>{&quot;height&quot; -- 256, &quot;width&quot;: 256}</code>):
Desired output size when applying center-cropping. Can be overridden by the <code>crop_size</code> parameter in the
<code>preprocess</code> method.`,name:"crop_size"},{anchor:"transformers.PerceiverImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image to <code>(size[&quot;height&quot;], size[&quot;width&quot;])</code>. Can be overridden by the <code>do_resize</code>
parameter in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.PerceiverImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;height&quot; -- 224, &quot;width&quot;: 224}</code>):
Size of the image after resizing. Can be overridden by the <code>size</code> parameter in the <code>preprocess</code> method.`,name:"size"},{anchor:"transformers.PerceiverImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>PILImageResampling.BICUBIC</code>) &#x2014;
Defines the resampling filter to use if resizing the image. Can be overridden by the <code>resample</code> parameter
in the <code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.PerceiverImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the <code>do_rescale</code>
parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.PerceiverImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Defines the scale factor to use if rescaling the image. Can be overridden by the <code>rescale_factor</code> parameter
in the <code>preprocess</code> method.`,name:"rescale_factor"},{anchor:"transformers.PerceiverImageProcessor.do_normalize",description:`<strong>do_normalize</strong> &#x2014;
Whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code>
method.`,name:"do_normalize"},{anchor:"transformers.PerceiverImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_MEAN</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.PerceiverImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_STD</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/image_processing_perceiver.py#L48"}}),Bt=new C({props:{name:"preprocess",anchor:"transformers.PerceiverImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']]"},{name:"do_center_crop",val:": typing.Optional[bool] = None"},{name:"crop_size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"resample",val:": Resampling = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Optional[float] = None"},{name:"do_normalize",val:": typing.Optional[bool] = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": ChannelDimension = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.PerceiverImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.PerceiverImageProcessor.preprocess.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_center_crop</code>) &#x2014;
Whether to center crop the image to <code>crop_size</code>.`,name:"do_center_crop"},{anchor:"transformers.PerceiverImageProcessor.preprocess.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.crop_size</code>) &#x2014;
Desired output size after applying the center crop.`,name:"crop_size"},{anchor:"transformers.PerceiverImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.PerceiverImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the image after resizing.`,name:"size"},{anchor:"transformers.PerceiverImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>, Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.PerceiverImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.PerceiverImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.PerceiverImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.PerceiverImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean.`,name:"image_mean"},{anchor:"transformers.PerceiverImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation.`,name:"image_std"},{anchor:"transformers.PerceiverImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.PerceiverImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
</ul>`,name:"data_format"},{anchor:"transformers.PerceiverImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/image_processing_perceiver.py#L212"}}),Dt=new $({props:{title:"PerceiverImageProcessorFast",local:"transformers.PerceiverImageProcessorFast",headingTag:"h2"}}),Rt=new C({props:{name:"class transformers.PerceiverImageProcessorFast",anchor:"transformers.PerceiverImageProcessorFast",parameters:[{name:"**kwargs",val:": typing_extensions.Unpack[transformers.image_processing_utils_fast.DefaultFastImageProcessorKwargs]"}],parametersDescription:[{anchor:"transformers.PerceiverImageProcessorFast.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.PerceiverImageProcessorFast.size",description:`<strong>size</strong> (<code>dict[str, int]</code>, <em>optional</em>, defaults to <code>{&apos;height&apos; -- 224, &apos;width&apos;: 224}</code>):
Describes the maximum input dimensions to the model.`,name:"size"},{anchor:"transformers.PerceiverImageProcessorFast.default_to_square",description:`<strong>default_to_square</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to default to a square image when resizing, if size is an int.`,name:"default_to_square"},{anchor:"transformers.PerceiverImageProcessorFast.resample",description:`<strong>resample</strong> (<code>Union[PILImageResampling, F.InterpolationMode, NoneType]</code>, defaults to <code>Resampling.BICUBIC</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>. Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.PerceiverImageProcessorFast.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to center crop the image.`,name:"do_center_crop"},{anchor:"transformers.PerceiverImageProcessorFast.crop_size",description:`<strong>crop_size</strong> (<code>dict[str, int]</code>, <em>optional</em>, defaults to <code>{&apos;height&apos; -- 256, &apos;width&apos;: 256}</code>):
Size of the output image after applying <code>center_crop</code>.`,name:"crop_size"},{anchor:"transformers.PerceiverImageProcessorFast.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.PerceiverImageProcessorFast.rescale_factor",description:`<strong>rescale_factor</strong> (<code>Union[int, float, NoneType]</code>, defaults to <code>0.00392156862745098</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.PerceiverImageProcessorFast.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.PerceiverImageProcessorFast.image_mean",description:`<strong>image_mean</strong> (<code>Union[float, list[float], NoneType]</code>, defaults to <code>[0.485, 0.456, 0.406]</code>) &#x2014;
Image mean to use for normalization. Only has an effect if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.PerceiverImageProcessorFast.image_std",description:`<strong>image_std</strong> (<code>Union[float, list[float], NoneType]</code>, defaults to <code>[0.229, 0.224, 0.225]</code>) &#x2014;
Image standard deviation to use for normalization. Only has an effect if <code>do_normalize</code> is set to
<code>True</code>.`,name:"image_std"},{anchor:"transformers.PerceiverImageProcessorFast.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.PerceiverImageProcessorFast.return_tensors",description:"<strong>return_tensors</strong> (<code>Union[str, ~utils.generic.TensorType, NoneType]</code>, defaults to <code>None</code>) &#x2014;\nReturns stacked tensors if set to `pt, otherwise returns a list of tensors.",name:"return_tensors"},{anchor:"transformers.PerceiverImageProcessorFast.data_format",description:`<strong>data_format</strong> (<code>~image_utils.ChannelDimension</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
Only <code>ChannelDimension.FIRST</code> is supported. Added for compatibility with slow processors.`,name:"data_format"},{anchor:"transformers.PerceiverImageProcessorFast.input_data_format",description:`<strong>input_data_format</strong> (<code>Union[~image_utils.ChannelDimension, str, NoneType]</code>, defaults to <code>None</code>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"},{anchor:"transformers.PerceiverImageProcessorFast.device",description:`<strong>device</strong> (<code>torch.device</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The device to process the images on. If unset, the device is inferred from the input images.
Returns stacked tensors if set to \`pt, otherwise returns a list of tensors.`,name:"device"},{anchor:"transformers.PerceiverImageProcessorFast.data_format",description:`<strong>data_format</strong> (<code>~image_utils.ChannelDimension</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
Only <code>ChannelDimension.FIRST</code> is supported. Added for compatibility with slow processors.`,name:"data_format"},{anchor:"transformers.PerceiverImageProcessorFast.input_data_format",description:`<strong>input_data_format</strong> (<code>Union[~image_utils.ChannelDimension, str, NoneType]</code>, defaults to <code>None</code>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"},{anchor:"transformers.PerceiverImageProcessorFast.device",description:`<strong>device</strong> (<code>torch.device</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The device to process the images on. If unset, the device is inferred from the input images.
Returns stacked tensors if set to \`pt, otherwise returns a list of tensors.`,name:"device"},{anchor:"transformers.PerceiverImageProcessorFast.data_format",description:`<strong>data_format</strong> (<code>~image_utils.ChannelDimension</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
Only <code>ChannelDimension.FIRST</code> is supported. Added for compatibility with slow processors.`,name:"data_format"},{anchor:"transformers.PerceiverImageProcessorFast.input_data_format",description:`<strong>input_data_format</strong> (<code>Union[~image_utils.ChannelDimension, str, NoneType]</code>, defaults to <code>None</code>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"},{anchor:"transformers.PerceiverImageProcessorFast.device",description:`<strong>device</strong> (<code>torch.device</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The device to process the images on. If unset, the device is inferred from the input images.
Returns stacked tensors if set to \`pt, otherwise returns a list of tensors.`,name:"device"},{anchor:"transformers.PerceiverImageProcessorFast.data_format",description:`<strong>data_format</strong> (<code>~image_utils.ChannelDimension</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
Only <code>ChannelDimension.FIRST</code> is supported. Added for compatibility with slow processors.`,name:"data_format"},{anchor:"transformers.PerceiverImageProcessorFast.input_data_format",description:`<strong>input_data_format</strong> (<code>Union[~image_utils.ChannelDimension, str, NoneType]</code>, defaults to <code>None</code>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"},{anchor:"transformers.PerceiverImageProcessorFast.device",description:`<strong>device</strong> (<code>torch.device</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The device to process the images on. If unset, the device is inferred from the input images.
Returns stacked tensors if set to \`pt, otherwise returns a list of tensors.`,name:"device"},{anchor:"transformers.PerceiverImageProcessorFast.data_format",description:`<strong>data_format</strong> (<code>~image_utils.ChannelDimension</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
Only <code>ChannelDimension.FIRST</code> is supported. Added for compatibility with slow processors.`,name:"data_format"},{anchor:"transformers.PerceiverImageProcessorFast.input_data_format",description:`<strong>input_data_format</strong> (<code>Union[~image_utils.ChannelDimension, str, NoneType]</code>, defaults to <code>None</code>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"},{anchor:"transformers.PerceiverImageProcessorFast.device",description:`<strong>device</strong> (<code>torch.device</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The device to process the images on. If unset, the device is inferred from the input images.
Returns stacked tensors if set to \`pt, otherwise returns a list of tensors.`,name:"device"},{anchor:"transformers.PerceiverImageProcessorFast.data_format",description:`<strong>data_format</strong> (<code>~image_utils.ChannelDimension</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
Only <code>ChannelDimension.FIRST</code> is supported. Added for compatibility with slow processors.`,name:"data_format"},{anchor:"transformers.PerceiverImageProcessorFast.input_data_format",description:`<strong>input_data_format</strong> (<code>Union[~image_utils.ChannelDimension, str, NoneType]</code>, defaults to <code>None</code>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"},{anchor:"transformers.PerceiverImageProcessorFast.device",description:`<strong>device</strong> (<code>torch.device</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The device to process the images on. If unset, the device is inferred from the input images.
Returns stacked tensors if set to \`pt, otherwise returns a list of tensors.`,name:"device"},{anchor:"transformers.PerceiverImageProcessorFast.data_format",description:`<strong>data_format</strong> (<code>~image_utils.ChannelDimension</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
Only <code>ChannelDimension.FIRST</code> is supported. Added for compatibility with slow processors.`,name:"data_format"},{anchor:"transformers.PerceiverImageProcessorFast.input_data_format",description:`<strong>input_data_format</strong> (<code>Union[~image_utils.ChannelDimension, str, NoneType]</code>, defaults to <code>None</code>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"},{anchor:"transformers.PerceiverImageProcessorFast.device",description:`<strong>device</strong> (<code>torch.device</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The device to process the images on. If unset, the device is inferred from the input images.
Returns stacked tensors if set to \`pt, otherwise returns a list of tensors.`,name:"device"},{anchor:"transformers.PerceiverImageProcessorFast.data_format",description:`<strong>data_format</strong> (<code>~image_utils.ChannelDimension</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
Only <code>ChannelDimension.FIRST</code> is supported. Added for compatibility with slow processors.`,name:"data_format"},{anchor:"transformers.PerceiverImageProcessorFast.input_data_format",description:`<strong>input_data_format</strong> (<code>Union[~image_utils.ChannelDimension, str, NoneType]</code>, defaults to <code>None</code>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"},{anchor:"transformers.PerceiverImageProcessorFast.device",description:`<strong>device</strong> (<code>torch.device</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The device to process the images on. If unset, the device is inferred from the input images.
Returns stacked tensors if set to \`pt, otherwise returns a list of tensors.`,name:"device"},{anchor:"transformers.PerceiverImageProcessorFast.data_format",description:`<strong>data_format</strong> (<code>~image_utils.ChannelDimension</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
Only <code>ChannelDimension.FIRST</code> is supported. Added for compatibility with slow processors.`,name:"data_format"},{anchor:"transformers.PerceiverImageProcessorFast.input_data_format",description:`<strong>input_data_format</strong> (<code>Union[~image_utils.ChannelDimension, str, NoneType]</code>, defaults to <code>None</code>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"},{anchor:"transformers.PerceiverImageProcessorFast.device",description:`<strong>device</strong> (<code>torch.device</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The device to process the images on. If unset, the device is inferred from the input images.
Returns stacked tensors if set to \`pt, otherwise returns a list of tensors.`,name:"device"},{anchor:"transformers.PerceiverImageProcessorFast.data_format",description:`<strong>data_format</strong> (<code>~image_utils.ChannelDimension</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
Only <code>ChannelDimension.FIRST</code> is supported. Added for compatibility with slow processors.`,name:"data_format"},{anchor:"transformers.PerceiverImageProcessorFast.input_data_format",description:`<strong>input_data_format</strong> (<code>Union[~image_utils.ChannelDimension, str, NoneType]</code>, defaults to <code>None</code>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"},{anchor:"transformers.PerceiverImageProcessorFast.device",description:`<strong>device</strong> (<code>torch.device</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The device to process the images on. If unset, the device is inferred from the input images.
Returns stacked tensors if set to \`pt, otherwise returns a list of tensors.`,name:"device"},{anchor:"transformers.PerceiverImageProcessorFast.data_format",description:`<strong>data_format</strong> (<code>~image_utils.ChannelDimension</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
Only <code>ChannelDimension.FIRST</code> is supported. Added for compatibility with slow processors.`,name:"data_format"},{anchor:"transformers.PerceiverImageProcessorFast.input_data_format",description:`<strong>input_data_format</strong> (<code>Union[~image_utils.ChannelDimension, str, NoneType]</code>, defaults to <code>None</code>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"},{anchor:"transformers.PerceiverImageProcessorFast.device",description:`<strong>device</strong> (<code>torch.device</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The device to process the images on. If unset, the device is inferred from the input images.
Returns stacked tensors if set to \`pt, otherwise returns a list of tensors.`,name:"device"},{anchor:"transformers.PerceiverImageProcessorFast.data_format",description:`<strong>data_format</strong> (<code>~image_utils.ChannelDimension</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
Only <code>ChannelDimension.FIRST</code> is supported. Added for compatibility with slow processors.`,name:"data_format"},{anchor:"transformers.PerceiverImageProcessorFast.input_data_format",description:`<strong>input_data_format</strong> (<code>Union[~image_utils.ChannelDimension, str, NoneType]</code>, defaults to <code>None</code>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"},{anchor:"transformers.PerceiverImageProcessorFast.device",description:`<strong>device</strong> (<code>torch.device</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The device to process the images on. If unset, the device is inferred from the input images.
Returns stacked tensors if set to \`pt, otherwise returns a list of tensors.`,name:"device"},{anchor:"transformers.PerceiverImageProcessorFast.data_format",description:`<strong>data_format</strong> (<code>~image_utils.ChannelDimension</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
Only <code>ChannelDimension.FIRST</code> is supported. Added for compatibility with slow processors.`,name:"data_format"},{anchor:"transformers.PerceiverImageProcessorFast.input_data_format",description:`<strong>input_data_format</strong> (<code>Union[~image_utils.ChannelDimension, str, NoneType]</code>, defaults to <code>None</code>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"},{anchor:"transformers.PerceiverImageProcessorFast.device",description:`<strong>device</strong> (<code>torch.device</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The device to process the images on. If unset, the device is inferred from the input images.`,name:"device"},{anchor:"transformers.PerceiverImageProcessorFast.Returns",description:"<strong>Returns</strong> stacked tensors if set to `pt, otherwise returns a list of tensors. &#x2014;",name:"Returns"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/image_processing_perceiver_fast.py#L41"}}),Lt=new C({props:{name:"preprocess",anchor:"transformers.PerceiverImageProcessorFast.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']]"},{name:"*args",val:""},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.image_processing_utils_fast.DefaultFastImageProcessorKwargs]"}],parametersDescription:[{anchor:"transformers.PerceiverImageProcessorFast.preprocess.images",description:`<strong>images</strong> (<code>Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, list[&apos;PIL.Image.Image&apos;], list[numpy.ndarray], list[&apos;torch.Tensor&apos;]]</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.PerceiverImageProcessorFast.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.PerceiverImageProcessorFast.preprocess.size",description:`<strong>size</strong> (<code>dict[str, int]</code>, <em>optional</em>) &#x2014;
Describes the maximum input dimensions to the model.`,name:"size"},{anchor:"transformers.PerceiverImageProcessorFast.preprocess.default_to_square",description:`<strong>default_to_square</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to default to a square image when resizing, if size is an int.`,name:"default_to_square"},{anchor:"transformers.PerceiverImageProcessorFast.preprocess.resample",description:`<strong>resample</strong> (<code>Union[PILImageResampling, F.InterpolationMode, NoneType]</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>. Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.PerceiverImageProcessorFast.preprocess.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to center crop the image.`,name:"do_center_crop"},{anchor:"transformers.PerceiverImageProcessorFast.preprocess.crop_size",description:`<strong>crop_size</strong> (<code>dict[str, int]</code>, <em>optional</em>) &#x2014;
Size of the output image after applying <code>center_crop</code>.`,name:"crop_size"},{anchor:"transformers.PerceiverImageProcessorFast.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.PerceiverImageProcessorFast.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>Union[int, float, NoneType]</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.PerceiverImageProcessorFast.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.PerceiverImageProcessorFast.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>Union[float, list[float], NoneType]</code>) &#x2014;
Image mean to use for normalization. Only has an effect if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.PerceiverImageProcessorFast.preprocess.image_std",description:`<strong>image_std</strong> (<code>Union[float, list[float], NoneType]</code>) &#x2014;
Image standard deviation to use for normalization. Only has an effect if <code>do_normalize</code> is set to
<code>True</code>.`,name:"image_std"},{anchor:"transformers.PerceiverImageProcessorFast.preprocess.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.PerceiverImageProcessorFast.preprocess.return_tensors",description:"<strong>return_tensors</strong> (<code>Union[str, ~utils.generic.TensorType, NoneType]</code>) &#x2014;\nReturns stacked tensors if set to `pt, otherwise returns a list of tensors.",name:"return_tensors"},{anchor:"transformers.PerceiverImageProcessorFast.preprocess.data_format",description:`<strong>data_format</strong> (<code>~image_utils.ChannelDimension</code>, <em>optional</em>) &#x2014;
Only <code>ChannelDimension.FIRST</code> is supported. Added for compatibility with slow processors.`,name:"data_format"},{anchor:"transformers.PerceiverImageProcessorFast.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>Union[~image_utils.ChannelDimension, str, NoneType]</code>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"},{anchor:"transformers.PerceiverImageProcessorFast.preprocess.device",description:`<strong>device</strong> (<code>torch.device</code>, <em>optional</em>) &#x2014;
The device to process the images on. If unset, the device is inferred from the input images.`,name:"device"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/image_processing_utils_fast.py#L571",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><strong>data</strong> (<code>dict</code>) — Dictionary of lists/arrays/tensors returned by the <strong>call</strong> method (‘pixel_values’, etc.).</li>
<li><strong>tensor_type</strong> (<code>Union[None, str, TensorType]</code>, <em>optional</em>) — You can give a tensor_type here to convert the lists of integers in PyTorch/TensorFlow/Numpy Tensors at
initialization.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>&lt;class 'transformers.image_processing_base.BatchFeature'&gt;</code></p>
`}}),Gt=new $({props:{title:"PerceiverTextPreprocessor",local:"transformers.models.perceiver.modeling_perceiver.PerceiverTextPreprocessor",headingTag:"h2"}}),Vt=new C({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverTextPreprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverTextPreprocessor",parameters:[{name:"config",val:": PerceiverConfig"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverTextPreprocessor.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014;
Model configuration.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L2810"}}),Ht=new $({props:{title:"PerceiverImagePreprocessor",local:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor",headingTag:"h2"}}),Et=new C({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor",parameters:[{name:"config",val:""},{name:"prep_type",val:" = 'conv'"},{name:"spatial_downsample",val:": int = 4"},{name:"temporal_downsample",val:": int = 1"},{name:"position_encoding_type",val:": str = 'fourier'"},{name:"in_channels",val:": int = 3"},{name:"out_channels",val:": int = 64"},{name:"conv_after_patching",val:": bool = False"},{name:"conv_after_patching_in_channels",val:": int = 54"},{name:"conv2d_use_batchnorm",val:": bool = True"},{name:"concat_or_add_pos",val:": str = 'concat'"},{name:"project_pos_dim",val:": int = -1"},{name:"**position_encoding_kwargs",val:""}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.config",description:`<strong>config</strong> ([<em>PerceiverConfig</em>]) &#x2014;
Model configuration.`,name:"config"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.prep_type",description:`<strong>prep_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;conv&quot;</code>) &#x2014;
Preprocessing type. Can be &#x201C;conv1x1&#x201D;, &#x201C;conv&#x201D;, &#x201C;patches&#x201D;, &#x201C;pixels&#x201D;.`,name:"prep_type"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.spatial_downsample",description:`<strong>spatial_downsample</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
Spatial downsampling factor.`,name:"spatial_downsample"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.temporal_downsample",description:`<strong>temporal_downsample</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Temporal downsampling factor (only relevant in case a time dimension is present).`,name:"temporal_downsample"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.position_encoding_type",description:`<strong>position_encoding_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;fourier&quot;</code>) &#x2014;
Position encoding type. Can be &#x201C;fourier&#x201D; or &#x201C;trainable&#x201D;.`,name:"position_encoding_type"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.in_channels",description:`<strong>in_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
Number of channels in the input.`,name:"in_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.out_channels",description:`<strong>out_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Number of channels in the output.`,name:"out_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.conv_after_patching",description:`<strong>conv_after_patching</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to apply a convolutional layer after patching.`,name:"conv_after_patching"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.conv_after_patching_in_channels",description:`<strong>conv_after_patching_in_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 54) &#x2014;
Number of channels in the input of the convolutional layer after patching.`,name:"conv_after_patching_in_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.conv2d_use_batchnorm",description:`<strong>conv2d_use_batchnorm</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use batch normalization in the convolutional layer.`,name:"conv2d_use_batchnorm"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.concat_or_add_pos",description:`<strong>concat_or_add_pos</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;concat&quot;</code>) &#x2014;
How to concatenate the position encoding to the input. Can be &#x201C;concat&#x201D; or &#x201C;add&#x201D;.`,name:"concat_or_add_pos"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.project_pos_dim",description:`<strong>project_pos_dim</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
Dimension of the position encoding to project to. If -1, no projection is applied.`,name:"project_pos_dim"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.*position_encoding_kwargs",description:`*<strong>*position_encoding_kwargs</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Keyword arguments for the position encoding.`,name:"*position_encoding_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L2973"}}),St=new $({props:{title:"PerceiverOneHotPreprocessor",local:"transformers.models.perceiver.modeling_perceiver.PerceiverOneHotPreprocessor",headingTag:"h2"}}),Xt=new C({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverOneHotPreprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverOneHotPreprocessor",parameters:[{name:"config",val:": PerceiverConfig"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverOneHotPreprocessor.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014;
Model configuration.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L3211"}}),At=new $({props:{title:"PerceiverAudioPreprocessor",local:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor",headingTag:"h2"}}),Ot=new C({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor",parameters:[{name:"config",val:""},{name:"prep_type",val:": str = 'patches'"},{name:"samples_per_patch",val:": int = 96"},{name:"position_encoding_type",val:": str = 'fourier'"},{name:"concat_or_add_pos",val:": str = 'concat'"},{name:"out_channels",val:" = 64"},{name:"project_pos_dim",val:" = -1"},{name:"**position_encoding_kwargs",val:""}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.config",description:`<strong>config</strong> ([<em>PerceiverConfig</em>]) &#x2014;
Model configuration.`,name:"config"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.prep_type",description:`<strong>prep_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;patches&quot;</code>) &#x2014;
Preprocessor type to use. Only &#x201C;patches&#x201D; is supported.`,name:"prep_type"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.samples_per_patch",description:`<strong>samples_per_patch</strong> (<code>int</code>, <em>optional</em>, defaults to 96) &#x2014;
Number of samples per patch.`,name:"samples_per_patch"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.position_encoding_type",description:`<strong>position_encoding_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;fourier&quot;</code>) &#x2014;
Type of position encoding to use. Can be &#x201C;trainable&#x201D; or &#x201C;fourier&#x201D;.`,name:"position_encoding_type"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.concat_or_add_pos",description:`<strong>concat_or_add_pos</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;concat&quot;</code>) &#x2014;
How to concatenate the position encoding to the input. Can be &#x201C;concat&#x201D; or &#x201C;add&#x201D;.`,name:"concat_or_add_pos"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.out_channels",description:`<strong>out_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Number of channels in the output.`,name:"out_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.project_pos_dim",description:`<strong>project_pos_dim</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
Dimension of the position encoding to project to. If -1, no projection is applied.`,name:"project_pos_dim"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.*position_encoding_kwargs",description:`*<strong>*position_encoding_kwargs</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Keyword arguments for the position encoding.`,name:"*position_encoding_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L3237"}}),Yt=new $({props:{title:"PerceiverMultimodalPreprocessor",local:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor",headingTag:"h2"}}),Qt=new C({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor",parameters:[{name:"modalities",val:": Mapping"},{name:"mask_probs",val:": typing.Optional[collections.abc.Mapping[str, float]] = None"},{name:"min_padding_size",val:": int = 2"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor.modalities",description:`<strong>modalities</strong> (<code>Mapping[str, PreprocessorType]</code>) &#x2014;
Dict mapping modality name to preprocessor.`,name:"modalities"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor.mask_probs",description:`<strong>mask_probs</strong> (<code>Dict[str, float]</code>) &#x2014;
Dict mapping modality name to masking probability of that modality.`,name:"mask_probs"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor.min_padding_size",description:`<strong>min_padding_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The minimum padding size for all modalities. The final output will have num_channels equal to the maximum
channels across all modalities plus min_padding_size.`,name:"min_padding_size"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L3340"}}),Kt=new $({props:{title:"PerceiverProjectionDecoder",local:"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionDecoder",headingTag:"h2"}}),eo=new C({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverProjectionDecoder",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionDecoder",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionDecoder.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014;
Model configuration.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L1988"}}),to=new $({props:{title:"PerceiverBasicDecoder",local:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder",headingTag:"h2"}}),oo=new C({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder",parameters:[{name:"config",val:": PerceiverConfig"},{name:"output_num_channels",val:": int"},{name:"position_encoding_type",val:": typing.Optional[str] = 'trainable'"},{name:"output_index_dims",val:": typing.Optional[int] = None"},{name:"num_channels",val:": typing.Optional[int] = 128"},{name:"subsampled_index_dims",val:": typing.Optional[int] = None"},{name:"qk_channels",val:": typing.Optional[int] = None"},{name:"v_channels",val:": typing.Optional[int] = None"},{name:"num_heads",val:": typing.Optional[int] = 1"},{name:"widening_factor",val:": typing.Optional[int] = 1"},{name:"use_query_residual",val:": typing.Optional[bool] = False"},{name:"concat_preprocessed_input",val:": typing.Optional[bool] = False"},{name:"final_project",val:": typing.Optional[bool] = True"},{name:"position_encoding_only",val:": typing.Optional[bool] = False"},{name:"**position_encoding_kwargs",val:""}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.config",description:`<strong>config</strong> ([<em>PerceiverConfig</em>]) &#x2014;
Model configuration.`,name:"config"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.output_num_channels",description:`<strong>output_num_channels</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of channels in the output. Will only be used in case <em>final_project</em> is set to <code>True</code>.`,name:"output_num_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.position_encoding_type",description:`<strong>position_encoding_type</strong> (<code>str</code>, <em>optional</em>, defaults to &#x201C;trainable&#x201D;) &#x2014;
The type of position encoding to use. Can be either &#x201C;trainable&#x201D;, &#x201C;fourier&#x201D;, or &#x201C;none&#x201D;.`,name:"position_encoding_type"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.output_index_dims",description:`<strong>output_index_dims</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of dimensions of the output queries. Ignored if &#x2018;position_encoding_type&#x2019; == &#x2018;none&#x2019;.`,name:"output_index_dims"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
The number of channels of the decoder queries. Ignored if &#x2018;position_encoding_type&#x2019; == &#x2018;none&#x2019;.`,name:"num_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.qk_channels",description:`<strong>qk_channels</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of channels of the queries and keys in the cross-attention layer.`,name:"qk_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.v_channels",description:`<strong>v_channels</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of channels of the values in the cross-attention layer.`,name:"v_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.num_heads",description:`<strong>num_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of attention heads in the cross-attention layer.`,name:"num_heads"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.widening_factor",description:`<strong>widening_factor</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The widening factor of the cross-attention layer.`,name:"widening_factor"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.use_query_residual",description:`<strong>use_query_residual</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use a residual connection between the query and the output of the cross-attention layer.`,name:"use_query_residual"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.concat_preprocessed_input",description:`<strong>concat_preprocessed_input</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to concatenate the preprocessed input to the query.`,name:"concat_preprocessed_input"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.final_project",description:`<strong>final_project</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to project the output of the cross-attention layer to a target dimension.`,name:"final_project"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.position_encoding_only",description:`<strong>position_encoding_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only use this class to define output queries.`,name:"position_encoding_only"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L2014"}}),no=new $({props:{title:"PerceiverClassificationDecoder",local:"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder",headingTag:"h2"}}),ro=new C({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder",parameters:[{name:"config",val:""},{name:"**decoder_kwargs",val:""}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014;
Model configuration.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L2200"}}),so=new $({props:{title:"PerceiverOpticalFlowDecoder",local:"transformers.models.perceiver.modeling_perceiver.PerceiverOpticalFlowDecoder",headingTag:"h2"}}),ao=new C({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverOpticalFlowDecoder",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverOpticalFlowDecoder",parameters:[{name:"config",val:""},{name:"output_image_shape",val:""},{name:"output_num_channels",val:" = 2"},{name:"rescale_factor",val:" = 100.0"},{name:"**decoder_kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L2246"}}),io=new $({props:{title:"PerceiverBasicVideoAutoencodingDecoder",local:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder",headingTag:"h2"}}),co=new C({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder",parameters:[{name:"config",val:": PerceiverConfig"},{name:"output_shape",val:": typing.List[int]"},{name:"position_encoding_type",val:": str"},{name:"**decoder_kwargs",val:""}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder.config",description:`<strong>config</strong> ([<em>PerceiverConfig</em>]) &#x2014;
Model configuration.`,name:"config"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder.output_shape",description:`<strong>output_shape</strong> (<code>List[int]</code>) &#x2014;
Shape of the output as (batch_size, num_frames, height, width), excluding the channel dimension.`,name:"output_shape"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder.position_encoding_type",description:`<strong>position_encoding_type</strong> (<code>str</code>) &#x2014;
The type of position encoding to use. Can be either &#x201C;trainable&#x201D;, &#x201C;fourier&#x201D;, or &#x201C;none&#x201D;.`,name:"position_encoding_type"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L2281"}}),lo=new $({props:{title:"PerceiverMultimodalDecoder",local:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder",headingTag:"h2"}}),mo=new C({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder",parameters:[{name:"config",val:": PerceiverConfig"},{name:"modalities",val:": typing.Dict[str, transformers.models.perceiver.modeling_perceiver.PerceiverAbstractDecoder]"},{name:"num_outputs",val:": int"},{name:"output_num_channels",val:": int"},{name:"min_padding_size",val:": typing.Optional[int] = 2"},{name:"subsampled_index_dims",val:": typing.Optional[typing.Dict[str, transformers.models.perceiver.modeling_perceiver.PerceiverAbstractDecoder]] = None"},{name:"**decoder_kwargs",val:""}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder.config",description:`<strong>config</strong> ([<em>PerceiverConfig</em>]) &#x2014;
Model configuration.`,name:"config"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder.modalities",description:`<strong>modalities</strong> (<code>Dict[str, PerceiverAbstractDecoder]</code>) &#x2014;
Dictionary mapping modality name to the decoder of that modality.`,name:"modalities"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder.num_outputs",description:`<strong>num_outputs</strong> (<code>int</code>) &#x2014;
The number of outputs of the decoder.`,name:"num_outputs"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder.output_num_channels",description:`<strong>output_num_channels</strong> (<code>int</code>) &#x2014;
The number of channels in the output.`,name:"output_num_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder.min_padding_size",description:`<strong>min_padding_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The minimum padding size for all modalities. The final output will have num_channels equal to the maximum
channels across all modalities plus min_padding_size.`,name:"min_padding_size"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder.subsampled_index_dims",description:`<strong>subsampled_index_dims</strong> (<code>Dict[str, PerceiverAbstractDecoder]</code>, <em>optional</em>) &#x2014;
Dictionary mapping modality name to the subsampled index dimensions to use for the decoder query of that
modality.`,name:"subsampled_index_dims"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L2358"}}),po=new $({props:{title:"PerceiverProjectionPostprocessor",local:"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionPostprocessor",headingTag:"h2"}}),ho=new C({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverProjectionPostprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionPostprocessor",parameters:[{name:"in_channels",val:": int"},{name:"out_channels",val:": int"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionPostprocessor.in_channels",description:`<strong>in_channels</strong> (<code>int</code>) &#x2014;
Number of channels in the input.`,name:"in_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionPostprocessor.out_channels",description:`<strong>out_channels</strong> (<code>int</code>) &#x2014;
Number of channels in the output.`,name:"out_channels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L2952"}}),go=new $({props:{title:"PerceiverAudioPostprocessor",local:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor",headingTag:"h2"}}),uo=new C({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor",parameters:[{name:"config",val:": PerceiverConfig"},{name:"in_channels",val:": int"},{name:"postproc_type",val:": str = 'patches'"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor.config",description:`<strong>config</strong> ([<em>PerceiverConfig</em>]) &#x2014;
Model configuration.`,name:"config"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor.in_channels",description:`<strong>in_channels</strong> (<code>int</code>) &#x2014;
Number of channels in the input.`,name:"in_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor.postproc_type",description:`<strong>postproc_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;patches&quot;</code>) &#x2014;
Postprocessor type to use. Currently, only &#x201C;patches&#x201D; is supported.`,name:"postproc_type"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L2925"}}),fo=new $({props:{title:"PerceiverClassificationPostprocessor",local:"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationPostprocessor",headingTag:"h2"}}),_o=new C({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverClassificationPostprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationPostprocessor",parameters:[{name:"config",val:": PerceiverConfig"},{name:"in_channels",val:": int"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationPostprocessor.config",description:`<strong>config</strong> ([<em>PerceiverConfig</em>]) &#x2014;
Model configuration.`,name:"config"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationPostprocessor.in_channels",description:`<strong>in_channels</strong> (<code>int</code>) &#x2014;
Number of channels in the input.`,name:"in_channels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L2905"}}),vo=new $({props:{title:"PerceiverMultimodalPostprocessor",local:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPostprocessor",headingTag:"h2"}}),bo=new C({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPostprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPostprocessor",parameters:[{name:"modalities",val:": Mapping"},{name:"input_is_dict",val:": bool = False"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPostprocessor.modalities",description:`<strong>modalities</strong> (<code>Mapping[str, PostprocessorType]</code>) &#x2014;
Dictionary mapping modality name to postprocessor class for that modality.`,name:"modalities"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPostprocessor.input_is_dict",description:`<strong>input_is_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If True, input is assumed to be dictionary structured, and outputs keep the same dictionary shape. If
False, input is a tensor which is sliced up during postprocessing by <em>modality_sizes</em>.`,name:"input_is_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L2871"}}),yo=new $({props:{title:"PerceiverModel",local:"transformers.PerceiverModel",headingTag:"h2"}}),Mo=new C({props:{name:"class transformers.PerceiverModel",anchor:"transformers.PerceiverModel",parameters:[{name:"config",val:""},{name:"decoder",val:": typing.Optional[ForwardRef('PerceiverAbstractDecoder')] = None"},{name:"input_preprocessor",val:": typing.Callable[..., typing.Tuple[torch.Tensor, typing.Optional[torch.Tensor], torch.Tensor]] = None"},{name:"output_postprocessor",val:": typing.Callable[..., typing.Any] = None"}],parametersDescription:[{anchor:"transformers.PerceiverModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverModel">PerceiverModel</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.PerceiverModel.decoder",description:`<strong>decoder</strong> (<code>PerceiverAbstractDecoder</code>, <em>optional</em>) &#x2014;
Decoder module that transforms latent representations into task predictions.`,name:"decoder"},{anchor:"transformers.PerceiverModel.input_preprocessor",description:`<strong>input_preprocessor</strong> (<code>Callable[..., Tuple[torch.Tensor, torch.Tensor, torch.Tensor]]</code>, <em>optional</em>) &#x2014;
Preprocessor that encodes raw inputs into tensors for the model.`,name:"input_preprocessor"},{anchor:"transformers.PerceiverModel.output_postprocessor",description:`<strong>output_postprocessor</strong> (<code>Callable[..., Any]</code>, <em>optional</em>) &#x2014;
Postprocessor that transforms model outputs into final predictions.`,name:"output_postprocessor"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L625"}}),Be=new me({props:{$$slots:{default:[id]},$$scope:{ctx:x}}}),To=new C({props:{name:"forward",anchor:"transformers.PerceiverModel.forward",parameters:[{name:"inputs",val:": FloatTensor"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"subsampled_output_points",val:": typing.Optional[typing.Dict[str, torch.Tensor]] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"interpolate_pos_encoding",val:": bool = False"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.PerceiverModel.forward.inputs",description:`<strong>inputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverModel.forward.subsampled_output_points",description:`<strong>subsampled_output_points</strong> (<code>Dict[str, torch.Tensor]</code>, torch.Tensor]\`, <em>optional</em>) &#x2014;
Dictionary of tensors used as queries for the decoder. The decoder maps these queries to the latent
representation of the model. Used for subsampled decoding, e.g. when only decoding certain image patches.`,name:"subsampled_output_points"},{anchor:"transformers.PerceiverModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverModel.forward.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"},{anchor:"transformers.PerceiverModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L682",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder’s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),De=new me({props:{$$slots:{default:[cd]},$$scope:{ctx:x}}}),Re=new Fe({props:{anchor:"transformers.PerceiverModel.forward.example",$$slots:{default:[ld]},$$scope:{ctx:x}}}),wo=new $({props:{title:"PerceiverForMaskedLM",local:"transformers.PerceiverForMaskedLM",headingTag:"h2"}}),Po=new C({props:{name:"class transformers.PerceiverForMaskedLM",anchor:"transformers.PerceiverForMaskedLM",parameters:[{name:"config",val:": PerceiverConfig"}],parametersDescription:[{anchor:"transformers.PerceiverForMaskedLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L889"}}),Co=new C({props:{name:"forward",anchor:"transformers.PerceiverForMaskedLM.forward",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"transformers.PerceiverForMaskedLM.forward.inputs",description:`<strong>inputs</strong> (<code>torch.Tensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverForMaskedLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverForMaskedLM.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverForMaskedLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverForMaskedLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverForMaskedLM.forward.labels",description:`<strong>labels</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should be in <code>[-100, 0, ..., config.vocab_size]</code> (see <code>input_ids</code> docstring) Tokens with indices set to <code>-100</code> are ignored (masked), the
loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"},{anchor:"transformers.PerceiverForMaskedLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PerceiverForMaskedLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L926",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Masked language modeling (MLM) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, num_latents, num_latents)</code>. Attentions weights after the attention softmax, used to compute the weighted average in the
self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder’s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Le=new me({props:{$$slots:{default:[dd]},$$scope:{ctx:x}}}),Ge=new Fe({props:{anchor:"transformers.PerceiverForMaskedLM.forward.example",$$slots:{default:[md]},$$scope:{ctx:x}}}),xo=new $({props:{title:"PerceiverForSequenceClassification",local:"transformers.PerceiverForSequenceClassification",headingTag:"h2"}}),$o=new C({props:{name:"class transformers.PerceiverForSequenceClassification",anchor:"transformers.PerceiverForSequenceClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.PerceiverForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverForSequenceClassification">PerceiverForSequenceClassification</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L1027"}}),ko=new C({props:{name:"forward",anchor:"transformers.PerceiverForSequenceClassification.forward",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"transformers.PerceiverForSequenceClassification.forward.inputs",description:`<strong>inputs</strong> (<code>torch.Tensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverForSequenceClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.Tensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If <code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"},{anchor:"transformers.PerceiverForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PerceiverForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L1053",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder’s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Ve=new me({props:{$$slots:{default:[pd]},$$scope:{ctx:x}}}),He=new Fe({props:{anchor:"transformers.PerceiverForSequenceClassification.forward.example",$$slots:{default:[hd]},$$scope:{ctx:x}}}),jo=new $({props:{title:"PerceiverForImageClassificationLearned",local:"transformers.PerceiverForImageClassificationLearned",headingTag:"h2"}}),Io=new C({props:{name:"class transformers.PerceiverForImageClassificationLearned",anchor:"transformers.PerceiverForImageClassificationLearned",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.PerceiverForImageClassificationLearned.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverForImageClassificationLearned">PerceiverForImageClassificationLearned</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L1142"}}),Fo=new C({props:{name:"forward",anchor:"transformers.PerceiverForImageClassificationLearned.forward",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"interpolate_pos_encoding",val:": bool = False"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"transformers.PerceiverForImageClassificationLearned.forward.inputs",description:`<strong>inputs</strong> (<code>torch.Tensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverForImageClassificationLearned.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverForImageClassificationLearned.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverForImageClassificationLearned.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverForImageClassificationLearned.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverForImageClassificationLearned.forward.labels",description:`<strong>labels</strong> (<code>torch.Tensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"},{anchor:"transformers.PerceiverForImageClassificationLearned.forward.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"},{anchor:"transformers.PerceiverForImageClassificationLearned.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PerceiverForImageClassificationLearned.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>, <em>optional</em>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L1186",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder’s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Ee=new me({props:{$$slots:{default:[gd]},$$scope:{ctx:x}}}),Se=new Fe({props:{anchor:"transformers.PerceiverForImageClassificationLearned.forward.example",$$slots:{default:[ud]},$$scope:{ctx:x}}}),Uo=new $({props:{title:"PerceiverForImageClassificationFourier",local:"transformers.PerceiverForImageClassificationFourier",headingTag:"h2"}}),Jo=new C({props:{name:"class transformers.PerceiverForImageClassificationFourier",anchor:"transformers.PerceiverForImageClassificationFourier",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.PerceiverForImageClassificationFourier.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverForImageClassificationFourier">PerceiverForImageClassificationFourier</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L1285"}}),zo=new C({props:{name:"forward",anchor:"transformers.PerceiverForImageClassificationFourier.forward",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"transformers.PerceiverForImageClassificationFourier.forward.inputs",description:`<strong>inputs</strong> (<code>torch.Tensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverForImageClassificationFourier.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverForImageClassificationFourier.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverForImageClassificationFourier.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverForImageClassificationFourier.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverForImageClassificationFourier.forward.labels",description:`<strong>labels</strong> (<code>torch.Tensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"},{anchor:"transformers.PerceiverForImageClassificationFourier.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PerceiverForImageClassificationFourier.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>, <em>optional</em>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L1330",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder’s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Xe=new me({props:{$$slots:{default:[fd]},$$scope:{ctx:x}}}),Ae=new Fe({props:{anchor:"transformers.PerceiverForImageClassificationFourier.forward.example",$$slots:{default:[_d]},$$scope:{ctx:x}}}),Zo=new $({props:{title:"PerceiverForImageClassificationConvProcessing",local:"transformers.PerceiverForImageClassificationConvProcessing",headingTag:"h2"}}),No=new C({props:{name:"class transformers.PerceiverForImageClassificationConvProcessing",anchor:"transformers.PerceiverForImageClassificationConvProcessing",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.PerceiverForImageClassificationConvProcessing.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverForImageClassificationConvProcessing">PerceiverForImageClassificationConvProcessing</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L1426"}}),Wo=new C({props:{name:"forward",anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.inputs",description:`<strong>inputs</strong> (<code>torch.Tensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.labels",description:`<strong>labels</strong> (<code>torch.Tensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"},{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>, <em>optional</em>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L1472",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder’s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Oe=new me({props:{$$slots:{default:[vd]},$$scope:{ctx:x}}}),Ye=new Fe({props:{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.example",$$slots:{default:[bd]},$$scope:{ctx:x}}}),qo=new $({props:{title:"PerceiverForOpticalFlow",local:"transformers.PerceiverForOpticalFlow",headingTag:"h2"}}),Bo=new C({props:{name:"class transformers.PerceiverForOpticalFlow",anchor:"transformers.PerceiverForOpticalFlow",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.PerceiverForOpticalFlow.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverForOpticalFlow">PerceiverForOpticalFlow</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L1568"}}),Do=new C({props:{name:"forward",anchor:"transformers.PerceiverForOpticalFlow.forward",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.PerceiverForOpticalFlow.forward.inputs",description:`<strong>inputs</strong> (<code>torch.Tensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverForOpticalFlow.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverForOpticalFlow.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverForOpticalFlow.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverForOpticalFlow.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverForOpticalFlow.forward.labels",description:`<strong>labels</strong> (<code>torch.Tensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the optical flow loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>.`,name:"labels"},{anchor:"transformers.PerceiverForOpticalFlow.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L1631",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder’s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Qe=new me({props:{$$slots:{default:[yd]},$$scope:{ctx:x}}}),Ke=new Fe({props:{anchor:"transformers.PerceiverForOpticalFlow.forward.example",$$slots:{default:[Md]},$$scope:{ctx:x}}}),Ro=new $({props:{title:"PerceiverForMultimodalAutoencoding",local:"transformers.PerceiverForMultimodalAutoencoding",headingTag:"h2"}}),Lo=new C({props:{name:"class transformers.PerceiverForMultimodalAutoencoding",anchor:"transformers.PerceiverForMultimodalAutoencoding",parameters:[{name:"config",val:": PerceiverConfig"}],parametersDescription:[{anchor:"transformers.PerceiverForMultimodalAutoencoding.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L1695"}}),Go=new C({props:{name:"forward",anchor:"transformers.PerceiverForMultimodalAutoencoding.forward",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"subsampled_output_points",val:": typing.Optional[typing.Dict[str, torch.Tensor]] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.inputs",description:`<strong>inputs</strong> (<code>torch.Tensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.subsampled_output_points",description:`<strong>subsampled_output_points</strong> (<code>Dict[str, torch.Tensor]</code>, torch.Tensor]\`, <em>optional</em>) &#x2014;
Dictionary of tensors used as queries for the decoder. The decoder maps these queries to the latent
representation of the model. Used for subsampled decoding, e.g. when only decoding certain image patches.`,name:"subsampled_output_points"},{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.labels",description:`<strong>labels</strong> (<code>torch.Tensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"},{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/perceiver/modeling_perceiver.py#L1840",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder’s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),et=new me({props:{$$slots:{default:[Td]},$$scope:{ctx:x}}}),tt=new Fe({props:{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.example",$$slots:{default:[wd]},$$scope:{ctx:x}}}),Vo=new rd({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/perceiver.md"}}),{c(){a=i("meta"),y=r(),p=i("p"),b=r(),h(M.$$.fragment),d=r(),P=i("div"),P.innerHTML=hc,Jr=r(),h(dt.$$.fragment),zr=r(),mt=i("p"),mt.innerHTML=gc,Zr=r(),pt=i("p"),pt.innerHTML=uc,Nr=r(),ht=i("p"),ht.textContent=fc,Wr=r(),gt=i("p"),gt.innerHTML=_c,qr=r(),ut=i("p"),ut.textContent=vc,Br=r(),ft=i("p"),ft.textContent=bc,Dr=r(),_t=i("p"),_t.innerHTML=yc,Rr=r(),vt=i("p"),vt.textContent=Mc,Lr=r(),bt=i("p"),bt.innerHTML=Tc,Gr=r(),Je=i("img"),Vr=r(),yt=i("small"),yt.innerHTML=Pc,Hr=r(),Mt=i("p"),Mt.innerHTML=Cc,Er=r(),h(ze.$$.fragment),Sr=r(),h(Tt.$$.fragment),Xr=r(),wt=i("ul"),wt.innerHTML=xc,Ar=r(),h(Pt.$$.fragment),Or=r(),pe=i("div"),h(Ct.$$.fragment),pa=r(),on=i("p"),on.textContent=$c,Yr=r(),he=i("div"),h(xt.$$.fragment),ha=r(),nn=i("p"),nn.textContent=kc,Qr=r(),ge=i("div"),h($t.$$.fragment),ga=r(),rn=i("p"),rn.textContent=jc,Kr=r(),ue=i("div"),h(kt.$$.fragment),ua=r(),sn=i("p"),sn.textContent=Ic,es=r(),h(jt.$$.fragment),ts=r(),L=i("div"),h(It.$$.fragment),fa=r(),an=i("p"),an.innerHTML=Fc,_a=r(),cn=i("p"),cn.innerHTML=Uc,va=r(),h(Ze.$$.fragment),os=r(),h(Ft.$$.fragment),ns=r(),G=i("div"),h(Ut.$$.fragment),ba=r(),ln=i("p"),ln.textContent=Jc,ya=r(),dn=i("p"),dn.innerHTML=zc,Ma=r(),Ne=i("div"),h(Jt.$$.fragment),Ta=r(),mn=i("p"),mn.textContent=Zc,rs=r(),h(zt.$$.fragment),ss=r(),fe=i("div"),h(Zt.$$.fragment),wa=r(),We=i("div"),h(Nt.$$.fragment),Pa=r(),pn=i("p"),pn.textContent=Nc,as=r(),h(Wt.$$.fragment),is=r(),te=i("div"),h(qt.$$.fragment),Ca=r(),hn=i("p"),hn.textContent=Wc,xa=r(),qe=i("div"),h(Bt.$$.fragment),$a=r(),gn=i("p"),gn.textContent=qc,cs=r(),h(Dt.$$.fragment),ls=r(),N=i("div"),h(Rt.$$.fragment),ka=r(),un=i("p"),un.textContent=Bc,ja=r(),fn=i("p"),fn.innerHTML=Dc,Ia=r(),_n=i("ul"),_n.innerHTML=Rc,Fa=r(),vn=i("div"),h(Lt.$$.fragment),ds=r(),h(Gt.$$.fragment),ms=r(),oe=i("div"),h(Vt.$$.fragment),Ua=r(),bn=i("p"),bn.innerHTML=Lc,Ja=r(),yn=i("p"),yn.innerHTML=Gc,ps=r(),h(Ht.$$.fragment),hs=r(),ne=i("div"),h(Et.$$.fragment),za=r(),Mn=i("p"),Mn.textContent=Vc,Za=r(),Tn=i("p"),Tn.innerHTML=Hc,gs=r(),h(St.$$.fragment),us=r(),_e=i("div"),h(Xt.$$.fragment),Na=r(),wn=i("p"),wn.textContent=Ec,fs=r(),h(At.$$.fragment),_s=r(),ve=i("div"),h(Ot.$$.fragment),Wa=r(),Pn=i("p"),Pn.textContent=Sc,vs=r(),h(Yt.$$.fragment),bs=r(),re=i("div"),h(Qt.$$.fragment),qa=r(),Cn=i("p"),Cn.textContent=Xc,Ba=r(),xn=i("p"),xn.textContent=Ac,ys=r(),h(Kt.$$.fragment),Ms=r(),be=i("div"),h(eo.$$.fragment),Da=r(),$n=i("p"),$n.textContent=Oc,Ts=r(),h(to.$$.fragment),ws=r(),se=i("div"),h(oo.$$.fragment),Ra=r(),kn=i("p"),kn.textContent=Yc,La=r(),jn=i("p"),jn.textContent=Qc,Ps=r(),h(no.$$.fragment),Cs=r(),ye=i("div"),h(ro.$$.fragment),Ga=r(),In=i("p"),In.innerHTML=Kc,xs=r(),h(so.$$.fragment),$s=r(),Me=i("div"),h(ao.$$.fragment),Va=r(),Fn=i("p"),Fn.textContent=el,ks=r(),h(io.$$.fragment),js=r(),Te=i("div"),h(co.$$.fragment),Ha=r(),Un=i("p"),Un.innerHTML=tl,Is=r(),h(lo.$$.fragment),Fs=r(),ae=i("div"),h(mo.$$.fragment),Ea=r(),Jn=i("p"),Jn.innerHTML=ol,Sa=r(),zn=i("p"),zn.textContent=nl,Us=r(),h(po.$$.fragment),Js=r(),we=i("div"),h(ho.$$.fragment),Xa=r(),Zn=i("p"),Zn.textContent=rl,zs=r(),h(go.$$.fragment),Zs=r(),Pe=i("div"),h(uo.$$.fragment),Aa=r(),Nn=i("p"),Nn.textContent=sl,Ns=r(),h(fo.$$.fragment),Ws=r(),Ce=i("div"),h(_o.$$.fragment),Oa=r(),Wn=i("p"),Wn.textContent=al,qs=r(),h(vo.$$.fragment),Bs=r(),xe=i("div"),h(bo.$$.fragment),Ya=r(),qn=i("p"),qn.textContent=il,Ds=r(),h(yo.$$.fragment),Rs=r(),z=i("div"),h(Mo.$$.fragment),Qa=r(),Bn=i("p"),Bn.textContent=cl,Ka=r(),h(Be.$$.fragment),ei=r(),Dn=i("p"),Dn.innerHTML=ll,ti=r(),Rn=i("p"),Rn.innerHTML=dl,oi=r(),H=i("div"),h(To.$$.fragment),ni=r(),Ln=i("p"),Ln.innerHTML=ml,ri=r(),h(De.$$.fragment),si=r(),h(Re.$$.fragment),Ls=r(),h(wo.$$.fragment),Gs=r(),W=i("div"),h(Po.$$.fragment),ai=r(),Gn=i("p"),Gn.textContent=pl,ii=r(),Vn=i("p"),Vn.innerHTML=hl,ci=r(),Hn=i("p"),Hn.innerHTML=gl,li=r(),E=i("div"),h(Co.$$.fragment),di=r(),En=i("p"),En.innerHTML=ul,mi=r(),h(Le.$$.fragment),pi=r(),h(Ge.$$.fragment),Vs=r(),h(xo.$$.fragment),Hs=r(),q=i("div"),h($o.$$.fragment),hi=r(),Sn=i("p"),Sn.textContent=fl,gi=r(),Xn=i("p"),Xn.innerHTML=_l,ui=r(),An=i("p"),An.innerHTML=vl,fi=r(),S=i("div"),h(ko.$$.fragment),_i=r(),On=i("p"),On.innerHTML=bl,vi=r(),h(Ve.$$.fragment),bi=r(),h(He.$$.fragment),Es=r(),h(jo.$$.fragment),Ss=r(),I=i("div"),h(Io.$$.fragment),yi=r(),Yn=i("p"),Yn.textContent=yl,Mi=r(),Qn=i("p"),Qn.textContent=Ml,Ti=r(),Kn=i("p"),Kn.innerHTML=Tl,wi=r(),er=i("p"),er.innerHTML=wl,Pi=r(),tr=i("p"),tr.innerHTML=Pl,Ci=r(),X=i("div"),h(Fo.$$.fragment),xi=r(),or=i("p"),or.innerHTML=Cl,$i=r(),h(Ee.$$.fragment),ki=r(),h(Se.$$.fragment),Xs=r(),h(Uo.$$.fragment),As=r(),F=i("div"),h(Jo.$$.fragment),ji=r(),nr=i("p"),nr.textContent=xl,Ii=r(),rr=i("p"),rr.textContent=$l,Fi=r(),sr=i("p"),sr.innerHTML=kl,Ui=r(),ar=i("p"),ar.innerHTML=jl,Ji=r(),ir=i("p"),ir.innerHTML=Il,zi=r(),A=i("div"),h(zo.$$.fragment),Zi=r(),cr=i("p"),cr.innerHTML=Fl,Ni=r(),h(Xe.$$.fragment),Wi=r(),h(Ae.$$.fragment),Os=r(),h(Zo.$$.fragment),Ys=r(),U=i("div"),h(No.$$.fragment),qi=r(),lr=i("p"),lr.textContent=Ul,Bi=r(),dr=i("p"),dr.textContent=Jl,Di=r(),mr=i("p"),mr.innerHTML=zl,Ri=r(),pr=i("p"),pr.innerHTML=Zl,Li=r(),hr=i("p"),hr.innerHTML=Nl,Gi=r(),O=i("div"),h(Wo.$$.fragment),Vi=r(),gr=i("p"),gr.innerHTML=Wl,Hi=r(),h(Oe.$$.fragment),Ei=r(),h(Ye.$$.fragment),Qs=r(),h(qo.$$.fragment),Ks=r(),Z=i("div"),h(Bo.$$.fragment),Si=r(),ur=i("p"),ur.innerHTML=ql,Xi=r(),fr=i("p"),fr.textContent=Bl,Ai=r(),_r=i("p"),_r.innerHTML=Dl,Oi=r(),vr=i("p"),vr.innerHTML=Rl,Yi=r(),Y=i("div"),h(Do.$$.fragment),Qi=r(),br=i("p"),br.innerHTML=Ll,Ki=r(),h(Qe.$$.fragment),ec=r(),h(Ke.$$.fragment),ea=r(),h(Ro.$$.fragment),ta=r(),k=i("div"),h(Lo.$$.fragment),tc=r(),yr=i("p"),yr.textContent=Gl,oc=r(),Mr=i("p"),Mr.innerHTML=Vl,nc=r(),Tr=i("p"),Tr.innerHTML=Hl,rc=r(),wr=i("p"),wr.innerHTML=El,sc=r(),Pr=i("p"),Pr.innerHTML=Sl,ac=r(),Cr=i("p"),Cr.textContent=Xl,ic=r(),xr=i("p"),xr.innerHTML=Al,cc=r(),$r=i("p"),$r.innerHTML=Ol,lc=r(),Q=i("div"),h(Go.$$.fragment),dc=r(),kr=i("p"),kr.innerHTML=Yl,mc=r(),h(et.$$.fragment),pc=r(),h(tt.$$.fragment),oa=r(),h(Vo.$$.fragment),na=r(),Fr=i("p"),this.h()},l(e){const t=nd("svelte-u9bgzb",document.head);a=c(t,"META",{name:!0,content:!0}),t.forEach(o),y=s(e),p=c(e,"P",{}),w(p).forEach(o),b=s(e),g(M.$$.fragment,e),d=s(e),P=c(e,"DIV",{class:!0,"data-svelte-h":!0}),m(P)!=="svelte-13t8s2t"&&(P.innerHTML=hc),Jr=s(e),g(dt.$$.fragment,e),zr=s(e),mt=c(e,"P",{"data-svelte-h":!0}),m(mt)!=="svelte-1q9pjug"&&(mt.innerHTML=gc),Zr=s(e),pt=c(e,"P",{"data-svelte-h":!0}),m(pt)!=="svelte-tt6rit"&&(pt.innerHTML=uc),Nr=s(e),ht=c(e,"P",{"data-svelte-h":!0}),m(ht)!=="svelte-vfdo9a"&&(ht.textContent=fc),Wr=s(e),gt=c(e,"P",{"data-svelte-h":!0}),m(gt)!=="svelte-1jljul4"&&(gt.innerHTML=_c),qr=s(e),ut=c(e,"P",{"data-svelte-h":!0}),m(ut)!=="svelte-l4zudt"&&(ut.textContent=vc),Br=s(e),ft=c(e,"P",{"data-svelte-h":!0}),m(ft)!=="svelte-12eh3gr"&&(ft.textContent=bc),Dr=s(e),_t=c(e,"P",{"data-svelte-h":!0}),m(_t)!=="svelte-wb5zf5"&&(_t.innerHTML=yc),Rr=s(e),vt=c(e,"P",{"data-svelte-h":!0}),m(vt)!=="svelte-490sb6"&&(vt.textContent=Mc),Lr=s(e),bt=c(e,"P",{"data-svelte-h":!0}),m(bt)!=="svelte-9ljddx"&&(bt.innerHTML=Tc),Gr=s(e),Je=c(e,"IMG",{src:!0,alt:!0,width:!0}),Vr=s(e),yt=c(e,"SMALL",{"data-svelte-h":!0}),m(yt)!=="svelte-d9mm9q"&&(yt.innerHTML=Pc),Hr=s(e),Mt=c(e,"P",{"data-svelte-h":!0}),m(Mt)!=="svelte-1mhzktt"&&(Mt.innerHTML=Cc),Er=s(e),g(ze.$$.fragment,e),Sr=s(e),g(Tt.$$.fragment,e),Xr=s(e),wt=c(e,"UL",{"data-svelte-h":!0}),m(wt)!=="svelte-7v41tc"&&(wt.innerHTML=xc),Ar=s(e),g(Pt.$$.fragment,e),Or=s(e),pe=c(e,"DIV",{class:!0});var Ho=w(pe);g(Ct.$$.fragment,Ho),pa=s(Ho),on=c(Ho,"P",{"data-svelte-h":!0}),m(on)!=="svelte-13fgwy5"&&(on.textContent=$c),Ho.forEach(o),Yr=s(e),he=c(e,"DIV",{class:!0});var Eo=w(he);g(xt.$$.fragment,Eo),ha=s(Eo),nn=c(Eo,"P",{"data-svelte-h":!0}),m(nn)!=="svelte-19jhdk9"&&(nn.textContent=kc),Eo.forEach(o),Qr=s(e),ge=c(e,"DIV",{class:!0});var So=w(ge);g($t.$$.fragment,So),ga=s(So),rn=c(So,"P",{"data-svelte-h":!0}),m(rn)!=="svelte-m841rf"&&(rn.textContent=jc),So.forEach(o),Kr=s(e),ue=c(e,"DIV",{class:!0});var Xo=w(ue);g(kt.$$.fragment,Xo),ua=s(Xo),sn=c(Xo,"P",{"data-svelte-h":!0}),m(sn)!=="svelte-soa7d4"&&(sn.textContent=Ic),Xo.forEach(o),es=s(e),g(jt.$$.fragment,e),ts=s(e),L=c(e,"DIV",{class:!0});var ie=w(L);g(It.$$.fragment,ie),fa=s(ie),an=c(ie,"P",{"data-svelte-h":!0}),m(an)!=="svelte-16vc34i"&&(an.innerHTML=Fc),_a=s(ie),cn=c(ie,"P",{"data-svelte-h":!0}),m(cn)!=="svelte-o55m63"&&(cn.innerHTML=Uc),va=s(ie),g(Ze.$$.fragment,ie),ie.forEach(o),os=s(e),g(Ft.$$.fragment,e),ns=s(e),G=c(e,"DIV",{class:!0});var ce=w(G);g(Ut.$$.fragment,ce),ba=s(ce),ln=c(ce,"P",{"data-svelte-h":!0}),m(ln)!=="svelte-qvnww0"&&(ln.textContent=Jc),ya=s(ce),dn=c(ce,"P",{"data-svelte-h":!0}),m(dn)!=="svelte-1c3t5ty"&&(dn.innerHTML=zc),Ma=s(ce),Ne=c(ce,"DIV",{class:!0});var Ao=w(Ne);g(Jt.$$.fragment,Ao),Ta=s(Ao),mn=c(Ao,"P",{"data-svelte-h":!0}),m(mn)!=="svelte-kpxj0c"&&(mn.textContent=Zc),Ao.forEach(o),ce.forEach(o),rs=s(e),g(zt.$$.fragment,e),ss=s(e),fe=c(e,"DIV",{class:!0});var Oo=w(fe);g(Zt.$$.fragment,Oo),wa=s(Oo),We=c(Oo,"DIV",{class:!0});var Yo=w(We);g(Nt.$$.fragment,Yo),Pa=s(Yo),pn=c(Yo,"P",{"data-svelte-h":!0}),m(pn)!=="svelte-khengj"&&(pn.textContent=Nc),Yo.forEach(o),Oo.forEach(o),as=s(e),g(Wt.$$.fragment,e),is=s(e),te=c(e,"DIV",{class:!0});var $e=w(te);g(qt.$$.fragment,$e),Ca=s($e),hn=c($e,"P",{"data-svelte-h":!0}),m(hn)!=="svelte-2cuwar"&&(hn.textContent=Wc),xa=s($e),qe=c($e,"DIV",{class:!0});var Qo=w(qe);g(Bt.$$.fragment,Qo),$a=s(Qo),gn=c(Qo,"P",{"data-svelte-h":!0}),m(gn)!=="svelte-1x3yxsa"&&(gn.textContent=qc),Qo.forEach(o),$e.forEach(o),cs=s(e),g(Dt.$$.fragment,e),ls=s(e),N=c(e,"DIV",{class:!0});var V=w(N);g(Rt.$$.fragment,V),ka=s(V),un=c(V,"P",{"data-svelte-h":!0}),m(un)!=="svelte-duco91"&&(un.textContent=Bc),ja=s(V),fn=c(V,"P",{"data-svelte-h":!0}),m(fn)!=="svelte-7883m0"&&(fn.innerHTML=Dc),Ia=s(V),_n=c(V,"UL",{"data-svelte-h":!0}),m(_n)!=="svelte-1qslv4f"&&(_n.innerHTML=Rc),Fa=s(V),vn=c(V,"DIV",{class:!0});var Ur=w(vn);g(Lt.$$.fragment,Ur),Ur.forEach(o),V.forEach(o),ds=s(e),g(Gt.$$.fragment,e),ms=s(e),oe=c(e,"DIV",{class:!0});var ke=w(oe);g(Vt.$$.fragment,ke),Ua=s(ke),bn=c(ke,"P",{"data-svelte-h":!0}),m(bn)!=="svelte-14oxh6f"&&(bn.innerHTML=Lc),Ja=s(ke),yn=c(ke,"P",{"data-svelte-h":!0}),m(yn)!=="svelte-10ewy9s"&&(yn.innerHTML=Gc),ke.forEach(o),ps=s(e),g(Ht.$$.fragment,e),hs=s(e),ne=c(e,"DIV",{class:!0});var je=w(ne);g(Et.$$.fragment,je),za=s(je),Mn=c(je,"P",{"data-svelte-h":!0}),m(Mn)!=="svelte-qqdw41"&&(Mn.textContent=Vc),Za=s(je),Tn=c(je,"P",{"data-svelte-h":!0}),m(Tn)!=="svelte-8bldbv"&&(Tn.innerHTML=Hc),je.forEach(o),gs=s(e),g(St.$$.fragment,e),us=s(e),_e=c(e,"DIV",{class:!0});var Ko=w(_e);g(Xt.$$.fragment,Ko),Na=s(Ko),wn=c(Ko,"P",{"data-svelte-h":!0}),m(wn)!=="svelte-dy213u"&&(wn.textContent=Ec),Ko.forEach(o),fs=s(e),g(At.$$.fragment,e),_s=s(e),ve=c(e,"DIV",{class:!0});var en=w(ve);g(Ot.$$.fragment,en),Wa=s(en),Pn=c(en,"P",{"data-svelte-h":!0}),m(Pn)!=="svelte-yuiep6"&&(Pn.textContent=Sc),en.forEach(o),vs=s(e),g(Yt.$$.fragment,e),bs=s(e),re=c(e,"DIV",{class:!0});var Ie=w(re);g(Qt.$$.fragment,Ie),qa=s(Ie),Cn=c(Ie,"P",{"data-svelte-h":!0}),m(Cn)!=="svelte-1ktcovi"&&(Cn.textContent=Xc),Ba=s(Ie),xn=c(Ie,"P",{"data-svelte-h":!0}),m(xn)!=="svelte-6kslc1"&&(xn.textContent=Ac),Ie.forEach(o),ys=s(e),g(Kt.$$.fragment,e),Ms=s(e),be=c(e,"DIV",{class:!0});var tn=w(be);g(eo.$$.fragment,tn),Da=s(tn),$n=c(tn,"P",{"data-svelte-h":!0}),m($n)!=="svelte-y6ydlz"&&($n.textContent=Oc),tn.forEach(o),Ts=s(e),g(to.$$.fragment,e),ws=s(e),se=c(e,"DIV",{class:!0});var jr=w(se);g(oo.$$.fragment,jr),Ra=s(jr),kn=c(jr,"P",{"data-svelte-h":!0}),m(kn)!=="svelte-1kkn2my"&&(kn.textContent=Yc),La=s(jr),jn=c(jr,"P",{"data-svelte-h":!0}),m(jn)!=="svelte-1rw0gn5"&&(jn.textContent=Qc),jr.forEach(o),Ps=s(e),g(no.$$.fragment,e),Cs=s(e),ye=c(e,"DIV",{class:!0});var sa=w(ye);g(ro.$$.fragment,sa),Ga=s(sa),In=c(sa,"P",{"data-svelte-h":!0}),m(In)!=="svelte-2naf7r"&&(In.innerHTML=Kc),sa.forEach(o),xs=s(e),g(so.$$.fragment,e),$s=s(e),Me=c(e,"DIV",{class:!0});var aa=w(Me);g(ao.$$.fragment,aa),Va=s(aa),Fn=c(aa,"P",{"data-svelte-h":!0}),m(Fn)!=="svelte-5i43m6"&&(Fn.textContent=el),aa.forEach(o),ks=s(e),g(io.$$.fragment,e),js=s(e),Te=c(e,"DIV",{class:!0});var ia=w(Te);g(co.$$.fragment,ia),Ha=s(ia),Un=c(ia,"P",{"data-svelte-h":!0}),m(Un)!=="svelte-ker3kf"&&(Un.innerHTML=tl),ia.forEach(o),Is=s(e),g(lo.$$.fragment,e),Fs=s(e),ae=c(e,"DIV",{class:!0});var Ir=w(ae);g(mo.$$.fragment,Ir),Ea=s(Ir),Jn=c(Ir,"P",{"data-svelte-h":!0}),m(Jn)!=="svelte-bcnwvf"&&(Jn.innerHTML=ol),Sa=s(Ir),zn=c(Ir,"P",{"data-svelte-h":!0}),m(zn)!=="svelte-1hdadgl"&&(zn.textContent=nl),Ir.forEach(o),Us=s(e),g(po.$$.fragment,e),Js=s(e),we=c(e,"DIV",{class:!0});var ca=w(we);g(ho.$$.fragment,ca),Xa=s(ca),Zn=c(ca,"P",{"data-svelte-h":!0}),m(Zn)!=="svelte-ko0545"&&(Zn.textContent=rl),ca.forEach(o),zs=s(e),g(go.$$.fragment,e),Zs=s(e),Pe=c(e,"DIV",{class:!0});var la=w(Pe);g(uo.$$.fragment,la),Aa=s(la),Nn=c(la,"P",{"data-svelte-h":!0}),m(Nn)!=="svelte-19fogj5"&&(Nn.textContent=sl),la.forEach(o),Ns=s(e),g(fo.$$.fragment,e),Ws=s(e),Ce=c(e,"DIV",{class:!0});var da=w(Ce);g(_o.$$.fragment,da),Oa=s(da),Wn=c(da,"P",{"data-svelte-h":!0}),m(Wn)!=="svelte-1kv6g6a"&&(Wn.textContent=al),da.forEach(o),qs=s(e),g(vo.$$.fragment,e),Bs=s(e),xe=c(e,"DIV",{class:!0});var ma=w(xe);g(bo.$$.fragment,ma),Ya=s(ma),qn=c(ma,"P",{"data-svelte-h":!0}),m(qn)!=="svelte-16bd8vx"&&(qn.textContent=il),ma.forEach(o),Ds=s(e),g(yo.$$.fragment,e),Rs=s(e),z=c(e,"DIV",{class:!0});var K=w(z);g(Mo.$$.fragment,K),Qa=s(K),Bn=c(K,"P",{"data-svelte-h":!0}),m(Bn)!=="svelte-jeiqrc"&&(Bn.textContent=cl),Ka=s(K),g(Be.$$.fragment,K),ei=s(K),Dn=c(K,"P",{"data-svelte-h":!0}),m(Dn)!=="svelte-6pahdo"&&(Dn.innerHTML=ll),ti=s(K),Rn=c(K,"P",{"data-svelte-h":!0}),m(Rn)!=="svelte-hswkmf"&&(Rn.innerHTML=dl),oi=s(K),H=c(K,"DIV",{class:!0});var ot=w(H);g(To.$$.fragment,ot),ni=s(ot),Ln=c(ot,"P",{"data-svelte-h":!0}),m(Ln)!=="svelte-bbo544"&&(Ln.innerHTML=ml),ri=s(ot),g(De.$$.fragment,ot),si=s(ot),g(Re.$$.fragment,ot),ot.forEach(o),K.forEach(o),Ls=s(e),g(wo.$$.fragment,e),Gs=s(e),W=c(e,"DIV",{class:!0});var le=w(W);g(Po.$$.fragment,le),ai=s(le),Gn=c(le,"P",{"data-svelte-h":!0}),m(Gn)!=="svelte-1ywli4"&&(Gn.textContent=pl),ii=s(le),Vn=c(le,"P",{"data-svelte-h":!0}),m(Vn)!=="svelte-6pahdo"&&(Vn.innerHTML=hl),ci=s(le),Hn=c(le,"P",{"data-svelte-h":!0}),m(Hn)!=="svelte-hswkmf"&&(Hn.innerHTML=gl),li=s(le),E=c(le,"DIV",{class:!0});var nt=w(E);g(Co.$$.fragment,nt),di=s(nt),En=c(nt,"P",{"data-svelte-h":!0}),m(En)!=="svelte-1i9anqc"&&(En.innerHTML=ul),mi=s(nt),g(Le.$$.fragment,nt),pi=s(nt),g(Ge.$$.fragment,nt),nt.forEach(o),le.forEach(o),Vs=s(e),g(xo.$$.fragment,e),Hs=s(e),q=c(e,"DIV",{class:!0});var de=w(q);g($o.$$.fragment,de),hi=s(de),Sn=c(de,"P",{"data-svelte-h":!0}),m(Sn)!=="svelte-1cf36qj"&&(Sn.textContent=fl),gi=s(de),Xn=c(de,"P",{"data-svelte-h":!0}),m(Xn)!=="svelte-6pahdo"&&(Xn.innerHTML=_l),ui=s(de),An=c(de,"P",{"data-svelte-h":!0}),m(An)!=="svelte-hswkmf"&&(An.innerHTML=vl),fi=s(de),S=c(de,"DIV",{class:!0});var rt=w(S);g(ko.$$.fragment,rt),_i=s(rt),On=c(rt,"P",{"data-svelte-h":!0}),m(On)!=="svelte-xw807e"&&(On.innerHTML=bl),vi=s(rt),g(Ve.$$.fragment,rt),bi=s(rt),g(He.$$.fragment,rt),rt.forEach(o),de.forEach(o),Es=s(e),g(jo.$$.fragment,e),Ss=s(e),I=c(e,"DIV",{class:!0});var B=w(I);g(Io.$$.fragment,B),yi=s(B),Yn=c(B,"P",{"data-svelte-h":!0}),m(Yn)!=="svelte-14sixf"&&(Yn.textContent=yl),Mi=s(B),Qn=c(B,"P",{"data-svelte-h":!0}),m(Qn)!=="svelte-7wi9f7"&&(Qn.textContent=Ml),Ti=s(B),Kn=c(B,"P",{"data-svelte-h":!0}),m(Kn)!=="svelte-186j94c"&&(Kn.innerHTML=Tl),wi=s(B),er=c(B,"P",{"data-svelte-h":!0}),m(er)!=="svelte-6pahdo"&&(er.innerHTML=wl),Pi=s(B),tr=c(B,"P",{"data-svelte-h":!0}),m(tr)!=="svelte-hswkmf"&&(tr.innerHTML=Pl),Ci=s(B),X=c(B,"DIV",{class:!0});var st=w(X);g(Fo.$$.fragment,st),xi=s(st),or=c(st,"P",{"data-svelte-h":!0}),m(or)!=="svelte-1vqh0cs"&&(or.innerHTML=Cl),$i=s(st),g(Ee.$$.fragment,st),ki=s(st),g(Se.$$.fragment,st),st.forEach(o),B.forEach(o),Xs=s(e),g(Uo.$$.fragment,e),As=s(e),F=c(e,"DIV",{class:!0});var D=w(F);g(Jo.$$.fragment,D),ji=s(D),nr=c(D,"P",{"data-svelte-h":!0}),m(nr)!=="svelte-14sixf"&&(nr.textContent=xl),Ii=s(D),rr=c(D,"P",{"data-svelte-h":!0}),m(rr)!=="svelte-8ozzz2"&&(rr.textContent=$l),Fi=s(D),sr=c(D,"P",{"data-svelte-h":!0}),m(sr)!=="svelte-m4n2j9"&&(sr.innerHTML=kl),Ui=s(D),ar=c(D,"P",{"data-svelte-h":!0}),m(ar)!=="svelte-6pahdo"&&(ar.innerHTML=jl),Ji=s(D),ir=c(D,"P",{"data-svelte-h":!0}),m(ir)!=="svelte-hswkmf"&&(ir.innerHTML=Il),zi=s(D),A=c(D,"DIV",{class:!0});var at=w(A);g(zo.$$.fragment,at),Zi=s(at),cr=c(at,"P",{"data-svelte-h":!0}),m(cr)!=="svelte-1ww2kje"&&(cr.innerHTML=Fl),Ni=s(at),g(Xe.$$.fragment,at),Wi=s(at),g(Ae.$$.fragment,at),at.forEach(o),D.forEach(o),Os=s(e),g(Zo.$$.fragment,e),Ys=s(e),U=c(e,"DIV",{class:!0});var R=w(U);g(No.$$.fragment,R),qi=s(R),lr=c(R,"P",{"data-svelte-h":!0}),m(lr)!=="svelte-14sixf"&&(lr.textContent=Ul),Bi=s(R),dr=c(R,"P",{"data-svelte-h":!0}),m(dr)!=="svelte-tp3lrm"&&(dr.textContent=Jl),Di=s(R),mr=c(R,"P",{"data-svelte-h":!0}),m(mr)!=="svelte-1jqmhdk"&&(mr.innerHTML=zl),Ri=s(R),pr=c(R,"P",{"data-svelte-h":!0}),m(pr)!=="svelte-6pahdo"&&(pr.innerHTML=Zl),Li=s(R),hr=c(R,"P",{"data-svelte-h":!0}),m(hr)!=="svelte-hswkmf"&&(hr.innerHTML=Nl),Gi=s(R),O=c(R,"DIV",{class:!0});var it=w(O);g(Wo.$$.fragment,it),Vi=s(it),gr=c(it,"P",{"data-svelte-h":!0}),m(gr)!=="svelte-1q75rzw"&&(gr.innerHTML=Wl),Hi=s(it),g(Oe.$$.fragment,it),Ei=s(it),g(Ye.$$.fragment,it),it.forEach(o),R.forEach(o),Qs=s(e),g(qo.$$.fragment,e),Ks=s(e),Z=c(e,"DIV",{class:!0});var ee=w(Z);g(Bo.$$.fragment,ee),Si=s(ee),ur=c(ee,"P",{"data-svelte-h":!0}),m(ur)!=="svelte-10ms8rq"&&(ur.innerHTML=ql),Xi=s(ee),fr=c(ee,"P",{"data-svelte-h":!0}),m(fr)!=="svelte-15z6y2c"&&(fr.textContent=Bl),Ai=s(ee),_r=c(ee,"P",{"data-svelte-h":!0}),m(_r)!=="svelte-6pahdo"&&(_r.innerHTML=Dl),Oi=s(ee),vr=c(ee,"P",{"data-svelte-h":!0}),m(vr)!=="svelte-hswkmf"&&(vr.innerHTML=Rl),Yi=s(ee),Y=c(ee,"DIV",{class:!0});var ct=w(Y);g(Do.$$.fragment,ct),Qi=s(ct),br=c(ct,"P",{"data-svelte-h":!0}),m(br)!=="svelte-1ksfz70"&&(br.innerHTML=Ll),Ki=s(ct),g(Qe.$$.fragment,ct),ec=s(ct),g(Ke.$$.fragment,ct),ct.forEach(o),ee.forEach(o),ea=s(e),g(Ro.$$.fragment,e),ta=s(e),k=c(e,"DIV",{class:!0});var j=w(k);g(Lo.$$.fragment,j),tc=s(j),yr=c(j,"P",{"data-svelte-h":!0}),m(yr)!=="svelte-1oaen3m"&&(yr.textContent=Gl),oc=s(j),Mr=c(j,"P",{"data-svelte-h":!0}),m(Mr)!=="svelte-1z5l98"&&(Mr.innerHTML=Vl),nc=s(j),Tr=c(j,"P",{"data-svelte-h":!0}),m(Tr)!=="svelte-a602dh"&&(Tr.innerHTML=Hl),rc=s(j),wr=c(j,"P",{"data-svelte-h":!0}),m(wr)!=="svelte-slizoj"&&(wr.innerHTML=El),sc=s(j),Pr=c(j,"P",{"data-svelte-h":!0}),m(Pr)!=="svelte-1hs9g1p"&&(Pr.innerHTML=Sl),ac=s(j),Cr=c(j,"P",{"data-svelte-h":!0}),m(Cr)!=="svelte-1ic9umv"&&(Cr.textContent=Xl),ic=s(j),xr=c(j,"P",{"data-svelte-h":!0}),m(xr)!=="svelte-6pahdo"&&(xr.innerHTML=Al),cc=s(j),$r=c(j,"P",{"data-svelte-h":!0}),m($r)!=="svelte-hswkmf"&&($r.innerHTML=Ol),lc=s(j),Q=c(j,"DIV",{class:!0});var lt=w(Q);g(Go.$$.fragment,lt),dc=s(lt),kr=c(lt,"P",{"data-svelte-h":!0}),m(kr)!=="svelte-8u2iso"&&(kr.innerHTML=Yl),mc=s(lt),g(et.$$.fragment,lt),pc=s(lt),g(tt.$$.fragment,lt),lt.forEach(o),j.forEach(o),oa=s(e),g(Vo.$$.fragment,e),na=s(e),Fr=c(e,"P",{}),w(Fr).forEach(o),this.h()},h(){T(a,"name","hf:doc:metadata"),T(a,"content",Cd),T(P,"class","flex flex-wrap space-x-1"),Kl(Je.src,wc="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/perceiver_architecture.jpg")||T(Je,"src",wc),T(Je,"alt","drawing"),T(Je,"width","600"),T(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(We,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(vn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(we,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){n(document.head,a),l(e,y,t),l(e,p,t),l(e,b,t),u(M,e,t),l(e,d,t),l(e,P,t),l(e,Jr,t),u(dt,e,t),l(e,zr,t),l(e,mt,t),l(e,Zr,t),l(e,pt,t),l(e,Nr,t),l(e,ht,t),l(e,Wr,t),l(e,gt,t),l(e,qr,t),l(e,ut,t),l(e,Br,t),l(e,ft,t),l(e,Dr,t),l(e,_t,t),l(e,Rr,t),l(e,vt,t),l(e,Lr,t),l(e,bt,t),l(e,Gr,t),l(e,Je,t),l(e,Vr,t),l(e,yt,t),l(e,Hr,t),l(e,Mt,t),l(e,Er,t),u(ze,e,t),l(e,Sr,t),u(Tt,e,t),l(e,Xr,t),l(e,wt,t),l(e,Ar,t),u(Pt,e,t),l(e,Or,t),l(e,pe,t),u(Ct,pe,null),n(pe,pa),n(pe,on),l(e,Yr,t),l(e,he,t),u(xt,he,null),n(he,ha),n(he,nn),l(e,Qr,t),l(e,ge,t),u($t,ge,null),n(ge,ga),n(ge,rn),l(e,Kr,t),l(e,ue,t),u(kt,ue,null),n(ue,ua),n(ue,sn),l(e,es,t),u(jt,e,t),l(e,ts,t),l(e,L,t),u(It,L,null),n(L,fa),n(L,an),n(L,_a),n(L,cn),n(L,va),u(Ze,L,null),l(e,os,t),u(Ft,e,t),l(e,ns,t),l(e,G,t),u(Ut,G,null),n(G,ba),n(G,ln),n(G,ya),n(G,dn),n(G,Ma),n(G,Ne),u(Jt,Ne,null),n(Ne,Ta),n(Ne,mn),l(e,rs,t),u(zt,e,t),l(e,ss,t),l(e,fe,t),u(Zt,fe,null),n(fe,wa),n(fe,We),u(Nt,We,null),n(We,Pa),n(We,pn),l(e,as,t),u(Wt,e,t),l(e,is,t),l(e,te,t),u(qt,te,null),n(te,Ca),n(te,hn),n(te,xa),n(te,qe),u(Bt,qe,null),n(qe,$a),n(qe,gn),l(e,cs,t),u(Dt,e,t),l(e,ls,t),l(e,N,t),u(Rt,N,null),n(N,ka),n(N,un),n(N,ja),n(N,fn),n(N,Ia),n(N,_n),n(N,Fa),n(N,vn),u(Lt,vn,null),l(e,ds,t),u(Gt,e,t),l(e,ms,t),l(e,oe,t),u(Vt,oe,null),n(oe,Ua),n(oe,bn),n(oe,Ja),n(oe,yn),l(e,ps,t),u(Ht,e,t),l(e,hs,t),l(e,ne,t),u(Et,ne,null),n(ne,za),n(ne,Mn),n(ne,Za),n(ne,Tn),l(e,gs,t),u(St,e,t),l(e,us,t),l(e,_e,t),u(Xt,_e,null),n(_e,Na),n(_e,wn),l(e,fs,t),u(At,e,t),l(e,_s,t),l(e,ve,t),u(Ot,ve,null),n(ve,Wa),n(ve,Pn),l(e,vs,t),u(Yt,e,t),l(e,bs,t),l(e,re,t),u(Qt,re,null),n(re,qa),n(re,Cn),n(re,Ba),n(re,xn),l(e,ys,t),u(Kt,e,t),l(e,Ms,t),l(e,be,t),u(eo,be,null),n(be,Da),n(be,$n),l(e,Ts,t),u(to,e,t),l(e,ws,t),l(e,se,t),u(oo,se,null),n(se,Ra),n(se,kn),n(se,La),n(se,jn),l(e,Ps,t),u(no,e,t),l(e,Cs,t),l(e,ye,t),u(ro,ye,null),n(ye,Ga),n(ye,In),l(e,xs,t),u(so,e,t),l(e,$s,t),l(e,Me,t),u(ao,Me,null),n(Me,Va),n(Me,Fn),l(e,ks,t),u(io,e,t),l(e,js,t),l(e,Te,t),u(co,Te,null),n(Te,Ha),n(Te,Un),l(e,Is,t),u(lo,e,t),l(e,Fs,t),l(e,ae,t),u(mo,ae,null),n(ae,Ea),n(ae,Jn),n(ae,Sa),n(ae,zn),l(e,Us,t),u(po,e,t),l(e,Js,t),l(e,we,t),u(ho,we,null),n(we,Xa),n(we,Zn),l(e,zs,t),u(go,e,t),l(e,Zs,t),l(e,Pe,t),u(uo,Pe,null),n(Pe,Aa),n(Pe,Nn),l(e,Ns,t),u(fo,e,t),l(e,Ws,t),l(e,Ce,t),u(_o,Ce,null),n(Ce,Oa),n(Ce,Wn),l(e,qs,t),u(vo,e,t),l(e,Bs,t),l(e,xe,t),u(bo,xe,null),n(xe,Ya),n(xe,qn),l(e,Ds,t),u(yo,e,t),l(e,Rs,t),l(e,z,t),u(Mo,z,null),n(z,Qa),n(z,Bn),n(z,Ka),u(Be,z,null),n(z,ei),n(z,Dn),n(z,ti),n(z,Rn),n(z,oi),n(z,H),u(To,H,null),n(H,ni),n(H,Ln),n(H,ri),u(De,H,null),n(H,si),u(Re,H,null),l(e,Ls,t),u(wo,e,t),l(e,Gs,t),l(e,W,t),u(Po,W,null),n(W,ai),n(W,Gn),n(W,ii),n(W,Vn),n(W,ci),n(W,Hn),n(W,li),n(W,E),u(Co,E,null),n(E,di),n(E,En),n(E,mi),u(Le,E,null),n(E,pi),u(Ge,E,null),l(e,Vs,t),u(xo,e,t),l(e,Hs,t),l(e,q,t),u($o,q,null),n(q,hi),n(q,Sn),n(q,gi),n(q,Xn),n(q,ui),n(q,An),n(q,fi),n(q,S),u(ko,S,null),n(S,_i),n(S,On),n(S,vi),u(Ve,S,null),n(S,bi),u(He,S,null),l(e,Es,t),u(jo,e,t),l(e,Ss,t),l(e,I,t),u(Io,I,null),n(I,yi),n(I,Yn),n(I,Mi),n(I,Qn),n(I,Ti),n(I,Kn),n(I,wi),n(I,er),n(I,Pi),n(I,tr),n(I,Ci),n(I,X),u(Fo,X,null),n(X,xi),n(X,or),n(X,$i),u(Ee,X,null),n(X,ki),u(Se,X,null),l(e,Xs,t),u(Uo,e,t),l(e,As,t),l(e,F,t),u(Jo,F,null),n(F,ji),n(F,nr),n(F,Ii),n(F,rr),n(F,Fi),n(F,sr),n(F,Ui),n(F,ar),n(F,Ji),n(F,ir),n(F,zi),n(F,A),u(zo,A,null),n(A,Zi),n(A,cr),n(A,Ni),u(Xe,A,null),n(A,Wi),u(Ae,A,null),l(e,Os,t),u(Zo,e,t),l(e,Ys,t),l(e,U,t),u(No,U,null),n(U,qi),n(U,lr),n(U,Bi),n(U,dr),n(U,Di),n(U,mr),n(U,Ri),n(U,pr),n(U,Li),n(U,hr),n(U,Gi),n(U,O),u(Wo,O,null),n(O,Vi),n(O,gr),n(O,Hi),u(Oe,O,null),n(O,Ei),u(Ye,O,null),l(e,Qs,t),u(qo,e,t),l(e,Ks,t),l(e,Z,t),u(Bo,Z,null),n(Z,Si),n(Z,ur),n(Z,Xi),n(Z,fr),n(Z,Ai),n(Z,_r),n(Z,Oi),n(Z,vr),n(Z,Yi),n(Z,Y),u(Do,Y,null),n(Y,Qi),n(Y,br),n(Y,Ki),u(Qe,Y,null),n(Y,ec),u(Ke,Y,null),l(e,ea,t),u(Ro,e,t),l(e,ta,t),l(e,k,t),u(Lo,k,null),n(k,tc),n(k,yr),n(k,oc),n(k,Mr),n(k,nc),n(k,Tr),n(k,rc),n(k,wr),n(k,sc),n(k,Pr),n(k,ac),n(k,Cr),n(k,ic),n(k,xr),n(k,cc),n(k,$r),n(k,lc),n(k,Q),u(Go,Q,null),n(Q,dc),n(Q,kr),n(Q,mc),u(et,Q,null),n(Q,pc),u(tt,Q,null),l(e,oa,t),u(Vo,e,t),l(e,na,t),l(e,Fr,t),ra=!0},p(e,[t]){const Ho={};t&2&&(Ho.$$scope={dirty:t,ctx:e}),ze.$set(Ho);const Eo={};t&2&&(Eo.$$scope={dirty:t,ctx:e}),Ze.$set(Eo);const So={};t&2&&(So.$$scope={dirty:t,ctx:e}),Be.$set(So);const Xo={};t&2&&(Xo.$$scope={dirty:t,ctx:e}),De.$set(Xo);const ie={};t&2&&(ie.$$scope={dirty:t,ctx:e}),Re.$set(ie);const ce={};t&2&&(ce.$$scope={dirty:t,ctx:e}),Le.$set(ce);const Ao={};t&2&&(Ao.$$scope={dirty:t,ctx:e}),Ge.$set(Ao);const Oo={};t&2&&(Oo.$$scope={dirty:t,ctx:e}),Ve.$set(Oo);const Yo={};t&2&&(Yo.$$scope={dirty:t,ctx:e}),He.$set(Yo);const $e={};t&2&&($e.$$scope={dirty:t,ctx:e}),Ee.$set($e);const Qo={};t&2&&(Qo.$$scope={dirty:t,ctx:e}),Se.$set(Qo);const V={};t&2&&(V.$$scope={dirty:t,ctx:e}),Xe.$set(V);const Ur={};t&2&&(Ur.$$scope={dirty:t,ctx:e}),Ae.$set(Ur);const ke={};t&2&&(ke.$$scope={dirty:t,ctx:e}),Oe.$set(ke);const je={};t&2&&(je.$$scope={dirty:t,ctx:e}),Ye.$set(je);const Ko={};t&2&&(Ko.$$scope={dirty:t,ctx:e}),Qe.$set(Ko);const en={};t&2&&(en.$$scope={dirty:t,ctx:e}),Ke.$set(en);const Ie={};t&2&&(Ie.$$scope={dirty:t,ctx:e}),et.$set(Ie);const tn={};t&2&&(tn.$$scope={dirty:t,ctx:e}),tt.$set(tn)},i(e){ra||(f(M.$$.fragment,e),f(dt.$$.fragment,e),f(ze.$$.fragment,e),f(Tt.$$.fragment,e),f(Pt.$$.fragment,e),f(Ct.$$.fragment,e),f(xt.$$.fragment,e),f($t.$$.fragment,e),f(kt.$$.fragment,e),f(jt.$$.fragment,e),f(It.$$.fragment,e),f(Ze.$$.fragment,e),f(Ft.$$.fragment,e),f(Ut.$$.fragment,e),f(Jt.$$.fragment,e),f(zt.$$.fragment,e),f(Zt.$$.fragment,e),f(Nt.$$.fragment,e),f(Wt.$$.fragment,e),f(qt.$$.fragment,e),f(Bt.$$.fragment,e),f(Dt.$$.fragment,e),f(Rt.$$.fragment,e),f(Lt.$$.fragment,e),f(Gt.$$.fragment,e),f(Vt.$$.fragment,e),f(Ht.$$.fragment,e),f(Et.$$.fragment,e),f(St.$$.fragment,e),f(Xt.$$.fragment,e),f(At.$$.fragment,e),f(Ot.$$.fragment,e),f(Yt.$$.fragment,e),f(Qt.$$.fragment,e),f(Kt.$$.fragment,e),f(eo.$$.fragment,e),f(to.$$.fragment,e),f(oo.$$.fragment,e),f(no.$$.fragment,e),f(ro.$$.fragment,e),f(so.$$.fragment,e),f(ao.$$.fragment,e),f(io.$$.fragment,e),f(co.$$.fragment,e),f(lo.$$.fragment,e),f(mo.$$.fragment,e),f(po.$$.fragment,e),f(ho.$$.fragment,e),f(go.$$.fragment,e),f(uo.$$.fragment,e),f(fo.$$.fragment,e),f(_o.$$.fragment,e),f(vo.$$.fragment,e),f(bo.$$.fragment,e),f(yo.$$.fragment,e),f(Mo.$$.fragment,e),f(Be.$$.fragment,e),f(To.$$.fragment,e),f(De.$$.fragment,e),f(Re.$$.fragment,e),f(wo.$$.fragment,e),f(Po.$$.fragment,e),f(Co.$$.fragment,e),f(Le.$$.fragment,e),f(Ge.$$.fragment,e),f(xo.$$.fragment,e),f($o.$$.fragment,e),f(ko.$$.fragment,e),f(Ve.$$.fragment,e),f(He.$$.fragment,e),f(jo.$$.fragment,e),f(Io.$$.fragment,e),f(Fo.$$.fragment,e),f(Ee.$$.fragment,e),f(Se.$$.fragment,e),f(Uo.$$.fragment,e),f(Jo.$$.fragment,e),f(zo.$$.fragment,e),f(Xe.$$.fragment,e),f(Ae.$$.fragment,e),f(Zo.$$.fragment,e),f(No.$$.fragment,e),f(Wo.$$.fragment,e),f(Oe.$$.fragment,e),f(Ye.$$.fragment,e),f(qo.$$.fragment,e),f(Bo.$$.fragment,e),f(Do.$$.fragment,e),f(Qe.$$.fragment,e),f(Ke.$$.fragment,e),f(Ro.$$.fragment,e),f(Lo.$$.fragment,e),f(Go.$$.fragment,e),f(et.$$.fragment,e),f(tt.$$.fragment,e),f(Vo.$$.fragment,e),ra=!0)},o(e){_(M.$$.fragment,e),_(dt.$$.fragment,e),_(ze.$$.fragment,e),_(Tt.$$.fragment,e),_(Pt.$$.fragment,e),_(Ct.$$.fragment,e),_(xt.$$.fragment,e),_($t.$$.fragment,e),_(kt.$$.fragment,e),_(jt.$$.fragment,e),_(It.$$.fragment,e),_(Ze.$$.fragment,e),_(Ft.$$.fragment,e),_(Ut.$$.fragment,e),_(Jt.$$.fragment,e),_(zt.$$.fragment,e),_(Zt.$$.fragment,e),_(Nt.$$.fragment,e),_(Wt.$$.fragment,e),_(qt.$$.fragment,e),_(Bt.$$.fragment,e),_(Dt.$$.fragment,e),_(Rt.$$.fragment,e),_(Lt.$$.fragment,e),_(Gt.$$.fragment,e),_(Vt.$$.fragment,e),_(Ht.$$.fragment,e),_(Et.$$.fragment,e),_(St.$$.fragment,e),_(Xt.$$.fragment,e),_(At.$$.fragment,e),_(Ot.$$.fragment,e),_(Yt.$$.fragment,e),_(Qt.$$.fragment,e),_(Kt.$$.fragment,e),_(eo.$$.fragment,e),_(to.$$.fragment,e),_(oo.$$.fragment,e),_(no.$$.fragment,e),_(ro.$$.fragment,e),_(so.$$.fragment,e),_(ao.$$.fragment,e),_(io.$$.fragment,e),_(co.$$.fragment,e),_(lo.$$.fragment,e),_(mo.$$.fragment,e),_(po.$$.fragment,e),_(ho.$$.fragment,e),_(go.$$.fragment,e),_(uo.$$.fragment,e),_(fo.$$.fragment,e),_(_o.$$.fragment,e),_(vo.$$.fragment,e),_(bo.$$.fragment,e),_(yo.$$.fragment,e),_(Mo.$$.fragment,e),_(Be.$$.fragment,e),_(To.$$.fragment,e),_(De.$$.fragment,e),_(Re.$$.fragment,e),_(wo.$$.fragment,e),_(Po.$$.fragment,e),_(Co.$$.fragment,e),_(Le.$$.fragment,e),_(Ge.$$.fragment,e),_(xo.$$.fragment,e),_($o.$$.fragment,e),_(ko.$$.fragment,e),_(Ve.$$.fragment,e),_(He.$$.fragment,e),_(jo.$$.fragment,e),_(Io.$$.fragment,e),_(Fo.$$.fragment,e),_(Ee.$$.fragment,e),_(Se.$$.fragment,e),_(Uo.$$.fragment,e),_(Jo.$$.fragment,e),_(zo.$$.fragment,e),_(Xe.$$.fragment,e),_(Ae.$$.fragment,e),_(Zo.$$.fragment,e),_(No.$$.fragment,e),_(Wo.$$.fragment,e),_(Oe.$$.fragment,e),_(Ye.$$.fragment,e),_(qo.$$.fragment,e),_(Bo.$$.fragment,e),_(Do.$$.fragment,e),_(Qe.$$.fragment,e),_(Ke.$$.fragment,e),_(Ro.$$.fragment,e),_(Lo.$$.fragment,e),_(Go.$$.fragment,e),_(et.$$.fragment,e),_(tt.$$.fragment,e),_(Vo.$$.fragment,e),ra=!1},d(e){e&&(o(y),o(p),o(b),o(d),o(P),o(Jr),o(zr),o(mt),o(Zr),o(pt),o(Nr),o(ht),o(Wr),o(gt),o(qr),o(ut),o(Br),o(ft),o(Dr),o(_t),o(Rr),o(vt),o(Lr),o(bt),o(Gr),o(Je),o(Vr),o(yt),o(Hr),o(Mt),o(Er),o(Sr),o(Xr),o(wt),o(Ar),o(Or),o(pe),o(Yr),o(he),o(Qr),o(ge),o(Kr),o(ue),o(es),o(ts),o(L),o(os),o(ns),o(G),o(rs),o(ss),o(fe),o(as),o(is),o(te),o(cs),o(ls),o(N),o(ds),o(ms),o(oe),o(ps),o(hs),o(ne),o(gs),o(us),o(_e),o(fs),o(_s),o(ve),o(vs),o(bs),o(re),o(ys),o(Ms),o(be),o(Ts),o(ws),o(se),o(Ps),o(Cs),o(ye),o(xs),o($s),o(Me),o(ks),o(js),o(Te),o(Is),o(Fs),o(ae),o(Us),o(Js),o(we),o(zs),o(Zs),o(Pe),o(Ns),o(Ws),o(Ce),o(qs),o(Bs),o(xe),o(Ds),o(Rs),o(z),o(Ls),o(Gs),o(W),o(Vs),o(Hs),o(q),o(Es),o(Ss),o(I),o(Xs),o(As),o(F),o(Os),o(Ys),o(U),o(Qs),o(Ks),o(Z),o(ea),o(ta),o(k),o(oa),o(na),o(Fr)),o(a),v(M,e),v(dt,e),v(ze,e),v(Tt,e),v(Pt,e),v(Ct),v(xt),v($t),v(kt),v(jt,e),v(It),v(Ze),v(Ft,e),v(Ut),v(Jt),v(zt,e),v(Zt),v(Nt),v(Wt,e),v(qt),v(Bt),v(Dt,e),v(Rt),v(Lt),v(Gt,e),v(Vt),v(Ht,e),v(Et),v(St,e),v(Xt),v(At,e),v(Ot),v(Yt,e),v(Qt),v(Kt,e),v(eo),v(to,e),v(oo),v(no,e),v(ro),v(so,e),v(ao),v(io,e),v(co),v(lo,e),v(mo),v(po,e),v(ho),v(go,e),v(uo),v(fo,e),v(_o),v(vo,e),v(bo),v(yo,e),v(Mo),v(Be),v(To),v(De),v(Re),v(wo,e),v(Po),v(Co),v(Le),v(Ge),v(xo,e),v($o),v(ko),v(Ve),v(He),v(jo,e),v(Io),v(Fo),v(Ee),v(Se),v(Uo,e),v(Jo),v(zo),v(Xe),v(Ae),v(Zo,e),v(No),v(Wo),v(Oe),v(Ye),v(qo,e),v(Bo),v(Do),v(Qe),v(Ke),v(Ro,e),v(Lo),v(Go),v(et),v(tt),v(Vo,e)}}}const Cd='{"title":"Perceiver","local":"perceiver","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"Perceiver specific outputs","local":"transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput","sections":[],"depth":2},{"title":"PerceiverConfig","local":"transformers.PerceiverConfig","sections":[],"depth":2},{"title":"PerceiverTokenizer","local":"transformers.PerceiverTokenizer","sections":[],"depth":2},{"title":"PerceiverFeatureExtractor","local":"transformers.PerceiverFeatureExtractor","sections":[],"depth":2},{"title":"PerceiverImageProcessor","local":"transformers.PerceiverImageProcessor","sections":[],"depth":2},{"title":"PerceiverImageProcessorFast","local":"transformers.PerceiverImageProcessorFast","sections":[],"depth":2},{"title":"PerceiverTextPreprocessor","local":"transformers.models.perceiver.modeling_perceiver.PerceiverTextPreprocessor","sections":[],"depth":2},{"title":"PerceiverImagePreprocessor","local":"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor","sections":[],"depth":2},{"title":"PerceiverOneHotPreprocessor","local":"transformers.models.perceiver.modeling_perceiver.PerceiverOneHotPreprocessor","sections":[],"depth":2},{"title":"PerceiverAudioPreprocessor","local":"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor","sections":[],"depth":2},{"title":"PerceiverMultimodalPreprocessor","local":"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor","sections":[],"depth":2},{"title":"PerceiverProjectionDecoder","local":"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionDecoder","sections":[],"depth":2},{"title":"PerceiverBasicDecoder","local":"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder","sections":[],"depth":2},{"title":"PerceiverClassificationDecoder","local":"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder","sections":[],"depth":2},{"title":"PerceiverOpticalFlowDecoder","local":"transformers.models.perceiver.modeling_perceiver.PerceiverOpticalFlowDecoder","sections":[],"depth":2},{"title":"PerceiverBasicVideoAutoencodingDecoder","local":"transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder","sections":[],"depth":2},{"title":"PerceiverMultimodalDecoder","local":"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder","sections":[],"depth":2},{"title":"PerceiverProjectionPostprocessor","local":"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionPostprocessor","sections":[],"depth":2},{"title":"PerceiverAudioPostprocessor","local":"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor","sections":[],"depth":2},{"title":"PerceiverClassificationPostprocessor","local":"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationPostprocessor","sections":[],"depth":2},{"title":"PerceiverMultimodalPostprocessor","local":"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPostprocessor","sections":[],"depth":2},{"title":"PerceiverModel","local":"transformers.PerceiverModel","sections":[],"depth":2},{"title":"PerceiverForMaskedLM","local":"transformers.PerceiverForMaskedLM","sections":[],"depth":2},{"title":"PerceiverForSequenceClassification","local":"transformers.PerceiverForSequenceClassification","sections":[],"depth":2},{"title":"PerceiverForImageClassificationLearned","local":"transformers.PerceiverForImageClassificationLearned","sections":[],"depth":2},{"title":"PerceiverForImageClassificationFourier","local":"transformers.PerceiverForImageClassificationFourier","sections":[],"depth":2},{"title":"PerceiverForImageClassificationConvProcessing","local":"transformers.PerceiverForImageClassificationConvProcessing","sections":[],"depth":2},{"title":"PerceiverForOpticalFlow","local":"transformers.PerceiverForOpticalFlow","sections":[],"depth":2},{"title":"PerceiverForMultimodalAutoencoding","local":"transformers.PerceiverForMultimodalAutoencoding","sections":[],"depth":2}],"depth":1}';function xd(x){return ed(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Zd extends td{constructor(a){super(),od(this,a,xd,Pd,Ql,{})}}export{Zd as component};
