import{s as Zo,o as Io,n as L}from"../chunks/scheduler.18a86fab.js";import{S as Go,i as qo,g as m,s as a,r as f,A as Bo,h as p,f as n,c as r,j as R,u as g,x as h,k as G,y as d,a as i,v as _,d as b,t as y,w as T}from"../chunks/index.98837b22.js";import{T as et}from"../chunks/Tip.77304350.js";import{D as Y}from"../chunks/Docstring.6758ea23.js";import{C as se}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as tt}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as ne}from"../chunks/Heading.7e7e0c5b.js";import{E as Vo}from"../chunks/getInferenceSnippets.de10bc7d.js";function Ro(v){let t,u=`The <code>Persimmon</code> models were trained using <code>bfloat16</code>, but the original inference uses <code>float16</code> The checkpoints uploaded on the hub use <code>torch_dtype = &#39;float16&#39;</code> which will be
used by the <code>AutoModel</code> API to cast the checkpoints from <code>torch.float32</code> to <code>torch.float16</code>.`,l,c,M="The <code>dtype</code> of the online weights is mostly irrelevant, unless you are using <code>torch_dtype=&quot;auto&quot;</code> when initializing a model using <code>model = AutoModelForCausalLM.from_pretrained(&quot;path&quot;, torch_dtype = &quot;auto&quot;)</code>. The reason is that the model will first be downloaded ( using the <code>dtype</code> of the checkpoints online) then it will be cast to the default <code>dtype</code> of <code>torch</code> (becomes <code>torch.float32</code>). Users should specify the <code>torch_dtype</code> they want, and if they don’t it will be <code>torch.float32</code>.",s,w,De="Finetuning the model in <code>float16</code> is not recommended and known to produce <code>nan</code>, as such the model should be fine-tuned in <code>bfloat16</code>.";return{c(){t=m("p"),t.innerHTML=u,l=a(),c=m("p"),c.innerHTML=M,s=a(),w=m("p"),w.innerHTML=De},l($){t=p($,"P",{"data-svelte-h":!0}),h(t)!=="svelte-17q3pz"&&(t.innerHTML=u),l=r($),c=p($,"P",{"data-svelte-h":!0}),h(c)!=="svelte-1mgue3n"&&(c.innerHTML=M),s=r($),w=p($,"P",{"data-svelte-h":!0}),h(w)!=="svelte-1p3drsu"&&(w.innerHTML=De)},m($,z){i($,t,z),i($,l,z),i($,c,z),i($,s,z),i($,w,z)},p:L,d($){$&&(n(t),n(l),n(c),n(s),n(w))}}}function Xo(v){let t,u;return t=new se({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBlcnNpbW1vbk1vZGVsJTJDJTIwUGVyc2ltbW9uQ29uZmlnJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMFBlcnNpbW1vbiUyMHBlcnNpbW1vbi03YiUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBQZXJzaW1tb25Db25maWcoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PersimmonModel, PersimmonConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Persimmon persimmon-7b style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = PersimmonConfig()`,wrap:!1}}),{c(){f(t.$$.fragment)},l(l){g(t.$$.fragment,l)},m(l,c){_(t,l,c),u=!0},p:L,i(l){u||(b(t.$$.fragment,l),u=!0)},o(l){y(t.$$.fragment,l),u=!1},d(l){T(t,l)}}}function Lo(v){let t,u=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=u},l(l){t=p(l,"P",{"data-svelte-h":!0}),h(t)!=="svelte-fincs2"&&(t.innerHTML=u)},m(l,c){i(l,t,c)},p:L,d(l){l&&n(t)}}}function No(v){let t,u=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=u},l(l){t=p(l,"P",{"data-svelte-h":!0}),h(t)!=="svelte-fincs2"&&(t.innerHTML=u)},m(l,c){i(l,t,c)},p:L,d(l){l&&n(t)}}}function Ho(v){let t,u="Example:",l,c,M;return c=new se({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBQZXJzaW1tb25Gb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwUGVyc2ltbW9uRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmFkZXB0JTJGcGVyc2ltbW9uLThiLWJhc2UlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyYWRlcHQlMkZwZXJzaW1tb24tOGItYmFzZSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJodW1hbiUzQSUyMEhleSUyQyUyMHdoYXQlMjBzaG91bGQlMjBJJTIwZWF0JTIwZm9yJTIwZGlubmVyJTNGJTIyJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwR2VuZXJhdGUlMEFnZW5lcmF0ZV9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dHMuaW5wdXRfaWRzJTJDJTIwbWF4X2xlbmd0aCUzRDMwKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUlMkMlMjBjbGVhbl91cF90b2tlbml6YXRpb25fc3BhY2VzJTNERmFsc2UpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, PersimmonForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = PersimmonForCausalLM.from_pretrained(<span class="hljs-string">&quot;adept/persimmon-8b-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;adept/persimmon-8b-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;human: Hey, what should I eat for dinner?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(inputs.input_ids, max_length=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;human: Hey, what should I eat for dinner?\\n\\ncat: 🐱\\n\\nhuman: 😐\\n\\n&#x27;</span>`,wrap:!1}}),{c(){t=m("p"),t.textContent=u,l=a(),f(c.$$.fragment)},l(s){t=p(s,"P",{"data-svelte-h":!0}),h(t)!=="svelte-11lpom8"&&(t.textContent=u),l=r(s),g(c.$$.fragment,s)},m(s,w){i(s,t,w),i(s,l,w),_(c,s,w),M=!0},p:L,i(s){M||(b(c.$$.fragment,s),M=!0)},o(s){y(c.$$.fragment,s),M=!1},d(s){s&&(n(t),n(l)),T(c,s)}}}function Yo(v){let t,u=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=u},l(l){t=p(l,"P",{"data-svelte-h":!0}),h(t)!=="svelte-fincs2"&&(t.innerHTML=u)},m(l,c){i(l,t,c)},p:L,d(l){l&&n(t)}}}function So(v){let t,u="Example of single-label classification:",l,c,M;return c=new se({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMFBlcnNpbW1vbkZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJhZGVwdCUyRnBlcnNpbW1vbi04Yi1iYXNlJTIyKSUwQW1vZGVsJTIwJTNEJTIwUGVyc2ltbW9uRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyYWRlcHQlMkZwZXJzaW1tb24tOGItYmFzZSUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIySGVsbG8lMkMlMjBteSUyMGRvZyUyMGlzJTIwY3V0ZSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5sb2dpdHMlMEElMEFwcmVkaWN0ZWRfY2xhc3NfaWQlMjAlM0QlMjBsb2dpdHMuYXJnbWF4KCkuaXRlbSgpJTBBbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCcHJlZGljdGVkX2NsYXNzX2lkJTVEJTBBJTBBJTIzJTIwVG8lMjB0cmFpbiUyMGElMjBtb2RlbCUyMG9uJTIwJTYwbnVtX2xhYmVscyU2MCUyMGNsYXNzZXMlMkMlMjB5b3UlMjBjYW4lMjBwYXNzJTIwJTYwbnVtX2xhYmVscyUzRG51bV9sYWJlbHMlNjAlMjB0byUyMCU2MC5mcm9tX3ByZXRyYWluZWQoLi4uKSU2MCUwQW51bV9sYWJlbHMlMjAlM0QlMjBsZW4obW9kZWwuY29uZmlnLmlkMmxhYmVsKSUwQW1vZGVsJTIwJTNEJTIwUGVyc2ltbW9uRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyYWRlcHQlMkZwZXJzaW1tb24tOGItYmFzZSUyMiUyQyUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzKSUwQSUwQWxhYmVscyUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUIxJTVEKSUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcyUwQXJvdW5kKGxvc3MuaXRlbSgpJTJDJTIwMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, PersimmonForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;adept/persimmon-8b-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PersimmonForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;adept/persimmon-8b-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_id = logits.argmax().item()
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.id2label[predicted_class_id]
...

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on \`num_labels\` classes, you can pass \`num_labels=num_labels\` to \`.from_pretrained(...)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PersimmonForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;adept/persimmon-8b-base&quot;</span>, num_labels=num_labels)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.tensor([<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(loss.item(), <span class="hljs-number">2</span>)
...`,wrap:!1}}),{c(){t=m("p"),t.textContent=u,l=a(),f(c.$$.fragment)},l(s){t=p(s,"P",{"data-svelte-h":!0}),h(t)!=="svelte-ykxpe4"&&(t.textContent=u),l=r(s),g(c.$$.fragment,s)},m(s,w){i(s,t,w),i(s,l,w),_(c,s,w),M=!0},p:L,i(s){M||(b(c.$$.fragment,s),M=!0)},o(s){y(c.$$.fragment,s),M=!1},d(s){s&&(n(t),n(l)),T(c,s)}}}function Qo(v){let t,u="Example of multi-label classification:",l,c,M;return c=new se({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMFBlcnNpbW1vbkZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJhZGVwdCUyRnBlcnNpbW1vbi04Yi1iYXNlJTIyKSUwQW1vZGVsJTIwJTNEJTIwUGVyc2ltbW9uRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyYWRlcHQlMkZwZXJzaW1tb24tOGItYmFzZSUyMiUyQyUyMHByb2JsZW1fdHlwZSUzRCUyMm11bHRpX2xhYmVsX2NsYXNzaWZpY2F0aW9uJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJIZWxsbyUyQyUyMG15JTIwZG9nJTIwaXMlMjBjdXRlJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQSUwQXByZWRpY3RlZF9jbGFzc19pZHMlMjAlM0QlMjB0b3JjaC5hcmFuZ2UoMCUyQyUyMGxvZ2l0cy5zaGFwZSU1Qi0xJTVEKSU1QnRvcmNoLnNpZ21vaWQobG9naXRzKS5zcXVlZXplKGRpbSUzRDApJTIwJTNFJTIwMC41JTVEJTBBJTBBJTIzJTIwVG8lMjB0cmFpbiUyMGElMjBtb2RlbCUyMG9uJTIwJTYwbnVtX2xhYmVscyU2MCUyMGNsYXNzZXMlMkMlMjB5b3UlMjBjYW4lMjBwYXNzJTIwJTYwbnVtX2xhYmVscyUzRG51bV9sYWJlbHMlNjAlMjB0byUyMCU2MC5mcm9tX3ByZXRyYWluZWQoLi4uKSU2MCUwQW51bV9sYWJlbHMlMjAlM0QlMjBsZW4obW9kZWwuY29uZmlnLmlkMmxhYmVsKSUwQW1vZGVsJTIwJTNEJTIwUGVyc2ltbW9uRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYWRlcHQlMkZwZXJzaW1tb24tOGItYmFzZSUyMiUyQyUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzJTJDJTIwcHJvYmxlbV90eXBlJTNEJTIybXVsdGlfbGFiZWxfY2xhc3NpZmljYXRpb24lMjIlMEEpJTBBJTBBbGFiZWxzJTIwJTNEJTIwdG9yY2guc3VtKCUwQSUyMCUyMCUyMCUyMHRvcmNoLm5uLmZ1bmN0aW9uYWwub25lX2hvdChwcmVkaWN0ZWRfY2xhc3NfaWRzJTVCTm9uZSUyQyUyMCUzQSU1RC5jbG9uZSgpJTJDJTIwbnVtX2NsYXNzZXMlM0RudW1fbGFiZWxzKSUyQyUyMGRpbSUzRDElMEEpLnRvKHRvcmNoLmZsb2F0KSUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, PersimmonForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;adept/persimmon-8b-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PersimmonForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;adept/persimmon-8b-base&quot;</span>, problem_type=<span class="hljs-string">&quot;multi_label_classification&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_ids = torch.arange(<span class="hljs-number">0</span>, logits.shape[-<span class="hljs-number">1</span>])[torch.sigmoid(logits).squeeze(dim=<span class="hljs-number">0</span>) &gt; <span class="hljs-number">0.5</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on \`num_labels\` classes, you can pass \`num_labels=num_labels\` to \`.from_pretrained(...)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PersimmonForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;adept/persimmon-8b-base&quot;</span>, num_labels=num_labels, problem_type=<span class="hljs-string">&quot;multi_label_classification&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.<span class="hljs-built_in">sum</span>(
<span class="hljs-meta">... </span>    torch.nn.functional.one_hot(predicted_class_ids[<span class="hljs-literal">None</span>, :].clone(), num_classes=num_labels), dim=<span class="hljs-number">1</span>
<span class="hljs-meta">... </span>).to(torch.<span class="hljs-built_in">float</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss`,wrap:!1}}),{c(){t=m("p"),t.textContent=u,l=a(),f(c.$$.fragment)},l(s){t=p(s,"P",{"data-svelte-h":!0}),h(t)!=="svelte-1l8e32d"&&(t.textContent=u),l=r(s),g(c.$$.fragment,s)},m(s,w){i(s,t,w),i(s,l,w),_(c,s,w),M=!0},p:L,i(s){M||(b(c.$$.fragment,s),M=!0)},o(s){y(c.$$.fragment,s),M=!1},d(s){s&&(n(t),n(l)),T(c,s)}}}function Eo(v){let t,u=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=u},l(l){t=p(l,"P",{"data-svelte-h":!0}),h(t)!=="svelte-fincs2"&&(t.innerHTML=u)},m(l,c){i(l,t,c)},p:L,d(l){l&&n(t)}}}function Oo(v){let t,u="Example:",l,c,M;return c=new se({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBQZXJzaW1tb25Gb3JUb2tlbkNsYXNzaWZpY2F0aW9uJTBBaW1wb3J0JTIwdG9yY2glMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJhZGVwdCUyRnBlcnNpbW1vbi04Yi1iYXNlJTIyKSUwQW1vZGVsJTIwJTNEJTIwUGVyc2ltbW9uRm9yVG9rZW5DbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyYWRlcHQlMkZwZXJzaW1tb24tOGItYmFzZSUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTBBJTIwJTIwJTIwJTIwJTIySHVnZ2luZ0ZhY2UlMjBpcyUyMGElMjBjb21wYW55JTIwYmFzZWQlMjBpbiUyMFBhcmlzJTIwYW5kJTIwTmV3JTIwWW9yayUyMiUyQyUyMGFkZF9zcGVjaWFsX3Rva2VucyUzREZhbHNlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUwQSklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQSUwQXByZWRpY3RlZF90b2tlbl9jbGFzc19pZHMlMjAlM0QlMjBsb2dpdHMuYXJnbWF4KC0xKSUwQSUwQSUyMyUyME5vdGUlMjB0aGF0JTIwdG9rZW5zJTIwYXJlJTIwY2xhc3NpZmllZCUyMHJhdGhlciUyMHRoZW4lMjBpbnB1dCUyMHdvcmRzJTIwd2hpY2glMjBtZWFucyUyMHRoYXQlMEElMjMlMjB0aGVyZSUyMG1pZ2h0JTIwYmUlMjBtb3JlJTIwcHJlZGljdGVkJTIwdG9rZW4lMjBjbGFzc2VzJTIwdGhhbiUyMHdvcmRzLiUwQSUyMyUyME11bHRpcGxlJTIwdG9rZW4lMjBjbGFzc2VzJTIwbWlnaHQlMjBhY2NvdW50JTIwZm9yJTIwdGhlJTIwc2FtZSUyMHdvcmQlMEFwcmVkaWN0ZWRfdG9rZW5zX2NsYXNzZXMlMjAlM0QlMjAlNUJtb2RlbC5jb25maWcuaWQybGFiZWwlNUJ0Lml0ZW0oKSU1RCUyMGZvciUyMHQlMjBpbiUyMHByZWRpY3RlZF90b2tlbl9jbGFzc19pZHMlNUIwJTVEJTVEJTBBcHJlZGljdGVkX3Rva2Vuc19jbGFzc2VzJTBBJTBBbGFiZWxzJTIwJTNEJTIwcHJlZGljdGVkX3Rva2VuX2NsYXNzX2lkcyUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcyUwQXJvdW5kKGxvc3MuaXRlbSgpJTJDJTIwMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, PersimmonForTokenClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;adept/persimmon-8b-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PersimmonForTokenClassification.from_pretrained(<span class="hljs-string">&quot;adept/persimmon-8b-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;HuggingFace is a company based in Paris and New York&quot;</span>, add_special_tokens=<span class="hljs-literal">False</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_token_class_ids = logits.argmax(-<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Note that tokens are classified rather then input words which means that</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># there might be more predicted token classes than words.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Multiple token classes might account for the same word</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_tokens_classes = [model.config.id2label[t.item()] <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> predicted_token_class_ids[<span class="hljs-number">0</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_tokens_classes
...

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = predicted_token_class_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(loss.item(), <span class="hljs-number">2</span>)
...`,wrap:!1}}),{c(){t=m("p"),t.textContent=u,l=a(),f(c.$$.fragment)},l(s){t=p(s,"P",{"data-svelte-h":!0}),h(t)!=="svelte-11lpom8"&&(t.textContent=u),l=r(s),g(c.$$.fragment,s)},m(s,w){i(s,t,w),i(s,l,w),_(c,s,w),M=!0},p:L,i(s){M||(b(c.$$.fragment,s),M=!0)},o(s){y(c.$$.fragment,s),M=!1},d(s){s&&(n(t),n(l)),T(c,s)}}}function Ao(v){let t,u,l,c,M,s,w,De='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',$,z,ot,ae,ro='The Persimmon model was created by <a href="https://www.adept.ai/blog/persimmon-8b" rel="nofollow">ADEPT</a>, and authored by Erich Elsen, Augustus Odena, Maxwell Nye, Sağnak Taşırlar, Tri Dao, Curtis Hawthorne, Deepak Moparthi, Arushi Somani.',nt,re,io="The authors introduced Persimmon-8B, a decoder model based on the classic transformers architecture, with query and key normalization. Persimmon-8B is a fully permissively-licensed model with approximately 8 billion parameters, released under the Apache license.  Some of the key attributes of Persimmon-8B are long context size (16K), performance, and capabilities for multimodal extensions.",st,ie,lo="The authors showcase their approach to model evaluation, focusing on practical text generation, mirroring how users interact with language models. The work also includes a comparative analysis, pitting Persimmon-8B against other prominent models (MPT 7B Instruct and Llama 2 Base 7B 1-Shot), across various evaluation tasks. The results demonstrate Persimmon-8B’s competitive performance, even with limited training data.",at,le,co="In terms of model details, the work outlines the architecture and training methodology of Persimmon-8B, providing insights into its design choices, sequence length, and dataset composition. The authors present a fast inference code that outperforms traditional implementations through operator fusion and CUDA graph utilization while maintaining code coherence. They express their anticipation of how the community will leverage this contribution to drive innovation, hinting at further upcoming releases as part of an ongoing series of developments.",rt,ce,mo=`This model was contributed by <a href="https://huggingface.co/ArthurZ" rel="nofollow">ArthurZ</a>.
The original code can be found <a href="https://github.com/persimmon-ai-labs/adept-inference" rel="nofollow">here</a>.`,it,de,lt,S,ct,me,po="Tips:",dt,pe,ho="<li>To convert the model, you need to clone the original repository using <code>git clone https://github.com/persimmon-ai-labs/adept-inference</code>, then get the checkpoints:</li>",mt,he,pt,ue,uo="For the chat model:",ht,fe,ut,ge,fo="Thereafter, models can be loaded via:",ft,_e,gt,be,go=`<li><p>Perismmon uses a <code>sentencepiece</code> based tokenizer, with a <code>Unigram</code> model. It supports bytefallback, which is only available in <code>tokenizers==0.14.0</code> for the fast tokenizer.
The <code>LlamaTokenizer</code> is used as it is a standard wrapper around sentencepiece. The <code>chat</code> template will be updated with the templating functions in a follow up PR!</p></li> <li><p>The authors suggest to use the following prompt format for the chat mode: <code>f&quot;human: {prompt}\\n\\nadept:&quot;</code></p></li>`,_t,ye,bt,j,Te,zt,Ze,_o=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/persimmon#transformers.PersimmonModel">PersimmonModel</a>. It is used to instantiate an
Persimmon model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the
<a href="https://huggingface.co/adept/persimmon-8b-base" rel="nofollow">adept/persimmon-8b-base</a>.`,jt,Ie,bo=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Wt,Q,yt,we,Tt,x,Me,Ft,Ge,yo="The bare Persimmon Model outputting raw hidden-states without any specific head on top.",Ut,qe,To=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Zt,Be,wo=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,It,X,ve,Gt,Ve,Mo='The <a href="/docs/transformers/main/en/model_doc/persimmon#transformers.PersimmonModel">PersimmonModel</a> forward method, overrides the <code>__call__</code> special method.',qt,E,wt,ke,Mt,N,$e,Bt,Z,Je,Vt,Re,vo='The <a href="/docs/transformers/main/en/model_doc/persimmon#transformers.PersimmonForCausalLM">PersimmonForCausalLM</a> forward method, overrides the <code>__call__</code> special method.',Rt,O,Xt,A,vt,xe,kt,k,Ce,Lt,Xe,ko="The Persimmon transformer with a sequence classification head on top (linear layer).",Nt,Le,$o=`<a href="/docs/transformers/main/en/model_doc/persimmon#transformers.PersimmonForSequenceClassification">PersimmonForSequenceClassification</a> uses the last token in order to do the classification, as other causal
models (e.g. GPT-2) do.`,Ht,Ne,Jo=`Since it does classification on the last token, it requires to know the position of the last token. If a
<code>pad_token_id</code> is defined in the configuration, it finds the last token that is not a padding token in each row. If
no <code>pad_token_id</code> is defined, it simply takes the last value in each row of the batch. Since it cannot guess the
padding tokens when <code>inputs_embeds</code> are passed instead of <code>input_ids</code>, it does the same (take the last value in
each row of the batch).`,Yt,He,xo=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,St,Ye,Co=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Qt,P,Pe,Et,Se,Po='The <a href="/docs/transformers/main/en/model_doc/persimmon#transformers.PersimmonForSequenceClassification">PersimmonForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',Ot,D,At,K,Dt,ee,$t,ze,Jt,C,je,Kt,Qe,zo=`The Persimmon transformer with a token classification head on top (a linear layer on top of the hidden-states
output) e.g. for Named-Entity-Recognition (NER) tasks.`,eo,Ee,jo=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,to,Oe,Wo=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,oo,I,We,no,Ae,Fo='The <a href="/docs/transformers/main/en/model_doc/persimmon#transformers.PersimmonForTokenClassification">PersimmonForTokenClassification</a> forward method, overrides the <code>__call__</code> special method.',so,te,ao,oe,xt,Fe,Ct,Ke,Pt;return M=new ne({props:{title:"Persimmon",local:"persimmon",headingTag:"h1"}}),z=new ne({props:{title:"Overview",local:"overview",headingTag:"h2"}}),de=new ne({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),S=new et({props:{warning:!0,$$slots:{default:[Ro]},$$scope:{ctx:v}}}),he=new se({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZwZXJzaW1tb24tYWktbGFicyUyRmFkZXB0LWluZmVyZW5jZSUwQXdnZXQlMjBodHRwcyUzQSUyRiUyRmF4dGtuNHhsNWNpcC5vYmplY3RzdG9yYWdlLnVzLXBob2VuaXgtMS5vY2kuY3VzdG9tZXItb2NpLmNvbSUyRm4lMkZheHRrbjR4bDVjaXAlMkZiJTJGYWRlcHQtcHVibGljLWRhdGElMkZvJTJGOGJfYmFzZV9tb2RlbF9yZWxlYXNlLnRhciUwQXRhciUyMC14dmYlMjA4Yl9iYXNlX21vZGVsX3JlbGVhc2UudGFyJTBBcHl0aG9uJTIwc3JjJTJGdHJhbnNmb3JtZXJzJTJGbW9kZWxzJTJGcGVyc2ltbW9uJTJGY29udmVydF9wZXJzaW1tb25fd2VpZ2h0c190b19oZi5weSUyMCUyMC0taW5wdXRfZGlyJTIwJTJGcGF0aCUyRnRvJTJGZG93bmxvYWRlZCUyRnBlcnNpbW1vbiUyRndlaWdodHMlMkYlMjAtLW91dHB1dF9kaXIlMjAlMkZvdXRwdXQlMkZwYXRoJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1wdF9tb2RlbF9wYXRoJTIwJTJGcGF0aCUyRnRvJTJGOGJfY2hhdF9tb2RlbF9yZWxlYXNlJTJGaXRlcl8wMDAxMjUxJTJGbXBfcmFua18wMCUyRm1vZGVsX29wdGltX3JuZy5wdCUwQSUyMCUyMCUyMCUyMC0tYWRhX2xpYl9wYXRoJTIwJTJGcGF0aCUyRnRvJTJGYWRlcHQtaW5mZXJlbmNl",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/persimmon-ai-labs/adept-inference
wget https://axtkn4xl5cip.objectstorage.us-phoenix-1.oci.customer-oci.com/n/axtkn4xl5cip/b/adept-public-data/o/8b_base_model_release.tar
tar -xvf 8b_base_model_release.tar
python src/transformers/models/persimmon/convert_persimmon_weights_to_hf.py  --input_dir /path/to/downloaded/persimmon/weights/ --output_dir /output/path \\
    --pt_model_path /path/to/8b_chat_model_release/iter_0001251/mp_rank_00/model_optim_rng.pt
    --ada_lib_path /path/to/adept-inference`,wrap:!1}}),fe=new se({props:{code:"d2dldCUyMGh0dHBzJTNBJTJGJTJGYXh0a240eGw1Y2lwLm9iamVjdHN0b3JhZ2UudXMtcGhvZW5peC0xLm9jaS5jdXN0b21lci1vY2kuY29tJTJGbiUyRmF4dGtuNHhsNWNpcCUyRmIlMkZhZGVwdC1wdWJsaWMtZGF0YSUyRm8lMkY4Yl9jaGF0X21vZGVsX3JlbGVhc2UudGFyJTBBdGFyJTIwLXh2ZiUyMDhiX2Jhc2VfbW9kZWxfcmVsZWFzZS50YXI=",highlighted:`wget https://axtkn4xl5cip.objectstorage.us-phoenix-1.oci.customer-oci.com/n/axtkn4xl5cip/b/adept-public-data/o/8b_chat_model_release.tar
tar -xvf 8b_base_model_release.tar`,wrap:!1}}),_e=new se({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBlcnNpbW1vbkZvckNhdXNhbExNJTJDJTIwUGVyc2ltbW9uVG9rZW5pemVyJTBBJTBBbW9kZWwlMjAlM0QlMjBQZXJzaW1tb25Gb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyJTJGb3V0cHV0JTJGcGF0aCUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBQZXJzaW1tb25Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMiUyRm91dHB1dCUyRnBhdGglMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PersimmonForCausalLM, PersimmonTokenizer

model = PersimmonForCausalLM.from_pretrained(<span class="hljs-string">&quot;/output/path&quot;</span>)
tokenizer = PersimmonTokenizer.from_pretrained(<span class="hljs-string">&quot;/output/path&quot;</span>)`,wrap:!1}}),ye=new ne({props:{title:"PersimmonConfig",local:"transformers.PersimmonConfig",headingTag:"h2"}}),Te=new Y({props:{name:"class transformers.PersimmonConfig",anchor:"transformers.PersimmonConfig",parameters:[{name:"vocab_size",val:" = 262144"},{name:"hidden_size",val:" = 4096"},{name:"intermediate_size",val:" = 16384"},{name:"num_hidden_layers",val:" = 36"},{name:"num_attention_heads",val:" = 64"},{name:"hidden_act",val:" = 'relu2'"},{name:"max_position_embeddings",val:" = 16384"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-05"},{name:"use_cache",val:" = True"},{name:"tie_word_embeddings",val:" = False"},{name:"rope_theta",val:" = 25000.0"},{name:"rope_scaling",val:" = None"},{name:"qk_layernorm",val:" = True"},{name:"hidden_dropout",val:" = 0.0"},{name:"attention_dropout",val:" = 0.0"},{name:"partial_rotary_factor",val:" = 0.5"},{name:"pad_token_id",val:" = None"},{name:"bos_token_id",val:" = 1"},{name:"eos_token_id",val:" = 2"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PersimmonConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 262144) &#x2014;
Vocabulary size of the Persimmon model. Defines the number of different tokens that can be represented by
the <code>inputs_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/persimmon#transformers.PersimmonModel">PersimmonModel</a>`,name:"vocab_size"},{anchor:"transformers.PersimmonConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Dimension of the hidden representations.`,name:"hidden_size"},{anchor:"transformers.PersimmonConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 16384) &#x2014;
Dimension of the MLP representations.`,name:"intermediate_size"},{anchor:"transformers.PersimmonConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 36) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.PersimmonConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.PersimmonConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;relu2&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the decoder.`,name:"hidden_act"},{anchor:"transformers.PersimmonConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 16384) &#x2014;
The maximum sequence length that this model might ever be used with.`,name:"max_position_embeddings"},{anchor:"transformers.PersimmonConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.PersimmonConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-5) &#x2014;
The epsilon used by the rms normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.PersimmonConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models). Only
relevant if <code>config.is_decoder=True</code>.`,name:"use_cache"},{anchor:"transformers.PersimmonConfig.tie_word_embeddings(bool,",description:`<strong>tie_word_embeddings(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to tie weight embeddings`,name:"tie_word_embeddings(bool,"},{anchor:"transformers.PersimmonConfig.rope_theta",description:`<strong>rope_theta</strong> (<code>float</code>, <em>optional</em>, defaults to 25000.0) &#x2014;
The base period of the RoPE embeddings.`,name:"rope_theta"},{anchor:"transformers.PersimmonConfig.rope_scaling",description:`<strong>rope_scaling</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Dictionary containing the scaling configuration for the RoPE embeddings. NOTE: if you apply new rope type
and you expect the model to work on longer <code>max_position_embeddings</code>, we recommend you to update this value
accordingly.
Expected contents:
<code>rope_type</code> (<code>str</code>):
The sub-variant of RoPE to use. Can be one of [&#x2018;default&#x2019;, &#x2018;linear&#x2019;, &#x2018;dynamic&#x2019;, &#x2018;yarn&#x2019;, &#x2018;longrope&#x2019;,
&#x2018;llama3&#x2019;], with &#x2018;default&#x2019; being the original RoPE implementation.
<code>factor</code> (<code>float</code>, <em>optional</em>):
Used with all rope types except &#x2018;default&#x2019;. The scaling factor to apply to the RoPE embeddings. In
most scaling types, a <code>factor</code> of x will enable the model to handle sequences of length x <em>
original maximum pre-trained length.
<code>original_max_position_embeddings</code> (<code>int</code>, </em>optional<em>):
Used with &#x2018;dynamic&#x2019;, &#x2018;longrope&#x2019; and &#x2018;llama3&#x2019;. The original max position embeddings used during
pretraining.
<code>attention_factor</code> (<code>float</code>, </em>optional<em>):
Used with &#x2018;yarn&#x2019; and &#x2018;longrope&#x2019;. The scaling factor to be applied on the attention
computation. If unspecified, it defaults to value recommended by the implementation, using the
<code>factor</code> field to infer the suggested value.
<code>beta_fast</code> (<code>float</code>, </em>optional<em>):
Only used with &#x2018;yarn&#x2019;. Parameter to set the boundary for extrapolation (only) in the linear
ramp function. If unspecified, it defaults to 32.
<code>beta_slow</code> (<code>float</code>, </em>optional<em>):
Only used with &#x2018;yarn&#x2019;. Parameter to set the boundary for interpolation (only) in the linear
ramp function. If unspecified, it defaults to 1.
<code>short_factor</code> (<code>List[float]</code>, </em>optional<em>):
Only used with &#x2018;longrope&#x2019;. The scaling factor to be applied to short contexts (&lt;
<code>original_max_position_embeddings</code>). Must be a list of numbers with the same length as the hidden
size divided by the number of attention heads divided by 2
<code>long_factor</code> (<code>List[float]</code>, </em>optional<em>):
Only used with &#x2018;longrope&#x2019;. The scaling factor to be applied to long contexts (&lt;
<code>original_max_position_embeddings</code>). Must be a list of numbers with the same length as the hidden
size divided by the number of attention heads divided by 2
<code>low_freq_factor</code> (<code>float</code>, </em>optional<em>):
Only used with &#x2018;llama3&#x2019;. Scaling factor applied to low frequency components of the RoPE
<code>high_freq_factor</code> (<code>float</code>, </em>optional*):
Only used with &#x2018;llama3&#x2019;. Scaling factor applied to high frequency components of the RoPE`,name:"rope_scaling"},{anchor:"transformers.PersimmonConfig.qk_layernorm",description:`<strong>qk_layernorm</strong> (<code>bool</code>, <em>optional</em>, default to <code>True</code>) &#x2014;
Whether or not to normalize the Queries and Keys after projecting the hidden states`,name:"qk_layernorm"},{anchor:"transformers.PersimmonConfig.hidden_dropout",description:`<strong>hidden_dropout</strong> (<code>float</code>, <em>optional</em>, default to 0.0) &#x2014;
The dropout ratio after applying the MLP to the hidden states.`,name:"hidden_dropout"},{anchor:"transformers.PersimmonConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, default to 0.0) &#x2014;
The dropout ratio after computing the attention scores.`,name:"attention_dropout"},{anchor:"transformers.PersimmonConfig.partial_rotary_factor",description:`<strong>partial_rotary_factor</strong> (<code>float</code>, <em>optional</em>, default to 0.5) &#x2014;
Percentage of the query and keys which will have rotary embedding.`,name:"partial_rotary_factor"},{anchor:"transformers.PersimmonConfig.Example",description:"<strong>Example</strong> &#x2014;",name:"Example"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/persimmon/configuration_persimmon.py#L25"}}),Q=new tt({props:{anchor:"transformers.PersimmonConfig.example",$$slots:{default:[Xo]},$$scope:{ctx:v}}}),we=new ne({props:{title:"PersimmonModel",local:"transformers.PersimmonModel",headingTag:"h2"}}),Me=new Y({props:{name:"class transformers.PersimmonModel",anchor:"transformers.PersimmonModel",parameters:[{name:"config",val:": PersimmonConfig"}],parametersDescription:[{anchor:"transformers.PersimmonModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/persimmon#transformers.PersimmonConfig">PersimmonConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/persimmon/modeling_persimmon.py#L414"}}),ve=new Y({props:{name:"forward",anchor:"transformers.PersimmonModel.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.modeling_flash_attention_utils.FlashAttentionKwargs]"}],parametersDescription:[{anchor:"transformers.PersimmonModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.PersimmonModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PersimmonModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.PersimmonModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>List[torch.FloatTensor]</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.PersimmonModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.PersimmonModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.PersimmonModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PersimmonModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PersimmonModel.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/persimmon/modeling_persimmon.py#L446",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPast"
>transformers.modeling_outputs.BaseModelOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/persimmon#transformers.PersimmonConfig"
>PersimmonConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>Cache</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — It is a <a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache"
>Cache</a> instance. For more details, see our <a
  href="https://huggingface.co/docs/transformers/en/kv_cache"
  rel="nofollow"
>kv cache guide</a>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and optionally if
<code>config.is_encoder_decoder=True</code> in the cross-attention blocks) that can be used (see <code>past_key_values</code>
input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPast"
>transformers.modeling_outputs.BaseModelOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),E=new et({props:{$$slots:{default:[Lo]},$$scope:{ctx:v}}}),ke=new ne({props:{title:"PersimmonForCausalLM",local:"transformers.PersimmonForCausalLM",headingTag:"h2"}}),$e=new Y({props:{name:"class transformers.PersimmonForCausalLM",anchor:"transformers.PersimmonForCausalLM",parameters:[{name:"config",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/persimmon/modeling_persimmon.py#L696"}}),Je=new Y({props:{name:"forward",anchor:"transformers.PersimmonForCausalLM.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"logits_to_keep",val:": typing.Union[int, torch.Tensor] = 0"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PersimmonForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.PersimmonForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PersimmonForCausalLM.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.PersimmonForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>List[torch.FloatTensor]</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.PersimmonForCausalLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.PersimmonForCausalLM.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"labels"},{anchor:"transformers.PersimmonForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.PersimmonForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PersimmonForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PersimmonForCausalLM.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"},{anchor:"transformers.PersimmonForCausalLM.forward.logits_to_keep",description:`<strong>logits_to_keep</strong> (<code>Union[int, torch.Tensor]</code>, defaults to <code>0</code>) &#x2014;
If an <code>int</code>, compute logits for the last <code>logits_to_keep</code> tokens. If <code>0</code>, calculate logits for all
<code>input_ids</code> (special case). Only last token logits are needed for generation, and calculating them only for that
token can save memory, which becomes pretty significant for long sequences or large vocabulary size.
If a <code>torch.Tensor</code>, must be 1D corresponding to the indices to keep in the sequence length dimension.
This is useful when using packed tensor format (single dimension for batch and sequence length).`,name:"logits_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/persimmon/modeling_persimmon.py#L733",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/persimmon#transformers.PersimmonConfig"
>PersimmonConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>Cache</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — It is a <a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache"
>Cache</a> instance. For more details, see our <a
  href="https://huggingface.co/docs/transformers/en/kv_cache"
  rel="nofollow"
>kv cache guide</a>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),O=new et({props:{$$slots:{default:[No]},$$scope:{ctx:v}}}),A=new tt({props:{anchor:"transformers.PersimmonForCausalLM.forward.example",$$slots:{default:[Ho]},$$scope:{ctx:v}}}),xe=new ne({props:{title:"PersimmonForSequenceClassification",local:"transformers.PersimmonForSequenceClassification",headingTag:"h2"}}),Ce=new Y({props:{name:"class transformers.PersimmonForSequenceClassification",anchor:"transformers.PersimmonForSequenceClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.PersimmonForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/persimmon#transformers.PersimmonForSequenceClassification">PersimmonForSequenceClassification</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/persimmon/modeling_persimmon.py#L815"}}),Pe=new Y({props:{name:"forward",anchor:"transformers.PersimmonForSequenceClassification.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[transformers.cache_utils.Cache] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.PersimmonForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.PersimmonForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PersimmonForSequenceClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.PersimmonForSequenceClassification.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>~cache_utils.Cache</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.PersimmonForSequenceClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.PersimmonForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"},{anchor:"transformers.PersimmonForSequenceClassification.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.PersimmonForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PersimmonForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/persimmon/modeling_persimmon.py#L846",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.modeling_outputs.SequenceClassifierOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/persimmon#transformers.PersimmonConfig"
>PersimmonConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>Cache</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — It is a <a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache"
>Cache</a> instance. For more details, see our <a
  href="https://huggingface.co/docs/transformers/en/kv_cache"
  rel="nofollow"
>kv cache guide</a>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.modeling_outputs.SequenceClassifierOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),D=new et({props:{$$slots:{default:[Yo]},$$scope:{ctx:v}}}),K=new tt({props:{anchor:"transformers.PersimmonForSequenceClassification.forward.example",$$slots:{default:[So]},$$scope:{ctx:v}}}),ee=new tt({props:{anchor:"transformers.PersimmonForSequenceClassification.forward.example-2",$$slots:{default:[Qo]},$$scope:{ctx:v}}}),ze=new ne({props:{title:"PersimmonForTokenClassification",local:"transformers.PersimmonForTokenClassification",headingTag:"h2"}}),je=new Y({props:{name:"class transformers.PersimmonForTokenClassification",anchor:"transformers.PersimmonForTokenClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.PersimmonForTokenClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/persimmon#transformers.PersimmonForTokenClassification">PersimmonForTokenClassification</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/persimmon/modeling_persimmon.py#L916"}}),We=new Y({props:{name:"forward",anchor:"transformers.PersimmonForTokenClassification.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[transformers.cache_utils.Cache] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.PersimmonForTokenClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.PersimmonForTokenClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PersimmonForTokenClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.PersimmonForTokenClassification.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>~cache_utils.Cache</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.PersimmonForTokenClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.PersimmonForTokenClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"},{anchor:"transformers.PersimmonForTokenClassification.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.PersimmonForTokenClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PersimmonForTokenClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/persimmon/modeling_persimmon.py#L941",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.TokenClassifierOutput"
>transformers.modeling_outputs.TokenClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/persimmon#transformers.PersimmonConfig"
>PersimmonConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided)  — Classification loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.num_labels)</code>) — Classification scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.TokenClassifierOutput"
>transformers.modeling_outputs.TokenClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),te=new et({props:{$$slots:{default:[Eo]},$$scope:{ctx:v}}}),oe=new tt({props:{anchor:"transformers.PersimmonForTokenClassification.forward.example",$$slots:{default:[Oo]},$$scope:{ctx:v}}}),Fe=new Vo({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/persimmon.md"}}),{c(){t=m("meta"),u=a(),l=m("p"),c=a(),f(M.$$.fragment),s=a(),w=m("div"),w.innerHTML=De,$=a(),f(z.$$.fragment),ot=a(),ae=m("p"),ae.innerHTML=ro,nt=a(),re=m("p"),re.textContent=io,st=a(),ie=m("p"),ie.textContent=lo,at=a(),le=m("p"),le.textContent=co,rt=a(),ce=m("p"),ce.innerHTML=mo,it=a(),f(de.$$.fragment),lt=a(),f(S.$$.fragment),ct=a(),me=m("p"),me.textContent=po,dt=a(),pe=m("ul"),pe.innerHTML=ho,mt=a(),f(he.$$.fragment),pt=a(),ue=m("p"),ue.textContent=uo,ht=a(),f(fe.$$.fragment),ut=a(),ge=m("p"),ge.textContent=fo,ft=a(),f(_e.$$.fragment),gt=a(),be=m("ul"),be.innerHTML=go,_t=a(),f(ye.$$.fragment),bt=a(),j=m("div"),f(Te.$$.fragment),zt=a(),Ze=m("p"),Ze.innerHTML=_o,jt=a(),Ie=m("p"),Ie.innerHTML=bo,Wt=a(),f(Q.$$.fragment),yt=a(),f(we.$$.fragment),Tt=a(),x=m("div"),f(Me.$$.fragment),Ft=a(),Ge=m("p"),Ge.textContent=yo,Ut=a(),qe=m("p"),qe.innerHTML=To,Zt=a(),Be=m("p"),Be.innerHTML=wo,It=a(),X=m("div"),f(ve.$$.fragment),Gt=a(),Ve=m("p"),Ve.innerHTML=Mo,qt=a(),f(E.$$.fragment),wt=a(),f(ke.$$.fragment),Mt=a(),N=m("div"),f($e.$$.fragment),Bt=a(),Z=m("div"),f(Je.$$.fragment),Vt=a(),Re=m("p"),Re.innerHTML=vo,Rt=a(),f(O.$$.fragment),Xt=a(),f(A.$$.fragment),vt=a(),f(xe.$$.fragment),kt=a(),k=m("div"),f(Ce.$$.fragment),Lt=a(),Xe=m("p"),Xe.textContent=ko,Nt=a(),Le=m("p"),Le.innerHTML=$o,Ht=a(),Ne=m("p"),Ne.innerHTML=Jo,Yt=a(),He=m("p"),He.innerHTML=xo,St=a(),Ye=m("p"),Ye.innerHTML=Co,Qt=a(),P=m("div"),f(Pe.$$.fragment),Et=a(),Se=m("p"),Se.innerHTML=Po,Ot=a(),f(D.$$.fragment),At=a(),f(K.$$.fragment),Dt=a(),f(ee.$$.fragment),$t=a(),f(ze.$$.fragment),Jt=a(),C=m("div"),f(je.$$.fragment),Kt=a(),Qe=m("p"),Qe.textContent=zo,eo=a(),Ee=m("p"),Ee.innerHTML=jo,to=a(),Oe=m("p"),Oe.innerHTML=Wo,oo=a(),I=m("div"),f(We.$$.fragment),no=a(),Ae=m("p"),Ae.innerHTML=Fo,so=a(),f(te.$$.fragment),ao=a(),f(oe.$$.fragment),xt=a(),f(Fe.$$.fragment),Ct=a(),Ke=m("p"),this.h()},l(e){const o=Bo("svelte-u9bgzb",document.head);t=p(o,"META",{name:!0,content:!0}),o.forEach(n),u=r(e),l=p(e,"P",{}),R(l).forEach(n),c=r(e),g(M.$$.fragment,e),s=r(e),w=p(e,"DIV",{class:!0,"data-svelte-h":!0}),h(w)!=="svelte-13t8s2t"&&(w.innerHTML=De),$=r(e),g(z.$$.fragment,e),ot=r(e),ae=p(e,"P",{"data-svelte-h":!0}),h(ae)!=="svelte-1dqqllh"&&(ae.innerHTML=ro),nt=r(e),re=p(e,"P",{"data-svelte-h":!0}),h(re)!=="svelte-tohaaf"&&(re.textContent=io),st=r(e),ie=p(e,"P",{"data-svelte-h":!0}),h(ie)!=="svelte-gxqz2j"&&(ie.textContent=lo),at=r(e),le=p(e,"P",{"data-svelte-h":!0}),h(le)!=="svelte-l2kkzt"&&(le.textContent=co),rt=r(e),ce=p(e,"P",{"data-svelte-h":!0}),h(ce)!=="svelte-1kv44aj"&&(ce.innerHTML=mo),it=r(e),g(de.$$.fragment,e),lt=r(e),g(S.$$.fragment,e),ct=r(e),me=p(e,"P",{"data-svelte-h":!0}),h(me)!=="svelte-axv494"&&(me.textContent=po),dt=r(e),pe=p(e,"UL",{"data-svelte-h":!0}),h(pe)!=="svelte-g9ue9k"&&(pe.innerHTML=ho),mt=r(e),g(he.$$.fragment,e),pt=r(e),ue=p(e,"P",{"data-svelte-h":!0}),h(ue)!=="svelte-1cs7acv"&&(ue.textContent=uo),ht=r(e),g(fe.$$.fragment,e),ut=r(e),ge=p(e,"P",{"data-svelte-h":!0}),h(ge)!=="svelte-nia5es"&&(ge.textContent=fo),ft=r(e),g(_e.$$.fragment,e),gt=r(e),be=p(e,"UL",{"data-svelte-h":!0}),h(be)!=="svelte-yk84b4"&&(be.innerHTML=go),_t=r(e),g(ye.$$.fragment,e),bt=r(e),j=p(e,"DIV",{class:!0});var q=R(j);g(Te.$$.fragment,q),zt=r(q),Ze=p(q,"P",{"data-svelte-h":!0}),h(Ze)!=="svelte-63ur08"&&(Ze.innerHTML=_o),jt=r(q),Ie=p(q,"P",{"data-svelte-h":!0}),h(Ie)!=="svelte-o55m63"&&(Ie.innerHTML=bo),Wt=r(q),g(Q.$$.fragment,q),q.forEach(n),yt=r(e),g(we.$$.fragment,e),Tt=r(e),x=p(e,"DIV",{class:!0});var W=R(x);g(Me.$$.fragment,W),Ft=r(W),Ge=p(W,"P",{"data-svelte-h":!0}),h(Ge)!=="svelte-qpvziu"&&(Ge.textContent=yo),Ut=r(W),qe=p(W,"P",{"data-svelte-h":!0}),h(qe)!=="svelte-6pahdo"&&(qe.innerHTML=To),Zt=r(W),Be=p(W,"P",{"data-svelte-h":!0}),h(Be)!=="svelte-hswkmf"&&(Be.innerHTML=wo),It=r(W),X=p(W,"DIV",{class:!0});var H=R(X);g(ve.$$.fragment,H),Gt=r(H),Ve=p(H,"P",{"data-svelte-h":!0}),h(Ve)!=="svelte-1wbx0c5"&&(Ve.innerHTML=Mo),qt=r(H),g(E.$$.fragment,H),H.forEach(n),W.forEach(n),wt=r(e),g(ke.$$.fragment,e),Mt=r(e),N=p(e,"DIV",{class:!0});var Ue=R(N);g($e.$$.fragment,Ue),Bt=r(Ue),Z=p(Ue,"DIV",{class:!0});var B=R(Z);g(Je.$$.fragment,B),Vt=r(B),Re=p(B,"P",{"data-svelte-h":!0}),h(Re)!=="svelte-n5vjih"&&(Re.innerHTML=vo),Rt=r(B),g(O.$$.fragment,B),Xt=r(B),g(A.$$.fragment,B),B.forEach(n),Ue.forEach(n),vt=r(e),g(xe.$$.fragment,e),kt=r(e),k=p(e,"DIV",{class:!0});var J=R(k);g(Ce.$$.fragment,J),Lt=r(J),Xe=p(J,"P",{"data-svelte-h":!0}),h(Xe)!=="svelte-1oalnz1"&&(Xe.textContent=ko),Nt=r(J),Le=p(J,"P",{"data-svelte-h":!0}),h(Le)!=="svelte-1g4f24y"&&(Le.innerHTML=$o),Ht=r(J),Ne=p(J,"P",{"data-svelte-h":!0}),h(Ne)!=="svelte-10ugs3m"&&(Ne.innerHTML=Jo),Yt=r(J),He=p(J,"P",{"data-svelte-h":!0}),h(He)!=="svelte-6pahdo"&&(He.innerHTML=xo),St=r(J),Ye=p(J,"P",{"data-svelte-h":!0}),h(Ye)!=="svelte-hswkmf"&&(Ye.innerHTML=Co),Qt=r(J),P=p(J,"DIV",{class:!0});var F=R(P);g(Pe.$$.fragment,F),Et=r(F),Se=p(F,"P",{"data-svelte-h":!0}),h(Se)!=="svelte-xuuqwj"&&(Se.innerHTML=Po),Ot=r(F),g(D.$$.fragment,F),At=r(F),g(K.$$.fragment,F),Dt=r(F),g(ee.$$.fragment,F),F.forEach(n),J.forEach(n),$t=r(e),g(ze.$$.fragment,e),Jt=r(e),C=p(e,"DIV",{class:!0});var U=R(C);g(je.$$.fragment,U),Kt=r(U),Qe=p(U,"P",{"data-svelte-h":!0}),h(Qe)!=="svelte-1dwlhe6"&&(Qe.textContent=zo),eo=r(U),Ee=p(U,"P",{"data-svelte-h":!0}),h(Ee)!=="svelte-6pahdo"&&(Ee.innerHTML=jo),to=r(U),Oe=p(U,"P",{"data-svelte-h":!0}),h(Oe)!=="svelte-hswkmf"&&(Oe.innerHTML=Wo),oo=r(U),I=p(U,"DIV",{class:!0});var V=R(I);g(We.$$.fragment,V),no=r(V),Ae=p(V,"P",{"data-svelte-h":!0}),h(Ae)!=="svelte-egyr8v"&&(Ae.innerHTML=Fo),so=r(V),g(te.$$.fragment,V),ao=r(V),g(oe.$$.fragment,V),V.forEach(n),U.forEach(n),xt=r(e),g(Fe.$$.fragment,e),Ct=r(e),Ke=p(e,"P",{}),R(Ke).forEach(n),this.h()},h(){G(t,"name","hf:doc:metadata"),G(t,"content",Do),G(w,"class","flex flex-wrap space-x-1"),G(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),G(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),G(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),G(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),G(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),G(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),G(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),G(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),G(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,o){d(document.head,t),i(e,u,o),i(e,l,o),i(e,c,o),_(M,e,o),i(e,s,o),i(e,w,o),i(e,$,o),_(z,e,o),i(e,ot,o),i(e,ae,o),i(e,nt,o),i(e,re,o),i(e,st,o),i(e,ie,o),i(e,at,o),i(e,le,o),i(e,rt,o),i(e,ce,o),i(e,it,o),_(de,e,o),i(e,lt,o),_(S,e,o),i(e,ct,o),i(e,me,o),i(e,dt,o),i(e,pe,o),i(e,mt,o),_(he,e,o),i(e,pt,o),i(e,ue,o),i(e,ht,o),_(fe,e,o),i(e,ut,o),i(e,ge,o),i(e,ft,o),_(_e,e,o),i(e,gt,o),i(e,be,o),i(e,_t,o),_(ye,e,o),i(e,bt,o),i(e,j,o),_(Te,j,null),d(j,zt),d(j,Ze),d(j,jt),d(j,Ie),d(j,Wt),_(Q,j,null),i(e,yt,o),_(we,e,o),i(e,Tt,o),i(e,x,o),_(Me,x,null),d(x,Ft),d(x,Ge),d(x,Ut),d(x,qe),d(x,Zt),d(x,Be),d(x,It),d(x,X),_(ve,X,null),d(X,Gt),d(X,Ve),d(X,qt),_(E,X,null),i(e,wt,o),_(ke,e,o),i(e,Mt,o),i(e,N,o),_($e,N,null),d(N,Bt),d(N,Z),_(Je,Z,null),d(Z,Vt),d(Z,Re),d(Z,Rt),_(O,Z,null),d(Z,Xt),_(A,Z,null),i(e,vt,o),_(xe,e,o),i(e,kt,o),i(e,k,o),_(Ce,k,null),d(k,Lt),d(k,Xe),d(k,Nt),d(k,Le),d(k,Ht),d(k,Ne),d(k,Yt),d(k,He),d(k,St),d(k,Ye),d(k,Qt),d(k,P),_(Pe,P,null),d(P,Et),d(P,Se),d(P,Ot),_(D,P,null),d(P,At),_(K,P,null),d(P,Dt),_(ee,P,null),i(e,$t,o),_(ze,e,o),i(e,Jt,o),i(e,C,o),_(je,C,null),d(C,Kt),d(C,Qe),d(C,eo),d(C,Ee),d(C,to),d(C,Oe),d(C,oo),d(C,I),_(We,I,null),d(I,no),d(I,Ae),d(I,so),_(te,I,null),d(I,ao),_(oe,I,null),i(e,xt,o),_(Fe,e,o),i(e,Ct,o),i(e,Ke,o),Pt=!0},p(e,[o]){const q={};o&2&&(q.$$scope={dirty:o,ctx:e}),S.$set(q);const W={};o&2&&(W.$$scope={dirty:o,ctx:e}),Q.$set(W);const H={};o&2&&(H.$$scope={dirty:o,ctx:e}),E.$set(H);const Ue={};o&2&&(Ue.$$scope={dirty:o,ctx:e}),O.$set(Ue);const B={};o&2&&(B.$$scope={dirty:o,ctx:e}),A.$set(B);const J={};o&2&&(J.$$scope={dirty:o,ctx:e}),D.$set(J);const F={};o&2&&(F.$$scope={dirty:o,ctx:e}),K.$set(F);const U={};o&2&&(U.$$scope={dirty:o,ctx:e}),ee.$set(U);const V={};o&2&&(V.$$scope={dirty:o,ctx:e}),te.$set(V);const Uo={};o&2&&(Uo.$$scope={dirty:o,ctx:e}),oe.$set(Uo)},i(e){Pt||(b(M.$$.fragment,e),b(z.$$.fragment,e),b(de.$$.fragment,e),b(S.$$.fragment,e),b(he.$$.fragment,e),b(fe.$$.fragment,e),b(_e.$$.fragment,e),b(ye.$$.fragment,e),b(Te.$$.fragment,e),b(Q.$$.fragment,e),b(we.$$.fragment,e),b(Me.$$.fragment,e),b(ve.$$.fragment,e),b(E.$$.fragment,e),b(ke.$$.fragment,e),b($e.$$.fragment,e),b(Je.$$.fragment,e),b(O.$$.fragment,e),b(A.$$.fragment,e),b(xe.$$.fragment,e),b(Ce.$$.fragment,e),b(Pe.$$.fragment,e),b(D.$$.fragment,e),b(K.$$.fragment,e),b(ee.$$.fragment,e),b(ze.$$.fragment,e),b(je.$$.fragment,e),b(We.$$.fragment,e),b(te.$$.fragment,e),b(oe.$$.fragment,e),b(Fe.$$.fragment,e),Pt=!0)},o(e){y(M.$$.fragment,e),y(z.$$.fragment,e),y(de.$$.fragment,e),y(S.$$.fragment,e),y(he.$$.fragment,e),y(fe.$$.fragment,e),y(_e.$$.fragment,e),y(ye.$$.fragment,e),y(Te.$$.fragment,e),y(Q.$$.fragment,e),y(we.$$.fragment,e),y(Me.$$.fragment,e),y(ve.$$.fragment,e),y(E.$$.fragment,e),y(ke.$$.fragment,e),y($e.$$.fragment,e),y(Je.$$.fragment,e),y(O.$$.fragment,e),y(A.$$.fragment,e),y(xe.$$.fragment,e),y(Ce.$$.fragment,e),y(Pe.$$.fragment,e),y(D.$$.fragment,e),y(K.$$.fragment,e),y(ee.$$.fragment,e),y(ze.$$.fragment,e),y(je.$$.fragment,e),y(We.$$.fragment,e),y(te.$$.fragment,e),y(oe.$$.fragment,e),y(Fe.$$.fragment,e),Pt=!1},d(e){e&&(n(u),n(l),n(c),n(s),n(w),n($),n(ot),n(ae),n(nt),n(re),n(st),n(ie),n(at),n(le),n(rt),n(ce),n(it),n(lt),n(ct),n(me),n(dt),n(pe),n(mt),n(pt),n(ue),n(ht),n(ut),n(ge),n(ft),n(gt),n(be),n(_t),n(bt),n(j),n(yt),n(Tt),n(x),n(wt),n(Mt),n(N),n(vt),n(kt),n(k),n($t),n(Jt),n(C),n(xt),n(Ct),n(Ke)),n(t),T(M,e),T(z,e),T(de,e),T(S,e),T(he,e),T(fe,e),T(_e,e),T(ye,e),T(Te),T(Q),T(we,e),T(Me),T(ve),T(E),T(ke,e),T($e),T(Je),T(O),T(A),T(xe,e),T(Ce),T(Pe),T(D),T(K),T(ee),T(ze,e),T(je),T(We),T(te),T(oe),T(Fe,e)}}}const Do='{"title":"Persimmon","local":"persimmon","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"PersimmonConfig","local":"transformers.PersimmonConfig","sections":[],"depth":2},{"title":"PersimmonModel","local":"transformers.PersimmonModel","sections":[],"depth":2},{"title":"PersimmonForCausalLM","local":"transformers.PersimmonForCausalLM","sections":[],"depth":2},{"title":"PersimmonForSequenceClassification","local":"transformers.PersimmonForSequenceClassification","sections":[],"depth":2},{"title":"PersimmonForTokenClassification","local":"transformers.PersimmonForTokenClassification","sections":[],"depth":2}],"depth":1}';function Ko(v){return Io(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class cn extends Go{constructor(t){super(),qo(this,t,Ko,Ao,Zo,{})}}export{cn as component};
