import{s as Ae,o as Ye,n as Te}from"../chunks/scheduler.18a86fab.js";import{S as De,i as Oe,g as h,s as l,r as y,A as Ke,h as u,f as r,c as d,j as me,u as M,x as k,k as le,y as _,a as i,v as T,d as w,t as v,w as C}from"../chunks/index.98837b22.js";import{T as Le}from"../chunks/Tip.77304350.js";import{D as Je}from"../chunks/Docstring.6758ea23.js";import{C as Ze}from"../chunks/CodeBlock.8d0c2e8a.js";import{F as et,M as tt}from"../chunks/Markdown.ae01904b.js";import{E as Ne}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as Me}from"../chunks/Heading.7e7e0c5b.js";import{E as ot}from"../chunks/getInferenceSnippets.de10bc7d.js";function nt(j){let t,p="Phi-3.5-MoE-instruct has been integrated in the development version (4.44.2.dev) of <code>transformers</code>. Until the official version is released through <code>pip</code>, ensure that you are doing the following:",n,a,f="<li>When loading the model, ensure that <code>trust_remote_code=True</code> is passed as an argument of the <code>from_pretrained()</code> function.</li>",o,g,pe="The current <code>transformers</code> version can be verified with: <code>pip list | grep transformers</code>.",F,I,ee="Examples of required packages:",x,B,R;return B=new Ze({props:{code:"Zmxhc2hfYXR0biUzRCUzRDIuNS44JTBBdG9yY2glM0QlM0QyLjMuMSUwQWFjY2VsZXJhdGUlM0QlM0QwLjMxLjAlMEF0cmFuc2Zvcm1lcnMlM0QlM0Q0LjQzLjA=",highlighted:`<span class="hljs-attribute">flash_attn</span>==<span class="hljs-number">2</span>.<span class="hljs-number">5</span>.<span class="hljs-number">8</span>
<span class="hljs-attribute">torch</span>==<span class="hljs-number">2</span>.<span class="hljs-number">3</span>.<span class="hljs-number">1</span>
<span class="hljs-attribute">accelerate</span>==<span class="hljs-number">0</span>.<span class="hljs-number">31</span>.<span class="hljs-number">0</span>
<span class="hljs-attribute">transformers</span>==<span class="hljs-number">4</span>.<span class="hljs-number">43</span>.<span class="hljs-number">0</span>`,wrap:!1}}),{c(){t=h("p"),t.innerHTML=p,n=l(),a=h("ul"),a.innerHTML=f,o=l(),g=h("p"),g.innerHTML=pe,F=l(),I=h("p"),I.textContent=ee,x=l(),y(B.$$.fragment)},l(m){t=u(m,"P",{"data-svelte-h":!0}),k(t)!=="svelte-16ml7y6"&&(t.innerHTML=p),n=d(m),a=u(m,"UL",{"data-svelte-h":!0}),k(a)!=="svelte-b3j7h0"&&(a.innerHTML=f),o=d(m),g=u(m,"P",{"data-svelte-h":!0}),k(g)!=="svelte-pmzjti"&&(g.innerHTML=pe),F=d(m),I=u(m,"P",{"data-svelte-h":!0}),k(I)!=="svelte-1njcx0o"&&(I.textContent=ee),x=d(m),M(B.$$.fragment,m)},m(m,$){i(m,t,$),i(m,n,$),i(m,a,$),i(m,o,$),i(m,g,$),i(m,F,$),i(m,I,$),i(m,x,$),T(B,m,$),R=!0},p:Te,i(m){R||(w(B.$$.fragment,m),R=!0)},o(m){v(B.$$.fragment,m),R=!1},d(m){m&&(r(t),r(n),r(a),r(o),r(g),r(F),r(I),r(x)),C(B,m)}}}function st(j){let t,p="Example:",n,a,f;return a=new Ze({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBoaW1vZU1vZGVsJTJDJTIwUGhpbW9lQ29uZmlnJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMFBoaS0zJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMFBoaW1vZUNvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGUGhpLTMuNS1Nb0UtaW5zdHJ1Y3QlMjIpJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwZnJvbSUyMHRoZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMFBoaW1vZU1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PhimoeModel, PhimoeConfig
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Phi-3 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = PhimoeConfig.from_pretrained(<span class="hljs-string">&quot;microsoft/Phi-3.5-MoE-instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PhimoeModel(configuration)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){t=h("p"),t.textContent=p,n=l(),y(a.$$.fragment)},l(o){t=u(o,"P",{"data-svelte-h":!0}),k(t)!=="svelte-11lpom8"&&(t.textContent=p),n=d(o),M(a.$$.fragment,o)},m(o,g){i(o,t,g),i(o,n,g),T(a,o,g),f=!0},p:Te,i(o){f||(w(a.$$.fragment,o),f=!0)},o(o){v(a.$$.fragment,o),f=!1},d(o){o&&(r(t),r(n)),C(a,o)}}}function at(j){let t,p=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=h("p"),t.innerHTML=p},l(n){t=u(n,"P",{"data-svelte-h":!0}),k(t)!=="svelte-fincs2"&&(t.innerHTML=p)},m(n,a){i(n,t,a)},p:Te,d(n){n&&r(t)}}}function rt(j){let t,p=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=h("p"),t.innerHTML=p},l(n){t=u(n,"P",{"data-svelte-h":!0}),k(t)!=="svelte-fincs2"&&(t.innerHTML=p)},m(n,a){i(n,t,a)},p:Te,d(n){n&&r(t)}}}function it(j){let t,p="Example:",n,a,f;return a=new Ze({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBQaGltb2VGb3JDYXVzYWxMTSUwQW1vZGVsJTIwJTNEJTIwUGhpbW9lRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRlBoaS0zLjUtTW9FLWluc3RydWN0JTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRlBoaS0zLjUtTW9FLWluc3RydWN0JTIyKSUwQXByb21wdCUyMCUzRCUyMCUyMkhleSUyQyUyMGFyZSUyMHlvdSUyMGNvbnNjaW91cyUzRiUyMENhbiUyMHlvdSUyMHRhbGslMjB0byUyMG1lJTNGJTIyJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTIzJTIwR2VuZXJhdGUlMEFnZW5lcmF0ZV9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dHMuaW5wdXRfaWRzJTJDJTIwbWF4X2xlbmd0aCUzRDMwKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUlMkMlMjBjbGVhbl91cF90b2tlbml6YXRpb25fc3BhY2VzJTNERmFsc2UpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, PhimoeForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PhimoeForCausalLM.from_pretrained(<span class="hljs-string">&quot;microsoft/Phi-3.5-MoE-instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;microsoft/Phi-3.5-MoE-instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(inputs.input_ids, max_length=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?\\nI&#x27;m not conscious, but I can talk to you.&quot;</span>`,wrap:!1}}),{c(){t=h("p"),t.textContent=p,n=l(),y(a.$$.fragment)},l(o){t=u(o,"P",{"data-svelte-h":!0}),k(t)!=="svelte-11lpom8"&&(t.textContent=p),n=d(o),M(a.$$.fragment,o)},m(o,g){i(o,t,g),i(o,n,g),T(a,o,g),f=!0},p:Te,i(o){f||(w(a.$$.fragment,o),f=!0)},o(o){v(a.$$.fragment,o),f=!1},d(o){o&&(r(t),r(n)),C(a,o)}}}function lt(j){let t,p=`Most generation-controlling parameters are set in <code>generation_config</code> which, if not passed, will be set to the
model’s default generation configuration. You can override any <code>generation_config</code> by passing the corresponding
parameters to generate(), e.g. <code>.generate(inputs, num_beams=4, do_sample=True)</code>.`,n,a,f=`For an overview of generation strategies and code examples, check out the <a href="../generation_strategies">following
guide</a>.`;return{c(){t=h("p"),t.innerHTML=p,n=l(),a=h("p"),a.innerHTML=f},l(o){t=u(o,"P",{"data-svelte-h":!0}),k(t)!=="svelte-1c5u34l"&&(t.innerHTML=p),n=d(o),a=u(o,"P",{"data-svelte-h":!0}),k(a)!=="svelte-fvlq1g"&&(a.innerHTML=f)},m(o,g){i(o,t,g),i(o,n,g),i(o,a,g)},p:Te,d(o){o&&(r(t),r(n),r(a))}}}function dt(j){let t,p=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=h("p"),t.innerHTML=p},l(n){t=u(n,"P",{"data-svelte-h":!0}),k(t)!=="svelte-fincs2"&&(t.innerHTML=p)},m(n,a){i(n,t,a)},p:Te,d(n){n&&r(t)}}}function ct(j){let t,p="Example of single-label classification:",n,a,f;return a=new Ze({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMFBoaW1vZUZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZQaGktMy41LU1vRS1pbnN0cnVjdCUyMiklMEFtb2RlbCUyMCUzRCUyMFBoaW1vZUZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRlBoaS0zLjUtTW9FLWluc3RydWN0JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJIZWxsbyUyQyUyMG15JTIwZG9nJTIwaXMlMjBjdXRlJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQSUwQXByZWRpY3RlZF9jbGFzc19pZCUyMCUzRCUyMGxvZ2l0cy5hcmdtYXgoKS5pdGVtKCklMEFtb2RlbC5jb25maWcuaWQybGFiZWwlNUJwcmVkaWN0ZWRfY2xhc3NfaWQlNUQlMEElMEElMjMlMjBUbyUyMHRyYWluJTIwYSUyMG1vZGVsJTIwb24lMjAlNjBudW1fbGFiZWxzJTYwJTIwY2xhc3NlcyUyQyUyMHlvdSUyMGNhbiUyMHBhc3MlMjAlNjBudW1fbGFiZWxzJTNEbnVtX2xhYmVscyU2MCUyMHRvJTIwJTYwLmZyb21fcHJldHJhaW5lZCguLi4pJTYwJTBBbnVtX2xhYmVscyUyMCUzRCUyMGxlbihtb2RlbC5jb25maWcuaWQybGFiZWwpJTBBbW9kZWwlMjAlM0QlMjBQaGltb2VGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZQaGktMy41LU1vRS1pbnN0cnVjdCUyMiUyQyUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzKSUwQSUwQWxhYmVscyUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUIxJTVEKSUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcyUwQXJvdW5kKGxvc3MuaXRlbSgpJTJDJTIwMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, PhimoeForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;microsoft/Phi-3.5-MoE-instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PhimoeForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;microsoft/Phi-3.5-MoE-instruct&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_id = logits.argmax().item()
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.id2label[predicted_class_id]
...

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on \`num_labels\` classes, you can pass \`num_labels=num_labels\` to \`.from_pretrained(...)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PhimoeForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;microsoft/Phi-3.5-MoE-instruct&quot;</span>, num_labels=num_labels)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.tensor([<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(loss.item(), <span class="hljs-number">2</span>)
...`,wrap:!1}}),{c(){t=h("p"),t.textContent=p,n=l(),y(a.$$.fragment)},l(o){t=u(o,"P",{"data-svelte-h":!0}),k(t)!=="svelte-ykxpe4"&&(t.textContent=p),n=d(o),M(a.$$.fragment,o)},m(o,g){i(o,t,g),i(o,n,g),T(a,o,g),f=!0},p:Te,i(o){f||(w(a.$$.fragment,o),f=!0)},o(o){v(a.$$.fragment,o),f=!1},d(o){o&&(r(t),r(n)),C(a,o)}}}function mt(j){let t,p="Example of multi-label classification:",n,a,f;return a=new Ze({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMFBoaW1vZUZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZQaGktMy41LU1vRS1pbnN0cnVjdCUyMiklMEFtb2RlbCUyMCUzRCUyMFBoaW1vZUZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRlBoaS0zLjUtTW9FLWluc3RydWN0JTIyJTJDJTIwcHJvYmxlbV90eXBlJTNEJTIybXVsdGlfbGFiZWxfY2xhc3NpZmljYXRpb24lMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJlZGljdGVkX2NsYXNzX2lkcyUyMCUzRCUyMHRvcmNoLmFyYW5nZSgwJTJDJTIwbG9naXRzLnNoYXBlJTVCLTElNUQpJTVCdG9yY2guc2lnbW9pZChsb2dpdHMpLnNxdWVlemUoZGltJTNEMCklMjAlM0UlMjAwLjUlNUQlMEElMEElMjMlMjBUbyUyMHRyYWluJTIwYSUyMG1vZGVsJTIwb24lMjAlNjBudW1fbGFiZWxzJTYwJTIwY2xhc3NlcyUyQyUyMHlvdSUyMGNhbiUyMHBhc3MlMjAlNjBudW1fbGFiZWxzJTNEbnVtX2xhYmVscyU2MCUyMHRvJTIwJTYwLmZyb21fcHJldHJhaW5lZCguLi4pJTYwJTBBbnVtX2xhYmVscyUyMCUzRCUyMGxlbihtb2RlbC5jb25maWcuaWQybGFiZWwpJTBBbW9kZWwlMjAlM0QlMjBQaGltb2VGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJtaWNyb3NvZnQlMkZQaGktMy41LU1vRS1pbnN0cnVjdCUyMiUyQyUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzJTJDJTIwcHJvYmxlbV90eXBlJTNEJTIybXVsdGlfbGFiZWxfY2xhc3NpZmljYXRpb24lMjIlMEEpJTBBJTBBbGFiZWxzJTIwJTNEJTIwdG9yY2guc3VtKCUwQSUyMCUyMCUyMCUyMHRvcmNoLm5uLmZ1bmN0aW9uYWwub25lX2hvdChwcmVkaWN0ZWRfY2xhc3NfaWRzJTVCTm9uZSUyQyUyMCUzQSU1RC5jbG9uZSgpJTJDJTIwbnVtX2NsYXNzZXMlM0RudW1fbGFiZWxzKSUyQyUyMGRpbSUzRDElMEEpLnRvKHRvcmNoLmZsb2F0KSUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, PhimoeForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;microsoft/Phi-3.5-MoE-instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PhimoeForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;microsoft/Phi-3.5-MoE-instruct&quot;</span>, problem_type=<span class="hljs-string">&quot;multi_label_classification&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_ids = torch.arange(<span class="hljs-number">0</span>, logits.shape[-<span class="hljs-number">1</span>])[torch.sigmoid(logits).squeeze(dim=<span class="hljs-number">0</span>) &gt; <span class="hljs-number">0.5</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on \`num_labels\` classes, you can pass \`num_labels=num_labels\` to \`.from_pretrained(...)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PhimoeForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;microsoft/Phi-3.5-MoE-instruct&quot;</span>, num_labels=num_labels, problem_type=<span class="hljs-string">&quot;multi_label_classification&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.<span class="hljs-built_in">sum</span>(
<span class="hljs-meta">... </span>    torch.nn.functional.one_hot(predicted_class_ids[<span class="hljs-literal">None</span>, :].clone(), num_classes=num_labels), dim=<span class="hljs-number">1</span>
<span class="hljs-meta">... </span>).to(torch.<span class="hljs-built_in">float</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss`,wrap:!1}}),{c(){t=h("p"),t.textContent=p,n=l(),y(a.$$.fragment)},l(o){t=u(o,"P",{"data-svelte-h":!0}),k(t)!=="svelte-1l8e32d"&&(t.textContent=p),n=d(o),M(a.$$.fragment,o)},m(o,g){i(o,t,g),i(o,n,g),T(a,o,g),f=!0},p:Te,i(o){f||(w(a.$$.fragment,o),f=!0)},o(o){v(a.$$.fragment,o),f=!1},d(o){o&&(r(t),r(n)),C(a,o)}}}function pt(j){let t,p,n,a,f,o,g="The bare Phimoe Model outputting raw hidden-states without any specific head on top.",pe,F,I=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,ee,x,B=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,R,m,$,te,he,Ue='The <a href="/docs/transformers/main/en/model_doc/phimoe#transformers.PhimoeModel">PhimoeModel</a> forward method, overrides the <code>__call__</code> special method.',oe,ne,ue,W,xe,z,q,we,J,de,ve,G,Pe='The <a href="/docs/transformers/main/en/model_doc/phimoe#transformers.PhimoeForCausalLM">PhimoeForCausalLM</a> forward method, overrides the <code>__call__</code> special method.',A,E,se,S,ae,Z,P,re,ce,fe="Generates sequences of token ids for models with a language modeling head.",ze,Y,V,D,Q,U,L,Ce,O,Ie=`The Phimoe Model transformer with a sequence classification head on top (linear layer).
<a href="/docs/transformers/main/en/model_doc/phimoe#transformers.PhimoeForSequenceClassification">PhimoeForSequenceClassification</a> uses the last token in order to do the classification, as other causal models
(e.g. GPT-2) do.
Since it does classification on the last token, it requires to know the position of the last token. If a
<code>pad_token_id</code> is defined in the configuration, it finds the last token that is not a padding token in each row. If
no <code>pad_token_id</code> is defined, it simply takes the last value in each row of the batch. Since it cannot guess the
padding tokens when <code>inputs_embeds</code> are passed instead of <code>input_ids</code>, it does the same (take the last value in
each row of the batch).`,e,c,K=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,We,ge,Qe=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Be,N,Fe,Re,qe,He='The <a href="/docs/transformers/main/en/model_doc/phimoe#transformers.PhimoeForSequenceClassification">PhimoeForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',Ee,ke,Se,je,Ve,$e,Ge;return t=new Me({props:{title:"PhimoeModel",local:"transformers.PhimoeModel",headingTag:"h2"}}),a=new Je({props:{name:"class transformers.PhimoeModel",anchor:"transformers.PhimoeModel",parameters:[{name:"config",val:": PhimoeConfig"}],parametersDescription:[{anchor:"transformers.PhimoeModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/phimoe#transformers.PhimoeConfig">PhimoeConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/phimoe/modeling_phimoe.py#L906"}}),$=new Je({props:{name:"forward",anchor:"transformers.PhimoeModel.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_router_logits",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"}],parametersDescription:[{anchor:"transformers.PhimoeModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.PhimoeModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PhimoeModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.PhimoeModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>List[torch.FloatTensor]</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.PhimoeModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.PhimoeModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.PhimoeModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PhimoeModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PhimoeModel.forward.output_router_logits",description:`<strong>output_router_logits</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the logits of all the routers. They are useful for computing the router loss, and
should not be returned during inference.`,name:"output_router_logits"},{anchor:"transformers.PhimoeModel.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/phimoe/modeling_phimoe.py#L937",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.modeling_outputs.MoeModelOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/phimoe#transformers.PhimoeConfig"
>PhimoeConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>Cache</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — It is a <a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache"
>Cache</a> instance. For more details, see our <a
  href="https://huggingface.co/docs/transformers/en/kv_cache"
  rel="nofollow"
>kv cache guide</a>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and optionally if
<code>config.is_encoder_decoder=True</code> in the cross-attention blocks) that can be used (see <code>past_key_values</code>
input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>router_logits</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_router_probs=True</code> and <code>config.add_router_probs=True</code> is passed or when <code>config.output_router_probs=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, sequence_length, num_experts)</code>.</p>
<p>Raw router logtis (post-softmax) that are computed by MoE routers, these terms are used to compute the auxiliary
loss for Mixture of Experts models.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.modeling_outputs.MoeModelOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ne=new Le({props:{$$slots:{default:[at]},$$scope:{ctx:j}}}),W=new Me({props:{title:"PhimoeForCausalLM",local:"transformers.PhimoeForCausalLM",headingTag:"h2"}}),q=new Je({props:{name:"class transformers.PhimoeForCausalLM",anchor:"transformers.PhimoeForCausalLM",parameters:[{name:"config",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/phimoe/modeling_phimoe.py#L1227"}}),de=new Je({props:{name:"forward",anchor:"transformers.PhimoeForCausalLM.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_router_logits",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"logits_to_keep",val:": typing.Union[int, torch.Tensor] = 0"},{name:"**loss_kwargs",val:""}],parametersDescription:[{anchor:"transformers.PhimoeForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.PhimoeForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PhimoeForCausalLM.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.PhimoeForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>List[torch.FloatTensor]</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.PhimoeForCausalLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.PhimoeForCausalLM.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"labels"},{anchor:"transformers.PhimoeForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.PhimoeForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PhimoeForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PhimoeForCausalLM.forward.output_router_logits",description:`<strong>output_router_logits</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the logits of all the routers. They are useful for computing the router loss, and
should not be returned during inference.`,name:"output_router_logits"},{anchor:"transformers.PhimoeForCausalLM.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"},{anchor:"transformers.PhimoeForCausalLM.forward.logits_to_keep",description:`<strong>logits_to_keep</strong> (<code>Union[int, torch.Tensor]</code>, defaults to <code>0</code>) &#x2014;
If an <code>int</code>, compute logits for the last <code>logits_to_keep</code> tokens. If <code>0</code>, calculate logits for all
<code>input_ids</code> (special case). Only last token logits are needed for generation, and calculating them only for that
token can save memory, which becomes pretty significant for long sequences or large vocabulary size.
If a <code>torch.Tensor</code>, must be 1D corresponding to the indices to keep in the sequence length dimension.
This is useful when using packed tensor format (single dimension for batch and sequence length).`,name:"logits_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/phimoe/modeling_phimoe.py#L1265",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.modeling_outputs.MoeCausalLMOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/phimoe#transformers.PhimoeConfig"
>PhimoeConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>aux_loss</strong> (<code>torch.FloatTensor</code>, <em>optional</em>, returned when <code>labels</code> is provided) — aux_loss for the sparse modules.</p>
</li>
<li>
<p><strong>router_logits</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_router_probs=True</code> and <code>config.add_router_probs=True</code> is passed or when <code>config.output_router_probs=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, sequence_length, num_experts)</code>.</p>
<p>Raw router logtis (post-softmax) that are computed by MoE routers, these terms are used to compute the auxiliary
loss for Mixture of Experts models.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>Cache</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — It is a <a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache"
>Cache</a> instance. For more details, see our <a
  href="https://huggingface.co/docs/transformers/en/kv_cache"
  rel="nofollow"
>kv cache guide</a>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.modeling_outputs.MoeCausalLMOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),E=new Le({props:{$$slots:{default:[rt]},$$scope:{ctx:j}}}),S=new Ne({props:{anchor:"transformers.PhimoeForCausalLM.forward.example",$$slots:{default:[it]},$$scope:{ctx:j}}}),P=new Je({props:{name:"generate",anchor:"transformers.PhimoeForCausalLM.generate",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"generation_config",val:": typing.Optional[transformers.generation.configuration_utils.GenerationConfig] = None"},{name:"logits_processor",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"stopping_criteria",val:": typing.Optional[transformers.generation.stopping_criteria.StoppingCriteriaList] = None"},{name:"prefix_allowed_tokens_fn",val:": typing.Optional[typing.Callable[[int, torch.Tensor], typing.List[int]]] = None"},{name:"synced_gpus",val:": typing.Optional[bool] = None"},{name:"assistant_model",val:": typing.Optional[ForwardRef('PreTrainedModel')] = None"},{name:"streamer",val:": typing.Optional[ForwardRef('BaseStreamer')] = None"},{name:"negative_prompt_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"use_model_defaults",val:": typing.Optional[bool] = None"},{name:"custom_generate",val:": typing.Optional[str] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PhimoeForCausalLM.generate.inputs",description:`<strong>inputs</strong> (<code>torch.Tensor</code> of varying shape depending on the modality, <em>optional</em>) &#x2014;
The sequence used as a prompt for the generation or as model inputs to the encoder. If <code>None</code> the
method initializes it with <code>bos_token_id</code> and a batch size of 1. For decoder-only models <code>inputs</code>
should be in the format of <code>input_ids</code>. For encoder-decoder models <em>inputs</em> can represent any of
<code>input_ids</code>, <code>input_values</code>, <code>input_features</code>, or <code>pixel_values</code>.`,name:"inputs"},{anchor:"transformers.PhimoeForCausalLM.generate.generation_config",description:`<strong>generation_config</strong> (<a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>, <em>optional</em>) &#x2014;
The generation configuration to be used as base parametrization for the generation call. <code>**kwargs</code>
passed to generate matching the attributes of <code>generation_config</code> will override them. If
<code>generation_config</code> is not provided, the default will be used, which has the following loading
priority: 1) from the <code>generation_config.json</code> model file, if it exists; 2) from the model
configuration. Please note that unspecified parameters will inherit <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>&#x2019;s
default values, whose documentation should be checked to parameterize generation.`,name:"generation_config"},{anchor:"transformers.PhimoeForCausalLM.generate.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
Custom logits processors that complement the default logits processors built from arguments and
generation config. If a logit processor is passed that is already created with the arguments or a
generation config an error is thrown. This feature is intended for advanced users.`,name:"logits_processor"},{anchor:"transformers.PhimoeForCausalLM.generate.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
Custom stopping criteria that complements the default stopping criteria built from arguments and a
generation config. If a stopping criteria is passed that is already created with the arguments or a
generation config an error is thrown. If your stopping criteria depends on the <code>scores</code> input, make
sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>. This feature is
intended for advanced users.`,name:"stopping_criteria"},{anchor:"transformers.PhimoeForCausalLM.generate.prefix_allowed_tokens_fn",description:`<strong>prefix_allowed_tokens_fn</strong> (<code>Callable[[int, torch.Tensor], List[int]]</code>, <em>optional</em>) &#x2014;
If provided, this function constraints the beam search to allowed tokens only at each step. If not
provided no constraint is applied. This function takes 2 arguments: the batch ID <code>batch_id</code> and
<code>input_ids</code>. It has to return a list with the allowed tokens for the next generation step conditioned
on the batch ID <code>batch_id</code> and the previously generated tokens <code>inputs_ids</code>. This argument is useful
for constrained generation conditioned on the prefix, as described in <a href="https://arxiv.org/abs/2010.00904" rel="nofollow">Autoregressive Entity
Retrieval</a>.`,name:"prefix_allowed_tokens_fn"},{anchor:"transformers.PhimoeForCausalLM.generate.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to continue running the while loop until max_length. Unless overridden, this flag will be set
to <code>True</code> if using <code>FullyShardedDataParallel</code> or DeepSpeed ZeRO Stage 3 with multiple GPUs to avoid
deadlocking if one GPU finishes generating before other GPUs. Otherwise, defaults to <code>False</code>.`,name:"synced_gpus"},{anchor:"transformers.PhimoeForCausalLM.generate.assistant_model",description:`<strong>assistant_model</strong> (<code>PreTrainedModel</code>, <em>optional</em>) &#x2014;
An assistant model that can be used to accelerate generation. The assistant model must have the exact
same tokenizer. The acceleration is achieved when forecasting candidate tokens with the assistant model
is much faster than running generation with the model you&#x2019;re calling generate from. As such, the
assistant model should be much smaller.`,name:"assistant_model"},{anchor:"transformers.PhimoeForCausalLM.generate.streamer",description:`<strong>streamer</strong> (<code>BaseStreamer</code>, <em>optional</em>) &#x2014;
Streamer object that will be used to stream the generated sequences. Generated tokens are passed
through <code>streamer.put(token_ids)</code> and the streamer is responsible for any further processing.`,name:"streamer"},{anchor:"transformers.PhimoeForCausalLM.generate.negative_prompt_ids",description:`<strong>negative_prompt_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
The negative prompt needed for some processors such as CFG. The batch size must match the input batch
size. This is an experimental feature, subject to breaking API changes in future versions.`,name:"negative_prompt_ids"},{anchor:"transformers.PhimoeForCausalLM.generate.negative_prompt_attention_mask",description:`<strong>negative_prompt_attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Attention_mask for <code>negative_prompt_ids</code>.`,name:"negative_prompt_attention_mask"},{anchor:"transformers.PhimoeForCausalLM.generate.use_model_defaults",description:`<strong>use_model_defaults</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
When it is <code>True</code>, unset parameters in <code>generation_config</code> will be set to the model-specific default
generation configuration (<code>model.generation_config</code>), as opposed to the global defaults
(<code>GenerationConfig()</code>). If unset, models saved starting from <code>v4.50</code> will consider this flag to be
<code>True</code>.`,name:"use_model_defaults"},{anchor:"transformers.PhimoeForCausalLM.generate.custom_generate",description:`<strong>custom_generate</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A string containing the name of a huggingface.co repository. If provided, the custom <code>generate</code>
function defined in that reposity&#x2019;s <code>custom_generate/generate.py</code> file will be executed instead of the
standard <code>generate</code> method. Note that the logic is for generation is entirely defined in that
repository, and the return type may be different from the standard <code>generate</code> method.`,name:"custom_generate"},{anchor:"transformers.PhimoeForCausalLM.generate.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Ad hoc parametrization of <code>generation_config</code> and/or additional model-specific kwargs that will be
forwarded to the <code>forward</code> function of the model. If the model is an encoder-decoder model, encoder
specific kwargs should not be prefixed and decoder specific kwargs should be prefixed with <em>decoder_</em>.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/utils.py#L2235",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> (if <code>return_dict_in_generate=True</code>
or when <code>config.return_dict_in_generate=True</code>) or a <code>torch.LongTensor</code>.</p>
<p>If the model is <em>not</em> an encoder-decoder model (<code>model.config.is_encoder_decoder=False</code>), the possible
<a
  href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.generation.GenerateDecoderOnlyOutput"
>GenerateDecoderOnlyOutput</a>,</li>
<li><a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.generation.GenerateBeamDecoderOnlyOutput"
>GenerateBeamDecoderOnlyOutput</a></li>
</ul>
<p>If the model is an encoder-decoder model (<code>model.config.is_encoder_decoder=True</code>), the possible
<a
  href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.generation.GenerateEncoderDecoderOutput"
>GenerateEncoderDecoderOutput</a>,</li>
<li><a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.generation.GenerateBeamEncoderDecoderOutput"
>GenerateBeamEncoderDecoderOutput</a></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> or <code>torch.LongTensor</code></p>
`}}),Y=new Le({props:{warning:!0,$$slots:{default:[lt]},$$scope:{ctx:j}}}),D=new Me({props:{title:"PhimoeForSequenceClassification",local:"transformers.PhimoeForSequenceClassification",headingTag:"h2"}}),L=new Je({props:{name:"class transformers.PhimoeForSequenceClassification",anchor:"transformers.PhimoeForSequenceClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.PhimoeForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/phimoe#transformers.PhimoeForSequenceClassification">PhimoeForSequenceClassification</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/phimoe/modeling_phimoe.py#L1404"}}),Fe=new Je({props:{name:"forward",anchor:"transformers.PhimoeForSequenceClassification.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[transformers.cache_utils.Cache] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.PhimoeForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.PhimoeForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PhimoeForSequenceClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.PhimoeForSequenceClassification.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>~cache_utils.Cache</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.PhimoeForSequenceClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.PhimoeForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"},{anchor:"transformers.PhimoeForSequenceClassification.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.PhimoeForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PhimoeForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/phimoe/modeling_phimoe.py#L1433",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.modeling_outputs.SequenceClassifierOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/phimoe#transformers.PhimoeConfig"
>PhimoeConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>Cache</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — It is a <a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache"
>Cache</a> instance. For more details, see our <a
  href="https://huggingface.co/docs/transformers/en/kv_cache"
  rel="nofollow"
>kv cache guide</a>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.modeling_outputs.SequenceClassifierOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ke=new Le({props:{$$slots:{default:[dt]},$$scope:{ctx:j}}}),je=new Ne({props:{anchor:"transformers.PhimoeForSequenceClassification.forward.example",$$slots:{default:[ct]},$$scope:{ctx:j}}}),$e=new Ne({props:{anchor:"transformers.PhimoeForSequenceClassification.forward.example-2",$$slots:{default:[mt]},$$scope:{ctx:j}}}),{c(){y(t.$$.fragment),p=l(),n=h("div"),y(a.$$.fragment),f=l(),o=h("p"),o.textContent=g,pe=l(),F=h("p"),F.innerHTML=I,ee=l(),x=h("p"),x.innerHTML=B,R=l(),m=h("div"),y($.$$.fragment),te=l(),he=h("p"),he.innerHTML=Ue,oe=l(),y(ne.$$.fragment),ue=l(),y(W.$$.fragment),xe=l(),z=h("div"),y(q.$$.fragment),we=l(),J=h("div"),y(de.$$.fragment),ve=l(),G=h("p"),G.innerHTML=Pe,A=l(),y(E.$$.fragment),se=l(),y(S.$$.fragment),ae=l(),Z=h("div"),y(P.$$.fragment),re=l(),ce=h("p"),ce.textContent=fe,ze=l(),y(Y.$$.fragment),V=l(),y(D.$$.fragment),Q=l(),U=h("div"),y(L.$$.fragment),Ce=l(),O=h("p"),O.innerHTML=Ie,e=l(),c=h("p"),c.innerHTML=K,We=l(),ge=h("p"),ge.innerHTML=Qe,Be=l(),N=h("div"),y(Fe.$$.fragment),Re=l(),qe=h("p"),qe.innerHTML=He,Ee=l(),y(ke.$$.fragment),Se=l(),y(je.$$.fragment),Ve=l(),y($e.$$.fragment),this.h()},l(s){M(t.$$.fragment,s),p=d(s),n=u(s,"DIV",{class:!0});var b=me(n);M(a.$$.fragment,b),f=d(b),o=u(b,"P",{"data-svelte-h":!0}),k(o)!=="svelte-34hkmq"&&(o.textContent=g),pe=d(b),F=u(b,"P",{"data-svelte-h":!0}),k(F)!=="svelte-6pahdo"&&(F.innerHTML=I),ee=d(b),x=u(b,"P",{"data-svelte-h":!0}),k(x)!=="svelte-hswkmf"&&(x.innerHTML=B),R=d(b),m=u(b,"DIV",{class:!0});var _e=me(m);M($.$$.fragment,_e),te=d(_e),he=u(_e,"P",{"data-svelte-h":!0}),k(he)!=="svelte-1kscpt1"&&(he.innerHTML=Ue),oe=d(_e),M(ne.$$.fragment,_e),_e.forEach(r),b.forEach(r),ue=d(s),M(W.$$.fragment,s),xe=d(s),z=u(s,"DIV",{class:!0});var be=me(z);M(q.$$.fragment,be),we=d(be),J=u(be,"DIV",{class:!0});var ie=me(J);M(de.$$.fragment,ie),ve=d(ie),G=u(ie,"P",{"data-svelte-h":!0}),k(G)!=="svelte-1snalrt"&&(G.innerHTML=Pe),A=d(ie),M(E.$$.fragment,ie),se=d(ie),M(S.$$.fragment,ie),ie.forEach(r),ae=d(be),Z=u(be,"DIV",{class:!0});var ye=me(Z);M(P.$$.fragment,ye),re=d(ye),ce=u(ye,"P",{"data-svelte-h":!0}),k(ce)!=="svelte-s5ko3x"&&(ce.textContent=fe),ze=d(ye),M(Y.$$.fragment,ye),ye.forEach(r),be.forEach(r),V=d(s),M(D.$$.fragment,s),Q=d(s),U=u(s,"DIV",{class:!0});var H=me(U);M(L.$$.fragment,H),Ce=d(H),O=u(H,"P",{"data-svelte-h":!0}),k(O)!=="svelte-14qa0ta"&&(O.innerHTML=Ie),e=d(H),c=u(H,"P",{"data-svelte-h":!0}),k(c)!=="svelte-6pahdo"&&(c.innerHTML=K),We=d(H),ge=u(H,"P",{"data-svelte-h":!0}),k(ge)!=="svelte-hswkmf"&&(ge.innerHTML=Qe),Be=d(H),N=u(H,"DIV",{class:!0});var X=me(N);M(Fe.$$.fragment,X),Re=d(X),qe=u(X,"P",{"data-svelte-h":!0}),k(qe)!=="svelte-1wwhu3t"&&(qe.innerHTML=He),Ee=d(X),M(ke.$$.fragment,X),Se=d(X),M(je.$$.fragment,X),Ve=d(X),M($e.$$.fragment,X),X.forEach(r),H.forEach(r),this.h()},h(){le(m,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),le(n,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),le(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),le(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),le(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),le(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),le(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(s,b){T(t,s,b),i(s,p,b),i(s,n,b),T(a,n,null),_(n,f),_(n,o),_(n,pe),_(n,F),_(n,ee),_(n,x),_(n,R),_(n,m),T($,m,null),_(m,te),_(m,he),_(m,oe),T(ne,m,null),i(s,ue,b),T(W,s,b),i(s,xe,b),i(s,z,b),T(q,z,null),_(z,we),_(z,J),T(de,J,null),_(J,ve),_(J,G),_(J,A),T(E,J,null),_(J,se),T(S,J,null),_(z,ae),_(z,Z),T(P,Z,null),_(Z,re),_(Z,ce),_(Z,ze),T(Y,Z,null),i(s,V,b),T(D,s,b),i(s,Q,b),i(s,U,b),T(L,U,null),_(U,Ce),_(U,O),_(U,e),_(U,c),_(U,We),_(U,ge),_(U,Be),_(U,N),T(Fe,N,null),_(N,Re),_(N,qe),_(N,Ee),T(ke,N,null),_(N,Se),T(je,N,null),_(N,Ve),T($e,N,null),Ge=!0},p(s,b){const _e={};b&2&&(_e.$$scope={dirty:b,ctx:s}),ne.$set(_e);const be={};b&2&&(be.$$scope={dirty:b,ctx:s}),E.$set(be);const ie={};b&2&&(ie.$$scope={dirty:b,ctx:s}),S.$set(ie);const ye={};b&2&&(ye.$$scope={dirty:b,ctx:s}),Y.$set(ye);const H={};b&2&&(H.$$scope={dirty:b,ctx:s}),ke.$set(H);const X={};b&2&&(X.$$scope={dirty:b,ctx:s}),je.$set(X);const Xe={};b&2&&(Xe.$$scope={dirty:b,ctx:s}),$e.$set(Xe)},i(s){Ge||(w(t.$$.fragment,s),w(a.$$.fragment,s),w($.$$.fragment,s),w(ne.$$.fragment,s),w(W.$$.fragment,s),w(q.$$.fragment,s),w(de.$$.fragment,s),w(E.$$.fragment,s),w(S.$$.fragment,s),w(P.$$.fragment,s),w(Y.$$.fragment,s),w(D.$$.fragment,s),w(L.$$.fragment,s),w(Fe.$$.fragment,s),w(ke.$$.fragment,s),w(je.$$.fragment,s),w($e.$$.fragment,s),Ge=!0)},o(s){v(t.$$.fragment,s),v(a.$$.fragment,s),v($.$$.fragment,s),v(ne.$$.fragment,s),v(W.$$.fragment,s),v(q.$$.fragment,s),v(de.$$.fragment,s),v(E.$$.fragment,s),v(S.$$.fragment,s),v(P.$$.fragment,s),v(Y.$$.fragment,s),v(D.$$.fragment,s),v(L.$$.fragment,s),v(Fe.$$.fragment,s),v(ke.$$.fragment,s),v(je.$$.fragment,s),v($e.$$.fragment,s),Ge=!1},d(s){s&&(r(p),r(n),r(ue),r(xe),r(z),r(V),r(Q),r(U)),C(t,s),C(a),C($),C(ne),C(W,s),C(q),C(de),C(E),C(S),C(P),C(Y),C(D,s),C(L),C(Fe),C(ke),C(je),C($e)}}}function ht(j){let t,p;return t=new tt({props:{$$slots:{default:[pt]},$$scope:{ctx:j}}}),{c(){y(t.$$.fragment)},l(n){M(t.$$.fragment,n)},m(n,a){T(t,n,a),p=!0},p(n,a){const f={};a&2&&(f.$$scope={dirty:a,ctx:n}),t.$set(f)},i(n){p||(w(t.$$.fragment,n),p=!0)},o(n){v(t.$$.fragment,n),p=!1},d(n){C(t,n)}}}function ut(j){let t,p,n,a,f,o,g,pe='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/> <img alt="FlashAttention" src="https://img.shields.io/badge/%E2%9A%A1%EF%B8%8E%20FlashAttention-eae0c8?style=flat"/> <img alt="SDPA" src="https://img.shields.io/badge/SDPA-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',F,I,ee,x,B='The PhiMoE model was proposed in <a href="https://arxiv.org/abs/2404.14219" rel="nofollow">Phi-3 Technical Report: A Highly Capable Language Model Locally on Your Phone</a> by Microsoft.',R,m,$,te,he="The abstract from the Phi-3 paper is the following:",Ue,oe,ne="We introduce phi-3-mini, a 3.8 billion parameter language model trained on 3.3 trillion tokens, whose overall performance, as measured by both academic benchmarks and internal testing, rivals that of models such as Mixtral 8x7B and GPT-3.5 (e.g., phi-3-mini achieves 69% on MMLU and 8.38 on MT-bench), despite being small enough to be deployed on a phone. Our training dataset is a scaled-up version of the one used for phi-2, composed of heavily filtered publicly available web data and synthetic data. The model is also further aligned for robustness, safety, and chat format. We also provide parameter-scaling results with a 7B, 14B models trained for 4.8T tokens, called phi-3-small, phi-3-medium, both significantly more capable than phi-3-mini (e.g., respectively 75%, 78% on MMLU, and 8.7, 8.9 on MT-bench). To enhance multilingual, multimodal, and long-context capabilities, we introduce three models in the phi-3.5 series: phi-3.5-mini, phi-3.5-MoE, and phi-3.5-Vision. The phi-3.5-MoE, a 16 x 3.8B MoE model with 6.6 billion active parameters, achieves superior performance in language reasoning, math, and code tasks compared to other open-source models of similar scale, such as Llama 3.1 and the Mixtral series, and on par with Gemini-1.5-Flash and GPT-4o-mini. Meanwhile, phi-3.5-Vision, a 4.2 billion parameter model derived from phi-3.5-mini, excels in reasoning tasks and is adept at handling both single-image and text prompts, as well as multi-image and text prompts.",ue,W,xe='The original code for PhiMoE can be found <a href="https://huggingface.co/microsoft/Phi-3.5-MoE-instruct" rel="nofollow">here</a>.',z,q,we,J,de='<li>This model is very similar to <code>Mixtral</code> with the main difference of <code>Phi3LongRoPEScaledRotaryEmbedding</code>, where they are used to extend the context of the rotary embeddings. The query, key and values are fused, and the MLP’s up and gate projection layers are also fused.</li> <li>The tokenizer used for this model is identical to the <a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaTokenizer">LlamaTokenizer</a>, with the exception of additional tokens.</li>',ve,G,Pe,A,E,se,S,ae,Z,P,re,ce,fe,ze=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/phimoe#transformers.PhimoeModel">PhimoeModel</a>. It is used to instantiate a Phi-moe
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the
<a href="https://huggingface.co/microsoft/Phi-3.5-MoE-instruct" rel="nofollow">microsoft/Phi-3.5-MoE-instruct</a>.
Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Y,V,D,Q,U,L,Ce,O,Ie;return f=new Me({props:{title:"PhiMoE",local:"phimoe",headingTag:"h1"}}),I=new Me({props:{title:"Overview",local:"overview",headingTag:"h2"}}),m=new Me({props:{title:"Summary",local:"summary",headingTag:"h3"}}),q=new Me({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),G=new Me({props:{title:"How to use PhiMoE",local:"how-to-use-phimoe",headingTag:"h2"}}),A=new Le({props:{warning:!0,$$slots:{default:[nt]},$$scope:{ctx:j}}}),se=new Ze({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, pipeline 

torch.random.manual_seed(<span class="hljs-number">0</span>) 

model = AutoModelForCausalLM.from_pretrained( 
    <span class="hljs-string">&quot;microsoft/Phi-3.5-MoE-instruct&quot;</span>,  
    device_map=<span class="hljs-string">&quot;cuda&quot;</span>,  
    torch_dtype=<span class="hljs-string">&quot;auto&quot;</span>,  
    trust_remote_code=<span class="hljs-literal">True</span>,  
) 

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;microsoft/Phi-3.5-MoE-instruct&quot;</span>) 

messages = [ 
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful AI assistant.&quot;</span>}, 
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Can you provide ways to eat combinations of bananas and dragonfruits?&quot;</span>}, 
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Sure! Here are some ways to eat bananas and dragonfruits together: 1. Banana and dragonfruit smoothie: Blend bananas and dragonfruits together with some milk and honey. 2. Banana and dragonfruit salad: Mix sliced bananas and dragonfruits together with some lemon juice and honey.&quot;</span>}, 
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What about solving an 2x + 3 = 7 equation?&quot;</span>}, 
] 

pipe = pipeline( 
    <span class="hljs-string">&quot;text-generation&quot;</span>, 
    model=model, 
    tokenizer=tokenizer, 
) 

generation_args = { 
    <span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">500</span>, 
    <span class="hljs-string">&quot;return_full_text&quot;</span>: <span class="hljs-literal">False</span>, 
    <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">0.0</span>, 
    <span class="hljs-string">&quot;do_sample&quot;</span>: <span class="hljs-literal">False</span>, 
} 

output = pipe(messages, **generation_args) 
<span class="hljs-built_in">print</span>(output[<span class="hljs-number">0</span>][<span class="hljs-string">&#x27;generated_text&#x27;</span>])`,wrap:!1}}),ae=new Me({props:{title:"PhimoeConfig",local:"transformers.PhimoeConfig",headingTag:"h2"}}),re=new Je({props:{name:"class transformers.PhimoeConfig",anchor:"transformers.PhimoeConfig",parameters:[{name:"vocab_size",val:" = 32064"},{name:"hidden_size",val:" = 4096"},{name:"intermediate_size",val:" = 6400"},{name:"num_hidden_layers",val:" = 32"},{name:"num_attention_heads",val:" = 32"},{name:"num_key_value_heads",val:" = 8"},{name:"hidden_act",val:" = 'silu'"},{name:"max_position_embeddings",val:" = 131072"},{name:"initializer_range",val:" = 0.02"},{name:"rms_norm_eps",val:" = 1e-05"},{name:"use_cache",val:" = True"},{name:"pad_token_id",val:" = None"},{name:"bos_token_id",val:" = 1"},{name:"eos_token_id",val:" = 2"},{name:"tie_word_embeddings",val:" = False"},{name:"rope_theta",val:" = 1000000.0"},{name:"rope_scaling",val:" = None"},{name:"sliding_window",val:" = None"},{name:"attention_dropout",val:" = 0.0"},{name:"num_experts_per_tok",val:" = 2"},{name:"num_local_experts",val:" = 16"},{name:"output_router_logits",val:" = False"},{name:"router_aux_loss_coef",val:" = 0.001"},{name:"router_jitter_noise",val:" = 0.01"},{name:"input_jitter_noise",val:" = 0.0"},{name:"attention_bias",val:" = False"},{name:"lm_head_bias",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PhimoeConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 32064) &#x2014;
Vocabulary size of the Phimoe model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/phimoe#transformers.PhimoeModel">PhimoeModel</a>`,name:"vocab_size"},{anchor:"transformers.PhimoeConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Dimension of the hidden representations.`,name:"hidden_size"},{anchor:"transformers.PhimoeConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 6400) &#x2014;
Dimension of the MLP representations.`,name:"intermediate_size"},{anchor:"transformers.PhimoeConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.PhimoeConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.PhimoeConfig.num_key_value_heads",description:`<strong>num_key_value_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
This is the number of key_value heads that should be used to implement Grouped Query Attention. If
<code>num_key_value_heads=num_attention_heads</code>, the model will use Multi Head Attention (MHA), if
<code>num_key_value_heads=1</code> the model will use Multi Query Attention (MQA) otherwise GQA is used. When
converting a multi-head checkpoint to a GQA checkpoint, each group key and value head should be constructed
by meanpooling all the original heads within that group. For more details, check out <a href="https://arxiv.org/pdf/2305.13245.pdf" rel="nofollow">this
paper</a>. If it is not specified, will default to <code>8</code>.`,name:"num_key_value_heads"},{anchor:"transformers.PhimoeConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;silu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the decoder.`,name:"hidden_act"},{anchor:"transformers.PhimoeConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to <code>4096*32</code>) &#x2014;
The maximum sequence length that this model might ever be used with. Mixtral&#x2019;s sliding window attention
allows sequence of up to 4096*32 tokens.`,name:"max_position_embeddings"},{anchor:"transformers.PhimoeConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.PhimoeConfig.rms_norm_eps",description:`<strong>rms_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the rms normalization layers.`,name:"rms_norm_eps"},{anchor:"transformers.PhimoeConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models). Only
relevant if <code>config.is_decoder=True</code>.`,name:"use_cache"},{anchor:"transformers.PhimoeConfig.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the padding token.`,name:"pad_token_id"},{anchor:"transformers.PhimoeConfig.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The id of the &#x201C;beginning-of-sequence&#x201D; token.`,name:"bos_token_id"},{anchor:"transformers.PhimoeConfig.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The id of the &#x201C;end-of-sequence&#x201D; token.`,name:"eos_token_id"},{anchor:"transformers.PhimoeConfig.tie_word_embeddings",description:`<strong>tie_word_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the model&#x2019;s input and output word embeddings should be tied.`,name:"tie_word_embeddings"},{anchor:"transformers.PhimoeConfig.rope_theta",description:`<strong>rope_theta</strong> (<code>float</code>, <em>optional</em>, defaults to 1000000.0) &#x2014;
The base period of the RoPE embeddings.`,name:"rope_theta"},{anchor:"transformers.PhimoeConfig.rope_scaling",description:`<strong>rope_scaling</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
The scaling strategy for the RoPE embeddings. If <code>None</code>, no scaling is applied. If a dictionary, it must
contain the following keys: <code>type</code>, <code>short_factor</code>, <code>long_factor</code>, <code>short_mscale</code>, <code>long_mscale</code> and
<code>original_max_position_embeddings</code>. The <code>type</code> must be <code>longrope</code>, the <code>short_mscale</code> and <code>long_scale</code> must
be numbers, the <code>short_factor</code> and <code>long_factor</code> must be lists of numbers with the same length as half of
the attention head size and the <code>original_max_position_embeddings</code> must be an integer.`,name:"rope_scaling"},{anchor:"transformers.PhimoeConfig.sliding_window",description:`<strong>sliding_window</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Sliding window attention window size. If not specified, will default to <code>262144</code>.`,name:"sliding_window"},{anchor:"transformers.PhimoeConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.PhimoeConfig.num_experts_per_tok",description:`<strong>num_experts_per_tok</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The number of experts to root per-token, can be also interpreted as the <code>top-p</code> routing
parameter`,name:"num_experts_per_tok"},{anchor:"transformers.PhimoeConfig.num_local_experts",description:`<strong>num_local_experts</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of experts per Sparse MLP layer.`,name:"num_local_experts"},{anchor:"transformers.PhimoeConfig.output_router_logits",description:`<strong>output_router_logits</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the router logits should be returned by the model. Enabling this will also
allow the model to output the auxiliary loss. See <a href>here</a> for more details`,name:"output_router_logits"},{anchor:"transformers.PhimoeConfig.router_aux_loss_coef",description:`<strong>router_aux_loss_coef</strong> (<code>float</code>, <em>optional</em>, defaults to 0.001) &#x2014;
The aux loss factor for the total loss.`,name:"router_aux_loss_coef"},{anchor:"transformers.PhimoeConfig.router_jitter_noise",description:`<strong>router_jitter_noise</strong> (<code>float</code>, <em>optional</em>, defaults to 0.01) &#x2014;
Amount of noise to add to the router.`,name:"router_jitter_noise"},{anchor:"transformers.PhimoeConfig.input_jitter_noise",description:"<strong>input_jitter_noise</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014; Input jitter noise",name:"input_jitter_noise"},{anchor:"transformers.PhimoeConfig.attention_bias",description:"<strong>attention_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014; Attention bias",name:"attention_bias"},{anchor:"transformers.PhimoeConfig.lm_head_bias",description:"<strong>lm_head_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014; LM head bias",name:"lm_head_bias"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/phimoe/configuration_phimoe.py#L26"}}),V=new Ne({props:{anchor:"transformers.PhimoeConfig.example",$$slots:{default:[st]},$$scope:{ctx:j}}}),Q=new et({props:{pytorch:!0,tensorflow:!1,jax:!1,$$slots:{pytorch:[ht]},$$scope:{ctx:j}}}),L=new ot({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/phimoe.md"}}),{c(){t=h("meta"),p=l(),n=h("p"),a=l(),y(f.$$.fragment),o=l(),g=h("div"),g.innerHTML=pe,F=l(),y(I.$$.fragment),ee=l(),x=h("p"),x.innerHTML=B,R=l(),y(m.$$.fragment),$=l(),te=h("p"),te.textContent=he,Ue=l(),oe=h("p"),oe.textContent=ne,ue=l(),W=h("p"),W.innerHTML=xe,z=l(),y(q.$$.fragment),we=l(),J=h("ul"),J.innerHTML=de,ve=l(),y(G.$$.fragment),Pe=l(),y(A.$$.fragment),E=l(),y(se.$$.fragment),S=l(),y(ae.$$.fragment),Z=l(),P=h("div"),y(re.$$.fragment),ce=l(),fe=h("p"),fe.innerHTML=ze,Y=l(),y(V.$$.fragment),D=l(),y(Q.$$.fragment),U=l(),y(L.$$.fragment),Ce=l(),O=h("p"),this.h()},l(e){const c=Ke("svelte-u9bgzb",document.head);t=u(c,"META",{name:!0,content:!0}),c.forEach(r),p=d(e),n=u(e,"P",{}),me(n).forEach(r),a=d(e),M(f.$$.fragment,e),o=d(e),g=u(e,"DIV",{class:!0,"data-svelte-h":!0}),k(g)!=="svelte-b95w5j"&&(g.innerHTML=pe),F=d(e),M(I.$$.fragment,e),ee=d(e),x=u(e,"P",{"data-svelte-h":!0}),k(x)!=="svelte-w1paw9"&&(x.innerHTML=B),R=d(e),M(m.$$.fragment,e),$=d(e),te=u(e,"P",{"data-svelte-h":!0}),k(te)!=="svelte-1iah8ch"&&(te.textContent=he),Ue=d(e),oe=u(e,"P",{"data-svelte-h":!0}),k(oe)!=="svelte-dp2ft6"&&(oe.textContent=ne),ue=d(e),W=u(e,"P",{"data-svelte-h":!0}),k(W)!=="svelte-weehy4"&&(W.innerHTML=xe),z=d(e),M(q.$$.fragment,e),we=d(e),J=u(e,"UL",{"data-svelte-h":!0}),k(J)!=="svelte-1mpfx9h"&&(J.innerHTML=de),ve=d(e),M(G.$$.fragment,e),Pe=d(e),M(A.$$.fragment,e),E=d(e),M(se.$$.fragment,e),S=d(e),M(ae.$$.fragment,e),Z=d(e),P=u(e,"DIV",{class:!0});var K=me(P);M(re.$$.fragment,K),ce=d(K),fe=u(K,"P",{"data-svelte-h":!0}),k(fe)!=="svelte-182wukm"&&(fe.innerHTML=ze),Y=d(K),M(V.$$.fragment,K),K.forEach(r),D=d(e),M(Q.$$.fragment,e),U=d(e),M(L.$$.fragment,e),Ce=d(e),O=u(e,"P",{}),me(O).forEach(r),this.h()},h(){le(t,"name","hf:doc:metadata"),le(t,"content",ft),le(g,"class","flex flex-wrap space-x-1"),le(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,c){_(document.head,t),i(e,p,c),i(e,n,c),i(e,a,c),T(f,e,c),i(e,o,c),i(e,g,c),i(e,F,c),T(I,e,c),i(e,ee,c),i(e,x,c),i(e,R,c),T(m,e,c),i(e,$,c),i(e,te,c),i(e,Ue,c),i(e,oe,c),i(e,ue,c),i(e,W,c),i(e,z,c),T(q,e,c),i(e,we,c),i(e,J,c),i(e,ve,c),T(G,e,c),i(e,Pe,c),T(A,e,c),i(e,E,c),T(se,e,c),i(e,S,c),T(ae,e,c),i(e,Z,c),i(e,P,c),T(re,P,null),_(P,ce),_(P,fe),_(P,Y),T(V,P,null),i(e,D,c),T(Q,e,c),i(e,U,c),T(L,e,c),i(e,Ce,c),i(e,O,c),Ie=!0},p(e,[c]){const K={};c&2&&(K.$$scope={dirty:c,ctx:e}),A.$set(K);const We={};c&2&&(We.$$scope={dirty:c,ctx:e}),V.$set(We);const ge={};c&2&&(ge.$$scope={dirty:c,ctx:e}),Q.$set(ge)},i(e){Ie||(w(f.$$.fragment,e),w(I.$$.fragment,e),w(m.$$.fragment,e),w(q.$$.fragment,e),w(G.$$.fragment,e),w(A.$$.fragment,e),w(se.$$.fragment,e),w(ae.$$.fragment,e),w(re.$$.fragment,e),w(V.$$.fragment,e),w(Q.$$.fragment,e),w(L.$$.fragment,e),Ie=!0)},o(e){v(f.$$.fragment,e),v(I.$$.fragment,e),v(m.$$.fragment,e),v(q.$$.fragment,e),v(G.$$.fragment,e),v(A.$$.fragment,e),v(se.$$.fragment,e),v(ae.$$.fragment,e),v(re.$$.fragment,e),v(V.$$.fragment,e),v(Q.$$.fragment,e),v(L.$$.fragment,e),Ie=!1},d(e){e&&(r(p),r(n),r(a),r(o),r(g),r(F),r(ee),r(x),r(R),r($),r(te),r(Ue),r(oe),r(ue),r(W),r(z),r(we),r(J),r(ve),r(Pe),r(E),r(S),r(Z),r(P),r(D),r(U),r(Ce),r(O)),r(t),C(f,e),C(I,e),C(m,e),C(q,e),C(G,e),C(A,e),C(se,e),C(ae,e),C(re),C(V),C(Q,e),C(L,e)}}}const ft='{"title":"PhiMoE","local":"phimoe","sections":[{"title":"Overview","local":"overview","sections":[{"title":"Summary","local":"summary","sections":[],"depth":3}],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"How to use PhiMoE","local":"how-to-use-phimoe","sections":[],"depth":2},{"title":"PhimoeConfig","local":"transformers.PhimoeConfig","sections":[],"depth":2},{"title":"PhimoeModel","local":"transformers.PhimoeModel","sections":[],"depth":2},{"title":"PhimoeForCausalLM","local":"transformers.PhimoeForCausalLM","sections":[],"depth":2},{"title":"PhimoeForSequenceClassification","local":"transformers.PhimoeForSequenceClassification","sections":[],"depth":2}],"depth":1}';function gt(j){return Ye(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class jt extends De{constructor(t){super(),Oe(this,t,gt,ut,Ae,{})}}export{jt as component};
